<cfcomponent extends="_transportes.funcoes.cfc_init"  >	
	<cftry>
		<!--- delete na tabela de acesso corrente --->
		<cfquery datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
			delete from kss.pessoa_usuario_acesso_cur c
			 where c.usuario = user
		</cfquery>
		<!--- insert na tabela de acesso corrente --->
		<cfquery datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
			insert into kss.pessoa_usuario_acesso_cur
				 select cod_pessoa, user 
				   from kss.pessoa_unidade_negocio 
				  where cod_unidade_negocio > 0
					and cod_unidade_negocio is not null
		</cfquery>	
		
		<cfcatch type="any"></cfcatch>
		
	</cftry>

	<!--- 
	-- PROPSITO 
	-- Busca os produtos registrados
	-- CRISTOFER  15/05/2006
	--->		
	<cffunction name="get_registro_aplicacao" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" 		required="no" default="" />
		<cfargument name="cod_aplicacao" 	required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct a.nome_aplicacao, 
				   p.nome_projeto, 
				   pa.cod_projeto, 
				   pa.cod_aplicacao, 
				   ra.cod_projeto, 
				   ra.cod_aplicacao,
				   ra.produto,
				   atualizador.pkg_atualizador_util.fnc_formata_versao( ra.v_major, ra.v_minor , ra.v_release , ra.v_build ) versao,
				   internet.pkg_kss_web.fnc_nome_projeto( ra.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao( ra.cod_projeto, ra.cod_aplicacao ) nome_aplicacao,
				   ra.v_major,ra.v_minor,ra.v_release,ra.v_build,ra.site_produto,ra.ativo, ra.mensagem
	  		  from kss.pessoa_aplicacao pa
			 inner join atualizador.v$registro_aplicacao ra
           			 on ra.cod_projeto = pa.cod_projeto         
  					and ra.cod_aplicacao = pa.cod_aplicacao      
			 inner join kss.kss_projeto p
					on p.cod_projeto = pa.cod_projeto
			 inner join kss.kss_aplicacao a
					on a.cod_projeto = pa.cod_projeto         
				   and a.cod_aplicacao = pa.cod_aplicacao         
			 where exists ( select 'x'
							  from kss.kss_usuarios_suporte us
							 where us.cod_projeto = pa.cod_projeto
							   and us.cod_aplicacao = pa.cod_aplicacao
							   and tecnico_suporte = user)			
			 <cfif IsDefined("arguments.cod_projeto") and IsNumeric( arguments.cod_projeto )>
			   and pa.cod_projeto   = #val( arguments.cod_projeto )#
			 </cfif>
			 <cfif IsDefined("arguments.cod_aplicacao") and Len( Trim( arguments.cod_aplicacao ) ) >
			   and pa.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif IsDefined("arguments.cod_pessoa") and Len( Trim( arguments.cod_pessoa ) ) >
			   and pa.cod_pessoa = #val( arguments.cod_pessoa)#
			 </cfif>
			 order by pa.cod_projeto, pa.cod_aplicacao					
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Lista todos os contratos
	-- CRISTOFER  08/05/2006
	--->		
	<cffunction name="get_contratos" access="remote" returntype="query" output="true">
		<cfargument name="num_serie" required="no" default="">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="cliente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cc.num_serie,
				   cc.inicio data_inicio_contrato,
				   cc.fim data_fim_contrato,
				   c.cod_projeto,
				   p.nome_projeto,
				   c.cod_aplicacao,
				   a.nome_aplicacao,
				   pes.cliente
			  from atualizador.copias c
			 inner join atualizador.copias_contrato cc 
					 on cc.num_serie = c.num_serie
			 inner join kss.kss_aplicacao a
					 on a.cod_aplicacao = c.cod_aplicacao
			 inner join kss.kss_projeto p 
					 on p.cod_projeto = c.cod_projeto
			 inner join kss.v$pessoa pes
					 on pes.cod_pessoa = c.cod_pessoa
			 where 1 = 1
			<cfif len(trim(arguments.cod_projeto))>
			   and c.cod_projeto in (#arguments.cod_projeto#)
			</cfif>
			<cfif len(trim(arguments.cod_aplicacao))>
			   and c.cod_aplicacao in (#ListQualify(arguments.cod_projeto, "'", ',')#)
			</cfif>
		    <cfif Len(Trim(arguments.num_serie))>
		       and cc.num_serie = replace( translate( '#arguments['num_serie']#', '-', ' '),' ', '')
		    </cfif>				
			<cfif len(trim(arguments.cliente))>
			   and upper(pes.cliente) like upper('%#arguments.cliente#%')
			</cfif>		  		
			 order by cc.inicio, cc.fim, pes.cliente, p.nome_projeto, a.nome_aplicacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Seleciona Dados Completos das Empresas com cpias registradas, inclusive filtrando pelo perodo de vigncia contratual
	-- CRISTOFER  08/05/2006
	--->		
	<cffunction name="get_copias" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" 		required="no" default="" />
		<cfargument name="cnpj_basico" 		required="no" default="" />
		<cfargument name="nome_fantasia" 	required="no" default="" />
		<cfargument name="cod_projeto" 		required="no" default="" />
		<cfargument name="cod_aplicacao" 	required="no" default="" />
		<cfargument name="num_serie" 		required="no" default="" />		
		<cfargument name="verifica_contratos" displayname="Flag para validar se a busca est sendo requisitada do LOCALIZAR do cadastro de CONTRATOS" required="no"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_serie, 
				   c.data_instalacao, 
				   c.limite_maquina lmaquina, 
				   c.atualizacao, 
				   c.direito_uso, 
				   upper(c.usuario) usuario, 
				   c.usuario_administrador, 
				   c.senha_administrador, 
				   decode( length( c.limite_maquina ), 5 , trim(to_char( atualizador.pkg_atualizador.fnc_total_maquina_copia( c.num_serie), '000') )|| '/' || c.limite_maquina, trim(to_char( atualizador.pkg_atualizador.fnc_total_maquina_copia( c.num_serie), '000') ) || '/' || trim(to_char(c.limite_maquina, '000') ) )limite_maquina, 
			   	   c.senha, 
				   c.cod_pessoa,  
				   c.cod_projeto, 
				   c.cod_aplicacao, 
			   	   internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto ) nome_projeto,
			   	   internet.pkg_kss_web.fnc_nome_aplicacao( c.cod_projeto, c.cod_aplicacao ) nome_aplicacao,
			   	   pe.cnpj_basico, 
				   pe.cnpj_ordem, 
				   pe.identificador cnpj, 
				   pe.endereco, 
				   pe.telefone, 
				   pe.municipio, 
				   pe.uf, 
				   pe.cep,
				   pe.telefone fax, 
				   pe.email, 
				   pe.nome_fantasia
	               <cfif isDefined("arguments.verifica_contratos") and IsNumeric( arguments.verifica_contratos )>
					,cc.inicio data_inicio_contrato
					,cc.fim data_fim_contrato
				   </cfif>  
		  	  from internet.v$pessoa pe
	  	     inner join atualizador.copias c
			 	 	 on c.cod_pessoa = pe.cod_pessoa 
	               <cfif isDefined("arguments.verifica_contratos") and IsNumeric( arguments.verifica_contratos )>
			 inner join atualizador.copias_contrato cc
                     on cc.num_serie = c.num_serie
					</cfif>  
/*		     inner join kss.pessoa_aplicacao pa  
					 on pa.cod_pessoa = pe.cod_pessoa 	
					and pa.cod_projeto = c.cod_projeto
 					and pa.cod_aplicacao = c.cod_aplicacao */		   
             where 1=1
		<cfif Len( Trim( arguments.cod_pessoa ) )>
		       and c.cod_pessoa = #val( arguments.cod_pessoa )#
		</cfif>		
		<cfif Len( Trim( arguments.nome_fantasia ) ) >
		       and instr( upper( pe.nome_fantasia ) , upper('#arguments.nome_fantasia#') ) <> 0
		</cfif>			
		<cfif IsNumeric( arguments.cod_projeto )>
		       and c.cod_projeto   = #val( arguments.cod_projeto )#
		</cfif>
		<cfif Len( Trim( arguments.cod_aplicacao ) )>
		  and c.cod_aplicacao = '#arguments.cod_aplicacao#'
		</cfif>
		<cfif Len( Trim( arguments.num_serie ) )>
		  and c.num_serie = replace( translate( '#arguments.num_serie#', '-', ' '),' ', '')
		</cfif>			
		<cfif len(trim(arguments.cnpj_basico))>
		  and pe.cnpj_basico = '#arguments.cnpj_basico#'
		</cfif>
		  order by  pe.nome_fantasia, c.cod_projeto, c.cod_aplicacao, pe.nome_fantasia, c.data_instalacao desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Cria Nmero de srie
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="get_serial" displayname="Cria Nmero de Serial" access="remote" returntype="string" output="true">
		   <cfinvoke component="_transportes.funcoes.cfc_serial"
					 method="criaSerial"
					 returnvariable="arguments.num_serie">
		   <cfquery name="qrCopias" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				 select c.num_serie
				   from atualizador.copias c
				  where c.num_serie  = replace( translate( '#arguments.num_serie#', '-', ' '),' ', '')
			</cfquery>
			<cfif qrCopias.recordcount>
				<cfreturn this.get_serial() />
			<cfelse>
				<cfreturn arguments.num_serie />
			</cfif>
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Seleciona Situao da Mqina
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="get_situacao_maquina" access="remote" returntype="Query" output="true">
		<cfargument name="situacao" required="false" default="" />
		<cfquery name="qrMaquinasSituacao" datasource="#session.dsn#" username="#Session.usuario#" password="#Session.senha#">
			select s.situacao, 
				   s.situacao_maquina_copias descricao_situacao
			  from atualizador.maquina_copias_situacao s
			<cfif len(trim(arguments.situacao))>
			 where s.situacao = '#arguments.situacao#'
			</cfif>
		</cfquery>
		<cfreturn qrMaquinasSituacao />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Seleciona as Mquinas que que esto com a cpia registrada
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="get_maquinas" access="remote" returntype="Query" output="true">
		<cfargument name="cod_pessoa" required="false" displayname="Cdigo da Pessoa" type="string" />
		<cfargument name="cnpj_basico" required="false" displayname="CNPJ Bsico" type="string" />
		<cfargument name="cod_projeto" required="false" displayname="Cdigo do Projeto" type="string" />
		<cfargument name="cod_aplicacao" required="false" displayname="Cdigo da Aplicao" type="string" />
		<cfargument name="num_serie" required="false" displayname="Nmero de Srie" type="string" />				
		<cfargument name="maquina" required="false" displayname="Nome da Mquina" type="string" />				
		<cfargument name="data_inicio" required="false" displayname="Data de inicio" type="string" />				
		<cfargument name="data_fim" required="false" displayname="Data de fim" type="string" />				
		<cfquery name="qrCopias" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pe.cnpj_basico, pe.cnpj_ordem, pe.nome_fantasia, pe.email,
				   internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao( c.cod_projeto, c.cod_aplicacao ) nome_aplicacao,
				   c.cod_projeto, c.cod_aplicacao, c.num_serie, mc.maquina,
				   mc.descricao descricao_maquina, mc.date_insert, ms.situacao, ms.situacao_maquina_copias descricao_situacao
			  from internet.v$pessoa pe
				   inner join atualizador.copias c
					  on c.cod_pessoa = pe.cod_pessoa
				   inner join atualizador.maquina_copias mc
					 on mc.num_serie  = c.num_serie
				   inner join atualizador.maquina_copias_situacao ms
					 on ms.situacao   = mc.situacao
					where exists ( select 'x'
							 from kss.kss_usuarios_suporte us
							where us.cod_projeto = c.cod_projeto
							  and us.cod_aplicacao = c.cod_aplicacao
							  and tecnico_suporte = user)		
	
				<cfif isDefined("arguments.num_serie") and Len( Trim( arguments.num_serie ) )>
				  and mc.num_serie = replace( translate( '#arguments.num_serie#', '-', ' '),' ', '')
				</cfif>									
				<cfif isDefined("arguments.maquina") and Len( Trim( arguments.maquina ) )>
				  and  upper(mc.maquina) = upper('#arguments.maquina#')
				</cfif>
				 <cfif isDefined("arguments.cnpj_basico") and Len(Trim( arguments.cnpj_basico ))>
				   and pe.cnpj_basico   = '#arguments.cnpj_basico#'
				</cfif>			 
				<cfif isDefined("arguments.cod_projeto")   and IsNumeric( arguments.cod_projeto )
				  and isDefined("arguments.cod_aplicacao") and Len( Trim( arguments.cod_aplicacao ) )>
				  and c.cod_projeto = #val( arguments.cod_projeto )#
				  and c.cod_aplicacao = '#arguments.cod_aplicacao#'
				</cfif>
				<cfif isDefined("arguments.data_inicio") and IsDate("arguments.data_inicio" )
					and isDefined("arguments.data_fim") and IsDate("arguments.data_fim" )>
					and to_date(to_char(mc.date_insert,'dd/mm/yyyy hh24:mi:ss'),'dd/mm/yyyy hh24:mi:ss') between to_date('#arguments.data_inicio# 00:00:01','dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59','dd/mm/yyyy hh24:mi:ss')
				 </cfif> 
				order by pe.nome_fantasia, pe.cnpj_basico, c.cod_projeto, c.cod_aplicacao, mc.maquina
		</cfquery>
		<cfreturn qrCopias />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca todos os clientes
	-- CRISTOFER  15/05/2006
	--->		
	<cffunction name="get_clientes" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct pe.cod_pessoa, pe.cnpj_basico, trim( decode( instr(pe.nome_fantasia, '-' ), 0, pe.nome_fantasia, substr( pe.nome_fantasia, 0, instr(pe.nome_fantasia, '-' ) - 1 ))) nome_fantasia 
			  from internet.v$pessoa pe
             	   inner join internet.pessoa_aplicacao_suporte pas 
                	  on pas.cod_pessoa = pe.cod_pessoa
			 where pas.situacao = 1
         	   and ( pe.cnpj_ordem  = '0001' 
              		  or instr( upper( pe.nome_fantasia ) , upper('Matriz') ) <> 0  
          			  or instr( upper( pe.nome_fantasia ) , upper('Sede' ) )  <> 0 )
		       and exists(  select 'x'
						     from kss.kss_usuarios_suporte pua
                inner join kss.pessoa_aplicacao pa
                        on pa.cod_aplicacao = pua.cod_aplicacao
                       and pa.cod_projeto = pua.cod_projeto
						  	where pua.tecnico_suporte       = user  )	      
			order by 2
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona relao de atualizaes da mquinas
	-- JEFFERSON          13/11/2003 - criado
	--->			
	<cffunction name="get_atualizacoes_maquinas" displayname="Listagem detalhada das atualizaes por mquina" access="remote" returntype="Query" output="false">
		<cfargument name="cod_pessoa"    			required="false"    displayname="Cdigo da Pessoa" 			type="string" />
		<cfargument name="cod_projeto" 				required="false" 	displayname="Cdigo do Projeto" 		type="string" />
		<cfargument name="cod_aplicacao" 			required="false"	displayname="Cdigo da Aplicao" 		type="string" />
		<cfargument name="cnpj_basico"    			required="false"    displayname="CNPJ Bsico" 				type="string" />	
		<cfargument name="num_serie"    			required="false"    displayname="Nmero de Srie" 			type="string" />				
		<cfargument name="maquina" 					required="false" 	displayname="Maquina da Unidade"  		type="string"/>
		<cfargument name="versao" 					required="false" 	displayname="Verso do Software" 	 	type="string"/>
			<cfquery name="qrAtualizacoesMaquinas" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="50">
				select /*+ first_rows */ distinct --c.num_serie,
					   c.cod_projeto,
					   c.cod_aplicacao,
					   internet.pkg_kss_web.fnc_nome_projeto(c.cod_projeto) nome_projeto,
					   internet.pkg_kss_web.fnc_nome_aplicacao(c.cod_projeto,c.cod_aplicacao) nome_aplicacao,
					   trim( decode( instr(pe.nome_fantasia, '-' ), 0, pe.nome_fantasia, substr( pe.nome_fantasia, 0, instr(pe.nome_fantasia, '-' ) - 1 ))) unidade,
					   at.maquina,
					   replace( translate( upper( at.maquina ) , '- _', ' '),' ', '') maquina_id,
					   at.data_hora data,
					   atualizador.pkg_atualizador_util.fnc_formata_versao(at.v_major,at.v_minor,at.v_release,at.v_build) versao,
					   4*at.v_major+3*at.v_minor+2*at.v_release+1*at.v_build versao_ordem,
					   atualizador.pkg_atualizador.fnc_max_versao_atualizacao( c.cod_projeto, c.cod_aplicacao ) maximo
				  from atualizador.copias c
				 inner join internet.v$pessoa pe 
						 on pe.cod_pessoa = c.cod_pessoa
			     inner join atualizador.atualizacoes at 
						 on at.num_serie = c.num_serie
				 inner join atualizador.maquina_copias mc 
					     on mc.num_serie = at.num_serie
					    and upper(mc.maquina) = upper(at.maquina)
				 inner join (select c.num_serie, c.cod_pessoa,t.maquina,max(t.data_hora) data
							   from atualizador.atualizacoes t
							  inner join atualizador.copias c 
									  on c.num_serie = t.num_serie
							  group by c.num_serie, c.cod_pessoa, t.maquina) dd 
					     on dd.num_serie =  at.num_serie
					    and dd.cod_pessoa =  c.cod_pessoa
					    and dd.maquina = at.maquina
					    and dd.data = at.data_hora
				 where mc.situacao = 1			   
				   and exists( select 'x'
								 from kss.kss_usuarios_suporte pua
								where pua.tecnico_suporte       = user 
								  and pua.cod_aplicacao = c.cod_aplicacao
								  and pua.cod_projeto = c.cod_projeto)		
				<cfif StructKeyExists(arguments, 'cnpj_basico') and Len(Trim( arguments['cnpj_basico'] ))>
				   and pe.cnpj_basico   = '#arguments['cnpj_basico']#'
				</cfif>			 
				<cfif StructKeyExists(arguments, 'cnpj') and Len( Trim( arguments['cnpj'] ) )>
				  and replace( translate( pe.identificador , '-/.', ' '),' ', '')  = replace( translate( '#arguments['cnpj'] #' , '-/.', ' '),' ', '')
				</cfif>
				<cfif StructKeyExists( arguments, 'cod_projeto') and Len( Trim( arguments['cod_projeto'] ) )>
				  and c.cod_projeto = #val( arguments['cod_projeto'] )#
				</cfif>
				<cfif StructKeyExists( arguments, 'cod_aplicacao') and Len( Trim( arguments['cod_aplicacao'] ) )>
				  and c.cod_aplicacao = '#arguments['cod_aplicacao']#'
				</cfif>
				<cfif StructKeyExists(arguments, 'num_serie') and Len( Trim( arguments['num_serie'] ) )>
				  and c.num_serie = replace( translate( '#arguments['num_serie']#', '-', ' '),' ', '')
				</cfif>	
				<cfif StructKeyExists(arguments, 'maquina') and Len( Trim( arguments['maquina'] ) )>
				  and upper(at.maquina) = upper('#arguments['maquina']#')
				</cfif>																			
				<cfif StructKeyExists(arguments, 'versao') and Len( Trim( arguments['versao'] ) )>
				  and 4*at.v_major+3*at.v_minor+2*at.v_release+1*at.v_build = (4*#val( ListFirst( arguments['versao'],'.'))#+3*#val( ListGetAt( arguments['versao'], 2 ,'.'))#+2*#val( ListGetAt( arguments['versao'], 3,'.'))#+1*#val( ListLast( arguments['versao'],'.'))#)
				</cfif>			
				  order by trim( decode( instr(pe.nome_fantasia, '-' ), 0, pe.nome_fantasia, substr( pe.nome_fantasia, 0, instr(pe.nome_fantasia, '-' ) - 1 ))), upper( at.maquina ), c.cod_projeto, c.cod_aplicacao, at.data_hora desc, 4*at.v_major+3*at.v_minor+2*at.v_release+1*at.v_build desc
				  
			</cfquery>
		<cfreturn qrAtualizacoesMaquinas />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca os arquivos da atualizacao
	-- JEFFERSON          13/11/2003 - criado
	--->		
	<cffunction name="get_arquivos_atualizacao" displayname="Lista os arquivos atualizados" access="remote" returntype="Query" output="true">
		<cfargument name="maquina" required="yes">
		<cfargument name="data_hora" required="yes">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="50">
			 select ar.num_serie,
					nvl( ar.nome_arquivo, 'Nenhum arquivo atualizado') nome_arquivo,
					ar.pasta_instalacao, 
					decode( nvl( ar.tamanho,0 ), 0, '', atualizador.pkg_atualizador_util.fnc_tamanho_arquivo( ar.tamanho) ) tamanho, 
					ar.data_arquivo,
					ar.data_hora data,
					ar.maquina
			   from atualizador.atualizacoes_arquivos ar
			  where ar.maquina   = '#arguments.maquina#'
				and to_char(ar.data_hora, 'dd/mm/yyyy hh') = '#DateFormat(arguments.data_hora, 'DD/MM/YYYY')# #TimeFormat(arguments.data_hora, 'HH')#'
		</cfquery>
		<cfreturn qr />
	</cffunction>	 	
	
	<!--- 
	-- PROPSITO
	-- Recupera histrico indivudual da atualizao dos arquivos
	-- JEFFERSON  13/11/2003 - criado
	--->			
	<cffunction name="get_historico_atualizacao_arquivo" displayname="Recupera histrico de atualizao do arquivo" access="remote" returntype="Query" output="true">
		<cfargument name="num_serie" required="yes" displayname="Nmero de Srie" />
		<cfargument name="maquina" required="yes" displayname="Nome da Mquina " />
		<cfargument name="data_hora" required="yes"	displayname="Data Atualizao" />
		<cfargument name="nome_arquivo" required="yes" displayname="Nome do Arquivo" />				
		<cfargument name="pasta_instalacao" required="yes" displayname="PAsta de Instalao" />
			<cfquery name="qrHistoricoAtualizacaoArquivo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select at.historico, at.nome_arquivo
				 from atualizador.atualizacoes_arquivos at
				where at.num_serie = replace( translate( '#arguments.num_serie#', '-', ' '),' ', '')
				  and upper( at.maquina ) = upper( '#arguments.maquina#' )
				  and to_date(to_char(at.data_hora,'dd/mm/yyyy hh24:mi:ss'),'dd/mm/yyyy hh24:mi:ss') = to_date('#arguments.data_hora#','dd/mm/yyyy hh24:mi:ss')
				  and upper( at.nome_arquivo )	   = upper( '#arguments.nome_arquivo#' )
				  and upper( at.pasta_instalacao ) = upper( '#arguments.pasta_instalacao#' )
			</cfquery>
		<cfreturn qrHistoricoAtualizacaoArquivo />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Seleciona todas as verses do produto e maquinas instaladas
	-- JEFFERSON  13/11/2003 - criado
	--->			
	<cffunction name="get_versao" access="remote" returntype="Query" output="true">	  
		<cfargument name="cod_projeto" 		required="no"/>
		<cfargument name="cod_aplicacao" 	required="no"/>
		<cfargument name="versao" 			required="no"/> 
		<cfargument name="data_inicio" 		required="no" default=""/> 
		<cfargument name="data_fim" 		required="no" default=""/> 
		<cfquery name="qrVersao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select  av.cod_projeto, av.cod_aplicacao, 
						internet.pkg_kss_web.fnc_nome_projeto( av.cod_projeto) nome_projeto,
						internet.pkg_kss_web.fnc_nome_aplicacao( av.cod_projeto, av.cod_aplicacao ) nome_aplicacao,
						av.descricao nota_atualizacao, av.date_insert data_disponibilizacao, atualizador.pkg_atualizador_util.fnc_formata_versao( av.v_major, av.v_minor, av.v_release, av.v_build ) versao_atualizacao,
						4*av.v_major+3*av.v_minor+2*av.v_release+1*av.v_build versao_ordem
				  from  atualizador.atualizacao_versao av
				 where exists ( select 'x'
							 from kss.kss_usuarios_suporte us
							where us.cod_projeto = av.cod_projeto
							  and us.cod_aplicacao = av.cod_aplicacao
							  and tecnico_suporte = user)		
				
				<cfif IsDefined("arguments.cod_projeto")  and IsNumeric( arguments.cod_projeto )>
					and av.cod_projeto   = #val( arguments.cod_projeto )#
				</cfif>	
				<cfif IsDefined("arguments.cod_aplicacao") and Len( Trim( arguments.cod_aplicacao ) )>
	
					and av.cod_aplicacao = '#arguments.cod_aplicacao#'
				</cfif>	
				<cfif IsDefined( "arguments.versao") and ListLen(arguments.versao,'.') eq 4 >
				   and 4*av.v_major+3*av.v_minor+2*av.v_release+1*av.v_build >= (4*#val( ListFirst( arguments['versao'],'.'))#+3*#val( ListGetAt( arguments['versao'], 2 ,'.'))#+2*#val( ListGetAt( arguments['versao'], 3,'.'))#+1*#val( ListLast( arguments['versao'],'.'))#)
				</cfif>
				<cfif len(trim(arguments.data_inicio))>
					and av.date_insert >= '#arguments.data_inicio#'
				</cfif>
				<cfif len(trim(arguments.data_fim))>
					and trunc(av.date_insert) <= '#arguments.data_fim#'
				</cfif>
				order  by av.cod_projeto, av.cod_aplicacao, 4*av.v_major+3*av.v_minor+2*av.v_release+1*av.v_build desc
			</cfquery>
		<cfreturn qrVersao />		
	</cffunction>			

	<!--- 
	-- PROPSITO
	-- Seleciona relao de mquinas ativas
	-- JEFFERSON          07/10/2004 - criado
	--->			
	<cffunction name="get_maquinas_ativa" displayname="Listagem das mquinas ativas" access="remote" returntype="Query" output="false">
		<cfargument name="cod_pessoa"   	required="false" />
		<cfargument name="cod_projeto" 		required="false" />
		<cfargument name="cod_aplicacao"	required="false" />
		<cfargument name="num_serie"    	required="false" />
		<cfargument name="data_inicio"    	required="false" />
		<cfargument name="data_fim"    		required="false" />
		<cfquery name="qrAtualizacoes" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_serie,c.cod_pessoa,c.cod_projeto,c.cod_aplicacao,
				   internet.pkg_kss_web.fnc_nome_projeto(c.cod_projeto) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao(c.cod_projeto,c.cod_aplicacao) nome_aplicacao,
				   pe.cnpj_basico,pe.cnpj_ordem,pe.identificador,pe.email,pe.nome_fantasia unidade,mc.maquina,
				   replace( translate( upper( mc.maquina ) , '- _', ' '),' ', '') maquina_id
			 from internet.v$pessoa pe 
				  inner join atualizador.copias c
					 on c.cod_pessoa = pe.cod_pessoa
				  inner join atualizador.maquina_copias mc 
					 on mc.num_serie = c.num_serie
			where mc.situacao    = 1
/*			  and exists( select 'x'
							from internet.pessoa_usr_aplic_suporte pua
						   where pua.cod_projeto   = c.cod_projeto
							 and pua.cod_aplicacao = c.cod_aplicacao   
							 and pua.cod_pessoa    = c.cod_pessoa 
							 and pua.usuario       = user)*/
			 <cfif StructKeyExists(arguments, 'cnpj_basico') and Len(Trim( arguments['cnpj_basico'] ))>
			   and pe.cnpj_basico   = '#arguments['cnpj_basico']#'
			</cfif>			 
			<cfif StructKeyExists( arguments, 'cnpj' ) and Len( Trim( arguments['cnpj'] ) )>
				and replace( translate( pe.identificador , '-/.', ' '),' ', '')  = replace( translate('#arguments['cnpj']#', '-/.', ' '),' ', '')
			</cfif>			
			<cfif StructKeyExists(arguments, 'cod_projeto')   and IsNumeric( arguments['cod_projeto'] )
				and StructKeyExists(arguments, 'cod_aplicacao') and Len( Trim( arguments['cod_aplicacao'] ) )>
				and c.cod_projeto = #val( arguments['cod_projeto'] )#
				and c.cod_aplicacao = '#arguments['cod_aplicacao']#'
			</cfif>
			<cfif StructKeyExists(arguments, 'data_inicio') and IsDate(arguments['data_inicio'] )
				and StructKeyExists(arguments, 'data_fim') 	 and IsDate(arguments['data_fim'] )>
				and to_date(to_char(mc.date_insert,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments['data_inicio']#','dd/mm/yyyy') and to_date('#arguments['data_fim']#','dd/mm/yyyy')
			 </cfif> 
			  order by pe.cnpj_basico, c.cod_projeto, c.cod_aplicacao, pe.nome_fantasia, mc.maquina
		</cfquery>
		<cfreturn qrAtualizacoes />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona mquinas que j atualizaram software para filtro no relatrio de atualizaes
	-- JEFFERSON  27/09/2004 - criado
	--->			
	<cffunction name="get_maquinas_atualizadas" displayname="Lista mquinas que j atualizaram software" access="remote" returntype="Query" output="true">
		<cfargument name="cod_projeto" displayname="Cdigo do Projeto" required="no" />				
		<cfargument name="cod_aplicacao" displayname="Cdigo da Aplicao" required="no"/>				
		<cfargument name="cnpj" displayname="CNPJ (identificador) da filial" required="no"/>				
			
			<cfquery name="qrMaquinasAtualizadas" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select distinct kss.pessoa_pkg.getIdentificador( c.cod_pessoa ) cnpj, mc.maquina
				  from atualizador.copias c
				 inner join atualizador.maquina_copias mc
					on mc.num_serie = c.num_serie
				 inner join internet.v$pessoa pe
					on pe.cod_pessoa = c.cod_pessoa
				 inner join kss.pessoa_aplicacao pa  
					on pa.cod_pessoa = c.cod_pessoa 	
					and pa.cod_projeto = c.cod_projeto
					and pa.cod_aplicacao = c.cod_aplicacao 		   
				  where exists( select 'x' 
						from atualizador.atualizacoes at 
					   where at.num_serie = mc.num_serie
						 and at.maquina   = mc.maquina )
					and exists ( select 'x'
						 from kss.kss_usuarios_suporte us
						where us.cod_projeto = pa.cod_projeto
						  and us.cod_aplicacao = pa.cod_aplicacao
						  and tecnico_suporte = user)		
				  
				 <cfif isDefined("arguments.cnpj") and Len( Trim( arguments.cnpj ) )>
				   and pe.identificador = '#arguments.cnpj#'
				 </cfif>
				 
				 order by mc.maquina
			</cfquery>
		<cfreturn qrMaquinasAtualizadas />
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Seleciona projetos que esto instalados na mquina do cliente 
	-- JEFFERSON 28/09/2004 - criado
	--->			
	<cffunction name="get_projetos_maquina"  displayname="Consulta projetos vinculados a uma mquina" access="Remote" returntype="Query" output="true">
		<cfargument name="maquina" displayname="Nome da mquina" required="no"/>
			<cfquery  name="qrProjetos" datasource="#session.dsn#"  username="#session.usuario#" password="#session.senha#">
				select distinct c.cod_projeto, internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto) nome_projeto, mc.maquina
				  from atualizador.copias c
				 inner join atualizador.maquina_copias mc
					on mc.num_serie = c.num_serie
					
				 inner join kss.pessoa_aplicacao pa <!---  conferir esse filtro--->
					on pa.cod_projeto = c.cod_projeto
				   and pa.cod_aplicacao = c.cod_aplicacao
				   and pa.cod_pessoa = c.cod_pessoa
	
				  where exists ( select 'x'
						 from kss.kss_usuarios_suporte us
						where us.cod_projeto = c.cod_projeto
						  and us.cod_aplicacao = c.cod_aplicacao
						  and tecnico_suporte = user)		
				 <cfif isDefined("arguments.maquina") and Len( Trim( arguments.maquina ) )>
				   and mc.maquina = '#arguments.maquina#'
				 </cfif>
				 order by internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto )		
			</cfquery>
		<cfreturn qrProjetos />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona conexes que foram liberadas para atualizaes
	-- JEFFERSON  13/11/2003 - criado
	--->			
	<cffunction name="get_conexoes_atualizacoes" displayname="Listagem das conexes que foram liberadas para atualizaes" access="remote" returntype="Query" output="true">
		<cfargument name="cnpj" required="no" displayname="CNPJ da Empresa"/>
		<cfargument name="cnpj_basico" required="no" displayname="CNPJ Bsico da Empresa"/>
		<cfargument name="maquina" required="no" displayname="Nome da Mquina"/>
		<cfargument name="cod_projeto" required="no" displayname="Cdigo do Projeto"/>
		<cfargument name="cod_aplicacao" required="no"	displayname="Cdigo da Aplicao"/>
		<cfargument name="num_serie" required="no" displayname="Nmero de Srie" />				
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
	
			<cfquery name="qrConexoesAtualizacoes" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select cc.endereco_ip, cc.maquina, cc.date_insert, cc.date_update, ccs.num_serie, atualizador.pkg_controle_conexao.fnc_calcula_tempo_conectado( cc.date_insert, nvl( cc.date_update, sysdate ), 's') tempo_conectado,
					   c.cod_pessoa, c.cod_projeto, c.cod_aplicacao,
					   internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto ) nome_projeto,
					   internet.pkg_kss_web.fnc_nome_aplicacao( c.cod_projeto, c.cod_aplicacao ) nome_aplicacao,
					   pe.nome_fantasia, pe.identificador cnpj, pe.cnpj_basico,
					   cc.servico_tipo_id,
					   st.descricao as tipo_servico
				  from atualizador.controle_conexao cc
					   inner join atualizador.controle_conexao_serial ccs
						  on ccs.controle_conexao_id = cc.controle_conexao_id
					   inner join atualizador.copias c
						  on c.num_serie = ccs.num_serie    
					   inner join internet.v$pessoa pe
						  on pe.cod_pessoa = c.cod_pessoa
					   inner join atualizador.v$servico_tipo st
						  on st.servico_tipo_id = cc.servico_tipo_id   
				 where cc.endereco_ip != '200.195.142.82'
				   and exists( select 'x' 
								 from atualizador.atualizacoes at
								where at.num_serie = ccs.num_serie
								  and at.maquina   = cc.maquina ) 
				   and exists( select 'x'
						 from kss.kss_usuarios_suporte us
						where us.cod_projeto = c.cod_projeto
						  and us.cod_aplicacao = c.cod_aplicacao
						  and tecnico_suporte = user)		
																			
				 <cfif StructKeyExists( arguments, 'cnpj' ) and Len( Trim( arguments['cnpj'] ) )>
					and replace(translate( pe.identificador , '-/.', ' '), ' ', '')  = replace( translate('#arguments['cnpj']#', '-/.', ' '),' ', '')
				 </cfif>	
				 <cfif StructKeyExists( arguments, 'cnpj_basico' ) and Len( Trim( arguments['cnpj_basico'] ) )>
					and pe.cnpj_basico= '#arguments['cnpj_basico']#'
				 </cfif>	
				 <cfif StructKeyExists( arguments, 'maquina' ) and Len( Trim( arguments['maquina'] ) )>
					and upper( cc.maquina ) = upper('#arguments['maquina']#')
				 </cfif>	
				 
				<cfif StructKeyExists( arguments, 'cod_projeto') and Len( Trim( arguments['cod_projeto'] ) )
				  and StructKeyExists( arguments, 'cod_aplicacao') and Len( Trim( arguments['cod_aplicacao'] ) )>
				  and c.cod_projeto = #val( arguments['cod_projeto'] )#
				  and c.cod_aplicacao = '#arguments['cod_aplicacao']#'
				</cfif>
				<cfif len(trim(arguments.data_inicio))>
					and cc.date_insert >= '#arguments.data_inicio#'
				</cfif>
				<cfif len(trim(arguments.data_fim))>
					and trunc(cc.date_insert) <= '#arguments.data_fim#'
				</cfif>
				  order by pe.cnpj_basico, pe.nome_fantasia, cc.maquina, c.cod_projeto, c.cod_aplicacao, cc.date_update desc
			</cfquery>
			
		<cfreturn qrConexoesAtualizacoes />
	
	</cffunction>	 

<cfscript>
/**
 * @descritivo	: Retorna o Tempo conectado
 * @parametro	: tamanho   : numero. ( Requerido )
 * @retorno		: string
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 18  de Fevereiro 2004
 */					

function tempoConectado( mins )
{
	var resultado 	 = '';
	var segundos	 = ( mins * 60 );
	var horas 		 =  segundos   / 3600;
	var minutos 	 =  segundos   / 60;
	var strSegundo 	 =  segundos mod 60;
	var strHora 	 = '';
	var strMinuto 	 = '';

	// se o total de minutos for maior que 60 
	if ( minutos gte 60 ) minutos = minutos mod 60;
	
	// customiza apresentao das horas
	if ( horas gte 1 )
	{ 
		strHora   = iif( horas gte 2, de(' horas '), de(' hora '));
	    resultado = Fix( horas ) & strHora;
	}

	// customiza a apresentao dos minutos 
	if ( minutos gte 1 )
	{
		strMinuto   = iif( minutos gte 2 , de(' minutos '), de(' minuto '));
	    resultado   = resultado & Fix( minutos ) & strMinuto;
	}	
	
	// customiza a apresentao dos minutos 
   	if ( strSegundo gt 0 ) 
	{
		resultado   = resultado & Fix( strSegundo ) & ' segundos';
	}

  return ( resultado );
}	
</cfscript>
	
	
	<!--- 
	-- PROPSITO
	-- Seleciona relao de mquinas atualizadas
	-- JEFFERSON  13/11/2003 - criado
	--->			
	<cffunction name="get_atualizacoes" displayname="Listagem das ltimas atualizaes efetivadas" access="remote" returntype="Query" output="true">
		<cfargument name="cod_pessoa" required="no" displayname="Cdigo da Pessoa" 	/>
		<cfargument name="cod_projeto" required="no" displayname="Cdigo do Projeto" />
		<cfargument name="cod_aplicacao" required="no"	displayname="Cdigo da Aplicao" />
		<cfargument name="num_serie" required="no" displayname="Nmero de Srie" />				
		<cfargument name="data_inicio" required="no" displayname="Data de Incio" default=""/>				
		<cfargument name="data_fim" required="no" displayname="Data de Trmino" default="" />				
		<cfquery name="qrAtualizacoes" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_serie,c.cod_pessoa,c.cod_projeto,c.cod_aplicacao,internet.pkg_kss_web.fnc_nome_projeto(c.cod_projeto) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao(c.cod_projeto,c.cod_aplicacao) nome_aplicacao,
				   pe.cnpj_basico,pe.cnpj_ordem,pe.identificador,pe.email,pe.nome_fantasia, pe.nome_fantasia unidade,at.maquina,pe.razao_social,
				   replace( translate( upper( at.maquina ) , '- _', ' '),' ', '') maquina_id,at.data_hora data,
				   atualizador.pkg_atualizador_util.fnc_formata_versao(at.v_major,at.v_minor,at.v_release,at.v_build) versao,
					4*at.v_major+3*at.v_minor+2*at.v_release+1*at.v_build versao_ordem, at.ip
			  from atualizador.copias c
				   inner join internet.v$pessoa pe 
					  on pe.cod_pessoa = c.cod_pessoa
				   inner join atualizador.atualizacoes at 
					  on at.num_serie = c.num_serie
				   inner join atualizador.maquina_copias mc 
					  on mc.num_serie = at.num_serie
					 and upper(mc.maquina) = upper(at.maquina)
					inner join (select c.num_serie, c.cod_pessoa,t.maquina,max(t.data_hora) data
								  from atualizador.atualizacoes t
									   inner join atualizador.copias c 
										  on c.num_serie = t.num_serie
								 group by c.num_serie, c.cod_pessoa, t.maquina) dd 
					  on dd.num_serie =  at.num_serie
					 and dd.cod_pessoa =  c.cod_pessoa
					 and dd.maquina = at.maquina
					 and dd.data = at.data_hora
			  where mc.situacao    = 1
			  <cfif StructKeyExists( arguments, 'cod_pessoa') and Len( Trim( arguments['cod_pessoa'] ) )>
				and c.cod_pessoa = #val( arguments['cod_pessoa'] )#
			  </cfif>		
				<cfif StructKeyExists(arguments, 'cod_projeto')   and IsNumeric( arguments['cod_projeto'] )>
				and c.cod_projeto = #val( arguments['cod_projeto'] )#
			  </cfif>
			  <cfif StructKeyExists(arguments, 'cod_projeto')   and IsNumeric( arguments['cod_projeto'] )
				and StructKeyExists(arguments, 'cod_aplicacao') and Len( Trim( arguments['cod_aplicacao'] ) )>
				and c.cod_projeto = #val( arguments['cod_projeto'] )#
				and c.cod_aplicacao = '#arguments['cod_aplicacao']#'
			  </cfif>
			  <cfif len(trim(arguments.data_inicio))>
				and at.data_hora >= '#arguments.data_inicio#'
			  </cfif>
			  <cfif len(trim(arguments.data_fim))>
				and at.data_hora <= '#arguments.data_fim#'
			  </cfif>
			  <cfif StructKeyExists(arguments, 'num_serie') and Len( Trim( arguments['num_serie'] ) )>
				and c.num_serie = replace( translate( '#arguments['num_serie']#', '-', ' '),' ', '')
			  </cfif>			
				  and exists( select 'x'
					 from kss.kss_usuarios_suporte us
					where us.cod_projeto = c.cod_projeto
					  and us.cod_aplicacao = c.cod_aplicacao
					  and tecnico_suporte = user)		
			  order by internet.pkg_kss_web.fnc_nome_aplicacao(c.cod_projeto,c.cod_aplicacao), pe.nome_fantasia, versao, at.maquina
		 </cfquery>
		<cfreturn qrAtualizacoes />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona servios vinculados ao tipo do servio
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="get_servicos" displayname="Consulta Todos os Servios" access="remote" returntype="Query" output="false">	  
		<cfargument name="servico_id" 	required="no" default="" />
		<cfargument name="descricao" 	required="no" default="" />
		<cfquery name="qrServicos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select s.servico_id,s.descricao,s.porta,s.nome_servidor,s.endereco_ip,s.path_servidor, 
				   s.servico_ativo, decode( s.servico_ativo, 1, 'Ativo', 'Inativo') situacao_servico
			  from atualizador.servico s
			 where 0 = 0
			<cfif StructKeyExists( arguments, 'servico_id' ) and IsNumeric( arguments['servico_id'] )>
			   and s.servico_id = #val( arguments['servico_id'] )#
			</cfif>
			<cfif StructKeyExists( arguments, 'descricao' ) and Len(Trim( arguments['descricao'] ))>
			   and instr( lower( s.descricao ), lower('#arguments['descricao']#') ) <> 0
			</cfif>
			order by s.descricao
		</cfquery>  
		<cfreturn qrServicos />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Seleciona conexes ativas
	-- JEFFERSON          30/07/2004 - criado
	--->			
	<cffunction name="get_conexoes" displayname="Seleciona Conexes Ativas" output="false" returntype="Query">
		<cfquery name="qrConexoes" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select  cc.controle_conexao_id,cc.date_insert,cc.date_update,cc.endereco_ip,cc.servico_tipo_id,
					s.servico_id, s.descricao, s.nome_servidor servidor, s.porta, upper(cc.maquina) maquina, 
					st.descricao tipo_servico,
					atualizador.pkg_controle_conexao.fnc_calcula_tempo_conectado( cc.date_insert, nvl( cc.date_update, sysdate ), 'm') tempo_conectado
			  from  atualizador.controle_conexao cc
					inner join atualizador.servico_tipo st
					   on st.servico_tipo_id = cc.servico_tipo_id
					inner join atualizador.servico_tipo_servico sts
					   on sts.servico_tipo_id = st.servico_tipo_id
					inner join atualizador.servico s
					   on s.servico_id = sts.servico_id
			  where cc.conexao_ativa 	= 1
				and cc.user_insert      = user
			  <cfif StructKeyExists( arguments, 'servico_id') and Len( Trim( arguments['servico_id'] ) ) >
				and s.servico_id = #val( arguments['servico_id'] )#
			  </cfif>
		 order by cc.conexao_ativa desc
		</cfquery>
		<cfreturn qrConexoes />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Seleciona conexes que foram liberadas para atualizaes
	-- JEFFERSON  13/11/2003 - criado
	--->			
	<cffunction name="get_servico_tipo" displayname="Tipos de Servico" access="remote" returntype="Query" output="true">
		<cfquery name="qrConexoesAtualizacoes" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select servico_tipo_id,
				   descricao
			  from atualizador.v$servico_tipo
		</cfquery>
		<cfreturn qrConexoesAtualizacoes />
	</cffunction>	
<!---



<cffunction name="getEmpresas" displayname="Lista todaas empresas que possuem cpias registradas dos produtos" access="remote" returntype="Query" output="false">
   <!--- 
   	-- PROPSITO
	-- Seleciona Empresas com cpias registradas
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          13/11/2003 - criado
	-- JEFFERSON          09/08/2004 - modificado
	--->			
	<cfargument name="num_serie"    			required="false"    displayname="Nmero de Srie" 			type="string" />				
	<cfargument name="cod_pessoa"    			required="false"    displayname="Cdigo da Pessoa" 			type="string" />
	<cfargument name="cnpj" 					required="false"	displayname="CNPJ" 						type="string" />
	<cfargument name="cnpj_basico" 				required="false"	displayname="CNPJ Bsico" 				type="string" />
	<cfargument name="nome_fantasia" 			required="false"	displayname="Nome Fantasia" 			type="string" />
	<cfargument name="cod_projeto" 				required="false" 	displayname="Cdigo do Projeto" 		type="string" />
	<cfargument name="cod_aplicacao" 			required="false"	displayname="Cdigo da Aplicao" 		type="string" />
					
		<cfset var qrEmpresas = '' />
			
		<cfquery name="qrEmpresas" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_serie, c.cod_pessoa, c.cod_projeto , c.cod_aplicacao, 
             	   internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao( c.cod_projeto, c.cod_aplicacao ) nome_aplicacao,
				   pe.nome_fantasia, pe.cnpj_basico, pe.identificador 
			  from atualizador.copias c
           		   inner join internet.v$pessoa pe
                	  on pe.cod_pessoa = c.cod_pessoa
			 where exists( select 'x'
							from internet.pessoa_usr_aplic_suporte pua
						   where pua.cod_projeto   = c.cod_projeto
							 and pua.cod_aplicacao = c.cod_aplicacao   
							 and pua.cod_pessoa    = c.cod_pessoa
							 and pua.usuario 	   = user )			
			 <cfif StructKeyExists(arguments, 'cadastra_contrato') and Len(Trim( arguments['cadastra_contrato'] ))>
			 -- so mostra os empresas que no tem contrato cadastrado ou a vigncia do contrato atual estiver vencida
			 and not exists( select 'x' 
							   from atualizador.copias_contrato cc
							  where cc.num_serie = c.num_serie
								and sysdate between cc.inicio and cc.fim  )
			 </cfif>
			 <cfif StructKeyExists(arguments, 'maquina') and Len(Trim( arguments['maquina'] ))>
			 -- so mostra os empresas que tem registro de mquinas
			   and exists( select 'x' 
						     from atualizador.maquina_copias mc
						    where mc.num_serie = c.num_serie )      
			</cfif>			 
			 <cfif StructKeyExists( arguments, 'num_serie' ) and Len( Trim( arguments['num_serie'] ) ) >
			   and  c.num_serie = replace( translate( '#arguments['num_serie']#', '-', ' '),' ', '')
			 </cfif>
			 <cfif StructKeyExists( arguments, 'cod_pessoa') and IsNumeric( arguments['cod_pessoa'] )>
			   and c.cod_pessoa    = #val( arguments['cod_pessoa'] )#
			 </cfif>		
			 <cfif StructKeyExists(arguments, 'cod_projeto')   and IsNumeric( arguments['cod_projeto'] )
			   and StructKeyExists(arguments, 'cod_aplicacao') and Len( Trim( arguments['cod_aplicacao'] ) ) >
			   and c.cod_projeto   = #val( arguments['cod_projeto'] )#
			   and c.cod_aplicacao = '#arguments['cod_aplicacao']#'
			 </cfif>
			 <cfif StructKeyExists( arguments, 'nome_fantasia' ) and Len( Trim( arguments['nome_fantasia'] ) ) >
			   and instr( upper( pe.nome_fantasia ) , upper('#arguments['nome_fantasia']#') ) <> 0
			 </cfif>			
			 <cfif StructKeyExists(arguments, 'cnpj_basico') and Len(Trim( arguments['cnpj_basico'] ))>
			   and pe.cnpj_basico   = '#arguments['cnpj_basico']#'
			</cfif>			 
			 <cfif StructKeyExists( arguments, 'cnpj' ) and Len( Trim( arguments['cnpj'] ) )>
				and replace( translate( pe.identificador , '-/.', ' '),' ', '')  = replace( translate( '#arguments['cnpj'] #' , '-/.', ' '),' ', '')
			 </cfif>			
		     order by pe.nome_fantasia , c.cod_projeto, c.cod_aplicacao
		</cfquery>
			
	<cfreturn qrEmpresas />
		
</cffunction>


<cffunction name="getAplicacoes"  displayname="Consulta Aplicaes vinculados a pessoa Jurdica" access="Remote" returntype="Query" output="false">
   <!--- 
   	-- PROPSITO ( Avaliar posteriormente ) 
	-- Seleciona projetos das empresas com cpias registradas
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          13/11/2003 - criado
	-- JEFFERSON          15/07/2004 - modificado
	--->			
	<cfargument name="cod_projeto" 				required="false" 	displayname="Cdigo do Projeto" 		type="string" />
	<cfargument name="cod_aplicacao" 			required="false"	displayname="Cdigo da Aplicao" 		type="string" />
	
		<cfset var qrAplicacoes = ''  />
			
		<cfquery  name="qrAplicacoes" datasource="#application.dsn#"  username="#session.usuario#" password="#session.senha#">
			select ra.cod_projeto, ra.cod_aplicacao,ra.produto,
				   atualizador.pkg_atualizador_util.fnc_formata_versao( ra.v_major, ra.v_minor , ra.v_release , ra.v_build ) versao,
				   internet.pkg_kss_web.fnc_nome_projeto( ra.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao( ra.cod_projeto, ra.cod_aplicacao ) nome_aplicacao,
				   ra.v_major,ra.v_minor,ra.v_release,ra.v_build,ra.site_produto,ra.ativo, ra.mensagem
			  from atualizador.v$registro_aplicacao ra
			 where exists( select 'x'
							from internet.pessoa_usr_aplic_suporte pua
						   where pua.cod_projeto   = ra.cod_projeto
							 and pua.cod_aplicacao = ra.cod_aplicacao   
							 and pua.usuario 	   = user )			
			 <cfif StructKeyExists(arguments, 'cod_projeto')   and IsNumeric( arguments.cod_projeto )>
			   and ra.cod_projeto   = #val( arguments['cod_projeto'] )#
			 </cfif>
			 <cfif StructKeyExists(arguments, 'cod_aplicacao') and Len( Trim( arguments.cod_aplicacao ) ) >
			   and ra.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 order by ra.cod_projeto, ra.cod_aplicacao					
		</cfquery>
	
	<cfreturn qrAplicacoes />		
		
</cffunction>		

<cffunction name="getAplicacoes2"  displayname="Consulta Aplicaes vinculados a pessoa Jurdica" access="Remote" returntype="Query" output="false">
   <!--- 
   	-- PROPSITO ( Avaliar posteriormente ) 
	-- Seleciona projetos das empresas com cpias registradas
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          13/11/2003 - criado
	-- JEFFERSON          15/07/2004 - modificado
	--->			
	<cfargument name="cod_projeto" 				required="false" 	displayname="Cdigo do Projeto" 		type="string" />
	<cfargument name="cod_aplicacao" 			required="false"	displayname="Cdigo da Aplicao" 		type="string" />
	
		<cfset var qrAplicacoes = ''  />
			
		<cfquery  name="qrAplicacoes" datasource="#application.dsn#"  username="#session.usuario#" password="#session.senha#">
			select ra.cod_projeto, ra.cod_aplicacao,ra.produto,
				   atualizador.pkg_atualizador_util.fnc_formata_versao( ra.v_major, ra.v_minor , ra.v_release , ra.v_build ) versao,
				   internet.pkg_kss_web.fnc_nome_projeto( ra.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao( ra.cod_projeto, ra.cod_aplicacao ) nome_aplicacao,
				   ra.v_major,ra.v_minor,ra.v_release,ra.v_build,ra.site_produto,ra.ativo, ra.mensagem
			  from atualizador.v$registro_aplicacao ra
			 where exists( select 'x'
							from internet.pessoa_usr_aplic_suporte pua
						   where pua.cod_projeto   = ra.cod_projeto
							 and pua.cod_aplicacao = ra.cod_aplicacao   
							 and pua.usuario 	   = user )			
			 <cfif StructKeyExists(arguments, 'cod_projeto')   and IsNumeric( arguments['cod_projeto'] )>
			   and ra.cod_projeto   = #val( arguments['cod_projeto'] )#
			 </cfif>
			 <cfif StructKeyExists(arguments, 'cod_aplicacao') and Len( Trim( arguments['cod_aplicacao'] ) ) >
			   and ra.cod_aplicacao = '#arguments['cod_aplicacao']#'
			 </cfif>
			 order by ra.cod_projeto, ra.cod_aplicacao					
		</cfquery>
	
	<cfreturn qrAplicacoes />		
		
</cffunction>		

<cffunction name="getProjetos"  displayname="Consulta projetos vinculados a pessoa Jurdica" access="Remote" returntype="Query" output="false">
   <!--- 
   	-- PROPSITO 
	-- Seleciona projetos das empresas com cpias registradas, que tenham direito a suporte
	    e que o usurio corrente esteja vinculado para ter acesso para trabalhar com essa empresa.
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          13/11/2003 - criado
	-- JEFFERSON          15/07/2004 - modificado
	--->			
		<cfset var qrProjetos = ''  />
			
		<cfquery  name="qrProjetos" datasource="#application.dsn#"  username="#session.usuario#" password="#session.senha#">
			select pas.cod_projeto, internet.pkg_kss_web.fnc_nome_projeto( pas.cod_projeto ) nome_projeto, 
				   pas.cod_pessoa, kss.pessoa_pkg.getIdentificador( pas.cod_pessoa) cnpj
			  from internet.pessoa_aplicacao_suporte pas
			 where  exists( select 'x' 
						      from atualizador.v$registro_aplicacao ra 
								   inner join internet.pessoa_usr_aplic_suporte pua
									 on pua.cod_projeto   = ra.cod_projeto
									and pua.cod_aplicacao = ra.cod_aplicacao
							  where pua.cod_pessoa    = pas.cod_pessoa
							    and pua.cod_projeto   = pas.cod_projeto 
			  					and pua.cod_aplicacao = pas.cod_aplicacao
					  			and pua.usuario       = user)
			 order by internet.pkg_kss_web.fnc_nome_projeto( pas.cod_projeto )		
 		</cfquery>
	
	<cfreturn qrProjetos />		
		
</cffunction>		



<cffunction name="getContratos" displayname="Lista tods contratos das cpias" access="remote" returntype="Query" output="true">
   <!--- 
   	-- PROPSITO
	-- Seleciona todos contratos da Cpia
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          13/11/2003 - criado
	-- JEFFERSON          15/07/2004 - modificado
	-- LUCIANA            28/12/2004 - modificado
	--->			
	<cfargument name="num_serie" required="false" displayname="Nmero de Srie" type="string" />				
		<cfset var qrCopias = '' />
		<cfquery name="qrCopias" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select cc.num_serie, cc.inicio data_inicio_contrato,cc.fim data_fim_contrato
			  from atualizador.copias c 
             	   inner join atualizador.copias_contrato cc
					 on cc.num_serie = c.num_serie					     
			  <cfif StructKeyExists(arguments, 'num_serie') and Len( Trim( arguments.num_serie ) )>
		      where cc.num_serie = replace( translate( '#arguments['num_serie']#', '-', ' '),' ', '')
		      </cfif>						
			 order by cc.inicio
		</cfquery>
	<cfreturn qrCopias />
</cffunction>

				

	


<cffunction name="getAtualizacoesMaquinas" displayname="Listagem detalhada das atualizaes por mquina" access="remote" returntype="Query" output="true">
   <!--- 
   	-- PROPSITO
	-- Seleciona relao de atualizaes da mquinas
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON  13/11/2003 - criado
	-- JEFFERSON  15/07/2004 - modificado
	-- LUCIANA    25/01/2005 - modificado
	--->			
	<cfargument name="cod_pessoa" displayname="Cdigo da Pessoa" required="no" />
	<cfargument name="cod_projeto" displayname="Cdigo do Projeto" required="no" />
	<cfargument name="cod_aplicacao" displayname="Cdigo da Aplicao" required="no" />
	<cfargument name="cnpj_basico" displayname="CNPJ Bsico" required="no" />
	<cfargument name="cnpj" displayname="Identificador" required="no" />
	<cfargument name="maquina" displayname="Maquina da Unidade" required="no" />
	<cfargument name="data_hora" displayname="Data de Atualizao" required="no" />
	<cfargument name="mostrar" required="no" default="1">
	<cfargument name="data_inicio" required="no" default="">
	<cfargument name="data_fim" required="no" default="">

		<cfquery name="qrAtualizacoesMaquinas" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.cod_pessoa, c.cod_projeto, c.cod_aplicacao, c.num_serie,
				   internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao( c.cod_projeto, c.cod_aplicacao ) nome_aplicacao,
				   pe.cnpj_basico,pe.cnpj_ordem,pe.identificador,pe.email,pe.nome_fantasia unidade, upper( mc.maquina ) maquina,
				   replace( translate( upper( at.maquina ) , '- _', ' '),' ', '') maquina_id,
				   at.data_hora data, at.data_hora, atualizador.pkg_atualizador_util.fnc_formata_versao( at.v_major, at.v_minor, at.v_release, at.v_build ) versao,
				   4*at.v_major+3*at.v_minor+2*at.v_release+1*at.v_build versao_ordem, 
               	   nvl( ar.nome_arquivo, 'Nenhum arquivo atualizado') nome_arquivo , ar.pasta_instalacao, 
				   decode( nvl( ar.tamanho,0 ) , 0, '', atualizador.pkg_atualizador_util.fnc_tamanho_arquivo( ar.tamanho) ) tamanho, ar.data_arquivo 
			  from internet.v$pessoa pe 
				   inner join atualizador.copias c
				 	  on c.cod_pessoa = pe.cod_pessoa         
			  	   inner join atualizador.maquina_copias mc
				 	  on mc.num_serie = c.num_serie
			  	   inner join atualizador.atualizacoes at
				 	  on at.num_serie = mc.num_serie
					 and at.maquina   = mc.maquina
				   left outer join atualizador.atualizacoes_arquivos ar
					 on  ar.num_serie = at.num_serie
					and  ar.maquina   = at.maquina
					and  ar.data_hora = at.data_hora
				   inner join kss.pessoa_aplicacao pa  
					  on pa.cod_pessoa = pe.cod_pessoa 	
					 and pa.cod_projeto = c.cod_projeto
 					 and pa.cod_aplicacao = c.cod_aplicacao 		   
	               where mc.situacao    = 1
              and exists ( select 'x'
						 from kss.kss_usuarios_suporte us
						where us.cod_projeto = pa.cod_projeto
						  and us.cod_aplicacao = pa.cod_aplicacao
						  and tecnico_suporte = user)							  

			<cfif IsDefined("arguments.data_hora") >
			  and at.data_hora = to_date('#arguments.data_hora#','dd/mm/yyyy hh24:mi:ss')
			</cfif>																			
			<cfif IsDefined("arguments.cod_projeto") and IsNumeric( arguments.cod_projeto ) >
			  and c.cod_projeto = #val( arguments.cod_projeto )#
			</cfif>
			<cfif IsDefined("arguments.cod_projeto") and IsNumeric( arguments.cod_projeto )
			  and IsDefined("arguments.cod_aplicacao") and Len( Trim ( arguments.cod_aplicacao ) )>
			  and c.cod_projeto = #val( arguments.cod_projeto )#
			  and c.cod_aplicacao = '# arguments.cod_aplicacao #'
			</cfif>
		    <cfif IsDefined("arguments.cnpj") and Len( Trim( arguments.cnpj ) )>
			  and replace( translate( pe.identificador , '-/.', ' '),' ', '')  = replace( translate( '#arguments.cnpj#' , '-/.', ' '),' ', '')
			</cfif>
			<cfif IsDefined("arguments.cnpj_basico") and Len(Trim( arguments.cnpj_basico ))>
			   and pe.cnpj_basico   = '#arguments.cnpj_basico#'
			</cfif>			 
			<cfif IsDefined("arguments.maquina") and Len( Trim( arguments.maquina ) )>
			  and upper(at.maquina) = upper('#arguments.maquina#')
			</cfif>
			<cfif arguments.mostrar neq "1">
				and 1=0
			</cfif>
			<cfif len(trim(arguments.data_inicio))>
				and at.data_hora >= '#arguments.data_inicio#'
			</cfif>
			<cfif len(trim(arguments.data_fim))>
				and trunc(at.data_hora) <= '#arguments.data_fim#'
			</cfif>
			  order by  pe.cnpj_basico, upper( at.maquina ), c.cod_projeto, c.cod_aplicacao, 4*at.v_major+3*at.v_minor+2*at.v_release+1*at.v_build desc, at.data_hora desc
			
		</cfquery>
	<cfreturn qrAtualizacoesMaquinas />
</cffunction>	 


	 






<cffunction name="getMaquinasAtualizadas2" displayname="Lista mquinas que j atualizaram software" access="remote" returntype="Query" output="false">
   <!--- 
   	-- PROPSITO
	-- Seleciona mquinas que j atualizaram software para filtro no relatrio de atualizaes
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          27/09/2004 - criado
	--->			
	<cfargument name="cod_projeto"     required="false"    displayname="Cdigo do Projeto" 		type="string" />				
	<cfargument name="cod_aplicacao"   required="false"    displayname="Cdigo da Aplicao" 	type="string" />				
			
		<cfset var qrMaquinasAtualizadas = '' />
				
		<cfquery name="qrMaquinasAtualizadas" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct kss.pessoa_pkg.getIdentificador( c.cod_pessoa ) cnpj, mc.maquina
			  from atualizador.copias c
				   inner join atualizador.maquina_copias mc
					  on mc.num_serie = c.num_serie
		   	  where exists( select 'x' 
						 	  from  atualizador.atualizacoes at 
							 where at.num_serie = mc.num_serie
						  	   and at.maquina   = mc.maquina )
      		   and exists ( select 'x'
						      from internet.pessoa_usr_aplic_suporte pua
						     where pua.cod_pessoa 	 = c.cod_pessoa
							   and pua.cod_projeto   = c.cod_projeto
							   and pua.cod_aplicacao = c.cod_aplicacao   
							   and pua.usuario       = user) 
							   
			 <cfif StructKeyExists(arguments, 'cod_projeto') and IsNumeric( arguments['cod_projeto'] )
			   and StructKeyExists(arguments, 'cod_projeto') and Len( Trim( arguments['cod_aplicacao'] ) )>
		       and c.cod_projeto   =  #val( arguments['cod_projeto'] )#
			   and c.cod_aplicacao = '#arguments['cod_aplicacao']#'
		     </cfif>						
			 order by mc.maquina
		</cfquery>
				
	<cfreturn qrMaquinasAtualizadas />
		
</cffunction>

	 


		


<cffunction name="getProjetosMaquina2"  displayname="Consulta projetos vinculados a uma mquina" access="Remote" returntype="Query" output="false">
   <!--- 
   	-- PROPSITO 
	-- Seleciona projetos que esto instalados na mquina do cliente 
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          28/09/2004 - criado
		<cfargument name="maquina" required="yes">
	--->			
		<cfset var qrProjetos = ''  />
		<cfquery  name="qrProjetos" datasource="#application.dsn#"  username="#session.usuario#" password="#session.senha#">
			select distinct c.cod_projeto, internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto) nome_projeto, mc.maquina
			  from atualizador.copias c
       			   inner join atualizador.maquina_copias mc
          			  on mc.num_serie = c.num_serie
			 where exists(  select 'x'
						     from kss.kss_usuarios_suporte pua
						  	where pua.tecnico_suporte       = user 
							  and pua.cod_aplicacao = c.cod_aplicacao
							  and pua.cod_projeto = c.cod_projeto )						 
			order by internet.pkg_kss_web.fnc_nome_projeto( c.cod_projeto )		
 		</cfquery>
	
	<cfreturn qrProjetos />		
		
</cffunction>		

<cffunction name="getMaquinasAtivas" displayname="Listagem das mquinas ativas" access="remote" returntype="Query" output="true">
   <!--- 
   	-- PROPSITO
	-- Seleciona relao de mquinas ativas
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON 07/10/2004 - criado
	-- LUCIANA   01/02/2005 - modificado	
	--->			
	<cfargument name="cod_pessoa" required="no" displayname="Cdigo da Pessoa" />
	<cfargument name="cnpj_basico" required="no" displayname="CNPJ_BASICO"/>	
	<cfargument name="cnpj" required="no" displayname="CNPJ"/>
	<cfargument name="cod_projeto" required="no" displayname="Cdigo do Projeto" />
	<cfargument name="cod_aplicacao" required="no"	displayname="Cdigo da Aplicao" />
	<cfargument name="num_serie" required="no" displayname="Nmero de Srie" />				
	<cfargument name="data_inicio" required="no" displayname="Data de Incio" />				
	<cfargument name="data_fim" required="no" displayname="Data de Trmino" />				
	
		<cfquery name="qrAtualizacoes" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_serie,c.cod_pessoa,c.cod_projeto,c.cod_aplicacao,
            	   internet.pkg_kss_web.fnc_nome_projeto(c.cod_projeto) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao(c.cod_projeto,c.cod_aplicacao) nome_aplicacao,
		 		   pe.cnpj_basico,pe.cnpj_ordem,pe.identificador,pe.email,pe.nome_fantasia,mc.maquina,pe.razao_social,
		       	   replace( translate( upper( mc.maquina ) , '- _', ' '),' ', '') maquina_id
		     from internet.v$pessoa pe 
             	  inner join atualizador.copias c
                  	 on c.cod_pessoa = pe.cod_pessoa
                  inner join kss.pessoa_aplicacao pa
                     on pa.cod_pessoa = c.cod_pessoa
                    and pa.cod_projeto = c.cod_projeto
                    and pa.cod_aplicacao = c.cod_aplicacao
      			  inner join atualizador.maquina_copias mc 
         			 on mc.num_serie = c.num_serie
			where mc.situacao    = 1
          	  and exists( select 'x'
					 from kss.kss_usuarios_suporte us
				    where us.cod_projeto = c.cod_projeto
					  and us.cod_aplicacao = c.cod_aplicacao
					  and tecnico_suporte = user)		
							 
			 <cfif IsDefined("arguments.cnpj_basico") and Len(Trim( arguments.cnpj_basico ))>
			   and pe.cnpj_basico   = '#arguments.cnpj_basico#'
			</cfif>			 
			<cfif IsDefined( "arguments.cnpj" ) and Len( Trim( arguments.cnpj ) )>
				and replace( translate( pe.identificador , '-/.', ' '),' ', '')  = replace( translate('#arguments.cnpj#', '-/.', ' '),' ', '')
			</cfif>			
			<cfif IsDefined("arguments.cod_projeto")   and IsNumeric( arguments.cod_projeto )>
			    and c.cod_projeto = #val( arguments.cod_projeto )#
			</cfif>
			<cfif IsDefined("arguments.cod_aplicacao") and Len( Trim( arguments.cod_aplicacao ) )>
			    and c.cod_aplicacao = '#arguments.cod_aplicacao#'
			</cfif>
			<cfif IsDefined("arguments.data_inicio") and IsDate(arguments.data_inicio )
			    and IsDefined("arguments.data_fim") and IsDate(arguments.data_fim )>
			    and to_date(to_char(mc.date_insert,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_fim#','dd/mm/yyyy')
			 </cfif> 
		  	  order by pe.razao_social, pe.nome_fantasia, internet.pkg_kss_web.fnc_nome_projeto(c.cod_projeto), internet.pkg_kss_web.fnc_nome_aplicacao(c.cod_projeto,c.cod_aplicacao), mc.maquina
		 </cfquery>
	<cfreturn qrAtualizacoes />
</cffunction>	



	


	 

<cfscript>
 /**
   * @descritivo	: Cria Gradiente de Cores
   * @parametro		: cod_projeto   : numrico. ( Requerido )
					  cod_aplicacao : string.   ( Requerido )
					  p_atual		  : string.   ( Requerido )
   * @retorno		: HexaDecimal
   * @autor         : Jefferson Petilo( jefferson@kmm.com.br ) 
   * @verso		: 1, 13  de Novembro de 2004
   */					
function verificaAtualizacao( cod_projeto, cod_aplicacao, versao_atual )
{
 var vCor1 			= 'FFE7E7'; 													// cor inicial do gradiente
 var vCor2			= 'FF2E2E'; 													// cor final do gradiente
 var qrVersoes 		= this.getVersao(ArgumentCollection = Arguments); 				// consulta todas as verses de atualizao disponiveis para o projeto e aplicao fornecido
 var qrMaxMinVersao = this.getMaxMinVersao(ArgumentCollection = Arguments);  		// consulta a primeira e ultima verso disponibilizada para o projeto e aplicao fornecido
 var vVersao 		= VaLueList( qrVersoes.versao_atualizacao );  								// crio uma lista com as verses disponveis do codigo do projeto e aplicao  fornecidos
 var vMax 			= qrMaxMinVersao.maximo; 										// versao maxima ( ltima verso disponibilizada )
 var vMin 			= qrMaxMinVersao.minimo; 										// versao minima ( primeira verso disponibilizada )
 var estilo 		= ''; 															// variavel de retorno ( que acumular o cdigo HexaDecimal da cor final )

	if( versao_atual eq vMax ) 
		estilo = FormatBaseN( 250, 16 ) & FormatBaseN( 251, 16 )  & FormatBaseN( 252, 16 ); // verifica se o valor atual for igual a ultima verso, aplica o estilo (cor FAFBFC)
	else if ( versao_atual eq vMin ) 
	    estilo = FormatBaseN( 255, 16 )  & '0' & FormatBaseN( 0, 16 )  & '0' & FormatBaseN( 0, 16 ); // se o valor atual for igual a primeira verso, aplica o estilo (cor F30000)
	else 
	{
	    vCores = Ucase( this.lista( vCor1 , vCor2 , qrVersoes.recordcount ) ); // invoca a funo "lista"  para criar cria uma paleta gradiente de cores Lista(cor1, cor2, st)

	   for( j = 1; j lte ListLen( vVersao ); j = j + 1 )
	    if( ListGetAt( vVersao , j ) eq versao_atual )
		{
		  estilo =  ListGetAt( vCores , j );// se o valor atual for igual a uma verso intermediria, aplica o estilo dinamicamente
		  break;	
		}	
	 }	 
  return  ( "##"&REReplace(JSStringFormat(trim(estilo)), '0', '', 'ALL') ); 					
}	

/**
* @descritivo	: Criar Paleta na Escala Vermelho/Branco
* @parametro	: cor1   : HexaDecimal. ( Requerido )
				  cor2   : HexaDecimal. ( Requerido )
				  step   : numrico.    ( Requerido )
* @retorno		: HexaDecimal
* @autor        : Jefferson Petilo( jefferson@kmm.com.br ) 
* @verso		: 1, 17  de Novembro de 2004
*/					
function lista( cor1 , cor2 , step )
{
 var saida		= cor1;
 var decimalr	= 0;
 var decimalg	= 0;
 var decimalb	= 0;
 var novor		= 0;
 var novog		= 0;
 var novob		= 0;
 var j 			= 1;
     step		= step-1; // elimina a ultima cor (evita duplicata)
	
	// criao da escala separada da escala RGB dividindo pelo step
	decimalr	= ( ( InputBaseN( Left(  cor1 , 2 ), 16 )         - InputBaseN(  Left( cor2 , 2 ) , 16 ) ) / step );
	decimalg	= ( ( InputBaseN( Mid(   cor1 , 3  ,  2 ) , 16 )  - InputBaseN(  Mid ( cor2 , 3   ,  2 )  , 16 ) ) / step );
	decimalb	= ( ( InputBaseN( Right( cor1 , 2 ), 16 )         - InputBaseN( Right( cor2 , 2 ) , 16 ) ) / step );
			
	for ( j = 1; j lte step; j = j + 1 ) // loop gerando novas cores com base na escala obtida 
	{
	  novor = FormatBaseN( Int( InputBaseN( Left( cor1 , 2) , 16) - ( j * decimalr ) ) , 16 ); 
	   if( len( novor ) ) novor = '0' & novor; // cria a tonalidade em vvermelho
	  novog	=	FormatBaseN( Int( InputBaseN( Mid( cor1, 3 , 2 ), 16 ) - ( j * decimalg ) ), 16 ); 		
	   if( Len( novog ) ) novog =	'0' & novog; // cria a tonalidade em verde
	  novob	=	FormatBaseN( Int( InputBaseN( Right( cor1,2 ),16 ) - ( j * decimalb ) ), 16 ); // crio a tonalidade em azul	
	   if( Len( novob ) ) novob = '0' & novob;
					
	  saida = saida &',' & novor & novog & novob; // cria uma lista com as cores
	}
  return ( saida & ',' & cor2 );  // retorna uma lista com as cores 
} 

</cfscript>

<cffunction name="getMaxMinVersao" displayname="Consulta a primeira e ltima verso de cada aplicao" access="remote" returntype="Query" output="false">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona verso mxima e mnima de cada projeto e aplicao
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          13/11/2003 - criado
	-- JEFFERSON          15/07/2004 - modificado
	--->			
	<cfargument name="cod_projeto" 				required="true" 	displayname="Cdigo do Projeto"  		type="numeric"	/>
	<cfargument name="cod_aplicacao" 			required="true" 	displayname="Cdigo da Aplicao" 	 	type="string"/>

		<cfset var qrMaxMinVersao = ''  />
			
		<cfquery name="qrMaxMinVersao" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="50">
			select av.cod_projeto, av.cod_aplicacao,
				   atualizador.pkg_atualizador.fnc_max_versao_atualizacao( av.cod_projeto, av.cod_aplicacao ) maximo,
				   atualizador.pkg_atualizador.fnc_min_versao_atualizacao( av.cod_projeto, av.cod_aplicacao ) minimo
			  from atualizador.atualizacao_versao av
			 where av.cod_projeto   = #val( arguments['cod_projeto'] )#
			   and av.cod_aplicacao = '#arguments['cod_aplicacao']#'
			 group by av.cod_projeto, av.cod_aplicacao  						
			 order by av.cod_projeto, av.cod_aplicacao		
		</cfquery>
				
	<cfreturn qrMaxMinVersao  />		
		
</cffunction>			

--->
</cfcomponent>