<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de infraestrutura" extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna Servidores Cadastrados
    -- LEOPOLDOS 30/06/2010 - CRIADO
    --->		
    <cffunction name="get_servidores" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.cod_servidor
                 , s.descricao
                 , s.rede
                 , s.mascara
              from infraestrutura.v$servidor_dhcp s
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Clientes
    -- LEOPOLDOS 30/06/2010 - CRIADO
    --->		
    <cffunction name="get_clientes_dhcp" access="remote" returntype="query" output="true">
    	<cfargument name="nome" required="no" default="">
    	<cfargument name="cliente_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.cliente_id
                 , c.descricao
              from infraestrutura.v$cliente_dhcp c
             where 1=1
             <cfif Len(Trim(arguments.NOME))>
               and upper(c.descricao) like upper('%#arguments.NOME#%')
             </cfif>
             <cfif Len(Trim(arguments.CLIENTE_ID))>
               and c.cliente_id = #arguments.CLIENTE_ID#
             </cfif>
              order by c.descricao ASC
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
        <!--- 
    -- PROPSITO 
    -- Retorna Ips
    -- Leandro 30/06/2010 - ALTERADO
    --->		
    <cffunction name="get_ip_cliente" access="remote" returntype="query" output="true">
        <cfargument name="cod_servidor" required="no" default="">
    	<cfargument name="cliente_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cd.cliente_ip_id
                 , cd.cod_servidor
                 , cd.cliente_id
                 , (select cl.descricao
                      from infraestrutura.v$cliente_dhcp cl
                     where cl.cliente_id = cd.cliente_id) as cliente
                 , cd.cod_servidor
                 , (select sdd.descricao
                      from infraestrutura.v$servidor_dhcp sdd
                     where sdd.cod_servidor = cd.cod_servidor) as servidor_dhcp
                 , cd.mac_address
                 , cd.ip
              from infraestrutura.v$cliente_dhcp_ip cd
              where 1 = 1
               <cfif Len(Trim(arguments.COD_SERVIDOR))>
              	   and cd.cod_servidor = #arguments.COD_SERVIDOR#  
			  </cfif>
              <cfif Len(Trim(arguments.CLIENTE_ID))>
              	   and cd.cliente_id = #arguments.CLIENTE_ID#  
			  </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
</cfcomponent>