<cfcomponent>
	<cffunction access="remote" name="redimensiona_imagem" returntype="string" output="true">		
        <cfargument name="url" required="yes">        
		<cfargument name="width" required="no" default="">
		<cfargument name="height" required="no" default="">
		<cfargument name="maxwidth" required="no" default="">
		<cfargument name="maxheight" required="no" default="">
        
		<cftry>
			<cfscript>
				if(not len(trim(arguments.url))) {
					return arguments.url;
				}
				v_url = arguments.url;
				conn = CreateObject("component", "_transportes.funcoes.cfc_image_utils");
				// Alterao foi feita pois o componente somente salva arquivos no formato JPG
				v_extensao = 'jpg';//ListLast(arguments.url,'.');
				if (len(trim(arguments.width))) {
					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_h"&arguments.width&"."&lcase(v_extensao);
					if(not FileExists(Expandpath(v_url))) {
						conn.load(filename = Expandpath(arguments.url));
						conn.setWidth(JavaCast("int",arguments.width));
						conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));	
					}
				} else if(len(trim(arguments.height))) {
					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_v"&arguments.height&"."&lcase(v_extensao);
					if(not FileExists(Expandpath(v_url))) {
						conn.load(filename = Expandpath(arguments.url));
						conn.setHeight(JavaCast('int',arguments.height));
						conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));	
					}
	
				} else if (len(trim(arguments.maxwidth)) or len(trim(arguments.maxheight)))	{
					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_mh"&arguments.maxwidth&"_mv"&arguments.maxheight&"."&lcase(v_extensao);
					if (not fileexists(ExpandPath(v_url))) {
						conn.load(filename = Expandpath(arguments.url));
						v_width = conn.getWidth();
						v_height = conn.getHeight();
						if (len(trim(arguments.maxwidth))) {
							if(v_width gt arguments.maxwidth or v_height gt arguments.maxheight) {
								v_reducao = arguments.maxwidth/v_width;
								if(len(trim(arguments.maxheight)) and  (v_height*v_reducao gt arguments.maxheight)) {
									//Reduz na vertical
									conn.setHeight(JavaCast('int',arguments.maxheight));
								} else {
									conn.setWidth(JavaCast('int',arguments.maxwidth));
								}
								conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
							} else {
								conn.setHeight(v_height);
								conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
							}
						} else if (len(trim(arguments.maxheight))) {
							if(v_height gt arguments.maxheight) {
								//Reduz na vertical
								conn.setHeight(JavaCast('int',arguments.maxheight));
								conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
							} else {
								conn.setHeight(v_height);
								conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
							}
						} else {
							conn.setHeight(v_height);
							conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
						}
					}
				
				} else {
					v_url = arguments.url;
				}
				if(ListFind("www.dcmais.com.br,sincronizador.kmm.com.br",cgi.HTTP_HOST)) {
					if(not isdefined("session.imgdomaincounter")) {
						session.imgdomaincounter = 0;
					}
					session.imgdomaincounter = session.imgdomaincounter + 1;
					if(session.imgdomaincounter gt 4) {
						session.imgdomaincounter = 1;
					}
					v_url = "http://img"&session.imgdomaincounter&".dcmais.com.br"&v_url;
				}
				return v_url;
			</cfscript>
			<cfcatch>
				<cfreturn arguments.url>
			</cfcatch>
		</cftry>
	</cffunction>
    
    <cffunction name="redimensiona_imagem_cfm" returntype="string" output="true"> 
        <cfargument name="url" required="yes"> 
        <cfargument name="width" required="no" default=""> 
        <cfargument name="height" required="no" default=""> 
        <cfargument name="maxwidth" required="no" default=""> 
        <cfargument name="maxheight" required="no" default=""> 
        <cftry> 
            <cfscript> 
                if(not len(trim(arguments.url))) { 
                    return arguments.url; 
                }  
                v_url = arguments.url; 
            </cfscript> 
            <cfscript>
												     v_extensao = 'jpg'; 
                 if (Len(Trim(arguments.maxheight)) or Len(Trim(arguments.maxwidth))) {
                					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_mh"&arguments.maxwidth&"_mv"&arguments.maxheight&"."&lcase(v_extensao);																	
																		}		
            </cfscript> 
            <cfif not FileExists(ExpandPath(v_url))> 
              <cfimage action="info" structname="v_imagem" source="#Expandpath(arguments.url)#"> 
														<cfscript> 
                  if (Len(Trim(arguments.maxwidth)) 
                      and ((v_imagem.width/(v_imagem.height/arguments.maxheight)) gt arguments.maxwidth )) { 
                      v_altura = v_imagem.height/(v_imagem.width/arguments.maxwidth); 
                      v_largura = arguments.maxwidth; 
                  } else if (Len(Trim(arguments.maxheight)) 
                             and ((v_imagem.height/(arguments.maxheight/v_imagem.height)) gt arguments.maxheight )) { 
                      v_altura = arguments.maxheight; 
                      v_largura = v_imagem.width/(v_imagem.height/arguments.maxheight); 
                  } else {
                          v_altura = v_imagem.height; 
                          v_largura = v_imagem.width; 
																		}
              </cfscript> 
              <cfimage action="resize" source="#Expandpath(arguments.url)#" name="v_imagem" height="#v_altura#" width="#v_largura#"> 
              <cfimage action="write" source="#v_imagem#" destination="#Expandpath(v_url)#" quality="0.9" overwrite="yes" > 
            </cfif> 
            <cfreturn v_url> 
            <cfcatch> 
               <cfreturn "">
            </cfcatch> 
        </cftry>  
    </cffunction> 

</cfcomponent>