<cfcomponent extends="_transportes.funcoes.cfc_init">	
	<!--- 
	-- PROPSITO
	-- Busca os dados da propriedade dos produtores
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 23/10/2006 - criado
	--->			
	<cffunction name="get_dados_produtores" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_pessoa" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select p.cod_pessoa,
					   p.area_total,
					   p.area_contrato,
					   p.possui_armazem
				  from granex.v$produtor p
				  where 1=1
				  <cfif Len(Trim(arguments.cod_pessoa))>
					and p.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
			</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os atributos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 24/10/2006 - criado
	--->	
	<cffunction name="get_atributo" displayname="Busca os atributos." access="remote" returntype="query" output="true">
		<cfargument name="atributo_id" required="no" default=""/>
		<cfargument name="cultura_id" required="no" default=""/>
		<cfargument name="nome" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select a.atributo_id, 
				   a.nome, 
				   a.observacao, 
				   a.tipo_dado, 
				   a.visivel, 
				   a.ativo, 
				   case a.tipo_dado
					 when 'LISTA' then (select kss.fnc_concat_all(to_concat_expr(ai.valor,','))
										  from granex.v$atributo_item ai
										 where ai.atributo_id = a.atributo_id)
					 when 'FLAG' then 'Sim,No'
					 else ''
				   end as itens
			  from granex.v$atributo a
  			 where 1=1
			 <cfif Len(Trim(arguments.atributo_id))>
			 	and a.atributo_id = #arguments.atributo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.nome))>
			 	and upper(a.nome) like upper('%#arguments.nome#%')
			 </cfif>
			 order by a.nome
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os atributos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 07/12/2006 - criado
	--->	
	<cffunction name="get_atributos_cultura" displayname="Busca os atributos de cada cultura." access="remote" returntype="query" output="true">
		<cfargument name="atributo_id" required="no" default=""/>
		<cfargument name="cultura_id" required="no" default=""/>
		<cfargument name="nome" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select a.atributo_id,
				   a.nome,
				   a.observacao,
				   a.tipo_dado,
				   a.visivel,
				   a.ativo,
				   case a.tipo_dado
					 when 'LISTA' then
					  (select kss.fnc_concat_all(to_concat_expr(ai.valor, ','))
						 from granex.v$atributo_item ai
						where ai.atributo_id = a.atributo_id)
					 when 'FLAG' then
					  'Sim,No'
					 else
					  ''
				   end as itens
			  from granex.v$atributo a
			 inner join granex.v$cultura_atributo ca
						on ca.atributo_id = a.atributo_id
			 inner join granex.v$cultura c
						on c.cultura_id = ca.cultura_id
			 where 1 = 1
			 <cfif Len(Trim(arguments.atributo_id))>
			 	and a.atributo_id = #arguments.atributo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cultura_id))>
			 	and c.cultura_id = #arguments.cultura_id#
			 </cfif>
			 <cfif Len(Trim(arguments.nome))>
			 	and upper(a.nome) like upper('%#arguments.nome#%')
			 </cfif>
			 order by a.nome
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna todos os itens dos atributos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 24/10/2006 - criado
	--->	
	<cffunction name="get_atributo_item" displayname="Busca os itens do atributo." access="remote" returntype="query" output="true">
		<cfargument name="atributo_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select atributo_id, 
				   item_id, 
				   valor
			  from granex.v$atributo_item
			 where 1=1
			 <cfif Len(Trim(arguments.atributo_id))>
			   and atributo_id = #arguments.atributo_id#
			 </cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Retorna todos os tipos de dados utilizados para os atributos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 24/10/2006 - criado
	--->	
	<cffunction name="get_tipo_dado" displayname="Retorna todos os tipos de dados" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select nome, 
				   codigo, 
				   descricao 
			  from granex.v$tipo_dado
			 order by nome
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca as caractersticas de produtos cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 25/10/2006 - criado
	--->	
	<cffunction name="get_caracteristica" displayname="Busca as caractersticas de produtos cadastradas." access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select atributo_id, 
				   nome 
			  from granex.v$atributo
			 order by nome
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca as culturas cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 25/10/2006 - criado
	--->	
	<cffunction name="get_cultura" displayname="Busca as culturas cadastradas." access="remote" returntype="query" output="true">
		<cfargument name="cultura_id" required="no" default=""/>
		<cfargument name="nome" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cultura_id, 
				   nome, 
				   comentario
			  from granex.v$cultura
			 where 1=1
			 <cfif Len(Trim(arguments.cultura_id))>
			 	and cultura_id = #arguments.cultura_id#
			 </cfif>
			 <cfif Len(Trim(arguments.nome))>
			 	and nome like '%#arguments.nome#%'
			 </cfif>
			 order by nome
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca as caractersicas da cultura
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 25/10/2006 - criado
	--->	
	<cffunction name="get_cultura_atributo" displayname="Busca as caractersicas da cultura." access="remote" returntype="query" output="true">
		<cfargument name="atributo_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select ca.cultura_id, 
				   ca.atributo_id
			  from granex.v$cultura_atributo ca,
			  	   granex.v$atributo a
			 where 1=1
			 	   and ca.atributo_id = a.atributo_id
			 <cfif Len(Trim(arguments.cultura_id))>
			 	and ca.cultura_id = #arguments.cultura_id#
			 </cfif>
			 <cfif Len(Trim(arguments.atributo_id))>
			 	and ca.atributo_id = #arguments.atributo_id#
			 </cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca caractersticas das culturas
	-- NOTAS EXPLICATIVAS
	-- arlen 26/10/2006
	--->
	<cffunction name="get_caracteristica_cultura" returntype="query" access="remote">
		<cfargument name="cultura_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.cultura_id, 
				   c.nome, 
				   ca.atributo_id   
			from granex.v$cultura c, 
				 granex.v$cultura_atributo ca
			where 1=1 
				  and c.cultura_id = ca.cultura_id			
			  <cfif Len(Trim(arguments.cultura_id))>
				and ca.cultura_id = #arguments.cultura_id#
			  </cfif>
			  order by c.nome 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca os dados dos agrnomos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 27/10/2006 - criado
	--->			
	<cffunction name="get_dados_agronomos" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_pessoa" required="yes">
			<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select a.cod_pessoa,
					   a.crea,
					   a.instituicao_formacao,
					   a.ano_formacao,
					   a.especializacao,
					   a.instituicao_especializacao,
					   a.regiao_atuacao
				  from granex.v$agronomo a
				  where 1=1
				  <cfif Len(Trim(arguments.cod_pessoa))>
					and a.cod_pessoa = #arguments.cod_pessoa#
				 </cfif>
			</cfquery>  
		<cfreturn qr />
	</cffunction>
	
	<!--- 
	-- PROPSITO  
	-- Busca os proprietrios
	-- NOTAS EXPLICATIVAS
	-- arlen 07/11/2006 - criado
	--->	
	<cffunction name="get_proprietarios" displayname="Busca os proprietrios." access="remote" returntype="query" output="true">
			<cfargument name="cod_proprietario" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select pe.cod_pessoa,
       				   pe.cliente
  				  from kss.v$pessoa pe
 				 inner join granex.v$produtor pr on pr.cod_pessoa = pe.cod_pessoa
				 where 1 = 1
				<cfif Len(Trim(arguments.cod_proprietario))> 
					and pr.cod_pessoa = #arguments.cod_proprietario#
				</cfif>
				order by pe.cliente				
			</cfquery>
	    <cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca as culturas cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 07/11/2006 - criado
	--->	
	<cffunction name="get_propriedade" displayname="Busca as propriedades dos produtores cadastradas." access="remote" returntype="query" output="true">
		<cfargument name="propriedade_id" required="no" default="">
		<cfargument name="cod_pessoa_proprietario" required="no" default="">
		<cfargument name="nome" required="no" default="">
		<cfargument name="nome_proprietario" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
		    select ps.cliente, 
				   pe.propriedade_id, 
				   pe.nome, 
				   pe.cod_pessoa_proprietario, 
				   pe.area_metros,
				   lo.codigo
		--	 from kss.v$pessoa ps, 
		--	 	  granex.v$propriedade pe, 
		--		  granex.v$produtor pr 
	   	     from granex.v$propriedade pe
	   inner join granex.v$produtor pr
		  	   on pr.cod_pessoa = pe.cod_pessoa_proprietario
	   inner join kss.v$pessoa ps
	           on ps.cod_pessoa = pr.cod_pessoa
       inner join granex.v$localizacao lo
	           on lo.propriedade_id = pe.propriedade_id
			where 1 = 1
			  and ps.cod_pessoa = pr.cod_pessoa
			  and pe.cod_pessoa_proprietario = pr.cod_pessoa
			<cfif Len(Trim(arguments.propriedade_id))> 
			  and pe.propriedade_id = #arguments.propriedade_id#
			</cfif>
			<cfif Len(Trim(arguments.cod_pessoa_proprietario))> 
			  and pe.cod_pessoa_proprietario = #arguments.cod_pessoa_proprietario#
			</cfif>
			<cfif Len(Trim(arguments.nome))>
			  and upper(pe.nome) like upper('%#arguments.nome#%')
			</cfif>
			<cfif Len(Trim(arguments.nome_proprietario))>
			  and upper(ps.cliente) like upper('%#arguments.nome_proprietario#%')
			</cfif>
			  order by pe.nome  
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca as localizaes das propriedades dos produtores
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 07/11/2006 - criado
	--->	
	<cffunction name="get_propriedade_localizacao" displayname="Busca as localizaes das propriedades dos produtores." access="remote" returntype="query" output="true">
		<cfargument name="localizacao_id" required="no" default=""/>
		<cfargument name="propriedade_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select pr.propriedade_id, 
				   lo.localizacao_id, 
				   lo.codigo, lo.nome, 
				   lo.area_metros,
				   lo.latitude,
				   lo.longitude
			  from granex.v$localizacao lo,
			  	   granex.v$propriedade pr
			 where 1=1
			 	   and lo.propriedade_id = pr.propriedade_id
			 <cfif Len(Trim(arguments.propriedade_id))>
			 	and pr.propriedade_id = #arguments.propriedade_id#
			 </cfif>
			 <cfif Len(Trim(arguments.localizacao_id))>
			 	and lo.localizacao_id = #arguments.localizacao_id#
			 </cfif>
			  order by lo.nome
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO  
	-- Busca as indstrias
	-- NOTAS EXPLICATIVAS
	-- arlen 09/11/2006 - criado
	--->	
	<cffunction name="get_industrias" displayname="Busca as indstrias." access="remote" returntype="query" output="true">
			<cfargument name="num_modalidade" required="no" default="">
			<cfargument name="existe_contrato" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select pe.cod_pessoa, 
					   pe.cliente
				  from kss.v$pessoa pe
				 inner join kss.v$pessoa_modalidade pm on pm.cod_pessoa = pe.cod_pessoa
				 where 1 = 1
				<cfif Len(Trim(arguments.num_modalidade))> 
					and pm.num_modalidade = '#arguments.num_modalidade#'
				</cfif>
				<cfif Len(Trim(arguments.existe_contrato))> 
					and exists (select 'x' 
								  from granex.v$contrato co
								 where pe.cod_pessoa = co.cod_pessoa_industria)
				</cfif>
				 order by pe.cliente				
			</cfquery>
	    <cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca os contratos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 09/11/2006 - criado
	--->	
	<cffunction name="get_contrato" displayname="Busca os contratos." access="remote" returntype="query" output="true">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="cod_pessoa_industria" required="no" default="">
		<cfargument name="nome_industria" required="no" default="">
		<cfargument name="nome_produto" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select ps.cliente as industria, 
				   ca.nome as produto, 
				   co.contrato_id, 
				   co.cod_pessoa_industria, 
				   co.produto_id, 
				   co.cod_unidade, 
				   co.expedicao, 
				   co.quantidade,
				   pss.cliente as produtor,
				   l.codigo
		--	 from kss.v$pessoa ps, 
	    --		 	  granex.v$contrato co, 
	    --	          granex.v$cultura ca
		 from granex.v$contrato co
       inner join kss.v$pessoa ps
       		 on ps.cod_pessoa = co.cod_pessoa_industria
       inner join granex.v$cultura ca
			 on ca.cultura_id = co.produto_id 
	   inner join granex.v$contrato_produtor cp
	   		 on cp.contrato_id = co.contrato_id
	   inner join granex.v$localizacao l
	   		 on l.localizacao_id = cp.localizacao_id
	   inner join granex.v$propriedade p
	         on p.propriedade_id = l.propriedade_id
	   inner join kss.v$pessoa pss
	         on pss.cod_pessoa = p.cod_pessoa_proprietario
			where 1 = 1
			  and ps.cod_pessoa = co.cod_pessoa_industria
			  and co.produto_id = ca.cultura_id
			<cfif Len(Trim(arguments.contrato_id))> 
			  and co.contrato_id = #arguments.contrato_id#
			</cfif>
			<cfif Len(Trim(arguments.cod_pessoa_industria))> 
			  and co.cod_pessoa_industria = #arguments.cod_pessoa_industria#
			</cfif>
			<cfif Len(Trim(arguments.nome_industria))>
			  and upper(ps.cliente) like upper('%#arguments.nome_industria#%')
			</cfif>
			<cfif Len(Trim(arguments.nome_produto))>
			  and upper(ca.nome) like upper('%#arguments.nome_produto#%')
			</cfif>
			  order by ps.cliente, ca.nome, co.quantidade 
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca as localizaes do contrato
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 09/11/2006 - criado
	--->	
	<cffunction name="get_localizacao_contrato" displayname="Busca as localizaes do contrato." access="remote" returntype="query" output="true">
		<cfargument name="contrato_id" required="no" default=""/>
		<cfargument name="localizacao_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select co.item_id, 
			 	   co.contrato_id, 
				   co.area_metros, 
				   co.estimativa_producao, 
				   lo.localizacao_id, 
				   lo.nome, 
				   pr.propriedade_id,
				   pr.nome as propriedade, 
				   ps.cod_pessoa
			  from granex.v$localizacao lo,
			  	   granex.v$contrato_produtor co,
				   granex.v$propriedade pr,
       			   kss.v$pessoa ps
			 where 1=1
			 	   and co.localizacao_id = lo.localizacao_id
				   and lo.propriedade_id = pr.propriedade_id
				   and ps.cod_pessoa = pr.cod_pessoa_proprietario
			 <cfif Len(Trim(arguments.contrato_id))>
			 	and co.contrato_id = #arguments.contrato_id#
			 </cfif>
			 <cfif Len(Trim(arguments.localizacao_id))>
			 	and lo.localizacao_id = #arguments.localizacao_id#
			 </cfif>
			 	order by lo.nome 
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca as caractersticas dos produtos do contrato
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 09/11/2006 - criado
	--->	
	<cffunction name="get_atributo_contrato" displayname="Busca as caractersticas dos produtos do contrato." access="remote" returntype="query" output="true">
		<cfargument name="contrato_id" required="no" default=""/>
		<cfargument name="atributo_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select ca.contrato_id, 
				   ca.atributo_id, 
				   ca.valor
			  from granex.v$contrato co,
			  	   granex.v$contrato_prod_atributo ca
			 where 1=1
			 	   and co.contrato_id = ca.contrato_id
			 <cfif Len(Trim(arguments.contrato_id))>
			 	and co.contrato_id = #arguments.contrato_id#
			 </cfif>
			 <cfif Len(Trim(arguments.atributo_id))>
			 	and ca.atributo_id = #arguments.atributo_id#
			 </cfif>
			 order by co.contrato_id
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca as unidades de peso
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 14/11/2006 - criado
	--->	
	<cffunction name="get_unidade" displayname="Busca as unidades de peso." access="remote" returntype="query" output="true">
		<cfargument name="cod_grupo_umedida" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_unidade, 
				   unidade
			  from kss.v$unidade_medida
			 where 1 = 1
			 <cfif Len(Trim(arguments.cod_grupo_umedida))>
			   and cod_grupo_umedida = '#arguments.cod_grupo_umedida#'
			 </cfif>
			 order by unidade
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO  
	-- Busca as informaes na consulta do contrato
	-- NOTAS EXPLICATIVAS
	-- arlen 16/11/2006 - criado
	--->	
	<cffunction name="get_dados_contrato" displayname="Busca as informaes na consulta do contrato." access="remote" returntype="query" output="true">
		<cfargument name="localizacao_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select lo.localizacao_id, 
				   lo.propriedade_id, 
				   lo.nome as nomeloc, 
				   pr.nome
			  from granex.v$localizacao lo,
			  	   granex.v$propriedade pr
			 where 1 = 1
			   and lo.propriedade_id = pr.propriedade_id
 			<cfif Len(Trim(arguments.localizacao_id))> 
				and lo.localizacao_id = #arguments.localizacao_id#
			</cfif>
			  order by lo.nome
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os insumos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 22/11/2006 - criado
	--->	
	<cffunction name="get_insumos" displayname="Busca os insumos." access="remote" returntype="query" output="true">
		<cfargument name="insumo_id" required="no" default=""/>
		<cfargument name="marca_descricao" required="no" default=""/>
		<cfargument name="classe_nome" required="no" default=""/>
		<cfargument name="ingrediente_nome" required="no" default=""/>
		<cfargument name="classe_toxica" required="no" default=""/>
		<cfargument name="grupo_nome" required="no" default=""/>
		<cfargument name="sigla_uf" required="no" default=""/>
		<cfargument name="empresa_registrante" required="no" default=""/>
		<cfargument name="num_registro" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select iu.insumo_id,
				   iu.sigla_uf,
				   iu.marca_id,
				   iu.cod_classe_uso,
				   iu.cod_unidade,
				   iu.num_registro,
				   iu.empresa_registrante,
				   iu.classe_toxica,
				   iu.ingrediente_ativo_id,
				   iu.grupo_quimico_id,
				   im.descricao as marcadescricao,
				   cu.nome as classenome,
				   ia.nome as ingredientenome,
				   gq.nome as gruponome				   
			  from granex.v$insumos iu
			  	   inner join granex.v$insumos_marca im 
				   			on iu.marca_id = im.marca_id
				   inner join granex.v$insumos_classe_uso cu 
				   			on iu.cod_classe_uso = cu.cod_classe_uso
				   inner join granex.v$insumos_ingrediente_ativo ia 
				   			on iu.ingrediente_ativo_id = ia.ingrediente_ativo_id
				   inner join granex.v$insumos_grupo_quimico gq 
				   			on iu.grupo_quimico_id = gq.grupo_quimico_id
			 where 1 = 1
			 <cfif Len(Trim(arguments.insumo_id))>
			   and iu.insumo_id = '#arguments.insumo_id#'
			 </cfif>
			 <cfif Len(Trim(arguments.marca_descricao))>
			   and upper(im.descricao) like upper('%#arguments.marca_descricao#%')
			 </cfif>
			 <cfif Len(Trim(arguments.classe_nome))>
			   and upper(cu.nome) like upper('%#arguments.classe_nome#%')
			 </cfif>
			 <cfif Len(Trim(arguments.ingrediente_nome))>
			   and upper(ia.nome) like upper('%#arguments.ingrediente_nome#%')
			 </cfif>
			 <cfif Len(Trim(arguments.classe_toxica))>
			   and iu.classe_toxica = '#arguments.classe_toxica#'
			 </cfif>
			 <cfif Len(Trim(arguments.grupo_nome))>
			   and upper(gq.nome) like upper('%#arguments.grupo_nome#%')
			 </cfif>
			 <cfif Len(Trim(arguments.sigla_uf))>
			   and iu.sigla_uf = '#arguments.sigla_uf#'
			 </cfif>
			 <cfif Len(Trim(arguments.empresa_registrante))>
			   and upper(iu.empresa_registrante) like upper('%#arguments.empresa_registrante#%')
			 </cfif>
			 <cfif Len(Trim(arguments.num_registro))>
			   and upper(iu.num_registro) like upper('%#arguments.num_registro#%')
			 </cfif>
			 order by im.descricao
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca as marcas de insumos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 22/11/2006 - criado
	--->	
	<cffunction name="get_insumos_marca" displayname="Busca as marcas de insumos." access="remote" returntype="query" output="true">
		<cfargument name="marca_id" required="no" default=""/>
		<cfargument name="descricao" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select marca_id,
				   descricao
			  from granex.v$insumos_marca
			 where 1 = 1
			 <cfif Len(Trim(arguments.marca_id))>
			   and marca_id = '#arguments.marca_id#'
			 </cfif>
			 <cfif Len(Trim(arguments.descricao))>
			  and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
			 order by descricao
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca as classes de uso de insumos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 23/11/2006 - criado
	--->	
	<cffunction name="get_insumos_classe_uso" displayname="Busca as classes de uso de insumos." access="remote" returntype="query" output="true">
		<cfargument name="cod_classe_uso" required="no" default=""/>
		<cfargument name="nome" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_classe_uso,
				   nome
			  from granex.v$insumos_classe_uso
			 where 1 = 1
			 <cfif Len(Trim(arguments.cod_classe_uso))>
			   and upper(cod_classe_uso) = upper('#arguments.cod_classe_uso#')
			 </cfif>
			 <cfif Len(Trim(arguments.nome))>
			  and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			 order by nome
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os grupos qumicos de insumos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 23/11/2006 - criado
	--->	
	<cffunction name="get_insumos_grupo_quimico" displayname="Busca os grupos qumicos de insumos." access="remote" returntype="query" output="true">
		<cfargument name="grupo_quimico_id" required="no" default=""/>
		<cfargument name="nome" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select grupo_quimico_id,
				   nome
			  from granex.v$insumos_grupo_quimico
			 where 1 = 1
			 <cfif Len(Trim(arguments.grupo_quimico_id))>
			   and grupo_quimico_id = '#arguments.grupo_quimico_id#'
			 </cfif>
			 <cfif Len(Trim(arguments.nome))>
			  and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			 order by nome
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os ingredientes ativos de insumos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 23/11/2006 - criado
	--->	
	<cffunction name="get_insumos_ingrediente_ativo" displayname="Busca os ingredientes ativos de insumos." access="remote" returntype="query" output="true">
		<cfargument name="ingrediente_ativo_id" required="no" default=""/>
		<cfargument name="nome" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select ingrediente_ativo_id,
				   nome
			  from granex.v$insumos_ingrediente_ativo
			 where 1 = 1
			 <cfif Len(Trim(arguments.ingrediente_ativo_id))>
			   and ingrediente_ativo_id = '#arguments.ingrediente_ativo_id#'
			 </cfif>
			 <cfif Len(Trim(arguments.nome))>
			  and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			 order by nome
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca as UFs
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 23/11/2006 - criado
	--->	
	<cffunction name="get_uf" displayname="Busca as UFs." access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select sigla_uf,
				   nome_uf,
				   cod_uf
			from cep_ufs
		order by sigla_uf
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os registros de plantio
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 06/12/2006 - criado
	--->	
	<cffunction name="get_plantio" displayname="Busca os registros de plantio." access="remote" returntype="query" output="true">
		<cfargument name="item_id" required="no" default="">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="industria" required="no" default="">
		<cfargument name="produto" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="propriedade" required="no" default="">
		<cfargument name="localizacao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cp.item_id,
				   to_char(cp.data, 'dd/mm/yyyy') data_char,
				   cp.tempo_dias,
                   cp.data_dessecacao,
				   to_char(cp.data_dessecacao, 'dd/mm/yyyy') data_dessecacao_char,
				   cp.estimativa_producao,
				   cp.cod_unidade,
				   cr.contrato_id,
				   co.cod_pessoa_industria,
				   pj.razao_social as industria_nome,
				   co.produto_id,
				   cu.nome as produto_nome,
				   lo.localizacao_id,
				   lo.nome as localizacao_nome,
				   pr.propriedade_id,
				   pr.cod_pessoa_proprietario,
				   pr.nome as propriedade_nome,
				   pe.cliente as proprietario_nome
			  from granex.v$contrato_plantio cp
			 inner join granex.v$contrato_produtor cr
				   on cp.item_id = cr.item_id
			 inner join granex.v$contrato co
				   on cr.contrato_id = co.contrato_id
			 inner join kss.v$pessoa_juridica pj
				   on pj.cod_pessoa = co.cod_pessoa_industria
			 inner join granex.v$cultura cu
				   on cu.cultura_id = co.produto_id
			 inner join granex.v$localizacao lo
				   on lo.localizacao_id = cr.localizacao_id
			 inner join granex.v$propriedade pr
				   on pr.propriedade_id = lo.propriedade_id
			 inner join kss.v$pessoa pe
				   on pe.cod_pessoa = pr.cod_pessoa_proprietario
			 where 1 = 1			 
			<cfif Len(Trim(arguments.item_id))>
			   and cp.item_id = '#arguments.item_id#'
			</cfif>
			<cfif Len(Trim(arguments.contrato_id))>
			   and co.contrato_id = '#arguments.contrato_id#'
			</cfif>
			<cfif Len(Trim(arguments.industria))>
			   and upper(pj.razao_social) like upper('%#arguments.industria#%')
			</cfif>
			<cfif Len(Trim(arguments.produto))>
			   and upper(cu.nome) like upper('%#arguments.produto#%')
			</cfif>
			<cfif Len(Trim(arguments.proprietario))>
			   and upper(pe.cliente) like upper('%#arguments.proprietario#%')
			</cfif>
			<cfif Len(Trim(arguments.propriedade))>
			   and upper(pr.nome) like upper('%#arguments.propriedade#%')
			</cfif>
			<cfif Len(Trim(arguments.localizacao))>
			   and upper(lo.nome) like upper('%#arguments.localizacao#%')
			</cfif>
			order by cp.data
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os tipos de aplicao
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 07/12/2006 - criado
	--->	
	<cffunction name="get_tipo_aplicacao" displayname="Busca os grupos qumicos de insumos." access="remote" returntype="query" output="true">
		<cfargument name="tipo_aplicacao_id" required="no" default=""/>
		<cfargument name="descricao" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select tipo_aplicacao_id,
				   descricao,
				   cor,
				   url_imagem
			  from granex.v$tipo_aplicacao
			 where 1 = 1
			 <cfif Len(Trim(arguments.tipo_aplicacao_id))>
			   and tipo_aplicacao_id = '#arguments.tipo_aplicacao_id#'
			 </cfif>
			 <cfif Len(Trim(arguments.descricao))>
			  and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
			 order by descricao
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO  
	-- Busca os agrnomos
	-- NOTAS EXPLICATIVAS
	-- arlen 07/12/2006 - criado
	--->	
	<cffunction name="get_agronomos" displayname="Busca os agrnomos." access="remote" returntype="query" output="true">
			<cfargument name="num_modalidade" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select pe.cod_pessoa, 
					   pe.cliente
				  from kss.v$pessoa pe
				 inner join kss.v$pessoa_modalidade pm on pm.cod_pessoa = pe.cod_pessoa
				 where 1 = 1
				<cfif Len(Trim(arguments.num_modalidade))> 
					and pm.num_modalidade = '#arguments.num_modalidade#'
				</cfif>
				 order by pe.cliente				
			</cfquery>
	    <cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca os registros de aplicao
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 07/12/2006 - criado
	--->	
	<cffunction name="get_aplicacao" displayname="Busca os registros de aplicao." access="remote" returntype="query" output="true">
		<cfargument name="aplicacao_id" required="no" default="">
		<cfargument name="item_id" required="no" default="">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="industria" required="no" default="">
		<cfargument name="produto" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="propriedade" required="no" default="">
		<cfargument name="localizacao" required="no" default="">
		<cfargument name="agronomo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select ca.aplicacao_id,
				   ca.item_id,
				   ca.tipo_aplicacao_id,
				   to_char(ca.data, 'dd/mm/yyyy') data_char,
				   ca.data,
				   ca.cod_pessoa_agronomo,
				   ca.descricao,
                   to_char(granex.pkg_granex.fnc_get_aplicacao_descricao(ca.aplicacao_id)) descricao_infograma,
           		   ta.descricao as descricao_tipo,
				   cr.contrato_id,
				   co.cod_pessoa_industria,
				   pj.razao_social as industria_nome,
				   co.produto_id,
				   cu.nome as produto_nome,
				   lo.localizacao_id,
				   lo.nome as localizacao_nome,
				   pr.propriedade_id,
				   pr.cod_pessoa_proprietario,
				   pr.nome as propriedade_nome,
				   pe.cliente as proprietario_nome,
                   pf.nome as agronomo_nome,
				   ca.numero_dias,
				   ta.url_imagem,
				   ta.cor
			  from granex.v$contrato_aplicacao ca
             inner join granex.v$tipo_aplicacao ta
				   on ta.tipo_aplicacao_id = ca.tipo_aplicacao_id
			 inner join granex.v$contrato_produtor cr
				   on ca.item_id = cr.item_id
			 inner join granex.v$contrato co
				   on cr.contrato_id = co.contrato_id
			 inner join kss.v$pessoa_juridica pj
				   on pj.cod_pessoa = co.cod_pessoa_industria
			 inner join granex.v$cultura cu
				   on cu.cultura_id = co.produto_id
			 inner join granex.v$localizacao lo
				   on lo.localizacao_id = cr.localizacao_id
			 inner join granex.v$propriedade pr
				   on pr.propriedade_id = lo.propriedade_id
			 inner join kss.v$pessoa pe
				   on pe.cod_pessoa = pr.cod_pessoa_proprietario
             inner join kss.v$pessoa_fisica pf
				   on pf.cod_pessoa = ca.cod_pessoa_agronomo
			 where 1 = 1			 
			<cfif Len(Trim(arguments.item_id))>
			   and ca.item_id = #arguments.item_id#
			</cfif>
			<cfif Len(Trim(arguments.aplicacao_id))>
			   and ca.aplicacao_id = '#arguments.aplicacao_id#'
			</cfif>
			<cfif Len(Trim(arguments.contrato_id))>
			   and co.contrato_id = '#arguments.contrato_id#'
			</cfif>
			<cfif Len(Trim(arguments.industria))>
			   and upper(pj.razao_social) like upper('%#arguments.industria#%')
			</cfif>
			<cfif Len(Trim(arguments.produto))>
			   and upper(cu.nome) like upper('%#arguments.produto#%')
			</cfif>
			<cfif Len(Trim(arguments.proprietario))>
			   and upper(pe.cliente) like upper('%#arguments.proprietario#%')
			</cfif>
			<cfif Len(Trim(arguments.propriedade))>
			   and upper(pr.nome) like upper('%#arguments.propriedade#%')
			</cfif>
			<cfif Len(Trim(arguments.localizacao))>
			   and upper(lo.nome) like upper('%#arguments.localizacao#%')
			</cfif>
			<cfif Len(Trim(arguments.agronomo))>
			   and upper(pf.nome) like upper('%#arguments.agronomo#%')
			</cfif>
			order by ca.data
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	

	<!--- 
	-- PROPSITO 
	-- Busca o produtor do contrato
	-- CRISTOFER  02/01/2007
	--->		
	<cffunction name="get_contrato_produtor" access="remote" returntype="query" output="true">
		<cfargument name="item_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cp.contrato_id,
				   ct.produto_id,
				   cl.nome cultura,
				   cp.localizacao_id,
				   lc.codigo cod_localizacao,
				   lc.nome localizacao,
				   pp.nome propriedade,
				   cp.area_metros,
				   cp.estimativa_producao,
                   cpl.data_dessecacao,
				   cp.user_insert,
				   cp.date_insert,
				   cp.user_update,
				   cp.date_update,
				   cp.site,
				   cp.item_id,
				   pp.cod_pessoa_proprietario,
				   p.cliente proprietario,
				   cpl.data data_plantio,
				   cpl.tempo_dias,
				   cpl.data + cpl.tempo_dias data_colheita
			  from granex.v$contrato_produtor cp
			 inner join granex.v$contrato_plantio cpl
					 on cpl.item_id = cp.item_id
			 inner join granex.v$contrato ct
					 on ct.contrato_id = cp.contrato_id
			 inner join granex.v$cultura cl
					 on cl.cultura_id = ct.produto_id
			 inner join granex.v$localizacao lc
					 on lc.localizacao_id = cp.localizacao_id
			 inner join granex.v$propriedade pp
					 on pp.propriedade_id = lc.propriedade_id
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = pp.cod_pessoa_proprietario
		     where 1=1
			<cfif len(trim(arguments.item_id))>
			   and cp.item_id in (#arguments.item_id#)
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as imagens de propriedades
	-- LOUIS  14/03/2007
	--->		
	<cffunction name="get_foto" access="remote" returntype="query" output="true">
		<cfargument name="foto_id" required="no" default="">
		<cfargument name="filtro" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select f.foto_id,
				   f.date_insert,
				   f.user_insert,
				   f.date_update,
				   f.user_update,
				   f.site,
				   f.descricao,
				   f.url_imagem
			  from granex.v$foto f
			  where 1=1
			 <cfif len(trim(arguments.foto_id))>
			   and f.foto_id = #arguments.foto_id#
			 </cfif> 		
			 <cfif len(trim(arguments.filtro))>
			   and 
			     (  upper(f.descricao) like upper('#arguments.filtro#')) 
				 </cfif>	 
			 order by f.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
    	<!--- 
	-- PROPSITO 
	-- Busca as imagens do filme
	-- CRISTOFER  06/03/2007
	--->		
	<cffunction name="get_propriedade_imagem" access="remote" returntype="query" output="true">
		<cfargument name="propriedade_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cfi.propriedade_id,
				   cfi.foto_id,
				   cfi.date_insert,
				   cfi.user_insert,
				   cfi.date_update,
				   cfi.user_update,
				   cfi.site,
				   f.descricao,
				   f.url_imagem
			  from granex.v$propriedade_imagem cfi
			 inner join granex.v$foto f
			         on f.foto_id = cfi.foto_id
			 where 1=1
			 <cfif len(trim(arguments.propriedade_id))>
			   and cfi.propriedade_id = #arguments.propriedade_id#
			 </cfif>
			 order by f.descricao 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	

	<!--- 
	-- PROPSITO 
	-- Busca as unidades cadastradas
	-- CRISTOFER  10/07/2007
	--->		
	<cffunction name="get_unidade_aplicacao" access="remote" returntype="query" output="true">
    	<cfargument name="unidade_id" required="no" default="">
    	<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select unidade_id,
                   descricao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from granex.v$unidade
             where 1=1
             <cfif len(trim(arguments.unidade_id))>
               and unidade_id = #arguments.unidade_id#
             </cfif>
             <cfif len(trim(arguments.descricao))>
               and upper(trim(kss.pkg_string.fnc_string_clean(descricao))) = upper(trim(kss.pkg_string.fnc_string_clean('%#arguments.descricao#%')))
             </cfif>
             order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca os insumos da aplicacao
	-- CRISTOFER  10/07/2007
	--->		
	<cffunction name="get_aplicacao_insumo" access="remote" returntype="query" output="true">
    	<cfargument name="aplicacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select aplicacao_id,
            	   insumo_id,
                   quantidade,
                   unidade_id
              from granex.v$contrato_aplicacao_insumo
             where 1=1
            <cfif len(trim(arguments.aplicacao_id))>
               and aplicacao_id = #arguments.aplicacao_id#
            </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

</cfcomponent>