<cfcomponent displayname="Controle de Gesto de Avarias" extends="_transportes.funcoes.cfc_init">

	<!---
	-- PROPSITO
	-- Retorna Avaria
	-- NOTAS EXPLICATIVAS
	-- CRIADO
	--->
		
	<cffunction name="get_avaria" displayname="Retorna avaria" output="true" returntype="query" access="remote">
		<cfargument name='AVARIA_ID' required='false' default="">
		<cfargument name='DATA_HORA' required='false' default="">
        <cfargument name='UNIDADE_NEGOCIO' required='false' default="">
		<cfargument name='COD_PESSOA_FILIAL' required='false' default="">
        <cfargument name='COD_UNIDADE_NEGOCIO' required='false' default="">
		<cfargument name='COD_CENTRO_CUSTO' required='false' default="">
		<cfargument name='CONHECIMENTO_ID' required='false' default="">
        <cfargument name='NUM_CONHECIMENTO' required='false' default="">
		<cfargument name='PLACA' required='false' default="">
		<cfargument name='PLACA_CARRETA' required='false' default="">
		<cfargument name='COD_REMETENTE' required='false' default="">
        <cfargument name='REM_CNPJ_CPF' required='false' default="">
		<cfargument name='REM_RAZAO_SOCIAL' required='false' default="">
		<cfargument name='COD_DESTINATARIO' required='false' default=""> 
        <cfargument name='DEST_CNPJ_CPF' required='false' default="">   
        <cfargument name='DEST_NOME' required='false' default=""> 
        <cfargument name='REM_NOME' required='false' default="">         
		<cfargument name='DEST_RAZAO_SOCIAL' required='false' default="">        
		<cfargument name='MERCADORIA' required='false' default="">
		<cfargument name='QTDE_TRANSPORTADA' required='false' default="">
		<cfargument name='NF_ORIGEM' required='false' default="">
		<cfargument name='NF_VALOR' required='false' default="">
		<cfargument name='NF_PESO' required='false' default="">
		<cfargument name='OBSERVACAO' required='false' default="">
		<cfargument name='DESCRICAO' required='false' default="">
		<cfargument name='QTDE_AVARIADA' required='false' default="">
		<cfargument name='VALOR_AVARIA' required='false' default="">
		<cfargument name='COD_MOEDA' required='false' default="">
        <cfargument name='CRT_CONHECIMENTO_ID' required='false' default="">
		<cfargument name='VALOR_AVARIA_MOEDA' required='false' default="">
		<cfargument name='CAUSA_PROVAVEL' required='false' default="">
		<cfargument name='SUGESTAO_ACAO' required='false' default="">
		<cfargument name='RESPONSAVEL' required='false' default="">
		<cfargument name='EMITENTE' required='false' default="">
		<cfargument name='CARGO' required='false' default="">
		<cfargument name='SITUACAO' required='false' default="">   
        <cfargument name='DATA_ENTRADA' required='false' default="">
        <cfargument name='DATA_SAIDA' required='false' default="">
        <cfargument name='NF_VALOR_MOEDA' required='false' default="">
        <cfargument name='NF_COD_MOEDA' required='false' default="">
        <cfargument name='RECUPERACAO' required='false' default="">        
 		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         	   select a.avaria_id,
               to_char(a.data_hora) as data_hora,
               a.placa,
               a.crt_conhecimento_id,
               a.placa_carreta,
               a.mercadoria,
               a.qtde_transportada,
               a.nf_origem,
               a.nf_peso,
               ic.num_crt_completo as num_crt ,
               nvl(ic.num_crt_completo , c.num_conhecimento) as num_conhecimento_tela,
               a.nf_valor,
               a.nf_valor_moeda,
               a.nf_cod_moeda,
               a.observacao,
               a.descricao,
               a.qtde_avariada,
               a.valor_avaria,
               a.valor_avaria_moeda,
               a.cod_moeda,
               a.recuperacao,
               a.causa_provavel,
               a.sugestao_acao,
               a.responsavel,
               a.emitente,
               a.cargo,
               a.situacao,
               a.placa as placa_carreta,
               a.cod_remetente,
               a.cod_destinatario,
               a.conhecimento_id,
               a.cod_centro_custo,
               cc.centro_custo,
               u.cod_unidade_negocio,
               u.unidade_negocio,
               u.cod_pessoa as cod_pessoa_filial,
               v.marca,
               v.modelo,
               c.serie,
               c.num_conhecimento,
               pr.CNPJ_CPF as  rem_cnpj_cpf,
               pr.RAZAO_SOCIAL as rem_nome,
               pd.CNPJ_CPF as dest_cnpj_cpf,
               pd.RAZAO_SOCIAL as dest_nome,
               (select v.marca
                  from oper.v$veiculo_dados v
                 where v.placa = a.placa_carreta) as marca_carreta,
               (select v.modelo
                  from oper.v$veiculo_dados v
                 where v.placa = a.placa_carreta) as modelo_carreta
          from oper.v$avaria a
          inner join kss.v$pessoa pr
                  on pr.cod_pessoa = a.cod_remetente
          inner join kss.v$pessoa pd
                  on pd.cod_pessoa = a.cod_destinatario
          inner join kss.v$unidade_negocio u 
                  on u.cod_pessoa = a.cod_pessoa_filial
          inner join kss.v$centro_custo cc 
                  on cc.cod_centro_custo = a.cod_centro_custo
          left join oper.v$veiculo_dados v on v.placa = a.placa
          left join fiscal.v$conhecimento c 
                 on c.conhecimento_id = a.conhecimento_id
          left join fiscal.v$intc_conhecimento ic
                 on ic.conhecimento_id = a.crt_conhecimento_id
         where 1 = 1
        	<cfif Len(Trim(arguments.AVARIA_ID))>
			   and a.avaria_id = #arguments.AVARIA_ID#
			</cfif>  
            <cfif Len(Trim(arguments.PLACA))>
            	and upper(a.placa) like upper('%#arguments.PLACA#%')
			</cfif>          
			<cfif len(trim(arguments.DATA_ENTRADA))>
            	and trunc(a.data_hora) >= '#arguments.DATA_ENTRADA#'
       		</cfif>
       		<cfif len(trim(arguments.DATA_SAIDA))>
          		and trunc(a.data_hora) <= '#arguments.DATA_SAIDA#'
       		</cfif>
            <cfif Len(Trim(arguments.NUM_CONHECIMENTO))>
			   and c.num_conhecimento = #arguments.NUM_CONHECIMENTO#
			</cfif>
            <cfif Len(Trim(arguments.REM_CNPJ_CPF))>
			   and c.rem_cnpj_cpf = #arguments.REM_CNPJ_CPF#
			</cfif>
            <cfif Len(Trim(arguments.REM_NOME))>
            	and upper(c.rem_razao_social) like upper('%#arguments.REM_NOME#%')
			</cfif>
            <cfif Len(Trim(arguments.DEST_CNPJ_CPF))>
			   and c.dest_cnpj_cpf = #arguments.DEST_CNPJ_CPF#
			</cfif>
            <cfif Len(Trim(arguments.DEST_NOME))>
			   and upper(c.dest_razao_social) like upper('%#arguments.DEST_NOME#%')
			</cfif>
        </cfquery>
		<cfreturn qr_result>
	</cffunction> 
    
    <!---                         
	--          PROPSITO         
	-- Retorna Historio de avaria 
	-- NOTAS EXPLICATIVAS         
	--        CRIADO          --->
		
	<cffunction name="get_avaria_historico" displayname="Retorna Historico de avaria" output="true" returntype="query" access="remote">
        <cfargument name="avaria_id" required="false">
        <cfargument name="historico" required="false">
        <cfargument name="historico_id" required="false">
        <cfargument name="user_insert" required="false">
        <cfargument name="user_update" required="false">
        <cfargument name="date_insert" required="false">
        <cfargument name="date_update" required="false">        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        
        select 	ah.avaria_id,
        		ah.historico_id,
				ah.historico,
			    ah.user_insert,
         		to_char(ah.date_insert) as date_insert,
        		ah.user_update,
         		to_char(ah.date_update) as date_update
		from oper.v$avaria_historico ah
		inner join oper.v$avaria a
       		on a.avaria_id = ah.avaria_id
	    where 1 = 1
         <cfif isDefined("arguments.avaria_id")>
			   and ah.avaria_id = #arguments.avaria_id#
		 </cfif>
        
        </cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca Conhecimentos
	-- CRIADO
	--->
	
	<cffunction name="get_conhecimento_serie" displayname="Busca serie de conhecimentos" access="remote" returntype="query" output="true">
		<cfargument name="num_conhecimento" required="false">
        <cfargument name="conhecimento_id" required="false">
        <cfargument name="cod_pessoa_filial" required="false">
		<cfargument name="serie" required="false">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      		select c.conhecimento_id
                 , c.num_conhecimento
                 , c.serie
              from fiscal.v$conhecimento c
       		 where 1=1
			 <cfif isDefined("arguments.num_conhecimento")>
			   and c.num_conhecimento = #arguments.num_conhecimento#
			 </cfif>
             <cfif isDefined("arguments.cod_pessoa_filial")>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
		</cfquery>			
		<cfreturn qr_result>
     </cffunction>
     
    	<!--- 
	-- PROPSITO
	-- Busca CRT
	-- CRIADO
	--->
	
	<cffunction name="get_crt_conhecimento" displayname="Busca serie de conhecimentos" access="remote" returntype="query" output="true">
		<cfargument name="crt_conhecimento" required="false" default="">
        <cfargument name="crt_conhecimento_id" required="false" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      		select ic.conhecimento_id
                 from fiscal.v$intc_conhecimento_form ic
            where 1=1
            <cfif Len(Trim(arguments.crt_conhecimento))>
				and ic.campo02 = '#arguments.crt_conhecimento#'
            </cfif>
		</cfquery>			
		<cfreturn qr_result>
     </cffunction>
     
     <!--- 
    -- PROPSITO 
    -- Busca os dados de uma avaria para impresso
    -- ANDERSON 31/08/2009 - CRIADO
    --->		
    <cffunction name="get_avaria_print" access="remote" returntype="query" output="true">
        <cfargument name="avaria_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.avaria_id
                 , (select p.cliente || ', ' || to_char(a.date_insert, 'dd/mm/yyyy')
                      from kss.v$kss_usuario_lotacao ul
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = ul.cod_pessoa
                     where ul.usuario = a.user_insert
                       and rownum = 1) as local_data
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = a.cod_pessoa_filial) as filial_remetente
                 , case
                      when a.conhecimento_id is not null then
                         (select c.num_conhecimento || '-' || c.serie
                            from fiscal.v$conhecimento c
                           where c.conhecimento_id = a.conhecimento_id)
                      when a.crt_conhecimento_id is not null then
                         (select c.num_crt_completo
                            from fiscal.v$intc_conhecimento c
                           where c.conhecimento_id = a.crt_conhecimento_id)
                      else ''
                   end as conhecimento_origem
                 , to_char(a.data_hora, 'dd/mm/yyyy') as data_avaria
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = a.cod_remetente) as cliente_remetente
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = a.cod_destinatario) as cliente_destinatario
                 , nvl2(a.placa_carreta, a.placa || '/' || a.placa_carreta, a.placa) as veiculo_placa
                 , a.mercadoria
                 , a.qtde_transportada
                 , a.nf_origem
                 , (select m.moeda || ' ' || to_char(a.nf_valor_moeda, 'FM9G9999G990D00', 'nls_numeric_characters=,.')
                      from finan.v$moeda_bacen m
                     where m.cod_moeda = a.nf_cod_moeda) as nf_valor
                 , to_char(a.nf_peso, 'FM9G9999G990D000', 'nls_numeric_characters=,.') as nf_peso
                 , a.qtde_avariada
                 , a.descricao
                 , a.causa_provavel
                 , a.responsavel
                 , a.sugestao_acao
                 , (select m.moeda || ' ' || to_char(a.valor_avaria, 'FM9G9999G990D00', 'nls_numeric_characters=,.')
                      from finan.v$moeda_bacen m
                     where m.cod_moeda = a.cod_moeda) as valor_avaria
                 , a.observacao
                 , (select kss.fnc_concat_all(to_concat_expr(ap.nf_cobranca, ', '))
                      from oper.v$avaria_pagamento ap
                     where ap.avaria_id = a.avaria_id) as nf_cobranca
                 , (select 'R$ ' || to_char(ar.valor_recuperacao, 'FM9G9999G990D00', 'nls_numeric_characters=,.')
                      from oper.v$avaria_recuperacao ar
                     where ar.avaria_id = a.avaria_id) as valor_recuperado
                 , (select to_char(ar.data_venda, 'dd/mm/yyyy')
                      from oper.v$avaria_recuperacao ar
                     where ar.avaria_id = a.avaria_id) as data_venda
                 , (select ar.observacao
                      from oper.v$avaria_recuperacao ar
                     where ar.avaria_id = a.avaria_id) as observacao_recuperacao
                 , a.emitente
                 , a.cargo
              from oper.v$avaria a
             where a.avaria_id = #arguments.avaria_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<cffunction name="get_status_pendencias" displayname="Busca status das pendncias operacionais" access="remote" returntype="query" output="true">
		<cfargument name="status_pendencia_id" required="no" default="">
        <cfargument name="codigo" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
      		 select sp.status_pendencia_id,
                    sp.codigo,
                    sp.descricao,
                    sp.user_insert,
                    sp.date_insert,
                    sp.user_update,
                    sp.date_update        
              from oper.v$status_pendencia sp
            where 1=1
            <cfif Len(Trim(arguments.status_pendencia_id))>
				and sp.status_pendencia_id = '#arguments.status_pendencia_id#'
            </cfif>
            <cfif Len(Trim(arguments.codigo))>
				and sp.codigo like '%#arguments.codigo#%'
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
				and upper(sp.descricao) like upper('%#arguments.descricao#%')
            </cfif>
		</cfquery>			
		<cfreturn qr_result>
     </cffunction>
     
	<cffunction name="get_pendencia_operacional" displayname="Busca status das pendncias operacionais" access="remote" returntype="query" output="true">
		<cfargument name="pendencia_operacional_id" required="no" default="">
        <cfargument name="conhecimento_id" required="no" default="">  
        <cfargument name="num_conhecimento" required="no" default="">    	
		<cfargument name="cod_pedido" required="no" default="">
		<cfargument name="num_pedido" required="no" default="">
		<cfargument name="num_coleta" required="no" default="">
		<cfargument name="nota_fiscal" required="no" default=""> 
		<cfargument name="serie" required="no" default=""> 
        <cfargument name="data_inicio" required="no" default=""> 
        <cfargument name="data_termino" required="no" default=""> 
        <cfargument name="status_pendencia_id" required="no" default="">           	
        <cfargument name="cod_cliente" required="no" default="">              	
        <cfargument name="cod_remetente" required="no" default="">              	
        <cfargument name="cod_destinatario" required="no" default="">  
        <cfargument name="cod_pessoa_filial" required="no" default="">            	
        <cfargument name="cod_departamento" required="no" default="">            	
        <cfargument name="cod_setor" required="no" default="">              	
        <cfargument name="cod_centro_custo" required="no" default="">    
        <cfargument name="num_nota_fiscal" required="no" default=""> <!--- campo NUM_NOTA_FISCAL -> oper.v$pendencia_operacional --->
        <cfargument name="data_emissao_nf" required="no" default=""> 
        <cfargument name="serie_nf" required="no" default=""> 
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select conh.conhecimento_id
                     , conh.serie
                     , conh.num_conhecimento
                     , to_char(conh.data_emissao, 'dd/mm/yyyy') as data_emissao_ctrc                
                     , nvl(conh.rem_razao_social, kss.pkg_pessoa.fnc_get_cliente(p.COD_PESSOA_REM, 1)) as rem_razao_social
                     , nvl(conh.dest_razao_social, kss.pkg_pessoa.fnc_get_cliente(p.COD_PESSOA_DEST, 1)) as dest_razao_social
                     , nvl((select m.municipio || ' - ' || m.uf_id
                              from cep.municipio m
                             where conh.coleta_municipio_id = m.municipio_id), mori.municipio) as origem
                    , nvl((select m.municipio || ' - ' || m.uf_id
                             from cep.municipio m
                            where conh.entrega_municipio_id = m.municipio_id), mdest.municipio) as destino
                     , nvl((select kss.fnc_concat_all(distinct kss.to_concat_expr(cnf.numero, ', '))
                              from fiscal.v$conhecimento_nota_fiscal cnf
                             where cnf.conhecimento_id = conh.conhecimento_id
                               and cnf.numero is not null), p.num_nota_fiscal) as nota_fiscal
                     , nvl((select to_char(max(cnf.data_emissao), 'dd/mm/yyyy')
                              from fiscal.v$conhecimento_nota_fiscal cnf
                             where cnf.conhecimento_id = conh.conhecimento_id
                               and cnf.data_emissao is not null), to_char(p.data_emissao_nf, 'dd/mm/yyyy')) as data_emissao_nf
                     , p.pendencia_operacional_id
                     , p.conhecimento_id
                     , to_char(p.data_ocorrencia, 'dd/mm/yyyy') as data_ocorrencia  
                     , p.ocorrencia
                     , p.solucao_apontada
                     , p.status_pendencia_id
                     , sp.codigo || ' - ' || sp.descricao as status
                     , p.responsavel
                     , p.fone_ddd
                     , p.fone_prefixo
                     , p.fone_numero
                     , p.fone_ddd || ' ' || p.fone_prefixo || '-' || p.fone_numero as telefone
                     , to_char(p.data_finalizacao, 'dd/mm/yyyy') as data_finalizacao  
                     , p.serie as serie_nf
                     , p.COD_PESSOA_REM
                     , kss.pkg_pessoa.fnc_get_cliente(p.COD_PESSOA_REM, 1) as REM_NOME
                     , kss.pkg_pessoa.fnc_get_identificador(p.COD_PESSOA_REM, 0) as REM_CNPJ_CPF
                     , p.COD_PESSOA_DEST
                     , kss.pkg_pessoa.fnc_get_cliente(p.COD_PESSOA_DEST, 1) as DEST_NOME
                     , kss.pkg_pessoa.fnc_get_identificador(p.COD_PESSOA_DEST, 0) as DEST_CNPJ_CPF
                     , p.MUNICIPIO_ID_ORIGEM
                     , mori.uf_id as ORIGEM_UF
                     , p.MUNICIPIO_ID_DESTINO
                     , mdest.uf_id as DESTINO_UF
                     , p.user_insert
                     , p.date_insert
                     , p.user_update
                     , p.date_update
                     , p.site
                  from oper.v$pendencia_operacional p
                  left join fiscal.v$conhecimento conh
                    on conh.conhecimento_id  = p.conhecimento_id
                 inner join oper.v$status_pendencia sp
                    on sp.status_pendencia_id = p.status_pendencia_id               
                  left join cep.v$municipio mori
                    on mori.municipio_id = p.MUNICIPIO_ID_ORIGEM
                  left join cep.v$municipio mdest
                    on mdest.municipio_id = p.MUNICIPIO_ID_DESTINO
                 where 1 = 1
                   and (((conh.modelo_documento = '08' or conh.modelo_documento is null) 
             		  <cfif len(trim(arguments.cod_pessoa_filial))>	                             
                      	and conh.cod_pessoa_filial = '#arguments.cod_pessoa_filial#' 
                      </cfif>    
                      <cfif len(trim(arguments.cod_departamento))>	                 
                      	and conh.cod_departamento = '#arguments.cod_departamento#'  
                      </cfif> 
                      <cfif len(trim(arguments.cod_setor))>	                     
                      	and conh.cod_setor = '#arguments.cod_setor#'                      
                      </cfif> 
                      <cfif len(trim(arguments.cod_centro_custo))>	 
                      	and conh.cod_centro_custo = '#arguments.cod_centro_custo#' 
                      </cfif>                      
                     ) or
                     (conh.modelo_documento = '57'
                     <cfif len(trim(arguments.cod_pessoa_filial))>	  
                     	and conh.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
                     </cfif> 
                     )
                	)
            <cfif Len(Trim(arguments.pendencia_operacional_id))>
				and p.pendencia_operacional_id = '#arguments.pendencia_operacional_id#'
            </cfif>
            <cfif len(trim(arguments.conhecimento_id))>
                and p.conhecimento_id = #arguments.conhecimento_id#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
				and p.data_ocorrencia >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_termino))>
				and p.data_ocorrencia <= '#arguments.data_termino#'
            </cfif>            
            <cfif Len(Trim(arguments.status_pendencia_id))>
				and p.status_pendencia_id = '#arguments.status_pendencia_id#'
            </cfif> 
             <cfif len(trim(arguments.num_conhecimento))>
                and conh.num_conhecimento = #arguments.num_conhecimento#
             </cfif>  
             <cfif len(trim(arguments.cod_cliente))>
                and conh.cod_cliente_cobranca = #arguments.cod_cliente#
             </cfif>             
             <cfif len(trim(arguments.serie))>
                and conh.serie = '#arguments.serie#'
             </cfif>                   
             <cfif len(trim(arguments.cod_remetente))>
                and (conh.cod_remetente = '#arguments.cod_remetente#' or p.COD_PESSOA_REM = '#arguments.cod_remetente#')
             </cfif>              
             <cfif len(trim(arguments.cod_destinatario))>
                and (conh.cod_destinatario = '#arguments.cod_destinatario#' or p.COD_PESSOA_DEST = '#arguments.cod_destinatario#')
             </cfif>       
             <cfif len(trim(arguments.num_pedido))>
			   and exists (select 1
                              from oper.v$coleta ct
                                  inner join oper.v$carga_ctrc cc
                                     on cc.carga_id = ct.carga_id
                            where cc.conhecimento_id = conh.conhecimento_id
                              and ct.num_pedido = '#arguments.num_pedido#'
               			  )
             </cfif>
             <cfif len(trim(arguments.cod_pedido))>
                and exists (select 1
                             from fiscal.v$conhecimento_nota_fiscal cnf
                            where cnf.conhecimento_id = conh.conhecimento_id
                              and cnf.ordem_compra_cliente = '#arguments.cod_pedido#'
               			  )
			 </cfif>
             <cfif len(trim(arguments.num_coleta))>
			   and exists (select 1
                             from oper.v$carga_ctrc cc
                            inner join oper.v$coleta col
                            	    on col.carga_id = cc.carga_id
                            where cc.conhecimento_id = conh.conhecimento_id
                              and col.num_coleta = #arguments.num_coleta#
               			  )
			 </cfif>
             <cfif len(trim(arguments.nota_fiscal))>                
                and exists (select 1
                             from fiscal.v$conhecimento_nota_fiscal cnf
                            where cnf.conhecimento_id = conh.conhecimento_id
                              and cnf.numero = #arguments.nota_fiscal#
               			  )
             </cfif>
             <cfif len(trim(arguments.num_nota_fiscal))>
                and p.num_nota_fiscal = #arguments.num_nota_fiscal#
             </cfif>
             <cfif len(trim(arguments.serie_nf))>                
                and p.serie = #arguments.serie_nf#
             </cfif>
             <cfif len(trim(arguments.data_emissao_nf))>                
                and p.data_emissao_nf = '#arguments.data_emissao_nf#'
             </cfif>
             order by p.pendencia_operacional_id, p.data_ocorrencia, p.status_pendencia_id
		</cfquery>
		<cfreturn qr_result>
     </cffunction>
     
	<!--- 
	-- PROPSITO 
	-- Busca as cargas
	-- CRISTOFER  26/10/2006
	--->		
	<cffunction name="get_conhecimento" access="remote" returntype="query" output="true">	
		<cfargument name="conhecimento_id" required="no" default="">  
        <cfargument name="num_conhecimento" required="no" default=""> 
		<cfargument name="cod_pedido" required="no" default="">
		<cfargument name="num_pedido" required="no" default="">
		<cfargument name="num_coleta" required="no" default="">
		<cfargument name="nota_fiscal" required="no" default=""> 
		<cfargument name="serie" required="no" default="">      	
        <cfargument name="cod_cliente" required="no" default="">        	
        <cfargument name="cod_remetente" required="no" default="">              	
        <cfargument name="cod_destinatario" required="no" default=""> 
        <cfargument name="cod_pessoa_filial" required="no" default="">            	
        <cfargument name="cod_departamento" required="no" default="">            	
        <cfargument name="cod_setor" required="no" default="">              	
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="busca_pendencias_operacionais" required="no" default="0">                                
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select conh.conhecimento_id
                 , conh.serie
                 , conh.num_conhecimento
                 , to_char(conh.data_emissao, 'dd/mm/yyyy') as data_emissao_ctrc                
                 , conh.rem_razao_social
                 , conh.dest_razao_social
                 , conh.cod_pessoa_filial
                 , conh.cod_departamento
                 , conh.cod_setor
                 , conh.cod_centro_custo
                 , (select m.municipio || ' - ' || m.uf_id
                      from cep.municipio m
                     where conh.coleta_municipio_id = m.municipio_id) as origem
                 , (select m.municipio || ' - ' || m.uf_id
                      from cep.municipio m
                     where conh.entrega_municipio_id = m.municipio_id) as destino  
            	 , (select kss.fnc_concat_all(distinct kss.to_concat_expr(cnf.numero, ', '))
                    from fiscal.v$conhecimento_nota_fiscal cnf
                   where cnf.conhecimento_id = conh.conhecimento_id
                     and cnf.numero is not null) as nota_fiscal
                 , (select to_char(max(cnf.data_emissao), 'dd/mm/yyyy')
                      from fiscal.v$conhecimento_nota_fiscal cnf
                     where cnf.conhecimento_id = conh.conhecimento_id
                       and cnf.data_emissao is not null) as data_emissao_nf
              from fiscal.v$conhecimento conh 
             where 1 = 1             
             and (((conh.modelo_documento = '08' or conh.modelo_documento is null) 
             		  <cfif len(trim(arguments.cod_pessoa_filial))>	                             
                      and conh.cod_pessoa_filial = '#arguments.cod_pessoa_filial#' 
                      </cfif>    
                      <cfif len(trim(arguments.cod_departamento))>	                 
                      and conh.cod_departamento = '#arguments.cod_departamento#'  
                      </cfif> 
                      <cfif len(trim(arguments.cod_setor))>	                     
                      and conh.cod_setor = '#arguments.cod_setor#'                      
                      </cfif> 
                      <cfif len(trim(arguments.cod_centro_custo))>	 
                      and conh.cod_centro_custo = '#arguments.cod_centro_custo#' 
                      </cfif>                      
                     ) or
                     (conh.modelo_documento = '57'
                     <cfif len(trim(arguments.cod_pessoa_filial))>	  
                      and conh.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
                      </cfif> 
                     )
                	)
             <cfif len(trim(arguments.conhecimento_id))>
                and conh.conhecimento_id = #arguments.conhecimento_id#
             </cfif> 
             <cfif len(trim(arguments.num_conhecimento))>
                and conh.num_conhecimento = #arguments.num_conhecimento#
             </cfif>  
             <cfif len(trim(arguments.cod_cliente))>
                and conh.cod_cliente_cobranca = #arguments.cod_cliente#
             </cfif>             
             <cfif len(trim(arguments.serie))>
                and conh.serie = '#arguments.serie#'
             </cfif>             
             <cfif len(trim(arguments.cod_remetente))>
                and conh.cod_remetente = '#arguments.cod_remetente#'
             </cfif>              
             <cfif len(trim(arguments.cod_destinatario))>
                and conh.cod_destinatario = '#arguments.cod_destinatario#'
             </cfif>     
             <!---TRM--->        
             <cfif len(trim(arguments.cod_pedido))>
			   and exists (select 1
                              from oper.v$coleta ct
                                  inner join oper.v$carga_ctrc cc
                                     on cc.carga_id = ct.carga_id
                            where cc.conhecimento_id = conh.conhecimento_id
                              and ct.num_pedido = '#arguments.cod_pedido#'
               			  )
             </cfif>
             <cfif len(trim(arguments.num_pedido))>
                and exists (select 1
                             from fiscal.v$conhecimento_nota_fiscal cnf
                            where cnf.conhecimento_id = conh.conhecimento_id
                              and cnf.ordem_compra_cliente = '#arguments.num_pedido#'
               			  )
			 </cfif>
             <cfif len(trim(arguments.num_coleta))>
			   and exists (select 1
                             from oper.v$carga_ctrc cc
                            inner join oper.v$coleta col
                            	    on col.carga_id = cc.carga_id
                            where cc.conhecimento_id = conh.conhecimento_id
                              and col.num_coleta = #arguments.num_coleta#
               			  )
			 </cfif>
             <cfif len(trim(arguments.nota_fiscal))>                
                and exists (select 1
                             from fiscal.v$conhecimento_nota_fiscal cnf
                            where cnf.conhecimento_id = conh.conhecimento_id
                              and cnf.numero = #arguments.nota_fiscal#
               			  )
             </cfif>
             union
            select null as conhecimento_id
                 , p.serie as serie
                 , null as num_conhecimento
                 , null as data_emissao_ctrc
                 , kss.pkg_pessoa.fnc_get_cliente(p.COD_PESSOA_REM, 1) as rem_razao_social
                 , kss.pkg_pessoa.fnc_get_cliente(p.COD_PESSOA_DEST, 1) as dest_razao_social
                 , null as cod_pessoa_filial
                 , null as cod_departamento
                 , null as cod_setor
                 , null as cod_centro_custo
                 , mori.municipio as origem
                 , mdest.municipio as destino  
            	 , to_char(p.num_nota_fiscal) as nota_fiscal
                 , to_char(p.data_emissao_nf, 'dd/mm/yyyy') as data_emissao_nf
              from oper.v$pendencia_operacional p
              left join cep.v$municipio mori
                on mori.municipio_id = p.MUNICIPIO_ID_ORIGEM
              left join cep.v$municipio mdest
                on mdest.municipio_id = p.MUNICIPIO_ID_DESTINO
             where 1 = #arguments.busca_pendencias_operacionais#
               and p.conhecimento_id is null
             <cfif len(trim(arguments.nota_fiscal))>   
             	and p.num_nota_fiscal = #arguments.nota_fiscal#
             </cfif>
             <cfif len(trim(arguments.cod_remetente))>
                and p.COD_PESSOA_REM = '#arguments.cod_remetente#'
             </cfif>              
             <cfif len(trim(arguments.cod_destinatario))>
                and p.COD_PESSOA_DEST = '#arguments.cod_destinatario#'
             </cfif>     
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
</cfcomponent>