<cfcomponent extends="_transportes.funcoes.cfc_init">	
	<!--- 
	-- PROPSITO 
	-- Seleciona Aplicaes Locais que o usurio d suporte
	-- CRISTOFER  05/05/2006
	--->		
	<cffunction name="get_aplicacoes" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ap.cod_projeto, ap.cod_aplicacao, ap.nome_aplicacao
			  from kss.kss_aplicacao ap
		     inner join kss.kss_usuarios_suporte us
			         on us.cod_projeto   = ap.cod_projeto 	 
				    and us.cod_aplicacao = ap.cod_aplicacao
		     where us.tecnico_suporte     = user
         	   and ap.tipo_aplicacao_id   = 0
			   and exists( select 'x' 
			   				 from atualizador.v$registro_aplicacao ra
							where ra.cod_projeto   = ap.cod_projeto
							  and ra.cod_aplicacao = ap.cod_aplicacao )
		    <cfif IsNumeric(arguments.COD_PROJETO)>
		 	   and ap.cod_projeto = #arguments.cod_projeto# 
		    </cfif>                    
     	 	 order by ap.nome_aplicacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca os arquivos cadastrados
	-- CRISTOFER  03/08/2005
	--->		
	<cffunction name="get_controle_arquivos" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="codigo_sequencial" required="no" default="">
		<cfargument name="grupo" required="no" default="">
		<cfargument name="alias" required="no" default="">
		<cfargument name="funcionalidade" required="no" default="">
		<cfargument name="descricao_formulario" required="no" default="">
		<cfargument name="cod_arquivo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_arquivo,
				   caption_formulario,
				   nome_formulario,
				   nome_arquivo,
				   descricao_formulario,
				   funcionalidade_arquivo,
				   codigo_sequencial,
				   grupo,
				   alias,
				   c.cod_projeto,
				   p.nome_projeto
			  from internet.v$controle_arquivos c 
			 inner join kss.kss_projeto p
			         on p.cod_projeto = c.cod_projeto
			 where 1=1
			 <cfif len(trim(arguments.cod_projeto))>
			 	and c.cod_projeto = #arguments.cod_projeto# 
			 </cfif>
			 <cfif len(trim(arguments.codigo_sequencial))>
			 	and codigo_sequencial = #arguments.codigo_sequencial#
			 </cfif>
			 <cfif len(trim(arguments.grupo))>
			 	and grupo = #arguments.grupo#
			 </cfif>
			 <cfif len(trim(arguments.alias))>
			 	and alias = '#arguments.alias#'
			 </cfif>
			 <cfif len(trim(arguments.funcionalidade))>
			 	and funcionalidade_arquivo like '%#arguments.funcionalidade#%'
			 </cfif>
			 <cfif len(trim(arguments.descricao_formulario))>
			 	and descricao_formulario like '%#arguments.descricao_formulario#%'
			 </cfif>
			 <cfif len(trim(arguments.cod_arquivo))>
			 	and cod_arquivo = '#arguments.cod_arquivo#'
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>			 

	<!--- 
	-- PROPSITO 
	-- Busca os diretorios do servidor
	-- CRISTOFER  05/05/2003
	--->		
	<cffunction name="get_diretorio_servidor" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="" />
		<cfargument name="cod_aplicacao" required="no" default="" />
		<cfargument name="dir" required="no" default="" />
		<cfargument name="descricao" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ds.cod_projeto,ds.cod_aplicacao,ds.dir,ds.descricao,
				   internet.pkg_kss_web.fnc_nome_projeto(ds.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao( ds.cod_projeto, ds.cod_aplicacao ) nome_aplicacao
			  from  atualizador.dir_servidor ds
			 where exists( select 'x'
							 from kss.kss_usuarios_suporte ts
							where ts.cod_projeto     = ds.cod_projeto
							  and ts.cod_aplicacao   = ds.cod_aplicacao
							  and ts.tecnico_suporte = user )
			<cfif len(trim(arguments.cod_projeto))>
			  and ds.cod_projeto   = #val( arguments.cod_projeto )#
			</cfif>
			<cfif Len(Trim(arguments.cod_aplicacao))>
			  and ds.cod_aplicacao = '#arguments.cod_aplicacao#'
			</cfif>
			<cfif Len(Trim(arguments.dir))>
			  and ds.dir = '#arguments.dir#'
			</cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and instr( upper( ds.descricao ),upper('#Arguments.descricao#') )  <> 0 
			</cfif>
			order by internet.pkg_kss_web.fnc_nome_projeto(ds.cod_projeto ), internet.pkg_kss_web.fnc_nome_aplicacao( ds.cod_projeto, ds.cod_aplicacao), ds.dir, ds.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o diretorio raiz de atualizao dos usuarios
	-- CRISTOFER  05/05/2006
	--->		
	<cffunction name="get_diretorio_usuario" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="" />
		<cfargument name="cod_aplicacao" required="no"  default="" />
		<cfargument name="tecnico_suporte" required="no" default="" />			
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select du.cod_projeto,du.cod_aplicacao,du.dir_raiz,du.usuario,
				   du.dir_raiz ||'/' || du.cod_projeto || '/' || du.cod_aplicacao map_usuario,
				   internet.pkg_kss_web.fnc_nome_projeto(du.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao(du.cod_projeto,du.cod_aplicacao ) nome_aplicacao
			  from atualizador.dir_usuario du 				   
			 where exists( select 'x'
							 from kss.kss_usuarios_suporte ts
							where ts.cod_projeto     = du.cod_projeto
							  and ts.cod_aplicacao   = du.cod_aplicacao
							  and ts.tecnico_suporte = user )
			<cfif len(trim(arguments.cod_projeto)) >
			  and du.cod_projeto   = #val( arguments.cod_projeto )#
			</cfif>
			<cfif Len(Trim(arguments.cod_aplicacao))>
			  and du.cod_aplicacao = '#arguments.cod_aplicacao#'
			</cfif>
			<cfif Len(Trim(arguments.tecnico_suporte))>
			  and du.usuario = '#arguments.tecnico_suporte#'
			<cfelse>
			  and du.usuario = user	
			</cfif>							
			order by du.dir_raiz
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Seleciona emails dos usurios que se cadastraram para serem notificados da atualizao
	-- CRISTOFER  05/05/2006
	--->		
	<cffunction name="get_emails_notificacao_sinc" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="false" default="" />
		<cfargument name="cod_aplicacao" required="false" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select distinct
				    us.usuario, 
					nvl( us.nome, 'Sem usurios cadastrados') nome, 
					e.email_username||'@'||e.email_provedor email,            
					ema.cod_projeto, 
					ema.cod_aplicacao,
					e.email_id,
					case 
					  when exists (select 'x' 
								     from kss.kss_usuarios_suporte s
									where s.cod_projeto   = ema.cod_projeto
									  and s.cod_aplicacao = ema.cod_aplicacao
									  and s.tecnico_suporte = us.usuario) then 1 
					  else 0 
					end as tecnico
			   from kss.email e
			   left join kss.kss_usuarios us
				      on us.email_id = e.email_id
			  inner join atualizador.email_atualizacao ema
					  on ema.email_id = e.email_id
			  where 1=1 
/* Retirado pelo bloqueio as aplicacoes */
/*			  	and exists( select 'x' 
							  from internet.pessoa_usr_aplic_suporte ps
							 where ps.cod_projeto     = ema.cod_projeto
							   and ps.cod_aplicacao   = ema.cod_aplicacao
							   and ps.usuario         = user)*/
		     <cfif len(trim(arguments.cod_projeto)) and Len(Trim(arguments.cod_aplicacao))>
			    and ema.cod_projeto   = #arguments.cod_projeto#
		  	    and ema.cod_aplicacao = '#arguments.cod_aplicacao#'
	  	     </cfif>
			  order by  tecnico desc , email, nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona Projetos que o usurio d suporte que estejam vinculados  aplicaes locais
	-- JEFFERSON 04/11/2003 - criado
	---> 			
	<cffunction name="get_projetos" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.cod_projeto, p.nome_projeto
			  from kss.kss_projeto p
			 where exists( select 'x' 
							 from kss.kss_usuarios_suporte us 
								  inner join kss.kss_aplicacao a 
									 on a.cod_projeto   = us.cod_projeto
									and a.cod_aplicacao = us.cod_aplicacao
							where a.cod_projeto         = p.cod_projeto 
							  and a.tipo_aplicacao_id   = 0
							  and us.tecnico_suporte    = user)				
			 order by nome_projeto
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Consulta os tipos de arquivo
	-- JEFFERSON  04/11/2003 - criado
	--->		
	<cffunction name="get_tipo_arquivos" access="remote" returntype="query" output="true">
		<cfargument name="cod_tipo_arquivo" required="no" default="" />
		<cfargument name="descricao" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ta.cod_tipo_arquivo,
				   ta.descricao
			  from atualizador.tipo_arquivo ta
			 where 0 = 0 
			<cfif len(trim( arguments.cod_tipo_arquivo ))>
			   and ta.cod_tipo_arquivo = '#arguments.cod_tipo_arquivo#'
			</cfif>
			<cfif Len( Trim( arguments.descricao ) )>
			   and instr( upper( ta.descricao ),upper('#arguments.descricao#') )  <> 0 
			</cfif>
			 order by ta.cod_tipo_arquivo, ta.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Seleciona Tipo de Arquivo permitido para o Diretrio
	-- CRISTOFER  04/11/2006
	--->		
	<cffunction name="get_tipo_arquivo_diretorio" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="" />
		<cfargument name="cod_aplicacao" required="no" default="" />
		<cfargument name="dir" required="no" default="" />
		<cfargument name="cod_tipo_arquivo" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select internet.pkg_kss_web.fnc_nome_projeto(dsta.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao(dsta.cod_projeto,dsta.cod_aplicacao ) nome_aplicacao,
				   dsta.cod_projeto,dsta.cod_aplicacao,dsta.dir,ta.cod_tipo_arquivo,ta.descricao
			  from atualizador.dir_servidor_tipo_arquivo dsta
				   inner join atualizador.tipo_arquivo ta
					  on ta.cod_tipo_arquivo = dsta.cod_tipo_arquivo									 
			 where exists( select 'x'
                       		 from kss.kss_usuarios_suporte ts
                     	    where ts.cod_projeto     = dsta.cod_projeto
                       		  and ts.cod_aplicacao   = dsta.cod_aplicacao
                       		  and ts.tecnico_suporte = user )
			 <cfif len(trim(arguments.cod_projeto))>
			   and dsta.cod_projeto   = #arguments.cod_projeto#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_aplicacao))>
			   and dsta.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif Len( Trim( arguments.dir ) )>
			   and dsta.dir = '#arguments.dir#'
			 </cfif>							
			 order by ta.cod_tipo_arquivo, dsta.dir, ta.descricao	 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


<!--- Funes utilizadas na sincronizao dos arquivos (na ordem de utilizao) --->

	<!--- 
	-- PROPSITO
	-- Configura Asssistente de sincronizao
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="config_sincronizador" displayname="Realiza os Procedimento de Mapeamento e Sincronizao de Diretrios"access="remote" returntype="Struct" output="true">
		<cfargument name="cod_projeto" 			required="true" 	displayname="Cdigo do Projeto"  			type="string"/>
		<cfargument name="cod_aplicacao" 		required="true" 	displayname="Cdigo da Aplicao"  			type="string"/>
		<cfargument name="opcao" 				required="false" 	displayname="Opo de Sincronizao"  		type="string" 	 default="0"/>
		<cfargument name="arquivos_permitidos"	required="false" 	displayname="Arquivos Permitidos (filtro)"	type="string" />			
		<cfargument name="arquivos_excluidos"	required="false" 	displayname="Arquivos Excluidos (filtro)"	type="string" />			
		<cfargument name="copia_destino"		required="false" 	displayname="Flag que identifca se copia"	type="boolean" 	 default="false" />
		<cfscript>
			conn_files = CreateObject("component","_transportes.funcoes.cfc_file");
			strRetorno 				 = StructNew();  // Cria Estrutura  de dados
			strRetorno.erro			 = false;  		 // varivel de flux ( controle de erros ) 
			barra  					 = '/'; 		 // converso da barra ( unix )
			// configura diretrio mapeado do usurio e do servidor
			strRetorno.map_usuario  = this.get_diretorio_usuario( ArgumentCollection = Arguments ).map_usuario; // path para caminho temporario do mapemanto do usurio
			strRetorno.map_servidor = this.get_diretorio_servidor_raiz( ArgumentCollection = Arguments ).map_servidor;
			//identifica origem e destino
			strRetorno.origem		 = iif( Find(  1 , arguments.opcao ), de ( strRetorno.map_usuario  ) , de ( strRetorno.map_servidor ) );
			strRetorno.destino		 = iif( Find( -1 , arguments.opcao ), de ( strRetorno.map_usuario  ) , de ( strRetorno.map_servidor ) );
			// cria diretrio de destino, caso ele no exista
			if( NOT DirectoryExists( strRetorno.destino ) ) 
				conn_files.criaDiretorio( strRetorno.destino );
			// lista arquivos
			qrArquivos	= this.get_arquivos( ArgumentCollection = Arguments, destino = strRetorno.destino);
			// lista histrico
			qrHistorico = this.get_historico_aberto( ArgumentCollection = Arguments );  
			// se no existe registros dos arquivos no banco, ento ele envia todos para o servidor e os cadastra no banco
			if( not qrArquivos.recordcount  ) {
				// consulta arquivos no diretrio
				strRetorno.qrArquivos_desatualizados = this.lista_diretorio( diretorio = strRetorno.map_usuario, 
																			 recursiva = true, 
																			 horario_verao = this.esta_no_horario_verao()); 
								
				if( StructKeyExists( arguments, 'copia_destino') and arguments['copia_destino'] ) {	  
					for( i = 1; i lte strRetorno.qrArquivos_desatualizados.recordcount; i = i + 1 ) { // loop na query dos arquivos
						// verifica se o diretrio de destino existe, se no existir ento o cria
						if( NOT DirectoryExists( strRetorno.destino & RePlace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ i ] , strRetorno.origem , '' , 'ALL'), '\', barra, 'ALL') ) ) 
							conn_files.criaDiretorio(  strRetorno.destino & RePlace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ i ] , strRetorno.origem , '' , 'ALL'), '\', barra, 'ALL') );
						if( FindNocase('File', strRetorno.qrArquivos_desatualizados['tipo'][ i ] ) and Len(Trim( strRetorno.qrArquivos_desatualizados['nome'][ i ] ) ) and StructKeyExists( arguments, 'arquivos_permitidos') and ListFindNoCase( arguments.arquivos_permitidos , strRetorno.qrArquivos_desatualizados['nome'][ i ] ) ) {
							 // copia arquivos
//							try {
								strRetorno.copia_arquivos  = conn_files.copiaArquivo( caminho_origem  = strRetorno.origem  & Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ i ] , strRetorno.origem  , '' , 'ALL') & barra & strRetorno.qrArquivos_desatualizados['nome'][ i ], 
																					  caminho_destino = strRetorno.destino & Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ i ] , strRetorno.origem  , '' , 'ALL') & barra & strRetorno.qrArquivos_desatualizados['nome'][ i ]); 
//							} catch(Any e) {}
							md5 = this.md5_file(file = strRetorno.destino & Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ i ] , strRetorno.origem  , '' , 'ALL') & barra & strRetorno.qrArquivos_desatualizados['nome'][ i ]);
							 // verifica se no existe histrico em aberto 	  
							if( not qrHistorico.recordcount ) { 
								// abre um novo histrico
								this.ins_historico_sincronizador( ArgumentCollection = Arguments ); 
								// consulta novos histricos
								qrHistorico = this.get_historico_aberto( ArgumentCollection = Arguments ); 
							}	
							// cadastra arquivos no banco
							strRetorno.arquivos	= this.ins_arquivos( cod_projeto      = arguments.cod_projeto,
																	cod_aplicacao    = arguments.cod_aplicacao,
																	nome_arquivo     = strRetorno.qrArquivos_desatualizados['nome'][ i ],
																	pasta_instalacao = Replace( Replace(strRetorno.qrArquivos_desatualizados['diretorio'][ i ], strRetorno.origem,'', 'ALL'),'/','\','ALL') & '\',
																	tamanho 		 = strRetorno.qrArquivos_desatualizados['tamanho'][ i ],
																	data_arquivo     = strRetorno.qrArquivos_desatualizados['ultima_modificacao'][ i ],
																	script			 = val( conn_files.isScript(  strRetorno.qrArquivos_desatualizados['nome'][ i ] ) ),
																	relatorio		 = val( conn_files.isRelatorio(  strRetorno.qrArquivos_desatualizados['nome'][ i ] ) ),
																	assinatura 		 = md5);				
							// grava log de comparao de arquivos
							strRetorno.log = this.ins_log_sincronizador(cod_projeto 			= arguments.cod_projeto,
																	  cod_aplicacao 		= arguments.cod_aplicacao,
																	  usuario				= this.usuario,
																	  cod_historico 		= qrHistorico.cod_historico,
																	  nome_arquivo  		= strRetorno.qrArquivos_desatualizados['nome'][ i ],
																	  pasta_instalacao      = Replace( Replace(strRetorno.qrArquivos_desatualizados['diretorio'][ i ], strRetorno.origem,'', 'ALL'),'/','\','ALL') & '\',
																	  comentario    		= 'Arquivo no existe no diretrio de destino',
																	  dir_origem 			= Replace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ i ],'/files0/sistema/','\\Hercules\Sistema\', 'ALL'),'/','\','ALL'),
																	  dir_destino 			= Replace( Replace( strRetorno.destino & strRetorno.qrArquivos_desatualizados['diretorio'][ i ], strRetorno.origem, '', 'ALL') & '/' ,'//','/','ALL'),	
																	  ultima_modificacao  	= strRetorno.qrArquivos_desatualizados['ultima_modificacao'][ i ],
																	  tamanho			  	= strRetorno.qrArquivos_desatualizados['tamanho'][ i ]);  
						}
					}
					// finaliza histrico
					strRetorno.upd_historico = this.upd_historico_sincronizador(ArgumentCollection = Arguments);
				}		
			} else {
				// cria query de origem
				qrOrigem     = QueryNew( qrArquivos.columnList ); 
				qrDirOrigem  = this.lista_diretorio(diretorio = strRetorno.origem, 
													recursiva = true, 
													horario_verao = this.esta_no_horario_verao());
				for( j =1; j lte qrDirOrigem.recordcount; j = j + 1 ) {
					if( FindNoCase('File', qrDirOrigem.tipo[ j ] ) ) {
						QueryAddRow ( qrOrigem );
						QuerySetCell( qrOrigem, 'nome'				  , qrDirOrigem['nome'][ j ] );
						QuerySetCell( qrOrigem, 'diretorio'		 	  , Replace( Replace( qrDirOrigem['diretorio'][ j ] , strRetorno['origem'],'', 'ALL'),'/','\','ALL') & '\' );
						QuerySetCell( qrOrigem, 'tamanho'			  , qrDirOrigem['tamanho'][ j ] );
						QuerySetCell( qrOrigem, 'ultima_modificacao'  , qrDirOrigem['ultima_modificacao'][ j ] );
						QuerySetCell( qrOrigem, 'data_modificacao'    , DateFormat( qrDirOrigem['data_modificacao'][ j ], 'dd/mm/yyyy') & TimeFormat( qrDirOrigem['data_modificacao'][ j ], 'HH:MM') );
						QuerySetCell( qrOrigem, 'assinatura'    	  , qrDirOrigem['assinatura'][ j ] );
					}
				}	
				// consulta diferena
				strRetorno.qrArquivos_desatualizados = this.f_query_diff( qrOrigem, qrArquivos );
				
				if( StructKeyExists( arguments, 'copia_destino') and arguments['copia_destino'] ) {
					for( j = 1; j lte strRetorno.qrArquivos_desatualizados.recordcount; j = j + 1 ) {
						// verifica se o diretrio de destino existe, se no existir ento o cria
						if( NOT DirectoryExists( strRetorno.destino & RePlace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ j ] , strRetorno.origem , '' , 'ALL'), '\', barra, 'ALL') ) ) 
							conn_files.criaDiretorio(  strRetorno.destino & RePlace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ j ] , strRetorno.origem , '' , 'ALL'), '\', barra, 'ALL') );
						// verifica se o arquivo est marcado para ser copiado e ento copia esse arquivo.
						if( StructKeyExists( arguments, 'arquivos_permitidos') and ListFindNoCase( arguments.arquivos_permitidos , strRetorno.qrArquivos_desatualizados['nome'][ j ] ) ) {
							// copia arquivos
							strRetorno.copia_arquivos = conn_files.copiaArquivo( caminho_origem  = strRetorno.origem  & Replace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ j ] , strRetorno.origem , '' , 'ALL'), '\', barra, 'ALL') & strRetorno.qrArquivos_desatualizados['nome'][ j ], 
																				 caminho_destino = strRetorno.destino & RePlace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ j ] , strRetorno.destino , '' , 'ALL'), '\', barra, 'ALL') & strRetorno.qrArquivos_desatualizados['nome'][ j ]); 
							md5 = this.md5_file(file = strRetorno.destino & RePlace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ j ] , strRetorno.destino , '' , 'ALL'), '\', barra, 'ALL') & strRetorno.qrArquivos_desatualizados['nome'][ j ] );
							// verifica se no existe histrico em aberto 	  
							if( not qrHistorico.recordcount ) { 
								// abre um novo histrico
								this.ins_historico_sincronizador( ArgumentCollection = Arguments ); 
								// consulta novos histricos
								qrHistorico = this.get_historico_aberto( ArgumentCollection = Arguments ); 
							}	
							// cadastra arquivos no banco
							strRetorno.arquivos =   this.ins_arquivos(cod_projeto      = arguments.cod_projeto,
																	  cod_aplicacao    = arguments.cod_aplicacao,
																	  nome_arquivo     = strRetorno.qrArquivos_desatualizados['nome'][ j ],
																	  pasta_instalacao = Replace( Replace(strRetorno.qrArquivos_desatualizados['diretorio'][ j ], strRetorno.origem,'', 'ALL'),'/','\','ALL'),
																	  tamanho 		   = strRetorno.qrArquivos_desatualizados['tamanho'][ j ],
																	  data_arquivo     = strRetorno.qrArquivos_desatualizados['ultima_modificacao'][ j ],
																	  script		   = conn_files.isScript(  strRetorno.qrArquivos_desatualizados['nome'][ j ] ),
																	  relatorio   	   = conn_files.isRelatorio(  strRetorno.qrArquivos_desatualizados['nome'][ j ] ),
																	  assinatura	   = md5);
							// grava log de comparao de arquivos
							strRetorno.log =  this.ins_log_sincronizador(cod_projeto 			= arguments.cod_projeto,
																		 cod_aplicacao 			= arguments.cod_aplicacao,
																		 usuario				= this.usuario,
																		 cod_historico 			= qrHistorico.cod_historico,
																		 nome_arquivo  			= strRetorno.qrArquivos_desatualizados['nome'][ j ],
																		 pasta_instalacao       = Replace( Replace(strRetorno.qrArquivos_desatualizados['diretorio'][ j ], strRetorno.origem,'', 'ALL'),'/','\','ALL'),
																		 comentario    			= strRetorno.qrArquivos_desatualizados['comentario'][ j ],
																		 dir_origem 			= Replace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ j ],'/files0/sistema/','\\Hercules\Sistema\', 'ALL'),'/','\','ALL') ,
																		 dir_destino 			= Replace( Replace( strRetorno.destino & strRetorno.qrArquivos_desatualizados['diretorio'][ j ], strRetorno.origem, '', 'ALL') & '/' ,'//','/','ALL'),	
																		 ultima_modificacao  	= strRetorno.qrArquivos_desatualizados['ultima_modificacao'][ j ],
																		 tamanho			  	= strRetorno.qrArquivos_desatualizados['tamanho'][ j ]);  
						}
						// verifica se o arquivo est marcado para ser removido e ento exclui esse arquivo.
						if( StructKeyExists( arguments, 'arquivos_excluidos') and ListFindNoCase( arguments.arquivos_excluidos , strRetorno.qrArquivos_desatualizados['nome'][ j ] ) ) {
							// verifica se no existe histrico em aberto 	  
							if( not qrHistorico.recordcount ) { 
								// abre um novo histrico
								this.ins_historico_sincronizador( ArgumentCollection = Arguments ); 
								// consulta novos histricos
								qrHistorico = this.get_historico_aberto( ArgumentCollection = Arguments ); 
							}	
							// exclui arquivo
							strRetorno.deleta_arquivo = this.del_arquivos( cod_projeto   = arguments.cod_projeto,
																		  cod_aplicacao = arguments.cod_aplicacao,
																		  nome_arquivo  = strRetorno.qrArquivos_desatualizados['nome'][ j ]);
							// grava log de comparao de arquivos
							strRetorno['log'] = this.ins_log_sincronizador( cod_projeto 		= arguments.cod_projeto,
																		  cod_aplicacao 		= arguments.cod_aplicacao,
																		  usuario				= this.usuario,
																		  cod_historico 		= qrHistorico.cod_historico,
																		  nome_arquivo  		= strRetorno.qrArquivos_desatualizados['nome'][ j ],
																		  pasta_instalacao      = Replace( Replace(strRetorno.qrArquivos_desatualizados['diretorio'][ j ], strRetorno.origem,'', 'ALL'),'/','\','ALL'),
																		  comentario    		= strRetorno.qrArquivos_desatualizados['comentario'][ j ],
																		  dir_origem 			= Replace( Replace( strRetorno.qrArquivos_desatualizados['diretorio'][ j ],'/files0/sistema/','\\Hercules\Sistema\', 'ALL'),'/','\','ALL') ,
																		  dir_destino 			= Replace( Replace( strRetorno.destino & strRetorno.qrArquivos_desatualizados['diretorio'][ j ], strRetorno.origem, '', 'ALL') & '/' ,'//','/','ALL'),	
																		  ultima_modificacao  	= strRetorno.qrArquivos_desatualizados['ultima_modificacao'][ j ],
																		  tamanho			  	= strRetorno.qrArquivos_desatualizados['tamanho'][ j ]);
						}														
					} 
					// finaliza histrico
					strRetorno.upd_historico = this.upd_historico_sincronizador(	ArgumentCollection = Arguments );  
				}
			}
		</cfscript>
		<cfreturn strRetorno />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Seleciona Diretrio Raiz do Servidor
	-- JEFFERSON 08/09/2003 - criado
	--->		
	<cffunction name="get_diretorio_servidor_raiz" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" 		required="no" />
		<cfargument name="cod_aplicacao" 	required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select dsr.cod_projeto, dsr.cod_aplicacao, dsr.dir_raiz,
				   dsr.dir_raiz || '/' || dsr.cod_projeto || '/' || dsr.cod_aplicacao map_servidor,
				   internet.pkg_kss_web.fnc_nome_projeto(dsr.cod_projeto) nome_projeto, 
				   internet.pkg_kss_web.fnc_nome_aplicacao(dsr.cod_projeto,dsr.cod_aplicacao ) nome_aplicacao
			  from atualizador.dir_servidor_raiz dsr			
			 where exists( select 'x'
							 from kss.kss_usuarios_suporte ts
							where ts.cod_projeto     = dsr.cod_projeto
							  and ts.cod_aplicacao   = dsr.cod_aplicacao
							  and ts.tecnico_suporte = user )
			<cfif IsNumeric( arguments['cod_projeto'] ) and Len( Trim( arguments['cod_aplicacao'] ) )>
			  and dsr.cod_projeto   = #val( arguments['cod_projeto'] )#
			  and dsr.cod_aplicacao = '#arguments['cod_aplicacao']#'
			</cfif>
			order by internet.pkg_kss_web.fnc_nome_projeto(dsr.cod_projeto), internet.pkg_kss_web.fnc_nome_aplicacao(dsr.cod_projeto,dsr.cod_aplicacao )
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os arquivos do banco de dados
	-- CRISTOFER  06/05/2006
	--->		
	<cffunction name="get_arquivos" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" 		required="true"  />
		<cfargument name="cod_aplicacao"	required="true"	 />
		<cfargument name="nome_arquivo" 	required="false" />
		<cfquery name="qrArquivosBanco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ar.nome_arquivo nome, 
				   ar.pasta_instalacao diretorio, 
				   ar.tamanho, 
				   trim(to_char( ar.data_arquivo,'yyyy-mm-dd hh24:mi:ss')) ultima_modificacao, 
				   trim(to_char( ar.data_arquivo,'yyyy-mm-dd hh24:mi')) data_modificacao,
				   assinatura
			  from atualizador.arquivos ar
			 where ar.cod_projeto   = #val( arguments['cod_projeto'] )#
			   and ar.cod_aplicacao = '#arguments['cod_aplicacao']#'
			 <cfif StructKeyExists( arguments, 'nome_arquivo') and Len( Trim( arguments['nome_arquivo'] ) )>
			   and upper( ar.nome_arquivo ) = upper('#arguments['nome_arquivo']#')
			 </cfif>			
			 order by    ar.pasta_instalacao, ar.nome_arquivo 
		</cfquery>
		<cfscript>
			// converte a query de banco para formato de query de diretrio e insere a assinatura
			qrArquivos = QueryNew( qrArquivosBanco.columnList );
			for ( j =1; j lte qrArquivosBanco.recordcount; j = j + 1 ) {
				QueryAddRow ( qrArquivos );
				QuerySetCell( qrArquivos, 'nome'			   , qrArquivosBanco['nome'][ j ] );
				QuerySetCell( qrArquivos, 'diretorio'		   , qrArquivosBanco['diretorio'][ j ] );
				QuerySetCell( qrArquivos, 'tamanho'			   , qrArquivosBanco['tamanho'][ j ] );
				QuerySetCell( qrArquivos, 'ultima_modificacao' , LsParseDateTime( qrArquivosBanco['ultima_modificacao'][ j ] )  );
				QuerySetCell( qrArquivos, 'data_modificacao'   , DateFormat( LsParseDateTime( qrArquivosBanco['data_modificacao'][ j ] ) , 'dd/mm/yyyy') & TimeFormat( LsParseDateTime( qrArquivosBanco['data_modificacao'][ j ] )  , 'HH:MM') );
				QuerySetCell( qrArquivos, 'assinatura'		   , this.md5_file(file = replace(arguments.destino&'/'&qrArquivosBanco['diretorio'][ j ]&qrArquivosBanco['nome'][ j ], '\', '/', 'ALL') ));
			}	
		</cfscript>
		<cfreturn qrArquivos>		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Seleciona histrico que ainda no foi finalizado
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="get_historico_aberto" displayname="Histrico em Aberto  ( ltimo ) do Sincronizador" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_projeto" 		required="yes" />
		<cfargument name="cod_aplicacao" 	required="yes" />
		<cfquery name="qrHistorico" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">	
			select hs.cod_historico 
			  from atualizador.historico_sincronizador hs
			 where hs.cod_projeto   =  #val( arguments['cod_projeto'] )#
			   and hs.cod_aplicacao = '#arguments['cod_aplicacao']#'
			   and hs.data_fim is null
		</cfquery>
		<cfreturn qrHistorico />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Lista Diretorio no de Forma Recursiva no servidor
	-- JEFFERSON 04/11/2003 - criado
	--->
	<cffunction name="lista_diretorio"  displayname="Lista Diretorio no de Forma Recursiva no servidor" access="remote" output="true" returntype="query">
		<cfargument 	name="diretorio" 	 type="string" 	required="true" />
		<cfargument 	name="filtro" 	 	 type="string" 	required="false" 	default="" />
		<cfargument 	name="sort" 	 	 type="string" 	required="false" 	default="type DESC, name ASC" />
		<cfargument 	name="recursiva"   	 type="boolean" required="false" 	default="false" />
		<cfargument 	name="horario_verao" type="boolean" required="false"	default="false" />
		<cfargument 	name="temp_dir" 	 type="query" 	required="false" />
		<cfargument 	name="atual_dir" 	 type="query" 	required="false" />
		<cfset var path  = iif( FindNoCase('windows', server.os.name ), de('\'), de('/')) />
		<cfset var temp  = '' />
		<cfif not recursiva>
			<cfdirectory name 		= "temp" 
						 directory 	= "#diretorio#" 
						 filter	   	= "#filtro#" 
						 sort	   	= "#sort#" />
			<cfscript>
				QueryAddColumn(temp, "assinatura", ArrayNew(1));
			</cfscript>
			<cfloop query="temp">
				<cfif find('Dir', temp.type)>
					<cfset temp.assinatura = "">
				<cfelse>
				<!--- funcao que busca o MD5 do Arquivo--->
					<cfset temp.assinatura = "#this.md5_file(file = temp.directory&'/'&temp.name)#">
				</cfif>
			</cfloop>
			<cfreturn temp />
		<cfelse>
			<cfif NOT isDefined("temp_dir")>
				<cfset temp_dir = queryNew("ultima_modificacao,nome,tamanho,tipo,diretorio,data_modificacao,assinatura")>
			</cfif>
			<cfset atual_dir = lista_diretorio(diretorio,filtro,sort,false,horario_verao)>
			<cfloop query="atual_dir">
				<cfset queryAddRow(temp_dir)>
				<cfset data = LSParseDateTime( LSDateFormat(datelastmodified) & ' ' & LSTimeFormat(datelastmodified) ) />
				<cfset querySetCell(temp_dir,"data_modificacao",  data )>
				<cfset querySetCell(temp_dir,"ultima_modificacao",  data )>
				<cfset querySetCell(temp_dir,"nome",name)>
				<cfset querySetCell(temp_dir,"tamanho",  val( size ) )>
				<cfset querySetCell(temp_dir,"tipo",type)>
				<cfset querySetCell(temp_dir,"diretorio",diretorio)>
				<cfset querySetCell(temp_dir,"assinatura",assinatura)>
				<cfif FindNoCase('dir', type )>
					<cfset lista_diretorio( diretorio & path & name , filtro , sort , true , horario_verao, temp_dir )>
				</cfif>
			</cfloop>
			<cfreturn temp_dir />
		</cfif>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Verificar se o nosso servidor est no horrio de vero ( aplicar ou no o fuso horrio )
	-- JEFFERSON 20/10/2004 - criado
	--->			
	<cffunction name="esta_no_horario_verao" access="remote" returntype="Boolean" output="true">
		<cfquery name="qrHorarioVerao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select decode( atualizador.pkg_atualizador.isDST, 0, 'false', 'true') Retorno
			   from dual
		</cfquery>
		<cfreturn iif( FindNoCase('true', qrHorarioVerao.retorno ), de( true ), de( false ) )   />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere histrico de sincronizao
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="ins_historico_sincronizador" access="remote" returntype="Struct" output="false">
		<cfargument name="cod_projeto" 			required="true" 	displayname="Cdigo do Projeto"  		type="Numeric"	/>
		<cfargument name="cod_aplicacao" 		required="true" 	displayname="Cdigo da Aplicao"  		type="string"	/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_ins_historico" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam 	dbvarname="p_cod_historico" 		type="inOut" value="-1" 								cfsqltype="cf_sql_integer" variable="cod_historico" />
				<cfprocparam 	dbvarname="p_cod_projeto" 		  	type="in"  	 value="#val( arguments['cod_projeto'] )#" 	cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_cod_aplicacao" 	  	type="in" 	 value="#arguments['cod_aplicacao']#" 		cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro	= False />
			<cfset retorno.mensagem = 'Arquivos Sincronizados com sucesso.!' />
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere arquivos sincronizados
	-- JEFFERSON 04/11/2003 - criado
	--->	
	<cffunction name="ins_arquivos" displayname="Insere Arquivos"access="remote" returntype="Struct" output="false">
		<cfargument name="cod_projeto" 			required="true" 	displayname="Cdigo do Projeto"  			type="numeric"	/>
		<cfargument name="cod_aplicacao" 		required="true" 	displayname="Cdigo da Aplicao"  			type="string"	/>
		<cfargument name="nome_arquivo" 		required="true" 	displayname="Nome do Arquivo"  				type="string"	/>
		<cfargument name="pasta_instalacao" 	required="true" 	displayname="Pasta de Instalao"  			type="string"	/>
		<cfargument name="tamanho"				required="true" 	displayname="Tamanho do Arquivo"  			type="numeric"	/>												
		<cfargument name="data_arquivo"			required="true" 	displayname="Data do Arquivo"  				type="date"	/>												
		<cfargument name="script"				required="true" 	displayname=" Script?"  					type="numeric"	 default="0"/>												
		<cfargument name="relatorio"			required="true" 	displayname=" Relatrio(rtx)"  			type="numeric"	 default="0"/>												
		<cfargument name="assinatura"			required="false"	default="">
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_ins_arquivos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam 	dbvarname="p_cod_projeto" 		  	type="in" 	value="#val( arguments['cod_projeto'] )#" 			cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_cod_aplicacao" 	  	type="in" 	value="#arguments['cod_aplicacao']#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_nome_arquivo" 			type="in" 	value="#arguments['nome_arquivo']#"					cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_pasta_instalacao"	 	type="in" 	value="#arguments['pasta_instalacao']#" 			cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_tamanho" 		 		type="in" 	value="#val( arguments['tamanho'] )#" 				cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_data_arquivo" 			type="in" 	value="#arguments['data_arquivo']#" 				cfsqltype="cf_sql_timestamp" />
				<cfprocparam 	dbvarname="p_script" 			  	type="in" 	value="#val( arguments['script'] )#" 				cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_relatorio" 			type="in" 	value="#val( arguments['relatorio'] )#" 			cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_assinatura" 			type="in" 	value="#arguments['assinatura'] #"		 			cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro	= False />
			<cfset retorno.mensagem = 'Arquivos inserido com sucesso.!' />			
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere log de sincronizao
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="ins_log_sincronizador" access="remote" returntype="Struct" output="false">
		<cfargument name="cod_projeto" 			required="true" 	displayname="Cdigo do Projeto"  		type="numeric"	/>
		<cfargument name="cod_aplicacao" 		required="true" 	displayname="Cdigo da Aplicao"  		type="string"	/>
		<cfargument name="usuario" 				required="true" 	displayname="Usurio"  					type="string"	/>
		<cfargument name="cod_historico"		required="true" 	displayname="Cdigo do Histrico"  		type="numeric"	/>
		<cfargument name="nome_arquivo" 		required="true" 	displayname="Nome do Arquivo"  			type="string"	/>
		<cfargument name="pasta_instalacao" 	required="true" 	displayname="Pasta Instalao"  		type="string"	/>			
		<cfargument name="comentario"	 		required="true" 	displayname="Comentrio "  				type="string"	/>
		<cfargument name="dir_origem" 			required="true" 	displayname="Diretrio de Origem"  		type="string"	/>
		<cfargument name="dir_destino" 			required="true" 	displayname="Diretrio de Destino"  	type="string"	/>									
		<cfargument name="ultima_modificacao"	required="true" 	displayname="ltima Modificao"  		type="date"	/>												
		<cfargument name="tamanho"				required="true" 	displayname="Tamanho do Arquivo"  		type="numeric"	/>												
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_ins_log_sincronizador" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam 	dbvarname="p_cod_projeto" 		  	type="in" value="#val( arguments['cod_projeto'] )#" 		cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_cod_aplicacao" 	  	type="in" value="#arguments['cod_aplicacao']#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_usuario" 			  	type="in" value="#arguments['usuario']#" 					cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_cod_historico"	 	  	type="in" value="#val( arguments['cod_historico'] )#"		cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_nome_arquivo"	 	  	type="in" value="#arguments['nome_arquivo']#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_pasta_instalacao"	 	type="in" value="#arguments['pasta_instalacao']#" 			cfsqltype="cf_sql_varchar" />									
				<cfprocparam 	dbvarname="p_comentario" 		 	type="in" value="#arguments['comentario']#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_dir_origem" 		  	type="in" value="#arguments['dir_origem']#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_dir_destino" 		 	type="in" value="#arguments['dir_destino']#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_ultima_modificacao" 	type="in" value="#arguments['ultima_modificacao']#" 		cfsqltype="cf_sql_timestamp" />
				<cfprocparam 	dbvarname="p_tamanho" 			  	type="in" value="#val( arguments['tamanho'] )#" 			cfsqltype="cf_sql_integer" />
			</cfstoredproc>
			<cfset retorno.erro	= False />
			<cfset retorno.mensagem = '' />			
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn strRetorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Atualiza Histrico de Sincronizao
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="upd_historico_sincronizador" displayname="Finaliza Histrico do Sincronizador"access="remote" returntype="Struct" output="false">
		<cfargument name="cod_projeto" 			required="true" 	displayname="Cdigo do Projeto"  		type="Numeric"	/>
		<cfargument name="cod_aplicacao" 		required="true" 	displayname="Cdigo da Aplicao"  		type="string"	/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_upd_historico" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam 	dbvarname="p_cod_projeto" 		  	type="in" 	value="#val( arguments['cod_projeto'] )#" 	cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_cod_aplicacao" 	  	type="in" 	value="#arguments['cod_aplicacao']#" 		cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro	= False />
			<cfset retorno.mensagem = '' />			
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn strRetorno />		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna Diferena entre duas Queries
	-- CRISTOFER 04/11/2003 - criado
	--->			
	<cffunction name="f_query_diff" displayname="" returntype="query" output="true">
		<cfargument name="q1" 	 displayname="Query Origem"  	required="true" 	type="query" />
		<cfargument name="q2" 	 displayname="Query Destino" 	required="true" 	type="query" />	
		<!---Cria um campo identificador com a juno de todas as colunas que devem ser comparadas--->
		<cfset QueryAddColumn(q1, "identificador", ArrayNew(1))>
		<cfset QueryAddColumn(q2, "identificador", ArrayNew(1))>

		<cfloop from="1" to="#q1.recordcount#" index="index">
			<cfset q1["identificador"][index] = q1["diretorio"][index]&"_=_"&q1["nome"][index]>
		</cfloop>
		<cfloop from="1" to="#q2.recordcount#" index="index">
			<cfset q2["identificador"][index] = q2["diretorio"][index]&"_=_"&q2["nome"][index]>
		</cfloop>
	
		<cfset qrDiff   = QueryNew( q1.columnlist ) />
		<cfset qrDiff2   = QueryNew( "nome,diretorio,tamanho,ultima_modificacao,data_modificacao,comentario,acao,ordem" ) />
		<cfset lstNome1     = VaLueList( q1.nome )/>
		<cfset lstNome2     = VaLueList( q2.nome )/>
		<cfset arID1		= ( VaLueList( q1.identificador ) )>
		<cfset arID2		= ( VaLueList( q2.identificador ) )>
		<cfif q1.recordcount and q2.recordcount>
			<cfloop from="1" to="#ListLen(arID1)#" index="v_index">
				<!---Busca o item da q1 em q2--->
				<cfset v_index2 = ListFind(UCase(arID2), ListGetAt(UCase(arID1), v_index))>
				<cfif v_index2 eq 0>
					<!---Item nao existe em q2--->
					<cfset QueryAddRow( qrDiff2 )>
					<cfset QuerySetCell(qrDiff2, "nome", q1["nome"][v_index])>
					<cfset QuerySetCell(qrDiff2, "diretorio", q1["diretorio"][v_index])>
					<cfset QuerySetCell(qrDiff2, "tamanho", q1["tamanho"][v_index])>
					<cfset QuerySetCell(qrDiff2, "ultima_modificacao", q1["ultima_modificacao"][v_index])>
					<cfset QuerySetCell(qrDiff2, "data_modificacao", q1["data_modificacao"][v_index])>
					<cfset QuerySetCell(qrDiff2, "comentario", "Arquivo no existe no diretrio de destino")>
					<cfset QuerySetCell(qrDiff2, "acao", "atualizar")>
					<cfset QuerySetCell(qrDiff2, "ordem", 2)>
				<cfelseif q1["assinatura"][v_index] neq q2["assinatura"][v_index2]>
					<!---Caso as assinaturas no correspondam--->
					<cfset QueryAddRow( qrDiff2 )>
					<cfset QuerySetCell(qrDiff2, "nome", q1["nome"][v_index])>
					<cfset QuerySetCell(qrDiff2, "diretorio", q1["diretorio"][v_index])>
					<cfset QuerySetCell(qrDiff2, "tamanho", q1["tamanho"][v_index])>
					<cfset QuerySetCell(qrDiff2, "ultima_modificacao", q1["ultima_modificacao"][v_index])>
					<cfset QuerySetCell(qrDiff2, "data_modificacao", q1["data_modificacao"][v_index])>
					<cfset QuerySetCell(qrDiff2, "comentario", "Arquivo sofreu modificaes")>
					<cfset QuerySetCell(qrDiff2, "acao", "atualizar")>
					<cfset QuerySetCell(qrDiff2, "ordem", 3)>
				</cfif>
			</cfloop>	
	
			<cfloop from="1" to="#ListLen(arID2)#" index="v_index">
				<!---Busca o item da q2 em q1--->
				<cfset v_index2 = ListFind(UCase(arID1), ListGetAt(UCase(arID2), v_index))>
				<cfif v_index2 eq 0>
					<!---Item nao existe em q2--->
					<cfset QueryAddRow( qrDiff2 )>
					<cfset QuerySetCell(qrDiff2, "nome", q2["nome"][v_index])>
					<cfset QuerySetCell(qrDiff2, "diretorio", q2["diretorio"][v_index])>
					<cfset QuerySetCell(qrDiff2, "tamanho", q2["tamanho"][v_index])>
					<cfset QuerySetCell(qrDiff2, "ultima_modificacao", q2["ultima_modificacao"][v_index])>
					<cfset QuerySetCell(qrDiff2, "data_modificacao", q2["data_modificacao"][v_index])>
					<cfset QuerySetCell(qrDiff2, "comentario", "Arquivo no existe no diretrio de origem e ser removido")>
					<cfset QuerySetCell(qrDiff2, "acao", "deletar")>
					<cfset QuerySetCell(qrDiff2, "ordem", 1)>
				</cfif>
			</cfloop>	
		</cfif>		
		<cfreturn qrDiff2 />
	</cffunction>

<!--- 
-- PROPSITO
-- Captura o Hash MD5 do Arquivo
-- CRISTOFER 04/11/2005 - criado
--->
<cffunction name="md5_file" displayname="Captura o Hash MD5 do Arquivo" returntype="string" output="true" access="remote">
	<cfargument name="file" required="yes">
	<cfargument name="expand" required="no" default="0">
	<cfif arguments.expand eq 1>
		<cfset arguments.file = expandPath(arguments.file)>
	</cfif>
	<cffile action="read" file="#file#" variable="xFile" />
	<cfscript>
		return ucase(hash(xFile,'MD5'));
	</cfscript>
</cffunction>


	<!--- 
	-- PROPSITO
	-- Deleta arquivos
	-- JEFFERSON 04/11/2003 - criado
	--->			
	<cffunction name="del_arquivos" displayname="Insere Arquivos"access="remote" returntype="Struct" output="false">
		<cfargument name="cod_projeto" 			required="true" 	displayname="Cdigo do Projeto"  	type="numeric"	/>
		<cfargument name="cod_aplicacao" 		required="true" 	displayname="Cdigo da Aplicao"  	type="string"	/>
		<cfargument name="nome_arquivo"			required="false" 	displayname="Nome do Arquivo"  		type="string"/>												
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_del_arquivos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				<cfprocparam 	dbvarname="p_cod_projeto" 		  	type="in" 	value="#val( arguments['cod_projeto'] )#" 			cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_cod_aplicacao" 	  	type="in" 	value="#arguments['cod_aplicacao']#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_nome_arquivo" 			type="in" 	value="#arguments['nome_arquivo']#"					cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro	= False />
			<cfset retorno.mensagem = '' />			
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
	   </cftry>
		<cfreturn strRetorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Verifica se a extenso do arquivo  permitida para ser gravada naquele diretrio
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="extensao_permitida" access="remote" returntype="boolean" output="false">	  
		<cfargument name="cod_projeto" 				required="true" 	displayname="Cdigo do Projeto"  				type="numeric"/>
		<cfargument name="cod_aplicacao" 			required="true" 	displayname="Cdigo da Aplicao" 	 			type="string"/>
		<cfargument name="dir" 						required="true" 	displayname="Diretrio (subpasta)" 	 			type="string"/>
		<cfargument name="cod_tipo_arquivo" 		required="true" 	displayname="Cdigo do Tipo de Arquivo" 	 	type="string"/>
		<cfquery name="qrPermiteUpload" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select 'x'
				  from atualizador.dir_servidor_tipo_arquivo dsta
				 where dsta.cod_projeto      		  = #val( arguments['cod_projeto'] )#
				   and dsta.cod_aplicacao    		  = '#arguments['cod_aplicacao']#'
				   and upper( dsta.dir )        	  = upper( substr( dsta.dir , instr( dsta.dir, '#arguments['dir']#', length( dsta.dir )) ) )
				   and upper( dsta.cod_tipo_arquivo ) = upper('#arguments['cod_tipo_arquivo']#')
		</cfquery>  
		<cfreturn iif( qrPermiteUpload.recordcount, de( true ), de( false )) />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Insere log de sincronizao
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="ins_nova_versao" displayname="Incrementa Verso de Atualizao"access="remote" returntype="Struct" output="false">
		<cfargument name="cod_projeto" 			required="true" 	displayname="Cdigo do Projeto"  		type="numeric"	/>
		<cfargument name="cod_aplicacao" 		required="true" 	displayname="Cdigo da Aplicao"  		type="string"	/>
		<cfargument name="descricao" 			required="true" 	displayname="Desecrio da Atualizao" type="string"	/>
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_upd_versao" datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
				<cfprocparam 	dbvarname="p_cod_projeto" 		  	type="in" value="#val( arguments['cod_projeto'] )#" 		cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_cod_aplicacao" 	  	type="in" value="#arguments['cod_aplicacao']#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_descricao"			  	type="in" value="#arguments['descricao']#" 					cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro	= False />
			<cfset retorno.mensagem = '' />		
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>				 
		</cftry>
		<cfreturn retorno />		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Envia mensagem de Verificao para os usurios cadastrados
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="envia_verificacao" access="Remote" returntype="Struct" output="false">
		<cfargument name="cod_projeto" 		required="yes" />
		<cfargument name="cod_aplicacao" 	required="yes" />
		<cfargument name="email" 			required="yes" />
		<cftry>
			<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_notifica_atualizacao" datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
				<cfprocparam 	dbvarname="p_destinatario" 	  	type="in" 	 value="#arguments.email#" 				cfsqltype="cf_sql_varchar" />
				<cfprocparam 	dbvarname="p_cod_projeto" 		type="in"  	 value="#val( arguments.cod_projeto )#" 	cfsqltype="cf_sql_integer" />
				<cfprocparam 	dbvarname="p_cod_aplicacao" 	type="in" 	 value="#arguments.cod_aplicacao#" 		cfsqltype="cf_sql_varchar" />
			</cfstoredproc>
			<cfset retorno.erro = false />
			<cfset retorno.mensagem = 'Notificao enviada com sucesso!'>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>	
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Seleciona histrico de sincronizao de arquivos
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cffunction name="get_historico_sincronizador" displayname="Histrico do Sincronizador" access="remote" returntype="Query" output="false">	  
		<cfargument name="cod_projeto" 		required="no" />
		<cfargument name="cod_aplicacao" 	required="no" />
		<cfquery name="qrHistorico" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select hs.cod_projeto, hs.cod_aplicacao, hs.cod_historico, hs.usuario, hs.data_inicio, hs.data_fim,
				   hs.cod_historico || ' - ' || trim( to_char( hs.data_inicio, 'dd/mm/yyyy hh24:mi:ss')) || ' at ' ||  trim( to_char( hs.data_fim, 'dd/mm/yyyy hh24:mi:ss')) descricao
			  from atualizador.historico_sincronizador hs
			 where exists ( select 'x'
							  from kss.kss_usuarios_suporte ts
							 where ts.cod_projeto     = hs.cod_projeto
							   and ts.cod_aplicacao   = hs.cod_aplicacao
							   and ts.tecnico_suporte = user )
			<cfif len(trim(arguments.cod_projeto))>
			  and hs.cod_projeto   = #val( arguments.cod_projeto )#
			</cfif>
			<cfif len(trim(arguments.cod_aplicacao))>
			  and hs.cod_aplicacao = '#arguments.cod_aplicacao#'
			</cfif>
			 order by hs.cod_historico
		</cfquery>  
		<cfreturn qrHistorico />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Seleciona histrico e log de sincronizao
	-- JEFFERSON 14/09/2004 - criado
	--->			
	<cffunction name="get_relatorio_historico" displayname="Log do Sincronizador" access="remote" returntype="Query" output="true">	  
		<cfargument name="cod_projeto" required="no" default="" />
		<cfargument name="cod_aplicacao" required="no" default="" />
		<cfargument name="cod_historico" required="no" default="" />
		<cfquery name="qrLog" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select hs.cod_projeto,hs.cod_aplicacao, hs.cod_historico, hs.usuario, hs.data_inicio, hs.data_fim,
				   internet.pkg_kss_web.fnc_nome_projeto( hs.cod_projeto ) nome_projeto,
				   internet.pkg_kss_web.fnc_nome_aplicacao( hs.cod_projeto, hs.cod_aplicacao ) nome_aplicacao,
				   hs.cod_historico || ' - Sincronizado por ' || internet.pkg_kss_web.fnc_nome_usuario( hs.usuario ) || ' de ' || trim( to_char( hs.data_inicio, 'dd/mm/yyyy hh24:mi:ss')) || ' at ' ||  trim( to_char( hs.data_fim, 'dd/mm/yyyy hh24:mi:ss')) descricao,
				   l.pasta_instalacao,l.nome_arquivo,l.comentario,l.dir_origem,l.dir_destino,l.ultima_modificacao, l.tamanho
			  from atualizador.historico_sincronizador HS
				   inner join atualizador.log_sincronizador l
					 on l.cod_projeto   = hs.cod_projeto
					and l.cod_aplicacao = hs.cod_aplicacao
					and l.cod_historico = hs.cod_historico
			 where exists( select 'x'
							 from kss.kss_usuarios_suporte ts
						    where ts.cod_projeto     = l.cod_projeto
							  and ts.cod_aplicacao   = l.cod_aplicacao
							  and ts.tecnico_suporte = user) 
    		 <cfif len(trim(arguments.cod_projeto))>
			   and hs.cod_projeto   = #val( arguments.cod_projeto )#
			 </cfif>
		 	 <cfif Len(Trim(arguments.cod_aplicacao))>
			   and hs.cod_projeto   = #val( arguments.cod_projeto )#
			   and hs.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif Len( Trim( arguments.cod_historico ) )>
			   and hs.cod_historico = #val( arguments.cod_historico )#
			 </cfif>							
			order by hs.cod_historico, hs.cod_projeto, hs.cod_aplicacao, hs.cod_historico, l.pasta_instalacao	, l.nome_arquivo
		</cfquery>  
		<cfreturn qrLog />
	</cffunction>
	
<!---

<cffunction name="getEmailsVerificacao"  displayname="Consulta Emails de Verificao "access="Remote" returntype="Query" output="true">
   <!--- 
   	-- PROPSITO
	-- Seleciona emails dos usurios que se cadastraram para serem notificados da atualizao
	-- NOTAS EXPLICATIVAS
	--  ( podem exisitir e-mails sem usurios cadastrados )
	-- JEFFERSON  04/11/2003 - criado
	-- LUCIANA    08/03/2005 - modificado
	--->			
	<cfargument name="cod_projeto" required="false" displayname="Cdigo do Projeto" type="string" />
	<cfargument name="cod_aplicacao" required="false" displayname="Cdigo da Aplicao" type="string" />
		<cfquery name="qrVerificacao" datasource="#application.dsn#"  username="#session.usuario#" password="#session.senha#">
			select us.usuario,us.nome, 'TS' || ';' || e.email_username||'@'||e.email_provedor email,ema.cod_projeto, ema.cod_aplicacao,e.email_id,
		     	   internet.pkg_kss_web.fnc_nome_projeto( ema.cod_projeto ) nome_projeto,
         		   internet.pkg_kss_web.fnc_nome_aplicacao( ema.cod_projeto, ema.cod_aplicacao ) nome_aplicacao,
				   1 as possui_usuario,
				   us.nome||' - '||e.email_username||'@'||e.email_provedor as texto,
				   e.email_username||'@'||e.email_provedor as endereco
	  		  from kss.email e
				   inner join kss.kss_usuarios us
				      on us.email_id = e.email_id
			  	   inner join atualizador.email_atualizacao ema
			     	  on ema.email_id = us.email_id
				   inner join kss.kss_usuarios_suporte s
					  on s.cod_projeto   = ema.cod_projeto
					 and s.cod_aplicacao = ema.cod_aplicacao
					 and s.tecnico_suporte = us.usuario   
			where exists( select 'x'
						   from kss.kss_usuarios_suporte ts
						  where ts.cod_projeto     = s.cod_projeto
							and ts.cod_aplicacao   = s.cod_aplicacao
							and ts.tecnico_suporte = user)
       <cfif IsDefined( "arguments.cod_projeto")   and IsNumeric( arguments.cod_projeto )>
		  and s.cod_projeto   = #val( arguments.cod_projeto )#
	   </cfif>
       <cfif IsDefined( "arguments.cod_projeto")   and IsNumeric( arguments.cod_projeto )
	      and IsDefined( "arguments.cod_aplicacao" ) and Len( Trim( arguments.cod_aplicacao ) )>
		  and s.cod_projeto   = #val( arguments.cod_projeto )#
		  and s.cod_aplicacao = '#arguments.cod_aplicacao#'
	   </cfif>
		union              
		 select us.usuario, nvl( us.nome, 'Sem usurio cadastrado ( ' || e.email_username||'@'||e.email_provedor ||')') nome, 'US' || ';' || e.email_username||'@'||e.email_provedor email,
           	 	ema.cod_projeto, ema.cod_aplicacao,e.email_id,
		        internet.pkg_kss_web.fnc_nome_projeto( ema.cod_projeto ) nome_projeto,
             	internet.pkg_kss_web.fnc_nome_aplicacao( ema.cod_projeto, ema.cod_aplicacao ) nome_aplicacao,
				decode(us.nome,null,0,1) as possui_usuario,
				decode(us.nome,null,e.email_username||'@'||e.email_provedor,us.nome||' - '||e.email_username||'@'||e.email_provedor) as texto,
				e.email_username||'@'||e.email_provedor as endereco
				
		   from kss.email e
             	left outer join kss.kss_usuarios us
               	   on us.email_id = e.email_id
				inner join atualizador.email_atualizacao ema
				   on ema.email_id = e.email_id
      	 where exists( select 'x' 
                         from internet.pessoa_usr_aplic_suporte ps
                        where ps.cod_projeto     = ema.cod_projeto
                          and ps.cod_aplicacao   = ema.cod_aplicacao
                          and ps.usuario         = user)
          and not exists( select 'x' 
                            from kss.kss_usuarios_suporte ts
                           where ts.cod_projeto = ema.cod_projeto
                             and ts.cod_aplicacao = ema.cod_aplicacao
                             and ts.tecnico_suporte = us.usuario)
		<cfif IsDefined( "arguments.cod_projeto")   and IsNumeric( arguments.cod_projeto )>
		  and ema.cod_projeto   = #val( arguments.cod_projeto )#
	   </cfif>    
		 <cfif IsDefined( "arguments.cod_projeto")   and IsNumeric( arguments.cod_projeto )
	      and IsDefined( "arguments.cod_aplicacao" ) and Len( Trim( arguments.cod_aplicacao ) )>
		  and ema.cod_projeto   = #val( arguments.cod_projeto )#
		  and ema.cod_aplicacao = '#arguments.cod_aplicacao#'
	   </cfif>
		  order by endereco, email
		</cfquery>
	<cfreturn qrVerificacao />
</cffunction>
















	




<cffunction name="buscar_md5" displayname="Busca o MD5 dos arquivos da Aplicacao" access="remote" returntype="boolean" output="true">	  
	<cfargument name="cod_aplicacao" 			required="false" 	displayname="Cdigo da Aplicao" 	 	type="string"/>

	<cfquery name="qrAtualizados" datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">		
	    select a.cod_projeto,
			   a.cod_aplicacao,
			   a.nome_arquivo,
			   a.pasta_instalacao,
			   d.dir_raiz||'/'||a.cod_projeto||'/'||a.cod_aplicacao||'/'||replace(a.pasta_instalacao, '\', '/')||'/'||a.nome_arquivo as arquivo
		  from atualizador.arquivos a
		 inner join atualizador.dir_servidor_raiz d
				 on d.cod_aplicacao = a.cod_aplicacao
				and d.cod_projeto   = a.cod_projeto
		where a.assinatura is null
		  and a.cod_aplicacao = '#arguments.cod_aplicacao#'
--		  and rownum = 1
	</cfquery>
	<cfoutput query="qrAtualizados">
		<cfset md5_hash = this.f_md5_file(file = qrAtualizados.arquivo)>
		<cfquery datasource="#application.dsn#" username="#session.usuario#" password="#session.senha#">
			update atualizador.arquivos
			   set assinatura = '#md5_hash#'
			 where cod_projeto = '#qrAtualizados.cod_projeto#'
			   and cod_aplicacao = '#qrAtualizados.cod_aplicacao#'
			   and nome_arquivo = '#qrAtualizados.nome_arquivo#'
			   and pasta_instalacao = '#qrAtualizados.pasta_instalacao#'
		</cfquery>

	</cfoutput>
	<cfreturn qrAtualizados.recordcount>
</cffunction>


<cffunction name="enviaVerificacao"  displayname="Envia Verificao para os Usurios"access="Remote" returntype="Struct" output="false">
   <!--- 
   	-- PROPSITO
	-- Envia mensagem de Verificao para os usurios cadastrados ( Suprimir por procedimento armazenado automtico )
	-- NOTAS EXPLICATIVAS
	--  
	-- JEFFERSON          04/11/2003 - criado
	--->			
	<cfargument name="cod_projeto" 		required="true" 	displayname="Cdigo do Projeto" 		type="numeric" />
	<cfargument name="cod_aplicacao" 	required="true"		displayname="Cdigo da Aplicao" 		type="string" />
	<cfargument name="email" 			required="true"		displayname="Email" 					type="string" />

	<cfset var strRetorno 	  =  StructNew() />
	<cfset strRetorno['erro'] =  false />
	<cftry>
		<cfstoredproc procedure="atualizador.pkg_gerenciador_arquivos.prc_notifica_atualizacao" datasource="#this.dsn#" username="#this.usuario#" password="#this.senha#">
			<cfprocparam 	dbvarname="p_destinatario" 	  	type="in" 	 value="#arguments['email']#" 				cfsqltype="cf_sql_varchar" />
			<cfprocparam 	dbvarname="p_cod_projeto" 		type="in"  	 value="#val( arguments['cod_projeto'] )#" 	cfsqltype="cf_sql_integer" />
			<cfprocparam 	dbvarname="p_cod_aplicacao" 	type="in" 	 value="#arguments['cod_aplicacao']#" 		cfsqltype="cf_sql_varchar" />
		</cfstoredproc>
		<cfset strRetorno['mensagem'] = 'Arquivos Sincronizados com sucesso! ' />
		<cfcatch type="any">
			<cfset strRetorno['erro'] 	  =  True />
			<cfset strRetorno['mensagem'] = 'Problemas ao tentar enviar email. \n' & JsStringFormat( cfcatch.Detail ) />
			<cfscript>
						this.enviarErro( // Envia erros 
										  de 		= '<KM&M Engenharia de Sistemas>erro@kmm.com.br',
										  assunto   = 'Erro - ' & cgi.script_name & ' [ '& strRetorno['mensagem'] & ' ]' ,
										  msg_pk	= 'Restrio Exclusiva Violada',
										  msg_pd	=  strRetorno['mensagem'],
										  dump		= cfcatch
									   );
			</cfscript>
		</cfcatch>
	</cftry>	
	<cfreturn strRetorno />
</cffunction>	

--->
</cfcomponent>