<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas de fluxos de documentos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca uma carta frete
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/04/2006
	--->
   	<cffunction name="get_carta_frete" access="remote" returntype="query">
		<cfargument name="cod_documento" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_romaneios" username="#session.usuario#" password="#session.senha#">
				select r.num_romaneio, it.num_lote, it.item_id, oper.pkg_global.fnc_busca_nome_pessoa(it.cod_remetente) as cliente, r.cod_unidade,
					 oper.pkg_global.fnc_municipio(it.rem_cod_uf, it.rem_cod_municipio, it.rem_cod_distrito, it.rem_cod_dv) as carregamento,
					 oper.pkg_global.fnc_municipio(it.dest_cod_uf, it.dest_cod_municipio, it.dest_cod_distrito, it.dest_cod_dv) as destino,
					 cf.frete_em, cf.valor_frete_liquido, cf.peso, cf.cod_documento, 
					 oper.pkg_operacional.fnc_converte_peso(cf.peso,'Kg',cf.cod_unidade) as peso_convertido,
					 cf.volume, cf.m3, cf.valor_frete_bruto, cf.data_emissao, cf.valor_unitario, cf.lancto_id
			    from oper.v$romaneio r 
			   inner join oper.v$romaneio_item it
				       on r.num_romaneio = it.num_romaneio
			   inner join oper.v$carta_frete cf
				       on cf.num_romaneio = r.num_romaneio
			   where 1=1
               <cfif Len(Trim(arguments.cod_documento))>
                 and cf.cod_documento = '#arguments.cod_documento#'
               </cfif>
               <cfif Len(Trim(arguments.num_romaneio))>
                 and r.num_romaneio = #arguments.num_romaneio#
               </cfif>
		</cfquery>
		<cfreturn qr_romaneios>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os itens de uma carta frete
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/04/2006
	--->
  	<cffunction name="get_carta_frete_item" access="remote" returntype="query">
		<cfargument name="lancto_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_itens" username="#session.usuario#" password="#session.senha#">
			select lancto_id, item_id, descricao, valor, desconto, compoe_frete, 
				   deb_cred_motorista, decode(desconto,1,'Desconto','Acrscimo') as desc_tipo
			  from oper.v$carta_frete_item
			 where lancto_id = #arguments.lancto_id#
			 order by descricao
		</cfquery>
		<cfreturn qr_itens>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/04/2006
	--->	
  	<cffunction name="get_carta_frete_lancada" access="remote" returntype="query">
		<cfargument name="lancto_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio, r.situacao_id, it.item_id, oper.pkg_global.fnc_busca_nome_pessoa(it.cod_remetente) as cliente, r.cod_unidade,
				   oper.pkg_global.fnc_municipio(it.rem_cod_uf, it.rem_cod_municipio, it.rem_cod_distrito, it.rem_cod_dv) as carregamento,
				   oper.pkg_global.fnc_municipio(it.dest_cod_uf, it.dest_cod_municipio, it.dest_cod_distrito, it.dest_cod_dv) as destino,
				   cf.frete_em, cf.valor_frete_liquido as frete_total, cf.peso as peso_total, cf.cod_documento, 
				   oper.pkg_operacional.fnc_converte_peso(cf.peso,'Kg',cf.cod_unidade) as peso_convertido,
				   cf.volume as volume_total, cf.m3 as m3_total, cf.valor_frete_bruto, cf.data_emissao, cf.valor_unitario, cf.lancto_id
			  from oper.v$romaneio r 
			 inner join oper.v$romaneio_item it
					 on r.num_romaneio = it.num_romaneio
			 inner join oper.v$carta_frete cf
					 on cf.num_romaneio = r.num_romaneio
			 inner join oper.v$fluxo_docto fd
					 on cf.num_romaneio = fd.num_romaneio
					and cf.item_id = fd.item_id
					and cf.lancto_id = fd.docto_id	
		     where 1=1
			  <cfif len(trim(arguments.lancto_id))>
			   and fd.lancto_id = #arguments.lancto_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os documentos para envio
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  07/04/2006
	--->		
	<cffunction name="get_doctos_para_envio" access="remote" returntype="query" output="true">
		<cfargument name="valor" required="no" default="">
		<cfargument name="tipo" required="no" default="">
		<cfargument name="num_docto" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfswitch expression="#arguments.tipo#">
			<cfcase value="1">
				<cfset arguments.num_docto = arguments.valor>
			</cfcase>
			<cfcase value="2">
				<cfset arguments.num_romaneio = arguments.valor>
			</cfcase>
		</cfswitch>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+FIRST_ROWS USE_HASH(FD FI)*/ fd.lancto_id, 
                       fd.num_romaneio, 
                       fd.docto_id, 
                       fi.data_recebimento, 
                       fi.data_entrega,
                       fi.documento_id,
                       r.carregamento, 
                       r.destino, 
                       df.documento,
                       fd.urgencia,
                       case oper.pkg_global.fnc_get_cod_pessoa_func(oper.pkg_romaneio.fnc_ult_mot_romaneio(fd.num_romaneio))
                       when -1 then oper.pkg_romaneio.fnc_ult_mot_romaneio(fd.num_romaneio)
                       else oper.pkg_global.fnc_get_cod_pessoa_func(oper.pkg_romaneio.fnc_ult_mot_romaneio(fd.num_romaneio)) 
                       end as cod_funcionario,
                       oper.pkg_global.fnc_busca_nome_pessoa(oper.pkg_romaneio.fnc_ult_mot_romaneio(fd.num_romaneio)) as motorista,
                       oper.pkg_fluxo_docto.fnc_num_docto(fd.lancto_id) as num_documento,
                       oper.pkg_fluxo_docto.fnc_tipo(fd.lancto_id) as tipo,
                       fd.urgencia as urgente,
                       decode(fd.urgencia,0,1,lf.cod_pessoa_filial) as cod_pessoa_filial,
                       decode(fd.urgencia,0,3,lf.cod_setor) as cod_setor,
                       decode(sei.cod_setor,3,ser.descricao || ' de ' || sei.municipio, ser.descricao) as setor_faturamento,
                       decode(fd.urgencia,0,1,lf.cod_pessoa_filial) as cod_pessoa_fat,
                       decode(fd.urgencia,0,1,lf.cod_departamento) as cod_departamento_fat,
                       decode(fd.urgencia,0,3,lf.cod_setor) as cod_setor_fat,
                       decode(fd.urgencia,0,1,lf.cod_centro_custo) as cod_centro_custo_fat
                    from oper.v$romaneio r
                   inner join oper.v$fluxo_docto fd
                           on r.num_romaneio = fd.num_romaneio
                   inner join oper.v$romaneio_item rit
                           on rit.num_romaneio = fd.num_romaneio
                          and rit.item_id = fd.item_id
                   inner join oper.v$fluxo_docto_it fi
                           on fi.lancto_id = fd.lancto_id
                   inner join oper.v$documento_frete df
                           on df.documento_id = fi.documento_id
                   inner join oper.v$lote_faturamento lf
                           on lf.num_lote = rit.num_lote
                   inner join kss.v$setor ser
                       on ser.cod_setor = decode(fd.urgencia,0,3,lf.cod_setor)
                   inner join oper.v$setor_informacoes sei
                       on ser.cod_setor = sei.cod_setor 
                      and sei.cod_pessoa_filial = decode(fd.urgencia,0,1,lf.cod_pessoa_filial)
                     where fi.cod_pessoa_filial = #session.cod_pessoa#
                       and fi.cod_setor = #session.cod_setor#
                       and fi.cod_etapa = 'A'
                       and (fi.data_entrega is null or fi.situacao_id = 0)
                     <cfif len(trim(arguments.num_romaneio))>
                       and fd.num_romaneio = #arguments.num_romaneio#
                     </cfif>
                     <cfif len(trim(arguments.num_docto))>
                       and oper.pkg_fluxo_docto.fnc_num_docto(fd.lancto_id) = '#arguments.num_docto#'
                     </cfif>
                      order by 12, 13
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos em CC do perodo para o funcionrio passado.
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/04/2006
	--->
	<cffunction name="get_doctos_prontos_fatura" displayname="Busca todos os lanamentos em CC do perodo para o funcionrio passado." access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
			select fd.num_romaneio, nvl(fi.responsavel,fi.user_insert) as responsavel , fd.cod_docto, 
				   min(fi.data_recebimento) as data_recebimento, max(fi.data_entrega) as data_entrega, r.carregamento, r.destino
			  from oper.v$fluxo_docto fd
			 inner join oper.v$fluxo_docto_it fi
					 on fi.lancto_id = fd.lancto_id
					and fi.cod_etapa = 'F'
			 inner join oper.v$romaneio r
					 on r.num_romaneio = fd.num_romaneio
			 inner join oper.v$romaneio_item rit
					 on rit.num_romaneio = r.num_romaneio
					and rit.item_id = fd.item_id
			 inner join oper.v$lote l
					 on l.num_lote = rit.num_lote
					and l.frete_proprio in (0,2)
			 inner join oper.v$carta_frete cf
					 on cf.lancto_id = fd.docto_id
				    and cf.conhecimento_id is null
				    and cf.crt_receber_id is null		
	       group by fd.num_romaneio, nvl(fi.responsavel,fi.user_insert), fd.cod_docto, r.carregamento, r.destino  
		</cfquery>
		<cfreturn qr_doctos>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca tos documentos em poder do motorista
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/04/2006
	--->
	<cffunction name="get_documentos_motorista" access="remote" returntype="query">
		<cfargument name="cod_pessoa_filial" required="false">
		<cfargument name="cod_departamento" required="false">
		<cfargument name="cod_setor" required="false">
		<cfargument name="cod_centro_custo" required="false">
		<cfargument name="tipo" required="false">
		<cfargument name="tipo_veiculo" required="false">
		<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
			select fd.setor, fd.responsavel, fd.lancto_id, fd.etapa, fd.cod_etapa, fd.num_romaneio, fd.carregamento, rv.cliente, 
				   fd.destino, fd.destinatario, fd.documento_id, fd.documento, fd.tipo, 
				   fd.num_docto, 
				   decode(fd.urgencia,1,fd.setor_faturamento,'Agncia Matriz') as setor_faturamento, 
          		   fd.data_recebimento, 
				   fd.data_entrega, fd.situacao_it, fd.situacao_lancto, fd.situacao_id_it, 
				   fd.urgencia as urgente,
				   fd.situacao_id_lancto, fd.sequencia, fd.cod_setor, fd.cod_departamento, fd.cod_centro_custo, fd.cod_pessoa,
                   oper.pkg_global.FNC_BUSCA_NOME_PESSOA(rv.cod_pessoa) as nome_funcionario,
				   oper.pkg_global.fnc_get_cod_funcionario(rv.cod_pessoa) as cod_funcionario, 
				   rv.cod_pessoa as cod_funcionario,
				   rv.data_termino_descarga
                  , (select max(l.frete_proprio)
                      from oper.v$romaneio_item ri
                inner join oper.v$lote l
                   on l.num_lote = ri.num_lote
               where ri.num_romaneio = fd.num_romaneio
                  ) as frete_proprio
			  from (select r.data_termino_descarga, rhv.cod_pessoa, rhv.num_romaneio, r.cliente
					  from oper.v$romaneio_hist_veiculo rhv
					 inner join oper.v$romaneio r
					    on r.num_romaneio = rhv.num_romaneio
					   and r.situacao_id <> 0
					 where nvl(rhv.data_termino, sysdate) =
						   (select max(nvl(rhv2.data_termino, sysdate))
							  from oper.v$romaneio_hist_veiculo rhv2
							 where rhv2.num_romaneio = rhv.num_romaneio)) rv 
             inner join oper.v$fluxo_documento fd
                on rv.num_romaneio = fd.num_romaneio
			 where fd.situacao_id_it = 0
			   and cod_etapa = 'M'
			   <cfif isDefined("arguments.tipo")>
				   and  fd.urgencia = #arguments.tipo#
			   </cfif>
			 <cfif isDefined("arguments.tipo_veiculo")>
			   <cfswitch expression="#arguments.tipo_veiculo#">
			   	  <cfcase value="1">
					   and exists (select 'x'
					                 from oper.v$veiculo_frota_geral vf
									where vf.placa = fd.placa_controle)
				  </cfcase>
			   	  <cfcase value="2">
					   and not exists (select 'x'
					                 from oper.v$veiculo_frota_geral vf
									where vf.placa = fd.placa_controle)
				  </cfcase>
			   </cfswitch>
			 </cfif>
			 order by nome_funcionario, fd.lancto_id, fd.num_docto
             
		</cfquery>
		<cfreturn qr_doctos>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca os documentos para confirmao de recebimento
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/04/2006
	--->	
	<cffunction name="get_documentos_pacote" access="remote" returntype="query">
		<cfargument name="lancto_id" required="false">
		<cfargument name="num_romaneio" required="false">
		<cfargument name="num_docto" required="false">
		<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
			select case
				      when fd.cod_etapa = 'M' then 1
				      when fd.cod_etapa = 'A' then 2
				      when fd.cod_etapa = 'MA' then 3
				   else 5
				   end ordem,				   
				   fd.lancto_id, fd.cod_etapa, fd.etapa, fd.num_romaneio, fd.carregamento, fd.destino, fd.destinatario, 
				   fd.tipo, fd.num_docto, fd.num_docto || fd.docto_id as num_docto_id, fd.setor, fd.setor_faturamento, fd.data_recebimento, 
				   fd.data_entrega, fd.situacao_it, fd.situacao_lancto, fd.situacao_id_it, 
				   fd.situacao_id_lancto, fd.responsavel, fd.sequencia, fd.documento_id, fd.documento,
				   rv.cod_pessoa as cod_motorista, oper.pkg_global.fnc_busca_nome_pessoa(rv.cod_pessoa) as nome_motorista
		      from oper.v$fluxo_documento fd
			  inner join (select rhv.cod_pessoa, rhv.num_romaneio
						    from oper.v$romaneio_hist_veiculo rhv
					 	   where nvl(rhv.data_termino, sysdate) = (select max(nvl(rhv2.data_termino, sysdate))
																	 from oper.v$romaneio_hist_veiculo rhv2
																    where rhv2.num_romaneio = rhv.num_romaneio)) rv 							 
					  on fd.num_romaneio = rv.num_romaneio
			  <cfif isDefined("arguments.lancto_id")>
			   where fd.lancto_id = #arguments.lancto_id#
			 </cfif>
			  <cfif isDefined("arguments.num_romaneio")>
			   where fd.num_romaneio = #arguments.num_romaneio#
			 </cfif>
			  <cfif isDefined("arguments.num_docto")>
			   where fd.docto_id in (select /*+ ORDERED */ docto_id
									   from (select cf.lancto_id as docto_id
											   from oper.v$carta_frete cf
											  where cf.cod_documento = to_char(#arguments.num_docto#)
								
											  union
								
											 select c.conhecimento_id as docto_id
											   from oper.v$conhecimento c
											  where c.num_conhecimento = #arguments.num_docto#
								
											  union
								
											 select ct.LANCTO_ID as docto_id
											   from oper.v$contrato_transp ct
											  where ct.num_formulario = #arguments.num_docto#))
			 </cfif>
			 order by num_docto_id, fd.documento, 1
		</cfquery>
		<cfreturn qr_doctos>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os documentos para confirmao de recebimento
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/04/2006
	--->
	<cffunction name="get_documentos_pendentes" access="remote" returntype="query">
		<cfargument name="lancto_id" 		 required="false" default="">
		<cfargument name="num_romaneio" 	 required="false" default="">
		<cfargument name="num_docto" 		 required="false" default="">
		<cfargument name="cod_funcionario" 	 required="false" default="">
		<cfargument name="cod_etapa" 		 required="false" default="">
		<cfargument name="cod_pessoa_filial" required="false" default="">
		<cfargument name="cod_departamento"  required="false" default="">
		<cfargument name="cod_setor" 		 required="false" default="">
		<cfargument name="cod_centro_custo"  required="false" default="">
		<cfargument name="data_envio" 		 required="false" default="">
		<cfargument name="pendentes" 		 required="false" default="0">
		<cfargument name="local"			 required="false" default="">
		<cfargument name="order_filial" 	 required="false" default="0">	

 	    <cfif len(trim(arguments.cod_funcionario))>
			<cfquery datasource="#session.dsn#" name="qr_func" username="#session.usuario#" password="#session.senha#" timeout="25">
				select decode(oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_funcionario#))
					   as cod_funcionario,
					   decode(oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#))  as cod_pessoa
				   from dual
			</cfquery>
		</cfif>

		<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
			select distinct fd.lancto_id, fd.etapa, fd.cod_etapa, fd.num_romaneio, fd.item_id, fd.redespacho, fd.carregamento, fd.destino, 
				   fd.destinatario, fd.documento_id, fd.documento, fd.tipo, 
				   fd.num_docto, fd.serie, 
				   oper.pkg_global.FNC_BUSCA_NOME_PESSOA(rv.cod_pessoa) as nome,
				   oper.pkg_global.fnc_get_cod_funcionario(rv.cod_pessoa) as cod_funcionario,
				   fd.urgencia as urgente,
				   fd.cod_pessoa as cod_filial_responsavel, fd.cod_setor as cod_setor_responsavel, 
				   fd.setor, fd.setor_faturamento as local_faturamento, 
				   fd.cod_pessoa_filial_fat as cod_pessoa_faturamento, fd.cod_setor_fat, 
				   fd.data_recebimento, fd.data_entrega, 
				   fd.situacao_it, fd.situacao_lancto, fd.situacao_id_it, fd.situacao_id_lancto, fd.responsavel, 
				   fd.sequencia, fd.placa_controle,decode(fd.situacao_id_it, 1, 'OK', 'Pendente') as situacao, 
				   (select distinct decode(s.cod_setor, 3, s.descricao || ' - ' || pj.nome_fantasia, s.descricao)
					  from oper.v$setor s
					 inner join kss.v$kss_usuario_lotacao ul
						on s.cod_pessoa_filial = ul.cod_pessoa
					   and s.cod_setor = ul.cod_setor
					 inner join oper.v$pessoa_juridica pj
					         on pj.cod_pessoa = ul.cod_pessoa
					 where ul.usuario = fd.responsavel) as local_envio				   
			  from (select rhv.cod_pessoa, rhv.num_romaneio
					  from oper.v$romaneio_hist_veiculo rhv
					 inner join oper.v$romaneio r 
						on rhv.num_romaneio = r.num_romaneio
				       and r.situacao_id in (1,2)
				     where nvl(rhv.data_termino, sysdate) = (select max(nvl(rhv2.data_termino, sysdate))
																   from oper.v$romaneio_hist_veiculo rhv2
																  where rhv2.num_romaneio = rhv.num_romaneio)) rv 
			  inner join oper.v$fluxo_documento fd 
				   on fd.num_romaneio = rv.num_romaneio 
			   where 1 = 1 		 
			 <cfif len(trim(arguments.COD_PESSOA_FILIAL)) and len(trim(arguments.COD_SETOR)) and len(trim(arguments.DATA_ENVIO))>
				 and fd.cod_etapa = 'F'
				 and fd.cod_pessoa = #session.cod_pessoa#
				 and fd.cod_setor = #session.cod_setor#
				 and exists (select 'x' 
							   from oper.v$fluxo_docto_it fi2
							  where fd.lancto_id = fi2.lancto_id
								and fi2.cod_pessoa_filial = #arguments.cod_pessoa_filial#
								and fi2.cod_setor = #arguments.cod_setor# 
								and fi2.situacao_id = 0
								and trunc(fi2.data_entrega) = '#arguments.data_envio#'
								and fi2.cod_etapa = 'A')			 
			  <cfelse>
				 <cfif len(trim(arguments.lancto_id))>
				   and fd.lancto_id = #arguments.lancto_id#
				 </cfif>
				 <cfif len(trim(arguments.num_romaneio))>
				   and fd.num_romaneio = #arguments.num_romaneio#
				 </cfif>
				 <cfif len(trim(arguments.num_docto))>
				   and fd.num_docto = '#arguments.num_docto#'
				 </cfif>
				 <cfif len(trim(arguments.cod_funcionario))>
				   and rv.cod_pessoa = #qr_func.cod_pessoa#
				 </cfif>
				 <cfif len(trim(arguments.cod_pessoa_filial)) and len(trim(arguments.cod_setor)) >
				   and fd.cod_pessoa = #arguments.cod_pessoa_filial#
				   and fd.cod_setor = #arguments.cod_setor#
				 </cfif>
				 <cfif len(trim(arguments.local))>
				   and fd.cod_pessoa = #session.cod_pessoa#
				   and fd.cod_setor = #session.cod_setor#
				 </cfif>
				 <cfif arguments.cod_etapa neq 'F'>
				   and fd.cod_etapa in (#ListQualify(arguments.cod_etapa,"'",",")#)
				 <cfelseif arguments.cod_etapa eq 'F'>
				   and fd.cod_etapa = '#arguments.cod_etapa#'
				   and exists (select 'x'
								 from oper.v$fluxo_docto_it fi2
								where fd.lancto_id = fi2.lancto_id
								  and fi2.cod_etapa = 'A'
								  and fi2.situacao_id = 0)
				 </cfif>			 
				 <cfif arguments.pendentes neq 0>
				   and fd.situacao_id_it = 0
				 </cfif>			
			 </cfif>			  
			 <cfif arguments.order_filial eq 1>
				 order by fd.cod_pessoa, fd.cod_setor, fd.data_entrega, fd.responsavel
			 <cfelse>
				 order by fd.num_romaneio, fd.num_docto, fd.lancto_id
			 </cfif>			   			  
		</cfquery>
		<cfreturn qr_doctos>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os romaneios
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/04/2006
	--->
  	<cffunction name="get_romaneios" access="remote" returntype="query">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_romaneios" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio, r.situacao_id, it.item_id, oper.pkg_global.fnc_busca_nome_pessoa(it.cod_remetente) as cliente, r.cod_unidade,
				   oper.pkg_global.fnc_municipio(it.rem_cod_uf, it.rem_cod_municipio, it.rem_cod_distrito, it.rem_cod_dv) as carregamento,
				   oper.pkg_global.fnc_municipio(it.dest_cod_uf, it.dest_cod_municipio, it.dest_cod_distrito, it.dest_cod_dv) as destino,
				   r.frete_em, r.frete_total, r.peso_total, 
				   oper.pkg_operacional.fnc_converte_peso(r.peso_total,'Kg',r.cod_unidade) as peso_convertido,
				   r.frete_total / decode(oper.pkg_operacional.fnc_converte_peso(r.peso_total,'Kg',r.cod_unidade),0,1,oper.pkg_operacional.fnc_converte_peso(r.peso_total,'Kg',r.cod_unidade)) as valor_unitario,
				   r.volume_total, r.m3_total
			  from oper.v$romaneio r 
	         inner join oper.v$romaneio_item it
                on r.num_romaneio = it.num_romaneio
			 inner join oper.v$lote l
			    on it.num_lote = l.num_lote
		       and 	l.frete_proprio <> 1
			 where 1=1
			  <cfif len(trim(arguments.num_romaneio))>
			   and r.num_romaneio = #arguments.num_romaneio#
			 </cfif>
		</cfquery>
		<cfreturn qr_romaneios>
	</cffunction>	
    
	<!--- 
	-- PROPSITO 
	-- Busca os romaneios
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/04/2006
	--->
  	<cffunction name="get_romaneio" access="remote" returntype="query">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_romaneios" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio, r.situacao_id, it.item_id, oper.pkg_global.fnc_busca_nome_pessoa(it.cod_remetente) as cliente, r.cod_unidade,
				   oper.pkg_global.fnc_municipio(it.rem_cod_uf, it.rem_cod_municipio, it.rem_cod_distrito, it.rem_cod_dv) as carregamento,
				   oper.pkg_global.fnc_municipio(it.dest_cod_uf, it.dest_cod_municipio, it.dest_cod_distrito, it.dest_cod_dv) as destino,
				   r.frete_em, r.frete_total, r.peso_total, 
				   oper.pkg_operacional.fnc_converte_peso(r.peso_total,'Kg',r.cod_unidade) as peso_convertido,
				   r.frete_total / decode(oper.pkg_operacional.fnc_converte_peso(r.peso_total,'Kg',r.cod_unidade),0,1,oper.pkg_operacional.fnc_converte_peso(r.peso_total,'Kg',r.cod_unidade)) as valor_unitario,
				   r.volume_total, r.m3_total
			  from oper.v$romaneio r 
	         left join oper.v$romaneio_item it
                on r.num_romaneio = it.num_romaneio
			 left join oper.v$lote l
			    on it.num_lote = l.num_lote
		       and 	l.frete_proprio <> 1
			 where 1=1
			  <cfif len(trim(arguments.num_romaneio))>
			   and r.num_romaneio = #arguments.num_romaneio#
			 </cfif>
		</cfquery>
		<cfreturn qr_romaneios>
	</cffunction>	    

	<!--- 
	-- PROPSITO 
	-- Busca os romaneios
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/04/2006
	--->
  	<cffunction name="get_romaneio_item" access="remote" returntype="query">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_romaneios" username="#session.usuario#" password="#session.senha#">
            select ri.num_romaneio, ri.item_id, 
                   pr.cliente as remetente, mr.sigla_uf as rem_uf, mr.nome_municipio as rem_municipio,
                   pd.cliente as destinatario, md.sigla_uf as dest_uf, md.nome_municipio as dest_municipio,
                   ri.num_lote, (ri.peso/1000) as peso, 
                   f.lancto_id as lancto_fluxo_id, coalesce(f.conhecimento_id,f.carta_frete_id) as docto_id_fluxo
              from oper.v$romaneio_item ri
              inner join kss.v$pessoa pr
                      on pr.cod_pessoa = ri.cod_remetente
              left join kss.v$pessoa pd
                      on pd.cod_pessoa = ri.cod_destinatario
              inner join cep.ibge_municipio mr
                      on mr.cod_uf = ri.rem_cod_uf
                     and mr.cod_municipio = ri.rem_cod_municipio
                     and mr.cod_distrito = ri.rem_cod_distrito
                     and mr.cod_dv = ri.rem_cod_dv 
              left join cep.ibge_municipio md
                      on md.cod_uf = ri.dest_cod_uf
                     and md.cod_municipio = ri.dest_cod_municipio
                     and md.cod_distrito = ri.dest_cod_distrito
                     and md.cod_dv = ri.dest_cod_dv 
              left join oper.v$fluxo_docto f
                     on f.num_romaneio = ri.num_romaneio
                     and f.item_id = ri.item_id
                 where 1=1
                  <cfif len(trim(arguments.num_romaneio))>
                   and ri.num_romaneio = #arguments.num_romaneio#
                 </cfif>
		</cfquery>
		<cfreturn qr_romaneios>
	</cffunction>	    
    
	<!--- 
	-- PROPSITO 
	-- Busca os romaneios
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  24/04/2006
	--->
  	<cffunction name="get_fluxo_romaneio" access="remote" returntype="query">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_romaneios" username="#session.usuario#" password="#session.senha#">
            select f.lancto_id, f.num_romaneio, f.item_id, 
                   f.cod_docto, f.docto_id, f.conhecimento_id, f.carta_frete_id,
                   f.tipo_docto_id, r.carregamento, r.destino, r.cliente, f.situacao_id,
                   decode(f.tipo_docto_id,1,'Conhecimento','Carta Frete') as tipo_docto, 
                   case 
                     when f.tipo_docto_id = 1 then c.rem_razao_social
                   else r.cliente end cliente,
                   case 
                     when f.tipo_docto_id = 1 then c.dest_razao_social
                   else oper.pkg_global.fnc_busca_nome_pessoa(cf.cod_destinatario) end destinatario       
              from oper.v$fluxo_docto f
              inner join oper.v$romaneio r
                      on r.num_romaneio = f.num_romaneio
              left join oper.v$carta_frete cf
                     on cf.lancto_id = f.carta_frete_id
                    and f.tipo_docto_id = 2 
              left join fiscal.v$conhecimento c
                     on c.conhecimento_id = f.conhecimento_id
                    and f.tipo_docto_id = 1 
			 where 1=1
			  <cfif len(trim(arguments.num_romaneio))>
			   and r.num_romaneio = #arguments.num_romaneio#
			 </cfif>
		</cfquery>
		<cfreturn qr_romaneios>
	</cffunction>	    
    
		
	<!--- 
	-- PROPSITO 
	-- Busca os documentos do romaneio
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/04/2006
	--->
	<cffunction name="get_romaneios_documentos" access="remote" returntype="query">
		<cfargument name="local" required="false">
		<cfargument name="receber" required="false">
		<cfargument name="urgente" required="false">
		<cfargument name="cod_pessoa_filial" required="false">
		<cfargument name="cod_departamento" required="false" default="2">
		<cfargument name="cod_setor" required="false">
		<cfargument name="cod_centro_custo" required="false" default="1">
		<cfargument name="tipo_veiculo" required="false">
		<cfargument name="cod_etapa" required="false">
		<cfquery datasource="#session.dsn#" name="qr_doctos" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered*/fd.lancto_id, fd.num_romaneio, fd.docto_id, num_docto, carregamento, destino, cliente,
				   serie, responsavel, setor_faturamento, setor, cod_pessoa_filial_fat, 
				   cod_departamento_fat, cod_setor_fat, cod_centro_custo_fat, urgente, 
   				   min(data_entrega) as data_entrega, min(data_recebimento) as data_recebimento
                 , (select max(l.frete_proprio)
            from oper.v$romaneio_item ri
           inner join oper.v$lote l
              on l.num_lote = ri.num_lote
           where ri.num_romaneio = fd.num_romaneio
              ) as frete_proprio
                 , (select c.sigla_uf
                      from cep.cep_ufs c
                     where c.cod_uf = fd.org_cod_uf ) as origem_uf
			  from oper.v$fluxo_docto fo
             inner join oper.v$fluxo_docto_romaneio fd
                     on fd.lancto_id = fo.lancto_id
			 inner join (select oper.fnc_veiculo_proprietario(r.placa_controle) as proprietario, r.num_romaneio
					 from oper.v$romaneio r) r1                                
				  on fd.num_romaneio = r1.num_romaneio			  
			 <cfif isDefined("arguments.tipo_veiculo")>
			   <cfswitch expression="#arguments.tipo_veiculo#">
				  <cfcase value="1">
					   and r1.proprietario <> 3
				  </cfcase>
				  <cfcase value="2">
					   and r1.proprietario = 3
				  </cfcase>
			   </cfswitch>
			 </cfif>
			  where 1 = 1
			  	<cfif IsDefined("vars.cod_etapa")>
					and fd.cod_etapa in (#ListQualify(vars.cod_etapa,"'",",")#)
				<cfelse>
					and	fd.cod_etapa = 'A'
				</cfif>
				<cfif isDefined("arguments.urgente") and arguments.urgente eq 1>
					and  decode(decode(fd.documento_id,11,11,0),11,0,fo.urgencia) = 1
				<cfelseif isDefined("arguments.urgente") and arguments.urgente eq 0>	
					and  decode(decode(fd.documento_id,11,11,0),11,0,fo.urgencia) = 0
				</cfif>
			  <cfif isDefined("arguments.local")>
				  <cfif isDefined("arguments.cod_pessoa_filial")>
					  and fd.cod_pessoa_filial = #arguments.cod_pessoa_filial#
					  and fd.cod_departamento = #arguments.cod_departamento#
					  and fd.cod_setor = #arguments.cod_setor#
					  and fd.cod_centro_custo = #arguments.cod_centro_custo#
			   <cfelse>
					and fd.cod_pessoa_filial = #session.cod_pessoa#
					and fd.cod_departamento = #session.cod_departamento#
					and fd.cod_setor = #session.cod_setor#
					and fd.cod_centro_custo = #session.cod_centro_custo#
			   </cfif>
			 </cfif>
				 <cfif isDefined("arguments.receber")>
					and (fo.urgencia = 1 
							 or (fd.cod_pessoa_filial_fat = 1 and fd.cod_setor_fat = 3))
					   <cfif isDefined("arguments.cod_pessoa_filial")>
							   and fd.cod_pessoa_filial_fat = #arguments.cod_pessoa_filial#
							 and fd.cod_setor_fat = #arguments.cod_setor#
					   <cfelse>
						   and fd.cod_pessoa_filial_fat = #session.cod_pessoa#
						   and fd.cod_setor_fat = #session.cod_setor#
					   </cfif>
			     </cfif>
			   group by fd.lancto_id, fd.num_romaneio, fd.docto_id, num_docto, carregamento, destino, cliente,
				   serie, responsavel, setor_faturamento, setor, cod_pessoa_filial_fat, 
				   cod_departamento_fat, cod_setor_fat, cod_centro_custo_fat, urgente,org_cod_uf
			   order by setor, origem_uf, serie, lpad(num_docto , 40, 0)
		</cfquery>
		<cfreturn qr_doctos>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os totais de documentos em tramite
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/04/2006
	--->
	<cffunction name="get_romaneio_motorista" access="remote" returntype="query">
		<cfargument name="num_romaneio" required="true">
		<cfquery datasource="#session.dsn#" name="qr_romaneios" username="#session.usuario#" password="#session.senha#">
			select r.placa_controle, oper.pkg_global.fnc_get_cod_funcionario(rhv.cod_pessoa) as cod_funcionario,
             	   oper.pkg_global.fnc_busca_nome_pessoa(rhv.cod_pessoa) as nome_funcionario
			  from oper.v$romaneio r 
		     inner join oper.v$romaneio_hist_veiculo rhv
			    on r.num_romaneio = rhv.num_romaneio
			   and rhv.data_inicio = (select max(rhv2.data_inicio)
									    from oper.v$romaneio_hist_veiculo rhv2
									   where rhv2.num_romaneio = rhv.num_romaneio)
		     where r.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_romaneios>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os totais de documentos em tramite
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  12/04/2006
	--->
   	<cffunction name="get_totais_doctos" access="remote" returntype="query">
		<cfquery datasource="#session.dsn#" name="qr_totais" username="#session.usuario#" password="#session.senha#">
			select env.env_enviados, 
				   env.env_nao_enviados, 
				   rec.rec_a_confirmar, 
				   rec.rec_nao_enviados
			  from (select  nvl(sum(decode(fit.data_entrega, null,0,1)),0) as env_enviados, 
						    nvl(sum(decode(fit.data_entrega, null,1,0)),0) as env_nao_enviados
					   from oper.v$fluxo_docto_it fit
  					  where fit.situacao_id = 0
  						and fit.cod_etapa = 'A'
  						and fit.cod_pessoa_filial = #session.cod_pessoa#
  						and fit.cod_departamento = #session.cod_departamento#
  						and fit.cod_setor = #session.cod_setor#
  						and fit.cod_centro_custo = #session.cod_centro_custo#) env,         
				   (select nvl(sum(decode(fit.data_entrega, null,0,1)),0) as rec_a_confirmar, 
                           nvl(sum(decode(fit.data_entrega, null,1,0)),0) as rec_nao_enviados
                      from oper.v$fluxo_docto fd
                     inner join oper.v$fluxo_docto_it fit
                             on fit.lancto_id = fd.lancto_id
                     inner join oper.v$romaneio_item rit
                             on rit.num_romaneio = fd.num_romaneio
                            and rit.item_id = fd.item_id
                     inner join oper.v$lote_faturamento lf
                             on lf.num_lote = rit.num_lote
                     where fit.situacao_id = 0
                       and fit.cod_etapa = 'A'
                       and decode(fd.urgencia,0,1,lf.cod_pessoa_filial) = #session.cod_pessoa#
                       and decode(fd.urgencia,0,3,lf.cod_setor) = #session.cod_setor#) rec
		</cfquery>
		<cfreturn qr_totais>
	</cffunction>		   	
	
	<!--- 
	-- PROPSITO 
	-- Busca os documentos do resumo
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_totais_doctos_detalhes" access="remote" returntype="query" output="true">
		<cfargument name="tipo" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.tipo eq 1>
				select num_romaneio, fit.num_docto, cliente, carregamento, destino, fit.data_entrega
				  from oper.v$fluxo_docto_romaneio fit
				 where fit.cod_etapa = 'A'
				   and fit.cod_pessoa_filial = #session.cod_pessoa#
				   and fit.cod_departamento = #session.cod_departamento#
				   and fit.cod_setor = #session.cod_setor#
				   and fit.cod_centro_custo = #session.cod_centro_custo#
				   and fit.data_entrega is not null
			<cfelseif arguments.tipo eq 2>
				select num_romaneio, fit.num_docto, cliente, carregamento, destino, fit.data_entrega
				  from oper.v$fluxo_docto_romaneio fit
				 where fit.cod_etapa = 'A'
				   and fit.cod_pessoa_filial = #session.cod_pessoa#
				   and fit.cod_departamento = #session.cod_departamento#
				   and fit.cod_setor = #session.cod_setor#
				   and fit.cod_centro_custo = #session.cod_centro_custo#
				   and fit.data_entrega is null
			<cfelseif arguments.tipo eq 3>
				select rit.num_romaneio, '' as num_docto, r.cliente, r.carregamento, r.destino, fit.DATA_ENTREGA
				  from oper.v$fluxo_docto fd
				 inner join oper.v$fluxo_docto_it fit on fit.lancto_id =
														 fd.lancto_id
				 inner join oper.v$romaneio_item rit on rit.num_romaneio =
														fd.num_romaneio
													and rit.item_id = fd.item_id
				 inner join oper.v$romaneio r on r.num_romaneio = rit.num_romaneio
				 inner join oper.v$lote_faturamento lf on lf.num_lote = rit.num_lote
				 where fit.situacao_id = 0
				   and fit.cod_etapa = 'A'
				   and decode(fd.urgencia, 0, 1, lf.cod_pessoa_filial) = #session.cod_pessoa#
				   and decode(fd.urgencia, 0, 3, lf.cod_setor) = #session.cod_setor# 
				   and fit.data_entrega is not null 
			<cfelse>
				select rit.num_romaneio, '' as num_docto, r.cliente, r.carregamento, r.destino, fit.DATA_ENTREGA
				  from oper.v$fluxo_docto fd
				 inner join oper.v$fluxo_docto_it fit on fit.lancto_id =
														 fd.lancto_id
				 inner join oper.v$romaneio_item rit on rit.num_romaneio =
														fd.num_romaneio
													and rit.item_id = fd.item_id
				 inner join oper.v$romaneio r on r.num_romaneio = rit.num_romaneio
				 inner join oper.v$lote_faturamento lf on lf.num_lote = rit.num_lote
				 where fit.situacao_id = 0
				   and fit.cod_etapa = 'A'
				   and decode(fd.urgencia, 0, 1, lf.cod_pessoa_filial) = #session.cod_pessoa#
				   and decode(fd.urgencia, 0, 3, lf.cod_setor) = #session.cod_setor# 
				   and fit.data_entrega is null 
			</cfif>			
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os documentos pendentes de baixa de recebimento
    -- ANDERSON 03/03/2010 - CRIADO
    --->		
    <cffunction name="get_documentos_pendentes_baixa_recebimento" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="urgente" required="no" default="">
        <cfargument name="tipo_veiculo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.lancto_id
                 , x.num_docto
                 , x.num_romaneio
                 , (select max(l.frete_proprio)
                      from oper.v$romaneio_item ri
                     inner join oper.v$lote l
                             on l.num_lote = ri.num_lote
                     where ri.num_romaneio = x.num_romaneio
                   ) as frete_proprio
                 , x.cod_pessoa_filial
                 , x.filial
                 , x.cod_setor
                 , x.setor
                 , (select r.cliente
                      from oper.v$romaneio r
                     where r.num_romaneio = x.num_romaneio
                   ) as cliente
                 , x.serie
                 , x.carregamento
                 , x.destino
                 , x.data_recebimento
                 , x.data_entrega
                 , x.urgente
                 , (select c.sigla_uf
                      from cep.cep_ufs c
                     where c.cod_uf = x.org_cod_uf ) as origem_uf
              from (
                    select t.lancto_id
                         , t.num_docto
                         , t.num_romaneio
                         , t.cod_pessoa_filial
                         , (select f.nome
                              from oper.v$filial f
                             where f.cod_pessoa = t.cod_pessoa_filial
                           ) as filial
                         , t.cod_setor
                         , (select s.descricao
                              from oper.v$setor s
                             where s.cod_pessoa_filial = t.cod_pessoa_filial
                               and s.cod_setor = t.cod_setor
                           ) as setor
                         , t.serie
                         , t.carregamento
                         , t.destino
                         , t.data_recebimento
                         , t.data_entrega
                         , t.urgencia as urgente
                         , t.org_cod_uf
                      from (
                            select fd.lancto_id
                                 , fd.num_docto
                                 , fd.num_romaneio
                                 , nvl(
                                       (select fi.cod_pessoa_filial
                                          from oper.v$fluxo_docto_it fi
                                         where fi.lancto_id = fd.lancto_id
                                           and fi.cod_etapa = 'A'
                                           and rownum = 1),
                                       (select fi.cod_pessoa_filial
                                          from oper.v$fluxo_docto_it fi
                                         where fi.lancto_id = fd.lancto_id
                                           and fi.cod_etapa = 'M'
                                           and rownum = 1)
                                      ) as cod_pessoa_filial
                                 , nvl(
                                       (select fi.cod_setor
                                          from oper.v$fluxo_docto_it fi
                                         where fi.lancto_id = fd.lancto_id
                                           and fi.cod_etapa = 'A'
                                           and rownum = 1),
                                       (select fi.cod_setor
                                          from oper.v$fluxo_docto_it fi
                                         where fi.lancto_id = fd.lancto_id
                                           and fi.cod_etapa = 'M'
                                           and rownum = 1)
                                      ) as cod_setor
                                 , fd.serie
                                 , fd.carregamento
                                 , fd.destino
                                 , fd.data_recebimento
                                 , fd.data_entrega
                                 , fd.urgencia
                                 , fr.org_cod_uf
                              from oper.v$fluxo_documento fd
                             inner join oper.v$fluxo_docto_romaneio fr
                    			on fd.lancto_id = fr.lancto_id
                             where fd.cod_etapa in ('MA', 'F')
                               and fd.data_entrega is null
                               and not exists (select 1
                                                 from oper.v$lote l
                                                where l.num_lote = fd.num_lote
                                                  and l.frete_proprio <> 1
                                                  and fd.situacao_id_it = 1
                                              )
							<cfif Len(Trim(arguments.urgente))>
                               and decode(decode(fd.documento_id, 11, 11, 0), 11, 0, fd.urgencia) = #arguments.urgente#
                            </cfif>
                            <cfif Len(Trim(arguments.tipo_veiculo))>
                                <cfif arguments.tipo_veiculo eq 1>
                                    and oper.fnc_veiculo_proprietario(fd.placa_controle) <> 3
                                <cfelseif arguments.tipo_veiculo eq 2>
                                    and oper.fnc_veiculo_proprietario(fd.placa_controle) = 3
                                </cfif>
                            </cfif>
                             group by fd.lancto_id
                                    , fd.num_docto
                                    , fd.num_romaneio
                                    , fd.serie
                                    , fd.carregamento
                                    , fd.destino
                                    , fd.data_recebimento
                                    , fd.data_entrega
                                    , fd.urgencia
                                    , fr.org_cod_uf
                           ) t
                     where 1 = 1
					<cfif Len(Trim(arguments.cod_pessoa_filial))>
                       and t.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_setor))>
                       and t.cod_setor = #arguments.cod_setor#
                    </cfif>
                   ) x
            order by x.filial
                  , x.setor
                  , origem_uf
                  , x.serie
                  , lpad(x.num_docto , 40, 0)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os itens de uma carta frete
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 02/12/2010
	--->
  	<cffunction name="get_carta_frete_nf" access="remote" returntype="query">
		<cfargument name="lancto_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_itens" username="#session.usuario#" password="#session.senha#">
			select to_char(cn.data_emissao,'dd/mm/yyyy') as data_emissao
                 , cn.modelo
                 , cn.serie
                 , cn.sub_serie
                 , cn.numero
                 , cn.valor_total
                 , cn.cfop
                 , nvl(cn.cfop, fiscal.pkg_cte.fnc_cfop_nf_carta_frete(cn.lancto_id)) as cfop_calculado
              from oper.v$carta_frete_nota_fiscal cn
			 where cn.lancto_id = #arguments.lancto_id#
			 order by numero
		</cfquery>
		<cfreturn qr_itens>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca o Destinatrio de uma carta frete
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 02/12/2010
	--->
  	<cffunction name="get_carta_frete_destinatario" access="remote" returntype="query">
		<cfargument name="lancto_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_itens" username="#session.usuario#" password="#session.senha#">
			select p.cnpj_cpf
              from oper.v$carta_frete cf
             inner join kss.v$pessoa p
                on p.cod_pessoa = cf.cod_destinatario
			 where cf.lancto_id = #arguments.lancto_id#
		</cfquery>
		<cfreturn qr_itens>
	</cffunction>
</cfcomponent>