<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de pneus" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as contas correntes cadastradas no sistema
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/03/2006
	--->		
	<cffunction name="get_ccorrente" access="remote" returntype="query" output="true">
		<cfargument name="cod_conta" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="ativo" required="no" default="">
		<cfargument name="modalidade_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="saldo" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cc.cod_conta,
				   cc.descricao_conta,
				   cc.cod_pessoa,
				   cc.modalidade_id,
				   ccm.descricao as modalidade,
				   cc.data_abertura,
				   cc.cod_moeda,
				   cc.ativo,
				   mb.descricao_moeda,
				  <cfif arguments.saldo eq 1>
				   round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta,sysdate),2) as saldo,
				  </cfif>
				   p.cnpj_cpf,
				   p.cliente,
				   case when exists (select 'x'
				                       from finan.v$ccorrente_lancamento ccl
									  where ccl.cod_conta = cc.cod_conta) then 0
		             else 1 end sem_lancamentos 
			  from finan.v$ccorrente cc
			 inner join kss.v$pessoa p
			         on p.cod_pessoa = cc.cod_pessoa
			 inner join finan.v$ccorrente_modalidade ccm
					 on ccm.modalidade_id = cc.modalidade_id
			 inner join oper.v$moeda_bacen mb
					 on mb.cod_moeda = cc.cod_moeda
		     where 1=1
			 <cfif len(trim(arguments.cod_conta))>
			   and cc.cod_conta = #arguments.cod_conta#
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa))>
			   and cc.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif len(trim(arguments.ativo))>
			   and cc.ativo = #arguments.ativo#
			 </cfif>
			 <cfif len(trim(arguments.modalidade_id))>
			   and cc.modalidade_id in (#arguments.modalidade_id#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(cc.data_abertura) >= to_date('#arguments.data_inicial#','dd/mm/yyyy')
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(cc.data_abertura) <= to_date('#arguments.data_final#','dd/mm/yyyy')
			 </cfif>
			 
			 order by cod_pessoa, modalidade_id
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os tipos de documento nos lancamentos em ccorrente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  17/03/2006
	--->		
	<cffunction name="get_ccorrente_documento" access="remote" returntype="query" output="true">
		<cfargument name="cod_documento" required="no" default="">
		<cfargument name="deb_cred" required="no" default="">
		<cfargument name="modalidade_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_documento,
				   descricao_documento,
				   deb_cred,
				   febraban_g092_id,
				   modalidade_id,
				   uso_exclusivo_cheque,
				   uso_exclusivo_deposito,
				   observacao
			  from finan.v$ccorrente_documento
			 where 1=1
			 <cfif len(trim(arguments.cod_documento))>
			   and cod_documento in (#arguments.cod_documento#)
			 </cfif>
			 <cfif len(trim(arguments.deb_cred))>
			   and deb_cred = #arguments.deb_cred#
			 </cfif>
			 <cfif len(trim(arguments.modalidade_id))>
			   and modalidade_id in (#arguments.modalidade_id#)
			 </cfif>
			 order by descricao_documento
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as contas correntes cadastradas no sistema
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  15/03/2006
	--->		
	<cffunction name="get_ccorrente_modalidade" access="remote" returntype="query" output="true">
		<cfargument name="modalidade_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select modalidade_id,
				   descricao,
				   aceita_cc_pf,
				   aceita_cc_pj,
				   aceita_cc_pe,
				   aceita_cc_bancaria
			  from finan.v$ccorrente_modalidade
			 where 1=1
			 <cfif len(trim(arguments.modalidade_id))>
			   and modalidade_id in (#arguments.modalidade_id#)
			 </cfif>
			 order by modalidade_id
    	</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os lancamentos de conta corrente do cliente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 14/03/2006
	--->
	<cffunction name="get_extrato_ccorrente" returntype="query" access="remote">
		<cfargument name="cod_conta" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="modalidade_id" required="no" default="1,2,6">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			SELECT t.cod_documento,
				   decode(t.user_insert,
						  'INTEGRACAO_VALE',
						  'VALE',
						  'FUNC_MOTORISTA',
						  'MOTORISTA',
						  'SENTINELA',
						  'AUTO',
						  'OPER',
						  'AUTO',
						  'RASTREADOR',
						  'AUTO',
						  t.user_insert) as usuario,
				   to_char(t.data_vencto,'dd/mm/yyyy hh24:mi') as data_vencto,
				   t.num_lancamento,
				   t.num_documento,
				   to_char(t.data_lancamento,'dd/mm/yyyy hh24:mi') as data_lancamento,
				   t.historico,
				   decode(t.deb_cred, 1, 'C', 'D') as d_c,
				   decode(t.deb_cred, 1, 'Crdito', 'Dbito') as d_c_p,
				   round(t.valor_lancamento,2) as valor_lancamento,
			       t.valor_lancamento * (t.deb_cred + (t.deb_cred-1)) as valor_lancamento_dc
			  FROM finan.v$ccorrente_lancamento t
			 inner join finan.v$ccorrente cc 
					 on cc.cod_conta = t.cod_conta
			 WHERE 1=1
               <cfif Len(Trim(arguments.cod_pessoa))>
               	  and cc.cod_pessoa = #arguments.cod_pessoa#
               </cfif>
               <cfif Len(Trim(arguments.cod_conta))>
               	  and cc.cod_conta = #arguments.cod_conta#
               </cfif>
               <cfif Len(Trim(arguments.data_inicial))>
			      and trunc(t.data_lancamento) >= to_date('#arguments.data_inicial#', 'dd/mm/yyyy')
               </cfif>
               <cfif Len(Trim(arguments.data_final))>
               	  and trunc(t.data_lancamento) <= to_date('#arguments.data_final#', 'dd/mm/yyyy')
               </cfif>
			   and cc.modalidade_id in (#arguments.modalidade_id#)
			 ORDER BY t.data_lancamento, num_lancamento
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Lista de Moedas cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 02/12/2005 - criado
	--->	
	<cffunction name="get_moeda" displayname="Retorna as cidades cadastradas no sistema" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_moeda,
				   moeda,
				   descricao_moeda,
				   pais,
				   tipo
			  from finan.v$moeda_bacen		
			 order by cod_moeda 
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o saldo anterior da conta corrente
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 14/03/2006
	--->
	<cffunction name="get_saldo_ant_ccorrente" returntype="query" access="remote">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="cod_conta" required="no" default="">
		<cfargument name="modalidade_id" required="no" default="1,2,6">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			SELECT round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta,to_date('#arguments.data_inicial# 23:59:59','DD/MM/YYYY hh24:mi:ss')),2) as saldo
			  FROM oper.v$ccorrente cc
			 WHERE cc.modalidade_id in (#arguments.MODALIDADE_ID#)	
               <cfif Len(Trim(arguments.cod_pessoa))>
			      and cc.cod_pessoa = #arguments.cod_pessoa#
               </cfif>
               <cfif Len(Trim(arguments.cod_conta))>
			      and cc.cod_conta = #arguments.cod_conta#
               </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o arquivo de cotaes do banco central
	-- CRISTOFER  18/04/2006
	--->		
	<cffunction name="get_cotacoes_bacen" access="remote" returntype="struct" output="true">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
		<cfargument name="cod_moeda" required="yes">
        <cftry>
            <cftransaction action="begin">
                <cfhttp url="http://www4.bcb.gov.br/pec/taxas/port/PtaxRPesq.asp?idpai=TXCOTACAO&id=TXCOTACAO" method="post">
                    <cfhttpparam type="formfield" name="BOLETIM" value="" />
                    <cfhttpparam type="formfield" name="BUTAO" value="Pesquisar" />
                    <cfhttpparam type="formfield" name="CHKMOEDA" value="#arguments.cod_moeda#" />
                    <cfhttpparam type="formfield" name="DATAFIM" value="#arguments.data_final#" />  
                    <cfhttpparam type="formfield" name="DATAINI" value="#arguments.data_inicial#" />  
                    <cfhttpparam type="formfield" name="DESCMOEDA" value="" />  
                    <cfhttpparam type="formfield" name="MOEDA" value="" />  
                    <cfhttpparam type="formfield" name="OPCAO" value="1" />  
                    <cfhttpparam type="formfield" name="RADOPCAO" value="1" />  
                    <cfhttpparam type="formfield" name="TXTOPCAO4" value="220" />  
                    <cfhttpparam type="formfield" name="TXTOPCAO5" value="DOLAR-DOS-EUA" />  
                </cfhttp>
                <cfscript>
					localizador = 'http://www4.bcb.gov.br/download/cotacoes/BC';
					inicio = find(localizador, cfhttp.FileContent);
					fim = find('.csv', cfhttp.FileContent, inicio)+4;
					link = mid(cfhttp.FileContent, inicio, fim-inicio);
                </cfscript>
                <cfhttp url="#link#" method="get">
                </cfhttp>
                <cfset retorno.mensagem = 'Cotaes importadas com sucesso.'>
                <cfset retorno.origem = link>
            	<cfset retorno.text = cfhttp.FileContent>
				<cfset retorno.erro = false>
            </cftransaction>
        <cfcatch>		
			<cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
        </cfcatch>        
        </cftry>
        <cfreturn retorno>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o tipos de pagamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/10/2008
	--->
	<cffunction name="get_tipo_pagto" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select tipo_pagto_id, tipo_pagto_descricao
              from finan.v$finan_tipo_pagto
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca o tipos de documento
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/10/2008
	--->
	<cffunction name="get_tipo_documento" returntype="query" access="remote">
		<cfargument name="contas_pagar" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select fd.docto_id, fd.descricao
              from finan.v$finan_documento fd
            where 1=1
            <cfif Len(Trim(arguments.contas_pagar))>
              and fd.contas_pagar = 1
            </cfif>
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>        
    
	<!--- 
	-- PROPSITO 
	-- Busca saldo atual das contas correntes
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/10/2008
	--->
	<cffunction name="get_saldo_ccorrente" returntype="query" access="remote">
		<cfargument name="modalidade_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select cc.cod_conta, cc.descricao_conta, cc.ativo, 
                   to_char(cc.data_abertura,'dd/mm/yyyy') as data_abertura, 
                   round(finan.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta, sysdate+1),2) as saldo
              from finan.v$ccorrente cc
            where 1=1
            <cfif Len(Trim(arguments.modalidade_id))>
              and cc.modalidade_id = #arguments.modalidade_id#
            </cfif>
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca saldo atual das contas correntes
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/10/2008
	--->
	<cffunction name="get_saldo_ccorrente_lancto" returntype="query" access="remote">
		<cfargument name="modalidade_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select cc.cod_conta, cc.descricao_conta, cc.ativo, 
                   to_char(cc.data_abertura,'dd/mm/yyyy') as data_abertura, 
                   round(finan.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta, sysdate+1),2) as saldo
              from finan.v$ccorrente cc
            where 1=1
            <cfif Len(Trim(arguments.modalidade_id))>
              and cc.modalidade_id = #arguments.modalidade_id#
            </cfif>
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction> 
    
    
</cfcomponent>