<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de pneus" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as alternativas
	-- CRISTOFER  22/04/2006
	--->		
	<cffunction name="get_alternativa" access="remote" returntype="query" output="true">
		<cfargument name="alternativa_id" required="no" default="">
		<cfargument name="pergunta_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select alternativa_id,
				   pergunta_id,
				   descricao,
				   certa,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from exame.v$alternativa
			 where 1=1
			<cfif len(trim(arguments.pergunta_id))>
			   and pergunta_id in (#arguments.pergunta_id#)
			</cfif>
			<cfif len(trim(arguments.alternativa_id))>
			   and alternativa_id in (#arguments.alternativa_id#)
			</cfif>
			 order by alternativa_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os Exames
	-- CRISTOFER  25/04/2006
	--->		
	<cffunction name="get_exame" access="remote" returntype="query" output="true">
		<cfargument name="exame_id" required="no" default="">
		<cfargument name="examinado_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.exame_id,
				   e.programacao_id,
				   p.descricao as programacao,
				   substr(p.tempo_execucao, 5, 5) as tempo,
				   e.examinado_id,
				   e.data_execucao,
				   e.situacao,
				   e.date_insert,
				   e.user_insert,
				   e.date_update,
				   e.user_update,
				   e.site,
				   (select count(*)
				      from exame.v$exame_pergunta ep
					 where ep.exame_id = e.exame_id) as nro_perguntas
			  from exame.v$exame e
			 inner join exame.v$programacao p
			         on p.programacao_id = e.programacao_id
			 where 1=1
			 <cfif len(trim(examinado_id))>
			   and e.examinado_id = #arguments.examinado_id#
			 </cfif>
			 <cfif len(trim(exame_id))>
			   and e.exame_id = #arguments.exame_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Busca uma proxima pergunta
	-- CRISTOFER  27/04/2006
	--->		
	<cffunction name="get_proxima_pergunta" access="remote" returntype="query" output="true">
		<cfargument name="nro_pergunta" required="yes">
		<cfargument name="exame_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select * from
			(select * from 
			(select 1 as ordem, 
				   ep.nro_questao
			  from exame.v$exame_pergunta ep
			 where exame_id = #arguments.exame_id#
			   and not exists (select 'x'
								 from exame.v$exame_resposta er1
								inner join exame.v$alternativa a
										on a.alternativa_id = er1.alternativa_id
								where a.pergunta_id = ep.pergunta_id)
			 order by nro_questao) a
			union
			select * from 
			(select 2 as ordem, 
				   ep.nro_questao
			  from exame.v$exame_pergunta ep
			 where exame_id = #arguments.exame_id#
			   and not exists (select 'x'
								 from exame.v$exame_resposta er1
								inner join exame.v$alternativa a
										on a.alternativa_id = er1.alternativa_id
								where a.pergunta_id = ep.pergunta_id)
			 order by nro_questao) b)
			where nro_questao > #arguments.nro_pergunta# or ordem = 2
			order by ordem, nro_questao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os resultados gerais do exame
	-- CRISTOFER  27/04/2006
	--->		
	<cffunction name="get_analise_exame" access="remote" returntype="query" output="true">
		<cfargument name="ordem" required="no" default="tema,nivel_id,status">
		<cfargument name="exame_id" required="no" default="">		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select count(*) as selec,
				   sum(count(*)) over(partition by nivel,tema) total_nivel,
				   sum(count(*)) over(partition by tema,status) as selec_tema,
				   sum(count(*)) over(partition by tema) total_tema,
				   sum(count(*)) over(partition by status) as selec_total,
				   sum(count(*)) over() as total,
				   status,
				   nivel,
				   tema
			  from exame.v$exame_respostas ers
			where 1=1
			 <cfif Len(Trim(arguments.exame_id))>
			   and exame_id = #arguments.exame_id# 
			 </cfif>
			 group by status, certa, tema, nivel, nivel_id
			 order by #arguments.ordem#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca uma pergunta do exame
	-- CRISTOFER  27/04/2006
	--->		
	<cffunction name="get_exame_pergunta" access="remote" returntype="query" output="true">
		<cfargument name="exame_id" required="no" default="">
		<cfargument name="nro_questao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ep.exame_id,
				   ep.pergunta_id,
				   p.pergunta,
				   t.descricao as tema,
				   ep.date_insert,
				   ep.user_insert,
				   ep.date_update,
				   ep.user_update,
				   ep.site,
				   ep.nro_questao,
				   (select count(*)
				      from exame.v$alternativa a
					 where a.pergunta_id = p.pergunta_id
					   and a.certa = 1) as certas
			  from exame.v$exame_pergunta ep
			 inner join exame.v$pergunta p
			         on p.pergunta_id = ep.pergunta_id
			 inner join exame.v$tema t
			         on p.tema_id = t.tema_id
			 where 1=1
			 <cfif len(trim(arguments.nro_questao))>
			   and nro_questao = #arguments.nro_questao#  
			 </cfif>
			 <cfif len(trim(arguments.exame_id))>
			   and exame_id = #arguments.exame_id#  
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  
	 	
	<!--- 
	-- PROPSITO 
	-- Busca os examinados
	-- CRISTOFER  24/04/2006
	--->		
	<cffunction name="get_examinado" access="remote" returntype="query" output="true">
		<cfargument name="examinado_id" required="no" default="">
		<cfargument name="nome" required="no" default="">
		<cfargument name="cod_acesso" required="no" default="">
		<cfargument name="senha" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select examinado_id,
				   nome,
				   cod_acesso,
				   senha,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from exame.v$examinado
			 where 1=1
			 <cfif len(trim(arguments.examinado_id))>
			   and examinado_id in (#arguments.examinado_id#)
			 </cfif>
			 <cfif len(trim(arguments.nome))>
			   and upper(nome) like upper('%#arguments.nome#%')
			 </cfif>
			 <cfif len(trim(arguments.cod_acesso))>
			   and upper(cod_acesso) like upper('#arguments.cod_acesso#')
			 </cfif>
			 <cfif len(trim(arguments.senha))>
			   and upper(senha) like upper('#arguments.senha#')
			 </cfif>
			 order by nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>   
	
	<!--- 
	-- PROPSITO 
	-- Busca as perguntas
	-- CRISTOFER  22/04/2006
	--->		
	<cffunction name="get_pergunta" access="remote" returntype="query" output="true">
		<cfargument name="pergunta_id" required="no" default="">
		<cfargument name="nivel_id" required="no" default="">
		<cfargument name="tema_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pergunta_id,
				   p.tema_id,
				   t.descricao as tema,
				   p.pergunta,
				   p.nivel_id,
				   pn.descricao as nivel,
				   p.date_insert,
				   p.user_insert,
				   p.date_update,
				   p.user_update,
				   p.site
			  from exame.v$pergunta p
			 inner join exame.v$pergunta_nivel pn
					 on pn.nivel_id = p.nivel_id
			 inner join exame.v$tema t
					 on t.tema_id = p.tema_id
			 where 1=1
			<cfif len(trim(arguments.pergunta_id))>
			   and p.pergunta_id in (#arguments.pergunta_id#)         
			</cfif>
			<cfif len(trim(arguments.nivel_id))>
			   and p.nivel_id in (#arguments.nivel_id#)         
			</cfif>
			<cfif len(trim(arguments.tema_id))>
			   and p.tema_id in (#arguments.tema_id#)         
			</cfif>
			<cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
			
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>   


	<!--- 
	-- PROPSITO 
	-- Busca os niveis de dificuldade
	-- CRISTOFER  22/04/2006
	--->		
	<cffunction name="get_pergunta_nivel" access="remote" returntype="query" output="true">
		<cfargument name="nivel_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nivel_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from exame.v$pergunta_nivel
			 where 1=1
			 <cfif len(trim(arguments.nivel_id))>
			   and nivel_id in (#arguments.nivel_id#)
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by nivel_id	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as programacoes
	-- CRISTOFER  24/04/2006
	--->		
	<cffunction name="get_programacao" access="remote" returntype="query" output="true">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="programacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select programacao_id,
				   descricao,
				   substr(tempo_execucao, 5, 5) as tempo,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from exame.v$programacao
			 where 1=1
			 <cfif len(trim(arguments.programacao_id))>
			   and programacao_id in (#arguments.programacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')	
			 </cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os temas da programacao
	-- CRISTOFER  24/04/2006
	--->		
	<cffunction name="get_programacao_tema" access="remote" returntype="query" output="true">
		<cfargument name="programacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select programacao_id,
				   tema_id,
				   numero_questoes,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from exame.v$programacao_tema
			 where 1=1
			<cfif len(trim(arguments.programacao_id))>
			   and programacao_id in (#arguments.programacao_id#)
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os temas dos exames
	-- CRISTOFER  22/04/2006
	--->		
	<cffunction name="get_tema" access="remote" returntype="query" output="true">
		<cfargument name="tema_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tema_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from exame.v$tema
			 where 1=1
			<cfif len(trim(arguments.tema_id))>
			   and tema_id in (#arguments.tema_id#)
			</cfif>
			<cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
</cfcomponent>