<cfcomponent displayname="Consultas da rea de emissao de documentos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos de um periodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 23/02/2006 
	--->
	<cffunction name="get_balanco" displayname="Busca todos os lanamentos de um periodo" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes" />
		<cfargument name="cod_setor" required="yes" />
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select ct.lancto_id, ct.data_emissao, ct.num_romaneio, ct.num_formulario, ct.placa_controle, ct.placa_referencia,
			       case
				     when l.regra_fiscal_id = 2 or sum(c.valor_icms_substit) > 0 then
					    sum(c.total_conhecimento) - sum(c.valor_icms_substit)
			       else (decode(l.pedagio_incluso,1,sum(c.despacho),0) + decode(l.icms_incluso,0,sum(c.valor_icms),0) + sum(c.frete_valor)) + nvl(sum(cc.valor_frete),0)
				   end frete_integral, 
				   sum(c.valor_icms) as valor_icms,
				   sum(c.valor_icms_substit) as valor_icms_substit,
				   avg(ct.valor_frete_bruto) as frete_motorista, 
				   sum((select cti.valor
						 from oper.v$contrato_transp_item cti
						where cti.lancto_id = ct.lancto_id
						  and cti.item_id = 1)) as pedagio,
				   r.remetente, r.destinatario, 
				   decode(oper.pkg_contrato_transporte.fnc_situacao_romaneio(ct.num_romaneio),0,'A Receber',1,'Recebido','No Faturado') as situacao,
				   decode(length(kss.pessoa_pkg.getidentificador(ct.proprietario_cod_pessoa)),18,
						 round((((decode(l.pedagio_incluso,1,sum(c.despacho),0) + decode(l.icms_incluso,0,sum(c.valor_icms) ,0) + sum(c.frete_valor)) + nvl(sum(cc.valor_frete),0) - avg(ct.valor_frete_bruto))*tr.PIS/100) + 
							   (((decode(l.pedagio_incluso,1,sum(c.despacho),0) + decode(l.icms_incluso,0,sum(c.valor_icms) ,0) + sum(c.frete_valor)) + nvl(sum(cc.valor_frete),0) - avg(ct.valor_frete_bruto))*tr.COFINS/100) + 
								(((decode(l.pedagio_incluso,1,sum(c.despacho),0) + decode(l.icms_incluso,0,sum(c.valor_icms) ,0) + sum(c.frete_valor)) + nvl(sum(cc.valor_frete),0)) *tr.CPMF/100),2)
						,
						 round((((decode(l.pedagio_incluso,1,sum(c.despacho),0) + decode(l.icms_incluso,0,sum(c.valor_icms) ,0) + sum(c.frete_valor)) + nvl(sum(cc.valor_frete),0))*tr.PIS/100) + 
							   (((decode(l.pedagio_incluso,1,sum(c.despacho),0) + decode(l.icms_incluso,0,sum(c.valor_icms) ,0)  + sum(c.frete_valor)) + nvl(sum(cc.valor_frete),0))*tr.COFINS/100) + 
								(((decode(l.pedagio_incluso,1,sum(c.despacho),0) + decode(l.icms_incluso,0,sum(c.valor_icms) ,0) + sum(c.frete_valor)) + nvl(sum(cc.valor_frete),0)) *tr.CPMF/100),2)) as pis_cofins_cpmf,
				   avg(oper.pkg_contrato_transporte.fnc_custo_financeiro(ct.lancto_id, 0, ct.num_romaneio, sysdate)) as custo_financeiro,
				   avg(oper.pkg_contrato_transporte.fnc_get_comissao(ct.lancto_id)) as comissao,
			       nvl(sum((decode(c.num_produto,125,0,129,0,127,0,oper.pkg_contrato_transporte.fnc_valor_seguro(ct.lancto_id)))),0) as seguro,
                   (select kss.fnc_concat_all(to_concat_expr(num_conhecimento,'/'))
                      from fiscal.v$conhecimento c1
                     where ct.num_romaneio = c1.num_romaneio) num_conhecimento,
                   (select kss.fnc_concat_all(to_concat_expr(num_lote,'/'))
                      from oper.v$romaneio_item ri1
                     where ri1.num_romaneio = ct.num_romaneio) num_lote
			  from oper.v$contrato_transp ct
			 inner join fiscal.v$conhecimento c
				on ct.num_romaneio = c.num_romaneio
			 inner join oper.v$romaneio r
				on ct.num_romaneio = r.num_romaneio		     
  		     inner join oper.v$romaneio_item rit
			    on rit.num_romaneio = r.num_romaneio
				and c.item_id = rit.item_id
		     inner join oper.v$lote l
                on rit.num_lote = l.num_lote
			 left join oper.v$conhecimento_complemento cc
         			on c.conhecimento_id = cc.conhecimento_id
             cross join oper.v$tributacao tr
			 where ct.cod_pessoa_filial = #Val(arguments.cod_pessoa_filial)#
			   and ct.cod_departamento  = 2
  			   and ct.cod_setor         = #Val(arguments.cod_setor)#
			   and ct.cod_centro_custo  = 1
			   and to_char(ct.data_emissao,'mm')   = '#NumberFormat(arguments.MES,'00')#'
			   and to_char(ct.data_emissao,'yyyy') = '#Val(arguments.ANO)#'
			 group by ct.lancto_id, ct.data_emissao, ct.num_romaneio, ct.num_formulario, ct.placa_controle, 
			 		  ct.placa_referencia, r.remetente, r.destinatario, ct.proprietario_cod_pessoa, l.pedagio_incluso, l.icms_incluso, 
--                      c.num_produto, 
                      l.regra_fiscal_id
			 order by ct.data_emissao 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca Itens para a carta frete
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2006
	--->
	<cffunction name="get_carta_frete_item" displayname="Busca Itens para a carta frete" access="remote" returntype="query" output="true">
		<cfargument name="posto" 				required="no" default="0">
		<cfargument name="contrato_transporte" 	required="no" default="0">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select item_id, descricao, 
				   decode(desconto,1,'Desconto','Acrscimo') as tipo,
				   desconto,
				   compoe_frete, deb_cred_motorista
			  from oper.v$carta_frete_item_setup 
			 where 1=1
			  <cfif arguments.posto eq 1>
			   and mostra_posto = 1
			  </cfif>
			  <cfif arguments.contrato_transporte eq 1>
			   and mostra_lancto_ct = 1
			  </cfif>
			 order by descricao	
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos de um periodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 23/02/2006
	--->
	<cffunction name="get_comissao_doctos_frota" displayname="Busca todos os lanamentos de um periodo" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes" />
		<cfargument name="cod_setor" required="yes" />		
		<cfargument name="mes" required="yes" />		
		<cfargument name="ano" required="yes" />		
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ min(c.data_emissao) as data_emissao, r.num_romaneio, min(c.num_conhecimento), r.remetente, r.destinatario,
				   rhv.placa_controle, rhv.placa_referencia, 
           decode(lpc.tipo_comissao_frota,0,oper.pkg_operacional.fnc_converte_peso(sum(c.peso),'Kg',c.cod_unidade),0) as peso,
           decode(lpc.tipo_comissao_frota,0,oper.pkg_operacional.fnc_converte_peso(sum(c.peso),'Kg',c.cod_unidade) * 0.50,avg(lpc.valor_comissao_frota)) as comissao
			  from oper.v$conhecimento c
       inner join oper.v$romaneio_item rit
          on c.num_romaneio = rit.num_romaneio
         and c.item_id = rit.item_id
       inner join oper.v$lote_participacao_comissao lpc
          on rit.num_lote = lpc.num_lote
         and (lpc.data_vigencia = (select max(lpc2.data_vigencia) 
                                    from oper.v$lote_participacao_comissao lpc2
                                   where lpc2.data_vigencia <= c.data_emissao
                                     and lpc2.num_lote = lpc.num_lote) 
            or lpc.data_vigencia = (select max(lpc2.data_vigencia)
                                    from oper.v$lote_participacao_comissao lpc2
                                   where lpc2.num_lote = lpc.num_lote) )                                  
			 inner join oper.v$romaneio r
				on c.num_romaneio = r.num_romaneio
			 inner join oper.v$romaneio_hist_veiculo rhv
				on r.num_romaneio = rhv.num_romaneio
			   and rhv.data_inicio = (select min(rhv2.data_inicio) 
										 from oper.v$romaneio_hist_veiculo rhv2
										where rhv.num_romaneio = rhv2.num_romaneio)
			 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			   and c.cod_departamento = 2
			   and c.cod_setor = #arguments.cod_setor#
			   and c.cod_centro_custo = 1
			   and to_char(c.data_emissao,'mm') = #arguments.MES#
			   and to_char(c.data_emissao,'yyyy') = #arguments.ANO#
			   and rhv.placa_referencia in (select ve.placa 
        							 from oper.v$veiculo_frota_geral ve)			   
        group by r.num_romaneio, r.remetente, r.destinatario, rhv.placa_controle, rhv.placa_referencia, lpc.tipo_comissao_frota, c.cod_unidade
		     order by min(c.data_emissao)
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os Conhecimentos lanados
	-- NOTAS EXPLICATIVAS
	-- GUTO 23/02/2006
	--->

	<cffunction name="get_conhecimento" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do sistema para o conhecimento" >
		<cfargument name="num_conhecimento" displayname="Numero do conhecimento"  >
		<cfargument name="data_inicial" displayname="Data Inicial emisso conhecimento" required="false">
		<cfargument name="data_final" displayname="Data Final emisso conhecimento" required="false">
		<cfargument name="serie" displayname="Serie" required="false">
		<cfargument name="cod_pessoa_filial" displayname="Filial" required="false">
		<cfargument name="cod_setor" displayname="Setor" required="false">
		<cfargument name="nivel_acesso"  required="false" default="0">
		<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
			select c.item_id,
                   c.num_romaneio,
                   c.conhecimento_id,
                   c.cod_pessoa_filial,
                   c.cod_setor,
                   s.descricao as setor,
                   c.serie,
                   c.num_conhecimento,
                   c.data_emissao,
                   c.cfop || '-' || c.cfop_id as cfop,
                   c.natureza_operacao,
                   c.pagador,
                   c.cod_remetente,
                   c.rem_razao_social,
                   c.rem_endereco,
                   c.rem_municipio,
                   c.rem_uf,
                   c.rem_cep,
                   c.rem_cnpj_cpf,
                   c.rem_inscricao_estadual,
                   c.cod_destinatario,
                   c.dest_razao_social,
                   c.dest_endereco,
                   c.dest_municipio,
                   c.dest_uf,
                   c.dest_cep,
                   c.dest_cnpj_cpf,
                   c.dest_inscricao_estadual,
                   c.cod_consignatario,
                   c.cons_razao_social,
                   c.cons_endereco,
                   c.cons_municipio,
                   c.cons_uf,
                   c.cons_cep,
                   c.cons_cnpj_cpf,
                   c.cons_inscricao_estadual,
                   c.cod_destinatario,
                   oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso,
                   nvl(c.peso_cobrado, c.peso) as peso_cobrado,
                   c.volume,
                   c.m3,
                   c.frete_unitario,
                   c.frete_peso,
                   c.frete_valor,
                   c.despacho,
                   c.base_calculo_icms,
                   c.aliquota_icms,
                   c.ademe,
                   c.desconto,
                   c.valor_icms,
                   c.valor_icms_substit,
                   c.coleta_entrega,
                   c.impostos,
                   c.total_conhecimento,
                   c.num_natureza,
                   n.descricao as natureza,
                   c.num_especie,
                   e.descricao as especie,
                   c.cod_unidade,
                   u.unidade,
                   col.nome_local as coleta,
                   col.sigla_uf as coleta_sigla_uf,
                   c.coleta_cod_uf,
                   c.coleta_cod_municipio,
                   c.coleta_cod_distrito,
                   c.coleta_cod_dv,
                   ent.nome_local as entrega,
                   ent.sigla_uf as entrega_sigla_uf,
                   c.entrega_cod_uf,
                   c.entrega_cod_municipio,
                   c.entrega_cod_distrito,
                   c.entrega_cod_dv,
                   c.placa,
                   c.nome_motorista,
                   c.prop_cnpj_cpf,
                   c.prop_razao_social,
                   c.prop_endereco,
                   c.prop_uf,
                   c.entrada_dados,
                   c.situacao_id,
                   decode(c.situacao_id, 0, 'Confirmado', 1, 'Cancelado', 2, 'Impresso') as situacao,
                   c.observacao,
                   c.rodape,
                   c.user_insert,
                   c.st_icms_id,
                   c.st_origem_id,
                   c.num_produto,
                   l.frete_em,
                   l.num_lote,
                   oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,
                   (select sum(nf.valor_total)
                      from oper.v$conhecimento_nota_fiscal nf
                     where nf.conhecimento_id = c.conhecimento_id) as valor_nota_fiscal,
                   l.regra_fiscal_id,
                   case
                      when exists (select 'x'
                                     from fiscal.v$conhecimento_receber cr1
                                    where cr1.conhecimento_id = c.conhecimento_id) then 1
                      else 0
                   end as faturado,
                   case
                      when exists (select 'x'
                                     from fiscal.v$conhecimento_contab cc1
                                    where cc1.conhecimento_id = c.conhecimento_id) then 1
                      else 0
                   end as contabilizado,
                   case
                      when r.situacao_id = 2 then 1
                      else 0
                   end as romaneio_ok,
                   case
                      when c.cod_unidade = 'Lt' then c.m3 * 1000
                      else oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade)
                   end as valor_complemento,
                   c.modelo_documento
              from oper.v$conhecimento c
              left join oper.v$setor s
                     on c.cod_pessoa_filial = s.cod_pessoa_filial
                    and c.cod_setor = s.cod_setor
              left join oper.v$romaneio_item ri
                     on ri.num_romaneio = c.num_romaneio
                    and ri.item_id = c.item_id
              left join oper.v$romaneio r
                     on r.num_romaneio = c.num_romaneio
              left join oper.v$lote l
                     on l.num_lote = ri.num_lote
              left join cep.cep_loc col
                     on c.coleta_cod_uf = col.cod_uf
                    and c.coleta_cod_municipio = col.cod_municipio
                    and c.coleta_cod_distrito = col.cod_distrito
                    and c.coleta_cod_dv = col.cod_dv
              left join cep.cep_loc ent
                     on c.entrega_cod_uf = ent.cod_uf
                    and c.entrega_cod_municipio = ent.cod_municipio
                    and c.entrega_cod_distrito = ent.cod_distrito
                    and c.entrega_cod_dv = ent.cod_dv
              left join oper.v$natureza n
                     on c.num_natureza = n.num_natureza
              left join oper.v$especie e
                     on c.num_especie = e.num_especie
              left join oper.v$unidade_medida u
                     on c.cod_unidade = u.cod_unidade
		   <cfif isDefined("Arguments.conhecimento_id") and Len(Trim(Arguments.conhecimento_id))>
             where c.conhecimento_id = #Arguments.conhecimento_id#
           <cfelseif isDefined("Arguments.num_conhecimento") and Len(Trim(Arguments.num_conhecimento))>
             where c.num_conhecimento = #Arguments.num_conhecimento#
           <cfelseif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
             where trunc(c.data_emissao) between '#arguments.data_inicial#' and '#arguments.data_final#'
           </cfif>
           
           <cfif isDefined("arguments.serie") and Len(Trim(arguments.serie)) >
              and c.serie = '#arguments.serie#'
           </cfif>
           <cfif isDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial)) and (arguments.nivel_acesso eq 5) >
              and c.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
           </cfif>
           <cfif isDefined("arguments.cod_setor") and Len(Trim(arguments.cod_setor)) and (arguments.nivel_acesso eq 5) and (arguments.nivel_acesso eq 1) >
              and c.cod_setor = #arguments.cod_setor#
           </cfif>
	   		order by c.num_conhecimento
	   </cfquery>
	   <cfreturn qr_conhecimento>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os Conhecimentos lanados
	-- NOTAS EXPLICATIVAS
	-- GUTO 23/02/2006
	--->

	<cffunction name="get_conhecimento_print" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes" displayname="Identificador do sistema para o conhecimento" >
		<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
			select 
				  c.aliquota_icms,c.base_calculo_icms,c.cfop,c.cfop_id
				  ,c.cod_centro_custo,c.cod_consignatario,c.cod_departamento
				  ,c.cod_destinatario,c.cod_motorista,c.cod_pessoa_filial
				  ,c.cod_proprietario,c.cod_remetente,c.COD_REDESPACHO
				  ,c.cod_setor,c.cod_unidade,c.coleta_bairro,c.coleta_cep      
				  ,c.coleta_cod_distrito,c.coleta_cod_dv,c.coleta_cod_municipio
				  ,c.coleta_cod_uf,c.coleta_complemento,c.coleta_entrega
				  ,c.coleta_logradouro,c.conhecimento_id,c.cons_cep
				  ,c.cons_cnpj_cpf,c.cons_endereco,c.cons_inscricao_estadual
				  ,c.cons_municipio,c.cons_razao_social,c.cons_uf
				  ,c.data_emissao,to_char(c.data_emissao, 'HH24:MI:SS') as Hora_Emissao
				  ,c.date_insert,c.date_update,c.desconto,c.despacho
				  ,c.dest_cep,c.dest_cnpj_cpf,(select p.identificador 
												 from kss.v$pessoa p 
												where p.cod_pessoa = c.cod_destinatario) dest_cnpj
				  ,c.dest_endereco,c.dest_inscricao_estadual,c.dest_municipio
				  ,c.dest_razao_social,c.dest_uf,c.entrada_dados,c.entrega_bairro
				  ,c.entrega_cep,c.entrega_cod_distrito,c.entrega_cod_dv
				  ,c.entrega_cod_municipio,c.entrega_cod_uf,c.entrega_complemento
				  ,c.entrega_logradouro,c.frete_peso,c.frete_unitario
				  ,c.frete_valor,c.gris,c.impostos,c.impresso
				  ,c.item_id,c.m3,c.natureza_operacao,c.nome_motorista
				  ,c.num_conhecimento,c.num_especie,c.num_natureza
				  ,c.num_produto,c.num_romaneio,c.observacao
			 	  ,c.pagador,c.pedagio,c.peso,c.placa
				  ,(select placa_controle
					  from oper.v$romaneio_hist_veiculo rhv
					 where rhv.num_romaneio = c.num_romaneio
					   and rhv.data_inicio = (select max(rhv1.data_inicio)
												from oper.v$romaneio_hist_veiculo rhv1
											   where rhv1.num_romaneio = rhv.num_romaneio)) placa_tracao
				  ,c.prop_cnpj_cpf,(  select p.identificador 
					  					from kss.v$pessoa p 
					 				   where p.cod_pessoa = c.cod_proprietario) prop_cnpj
				  ,c.prop_endereco,c.prop_razao_social,c.prop_uf
				  ,c.RED_CEP,c.RED_CNPJ_CPF,c.RED_ENDERECO
				  ,c.RED_INSCRICAO_ESTADUAL,c.RED_MUNICIPIO,c.RED_RAZAO_SOCIAL
				  ,c.RED_UF,c.rem_cep,c.rem_cnpj_cpf,(select p.identificador 
					  									from kss.v$pessoa p 
					 								   where p.cod_pessoa = c.cod_remetente) rem_cnpj
				  ,c.rem_endereco,c.rem_inscricao_estadual,c.rem_municipio
				  ,c.rem_razao_social,c.rem_uf
				  ,case 
					   when c.cod_consignatario is not null then
							c.cons_razao_social 
					   when c.pagador = 0 then
							c.rem_razao_social 
					   else c.dest_razao_social
					   end razao_pagador
				  ,c.rodape,c.rowid,c.sec_cat,c.serie,c.situacao_id
				  ,c.valor_icms_substit,c.st_icms_id,c.st_origem_id
				  ,c.total_conhecimento,nvl((   select initcap(p.cliente)
												  from kss.v$pessoa p
												 inner join kss.kss_usuarios s
														 on s.cod_pessoa = p.cod_pessoa
												 where s.usuario = c.user_insert),user_insert) user_insert
				  ,nvl((select initcap(p.cliente)
						  from kss.v$pessoa p
						 inner join kss.kss_usuarios s
								 on s.cod_pessoa = p.cod_pessoa
						 where s.usuario = c.user_update),user_update) user_update
				  ,c.valor_icms,c.volume,cc.centro_custo,d.descricao as departamento
				  ,s.descricao as setor,u.cod_unidade_negocio,u.unidade_negocio
				  ,pe_unid.municipio as municipio_unid_negocio,c.ademe
				  ,pe_rem.bairro rem_bairro,pe_dest.bairro dest_bairro
			 	  ,pe_prop.municipio prop_municipio,pe_prop.uf prop_uf 
				  ,(select pe.logradouro from kss.v$pessoa_endereco pe
					 where pe.cod_pessoa = c.cod_motorista
					   and pe.endereco_padrao = 1) mot_endereco
				  ,(select pe.municipio from kss.v$pessoa_endereco pe
					 where pe.cod_pessoa = c.cod_motorista
					   and pe.endereco_padrao = 1) mot_municipio
				  ,(select pe.uf from kss.v$pessoa_endereco pe
					 where pe.cod_pessoa = c.cod_motorista
					   and pe.endereco_padrao = 1) mot_uf
				  ,(select pf.cnh_num_registro from kss.v$pessoa_fisica pf
					 where pf.cod_pessoa = c.cod_motorista) cnh          
				  ,(select pf.cnh_validade from kss.v$pessoa_fisica pf
					 where pf.cod_pessoa = c.cod_motorista) cnh_data_validade
				  ,(select pe.municipio from kss.v$pessoa_endereco pe
					 where pe.cod_pessoa = c.cod_pessoa_filial
					   and pe.endereco_padrao = 1) filial_municipio           
			 	  ,to_char(r.data_previsao_descarga, 'dd/mm/yyyy') as data_previsao_descarga
				  ,n.descricao natureza,e.descricao especie
				  ,(select vm.marca 
					  from oper.v$veiculo v 
					  left outer join oper.v$veiculo_marca vm
								   on vm.marca_id = v.marca_id
					  where v.placa = c.placa) marca
			 	  ,(select cm.nome_local
					  from cep.cep_loc cm
					 where cm.cod_municipio = c.coleta_cod_municipio
					   and cm.cod_uf = c.coleta_cod_uf
					   and cm.cod_dv = c.coleta_cod_dv
					   and cm.cod_distrito = c.coleta_cod_distrito) coleta_mun  
				  ,(select em.nome_local
					  from cep.cep_loc em
					 where em.cod_municipio = c.entrega_cod_municipio
					   and em.cod_uf = c.entrega_cod_uf
					   and em.cod_dv = c.entrega_cod_dv
					   and em.cod_distrito = c.entrega_cod_distrito) entrega_mun     
			 	  ,to_char(c.DATA_EMISSAO,'DD') dia,to_char(c.DATA_EMISSAO,'Month') mes
				  ,to_char(c.DATA_EMISSAO,'RR') ano,v.cor_predominante cor 
				  ,decode((select sum(vvv.valor) valor
							from oper.v$vale_romaneio vrr
						   inner join oper.v$vale vvv
								   on vvv.num_vale = vrr.num_vale
						   where num_romaneio = c.num_romaneio), null, null, 
						   (select finan.pkg_financeiro.fnc_extenso(sum(vvv.valor))
							  from oper.v$vale_romaneio vrr
							 inner join oper.v$vale vvv
									 on vvv.num_vale = vrr.num_vale
							 where num_romaneio = c.num_romaneio)) as valorextenso
				  ,(select sum(vvv.valor) valor
					  from oper.v$vale_romaneio vrr
					 inner join oper.v$vale vvv
							 on vvv.num_vale = vrr.num_vale
					 where num_romaneio = c.num_romaneio) valor_vale
				  ,vl.num_vale
				  ,to_char(sysdate, 'dd') as dia_sysdate,to_char(sysdate, 'Month') as mes_sysdate
				  ,to_char(sysdate, 'yy') as ano_sysdate,vl.user_insert user_insert_vale,
				  'Vale Viagem' as  tipo_vale      
				  ,fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
				  ,(select sum(nf.valor_total)
					  from fiscal.v$conhecimento_nota_fiscal nf
					 where nf.conhecimento_id = c.conhecimento_id) as valor_nota_fiscal
				  ,(select nvl(umc.equivalencia,1)
					  from kss.v$unidade_medida_conversao umc
					 where upper(umc.cod_unidade_eq) = upper(c.cod_unidade)
					   and upper(umc.cod_unidade) = 'KG') *  nvl(c.peso,0) peso_real
				   -- conferencia
				  ,decode(c.conferido, 1,'CONFERIDO', '') as status_conferencia
				   -- impressao
				  ,decode(c.impresso, 1,'IMPRESSO', '') as status_impresso
				   -- situacao
				   ,decode(c.situacao_id, 1,'CANCELADO', 'EMITIDO') as status_cancelado
				   -- entrada dados
				   ,decode(c.entrada_dados,0,'LOCAL', 1,'INTEGRAO', 2, 'INTERNET') as status_entrada
				   ,ap.numero_apolice, ap.valor_cobertura, ap.seguradora
			from   fiscal.v$conhecimento c
	   left join kss.v$unidade_negocio u
			  on c.cod_pessoa_filial = u.cod_pessoa
	   left join kss.v$departamento d
		      on c.cod_departamento = d.cod_departamento
	   left join kss.v$setor s
		      on c.cod_setor = s.cod_setor
	   left join kss.v$centro_custo cc
		      on c.cod_centro_custo = cc.cod_centro_custo
	   left join kss.v$pessoa_endereco_padrao pe_rem
		      on c.cod_remetente = pe_rem.cod_pessoa
	   left join kss.v$pessoa_endereco_padrao pe_dest
			  on c.cod_destinatario = pe_dest.cod_pessoa
	   left join kss.v$pessoa_endereco_padrao pe_prop
			  on c.cod_proprietario = pe_prop.cod_pessoa
	   left join kss.v$pessoa_endereco_padrao pe_unid
			  on u.cod_pessoa = pe_unid.cod_pessoa
	   left join oper.v$romaneio r
		      on c.num_romaneio = r.num_romaneio
	   left join fiscal.v$natureza n
		      on c.num_natureza = n.num_natureza
	   left join fiscal.v$especie e
		      on c.num_especie = e.num_especie 
	   left join oper.v$veiculo v 
		 	  on v.placa = c.placa 
	   left join (select max(num_vale) num_vale, num_romaneio
					from oper.v$vale_romaneio
				group by num_romaneio) vr
					  on vr.num_romaneio = c.num_romaneio
	   left join oper.v$vale vl
			  on vl.num_vale = vr.num_vale
	   left join (select /*+FIRST_ROWS*/
							max(ri.valor_frete_liquido), ri.num_romaneio,
							sc.numero_apolice, sc.valor_cobertura,
							sc.data_inicio_vigencia, sc.data_fim_vigencia,
							ps.razao_social as seguradora
					from oper.v$romaneio_item ri
			  inner join oper.v$lote_seguro ls
					  on ls.num_lote = ri.num_lote
					 and ls.data_exclusao is null
			  inner join oper.v$seg_contratado sc
			  		  on sc.id_seguradora = ls.id_seg_rctr_c
			  inner join oper.v$pessoa ps
					  on ps.cod_pessoa = ls.cod_gerenciadora
				group by ri.num_romaneio, sc.numero_apolice, sc.valor_cobertura,
						 sc.data_inicio_vigencia, sc.data_fim_vigencia, ps.razao_social) ap
					  on ap.num_romaneio = c.num_romaneio
					 and r.data_inicio between ap.data_inicio_vigencia and ap.data_fim_vigencia
			<cfif isDefined("Arguments.conhecimento_id") and Len(Trim(Arguments.conhecimento_id))>
				  	   	where c.conhecimento_id = #Arguments.conhecimento_id#
			</cfif>
			order  by c.data_emissao
		</cfquery>
		<cfreturn qr_conhecimento>
	</cffunction>
	
		<!--- 
	-- PROPSITO 
	-- Busca todos os Conhecimentos lanados
	-- NOTAS EXPLICATIVAS
	-- Wagner 23/08/2006
	--->

	<cffunction name="print_conhecimento_rodomar" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes" displayname="Identificador do sistema para o conhecimento" >
		<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
			 select c.num_conhecimento,c.natureza_operacao as natureza_operacao
		            ,c.cfop,trunc(c.data_emissao) as data_emissao
					,to_char(c.data_emissao, 'HH24:MI:SS') as hora_emissao
					,substr(pj.cnpj_ordem, 4, 1) || '/' || c.serie as serie
					--cabecalho
					,en.logradouro || ' ' || en.numero || chr(13) || 'Fone: ' || t.fone_ddd || '-' || t.fone_prefixo || t.fone_numero ||
					chr(13) || 'CEP: ' || en.cep || chr(13) ||'CNPJ: ' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial) ||
					chr(13) ||'I.E.: ' || pj.inscricao_estadual as cabecalho
					--cabecalho_internet
					,en.logradouro || ' ' || en.numero || chr(13) as cabecalho_endereco
   				    ,'Fone: ' || t.fone_ddd || '-' || t.fone_prefixo || t.fone_numero as cabecalho_telefone
					,'CEP: ' || en.cep as cabecalho_cep
					,'CNPJ: ' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial) as cabecalho_cnpj
					,'I.E.: ' || pj.inscricao_estadual as cabecalho_ie
					-- emitente
					,pj.razao_social as emit_razao_social
					,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial) as emit_cnpj
					,pj.inscricao_estadual as emit_inscricao_estadual
					,en.logradouro || ' ' || en.numero as emit_endereco
					,en.municipio as emit_municipio
					,en.cep as emit_cep
					,t.fone_ddd || '-' || t.fone_prefixo || t.fone_numero as emit_telefone
					-- remetente
					,c.rem_razao_social,c.rem_endereco,c.rem_municipio
					,c.rem_uf,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente) as rem_cnpj_cpf
					,c.rem_inscricao_estadual
					-- destinatario
					,c.dest_razao_social,c.dest_endereco,c.dest_municipio
					,c.dest_uf,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario) as dest_cnpj_cpf
					,c.dest_inscricao_estadual
					-- consignatrio
					,c.cons_razao_social,c.cons_endereco,c.cons_municipio
					,c.cons_uf,oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_CONSIGNATARIO) as cons_cnpj_cpf
					,decode(c.pagador, 0, 'X', '') as cons_pago
					,decode(c.pagador, 1, 'X', '') as cons_apagar
					,(select m.uf_id
					    from cep.municipio m
					   where upper(m.municipio) like upper(c.cons_municipio)
						 and rownum = 1) as cons_calculado_ate
					-- redespacho
					,c.red_razao_social,c.red_endereco,c.red_municipio
					,c.red_uf,c.red_cnpj_cpf,'' as red_pago,'' as red_apagar
					,c.serie || ' ' || c.num_conhecimento as red_num_conhec
					--local coleta
					,(select cm.nome_local
					    from cep.cep_loc cm
					   where cm.cod_municipio = c.coleta_cod_municipio
						 and cm.cod_uf = c.coleta_cod_uf
						 and cm.cod_dv = c.coleta_cod_dv
						 and cm.cod_distrito = c.coleta_cod_distrito
						 and rownum = 1) as coleta_municipio
					--local entrega
					,(select cm.nome_local
						from cep.cep_loc cm
					   where cm.cod_municipio = c.entrega_cod_municipio
						 and cm.cod_uf = c.entrega_cod_uf
						 and cm.cod_dv = c.entrega_cod_dv
						 and cm.cod_distrito = c.entrega_cod_distrito
						 and rownum = 1) as entrega_municipio
					-- cobrana     
					,decode(c.pagador, 0, c.rem_razao_social, 1, c.dest_razao_social) as cobr_razao_social
					,decode(c.pagador, 0, c.rem_endereco, 1, c.dest_endereco) as cobr_endereco
					,decode(c.pagador, 0, c.rem_municipio, 1, c.dest_municipio) as cobr_municipio
					,decode(c.pagador, 0, c.rem_uf, 1, c.dest_uf) as cobr_uf
					,decode(c.pagador, 0, oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_REMETENTE),1,
					 oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_DESTINATARIO)) as cobr_cnpj_cpf
					-- mercadorias transportadas
					,n.descricao as natureza_carga
					,fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
					,e.descricao as especie,c.volume as quantidade,
					(select sum(cnf.valor_total)
                  	   from fiscal.v$conhecimento_nota_fiscal cnf
                  	  where cnf.conhecimento_id = c.conhecimento_id) as peso_kg_nf
					,c.peso as peso_kg_nf
					,c.peso as peso_cobrar,'' as m3_l
					,(select sum(nf.valor_total)
						from fiscal.v$conhecimento_nota_fiscal nf
					   where nf.conhecimento_id = c.conhecimento_id) as valor_nf
					,(select sum(nf.valor_total)
					  	from fiscal.v$conhecimento_nota_fiscal nf
					   where nf.conhecimento_id = c.conhecimento_id) as valor_nf_segurado
					,'' as num_conhec_subcontr
					-- veculo transportador
					,c.prop_razao_social,oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_PROPRIETARIO) as prop_cnpj_cpf
					,c.placa as placa_sr
					,(select vc.placa_1
						from oper.v$veiculo_composicao vc
					   where vc.placa_2 = c.placa
						 and c.data_emissao between vc.data_hora_engate and nvl(vc.data_hora_desengate,sysdate)
						 and rownum = 1) as placa_veiculo
					-- composio do frete
					,c.frete_peso,c.frete_valor,c.sec_cat,c.despacho,c.pedagio
					,c.gris as seguro,c.coleta_entrega as outros,c.total_conhecimento as total_frete
					,c.base_calculo_icms as base_calculo,c.aliquota_icms as aliquota
					,c.valor_icms as valor,c.observacao
					,(select decode(sum(nfc.altura),'','','('||sum(nfc.altura)||'X'|| sum(nfc.largura)||'X'||sum(nfc.comprimento)||')')
                   		from v$conhecimento_nota_fiscal nfc
                       where nfc.conhecimento_id = c.conhecimento_id) as observacao_cubagem
			   from fiscal.v$conhecimento c
		 inner join kss.v$pessoa_juridica pj
				 on pj.cod_pessoa = c.cod_pessoa_filial
		  left join kss.v$pessoa_endereco en
				 on en.endereco_padrao = 1
				and en.cod_pessoa = c.cod_pessoa_filial
		  left join kss.v$pessoa_telefone tel
				 on tel.telefone_padrao = 1
				and tel.cod_pessoa = c.cod_pessoa_filial
		  left join kss.v$telefone t
				 on t.telefone_id = tel.telefone_id
		  left join fiscal.v$natureza n
				 on c.num_natureza = n.num_natureza
		  left join fiscal.v$especie e
				 on c.num_especie = e.num_especie
			  where c.conhecimento_id = #arguments.conhecimento_id#
		   order by c.data_emissao
  	</cfquery>
		<cfreturn qr_conhecimento>
	</cffunction>	
	
			<!--- 
	-- PROPSITO 
	-- Busca todos os Conhecimentos lanados
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/102006
	--->

	<cffunction name="print_conhecimento_bbm" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes" displayname="Identificador do sistema para o conhecimento" >
			<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
				 select 
				-- geral
					   c.num_conhecimento
					  ,c.natureza_operacao
					  ,c.cfop
					  ,c.serie as tipo_ctrc   
					  ,trunc(c.data_emissao) as data_emissao
					  ,to_char(c.data_emissao, 'HH24:MI:SS') as hora_emissao
					  ,to_char((select cod_unidade_negocio
						  	   from kss.v$unidade_negocio 
						 	  where cod_pessoa = c.cod_pessoa_filial),'00')||'/'||c.serie as serie
					  ,c.num_romaneio  
				--cabecalho_internet
					  ,en.logradouro || ' ' || en.numero || chr(13) as cabecalho_endereco
					  ,'Fone: ' || t.fone_ddd || '-' || t.fone_prefixo || t.fone_numero as cabecalho_telefone
					  ,'CEP: ' || en.cep as cabecalho_cep
					  ,'CNPJ: ' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial) as cabecalho_cnpj
					  ,'I.E.: ' || pj.inscricao_estadual as cabecalho_ie
				--cabecalho
					  ,en.logradouro||' '||en.numero||chr(13)||
					  'Fone: '||t.fone_ddd||'-'||t.fone_prefixo||t.fone_numero||chr(13)||
					  'CEP: ' ||en.cep||chr(13)||
					  'CNPJ: '||oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial)||chr(13)||
					  'I.E.: '||pj.inscricao_estadual as cabecalho
				-- emitente
					  ,pj.razao_social as emit_razao_social
					  ,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial) as emit_cnpj_cpf
					  ,pj.inscricao_estadual as emit_inscricao_estadual
					  ,en.logradouro||' '||en.numero as emit_endereco      
					  ,en.municipio as emit_municipio
					  ,en.cep as emit_cep
					  ,en.uf as emit_uf
					  ,t.fone_ddd||'-'||t.fone_prefixo||t.fone_numero as emit_telefone
					  ,(select cod_unidade_negocio
						  from kss.v$unidade_negocio 
						 where cod_pessoa = c.cod_pessoa_filial) as unidade_negocio
				-- remetente
					  ,c.rem_razao_social
					  ,c.rem_endereco
					  ,c.rem_municipio
					  ,c.rem_uf
					  ,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente) as rem_cnpj_cpf
					  ,c.rem_inscricao_estadual
				-- destinatario
					  ,c.dest_razao_social
					  ,c.dest_endereco
					  ,c.dest_municipio
					  ,c.dest_uf
					  ,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario) as dest_cnpj_cpf
					  ,c.dest_inscricao_estadual
				-- consignatrio
					  ,c.cons_razao_social
					  ,c.cons_endereco
					  ,c.cons_municipio
					  ,c.cons_inscricao_estadual
					  ,c.cons_uf
					  ,oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_CONSIGNATARIO) as cons_cnpj_cpf
					  ,decode(c.pagador, 0, 'X', '') as cons_pago
					  ,decode(c.pagador, 1, 'X', '') as cons_apagar
					  ,(select m.uf_id
						  from cep.municipio m
						 where upper(m.municipio) like upper(c.cons_municipio)
						   and rownum = 1) as cons_calculado_ate
				-- redespacho
					  ,c.red_razao_social
					  ,c.red_endereco
					  ,c.red_municipio
					  ,c.red_uf
					  ,c.red_inscricao_estadual
					  ,c.red_cnpj_cpf
					  ,'' as red_pago
					  ,'' as red_apagar
					  ,c.serie||' '||c.num_conhecimento as red_num_conhec
				--local coleta
					  ,(select cm.nome_local
						  from cep.cep_loc cm
						 where cm.cod_municipio = c.coleta_cod_municipio
						   and cm.cod_uf = c.coleta_cod_uf
						   and cm.cod_dv = c.coleta_cod_dv
						   and cm.cod_distrito = c.coleta_cod_distrito
						   and rownum = 1) as coleta_municipio
					  ,(select cm.sigla_uf
						  from cep.cep_loc cm
						 where cm.cod_municipio = c.coleta_cod_municipio
						   and cm.cod_uf = c.coleta_cod_uf
						   and cm.cod_dv = c.coleta_cod_dv
						   and cm.cod_distrito = c.coleta_cod_distrito
						   and rownum = 1) as coleta_uf
				--local entrega
					  ,(select cm.nome_local
						  from cep.cep_loc cm
						 where cm.cod_municipio = c.entrega_cod_municipio
						   and cm.cod_uf = c.entrega_cod_uf
						   and cm.cod_dv = c.entrega_cod_dv
						   and cm.cod_distrito = c.entrega_cod_distrito
						   and rownum = 1) as entrega_municipio
					   ,(select cm.sigla_uf
						  from cep.cep_loc cm
						 where cm.cod_municipio = c.entrega_cod_municipio
						   and cm.cod_uf = c.entrega_cod_uf
						   and cm.cod_dv = c.entrega_cod_dv
						   and cm.cod_distrito = c.entrega_cod_distrito
						   and rownum = 1) as entrega_uf
				-- cobrana     
					  ,decode(c.pagador, 0, c.rem_razao_social, 1, c.dest_razao_social) as cobr_razao_social
					  ,decode(c.pagador, 0, c.rem_endereco, 1, c.dest_endereco) as cobr_endereco
					  ,decode(c.pagador, 0, c.rem_municipio, 1, c.dest_municipio) as cobr_municipio
					  ,decode(c.pagador, 0, c.rem_uf, 1, c.dest_uf) as cobr_uf
					  ,decode(c.pagador, 0, oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_REMETENTE), 1, oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_DESTINATARIO)) as cobr_cnpj_cpf
				-- mercadorias transportadas
					  ,n.num_natureza as cod_natureza_carga
					  ,n.descricao as natureza_carga
					  ,fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
					  ,e.descricao as especie
					  ,c.volume as quantidade
					  ,c.m3 as peso_kg_nf
					  ,c.peso as peso_cobrar
					  , '' as m3_l
					  ,(select sum(nf.valor_total)
						  from fiscal.v$conhecimento_nota_fiscal nf
						 where nf.conhecimento_id = c.conhecimento_id) as valor_nf
					  ,(select sum(nf.valor_total)
						  from fiscal.v$conhecimento_nota_fiscal nf
						 where nf.conhecimento_id = c.conhecimento_id) as valor_nf_segurado
					  ,'' as num_conhec_subcontr
				-- veculo transportador
					  ,c.prop_razao_social
					  ,oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_PROPRIETARIO) as prop_cnpj_cpf
					  ,c.placa as placa_sr
					  ,c.PROP_UF
					  ,(select pe.municipio
						  from kss.v$pessoa_endereco_padrao pe
              			 where pe.cod_pessoa = c.cod_proprietario) as prop_municipio
					  ,(select vc.placa_1
						  from oper.v$veiculo_composicao vc
						 where vc.placa_2 = c.placa
						   and c.data_emissao between vc.data_hora_engate and vc.data_hora_desengate
						   and rownum = 1) as placa_veiculo
				-- composio do frete
					  ,c.frete_peso 
					  ,c.frete_valor 
					  ,c.sec_cat 
					  ,c.despacho 
					  ,c.pedagio 
					  ,c.gris as seguro
					  ,c.coleta_entrega as outros
					  ,c.total_conhecimento as total_frete           
					  ,c.base_calculo_icms as base_calculo 
					  ,c.aliquota_icms as aliquota 
					  ,c.valor_icms as valor_icms
					  ,c.observacao 
				 from fiscal.v$conhecimento c
		   inner join kss.v$pessoa_juridica pj
				   on pj.cod_pessoa = c.cod_pessoa_filial 
			left join kss.v$pessoa_endereco en
				   on en.endereco_padrao = 1
				  and en.cod_pessoa = c.cod_pessoa_filial
			left join kss.v$pessoa_telefone tel
				   on tel.telefone_padrao = 1        
				  and tel.cod_pessoa = c.cod_pessoa_filial 
			left join kss.v$telefone t
				   on t.telefone_id = tel.telefone_id 
			left join fiscal.v$natureza n
				   on c.num_natureza = n.num_natureza
			left join fiscal.v$especie e
				   on c.num_especie = e.num_especie 
				where c.conhecimento_id = #arguments.conhecimento_id#
			 order by c.data_emissao
			</cfquery>
		<cfreturn qr_conhecimento>
	</cffunction>	
	
		
	
	<!--- 
	-- PROPSITO 
	-- Busca Todos os romaneios de lotes prprios que no possuem conhecimento emitido no sistema
	-- NOTAS EXPLICATIVAS
	-- GUTO 24/02/2006
	--->
	<cffunction name="get_romaneio_sem_conhecimento" displayname="Busca Todos os romaneios de lotes prprios que no possuem conhecimento emitido no sistema" access="remote" returntype="query" output="true">
		<cfargument name="cavalo" required="no" default="0">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#" blockfactor="10">
			select /*ORDERED*/
			distinct decode(evo.num_evento, 100, 1, evo.num_evento) as evento_id,
					 rfr.placa_controle,
					 rfr.placa_referencia,
                     (select vc.placa_2
                        from oper.v$veiculo_composicao vc
                       where vc.placa_1 = rfr.placa_referencia
                         and roo.DATA_INICIO between data_hora_engate and nvl(data_hora_desengate,sysdate)) as placa_referencia_2,
					 oper.fnc_get_cod_veiculo(rfr.placa_controle) as frota_controle,
					 oper.fnc_get_cod_veiculo(rfr.placa_referencia) as frota_referencia,
					 roo.num_romaneio,
					 roo.carregamento,
                     <cfif session.site eq "verdescampos/">
                     	oper.pkg_veiculo.fnc_get_reboque(rfr.placa_controle) as composicao,
					 </cfif>
                     to_char(rfr.data_ultima_posicao,'dd/mm/yyyy hh24:mi') as data_ultima_posicao,
					 rfr.landmark referencia,
                	 evs.descricao_resumida as status
			  from oper.v$rank_frota rfr
			 inner join oper.v$romaneio roo 
			         on roo.num_romaneio = rfr.num_romaneio
			 inner join oper.v$romaneio_item rit 
			         on roo.num_romaneio = rit.num_romaneio
			 inner join oper.v$lote lo 
			         on lo.num_lote = rit.num_lote
					and lo.frete_proprio = 1
			 inner join oper.v$evento_operacao evo 
			         on evo.controle_evo_id = rfr.roo_evo_id
			 inner join oper.v$evento_operacao_setup evs 
			         on evs.num_evento =evo.num_evento
			 inner join oper.v$lote_setor_docto lsd on rit.num_lote = lsd.num_lote
			 where evo.NUM_EVENTO <> 5
			   and not exists (select 'x'
					  from oper.v$conhecimento c
					 where c.num_romaneio = roo.num_romaneio
					   and c.item_id = rit.item_id)
			  and lsd.COD_PESSOA_FILIAL = #session.cod_pessoa#
			  and lsd.COD_DEPARTAMENTO = #session.cod_departamento#
			  and lsd.cod_setor = #session.cod_setor#
            <cfif arguments.cavalo eq 1>
              and rfr.placa_controle is not null
            </cfif>
 	    </cfquery>
	    <cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca Sries
	-- NOTAS EXPLICATIVAS
	-- GUTO 24/02/2006
	--->
	<cffunction name="get_serie" displayname="Busca Sries" access="remote" returntype="query" output="false">
	    <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_pessoa" hint="Usado para algumas telas que usam o COD_PESSOA como o cdigo pessoa da filial" required="no" default=""/>
	    <cfargument name="cod_departamento" required="no">
	    <cfargument name="cod_setor" required="no">
	    <cfargument name="cod_centro_custo" required="no">
		<cfargument name="cod_modelo" required="no" default="">
	    <cfargument name="organograma" required="no" default="">		
		<cfargument name="todas" required="no">
        <cfargument name="ordenada" required="no">
        <cfargument name="documento_proprio" required="no">
		<cfif Len(Trim(arguments.cod_pessoa)) and not Len(Trim(arguments.cod_pessoa_filial))>
			<cfset arguments.cod_pessoa_filial = arguments.cod_pessoa>
		</cfif>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cfif not isDefined("arguments.todas")>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				 <cfif Len(Trim(arguments.cod_pessoa_filial))>
					select ags.serie, ags.cod_modelo , (select f.formulario_id
                                                          from kss.v$formulario f
                                                         where f.formulario_id = ags.formulario_id) as formulario
					  from fiscal.v$modelo_serie ags
					 where ags.cod_pessoa       = #arguments.cod_pessoa_filial#
					   and ags.cod_departamento = #arguments.cod_departamento#
					   <cfif isDefined("arguments.cod_setor") and Len(Trim(arguments.cod_setor))>
                       	and ags.cod_setor        = #arguments.cod_setor#
                       </cfif>                       
					   and ags.ativo 			= 1 
					   <cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
					   </cfif>
                       <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
					   </cfif>
					  order by ags.cod_pessoa, ags.cod_departamento, ags.cod_setor
                      <cfif  isDefined("arguments.ordenada") and Len(Trim(arguments.ordenada))>
                      , lpad(ags.serie,3,'0')
                      </cfif>
				 <cfelse>
					select distinct ags.serie
					  from fiscal.v$modelo_serie ags
					 inner join oper.v$kss_usuario_lotacao ul
						on ags.cod_pessoa = ul.cod_pessoa
					   and ags.cod_departamento = ul.cod_departamento
					   and ags.cod_setor = ul.cod_setor
					  where ags.ativo 	 = 1
					  	<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
					   </cfif>
                       <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
					   </cfif>
					  order by ags.serie
				 </cfif>
			</cfquery>		
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				select distinct serie 
				from fiscal.v$modelo_serie ags
				where ativo 	 = 1
				<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
				</cfif>
                <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
					   </cfif>
  			</cfquery>		
	    </cfif>
		<cfreturn qr_serie> 
	</cffunction>	
    
    
    <!--- 
	-- PROPSITO 
	-- Busca Sries relativas ao organograma do conhecimento
	-- NOTAS EXPLICATIVAS
	-- WAGNER 06/01/2011
	--->
	<cffunction name="get_serie_conhecimento" displayname="Busca Sries" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default="">
        <cfargument name="conhecimento_id" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
					select distinct ags.serie
                      from fiscal.v$modelo_serie ags
                     inner join (select cod_pessoa_filial,
                                         cod_departamento,
                                         cod_setor,
                                         cod_centro_custo
                                  from fiscal.v$conhecimento c
                                  where c.conhecimento_id = #conhecimento_id#) t
                        on t.cod_pessoa_filial = ags.cod_pessoa
                       and t.cod_departamento = ags.cod_departamento
                       and t.cod_setor = ags.cod_setor
                       and t.cod_centro_custo = ags.cod_centro_custo
                       
                     where 1=1
					   <cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo)) >
					   		and ags.cod_modelo = '#arguments.cod_modelo#'
					   </cfif>
                       and ags.ativo = 1
  			</cfquery>
		<cfreturn qr_serie> 
	</cffunction>
    

	<!--- 
	-- PROPSITO 
	-- Busca relaes de complemento em aberto
	-- NOTAS EXPLICATIVAS
	-- GUTO 24/02/2006
	--->
	<cffunction name="get_relacao_aberto" displayname="Busca relaes de complemento em aberto" access="remote" returntype="query" output="true">
	<cfargument name="conhecimento_romaneios" displayname="FLAG Conhecimento ou Romaneio, 0 - CTRC. 1 - Romaneio" required="no" default="0">
	<cfargument name="relacao_id" required="no" default="" />
	<cfargument name="pagador" required="no" default="" />
	<cfargument name="todas" displayname="FLAG que indica a consulta por todas as relaes" required="no" />
		<cfquery datasource="#session.dsn#" name="qr_relacao_complemento" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.conhecimento_romaneios eq 0>
				select /*+ FIRST_ROWS */ 
					   cc.relacao_id, 
					   cc.conhecimento_id, 
					   decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) as pagador,
					   decode(c.pagador,0,c.rem_razao_social,c.dest_razao_social) as razao_social, 
					   decode(c.pagador,0,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente),oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario)) as cnpj_cpf, 
					   c.num_conhecimento, 
					   oper.pkg_operacional.fnc_converte_peso(c.peso,'Kg',c.cod_unidade) as peso_lancado, 
					   oper.pkg_operacional.fnc_converte_peso(c.peso+cc.peso,'Kg',c.cod_unidade) as peso_correto, 
                       oper.pkg_operacional.fnc_converte_peso(c.peso_cobrado , 'Kg', c.cod_unidade) as peso_cobrado,
                       oper.pkg_operacional.fnc_converte_peso(c.peso_cobrado + nvl(cc.peso_cobrado, 0), 'Kg', c.cod_unidade) as peso_cobrado_correto,
                       c.m3 as m3_lancado,
					   c.m3 + cc.m3 as m3_correto, 
					   cc.volume, 
					   cc.m3, 
					   c.frete_unitario as unit_lancado, 
					   cc.valor_unitario as unit_correto, 
					   c.frete_valor as frete_lancado, 
					   cc.valor_frete_liquido + c.frete_valor as frete_correto, 
					   cc.valor_frete_liquido as diferenca, 
					   cc.cod_unidade, 
					   oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,
					   c.cod_pessoa_filial, 
					   c.cod_setor, 
					   decode(cc.situacao,1,'Fechada','Aberta') as situacao
				  from oper.v$conhecimento_complemento cc
				 inner join oper.v$conhecimento c
					on cc.conhecimento_id = c.conhecimento_id
				 <cfif not isDefined("arguments.todas")>
					 inner join oper.v$kss_usuario_lotacao ul
						on c.cod_pessoa_filial = ul.cod_pessoa
						and ul.cod_aplicacao = 'EMISSAO_DOCUMENTO'
			     </cfif>
				 where 1=1
				 <cfif not isDefined("arguments.todas")>
  		          and cc.situacao = 0
				 </cfif> 
				 <cfif Len(Trim(arguments.RELACAO_ID))>
  		           and cc.relacao_id = #arguments.RELACAO_ID#
				 </cfif> 
				 <cfif Len(Trim(arguments.pagador))>
				   and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.pagador#
				 </cfif>
				order by pagador, cc.relacao_id 
          <cfelse>
				select /*+ FIRST_ROWS */ c.conhecimento_id, r.num_romaneio, cc.relacao_id, avg(c.frete_unitario) as unit_lancado, avg(cc.valor_unitario) as unit_correto,
					   sum(oper.pkg_operacional.fnc_converte_peso(c.peso,'Kg',c.cod_unidade)) as peso_lancado, 
					   sum(oper.pkg_operacional.fnc_converte_peso(c.peso,'Kg',c.cod_unidade)) + sum(oper.pkg_operacional.fnc_converte_peso(cc.peso,'Kg',cc.cod_unidade)) as peso_correto,
                       sum(c.m3) as m3_lancado,
 					   sum(c.m3) + sum(cc.m3) as m3_correto,
					   sum(c.total_conhecimento) as frete_lancado, sum(c.total_conhecimento) + sum(cc.valor_frete) as frete_correto,
                       sum(c.frete_valor) as valor_cobrado,
 					   sum(c.frete_valor) + sum(cc.valor_frete_liquido) as valor_correto,
					   sum(cc.valor_frete_liquido) as diferenca, oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,  
					   decode(c.pagador,0,c.rem_razao_social,c.dest_razao_social) as razao_social,
					   c.cod_pessoa_filial, c.cod_setor, 
					   decode(cc.situacao,1,'Fechada','Aberta') as situacao
 			      from oper.v$conhecimento_complemento cc
			     inner join oper.v$conhecimento c       
					     on cc.conhecimento_id = c.conhecimento_id
				 <cfif not isDefined("arguments.todas")>
					 inner join kss.v$kss_usuario_lotacao ul
						on c.cod_pessoa_filial = ul.cod_pessoa
					   and c.cod_setor = ul.cod_setor
					   and ul.usuario = user
					   and ul.cod_aplicacao = 'EMISSAO_DOCUMENTO'
				 </cfif> 
				inner join oper.v$romaneio r
				  on r.num_romaneio = c.num_romaneio
				 where 1=1
				 <cfif not isDefined("arguments.todas")>
			       and cc.situacao = 0
				 </cfif> 
				 <cfif Len(Trim(arguments.relacao_id))>
				   and cc.relacao_id = #arguments.relacao_id#
				 </cfif>
			  group by r.num_romaneio, c.conhecimento_id, 
			  		   cc.relacao_id,decode(c.pagador,0,c.rem_razao_social,c.dest_razao_social),
			  		   oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id), c.cod_pessoa_filial, c.cod_setor, decode(cc.situacao,1,'Fechada','Aberta')
					order by cc.relacao_id 
		  </cfif>
		</cfquery> 
		<cfreturn qr_relacao_complemento>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os Conhecimentos realcionados a nota fiscal
	-- CRISTOFER  05/06/2006
	--->		
	<cffunction name="get_busca_conhecimento_nota" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */ c.conhecimento_id, decode(c.situacao_id,0,'Confirmado',1,'Cancelado',2,'Impresso') as situacao,
				   c.num_conhecimento, s.descricao as setor, c.serie, c.user_insert, c.data_emissao, 
				   c.peso, c.frete_valor, c.frete_unitario, c.despacho, c.total_conhecimento,
				   c.valor_icms, oper.pkg_global.fnc_busca_nome_pessoa(c.cod_remetente) as remetente,
				   oper.pkg_global.fnc_busca_nome_pessoa(c.cod_destinatario) as destinatario
			  from oper.v$conhecimento_nota_fiscal cnf
			 inner join oper.v$conhecimento c
				on c.conhecimento_id = cnf.conhecimento_id
			 inner join oper.v$setor s
				on c.cod_pessoa_filial = s.cod_pessoa_filial
			   and c.cod_setor = s.cod_setor
			 where cnf.numero = #arguments.num_nota_fiscal#	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os conhecimentos da relacao
	-- CRISTOFER  05/06/2006
	--->		
	<cffunction name="get_conhecimentos_relacao" access="remote" returntype="query" output="true">
		<cfargument name="relacao_id" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_setor" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_romaneio, c.conhecimento_id, c.num_conhecimento, c.data_emissao, 
				   oper.pkg_global.fnc_busca_nome_pessoa(c.cod_remetente) as remetente,
				   oper.pkg_global.fnc_busca_nome_pessoa(c.cod_destinatario) as destinatario,
				   c.frete_valor, c.peso, c.total_conhecimento
			  from oper.v$conhecimento c
			 where c.num_romaneio in (select r.num_romaneio
												  from oper.v$conhecimento_complemento cc
												 inner join oper.v$conhecimento c2       
													  on cc.conhecimento_id = c2.conhecimento_id
											 <cfif len(trim(arguments.cod_pessoa_filial))>
												   and c2.cod_pessoa_filial = #arguments.cod_pessoa_filial#
												   and c2.cod_setor = #arguments.cod_setor#
											 <cfelse>
												 inner join oper.v$kss_usuario_lotacao ul
													  on c2.cnpj_basico_filial = ul.cnpj_basico
												   and c2.cnpj_ordem_filial = ul.cnpj_ordem
												   and ul.usuario = user
												   and ul.cod_aplicacao = 'EMISSAO_DOCUMENTO'
											 </cfif>
											   inner join oper.v$romaneio r
												  on r.num_romaneio = c2.num_romaneio
												 where 1=1
											 <cfif Len(Trim(arguments.relacao_id))>	 
												 and cc.relacao_id = #arguments.relacao_id# 
										     </cfif>
											group by r.num_romaneio)
			order by c.conhecimento_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as notas dos conhecimentos da relacao
	-- CRISTOFER  05/06/2006
	--->		
	<cffunction name="get_notas_conhecimentos_relacao" access="remote" returntype="query" output="true">
		<cfargument name="relacao_id" required="yes">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_setor" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nf.conhecimento_id, nf.data_emissao as nf_data_emissao, nf.modelo as nf_modelo, nf.serie as nf_serie, 
				   nf.sub_serie as nf_sub_serie, nf.numero as nf_numero, nf.valor_total as nf_valor_total
			  from oper.v$conhecimento_nota_fiscal nf   
			 where nf.conhecimento_id in (select c2.conhecimento_id 
											from oper.v$conhecimento c2
										   where c2.num_romaneio in (select r.num_romaneio
																			  from oper.v$conhecimento_complemento cc
																			 inner join oper.v$conhecimento c       
																				  on cc.conhecimento_id = c.conhecimento_id
																			 <cfif len(trim(arguments.cod_pessoa_filial))>
																				   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
																				   and c.cod_setor = #arguments.cod_setor#
																			 <cfelse>
																				 inner join oper.v$kss_usuario_lotacao ul
																					  on c.cod_pessoa_filial = ul.cod_pessoa
																				   and c.cod_setor = ul.cod_setor
																				   and ul.usuario = user
																				   and ul.cod_aplicacao = 'EMISSAO_DOCUMENTO'
																			 </cfif>
																		   inner join oper.v$romaneio r
																			  on r.num_romaneio = c.num_romaneio
																			 where cc.relacao_id = #arguments.relacao_id#
																	  group by r.num_romaneio))
			order by nf.conhecimento_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca dados de um complemento j feito
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/04/2006
	--->
	<cffunction name="get_conhecimento_complemento" displayname="Busca dados de um complemento j feito" access="remote" returntype="query" output="false">
		<cfargument name="relacao_id" required="no" default="" />
		<cfargument name="conhecimento_id" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#" blockfactor="10">
			select c.num_conhecimento, c.conhecimento_id, c.data_emissao, cc.relacao_id, c.serie,
				   c.cod_pessoa_filial || '_' || c.cod_departamento || '_' || c.cod_setor || '_' || c.cod_centro_custo as organograma,
				   oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso_lancto, 
				   oper.pkg_operacional.fnc_converte_peso(c.peso + cc.peso, 'Kg', c.cod_unidade) as peso_correto, 
				   c.frete_unitario as unit_lancto, cc.valor_unitario unit_correto, 
				   c.total_conhecimento as valor_lancto, c.total_conhecimento + cc.valor_frete as valor_correto, 
				   cc.valor_frete as diferenca,
				   oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,
				   cc.situacao
			  from fiscal.v$conhecimento c
			 inner join fiscal.v$conhecimento_complemento cc
					 on cc.conhecimento_id = c.conhecimento_id
			where 1=1
			  <cfif Len(Trim(arguments.relacao_id))>
				  and cc.relacao_id = #arguments.relacao_id#
			  </cfif>
			  <cfif Len(Trim(arguments.conhecimento_id))>
				  and c.conhecimento_id = #arguments.conhecimento_id#
			  </cfif>			  
			  <cfif not Len(Trim(arguments.relacao_id)) and not Len(Trim(arguments.conhecimento_id))>
				  and 0=1 -- se no for passado nenhum parametro no retorna nenhuma linha
			  </cfif>			  			  
		</cfquery>
	    <cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca dados do item do romaneio
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/04/2006
	--->
	<cffunction name="get_romaneio_item" displayname="Busca o item do romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" required="no" default="" />
		<cfargument name="frete_proprio" displayname="FLAG que indica se a consulta  por frete propio" required="no" default="1" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */
                   ri.num_romaneio, 
                   ri.item_id, 
                   ri.num_lote, 
                   ri.volume, 
                   ri.m3, 
                   ri.valor_frete,
                   ri.cod_remetente, 
                   rem.razao_social as remetente, 
                   rem.cnpj_cpf as rem_cnpj_cpf,
                   rmun.municipio as rem_municipio, 
                   rmun.uf_id as rem_uf,
                   rend.logradouro || ', ' || rend.numero || ' - ' || rend.complemento as rem_endereco, 
                   to_char(rend.cep) as rem_cep, 
                   rend.bairro as rem_bairro, 
                   initcap(rmun.municipio) as coleta, 
                   rem.inscricao_estadual as rem_inscr_estadual, 
                   ri.cod_destinatario, 
                   dest.razao_social as destinatario, 
                   dest.cnpj_cpf as dest_cnpj_cpf, 
                   dend.logradouro || ', ' || dend.numero || ' - ' || dend.complemento as dest_endereco,
                   dmun.uf_id as dest_uf,
                   to_char(dend.cep) as dest_cep, 
                   dend.bairro as dest_bairro, 
                   initcap(dmun.municipio) as dest_municipio,
                   dest.cod_atividade_fiscal as dest_atividade_fiscal,          
                   dest.inscricao_estadual as dest_inscr_estadual,
                   ri.observacao, 
                   l.icms_incluso, 
            --       l.frete_valor_unitario,    
                   l.pedagio_incluso, 
            --       l.aliquota_icms, 
            --       l.destaca_base_calc_icms, 
            --       l.reducao_base_calculo,
                   l.frete_por_conta, 
                   l.frete_em, 
            --       l.fundamentacao_legal, 
                   l.num_produto,
                   decode(l.frete_por_conta, 0, rem.cod_atividade_fiscal, dest.cod_atividade_fiscal) as cod_atividade_fiscal,
                   /*case frete_em
                      when 'PESO' then fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'Kg', l.cod_unidade) * l.frete_valor_unitario
                      when 'VOLUME' then ri.volume * l.frete_valor_unitario
                      when 'M3' then ri.m3 * l.frete_valor_unitario
                      when 'LOTACAO' then l.frete_valor_unitario
                   end total_conhecimento,*/
                   fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'Kg', l.cod_unidade) as peso,
                   decode(ld.imprime_conhecimento, 1, ld.observacao, '') as rodape,
                   decode(l.cod_pessoa_destinatario, null, 0, 1) as lote_com_destinatario,
            --       l.situacao_tributaria as st_icms_id, 
                   l.frete_proprio, 
                   l.regra_fiscal_id, 
                   ri.redespacho,
                   lc.razao_social as cons_razao_social,
                   lc.cnpj_cpf as cons_cnpj_cpf,
                   lc.inscricao_estadual as cons_inscricao_estadual,
                   lc.endereco as cons_endereco,
                   lc.cep as cons_cep,
                   lc.municipio as cons_municipio,
                   lc.uf as cons_uf,
                   lc.cod_consignatario,
                   InitCap(dmun.municipio) entrega,
                   dmun.uf_id as entrega_uf
                       
              from oper.v$romaneio_item ri
             inner join oper.v$lote l
                     on ri.num_lote = l.num_lote
              left join oper.v$lote_consignatario lc
                     on lc.num_lote = l.num_lote
             inner join kss.v$pessoa rem
                     on ri.cod_remetente = rem.cod_pessoa
             inner join kss.v$pessoa_endereco rend
                     on rend.cod_pessoa = rem.cod_pessoa
                    and rend.endereco_padrao = 1
             inner join cep.municipio rmun
                     on coalesce(l.coleta_municipio_id,rend.municipio_id) = rmun.municipio_id
              left join kss.v$pessoa dest
                     on ri.cod_destinatario = dest.cod_pessoa
              left join kss.v$pessoa_endereco dend
                     on dend.cod_pessoa = dest.cod_pessoa
                    and dend.endereco_padrao = 1
              left join cep.municipio dmun
                     on coalesce(l.entrega_municipio_id,dend.municipio_id) = dmun.municipio_id
              left join oper.v$lote_descarga ld
                     on l.num_lote = ld.num_lote
			 where num_romaneio = #arguments.num_romaneio#
			 <cfif Len(Trim(arguments.item_id))>
			   and ri.item_id = #arguments.item_id#
			 </cfif>
 			 <cfif arguments.frete_proprio eq 1>
			   and l.frete_proprio = 1
			 <cfelse>
			   and l.frete_proprio <> 1
			 </cfif> 
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca dados do romaneio
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/04/2006
	--->
	<cffunction name="get_romaneio_aberto" displayname="Busca o romaneio aberto para o veculo" access="remote" returntype="query" output="true">
		<cfargument name="placa_referencia" required="no" default="" />
		<cfargument name="placa_controle" required="no" default="" />
		<cfargument name="data" required="no" default="" />
		<cfargument name="num_romaneio" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			 select /*+ STAR_TRANSFORMATION */ 
             		r.num_romaneio, 
                    r.carregamento, 
                    r.destino, 
                    r.cliente, 
                    r.remetente, 
                    r.destinatario, 
                    rhv.data_inicio,
                    rhv.data_termino, 
                    r.data_previsao_descarga, 
				    r.data_previsao_carregado, 
                    r.num_natureza, 
                    n.descricao as natureza, 
                    r.num_especie, 
                    r.cod_unidade, 
                    r.frete_em, 
                    fiscal.pkg_fiscal.fnc_converte_peso(r.peso_total, 'Kg',r.cod_unidade) as peso_convertido,
 				    r.peso_total, 
                    r.volume_total, 
                    r.m3_total, 
                    r.frete_total, 
				    r.valor_entregue, 
                    r.km_vazio, 
                    r.km_carregado, 
                    r.valor_pedagio_vazio, 
                    r.valor_pedagio_carregado, 
                    nvl(r.valor_descarga,0) as valor_descarga, 
                    r.org_logradouro, 
				    r.org_complemento, 
                    r.org_bairro, 
                    r.org_cep, 
                    r.dest_logradouro, 
				    r.dest_complemento, 
                    r.dest_bairro, 
                    r.dest_cep, 
                    r.situacao_id, 
				    r.data_inicio_carga, 
                    r.data_termino_carga, 
                    r.data_inicio_descarga, 
                    r.data_termino_descarga, 
                    r.observacao, 
                    r.data_destinado, 
                    rhv.placa_referencia, 
                    rhv.placa_controle,
				    oper.pkg_veiculo.fnc_get_composicao(rhv.placa_controle) as composicao
			   from oper.v$romaneio r
			  inner join oper.v$romaneio_hist_veiculo rhv
				      on r.num_romaneio = rhv.num_romaneio    
			   left join oper.v$natureza n
				      on r.num_natureza = n.num_natureza
			 where 1 = 1
			 	and nvl(rhv.data_termino,sysdate) = (select max(nvl(rhv2.data_termino,sysdate)) 
												      from oper.v$romaneio_hist_veiculo rhv2
													 where rhv2.num_romaneio = rhv.num_romaneio)
			 <cfif Len(Trim(arguments.num_romaneio))>
				and r.num_romaneio = #arguments.num_romaneio#
			 <cfelse>
			 	<cfif Len(Trim(arguments.data)) and Len(Trim(arguments.placa_referencia)) and Len(Trim(arguments.placa_controle))>
				   and rhv.placa_controle = '#Replace(arguments.placa_controle,'-','')#'
				   and rhv.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'    
				   and to_date('#arguments.data#','dd/mm/yyyy hh24:mi') between rhv.data_inicio and nvl(rhv.data_termino,sysdate)
			   <cfelseif not Len(Trim(arguments.data)) and Len(Trim(arguments.placa_referencia)) and Len(Trim(arguments.placa_controle))>
			       and rhv.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'    
				   and rhv.placa_controle = '#Replace(arguments.placa_controle,'-','')#'
				   and nvl(rhv.data_termino,sysdate) = (select max(nvl(rhv2.data_termino,sysdate)) 
														  from oper.v$romaneio_hist_veiculo rhv2 
														   where rhv2.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'    
															 and rhv2.placa_controle = '#Replace(arguments.placa_controle,'-','')#')
															 
			   </cfif>
			 </cfif>
		</cfquery>
		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca dados do romaneio
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/04/2006
	--->
	<cffunction name="get_romaneio_veiculo" displayname="Busca o romaneio aberto para o veculo" access="remote" returntype="query" output="true">
		<cfargument name="placa_referencia" required="no" default="" />
		<cfargument name="placa_controle" required="no" default="" />
		<cfargument name="data_inicial" required="no" default="" />
		<cfargument name="data_final" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			  select /*+ STAR_TRANSFORMATION */ distinct r.num_romaneio, r.carregamento, r.destino, r.cliente, r.remetente, r.destinatario, 
       		           min(trunc(rhv.data_inicio)) over (partition by c.conhecimento_id, rhv.PLACA_REFERENCIA order by c.conhecimento_id, rhv.PLACA_REFERENCIA) data_inicio,
                       /*  trunc(rhv.data_inicio) data_inicio, rhv.data_termino, */ 
                        r.data_previsao_descarga, 
					   r.data_previsao_carregado, r.num_natureza, n.descricao as natureza, r.num_especie, r.cod_unidade, r.frete_em, oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'Kg',r.cod_unidade) as peso_convertido,
					   r.peso_total, r.volume_total, r.m3_total, r.frete_total,
					   c.num_conhecimento || ' - ' || to_char(substr(pj.cnpj_ordem,3,2)) || '/' || c.serie as num_ctrc_serie,
					   r.valor_entregue, r.km_vazio, r.km_carregado, r.valor_pedagio_vazio, r.valor_pedagio_carregado, nvl(r.valor_descarga,0) as valor_descarga, r.org_logradouro, 
					   r.org_complemento, r.org_bairro, r.org_cep, r.org_cod_uf, r.org_cod_municipio, r.org_cod_distrito, r.org_cod_dv, r.dest_logradouro, 
					   r.dest_complemento, r.dest_bairro, r.dest_cep, r.dest_cod_uf, r.dest_cod_municipio, r.dest_cod_distrito, r.dest_cod_dv, r.situacao_id, 
					   r.data_inicio_carga, r.data_termino_carga, r.data_inicio_descarga, r.data_termino_descarga, r.observacao, r.data_destinado, rhv.placa_referencia, rhv.placa_controle,
				       /* oper.pkg_veiculo.fnc_get_composicao(rhv.placa_controle) as composicao, */
					   oper.pkg_veiculo.fnc_get_composicao(c.placa) as composicao,
        oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_controle) || ' / ' || oper.pkg_veiculo.fnc_get_cod_veiculo(rhv.placa_referencia) as composicao_frota,
					   rhv.cod_pessoa as cod_pessoa_motorista,
					   rot.abreviatura as rota,
					   kss.pkg_global.fnc_busca_nome_pessoa(rhv.cod_pessoa) as motorista,
                       to_char(c.data_emissao,'dd/mm/yyyy hh24:mi:ss') as data_emissao_ctrc,
                       oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg','Kg') peso_ctrc,
                       c.total_conhecimento
			   from oper.v$romaneio r
	     inner join fiscal.v$conhecimento c
          		 on c.num_romaneio = r.num_romaneio
	     inner join oper.v$rota rot
 		 		 on rot.rota_id = c.rota_id
	     inner join kss.pessoa_juridica pj
		 		 on pj.cod_pessoa = c.cod_pessoa_filial
		 inner join oper.v$romaneio_hist_veiculo rhv
		  		 on r.num_romaneio = rhv.num_romaneio    
	     inner join oper.v$natureza n
				 on r.num_natureza = n.num_natureza
         where 1=1
			 <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
			    and rhv.data_inicio between '#LSDateFormat(arguments.data_inicial)#' and '#LSDateFormat(arguments.data_final)#'
			</cfif>
			<cfif Len(Trim(arguments.placa_controle))>
				and rhv.placa_controle = '#Replace(arguments.placa_controle,'-','')#'
			</cfif>
			<cfif Len(Trim(arguments.placa_referencia)) >
				and rhv.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'  
			</cfif>
			
		</cfquery>
		
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca natureza
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 19/07/2009 - MODIFICADO
	--->
	<cffunction name="get_natureza" displayname="Busca Natureza" access="remote" returntype="query" output="false">
		<cfargument name="num_natureza" required="no" default="">
		<cfargument name="descricao" required="no" default="">
        <cfargument name="order_by" required="no" default="0" hint="0-Descrio Resumida, Descrio; 1-Descrio">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select n.num_natureza, n.descricao, n.grupo_natureza_id, gn.descricao_resumida grupo, gn.descricao as descricao_grupo, n.peso_especifico
              from oper.v$natureza n
             inner join oper.v$grupo_natureza gn
                     on gn.grupo_natureza_id = n.grupo_natureza_id
             where 1=1
			<cfif Len(Trim(arguments.num_natureza))>
			   and n.num_natureza = #arguments.num_natureza#
			</cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(n.descricao) like upper('%#arguments.descricao#%')
			</cfif>
            <cfif arguments.order_by eq 0>
			 order by gn.descricao_resumida, n.descricao
            <cfelseif arguments.order_by eq 1>
             order by n.descricao
            </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca natureza da Operao 
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_natureza_operacao" displayname="Busca Natureza Operao" access="remote" returntype="query" output="false">
		<cfargument name="natureza_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select nop.natureza_id
                 , nop.descricao
                 , nop.e_s
                 --, decode(nop.e_s, 0, 'Entrada', 'Sada') as e_s
              from fiscal.v$natureza_operacao nop
			 <cfif Len(Trim(arguments.natureza_id))>
			 	where nop.natureza_id = #arguments.natureza_id#
			 </cfif>
             <cfif Len(Trim(arguments.descricao))>
			 	where upper(kss.pkg_string.fnc_string_clean(nop.descricao)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.descricao#%'))
			 </cfif>
  			 order by nop.descricao
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca espcie
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_especie" displayname="Busca Espcie" access="remote" returntype="query" output="false">
		<cfargument name="num_especie" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select  e.num_especie, e.descricao
			  from oper.v$especie e	
			 where 1=1
			 <cfif len(trim(arguments.num_especie))>
			   and num_especie = #arguments.num_especie#
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(e.descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by e.descricao
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca unidades de medida
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 20/04/2009
	--->
	<cffunction name="get_unidade" displayname="Busca unidades de medida" access="remote" returntype="query" output="false">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select u.cod_unidade, 
            	   u.unidade, 
                   u.cod_grupo_umedida,
                   nvl((select uc.equivalencia
                      from fiscal.v$unidade_medida_conversao uc
                     where uc.cod_unidade = u.cod_unidade
                       and uc.cod_unidade_eq = 'Kg'),1) as equivalencia_kg
			  from fiscal.v$unidade_medida u
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca Modelos para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_modelo_nota" displayname="Busca Modelos para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="documento_proprio" required="no" default="1">
		<cfargument name="cod_modelo" required="no" default="'01','04'">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct smf.cod_modelo
                 , smf.modelo
              from fiscal.v$modelo_serie ms
             inner join fiscal.v$sintegra_modelo_fiscal smf
                     on smf.cod_modelo = ms.cod_modelo
                    and ms.documento_proprio = #arguments.documento_proprio#
             where 1 = 1
			<cfif Len(Trim(arguments.cod_modelo))>
			   and smf.cod_modelo in (#PreserveSingleQuotes(arguments.cod_modelo)#)
			</cfif>
 			 order by smf.modelo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca Srie para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_serie_nota" displayname="Busca Srie para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="cod_departamento" required="no" default=""/>
		<cfargument name="cod_setor" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1">
		<cfargument name="todas" required="no" default="0">
		<cfargument name="todos_modelos" required="no" default="0">
		<cfif arguments.TODAS eq 0>
        	<cfif arguments.todos_modelos eq 0>
                <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
                    select ms.cod_pessoa, ms.cod_departamento, ms.cod_setor,
                             ms.cod_modelo, ms.serie, ms.subserie, ms.num_inicial, 
                             ms.num_final, ms.documento_proprio, ms.incluir_livro_fiscal, ms.INCLUIR_SINTEGRA
                      from fiscal.v$modelo_serie ms
                     where ms.ativo = 1
                        and ms.documento_proprio = #arguments.documento_proprio#
                    <cfif Len(Trim(arguments.cod_modelo))>
                        and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
                    </cfif>
                    <cfif Len(Trim(arguments.cod_pessoa))>
                       and ms.cod_pessoa = #arguments.cod_pessoa#
                        and ms.cod_departamento = #arguments.cod_departamento#
                        and ms.cod_setor = #arguments.cod_setor#
                    </cfif>
                    order by ms.cod_pessoa, ms.cod_departamento, ms.cod_setor, ms.cod_modelo, ms.serie, ms.subserie 
                </cfquery>		
            <cfelse>
                <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
                    select distinct ms.cod_modelo, ms.serie, ms.INCLUIR_SINTEGRA
                      from fiscal.v$modelo_serie ms
                     where ms.ativo = 1
                        and ms.documento_proprio = #arguments.documento_proprio#
                    <cfif Len(Trim(arguments.cod_modelo))>
                        and ms.cod_modelo in (#PreserveSingleQuotes(arguments.cod_modelo)#)
                    </cfif>
                    order by ms.cod_modelo, ms.serie
                </cfquery>		
            </cfif>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.serie, ms.documento_proprio, ms.incluir_livro_fiscal, ms.INCLUIR_SINTEGRA
				  from fiscal.v$modelo_serie ms
				 where ms.ativo = 1
					and ms.documento_proprio = #arguments.documento_proprio#
				order by ms.serie
			</cfquery>		
		</cfif>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca Sub-series para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_sub_serie_nota" displayname="Busca Sub-series para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="todas" required="no" default="0" />
		<cfif arguments.TODAS eq 0>
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.cod_modelo, smf.modelo, ms.serie, ms.subserie
				  from fiscal.v$modelo_serie ms
                inner join fiscal.v$sintegra_modelo_fiscal smf on smf.cod_modelo = ms.cod_modelo
				 where 1=1
				 and ms.ativo = 1 
				 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
				 <cfif Len(Trim(arguments.cod_modelo))>
					and ms.cod_modelo = '#arguments.cod_modelo#'
				 </cfif>
				 <cfif Len(Trim(arguments.serie))>
					and ms.serie ='#arguments.serie#'
				 </cfif>
				 order by ms.cod_modelo, ms.serie, ms.subserie
				</cfquery>		
		<cfelse>			
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.subserie
				  from fiscal.v$modelo_serie ms
				 where 1=1
				 and ms.ativo = 1 
				 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
				</cfquery>		
		</cfif>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Executa todos os calculos do CTRC levando em considerao as regras fiscais
	-- guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name='calcula_ctrc' displayname='Executa todos os calculos do CTRC levando em considera??o as regras fiscais' access='remote' 
     returntype='Struct' false='true'>
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='M3' required='no' default="0">
		<cfargument name='VOLUME' required='no' default="0">
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='PEDAGIO' required='yes' >
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='ENTREGA_UF' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
   		<cfif session.site eq "verdescampos/">
			<cfset v_empresa = 1>
		<cfelse>
			<cfset v_empresa = 0>
		</cfif>
            <cfstoredproc procedure='fiscal.prc_calcula_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
				
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#' null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#' variable="retorno.PESO">
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#' null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#' variable="retorno.M3">
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#' null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#' variable="retorno.VOLUME">
		    	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGO_POR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
				
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMPRESA'  value='#v_empresa#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='COLETA_UF'  value='#arguments.COLETA_UF#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='ENTREGA_UF' value='#arguments.ENTREGA_UF#'>
				
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#' variable='retorno.FRETE_UNITARIO' null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' variable='retorno.ST_ICMS_ID' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR' variable='retorno.FRETE_VALOR'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_CONHECIMENTO' variable='retorno.TOTAL_CONHECIMENTO'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS' variable='retorno.BASE_CALCULO_ICMS'>
				
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS' variable='retorno.ALIQUOTA_ICMS'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS' variable='retorno.VALOR_ICMS'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_SUBSTIT' variable='retorno.VALOR_ICMS_SUBSTIT'>
			</cfstoredproc>
			<cfif not Len(Trim(retorno.FRETE_UNITARIO))>
				<cfset retorno.FRETE_UNITARIO = 0>
			</cfif>		
		<cfreturn retorno/>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Monta observao para o CTRC
	-- Guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_observacao" displayname="Monta observao para o CTRC" access="remote" returntype="query" output="false">
		<cfargument name="num_romaneio" required="no"/>
		<cfargument name="observacao" required="no"/>
		<cfargument name="placa_controle" required="no"/>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			<!---select #arguments.num_romaneio# as num_romaneio, 
				   decode('#arguments.observacao#','','','#arguments.observacao#' || chr(10)) || 'Seguradora HDI Seguros S/A-ap.0101054045760' || chr(10) || 'Tracionado por: ' || replace(substr(OPER.pkg_veiculo.FNC_GET_COMPOSICAO('#Replace(arguments.placa_controle,'-','')#'),2,7),'|','/') 	as observacao
			from dual--->
			select #arguments.num_romaneio# as num_romaneio, 
				   decode('#arguments.observacao#','','','#arguments.observacao#' || chr(10)) || oper.fnc_monta_observacao_ctrc(#arguments.num_romaneio#) as observacao
			from dual
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Dados para a ordem de coleta
	-- Guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_dados_coleta" displayname="Busca dados para preencher a ordem de coleta" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id"  required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
  			select /*+ ORDERED  */
            	   ri.item_id, 
                   ri.num_romaneio, 
                   ri.num_lote, 
                   ri.cod_remetente, 
                   rem.razao_social as remetente, 
                   rem.municipio as rem_municipio, 
                   rem.inscricao_estadual as rem_inscr_estadual, 
                   rem.codigo as cnpj_cpf_remetente, 
                   uf_rem.sigla_uf as rem_sigla_uf , 
                   rem.endereco as rem_endereco,
			 	   rem.cep as rem_CEP, 
                   rem.bairro as rem_bairro,
                   (select kss.fnc_concat_all(to_concat_expr(vgs.cod_grupo,','))
                    from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.fnc_get_composicao(r.placa_controle),'|')) pl
                   inner join oper.v$veiculo_grupo vg
                           on vg.placa = pl.column_value
                          and vg.DATA_TERMINO is null
                   inner join oper.v$veiculo_grupo_setup vgs
                           on vgs.GRUPO_ID = vg.grupo_id) as cod_grupo,
                   (select sum(vm.CAPACIDADE_M3)
                      from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.fnc_get_composicao(r.placa_controle),'|')) pl
                     inner join oper.v$veiculo_dados v
                             on pl.column_value = v.placa
                     inner join oper.v$veiculo_modelo vm
                             on v.modelo_id = vm.modelo_id
                     where column_value is not null) as capacidade_m3,
                   ri.cod_destinatario, 
                   dest.razao_social as destinatario, 
                   ri.date_insert,
             	   dest.municipio as dest_municipio, 
                   dest.codigo as cnpj_cpf_destinatario, 
                   dest.inscricao_estadual as dest_inscr_estadual, 
             	   uf_dest.sigla_uf as dest_sigla_uf, 
                   dest.endereco as dest_endereco, 
             	   ri.dest_cod_uf, 
                   ri.dest_cod_municipio, 
             	   oper.pkg_operacional.fnc_converte_peso(ri.peso, 'Kg', l.cod_unidade) as peso, 
                   n.descricao as mercadoria, 
                   e.descricao as especie, 
                   pf.nome, 
                   pf.cnh_num_registro,
                   pf.cart_ident_num, 
                   pf.cpf, 
                   pf.cpf_dv, 
                   r.cod_unidade
   		      from oper.v$romaneio r
			 inner join oper.v$romaneio_item ri      
			         on r.num_romaneio = ri.num_romaneio
			 inner join oper.v$romaneio_hist_veiculo rv      
				     on r.num_romaneio = rv.num_romaneio
			        and rv.data_termino is null
			 inner join oper.v$remetente_destinatario rem
			   	     on ri.cod_remetente = rem.cod_pessoa
			  left join oper.v$remetente_destinatario dest
				     on ri.cod_destinatario = dest.cod_pessoa
			 inner join cep.cep_loc col 
				     on ri.rem_cod_municipio = col.cod_municipio
				    and ri.rem_cod_uf = col.cod_uf
				    and ri.rem_cod_distrito = col.cod_distrito
				    and ri.rem_cod_dv = col.cod_dv
			  left join cep.cep_loc ent 
				     on ri.dest_cod_municipio = ent.cod_municipio          
				    and ri.dest_cod_uf = ent.cod_uf
				    and ri.dest_cod_distrito = ent.cod_distrito
				    and ri.dest_cod_dv = ent.cod_dv
			 inner join oper.v$lote l
			  	     on ri.num_lote = l.num_lote 
			 inner join cep.cep_ufs uf_rem
				     on uf_rem.cod_uf = ri.rem_cod_uf
			  left join cep.cep_ufs uf_dest
				     on uf_dest.cod_uf = ri.dest_cod_uf
			  left join oper.v$lote_descarga ld
				     on l.num_lote = ld.num_lote
			 inner join oper.v$natureza n
				     on r.num_natureza = n.num_natureza
			 inner join oper.v$especie e
				     on r.num_especie = e.num_especie
			 inner join oper.pessoa_fisica pf
				     on rv.cod_pessoa = pf.cod_pessoa
			 where ri.num_romaneio = #arguments.num_romaneio#
			   and ri.item_id = #arguments.item_id#	
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Busca Forma de Pagamento
	-- Guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_forma_pagto" displayname="Busca Forma de Pagamento" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select forma_id as tipo_pagto_id, forma_descricao  as tipo_pagto_descricao
			  from finan.faturamento_forma
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca os pagadores com conhecimento em aberto para determinada agencia
	-- Guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_pagador_frete" displayname="Busca os pagadores com conhecimento em aberto para determinada agencia" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
	    <cfargument name="cod_departamento" required="no">
	    <cfargument name="cod_setor" required="no">
		<cfargument name="cod_centro_custo" required="no"/>
		<cfargument name="serie" required="yes"/>
		<cfargument name="data_inicial" required="no"/>
		<cfargument name="data_final" required="no"/>
		<cfargument name="complemento" required="no"/>
		<cfargument name="ORGANOGRAMA" required="no" default=""/>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.ORGANOGRAMA,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.ORGANOGRAMA,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.ORGANOGRAMA,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.ORGANOGRAMA,4,'_')>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select 
				distinct decode(c.pagador, 0, c.cod_remetente, c.cod_destinatario) as pagador,
				 oper.pkg_global.FNC_MASCARA_CNPJ_CPF(decode(c.pagador, 0, c.cod_remetente, c.cod_destinatario)) as cnpj_cpf,
				  decode(c.pagador, 0, c.rem_razao_social, c.dest_razao_social) as razao_social, 
				  decode(c.pagador, 0, c.rem_municipio, c.dest_municipio) as municipio, 
				  decode(c.pagador, 0, c.rem_uf, c.dest_uf) as uf, 
				  decode(c.pagador, 0, c.rem_cnpj_cpf, c.dest_cnpj_cpf) as codigo
			  from fiscal.v$conhecimento c
			  left join oper.v$romaneio_item ri
                on ri.num_romaneio = c.num_romaneio
               and ri.item_id = c.item_id
              left join oper.v$lote_setor_docto lsd
                on lsd.num_lote = ri.num_lote                
             where nvl(lsd.cod_pessoa_filial, c.cod_pessoa_filial) = #arguments.cod_pessoa_filial#
               and nvl(lsd.cod_departamento, c.cod_departamento) = #arguments.cod_departamento#
               and nvl(lsd.cod_setor, c.cod_setor)  = #arguments.cod_setor#
               and nvl(lsd.cod_centro_custo, c.cod_centro_custo) = #arguments.cod_centro_custo#
			   and c.situacao_id <> 1
			   <cfif arguments.serie neq 0>
				   and c.serie = '#arguments.serie#'
			   </cfif>
			   <cfif not isDefined("arguments.complemento")>
				   and not exists (select 'x' 
									 from oper.v$conhecimento_receber cr
									where c.conhecimento_id = cr.conhecimento_id)
			   </cfif>
			   <cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
			  	  and data_emissao between to_date('#arguments.data_inicial#','dd/mm/yyyy')-1/1440 and to_date('#arguments.data_final#','dd/mm/yyyy')+1-1/1440
			   </cfif> 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca conhecimentos para faturar
	-- Guto 10/06/2009 11:38:00 - ALTERADO
	--->
	<cffunction name="get_conhecimentos_faturar" displayname="Busca os pagadores com conhecimento em aberto para determinada agencia" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" displayname="Filial" required="no">
		<cfargument name="cod_departamento" displayname="Setor usurio" required="no">
		<cfargument name="cod_setor" displayname="Setor usurio" required="no">


		<cfargument name="cod_centro_custo" displayname="Setor usurio" required="no">
		<cfargument name="serie" displayname="Agncia do usurio" required="yes">
		<cfargument name="pagador" displayname="Cd. Pessoa do pagador" required="yes">
		<cfargument name="complemento" displayname="Cd. Pessoa do pagador" required="no">
		<cfargument name="data_vencimento" displayname="Data Vencimento" required="no">
		<cfargument name="data_inicial" displayname="Data Inicial" required="no">
		<cfargument name="data_final" displayname="Data Final" required="no">
		<cfargument name="ORGANOGRAMA" required="no" default=""/>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.ORGANOGRAMA,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.ORGANOGRAMA,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.ORGANOGRAMA,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.ORGANOGRAMA,4,'_')>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_conhecimentos" username="#session.usuario#" password="#session.senha#">
            select /*+ ORDERED USE_HASH(C IT) USE_HASH(IT LF)*/
                   c.num_romaneio,
                   c.item_id,
                   (select sum(roo.frete_total)
                      from oper.v$romaneio roo
                     where roo.num_romaneio = c.num_romaneio) as total_romaneio,
                   (select oper.pkg_operacional.fnc_converte_peso(sum(roo2.peso_total), 'Kg', c.cod_unidade)
                      from oper.v$romaneio roo2
                     where roo2.num_romaneio = c.num_romaneio) as total_peso,
                   (select sum(roo2.m3_total)
                      from oper.v$romaneio roo2
                     where roo2.num_romaneio = c.num_romaneio) as total_m3,
                   c.conhecimento_id,
                   c.num_conhecimento,
                   c.data_emissao,
                   case
                      when nvl(l.regra_fiscal_id, 1) = 1 then c.valor_icms
                      when l.regra_fiscal_id in (2, 3, 7, 8) then c.valor_icms_substit + c.valor_icms
                      when l.regra_fiscal_id in (4,13) and c.pagador = 0 then (c.valor_icms_substit + c.valor_icms) * 0.80 -- declarado na fatura 80% do icms para minas, 20%  presumido
                      when l.regra_fiscal_id in (4,13) and c.pagador = 1 then 0 -- se pagador destinatario ICMS 0,00 (tarefa 3609)
                   end valor_icms,
                   case
                      when nvl(l.regra_fiscal_id, 1) = 1 then 0
                      when l.regra_fiscal_id in (2, 3, 7, 8) then 0
                      when l.regra_fiscal_id in (4,13) and c.pagador = 0 then (c.valor_icms_substit + c.valor_icms) * 0.20 -- declarado na fatura 80% do icms para minas, 20%  presumido
                      when l.regra_fiscal_id in (4,13) and c.pagador = 1 then 0 -- se pagador destinatario ICMS 0,00 (tarefa 3609)
                   end val_icms_presumido,
                   case
                      when nvl(l.regra_fiscal_id, 1) = 1 then c.total_conhecimento
                      when l.regra_fiscal_id in (2) then c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 3 and c.pagador = 0 then c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 3 and c.pagador = 1 then c.total_conhecimento
                      when l.regra_fiscal_id = 7 and c.pagador = 0 then c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 7 and c.pagador = 1 and c.coleta_cod_uf = c.entrega_cod_uf then c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 7 and c.pagador = 1 and c.coleta_cod_uf <> c.entrega_cod_uf then c.total_conhecimento
                      when l.regra_fiscal_id in (4,13) and c.pagador = 0 then c.total_conhecimento - ((c.valor_icms_substit + c.valor_icms) * 0.80) -- Gerdal desconta 80% do ICMS
                      when l.regra_fiscal_id in (4,13) and c.pagador = 1 then c.total_conhecimento -- Gerdal se pagador destinatario no desconta ICMS
                      when l.regra_fiscal_id = 6 then c.total_conhecimento + c.pedagio -- Coamo
                      when l.regra_fiscal_id = 8 and c.pagador = 0 then c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 8 and c.pagador = 1 then c.total_conhecimento
                      else c.total_conhecimento
                   end total_conhecimento,
                   nvl(lf.forma_id, 0) as forma_id,
                   case
                      when c.num_romaneio is null then 1
                      when to_number(kss.pkg_global.fnc_obtem_parametro_str(25, 'FISCAL.EXE', 8, 2)) = 0 then 1
                      else oper.pkg_fluxo_docto.fnc_verifica_doctos_fatura_2(c.num_romaneio, c.item_id, null)
                   end situacao_fluxo,
                   nvl(lf.agrupamento_id, 2) as agrupamento_id,
                   nvl(lf.cod_conta_favorecido, 3810) as cod_conta_favorecido,
                   oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso,
                   oper.pkg_operacional.fnc_converte_peso(c.peso_cobrado, 'Kg', c.cod_unidade) as peso_cobrado,
                   c.m3,
                   nvl(l.frete_em, 'PESO') as frete_em,
                   oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,
                   c.frete_unitario,
                   r.carregamento,
                   r.destino,
                   (select distinct count(rit2.cod_destinatario)
                      from oper.v$romaneio_item rit2
                     where rit2.num_romaneio = c.num_romaneio) as total_entregas
              from oper.v$conhecimento c
              left join oper.v$romaneio r
                     on c.num_romaneio = r.num_romaneio
              left join oper.v$romaneio_item it
                     on c.num_romaneio = it.num_romaneio
                    and c.item_id = it.item_id
              left join oper.v$lote_faturamento lf
                     on it.num_lote = lf.num_lote
              left join oper.v$lote l
                     on it.num_lote = l.num_lote
              left join oper.v$lote_setor_docto lsd
                   on lsd.num_lote = l.num_lote
			 where nvl(lsd.cod_pessoa_filial, c.cod_pessoa_filial) = #arguments.cod_pessoa_filial#
               and nvl(lsd.cod_departamento, c.cod_departamento) = #arguments.cod_departamento#
               and nvl(lsd.cod_setor, c.cod_setor)  = #arguments.cod_setor#
               and nvl(lsd.cod_centro_custo, c.cod_centro_custo) = #arguments.cod_centro_custo#
			   and c.situacao_id <> 1
			<cfif arguments.serie neq 0>
			   and c.serie = '#arguments.serie#'
			</cfif>
			   and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.pagador#
			<cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
			   and data_emissao between to_date('#arguments.data_inicial#','dd/mm/yyyy hh24:mi') and to_date('#arguments.data_final#','dd/mm/yyyy hh24:mi')+1-1/1440
			</cfif>
			<cfif isDefined("arguments.data_vencimento") and Len(Trim(arguments.data_vencimento))>
			   and data_emissao <= '#arguments.data_vencimento#'
			</cfif>
			<cfif isDefined("arguments.complemento")>
               and not exists (select * 
                                 from oper.v$conhecimento_complemento cc
                                where c.conhecimento_id = cc.conhecimento_complemento_id)
			<cfelse>
			   and not exists (select * 
							     from oper.v$conhecimento_receber cr
						        where c.conhecimento_id = cr.conhecimento_id)
			 
			</cfif>
			 order by c.data_emissao, c.num_conhecimento
		</cfquery>
		<cfreturn qr_conhecimentos>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Busca itens soma dos itens da fatura
	-- Guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_soma_itens_fatura" displayname="Busca itens soma dos itens da fatura" access="remote" returntype="query" output="true">
		<cfargument name="contas_receber_id" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select contas_receber_id, peso, base_icms, val_icms, val_icms_presumido,
				   impostos, total 
		      from finan.v$soma_itens_duplicata	
			 where contas_receber_id = #arguments.contas_receber_id#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca itens da fatura
	-- Guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_itens_fatura" displayname="Busca itens da fatura" access="remote" returntype="query" output="true">
		<cfargument name="contas_receber_id" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select contas_receber_id, num_docto, data_emissao, nvl(nf_carga,'&nbsp;') as nf_carga, peso, base_icms, val_icms, impostos, total 
			  from finan.v$itens_duplicata
  			 where contas_receber_id = #arguments.contas_receber_id#
			 order by data_emissao, num_docto
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca duplicatas da fatura
	-- Guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_duplicata" displayname="Busca duplicatas da fatura" access="remote" returntype="query" output="true">
		<cfargument name="contas_receber_id" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */d.contas_receber_id, d.num_docto, d.dup_ordem, d.data_emissao, d.end_filial as ENDERECO_FILIAL
                 , d.data_vencto, d.valor_docto, d.linha_1, d.linha_2, d.cnpj_filial
                 , d.razao_social, d.inscricao_estadual, d.cep_filial, d.municipio
                 , d.uf, d.cliente, d.municipio_cliente, d.uf_cliente
                 , d.cep_cliente, d.ie_cliente, d.cnpjcpf_cliente, d.end_cliente
                 , d.bairro_cliente
                 , nvl((select /*+ index (cr IDX_CNCR_04) */
                               (select decode(lf.cep,'',d.praca_pagto,trim(lf.logradouro) ||', '||trim(lf.complemento) || ' CEP:'|| lf.cep || ' ' || im.nome_municipio || '/'||im.sigla_uf
                                       )
                                  from oper.v$romaneio_item ri
                                 inner join oper.v$lote_faturamento lf
                                    on lf.num_lote = ri.num_lote
                                 inner join cep.ibge_municipio im
                                    on lf.cod_uf = im.cod_uf
                                   and lf.cod_municipio = im.cod_municipio
                                   and lf.cod_distrito = im.cod_distrito
                                   and lf.cod_dv = im.cod_dv
                                 where ri.item_id = c.item_id
                               )
                          from fiscal.v$conhecimento_receber cr
                         inner join oper.v$conhecimento c
                            on cr.conhecimento_id = c.conhecimento_id
                         where cr.contas_receber_id = d.contas_receber_id
                           and rownum = 1
                       ),d.municipio_cliente) as praca_pagto
              from finan.v$duplicata d
             where d.contas_receber_id = #arguments.contas_receber_id#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca o identificador da fatura no contas a receber
	-- Guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_contas_receber_id" displayname="Busca o identificador da fatura no contas a receber" access="remote" returntype="query" output="true">
		<cfargument name="num_docto"    required="yes" />
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="ORGANOGRAMA" required="no" default=""/>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.ORGANOGRAMA,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.ORGANOGRAMA,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.ORGANOGRAMA,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.ORGANOGRAMA,4,'_')>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select f.contas_receber_id, f.num_docto, 
             	   f.data_emissao, f.data_vencto, f.valor_docto
			  from finan.finan_contas_receber f
			 where 1=1
			 <cfif Len(Trim(arguments.num_docto))>
			   and f.num_docto = #arguments.num_docto#			 
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_filial))>
			   and f.cod_pessoa_empresa = #arguments.cod_pessoa_filial# 
			 </cfif>
			   and f.docto_id = 'DP'
			   order by  f.num_docto
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca os locais de coleta e entrega
	-- Guto 04/05/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_coleta_entrega" displayname="Busca os locais de coleta e entrega" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" />
		<cfargument name="cod_setor" 		 required="no" />
		<cfargument name="serie" 			 required="yes" />
		<cfargument name="clientes" 		 required="yes" />
		<cfargument name="coleta_entrega"    displayname="FLAG - 0 Coleta 1 Entrega" required="no" default="0">
		<cfargument name="data_inicial" 	 required="no" default="" />
		<cfargument name="data_final" 		 required="no" default=""/>
		<cfargument name="organograma" required="no" default="">		
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>		
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select l.sigla_uf, initcap(l.nome_local) as localidade, 
			  <cfif arguments.coleta_entrega eq 0>
				   c.coleta_cod_uf as cod_uf, c.coleta_cod_municipio as cod_municipio, c.coleta_cod_distrito as cod_distrito, c.coleta_cod_dv as cod_dv
			  <cfelse>
	               c.entrega_cod_uf as cod_uf, c.entrega_cod_municipio as cod_municipio, c.entrega_cod_distrito as cod_distrito, c.entrega_cod_dv as cod_dv
			  </cfif>
			  from oper.v$conhecimento c
			  <cfif arguments.coleta_entrega eq 0>
				 inner join cep.cep_loc l
					on l.cod_uf = c.coleta_cod_uf
					and l.cod_municipio = c.coleta_cod_municipio
					and l.cod_distrito = c.coleta_cod_distrito
					and l.cod_dv = c.coleta_cod_dv
			  <cfelse>
				 inner join cep.cep_loc l
					on l.cod_uf = c.entrega_cod_uf
					and l.cod_municipio = c.entrega_cod_municipio
					and l.cod_distrito = c.entrega_cod_distrito
					and l.cod_dv = c.entrega_cod_dv
			  </cfif>
				 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
				   and c.cod_setor = #arguments.cod_setor#
				   and c.situacao_id <> 1
			   <cfif arguments.serie neq 0>
				   and c.serie = '#arguments.serie#'
			   </cfif>
			  <cfif Len(Trim(arguments.DATA_INICIAL)) and Len(Trim(arguments.DATA_FINAL))>
			  	and data_emissao between to_date('#arguments.data_inicial#','dd/mm/yyyy') and to_date('#arguments.data_final#','dd/mm/yyyy')+1-1/1440
			  </cfif>
			  <cfif not arguments.coleta_entrega eq 0 and Len(Trim(arguments.clientes))>
		           and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.clientes#
			  </cfif>
				and not exists (select * 
								  from oper.v$conhecimento_complemento cc
								 where c.conhecimento_id = cc.conhecimento_complemento_id)
			    group by l.sigla_uf, l.nome_local, 
			  <cfif arguments.coleta_entrega eq 0>
				   c.coleta_cod_uf, c.coleta_cod_municipio, c.coleta_cod_distrito, c.coleta_cod_dv
			  <cfelse>
		           c.entrega_cod_uf, c.entrega_cod_municipio, c.entrega_cod_distrito, c.entrega_cod_dv
			  </cfif>
			  order by l.sigla_uf, l.nome_local
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca pessoa, enqueanto no for unificado a parte de MUNICIPIO deve ser usada essa consulta
	-- Guto 04/05/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_pessoa" displayname="Busca pessoa, enqueanto no for unificado a parte de MUNICIPIO deve ser usada essa consulta" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" displayname="Cdigo pessoa" required="false">
		<cfargument name="cnpj_cpf" displayname="CNPJ ou CPF ou cdigo da pessoa" required="false">
		<cfargument name="nome" displayname="Nome ou parte do nome da pessoa" required="false">
		<cfargument name="razao_social" displayname="Razao Social do nome da pessoa" required="false">
		<cfargument name="tipo" displayname="Tipo para  consulta, 1 - CNPJ e Estrangeiro, 2 - CPF e Estrangeiro, 3 - Sem Estrangeiro, 4 - Somente CPF" required="false">
		<cfquery datasource="#session.dsn#" name="qr_pessoa" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa, codigo, bairro, endereco, to_char(cep) as cep, 
				   complemento, logradouro, 
				   nome_fantasia, razao_social, municipio, uf, 
				   cod_atividade_fiscal, inscricao_estadual,
				   municipio || ' - ' || uf as municipio_uf, 
				   oper.pkg_global.fnc_endereco_ibge(cep).cod_uf as cod_uf,
				   oper.pkg_global.fnc_endereco_ibge(cep).cod_municipio as cod_municipio,
				   oper.pkg_global.fnc_endereco_ibge(cep).cod_distrito as cod_distrito,
				   oper.pkg_global.fnc_endereco_ibge(cep).cod_dv as cod_dv,
	               case rd.situacao_id
				     when 0 then 'Inativo'
				     when 1 then 'Ativo'
				     when 2 then 'Em avaliao'
                   end situacao          
 		      from oper.v$remetente_destinatario rd
		      where 0=0 
			 <cfif isDefined("arguments.cod_pessoa") and len(trim(arguments.cod_pessoa))>
				 and rd.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif isDefined("arguments.cnpj_cpf") and len(arguments.cnpj_cpf) eq 14>
				 and rd.codigo like '#arguments.cnpj_cpf#%'
			 <cfelseif isDefined("arguments.cnpj_cpf") and len(arguments.cnpj_cpf) eq 11>
				 and rd.codigo like '#arguments.cnpj_cpf#%'
			 <cfelseif isDefined("arguments.cnpj_cpf")>
				 and rd.cod_pessoa = #arguments.cnpj_cpf#
			 </cfif>
			 <cfif isDefined("arguments.nome")>
				 and upper(rd.nome_fantasia) like upper('%#arguments.nome#%')
			 </cfif>
			 <cfif isDefined("arguments.razao_social")>
				 and upper(rd.razao_social) like upper('%#arguments.razao_social#%')
			 </cfif>			
			<cfif isDefined("arguments.tipo") and arguments.tipo eq 1>
				 and rd.cpf is null
			</cfif>
			<cfif isDefined("arguments.tipo") and arguments.tipo eq 2>
				 and rd.cnpj_basico is null
			</cfif>
			<cfif isDefined("arguments.tipo") and arguments.tipo eq 3>
				 and rd.cpf is not null
				 or rd.cnpj_basico is not null
			</cfif>
			<cfif isDefined("arguments.tipo") and arguments.tipo eq 4>
				 and rd.cpf is not null
				 and rd.cnpj_basico is null
				 and rd.cod_estrangeiro is null
			</cfif>
			 order by nome_fantasia 
 		</cfquery>
		<cfreturn qr_pessoa>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Busca Dados do calculo do ICMS
	-- Guto 06/05/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_icms" displayname="Busca Dados do calculo do ICMS" access="remote" returntype="struct" output="true">
		<cfargument name="produto_id" displayname="Produto que est sendo transportando" required="yes">
		<cfargument name="cod_atividade" displayname="Cdigo da atividade fiscal do pagador" required="yes">
		<cfargument name="uf_origem" displayname="UF coleta" required="yes">
		<cfargument name="uf_destino" displayname="UF entrega" required="yes">
		<cfargument name="tomador_servico" displayname="UF Tomador do Servio" required="no">
		<cfstoredproc datasource="#session.dsn#" procedure="fiscal.pkg_fiscal.prc_calcula_icms" username="#session.usuario#" password="#session.senha#">
			<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_produto_id" value="#arguments.produto_id#">
			<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_atividade" value="#arguments.cod_atividade#">
			<cfprocparam type="in" cfsqltype="cf_sql_char" dbvarname="p_uf_origem" value="#arguments.uf_origem#">
			<cfprocparam type="in" cfsqltype="cf_sql_char" dbvarname="p_uf_destino" value="#arguments.uf_destino#">
			<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_tomador_servico" value="#arguments.tomador_servico#">
			<cfprocparam type="out" cfsqltype="cf_sql_float" dbvarname="p_reducao_base_icms" variable="retorno.reducao_base_icms">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_st_icms_id" variable="retorno.st_icms_id">
			<cfprocparam type="out" cfsqltype="cf_sql_float" dbvarname="p_aliquota_icms" variable="retorno.aliquota_icms">
		</cfstoredproc>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca os lotes que esto aberto para as agncias
	-- Guto 11/05/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_lote_aberto_agencia" displayname="Busca os lotes que esto aberto para as agncias" access="remote" returntype="query" output="true">
        <cfargument name="num_lote" required="no" default=""/>
        <cfargument name="repom" required="no" default="0"/>
		<cfquery datasource="#session.dsn#" name="qr_lotes" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ l.num_lote, l.data_inicio_retirada, l.data_prazo_retirada, l.data_contrato, l.num_natureza, 
				   n.descricao as natureza, l.num_especie, e.descricao as especie, 
				   oper.pkg_operacional.fnc_converte_peso(l.peso,'Kg',l.cod_unidade) as peso, l.volume, 
				   l.m3, l.frete_em, l.cod_unidade, l.qtde_viagem, 
				   l.frete_proprio, l.frete_valor_unitario, l.frete_valor, l.frete_por_conta, 
				   l.num_produto, l.situacao_tributaria, l.aliquota_icms, l.reducao_base_calculo, 
				   l.icms_incluso, l.destaca_base_calc_icms, 
				   decode(l.fundamentacao_legal,'','',l.fundamentacao_legal || chr(10)) || 'Ace Seguros S/A. n AP-27.54.0001133.14' as fundamentacao_legal, 
				   rem.razao_social as remetente, rem.municipio as rem_municipio, rem.uf as rem_uf, rem.codigo as cnpj_cpf_remetente, dest.codigo as cnpj_cpf_destinatario,
				   dest.razao_social as destinatario, dest.municipio as dest_municipio, dest.uf as dest_uf, 
				   decode(l.cod_pessoa_destinatario,null,0,1) as lote_com_destinatario,
				   l.cod_pessoa_remetente, l.cod_pessoa_destinatario, l.coleta_logradouro, 
				   l.coleta_complemento, l.coleta_bairro, l.coleta_cep, l.coleta_cod_uf, 
				   l.coleta_cod_municipio, l.coleta_cod_dv, l.coleta_cod_distrito, 
       oper.pkg_global.fnc_municipio(l.coleta_cod_uf, l.coleta_cod_municipio, l.coleta_cod_distrito, l.coleta_cod_dv) as coleta_municipio,
       l.entrega_logradouro, 
				   l.entrega_complemento, l.entrega_cep, l.entrega_bairro, l.entrega_cod_uf, 
				   l.entrega_cod_municipio, l.entrega_cod_distrito, l.entrega_cod_dv, 
       oper.pkg_global.fnc_municipio(l.entrega_cod_uf, l.entrega_cod_municipio, l.entrega_cod_distrito, l.entrega_cod_dv) as entrega_municipio,
       l.controle_peso, 
				   l.controle_peso_veiculo, l.situacao_id, l.observacao, l.negociador_id, 
				   l.controle_viagem, l.observacao_emitente, l.pedagio_incluso,
				   decode(l.frete_por_conta,0,rem.cod_atividade_fiscal,dest.cod_atividade_fiscal) as cod_atividade_fiscal,
				   oper.pkg_operacional.fnc_posicao_lote(l.num_lote).gauge as peso_carregado,
				   decode(ld.imprime_conhecimento,1,ld.observacao,'') as rodape
			  from oper.v$lote l 
			 inner join oper.v$natureza n
			   on l.num_natureza = n.num_natureza
			 inner join oper.v$especie e 
			   on l.num_especie = e.num_especie
			 inner join oper.v$remetente_destinatario rem
				on rem.cod_pessoa = l.cod_pessoa_remetente
			 left outer join oper.v$remetente_destinatario dest
				on dest.cod_pessoa = l.cod_pessoa_destinatario
			 left outer join oper.v$lote_descarga ld
			   on l.num_lote = ld.num_lote				
 			 where l.situacao_id = 1
     <cfif Len(Trim(arguments.NUM_LOTE))>
     	 and l.num_lote = #arguments.NUM_LOTE#
     </cfif>
     <cfif arguments.REPOM eq 1>
     	 and l.operacao_id_repom is not null
     </cfif>			  and (exists (select 'x' 
						   from oper.v$kss_usuario_lotacao u
								where l.cod_pessoa_filial = u.cod_pessoa
								  and l.cod_departamento = u.cod_departamento
								  and l.cod_setor	     = u.cod_setor
								  and u.cod_aplicacao = 'EMISSAO_DOCUMENTO'
								  )
				  or
				   exists (select 'x' 
							  from oper.v$kss_usuario_lotacao u2
							 inner join oper.v$lote_setor_compto lac
								on lac.cod_pessoa_filial = u2.cod_pessoa
								   and lac.cod_departamento = u2.cod_departamento
								   and lac.cod_setor        = u2.cod_setor
								 where lac.num_lote = l.num_lote))          
		</cfquery>
		<cfreturn qr_lotes>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca os Conhecimentos por data 
	-- Wagner 08/06/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_busca_conhecimento_cadastrados" access="remote" returntype="query" output="true">
		<cfargument name="data_emissao" required="true">
		<cfquery datasource="#session.dsn#" name="qr_conhecimentos" username="#session.usuario#" password="#session.senha#">
			select c.num_conhecimento, c.serie, c.data_emissao, c.user_insert, 
				   oper.pkg_global.fnc_municipio(c.coleta_cod_uf,c.coleta_cod_municipio,c.coleta_cod_distrito,c.coleta_cod_dv) as origem,
				   oper.pkg_global.fnc_municipio(c.entrega_cod_uf,c.entrega_cod_municipio,c.entrega_cod_distrito,c.entrega_cod_dv) as destino
			  from oper.v$conhecimento c
			 where trunc(c.date_insert) > trunc(c.data_emissao)
			   and trunc(c.date_insert) = '#arguments.data_emissao#'				
 		</cfquery>
		<cfreturn qr_conhecimentos>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Formata CNPJ
	-- Wagner 08/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="f_formata_cnpj" displayname="Insere pontuao no CNPJ" access="remote" returntype="string" output="true">
		<cfargument name="cnpj" required="yes">
		<cfif Len(cnpj) eq 15>
			<cfset v_cnpj = Insert('.',cnpj,2)>
			<cfset v_cnpj = Insert('.',v_cnpj,6)>
			<cfset v_cnpj = Insert('/',v_cnpj,10)>
			<cfset v_cnpj = Insert('-',v_cnpj,15)>
		<cfelseif Len(cnpj) eq 11>
			<cfset v_cnpj = Insert('-',cnpj,10)>
		<cfelse>
			<cfset v_cnpj = cnpj>
		</cfif>
		<cfreturn v_cnpj>	
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca Cartas Frete
	-- Wagner 08/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_carta_frete_conhecimento" displayname="Busca Todas as cartas fretes viculadas a um ctrc" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="true">
		<cfquery datasource="#session.dsn#" name="qr_carta_frete" username="#session.usuario#" password="#session.senha#">
			select cf.cod_documento, oper.pkg_operacional.fnc_converte_peso(cf.peso,'Kg',cod_unidade) as peso, 
				   cf.valor_unitario, cf.valor_frete_liquido, cf.user_insert, cf.data_emissao
			  from oper.v$carta_frete cf
			  where cf.conhecimento_id = #arguments.conhecimento_id#
 		</cfquery>		
		<cfreturn qr_carta_frete>
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Busca Conhecimentos
	-- Wagner 08/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_relacao_conhecimentos" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="true">
		<cfquery datasource="#session.dsn#" name="qr_relacao" username="#session.usuario#" password="#session.senha#">
			select num_carta_frete, observacao, num_romaneio, data_emissao, ctrc, valor_unitario, frete, saldo, 
				   lancto_id, conhecimento_id, crt_receber_id, peso, remetente, 
				   carregou, destino, placa, pedagio, quebra 
			  from oper.v$relacao_cf_acerto
			 where conhecimento_id = #arguments.conhecimento_id# 
 		</cfquery>
		<cfreturn qr_relacao>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca pagadores contratados
	-- Wagner 14/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_pagador_subcontratado" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_pagador" username="#session.usuario#" password="#session.senha#">
            select t.cod_pessoa
                 , oper.pkg_global.fnc_mascara_cnpj_cpf(t.cod_pessoa) as cnpj_cpf_pagador
                 , trim(oper.pkg_global.fnc_busca_nome_pessoa(t.cod_pessoa)) as pagador
              from (select distinct case
                                       when l.frete_por_conta = 0 then
                                          l.cod_pessoa_remetente
                                       when l.frete_por_conta = 1 and
                                            c.cod_consignatario is not null then
                                          c.cod_consignatario
                                       else
                                          l.cod_pessoa_destinatario
                                     end as cod_pessoa
                      from oper.v$carta_frete cf
                     inner join oper.v$romaneio_item ri
                             on ri.num_romaneio = cf.num_romaneio
                            and ri.item_id = cf.item_id
                     inner join oper.v$lote l
                             on ri.num_lote = l.num_lote
                      left join oper.v$lote_consignatario c
                             on c.num_lote = l.num_lote) t
             where t.cod_pessoa is not null                 
             order by 3
		</cfquery>
		<cfreturn qr_pagador>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca documentos do pagador
	-- Wagner 14/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_documentos_pagador" access="remote" returntype="query" output="true">
		<cfargument name="cod_remetente" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_documentos_pagador" username="#session.usuario#" password="#session.senha#">
			select cf.cod_documento, dc.documento,
				   cf.data_emissao, cf.volume,
				   oper.pkg_operacional.fnc_converte_peso(cf.peso, 'Kg', cf.cod_unidade) peso,
				   cf.valor_unitario, cf.valor_frete_liquido,
				   cf.valor_frete_bruto, cf.lancto_id,
				   d.cod_pessoa destinatario, d.nome_fantasia nome_destinatario,
				   oper.pkg_global.FNC_MASCARA_CNPJ_CPF(d.codigo) cnpj_cpf_destinatario,
				   ri.cod_remetente, d.municipio
			  from oper.v$carta_frete cf
			inner join oper.v$remetente_destinatario d
					on d.cod_pessoa = cf.cod_destinatario
			inner join oper.v$documento_frete dc
					on dc.documento_id = cf.tipo_docto
			inner join oper.v$romaneio_item ri
					on ri.num_romaneio = cf.num_romaneio
				   and ri.item_id = cf.item_id
				   and ri.cod_remetente = #arguments.cod_remetente#
			 where cf.conhecimento_id is null
			   and cf.crt_receber_id is null
			 order by cf.data_emissao
 		</cfquery>
		<cfreturn qr_documentos_pagador>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca descontos e pedagio
	-- Wagner 14/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_total_pedagio_descontos" access="remote" returntype="query" output="true">
		<cfargument name="lst_documentos" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_total_pedagio_descontos" username="#session.usuario#" password="#session.senha#">
			select (select nvl(sum(cfi_ped.valor), 0.00)
					  from oper.v$carta_frete_item cfi_ped
						   where kss.instr_pkg.verifica_lista(cfi_ped.lancto_id, '#arguments.lst_documentos#') = 1
							 and cfi_ped.item_id = 1) total_pedagio,
					   (select nvl(sum(cfi_desc.valor),0.00)
							from oper.v$carta_frete_item cfi_desc
						   where kss.instr_pkg.verifica_lista(cfi_desc.lancto_id, '#arguments.lst_documentos#') = 1
							 and cfi_desc.item_id = 6) total_descontos,
				   sum(oper.pkg_operacional.fnc_converte_peso(cf.peso,'Kg',cf.cod_unidade)) as peso,
				   sum(cf.valor_frete_liquido) +
           (select nvl(sum(cfi_ped.valor), 0.00)
					  from oper.v$carta_frete_item cfi_ped
						   where kss.instr_pkg.verifica_lista(cfi_ped.lancto_id, '#arguments.lst_documentos#') = 1
							 and cfi_ped.compoe_frete = 1
               and cfi_ped.desconto = 0) -
           (select nvl(sum(cfi_ped.valor), 0.00)
					  from oper.v$carta_frete_item cfi_ped
						   where kss.instr_pkg.verifica_lista(cfi_ped.lancto_id, '#arguments.lst_documentos#') = 1
							 and cfi_ped.compoe_frete = 1
               and cfi_ped.desconto = 1) as total_final,
			   sum(cf.valor_frete_liquido) as valor_liquido
			 from oper.v$carta_frete cf
			where kss.instr_pkg.verifica_lista(cf.lancto_id, '#arguments.lst_documentos#') = 1
			group by 1,2
   		</cfquery>
		<cfreturn qr_total_pedagio_descontos>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca tipo Documento
	-- Wagner 19/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_tipo_docto" displayname="Busca Documentos" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_tipo_docto" username="#session.usuario#" password="#session.senha#">
			select d.documento_id, d.documento 
			  from oper.v$documento_frete d
			 order by documento
 		</cfquery>		
		<cfreturn qr_tipo_docto>
	</cffunction>
	
    <!--- 
    -- PROPSITO 
    -- Retorna as situaes tributrias
    -- ANDERSON 26/08/2010 - CRIADO
    --->		
    <cffunction name="get_situacao_tributaria" access="remote" returntype="query" output="true">
    	<cfargument name="st_icms_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.st_icms_id
                 , t.st_icms_descricao
              from fiscal.v$st_icms t
             where 1 = 1
			<cfif Len(Trim(arguments.st_icms_id))>
               and t.st_icms_id in (#PreserveSingleQuotes(arguments.st_icms_id)#)
			</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca Todas as Gerenciadoras
	-- Wagner 19/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_gerenciadoras" displayname="Busca Situao Tributria" access="remote" returntype="query" output="true">
		<cfargument name="cnpj" required="no" default="">
		<cfargument name="razao_social" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_situacao_tributaria" username="#session.usuario#" password="#session.senha#">
			select 	pj.cod_pessoa,
					pj.cnpj_basico||pj.cnpj_ordem||pj.cnpj_dv cnpj,
					pj.razao_social
				from grisco.v$gerenciadora g
				inner join oper.v$pessoa_juridica pj on pj.cod_pessoa = g.cod_gerenciadora
				where 1=1
			<cfif Len(Trim(arguments.cnpj))>
				and pj.cnpj_basico||pj.cnpj_ordem||pj.cnpj_dv = #arguments.cnpj#
 			</cfif>
			<cfif Len(Trim(arguments.razao_social))>
				and pj.razao_social like '%#arguments.razao_social#%'
 			</cfif>
		</cfquery>		
		<cfreturn qr_situacao_tributaria>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca Conhecimentos para o Complemento de Romaneio
	-- Wagner 19/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_conhecimentos_viagens" displayname="Busca Conhecimentos para o Complemento de Romaneio" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" displayname="Pessoa filial" required="no">
		<cfargument name="cod_setor" displayname="Setor do usurio" required="no">
		<cfargument name="serie" displayname="Srie" required="no">
		<cfargument name="coleta" displayname="Coleta" required="no">
		<cfargument name="entrega" displayname="Entrega" required="no">
		<cfargument name="data_inicial" displayname="Data Inicial" required="no">
		<cfargument name="data_final" displayname="Data Final" required="no">
		<cfquery datasource="#session.dsn#" name="qr_conhecimentos" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED USE_HASH(C RD) USE_HASH(C R)*/ c.num_romaneio, c.item_id, 
				     nvl(r.frete_liquido,0) as total_romaneio, 
             nvl(round(r.frete_liquido / decode(oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'Kg',c.cod_unidade),0,1,oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'Kg',c.cod_unidade)),2),0) as frete_unitario,
			       (select distinct count(rit2.cod_destinatario) from oper.v$romaneio_item rit2 where rit2.num_romaneio = c.num_romaneio) as total_entregas,
				     r.carregamento, r.destino, 
		  		   nvl(oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'Kg',c.cod_unidade),0) as total_peso, 	
				     c.conhecimento_id, c.num_conhecimento, c.data_emissao, c.total_conhecimento, c.valor_icms, oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg',c.cod_unidade) as peso,
			 	     oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal, c.frete_unitario,
			       decode(it.cod_remetente,'','',c.rem_razao_social) as remetente,
			       decode(it.cod_destinatario,'','',c.dest_razao_social) as destinatario, c.user_insert,
			       (select nvl(count(*),0) 
			          from oper.v$conhecimento_complemento cc 
				       inner join oper.v$conhecimento c2
				               on cc.conhecimento_id = c2.conhecimento_id 
			         where c2.num_romaneio = c.num_romaneio) as possui_complemento
					from oper.v$conhecimento c 
				 inner join oper.v$remetente_destinatario rd 
						 on rd.cod_pessoa = decode(c.pagador, 0, c.cod_remetente,	 c.cod_destinatario)
				 inner join oper.v$romaneio r
						 on c.num_romaneio = r.num_romaneio
				 inner join oper.v$romaneio_item it on c.num_romaneio = it.num_romaneio
																					 and c.item_id = it.item_id
		   where c.situacao_id <> 1
		     and (r.situacao_id <> 2 or r.situacao_id is null)
			   <cfif arguments.serie neq 0>
				   and c.serie = '#arguments.serie#'
			   </cfif>
			   and c.coleta_cod_uf = '#GetToken(arguments.coleta,1,',')#'
			   and c.coleta_cod_municipio = '#GetToken(arguments.coleta,2,',')#'
			   and c.coleta_cod_distrito = '#GetToken(arguments.coleta,3,',')#'
			   and c.coleta_cod_dv = '#GetToken(arguments.coleta,4,',')#'
			   <cfif arguments.entrega neq 0>
				   and c.entrega_cod_uf = '#GetToken(arguments.entrega,1,',')#'
				   <cfif ListLen(arguments.entrega) gt 1>
					   and c.entrega_cod_municipio = '#GetToken(arguments.entrega,2,',')#'
					   and c.entrega_cod_distrito = '#GetToken(arguments.entrega,3,',')#'
					   and c.entrega_cod_dv = '#GetToken(arguments.entrega,4,',')#'
				   </cfif>
			   </cfif>
			  <cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
			  	and data_emissao between to_date('#arguments.data_inicial#','dd/mm/yyyy') and to_date('#arguments.data_final#','dd/mm/yyyy')+1-1/1440
			  </cfif>
			       and not exists (select * 
								 from oper.v$conhecimento_complemento cc
								where c.conhecimento_id = cc.conhecimento_complemento_id)
				and (num_romaneio is null or
					 num_romaneio in (select num_romaneio
			  from oper.v$romaneio_item it 
			   inner join oper.v$lote_setor_docto la 
				  on it.num_lote = la.num_lote 
				inner join oper.v$kss_usuario_lotacao ul 
				   on ul.cod_pessoa = la.cod_pessoa_filial 
				  and ul.cod_setor = la.cod_setor
					and ul.usuario = user))			
			  order by c.num_romaneio, c.item_id, c.num_conhecimento  
		</cfquery>
		<cfreturn qr_conhecimentos>
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Busca Conhecimentos para o Complemento de Romaneio
	-- ANDERSON 10/06/2009 - ALTERADO
	--->	
	<cffunction name="get_complemento_romaneio" displayname="Busca Conhecimentos para o Complemento de Romaneio" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no">
		<cfargument name="cod_setor" required="no">
		<cfargument name="serie" required="no" default="">
		<cfargument name="coleta" required="no" default="">
		<cfargument name="entrega" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfargument name="conhecimento_id" required="no" default="">
        <cfargument name="pagador" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_conhecimentos" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS_100 ORDERED PUSH_SUBQ INDEX(IT IDX_RIT_04) */
                   c.num_romaneio,
                   c.item_id,
                   nvl(c.frete_valor, 0) as total_romaneio,
                   case when (select nvl(l.frete_em, 'PESO')
                                from oper.v$lote l
                               where l.num_lote = it.num_lote) = 'PESO' then
                      nvl(round(r.frete_liquido / decode(oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'Kg', c.cod_unidade), 0, 1, oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'Kg', c.cod_unidade)), 2), 0)
                   else
                      nvl(round(r.frete_liquido / decode(r.m3_total, 0, 1, r.m3_total), 2), 0)
                   end as frete_unitario,
                   (select distinct count(rit2.cod_destinatario)
                      from oper.v$romaneio_item rit2
                     where rit2.num_romaneio = c.num_romaneio) as total_entregas,
                   r.carregamento,
                   r.destino,
                   nvl(oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'Kg', c.cod_unidade), 0) as total_peso,
                   nvl(oper.pkg_operacional.fnc_converte_peso(r.PESO_TOTAL_COBRADO, 'Kg', c.cod_unidade), 0) as total_peso_cobrado,
                   nvl(r.m3_total, 0) as total_m3,
                   (select nvl(l.frete_em, 'PESO')
                      from oper.v$lote l
                     where l.num_lote = it.num_lote) as frete_em,
                   c.conhecimento_id,
                   c.num_conhecimento,
                   c.data_emissao,
                   c.total_conhecimento,
                   c.valor_icms,
                   oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso,
                   oper.pkg_operacional.fnc_converte_peso(c.peso_cobrado, 'Kg', c.cod_unidade) as peso_cobrado,
                   oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,
                   c.frete_unitario as frete_unitario_ctrc,
                   decode(it.cod_remetente, '', '', c.rem_razao_social) as remetente,
                   decode(it.cod_destinatario, '', '', c.dest_razao_social) as destinatario,
                   c.user_insert,
                   (select nvl(count(*), 0)
                      from oper.v$conhecimento_complemento cc
                     inner join oper.v$conhecimento c2
                             on cc.conhecimento_id = c2.conhecimento_id
                     where c2.num_romaneio = c.num_romaneio) as possui_complemento
              from oper.v$conhecimento c
             inner join oper.v$romaneio r
                     on c.num_romaneio = r.num_romaneio
             inner join oper.v$romaneio_item it
                     on c.num_romaneio = it.num_romaneio
                    and c.item_id = it.item_id
			<cfif (Len(Trim(arguments.coleta)) or Len(Trim(arguments.entrega))) and (Not Len(Trim(arguments.num_romaneio)))>
			 inner join oper.v$remetente_destinatario_ rd 
				     on rd.cod_pessoa = decode(c.pagador, 0, c.cod_remetente, c.cod_destinatario)
			</cfif>
			 where c.situacao_id <> 1
		       and (r.situacao_id <> 2 or r.situacao_id is null)
			<cfif Len(Trim(arguments.serie)) and (Not Len(Trim(arguments.num_romaneio)))>
			   and c.serie = '#arguments.serie#'
			</cfif>
			<cfif (Len(Trim(arguments.coleta)) or Len(Trim(arguments.entrega))) and (Not Len(Trim(arguments.num_romaneio)))>
				<cfif Len(Trim(arguments.coleta))>
                    and c.coleta_cod_uf = '#GetToken(arguments.coleta,1,',')#'
                    and c.coleta_cod_municipio = '#GetToken(arguments.coleta,2,',')#'
                    and c.coleta_cod_distrito = '#GetToken(arguments.coleta,3,',')#'
                    and c.coleta_cod_dv = '#GetToken(arguments.coleta,4,',')#'
                </cfif>                
				<cfif Len(Trim(arguments.entrega))>
                	<cfif arguments.entrega neq 0>
                		and c.entrega_cod_uf = '#GetToken(arguments.entrega,1,',')#'
                		<cfif ListLen(arguments.entrega) gt 1>
                            and c.entrega_cod_municipio = '#GetToken(arguments.entrega,2,',')#'
                            and c.entrega_cod_distrito = '#GetToken(arguments.entrega,3,',')#'
                            and c.entrega_cod_dv = '#GetToken(arguments.entrega,4,',')#'
                		</cfif>
					</cfif>
				</cfif>
			</cfif>
			<cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final") and (Not Len(Trim(arguments.num_romaneio)))>
			   and data_emissao between to_date('#arguments.data_inicial#','dd/mm/yyyy') and to_date('#arguments.data_final#','dd/mm/yyyy')+1-1/1440
			</cfif>
			   and not exists (select 'x'
							     from oper.v$conhecimento_complemento cc
								where c.conhecimento_id = cc.conhecimento_complemento_id)
			   and (c.num_romaneio is null or c.num_romaneio in (select it.num_romaneio
			 	   											   from oper.v$romaneio_item it
			 												  inner join oper.v$lote_setor_docto la 
				  	 												  on it.num_lote = la.num_lote 
			 												  inner join oper.v$kss_usuario_lotacao ul 
                                                                 on ul.cod_pessoa = la.cod_pessoa_filial 
                                                                and ul.cod_setor = la.cod_setor
                                                                and ul.usuario = user))
			<cfif Len(Trim(arguments.num_romaneio))>
               and c.num_romaneio = #arguments.num_romaneio#
            </cfif>
            <cfif Len(Trim(arguments.conhecimento_id))>
               and c.conhecimento_id = #arguments.conhecimento_id#
            </cfif>
            <cfif Len(Trim(arguments.pagador))>
               and case c.pagador
                      when 0 then c.cod_remetente
                      else c.cod_destinatario
                   end = #arguments.pagador#
            </cfif>
             order by c.num_romaneio, c.item_id, c.num_conhecimento
		</cfquery>
		<cfreturn qr_conhecimentos>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca Nmero do Romaneio pelo numero do Conhecimento ou NF
	-- Wagner 19/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_romaneio" displayname="Busca duplicatas da fatura" access="remote" returntype="query" output="true">
		<cfargument name="num_conhecimento" displayname="CNPJ basico da filial" required="no">
		<cfargument name="serie" displayname="SERIE" required="no">
		<cfargument name="num_nota" displayname="CNPJ basico da filial" required="no">
		<cfargument name="cod_pessoa_filial" displayname="Pessoa filial" required="no">
		<cfargument name="cod_setor" displayname="Setor do usurio" required="no">
		<cfargument name="organograma" required="no" default="">		
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_duplicata" username="#session.usuario#" password="#session.senha#">
				select r.num_romaneio
			  	  from oper.v$romaneio r
			inner join oper.v$conhecimento c
					on r.num_romaneio = c.num_romaneio 
				 where cod_pessoa_filial = #arguments.cod_pessoa_filial#
			  	   and cod_setor = #arguments.cod_setor#
			  <cfif isDefined("arguments.num_conhecimento") and arguments.num_conhecimento neq 0>
				   and num_conhecimento = #arguments.num_conhecimento#
				   and serie = '#arguments.serie#'
			  </cfif>
 			  <cfif isDefined("arguments.num_nota") and arguments.num_nota neq 0>
			 	 and conhecimento_id = (select conhecimento_id 
				 					      from oper.v$conhecimento_nota_fiscal nf 
										 where c.conhecimento_id = nf.conhecimento_id 
										   and nf.numero = #arguments.num_nota#)
			  </cfif>
			  
		</cfquery>
		<cfreturn qr_duplicata>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca Destinatario do conhecimento de complemento
	-- Wagner 20/09/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_dest_ctrc_complemento" displayname="Busca Destinatario do conhecimento de complemento." access="remote" returntype="struct" output="true">
		<cfargument name="relacao_id" required="yes">
		<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_conhecimento.prc_busca_dest_complemento" username="#session.usuario#" password="#session.senha#">
			<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_relacao_id" value="#arguments.relacao_id#">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_destinatario" variable="retorno.destinatario">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_razao_social" variable="retorno.razao_social">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_uf" variable="retorno.entrega_cod_uf">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_municipio" variable="retorno.entrega_cod_municipio">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_distrito" variable="retorno.entrega_cod_distrito">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_entrega_cod_dv" variable="retorno.entrega_cod_dv">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_municipio" variable="retorno.municipio">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_uf" variable="retorno.uf">
		</cfstoredproc>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os conhecimentos romaneio
	-- CRISTOFER  18/12/2006
	--->		
	<cffunction name="get_ctrc_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.conhecimento_id,
				   c.num_conhecimento,
				   c.num_romaneio,
				   c.item_id, 
                   to_char(c.data_emissao,'dd/mm/yyyy') as data_emissao,
                   cc.conhecimento_id conhecimento_id_complementado,
                   case 
                      when exists(select 'x' 
                                    from oper.v$contrato_transp ct 
                                   where ct.conhecimento_id = c.conhecimento_id
                                     and data_cancelamento is null) then 1 
                      else 0 
                   end ct_vinculado
			  from fiscal.v$conhecimento c
              left join fiscal.v$conhecimento_complemento cc
                     on cc.conhecimento_complemento_id = c.conhecimento_id
			 where 1=1
			   and num_romaneio in (#arguments.num_romaneio#)			
			 order by c.num_conhecimento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca romaneio
	-- CRISTOFER  18/12/2006
	--->		
	<cffunction name="get_romaneio_ct" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select coalesce(sum(ri.peso), sum(sc.peso), 0) as peso
                 , coalesce(sum(ri.volume), sum(sc.qtde_volume), 0) as volume
                 , coalesce(sum(ri.m3), sum(sc.m3), 0) as m3
                 , 'Kg' as cod_unidade
                 , r.num_romaneio
                 , rhv.placa_controle
                 , o.internacional
                 , ri.operacao_id
                 , logistica.pkg_operacao.fnc_descricao_completa(ri.operacao_id) as operacao
                 , ri.viagem_carga_id
                 , (select sign(count(1))
                      from oper.v$contrato_transp ct
                     where ct.num_romaneio = r.num_romaneio
                       and ct.data_cancelamento is null
                  ) as vinculado_ct
                 , nvl(case
                          when oper.pkg_veiculo.fnc_veiculo_modalidade(rhv.placa_controle, rhv.data_inicio) = 'TERCEIRO' then min(o.margem_terceiro)
                          else min(o.margem_agregado)
                       end, kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 15, 8)
                      ) as margem_receita
                 , o.tipo_pagamento_id
                 , max(c.cartao_numero) keep(dense_rank last order by scd.date_insert) as cartao_numero
                 , (select max(c2.cartao_numero) keep(dense_rank last order by ct.date_insert)
                      from repom.v$contrato ct
                     inner join repom.v$cartao c2
                             on c2.cartao_id = ct.cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.data_cancelamento is null
                   ) as cartao_numero_historico
                 , nvl(min(scd.valor_pedagio_rota) keep(dense_rank first order by sc.data_carregamento_inicio), 0) as valor_pedagio_rota
                 , (select sign(count(1))
                      from repom.v$contrato ct
                     where ct.num_romaneio = r.num_romaneio
                       and ct.cod_motorista = rhv.cod_pessoa
                       and ct.data_cancelamento is null
                  ) as contrato_emitido
                 , ro.rota_id
                 , ro.descricao_rota
                 , o.tipo_servico_id
                 , o.tipo_docto_frete
              from oper.v$romaneio_item ri
             inner join oper.v$romaneio r
                     on r.num_romaneio = ri.num_romaneio
             inner join logistica.v$operacao o
                     on o.operacao_id = ri.operacao_id
             inner join oper.v$romaneio_hist_veiculo rhv
                     on rhv.num_romaneio = r.num_romaneio
                    and rhv.data_inicio = (select max(rhv2.data_inicio)
                                             from oper.v$romaneio_hist_veiculo rhv2
                                            where rhv2.num_romaneio = rhv.num_romaneio
                                          )
              left join logistica.v$viagem_carga vc
                     on vc.viagem_carga_id = ri.viagem_carga_id
              left join logistica.v$solicitacao_carga sc
                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
              left join repom.v$solicitacao_carga_dados scd
                     on scd.solicitacao_carga_id = sc.solicitacao_carga_id
              left join repom.v$cartao c
                     on c.cartao_id = scd.cartao_id
              left join oper.v$rota ro
                     on ro.rota_id = repom.pkg_logistica.fnc_rota_solicitacao_carga(vc.solicitacao_carga_id, vc.viagem_id)
             where r.num_romaneio = #arguments.num_romaneio#
             group by r.num_romaneio
                    , ri.operacao_id
                    , ri.viagem_carga_id
                    , o.internacional
                    , o.tipo_pagamento_id
                    , rhv.placa_controle
                    , rhv.cod_pessoa
                    , oper.pkg_veiculo.fnc_veiculo_modalidade(rhv.placa_controle, rhv.data_inicio)
                    , ro.rota_id
                    , ro.descricao_rota
                    , o.tipo_servico_id
                    , o.tipo_docto_frete
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca CFOP
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_cfop" access="remote" returntype="query" output="true">
		<cfargument name="cfop" required="no" default="">
		<cfargument name="cfop_id" required="no" default="">
		<cfargument name="natureza" required="no" default="">
        <cfargument name="natureza_id" required="no" default="">
  		<cfargument name="produto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select c.cfop
                      ,c.id
                      ,c.natureza_id
                      ,cfn.natureza_operacao as descricao
                      ,n.descricao as natureza_operacao
                      ,n.avista_aprazo
                  from fiscal.v$cfop_id c
            inner join fiscal.v$natureza_operacao n
                    on n.natureza_id = c.natureza_id
            inner join fiscal.v$cfop_nivel_3 cfn
                    on cfn.cfop_nivel_3 = c.cfop
             <cfif Len(Trim(arguments.produto_id))>
			inner join fiscal.v$cfop_produto cp
                    on cp.produto_id = '#arguments.produto_id#'
                   and cp.cfop = c.cfop
			 </cfif>
                 where 1=1
			 <cfif Len(Trim(arguments.NATUREZA))>
			   and upper(n.descricao) like upper('%#arguments.NATUREZA#%')
			 </cfif>
			 <cfif Len(Trim(arguments.CFOP))>
			   and upper(c.cfop) like upper('%#arguments.CFOP#%')
			 </cfif>
			 <cfif Len(Trim(arguments.CFOP_ID))>
				and c.id = #arguments.CFOP_ID#
			 </cfif>
             <cfif Len(Trim(arguments.natureza_id))>
			   and c.natureza_id = #arguments.natureza_id#
			</cfif>
			 order by c.cfop, c.id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca PRODUTOS
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_produto" access="remote" returntype="query" output="true">
		<cfargument name="produto_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select p.produto_id, p.descricao, p.cod_ncm, p.st_origem_id, p.cod_unidade, 
                     p.ipi_aliquota, p.ipi_reducao_base, pc.cod_contabil,  p.categoria_id
                from fiscal.v$produto p  
				inner join fiscal.v$produto_categoria pc
				       on pc.categoria_id = p.categoria_id
			 where 1=1
             <cfif Len(Trim(arguments.descricao))>
			   and upper(p.descricao) = upper('%#arguments.descricao#%')
             </cfif>
             <cfif Len(Trim(arguments.produto_id))>
			   and p.produto_id = #arguments.produto_id#
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca Situao Origem ID
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_st_origem" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select s.st_origem_id, s.st_origem_descricao
			  from fiscal.v$st_origem s
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca Unidade de converso
	-- ANDERSONC 20/04/2009
	--->		
	<cffunction name="get_unidade_conversao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select umc.cod_unidade, umc.cod_unidade_eq, umc.equivalencia
			  from fiscal.v$unidade_medida_conversao umc
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca Nota fiscal de terceiro emitida
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_nf_terceiro" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nf.num_nota_id, nf.num_nota_fiscal, p.identificador, p.razao_social, p.cliente,
			       nf.calc_valor_total_nota
			  from fiscal.v$nf_terceiro nf
			 inner join kss.v$pessoa p 
						on p.cod_pessoa = nf.cod_emitente
			 where 1=1
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
			   and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca CTRCs emitidos em determina data da unidade de Ouro Branco/MG
	-- PAULO  06/01/2007
	--->		
	<cffunction name="get_ctrc_gerdau" access="remote" returntype="query" output="true">
		<cfargument name="data" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select f.cnpj_cpf cnpj_transp, c.num_conhecimento num_ctrc, c.serie serie_ctrc,
				   cnf.numero num_nf, cnf.serie serie_nf, 
				   c.data_emissao data_emissao_ctrc,c.total_conhecimento total_ctrc, 
				   to_char(c.total_conhecimento, '0000000000000V00') as total_ctrc_formatado,
				   c.valor_icms, to_char(c.valor_icms, '0000000000000V00') as valor_icms_formatado, 
				   c.base_calculo_icms, to_char(c.base_calculo_icms, '0000000000000V00') as base_calc_icms_formatado, 
				   cnf.data_emissao data_emissao_nf, placa,
				   c.rem_cnpj_cpf cnpj_rem,
				   case 
					  when (select count(*) 
						      from kss.v$pessoa_estrangeira r
							 where r.cod_pessoa = c.cod_destinatario) > 0 then null
					  else c.dest_cnpj_cpf
				   end cnpj_dest,
				   case 
					  when situacao_id = 1 then 'X'
					  else ' '
				   end cancelado,
				   case 
					  when (select count(*) 
					  		  from fiscal.v$conhecimento_complemento cc
							 where cc.conhecimento_id = c.conhecimento_id ) > 0 then 'X'
					  else ' '
				   end complemento, ' ' as iss,
				   c.aliquota_icms, to_char(c.aliquota_icms,  '000v00') aliquota_icms_formatado
			  from fiscal.v$conhecimento c
			inner join kss.v$pessoa f
					on f.cod_pessoa = c.cod_pessoa_filial	
			left join fiscal.v$conhecimento_nota_fiscal cnf
					on c.conhecimento_id = cnf.conhecimento_id
               where 1 = 1 
			     and c.cod_remetente = 4656
			 <cfif Len(Trim(arguments.data))>
                and trunc(c.data_emissao) = '#arguments.data#' 
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Verifica fluxo na emissao
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 20/01/2007  - criado
	--->	
	<cffunction name="get_fluxo_ok" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_motorista" required="no" default=""/>
		<cfargument name="data_emissao" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_veiculo_esta_filial_ag(#arguments.COD_MOTORISTA#, null, '#arguments.DATA_EMISSAO#', #session.cod_pessoa#, #session.cod_departamento#, #session.cod_setor#, #session.cod_centro_custo#) as na_filial,
				   oper.pkg_fluxo_documentos.fnc_entrega_doctos_pendente(#arguments.COD_MOTORISTA#) fluxo_ok
			  from dual
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Consulta uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS - 05/06/2007  - criado
	--->	
	<cffunction name="get_nf_terceiro_completa" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		    select nf.num_nota_id,
				   nf.cod_pessoa_filial,
				   nf.cod_departamento,
				   nf.cod_setor,
				   nf.cod_centro_custo,
				   nf.num_nota_fiscal,
				   nf.cod_modelo,
				   nf.serie,
				   nf.subserie,
				   nf.cod_contabil,
				   nf.natureza_id,
				   nf.natureza_descricao,
				   nf.data_emissao,
				   nf.data_entrada,
				   nf.cod_emitente,
				   nf.emit_razao_social,
				   nf.emit_endereco,
				   nf.emit_bairro,
				   nf.emit_municipio,
				   nf.emit_uf,
				   nf.emit_cep,
				   nf.emit_telefone,
				   nf.emit_cnpj_cpf,
				   nf.emit_inscricao_estadual,
				   nf.cod_cliente,
				   nf.nf_imposto_id,
				   nf.calc_base_icms,
				   nf.calc_valor_icms,
				   nf.calc_base_icms_subst,
				   nf.calc_valor_icms_subst,
				   nf.calc_valor_total_produtos,
				   nf.calc_valor_frete,
				   nf.calc_valor_seguro,
				   nf.calc_outras_despesas,
				   nf.calc_valor_total_ipi,
				   nf.calc_valor_total_nota,
				   nf.observacao_fiscal,
				   nf.observacao_usuario,
				   nf.conferida,
				   nf.cod_servico_des,
				   nf.natureza_siss_id,
				   nf.incluir_siss,
				   nf.avista_aprazo,
				   nf.contabilizada,
				   o.num_controle as num_documento,
				   o.titulo as num_controle,
  			       nfi.cod_gestao, 
				   nfi.num_nota_it_id, 
				   nfi.cfop, 
				   nfi.cfop_id, 
				   nfi.produto_id, 
				   nfi.descricao, 
				   nfi.cod_ncm, 
				   nfi.st_origem_id, 
				   nfi.st_icms_id, 
				   nfi.cod_unidade, 
				   nfi.qtde_peso, 
				   nfi.qtde_volume, 
				   nfi.qtde_metro, 
				   nfi.valor_em, 
				   nfi.valor_unitario, 
				   nfi.valor_total, 
				   nfi.icms_reducao_base, 
				   nfi.icms_base_calculo, 
				   nfi.icms_aliquota, 
				   nfi.icms_valor, 
				   nfi.ipi_reducao_base, 
				   nfi.ipi_base_calculo, 
				   nfi.ipi_aliquota, 
				   nfi.ipi_valor, 
				   nfi.desconto_percentual, 
				   nfi.desconto_valor, 
				   nfi.incluir_estoque, 
				   nfi.incluir_livro_fiscal, 
				   nfi.serv_total_tributavel, 
				   nfi.serv_total_nao_tributavel, 
				   nfi.serv_total_produto, 
				   nfi.serv_iss_aliquota, 
				   nfi.serv_iss_deducao, 
				   nfi.serv_iss_valor, 
				   nfi.valor_em_unidade, 
				   nfi.descricao_complemento, 
				   nfi.icms_base_calc_subst, 
				   nfi.icms_valor_subst, 
				   nfi.contabilizacao_id, 
				   nfi.icms_isentas, 
				   nfi.icms_outras, 
				   nfi.ipi_isentas, 
				   nfi.ipi_outras,
				   st.st_origem_descricao,
				   sti.st_icms_descricao,
				   n.descricao as natureza_operacao,
				   un.unidade as unidade_medida
		      from fiscal.v$nf_terceiro nf  
			  inner join kss.v$pessoa p 
				   	  on p.cod_pessoa = nf.cod_emitente 
			  inner join fiscal.v$nf_terceiro_it nft
			          on nft.num_nota_id = nf.num_nota_id
			  inner join fiscal.v$nf_item nfi
			          on nfi.num_nota_it_id = nft.num_nota_it_id
			  inner join fiscal.v$st_origem st
     				  on st.st_origem_id = nfi.st_origem_id
			  inner join fiscal.v$st_icms sti
     				  on sti.st_icms_id = nfi.st_icms_id  
			  inner join fiscal.v$cfop_id cf
					  on cf.cfop = nfi.cfop
                     and cf.id = nfi.cfop_id
			  inner join fiscal.v$natureza_operacao n
				      on n.natureza_id = cf.natureza_id
			  inner join kss.v$unidade_medida un
			          on un.cod_unidade =nfi.cod_unidade	
			  left join manutencao.nf_terceiro_ordem_compra oc
					  on oc.nf_terceiro_id = nf.num_nota_id
			  left join manutencao.v$ordem_compra o
				  	  on o.num_controle = oc.ordem_compra_id
		      where 1=1
		     <cfif len(trim(arguments.num_nota_id))>
		   		and nf.num_nota_id = #arguments.num_nota_id# 
		 	 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Consulta as ordens de compra referente a uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS - 12/06/2007  - criado
	--->	
	<cffunction name="get_nf_terceiro_ordem_compra" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.nf_terceiro_id, 
				   t.ordem_compra_id,
				   o.titulo, t.valor_utilizado
			  from manutencao.v$nf_terceiro_ordem_compra t 
		inner join manutencao.v$ordem_compra o
		   	    on o.num_controle = t.ordem_compra_id
		     where 1=1
			 <cfif len(trim(arguments.num_nota_id))>
		   		and t.nf_terceiro_id = #arguments.num_nota_id# 
		 	 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Consulta os itens referentes a uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS - 12/06/2007  - criado
	--->	
	<cffunction name="get_nf_terceiro_item" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select i.cod_gestao, 
				i.num_nota_it_id, 
				i.cfop, 
				i.cfop_id, 
				i.produto_id, 
				i.descricao, 
				i.cod_ncm, 
				i.st_origem_id, 
				i.st_icms_id, 
				i.cod_unidade, 
				i.qtde_peso, 
				i.qtde_volume, 
				i.qtde_metro, 
				i.valor_em, 
				i.valor_unitario, 
				i.valor_total, 
				i.icms_reducao_base, 
				i.icms_base_calculo, 
				i.icms_aliquota, 
				i.icms_valor, 
				i.ipi_reducao_base, 
				i.ipi_base_calculo, 
				i.ipi_aliquota, 
				i.ipi_valor, 
				i.desconto_percentual, 
				i.desconto_valor, 
				i.incluir_estoque, 
				i.incluir_livro_fiscal, 
				i.serv_total_tributavel, 
				i.serv_total_nao_tributavel, 
				i.serv_total_produto, 
				i.serv_iss_aliquota, 
				i.serv_iss_deducao, 
				i.serv_iss_valor, 
				i.valor_em_unidade, 
				i.descricao_complemento, 
				i.icms_base_calc_subst, 
				i.icms_valor_subst, 
				i.contabilizacao_id, 
				i.icms_isentas, 
				i.icms_outras, 
				i.ipi_isentas, 
				i.ipi_outras,
				un.unidade as unidade_medida
		   from fiscal.v$nf_item i 
	 inner join fiscal.v$nf_terceiro_it t
	 	     on i.num_nota_it_id = t.num_nota_it_id
	 inner join kss.v$unidade_medida un
	         on un.cod_unidade = i.cod_unidade
			 where 1=1
			 <cfif len(trim(arguments.num_nota_id))>
		   		and t.num_nota_id = #arguments.num_nota_id# 
		 	 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Consulta a movimentacao de almoxarifaco referente a uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS - 13/06/2007  - criado
	--->	
	<cffunction name="get_nf_terceiro_almoxarifado" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		    select m.lancamento_id, 
				   m.operacao_tipo_id, 
				   m.material_id, 
				   m.cod_pessoa_filial, 
				   m.data_lancamento, 
				   m.quantidade, 
				   m.observacao, 
				   m.user_insert, 
				   m.date_insert, 
				   m.user_update, 
				   m.date_update, 
				   m.site, 
				   m.num_nota_id,
				   mt.descricao as material_descricao
			 from almoxarifado.v$movimentacao m
		    inner join almoxarifado.v$material mt
               on mt.material_id = m.material_id
			 where 1=1
			 <cfif len(trim(arguments.num_nota_id))>
		   		and m.num_nota_id = #arguments.num_nota_id# 
		 	 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Consulta o ultimo numero de conhecimento 
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS - 10/07/2007  - criado
	--->	
	<cffunction name="get_num_conhecimento" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nvl(max(c.num_conhecimento),0) + 1 as num_conhecimento
              from fiscal.v$conhecimento c
             where c.cod_pessoa_filial 	= #session.cod_pessoa#
               and c.cod_setor			= #session.cod_setor#
               and c.cod_departamento	= #session.cod_departamento#
               and c.cod_centro_custo 	= #session.cod_centro_custo#
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os blocos alocados para uma determinada filial 
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS - 13/07/2007  - criado
	--->	
	<cffunction name="get_blocos_alocados" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default=""/>
       	<cfargument name="cod_setor" required="no" default=""/>
       	<cfargument name="data_transferencia" required="no" default=""/>
      	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select s.data_solicitacao, 
                   b.num_bloco, 
                   b.bloco_id,
                   s.solicitacao_id as solicitacao, 
                   s.numero_aidf as aidf,
                   s.serie,
                   dt.descricao as tipo_docto,
                   t.alocacao_id,
                   t.data_transferencia,
                   (select min(dr.numero_docto)
                      from fiscal.v$docto_registro dr
                     where dr.bloco_id = b.bloco_id) as numero_inicial, 
                   (select max(dr.numero_docto)
                      from fiscal.v$docto_registro dr
                     where dr.bloco_id = b.bloco_id) as numero_final
		     from fiscal.v$docto_alocacao t
       inner join kss.v$pessoa p 
               on t.cod_filial = p.cod_pessoa
       inner join fiscal.v$docto_bloco_restante b 
               on b.bloco_id = t.bloco_id
       inner join fiscal.v$docto_solicitacao s
              on s.solicitacao_id =  b.solicitacao_id
       inner join fiscal.v$docto_tipo dt 
              on dt.docto_id = s.docto_id

            where 1=1 
            <cfif len(trim(arguments.cod_pessoa))>
            	and t.cod_filial = #arguments.cod_pessoa# 
            </cfif>
            <cfif len(trim(arguments.cod_setor))>
                and t.cod_setor = #arguments.cod_setor# 
            </cfif>
            <cfif len(trim(arguments.data_transferencia)) and arguments.data_transferencia eq 0>
            	and t.data_transferencia is null and t.data_saida is null 
            </cfif>
             <cfif len(trim(arguments.data_transferencia)) and arguments.data_transferencia eq 1>
            	and t.data_transferencia is not null and t.data_entrada is null
            </cfif>
         order by b.num_bloco 
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os valores da cg_ref_codes
	-- CRISTOFER  11/06/2007
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
		<cfargument name="DOMINIO" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rv_domain dominio, 
				   rv_low_value id, 
				   rv_high_value, 
				   rv_abbreviation abreviacao, 
				   rv_meaning descricao
			  from fiscal.v$cg_ref_codes
			 where rv_domain = '#arguments.dominio#'
             order by rv_low_value
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca as notas fiscais do conhecimento
	-- CRISTOFER  19/10/2007 --
	--->		
	<cffunction name="get_conhecimento_nota_fiscal" access="remote" returntype="query" output="true">
    	<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cn.conhecimento_id,
                   cn.numero,
                   cn.data_emissao,
                   cn.modelo,
                   cn.serie,
                   cn.sub_serie,
                   cn.valor_total,
                   cn.user_insert,
                   cn.date_insert,
                   cn.user_update,
                   cn.date_update,
                   cn.site,
                   cn.nf_eletronica
              from fiscal.v$conhecimento_nota_fiscal cn
             where 1=1
             <cfif len(trim(arguments.conhecimento_id))>
               and cn.conhecimento_id in (#arguments.conhecimento_id#)
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados da rota
	-- CRISTOFER  14/04/2007
	--->		
	<cffunction name="get_rota" access="remote" returntype="query" output="true">
    	<cfargument name="abreviatura" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.rota_id, r.destino_municipio_id
            	 , r.abreviatura
                 , mo.municipio municipio_origem
                 , mo.uf_id uf_origem
                 , md.municipio municipio_destino
                 , md.uf_id uf_destino
                 , r.origem_municipio_id
                 , r.destino_municipio_id
                 , r.descricao_rota
                 , md.municipio||'/'||md.uf_id as localidade
                 , nvl(pv.valor_fixo,0) as valor_fixo
                 , nvl(pv.valor_eixo,0) as valor_eixo
                 , nvl(pv.valor_semparar_fixo,0) as valor_semparar_fixo
                 , nvl(pv.valor_semparar_eixo,0) as valor_semparar_eixo
                 , r.distancia_padrao
              from oper.v$rota r
             inner join cep.municipio md
                on md.municipio_id = r.destino_municipio_id
             inner join cep.municipio mo
                on mo.municipio_id = r.origem_municipio_id
              left join oper.v$rota_pedagio_valores pv
                on pv.rota_id = r.rota_id
             where 1=1
             <cfif len(trim(arguments.abreviatura))>
               and upper(r.abreviatura) like upper('#arguments.abreviatura#%')
             </cfif>
             order by r.abreviatura
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca os itinerarios do romaneio para a insercao na viagem de agregado
	-- CRISTOFER  15/04/2007
	--->		
	<cffunction name="get_romaneio_itinetario_agregado" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
    	<cfargument name="vazio_carregado" required="no" default="">
    	<cfargument name="placa" required="no" default="">
    	<cfargument name="data" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.rota_id,
                   r.abreviatura as cod_rota,
                   r.descricao_rota as descricao_rota,
                   r.origem_municipio_id,
                   r.destino_municipio_id,
                   r.distancia_padrao as km,
                   <cfif Len(Trim(arguments.PLACA))>
                      to_char(nvl(i.data_previsao,oper.pkg_tempo_viagem_ctrl.fnc_previsao_chegada_rota(r.rota_id,'#arguments.DATA#','#arguments.PLACA#')), 'dd/mm/yyyy hh24:mi') as previsao_chegada,
                   <cfelse>
                      to_char(i.data_previsao,'dd/mm/yyyy hh24:mi') previsao_chegada,
                   </cfif>
                   nvl(pv.valor_fixo,0) as pedagio_fixo,
                   nvl(pv.valor_eixo,0) as pedagio_eixo,
                   nvl(pv.valor_semparar_fixo,0) as pedagio_semparar_fixo,
                   nvl(pv.valor_semparar_eixo,0) as pedagio_semparar_eixo,
                   mo.municipio origem_municipio,
                   mo.uf_id origem_uf,
                   md.municipio destino_municipio,
                   md.uf_id destino_uf
              from oper.v$romaneio_itinerario i
             inner join oper.v$rota r
                     on r.rota_id = i.rota_id
             inner join cep.municipio md
                     on md.municipio_id = r.destino_municipio_id
             inner join cep.municipio mo
                     on mo.municipio_id = r.origem_municipio_id
              left join oper.v$rota_pedagio_valores pv
                     on pv.rota_id = r.rota_id
             where 1=1
             <cfif len(trim(arguments.num_romaneio))>
               and i.num_romaneio = #arguments.num_romaneio#
             </cfif>
             <cfif len(trim(arguments.vazio_carregado))>
               and i.vazio_carregado = #arguments.vazio_carregado#
             </cfif>
             order by i.vazio_carregado,i.ordem 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
        
    <!--- 
    -- PROPSITO
    -- Calcula os dados da viagem
    -- cristofer 15/04/2008 14:18:54 - CRIADO
    --->
    <cffunction name='get_dados_viagem' displayname='Calcula os dados da viagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_SERVICO' required='yes'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PEDAGIO_EIXO' required='yes'>
        <cfargument name='PEDAGIO_EIXO_SEMPARAR' required='yes'>
        <cfargument name='PEDAGIO_FIXO' required='yes'> 
        <cfargument name='PEDAGIO_FIXO_SEMPARAR' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_agreg.prc_dados_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_SERVICO'  value='#arguments.TIPO_SERVICO#'  null='#iif(len(trim(arguments.TIPO_SERVICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_VEICULO'  value='#arguments.COD_VEICULO#' variable='retorno.COD_VEICULO' >
                    <cfprocparam type='IN' cfsqltype='cf_sql_varchar' dbvarname="P_DATA" null="yes">
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE' variable='retorno.PLACA_CONTROLE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA' variable='retorno.PLACA_REFERENCIA' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_AGREGADO' variable='retorno.COD_PESSOA_AGREGADO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_AGREGADO' variable='retorno.AGREGADO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_EIXOS' variable='retorno.NUM_EIXOS' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_EIXO'  value='#arguments.PEDAGIO_EIXO#'  null='#iif(len(trim(arguments.PEDAGIO_EIXO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_EIXO_SEMPARAR'  value='#arguments.PEDAGIO_EIXO_SEMPARAR#'  null='#iif(len(trim(arguments.PEDAGIO_EIXO_SEMPARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_FIXO'  value='#arguments.PEDAGIO_FIXO#'  null='#iif(len(trim(arguments.PEDAGIO_FIXO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_FIXO_SEMPARAR'  value='#arguments.PEDAGIO_FIXO_SEMPARAR#'  null='#iif(len(trim(arguments.PEDAGIO_FIXO_SEMPARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_PEDAGIO' variable='retorno.TOTAL_PEDAGIO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_PEDAGIO_SEMPARAR' variable='retorno.TOTAL_PEDAGIO_SEMPARAR' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('ok')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
	-- PROPSITO 
	-- Busca as cargas relacionadas ao romaneio para a viagem de agregado
	-- CRISTOFER  15/04/2007
	--->		
	<cffunction name="get_romaneio_carga_agregado" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ca.carga_id,
            	   con.num_conhecimento,
                   rem.cliente remetente,
                   dest.cliente destinatario,
                   cep.fnc_municipio_uf(ca.coleta_municipio_id) origem,
                   cep.fnc_municipio_uf(ca.entrega_municipio_id) destino
              from oper.v$carga ca
             inner join oper.v$carga_ctrc cc
                     on cc.carga_id = ca.carga_id
             inner join fiscal.v$conhecimento con 
                     on con.conhecimento_id = cc.conhecimento_id
             inner join oper.v$romaneio r
                     on r.num_romaneio = con.num_romaneio
             inner join kss.v$pessoa rem
                     on rem.cod_pessoa = ca.rem_cod_pessoa
             inner join kss.v$pessoa dest
                     on dest.cod_pessoa = ca.dest_cod_pessoa
             where 1=1
             <cfif len(trim(arguments.num_romaneio))>
               and r.num_romaneio = #arguments.num_romaneio#     
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca os romaneios
	-- CRISTOFER  25/04/2007
	--->		
	<cffunction name="get_romaneio_placa" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio, 
                   to_char(r.data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio, 
                   to_char(r.data_termino,'dd/mm/yyyy hh24:mi:ss') as data_termino, 
                   r.remetente, 
                   r.destinatario,
                   r.carregamento,
                   r.destino,
                   r.placa_controle,
                   r.placa_referencia,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) cod_veiculo_controle,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia) cod_veiculo_referencia
              from oper.v$romaneio r
             where 1=1
             <cfif not len(trim(arguments.data_inicial))>
               and r.data_inicio >= sysdate - 180
             <cfelse>
               and trunc(r.data_inicio) >= '#arguments.data_inicial#'
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and trunc(r.data_inicio) <= '#arguments.data_final#'
             </cfif>
             <cfif len(trim(arguments.placa))>
               and exists (select 0
                             from oper.v$romaneio_hist_veiculo v
                            where v.num_romaneio = r.num_romaneio
                              and (v.placa_controle like upper('#arguments.placa#%') or v.placa_referencia like upper('#arguments.placa#%')))
             </cfif>

		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca listagem do relatorio de consulta de ctrc
	-- IGOR 16/09/2008
	--->		
	<cffunction name="get_consulta_ctrc" access="remote" returntype="query" output="true">
    	<cfargument name="CONHECIMENTO_ID" required="no" default="">
        <cfargument name="num_conhecimento" required="no" default="">
        <cfargument name="serie" required="no" default="">
        <cfargument name="data_emissao" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="cod_unidade_negocio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			-- relatrio 1
            select c.conhecimento_id
                 , c.num_conhecimento
                 , c.serie
                 , c.data_emissao -- Emisso / Movimento
            --   , c.cod_pessoa_filial
                 , un.cod_unidade_negocio
                 , un.unidade_negocio
                 , c.num_romaneio
            --   , c.rem_cnpj_cpf
                 , c.rem_razao_social
                 , c.dest_razao_social
            --   , c.dest_cnpj_cpf
                 , case co.modalidade
                      when '11' then 'Frota'
                      when '21' then 'Terceiro'
                      when '23' then 'Agregado'
                   end as desc_modalidade
                 , decode(c.pagador,0,'CIF - Pago',1,'FOB - A Pagar') as cif_fob
                 , (select n.descricao
                      from fiscal.v$natureza  n
                     where n.num_natureza = c.num_natureza) as descricao_natureza
                 , (select e.descricao
                      from oper.v$especie e
                     where e.num_especie = c.num_especie
                   ) as especie
            /*     , (select sum(nf.valor_total)
                      from fiscal.v$conhecimento_nota_fiscal nf
                     where nf.conhecimento_id = c.conhecimento_id
                   ) as valor_mercadoria
                 , c.volume as quantidade*/
                 , c.peso         --\___ um desses  o peso cobrado
                 , c.peso_real    --/
                 , c.frete_unitario
                 , c.frete_peso
                 , c.frete_valor
              from fiscal.v$conhecimento c
             inner join kss.v$unidade_negocio un
                on un.cod_pessoa = c.cod_pessoa_filial
              left join fiscal.v$conhecimento_outros_dados co
                on c.conhecimento_id = co.conhecimento_id
              where 1=1
             <cfif len(trim(arguments.DATA_INICIAL))>
               and c.data_emissao >= '#arguments.data_inicial#'
             </cfif>
             <cfif len(trim(arguments.DATA_FINAL))>
               and c.data_emissao <= '#arguments.data_final#'
             </cfif>
			 <cfif len(trim(arguments.serie))>
             	and c.serie = '#arguments.serie#'
			 </cfif>
             <cfif len(trim(arguments.cod_unidade_negocio))>
             	and un.cod_unidade_negocio = '#arguments.cod_unidade_negocio#'
             </cfif>
             <cfif len(trim(arguments.num_conhecimento))>
             	and c.num_conhecimento = '#arguments.num_conhecimento#'
             </cfif>
		</cfquery>
		<cfreturn qr_result>	
	</cffunction>    
    
	<!--- 
	-- PROPSITO 
	-- Busca listagem do relatorio de consulta de ctrc
	-- IGOR 16/09/2008
	--->		
	<cffunction name="get_relatorio_consulta_ctrc" access="remote" returntype="query" output="true">
    	<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            -- 1 relatrio
            select c.conhecimento_id
                 , c.num_conhecimento
                 , c.serie
                 , c.data_emissao -- Emisso / Movimento
                 , nvl((select 'Complementar'
                          from fiscal.v$conhecimento_complemento cc
                         where cc.conhecimento_id = c.conhecimento_id and rownum = 1),'Normal') as tipo_ctrc
            --     , c.cod_pessoa_filial
                 , un.cod_unidade_negocio  --Cdigo da Filial
                 , un.unidade_negocio      --Filial
                 , c.num_romaneio
                 /*, (select ct.num_formulario||'/'||ct.serie_formulario from oper.v$contrato_transp ct
                     where ct.conhecimento_id = c.conhecimento_id) as carta_frete  --Carta Frete*/
                 , (select kss.fnc_concat_all(kss.to_concat_expr(ct.num_formulario||'/'||ct.serie_formulario,';'))
                      from oper.v$contrato_transp_todos ct
                     where ct.num_romaneio = c.num_romaneio) as carta_frete  --Cartas Fretes
                   ----------------------------------------------------------------------Remetente / Destinatrio
                   -- Negociador
                 , (select p.cnpj_cpf from kss.v$pessoa p where p.cod_pessoa = c.cod_negociador) as neg_cnpj_cpf
                 , (select p.razao_social from kss.v$pessoa p where p.cod_pessoa = c.cod_negociador) as neg_razao_social
                   -- Remetente
                 , c.rem_cnpj_cpf
                 , c.rem_razao_social
                   -- Destinatrio
                 , c.dest_cnpj_cpf
                 , c.dest_razao_social
                   -- Consignatrio
                 , c.cons_cnpj_cpf
                 , c.cons_razao_social
                   -- Redespacho
                 , c.red_cnpj_cpf
                 , c.red_razao_social
                   -- Cobranca
                 , c.cob_cnpj_cpf
                 , c.cob_razao_social
                   ------------------------------------------- Servios
                 , c.cfop
                 , c.natureza_operacao
                   --CVF -- no fao idia; deixe em branco
                 , co.tipo_venda
                 , decode(co.tipo_venda,1,'Seca','Fracionada') as venda
                 , c.data_chegada
                   -- Coleta Urgente - MOCADO
                   -- Operao - ??? - MOCADO
                 , co.modalidade
                 , case co.modalidade
                      when '11' then 'Frota'
                      when '21' then 'Terceiro'
                      when '23' then 'Agregado'
                   end as desc_modalidade
                 , c.pagador
                 , decode(c.pagador,0,'CIF - Pago',1,'FOB - A Pagar') as cif_fob
                 , co.tipo_frete
                 , decode(co.faturado,1,'Sim','No') as faturado
                   -- Pagto  --- use o Tipo_Docto abaixo
                 , nvl2(fcr.docto_id,fcr.docto_id||' - '||(select fd.descricao from finan.v$finan_documento fd
                                                            where fd.docto_id = fcr.docto_id),null) as tipo_docto
                 , fcr.num_docto
                 , fcr.data_vencto
                   -- Ordem de Coleta -- deixe em branco
                 , c.num_natureza
                 , (select n.descricao
                      from fiscal.v$natureza  n
                     where n.num_natureza = c.num_natureza) as descricao_natureza
                   ------------Depois da tabela de Notas Fiscais....
                 , c.num_produto
                 , c.num_especie
                 , (select e.descricao
                      from oper.v$especie e
                     where e.num_especie = c.num_especie
                   ) as especie
                 , (select sum(nf.valor_total)
                      from fiscal.v$conhecimento_nota_fiscal nf
                     where nf.conhecimento_id = c.conhecimento_id
                   ) as valor_mercadoria
                 , c.volume as quantidade
                 , c.peso         --\___ um desses  o peso cobrado
                 , c.peso_real    --/
                 , c.frete_unitario
                 , c.base_calculo_icms
                 , c.aliquota_icms
                 , c.valor_icms
                   --Extras:
                 , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(cn.numero), '/')) as notas_fiscais
                      from fiscal.v$conhecimento_nota_fiscal cn
                     where cn.conhecimento_id = c.conhecimento_id
                   ) as notas_fiscais
                   ------------------------------------------------------- Seg / Origem / Destino / Veculo
                 , c.rem_municipio||'/'||c.rem_uf as origem
                 , c.dest_municipio||'/'||c.dest_uf as destino
                 , c.placa_tracao
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_tracao) as frota   --- esse campo que ser usado!
                 , c.placa as placa_carreta
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa) as frota_carreta   --- esse campo que ser usado!
                 , (select r.destino from oper.v$romaneio r
                     where r.num_romaneio = c.num_romaneio) as ultimo_destino
                 , c.km_rota
                 , co.km_vazio
                   --------------------------------------------------------------Negociao
                 , c.frete_peso
                 , c.frete_valor
                 , c.sec_cat
                 , co.seguro_rctr_c + co.seguro_rr + co.seguro_si as seguro
                 , c.despacho
                 , c.pedagio
                 , co.outros
                 , c.total_conhecimento  --Soma do CTRC
                 , nvl((select ccc.total_conhecimento
                          from fiscal.v$conhecimento_complemento cc
                         inner join fiscal.v$conhecimento ccc
                            on ccc.conhecimento_id = cc.conhecimento_complemento_id
                         where cc.conhecimento_id = c.conhecimento_id and rownum = 1),0) as total_complementos
                   --Resultado = Soma do CTRC - Complementos - Despesas
                 , (select nvl(sum(i.valor),0)
                      from oper.v$ctrc_outros_dados_itens i
                     where i.conhecimento_id = c.conhecimento_id
                       and i.despesa = 1
                   ) +
                   (select nvl(sum(i.valor),0)
                      from fiscal.v$conhecimento_complemento cm
                     inner join oper.v$ctrc_outros_dados_itens i
                        on i.conhecimento_id = cm.conhecimento_complemento_id
                     where cm.conhecimento_id = c.conhecimento_id
                       and i.despesa = 1
                   ) as total_despesas
                 , c.observacao
              from fiscal.v$conhecimento c
             inner join kss.v$unidade_negocio un
                on un.cod_pessoa = c.cod_pessoa_filial
              left join fiscal.v$conhecimento_outros_dados co
                on c.conhecimento_id = co.conhecimento_id
              left join fiscal.v$conhecimento_receber cr
                on cr.conhecimento_id = c.conhecimento_id
              left join finan.v$finan_contas_receber fcr
                on fcr.contas_receber_id = cr.contas_receber_id
              where 1=1
          <cfif len(trim(arguments.conhecimento_id))>
             	and c.conhecimento_id = '#arguments.conhecimento_id#' 
          </cfif>
        </cfquery>
		<cfreturn qr_result>	
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca listagem do relatorio de consulta de carta frete
	-- IGOR 18/09/2008
	--->		
	<cffunction name="get_consulta_carta_frete" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfargument name="serie_formulario" required="no" default="">
        <cfargument name="data_emissao" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="cod_unidade_negocio" required="no" default="">
        <cfargument name="cod_motorista" required="no" default="">
        <cfargument name="cod_proprietario" required="no" default="">
        <cfargument name="placa_controle" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ct.lancto_id, ct.num_formulario, ct.serie_formulario
                 , trunc(ct.data_emissao) as data_emissao
                 , un.cod_unidade_negocio, un.unidade_negocio
                 , nvl2(ct.data_cancelamento,'Cancelado',decode(ct.impresso,0,'Emitido', 'Impresso')) as situacao
                 , ct.num_romaneio
                 , ct.placa_controle as cavalo, ct.placa_referencia as carreta
                 , prop.razao_social as razao_social_proprietario
                 , mot.razao_social as nome_motorista
                 , ct.valor_frete_liquido   --Valor Total Lquido
                 , ct.valor_unitario
                 , ct.valor_frete_bruto   --Frete Carreteiro
              from oper.v$contrato_transp_todos ct
             inner join kss.v$unidade_negocio un
                on un.cod_pessoa = ct.cod_pessoa_filial
             inner join kss.v$pessoa prop
                on prop.cod_pessoa = ct.proprietario_cod_pessoa
             inner join kss.v$pessoa mot
                on mot.cod_pessoa = ct.motorista_cod_pessoa
             where 1=1
             <cfif len(trim(arguments.DATA_INICIAL))>
               and data_emissao >= '#arguments.data_inicial#'
             </cfif>
             <cfif len(trim(arguments.DATA_FINAL))>
               and data_emissao <= '#arguments.data_final#'
             </cfif>             
             <cfif len(trim(arguments.lancto_id))>
             	and ct.lancto_id = '#arguments.lancto_id#'
			 </cfif>
             <cfif len(trim(arguments.num_formulario))>
             	and ct.num_formulario = '#arguments.num_formulario#'
			 </cfif>
             <cfif len(trim(arguments.serie_formulario))>
             	and ct.serie_formulario = '#arguments.serie_formulario#'
			 </cfif>
             <cfif len(trim(arguments.cod_unidade_negocio))>
             	and un.cod_unidade_negocio = '#arguments.cod_unidade_negocio#'
             </cfif>
             <cfif len(trim(arguments.cod_motorista))>
             	and ct.motorista_cod_pessoa = '#arguments.cod_motorista#'
             </cfif>
             <cfif len(trim(arguments.cod_proprietario))>
             	and ct.proprietario_cod_pessoa = '#arguments.cod_proprietario#'
             </cfif>
             <cfif len(trim(arguments.placa_controle))>
             	and ct.placa_controle = '#arguments.placa_controle#'
             </cfif>
		</cfquery>
		<cfreturn qr_result>	
	</cffunction>  

<!--- 
	-- PROPSITO 
	-- Busca listagem do relatorio de consulta de carta frete
	-- IGOR 18/09/2008
	--->		
	<cffunction name="get_relatorio_consulta_carta_frete" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        -----2 Relatrio
        select ct.lancto_id, ct.num_formulario, ct.serie_formulario
             , decode(ct.tipo_contrato,1,'Agregado','Terceiro') as tipo_contrato
             , (select kss.fnc_concat_all(kss.to_concat_expr(c.num_conhecimento||'/'||c.serie,'; ')) as ctrc
                  from oper.v$contrato_transp_ctrc ctc
                 inner join fiscal.v$conhecimento c
                         on c.conhecimento_id = ctc.conhecimento_id
                 where ctc.lancto_id = ct.lancto_id
               ) as ctrc
             , trunc(ct.data_emissao) as data_emissao
             , un.cod_unidade_negocio, un.unidade_negocio  --Filial Emitente
             , nvl2(ct.data_cancelamento,'Cancelado',decode(ct.impresso,0,'Emitido', 'Impresso')) as situacao
             , ct.num_romaneio
             , nvl(ct.parcela,1) as parcela
             , r.carregamento as origem
             , r.destino
               -----------------------------------------------------------------------Remetente/Destinatrio
             , r.remetente
             , r.destinatario
               -----------------------------------------------------------------------Mercadorias
             , r.num_natureza
             , r.num_especie
             , (select e.descricao
                  from oper.v$especie e
                 where e.num_especie = r.num_especie
               ) as especie
             , (select sum((select sum(nf.valor_total)
                          from fiscal.v$conhecimento_nota_fiscal nf
                         where nf.conhecimento_id = c.conhecimento_id)) as valor_mercadoria
                  from fiscal.v$conhecimento c
                 where c.num_romaneio = r.num_romaneio
               ) as valor_mercadoria
             , r.volume_total
             , r.peso_total
             , oper.pkg_operacional.fnc_converte_peso(ct.peso, 'Kg', ct.cod_unidade) as peso
             , ct.cod_unidade
               -----------------------------------------------------------------------Veculo
             , ct.placa_controle as cavalo, ct.placa_referencia as carreta
             , oper.pkg_veiculo.fnc_get_cod_veiculo(ct.placa_controle) as frota_cavalo
             , oper.pkg_veiculo.fnc_get_cod_veiculo(ct.placa_referencia) as frota_carreta
             , prop.razao_social as razao_social_proprietario
             , prop.identificador as cnpj_cpf_proprietario_veiculo
             , mot.razao_social as nome_motorista
             , mot.identificador as cnpj_cpf_motorista
               -----------------------------------------------------------------------Valores
             , ct.valor_frete_liquido   --Valor Total Lquido / Valor do Servio
        --     , ct.valor_unitario
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 8) as valor_carga_descarga
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 1) as valor_pedagio
               ------------
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 20) as valor_irrf
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 7) as valor_adto
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 4) as valor_adto_pedagio
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 2) as valor_adto_comb
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 21) as valor_inss
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 23) as valor_sest --No tem no layout, mas pode colocar esse e o de baixo como Sest/Senat
             , (select nvl(sum(cti.valor),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id = 24) as valor_senat
             , (select nvl(sum(cti.valor * (cti.desconto - (1 - cti.desconto))),0)
                  from oper.v$contrato_transp_item cti
                 where cti.lancto_id = ct.lancto_id
                   and cti.item_id not in (20,21,23,24,7,4,2,8,1)) as valor_outros_itens  --Tb no tem, adicione como Outros
        
             , nvl2(ct.num_rpa,folha.pkg_rpa.fnc_base_calc_inss_empresa(ct.num_rpa),0) as valor_base_inss
             , nvl2(ct.num_rpa,folha.pkg_rpa.fnc_base_calc_inss_empresa(ct.num_rpa) * (folha.pkg_rpa.fnc_aliquota_inss_empresa(ct.num_rpa)/100),0) as inss_empresa
        
               --Total de Acrscimos  --valor_carga_descarga + valor_pedagio
               --Total de Descontos   --valor_irrf + valor_adto + valor_adto_pedagio + valor_adto_comb + valor_inss + valor_sest + valor_senat + valor_outros_itens
             , ct.valor_frete_bruto   --Frete Carreteiro
               --Valor do Saldo       --Total lquido + Acrscimos - Descontos
               -----------------------------------------------------------------------Documentos
             , (select m.num_manifesto
                  from oper.v$manifesto m
                 where m.manifesto_id = ct.manifesto_id) as num_manifesto  --No  usado
             , ct.num_rpa  --No  usado
             , (select kss.fnc_concat_all(kss.to_concat_expr(cp.num_docto||'/'||cp.parc_docto,', ')) as titulos
                  from oper.v$contrato_transp_todos t
                 inner join oper.v$contrato_transp_pagar ctp
                    on t.lancto_id = ctp.lancto_id
                 inner join finan.v$finan_contas_pagar cp
                    on cp.contas_pagar_id = ctp.contas_pagar_id
                 where nvl(t.lancto_id_pai,t.lancto_id) = ct.lancto_id
               ) as titulos_cpg
             , round(ct.valor_frete_bruto * nvl((select nvl(im.imposto_aliquota,0)
                                                      * case
                                                           when im.imposto_reducao_base > 0 then
                                                             (nvl(im.imposto_reducao_base,0)/100)
                                                           else 1
                                                        end
                                                   from fiscal.v$imposto_docto_fiscal im
                                                  where im.imposto_id = case when ct.num_rpa is null then 20 else 22 end),0)/100,2) as credito_pis
             , round(ct.valor_frete_bruto * nvl((select nvl(im.imposto_aliquota,0)
                                                      * case
                                                           when im.imposto_reducao_base > 0 then
                                                             (nvl(im.imposto_reducao_base,0)/100)
                                                           else 1
                                                        end
                                                   from fiscal.v$imposto_docto_fiscal im
                                                  where im.imposto_id = case when ct.num_rpa is null then 21 else 23 end),0)/100,2) as credito_cofins
             , ct.observacao
          from oper.v$contrato_transp_todos ct
         inner join kss.v$unidade_negocio un
            on un.cod_pessoa = ct.cod_pessoa_filial
         inner join kss.v$pessoa prop
            on prop.cod_pessoa = ct.proprietario_cod_pessoa
         inner join kss.v$pessoa mot
            on mot.cod_pessoa = ct.motorista_cod_pessoa
          left join oper.v$romaneio r
            on r.num_romaneio = ct.num_romaneio
          where 1=1
          <cfif len(trim(arguments.lancto_id))>
             	and ct.lancto_id = '#arguments.lancto_id#'
          </cfif>
        </cfquery>
		<cfreturn qr_result>	
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca listagem do relatorio de consulta de viagem
	-- IGOR 23/09/2008
	--->		
	<cffunction name="get_consulta_viagem" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="num_conhecimento" required="no" default="">
        <cfargument name="serie" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio
                 , r.placa_controle, r.placa_referencia
                 , r.data_inicio
                 , r.carregamento, r.destino
                 , r.remetente, r.destinatario
                 , oper.fnc_ref_code('ROMANEIO.SITUACAO_ID',r.situacao_id,0) as situacao
                 , (select kss.fnc_concat_all(kss.to_concat_expr(c.num_conhecimento||'/'||c.serie,';'))
                      from fiscal.v$conhecimento c
                     where c.num_romaneio = r.num_romaneio) as lista_ctrc
              from oper.v$romaneio r
             where 1=1
             <cfif Len(Trim(arguments.num_conhecimento))>
               and exists (select 0 from fiscal.v$conhecimento c
                            where c.num_romaneio = r.num_romaneio and c.num_conhecimento = '#arguments.num_conhecimento#')
             </cfif>               
             <cfif len(trim(arguments.DATA_INICIAL))>
               and r.data_inicio >= '#arguments.data_inicial#'
             </cfif>
             <cfif len(trim(arguments.DATA_FINAL))>
               and r.data_inicio <= '#arguments.data_final#'
             </cfif>                       
             <cfif len(trim(arguments.num_romaneio))>
             	and r.num_romaneio = '#arguments.num_romaneio#'
			 </cfif>
		</cfquery>
		<cfreturn qr_result>	
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Busca listagem do relatorio de consulta de carta frete
	-- IGOR 18/09/2008
	--->		
	<cffunction name="get_relatorio_consulta_viagem" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select r.num_romaneio
             , r.placa_controle
             , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) as frota_controle 
             , r.placa_referencia
             , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia) as frota_referencia
             , r.data_inicio
             , r.carregamento, r.destino
             , r.remetente, r.destinatario, r.cliente
             , oper.fnc_ref_code('ROMANEIO.SITUACAO_ID',r.situacao_id,0) as situacao
             , r.observacao
             , (select nvl(sum(c.total_conhecimento),0)
                  from fiscal.v$conhecimento c
                 where c.num_romaneio = r.num_romaneio) as total_receitas
             , (select nvl(sum(i.valor),0)
                  from fiscal.v$conhecimento c
                    inner join oper.v$ctrc_outros_dados_itens i
                    on i.conhecimento_id = c.conhecimento_id
                  where c.num_romaneio = r.num_romaneio
                    and i.tributo+i.custo = 1) as total_despesas
          from oper.v$romaneio r
         where 1=1
         <cfif len(trim(arguments.num_romaneio))>
             	and r.num_romaneio = '#arguments.num_romaneio#'
		 </cfif>
 		</cfquery>
		<cfreturn qr_result>	
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca listagem do relatorio de consulta de critica operacional de vendas
	-- IGOR 23/09/2008
	--->		
	<cffunction name="get_consulta_critica_operacional" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="cod_unidade_negocio" required="no" default="">
        <cfargument name="num_conhecimento" required="no" default="">
        <cfargument name="serie" required="no" default="">
        <cfargument name="modalidade" required="no" default="">
        <cfargument name="rentabilidade" required="no" default="">		
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">		
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select x.*
                     , x.total_ctrc - (x.custos + x.tributos) as margem_liquida
                     , ((x.total_ctrc - (x.custos + x.tributos))/nullif(x.total_ctrc,0)) * 100 as rentabilidade
                  from (--- 4 Relatrio
                        select r.num_romaneio
                             , un.cod_unidade_negocio, un.unidade_negocio
                             , (select min(c.placa_tracao)
                                  from fiscal.v$conhecimento c
                                 where c.num_romaneio = r.num_romaneio) as placa_controle
                             , r.placa_referencia
                             , r.data_inicio
                             , r.carregamento, r.destino
                             , r.km_vazio
                             , r.km_carregado
                             , oper.fnc_ref_code('ROMANEIO.SITUACAO_ID',r.situacao_id,0) as situacao
                             , (select sum(c.total_conhecimento)
                                  from fiscal.v$conhecimento c
                                 where c.num_romaneio = r.num_romaneio) as total_ctrc
                             , (select count(*)
                                  from fiscal.v$conhecimento c
                                 where c.num_romaneio = r.num_romaneio) as qtde_ctrc
                             , r.frete_total
                             , (select nvl(sum(i.valor),0) as total
                                  from fiscal.v$conhecimento c
                                 inner join oper.v$ctrc_outros_dados_itens i
                                    on i.conhecimento_id = c.conhecimento_id
                                 where c.num_romaneio = r.num_romaneio
                                   and i.custo = 1
                                   and i.coluna <> 'CUSTO_GE'
                               ) as custos --Custo Total
                             , (select nvl(sum(i.valor),0) as total
                                  from fiscal.v$conhecimento c
                                 inner join oper.v$ctrc_outros_dados_itens i
                                    on i.conhecimento_id = c.conhecimento_id
                                 where c.num_romaneio = r.num_romaneio
                                   and i.tributo = 1
                               ) as tributos --Seguros+Tributos
                		     ,oper.pkg_veiculo_dml.fnc_veiculo_get_modalidade((select min(c.placa_tracao)
                                                                                 from fiscal.v$conhecimento c
                                                                                where c.num_romaneio = r.num_romaneio)
                                                                               ,r.data_inicio) as modalidade
                               --Margem lquida =  total_ctrc - (custos + tributos)
                               --Rentabilidade (%) = ((total_ctrc - (custos + tributos))/total_ctrc) * 100
                             , r.observacao
                          from oper.v$romaneio r
                         inner join kss.v$unidade_negocio un
                            on un.cod_pessoa = r.cod_pessoa_filial
                 where 1=1
					<cfif len(trim(arguments.num_romaneio))>
                    	and r.num_romaneio like '#arguments.num_romaneio#'
                    </cfif>
					<cfif len(trim(arguments.cod_unidade_negocio))>
                    	and un.cod_unidade_negocio = '#arguments.cod_unidade_negocio#'
                    </cfif>                    
                    <cfif len(trim(arguments.num_conhecimento))>
                    	and exists (select 0 from fiscal.v$conhecimento c
                                where c.num_romaneio = r.num_romaneio and c.num_conhecimento like '#arguments.num_conhecimento#'
                                  <cfif len(trim(arguments.serie))>
                                  	and c.serie = '#arguments.serie#'
                                  </cfif>
                              ) 
                    </cfif>
                    <cfif len(trim(arguments.modalidade)) and arguments.modalidade neq "T">
                    	and oper.pkg_veiculo_dml.fnc_veiculo_get_modalidade(r.placa_controle,r.data_inicio) like '#arguments.modalidade#'
                    </cfif>
                    <cfif len(trim(arguments.modalidade)) and arguments.modalidade eq "T">
                    	and oper.pkg_veiculo_dml.fnc_veiculo_get_modalidade(r.placa_controle,r.data_inicio) like '%'
                    </cfif>
                    <cfif len(trim(arguments.DATA_INICIAL))>
                    	and r.data_inicio >= '#arguments.data_inicial#'
                    </cfif>
                    <cfif len(trim(arguments.DATA_FINAL))>
                    	and r.data_inicio <= '#arguments.data_final#'
                    </cfif>
            	) x
        where 1=1
        <cfif len(trim(arguments.rentabilidade)) and arguments.rentabilidade eq 0>
               and ((total_ctrc - (x.custos + x.tributos))/nullif(x.total_ctrc,0)) * 100 > 0  --Rentabilidade positiva
        </cfif>
        <cfif len(trim(arguments.rentabilidade)) and arguments.rentabilidade eq 1>
               and  lnnvl(((total_ctrc - (x.custos + x.tributos))/nullif(x.total_ctrc,0)) * 100 > 0) --Rentabilidade negativa ou nula
        </cfif>
       	order by  COD_UNIDADE_NEGOCIO, MODALIDADE
       </cfquery>
	   <cfreturn qr_result>
	</cffunction>     
    
    
    <!--- 
	-- PROPSITO 
	-- Busca modalidade da consulta de critica operacional de vendas
	-- IGOR 23/09/2008
	--->		
	<cffunction name="get_modalidade" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.valor
  		   from kss.v$atributo_item a
 		   where a.atributo_id = 115
 		   order by a.valor
       </cfquery>
	   <cfreturn qr_result>
	</cffunction> 
    
    <!--- 
	-- PROPSITO 
	-- Busca listagem do relatorio de consulta de critica operacional de vendas
	-- IGOR 23/09/2008
	--->		
	<cffunction name="get_vendas_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="data_final" required="no" default="">	
        <cfargument name="data_inicial" required="no" default="">		
        <cfargument name="modalidade" required="no" default="">	
        <cfargument name="tipo_cliente" required="no" default="">	
        <cfargument name="cod_pessoa" required="no" default="">	
        <cfargument name="cnpj_cpf" required="no" default="">	
        <cfargument name="nome" required="no" default="">	
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select
               i.modalidade
             , case i.modalidade
                  when '11' then 'Frota'
                  when '21' then 'Terceiro'
                  when '23' then 'Agregado'
               end as desc_modalidade
             , sum(sum(total_conhecimento)) over (partition by i.modalidade) as total_conhecimento_modalidade 
             , round((1 - sum(sum(i.total_despesa)) over (partition by i.modalidade)
                        / sum(sum(total_conhecimento)) over (partition by i.modalidade)) * 100,2) as margem_liq_modalidade
             , sum(sum(peso)) over (partition by i.modalidade) as peso_modalidade  
             , round(100 * sum(sum(peso)) over (partition by i.modalidade) / sum(sum(peso)) over (),2) as perc_peso_modalidade  
             , sum(sum(qtde)) over (partition by i.modalidade) as qtde_modalidade  
             , i.coluna  
             , max(i.descricao) as despesa
             , sum(i.valor) as valor
               from (select i.conhecimento_id, i.coluna, i.descricao, i.valor
                     , co.modalidade
                     , case
                          when nvl(lag(c.conhecimento_id) over (order by c.conhecimento_id),0) <> c.conhecimento_id then
                             c.total_conhecimento
                          else 0
                       end as total_conhecimento
                     , case
                          when nvl(lag(c.conhecimento_id) over (order by c.conhecimento_id),0) <> c.conhecimento_id then
                             c.peso
                          else 0
                       end as peso
                     , case
                          when nvl(lag(c.conhecimento_id) over (order by c.conhecimento_id),0) <> c.conhecimento_id then
                             1
                          else 0
                       end as qtde
                     , case
                          when nvl(lag(c.conhecimento_id) over (order by c.conhecimento_id),0) <> c.conhecimento_id then
                             sum(i.valor) over (partition by i.conhecimento_id)
                          else 0
                       end as total_despesa
                  from fiscal.v$conhecimento c
                 inner join oper.v$ctrc_outros_dados_itens i
                    on i.conhecimento_id = c.conhecimento_id
                 inner join fiscal.v$conhecimento_outros_dados co
                    on co.conhecimento_id = c.conhecimento_id
                 where i.despesa = 1
                   and c.situacao_id = 0
                   and c.num_romaneio is not null
                   <cfif len(trim(arguments.tipo_cliente)) and arguments.tipo_cliente eq 0 >
                   		and c.cod_negociador = '#arguments.cod_pessoa#'
                   <cfelseif len(trim(arguments.tipo_cliente)) and arguments.tipo_cliente eq 1 >
                   		and c.cod_remetente = '#arguments.cod_pessoa#'
                   </cfif>
                   <cfif len(trim(arguments.modalidade))>
                   		<cfif arguments.modalidade eq '0'>
                        	and co.modalidade like '%'
                        <cfelseif arguments.modalidade neq '0'> 	
                   				and co.modalidade = #arguments.modalidade#
                        </cfif>
                   </cfif>
                   <cfif len(trim(arguments.data_inicial)) and len(trim(arguments.data_final))>
			  			and c.data_emissao between to_date('#arguments.data_inicial#','dd/mm/yyyy') and to_date('#arguments.data_final#','dd/mm/yyyy')
				   </cfif>
               ) i
         group by i.coluna, i.modalidade
         order by modalidade  
       </cfquery>
	   <cfreturn qr_result>
	</cffunction>   

	<!--- 
	-- PROPSITO
	-- Executa todos os calculos do CTRC levando em considerao as regras fiscais
	-- guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name='calcula_ctrc_comercial' displayname='Executa todos os calculos do CTRC levando em considera??o as regras fiscais' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='PEDAGIO' required='yes' >
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='VALOR_MERCADORIA' required='yes'>
		<cfargument name='AD_VALOREM' required='no' default="0">
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='ENTREGA_UF' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COD_REMETENTE' required='no' default="">
		<cfargument name='COD_CLIENTE_COBRANCA' required='no' default="">
		<cfargument name='COD_UNIDADE' required='no' default="">
		<cfargument name='REGRA_FISCAL_ID' required='no' default="1">
		<cfargument name='COLETA_MUNICIPIO_ID' required='no' default="">
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='no' default="">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='SEM_ICMS' required='no' default="0">
		<!---Novos campos para CONTRATO--->	
		<cfargument name='COD_NEGOCIADOR' required='no' default="">
		<cfargument name='FRACIONADO' required='no' default="">
		<cfargument name='NUM_NATUREZA' required='no' default="">
		<cfargument name='COD_TABELA_FRETE' required='no' default="">
		<cfargument name='VALOR_TOTAL_NOTA' required='no' default="">
		<cfargument name='FLAG_COLETA' required='no' default="">
		<cfargument name='NUM_EIXOS' required='no' default="">
		<cfargument name='FLAG_URGENTE' required='no' default="">
		<cfargument name='FLAG_TRUCK' required='no' default="">
		<cfargument name='NUM_AJUDANTES' required='no' default="">
		<cfargument name='NUM_ENTREGAS' required='no' default="">
		<cfargument name='FLAG_LOTACAO' required='no' default="">
		<cfargument name='M3' required='no' default="">
		<cfargument name='CTRC_COMPLEMENTAR' required='no' default="0">
    	<cftry>        
            <cfstoredproc procedure='fiscal.pkg_conhecimento.prc_calcula_ctrc_comercial' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
    
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#' variable='retorno.DESPACHO'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#' variable='retorno.SEC_CAT'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#' variable='retorno.GRIS'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#' variable='retorno.PEDAGIO'>
    
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#' variable="retorno.NUM_PRODUTO">
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGO_POR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#' variable='retorno.COLETA_ENTREGA' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='COLETA_UF'  value='#arguments.COLETA_UF#'  null='#iif(len(trim(arguments.COLETA_UF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='ENTREGA_UF' value='#arguments.ENTREGA_UF#'  null='#iif(len(trim(arguments.ENTREGA_UF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MERCADORIA' value='#arguments.VALOR_MERCADORIA#' null='#iif(len(trim(arguments.VALOR_MERCADORIA)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AD_VALOREM' value='#arguments.AD_VALOREM#' null='#iif(len(trim(arguments.AD_VALOREM)), de('no'), de('yes'))#' variable='retorno.AD_VALOREM'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#' variable='retorno.FRETE_UNITARIO' null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' variable='retorno.ST_ICMS_ID' >
    
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR' variable='retorno.FRETE_VALOR'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PESO' variable='retorno.FRETE_PESO'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_CONHECIMENTO' variable='retorno.TOTAL_CONHECIMENTO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS' variable='retorno.BASE_CALCULO_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS' variable='retorno.ALIQUOTA_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS' variable='retorno.VALOR_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_SUBSTIT' variable='retorno.VALOR_ICMS_SUBSTIT' >
    
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE' value='#arguments.COD_REMETENTE#' null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_COD_UNIDADE' value='#arguments.COD_UNIDADE#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_REGRA_FISCAL_ID' value='#arguments.regra_fiscal_id#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_COB_UF' value='#arguments.COB_UF#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID' value='#arguments.COLETA_MUNICIPIO_ID#' null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID' value='#arguments.ENTREGA_MUNICIPIO_ID#' null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE' value='#arguments.NUM_LOTE#' null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEM_ICMS' value='#arguments.SEM_ICMS#' null='#iif(len(trim(arguments.SEM_ICMS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA' value='#arguments.COD_CLIENTE_COBRANCA#' null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'> 
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_FILIAL' value='#arguments.UF_EMITENTE#'>
    
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP' variable='retorno.CFOP' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID' variable='retorno.CFOP_ID' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO' variable='retorno.NATUREZA_OPERACAO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL' variable='retorno.FUNDAMENTACAO_LEGAL' >
				<!---Novos campos para CONTRATO--->	
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_INCLUSO' variable='retorno.PEDAGIO_INCLUSO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR' value='#arguments.COD_NEGOCIADOR#' null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRACIONADO' value='#arguments.FRACIONADO#' null='#iif(len(trim(arguments.FRACIONADO)), de('no'), de('yes'))#'>
                  <!---Se possuir M3 ento  1 (por volume) seno  PESO (0)--->
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_UNIDADE_COBRANCA' value='#iif(arguments.M3 gt 0,DE("1"),DE("0"))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA' value='#arguments.NUM_NATUREZA#' null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_TABELA_FRETE_RET' variable='retorno.COD_TABELA_FRETE_RET' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CONTRATO' variable='retorno.DESCRICAO_CONTRATO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LISTA_TABELA_FRETE' variable='retorno.LISTA_TABELA_FRETE' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_TABELA_FRETE' value='#arguments.COD_TABELA_FRETE#' null='#iif(len(trim(arguments.COD_TABELA_FRETE)), de('no'), de('yes'))#'> 
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_TOTAL_NOTA' value='#arguments.VALOR_TOTAL_NOTA#' null='#iif(len(trim(arguments.VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FLAG_COLETA' value='#arguments.FLAG_COLETA#' null='#iif(len(trim(arguments.FLAG_COLETA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_EIXOS' value='#arguments.NUM_EIXOS#' null='#iif(len(trim(arguments.NUM_EIXOS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FLAG_URGENTE' value='#arguments.FLAG_URGENTE#' null='#iif(len(trim(arguments.FLAG_URGENTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FLAG_TRUCK' value='#arguments.FLAG_TRUCK#' null='#iif(len(trim(arguments.FLAG_TRUCK)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_AJUDANTES' value='#arguments.NUM_AJUDANTES#' null='#iif(len(trim(arguments.NUM_AJUDANTES)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ENTREGAS' value='#arguments.NUM_ENTREGAS#' null='#iif(len(trim(arguments.NUM_ENTREGAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FLAG_LOTACAO' value='#arguments.FLAG_LOTACAO#' null='#iif(len(trim(arguments.FLAG_LOTACAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3' value='#arguments.M3#' null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_OUTROS' variable='retorno.OUTROS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_COBRADO' variable='retorno.PESO_COBRADO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CTRC_COMPLEMENTAR' value='#arguments.CTRC_COMPLEMENTAR#' null='#iif(len(trim(arguments.CTRC_COMPLEMENTAR)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfif not Len(Trim(retorno.FRETE_UNITARIO))>
                <cfset retorno.FRETE_UNITARIO = 0>
            </cfif>		
            <cfif not Len(Trim(retorno.AD_VALOREM))>
                <cfset retorno.AD_VALOREM = 0>
            </cfif>		
        <cfset retorno.erro = false>
        <cfset retorno.mensagem = JSStringFormat('Ok')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset retorno.mensagem_str = Mid(cfcatch.Detail,1,Find('ORA-',cfcatch.Detail,10)-1)>
            <cfset retorno.mensagem_str = cfcatch.detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
		<cfreturn retorno/>
	</cffunction>	    

    <!--- 
	-- PROPSITO 
	-- Busca modalidade da consulta de critica operacional de vendas
	-- IGOR 23/09/2008
	--->		
	<cffunction name="get_impostos_nf" access="remote" returntype="query" output="true">
    	<cfargument name="categoria_id" required="no" default="">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select i.imposto_id
                 , i.descricao_imposto
                 , i.imposto_reducao_base
                 , i.imposto_aliquota
                 , c.categoria_id
              from fiscal.v$categoria_imp_retencao c
             inner join fiscal.v$imposto_docto_fiscal i 
                on i.imposto_id = c.imposto_id
             where 1=1
               <cfif Len(Trim(arguments.categoria_id))>
                 and c.categoria_id in (#arguments.categoria_id#)
               </cfif>
       </cfquery>
	   <cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os centros de custo gerenciais
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 01/12/2010
	--->
    <cffunction name="get_centro_custo_gerencial" access="remote" returntype="query" output="true">
    	<cfargument name="cod_organograma" required="no" default="" />
        <cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.cod_organograma
                 , o.cod_pessoa
                 , o.cod_unidade_negocio
                 , lpad(o.cod_unidade_negocio, 2, '0') || ' - ' || un.unidade_negocio as desc_unidade_negocio
                 , o.cod_departamento
                 , lpad(o.cod_departamento, 3, '0') || ' - ' || d.descricao as desc_departamento
                 , o.cod_setor
                 , lpad(o.cod_setor, 3, '0') || ' - ' || s.descricao as desc_setor
                 , o.cod_centro_custo
                 , lpad(o.cod_centro_custo, 4, '0') || ' - ' || cc.centro_custo as desc_centro_custo
              from kss.v$organograma o
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = o.cod_pessoa
             inner join kss.v$departamento d
                     on d.cod_departamento = o.cod_departamento
             inner join kss.v$setor s
                     on s.cod_setor = o.cod_setor
             inner join kss.v$centro_custo cc
                     on cc.cod_centro_custo = o.cod_centro_custo
             where 1 = 1
			<cfif Len(Trim(arguments.cod_organograma))>
               and o.cod_organograma = '#arguments.cod_organograma#'
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and o.cod_pessoa = #arguments.cod_pessoa_filial#
			</cfif>
            <cfif Len(Trim(arguments.cod_departamento))>
               and o.cod_departamento = #arguments.cod_departamento#
			</cfif>
            <cfif Len(Trim(arguments.cod_setor))>
               and o.cod_setor = #arguments.cod_setor#
			</cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and o.cod_centro_custo = #arguments.cod_centro_custo#
			</cfif>
             order by o.cod_unidade_negocio, o.cod_departamento, o.cod_setor, o.cod_centro_custo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um "cod_organograma_gerencial" atravs de uma Placa de Referncia e um Num de Romaneio
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 24/03/2009
	--->	
	<cffunction name="get_cod_organograma_gerencial" displayname="Retorna os centro de custos gerenciais" output="true" returntype="query" access="remote">
        <cfargument name="PLACA_REFERENCIA" required="no" default="">
        <cfargument name="NUM_ROMANEIO" required="no" default="">
        <cfargument name="COMPLEMENTO" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select oper.pkg_contrato_transporte.fnc_cod_organograma_gerencial('#arguments.PLACA_REFERENCIA#', '#arguments.NUM_ROMANEIO#', '#arguments.COMPLEMENTO#') as cod_organograma_gerencial
              from dual
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca Organograma completo
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_organograma" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select o.cod_organograma, o.cod_unidade_negocio, 
				   p.cliente as filial, o.cod_pessoa, 
				   d.descricao as departamento, o.cod_departamento,
				   s.descricao as setor, o.cod_setor,
				   cc.centro_custo, o.cod_centro_custo
			  from kss.v$organograma o
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = o.cod_pessoa
			 inner join kss.v$departamento d
					 on d.cod_departamento = o.cod_departamento
			 inner join kss.v$setor s
					 on s.cod_setor = o.cod_setor
			 inner join kss.v$centro_custo cc
					 on cc.cod_centro_custo = o.cod_centro_custo   
             where 1=1
			 <cfif Len(Trim(arguments.cod_pessoa))>
			   and o.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>			 					                      
			 <cfif Len(Trim(arguments.cod_centro_custo))>
			   and o.cod_centro_custo = '#arguments.cod_centro_custo#'
			 </cfif>			 					                      
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Sries para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_nota_serie" displayname="Busca Sries para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="nfes" required="no" default="" />
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.serie
                           from fiscal.v$modelo_serie ms
                     inner join fiscal.v$sintegra_modelo_fiscal smf
                     	     on smf.cod_modelo = ms.cod_modelo
                          where 1=1
                            and ms.ativo = 1 
                 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
                  <cfif Len(Trim(arguments.nfes))>
					and smf.nfes = '#arguments.nfes#' 
				 </cfif>
				 <cfif Len(Trim(arguments.cod_modelo))>
					and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
				 </cfif>
				 <cfif Len(Trim(arguments.serie))>
					and ms.serie ='#arguments.serie#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_departamento))>
					and ms.cod_departamento ='#arguments.cod_departamento#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_pessoa))>
					and ms.cod_pessoa ='#arguments.cod_pessoa#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_setor))>
					and ms.cod_setor ='#arguments.cod_setor#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_centro_custo))>
					and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
				 </cfif>
                 group by ms.serie
				 order by ms.serie
				</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Sub-Sries para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_nota_subserie" displayname="Busca Sub-Sries para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="nfes" required="no" default="" />
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.subserie
                      ,nvl((select (max(nf.num_nota_fiscal)+1)
                              from fiscal.v$nf_es nf
                             where nf.cod_pessoa_filial = ms.cod_pessoa
                               and nf.cod_departamento  = ms.cod_departamento
                               and nf.cod_setor         = ms.cod_setor
                               and nf.cod_centro_custo  = ms.cod_centro_custo
                               and nf.cod_modelo        = ms. cod_modelo
                               and nf.serie             = ms.serie
                               and nf.subserie          = ms.subserie),(ms.num_inicial)) as prox_nota,
                                ms.incluir_livro_fiscal as livro_fiscal,
                                ms.incluir_sintegra
                           from fiscal.v$modelo_serie ms
                     inner join fiscal.v$sintegra_modelo_fiscal smf
                     	     on smf.cod_modelo = ms.cod_modelo
                          where 1=1
                            and ms.ativo = 1 
                 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
                  <cfif Len(Trim(arguments.nfes))>
					and smf.nfes = '#arguments.nfes#' 
				 </cfif>
				 <cfif Len(Trim(arguments.cod_modelo))>
					and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
				 </cfif>
				 <cfif Len(Trim(arguments.serie))>
					and ms.serie ='#arguments.serie#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_departamento))>
					and ms.cod_departamento ='#arguments.cod_departamento#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_pessoa))>
					and ms.cod_pessoa ='#arguments.cod_pessoa#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_setor))>
					and ms.cod_setor ='#arguments.cod_setor#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_centro_custo))>
					and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
				 </cfif>
                 order by ms.subserie
				</cfquery>		
		<cfreturn qr_result>
	</cffunction>
          
    <!--- 
    -- PROPSITO
    -- Retorna os valores para o clculo RPA
    -- ANDERSONC 04/05/2009 14:44:03 - CRIADO
    --->
    <cffunction name='calculo_rpa' displayname='Retorna os valores para o clculo RPA' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='VALOR_SERVICO' required='yes'>
            <cfstoredproc procedure='folha.pkg_rpa.prc_calculo_rpa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA' value='#arguments.COD_PESSOA#' null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA' value='#arguments.DATA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_SERVICO' value='#arguments.VALOR_SERVICO#' null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_INSS' variable='retorno.VALOR_INSS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_SEST' variable='retorno.VALOR_SEST' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_SENAT' variable='retorno.VALOR_SENAT' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_IRRF' variable='retorno.VALOR_IRRF' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALC_INSS' variable='retorno.BASE_CALC_INSS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALC_SEST_SENAT' variable='retorno.BASE_CALC_SEST_SENAT' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALC_IRRF' variable='retorno.BASE_CALC_IRRF' >
            </cfstoredproc>
        <cfreturn retorno/>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna a previso de chegada para uma rota
	-- ANDERSON 06/05/2009
	--->		
	<cffunction name="get_previsao_entrega" display="Retorna a previso de chegada para uma rota" access="remote" returntype="query" output="true">
		<cfargument name='ROTA_ID' required='no' default="">
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default="">
		<cfargument name='DESTINO_MUNICIPIO_ID' required='no' default="">
		<cfargument name='DATA_INICIO' required='no' default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select to_char(oper.pkg_rota.fnc_previsao_chegada(to_date('#arguments.data_inicio#', 'dd/mm/yyyy hh24:mi'),r.origem_municipio_id,r.destino_municipio_id),'dd/mm/yyyy hh24:mi') as data_prazo_entrega
              from oper.v$rota r
             where 1 = 1
			<cfif Len(Trim(arguments.origem_municipio_id))>
              and r.origem_municipio_id = #arguments.origem_municipio_id#
            </cfif>
            <cfif Len(Trim(arguments.destino_municipio_id))>
              and r.destino_municipio_id = #arguments.destino_municipio_id#
            </cfif>
            <cfif Len(Trim(arguments.rota_id))>
              and r.rota_id = #arguments.rota_id#
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna os dados para o Espelho do Conhecimento
	-- ANDERSON 19/06/2009 - CRIADO
	--->		
	<cffunction name="get_espelho_conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
        <cfargument name="serie" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
                 , kss.pkg_pessoa.fnc_get_cliente(ku.cod_pessoa) || ' - ' || nvl(cc.centro_custo, c.cod_centro_custo) as emitente
                 , c.cob_razao_social
                 , c.num_conhecimento
                 , case when c.faturado is null then 'A Faturar' else 'Faturado' end as tipo_faturamento
                 , to_char(c.date_insert, 'dd/mm/yyyy') as date_insert
                 , c.user_insert
                 , case
                      when c.conhecimento_id in (select conhecimento_complemento_id
                                                   from fiscal.v$conhecimento_complemento cc
                                                  where cc.conhecimento_complemento_id = c.conhecimento_id) then 'Complementar'
                      else 'Normal'
                   end as tipo_emissao
                 , nvl((select case
                                  when fcr.situacao = 1 then 'Quitado'
                                  else
                                     case
                                        when exists (select 0
                                                       from finan.v$finan_contas_receber_amort a
                                                      where a.contas_receber_id = fcr.contas_receber_id
                                                        and a.autenticado = 1) then 'Parcial'
                                        else 'Aberto'
                                     end
                                  end as situacao_fat
                          from finan.v$finan_contas_receber fcr
                         inner join fiscal.v$conhecimento_receber cr
                                 on cr.contas_receber_id = fcr.contas_receber_id
                         where cr.conhecimento_id = c.conhecimento_id
                           and rownum = 1), 'No Faturado') as situacao_fat
                 , to_char(c.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , decode(c.pagador, 0, 'Pago', 'A Pagar') as tipo_frete
                 , to_char(c.data_entrega, 'dd/mm/yyyy') as data_entrega
                 , nvl2(c.data_entrega,
                      (select count(*)
                         from dual
                        where to_char(c.data_emissao + level - 1, 'd') not in ('1', '7')
                      connect by c.data_emissao + level - 1 <= c.data_entrega), '') as dias_uteis_entrega
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = c.cod_motorista) as cpf_motorista
                 , c.nome_motorista
                 , c.placa_tracao
                 , c.placa
                 , c.rem_cnpj_cpf
                 , c.rem_razao_social
                 , c.dest_cnpj_cpf
                 , c.dest_razao_social
                 , c.red_cnpj_cpf
                 , c.red_razao_social
                 , c.cons_cnpj_cpf
                 , c.cons_razao_social
                 , c.coleta_cep
                 , (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = c.coleta_municipio_id) as coleta_cidade
                 , (select m.uf_id
                      from cep.municipio m
                     where m.municipio_id = c.coleta_municipio_id) as coleta_uf
                 , c.entrega_cep
                 , (select m.municipio
                      from cep.municipio m
                     where m.municipio_id = c.entrega_municipio_id) as entrega_cidade
                 , (select m.uf_id
                      from cep.municipio m
                     where m.municipio_id = c.entrega_municipio_id) as entrega_uf
                 , c.coleta_logradouro
                 , c.entrega_logradouro
                 , to_char((select sum(cnf.valor_total)
                              from fiscal.v$conhecimento_nota_fiscal cnf
                             where cnf.conhecimento_id = c.conhecimento_id),'FM9G9999G990D00','nls_numeric_characters=,.') as valor_mercadoria
                 , to_char((select sum(cnf.peso)
                              from fiscal.v$conhecimento_nota_fiscal cnf
                             where cnf.conhecimento_id = c.conhecimento_id),'FM9G9999G990D000','nls_numeric_characters=,.') as peso
                 , to_char((select sum(cnf.peso_cubado)
                              from fiscal.v$conhecimento_nota_fiscal cnf
                             where cnf.conhecimento_id = c.conhecimento_id),'FM9G9999G990D000','nls_numeric_characters=,.') as peso_cubado
                 , (select sum(cnf.qtde_volume)
                      from fiscal.v$conhecimento_nota_fiscal cnf
                     where cnf.conhecimento_id = c.conhecimento_id) as qtde_volume

                 , (c.num_natureza || ' ' ||
                   (select n.descricao
                      from oper.v$natureza n
                     where n.num_natureza = c.num_natureza)) as natureza_carga
                 , (select sum(cnf.m3)
                      from fiscal.v$conhecimento_nota_fiscal cnf
                     where cnf.conhecimento_id = c.conhecimento_id) as m3
                 , (c.num_especie || ' ' ||
                   (select es.descricao
                      from oper.v$especie es
                     where es.num_especie = c.num_especie)) as especie_carga
                 , to_char(c.frete_peso,'FM9G9999G990D00','nls_numeric_characters=,.') as frete_peso
                 , to_char(c.frete_valor,'FM9G9999G990D00','nls_numeric_characters=,.') as frete_valor
                 , to_char(c.ademe,'FM9G9999G990D00','nls_numeric_characters=,.') as ademe
                 , to_char(c.gris,'FM9G9999G990D00','nls_numeric_characters=,.') as gris
                 , to_char(c.sec_cat,'FM9G9999G990D00','nls_numeric_characters=,.') as sec_cat
                 , to_char(c.desconto,'FM9G9999G990D00','nls_numeric_characters=,.') as desconto
                 , to_char(c.despacho,'FM9G9999G990D00','nls_numeric_characters=,.') as despacho
                 , to_char(c.pedagio,'FM9G9999G990D00','nls_numeric_characters=,.') as pedagio
                 , ((select upper(o.cod_organizacional)
                       from kss.v$organizacional o
                      where o.organizacional_id = c.organizacional_id_gerencial) || ' - ' ||
                   kss.pkg_organizacional.fnc_descricao_completa(c.organizacional_id_gerencial)) as tipo_transporte
                 , (select r.descricao_rota
                      from oper.v$rota r
                     where r.rota_id = c.rota_id) as percurso_operacional
                 , (c.cfop || ' - ' ||
                   (select p.descricao
                      from fiscal.v$produto p
                     where p.produto_id = c.num_produto) || ' - ' ||
                   to_char(c.aliquota_icms,'FM9G9999G990D09','nls_numeric_characters=,.')) as nat_operacao
                 , c.st_icms_id || ' - ' ||
                   (select si.st_icms_descricao
                      from fiscal.v$st_icms si
                     where si.st_icms_id = c.st_icms_id) as tipo_icms
                 , to_char(c.base_calculo_icms,'FM9G9999G990D00','nls_numeric_characters=,.') as base_calculo_icms
                 , (c.aliquota_icms || '%') as aliquota_icms
                 , to_char((c.valor_icms + c.valor_icms_substit + c.valor_icms_presumido),'FM9G9999G990D00','nls_numeric_characters=,.') as valor_icms
                 , c.observacao
              from fiscal.v$conhecimento c
              left join kss.v$kss_usuarios ku
                     on ku.usuario = c.user_insert
              left join kss.v$kss_usuario_lotacao kul
                     on kul.usuario = ku.usuario
              left join kss.v$centro_custo cc
                     on cc.cod_centro_custo = kul.cod_centro_custo
             where 1 = 1
			<cfif Len(Trim(arguments.conhecimento_id))>
               and c.conhecimento_id = #arguments.conhecimento_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and c.cod_pessoa_filial = #arguments.cod_pessoa_filial# 
            </cfif>
            <cfif Len(Trim(arguments.cod_departamento))>
               and c.cod_departamento = #arguments.cod_departamento#
            </cfif>
            <cfif Len(Trim(arguments.cod_setor))>
               and c.cod_setor = #arguments.cod_setor#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and c.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.num_conhecimento))>
               and c.num_conhecimento = #arguments.num_conhecimento#
            </cfif>
            <cfif Len(Trim(arguments.serie))>
               and c.serie = '#arguments.serie#'
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as notas fiscais de um conhecimento para o Espelho do Conhecimento
    -- ANDERSON 19/06/2009 - CRIADO
    --->		
    <cffunction name="get_nf_espelho_conhecimento" access="remote" returntype="query" output="true">
        <cfargument name="conhecimento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cnf.serie
                 , cnf.numero as num_nota_fiscal
                 , c.cob_cnpj_cpf || ' - ' || c.cob_razao_social as cliente
                 , to_char(cnf.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , to_char(cnf.peso_cubado,'FM9G9999G990D000','nls_numeric_characters=,.') as peso_cubado
                 , to_char(cnf.valor_total,'FM9G9999G990D00','nls_numeric_characters=,.') as valor_total
                 , to_char(cnf.valor_segurado,'FM9G9999G990D00','nls_numeric_characters=,.') as valor_segurado
                 , cnf.qtde_volume
              from fiscal.v$conhecimento c
             inner join fiscal.v$conhecimento_nota_fiscal cnf
                     on cnf.conhecimento_id = c.conhecimento_id
             where c.conhecimento_id = #arguments.conhecimento_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna os dados de uma Carta de Correo de um CTRC ao Remetente
	-- ANDERSON 23/06/2009
	--->		
	<cffunction name="get_carta_correcao_ctrc_rem" access="remote" returntype="query" output="true">
		<cfargument name="documento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.documento_id, 
                   cc.num_documento, 
                   cc.serie, 
                   cc.data_emissao, 
                   cc.cod_pessoa_filial, 
                   cc.razao_social, 
                   cc.cnpj_cpf, 
                   cc.inscricao_estadual, 
                   cc.endereco, 
                   cc.municipio, 
                   cc.uf, 
                   cc.cep, 
                   cc.quadro, 
                   cc.codigo, 
                   cc.campo, 
                   cc.valor_errado, 
                   cc.valor_correto
              from fiscal.v$carta_correcao_ctrc_rem cc
			 where cc.documento_id = #arguments.documento_id#
             order by cc.codigo asc
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna os dados para montar a rvore do Acerto de Comisso por Filial
	-- ANDERSON 25/06/2009
	--->		
	<cffunction name="get_arvore_comissao_filial" access="remote" returntype="query" output="true">
		<cfargument name="ano" required="yes">
        <cfargument name="mes" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct null as parent
                 , cp.mes||' - '||cp.ano as field
                 , cp.mes||'/'||cp.ano as descricao
                 , null as fechto_id
                 , cp.mes
                 , cp.ano
                 , null as cod_filial
                 , null as data
              from oper.v$cfilial_fechto cp
             where cp.ano = #arguments.ano#
			<cfif Len(Trim(arguments.mes))>
           	   and (cp.mes = #arguments.mes# or #arguments.mes# is null)
            </cfif>
            union all
            select cp.mes||' - '||cp.ano as parent
                 , to_char(cp.fechto_id) as field
                 , p.cliente||' - N '||cp.fechto_id as descricao
                 , cp.fechto_id
                 , cp.mes
                 , cp.ano
                 , cp.cod_filial
                 , cp.data
              from oper.v$cfilial_fechto cp
             inner join kss.v$pessoa p
                     on p.cod_pessoa = cp.cod_filial
             where cp.ano = #arguments.ano#
            <cfif Len(Trim(arguments.mes))>
           	   and (cp.mes = #arguments.mes# or #arguments.mes# is null)
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
           	   and (cp.cod_filial = #arguments.cod_pessoa_filial# or #arguments.cod_pessoa_filial# is null)
            </cfif>
            union all
            -- Em Aberto
            select distinct null as parent
                 , 'Aberto' as field
                 , 'Aberto' as descricao
                 , null as fechto_id
                 , 0 as mes
                 , 0 as ano
                 , null as cod_filial
                 , null as data
              from kss.v$unidade_negocio un
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
           	 where (un.cod_pessoa = #arguments.cod_pessoa_filial# or #arguments.cod_pessoa_filial# is null)
            </cfif>
            union all   
            select 'Aberto' as parent
                 , un.unidade_negocio as field
                 , un.unidade_negocio as descricao
                 , null as fechto_id
                 , 0 as mes
                 , 0 as ano
                 , un.cod_pessoa as cod_filial
                 , null as data
              from kss.v$unidade_negocio un
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
           	 where (un.cod_pessoa = #arguments.cod_pessoa_filial# or #arguments.cod_pessoa_filial# is null)
            </cfif>  
             order by parent desc, ano asc, mes desc, fechto_id, descricao
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna os dados de um Fechamento
	-- ANDERSON 26/06/2009
	--->		
	<cffunction name="get_fechamento_dados" access="remote" returntype="query" output="true">
		<cfargument name="fechto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cf.fechto_id
                 , cf.mes 
                 , cf.ano
                 , to_char(cf.data, 'dd/mm/yyyy hh24:mi:ss') as data
                 , cf.cod_filial
                 , p.cliente||' - N '||cf.fechto_id as descricao
                 -- CTRC
                 , cf.qtde_emitente_ctrc
                 , cf.vlr_emitente_ctrc
                 , cf.qtde_negociador_ctrc
                 , cf.vlr_negociador_ctrc
                 -- NF E/S
                 , cf.qtde_emitente_nf_es
                 , cf.vlr_emitente_nf_es
                 , cf.qtde_negociador_nf_es
                 , cf.vlr_negociador_nf_es
                 -- CRT
                 , cf.qtde_emitente_crt
                 , cf.vlr_emitente_crt
                 , cf.qtde_negociador_crt
                 , cf.vlr_negociador_crt
                 -- Total Geral Emitente
                 , (nvl(cf.qtde_emitente_ctrc,0) +nvl(cf.qtde_emitente_nf_es,0)+nvl(cf.qtde_emitente_crt,0)) as emitente_qtde_total
                 , (nvl(cf.vlr_emitente_ctrc,0) + nvl(cf.vlr_emitente_nf_es,0) + nvl(cf.vlr_emitente_crt,0)) as emitente_vlr_total
                 -- Total Geral Negociador    
                 , (nvl(cf.qtde_negociador_ctrc,0) + nvl(cf.qtde_negociador_nf_es,0) + nvl(cf.qtde_negociador_crt,0)) as negociador_qtde_total
                 , (nvl(cf.vlr_negociador_ctrc,0) + nvl(cf.vlr_negociador_nf_es,0) + nvl(cf.vlr_negociador_crt,0)) as negociador_vlr_total    
              from oper.v$cfilial_fechto cf
             inner join kss.v$pessoa p
                     on p.cod_pessoa = cf.cod_filial
              where cf.fechto_id = #arguments.fechto_id#
        </cfquery>
        <cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna os CTRCs de um Fechamento com suas respectivas comisses
	-- ANDERSON 26/06/2009
	--->		
	<cffunction name="get_ctrc_fechamento" access="remote" returntype="query" output="true">
		<cfargument name="emitente_negociador" required="yes" hint="1-Emitente, 2-Negociador">
        <cfargument name="fechto_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cfc.conhecimento_id
                 , c.num_conhecimento
                 , to_char(c.data_emissao,'dd/mm/yyyy') as data_emissao
                 , decode(c.situacao_id, 1, 'Cancelado', 'Emitido') as situacao
                 -- Base
                  , to_char(c.total_conhecimento,'FM9G9999G990D00','nls_numeric_characters=,.') as base_ve
                 , to_char(co.total_receita_fr+co.total_receita_ge,'FM9G9999G990D00','nls_numeric_characters=,.') as base_fl
                 , to_char(co.ganho_bruto,'FM9G9999G990D00','nls_numeric_characters=,.') as base_lb 
                 -- Emitente
                 , cfc.cod_filial_emitente
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = cfc.cod_filial_emitente) as emitente
                 , to_char(cfc.emitente_ve,'FM9G9999G990D00','nls_numeric_characters=,.') as emitente_ve
                 , to_char(cfc.emitente_fl,'FM9G9999G990D00','nls_numeric_characters=,.') as emitente_fl
                 , to_char(cfc.emitente_lb,'FM9G9999G990D00','nls_numeric_characters=,.') as emitente_lb
                 , cfc.emitente_fechto_id
                 -- Negociador
                 , cfc.cod_filial_negociador
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = cfc.cod_filial_negociador) as negociador     
                 , to_char(cfc.negociador_ve,'FM9G9999G990D00','nls_numeric_characters=,.') as negociador_ve
                 , to_char(cfc.negociador_fl,'FM9G9999G990D00','nls_numeric_characters=,.') as negociador_fl
                 , to_char(cfc.negociador_lb,'FM9G9999G990D00','nls_numeric_characters=,.') as negociador_lb
                 , cfc.negociador_fechto_id
                 -- Auditoria
                 , cfc.user_insert
                 , cfc.date_insert
                 , cfc.user_update
                 , cfc.date_update
              from fiscal.v$conhecimento_cfilial cfc
        inner join fiscal.v$conhecimento c
                on c.conhecimento_id = cfc.conhecimento_id
        inner join fiscal.v$conhecimento_outros_dados co
                on co.conhecimento_id = cfc.conhecimento_id
			<cfif arguments.emitente_negociador eq 1>
            	<cfif Len(Trim(arguments.fechto_id))>
                	where cfc.emitente_fechto_id = #arguments.fechto_id#
                <cfelseif Len(Trim(arguments.cod_pessoa_filial))>
                	where cfc.cod_filial_emitente = #arguments.cod_pessoa_filial#
                      and cfc.emitente_fechto_id is null
                </cfif>
            <cfelseif arguments.emitente_negociador eq 2>
            	<cfif Len(Trim(arguments.fechto_id))>
                	where cfc.negociador_fechto_id = #arguments.fechto_id#
                <cfelseif Len(Trim(arguments.cod_pessoa_filial))>
                	where cfc.cod_filial_negociador = #arguments.cod_pessoa_filial#
                      and cfc.negociador_fechto_id is null
                </cfif>
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna as Notas Fiscais de Frete de um Fechamento com suas respectivas comisses
	-- ANDERSON 26/06/2009
	--->		
	<cffunction name="get_nf_es_fechamento" access="remote" returntype="query" output="true">
		<cfargument name="emitente_negociador" required="yes" hint="1-Emitente, 2-Negociador">
        <cfargument name="fechto_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select cft.nf_es_id
                 , (select f.num_nota_fiscal
                      from fiscal.v$nf_es f
                     where f.num_nota_id = cft.nf_es_id) as num_nota_fiscal
                 , to_char(f.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , case
                      when f.cancelada = 1 then
                         'Cancelada'
                      when f.conferida = 1 then
                         'Conferida'
                      when f.emitida = 1 then
                         'Emitida'                           
                   end as situacao
                 -- Base
                 , to_char(f.calc_valor_total_nota,'FM9G9999G990D00','nls_numeric_characters=,.') as base_ve
                 , to_char(c.total_receita_fr+c.total_receita_ge,'FM9G9999G990D00','nls_numeric_characters=,.') as base_fl
                 , to_char(c.ganho2,'FM9G9999G990D00','nls_numeric_characters=,.') as base_lb
                 -- Emitente
                 , cft.cod_filial_emitente
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = cft.cod_filial_emitente) as emitente
                 , to_char(cft.emitente_ve,'FM9G9999G990D00','nls_numeric_characters=,.') as emitente_ve
                 , to_char(cft.emitente_fl,'FM9G9999G990D00','nls_numeric_characters=,.') as emitente_fl
                 , to_char(cft.emitente_lb,'FM9G9999G990D00','nls_numeric_characters=,.') as emitente_lb
                 , cft.emitente_fechto_id
                 -- Negociador
                 , cft.cod_filial_negociador
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = cft.cod_filial_negociador) as negociador     
                 , to_char(cft.negociador_ve,'FM9G9999G990D00','nls_numeric_characters=,.') as negociador_ve
                 , to_char(cft.negociador_fl,'FM9G9999G990D00','nls_numeric_characters=,.') as negociador_fl
                 , to_char(cft.negociador_lb,'FM9G9999G990D00','nls_numeric_characters=,.') as negociador_lb
                 , cft.negociador_fechto_id
                 -- Auditoria
                 , cft.user_insert
                 , cft.date_insert
                 , cft.user_update
                 , cft.date_update
              from fiscal.v$nf_es_frete_cfilial cft
        inner join fiscal.v$nf_es f
                on f.num_nota_id = cft.nf_es_id
        inner join fiscal.v$nf_es_frete c
                on f.num_nota_id = c.nf_es_id
			<cfif arguments.emitente_negociador eq 1>
            	<cfif Len(Trim(arguments.fechto_id))>
                	where cft.emitente_fechto_id = #arguments.fechto_id#
                <cfelseif Len(Trim(arguments.cod_pessoa_filial))>
                	where cft.cod_filial_emitente = #arguments.cod_pessoa_filial#
                      and cft.emitente_fechto_id is null
                </cfif>
            <cfelseif arguments.emitente_negociador eq 2>
            	<cfif Len(Trim(arguments.fechto_id))>
                	where cft.negociador_fechto_id = #arguments.fechto_id#
                <cfelseif Len(Trim(arguments.cod_pessoa_filial))>
                	where cft.cod_filial_negociador = #arguments.cod_pessoa_filial#
                      and cft.negociador_fechto_id is null
                </cfif>
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Retorna os CRTs de um Fechamento com suas respectivas comisses
	-- ANDERSON 26/06/2009
	--->		
	<cffunction name="get_crt_fechamento" access="remote" returntype="query" output="true">
		<cfargument name="emitente_negociador" required="yes" hint="1-Emitente, 2-Negociador">
        <cfargument name="fechto_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select cfc.conhecimento_id
                 , c.num_crt_completo
                 , to_char(c.emissao_data,'dd/mm/yyyy') as data_emissao
                 , case
                      when c.embarcado = 1 then
                         'Embarcado'
                      when c.conferido = 1 then
                         'Conferido'
                      when c.quitado = 1 then
                         'Quitado'
                      when c.faturado = 1 then
                         'Faturado'
                      when c.liberado_fatura = 1 then
                         'Liberado para Fatura'
                      when c.cancelado = 1 then
                         'Cancelado'
                      when c.impresso = 1 then
                         'Impresso'      
                   end as situacao
                 -- Base
                 , to_char(((c.total_custo_origem * c.cotacao) + (c.total_custo_destino * c.cotacao)),'FM9G9999G990D00','nls_numeric_characters=,.') as base_ve
                 , to_char(((c.total_custo_origem * c.cotacao) + (c.total_custo_destino * c.cotacao) - 0),'FM9G9999G990D00','nls_numeric_characters=,.') as base_lb
                 -- Emitente
                 , cfc.cod_filial_emitente
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = cfc.cod_filial_emitente) as emitente
                 , to_char(cfc.emitente_ve,'FM9G9999G990D00','nls_numeric_characters=,.') as emitente_ve
                 , to_char(cfc.emitente_lb,'FM9G9999G990D00','nls_numeric_characters=,.') as emitente_lb
                 , cfc.emitente_fechto_id
                 -- Negociador
                 , cfc.cod_filial_negociador
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = cfc.cod_filial_negociador) as negociador     
                 , to_char(cfc.negociador_ve,'FM9G9999G990D00','nls_numeric_characters=,.') as negociador_ve
                 , to_char(cfc.negociador_lb,'FM9G9999G990D00','nls_numeric_characters=,.') as negociador_lb
                 , cfc.negociador_fechto_id
                 -- Auditoria
                 , cfc.user_insert
                 , cfc.date_insert
                 , cfc.user_update
                 , cfc.date_update
              from fiscal.v$intc_conhecimento_cfilial cfc
        inner join fiscal.v$intc_conhecimento c
           on c.conhecimento_id = cfc.conhecimento_id
			<cfif arguments.emitente_negociador eq 1>
            	<cfif Len(Trim(arguments.fechto_id))>
                	where cfc.emitente_fechto_id = #arguments.fechto_id#
                <cfelseif Len(Trim(arguments.cod_pessoa_filial))>
                	where cfc.cod_filial_emitente = #arguments.cod_pessoa_filial#
                      and cfc.emitente_fechto_id is null
                </cfif>
            <cfelseif arguments.emitente_negociador eq 2>
            	<cfif Len(Trim(arguments.fechto_id))>
                	where cfc.negociador_fechto_id = #arguments.fechto_id#
                <cfelseif Len(Trim(arguments.cod_pessoa_filial))>
                	where cfc.cod_filial_negociador = #arguments.cod_pessoa_filial#
                      and cfc.negociador_fechto_id is null
                </cfif>
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os grupos liberados para EDI para o usurio conectado
	-- ANDERSON 06/07/2009 - CRIADO
	--->		
	<cffunction name="get_grupo_edi_liberado" access="remote" returntype="query" output="true">
		<cfargument name="prefixo_arquivo" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gn.grupo_id, gn.descricao
              from oper.v$grupo_negociador gn
             inner join oper.v$edi_pessoa ep
                     on ep.grupo_id = gn.grupo_id
                    and ep.prefixo_arquivo = '#arguments.prefixo_arquivo#'
             inner join oper.v$edi_usuario euo
                     on euo.grupo_id = gn.grupo_id
                    and euo.usuario = user
             order by gn.descricao
        </cfquery>
        <cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os clientes para os quais ser exportado o EDI
	-- ANDERSON 06/07/2009 - CRIADO
	--->		
	<cffunction name="get_cliente_edi" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" required="yes">
        <cfargument name="prefixo_arquivo" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cod_pessoa,
                   p.identificador || ' - ' || p.razao_social as cnpj_cpf_remetente
              from oper.v$edi_pessoa ep
             inner join oper.v$grupo_negociador_pessoa gnp
                     on gnp.grupo_id = ep.grupo_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = gnp.cod_pessoa
             where ep.grupo_id = #arguments.grupo_id#
               and ep.prefixo_arquivo = '#arguments.prefixo_arquivo#'
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o nome do procedimento a ser usado para exportar o EDI para aquele(s) cliente(s)
    -- ANDERSON 24/07/2009 - CRIADO
    --->		
    <cffunction name="get_cliente_prc_fnc" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa" required="yes">
        <cfargument name="prefixo_arquivo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select oper.pkg_edi.fnc_cliente_prc_fnc('#arguments.cod_pessoa#', '#arguments.prefixo_arquivo#') as cliente_prc_fnc from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os CTRCs a serem exportados para o EDI CONEMB
	-- ANDERSON 24/07/2009 - ALTERADO
	--->		
	<cffunction name="get_ctrc_conemb" access="remote" returntype="query" output="true">
		<cfargument name="cod_cliente_cobranca" required="yes">
        <cfargument name="num_fatura" required="no" default="">
        <cfargument name="num_natureza" required="no" default="">
        <cfargument name="datahora_inicio" required="no" default="">
        <cfargument name="datahora_fim" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id,
                   c.num_conhecimento,
                   c.rem_razao_social as remetente,
                   c.dest_razao_social as destinatario,
                   to_char(c.data_emissao, 'dd/mm/yyyy') as data_contrato,
                   c.cob_razao_social,
                   n.descricao as natureza,
                   fcr.num_docto as num_fatura
              from fiscal.v$conhecimento c
             inner join oper.v$natureza n
                     on n.num_natureza = c.num_natureza
              left join fiscal.v$conhecimento_receber cr
                     on cr.conhecimento_id = c.conhecimento_id
              left join finan.v$finan_contas_receber fcr
                     on fcr.contas_receber_id = cr.contas_receber_id
             where c.impresso is not null
               and c.cancelado is null
               and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			<cfif Len(Trim(arguments.num_fatura))>
               and fcr.num_docto = '#arguments.num_fatura#'
            <cfelse>
               and c.data_emissao between to_date('#arguments.datahora_inicio#', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.datahora_fim#', 'dd/mm/yyyy hh24:mi:ss')
				<cfif Len(Trim(arguments.num_natureza))>
					and c.num_natureza = #arguments.num_natureza#
                </cfif>
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as filiais dos CTRCs para o EDI CONEMB
	-- ANDERSON 24/07/2009 - ALTERADO
	--->		
	<cffunction name="get_filiais_ctrc_conemb" access="remote" returntype="query" output="true">
		<cfargument name="cod_cliente_cobranca" required="yes">
        <cfargument name="num_fatura" required="no" default="">
        <cfargument name="num_natureza" required="no" default="">
        <cfargument name="datahora_inicio" required="no" default="">
        <cfargument name="datahora_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct u.cod_unidade_negocio,
                   u.unidade_negocio,
                   u.cod_pessoa
              from kss.v$unidade_negocio u
             inner join fiscal.v$conhecimento c
                     on c.cod_pessoa_filial = u.cod_pessoa
              left join fiscal.v$conhecimento_receber cr
                     on cr.conhecimento_id = c.conhecimento_id
              left join finan.v$finan_contas_receber fcr
                     on fcr.contas_receber_id = cr.contas_receber_id
             where c.impresso is not null
               and c.cancelado is null
               and c.cod_cliente_cobranca in (#arguments.cod_cliente_cobranca#)
			<cfif Len(Trim(arguments.num_fatura))>
               and fcr.num_docto = '#arguments.num_fatura#'
            <cfelse>
               and c.data_emissao between to_date('#arguments.datahora_inicio#', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.datahora_fim#', 'dd/mm/yyyy hh24:mi:ss')
				<cfif Len(Trim(arguments.num_natureza))>
					and c.num_natureza = #arguments.num_natureza#
                </cfif>
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os CRTs a serem exportados para o EDI CONEMB
	-- ANDERSON 24/07/2009 - CRIADO
	--->		
	<cffunction name="get_crt_conemb" access="remote" returntype="query" output="true">
		<cfargument name="cod_pagador" required="yes">
        <cfargument name="num_fatura" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id,
                   c.num_crt_completo,
                   c.rem_nome as remetente,
                   c.dest_nome as destinatario,
                   to_char(c.emissao_data, 'dd/mm/yyyy') as data_contrato,
                   c.pag_origem_nome,
                   c.pag_destino_nome,
                   fcr.num_docto as num_fatura
              from fiscal.v$intc_conhecimento c
              left join fiscal.v$intc_conhecimento_receber cr        
                     on cr.conhecimento_id = c.conhecimento_id
              left join finan.v$finan_contas_receber fcr
                     on fcr.contas_receber_id = cr.contas_receber_id
             where c.cancelado = 0
               and (c.cod_pagador_origem in (#arguments.cod_pagador#) or c.cod_pagador_destino in (#arguments.cod_pagador#))
			<cfif Len(Trim(arguments.num_fatura))>
               and fcr.num_docto = '#arguments.num_fatura#'
            <cfelse>
               and c.emissao_data between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as filiais dos CTRCs para o EDI CONEMB
	-- ANDERSON 24/07/2009 - CRIADO
	--->		
	<cffunction name="get_filiais_crt_conemb" access="remote" returntype="query" output="true">
		<cfargument name="cod_pagador" required="yes">
        <cfargument name="num_fatura" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct u.cod_unidade_negocio,
                   u.unidade_negocio,
                   u.cod_pessoa
              from kss.v$unidade_negocio u
             inner join fiscal.v$intc_conhecimento c
                     on c.cod_pessoa_filial = u.cod_pessoa
              left join fiscal.v$intc_conhecimento_receber cr        
                     on cr.conhecimento_id = c.conhecimento_id
              left join finan.v$finan_contas_receber fcr
                     on fcr.contas_receber_id = cr.contas_receber_id
             where c.cancelado = 0
               and (c.cod_pagador_origem in (#arguments.cod_pagador#) or c.cod_pagador_destino in (#arguments.cod_pagador#))
			<cfif Len(Trim(arguments.num_fatura))>
               and fcr.num_docto = '#arguments.num_fatura#'
            <cfelse>
               and c.emissao_data between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')
            </cfif>
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o perodo dos conhecimentos a serem exportados para o EDI CONEMB
    -- ANDERSON 24/07/2009 - CRIADO
    --->		
    <cffunction name="get_periodo_conemb" access="remote" returntype="query" output="true">
        <cfargument name="cod_pagador" required="yes">
        <cfargument name="num_docto" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(min(t.min_data_emissao), 'dd/mm/yyyy hh24:mi') as datahora_inicio,
                   to_char(max(t.max_data_emissao), 'dd/mm/yyyy hh24:mi') as datahora_fim
              from (select min(c.data_emissao) as min_data_emissao,
                           max(c.data_emissao) as max_data_emissao               
                      from fiscal.v$conhecimento c
                      left join fiscal.v$conhecimento_receber cr
                             on cr.conhecimento_id = c.conhecimento_id
                      left join finan.v$finan_contas_receber fcr
                             on fcr.contas_receber_id = cr.contas_receber_id
                     where c.impresso is not null
                       and c.cancelado is null
                       and c.cod_cliente_cobranca in (#arguments.cod_pagador#)
                       and fcr.num_docto = '#arguments.num_docto#'
                     union all
                    select min(c.emissao_data) as min_data_emissao,
                           max(c.emissao_data) as max_data_emissao               
                      from fiscal.v$intc_conhecimento c
                      left join fiscal.v$intc_conhecimento_receber cr        
                             on cr.conhecimento_id = c.conhecimento_id
                      left join finan.v$finan_contas_receber fcr
                             on fcr.contas_receber_id = cr.contas_receber_id
                     where c.cancelado = 0
                       and (c.cod_pagador_origem in (#arguments.cod_pagador#) or c.cod_pagador_destino in (#arguments.cod_pagador#))
                       and fcr.num_docto = '#arguments.num_docto#') t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Gera o arquivo *.txt para o EDI CONEMB
    -- ANDERSONC 24/07/2009 - ALTERADO
    --->
    <cffunction name='get_arquivo_conemb' displayname='Gera o arquivo *.txt para o EDI CONEMB' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='COD_REMETENTE' required='yes'>
        <cfargument name='DATAHORA_INICIO' required='yes'>
        <cfargument name='DATAHORA_FIM' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='CRT_ID' required='yes'>
        <cftry>
			<cfstoredproc procedure='oper.pkg_edi.prc_conemb' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATAHORA_INICIO'  value='#arguments.DATAHORA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATAHORA_FIM'  value='#arguments.DATAHORA_FIM#:59' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CRT_ID'  value='#arguments.CRT_ID#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
            </cfstoredproc>
			<cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Arquivo gerado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>            
		<cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as faturas a serem exportados para o EDI DOCCOB
	-- ANDERSON 08/07/2009 - CRIADO
	--->		
	<cffunction name="get_faturas_doccob" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fcr.contas_receber_id as num_lancto,
                   fcr.num_docto as num_docto,
                   fcr.parc_docto,
                   fcr.cod_pessoa,
                   oper.pkg_global.fnc_busca_nome_pessoa(fcr.cod_pessoa) as cliente,
                   fcr.cod_pessoa_empresa,
                   oper.pkg_global.fnc_busca_nome_pessoa(fcr.cod_pessoa_empresa) as emissor,
                   to_char(fcr.data_emissao, 'dd/mm/yyyy') as data_emissao,
                   to_char(fcr.data_vencto, 'dd/mm/yyyy') as data_vencto,
                   count(c.conhecimento_id) as qtde_ctrc
              from fiscal.v$conhecimento c
             inner join fiscal.v$conhecimento_receber cr
                     on cr.conhecimento_id = c.conhecimento_id
             inner join finan.v$finan_contas_receber fcr
                     on fcr.contas_receber_id = cr.contas_receber_id
             where fcr.cod_pessoa in (#arguments.cod_pessoa#)
               and fcr.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim#', 'dd/mm/yyyy hh24:mi:ss')
             group by fcr.contas_receber_id,
                      fcr.cod_pessoa,
                      fcr.num_docto,
                      fcr.parc_docto,
                      fcr.cod_pessoa_empresa,
                      fcr.data_emissao,
                      fcr.data_vencto
             order by fcr.cod_pessoa
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as filiais para o EDI DOCCOB
	-- ANDERSON 08/07/2009 - CRIADO
	--->		
	<cffunction name="get_filiais_doccob" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fcr.cod_pessoa_empresa as cod_remetente,
                   count(c.conhecimento_id) as qtde_ctrc
              from fiscal.v$conhecimento c
             inner join fiscal.v$conhecimento_receber cr
                     on cr.conhecimento_id = c.conhecimento_id
             inner join finan.v$finan_contas_receber fcr
                     on fcr.contas_receber_id = cr.contas_receber_id
             where fcr.cod_pessoa in (#arguments.cod_pessoa#)
               and fcr.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim#', 'dd/mm/yyyy hh24:mi:ss')
             group by fcr.cod_pessoa_empresa
             order by fcr.cod_pessoa_empresa
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gera o arquivo *.txt para o EDI DOCCOB
	-- ANDERSONC 08/07/2009 14:22:35 - CRIADO
	--->
	<cffunction name='get_arquivo_doccob' displayname='Gera o arquivo *.txt para o EDI DOCCOB' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
			<cfstoredproc procedure='oper.pkg_edi.prc_doccob' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM# 23:59:59' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
            </cfstoredproc>
			<cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Arquivo gerado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>            
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as ocorrncias
	-- ANDERSON 09/07/2009 - CRIADO
	--->		
	<cffunction name="get_ocorrencia_proceda" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.ocorrencia_id,
                   t.descricao
              from oper.v$ocorrencia_proceda t
             order by t.descricao
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os conhecimentos a serem exportados para o EDI OCOREN
	-- ANDERSON 09/07/2009 - CRIADO
	--->		
	<cffunction name="get_conhecimentos_ocoren" access="remote" returntype="query" output="true">
		<cfargument name="ocorrencia_id" required="yes">
        <cfargument name="cod_remetente" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="opcao_envio" required="yes" hint="1-Todos os CTRCs; 2-Apenas onde  Pagador">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct c.num_conhecimento
                 , c.conhecimento_id
                 , c.cod_remetente
                 , c.rem_cnpj_cpf
                 , c.cod_pessoa_filial
                 , c.cod_destinatario
                 , c.rem_razao_social as remetente
                 , c.dest_razao_social as destinatario
                 , to_char(c.data_emissao, 'dd/mm/yyyy') as data_emissao
              from fiscal.v$conhecimento c
             where c.impresso is not null
            <cfif arguments.opcao_envio eq 1>
               and c.cod_remetente in (#arguments.cod_remetente#)
            <cfelseif arguments.opcao_envio eq 2>
               and c.cod_cliente_cobranca in (#arguments.cod_remetente#)
            </cfif>
               and c.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim#', 'dd/mm/yyyy hh24:mi:ss')
               and exists (select 'x' 
                             from oper.v$carga_ctrc ct
                            where ct.conhecimento_id = c.conhecimento_id
                              and exists (select 0
                                            from oper.v$carga_ocorrencia co
                                           where co.carga_id = ct.carga_id
                                             and co.ocorrencia_id in (#arguments.ocorrencia_id#)
                                         )
                          )
             order by c.cod_remetente
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as filiais para o EDI OCOREN
	-- ANDERSON 09/07/2009 - CRIADO
	--->		
	<cffunction name="get_filiais_ocoren" access="remote" returntype="query" output="true">
		<cfargument name="ocorrencia_id" required="yes">
        <cfargument name="cod_remetente" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="opcao_envio" required="yes" hint="1-Todos os CTRCs; 2-Apenas onde  Pagador">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct u.cod_unidade_negocio,
                   u.unidade_negocio,
                   u.cod_pessoa
              from kss.v$unidade_negocio u
             inner join fiscal.v$conhecimento c
                     on c.cod_pessoa_filial = u.cod_pessoa
             where c.impresso is not null
            <cfif arguments.opcao_envio eq 1>
               and c.cod_remetente in (#arguments.cod_remetente#)
            <cfelseif arguments.opcao_envio eq 2>
               and c.cod_cliente_cobranca in (#arguments.cod_remetente#)
            </cfif>
               and c.data_emissao between to_date('#arguments.data_inicio#', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim#', 'dd/mm/yyyy hh24:mi:ss')
               and exists (select 'x' 
                             from oper.v$carga_ctrc ct
                            where ct.conhecimento_id = c.conhecimento_id
                              and exists (select 0
                                            from oper.v$carga_ocorrencia co
                                           where co.carga_id = ct.carga_id
                                             and co.ocorrencia_id in (#arguments.ocorrencia_id#)
                                         )
                          )
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gera o arquivo *.txt para o EDI OCOREN
	-- ANDERSONC 09/07/2009 10:49:06 - CRIADO
	--->
	<cffunction name='get_arquivo_ocoren' displayname='Gera o arquivo *.txt para o EDI OCOREN' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='CONHECIMENTO' required='yes'>
		<cfargument name='OCORRENCIA' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
        <cftry>
			<cfstoredproc procedure='oper.pkg_edi.prc_ocoren' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONHECIMENTO'  value='#arguments.CONHECIMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OCORRENCIA'  value='#arguments.OCORRENCIA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM# 23:59:59' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
            </cfstoredproc>
			<cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Arquivo gerado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>            
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Retorna o contedo do arquivo *.txt do EDI gerado na sesso do usurio conectado
	-- ANDERSON 08/07/2009 - CRIADO
	--->		
	<cffunction name="get_txt_edi" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.arquivo
              from oper.oper_arquivo t
        </cfquery>
        <cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os dados para o Mapa de Produo
    -- ANDERSON 13/07/2009 - CRIADO
    --->		
    <cffunction name="get_mapa_producao" access="remote" returntype="query" output="true">
        <cfargument name="cavalo" required="no" default="">
        <cfargument name="carreta" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="cod_negociador" required="no" default="">
        <cfargument name="cod_remetente" required="no" default="">
        <cfargument name="cod_destinatario" required="no" default="">
        <cfargument name="cod_cliente_cobranca" required="no" default="">
        <cfargument name="cod_pessoa_motorista" required="no" default="">
        <cfargument name="tipo_documento" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" timeout="360">
            select mp.num_romaneio
                 , mp.cod_pessoa_filial
                 , mp.filial
                 , mp.cod_centro_custo
                 , mp.centro_custo
                 , mp.cob_razao_social
                 , to_char(mp.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , mp.hora_emissao
                 , mp.veiculo
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(mp.placa_reboque) as cod_veiculo_reboque
                 , mp.emp
                 , mp.num_conhecimento
                 , mp.nf_conhecimento
                 , mp.motorista
                 , mp.natureza
                 , mp.origem
                 , mp.origem_uf
                 , mp.destino
                 , mp.destino_uf
                 , mp.km_vazio
                 , mp.km_rota
                 , mp.peso
                 , mp.valor_frete
                 , mp.valor_sem_icms
                 , mp.pedagio
                 , mp.terceiro
                 , mp.centro_custo_gerencial
                 , mp.cod_centro_custo_gerencial
                 , mp.modalidade_veiculo
                 , case
                      when mp.valor_sem_icms > 0 then
                         round((mp.terceiro / mp.valor_sem_icms), 2)
                      else 0
                   end as fc_fe
                 , case
                      when mp.km_rota > 0 then
                         round((mp.valor_sem_icms / mp.km_rota), 2)
                      else 0
                   end as reais_km
                 ,(select kss.fnc_concat_all(kss.to_concat_expr(co.num_formulario,'/'))
                            from oper.v$contrato_transp co
                           where co.num_romaneio = mp.num_romaneio) as carta_frete
                 ,nvl((select kss.fnc_concat_all(kss.to_concat_expr(opp.descricao || ' ' || op.descricao,' / '))
                         from logistica.v$operacao op
                         left join logistica.v$operacao opp
                                on opp.operacao_id = op.operacao_id_pai
                        where op.operacao_id = mp.operacao_id),
                     (select kss.fnc_concat_all(kss.to_concat_expr(opp.descricao || ' ' || op.descricao,' / '))
                        from oper.v$romaneio_item ri
                       inner join logistica.v$operacao op
                               on op.operacao_id = ri.operacao_id
                        left join logistica.v$operacao opp
                               on opp.operacao_id = op.operacao_id_pai
                       where ri.num_romaneio = mp.num_romaneio)) as operacao
              from oper.v$mapa_producao mp
             where mp.emissao_data between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
               and mp.documento in (#PreserveSingleQuotes(arguments.tipo_documento)#)
			<cfif Len(Trim(arguments.cavalo))>
               and mp.placa_tracao = oper.pkg_veiculo.fnc_get_placa('#arguments.cavalo#')
            </cfif>
            <cfif Len(Trim(arguments.carreta))>
               and mp.placa_reboque = oper.pkg_veiculo.fnc_get_placa('#arguments.carreta#')
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and mp.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and mp.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
               and mp.organizacional_id_gerencial = #arguments.organizacional_id_gerencial#
            </cfif>
            <cfif Len(Trim(arguments.cod_negociador))>
               and mp.cod_negociador = #arguments.cod_negociador#
            </cfif>
            <cfif Len(Trim(arguments.cod_remetente))>
               and mp.cod_remetente = #arguments.cod_remetente#
            </cfif>
            <cfif Len(Trim(arguments.cod_destinatario))>
               and mp.cod_destinatario = #arguments.cod_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.cod_cliente_cobranca))>
               and mp.cod_cliente_cobranca = #arguments.cod_cliente_cobranca#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_motorista))>
               and mp.cod_pessoa_motorista = #arguments.cod_pessoa_motorista#
            </cfif>
             order by mp.cod_pessoa_filial, mp.cod_centro_custo, mp.emissao_data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
    <cffunction name="get_mapa_producao_excel" access="remote" returntype="query" output="true">
        <cfargument name="cavalo" required="no" default="">
        <cfargument name="carreta" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="cod_negociador" required="no" default="">
        <cfargument name="cod_remetente" required="no" default="">
        <cfargument name="cod_destinatario" required="no" default="">
        <cfargument name="cod_cliente_cobranca" required="no" default="">
        <cfargument name="cod_pessoa_motorista" required="no" default="">
        <cfargument name="tipo_documento" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="http_host" required="yes" default="#cgi.http_host#">
        <cfset v_tipo_docto = replace(arguments.tipo_documento,"'",'','ALL') >
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" timeout="360">        
           select gerencial.pkg_gerencial.fnc_gera_mapa_producao(  '#arguments.data_inicio#'
                                                                 , '#arguments.data_fim# 23:59:59'
                                                                 , '#arguments.cavalo#'
                                                                 , '#arguments.carreta#'
                                                                 , '#arguments.cod_pessoa_filial#'
                                                                 , '#arguments.cod_centro_custo#'
                                                                 , '#arguments.organizacional_id_gerencial#'
                                                                 , '#arguments.cod_negociador#'
                                                                 , '#arguments.cod_remetente#'
                                                                 , '#arguments.cod_destinatario#'
                                                                 , '#arguments.cod_cliente_cobranca#'
                                                                 , '#arguments.cod_pessoa_motorista#'
                                                                 , '#v_tipo_docto#'                                                                 
                                                                 , '#arguments.http_host#') as conteudo
  			 from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os dados para a Produo Acumulada
    -- ANDERSON 31/07/2009 - CRIADO
    --->		
    <cffunction name="get_producao_acumulada" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="tipo_documento" required="yes">
        <cfargument name="add_months" required="yes">
        <cfargument name="mes" required="yes">
        <cfargument name="ano" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.mes,
                   t.dia,
                   t.dia_numero,
                   t.dia_semana,
                   round(t.frota_frete, 2) as frota_frete,
                   round((sum(t.frota_frete) over(order by t.dia rows unbounded preceding)), 2) as frota_frete_acum,
                   round(((sum(t.frota_frete) over(order by t.dia rows unbounded preceding)) / t.dia_numero), 2) as frota_frete_media,
                   round(t.frota_frete_mes_ant, 2) as frota_frete_mes_ant,
                   round((t.frota_frete - nvl(t.frota_frete_mes_ant, 0)), 2) as frota_frete_diff,
                   case
                      when t.frota_frete_mes_ant > 0 then
                         round((((t.frota_frete / t.frota_frete_mes_ant) * 100) - 100), 2)
                      else 0
                   end as frota_frete_perc,
                   round(t.frota_km_vazio, 2) as frota_km_vazio,
                   round((sum(t.frota_km_vazio) over(order by t.dia rows unbounded preceding)), 2) as frota_km_vazio_acum,
                   round(t.frota_km_rota, 2) as frota_km_rota,
                   round((sum(t.frota_km_rota) over(order by t.dia rows unbounded preceding)), 2) as frota_km_rota_acum,
                   case
                      when t.frota_km_rota > 0 then
                         round((t.frota_frete / t.frota_km_rota), 4)
                      else 0
                   end as frota_reais_km,
                   case
                      when (sum(t.frota_km_rota) over(order by t.dia rows unbounded preceding)) > 0 then
                         round(((sum(t.frota_frete) over(order by t.dia rows unbounded preceding)) / (sum(t.frota_km_rota) over(order by t.dia rows unbounded preceding))), 4)
                      else 0
                   end as frota_reais_km_acum,
                   round(t.terceiro_frete, 2) as terceiro_frete,
                   round((sum(t.terceiro_frete) over(order by t.dia rows unbounded preceding)), 2) as terceiro_frete_acum,
                   round(t.terceiro, 2) as terceiro,
                   round((sum(t.terceiro) over(order by t.dia rows unbounded preceding)), 2) as terceiro_acum,
                   case
                      when t.frota_frete > 0 then
                         round((t.terceiro / t.frota_frete), 4)
                      else 0
                   end as fc_fe,
                   case
                      when (sum(t.frota_frete) over(order by t.dia rows unbounded preceding)) > 0 then
                         round(((sum(t.terceiro) over(order by t.dia rows unbounded preceding)) / (sum(t.frota_frete) over(order by t.dia rows unbounded preceding))), 4)
                      else 0
                   end as fc_fe_acum,
                   round((t.frota_frete + t.terceiro_frete), 2) as fat_total,
                   round((sum(t.frota_frete + t.terceiro_frete) over(order by t.dia rows unbounded preceding)), 2) as fat_total_acum
              from (select to_char(d.dia, 'Month') as mes,
                           d.dia,
                           extract(day from d.dia) as dia_numero,
                           to_char(d.dia, 'Dy') as dia_semana,
                           sum(case mp.modalidade_veiculo
                                  when 'FROTA' then mp.valor_sem_icms
                                  when null then mp.valor_sem_icms
                                  else 0
                               end) as frota_frete,
                           (select sum(case xp.modalidade_veiculo
                                          when 'FROTA' then xp.valor_sem_icms
                                          when null then xp.valor_sem_icms
                                          else 0
                                       end)
                              from oper.v$mapa_producao xp
                             where trunc(xp.data_emissao) = add_months(d.dia, -1)
                               and xp.documento in (#PreserveSingleQuotes(arguments.tipo_documento)#)
                            <cfif Len(Trim(arguments.cod_pessoa_filial))>
                               and xp.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                            </cfif>
                            <cfif Len(Trim(arguments.cod_centro_custo))>
                               and xp.cod_centro_custo = #arguments.cod_centro_custo#
                            </cfif>
                            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
                               and xp.organizacional_id_gerencial = #arguments.organizacional_id_gerencial#
                            </cfif>
                           ) as frota_frete_mes_ant,
                           sum(case mp.modalidade_veiculo
                                  when 'FROTA' then mp.km_vazio
                                  when null then mp.km_vazio
                                  else 0
                               end) as frota_km_vazio,
                           sum(case mp.modalidade_veiculo
                                  when 'FROTA' then mp.km_rota
                                  when null then mp.km_rota
                                  else 0
                               end) as frota_km_rota,
                           sum(case mp.modalidade_veiculo
                                  when 'FROTA' then 0
                                  when null then 0
                                  else mp.valor_frete
                               end) as terceiro_frete,
                           sum(case mp.modalidade_veiculo
                                  when 'FROTA' then 0
                                  when null then 0
                                  else mp.terceiro
                               end) as terceiro
                      from (select mp.data_emissao,
                                   mp.km_vazio,
                                   mp.km_rota,
                                   mp.valor_frete,
                                   mp.valor_sem_icms,
                                   mp.terceiro,
                                   mp.modalidade_veiculo
                              from oper.v$mapa_producao mp
                             where mp.data_emissao between to_date('#arguments.mes#/#arguments.ano#', 'mm/yyyy') and last_day(add_months(to_date('#arguments.mes#/#arguments.ano#', 'mm/yyyy'), #arguments.add_months#))
                               and mp.documento in (#PreserveSingleQuotes(arguments.tipo_documento)#)
                            <cfif Len(Trim(arguments.cod_pessoa_filial))>
                               and mp.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                            </cfif>
                            <cfif Len(Trim(arguments.cod_centro_custo))>
                               and mp.cod_centro_custo = #arguments.cod_centro_custo#
                            </cfif>
                            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
                               and mp.organizacional_id_gerencial = #arguments.organizacional_id_gerencial#
                            </cfif>
                           ) mp
                     right join
                   (select to_date('#arguments.mes#/#arguments.ano#', 'mm/yyyy') + (level - 1) as dia
                      from dual
                   connect by level <= (last_day(add_months(to_date('#arguments.mes#/#arguments.ano#', 'mm/yyyy'), #arguments.add_months#)) - trunc(to_date('#arguments.mes#/#arguments.ano#', 'mm/yyyy'), 'month') + 1)) d
                        on trunc(d.dia) = mp.data_emissao
                     group by d.dia
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os dados para o Resumo da Produo Acumulada
    -- ANDERSON 03/08/2009 - CRIADO
    --->		
    <cffunction name="get_producao_acumulada_resumo" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="tipo_documento" required="yes">
        <cfargument name="add_months" required="yes">
        <cfargument name="mes" required="yes">
        <cfargument name="ano" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.modalidade_veiculo
                 , round(sum(t.valor_frete), 2) as valor_frete
                 , round(sum(t.valor_icms), 2) as valor_icms
                 , round(sum(t.valor_icms_substit), 2) as valor_icms_substit
                 , round(sum(t.valor_icms_presumido), 2) as valor_icms_presumido
                 , round(sum(t.valor_sem_icms), 2) as valor_sem_icms
                 , round(sum(t.frete_valor), 2) frete_valor
              from (select decode(mp.modalidade_veiculo, 'AGREGADO', 'Agregados', 'FROTA', 'Frota', 'TERCEIRO', 'Terceiros', 'Frota') as modalidade_veiculo
                         , mp.valor_frete
                         , mp.valor_icms
                         , mp.valor_icms_substit
                         , mp.valor_icms_presumido
                         , mp.valor_sem_icms
                         , mp.frete_valor
                      from oper.v$mapa_producao mp
                     where mp.data_emissao between to_date('#arguments.mes#/#arguments.ano#', 'mm/yyyy') and last_day(add_months(to_date('#arguments.mes#/#arguments.ano#', 'mm/yyyy'), #arguments.add_months#))
                       and mp.documento in (#PreserveSingleQuotes(arguments.tipo_documento)#)
					<cfif Len(Trim(arguments.cod_pessoa_filial))>
                       and mp.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_centro_custo))>
                       and mp.cod_centro_custo = #arguments.cod_centro_custo#
                    </cfif>
                    <cfif Len(Trim(arguments.organizacional_id_gerencial))>
                       and mp.organizacional_id_gerencial = #arguments.organizacional_id_gerencial#
                    </cfif>
                    ) t
             group by t.modalidade_veiculo
             order by decode(t.modalidade_veiculo, 'Frota', 1, 'Agregados', 2, 'Terceiros', 3) asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as metas para a Produo Acumulada
    -- ANDERSON 03/08/2009 - CRIADO
    --->		
    <cffunction name="get_meta_faturamento" access="remote" returntype="query" output="true">
        <cfargument name="add_months" required="yes">
        <cfargument name="mes" required="yes">
        <cfargument name="ano" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.mes
                 , m.ano
                 , m.valor
              from oper.v$meta_faturamento m
             where m.mes between #arguments.mes# and #arguments.mes# + #arguments.add_months#
               and m.ano = #arguments.ano#
             order by to_number(m.mes), m.ano
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna Datas do Job de Fechamento
    -- RAFAEL 15/07/2009
    --->		
    <cffunction name="get_fechamento_datas" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select to_char(j.ultima_data, 'dd/mm/yyyy') as ultima_data
     		  	 , to_char(j.proxima_data, 'dd/mm/yyyy') as proxima_data
              from oper.v$cfilial_job j
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados para a Lista de Notas Fiscais de Servio
    -- ANDERSON 20/07/2009 - CRIADO
    --->		
    <cffunction name="get_nf_es_lista" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="cod_destinatario" required="no" default="">
        <cfargument name="num_nota_fiscal" required="no" default="">
        <cfargument name="cod_modelo" required="no" default="">
        <cfargument name="serie" required="no" default="">
        <cfargument name="subserie" required="no" default="">
        <cfargument name="emitida" required="no" default="">
        <cfargument name="cancelada" required="no" default="">
        <cfargument name="conferida" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select count(*)
                      from fiscal.v$nf_es nf2
                     inner join kss.v$organograma o
                             on o.cod_pessoa = nf2.cod_pessoa_filial
                            and o.cod_departamento = nf2.cod_departamento
                            and o.cod_setor = nf2.cod_setor
                            and o.cod_centro_custo = nf2.cod_centro_custo
                     where nf2.num_nota_id = nf.num_nota_id
                       and nf2.cod_pessoa_filial = #session.cod_pessoa#
                       and nf2.emitida = 0) as impresso
                 , nf.num_nota_id
                 , nf.num_nota_fiscal
                 , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(fcr.num_docto), '/'))
                      from fiscal.v$nf_es_receber nfr
                     inner join finan.v$finan_contas_receber fcr
                             on fcr.contas_receber_id = nfr.contas_receber_id
                     where nfr.num_nota_id = nf.num_nota_id) as num_fatura
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = nf.cod_pessoa_filial) as filial
                 , to_char(nf.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , nf.dest_razao_social
                 , nf.dest_municipio
                 , nf.dest_uf
                 , nf.calc_valor_total_nota as valor_bruto
                 , nf.serv_iss_valor as valor_iss
                 , (nf.calc_valor_icms +
                    nf.calc_valor_icms_subst +
                    nf.calc_valor_total_ipi +
                    fiscal.pkg_nf_es.fnc_valor_retencao_impostos(nf.num_nota_id)) as valor_impostos
                 , nf.valor_faturamento as valor_liquido
                 , nf.user_insert
                 , to_char(nf.date_insert, 'dd/mm/yyyy') as date_insert
                 , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(ni.descricao), '/'))
                      from fiscal.v$nf_es_it nfi
                     inner join fiscal.v$nf_item ni
                             on ni.num_nota_it_id = nfi.num_nota_it_id
                     where nfi.num_nota_id = nf.num_nota_id) as tipo_servico
                 , nf.serie
                 , to_char(nf.data_es, 'dd/mm/yyyy') as data_es
                 , nf.natureza_descricao
                 , (nf.calc_valor_icms + nf.calc_valor_icms_subst) as valor_icms
                 , nf.trp_peso_liquido
              from fiscal.v$nf_es nf
             where 1 = 1
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
               and nf.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and nf.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
               and nf.organizacional_id_gerencial = #arguments.organizacional_id_gerencial#
            </cfif>
            <cfif Len(Trim(arguments.cod_destinatario))>
               and nf.cod_destinatario = #arguments.cod_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.num_nota_fiscal))>
               and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
            </cfif>
            <cfif Len(Trim(arguments.cod_modelo))>
               and nf.cod_modelo = '#arguments.cod_modelo#'
            </cfif>
            <cfif Len(Trim(arguments.serie))>
               and nf.serie = '#arguments.serie#'
            </cfif>
            <cfif Len(Trim(arguments.subserie))>
               and nf.subserie = '#arguments.subserie#'
            </cfif>
            <cfif Len(Trim(arguments.emitida)) and arguments.emitida eq 1>
               and nf.emitida = 1
            </cfif>
            <cfif Len(Trim(arguments.cancelada))>
            	<cfif arguments.cancelada eq 0>
					and nf.cancelada = 0
				<cfelseif arguments.cancelada eq 1>
                	and nf.cancelada = 1
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.conferida)) and arguments.conferida eq 1>
               and nf.conferida = 1
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(nf.data_emissao) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(nf.data_emissao) <= '#arguments.data_fim#'
            </cfif>
             order by nf.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados para a Lista de Notas Fiscais de Frete Municipal
    -- ANDERSON 20/07/2009 - CRIADO
    --->		
    <cffunction name="get_nf_es_frete_lista" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="cod_remetente" required="no" default="">
        <cfargument name="cod_destinatario" required="no" default="">
        <cfargument name="num_nota_fiscal" required="no" default="">
        <cfargument name="cod_modelo" required="no" default="">
        <cfargument name="serie" required="no" default="">
        <cfargument name="subserie" required="no" default="">
        <cfargument name="emitida" required="no" default="">
        <cfargument name="cancelada" required="no" default="">
        <cfargument name="conferida" required="no" default="">
        <cfargument name="terceiro" required="no" default="">
        <cfargument name="tipo_pessoa" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select count(*)
                      from fiscal.v$nf_es nf2
                     inner join kss.v$organograma o
                             on o.cod_pessoa = nf2.cod_pessoa_filial
                            and o.cod_departamento = nf2.cod_departamento
                            and o.cod_setor = nf2.cod_setor
                            and o.cod_centro_custo = nf2.cod_centro_custo
                     where nf2.num_nota_id = nf.num_nota_id
                       and nf2.cod_pessoa_filial = #session.cod_pessoa#
                       and nf2.emitida = 0) as impresso
            	 , nff.nf_es_id
            	 , nf.num_nota_fiscal
                 , nff.num_romaneio
                 , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(fcr.num_docto), '/'))
                      from fiscal.v$nf_es_receber nfr
                     inner join finan.v$finan_contas_receber fcr
                             on fcr.contas_receber_id = nfr.contas_receber_id
                     where nfr.num_nota_id = nff.nf_es_id) as num_fatura
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = nf.cod_pessoa_filial) as filial
                 , to_char(nf.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(nff.placa_tracao) as cod_veiculo_tracao
                 , oper.pkg_veiculo.fnc_veiculo_modalidade(nff.placa_tracao, nff.date_insert) as modalidade
                 , nff.rem_razao_social
                 , nff.dest_razao_social
                 , nff.dest_municipio
                 , nff.dest_uf
                 , nf.calc_valor_total_nota as valor_bruto
                 , nf.serv_iss_valor as valor_iss
                 , nff.impostos as valor_impostos
                 , (nff.total_viagem - nff.impostos) as valor_liquido
                 , (select ct.valor_frete_bruto
                      from oper.v$contrato_transp ct
                     where ct.num_romaneio = nff.num_romaneio
                       and ct.data_cancelamento is null) as valor_cf
                 , nf.user_insert
                 , to_char(nf.date_insert, 'dd/mm/yyyy') as date_insert
              from fiscal.v$nf_es_frete nff
             inner join fiscal.v$nf_es nf
                     on nf.num_nota_id = nff.nf_es_id
             where 1 = 1
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
               and nf.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and nf.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
               and nf.organizacional_id_gerencial = #arguments.organizacional_id_gerencial#
            </cfif>
            <cfif Len(Trim(arguments.cod_remetente))>
               and nff.cod_remetente = #arguments.cod_remetente#
            </cfif>
            <cfif Len(Trim(arguments.cod_destinatario))>
               and nff.cod_destinatario = #arguments.cod_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.num_nota_fiscal))>
               and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
            </cfif>
            <cfif Len(Trim(arguments.cod_modelo))>
               and nf.cod_modelo = '#arguments.cod_modelo#'
            </cfif>
            <cfif Len(Trim(arguments.serie))>
               and nf.serie = '#arguments.serie#'
            </cfif>
            <cfif Len(Trim(arguments.subserie))>
               and nf.subserie = '#arguments.subserie#'
            </cfif>
            <cfif Len(Trim(arguments.emitida)) and arguments.emitida eq 1>
               and nf.emitida = 1
            </cfif>
            <cfif Len(Trim(arguments.cancelada)) and arguments.cancelada eq 1>
               and nf.cancelada = 1
            </cfif>
            <cfif Len(Trim(arguments.conferida)) and arguments.conferida eq 1>
               and nf.conferida = 1
            </cfif>
            <cfif Len(Trim(arguments.terceiro)) and arguments.terceiro eq 1>
               and exists (select 0
                             from oper.v$contrato_transp ct
                            where ct.num_romaneio = nff.num_romaneio
                              and ct.data_cancelamento is null)
				<cfif Len(Trim(arguments.tipo_pessoa))>
					and nff.cod_proprietario in (select p.cod_pessoa
                                                   from kss.v$pessoa p
                                                  where p.tipo_pessoa = #arguments.tipo_pessoa#)
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(nf.data_emissao) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(nf.data_emissao) <= '#arguments.data_fim#'
            </cfif>
             order by nf.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o rateio automtico para nota fiscal de fornecedor atravs dos itens de pedido
    -- ANDERSON 25/01/2010 - ALTERADO
    --->		
    <cffunction name="get_rateio_pedido_item" access="remote" returntype="any" output="true">
        <cfargument name="lista_pedido_item" required="yes">
        <cfargument name="lista_quantidade" required="yes">
        <cfargument name="valor" required="yes">
        <cftry>
        	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select o.cod_unidade_negocio
                      , (select un.cod_pessoa
                           from kss.v$unidade_negocio un
                          where un.cod_unidade_negocio = o.cod_unidade_negocio) as cod_pessoa
                      , (select un.unidade_negocio
                           from kss.v$unidade_negocio un
                          where un.cod_unidade_negocio = o.cod_unidade_negocio) as unidade_negocio
                      , o.cod_departamento
                      , (select d.descricao
                           from kss.v$departamento d
                          where d.cod_departamento = o.cod_departamento) as departamento
                      , o.cod_setor
                      , (select s.descricao
                           from kss.v$setor s
                          where s.cod_setor = o.cod_setor) as setor
                      , o.cod_centro_custo
                      , (select cc.centro_custo
                           from kss.v$centro_custo cc
                          where cc.cod_centro_custo = o.cod_centro_custo) as centro_custo
                      , x.organizacional_id
                      , x.percentual
                      , ((ceil((#arguments.valor# * x.percentual / 100) * 100) / 100)
                         + (nvl(lead(0) over (order by x.percentual), 1)
                            * (#arguments.valor# - sum((ceil((#arguments.valor# * x.percentual / 100) * 100) / 100)) over(order by x.percentual rows unbounded preceding))
                           )
                        ) as valor
                   from (
                         select t.cod_organograma
                              , t.organizacional_id
                              , sum(t.percentual) as percentual
                           from table(compras.pkg_compras.fnc_get_rateio_pedido_item('#arguments.lista_pedido_item#', '#arguments.lista_quantidade#')) t
                          group by t.cod_organograma
                                 , t.organizacional_id
                        ) x
                  inner join kss.v$organograma o
                          on o.cod_organograma = x.cod_organograma
                  order by x.percentual
			</cfquery>
            <cfset qr_result.erro = false>
            <cfset qr_result.mensagem = "">
        	<cfcatch>
           	 	<cfset retorno.mensagem = cfcatch>
            	<cfset retorno.erro = true>
                <cfset qr_result = retorno>
        	</cfcatch>
        </cftry>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca Modelos para as notas com base no SINTEGRA
    -- NOTAS EXPLICATIVAS
    -- ANDERSON - 17/07/2009 - ALTERADO
    --->
    <cffunction name="get_nota_modelo" displayname="Busca Modelos para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
       <cfargument name="cod_modelo" required="no" default=""/>
       <cfargument name="serie" required="no" default=""/>
       <cfargument name="documento_proprio" required="no" default="1" />
       <cfargument name="cod_pessoa" required="no" default="" />
       <cfargument name="cod_departamento" required="no" default="" />
       <cfargument name="cod_setor" required="no" default="" />
       <cfargument name="cod_centro_custo" required="no" default="" />
       <cfargument name="nfes" required="no" default="" />
       <cfargument name="agrupar" required="no" default="1" />
       <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
          select distinct ms.cod_modelo
               , smf.modelo                     
          <cfif arguments.agrupar eq 0>
               , ms.serie
               , ms.subserie
              </cfif>
            from fiscal.v$modelo_serie ms
           inner join fiscal.v$sintegra_modelo_fiscal smf
                   on smf.cod_modelo = ms.cod_modelo
           where 1 = 1
             and ms.ativo = 1
          <cfif len(trim(arguments.documento_proprio))>
             and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
          </cfif>
          <cfif Len(Trim(arguments.nfes))>
             and smf.nfes = '#arguments.nfes#' 
          </cfif>
          <cfif Len(Trim(arguments.cod_modelo))>
             and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
          </cfif>
          <cfif Len(Trim(arguments.serie))>
             and ms.serie ='#arguments.serie#'
          </cfif>
          <cfif Len(Trim(arguments.cod_departamento))>
             and ms.cod_departamento ='#arguments.cod_departamento#'
          </cfif>
          <cfif Len(Trim(arguments.cod_pessoa))>
             and ms.cod_pessoa ='#arguments.cod_pessoa#'
          </cfif>
          <cfif Len(Trim(arguments.cod_setor))>
             and ms.cod_setor ='#arguments.cod_setor#'
          </cfif>
          <cfif Len(Trim(arguments.cod_centro_custo))>
             and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
          </cfif>
          <cfif arguments.agrupar eq 1>
           group by ms.cod_modelo , smf.modelo
          </cfif>
           order by ms.cod_modelo
       </cfquery>  
       <cfreturn qr_result>
    </cffunction>   
    
    <!--- 
    -- PROPSITO 
    -- Verifica se existe uma nota fiscal de terceiro emitida com o mesmo nmero
    -- ANDERSON 22/04/2010 - CRIADO
    --->		
    <cffunction name="valida_num_nota_fiscal_terceiro" access="remote" returntype="query" output="true">
    	<cfargument name="cod_emitente" required="yes">
        <cfargument name="num_nota_fiscal" required="yes">
        <cfargument name="cod_modelo" required="yes">
        <cfargument name="serie" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nft.num_nota_fiscal
              from fiscal.v$nf_terceiro nft
             where nft.cod_emitente = #arguments.cod_emitente#
               and nft.num_nota_fiscal = #arguments.num_nota_fiscal#
               and nft.cod_modelo = '#arguments.cod_modelo#'
               and nft.serie = '#arguments.serie#'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os itens de pedido de uma nota fiscal
    -- ANDERSON 28/01/2010 - CRIADO
    --->		
    <cffunction name="get_nf_terceiro_pedido_item" access="remote" returntype="query" output="true">
        <cfargument name="num_nota_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select nfpi.num_nota_id
                 , p.pedido_id
                 , p.num_pedido
                 , to_char(p.data_pedido, 'dd/mm/yyyy') as data_pedido
                 , (select cg.rv_abbreviation
                      from compras.v$cg_ref_codes cg
                     where cg.rv_domain = 'PEDIDO SITUACAO'
                       and cg.rv_low_value = p.situacao_id
                   ) as situacao
                 , compras.pkg_compras.fnc_get_solitacao_pedido(p.pedido_id) as num_solicitacao_compra
                 , compras.pkg_compras.fnc_get_solicitante_pedido(p.pedido_id) as solicitante
                 , compras.pkg_compras.fnc_get_equipamento_pedido(p.pedido_id) as equipamento
                 , p.valor_material
                 , p.valor_atividade
                 , p.valor_total_pedido
                 , sum(nfpi.valor_utilizado) over(partition by nfpi.pedido_id) as valor_utilizado_pedido
                 , pi.pedido_item_id
                 , ct.atividade_id
                 , ct.material_id
                 , nvl(a.titulo, m.descricao_completa) as descricao_item
                 , ct.valor_unitario
                 , ct.valor_negociado
                 , ct.quantidade
                 , nfpi.quantidade as quantidade_utilizada
                 , nfpi.valor_utilizado as valor_utilizado
              from fiscal.v$nf_terceiro_pedido_item nfpi
             inner join compras.v$pedido_item pi
                     on pi.pedido_item_id = nfpi.pedido_item_id
             inner join compras.v$pedido p
                     on p.pedido_id = nfpi.pedido_id
             inner join compras.v$cotacao ct
                     on ct.cotacao_id = pi.cotacao_id
              left join manutencao.v$atividade a
                     on a.atividade_id = ct.atividade_id
              left join almoxarifado.v$material m
                     on m.material_id = ct.material_id
             where nfpi.num_nota_id = #arguments.num_nota_id#
             order by p.num_pedido
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os dados fiscais do CTRC atravs dos parmetros informados
	-- ANDERSONC 13/07/2010 - CRIADO
	--->
	<cffunction name='get_ctrc_dados_fiscais' displayname='Retorna os dados fiscais do CTRC atravs dos parmetros informados' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='PAGO_POR' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='ENTREGA_UF' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
		<cfargument name='VIAGEM_CARGA_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='UF_FILIAL' required='yes'>
		<cfargument name='NOTA_FISCAL' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_conhecimento.prc_ctrc_dados_fiscais' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#' variable='retorno.PRODUTO_ID'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAGO_POR'  value='#arguments.PAGO_POR#'  null='#iif(len(trim(arguments.PAGO_POR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_UF'  value='#arguments.COLETA_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_UF'  value='#arguments.ENTREGA_UF#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' variable='retorno.ST_ICMS_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGRA_FISCAL_ID'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_UF'  value='#arguments.COB_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VIAGEM_CARGA_ID'  value='#arguments.VIAGEM_CARGA_ID#'  null='#iif(len(trim(arguments.VIAGEM_CARGA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_FILIAL'  value='#arguments.UF_FILIAL#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CFOP' variable='retorno.CFOP' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID' variable='retorno.CFOP_ID' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO' variable='retorno.NATUREZA_OPERACAO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL' variable='retorno.FUNDAMENTACAO_LEGAL' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO_INCLUSO' variable='retorno.PEDAGIO_INCLUSO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FRETE_PROPRIO' variable='retorno.FRETE_PROPRIO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TOMADOR_UF' variable='retorno.TOMADOR_UF' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_ATIVIDADE_TOMADOR' variable='retorno.COD_ATIVIDADE_TOMADOR' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NOTA_FISCAL'  value='#arguments.NOTA_FISCAL#'  null='#iif(len(trim(arguments.NOTA_FISCAL)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o imposto ISS de um produto
    -- ANDERSON 30/08/2010 - CRIADO
    --->		
    <cffunction name="get_iss_produto" access="remote" returntype="query" output="true">
    	<cfargument name="produto_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.produto_id
                 , p.descricao as produto
                 , p.categoria_id
                 , (select pc.descricao
                      from fiscal.v$produto_categoria pc
                     where pc.categoria_id = p.categoria_id
                   ) as categoria
                 , i.imposto_aliquota
              from fiscal.v$produto p
             inner join fiscal.v$categoria_imp_retencao cir
                     on cir.categoria_id = p.categoria_id
             inner join fiscal.v$imposto i
                     on i.imposto_id = cir.imposto_id
             where p.produto_id = #arguments.produto_id#
               and i.issqn_nfes = 1
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO 
    -- Retorna todas as verses ou a ltima verso do CTRC
    -- ERICG 13/10/2010 - CRIADO
    --->		
    <cffunction name="get_ctrc_comercial_versao" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="no" default="" />
        <cfargument name="conhecimento_id" required="no" default="" />
        <cfargument name="ultima_versao" required="no" default="0" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ccv.versao_id
                 , row_number() over (order by ccv.versao_id) as num_versao
                 , ccv.conhecimento_id
                 , ccv.tabela_frete_rota_id
                 , ccv.user_insert
                 , to_char(ccv.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , ccv.user_update
                 , to_char(ccv.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
                 , ccv.site
              from fiscal.v$ctrc_comercial_versao ccv
             where 1 = 1
            <cfif Len(Trim(arguments.versao_id))>
               and ccv.versao_id = #arguments.versao_id#
            </cfif>
            <cfif Len(Trim(arguments.conhecimento_id))>
               and ccv.conhecimento_id = #arguments.conhecimento_id#
            </cfif>
            <cfif arguments.ultima_versao eq 1>
               and ccv.versao_id = (select max(ccv2.versao_id)
                                      from fiscal.v$ctrc_comercial_versao ccv2
                                     where ccv2.conhecimento_id = ccv.conhecimento_id
                                   )
            </cfif>
             order by ccv.versao_id desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>     
    
	<!--- 
    -- PROPSITO 
    -- Retorna as tarifas da verso do CTRC
    -- ERICG 13/10/2010 - CRIADO
    --->		
    <cffunction name="get_conhecimento_tarifa" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.tarifa_id
                 , ct.versao_id
                 , ct.cod_variavel
                 , v.descricao
                 , ct.taxa_id
                 , ct.valor
              from fiscal.v$conhecimento_tarifa ct
             inner join comercial.v$variavel v
                     on v.cod_variavel = ct.cod_variavel
             where ct.versao_id = #arguments.versao_id#
             order by v.ordem_exibicao, v.tipo, v.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>      
    
	<!--- 
    -- PROPSITO 
    -- Retorna todas as verses ou a ltima verso da nota fiscal de frete.
    -- ERICG 13/10/2010 - CRIADO
    --->		
    <cffunction name="get_nf_frete_comercial_versao" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="no" default="" />
        <cfargument name="nf_es_id" required="no" default="" />
        <cfargument name="ultima_versao" required="no" default="0" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nfcv.versao_id
                 , row_number() over (order by nfcv.versao_id) as num_versao
                 , nfcv.nf_es_id
                 , nfcv.tabela_frete_rota_id
                 , nfcv.user_insert
                 , to_char(nfcv.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , nfcv.user_update
                 , to_char(nfcv.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
                 , nfcv.site
              from fiscal.v$nf_frete_comercial_versao nfcv
             where 1 = 1
            <cfif Len(Trim(arguments.versao_id))>
               and nfcv.versao_id = #arguments.versao_id#
            </cfif>
            <cfif Len(Trim(arguments.nf_es_id))>
               and nfcv.nf_es_id = #arguments.nf_es_id#
            </cfif>
            <cfif arguments.ultima_versao eq 1>
               and nfcv.versao_id = (select max(nfcv2.versao_id)
                                       from fiscal.v$nf_frete_comercial_versao nfcv2
                                      where nfcv2.nf_es_id = nfcv.nf_es_id
                                    )
            </cfif>
             order by nfcv.versao_id desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>   
    
	<!--- 
    -- PROPSITO 
    -- Retorna as tarifas da verso da nota fiscal de frete.
    -- ERICG 13/10/2010 - CRIADO
    --->		
    <cffunction name="get_nf_es_frete_tarifa" access="remote" returntype="query" output="true">
    	<cfargument name="versao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nft.tarifa_id
                 , nft.versao_id
                 , nft.cod_variavel
                 , v.descricao
                 , nft.taxa_id
                 , nft.valor
              from fiscal.v$nf_es_frete_tarifa nft
             inner join comercial.v$variavel v
                     on v.cod_variavel = nft.cod_variavel
             where nft.versao_id = #arguments.versao_id#
             order by v.ordem_exibicao, v.tipo, v.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>         
   
   <!--- 
	-- PROPSITO 
	-- Busca os itens das notas fiscais para imprimi-la.
	-- Jonas  30/07/2009
	--->		
	<cffunction name="get_nf_es_it_print" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select upper(ni.descricao) as descricao
              , upper(ni.descricao_complemento) as complemento
              , ni.valor_total
              , ni.serv_iss_aliquota as iss_aliquota
              , ni.serv_iss_valor as iss_valor
              , ni.icms_aliquota
              , ni.icms_valor
              , (select count(*)
                   from fiscal.v$nf_imposto nfim
                  where nfim.num_nota_it_id = nfi.num_nota_id
                    and nfim.imposto_retido_fonte = 1) as impostos_retidos
           from fiscal.v$nf_es_it nfi
          inner join fiscal.v$nf_item ni
                  on ni.num_nota_it_id = nfi.num_nota_it_id
          where nfi.num_nota_id = #arguments.num_nota_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
   
	<!--- 
	-- PROPSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  Busca dados do localiza de notas fiscais de ES
	-- GUTO - 09/02/2007 - criado
	--->	
	<cffunction name="get_nf_es_localizar" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="no" default=""/>
		<cfargument name="dest_cnpj_cpf" required="no" default=""/>
		<cfargument name="dest_razao_social" required="no" default=""/>
		<cfargument name="data_emissao" required="no" default=""/>
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="nfse" required="no" default="0"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
         select es.num_nota_id
              , es.num_nota_fiscal
              , es.data_emissao
              , es.data_es
              , es.cod_destinatario
              , es.dest_razao_social
              , es.dest_municipio
              , es.dest_cnpj_cpf
              , es.calc_valor_total_nota
           from fiscal.v$nf_es es		
          inner join kss.v$organograma o
                  on o.cod_pessoa = es.cod_pessoa_filial
                 and o.cod_departamento = es.cod_departamento
                 and o.cod_setor = es.cod_setor
                 and o.cod_centro_custo = es.cod_centro_custo
         <cfif arguments.nfse eq 1>
          inner join nfse.v$rps_todos r
                  on r.num_nota_id = es.num_nota_id
         </cfif>
          where 1=1
         <cfif Len(Trim(arguments.cod_pessoa))>
            and o.cod_pessoa = #arguments.cod_pessoa#
         </cfif>
         <cfif Len(Trim(arguments.num_nota_fiscal))>
            and num_nota_fiscal = #arguments.num_nota_fiscal#
         </cfif>
         <cfif Len(Trim(arguments.dest_cnpj_cpf))>
            and dest_cnpj_cpf = '#arguments.dest_cnpj_cpf#'
         </cfif>
         <cfif Len(Trim(arguments.dest_razao_social))>
            and upper(dest_razao_social) like upper('#arguments.dest_razao_social#%')
         </cfif>
         <cfif Len(Trim(arguments.data_emissao))>
            and trunc(data_emissao) = '#arguments.data_emissao#'
         </cfif>
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
   
	<!--- 
	-- PROPSITO
	-- Busca dados nota fiscal ES itens
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/02/2007 - criado
	--->	
	<cffunction name="get_nf_es_it" displayname="Busca dados nota fiscal" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="yes"/>
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
         select nf.e_s as es
              , nfe.num_nota_id
              , nfe.num_nota_it_id
              , cfop
              , cfop_id
              , produto_id
              , descricao
              , descricao_complemento
              , cod_ncm
              , st_origem_id
              , st_icms_id
              , cod_unidade
              , qtde_peso
              , qtde_volume
              , qtde_metro
              , valor_em
              , valor_em_unidade
              , valor_unitario
              , valor_total
              , icms_reducao_base
              , icms_base_calculo
              , icms_aliquota
              , icms_valor
              , icms_base_calc_subst
              , icms_valor_subst
              , ipi_reducao_base
              , ipi_base_calculo
              , ipi_aliquota
              , ipi_valor
              , ni.serv_total_tributavel as servico_total_tributavel
              , ni.serv_total_nao_tributavel as servico_total_nao_tributavel
              , ni.serv_total_produto as servico_total_produto
              , ni.serv_iss_aliquota as servico_iss_aliquota
              , ni.serv_iss_deducao as servico_iss_deducao
              , ni.serv_iss_valor as servico_iss_valor
              , ni.incluir_sintegra
              , desconto_percentual
              , desconto_valor
              , incluir_estoque
              , incluir_livro_fiscal
              , pe.uf as uf_unidade_negocio
              , nf.dest_uf as uf_destinatario
           from fiscal.v$nf_es nf
          inner join kss.v$unidade_negocio f
                  on f.cod_pessoa = nf.cod_pessoa_filial
          inner join kss.v$pessoa_endereco pe
                  on pe.cod_pessoa = f.cod_pessoa
                 and pe.endereco_padrao = 1        
          inner join fiscal.v$nf_es_it nfe
                  on nfe.num_nota_id = nf.num_nota_id
          inner join fiscal.v$nf_item ni
                  on nfe.num_nota_it_id = ni.num_nota_it_id
          where nfe.num_nota_id = #arguments.num_nota_id#
         <cfif Len(Trim(arguments.cod_pessoa))>
            and f.cod_pessoa = #arguments.cod_pessoa#
         </cfif>
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

   <!--- 
	-- PROPSITO 
	-- Busca o Histrico de Nota Fiscal
	-- NOTAS EXPLICATIVAS
	-- ANDRF 23/03/2010
	--->
    <cffunction name="get_historico_nota" displayname="Busca o Histrico da Nota Fiscal" access="remote" returntype="query" output="false">
		<cfargument name="num_nota_id" displayname="Identificador da Nota Fiscal" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select oc.num_nota_id
                 , oc.ocorrencia_id
                 , nf_es_ocorrencia_id
                 , fiscal.fnc_ref_code('OCORRENCIA', oc.ocorrencia_id) as descricao_ocorrencia
                 , oc.historico
                 , oc.motivo
                 , oc.usuario
                 , to_char(oc.data_hora, 'dd/mm/yyyy hh24:mi:ss') as data_hora
              from fiscal.v$nf_es_ocorrencia oc
             where oc.num_nota_id = #arguments.num_nota_id#
             order by nf_es_ocorrencia_id
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>  
    
    <!--- 
	-- PROPSITO
	-- Busca o Tipo de Conhecimento
	-- NOTAS EXPLICATIVAS
	-- WAGNERS 30/03/2011
	--->
    <cffunction name="get_conhecimento_tipo" displayname="Busca o Tipo de Conhecimento" access="remote" returntype="query" output="false">
		<cfargument name="conhecimento_tipo_id" displayname="Identificador do tipo de conhecimento" required="no"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select conhecimento_tipo_id,
                   descricao,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from fiscal.v$conhecimento_tipo ct

             where 1=1
             <cfif isDefined("arguments.conhecimento_tipo_id") and len(trim(arguments.conhecimento_tipo_id)) >
             	and ct.conhecimento_tipo_id = #arguments.conhecimento_tipo_id#
             </cfif>
             <cfif isDefined("arguments.descricao") and len(trim(arguments.descricao)) >
             	and upper(ct.descricao) like upper('%#arguments.descricao#%')
             </cfif>
             
             order by descricao
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>
    
    
    
    <!--- 
	-- PROPSITO 
	-- Busca todos os Conhecimentos lista
	-- NOTAS EXPLICATIVAS
	-- LOUIS 13/03/2006
	--->
	<cffunction name="get_conhecimento_lista" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do sistema para o conhecimento" >
		<cfargument name="num_conhecimento" displayname="Numero do conhecimento"  >
		<cfargument name="data_inicial" displayname="Data Inicial emisso conhecimento" required="false">
		<cfargument name="data_final" displayname="Data Final emisso conhecimento" required="false">
		<cfargument name="serie" displayname="Serie" required="false">
		<cfargument name="cod_pessoa_filial" displayname="Filial" required="false">
		<cfargument name="cod_setor" displayname="Setor" required="false">
		<cfargument name="nivel_acesso"  required="false" default="0">
		<cfargument name="situacao_id"  required="false" default="0">
        <cfargument name="impresso_id"  required="false" default="">
        <cfargument name="faturado_id"  required="false" default="">
        <cfargument name="cod_centro_custo"  required="false" default="">
        <cfargument name="cnpj_cpf"  required="false" default="">
        <cfargument name="check_remetente"  required="false" default="">
        <cfargument name="check_destinatario"  required="false" default="">
        <cfargument name="check_consignatario"  required="false" default="">
        <cfargument name="check_redespacho"  required="false" default="">
        <cfargument name="check_cobranca"  required="false" default="">
		<cfquery datasource="#session.dsn#" name="qr_conhecimento_lista" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id, 
                   c.num_conhecimento, 
                   c.serie, 
                   c.num_romaneio, 
                   c.item_id,
                   to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao, 
                   c.num_produto, 
                   p.descricao,
                   
                   c.cod_pessoa_filial,
                   un.cod_unidade_negocio,
                   un.unidade_negocio as filial,

                   
                   c.cod_departamento, 
                   dp.descricao as departamento,
                   c.cod_setor, 
                   st.descricao as setor,
                   c.cod_centro_custo, 
                   cc.centro_custo as centro_custo,
            
            
                   c.cod_organograma_gerencial,
                  /* c.cod_centro_custo_gerencial || ' - ' ||c.centro_custo_gerencial as desc_centro_custo,
                   c.tipo_frete,
                   c.cod_centro_custo_gerencial,
                   c.centro_custo_gerencial,*/
            
                   c.cfop, 
                   c.cfop_id, 
                   c.natureza_operacao,
                   decode(c.pagador,0,'Remetente','Destinatrio') as pagador_descricao,
            
                   c.coleta_logradouro, 
                   c.coleta_complemento, 
                   c.coleta_bairro, 
                   c.coleta_cep, 
                   mcol.municipio coleta_municipio,
                   mcol.uf_id coleta_uf,
                   
                   c.entrega_logradouro, 
                   c.entrega_complemento, 
                   c.entrega_bairro, 
                   c.entrega_cep, 
                   ment.municipio entrega_municipio,
                   ment.uf_id entrega_uf,
                   
                   c.rem_razao_social, 
                   c.rem_endereco, 
                   c.rem_municipio, 
                   c.rem_uf, 
                   c.rem_cep, 
                   c.rem_cnpj_cpf,
                   c.rem_inscricao_estadual,
                   
                   c.dest_razao_social, 
                   c.dest_endereco, 
                   c.dest_municipio, 
                   c.dest_uf, 
                   c.dest_cep, 
                   c.dest_cnpj_cpf,
                   c.dest_inscricao_estadual,
                   
                   c.cons_razao_social, 
                   c.cons_endereco, 
                   c.cons_municipio, 
                   c.cons_uf, 
                   c.cons_cep, 
                   c.cons_cnpj_cpf,
                   c.cons_inscricao_estadual,
                   
                   c.red_razao_social, 
                   c.red_endereco, 
                   c.red_municipio, 
                   c.red_uf, 
                   c.red_cep, 
                   c.red_cnpj_cpf,
                   c.red_inscricao_estadual,
                   
                   c.cob_razao_social, 
                   c.cob_endereco, 
                   c.cob_municipio, 
                   c.cob_uf, 
                   c.cob_cep, 
                   c.cob_cnpj_cpf,
                   c.cob_inscricao_estadual,
                   
                   c.peso, 
                   c.volume, 
                   c.m3, 
                   c.frete_unitario, 
                   nvl(c.frete_peso, 0) as frete_peso, 
                   c.frete_valor, 
                   c.despacho,
                   c.ademe, 
                   c.desconto, 
                   c.sec_cat, 
                   c.gris, 
                   c.pedagio,
                   c.reducao_base_icms,
                   c.base_calculo_icms,
                   c.aliquota_icms,
                   c.valor_icms,
                   c.reducao_base_icms_substit,
                   c.base_calculo_icms_substit,
                   c.aliquota_icms_substit,
                   c.valor_icms_substit,
                   c.valor_icms_presumido,
                   c.coleta_entrega, 
                   c.impostos, 
                   c.base_calculo_iss,
                   c.aliquota_iss,
                   c.valor_iss,
                   c.total_conhecimento,
                   
                   c.num_natureza,
                   nat.descricao as natureza,
                   c.num_especie,
                   esp.descricao as especie,
                   c.cod_unidade,
                   und.unidade,
                   
                   c.st_origem_id,
                   /*c.st_origem_descricao,*/
                   c.st_icms_id,
                   /*c.st_icms_descricao,
            
                   c.tipo_venda,
                   c.modalidade,*/
            
                   c.placa,
                   c.placa_tracao,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_tracao) as cod_veiculo_tracao,
                   vuk.km hodometro,
                   /*c.placa_veiculo_modalidade as placa_veiculo,
                   c.placa_tracao_modalidade as placa_frota,*/
                   c.cod_motorista,
                   c.nome_motorista,
                   c.cod_proprietario,
                   c.prop_razao_social, 
                   c.prop_cnpj_cpf, 
                   c.prop_endereco, 
                   c.prop_uf,
                       
                   nvl2(c.cancelado, 'Inserido','Cancelado') as situacao_flag,
                   nvl2(c.impresso,'No','Sim') as impresso_flag,
                   nvl2(c.conferido,'No','Sim') as conferido_flag,
                   /*decode(c.faturado,    0, 'No', 'Sim') as faturado_flag,*/
                   decode(c.data_entrega, null, 'No', 'Sim') as comprovante_entrega,
                   c.observacao,
                   c.rodape,
                 /*  m.num_manifesto,
                   c.cod_empresa,*/
                   c.prazo_entrega,
                   c.data_entrega,
                   c.km_rota,
                   (select InitCap(crc.rv_abbreviation) as situacao_romaneio
                      from oper.v$romaneio r
                      left join oper.cg_ref_codes crc
                             on crc.rv_domain = 'ROMANEIO.SITUACAO_ID'
                            and crc.rv_low_value = r.situacao_id
                     where r.num_romaneio = c.num_romaneio) as situacao_romaneio,
                   c.conferido_por,
                   c.conferido conferido_em,
                   c.data_chegada,
                   nvl2(c.impresso,1,0) impresso,
                   case
                      when c.cancelado is null then 'Confirmado'
                      else 'Cancelado'
                   end as situacao,
                   c.placa_tracao as veiculo_prop_tipo,
                   /*decode(OPER.,11,'Frota',21,'Terceiro',23,'Agregado','','---') as veiculo_prop_tipo,*/
                   fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as notas_fiscais,
                   (select kss.fnc_concat_all(kss.to_concat_expr(to_char(cnf.ordem_compra_cliente), '/'))
                   	  from fiscal.v$conhecimento_nota_fiscal cnf
                     where cnf.conhecimento_id = c.conhecimento_id) as ordem_compra_cliente,
                   c.user_insert,
                   to_char(c.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   c.user_update,
                   c.date_update,
                   '' as num_nota_fiscal,
                   0 as peso_real,
                   0 as peso_cobrado,
                   c.cancelado,
                   '' as municipio_filial,
                   '' as usuario,
                   (select sum(valor_total)
                      from fiscal.v$conhecimento_nota_fiscal nf
                     where nf.conhecimento_id = c.conhecimento_id ) as valor_mercadorias,
                   neg.razao_social as neg_razao_social,
                   cep.fnc_municipio_uf(negend.municipio_id,'-') as neg_municipio,
                   to_number(replace(replace(ctf.cf_valor_servico, '.', ''), ',', '.')) as cf_valor_servico,
                   ctf.cf_valor_servico as valor_bruto_cf,
                   case
                      when c.frete_peso > 0 then
                         round((to_number(replace(replace(ctf.cf_valor_servico, '.', ''), ',', '.')) / c.frete_peso), 2)
                      else 0
                   end as fc_fe,
                   case
                      when c.km_rota > 0 then
                         round((c.frete_peso / c.km_rota), 2)
                      else 0
                   end as reais_km,
                   nvl2(ctf.cf_data_cancelamento,'Sim','No') as cancelada_cf,
                   ctf.cf_valor_liquido as valor_liquido_cf,
                   ctf.cf_adiant as adiantamento_cf,
                   ctf.cf_saldo_frete as saldo_cf,
                   ctf.cf_total_impostos,
                   c.modalidade,
                   c.liberado_impressao,
                   substr(c.modalidade, 0, 1) as modalidade_fat,
                   case
                      when exists (select 0
                               from fiscal.v$carta_correcao_ctrc_rem cc
                                    where cc.documento_id = c.conhecimento_id) then 1
                      else 0
                   end as carta_correcao,
                   (select kss.fnc_concat_all(kss.to_concat_expr(slc.solicitacao_carga_id,','))
                      from oper.v$romaneio_item ri
                   inner join logistica.v$viagem_carga vc
                           on vc.viagem_carga_id = ri.viagem_carga_id
                   inner join logistica.v$solicitacao_carga slc
                           on slc.solicitacao_carga_id = vc.solicitacao_carga_id
                   inner join logistica.v$operacao l
                           on l.operacao_id = slc.operacao_id
                          and l.internacional = 0
                        where ri.num_romaneio = c.num_romaneio
                          and ri.item_id = c.item_id) as solicitacao,
                   (select count(*) from oper.v$contrato_transp ct
                     where ct.num_formulario = c.num_conhecimento
                       and ct.data_cancelamento is null) as possui_cf,
                   (select sign(count(1))
                      from fiscal.v$ctrc_comercial_versao ccv
                     where ccv.conhecimento_id = c.conhecimento_id) as possui_tabela_frete,
                   dc.documento_id,
                   decode(dc.documento_id, null, 'CTRC', 'CTE') as tipo_docto,
                   ds.cod_status
              from fiscal.v$conhecimento c
             inner join fiscal.v$produto p
                     on p.produto_id = c.num_produto
             inner join kss.v$departamento dp
                     on dp.cod_departamento = c.cod_departamento
             inner join kss.v$setor st
                     on st.cod_setor = c.cod_setor
             inner join kss.v$centro_custo cc
                     on cc.cod_centro_custo = c.cod_centro_custo
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = c.cod_pessoa_filial
              left join oper.v$natureza nat
                     on nat.num_natureza = c.num_natureza
              left join oper.v$especie esp
                     on esp.num_especie = c.num_especie
              left join fiscal.v$unidade_medida und
                     on und.cod_unidade = c.cod_unidade
              left join cep.municipio mcol
                     on mcol.municipio_id = c.coleta_municipio_id
              left join cep.municipio ment
                     on ment.municipio_id = c.entrega_municipio_id
              left join kss.v$pessoa neg
                     on neg.cod_pessoa = c.cod_negociador
              left join kss.v$pessoa_endereco negend
                     on negend.cod_pessoa = c.cod_negociador
                    and negend.endereco_padrao = 1
              left join oper.v$contrato_transp ct
                     on ct.num_romaneio = c.num_romaneio
                    and ct.data_cancelamento is null
              left join oper.v$contrato_transp_form ctf
                     on ctf.documento_id = ct.lancto_id
              left join oper.v$veiculo_ultimo_km vuk
                     on vuk.placa = c.placa_tracao
              left join fiscal.documento_cte dc
                    on dc.conhecimento_id = c.conhecimento_id
              left join fiscal.v$documento_status ds
                   on ds.documento_id = dc.documento_id
              where 1 = 1
       <cfif isDefined("Arguments.conhecimento_id") and Len(Trim(Arguments.conhecimento_id))>
            and c.conhecimento_id in (#Arguments.conhecimento_id#)
       <cfelseif isDefined("Arguments.num_conhecimento") and Len(Trim(Arguments.num_conhecimento))>
            and c.num_conhecimento = #Arguments.num_conhecimento#
       <cfelseif len(trim(arguments.data_inicial)) and len(trim("arguments.data_final"))>
            and trunc(c.data_emissao) between '#arguments.data_inicial#' and '#arguments.data_final#'
       </cfif>
	   <cfif isDefined("arguments.serie") and Len(Trim(arguments.serie)) >
		   and c.serie = '#arguments.serie#'
	   </cfif>
	   <cfif isDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial)) >
		   and c.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
	   </cfif>
	   <cfif isDefined("arguments.cod_setor") and Len(Trim(arguments.cod_setor)) and (arguments.nivel_acesso eq 5) and (arguments.nivel_acesso eq 1) >
		   and c.cod_setor = #arguments.cod_setor#
	   </cfif>
	   <cfif isDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id)) >
		   and nvl2(c.cancelado,1,0) in (#arguments.situacao_id#)
	   </cfif> 
       <cfif isDefined("arguments.cod_setor") and Len(Trim(arguments.cod_setor)) and (arguments.nivel_acesso eq 5) and (arguments.nivel_acesso eq 1) >
		   and c.cod_setor = #arguments.cod_setor#
	   </cfif> 
	    <cfif isDefined("arguments.impresso_id") and Len(Trim(arguments.impresso_id))>
       	   and nvl2(c.impresso,1,0) = #arguments.impresso_id#
       </cfif>
       <cfif isDefined("arguments.faturado_id") and Len(Trim(arguments.faturado_id))>
       	   and nvl2(c.faturado,1,0) = #arguments.faturado_id#
       </cfif>
       <cfif isDefined("arguments.cod_centro_custo") and Len(Trim(arguments.cod_centro_custo)) >
		   and c.cod_centro_custo = #arguments.cod_centro_custo#
	   </cfif>  
       <cfif isDefined("arguments.conhecimento_tipo_id") and Len(Trim(arguments.conhecimento_tipo_id)) >
		   and c.conhecimento_tipo_id = #arguments.conhecimento_tipo_id#
	   </cfif>    
       <cfif isDefined("arguments.cod_remetente") and Len(Trim(arguments.cod_remetente)) >
		   and c.cod_remetente = #arguments.cod_remetente#
	   </cfif>
       <cfif Len(Trim(arguments.check_remetente)) or Len(Trim(arguments.check_destinatario)) or Len(Trim(arguments.check_consignatario)) or Len(Trim(arguments.check_redespacho)) or Len(Trim(arguments.check_cobranca))>
	   and(<cfif isDefined("arguments.check_remetente") and Len(Trim(arguments.check_remetente))>
                c.rem_cnpj_cpf = #arguments.cnpj_cpf#
           </cfif>
           <cfif isDefined("arguments.check_destinatario") and Len(Trim(arguments.check_destinatario))>
               <cfif len(trim(arguments.check_remetente))>
               	or c.dest_cnpj_cpf = #arguments.cnpj_cpf#
               <cfelse>
               	c.dest_cnpj_cpf = #arguments.cnpj_cpf# 
               </cfif>
           </cfif>
           <cfif isDefined("arguments.check_consignatario") and Len(Trim(arguments.check_consignatario))>
       		   <cfif len(trim(arguments.check_destinatario)) or len(trim(arguments.check_remetente))>
                or c.cons_cnpj_cpf = #arguments.cnpj_cpf#
           	   <cfelse>
               	c.cons_cnpj_cpf = #arguments.cnpj_cpf#
               </cfif>
		   </cfif>
           <cfif isDefined("arguments.check_redespacho") and Len(Trim(arguments.check_redespacho))>
               <cfif len(trim(arguments.check_consignatario)) or len(trim(arguments.check_destinatario)) or len(trim(arguments.check_remetente))>
                 or c.red_cnpj_cpf = #arguments.cnpj_cpf#
               <cfelse>
               	 c.red_cnpj_cpf = #arguments.cnpj_cpf#
               </cfif>	
           </cfif>
            <cfif isDefined("arguments.check_cobranca") and Len(Trim(arguments.check_cobranca))>
               <cfif len(trim(arguments.check_consignatario)) or len(trim(arguments.check_destinatario)) or len(trim(arguments.check_remetente)) or len(trim(arguments.check_redespacho))>
               or c.cob_cnpj_cpf = #arguments.cnpj_cpf#
               <cfelse>
               	c.cob_cnpj_cpf = #arguments.cnpj_cpf#
               </cfif>
           </cfif>
           )
           </cfif>
       <!--- order by c.num_conhecimento  --->
	   order by trunc(c.data_emissao)
	  </cfquery>
	   <cfreturn qr_conhecimento_lista>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a Natureza de Operao configurada para emisso de NFSE da filial
	-- RAFAEL 25/04/2011
	--->		
	<cffunction name="get_nfse_natureza" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="yes">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select p.natureza_operacao
              from nfse.v$parametro p
             where p.cod_pessoa = #arguments.cod_pessoa_filial#
        </cfquery>
	   <cfreturn qr_result>
	</cffunction> 
    
     <!--- 
	-- PROPSITO
	-- Verifica a placa do veiculo se  tracao
	-- NOTAS EXPLICATIVAS
	-- FABIOG 22/07/2011 16:20
	--->
    <cffunction name="verifica_placa_agrupamento" displayname="Verifica a placa no agrupamento" access="remote" returntype="query" output="false">
        <cfargument name="placa" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
        	select va.tracao
                 , va.articulado
              from oper.v$veiculo_agrupamento va
             inner join oper.v$veiculo_tipo_carroceria vtc
                     on vtc.agrupamento_id = va.agrupamento_id
             inner join oper.v$veiculo v
                     on v.tipo_carroceria_id = vtc.tipo_carroceria_id
             where v.placa = '#arguments.placa#'
        </cfquery>
    	<cfreturn qr_result>
    </cffunction> 
    
    <!--- 
	-- PROPSITO 
	-- Verifica se o motorista esta bloqueado para emisso do conhecimento
	-- FABIOG 30/08/2011
	--->
	
    <cffunction name="verifica_bloqueio_motorista" displayname="Verifica se o motorista esta bloqueado" access="remote" returntype="query" output="false">
		<cfargument name="cod_motorista" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select count(1) as motorista_bloqueado
              from oper.v$agreg_bloqueio_motorista v
             where v.cod_pessoa = #arguments.cod_motorista#
               and v.data_desbloqueio is null
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Verifica se o veculo esta bloqueado para emisso do conhecimento
	-- FABIOG 30/08/2011
	--->
	
    <cffunction name="verifica_bloqueio_veiculo" displayname="Verifica se o veculo esta bloqueado" access="remote" returntype="query" output="false">
		<cfargument name="placa" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select count(1) as veiculo_bloqueado
              from oper.v$agreg_bloqueio_veiculo v
             where v.veiculo_id = oper.pkg_veiculo.fnc_veiculo_id('#arguments.placa#')
               and v.data_desbloqueio is null
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca o Valor do CTRC de Diria para emisso de Carta Frete
	-- RAFAEL 23/10/2009
	--->
	<cffunction name="get_ctrc_diaria_valor" access="remote" returntype="query" output="true">
    	<cfargument name='num_conhecimento' required='yes' />
        <cfargument name='serie' required='yes' />
        <cfargument name='cod_pessoa_filial' required='yes' />
        <cfargument name='cod_departamento' required='yes' />
        <cfargument name='cod_setor' required='yes' />
        <cfargument name='cod_centro_custo' required='yes' />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
                 , c.placa_tracao
                 , c.peso
                 , c.cod_unidade
                 , c.m3
                 , c.volume
                 , c.total_conhecimento
                 , c.operacao_id
                 , logistica.pkg_operacao.fnc_descricao_completa(c.operacao_id) as operacao
                 , (select max(c2.cartao_numero) keep(dense_rank last order by ct.date_insert)
                      from repom.v$contrato ct
                     inner join repom.v$cartao c2
                             on c2.cartao_id = ct.cartao_id
                     where ct.cod_motorista = c.cod_motorista
                       and ct.data_cancelamento is null
                   ) as cartao_numero_historico
                 , to_char(c.cancelado, 'dd/mm/yyyy hh24:mi:ss') as cancelado
                 , o.tipo_servico_id
                 , o.tipo_docto_frete
              from fiscal.v$conhecimento c
             inner join logistica.v$operacao o
                     on o.operacao_id = c.operacao_id
             where c.conhecimento_tipo_id = kss.pkg_global.fnc_parametro_num(11, 'OPERACIONAL', 12, 418)
               and c.num_conhecimento = #arguments.num_conhecimento#
               and c.serie = '#arguments.serie#'
               and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               and c.cod_departamento = #arguments.cod_departamento#
               and c.cod_setor = #arguments.cod_setor#
               and c.cod_centro_custo = #arguments.cod_centro_custo#
       </cfquery>
	   <cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca o Valor do CRT de Diria para emisso de Carta Frete
	-- RAFAEL 23/10/2009
	--->
	<cffunction name="get_crt_diaria_valor" access="remote" returntype="query" output="true">
    	<cfargument name='num_conhecimento' required='yes' />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
                 , c.peso_bruto
                 , c.m3
                 , c.unidade_id as cod_unidade
                 , ((c.total_custo_origem + c.total_custo_destino) * c.cotacao_crt) as total_crt
                 , c.organizacional_id_gerencial
              from fiscal.v$intc_conhecimento c
             where 1 = 1
               and c.tipo_crt = 1
			<cfif Len(Trim(arguments.num_conhecimento))>
               and c.num_crt_completo = '#arguments.num_conhecimento#'
            </cfif>
       </cfquery>
	   <cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca estrutura organizacional
	-- GUTO 29/05/2009
	--->		
	<cffunction name="get_organizacional" access="remote" returntype="query" output="true">
    	<cfargument name="organizacional_id" required="no" default="" />
        <cfargument name="operacao_id" required="no" default="" />
        <cfargument name="multipla_consulta" required="no" default="0" hint="0-Busca de pelo ID e/ou pela operao separadamente; 1-Busca pelo ID e pela operao juntamente;" />
        <cfargument name="entrada_saida" required="no" default="" hint="0-Entrada; 1-Sada;" />
        <cfargument name="somente_ativos" required="no" default="0">
        <cfargument name="somente_folhas" required="no" default="0">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="cod_organizacional" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.organizacional_id, o.organizacional_id_pai, 
            	   upper(o.cod_organizacional) as cod_organizacional, o.descricao,
                   substr(replace(sys_connect_by_path(o.descricao, '@@'),'@@','/'),2) as descricao_completa, 
                   /*trim(substr(sys_connect_by_path(o.cod_organizacional, '.'),2)) as codigo_completo,*/
                   connect_by_isleaf as folha
              from kss.v$organizacional o
              where 1 = 1
              	<cfif len(trim(arguments.cod_organizacional))>
                 and o.cod_organizacional = '#arguments.cod_organizacional#'
                </cfif>
                <cfif len(trim(arguments.descricao))>
                 and lower(o.descricao) like lower('%#arguments.descricao#%')
                </cfif>
				<cfif arguments.multipla_consulta eq 1>
                   and (o.organizacional_id in (#arguments.organizacional_id#)
                        or (o.organizacional_id in (select op.organizacional_id
                                                     from logistica.v$operacao_organizacional op
                                                    where op.operacao_id = #arguments.operacao_id#)
                            or not exists (select op.organizacional_id
                                             from logistica.v$operacao_organizacional op
                                            where op.operacao_id = #arguments.operacao_id#)
                           )
                       )
                <cfelse>
                    <cfif Len(Trim(arguments.organizacional_id))>
                        and o.organizacional_id in (#arguments.organizacional_id#)
                    </cfif>
                    <cfif Len(Trim(arguments.operacao_id))>
                        and (o.organizacional_id in (select op.organizacional_id
                                                       from logistica.v$operacao_organizacional op
                                                      where op.operacao_id = #arguments.operacao_id#))
                    </cfif>
                </cfif>
                <cfif Len(Trim(arguments.entrada_saida))>
                    <cfif arguments.entrada_saida eq 0>
                        and o.tipo in (0,2)
                    <cfelseif arguments.entrada_saida eq 1>
                        and o.tipo in (1,2)
                    </cfif>
                </cfif>
                <cfif arguments.somente_ativos eq 1>
                   and o.ativo = 1
                </cfif>
                <cfif arguments.somente_folhas eq 1>
                   and connect_by_isleaf = 1
                </cfif>
             start with o.organizacional_id_pai = -1
            connect by prior o.organizacional_id = o.organizacional_id_pai
            order siblings by o.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca estrutura organizacional
	-- WAGNERS 30/03/2012
	--->		
	<cffunction name="get_dados_xml_nfe" access="remote" returntype="query" output="true">
        <cfargument name="cod_modelo" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	
            select nvl(case '#arguments.cod_modelo#'
                          when '55' then
                             regexp_replace(extractvalue(xmltype(a.arquivo), '//NFe/infNFe/@Id', 'xmlns="http://www.portalfiscal.inf.br/nfe"'), '^NFe', '')
                          when '57' then
                             regexp_replace(extractvalue(xmltype(a.arquivo), '//CTe/infCte/@Id', 'xmlns="http://www.portalfiscal.inf.br/cte"'), '^CTe', '')
                       end
                     , 'chave no encontrada.'
                   ) as chave
                 , case '#arguments.cod_modelo#'
                      when '55' then
                         extractvalue(xmltype(a.arquivo), '//NFe/infNFe/ide/nNF', 'xmlns="http://www.portalfiscal.inf.br/nfe"')
                      when '57' then
                         extractvalue(xmltype(a.arquivo), '//CTe/infCte/ide/nCT', 'xmlns="http://www.portalfiscal.inf.br/cte"')
                   end as num_nota_fiscal
                 , case '#arguments.cod_modelo#'
                      when '55' then
                         to_date(extractvalue(xmltype(a.arquivo), '//NFe/infNFe/ide/dEmi', 'xmlns="http://www.portalfiscal.inf.br/nfe"'), 'yyyy/mm/dd')
                      when '57' then
                         trunc(to_date(replace(extractvalue(xmltype(a.arquivo), '//CTe/infCte/ide/dhEmi', 'xmlns="http://www.portalfiscal.inf.br/cte"'), 'T', ' '), 'yyyy/mm/dd HH24:mi:ss'))
                   end as data_emissao
                 , case '#arguments.cod_modelo#'
                      when '55' then
                         extractvalue(xmltype(a.arquivo), '//NFe/infNFe/emit/CNPJ', 'xmlns="http://www.portalfiscal.inf.br/nfe"')
                      when '57' then
                         extractvalue(xmltype(a.arquivo), '//CTe/infCte/emit/CNPJ', 'xmlns="http://www.portalfiscal.inf.br/cte"')
                   end as emit_cnpj_cpf
              from integracao.v$arquivo a
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca as filiais cadastradas
	-- CRISTOFER  18/12/2006
	--->		
	<cffunction name="get_filial" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct t.cod_pessoa, p.cliente filial, p.cliente as nome
			  from kss.v$organograma t
			 inner join kss.v$pessoa p 
					 on p.cod_pessoa = t.cod_pessoa
	         order by p.cliente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
</cfcomponent>