<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de clientes" extends="_transportes.funcoes.cfc_init">
			
	<!--- 
	-- PROPSITO 
	-- Busca a empresa pela Caixa Postal
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_empresa_caixa_postal" access="remote" returntype="query" output="true">
		<cfargument name="caixa_postal" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.cnpj_cpf
              from oper.v$edi_pessoa ep
             inner join oper.v$grupo_negociador_pessoa gnp
                     on gnp.grupo_id = ep.grupo_id 
             inner join kss.v$pessoa p
                     on p.cod_pessoa = gnp.cod_pessoa         
              where ep.prefixo_arquivo = 'PREFAT'
                and upper(ep.caixa_postal_remetente) = '#arguments.caixa_postal#'
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a empresa pelo CPF / CNPJ
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_pessoa" access="remote" returntype="query" output="true">
		<cfargument name="CNPJ_CPF" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.cod_pessoa
                  ,p.tipo_pessoa
                  ,p.cnpj_cpf
                  ,p.identificador
                  ,p.inscricao_estadual
                  ,p.razao_social
                  ,p.cliente
                  ,p.cod_atividade_fiscal 
              from kss.v$pessoa p
             where p.cnpj_cpf = '#arguments.CNPJ_CPF#'
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca arquivo temporrio
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_arquivo_temp" access="remote" returntype="query" output="true">
		<cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rowid
                 , arquivo
              from oper.oper_arquivo
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca integraes do PREFAT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_integracoes" access="remote" returntype="query" output="true">
    	<cfargument name="DATA_INICIO" required="yes">
        <cfargument name="DATA_FIM" required="yes">
        <cfargument name="PREFIXO" required="yes">
		<cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select eia.cod_pessoa, 
                   p.razao_social, 
                   p.identificador,
                   to_char(eia.data_integracao, 'dd/mm/yyyy') as data_integracao, 
                   eia.imp_log_id, 
                   eia.docto_id
             from oper.v$edi_imp_arquivo eia
            inner join kss.v$pessoa p
               on p.cod_pessoa = eia.cod_pessoa   
            where trunc(eia.data_integracao) between to_date('#arguments.DATA_INICIO#','dd/mm/yyyy')
                                                 and to_date('#arguments.DATA_FIM#','dd/mm/yyyy')    
              and eia.prefixo_arquivo = '#arguments.PREFIXO#'                              
            order by eia.data_integracao
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Relatrio do PREFAT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_relatorio_edi" access="remote" returntype="query" output="true">
    	<cfargument name="IMP_LOG_ID" required="yes">
		<cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.*                  
              from (select ep.registro_id
                          ,ep.imp_log_id
                          ,ep.cod_pessoa_rem
                          ,(select p.razao_social
                             from kss.v$pessoa p
                            where p.cod_pessoa = ep.cod_pessoa_rem) as remetente
                          ,(select p.identificador
                              from kss.v$pessoa p
                             where p.cod_pessoa = ep.cod_pessoa_rem) as cnpj_remetente
                           ,ep.uf_remetente
                           ,ep.cod_pessoa_dest
                           ,(select p.razao_social
                               from kss.v$pessoa p
                              where p.cod_pessoa = ep.cod_pessoa_dest) as destinatario
                           ,(select p.identificador
                               from kss.v$pessoa p
                              where p.cod_pessoa = ep.cod_pessoa_dest) as cnpj_destinatario
                           ,ep.uf_destinatario
                           ,ep.docto_id
                           ,ep.num_nota_fiscal
                           ,to_char(ep.data_emissao, 'dd/mm/yyyy') as data_emissao
                           ,ep.caixa_postal_remetente
                           ,ep.caixa_postal_destinatario
                           , ep.especie_acond
                           ,ep.frete_valor
                           ,to_number(ep.pre_fatura_id) as pre_fatura_id
                           ,ep.peso
                           ,ep.valor_total_nota
                           ,eia.prefixo_arquivo
                      from oper.v$edi_registro ep
                inner join oper.v$edi_imp_arquivo eia
                        on eia.imp_log_id = ep.imp_log_id
                     where 1= 1
                       and eia.prefixo_arquivo = 'PREFAT'
                  order by eia.imp_log_id, ep.num_nota_fiscal) x
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca integraes do PREFAT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_nf_notfis" access="remote" returntype="query" output="true">
    	<cfargument name="NUM_NOTA_FISCAL" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select eia.cod_pessoa
                  ,p.razao_social
                  ,p.identificador
                  ,eia.data_integracao
                  ,eia.imp_log_id
                  ,eia.docto_id
                  ,er.num_nota_fiscal
                  ,to_char(er.data_emissao, 'dd/mm/yyyy') as data_emissao                  
                  ,(select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = er.cod_pessoa_rem)||' - '||er.uf_remetente as remetente
                  ,(select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = er.cod_pessoa_dest)||' - '||er.uf_destinatario as destinatario
                  ,er.especie_acond
                  ,er.peso
                  ,er.valor_total_nota
              from oper.v$edi_imp_arquivo eia
             inner join kss.v$pessoa p
                     on p.cod_pessoa = eia.cod_pessoa
             inner join oper.v$edi_registro er
                     on er.imp_log_id = eia.imp_log_id
             where er.num_nota_fiscal = #arguments.NUM_NOTA_FISCAL#
               and eia.prefixo_arquivo = 'NOTFI'
             order by eia.data_integracao
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a empresa pelo CPF / CNPJ
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_pessoa_notfis" access="remote" returntype="query" output="true">
		<cfargument name="CNPJ_CPF" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.cod_pessoa
                 , p.tipo_pessoa
                 , p.cnpj_cpf
                 , p.identificador
                 , p.inscricao_estadual
                 , p.razao_social
                 , p.cliente
                 , p.cod_atividade_fiscal
                 , ep.operacao_id 
              from kss.v$pessoa p
        inner join oper.v$grupo_negociador_pessoa gnp
                on gnp.cod_pessoa = p.cod_pessoa
        inner join oper.v$grupo_negociador gn
                on gn.grupo_id = gnp.grupo_id         
        inner join oper.v$edi_pessoa ep
                on ep.grupo_id = gn.grupo_id
               and ep.prefixo_arquivo = 'NOTFI'
             where p.cnpj_cpf = '#arguments.CNPJ_CPF#'
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Inconsitncias na importao do NOTFIS
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_inconsistencias" access="remote" returntype="query" output="true">
		<cfargument name="IMP_LOG_ID" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		   select ea.rowid,
                  ea.imp_log_id, 
                  ea.cod_pessoa,
                  p.razao_social,
                  ea.docto_id, 
                  ea.data_integracao, 
                  ea.conteudo,
                  ea.origem,
                  (select count(*)
                      from oper.v$edi_imp_inconsistencia eii
                     where eii.imp_log_id = ea.imp_log_id) inconsistencia  
             from oper.v$edi_imp_arquivo ea
        inner join kss.v$pessoa p
                on p.cod_pessoa = ea.cod_pessoa
            where ea.imp_log_id = #arguments.IMP_LOG_ID#
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Inconsitncias na importao do NOTFIS
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_relatorio_inconsistencias" access="remote" returntype="query" output="true">
		<cfargument name="IMP_LOG_ID" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		    select eii.imp_log_id,
                   eii.inconsistencia,
                   TO_CHAR(eii.date_insert, 'dd/mm/yyyy') as date_insert,
                   eia.docto_id,
                   eii.processamento,
                   kss.pkg_pessoa.fnc_get_cliente(eia.cod_pessoa) as cliente
              from oper.v$edi_imp_inconsistencia eii
        inner join oper.v$edi_imp_arquivo        eia
                on eia.imp_log_id = eii.imp_log_id
             where eii.imp_log_id = #arguments.IMP_LOG_ID#               
          order by eii.imp_log_id, eii.processamento
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as OT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_ot" access="remote" returntype="query" output="true">
    	<cfargument name="DATA_INICIO" required="yes">
        <cfargument name="DATA_FIM" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select o.ot_id
                     , o.imp_log_id
                     , to_char(o.data_criacao, 'dd/mm/yyyy') as data_criacao
                     , o.num_transporte
                     , o.tipo_transporte
                     , o.tipo_expedicao
                     , o.expedicao_percurso
                     , o.capacidade_maxima
                     , o.tipo_elemento_exp
                     /*remessas*/
                     , r.ot_remessa_id
                     , r.num_docto_venda_distr
                     , r.tipo_frete
                     , r.destino
                     , r.peso_total
                     , r.peso_liquido
                     , r.volume
                     , r.local_expedicao
                     , r.tipo_remessa
                     , r.grupo_transporte
                     , to_char(r.data_inicio, 'dd/mm/yyyy') as data_inicio_remessa
                     , to_char(r.data_termino, 'dd/mm/yyyy') as data_termino_remessa                                        
                  from oper.v$edi_ot o
            inner join oper.v$edi_ot_remessa r
                    on r.ot_id = o.ot_id
                 where 1 = 1
                   and trunc(o.data_criacao) between to_date('#arguments.DATA_INICIO#','dd/mm/yyyy')
                                                 and to_date('#arguments.DATA_FIM#','dd/mm/yyyy')            
             order by o.imp_log_id, o.ot_id, r.ot_remessa_id
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os itens da OT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_ot_itens" access="remote" returntype="query" output="true">
    	<cfargument name="OT_REMESSA_ID" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select it.ot_remessa_item_id
                     , it.num_item
                     , it.num_material
                     , it.material
                     , it.quantidade
                     , it.peso_liquido
                     , it.peso_bruto
                     , it.volume
                     , it.ean
                     , it.valor_liquido
                     , it.tipo_carregamento
                     , it.grupo_transporte
                     , it.canal_distribuicao
                     , it.centro_produtor                     
                  from oper.edi_ot_remessa_item it                    
                 where 1 = 1
                   and it.ot_remessa_id = #arguments.OT_REMESSA_ID#           
            order by it.ot_remessa_item_id
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os itinerarios da OT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_ot_itinerarios" access="remote" returntype="query" output="true">
    	<cfargument name="OT_REMESSA_ID" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select it.ot_remessa_itinerario_id
                     , it.ordem
                     , it.num_parceiro_sap
                     , it.nome_parceiro
                     , it.endereco
                     , it.cep
                     , it.municipio
                     , it.bairro
                     , it.telefone
                     , it.uf                     
                  from oper.v$edi_ot_remessa_itinerario it                    
                 where 1 = 1
                   and it.ot_remessa_id = #arguments.OT_REMESSA_ID#           
            order by it.ot_remessa_itinerario_id
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os parceiros da OT
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_ot_parceiros" access="remote" returntype="query" output="true">
    	<cfargument name="OT_ID" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select p.num_parceiro_sap
                     , p.partner_q
                     , p.uf_parceiro
                     , p.nome_parceiro
                  from oper.v$edi_ot_parceiro p
                 where 1 = 1
                   and p.ot_id = #arguments.OT_ID#
                 order by p.num_parceiro_sap                   
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as NF
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_nf" access="remote" returntype="query" output="true">
    	<cfargument name="DATA_INICIO" required="yes">
        <cfargument name="DATA_FIM" required="yes">
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select nf.nf_id
                   , nf.imp_log_id
                   , to_char(nf.data_documento, 'dd/mm/yyy') as data_documento
                   , to_char(nf.data_lancamento, 'dd/mm/yyy') as data_lancamento
                   , nf.num_formulario
                   , nf.num_nf
                   , nf.modelo_nf
                   , nf.serie_nf
                   , nf.subserie_nf
                   , nf.tipo_frete
                   , nf.destino
                   , nf.volume
                   , nf.peso_bruto
                   , nf.peso_liquido
                   , nf.valor_total
                   , nf.valor_total_imposto
                   , nf.cnpj_cpf_destinatario
                   , nf.razao_social_destinatario
                   , nf.endereco_destinatario
                   , nf.cep_destinatario
                   , nf.municipio_destinatario
                   , nf.bairro_destinatario
                   , nf.uf_destinatario
                   /*itens*/
                   , nfi.num_item
                   , nfi.num_material
                   , nfi.area_avaliacao
                   , nfi.num_lote
                   , nfi.material
                   , nfi.cfop
                   , nfi.quantidade
                   , nfi.preco_liquido
                   , nfi.valor_liquido           
                from oper.v$edi_nf nf 
          inner join oper.v$edi_nf_item nfi
                  on nfi.nf_id = nf.nf_id
               where 1 = 1
                 and trunc(nf.DATA_DOCUMENTO) between to_date('#arguments.DATA_INICIO#','dd/mm/yyyy')
                                                  and to_date('#arguments.DATA_FIM#','dd/mm/yyyy')            
                     order by nf.nf_id, nfi.num_item
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as NF
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 07/06/2010
	--->		
	<cffunction name="get_nf_detalhes" access="remote" returntype="query" output="true">
    	<cfargument name="NF_ID" required="yes">        
        <cfquery name="qr_grupo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select nf.cnpj_cpf_destinatario
                   , nf.razao_social_destinatario
                   , nf.endereco_destinatario
                   , nf.cep_destinatario
                   , nf.municipio_destinatario
                   , nf.bairro_destinatario
                   , nf.uf_destinatario                   
                from oper.v$edi_nf nf 
               where 1 = 1
                 and nf.nf_id = #arguments.NF_ID#                     
		</cfquery>
		<cfreturn qr_grupo>
	</cffunction>
    
</cfcomponent> 