<cfcomponent displayname="Componentes de consulta para controle de trfego"
		     extends="_transportes.funcoes.cfc_init">
	
	<!--- 
	-- PROPSITO 
	-- Pega o texto da pagina inicial do toquecompimenta
	-- WAGNERLV  12/03/2008
	--->		
	<cffunction name="get_texto_home" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select texto_id,
              titulo,
              texto
         from toquepimenta.v$texto_home
		</cfquery>
        <cfreturn qr_result>		
     </cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as Circulares
	-- CRISTOFER  19/04/2006
	--->		
	<cffunction name="get_circular" access="remote" returntype="query" output="true">
		<cfargument name="circular_id" required="no" default="">
		<cfargument name="ano" required="no" default="">
		<cfargument name="atual" required="no" default="0">
		<cfargument name="arquivo" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select circular_id,
				   descricao,
				   mes,
				   ano,
				   titulo,
				   resumo,
				   <cfif arguments.arquivo eq 1>
				   arquivo,
				   </cfif>
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from site.v$circular
			 where 1=1
			<cfif len(trim(arguments.circular_id))>
				and circular_id = #arguments.circular_id#
			</cfif>
			<cfif len(trim(arguments.ano))>
				and ano = #arguments.ano#
			</cfif>
			<cfif arguments.atual eq 1>
				and mes <= to_number(to_char(sysdate, 'mm'))
				and ano <= to_number(to_char(sysdate, 'yyyy'))
			</cfif>
			order by ano desc, mes desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as cotaes
	-- CRISTOFER  04/05/2006
	--->		
	<cffunction name="get_cotacao" access="remote" returntype="query" output="true">
		<cfargument name="mercado" required="no" default="">
		<cfargument name="semente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cp.produto_id,
				   cp.descricao as produto,
				   cp.unidade,
				   cp.mercado,
				   cp.semente,
				   nvl(c.venda,0) venda,
				   nvl(c.compra,0) compra,
				   c.data,
				   c.venda_a_prazo,
				   c.venda_prazo
			  from site.v$cotacao_produto cp
			  left join site.v$cotacao c
					 on cp.produto_id = c.produto_id
			 where 1=1
			 <cfif len(trim(arguments.mercado))>
			   and cp.mercado in (#arguments.mercado#)
			 </cfif>
			 <cfif len(trim(arguments.semente))>
			   and cp.semente in (#arguments.semente#)
			 </cfif>
			   and (c.cotacao_id = (select max(cotacao_id)
									  from site.v$cotacao c2
									 where c2.produto_id = c.produto_id
									   and trunc(c2.data) <= trunc(sysdate)) or c.cotacao_id is null)
			 order by cp.mercado, cp.semente, cp.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os produtos das cotacoes
	-- CRISTOFER  04/05/2006
	--->		
	<cffunction name="get_cotacao_produto" access="remote" returntype="query" output="true">
		<cfargument name="produto_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="mercado" required="no" default="">
		<cfargument name="semente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select produto_id,
				   descricao,
				   unidade,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site,
				   mercado,
				   semente
			  from site.v$cotacao_produto
			 where 1=1
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 <cfif len(trim(arguments.produto_id))>
			   and produto_id in (#arguments.produto_id#)
			 </cfif>
			 <cfif len(trim(arguments.mercado))>
			   and mercado in (#arguments.mercado#)
			 </cfif>
			 <cfif len(trim(arguments.semente))>
			   and semente in (#arguments.semente#)
			 </cfif>
			 order by mercado, semente, descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  


	
	<!--- 
	-- PROPSITO 
	-- Busca as enquetes
	-- CRISTOFER  18/04/2006
	--->		
	<cffunction name="get_enquete" access="remote" returntype="query" output="true">
		<cfargument name="enquete_id" required="no" default="">
		<cfargument name="pergunta" required="no" default="">
		<cfargument name="ativa" required="no" default="0">
		<cfargument name="passadas" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select enquete_id,
			   data_inicial,
			   data_final,
			   pergunta,
			   date_insert,
			   user_insert,
			   date_update,
			   user_update,
			   site
		  from site.v$enquete
		 where 1=1
		 <cfif len(trim(arguments.pergunta))>
		   and upper(pergunta) like upper('%#arguments.pergunta#%')
		 </cfif>
		 <cfif arguments.ativa eq 1>
		   and (trunc(data_final) <= trunc(sysdate) or data_final is null)
		   and trunc(data_inicial) >= trunc(sysdate)
		 </cfif>
		 <cfif arguments.passadas neq 1 and arguments.ativa neq 1>
		   and (trunc(data_final) >= trunc(sysdate) or data_final is null)
		 </cfif>
		 <cfif len(trim(arguments.enquete_id))>
		   and enquete_id in (#arguments.enquete_id#)
		 </cfif>
		 order by data_inicial
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as alternativas da enquete
	-- CRISTOFER  18/04/2006
	--->		
	<cffunction name="get_enquete_alternativas" access="remote" returntype="query" output="true">
		<cfargument name="enquete_id" required="no" default="">
		<cfargument name="ativa" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select a.alternativa_id,
			   a.enquete_id,
			   a.descricao,
			   e.pergunta
		  from site.v$enquete_alternativa a	
		 inner join site.v$enquete e
		         on e.enquete_id = a.enquete_id
		 where 1=1
		 <cfif len(trim(arguments.enquete_id))>
		   and a.enquete_id = #arguments.enquete_id#
		 </cfif>
		 <cfif arguments.ativa eq 1>
		   and (trunc(data_final) >= trunc(sysdate) or data_final is null)
		   and trunc(data_inicial) <= trunc(sysdate)
		 </cfif>		 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o resultado da enquete
	-- CRISTOFER  18/04/2006
	--->		
	<cffunction name="get_enquete_resultado" access="remote" returntype="query" output="true">
		<cfargument name="enquete_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select enquete_id,
			   alternativa_id,
			   alternativa,
			   total,
			   total_geral,
			   percentual
		  from site.v$enquete_resultado	
		 where 1=1
		 <cfif len(trim(arguments.enquete_id))>
		   and enquete_id = #arguments.enquete_id#
		 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as noticias cadastradas
	-- CRISTOFER  09/05/2006
	--->		
	<cffunction name="get_noticia" access="remote" returntype="query" output="true">
		<cfargument name="noticia_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="ocepar" required="no" default="">
		<cfargument name="ativa" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select noticia_id,
				   titulo,
				   data,
				   texto,
				   ocepar,
				   cod_ocepar,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site,
				   ativa
			  from site.v$noticia	
			 where 1=1
			 <cfif len(trim(arguments.noticia_id))>
			   and noticia_id in (#arguments.noticia_id#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(data) >= to_date('#arguments.data_inicial#', 'dd/mm/yyyy')
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(data) <= to_date('#arguments.data_final#', 'dd/mm/yyyy')
			 </cfif>
			 <cfif len(trim(arguments.ocepar))>
			   and ocepar = #arguments.ocepar#
			 </cfif>
			 <cfif len(trim(arguments.ativa))>
			   and ativa = #arguments.ativa#
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and upper(titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 order by data desc, noticia_id , titulo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Buscar todas as Categorias
	-- WAGNER  29/05/2006--->		
	<cffunction name="get_produto_categoria" access="remote" returntype="query" output="true">
		
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select categoria_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from toquepimenta.v$produto_categoria
              order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Buscar produtos
	-- WAGNER  29/05/2006--->		
	
	<cffunction name="get_produtos" access="remote" returntype="query" output="true">
		<cfargument name="categoria_id" required="no" default="">
		<cfargument name="produto_id" required="no" default="">
		<cfargument name="nome" required="no" default="">
		<cfargument name="inat" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.produto_id,
				p.categoria_id,
				p.nome,
				p.descricao,
				p.valor,
				p.flags,
				p.inativo,
				p.destaque,
				p.date_insert,
				p.user_insert,
				p.date_update,
				p.user_update,
				p.site,
        		c.descricao as categoria,
        		pf.url
			from toquepimenta.v$produto p 
     			inner join toquepimenta.v$produto_categoria c
             	on p.categoria_id = c.categoria_id
     			left join toquepimenta.v$produto_foto pf
            	on p.produto_id = pf.produto_id
			where 1=1 
			<cfif len(trim(arguments.categoria_id))>
				and p.categoria_id in (#arguments.categoria_id#)
			</cfif>
			<cfif len(trim(arguments.inat))>
				and p.inativo in (#arguments.inat#)
			</cfif>
			<cfif len(trim(arguments.produto_id))>
				and p.produto_id in (#arguments.produto_id#)
			</cfif>
			<cfif len(trim(arguments.nome))>
				and upper(p.nome) like upper('%#arguments.nome#%')
			</cfif>
				order by c.descricao, destaque desc, nome
			</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Buscar fotos dos produtos 
	-- WAGNER  30/05/2006--->		
	
	<cffunction name="get_produtos_foto" access="remote" returntype="query" output="true">
		<cfargument name="produto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select imagem_id,
				   produto_id,
				   nro_foto,
				   url,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			from toquepimenta.v$produto_foto
			where 1=1 
			<cfif len(trim(arguments.produto_id))>
				and produto_id in (#arguments.produto_id#)
			</cfif>
			</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Buscar Classificados
	-- WAGNER  29/05/2006--->		
	
	<cffunction name="get_classificados" access="remote" returntype="query" output="true">
		<cfargument name="classificado_id" required="no" default="">
		<cfargument name="nome" required="no" default="">
		<cfargument name="com_foto" required="no" default="">
		<cfargument name="ativo" required="no" default="0">
		<cfargument name="em_avaliacao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select classificado_id,
				   nome,
				   endereco,
				   telefone,
				   cidade,
				   email,
				   titulo,
				   texto,
				   url_imagem,
				   inicio,
				   termino,
				   com_foto,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from site.v$classificado
			where 1=1
			<cfif len(trim(arguments.classificado_id))>
				and classificado_id in (#arguments.classificado_id#)
			</cfif>
			<cfif len(trim(arguments.nome))>
				and upper(nome) like upper('%#arguments.nome#%')
			</cfif>
			<cfif arguments.ativo eq 1>
				and trunc(sysdate)>= trunc(inicio) and (trunc(sysdate)<= trunc(termino) or termino is null)
			</cfif>
			<cfif arguments.em_avaliacao eq "1">
				and inicio is null and termino is null
			</cfif>
			<cfif len(trim(arguments.com_foto))>
				and com_foto in (#arguments.com_foto#)
			</cfif>
				order by nome, titulo
			</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	
	
</cfcomponent>
