<cfcomponent>
	<!--- 
	-- PROPSITO
	-- Retorna os diagramas
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 08/07/2005 - criado
	--->	
	<cffunction name="get_diagrama" access="remote" returntype="query" output="true">
		<cfargument name="diagrama_id" required="no" default="">
		<cfargument name="titulo"      required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select diagrama_id, titulo, conteudo
			  from desenvolvimento.v$diagrama
			 where 1=1
			   <cfif Len(Trim(arguments.diagrama_id))>
			   	  and diagrama_id = #arguments.diagrama_id#
			   </cfif>
			   <cfif Len(Trim(arguments.titulo))>
			   	  and titulo like '%#arguments.titulo#%'
			   </cfif>		
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Retorna os objetos
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 08/07/2005 - criado
	--->	
	<cffunction name="get_diagrama_objeto" access="remote" returntype="query" output="true">
		<cfargument name="diagrama_id" required="no" default="">
		<cfargument name="objeto_id"   required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select objeto_id, diagrama_id, x, y, forma_id, altura, largura
			  from desenvolvimento.v$diagrama_objeto
  			 where 1=1
			   <cfif Len(Trim(arguments.diagrama_id))>
			   	  and diagrama_id = #arguments.diagrama_id#
			   </cfif>
			   <cfif Len(Trim(arguments.objeto_id))>
			   	  and objeto_id = #arguments.objeto_id#
			   </cfif>	
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna as formas
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 08/07/2005 - criado
	--->	
	<cffunction name="get_diagrama_forma" access="remote" returntype="query" output="true">
		<cfargument name="forma_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select forma_id, nome, altura_padrao, largura_padrao
			  from desenvolvimento.v$diagrama_forma
  			 where 1=1
		     <cfif Len(Trim(arguments.forma_id))>
			   and forma_id = #arguments.forma_id#
		     </cfif>
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Retorna as conexes do diagrama
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 08/07/2005 - criado
	--->	
	<cffunction name="get_diagrama_conexoes" access="remote" returntype="query" output="true">
		<cfargument name="diagrama_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select do1.objeto_id as objeto_id_1, do1.x as x1, do1.y as y1, do1.altura as altura_1, do1.largura as largura_1,
				   do2.objeto_id as objeto_id_2, do2.x as x2, do2.y as y2, do2.altura as altura_2, do2.largura as largura_2 
			  from desenvolvimento.v$diagrama_objeto_vinculo dov
			 inner join desenvolvimento.v$diagrama_objeto do1
					 on do1.objeto_id = dov.objeto_id_1
			 inner join desenvolvimento.v$diagrama_objeto do2
					 on do2.objeto_id = dov.objeto_id_2
  			 where 1=1
		     <cfif Len(Trim(arguments.diagrama_id))>
			   and diagrama_id = #arguments.diagrama_id#
		     </cfif>
		</cfquery>	
		<cfreturn qr_result>
	</cffunction>	
</cfcomponent>