<!-- KM&M Componentes -->
<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as concessionarias de pedgio
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_concessionaria" displayname="Busca as concessionarias de pedgio" access="remote" returntype="query" output="true">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct pj.cod_pessoa, pj.nome_fantasia         
			  from oper.pessoa_juridica pj 
			 inner join oper.v$pedagio_postos pp 
				on pp.cod_pessoa = pj.cod_pessoa
			 order by pj.nome_fantasia
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca as praas da concessionaria selecionada
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_pracas" displayname="Busca as praas da concessionaria selecionada" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_concessionaria" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#"  username="#session.usuario#" password="#session.senha#">
			select distinct pp.posto_pedagio_id, pp.descricao
			  from oper.v$pedagio_historico_preco php1 
			 inner join oper.v$pedagio_postos pp 
					 on php1.posto_pedagio_id = pp.posto_pedagio_id               
			 where pp.cod_pessoa =  #arguments.cod_pessoa_concessionaria#
			   and pp.referencia_id is not null
			 order by pp.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
		
	<!--- 
	-- PROPSITO 
	-- Encontra o valor mximo para o pedgio que est sendo lanado.
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_valor_pedagio" displayname="Encontra o valor mximo para o pedgio que est sendo lanado." access="remote" returntype="struct" output="true">
		<cfargument name="posto_pedagio_id" required="yes" />
		<cfargument name="placa" required="yes" />
		<cfargument name="data_hora" required="yes" />
	
		<cfset retorno = StructNew()>
		<cfset retorno.num_eixos = 0>
		<cfset retorno.valor_pedagio = 0>
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pedagio_dml.prc_valor_pedagio" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric"  dbvarname="p_posto_pedagio_id" value="#arguments.posto_pedagio_id#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  dbvarname="p_data" value="#arguments.data_hora#">
				<cfprocparam type="in" cfsqltype="cf_sql_varchar"  dbvarname="p_placa" value="#arguments.placa#">
				<cfprocparam type="out" cfsqltype="cf_sql_numeric" dbvarname="p_num_eixos" variable="retorno.num_eixos">
				<cfprocparam type="out" cfsqltype="cf_sql_float"   dbvarname="p_valor_pedagio" variable="retorno.valor_pedagio_real">
				<cfprocparam type="out" cfsqltype="cf_sql_float"   dbvarname="p_valor_maximo" variable="retorno.valor_pedagio">
			</cfstoredproc>
		<cfcatch>
			<cfdump var="#cfcatch#">
			<cfset retorno.num_eixos = 0>
			<cfset retorno.valor_pedagio = -5>		
		</cfcatch>
		</cftry>		
		<cfreturn retorno>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca se o lanamento j foi efetuado.
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_lancamento" displayname="Busca se o lanamento j foi efetuado." access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes" />
		<cfargument name="data_hora" required="yes" />
		<cfargument name="posto_pedagio_id" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select pl.lancto_id,pl.user_insert as usuario,pl.date_insert
			  from oper.v$pedagio_lancto pl  
			 where pl.placa = '#arguments.placa#' 
			   and pl.posto_pedagio_id = #arguments.posto_pedagio_id#
			   and to_date(to_char(pl.data,'dd/mm/yyyy hh24:mi'),'dd/mm/yyyy hh24:mi') = to_date('#arguments.data_hora#','dd/mm/yyyy hh24:mi')	
		</cfquery>
		<cfreturn qr_result>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos em aberto do usurio.
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_lancamentos_abertos" displayname="Busca todos os lanamentos em aberto do usurio" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no" />
		<cfif isDefined("arguments.cod_funcionario")>
			<cfquery name="qr_func" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" timeout="25">
				select decode(oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_funcionario#))
					   as cod_funcionario,
					   decode(oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#))  as cod_pessoa
				   from dual
			</cfquery>
		</cfif>
		
		<cfquery datasource="#session.dsn#" name="qr_lancamentos" username="#session.usuario#" password="#session.senha#">
			SELECT 'Pedgio' as tipo, 1 as tipo_id, pl.lancto_id, pp.descricao as historico,         
				   pl.placa, 
				   to_char(pl.data,'dd/mm/yyyy hh24:mi') as data, to_char(pl.data,'HH24:mi') as hora,
                   pl.valor_tarifa as valor, 
				   pl.date_insert, pl.user_insert as usuario, 
				   pl.categoria, pp.cod_pessoa as concessionaria, pl.posto_pedagio_id
			  FROM oper.v$pedagio_lancto pl,         
				   oper.v$pedagio_postos pp          
			 WHERE pl.user_insert = user
			   and pp.posto_pedagio_id = pl.posto_pedagio_id          
			   and not exists(select *                      
								FROM oper.v$viagem_relacao pr                     
							   WHERE pr.relacao_id = pl.relacao_id)  
							   
			<cfif isDefined("arguments.cod_funcionario")>
				union  			
			
				SELECT 'Pedgio' as tipo, 1 as tipo_id, pl.lancto_id, pp.descricao as historico,         
					   pl.placa, to_char(pl.data,'dd/mm/yyyy hh24:mi') as data,
					   to_char(pl.data,'HH24:mi') as hora,pl.valor_tarifa as valor, 
					   pl.date_insert, pl.user_insert as usuario, 
					   pl.categoria, pp.cod_pessoa as concessionaria, pl.posto_pedagio_id
				  FROM oper.v$pedagio_lancto pl,         
					   oper.v$pedagio_postos pp          
				 WHERE upper(pl.user_insert) in ('RASTREADOR','INTEGRACAO')
				   and pl.cod_pessoa = #qr_func.cod_pessoa#
				   and pp.posto_pedagio_id = pl.posto_pedagio_id          
				   and pl.relacao_id is null and not exists(select *                      
															  FROM oper.v$viagem_relacao pr                     
															 WHERE pr.relacao_id = pl.relacao_id) 		
				union  
				
				select 'Nota/Recibo' as tipo, 2 as tipo_id, vr.num_recibo_viagem as lancto_id,          
					   prod.descricao || '-' || complemento as historico,          
					   vr.placa,          
					   to_char(vr.data,'dd/mm/yyyy hh24:mi') as data, to_char(vr.data,'HH24:mi') as hora, vr.valor, vr.date_insert, 
					   vr.user_insert as usuario, 
					   0 as categoria, 0 as concessionaria, 0 as posto_pedagio_id  
				  from oper.v$viagem_recibo vr, oper.v$setor_produto prod   
				 where vr.user_insert in ('RASTREADOR','INTEGRACAO')
				   and vr.cod_pessoa = #qr_func.cod_pessoa#
				   and prod.produto_id = vr.produto_id     
				   and vr.relacao_id is null  
				   and not exists(select *  
									FROM oper.v$viagem_relacao pr  
								   WHERE pr.relacao_id = vr.relacao_id)
			<cfelse>								   															 
				union  
				select 'Nota/Recibo' as tipo, 2 as tipo_id, vr.num_recibo_viagem as lancto_id,          
					   prod.descricao || '-' || complemento as historico,          
					   vr.placa,          
					   to_char(vr.data,'dd/mm/yyyy hh24:mi') as data, to_char(vr.data,'HH24:mi') as hora, vr.valor, vr.date_insert , 
					   vr.user_insert as usuario, 
					   0 as categoria, 0 as concessionaria, 0 as posto_pedagio_id  
				  from oper.v$viagem_recibo vr, oper.v$setor_produto prod   
				 where vr.user_insert = 'RASTREADOR' 
				   and vr.relacao_id is null  
				   and vr.cod_pessoa = (SELECT cod_pessoa
										  FROM oper.v$pedagio_lancto pl   
										 WHERE upper(pl.user_insert) = user         
												and not exists(select * 
																 FROM oper.v$viagem_relacao pr 
																WHERE pr.relacao_id = pl.relacao_id)  
										union                                 
										
										SELECT cod_pessoa
										  FROM oper.v$viagem_recibo pl   
										 WHERE upper(pl.user_insert) = user         
										   and not exists(select * 
															FROM oper.v$viagem_relacao pr 
														   WHERE pr.relacao_id = pl.relacao_id))   
										   and prod.produto_id = vr.produto_id     
										   and not exists(select *  
															FROM oper.v$viagem_relacao pr  
														   WHERE pr.relacao_id = vr.relacao_id)
			</cfif>											
	
			union  
			
			select 'Nota/Recibo' as tipo, 2 as tipo_id, vr.num_recibo_viagem as lancto_id,          
				   prod.descricao || '-' || complemento as historico,          
				   vr.placa,          
				   to_char(vr.data,'dd/mm/yyyy hh24:mi') as data, to_char(vr.data,'HH24:mi') as hora, vr.valor, 
				   vr.date_insert , vr.user_insert as usuario, 
				   0 as categoria, 0 as concessionaria, 0 as posto_pedagio_id  
			  from oper.v$viagem_recibo vr, oper.v$setor_produto prod   
			 where vr.user_insert = user 
			   and prod.produto_id = vr.produto_id     
			   and vr.relacao_id is null   
			   and not exists(select *  
								FROM oper.v$viagem_relacao pr  
							   WHERE pr.relacao_id = vr.relacao_id)  
			ORDER BY 6 desc                  
		</cfquery> 
		<cfreturn qr_lancamentos>
	</cffunction>			
	
	<!--- 
	-- PROPSITO 
	-- Busca o Cdigo do funcionrio caso o usurio que esteja fazendo o lanamento tenha o iniciado uma relao
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_funcionario_em_aberto" displayname="Busca o Cdigo do funcionrio caso o usurio que esteja fazendo o lanamento tenha o iniciado uma relao" access="remote" returntype="numeric" output="true">
		<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
			select distinct cod_funcionario 
			  from (SELECT oper.pkg_global.fnc_get_cod_funcionario(pl.cod_pessoa) as cod_funcionario
					  FROM oper.v$pedagio_lancto pl,         
						   oper.v$pedagio_postos pp          
					 WHERE pl.user_insert = user
					   and pp.posto_pedagio_id = pl.posto_pedagio_id          
					   and not exists(select *                      
										FROM oper.v$viagem_relacao pr                     
									   WHERE pr.relacao_id = pl.relacao_id) 
					union  
						
				   select oper.pkg_global.fnc_get_cod_funcionario(vr.cod_pessoa) as cod_funcionario
					 from oper.v$viagem_recibo vr, oper.v$setor_produto prod   
					where vr.user_insert = user 
					  and prod.produto_id = vr.produto_id     
					  and vr.relacao_id is null   
					  and not exists(select *  
									   FROM oper.v$viagem_relacao pr  
									  WHERE pr.relacao_id = vr.relacao_id)) 		
		</cfquery>
		<cfif qr_funcionario.RecordCount gt 0>
			<cfreturn val(qr_funcionario.cod_funcionario)>
		<cfelse>		
			<cfreturn 0>
		</cfif>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos da Relao ou da ltima relao
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_lancamentos_relacao" displayname="Busca todos os lanamentos da Relao ou da ltima relao" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes" />
		<cfargument name="cod_funcionario" required="no" />
		<cfargument name="relacao_id" required="no" />
		<cfif isdefined("arguments.cod_funcionario") and Len(Trim(arguments.cod_funcionario))>
			<cfquery name="qr_func" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" timeout="25">
				select decode(oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)) as cod_pessoa
				  from dual
			</cfquery>
			<cfset arguments.cod_pessoa = qr_func.COD_PESSOA>
		</cfif>
	
		<cfquery name="qr_nome_func" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" timeout="25">
			select oper.pkg_global.fnc_busca_nome_pessoa(#arguments.cod_pessoa#) as nome_funcionario,
				   oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_pessoa#) as cod_funcionario
			  from dual
		</cfquery>
		
		<cfquery datasource="#session.dsn#" name="qr_lancamentos" username="#session.usuario#" password="#session.senha#">
			SELECT /*+FIRST_ROWS */ 
                   'Pedgio' as tipo, 
            	   pl.lancto_id, 
                   pp.descricao as historico,                         
				   (substr(pl.placa,1,3)||'-'||substr(pl.placa,4,7)) as placa,                                   
				   to_char(pl.data,'dd/mm/yyyy hh24:mi:ss') as data, 
                   pl.valor_tarifa as valor, 
                   to_char(pl.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert, 
                   pl.relacao_id, 
				   vr.user_insert as usuario_relacao, 
                   to_char(vr.date_insert,'dd/mm/yyyy hh24:mi:ss') as data_relacao,
				   '#qr_nome_func.NOME_FUNCIONARIO#' as nome_funcionario,
				   '#qr_nome_func.COD_FUNCIONARIO#' as cod_funcionario,
				   pl.user_insert as lancado_por
			  FROM oper.v$pedagio_lancto pl,
				   oper.v$pedagio_postos pp, 
				   oper.v$viagem_relacao vr
			 WHERE pp.posto_pedagio_id = pl.posto_pedagio_id         
			   and pl.cod_pessoa = #arguments.cod_pessoa#
			   and pl.relacao_id = vr.relacao_id
			   and pl.cod_pessoa = vr.cod_pessoa
			   <cfif not isDefined("arguments.relacao_id")>
               and pl.user_insert in (user, 'RASTREADOR')   
               and pl.relacao_id = (select MAX(relacao_id)                           
                                     from oper.v$viagem_relacao                          
                                    where cod_pessoa = #arguments.cod_pessoa#)                                                     
			   <cfelse>
			   and pl.relacao_id = #arguments.relacao_id#
			   </cfif>
			union 
			select 'Nota/Recibo' as tipo, 
            	   vr.num_recibo_viagem as lancto_id,                                                   
				   prod.descricao || '-' || complemento as historico,                                                   
				   (substr(vr.placa,1,3)||'-'||substr(vr.placa,4,7)) as placa,
				   to_char(vr.data,'dd/mm/yyyy hh24:mi:ss') as data, 
                   vr.valor, 
                   to_char(vr.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert, 
                   vr.relacao_id, 
                   vrel.user_insert as usuario_relacao,
				   to_char(vrel.date_insert,'dd/mm/yyyy hh24:mi:ss') as data_relacao,
				   '#qr_nome_func.NOME_FUNCIONARIO#' as nome_funcionario,
				   '#qr_nome_func.COD_FUNCIONARIO#' as cod_funcionario,
				   vr.user_insert as lancado_por
			 from oper.v$viagem_recibo vr, 
				  oper.v$setor_produto prod, 
				  oper.v$viagem_relacao vrel
			where prod.produto_id = vr.produto_id                                 
			  and vr.cod_pessoa = #arguments.cod_pessoa#
			  and vr.relacao_id = vrel.relacao_id
			  and vr.cod_pessoa = vrel.cod_pessoa
			   <cfif not isDefined("Arguments.relacao_id")>
				   and vr.user_insert in (user,'RASTREADOR')                            
				   and vr.relacao_id = (select MAX(relacao_id)                                                     
										  FROM oper.v$viagem_relacao                                                    
										 WHERE cod_pessoa = #arguments.cod_pessoa#)
			   <cfelse>
				   and vr.relacao_id = #arguments.relacao_id#
			   </cfif>
			ORDER BY 7 
		</cfquery>
		<cfreturn qr_lancamentos>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os produtos liberados para as agencias e tambm os produtos liberados para o funcionrio selecionado.
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_produtos_estrada" displayname="Busca os produtos liberados para as agencias e tambm os produtos liberados para o funcionrio selecionado." access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select produto_id, descricao  
			  from oper.v$setor_produto 
			 where ativo = 1  
			   and nvl(necessita_liberacao,0) = 0 
				
			union 
			
			select p.produto_id, p.descricao
			  from oper.v$liberacao_pagamento l, oper.v$setor_produto p 
			 where l.produto_id = p.produto_id 
			   and p.produto_id <> 94 
			   and l.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
			   and not exists (select num_liberacao 
								 from oper.v$viagem_recibo vr 
								where vr.num_liberacao = l.num_liberacao) 		
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os liberacaoes do produto para o funcionrio selecionado.
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_liberacoes_func" displayname="Busca os liberacaoes do produto para o funcionrio selecionado." access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" displayname="Cdigo do funcionrio." required="true">		
		<cfargument name="produto_id" displayname="Identificador do produto." required="true">		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select lp.num_liberacao, lp.responsavel, lp.data_autorizacao,
				   oper.pkg_global.fnc_get_cod_funcionario(lp.cod_pessoa) as cod_funcionario, p.descricao as produto, 
				   lp.complemento, lp.valor 
			  from oper.v$liberacao_pagamento lp, 
				   oper.v$setor_produto p   
			 where lp.produto_id = p.produto_id  
			   and lp.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
			   and lp.produto_id = #arguments.produto_id#
			   and not exists (select num_liberacao 
								 from oper.v$viagem_recibo vr 
								 where vr.num_liberacao = lp.num_liberacao)				
		</cfquery>
		<cfreturn qr_result>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca o saldo anterior a data passada.
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_saldo_anterior_extrato" displayname="Busca o saldo anterior a data passada." access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no" default="" />
		<cfargument name="data_inicial" required="no" default="Now()" />
        <cfargument name="cod_pessoa" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta, to_date('#arguments.data_inicial# 23:59:59','dd/mm/yyyy hh24:mi:ss')),2) as saldo  
			  from oper.v$ccorrente cc  
			 where cc.modalidade_id = 4 
			   and cc.ativo = 1   
             <cfif Len(Trim(arguments.cod_funcionario))>
               and cc.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
             <cfelseif Len(Trim(arguments.cod_pessoa))>
			   and cc.cod_pessoa = #arguments.cod_pessoa#
             </cfif>
             
		</cfquery>
		<cfreturn qr_result>
	</cffunction>					
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos em CC do perodo para o funcionrio passado.
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_lancamentos_extrato" displayname="Busca todos os lanamentos em CC do perodo para o funcionrio passado." access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="yes" />
		<cfargument name="data_inicial" required="no" default="Now()" />
		<cfargument name="data_final" required="no" default="Now()" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			SELECT cl.cod_documento, decode(cl.user_insert,'AUTOTRAC','RASTREADOR', 'INTEGRACAO_VALE','VALE','FUNC_MOTORISTA','MOTORISTA',cl.user_insert) as usuario,          
							cl.data_vencto, cl.num_lancamento, cl.num_documento,                              
							cl.data_lancamento, cl.historico, decode(cl.deb_cred, 1, 'C','D') as d_c,                            
							round(cl.valor_lancamento,2) as valor_lancamento,
						  nvl((select pl.placa
							from oper.v$pedagio_lancto pl
								where pl.num_lancto_ccorrente = cl.num_lancamento),'------------') as placa
			 FROM oper.v$ccorrente_lancamento cl 
			  inner join oper.v$ccorrente cc
			  on cl.cod_conta = cc.cod_conta           
			WHERE cc.modalidade_id = 4  
			and cc.ativo = 1  
				and cc.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
			and cl.data_vencto between to_date('#arguments.data_inicial# 00:00','dd/mm/yyyy hh24:mi')  and to_date('#arguments.data_final# 23:59','dd/mm/yyyy hh24:mi')       
			ORDER BY cl.data_vencto, cl.num_lancamento
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca relaes de despesas por funcionario
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_relacoes_func" displayname="Busca todas as relaes do motorista" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select to_char(sum(lanctos.lancto),'00000') as lancto_relacao, sum(lanctos.valor) as valor_relacao, 
				   to_char(lanctos.relacao_id,'00000') as relacao_id, trunc(vir.data_relacao) as data, 
				   fnc_concat_all(to_concat_expr(to_char(lanctos.usuario), '/')) as usuario, vir.user_insert as usuario_print, 
				   vir.cod_pessoa,
				   min(oper.pkg_global.fnc_get_cod_funcionario(vir.cod_pessoa)) as cod_funcionario 
			  from (select count(vr.num_recibo_viagem) as lancto, 
						   sum(vr.valor) as valor, vr.relacao_id,                          
						   vr.user_insert as usuario                       
					  from oper.v$viagem_recibo vr                      
					 where cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
					 group by vr.relacao_id, vr.user_insert                      
			 union                      
			select count(pl.lancto_id),                    
				   sum(pl.valor_tarifa), pl.relacao_id,                      
				   pl.user_insert as usuario              
			  from oper.v$pedagio_lancto pl             
			 where cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
			 group by pl.relacao_id, pl.user_insert) lanctos, oper.v$viagem_relacao vir   
			 where vir.relacao_id = lanctos.relacao_id  
			   and vir.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
			 group by lanctos.relacao_id, trunc(vir.data_relacao), vir.user_insert, vir.cod_pessoa
			order by relacao_id desc		
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca relaes de despesas por data de emisso
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_relacoes_data" displayname="Busca todas as relaes do motorista" access="remote" returntype="query" output="true">
		<cfargument name="data" required="yes" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select to_char(sum(lanctos.lancto),'00000') as lancto_relacao, sum(lanctos.valor) as valor_relacao, 
				   to_char(lanctos.relacao_id,'00000') as relacao_id, trunc(vir.data_relacao) as data, 
				   fnc_concat_all(to_concat_expr(to_char(lanctos.usuario), '/')) as usuario, vir.user_insert as usuario_print, min(oper.pkg_global.fnc_get_cod_funcionario(vir.cod_pessoa)) as cod_funcionario,
				   vir.cod_pessoa
			  from (select count(vr.num_recibo_viagem) as lancto, vr.cod_pessoa,
						   sum(vr.valor) as valor, vr.relacao_id,                          
						   vr.user_insert as usuario, min(vr.cod_pessoa) as cod_funcionario
					  from oper.v$viagem_recibo vr                      
					 group by vr.relacao_id, vr.user_insert, vr.cod_pessoa                      
					 union                      
					select count(pl.lancto_id), pl.cod_pessoa,
						   sum(pl.valor_tarifa), pl.relacao_id,                      
						   pl.user_insert as usuario, min(pl.cod_pessoa) as cod_funcionario
					  from oper.v$pedagio_lancto pl             
					 group by pl.relacao_id, pl.user_insert, pl.cod_pessoa) lanctos, oper.v$viagem_relacao vir   
			 where vir.relacao_id = lanctos.relacao_id  
			   and vir.cod_pessoa = lanctos.cod_pessoa
			   and trunc(vir.data_relacao) = '#arguments.data#'
			 group by lanctos.relacao_id, trunc(vir.data_relacao), vir.user_insert, vir.cod_pessoa
			order by cod_funcionario, relacao_id	
		</cfquery>
		<cfreturn qr_result>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Buscas os recados para os motoristas
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_recados" displayname="Buscas os recados para os motoristas" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no" />
		<cfargument name="abertas" required="no" />
		<cfargument name="ativas" required="no" />
		<cfif isDefined("arguments.cod_funcionario")>
			<cfquery datasource="#session.dsn#" name="qr_func" username="#session.usuario#" password="#session.senha#" timeout="25">
				select decode(oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_funcionario#))
					   as cod_funcionario,
					   decode(oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#))  as cod_pessoa
				   from dual
			</cfquery>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_lancamento" username="#session.usuario#" password="#session.senha#">
			select recado_id, cod_pessoa, oper.pkg_global.fnc_get_cod_funcionario(cod_pessoa) as cod_funcionario, 
				   oper.pkg_global.fnc_busca_nome_pessoa(cod_pessoa) as nome_funcionario, 
				   recado, data_inicio, data_fim, ativo, user_insert
			  from oper.v$motorista_recado	
			where extrato = 1
			<cfif isDefined("arguments.cod_funcionario")>
				and cod_pessoa = #qr_func.cod_pessoa#
			</cfif>
	
			<cfif isDefined("arguments.abertas")>
				and sysdate between data_inicio and data_fim
			</cfif>
	
			<cfif isDefined("arguments.ativas")>
				and ativo = 1
			</cfif>
		</cfquery>
		<cfreturn qr_lancamento>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca lista de pertences que devem ser conferidos pelo motorista
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/01/2006
	--->
	<cffunction name="get_pertences" displayname="Busca lista de pertences que devem ser conferidos pelo motorista" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select  cod_macro, descricao
			  from oper.v$material_acessorio
			  where cod_macro is not null
			  order by cod_macro 		
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca lista de lanamentos nos cartes de pedgio
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/05/2006
	--->
	<cffunction name="get_lancamentos_cartao" displayname="Buscas os lanamentos feitos pelo usurio" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no"/>
		<cfargument name="data_inicial" required="no" default="" />
		<cfargument name="data_final" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_lancamento" username="#session.usuario#" password="#session.senha#">
				select num_lancamento, descricao_documento, cod_funcionario, favorecido, 
					   num_documento, data_lancamento, historico, valor_lancamento, deb_cred, 
					   data_vencto, user_insert
				 from (SELECT /*+ RULE */ decode(cc.user_insert,'INTEGRACAO_VALE','VALE','FUNC_MOTORISTA','MOTORISTA','SENTINELA','AUTO','OPER','AUTO','RASTREADOR','AUTO',cc.user_insert) as user_insert, cc.num_lancamento, ccd.descricao_documento, 
							  mr.cod_registro as cod_funcionario, cc.favorecido,          
							  cc.num_documento, cc.data_lancamento, cc.historico,          
							  cc.valor_lancamento, decode(cc.cod_documento, 373, 'Pagamento',decode(cc.deb_cred,0,'Dbito','Crdito')) as deb_cred, cc.data_vencto
					     FROM oper.v$ccorrente c 
					    inner join oper.v$ccorrente_lancamento cc 
						        on cc.cod_conta = c.cod_conta
							   and c.modalidade_id = 4
							   and c.ativo = 1
					    inner join oper.v$ccorrente_documento ccd 
								on cc.cod_documento = ccd.cod_documento    							    
							   and ccd.deb_cred = 0
					    inner join oper.v$motorista_reg_historico mr
							    on mr.cod_pessoa = c.cod_pessoa
							   and mr.data_fim is null        
					    where ccd.cod_documento in (375)     
					    <cfif isDefined("arguments.cod_pessoa") and len(trim(arguments.cod_pessoa))>
					      and c.cod_pessoa = #arguments.cod_pessoa#
					    </cfif>
			   <cfif Len(Trim(arguments.DATA_INICIAL)) and Len(Trim(arguments.DATA_FINAL))>
						order by data_lancamento desc, cc.favorecido) 
					where trunc(data_lancamento) between '#arguments.data_inicial#' and '#arguments.data_final#'
			   <cfelseif not (isDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa)))>
					order by data_lancamento desc, num_lancamento desc) 
				where rownum < 6   
				<cfelse>
				)
			   </cfif>
			   order by data_lancamento desc, num_lancamento desc
   		</cfquery>
		<cfreturn qr_lancamento>
	</cffunction>
	
    <!--- 
	-- PROPSITO 
	-- Retorna as 10 mais prximas praas de pedgio para um veculo em uma determinada data
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 06/05/2009
	--->
	<cffunction name="get_pracas_pedagio_proximas" displayname="Retorna as 10 mais prximas praas de pedgio para um veculo em uma determinada data" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes">
		<cfargument name="data_hora" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa as cod_pessoa_concessionaria,
                   posto_pedagio_id,
                   descricao,
                   distancia
              from (select pp.cod_pessoa,
                           pp.posto_pedagio_id,
                           pp.descricao,
                           oper.pkg_coord_geografica.fnc_haversine2(a.latitude, a.longitude, r.latitude, r.longitude) as distancia
                      from oper.v$pedagio_postos pp
                     inner join rastreador.v$referencia r
                             on r.referencia_id = pp.referencia_id,
                        (select t.latitude, t.longitude
                           from rastreador.v$posicao t
                          where t.placa = '#UCase(REReplace(arguments.placa,'-',''))#'
                            and t.data = (select min(p2.data)
                                            from rastreador.v$posicao p2
                                           where p2.placa = t.placa 
                                             and p2.data > '#arguments.data_hora#')) a
                     order by distancia)
             where rownum <= 10
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca todos os lanamentos em CC do perodo dos motoristas
    -- GUSTAVOC 04/06/2010
    --->		
    <cffunction name="get_lancamentos_extrato_motoristas" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="no" default="Now()" />
		<cfargument name="data_final" required="no" default="Now()" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            SELECT cc.cod_pessoa
                 , oper.pkg_global.fnc_get_cod_funcionario(cc.cod_pessoa) as cod_funcionario
                 , (select distinct mot.nome
                      from oper.v$motorista mot
                     where mot.cod_pessoa = cc.cod_pessoa
                   ) as nome
                 , cl.cod_documento
                 , decode(cl.user_insert,'AUTOTRAC','RASTREADOR', 'INTEGRACAO_VALE','VALE','FUNC_MOTORISTA','MOTORISTA',cl.user_insert) as usuario
                 , cl.data_vencto
                 , cl.num_lancamento
                 , cl.num_documento
                 , cl.data_lancamento
                 , cl.historico
                 , decode(cl.deb_cred, 1, 'C','D') as d_c
                 , round(cl.valor_lancamento,2) as valor_lancamento
                 , nvl((select pl.placa
                          from oper.v$pedagio_lancto pl
                         where pl.num_lancto_ccorrente = cl.num_lancamento)
                       ,'------------') as placa
              from oper.v$ccorrente_lancamento cl 
             inner join oper.v$ccorrente cc
                on cl.cod_conta = cc.cod_conta
             where cc.modalidade_id = 4
               and cc.ativo = 1  
               and cl.data_vencto between to_date('#arguments.data_inicial# 00:00','dd/mm/yyyy hh24:mi')  and to_date('#arguments.data_final# 23:59:59','dd/mm/yyyy hh24:mi:ss')       
             order by cc.cod_pessoa, cl.data_vencto, cl.num_lancamento
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>