<cfcomponent extends="_transportes.funcoes.cfc_init">	
	<!--- 
	-- PROPSITO 
	-- Buscas as aplicacoes
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_aplicacao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select aplicacao_id,
				   aplicacao,
				   descricao,
				   ativo,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update, 
				   site
			  from desenvolvimento.v$aplicacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os clientes
	-- CRISTOFER  02/05/2006
	--->
	<cffunction name="get_cliente" access="remote" returntype="query" output="true">
		<cfargument name="cliente" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cliente_id,
				   cliente,
				   nome,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$cliente
			 where 1=1
			<cfif len(trim(arguments.cliente))>
			   and upper(cliente) like upper('%#arguments.cliente#%')
			</cfif>
			<cfif len(trim(arguments.cliente_id))>
			   and cliente_id in (#arguments.cliente_id#)
			</cfif>
			 order by cliente
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os tipo de solicitacao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_solicitacao_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tipo_id,
			       descricao
			  from desenvolvimento.v$solicitacao_tipo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os tecnicos
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_tecnico" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tecnico,
			       email
			  from desenvolvimento.v$solicitacao_tecnico
			 order by tecnico
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as situaes das SDs
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_situacao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select situacao_id,
				   descricao
			  from desenvolvimento.v$solicitacao_situacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as situaes dos projetos
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_situacao_projeto" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select situacao_id,
				   descricao
			  from desenvolvimento.v$projeto_situacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as situaes das reunes
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_situacao_reuniao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select situacao_id,
				   descricao
			  from desenvolvimento.v$reuniao_situacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as situaes das obrigacoes de reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_situacao_obrigacao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select situacao_id,
				   descricao
			  from desenvolvimento.v$obrigacao_situacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca das situaes das discues
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_situacao_discussao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select situacao_id, descricao from kmm.v$discussao_situacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os responsaveis por alguma reunio
	-- CRISTOFER  05/02/2006
	--->		
	<cffunction name="get_responsavel_reuniao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct upper(responsavel) responsavel
			  from desenvolvimento.v$reuniao
			 order by upper(responsavel)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os clientes que participaram de alguma reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_cliente_reuniao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct upper(cliente) cliente
			  from desenvolvimento.v$reuniao
			 order by upper(cliente)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as SDs
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_solicitacao" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="no" default="">
		<cfargument name="cliente" required="no" default="">
		<cfargument name="aplicacao" required="no" default="">
		<cfargument name="projeto" required="no" default="">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="encerradas" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select s.solicitacao_id,
				   s.titulo,
				   s.data,
				   s.data_limite_programacao,
				   s.data_limite_entrega,
				   s.aplicacao,
				   s.projeto,
				   s.projeto_id,
				   s.cliente,
				   s.tipo_id,
				   s.resp_solicitacao,
				   s.resp_tecnico,
				   s.aceite_data,
				   s.aceite_responsavel,
				   s.situacao_id,
				   ss.descricao as situacao,
				   p.titulo as titulo_projeto,
				   (select count(*)
				      from internet.tarefa t
					 where t.sd_id = s.solicitacao_id
					   and t.status_id = 6
					   and t.status_id <> 9) as tarefas_finalizadas,
				   (select count(*)
				      from internet.tarefa t
					 where t.sd_id = s.solicitacao_id
					   and t.status_id not in (9)) as total_tarefas
			  from desenvolvimento.v$solicitacao s
			 inner join desenvolvimento.v$solicitacao_situacao ss
			         on ss.situacao_id = s.situacao_id
			  left join desenvolvimento.v$projeto p
			         on s.projeto_id = p.projeto_id
			 where 1=1
			 <cfif len(trim(arguments.solicitacao_id))>
			   and s.solicitacao_id = #arguments.solicitacao_id#
			 </cfif>
			 <cfif len(trim(arguments.cliente))>
			   and s.cliente = '#arguments.CLIENTE#'
			 </cfif>
			 <cfif len(trim(arguments.aplicacao))>
			   and s.aplicacao = '#arguments.APLICACAO#'
			 </cfif>
			 <cfif len(trim(arguments.projeto))>
			   and s.projeto = '#arguments.PROJETO#'
			 </cfif>
			 <cfif len(trim(arguments.projeto_id))>
			   and s.projeto_id in (#arguments.PROJETO_ID#)
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and s.titulo like '%#arguments.titulo#%'
			 </cfif>
			 <cfif arguments.encerradas neq 1>
			   and s.situacao_id not in (4,5)
			 </cfif>
			 order by s.projeto_id, s.titulo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os grupos de descricao das SDs
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_grupo_descricao" access="remote" returntype="query" output="true">
		<cfargument name="grupo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select grupo_id,
				   descricao,
				   observacao,
				   exige_confirmacao
			  from desenvolvimento.v$grupo_descricao
			 where 1=1
			<cfif len(trim(arguments.grupo_id))>
			   and grupo_id = #argument.GRUPO_ID#
			</cfif>
			<cfif len(trim(arguments.descricao))>
			   and descricao like '%#arguments.descricao#%'
			</cfif>
			order by grupo_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as descries da SD
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_descricao_solicitacao" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="grupo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select d.solicitacao_id,
				   d.grupo_id,
				   g.descricao as grupo,
				   g.observacao as grupo_obs,
				   g.exige_confirmacao as confirmacao,
				   d.item_id,
				   d.texto,
				   d.conferido
			  from desenvolvimento.v$solicitacao_descricao d
			 inner join desenvolvimento.v$grupo_descricao g
			         on d.grupo_id = g.grupo_id
			 where 1=1
			   and d.solicitacao_id = #arguments.solicitacao_id#
			 <cfif len(trim(arguments.grupo_id))>
			   and g.grupo_id = #arguments.grupo_id#
			 </cfif>
			 order by grupo_id, item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os anexos
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_anexo" access="remote" returntype="query" output="true">
		<cfargument name="anexo_id" required="no" default="">
		<cfargument name="todos" required="no" default="0">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="com_grupo" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 
				<cfif arguments.com_grupo eq 1>
					distinct replace(replace(sys_connect_by_path(replace(ag.descricao,'/','@@'), '/') || '/','/Raiz/','/'),'@@','/') as path ,
				   upper(a.titulo) as titulo_upper,
				</cfif>
			       a.titulo,
				   a.anexo_id,
				   ag.descricao as grupo,
				   a.url,
				   a.permite_excluir,
				   a.user_insert,
				   a.grupo_id
			  from desenvolvimento.v$anexo_grupo ag 
 			  left join desenvolvimento.v$anexos a
					 on ag.grupo_id = a.grupo_id
			 where 1 = 1
			   and a.anexo_id is not null
			 <cfif arguments.todos eq 0>
			   and (a.permite_excluir = 1 or a.user_insert = user)
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and upper(a.titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 <cfif len(trim(arguments.anexo_id))>
			   and a.anexo_id = #arguments.anexo_id#
			 </cfif>
			<cfif arguments.com_grupo eq 1>
			 start with ag.grupo_id = 0
			connect by prior ag.grupo_id = ag.grupo_pai_id
			 order siblings by upper(a.titulo)
 			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os anexos da solicitacao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_anexo_solicitacao" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sa.anexo_id,
				   sa.solicitacao_id,
				   a.url,
				   a.titulo
			  from desenvolvimento.v$solicitacao_anexo sa
			 inner join desenvolvimento.v$anexos a
			         on a.anexo_id = sa.anexo_id
			 where 1=1
			   and solicitacao_id = #arguments.solicitacao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as implementaoes da solicitacao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_implementacao_solicitacao" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select solicitacao_id,
				   implementacao_id,
				   texto,
				   anexo_id
			  from desenvolvimento.v$solicitacao_implementacao
			 where 1=1
			   and solicitacao_id = #arguments.solicitacao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as instrues de instalacao da solicitacao
	-- CRISTOFER  //2006
	--->		
	<cffunction name="get_instalacao_solicitacao" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select solicitacao_id,
				   orientacao_id,
				   texto
			  from desenvolvimento.v$solicitacao_instalacao
			 where 1=1
			   and solicitacao_id = #arguments.solicitacao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as instrues de uso da solicitacao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_uso_solicitacao" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select solicitacao_id,
				   orientacao_id,
				   texto
			  from desenvolvimento.v$solicitacao_uso
			 where 1=1
			   and solicitacao_id = #arguments.solicitacao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as no-conformidades das SDs
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_nao_conformidade" access="remote" returntype="query" output="true">
		<cfargument name="nao_conformidade_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nao_conformidade_id,
				   descricao,
				   gravidade
			  from desenvolvimento.v$nao_conformidade
			 where 1=1
			 <cfif len(trim(arguments.nao_conformidade_id))>
			   and nao_conformidade_id = #arguments.nao_conformidade_id#
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as nao-conformidades da solicitacao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_nao_conformidade_solicitacao" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sn.solicitacao_id,
				   sn.nao_conformidade_id,
				   n.descricao as nao_conformidade,
				   sn.ocorrencia,
				   sn.observacao,
				   sn.registrado_por
			  from desenvolvimento.v$solicitacao_nao_conformidade sn
			 inner join desenvolvimento.v$nao_conformidade n
			         on sn.nao_conformidade_id = n.nao_conformidade_id
			 where 1=1
			   and solicitacao_id = #arguments.solicitacao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados para a construo do PDF
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_relatorio" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select solicitacao_id,
				   titulo,
				   data,
				   data_limite_programacao,
				   data_limite_entrega,
				   aplicacao,
				   projeto,
				   cliente,
				   tipo_id,
				   resp_solicitacao,
				   resp_tecnico,
				   aceite_data,
				   aceite_responsavel,
				   tipo,
				   grupo,
				   descricao_grupo_id,
				   descricao_grupo,
				   descricao_item,
				   descricao_texto,
				   descricao_titulo,
				   descricao_conferido
			  from desenvolvimento.v$solicitacao_relatorio
			 where 1=1
			   and solicitacao_id = #arguments.solicitacao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as reunioes cadastradas
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_reuniao" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="no" default="">
		<cfargument name="CLIENTE" required="no" default="">
		<cfargument name="RESPONSAVEL" required="no" default="">
		<cfargument name="TITULO" required="no" default="">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="obrigacao_situacao_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="tarefas" required="no" default="">
		<cfargument name="sd_id" required="no" default="">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="obrigacoes" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reuniao_id,
				   titulo,
				   data_hora,
				   local,
				   cliente,
				   responsavel,
				   projeto_id,
				   sd_id,
				   r.situacao_id,
				   inicio_execucao,
				   termino_execucao,
				   motivo_cancelamento,
				   rs.descricao as situacao
				 <cfif arguments.obrigacoes eq 1>
				   ,
				   (select count(*)
				      from desenvolvimento.v$reuniao_obrigacao ro
					 where ro.reuniao_id = r.reuniao_id
					   and ro.situacao_id in (2)) obrigacoes_finalizadas,
				   (select count(*)
				      from desenvolvimento.v$reuniao_obrigacao ro
					 where ro.reuniao_id = r.reuniao_id
					   and ro.situacao_id in (1,2)) total_obrigacoes
				</cfif>
			  from desenvolvimento.v$reuniao r
			 inner join desenvolvimento.v$reuniao_situacao rs
			         on rs.situacao_id = r.situacao_id
			 where 1=1
			 <cfif len(trim(arguments.reuniao_id))>
			 	and reuniao_id = #arguments.reuniao_id#
			 </cfif>
			 <cfif len(trim(arguments.responsavel))>
			 	and upper(responsavel) like upper('%#arguments.responsavel#%')
			 </cfif>
			 <cfif len(trim(arguments.cliente))>
			 	and upper(cliente) like upper('%#arguments.cliente#%')
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			 	and upper(titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 <cfif len(trim(arguments.situacao_id))>
			 	and r.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.projeto_id))>
			 	and projeto_id in (#arguments.projeto_id#)
			 </cfif>
			 <cfif len(trim(arguments.sd_id))>
			 	and sd_id in (#arguments.sd_id#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			 	and trunc(data_hora) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			 	and trunc(data_hora) <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.tarefas))>
			 	and exists (select 0
				              from desenvolvimento.v$reuniao_obrigacao ro
							 where tarefa_id in (#arguments.tarefas#)
							   and ro.reuniao_id = r.reuniao_id)
			 </cfif>
			 <cfif len(trim(arguments.obrigacao_situacao_id))>
			 	and exists (select 0
				              from desenvolvimento.v$reuniao_obrigacao ro
							 where situacao_id in (#arguments.obrigacao_situacao_id#)
							   and ro.reuniao_id = r.reuniao_id)
			 </cfif>			 
			 order by reuniao_id desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca os participantes da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_participantes_reuniao" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reuniao_id,
				   item_id,
				   nome
			  from desenvolvimento.v$reuniao_participantes  
			 where reuniao_id = #arguments.reuniao_id#
			 order by nome, item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os assuntos da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_assunto_reuniao" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reuniao_id,
				   item_id,
				   texto
			  from desenvolvimento.v$reuniao_assunto
			 where reuniao_id = #arguments.reuniao_id#
			 order by item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
 
	<!--- 
	-- PROPSITO 
	-- Busca as discussoes da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_discussao_reuniao" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reuniao_id,
				   item_id,
				   texto
			  from desenvolvimento.v$reuniao_discussao  
			 where reuniao_id = #arguments.reuniao_id#
			 order by item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as obrigaes da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_obrigacao_reuniao" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reuniao_id,
				   item_id,
				   nome,
				   texto,
				   tarefa_id,
				   situacao_id
			  from desenvolvimento.v$reuniao_obrigacao  
			 where reuniao_id = #arguments.reuniao_id#
			 order by nome, item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados para o PDF da reuniao
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_relatorio_reuniao" access="remote" returntype="query" output="true">
		<cfargument name="reuniao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select reuniao_id,
				   titulo,
				   data_hora,
				   cliente,
				   local,
				   responsavel,
				   grupo,	
				   sub_grupo,
				   item_id,
				   texto,
				   projeto,
				   solicitacao
			  from desenvolvimento.v$reuniao_relatorio
			 where reuniao_id = #arguments.reuniao_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os projetos
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_projeto" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="cliente" required="no" default="">
		<cfargument name="tecnico" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="encerrados" required="no" default="0">
		<cfargument name="situacao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   codigo,
				   cliente,
				   tecnico,
				   titulo,
				   primeira_definicao,
				   ultima_definicao,
				   p.situacao_id,
				   sp.descricao as situacao
			  from desenvolvimento.v$projeto p
			 inner join desenvolvimento.v$projeto_situacao sp
			         on sp.situacao_id = p.situacao_id
			 where 1=1 
			 <cfif len(trim(arguments.projeto_id))>
			   and projeto_id = #arguments.projeto_id#
			 </cfif>
			 <cfif len(trim(arguments.cliente))>
			   and upper(cliente) like upper('%#arguments.cliente#%')
			 </cfif>
			 <cfif len(trim(arguments.tecnico))>
			   and upper(tecnico) like upper('%#arguments.tecnico#%')
			 </cfif>
			 <cfif len(trim(arguments.titulo))>
			   and upper(titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 <cfif arguments.encerrados neq 1> 
			   and p.situacao_id in (1,2,3,6,7,8,9)
			 </cfif>
			 <cfif len(trim(arguments.situacao_id)) >
			   and p.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 order by codigo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os projetos com discusso
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_projeto_discussao" access="remote" returntype="query" output="true">
		<cfargument name="cliente_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct pr.projeto_id, pr.titulo as titulo_projeto
				  from kmm.v$discussao ds
		    inner join desenvolvimento.v$projeto pr on pr.projeto_id = ds.projeto_id
			inner join kmm.v$cliente c on c.cliente = pr.cliente
			<cfif len(Trim(arguments.cliente_id))>
				where c.cliente_id = #arguments.cliente_id#
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os anexos do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_projeto_anexos" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pa.projeto_id,
				   pa.anexo_id,
				   a.url,
				   a.titulo
			  from desenvolvimento.v$projeto_anexo pa
			 inner join desenvolvimento.v$anexos a
			         on a.anexo_id = pa.anexo_id
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os escopos do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_projeto_escopo" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   item_id,
				   texto
			  from desenvolvimento.v$projeto_escopo
			 where projeto_id = #arguments.projeto_id#
			 order by item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os detalhamentos do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_projeto_detalhamento" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   item_id,
				   texto
			  from desenvolvimento.v$projeto_detalhamento
			 where projeto_id = #arguments.projeto_id#
			 order by item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os cronogramas do projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_projeto_cronograma" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   item_id,
				   texto,
				   data_termino
			  from desenvolvimento.v$projeto_cronograma
			 where projeto_id = #arguments.projeto_id#
			 order by data_termino
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os dados para o PDF do Projeto
	-- CRISTOFER  02/05/2006
	--->		
	<cffunction name="get_relatorio_projeto" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   codigo,
				   cliente,
				   tecnico,
				   titulo,
				   primeira_definicao,
				   ultima_definicao,
				   grupo,
				   sub_grupo,
				   item_id,
				   texto
			  from desenvolvimento.v$projeto_relatorio
			 where projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca o status das tarefas da sd
	-- CRISTOFER  09/05/2006
	--->		
	<cffunction name="get_status_tarefas_sd" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_id" required="no" default="">
		<cfargument name="reuniao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct
				   aplicacao,
				   count(case 
						   when status_id in (1) then 1
						   else null
						 end) as abertas,
				   count(case 
						   when status_id in (2,3,4,7) then 1
						   else null
						 end) as executando,
				   count(case 
						   when status_id in (5,8) then 1
						   else null
						 end) as testes,
				   count(case 
						   when status_id in (6) then 1
						   else null
						 end) as finalizadas,
				   count(case 
						   when status_id not in (9) then 1
						   else null
						 end) as total,
			       kss.fnc_concat_all(kss.to_concat_expr(t.tarefa_id, ',')) as tarefa_id
			  from internet.v$tarefa t

			 where 1=1
			 <cfif len(trim(arguments.reuniao_id))>
			   and exists (select 'x'
			                 from desenvolvimento.v$reuniao_obrigacao ro
							where ro.tarefa_id = t.tarefa_id
							  and reuniao_id = #arguments.reuniao_id#)
			 </cfif>
			 <cfif len(trim(arguments.solicitacao_id))>
		 	   and sd_id = #arguments.solicitacao_id#
			 </cfif>
			   and status_id not in (9)
			 group by aplicacao	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os grupos de anexos
	-- CRISTOFER  11/05/2006
	--->		
	<cffunction name="get_anexo_grupo" access="remote" returntype="query" output="true">
		<cfargument name="raiz" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select grupo_id,
				   grupo_pai_id,
				   nvl(grupo_pai_id,0) as grupo_pai_id_nvl,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$anexo_grupo	
			 where 1=1
			   and grupo_id <> 0
		     start with grupo_pai_id = #arguments.raiz#
		   connect by prior grupo_id = grupo_pai_id
		     order siblings by descricao			   
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os usuarios do cliente
	-- CRISTOFER  18/05/2006
	--->		
	<cffunction name="get_cliente_usuario" access="remote" returntype="query" output="true">
		<cfargument name="cliente_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select usuario,
				   cliente_id,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$cliente_usuario
			 where 1=1
			 <cfif len(trim(arguments.cliente_id))>
			   and cliente_id = #arguments.cliente_id#
			 </cfif>
			 order by usuario
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  
	
	<!--- 
	-- PROPSITO 
	-- busca os recursos 
	-- CRISTOFER  18/05/2006
	--->		
	<cffunction name="get_recurso" access="remote" returntype="query" output="true">
		<cfargument name="recurso_id" required="no" default="">
		<cfargument name="nome" required="no" default="">
        <cfargument name="nome_inteiro" required="no" default="0">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="tecnico" required="no" default="">
		<cfargument name="ativo" required="no" default="">
		<cfargument name="somente_equipe" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select recurso_id,
				   nome,
				   nome_completo,
				   cliente_id,
				   descricao,
				   tecnico,
				   exibir_ranking,
				   email,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site,
				   custo_hora,
                   (select min(equipe_id)
                      from kmm.v$equipe_recurso er
                     where er.recurso_id = t.recurso_id) as equipe_id,
                   case when exists (select 0
                             from kmm.v$equipe_recurso rd
                            inner join kmm.v$equipe_recurso ro
                               on ro.equipe_id = rd.equipe_id
                            inner join kmm.v$recurso r
                               on r.recurso_id = ro.recurso_id
                            where rd.recurso_id = t.recurso_id
                              and upper(trim(r.nome)) = user) then 1 else 0 end as mesma_equipe,
				   ativo
			  from kmm.v$recurso t
			 where 1=1
			 <cfif len(trim(arguments.recurso_id))>
			   and recurso_id in (#arguments.recurso_id#)
			 </cfif>
			 <cfif len(trim(arguments.nome))>
             	<cfif arguments.nome_inteiro eq 0>
			   		and upper(nome) like upper('%#arguments.nome#%')
                <cfelse>
                	and upper(nome) = upper('#arguments.nome#')
               	</cfif>
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(nome) like upper('#arguments.usuario#')
			 </cfif>
			 <cfif len(trim(arguments.tecnico))>
			   and tecnico = #arguments.tecnico#
			 </cfif>
			 <cfif len(trim(arguments.ativo))>
			   and ativo = #arguments.ativo#
			 </cfif>
             <cfif arguments.somente_equipe eq 1>
             	<cfif  listfindnocase('cristofer,guto,paulo,jcm',trim(ucase(session.usuario)),',')>
               and 1=1
                <cfelse>
               and exists (select 0
                             from kmm.v$equipe_recurso rd
                            inner join kmm.v$equipe_recurso ro
                               on ro.equipe_id = rd.equipe_id
                            inner join kmm.v$recurso r
                               on r.recurso_id = ro.recurso_id
                            where rd.recurso_id = t.recurso_id
                              and upper(trim(r.nome)) = user)
                </cfif>
             </cfif>
			 order by cliente_id, nome_completo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as funcoes dos recursos
	-- CRISTOFER  18/05/2006
	--->		
	<cffunction name="get_recurso_funcao" access="remote" returntype="query" output="true">
		<cfargument name="funcao_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select funcao_id,
				   descricao,
				   responsabilidades,
				   cor_hexadecimal,
				   interno,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$recurso_funcao
			 where 1=1
			 <cfif len(trim(arguments.funcao_id))>
			   and funcao_id in (#arguments.funcao_id#)
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>			

	<!--- 
	-- PROPSITO 
	-- Busca os recursos do projeto
	-- CRISTOFER  18/05/2006
	--->		
	<cffunction name="get_projeto_recurso" access="remote" returntype="query" output="true">
		<cfargument name="projeto_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select projeto_id,
				   item_id,
				   recurso_id,
				   funcao_id,
				   custo_hora,
				   data_entrada,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$projeto_recurso
			 where 1=1
			   and projeto_id = #arguments.projeto_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as discussoes
	-- CRISTOFER  23/05/2006
	--->		
	<cffunction name="get_discussao" access="remote" returntype="query" output="true">
		<cfargument name="discussao_id" required="no" default="">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="projeto_id" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="solicitacao_id" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="detalhes" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select d.discussao_id,
				   d.projeto_id,
				   d.titulo,
				   d.responsavel,
				   d.data_inicio,
				   d.situacao_id,
				   d.date_insert,
				   d.user_insert,
				   d.date_update,
				   d.user_update,
				   d.site,
				   p.titulo as projeto,
				   <cfif arguments.detalhes eq 1>
				   (select count(*)
				      from kmm.v$discussao_item di
					 where di.discussao_id = d.discussao_id) as comentarios,
				   (select max(di.data)
				      from kmm.v$discussao_item di
					 where di.discussao_id = d.discussao_id) as ultimo_comentario,
				   </cfif>
				   ds.descricao as situacao
			  from kmm.v$discussao d
			 inner join kmm.v$discussao_situacao ds
			         on ds.situacao_id = d.situacao_id
			 left join kmm.v$projeto p 
			         on p.projeto_id = d.projeto_id
--			 inner join kmm.v$cliente c on c.cliente = p.cliente		
			 where 1=1
			 <cfif len(trim(arguments.discussao_id))>
			   and d.discussao_id in (#arguments.discussao_id#)
			 </cfif>
			 <cfif len(trim(arguments.situacao_id))>
			   and d.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.projeto_id))>
			   and d.projeto_id in (#arguments.projeto_id#)
			 </cfif>
			 <cfif len(trim(arguments.cliente_id))>
--			   and c.cliente_id = #arguments.cliente_id#
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and d.discussao_id in (select p.discussao_id
			                            from kmm.v$discussao_participante p
									   inner join kmm.v$recurso r
									           on r.recurso_id = p.recurso_id
									   where upper(r.nome) in (#ListQualify(UCase(arguments.usuario),"'",',')#))
			 </cfif>
			 order by d.data_inicio
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca os comentarios inseridos na discussao
	-- CRISTOFER  23/05/2006
	--->		
	<cffunction name="get_discussao_item" access="remote" returntype="query" output="true">
		<cfargument name="item_id" required="no" default="">
		<cfargument name="discussao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select di.item_id,
				   di.discussao_id,
				   di.recurso_id,
				   di.texto,
				   di.data,
				   di.date_insert,
				   di.user_insert,
				   di.date_update,
				   di.user_update,
				   di.site,
				   r.nome as recurso
			  from kmm.v$discussao_item	di
			 inner join kmm.v$recurso r
			         on di.recurso_id = r.recurso_id
			 where 1=1
			 <cfif len(trim(arguments.item_id))>
			   and di.item_id in (#arguments.item_id#)
			 </cfif>
			 <cfif len(trim(arguments.discussao_id))>
			   and di.discussao_id in (#arguments.discussao_id#)
			 </cfif>
			 order by di.data
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os participantes da reuniao
	-- CRISTOFER  24/05/2006
	--->		
	<cffunction name="get_discussao_participante" access="remote" returntype="query" output="true">
		<cfargument name="discussao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.discussao_id,
				   p.recurso_id,
				   r.nome,
				   r.descricao,
				   r.email,
				   p.date_insert,
				   p.user_insert,
				   p.date_update,
				   p.user_update,
				   p.site
			  from kmm.v$discussao_participante p
			 inner join kmm.v$recurso r
					 on r.recurso_id = p.recurso_id
		     where 1=1
			<cfif len(trim(arguments.discussao_id))>
			   and p.discussao_id in (#arguments.discussao_id#)
			</cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 	

	<!--- 
	-- PROPSITO 
	-- Busca os anexos dos items de discussao
	-- CRISTOFER  24/05/2006
	--->		
	<cffunction name="get_discussao_item_anexo" access="remote" returntype="query" output="true">
		<cfargument name="item_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select dia.item_id,
				   dia.anexo_id,
				   dia.date_insert,
				   dia.user_insert,
				   dia.date_update,
				   dia.user_update,
				   dia.site,
				   a.titulo,
				   a.url
			  from kmm.v$discussao_item_anexo dia
			 inner join desenvolvimento.v$anexos a
					 on a.anexo_id = dia.anexo_id
			 where 1=1
			<cfif len(trim(arguments.item_id))>
			   and dia.item_id in (#arguments.item_id#)	
			</cfif>
			 order by dia.item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as secoes
	-- CRISTOFER  25/05/2006
	--->		
	<cffunction name="get_documento_secao" access="remote" returntype="query" output="true">
		<cfargument name="secao_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select secao_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$documento_secao
			 where 1=1
			<cfif len(trim(arguments.secao_id))>
			   and secao_id in (#arguments.secao_id#)
			</cfif>
			<cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			</cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca os documentos
	-- CRISTOFER  27/05/2006
	--->		
	<cffunction name="get_documento" access="remote" returntype="query" output="true">
		<cfargument name="documento_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="secao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select d.documento_id,
				   d.titulo,
				   d.secao_id,
				   s.descricao as secao,
				   d.definicao,
				   d.ultima_definicao,
				   d.recurso_id,
				   r.descricao as responsavel,
				   d.objetivo,
				   d.detalhamento,
				   d.date_insert,
				   d.user_insert,
				   d.date_update,
				   d.user_update,
				   d.site,
				   d.grupo_id
			  from desenvolvimento.v$documento d
			 inner join desenvolvimento.v$documento_secao s
			         on s.secao_id = d.secao_id
		     inner join desenvolvimento.v$recurso r
			         on r.recurso_id = d.recurso_id
			 where 1=1
			<cfif len(trim(arguments.documento_id))>
			   and d.documento_id in (#arguments.documento_id#)
			</cfif>
			<cfif len(trim(arguments.titulo))>
			   and upper(d.titulo) like upper('%#arguments.titulo#%')
			</cfif>
			<cfif len(trim(arguments.secao_id))>
			   and d.secao_id in (#arguments.secao_id#)
			</cfif>
			 order by d.secao_id, d.titulo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os anexos do documento
	-- CRISTOFER  29/05/2006
	--->		
	<cffunction name="get_documento_anexo" access="remote" returntype="query" output="true">
		<cfargument name="documento_id" required="no" default="">
		<cfargument name="anexo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select da.documento_id,
				   da.anexo_id,
				   da.date_insert,
				   da.user_insert,
				   da.date_update,
				   da.user_update,
				   da.site,
				   a.titulo,
				   a.url
			  from desenvolvimento.v$documento_anexo da
			 inner join desenvolvimento.v$anexos a
			         on a.anexo_id = da.anexo_id
			 where 1=1
			<cfif len(trim(arguments.documento_id))>
			   and da.documento_id in (#arguments.documento_id#)
			</cfif>
			<cfif len(trim(arguments.anexo_id))>
			   and da.anexo_id in (#arguments.anexo_id#)
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as revisoes do documento
	-- CRISTOFER  29/05/2006
	--->		
	<cffunction name="get_documento_revisao" access="remote" returntype="query" output="true">
		<cfargument name="documento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select revisao_id,
				   documento_id,
				   data,
				   descricao,
				   alterado_por,
				   revisado_por,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$documento_revisao
			 where 1=1
			   and documento_id in (#arguments.documento_id#)	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os atendimentos
	-- CRISTOFER  31/05/2006
	--->		
	<cffunction name="get_atendimento" access="remote" returntype="query" output="true">
		<cfargument name="atendimento_id" required="no" default="">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="tecnico" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select atd.atendimento_id,
				   atd.cliente_id,
				   clt.nome as cliente,
				   atd.aplicacao_id,
				   apl.descricao as aplicacao,
				   atd.usuario,
				   atd.descricao,
				   substr(atd.descricao,0,50)||case when length(atd.descricao) > 50 then '...' else '' end as resumo,
				   atd.situacao_id,
				   atd.data_inicio,
				   atd.data_termino,
				   atd.tecnico_atendimento,
				   atd.date_insert,
				   atd.user_insert,
				   atd.date_update,
				   atd.user_update,
				   atd.site
			  from desenvolvimento.v$atendimento atd
			 inner join desenvolvimento.v$cliente clt
					 on clt.cliente_id = atd.cliente_id
			 inner join desenvolvimento.v$aplicacao apl
					 on apl.aplicacao_id = atd.aplicacao_id
			 where 1=1
			 <cfif len(trim(arguments.atendimento_id))>
			   and atd.atendimento_id in (#arguments.atendimento_id#)
			 </cfif>
			 <cfif len(trim(arguments.situacao_id))>
			   and atd.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(atd.usuario) = upper('#arguments.usuario#')
			 </cfif>
			 <cfif arguments.tecnico eq 1>
			   and ((upper(atd.tecnico_atendimento) = upper('#session.usuario#') and atd.situacao_id = 2) or (atd.situacao_id <> 2))
			 </cfif>
			 order by atd.situacao_id desc, atd.data_inicio
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca as mensagens do atendimento
	-- CRISTOFER  31/05/2006
	--->		
	<cffunction name="get_atendimento_mensagem" access="remote" returntype="query" output="true">
		<cfargument name="atendimento_id" required="no" default="">
		<cfargument name="ultima_mensagem_id" required="no" default="">
		<cfargument name="apos_refresh" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mensagem_id,
				   atendimento_id,
				   usuario,
				   data,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site,
				   mensagem
			  from desenvolvimento.v$atendimento_mensagem
			 where 1=1
			 <cfif len(trim(arguments.atendimento_id))>
			   and atendimento_id = #arguments.atendimento_id#
			 </cfif>
			 <cfif len(trim(arguments.ultima_mensagem_id))>
			   and mensagem_id > #arguments.ultima_mensagem_id#
			 </cfif>
			 <cfif arguments.apos_refresh eq 1>
			 </cfif>
			 order by mensagem_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  
  	 
	<!--- 
	-- PROPSITO 
	-- Busca as ferramentas
	-- CRISTOFER  27/06/2006
	--->		
	<cffunction name="get_ferramenta" access="remote" returntype="query" output="true">
		<cfargument name="ferramenta_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ferramenta_id,
				   descricao,
				   item_acesso_id,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$mpsbr_ferramenta
			 where 1=1
			 <cfif len(trim(arguments.ferramenta_id))>
			   and ferramenta_id in (#arguments.ferramenta_id#)
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	 
	
	<!--- 
	-- PROPSITO 
	-- Busca os eventos cadastros para as atividades
	-- CRISTOFER  30/06/2006
	--->		
	<cffunction name="get_mpsbr_evento" access="remote" returntype="query" output="true">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="evento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select evento_id,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from desenvolvimento.v$mpsbr_evento	
			 where 1=1
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 <cfif len(trim(arguments.evento_id))>
			   and evento_id in (#arguments.evento_id#)
			 </cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os processos cadastrados
	-- CRISTOFER  30/06/2006
	--->		
	<cffunction name="get_mpsbr_processo" access="remote" returntype="query" output="true">
		<cfargument name="atividade" required="no" default="">
		<cfargument name="processo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mp.processo_id,
				   mp.atividade,
				   mp.descricao,
				   mp.responsavel,
				   rf.descricao as responsavel_nome,
				   mp.observacoes,
				   mp.date_insert,
				   mp.user_insert,
				   mp.date_update,
				   mp.user_update,
				   mp.site
			  from desenvolvimento.v$mpsbr_processo	mp
			 inner join desenvolvimento.v$recurso_funcao rf
			         on rf.funcao_id = mp.responsavel
			 where 1=1
			 <cfif len(trim(arguments.processo_id))>
			   and mp.processo_id in (#arguments.processo_id#)
			 </cfif>
			 <cfif len(trim(arguments.atividade))>
			   and upper(mp.atividade) like upper('%#arguments.atividade#%')
			 </cfif>
			 order by atividade
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os envolvidos no processo
	-- CRISTOFER  30/06/2006
	--->		
	<cffunction name="get_processo_envolvidos" access="remote" returntype="query" output="true">
		<cfargument name="processo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pe.envolvido_id,
				   pe.processo_id,
				   pe.funcao_id,
				   f.descricao as funcao,
				   pe.date_insert,
				   pe.user_insert,
				   pe.date_update,
				   pe.user_update,
				   pe.site
			  from desenvolvimento.v$mpsbr_processo_envolvido pe
			 inner join desenvolvimento.v$recurso_funcao f
			         on f.funcao_id = pe.funcao_id
			 where processo_id in (#arguments.processo_id#)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os eventos cadastrados para o processo
	-- CRISTOFER  30/06/2006
	--->		
	<cffunction name="get_processo_evento" access="remote" returntype="query" output="true">
		<cfargument name="processo_id" required="yes">
		<cfargument name="entrada" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pe.processo_evento_id,
				   pe.processo_id,
				   pe.evento_id,
				   ev.descricao as evento,
				   pe.entrada,
				   pe.unico,
				   pe.requerido,
				   pe.date_insert,
				   pe.user_insert,
				   pe.date_update,
				   pe.user_update,
				   pe.site
			  from desenvolvimento.v$mpsbr_processo_evento pe
			 inner join desenvolvimento.v$mpsbr_evento ev
					 on ev.evento_id = pe.evento_id	
	 		 where 1=1
			   and processo_id = #arguments.processo_id#
			 <cfif len(trim(arguments.entrada))>
			   and entrada = #arguments.entrada#
			 </cfif>
			 order by ev.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os tipos de requisito
	-- GUTO - 01/07/2006
	--->		
	<cffunction name="get_requisito_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tipo_id, descricao, funcional
			  from desenvolvimento.v$requisito_tipo
			 order by tipo_id
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os nivel de estabilidade
	-- GUTO - 01/07/2006
	--->		
	<cffunction name="get_requisito_estabilidade" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select estabilidade_id, descricao, user_insert, date_insert, 
				   user_update, date_update, site 
			  from desenvolvimento.v$requisito_estabilidade
			 order by estabilidade_id
   		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	

	<!--- 
	-- PROPSITO 
	-- Busca os estados do requisito
	-- GUTO - 01/07/2006
	--->		
	<cffunction name="get_requisito_estado" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select estado_id, descricao, cor_hexadecimal
			  from desenvolvimento.v$requisito_estado	
			 order by estado_id
   		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca requisitos
	-- GUTO - 03/07/2006
	--->		
	<cffunction name="get_requisito" access="remote" returntype="query" output="true">
		<cfargument name="requisito_id" required="no" default=""/>
		<cfargument name="cod_requisito" required="no" default=""/>
		<cfargument name="titulo" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.requisito_id, r.requisito_pai, r.cod_requisito, r.titulo, 
				   r.escopo, r.tipo_id, r.estado_id, r.estabilidade_id, re.descricao as estabilidade,
				   rs.descricao as estado, rs.cor_hexadecimal, rt.descricao as tipo
			  from desenvolvimento.v$requisito r
			 inner join desenvolvimento.v$requisito_estabilidade re
					 on re.estabilidade_id = r.estabilidade_id
			 inner join desenvolvimento.v$requisito_estado rs
					 on rs.estado_id = r.estado_id
			 inner join desenvolvimento.v$requisito_tipo rt
					 on rt.tipo_id = r.tipo_id
		     where 1=1
			  <cfif Len(Trim(arguments.COD_REQUISITO))>
			   and upper(r.cod_requisito) = upper('#arguments.COD_REQUISITO#')
			  </cfif>
			  <cfif Len(Trim(arguments.REQUISITO_ID))>
			   and r.requisito_id = #arguments.REQUISITO_ID#
			  </cfif>
			  <cfif Len(Trim(arguments.TITULO))>
			   and r.titulo like '%#arguments.TITULO#%'
			  </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
		 
	<!--- 
	-- PROPSITO 
	-- Busca arvore de requisitos
	-- GUTO - 03/07/2006
	--->		
	<cffunction name="get_requisito_tree" access="remote" returntype="query" output="true">
		<cfargument name="cod_requisito" required="no" default=""/>
		<cfargument name="titulo" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.path, r.codigo_completo, r.requisito_id, r.requisito_pai, r.cod_requisito,
				   r.titulo, r.escopo, r.tipo_id, r.estado_id, r.estabilidade_id, r.folha,
				   r.nivel, r.requisito_id_raiz, max(r.nivel) over(partition by r.requisito_id_raiz) as maior_nivel,
				   (select count(*) 
					  from desenvolvimento.v$requisito rp
					 where rp.requisito_pai = r.requisito_id) as filhos,
				   (select fnc_concat_all(to_concat_expr(to_char(requisito_id), ',')) requisitos
					  from desenvolvimento.v$requisito rp
					 where rp.requisito_pai = r.requisito_id) as req_filhos,
				   re.descricao as estabilidade,
				   rs.descricao as estado, rs.cor_hexadecimal, rt.descricao as tipo					                  					 
			  from (
						select substr(sys_connect_by_path(case when length(titulo) < 25 then titulo else substr(titulo,1,25) || '...' end , ' -> '),5) as path,
							   substr(sys_connect_by_path(cod_requisito, '.'),2) as codigo_completo,
							   requisito_id, requisito_pai, cod_requisito, titulo, 
							   escopo, tipo_id, estado_id, estabilidade_id, connect_by_isleaf as folha,  level as nivel,
					   connect_by_root  requisito_id  as requisito_id_raiz
						  from desenvolvimento.v$requisito
						start with requisito_pai is null
						connect by prior requisito_id = requisito_pai
						order siblings by requisito_id	) r
				 inner join desenvolvimento.v$requisito_estabilidade re
						 on re.estabilidade_id = r.estabilidade_id
				 inner join desenvolvimento.v$requisito_estado rs
						 on rs.estado_id = r.estado_id
				 inner join desenvolvimento.v$requisito_tipo rt
						 on rt.tipo_id = r.tipo_id
			  where 1=1
			  <cfif Len(Trim(arguments.COD_REQUISITO))>
			   and upper(r.cod_requisito) = upper('#arguments.COD_REQUISITO#')
			  </cfif>
			  <cfif Len(Trim(arguments.TITULO))>
			   and r.titulo like '%#arguments.TITULO#%'
			  </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca requisitos vinculados
	-- GUTO - 03/07/2006
	--->		
	<cffunction name="get_requisito_vinculo" access="remote" returntype="query" output="true">
		<cfargument name="requisito_id_1" required="no" default="" />
		<cfargument name="requisito_id_2" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rv.requisito_id_1, r1.titulo as titulo_1, requisito_id_2, r2.titulo as titulo_2
			  from desenvolvimento.v$requisito_vinculo rv
			 inner join desenvolvimento.v$requisito r1
			         on r1.requisito_id = rv.requisito_id_1
			 inner join desenvolvimento.v$requisito r2
			         on r2.requisito_id = rv.requisito_id_2
			 where 1=1
			 <cfif Len(Trim(arguments.requisito_id_1))>
			   and requisito_id_1 = #arguments.requisito_id_1#
			 </cfif>
			 <cfif Len(Trim(arguments.requisito_id_2))>
			   and requisito_id_2 = #arguments.requisito_id_2#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca as tarefas do processo
	-- CRISTOFER  03/07/2006
	--->		
	<cffunction name="get_processo_tarefa" access="remote" returntype="query" output="true">
		<cfargument name="processo_id" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pt.processo_id,
				   pt.tarefa_id,
				   t.descricao as tarefa,
				   t.ferramenta_id,
				   t.responsavel,
				   rf.descricao as funcao,
				   f.descricao as ferramenta,
				   it.item_acesso_cod,
				   pt.ordem,
				   pt.date_insert,
				   pt.user_insert,
				   pt.date_update,
				   pt.user_update,
				   pt.site
			  from desenvolvimento.v$mpsbr_processo_tarefa pt
			 inner join desenvolvimento.v$mpsbr_tarefa t
					 on t.tarefa_id = pt.tarefa_id
			  left join desenvolvimento.v$recurso_funcao rf
			         on rf.funcao_id = t.responsavel
			  left join desenvolvimento.v$mpsbr_ferramenta f
			         on t.ferramenta_id = f.ferramenta_id
			  left join acesso.v$item_acesso it
			         on it.item_acesso_id = f.item_acesso_id
		     where 1=1
			   and processo_id in (#arguments.processo_id#)
			 order by ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os resultados esperados
	-- CRISTOFER  03/07/2006
	--->		
	<cffunction name="get_resultados" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select resultado_id,
				   cod_resultado,
				   cod_nivel,
				   descricao,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site,
				   grupo_id
			  from desenvolvimento.v$mpsbr_resultado
			 order by resultado_id
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os guias do processo
	-- CRISTOFER  03/07/2006
	--->		
	<cffunction name="get_processo_guia" access="remote" returntype="query" output="true">
		<cfargument name="processo_id" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pg.processo_id,
				   pg.anexo_id,
				   a.titulo,
				   a.url,
				   pg.date_insert,
				   pg.user_insert,
				   pg.date_update,
				   pg.user_update,
				   pg.site
			  from desenvolvimento.v$mpsbr_processo_guia pg
			 inner join desenvolvimento.v$anexos a
					 on a.anexo_id = pg.anexo_id
			 where 1=1
			   and pg.processo_id in (#arguments.processo_id#)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca os resultados do processo
	-- CRISTOFER  03/07/2006
	--->		
	<cffunction name="get_processo_resultado" access="remote" returntype="query" output="true">
		<cfargument name="processo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rs.processo_id,
				   rs.resultado_id,
				   r.cod_resultado,
				   r.descricao,
				   rs.date_insert,
				   rs.user_insert,
				   rs.date_update,
				   rs.user_update,
				   rs.site
			  from desenvolvimento.v$mpsbr_processo_resultado rs
			 inner join desenvolvimento.v$mpsbr_resultado r
			         on rs.resultado_id = r.resultado_id
			 where 1=1
			   and rs.processo_id = #arguments.processo_id#
			 order by rs.resultado_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca a solicitacao de desenvolvimento
	-- JONAS  02/04/2008
	--->		
	<cffunction name="get_solicitacao_desenvolvimento" access="remote" returntype="query" output="true">
		<cfargument name="SD_ID" required="no" default="">
        <cfargument name="CODIGO" required="no" default="">
        <cfargument name="CLIENTE_ID" required="no" default="">
        <cfargument name="MODULO_ID" required="no" default="">
        <cfargument name="TITULO" required="no" default="">
        <cfargument name="PROJETO_ID" required="no" default="">
        <cfargument name="STATUS" required="no" default="">
        <cfargument name="TIPO_ID" required="no" default="">
        <cfargument name="ENCERRADAS" required="no" default="">
        <cfargument name="DATA_INICIO" required="no" default="">
        <cfargument name="DATA_FINAL" required="no" default="">
        <cfargument name="MINHAS" required="no" default="">
        <cfargument name="ORDER_BY" required="no" default="">
        
        <cfargument name="DISPONIBILIZACAO_INICIAL" required="no" default="">
        <cfargument name="DISPONIBILIZACAO_FINAL" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sd_id,
                   codigo,
                   geradora_codigo,
                   geradora_titulo,
                   geradora_titulo_codigo,
                   sd_id_geradora,
                   projeto_id,
                   modulo_id,
                   tecnico_aprovacao,
                   titulo,
                   obs_producao,
                   responsavel_sd,
                   responsavel,
                   data_solicitacao,
                   tipo_id,
                   tipo,
                   escopo_requisito,
                   motivo,
                   observacoes,
                   analise_impacto,
                   sprint_id,
                   sprint_descricao,
                   texto_aprovacao,
                   tecnico_aprovacao_nome,
                   prioridade,
                   prioridade_kmm,
                   flag,
                   termo_encerramento,
                   cliente_nome,
                   cliente_id,
                   liberada_desenvolvimento,
                   modulo_nome,
                   projeto,
                   data_entrega_cliente,
                   atraso_data_cliente,
                   data_entrega_nivel,
                   data_entrega_situacao_id,
                   tempo_total,
                   tempo_analise,
                   tempo_tarefa_analise,
                   percentual_atribuido,
                   percentual_concluido,
                   percentual_concluido_teste,
                   tempo_estimado_sd,
                   detalhamentos,
                   detalhamento_aberto,
                   num_analises,
                   num_analises_aberto,
                   tempo_total_concluido,
                   data_previsao_producao,
                   data_previsao,
                   tarefas,
                   data_disponibilizacao,
                   data_conclusao,
                   status,
                   status_id,
                   tarefas_abertas,
                   tarefas_finalizadas,
                   tarefas_em_execucao,
                   case 
                       when (t.tarefas - t.tarefas_finalizadas - t.tarefas_em_execucao) = 0 then
                           1
                       else
                           0
                   end em_aprovacao,
                   lider_tecnico,
                   atrasos_equipe,
                   equipe_id,
                   gerente_projeto,
                   analista_negocio,
                   funcao_sd,
                   previsao_analise,
                   situacao_faturamento_id,
                   situacao_faturamento,
                   data_quitacao,
                   data_liberacao_faturamento,
                   etapa_id,
                   etapa,
                   situacao,
                   tempo_cobrado,
                   tempo_cobrado_horas,
                   tempo_cobrado_minutos,
                   tempo_cobrado_travado,
                   prazo_desenvolvimento,
                   data_producao,
                   data_producao_situacao_id
              from (
                      select sd.sd_id,
                           sd.codigo,
                           ger.codigo as geradora_codigo,
                           ger.titulo as geradora_titulo,
                           ger.codigo || '-' || ger.titulo as geradora_titulo_codigo,
                           ger.sd_id as sd_id_geradora,
                           sd.projeto_id,
                           sd.modulo_id,
                           sd.tecnico_aprovacao,
                           sd.titulo, sd.obs_producao, 
                           sd.responsavel_sd, r.nome_completo as responsavel, 
                           to_char(sd.data_solicitacao,'dd/mm/yyyy') as data_solicitacao,
                           sd.tipo_id, st.descricao as tipo,
                           sd.escopo_requisito,
                           sd.motivo,
                           sd.observacoes,
                           sd.analise_impacto,
                           sd.sprint_id,
                           (select descricao || decode(s.data_fechamento,null,' <span style="color:##00F">- Aberto</span>',' <span class="obrigatorio">- Fechado em ' || to_char(s.data_fechamento,'dd/mm/yyyy') || '<span>')
                              from kmm.v$sprint s
                             where s.sprint_id = sd.sprint_id) as sprint_descricao,
                           sd.texto_aprovacao, 
                           tec.nome_completo as tecnico_aprovacao_nome,
                           decode(sd.tipo_id,4,'-',decode(sd.status_id,4,'-',2,c.nome || ' '  || '(' || sd.prioridade||')',sd.prioridade)) as prioridade,
                           sd.prioridade_kmm, sd.flag,
                           sd.termo_encerramento,
                           c.nome as cliente_nome,
                           c.cliente_id,
                           sd.liberada_desenvolvimento,
                           m.nome as modulo_nome,
                           p.titulo as projeto,
                           to_char(sd.data_entrega_cliente,'dd/mm/yyyy hh24:mi:ss') as data_entrega_cliente,
                           case 
                             when sd.data_entrega_cliente is null then null
                             when sd.data_entrega_cliente - sysdate < 0 then 1
                             when sd.data_entrega_cliente - (sysdate + 10) < 0 then 0
                           else -1 end atraso_data_cliente,
                           sd.data_entrega_nivel,
                           sd.data_entrega_situacao_id,
                           kss.to_tempo((select numtodsinterval(sum((sysdate+t.tempo_estimado)-sysdate),'DAY')
                                          from kmm.v$sd_detalhamento sdd
                                          inner join kmm.v$sd_tarefa st
                                                  on st.sd_detalhamento_id = sdd.sd_detalhamento_id
                                          inner join kmm.v$tarefa t
                                                  on t.tarefa_id = st.tarefa_id
                                         where sdd.sd_id = sd.sd_id),3).retorno as tempo_total,
                           kss.to_tempo((select kss.sum_dsinterval(sae.tempo_estimado)
                                          from kmm.v$sd_analise sa
                                          inner join kmm.v$sd_analise_etapa sae
                                                  on sa.analise_id = sae.analise_id
                                         where sa.sd_id = sd.sd_id),3).retorno as tempo_analise,
                           kss.to_tempo((select kss.sum_dsinterval(t.tempo_estimado)
                                          from kmm.v$sd_tarefa st
                                         inner join kmm.v$tarefa t
                                                 on st.tarefa_id = t.tarefa_id
                                                and st.tipo = 0
                                         where st.sd_id = sd.sd_id),3).retorno as tempo_tarefa_analise,
        
                           round(nvl((( select sysdate + kss.sum_dsinterval(t.tempo_estimado) - sysdate
                                      from (select st1.tarefa_id, st1.sd_id, max(st1.tipo) as tipo from kmm.v$sd_tarefa st1 group by tarefa_id, sd_id) st
                                     inner join kmm.v$tarefa t
                                        on st.tarefa_id = t.tarefa_id
                                       and st.tipo = 1
                                      left join kmm.v$tarefa_atribuicao ta
                                        on ta.atribuicao_id = t.atribuicao_id
                                     where st.sd_id = sd.sd_id
                                       and t.status in (5,2,3,7)) /
                                   nullif((select sysdate + kss.sum_dsinterval(sae.tempo_estimado) - sysdate
                                      from kmm.v$sd_analise sa
                                     inner join kmm.v$sd_analise_etapa sae
                                        on sa.analise_id = sae.analise_id
                                     where sa.sd_id = sd.sd_id),0))*100,0),4) as percentual_atribuido,
                                     
                                     
                           round(nvl((( select sysdate + kss.sum_dsinterval(t.tempo_estimado) - sysdate
                                      from (select st1.tarefa_id, st1.sd_id, max(st1.tipo) as tipo from kmm.v$sd_tarefa st1 group by tarefa_id, sd_id) st
                                     inner join kmm.v$tarefa t
                                        on st.tarefa_id = t.tarefa_id
                                       and st.tipo = 1
                                      left join kmm.v$tarefa_atribuicao ta
                                        on ta.atribuicao_id = t.atribuicao_id
                                     where st.sd_id = sd.sd_id
                                       and (ta.etapa_id in (5,6,16) or t.status = 7)
                                       and t.status <> 8) /
                                   nullif((select sysdate + kss.sum_dsinterval(sae.tempo_estimado) - sysdate
                                      from kmm.v$sd_analise sa
                                     inner join kmm.v$sd_analise_etapa sae
                                        on sa.analise_id = sae.analise_id
                                     where sa.sd_id = sd.sd_id),0))*100,0),4) as percentual_concluido,
                           round(nvl((( select sysdate + kss.sum_dsinterval(t.tempo_estimado) - sysdate
                                      from (select st1.tarefa_id, st1.sd_id, max(st1.tipo) as tipo from kmm.v$sd_tarefa st1 group by tarefa_id, sd_id) st
                                     inner join kmm.v$tarefa t
                                        on st.tarefa_id = t.tarefa_id
                                       and st.tipo = 1
                                      left join kmm.v$tarefa_atribuicao ta
                                        on ta.atribuicao_id = t.atribuicao_id
                                     where st.sd_id = sd.sd_id
                                       and (ta.etapa_id in (4))
                                       and t.status <> 8) /
                                   nullif((select sysdate + kss.sum_dsinterval(sae.tempo_estimado) - sysdate
                                      from kmm.v$sd_analise sa
                                     inner join kmm.v$sd_analise_etapa sae
                                        on sa.analise_id = sae.analise_id
                                     where sa.sd_id = sd.sd_id),0))*100,0),4) as percentual_concluido_teste,
                                         
                           kss.to_tempo((select kss.sum_dsinterval(seh.horas)
                                          from kmm.v$sd_etapa_hora seh
                                         where seh.sd_id = sd.sd_id),3).retorno as tempo_estimado_sd,
                           (select count(*)
                              from kmm.v$sd_detalhamento sdd
                              where sdd.sd_id = sd.sd_id ) as detalhamentos,
                           (select count(*)
                              from kmm.v$sd_detalhamento sdd
                              where sdd.sd_id = sd.sd_id
                                and sdd.exige_tarefa = 1
                                and not exists ( select 1 
                                                   from kmm.v$sd_analise_detalhamento st 
                                                  where st.sd_detalhamento_id = sdd.sd_detalhamento_id)                        
                                and not exists ( select 1 
                                                   from kmm.v$sd_tarefa st 
                                                  where st.sd_detalhamento_id = sdd.sd_detalhamento_id) ) as detalhamento_aberto,
                           (select count(*)
                              from kmm.v$sd_analise sa
                              where sa.sd_id = sd.sd_id) as num_analises,
                           (select count(*)
                              from kmm.v$sd_analise sa
                              where sa.sd_id = sd.sd_id
                                and not exists ( select 1 
                                                   from kmm.v$tarefa  t 
                                                  where t.analise_id = sa.analise_id) ) as num_analises_aberto,
                           kss.to_tempo((select numtodsinterval(sum((sysdate+t.tempo_estimado)-sysdate),'DAY')
                                          from kmm.v$sd_detalhamento sdd
                                          inner join kmm.v$sd_tarefa st
                                                  on st.sd_detalhamento_id = sdd.sd_detalhamento_id
                                          inner join kmm.v$tarefa t
                                                  on t.tarefa_id = st.tarefa_id
                                         where sdd.sd_id = sd.sd_id
                                           and t.status = 7),3).retorno as tempo_total_concluido, 
                           nvl((select to_char(max(decode(st.tipo,1,t.entregar_em,null)),'dd/mm/yyyy') 
                              from kmm.v$sd_detalhamento sdd
                              inner join kmm.v$sd_tarefa st
                                      on st.sd_detalhamento_id = sdd.sd_detalhamento_id
                              inner join kmm.v$tarefa t
                                      on t.tarefa_id = st.tarefa_id
                             where sdd.sd_id = sd.sd_id),'Aberta') as data_previsao_producao,
                           decode(sd.tipo_id,4,to_char(last_day(sd.data_solicitacao),'dd/mm/yyyy'),nvl(to_char(sd.data_previsao_entrega,'dd/mm/yyyy'),'Anlise')) as data_previsao,
                           (select count(distinct t.tarefa_id)
                                          from kmm.v$sd_detalhamento sdd
                                          inner join kmm.v$sd_tarefa st
                                                  on st.sd_detalhamento_id = sdd.sd_detalhamento_id
                                          inner join kmm.v$tarefa t
                                                  on t.tarefa_id = st.tarefa_id
                                         where sdd.sd_id = sd.sd_id
                                           and t.status <> 8) as tarefas,
                           (select to_char(max(sdd.data_disponibilizacao),'dd/mm/yyyy')
                              from kmm.v$sd_detalhamento sdd
                             where sdd.sd_id = sd.sd_id) as data_disponibilizacao,
                           (select to_char(max(sdd.data_conclusao),'dd/mm/yyyy')
                              from kmm.v$sd_detalhamento sdd
                             where sdd.sd_id = sd.sd_id) as data_conclusao,
                           (select c.descricao
                              from kmm.v$cg_ref_codes c
                             where c.dominio = 'SD STATUS'
                               and c.id = nvl(sd.status_id,0)) as status,
                           nvl(sd.status_id,0) as status_id,
                           (select count(*) 
                              from kmm.v$sd_tarefa st
                              inner join kmm.v$tarefa t
                                      on t.tarefa_id = st.tarefa_id
                             where st.sd_id = sd.sd_id
                               and t.status = 1) as tarefas_abertas,
                           (select count(*) 
                              from kmm.v$sd_tarefa st
                              inner join kmm.v$tarefa t
                                      on t.tarefa_id = st.tarefa_id
                             where st.sd_id = sd.sd_id
                               and t.status = 7) as tarefas_finalizadas,
                            (select count(*)
                              from kmm.v$tarefa t
                             where t.sd_id = sd.sd_id
                               and t.status = 3 ) as tarefas_em_execucao,
                           (select kss.fnc_concat_all(kss.to_concat_expr(rc.nome_completo, '/'))
                              from kmm.v$sd_responsaveis r
                             inner join kmm.v$recurso rc
                                     on rc.recurso_id = r.recurso_id
                             where r.funcao_id = 8
                               and r.sd_id = sd.sd_id) as lider_tecnico,
                           (select count(*)
                              from kmm.v$sd_responsaveis r
                             inner join kmm.v$equipe_recurso er
                                     on er.recurso_id = r.recurso_id
                                    and er.funcao_id = 8
                             inner join kmm.v$sd_atraso sa
                                     on sa.equipe_id = er.equipe_id
                                    and sa.data_cancelamento is null
                                    and sa.sd_id = r.sd_id
                             where r.sd_id = sd.sd_id) as atrasos_equipe,
                           (select max(equipe_id)
                              from kmm.v$sd_responsaveis r
                             inner join kmm.v$equipe_recurso er
                                     on er.recurso_id = r.recurso_id
                                    and er.funcao_id = 8
                             where r.sd_id = sd.sd_id) as equipe_id,
                           (select kss.fnc_concat_all(kss.to_concat_expr(rc.nome_completo, '/'))
                              from kmm.v$sd_responsaveis r
                             inner join kmm.v$recurso rc
                                     on rc.recurso_id = r.recurso_id
                             where r.funcao_id = 7
                               and r.sd_id = sd.sd_id) as gerente_projeto,
                           (select kss.fnc_concat_all(kss.to_concat_expr(rc.nome_completo, '/'))
                              from kmm.v$sd_responsaveis r
                             inner join kmm.v$recurso rc
                                     on rc.recurso_id = r.recurso_id
                             where r.funcao_id = 2
                               and r.sd_id = sd.sd_id) as analista_negocio,
                           (select kss.fnc_concat_all(kss.to_concat_expr(rf.descricao,'/'))
                             from kmm.v$sd_responsaveis r 
                             inner join kmm.v$recurso re
                                     on re.recurso_id = r.recurso_id
                             inner join kmm.v$recurso_funcao rf
                                     on rf.funcao_id = r.funcao_id 
                            where re.nome = user
                              and r.sd_id = sd.sd_id) as funcao_sd,
                           case
                              when sd.status_id in (0,1) then (select max(entregar_em)
                                                                   from kmm.v$sd_tarefa st
                                                                  inner join kmm.v$tarefa t on t.tarefa_id = st.tarefa_id
                                                                  where st.sd_id = sd.sd_id
                                                                    and t.tipo_id = 6) 
                              else null
                           end as previsao_analise,
                           sd.situacao_faturamento_id,
                           (select descricao
                              from kmm.v$cg_ref_codes cg
                             where cg.dominio = 'SD.SITUACAO_FATURAMENTO_ID'
                               and cg.id = sd.situacao_faturamento_id) as situacao_faturamento,
                           to_char(sd.data_quitacao,'dd/mm/yyyy') as data_quitacao,
                           to_char(sd.data_liberacao_faturamento,'dd/mm/yyyy') as data_liberacao_faturamento,
                           se.etapa_id,
                           scv.descricao as etapa,
                           (select sse.descricao
                              from kmm.v$sd_status_etapa sse
                             where sse.status_id = se.status_id) as situacao,                   
                           
                           case 
                              when sd.tempo_cobrado is null then 
                                  kss.to_tempo((select kss.sum_dsinterval(seh.horas)
                                                  from kmm.v$sd_etapa_hora seh
                                                 where seh.sd_id = sd.sd_id),3).retorno 
                           else kss.to_tempo(sd.tempo_cobrado,3).retorno end tempo_cobrado,
                                                       
                           (extract(day from sd.tempo_cobrado)*24) + extract(hour from sd.tempo_cobrado) as tempo_cobrado_horas,
                           extract(minute from sd.tempo_cobrado) as tempo_cobrado_minutos,
                           sd.tempo_cobrado_travado,
                           kmm.pkg_producao.fnc_sd_prazo_desenv_stat(sd.sd_id) as prazo_desenvolvimento,
                           to_char(sd.data_producao,'dd/mm/yyyy') as data_producao,
                           sd.data_producao_situacao_id
                      from kmm.v$sd sd
                      inner join kmm.v$projeto p
                          on sd.projeto_id = p.projeto_id   
                      inner join kmm.v$cliente c
                          on p.cliente_id = c.cliente_id           
                      inner join kmm.v$modulo m
                          on sd.modulo_id = m.modulo_id
                      inner join kmm.v$recurso r
                              on r.recurso_id = sd.responsavel_sd
                       left join kmm.v$sd_etapa se
                              on se.sd_etapa_id = sd.sd_etapa_id
                       left join kmm.v$sd_ciclo_vida scv
                              on scv.etapa_id = se.etapa_id
                       left join kmm.v$recurso tec
                              on tec.recurso_id = sd.tecnico_aprovacao
                      inner join kmm.v$sd_tipo st
                              on st.tipo_id = sd.tipo_id
                      <!--- inicio geradora --->
                      left join kmm.v$sd ger
                              on ger.sd_id = sd.sd_id_geradora
                      <!--- fim geradora --->
                      where 1=1
                       <cfif Len(trim(arguments.SD_ID))>
                      and sd.sd_id = #arguments.SD_ID#
                      </cfif>
                      <cfif Len(trim(arguments.CODIGO))>
                      and upper(sd.codigo) like upper('#arguments.CODIGO#%')
                      </cfif>
                      <cfif Len(trim(arguments.CLIENTE_ID))>
                      and c.cliente_id in (#arguments.CLIENTE_ID#)
                      </cfif>
                      <cfif Len(trim(arguments.MODULO_ID))>
                      and m.modulo_id = #arguments.MODULO_ID#
                      </cfif>
                      <cfif Len(trim(arguments.TITULO))>
                      and upper(sd.titulo) like upper('#arguments.TITULO#%')
                      </cfif>
                      <cfif isDefined("arguments.TECNICO_APROVACAO") and Len(trim(arguments.TECNICO_APROVACAO))>
                      and upper(tec.nome) = upper('#arguments.TECNICO_APROVACAO#')
                      </cfif>
                      <cfif Len(trim(arguments.PROJETO_ID))>
                      and p.projeto_id = #arguments.PROJETO_ID#
                      </cfif>
                      <cfif Len(trim(arguments.STATUS)) and arguments.STATUS neq ','>
                         and sd.status_id in (#arguments.STATUS#)
                      </cfif>
                      <cfif Len(trim(arguments.TIPO_ID))  and arguments.TIPO_ID neq ','>
                         and sd.tipo_id in (#arguments.TIPO_ID#)
                      </cfif>
                      <cfif arguments.ENCERRADAS eq 1>
                       and sd.status_id in (6,7)
                     </cfif>
                     <cfif Len(trim(arguments.DATA_INICIO)) AND Len(trim(arguments.DATA_FINAL)) >
                     and sd.data_solicitacao between ('#arguments.DATA_INICIO#') and ('#arguments.DATA_FINAL#')
                     </cfif>
                      <cfif arguments.MINHAS eq 1>
                       and exists (select 1 
                                     from kmm.v$sd_responsaveis r 
                                     inner join kmm.v$recurso re
                                             on re.recurso_id = r.recurso_id
                                    where (re.nome = user
                                    		    or
                                          (re.nome =  (select (select nome
                                                         from kmm.v$recurso re
                                                         where recurso_id = e.lider_tecnico_id) as nome
                                                 from kmm.v$equipe e
                                                inner join kmm.v$equipe_recurso er 
                                                   on er.equipe_id = e.equipe_id
                                                where e.equipe_id = (select equipe_id
                                                                       from kmm.v$equipe_recurso er
                                                                      inner join kmm.v$recurso r 
                                                                         on r.recurso_id = er.recurso_id
                                                                      where r.nome = user)
                                                  and er.funcao_id = 8) ) )
                                      and r.sd_id = sd.sd_id)
                     </cfif>
                     <cfif len(trim(arguments.DISPONIBILIZACAO_INICIAL))>
                       and (select max(sdd.data_disponibilizacao)
                              from kmm.v$sd_detalhamento sdd
                             where sdd.sd_id = sd.sd_id) >= '#arguments.DISPONIBILIZACAO_INICIAL#'
                     </cfif>
                     <cfif len(trim(arguments.DISPONIBILIZACAO_FINAL))>
                       and (select max(sdd.data_disponibilizacao)
                              from kmm.v$sd_detalhamento sdd
                             where sdd.sd_id = sd.sd_id) <= '#arguments.DISPONIBILIZACAO_FINAL#'
                     </cfif>
                     <cfif len(trim(arguments.order_by))>
                       order by #arguments.order_by#
                     <cfelse>
                      order by sd.projeto_id, decode(status_id,2,-100,9,-101,4,-200,0), decode(tipo_id,4,-100,0), to_number(sd.prioridade)
                     </cfif>
                  ) t
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os responsveis da solicitacao de desenvolvimento
	-- JONAS  06/04/2008
	--->		
	<cffunction name="get_sd_responsaveis" access="remote" returntype="query" output="true">
		<cfargument name="SD_ID" required="no" default="">
        <cfargument name="CONTROLE_ID" required="no" default="">
        <cfargument name="RECURSO_ID" required="no" default="">
        <cfargument name="FUNCAO_ID" required="no" default="">        
        <cfargument name="CLIENTE_ID" required="no" default="">        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sdr.controle_id
                   ,sdr.sd_id
                   ,sdr.recurso_id
                   ,sdr.funcao_id
                   ,sdr.ordem
                   ,c.nome as cliente_nome
                   ,r.nome as recurso_nome
                   ,r.nome_completo as recurso_nome_completo
                   ,rc.descricao as funcao_descricao
                   
			  from kmm.v$sd_responsaveis sdr
              	inner join kmm.v$recurso r on r.recurso_id = sdr.recurso_id
                inner join kmm.v$cliente c on c.cliente_id = r.cliente_id
                inner join kmm.v$recurso_funcao rc on rc.funcao_id = sdr.funcao_id
              where 1=1 
              <cfif Len(trim(arguments.SD_ID))>
              and sdr.sd_id = #arguments.SD_ID#
              </cfif>
              <cfif Len(trim(arguments.CONTROLE_ID))>
              and sdr.controle_id = #arguments.CONTROLE_ID#
              </cfif>
              <cfif Len(trim(arguments.RECURSO_ID))>
              and sdr.recurso_id = #arguments.RECURSO_ID#
              </cfif>
              <cfif Len(trim(arguments.FUNCAO_ID))>
              and sdr.funcao_id = #arguments.FUNCAO_ID#
              </cfif>
              <cfif Len(trim(arguments.CLIENTE_ID))>
              and c.cliente_id = #arguments.CLIENTE_ID#
              </cfif>
              order by ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Busca detalhamento da SD
	-- GUTO  08/04/2008
	--->		
	<cffunction name="get_sd_detalhamento" access="remote" returntype="query" output="true">
		<cfargument name="SD_ID" required="no" default="">
		<cfargument name="SD_DETALHAMENTO_ID" required="no" default="">
		<cfargument name="ajax" required="no" default="0">
        <cfargument name="exige_tarefa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sdd.sd_detalhamento_id, sdd.sd_id, <cfif arguments.ajax neq 0>to_char(sdd.descricao)<cfelse>sdd.descricao</cfif> as descricao, 
            	   to_char(substr(sdd.descricao,1,100) || '...') as resumo,
            	   sdd.status, sdd.data_previsao,  
                   sdd.tempo_total, sdd.data_disponibilizacao, sdd.data_conclusao, sdd.ordem, sdd.exige_tarefa, sd.projeto_id,
                   (select kss.fnc_concat_all(kss.to_concat_expr(st.tarefa_id,','))
                      from kmm.v$sd_tarefa st 
                     where st.sd_detalhamento_id = sdd.sd_detalhamento_id
                       and st.tipo = 1) as tarefas,
                   to_char((select max(t.entregar_em)
                      from kmm.v$sd_tarefa st 
                       inner join kmm.v$tarefa t
                                on st.tarefa_id = t.tarefa_id
                     where st.sd_detalhamento_id = sdd.sd_detalhamento_id),'dd/mm/yyyy') as entregar_em                     
              from kmm.v$sd_detalhamento sdd
              inner join kmm.v$sd sd
                      on sd.sd_id = sdd.sd_id
              where 1=1 
              <cfif Len(trim(arguments.SD_ID))>
                 and sdd.sd_id = #arguments.SD_ID#
              </cfif>
              <cfif Len(trim(arguments.EXIGE_TAREFA))>
                 and sdd.exige_tarefa = #arguments.EXIGE_TAREFA#
              </cfif>
              <cfif Len(trim(arguments.SD_DETALHAMENTO_ID))>
                 and sdd.sd_detalhamento_id in (#arguments.SD_DETALHAMENTO_ID#)
              </cfif>
              order by sd_id, ordem 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    
    
    <!--- 
	-- PROPSITO 
	-- Busca detalhamento da SD
	-- GUTO  08/04/2008
	--->		
	<cffunction name="get_sd_tempo_etapas" access="remote" returntype="query" output="true">
		<cfargument name="SD_ID" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select etapa_id, etapa, 
                   kss.to_tempo(tempo_dia,3).retorno as tempo,
                   kss.to_tempo(kss.sum_dsinterval(tempo_dia) over(),3).retorno as tempo_total
              from (select te.etapa_id, ce.descricao as etapa
                           ,kss.sum_dsinterval(te.tempo_estimado) as tempo_dia
                                  from kmm.v$sd_detalhamento sdd
                                  inner join kmm.v$sd_tarefa st
                                          on st.sd_detalhamento_id = sdd.sd_detalhamento_id
                                  inner join kmm.v$tarefa t
                                          on t.tarefa_id = st.tarefa_id
                                  inner join kmm.v$tarefa_etapa te
                                          on te.tarefa_id = t.tarefa_id
                                  inner join kmm.v$ciclo_vida_etapa ce
                                          on ce.etapa_id = te.etapa_id
                                 where sdd.sd_id =#arguments.SD_ID#
                    group by te.etapa_id, ce.descricao
                    union all
                    select ce.etapa_id, ce.descricao as etapa,
                           kss.sum_dsinterval(se.tempo_estimado) as tempo_dia
                      from kmm.v$sd_analise sa
                     inner join kmm.v$sd_analise_etapa se
                             on sa.analise_id = se.analise_id 
                     inner join kmm.v$ciclo_vida_etapa ce
                             on ce.etapa_id = se.etapa_id
                    where sa.sd_id = #arguments.SD_ID#
                      and not exists (select 1 
                                        from kmm.v$tarefa t
                                       where t.analise_id = sa.analise_id)                    
                    group by ce.etapa_id, ce.descricao)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

    <!--- 
	-- PROPSITO 
	-- Busca horas da SD
	-- GUTO  08/04/2008
	--->		
	<cffunction name="get_sd_etapa_hora" access="remote" returntype="query" output="true">
		<cfargument name="SD_ID" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select seh.controle_id, seh.sd_id, 
                   seh.etapa_id, ce.descricao as etapa, seh.confirmado, 
                   kss.to_tempo(seh.horas,4).retorno as horas,
                   kss.to_tempo(seh.horas,3).retorno as tempo,
                   kss.to_tempo(kss.sum_dsinterval(seh.horas) over(),3).retorno as tempo_total,
                   ((sysdate + (kss.sum_dsinterval(seh.horas) over()) - sysdate) * 24) * p.valor_hora as valor_total, p.projeto_id
              from kmm.v$sd sd
              inner join kmm.v$sd_etapa_hora seh
                      on seh.sd_id = sd.sd_id
              inner join kmm.v$projeto p
                      on p.projeto_id = sd.projeto_id
              inner join kmm.v$ciclo_vida_etapa ce
                      on ce.etapa_id = seh.etapa_id
                 where seh.sd_id = #arguments.SD_ID#  
                order by ce.num_etapa
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>      

    <!--- 
	 -- PROPSITO 
	 -- Buscas os tipos possveis de uma solicitao de desenvolvimento
	 -- JONAS  08/04/2009
	 --->  
	 <cffunction name="get_sd_tipo" access="remote" returntype="query" output="true">
     	<cfargument name="TIPO_ID" required="no" default="">
        <cfargument name="DESCRICAO" required="no" default="">
	 	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select 	sdt.tipo_id,
                    sdt.descricao
             from kmm.v$sd_tipo sdt
                      where 1=1 
                      <cfif Len(trim(arguments.TIPO_ID))>
                      and sdt.tipo_id = #arguments.TIPO_ID#
                      </cfif>
                      <cfif Len(trim(arguments.DESCRICAO))>
                      and sdt.descricao = #arguments.DESCRICAO#
                      </cfif>
	  	</cfquery>
	  <cfreturn qr_result>  
	 </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Avaliao da SD
	-- jonas  25/04/2009
	--->
	<cffunction name="get_sd_avaliacao" access="remote" returntype="query" output="true">
		<cfargument name="SD_ID" required="no" default="">
        <cfargument name="ITEM_ID" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sa.controle_id,sa.item_id,sa.responsavel_nota,sa.cliente_nota,sa.responsavel_observacao,sa.cliente_observacao
              from kmm.v$sd_avaliacao sa
              where 1=1
              <cfif Len(trim(arguments.SD_ID))>
                 and sa.sd_id = #arguments.SD_ID#
              </cfif>
              <cfif Len(trim(arguments.ITEM_ID))>
                 and sa.item_id = #arguments.ITEM_ID#
              </cfif>
              order by sa.sd_id
         </cfquery>
		<cfreturn qr_result>		
	</cffunction>    
     
    <!--- 
	-- PROPSITO 
	-- Busca Item de Avaliao da SD
	-- jonas  25/04/2009
	--->
	<cffunction name="get_sd_avaliacao_item" access="remote" returntype="query" output="true">
    	<cfargument name="SD_ID" required="no" default="">
		<cfargument name="ITEM_ID" required="no" default="">
        <cfargument name="OBRIGATORIO" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sai.item_id,sai.texto,sai.obrigatorio
              from kmm.v$sd_avaliacao_item sai
              where 1=1 
              <cfif Len(trim(arguments.ITEM_ID))>
                 and sai.item_id = #arguments.ITEM_ID#
              </cfif>
              <cfif Len(trim(arguments.SD_ID))>
                 and sai.sd_id = #arguments.SD_ID#
              </cfif>
              <cfif Len(trim(arguments.OBRIGATORIO))>
                 and sai.obrigatorio = #arguments.OBRIGATORIO#
              </cfif>
              order by sai.item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
     <!--- 
	-- PROPSITO 
	-- Busca Item de Avaliao da SD para relatrio
	-- Rafael  12/05/2009
	--->
	<cffunction name="get_sd_relatorio_avaliacao" access="remote" returntype="query" output="true">
    	<cfargument name="SD_ID" required="no" default="">
		<cfargument name="ITEM_ID" required="no" default="">
        <cfargument name="OBRIGATORIO" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sai.item_id,sai.texto,sai.obrigatorio,sa.responsavel_nota, sa.cliente_nota, sa.responsavel_observacao, sa.cliente_observacao
              from kmm.v$sd_avaliacao_item sai
              
              inner join kmm.v$sd_avaliacao sa
                      on sa.item_id = sai.item_id
              
              where 1=1 
              <cfif Len(trim(arguments.ITEM_ID))>
                 and sai.item_id = #arguments.ITEM_ID#
              </cfif>
              <cfif Len(trim(arguments.SD_ID))>
                 and sa.sd_id = #arguments.SD_ID#
              </cfif>
              <cfif Len(trim(arguments.OBRIGATORIO))>
                 and sai.obrigatorio = #arguments.OBRIGATORIO#
              </cfif>
                       
              
              order by sai.item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Retorna status para a S.D.
	-- GUTO - 01/07/2006
	--->		
	<cffunction name="get_status_sd" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select c.id, c.descricao
              from kmm.v$cg_ref_codes c
              where c.dominio = 'SD STATUS'
   		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Retorna atribuies do recurso
	-- GUTO - 01/07/2006
	--->		
	<cffunction name="get_atribuicao_recurso" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" required="no" default=""/>
    	<cfargument name="usuario" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(data_limite,'dy - dd/mm/yyyy') as data_limite, 
            	   kss.to_tempo(kss.sum_dsinterval(tempo),3).retorno as tempo
              from (	
                    select te.data_limite, kss.sum_dsinterval(te.tempo_estimado) as tempo
                      from kmm.v$tarefa t
                     inner join kmm.v$tarefa_etapa te
                             on te.tarefa_id = t.tarefa_id
                     inner join kmm.v$recurso r
                             on r.recurso_id = te.recurso_id  
                     where 1=1
                       <cfif Len(Trim(arguments.recurso_id))>
	                       and te.recurso_id = #arguments.recurso_id#
                       </cfif>
                       <cfif Len(Trim(arguments.usuario))>
	                       and r.nome = upper('#arguments.usuario#')
                       </cfif>
                       and t.status not in (7,8,10)
                    group by te.data_limite
                    union
                    select trunc(data) as data, numtodsinterval(0,'DAY') as tempo
                      from (select sysdate+level-4 as data
                              from dual connect by level <= 30)
                     where 1=1
                     order by data_limite
                    )
            group by data_limite
            
   		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Busca Hora Extra
	-- jonas  04/05/2009
	--->
	<cffunction name="get_recurso_hora_extra" access="remote" returntype="query" output="true">
		<cfargument name="autorizacao_id" required="no" default="">
        <cfargument name="recurso_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select he.autorizacao_id
            		,to_char(he.data_emissao,'dd/mm/yyyy') as data_emissao
                    ,he.recurso_id
                    ,r.nome as recurso_nome
                    ,r.nome_completo as recurso_nome_completo
                    ,he.cod_cargo
                    ,c.cargo as cargo
                    ,he.descricao_atividades
                    ,he.justificativa
                    ,to_char(he.autorizado_em,'dd/mm/yyyy') as autorizado_em
                    ,he.autorizado_por
                    ,r2.nome as autorizado_por_nome
                    ,r2.nome_completo as autorizado_por_nome_completo
              from kmm.v$recurso_hora_extra he
              inner join kmm.v$recurso r 
              	on r.recurso_id = he.recurso_id
              inner join kmm.v$recurso r2 
              	on r2.recurso_id = he.autorizado_por
              inner join rh.rh_cargos_salarios c
              	on c.cod_cargo = he.cod_cargo
              where 1=1
              <cfif Len(trim(arguments.AUTORIZACAO_ID))>
                 and he.autorizacao_id = #arguments.AUTORIZACAO_ID#
              </cfif>
              <cfif Len(trim(arguments.RECURSO_ID))>
                 and r.recurso_id = #arguments.RECURSO_ID#
              </cfif>
              order by he.autorizacao_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Item de  Hora Extra
	-- jonas  04/05/2009
	--->
	<cffunction name="get_recurso_hora_extra_it" access="remote" returntype="query" output="true">
		<cfargument name="autorizacao_id" required="no" default="">
        <cfargument name="item_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 	
            		hei.item_id
            		,hei.autorizacao_id
            		,to_char(hei.data,'dd/mm/yyyy') as data
                    ,hei.hora_inicio
                    ,hei.hora_termino
                    ,hei.numero_horas
              from kmm.v$recurso_hora_extra_it hei
              where 1=1
              <cfif Len(trim(arguments.AUTORIZACAO_ID))>
                 and hei.autorizacao_id = #arguments.AUTORIZACAO_ID#
              </cfif>
              order by hei.autorizacao_id,hei.item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os comentrios de uma SD
    -- ANDERSON 10/08/2009 - CRIADO
    --->
    <cffunction name="get_sd_comentarios" access="remote" returntype="query" output="true">
        <cfargument name="sd_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.controle_id
                 , c.sd_id
                 , c.comentario
				 , to_char(c.date_insert, 'dd/mm/yyyy hh24:mi') as date_insert
                 , c.user_insert
              from kmm.v$sd_comentario c
             where 1 = 1
			<cfif Len(Trim(arguments.sd_id))>
               and c.sd_id = #arguments.sd_id#
			</cfif>
             order by c.date_insert
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca analise
    -- ANDERSON 10/08/2009 - CRIADO
    --->
    <cffunction name="get_sd_analise" access="remote" returntype="query" output="true">
        <cfargument name="sd_id" required="no" default="">
        <cfargument name="analise_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select sa.analise_id
                	   ,sa.sd_id
                       ,sa.titulo
                       ,sa.tipo_aplicacao_id
                       ,sa.analise
                       ,sa.contato_id
                       ,sa.tipo_id
                       ,sa.urgencia_id
              from kmm.v$sd_analise sa
             where 1 = 1
			<cfif Len(Trim(arguments.sd_id))>
               and sa.sd_id = #arguments.sd_id#
			</cfif>
			<cfif Len(Trim(arguments.analise_id))>
               and sa.analise_id = #arguments.analise_id#
			</cfif>
             order by sa.analise_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca analise detalhamentos
    -- ANDERSON 10/08/2009 - CRIADO
    --->
    <cffunction name="get_sd_analise_detalhamento" access="remote" returntype="query" output="true">
        <cfargument name="analise_id" required="no" default="">
        <cfargument name="sd_id" required="no" default="">
        <cfargument name="sd_detalhamento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sa.analise_id
            	 , sa.titulo
                 , (select cg.descricao 
                      from kmm.v$cg_ref_codes cg
                     where cg.id = sa.tipo_aplicacao_id 
                       and cg.dominio = 'TIPO APLICACAO TAREFA') as tipo_aplicacao
                 , sad.detalhamento_id
                 , sad.analise_id
                 , sad.sd_detalhamento_id
                 , (select r.nome
                      from kmm.v$recurso r
                     where r.recurso_id = sa.contato_id) as contato
                 , t.tarefa_id
                 , to_char(t.entregar_em,'dd/mm/yyyy') as entregar_em
                 , (select kss.fnc_concat_all(kss.to_concat_expr(sae.etapa_id,','))
                      from kmm.v$sd_analise_etapa sae
                     where sae.analise_id = sa.analise_id) as etapas_id
                 , kss.to_tempo(numtodsinterval((select sum(sysdate + sae.tempo_estimado - sysdate)
                                                   from kmm.v$sd_analise_etapa sae
                                                  where sae.analise_id = sa.analise_id),'day'),3).retorno as tempo_estimado
              from kmm.v$sd_analise sa
             inner join kmm.v$sd_analise_detalhamento sad
                     on sa.analise_id = sad.analise_id             
             left join kmm.v$tarefa t
                    on t.analise_id = sa.analise_id
                   and t.status <> 8
             where 1 = 1
			<cfif Len(Trim(arguments.sd_detalhamento_id))>
               and sad.sd_detalhamento_id = #arguments.sd_detalhamento_id#
			</cfif>
			<cfif Len(Trim(arguments.analise_id))>
               and sad.analise_id = #arguments.analise_id#
			</cfif>
			<cfif Len(Trim(arguments.sd_id))>
               and sa.sd_id = #arguments.sd_id#
			</cfif>
             order by sa.analise_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca analise detalhamentos
    -- ANDERSON 10/08/2009 - CRIADO
    --->
    <cffunction name="get_sd_analise_detalhamento_tarefas" access="remote" returntype="query" output="true">
        <cfargument name="analise_id" required="no" default="">
        <cfargument name="sd_detalhamento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sa.analise_id
            	 , sa.titulo
                 , (select cg.descricao 
                      from kmm.v$cg_ref_codes cg
                     where cg.id = sa.tipo_aplicacao_id 
                       and cg.dominio = 'TIPO APLICACAO TAREFA') as tipo_aplicacao
                 , sa.analise_id
                 , (select r.nome
                      from kmm.v$recurso r
                     where r.recurso_id = sa.contato_id) as contato
                 , t.tarefa_id
                 , to_char(t.entregar_em,'dd/mm/yyyy') as entregar_em
                 , (select kss.fnc_concat_all(kss.to_concat_expr(sdd.ordem/2,','))
                      from kmm.v$sd_analise_detalhamento sad
                     inner join kmm.v$sd_detalhamento sdd
                        on sdd.sd_detalhamento_id = sad.sd_detalhamento_id
                     where sad.analise_id = sa.analise_id) as detalhamento_item_id
                 , (select kss.fnc_concat_all(kss.to_concat_expr(sae.etapa_id,','))
                      from kmm.v$sd_analise_etapa sae
                     where sae.analise_id = sa.analise_id) as etapas_id
                 , (select sum(sysdate + sae.tempo_estimado - sysdate)
                      from kmm.v$sd_analise_etapa sae
                     where sae.analise_id = sa.analise_id) as horas_estimado
                 , kss.to_tempo(numtodsinterval((select sum(sysdate + sae.tempo_estimado - sysdate)
                                                   from kmm.v$sd_analise_etapa sae
                                                  where sae.analise_id = sa.analise_id),'day'),3).retorno as tempo_estimado
              from kmm.v$sd_analise sa
             left join kmm.v$tarefa t
                    on t.analise_id = sa.analise_id
                   and t.status <> 8
             where 1 = 1
			<cfif Len(Trim(arguments.sd_detalhamento_id))>
               and sad.sd_detalhamento_id = #arguments.sd_detalhamento_id#
			</cfif>
			<cfif Len(Trim(arguments.analise_id))>
               and sad.analise_id = #arguments.analise_id#
			</cfif>
			<cfif Len(Trim(arguments.sd_id))>
               and sa.sd_id = #arguments.sd_id#
			</cfif>
             order by sa.analise_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
    <!--- 
    -- PROPSITO 
    -- Busca analise etapas
    -- ANDERSON 10/08/2009 - CRIADO
    --->
    <cffunction name="get_sd_analise_etapa" access="remote" returntype="query" output="true">
        <cfargument name="analise_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sae.controle_id, sae.analise_id, sae.etapa_id, 
            	   sae.dias,
                   to_char(extract(day from sae.tempo_estimado) *24 + extract(hour from sae.tempo_estimado),'FM00') as hora,
                   to_char(extract(minute from sae.tempo_estimado),'FM00') as minuto
              from kmm.v$sd_analise_etapa sae             
              where 1 = 1
			<cfif Len(Trim(arguments.analise_id))>
               and sae.analise_id = #arguments.analise_id#
			</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>      
    
    <!--- 
    -- PROPSITO 
    -- Busca analise habilidades
    -- ANDERSON 10/08/2009 - CRIADO
    --->
    <cffunction name="get_sd_analise_habilidade" access="remote" returntype="query" output="true">
        <cfargument name="analise_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sah.controle_id
                   ,sah.analise_id
                   ,sah.habilidade_id
                   ,(select descricao 
                       from kmm.v$habilidade h
                      where h.habilidade_id = sah.habilidade_id) as habilidade
                   ,sah.nivel_id
                   ,(select descricao 
                       from kmm.v$habilidade_nivel h
                      where h.nivel_id = sah.nivel_id) as nivel
              from kmm.v$sd_analise_habilidade sah
              where 1 = 1
			<cfif Len(Trim(arguments.analise_id))>
               and sah.analise_id = #arguments.analise_id#
			</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>          
    

	<!--- 
	-- PROPSITO 
	-- Busca a produtividade das equipees
	-- CRISTOFER  26/04/2010
	--->		
	<cffunction name="get_produtividade_equipe" access="remote" returntype="query" output="true">
    	<cfargument name="equipe_id" required="no" default="">
        <cfargument name="recurso_id" required="no" default="">
        <cfargument name="dias_retroagir" required="no" default="84">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-84,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select equipe_id,
                   equipe,
                   tempo_produtivo,
                   tempo_total,
                   cap_produtiva,
                   meta_produtiva,
                   tempo_produtivo/cap_produtiva as percentual_produtivo,
                   tempo_total/cap_produtiva as percentual_total,
                   meta_produtiva/cap_produtiva as percentual_meta,
                   ceil(to_date('#arguments.data_final#')-to_date('#arguments.data_inicial#')) as dias_analise
              from (select eq.equipe_id,
                           eq.descricao as equipe,
                           sum(to_date('1/1/2000') + te.tempo_estimado - to_date('1/1/2000')) * 24 as tempo_total,
                           sum(case when s.tipo_id in (1, 2, 3) then to_date('1/1/2000') + te.tempo_estimado - to_date('1/1/2000') else 0 end) * 24 as tempo_produtivo,
                           (select sum(kmm.pkg_tarefa.fnc_capacidade_produtiva(er.recurso_id,'#arguments.data_inicial#','#arguments.data_final#'))
                              from kmm.v$equipe_recurso er
                             inner join kmm.v$recurso r on r.recurso_id = er.recurso_id
                             where er.equipe_id = eq.equipe_id
							 <cfif len(trim(arguments.recurso_id))>
                               and r.recurso_id in (#arguments.recurso_id#)
                             </cfif>
                             ) as cap_produtiva,
                           (select sum(kmm.pkg_tarefa.fnc_capacidade_produtiva(er.recurso_id,'#arguments.data_inicial#','#arguments.data_final#') * (r.produtividade / 100))
                              from kmm.v$equipe_recurso er
                             inner join kmm.v$recurso r on r.recurso_id = er.recurso_id
                             where er.equipe_id = eq.equipe_id
							 <cfif len(trim(arguments.recurso_id))>
                               and r.recurso_id in (#arguments.recurso_id#)
                             </cfif>
                             ) as meta_produtiva
                      from kmm.v$sd s
                     inner join (select tarefa_id, sd_id
                           from kmm.v$sd_tarefa t
                          group by tarefa_id, sd_id) st on st.sd_id = s.sd_id
                     inner join kmm.v$tarefa t on t.tarefa_id = st.tarefa_id
                     inner join kmm.v$tarefa_etapa te on te.tarefa_id = t.tarefa_id
                     inner join kmm.v$equipe_recurso er on er.recurso_id = te.recurso_id
                     inner join kmm.v$equipe eq on eq.equipe_id = er.equipe_id
                     left join kmm.v$tarefa_atribuicao ta on ta.atribuicao_id = t.atribuicao_id 
            		 where (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
                       and t.entregar_em >= '#arguments.data_inicial#'
                       and eq.apoio = 0
                     <cfif len(trim(arguments.equipe_id))>
                       and er.equipe_id in (#arguments.equipe_id#)
                     </cfif>
                     <cfif len(trim(arguments.recurso_id))>
                       and te.recurso_id in (#arguments.recurso_id#)
                     </cfif>
                     group by eq.equipe_id, eq.descricao)
             order by equipe_id
             
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_produtividade_equipe_recurso" access="remote" returntype="query" output="true">
    	<cfargument name="equipe_id" required="no" default="">
        <cfargument name="recurso_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-28,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.equipe_id,
                   a.equipe,
                   a.recurso_id, 
                   a.nome_completo,
                   a.nome,
                   a.rank,
                   a.tempo_produtivo,
                   a.tempo_total,
                   a.produtividade,
                   a.meta_produtiva,
                   a.tempo_produtivo/a.cap_produtiva as percentual_produtivo,
                   kss.to_tempo(numtodsinterval(a.cap_produtiva,'hour'),3).retorno as cap_produtiva_desc,
                   (select max(pr.tempo_produtivo/pr.capacidade_produtiva) keep (dense_rank last order by pr.data)
                      from kmm.v$produtividade_relatorio pr
                     where pr.recurso_id = a.recurso_id
                       and pr.equipe_id = a.equipe_id
                       and pr.data < trunc(sysdate)
                       and kmm.pkg_tarefa.fnc_dia_util(pr.data) = 1) as percentual_produtivo_ant,
                   a.tempo_total/a.cap_produtiva as percentual_total,
                   (select max(pr.tempo_total/pr.capacidade_produtiva) keep (dense_rank last order by pr.data)
                      from kmm.v$produtividade_relatorio pr
                     where pr.recurso_id = a.recurso_id
                       and pr.equipe_id = a.equipe_id
                       and pr.data < trunc(sysdate)
                       and kmm.pkg_tarefa.fnc_dia_util(pr.data) = 1) as percentual_total_ant,
                   (select max(pr.data)
                      from kmm.v$produtividade_relatorio pr
                     where pr.recurso_id = a.recurso_id
                       and pr.equipe_id = a.equipe_id
                       and pr.data < trunc(sysdate)
                       and kmm.pkg_tarefa.fnc_dia_util(pr.data) = 1) as data_ant,
                   a.meta_produtiva/a.cap_produtiva as percentual_meta
              from (select eq.equipe_id,
                           eq.descricao as equipe,
                           sum(to_date('1/1/2000') + te.tempo_estimado - to_date('1/1/2000')) * 24 as tempo_total,
                           sum(case when s.tipo_id in (1, 2, 3) then to_date('1/1/2000') + te.tempo_estimado - to_date('1/1/2000') else 0 end) * 24 as tempo_produtivo,
                           kmm.pkg_tarefa.fnc_capacidade_produtiva(er.recurso_id,'#arguments.data_inicial#','#arguments.data_final#') as cap_produtiva,
                           kmm.pkg_tarefa.fnc_capacidade_produtiva(er.recurso_id,'#arguments.data_inicial#','#arguments.data_final#') * (r.produtividade / 100) as meta_produtiva,
                           dense_rank() over (order by (sum(to_date('1/1/2000') + te.tempo_estimado - to_date('1/1/2000')) * 24)/kmm.pkg_tarefa.fnc_capacidade_produtiva(er.recurso_id,'#arguments.data_inicial#','#arguments.data_final#') desc) as rank,
                           er.recurso_id,
                           r.nome_completo,
                           r.nome,
                           r.produtividade
                      from kmm.v$sd s
                     inner join (select tarefa_id, sd_id
                           from kmm.v$sd_tarefa t
                          group by tarefa_id, sd_id) st on st.sd_id = s.sd_id
                     inner join kmm.v$tarefa t on t.tarefa_id = st.tarefa_id
                     inner join kmm.v$tarefa_etapa te on te.tarefa_id = t.tarefa_id
                     inner join kmm.v$equipe_recurso er on er.recurso_id = te.recurso_id
                     inner join kmm.v$recurso r on r.recurso_id = er.recurso_id and r.exibir_ranking = 1
                     inner join kmm.v$equipe eq on eq.equipe_id = er.equipe_id
                     left join kmm.v$tarefa_atribuicao ta on ta.atribuicao_id = t.atribuicao_id 
             		where (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
                       and t.entregar_em >= '#arguments.data_inicial#'
                     group by eq.equipe_id, eq.descricao, er.recurso_id, r.nome_completo, r.produtividade, r.nome) a
             where 1=1
             <cfif len(trim(arguments.equipe_id))>
               and equipe_id in (#arguments.equipe_id#)
             </cfif>
             <cfif len(trim(arguments.recurso_id))>
               and recurso_id in (#arguments.recurso_id#)
             </cfif>
             order by tempo_total/cap_produtiva desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	
    
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_tarefas_produtividade" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tarefa_id,
                   t.titulo tarefa,
                   to_char(t.entregar_em,'dd/mm/yyyy hh24:mi:ss') as entregar_em,
                   s.sd_id,
                   s.codigo,
                   s.titulo sd,
                   to_char(s.data_entrega_cliente,'dd/mm/yyyy hh24:mi:ss') as data_entrega_cliente,
                   (to_date('1/1/2000') + (kss.sum_dsinterval(te.tempo_estimado)/count(distinct er.equipe_id)) - to_date('1/1/2000')) * 24 as tempo,
                   kss.to_tempo(kss.sum_dsinterval(te.tempo_estimado)/count(distinct er.equipe_id),3).retorno as tempo_total,
                   kss.to_tempo(kss.sum_dsinterval(kss.sum_dsinterval(te.tempo_estimado)) over ()/count(distinct er.equipe_id),3).retorno as tempo_total_geral,
                   
                   ((to_date('1/1/2000') + kss.sum_dsinterval(kss.sum_dsinterval(te.tempo_estimado)) over () - to_date('1/1/2000')) * 24)/count(distinct er.equipe_id) as horas_total_geral,

                   kss.to_tempo(numtodsinterval(kmm.pkg_tarefa.fnc_capacidade_produtiva(#arguments.recurso_id#),'hour'),3).retorno as capacidade_total,
                   kmm.pkg_tarefa.fnc_capacidade_produtiva(#arguments.recurso_id#) as capacidade_total_horas,
                   (select count(*)
                      from kmm.v$tarefa_atraso ta
                     where ta.tarefa_id = t.tarefa_id
                       and ta.recurso_id = r.recurso_id) as nro_atrasos
                   
              from kmm.v$sd s
             inner join (select tarefa_id, sd_id
                           from kmm.v$sd_tarefa t
                          group by tarefa_id, sd_id) st 
                on st.sd_id = s.sd_id
             inner join kmm.v$tarefa t 
                on t.tarefa_id = st.tarefa_id
             inner join kmm.v$tarefa_etapa te 
                on te.tarefa_id = t.tarefa_id
             inner join kmm.v$equipe_recurso er 
                on er.recurso_id = te.recurso_id
             inner join kmm.v$recurso r 
                on r.recurso_id = er.recurso_id 
               and r.exibir_ranking = 1
             inner join kmm.v$equipe eq 
                on eq.equipe_id = er.equipe_id
              left join kmm.v$tarefa_atribuicao ta 
                on ta.atribuicao_id = t.atribuicao_id 
             where (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
               and t.entregar_em >= sysdate - 28
             <cfif len(trim(arguments.recurso_id))>
               and te.recurso_id = #arguments.recurso_id#
             </cfif>
             group by t.tarefa_id,
                   t.titulo,
                   t.entregar_em,
                   r.recurso_id, s.codigo, s.titulo, s.data_entrega_cliente, s.sd_id
             order by t.entregar_em desc, t.tarefa_id desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>         	    

	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_equipe_recurso_funcao" access="remote" returntype="query" output="true">
    	<cfargument name="usuario" required="no" default="">
    	<cfargument name="funcao_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select er.*
              from kmm.v$equipe_recurso er
             inner join kmm.v$recurso r
                on r.recurso_id = er.recurso_id
             where er.funcao_id in (#arguments.funcao_id#)
               and upper(trim(r.nome)) = '#arguments.usuario#'
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_recurso_produtividade" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" required="no" default="">
    	<cfargument name="equipe_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select produtividade_id, 
                   data, 
                   recurso_id, 
                   capacidade_produtiva, 
                   produtividade, 
                   meta_produtiva, 
                   tempo_produtivo, 
                   tempo_total, 
                   tempo_produtivo/capacidade_produtiva*100 as percentual_produtivo,
                   tempo_total/capacidade_produtiva*100 as percentual_total,
                   meta_produtiva/capacidade_produtiva*100 as percentual_meta,
                   (meta_produtiva/capacidade_produtiva*100)-20 as percentual_meta_abaixo,
                   0 as zero,
                   100 as cem,
                   date_insert, 
                   user_insert, 
                   date_update, 
                   user_update, 
                   site, 
                   equipe_id
              from kmm.v$produtividade_relatorio 
             where 1=1
               and recurso_id = #arguments.recurso_id#
               and equipe_id = #arguments.equipe_id#
               and trunc(data) between to_date('#arguments.data_inicial#') and to_date('#arguments.data_final#')
             order by data
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    
   
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_recurso_produtividade_equipe" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" required="no" default="">
    	<cfargument name="equipe_id" required="no" default="">
    	<cfargument name="total" required="no" default="0">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-28,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select data, 
                   sum(capacidade_produtiva) as capacidade_produtiva,
                   sum(meta_produtiva) as meta_produtiva,
                   sum(tempo_produtivo) as tempo_produtivo,
                   sum(tempo_total) as tempo_total,
                   sum(tempo_produtivo)/sum(capacidade_produtiva)*100 as percentual_produtivo,
                   sum(tempo_total)/sum(capacidade_produtiva)*100 as percentual_total,
                   sum(meta_produtiva)/sum(capacidade_produtiva)*100 as percentual_meta,
                   (sum(meta_produtiva)/sum(capacidade_produtiva)*100)-20 as percentual_meta_abaixo,
                   0 as zero,
                   100 as cem
                   <cfif arguments.total neq 1>
                   , equipe_id
                   </cfif>
              from kmm.v$produtividade_relatorio pr
             where 1=1
			 <cfif len(trim(arguments.equipe_id))>
               and pr.equipe_id in (#arguments.equipe_id#)
             </cfif>
             <cfif len(trim(arguments.recurso_id))>
               and pr.recurso_id in (#arguments.recurso_id#)
             </cfif>
               and trunc(data) between '#arguments.data_inicial#' and '#arguments.data_final#'
             <cfif arguments.total eq 1>
             group by data
             order by data
             <cfelse>
             group by data, equipe_id
             order by equipe_id, data
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    
            
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_equipe_produtividade_tipo" access="remote" returntype="query" output="true">
    	<cfargument name="equipe_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select equipe_id,
                   equipe,
                   tipo_id,
                   tipo,
                   tempo,
                   tempo_total,
                   capacidade_total,
                   (tempo_total/capacidade_total)*100 as perc_total,
                   (tempo/capacidade_total)*100 as perc,
                   (tempo/tempo_total)*100 as perc_prod
            from (
            select eq.equipe_id,
                   t.tipo_id,
                   (select descricao
                      from kmm.v$cg_ref_codes c
                     where c.dominio = 'TIPO TAREFA'
                       and c.id = t.tipo_id) as tipo,
                   (to_date('1/1/2000') + kss.sum_dsinterval(te.tempo_estimado) - to_date('1/1/2000'))*24 as tempo,
                   (to_date('1/1/2000') + (select numtodsinterval(sum(kmm.pkg_tarefa.fnc_capacidade_produtiva(er2.recurso_id,trunc(sysdate-28),trunc(sysdate))),'hour')
                                             from kmm.v$equipe_recurso er2
                                            where er2.equipe_id = eq.equipe_id) - (to_date('1/1/2000')))*24 as capacidade_total,
                   sum((to_date('1/1/2000') + kss.sum_dsinterval(te.tempo_estimado) - to_date('1/1/2000'))*24) over(partition by eq.equipe_id) as tempo_total,
                   eq.descricao as equipe
              from kmm.v$sd s
             inner join (select tarefa_id, sd_id
                   from kmm.v$sd_tarefa t
                  group by tarefa_id, sd_id) st on st.sd_id = s.sd_id
             inner join kmm.v$tarefa t on t.tarefa_id = st.tarefa_id
             inner join kmm.v$tarefa_etapa te on te.tarefa_id = t.tarefa_id
             inner join kmm.v$equipe_recurso er on er.recurso_id = te.recurso_id
             inner join kmm.v$equipe eq on eq.equipe_id = er.equipe_id
             inner join kmm.v$projeto_tarefa pt on pt.tarefa_id = t.tarefa_id
             inner join kmm.v$projeto pr on pr.projeto_id = pt.projeto_id
              left join kmm.v$tarefa_atribuicao ta on ta.atribuicao_id = t.atribuicao_id
            where (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
                  and t.entregar_em >= sysdate - 28
                  and eq.apoio = 0
            /*      and pr.cliente_id = 9 */
            group by eq.equipe_id, eq.descricao, t.tipo_id)
            where 1=1
            <cfif len(trim(arguments.equipe_id))>
              and equipe_id = #arguments.equipe_id#
            </cfif>
            order by tipo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_produtividade_recurso_acumulada" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" required="no" default="">
    	<cfargument name="equipe_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-28,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select data,
                   nome,
                   sum(capacidade) as capacidade,
                   sum(tempo_produtivo) as tempo_produtivo,
                   sum(tempo_total) as tempo_total,
                   sum(sum(capacidade)) over (partition by nome order by data) as capacidade_acumulada,
                   kss.to_tempo(numtodsinterval(sum(sum(capacidade)) over (partition by nome order by data),'hour'),3).retorno as capacidade_acumulada_form,
                   sum(sum(tempo_produtivo)) over (partition by nome order by data) as produtivo_acumulado,
                   kss.to_tempo(numtodsinterval(sum(sum(tempo_produtivo)) over (partition by nome order by data),'hour'),3).retorno as produtivo_acumulado_form,
                   sum(sum(tempo_total)) over (partition by nome order by data) as total_acumulado,
                   kss.to_tempo(numtodsinterval(sum(sum(tempo_total)) over (partition by nome order by data),'hour'),3).retorno as total_acumulado_form
              from (select dt.data,
              			 <cfif len(trim(arguments.equipe_id))>
                           'Equipe' as nome,
                         <cfelseif len(trim(arguments.recurso_id))>
                           r.nome,
                         </cfif>
                           nvl(kmm.pkg_tarefa.fnc_capacidade_produtiva(r.recurso_id,dt.data,dt.data),0) as capacidade,
                           (select (to_date('1/1/2000') + kss.sum_dsinterval(te.tempo_estimado) - to_date('1/1/2000'))*24
                              from kmm.v$tarefa_etapa te
                             inner join kmm.v$tarefa t
                                on t.tarefa_id = te.tarefa_id
                              left join kmm.v$tarefa_atribuicao ta
                                on ta.atribuicao_id = t.atribuicao_id
                             where te.recurso_id = r.recurso_id
                               and (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
                               and t.entregar_em = dt.data
                               and t.tipo_id <> 1
                             ) as tempo_produtivo,
                           (select (to_date('1/1/2000') + kss.sum_dsinterval(te.tempo_estimado) - to_date('1/1/2000'))*24
                              from kmm.v$tarefa_etapa te
                             inner join kmm.v$tarefa t
                                on t.tarefa_id = te.tarefa_id
                              left join kmm.v$tarefa_atribuicao ta
                                on ta.atribuicao_id = t.atribuicao_id
                             where te.recurso_id = r.recurso_id
                               and (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
                               and t.entregar_em = dt.data
                             ) as tempo_total
                      from (select trunc(to_date('#arguments.data_inicial#'))+level-1 as data
                              from dual
                           connect by trunc(to_date('#arguments.data_inicial#'))+level-1 <= trunc(to_date('#arguments.data_final#'))) dt
                     cross join kmm.v$recurso r
                     where r.tecnico = 1
                       and r.exibir_ranking = 1
                     <cfif len(trim(arguments.recurso_id))>
                       and r.recurso_id = #arguments.recurso_id#
                     </cfif>
                     <cfif len(trim(arguments.equipe_id))>
                       and r.recurso_id in (select recurso_id from kmm.v$equipe_recurso er where er.equipe_id in (#arguments.equipe_id#))
                     </cfif>
                     order by nome, data)
                 group by data, nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_produtividade_recurso_etapa" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" required="no" default="">
    	<cfargument name="equipe_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-28,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select te.etapa_id,
                   ce.descricao as etapa,
                   (to_date('1/1/2000') + kss.sum_dsinterval(te.tempo_estimado) - to_date('1/1/2000'))*24 as horas,
                   kss.to_tempo(kss.sum_dsinterval(te.tempo_estimado),3).retorno as horas_formatadas
              from kmm.v$tarefa_etapa te
             inner join kmm.v$ciclo_vida_etapa ce
                on ce.etapa_id = te.etapa_id
             inner join kmm.v$tarefa t
                on t.tarefa_id = te.tarefa_id
              left join kmm.v$tarefa_atribuicao ta
                on ta.atribuicao_id = t.atribuicao_id
             where (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
               and t.entregar_em between trunc(to_date('#arguments.data_inicial#')) and trunc(to_date('#arguments.data_final#'))
             <cfif len(trim(arguments.equipe_id))>
               and te.recurso_id in (select recurso_id from kmm.v$equipe_recurso er where er.equipe_id in (#arguments.equipe_id#))
             </cfif>
             <cfif len(trim(arguments.recurso_id))>
               and te.recurso_id in (#arguments.recurso_id#)
             </cfif>
             group by te.etapa_id, ce.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_produtividade_recurso_tipo" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" required="no" default="">
    	<cfargument name="equipe_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-28,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tipo_id,
                   (select c.descricao
                      from kmm.v$cg_ref_codes c
                     where c.dominio = 'TIPO TAREFA'
                       and c.id = t.tipo_id) as tipo,
                   (to_date('1/1/2000') + kss.sum_dsinterval(te.tempo_estimado) - to_date('1/1/2000'))*24 as horas,
                   kss.to_tempo(kss.sum_dsinterval(te.tempo_estimado),3).retorno as horas_formatadas
              from kmm.v$tarefa_etapa te
             inner join kmm.v$ciclo_vida_etapa ce
                on ce.etapa_id = te.etapa_id
             inner join kmm.v$tarefa t
                on t.tarefa_id = te.tarefa_id
              left join kmm.v$tarefa_atribuicao ta
                on ta.atribuicao_id = t.atribuicao_id
             where (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
               and t.entregar_em between trunc(to_date('#arguments.data_inicial#')) and trunc(to_date('#arguments.data_final#'))
             <cfif len(trim(arguments.recurso_id))>
               and te.recurso_id in (#arguments.recurso_id#)
             </cfif>
             <cfif len(trim(arguments.equipe_id))>
               and te.recurso_id in (select recurso_id from kmm.v$equipe_recurso er where er.equipe_id in (#arguments.equipe_id#))
             </cfif>
             group by t.tipo_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_produtividade_recurso_cliente" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" required="no" default="">
    	<cfargument name="equipe_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-28,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cl.cliente_id,
                   cl.nome,
                   (to_date('1/1/2000') + kss.sum_dsinterval(te.tempo_estimado) - to_date('1/1/2000'))*24 as horas,
                   kss.to_tempo(kss.sum_dsinterval(te.tempo_estimado),3).retorno as horas_formatadas
              from kmm.v$tarefa_etapa te
             inner join kmm.v$ciclo_vida_etapa ce
                on ce.etapa_id = te.etapa_id
             inner join kmm.v$tarefa t
                on t.tarefa_id = te.tarefa_id
             inner join kmm.v$projeto_tarefa pt
                on pt.tarefa_id = t.tarefa_id
             inner join kmm.v$projeto pr
                on pr.projeto_id = pt.projeto_id
             inner join kmm.v$cliente cl
                on cl.cliente_id = pr.cliente_id
              left join kmm.v$tarefa_atribuicao ta
                on ta.atribuicao_id = t.atribuicao_id
             where (t.status = 7 or nvl(ta.etapa_id,-1) in (16,6))
               and t.entregar_em between trunc(to_date('#arguments.data_inicial#')) and trunc(to_date('#arguments.data_final#'))
             <cfif len(trim(arguments.recurso_id))>
               and te.recurso_id in (#arguments.recurso_id#)
             </cfif>
             <cfif len(trim(arguments.equipe_id))>
               and te.recurso_id in (select recurso_id from kmm.v$equipe_recurso er where er.equipe_id in (#arguments.equipe_id#))
             </cfif>
             group by cl.cliente_id, cl.nome
             order by horas desc 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
    
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_equipe" access="remote" returntype="query" output="true">
    	<cfargument name="equipe_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select equipe_id, 
                   descricao, 
                   situacao_id, 
                   lider_tecnico_id, 
                   apoio, 
                   date_insert, 
                   user_insert, 
                   date_update, 
                   user_update, 
                   site
              from kmm.v$equipe
             where 1=1
             <cfif len(trim(arguments.equipe_id))>
               and equipe_id in (#arguments.equipe_id#)
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_equipe_atrasos_recurso" access="remote" returntype="query" output="true">
    	<cfargument name="equipe_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-28,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select count(ta.atraso_id) as total,
                   count(data_cancelamento) as abonados,
                   count(ta.atraso_id) - count(data_cancelamento) as validos,
                   r.recurso_id, 
                   r.nome,
                   max(decode(data_cancelamento,null,entrega_em,null)) as ultima_data
              from kmm.v$recurso r
             inner join kmm.v$equipe_recurso er
                on er.recurso_id = r.recurso_id
              left join kmm.v$tarefa_atraso_todos ta
                on r.recurso_id = ta.recurso_id
               and ta.entrega_em between '#arguments.data_inicial#' and '#arguments.data_final#'
             where 1=1
             <cfif len(trim(arguments.equipe_id))>
               and r.recurso_id in (select recurso_id from kmm.v$equipe_recurso er where er.equipe_id = #arguments.equipe_id#)
             </cfif>
             group by r.recurso_id, r.nome
             order by total, r.nome
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 


	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_tarefa_atraso" access="remote" returntype="query" output="true">
    	<cfargument name="recurso_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="#lsdateformat(dateadd('d',-28,now()))#">
        <cfargument name="data_final" required="no" default="#lsdateformat(now())#">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.atraso_id,
                   t.tarefa_id,
                   t.entrega_em,
                   t.adiada_para,
                   to_char(t.data_cancelamento,'dd/mm/yyyy hh24:mi:ss') as data_cancelamento,
                   t.usuario_cancelamento,
                   t.user_insert,
                   to_char(t.date_insert,'dd/mm/yyyy hh24:mi:ss') as date_insert,
                   ta.titulo
              from kmm.v$tarefa_atraso_todos t
             inner join kmm.v$tarefa ta
                on t.tarefa_id = ta.tarefa_Id
             where 1=1
               and t.entrega_em between '#arguments.data_inicial#' and '#arguments.data_final#'
             <cfif len(trim(arguments.recurso_id))>
               and t.recurso_id in (#arguments.recurso_id#)
             </cfif>
             order by t.entrega_em
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
    
	<!--- 
	-- PROPSITO 
	-- 
	-- CRISTOFER  //2009
	--->		
	<cffunction name="get_sd_atraso" access="remote" returntype="query" output="true">
    	<cfargument name="sd_id" required="no" default="">
        <cfargument name="equipe_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.atraso_id, 
                   t.sd_id, 
                   sd.codigo,
                   sd.titulo,
                   (select descricao
                      from kmm.v$cg_ref_codes cg
                     where dominio = 'SD STATUS'
                       and id = t.status_id) as status,
                   t.data_entrega, 
                   t.adiada_para, 
                   t.equipe_id, 
                   e.descricao as equipe,
                   t.status_id, 
                   to_char(t.data_atraso,'dd/mm/yyyy hh24:mi:ss') as data_atraso, 
                   t.usuario_atraso, 
                   t.motivo, 
                   t.data_cancelamento, 
                   t.usuario_cancelamento, 
                   t.motivo_cancelamento, 
                   t.date_insert, 
                   t.user_insert, 
                   t.date_update, 
                   t.user_update, 
                   t.site, 
                   t.responsavel_id, 
                   r.nome as responsavel,
                   t.rowid 
              from kmm.v$sd_atraso t
             inner join kmm.v$sd sd
                on sd.sd_id = t.sd_id
              left join kmm.v$equipe e
                on e.equipe_id = t.equipe_id
              left join kmm.v$recurso r
                on r.recurso_id = t.responsavel_id
             where 1=1
             <cfif len(trim(arguments.sd_id))>
               and t.sd_id in (#arguments.sd_id#)    
             </cfif>
             <cfif len(trim(arguments.equipe_id))>
               and t.equipe_id in (#arguments.equipe_id#)
             </cfif>
             order by t.data_atraso
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>                
</cfcomponent>