<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Retorna cargos
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_cargo" displayname="Retorna operaes" output="true" returntype="query" access="remote">
		<cfargument name="cargo_id" required="no" default="" />
		<cfargument name="descricao" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.cargo_id, c.descricao
              from dedicado.v$cargo c
  			 where 1=1
			 <cfif Len(Trim(arguments.cargo_id))>
				 and c.cargo_id = #arguments.cargo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.descricao))>
				 and c.descricao like '%#arguments.descricao#%'
			 </cfif>             
             order by c.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna operaes
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_operacao" displayname="Retorna operaes" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="operacao_id_pai" required="no" default="" />
		<cfargument name="nome" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.operacao_id, o.nome, o.operacao_id_pai, 
            	   o.ativo, to_char(o.data_inicio_operacao,'dd/mm/yyyy') as data_inicio_operacao,
                   dedicado.pkg_operacao.fnc_possui_filhos(o.operacao_id) as possui_filhos
              from dedicado.v$operacao o
  			 where 1=1
			 <cfif Len(Trim(arguments.OPERACAO_ID_PAI))> 
                 and nvl(o.operacao_id_pai,-1) = #arguments.OPERACAO_ID_PAI#
             </cfif>
			 <cfif Len(Trim(arguments.operacao_id))>
				 and o.operacao_id = #arguments.operacao_id#
			 </cfif>
			 <cfif Len(Trim(arguments.nome))>
				 and o.nome like '%#arguments.nome#%'
			 </cfif>             
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
    
	<!--- 
	-- PROPSITO
	-- Retorna operaes tipo
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_operacao_tipo" displayname="Retorna operaes tipo" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.tipo_id, o.descricao
              from dedicado.v$operacao_tipo o
  			 where 1=1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	    

	<!--- 
    -- PROPSITO 
    -- Retorna as operaes dedicadas em rvore
    -- ANDERSON 25/11/2010 - ALTERADO
    --->
	<cffunction name="get_operacao_tree" displayname="Retorna operaes" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="operacao_id_pai" required="no" default="" />
		<cfargument name="ativo" required="no" default="" />
        <cfargument name="nome" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dedicado.to_operacao_dados(o.operacao_id).nome_completo as nome_completo
                 , o.operacao_id
                 , o.nome
                 , o.operacao_id_pai
                 , o.ativo
                 , to_char(o.data_inicio_operacao, 'dd/mm/yyyy') as data_inicio_operacao
                 , o.exporta_gerenciadora
                 , o.internacional
                 , o.referencia_id
                 , (select r.referencia
                      from rastreador.v$referencia r
                     where r.referencia_id = o.referencia_id
                   ) as referencia
                 , o.local_carregamento
                 , decode(o.local_carregamento, 1, 'Origem', 'Destino') as local_carregamento_desc
                 , o.rotas_automaticas
                 , o.percentual_adiantamento
                 , o.valor_km
                 , o.valor_ton
                 , o.valor_fixo
                 , o.dia_vencimento
                 , o.cod_organograma_gerencial
                 , (select lpad(cc.cod_centro_custo, 4, '0') || ' - ' || cc.centro_custo
                      from kss.v$organograma org
                     inner join kss.v$centro_custo cc
                             on cc.cod_centro_custo = org.cod_centro_custo
                     where org.cod_organograma = o.cod_organograma_gerencial
                   ) as organograma_gerencial
                 , o.cfa_pre_impressa
              from dedicado.v$operacao o
             where 1 = 1
			<cfif Len(Trim(arguments.ativo))>
               and o.ativo = #arguments.ativo#
            </cfif>
            <cfif Len(Trim(arguments.nome))>
               and upper(o.nome) like upper('%#arguments.nome#%')
            </cfif>
            <cfif Len(Trim(arguments.operacao_id_pai))> 
             start with o.operacao_id_pai = #arguments.operacao_id_pai#
            </cfif>
            <cfif Len(Trim(arguments.operacao_id))> 
             start with o.operacao_id = #arguments.operacao_id#
            <cfelseif not Len(Trim(arguments.operacao_id_pai))>
             start with o.operacao_id_pai is null
            </cfif>
           connect by prior o.operacao_id = o.operacao_id_pai
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna itens da operacao na estrutura
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_operacao_item" displayname="Retorna operaes" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oi.operacao_id, oi.item_id, oi.nivel_acesso_minimo,
                   ei.nome, ei.cod_acesso, ei.comentario, ei.url_acesso,
                   ei.url_icone
              from dedicado.v$operacao_item oi
             inner join dedicado.v$estrutura_item ei
                     on ei.item_id = oi.item_id
            where 1=1
            <cfif Len(Trim(arguments.operacao_id))>
              and oi.operacao_id = #arguments.operacao_id#
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	    

	<!--- 
	-- PROPSITO
	-- Retorna itens da estrutura
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_estrutura_item" displayname="Retorna itens da estrutura" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select item_id, nome, cod_acesso, comentario, 
                   url_acesso, url_icone
              from dedicado.v$estrutura_item            
             where 1=1
             order by nome
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	    

	<!--- 
	-- PROPSITO
	-- Retorna contratos
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_contratos" displayname="Retorna contratos" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select contrato_id, cod_pessoa_cliente, descricao
              from dedicado.v$contrato
               where 1=1
             order by descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO
	-- Retorna regies
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_regiao" displayname="Retorna regies" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="nome" required="no" default="" />
		<cfargument name="regiao_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.operacao_id, r.regiao_id, r.nome, 
                   r.ativa, dedicado.to_operacao_dados(r.operacao_id).nome_completo as operacao
              from dedicado.v$regiao r
             where 1=1		
             <cfif Len(Trim(arguments.OPERACAO_ID))>
               and r.operacao_id = #arguments.OPERACAO_ID#
			 </cfif>
             <cfif Len(Trim(arguments.REGIAO_ID))>
               and r.regiao_id = #arguments.REGIAO_ID#
			 </cfif>
             <cfif Len(Trim(arguments.NOME))>
               and upper(r.nome) like upper('%#arguments.NOME#%')
			 </cfif>
             order by r.operacao_id, r.nome
        </cfquery>
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO
	-- Retorna PROJETOS
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_projeto" displayname="Retorna regies" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="nome" required="no" default="" />
		<cfargument name="regiao_id" required="no" default="" />
		<cfargument name="projeto_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.operacao_id, r.regiao_id, r.nome as regiao, 
                   r.ativa, dedicado.to_operacao_dados(r.operacao_id).nome_completo as operacao,
                   p.projeto_id, p.distancia_base, p.nome, p.referencia_id, re.referencia
              from dedicado.v$projeto p
              inner join dedicado.v$regiao r
                      on p.regiao_id = r.regiao_id
              inner join rastreador.v$referencia re
                      on re.referencia_id = p.referencia_id
             where 1=1		
             <cfif Len(Trim(arguments.PROJETO_ID))>
               and p.projeto_id = #arguments.PROJETO_ID#
			 </cfif>
             <cfif Len(Trim(arguments.OPERACAO_ID))>
               and r.operacao_id = #arguments.OPERACAO_ID#
			 </cfif>
             <cfif Len(Trim(arguments.REGIAO_ID))>
               and r.regiao_id = #arguments.REGIAO_ID#
			 </cfif>
             <cfif Len(Trim(arguments.NOME))>
               and upper(p.nome) like upper('%#arguments.NOME#%')
			 </cfif>
             order by r.operacao_id, r.nome
        </cfquery>
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO
	-- Retorna LOCAIS
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_local" displayname="Retorna locais" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="descricao" required="no" default="" />
		<cfargument name="local_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select l.local_id, l.descricao, 
            	   l.referencia_id, l.operacao_id, r.referencia
              from dedicado.v$local l
             inner join rastreador.v$referencia r
                     on r.referencia_id = l.referencia_id
             where 1=1
             <cfif Len(Trim(arguments.LOCAL_ID))>
               and l.local_id = #arguments.LOCAL_ID#
			 </cfif>
             <cfif Len(Trim(arguments.OPERACAO_ID))>
               and l.operacao_id = #arguments.OPERACAO_ID#
			 </cfif>
             <cfif Len(Trim(arguments.DESCRICAO))>
               and upper(l.descricao) like upper('%#arguments.DESCRICAO#%')
			 </cfif>
             order by l.operacao_id, l.descricao
        </cfquery>
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO
	-- Retorna Contratos vinculados a operao
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_operacao_contrato" displayname="Retorna Contratos vinculados a operao" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="em_aberto" required="no" default="0" />
		<cfargument name="contrato_id" required="no" default="" />
		<cfargument name="controle_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oc.controle_id, oc.contrato_id, oc.operacao_id,
                   to_char(oc.data_inicio,'dd/mm/yyyy') as data_inicio, 
                   to_char(oc.data_termino,'dd/mm/yyyy') as data_termino, 
                   o.nome as operacao,
                   c.descricao as contrato, p.cliente
              from dedicado.v$operacao_contrato oc
              inner join dedicado.v$operacao o
                        on o.operacao_id = oc.operacao_id
              inner join dedicado.v$contrato c
                        on c.contrato_id = oc.contrato_id
              inner join kss.v$pessoa p 
                      on p.cod_pessoa = c.cod_pessoa_cliente
             where 1=1		
             <cfif Len(Trim(arguments.OPERACAO_ID))>
               and oc.operacao_id = #arguments.OPERACAO_ID#
			 </cfif>
             <cfif arguments.EM_ABERTO eq 1>
               and oc.data_termino is null
			 </cfif>
             <cfif Len(Trim(arguments.CONTROLE_ID))>
               and oc.controle_id = #arguments.CONTROLE_ID#
			 </cfif>
             <cfif Len(Trim(arguments.CONTRATO_ID))>
               and oc.contrato_id = #arguments.CONTRATO_ID#
			 </cfif>
             order by oc.operacao_id, oc.data_inicio
        </cfquery>
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO
	-- Retorna Veiculos vinculados a operao
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_operacao_veiculo" displayname="Retorna Contratos vinculados a operao" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="em_aberto" required="no" default="0" />
		<cfargument name="placa" required="no" default="" />
		<cfargument name="controle_id" required="no" default="" />
		<cfargument name="veiculo_maquina" required="no" default="" />
		<cfargument name="veiculo_proprietario" required="no" default="" />
        <!---Indica se deve mostrar os veculos da operao toda--->
		<cfargument name="operacao_completa" required="no" default="0" /> 
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.equipamento_id, ov.controle_id, v.cod_veiculo, ov.placa, ov.operacao_id,
                   to_char(ov.data_inicio,'dd/mm/yyyy') as data_inicio, 
                   to_char(ov.data_termino,'dd/mm/yyyy') as data_termino, 
                   o.nome as operacao, c.descricao as contrato, p.cliente,
				   m.marca, mo.modelo, ov.veiculo_maquina,
                   decode(ov.veiculo_maquina,1,'Mquina','Veculo') as veiculo_maquina_descricao,
                   oper.pkg_veiculo.fnc_veiculo_proprietario(ov.placa) as veiculo_proprietario
              from dedicado.v$operacao_veiculo ov
             inner join dedicado.v$operacao o
                     on o.operacao_id = ov.operacao_id
             inner join oper.v$veiculo v
                     on v.placa = ov.placa
             inner join oper.v$veiculo_marca m
                     on m.marca_id = v.marca_id
             inner join oper.v$veiculo_modelo mo
                     on mo.modelo_id = v.modelo_id 
                    and mo.marca_id = v.marca_id
             inner join dedicado.v$contrato c
                     on c.contrato_id = ov.contrato_id
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = c.cod_pessoa_cliente
              left join almoxarifado.v$equipamento e
                     on e.cod_equipamento = v.cod_veiculo
             where 1=1
             <cfif Len(Trim(arguments.VEICULO_PROPRIETARIO))>
		       and oper.pkg_veiculo.fnc_veiculo_proprietario(ov.placa) = any(#arguments.VEICULO_PROPRIETARIO#)
             </cfif>
             <cfif Len(Trim(arguments.VEICULO_MAQUINA))>
		       and ov.veiculo_maquina = #arguments.veiculo_maquina#
             </cfif>
             <cfif Len(Trim(arguments.OPERACAO_ID)) and arguments.OPERACAO_COMPLETA eq 0>
               and ov.operacao_id = #arguments.OPERACAO_ID#
             <cfelseif Len(Trim(arguments.OPERACAO_ID)) and arguments.OPERACAO_COMPLETA eq 1>
               and ov.operacao_id in (select a.operacao_id
                                        from table(dedicado.pkg_operacao.fnc_operacao_antecessoras(#arguments.OPERACAO_ID#)) a)
			 </cfif>
             <cfif arguments.EM_ABERTO eq 1>
               and ov.data_termino is null
			 </cfif>
             <cfif Len(Trim(arguments.CONTROLE_ID))>
               and ov.controle_id = #arguments.CONTROLE_ID#
			 </cfif>
             <cfif Len(Trim(arguments.PLACA))>
               and ov.placa = '#arguments.PLACA#'
			 </cfif>
             order by ov.operacao_id, ov.data_inicio
        </cfquery>
		<cfreturn qr_result>
	</cffunction>    	

	<!--- 
	-- PROPSITO
	-- Retorna usurios vinculados a operao
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_operacao_usuario" displayname="Retorna operaes" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ou.controle_id
                 , ou.operacao_id
                 , u.usuario
                 , u.nome
                 , na.descricao as nome_nivel_acesso
              from dedicado.v$operacao_usuario ou
             inner join kss.kss_usuarios u
                     on u.usuario = ou.usuario
             inner join acesso.v$nivel_acesso na
                     on na.nivel_acesso = ou.nivel_acesso_id
             where 1 = 1
            <cfif Len(Trim(arguments.operacao_id))>
              and ou.operacao_id = #arguments.operacao_id#
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
        
	<!--- 
	-- PROPSITO
	-- Retorna cargos vinculados as operaes
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_operacao_cargo" displayname="Retorna operaes" output="true" returntype="query" access="remote">
		<cfargument name="cargo_id" required="no" default="" />
		<cfargument name="operacao_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.cargo_id, c.descricao,
                   oc.controle_id, 
                   to_char(oc.data_vigencia,'dd/mm/yyyy') as data_vigencia, 
                   oc.perc_periculosidade, oc.perc_insalubridade, oc.salario_base
                from dedicado.v$cargo c
             inner join dedicado.v$operacao_cargo oc
                         on oc.cargo_id = c.cargo_id
             where 1=1
			 <cfif Len(Trim(arguments.cargo_id))>
				 and c.cargo_id = #arguments.cargo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.operacao_id))>
				 and oc.operacao_id = #arguments.operacao_id#
			 </cfif>
             order by c.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	    

	<!--- 
	-- PROPSITO
	-- Retorna funcionarios vinculados as operaes
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_operacao_funcionario" displayname="Retorna operaes" output="true" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="" />
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="em_aberto" required="no" default="0" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.controle_id, f.operacao_id, f.cod_pessoa, 
                   f.cargo_id, 
                   to_char(f.data_inicio,'dd/mm/yyyy') as data_inicio, 
                   to_char(f.data_termino,'dd/mm/yyyy') as data_termino, 
                   c.descricao as cargo, p.cliente as funcionario
              from dedicado.v$operacao_funcionario f
             inner join dedicado.v$cargo c
                           on c.cargo_id = f.cargo_id
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = f.cod_pessoa				 
             where 1=1
			 <cfif Len(Trim(arguments.controle_id))>
				 and f.controle_id = #arguments.controle_id#
			 </cfif>
			 <cfif Len(Trim(arguments.operacao_id))>
				 and f.operacao_id = #arguments.operacao_id#
			 </cfif>
             <cfif arguments.EM_ABERTO eq 1>
               and f.data_termino is null
			 </cfif>
             order by funcionario
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	    

	<!--- 
	-- PROPSITO
	-- Retorna eventos disponiveis
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_eventos" displayname="Retorna eventos" output="true" returntype="query" access="remote">
		<cfargument name="agrupamento_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ae.descricao as agrupamento, ae.agrupamento_id, ev.num_evento, 
            	   ev.descricao, ev.descricao_resumida, ev.registra_km
              from dedicado.v$evento_agrupamento e
             inner join oper.v$evento_operacao_setup ev
                     on ev.num_evento = e.num_evento
             inner join dedicado.v$agrupamento_evento ae
                     on ae.agrupamento_id = e.agrupamento_id				 
             where 1=1
			 <cfif Len(Trim(arguments.agrupamento_id))>
			   and e.agrupamento_id = #arguments.agrupamento_id#
			 </cfif>
            order by e.agrupamento_id
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	    

	<!--- 
	-- PROPSITO
	-- Retorna eventos vinculados a operao
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_operacao_eventos" displayname="Retorna eventos" output="true" returntype="query" access="remote">
		<cfargument name="agrupamento_id" required="no" default="" />
		<cfargument name="operacao_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oe.controle_id, ae.descricao as agrupamento, ev.num_evento, 
            	   oe.codigo as cod_evento, ev.descricao, ev.descricao_resumida,
                   ev.registra_km
              from dedicado.v$operacao_evento oe
             inner join	dedicado.v$evento_agrupamento e
                     on e.num_evento = oe.num_evento
             inner join oper.v$evento_operacao_setup ev
                     on ev.num_evento = e.num_evento
             inner join dedicado.v$agrupamento_evento ae
                     on ae.agrupamento_id = e.agrupamento_id				 
             where 1=1
			 <cfif Len(Trim(arguments.agrupamento_id))>
			   and e.agrupamento_id = #arguments.agrupamento_id#
			 </cfif>
			 <cfif Len(Trim(arguments.operacao_id))>
			   and oe.operacao_id = #arguments.operacao_id#
			 </cfif>
            order by e.agrupamento_id, oe.codigo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	        
    
	<!--- 
	-- PROPSITO
	-- Retorna eventos vinculados ao veiculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_eventos_veiculo" displayname="Retorna eventos" output="true" returntype="query" access="remote">
		<cfargument name="cod_veiculo" required="no" default="" />
		<cfargument name="placa" required="no" default="" />
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="data_inicial" required="no" default="" />
		<cfargument name="data_final" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		     select /*+ ordered*/ e.controle_evo_id, e.num_evento, eo.descricao, oe.codigo as cod_evento, eo.descricao_resumida,  e.placa,
             		 roe.num_romaneio,
                     to_char(e.data,'dd/mm/yyyy hh24:mi') as data, to_char(e.data,'hh24:mi') as hora, e.km, 
                     e.local, lag(e.local) over(order by e.data) as origem, e.local as destino,
                     (select kss.fnc_concat_all(to_concat_expr(oper.pkg_veiculo.fnc_get_cod_veiculo(t.column_value),'/')) as placa
                        from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.fnc_get_composicao(e.placa,e.data+1/1440),'|')) t
                         where t.column_value is not null) as composicao,
                     (select max(p.cliente) keep(dense_rank last order by vm.data_inicio)
                        from oper.v$veiculo_motorista vm
                         inner join kss.v$pessoa p
                                 on p.cod_pessoa = vm.cod_pessoa
                         where vm.placa = e.placa
                           and e.data between vm.data_inicio and nvl(vm.data_fim,sysdate)) as motorista, eo.permite_lancto_manual
              from oper.v$veiculo v
             inner join oper.v$evento_operacao e
                     on e.placa = v.placa
             inner join oper.v$evento_operacao_setup eo
                     on eo.num_evento = e.num_evento
             inner join rastreador.v$referencia r
                     on r.referencia_id = e.referencia_id
             inner join dedicado.v$operacao_evento oe
                     on oe.num_evento = e.num_evento
             left join oper.v$romaneio_evo roe
                    on roe.controle_evo_id = e.controle_evo_id
             where 1=1
			 <cfif Len(Trim(arguments.placa))>
               and e.placa = '#arguments.placa#'
			 </cfif>
			 <cfif Len(Trim(arguments.cod_veiculo))>
               and v.cod_veiculo = '#arguments.cod_veiculo#'
			 </cfif>
			 <cfif Len(Trim(arguments.data_inicial))>
               and e.data >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif Len(Trim(arguments.data_final))>
               and e.data <= '#arguments.data_final#'
			 </cfif>
			 <cfif Len(Trim(arguments.operacao_id))>
               and oe.operacao_id = #arguments.operacao_id#
			 </cfif>
             order by e.data 	 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	    

	<!--- 
	-- PROPSITO
	-- Retorna atributos dos eventos vinculados ao veiculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_evento_dados_veiculo" displayname="Retorna eventos" output="true" returntype="query" access="remote">
		<cfargument name="controle_evo_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select eod.controle_evo_id, ed.descricao, eod.valor
              from oper.v$evento_operacao_dado eod
             inner join oper.v$evento_dado_setup ed
                     on ed.dado_id = eod.dado_id
             where 1=1
			 <cfif Len(Trim(arguments.controle_evo_id))>
               and eod.controle_evo_id = #arguments.controle_evo_id#
			 </cfif>
             order by ed.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	   

	<!--- 
	-- PROPSITO
	-- Retorna referencias vinculadas a operao
	-- NOTAS EXPLICATIVAS
	--  
	-- 05/04/2008 - criado
	--->	
	<cffunction name="get_referencia_operacao" displayname="Retorna eventos" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select r.referencia_id, r.referencia, r.latitude, r.longitude,
                	   l.descricao as local
                  from dedicado.v$local l
                    inner join rastreador.v$referencia r
                            on r.referencia_id = l.referencia_id
                 where 1=1
			 <cfif Len(Trim(arguments.operacao_id))>
               and l.operacao_id = #arguments.operacao_id#
			 </cfif>
                 
                union
                
                select r.referencia_id, r.referencia, r.latitude, r.longitude,
                	   l.nome as local
                  from dedicado.v$regiao rg
                  inner join dedicado.v$projeto l
                          on rg.regiao_id = l.regiao_id
                    inner join rastreador.v$referencia r
                            on r.referencia_id = l.referencia_id
                 where 1=1
			 <cfif Len(Trim(arguments.operacao_id))>
               and rg.operacao_id = #arguments.operacao_id#
			 </cfif>
             order by local
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

    
<!--- 
	-- PROPSITO 
	-- Retorna Descricao de tipos de servico
	--                    
	-- 15/08/2008 - criado
	--->		
	<cffunction name="get_servico" access="remote" returntype="query" output="true">
    	<cfargument name="servico_id" required="no" default="" />
        <cfargument name="descricao" required="no" default="" />
       		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            	select s.servico_id,
            	   	   s.descricao
            	from dedicado.v$tipo_servico s
            	where 1=1 
          		
				<cfif Len(Trim(arguments.servico_id))>
		  			and s.servico_id like '%#arguments.servico_id#%'
		  		</cfif>
			 	<cfif Len(Trim(arguments.descricao))>
               		and upper(s.descricao) like upper ('%#arguments.descricao#%')
		        </cfif>                    
             	order by s.servico_id
			</cfquery>
       		<cfreturn qr_result>		
	</cffunction>  
    
<!--- 
	-- PROPSITO 
	-- Retorna Descricao de tipos produto tranportado
	--                   
	-- 15/08/2008 - criado
	--->		
	<cffunction name="get_produto_transportado" access="remote" returntype="query" output="true">
    	<cfargument name="produto_id" required="no" default="" />
        <cfargument name="descricao" required="no" default="" />
       		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            	select p.produto_id,
            	   	   p.descricao
            	from dedicado.v$produto_transportado p
            	where 1=1 
          		
				<cfif Len(Trim(arguments.produto_id))>
                	and p.produto_id like '%#arguments.produto_id#%'
		  		</cfif>
			 	<cfif Len(Trim(arguments.descricao))>
                	and upper(p.descricao) like upper ('%#arguments.descricao#%')
		        </cfif>                    
             	order by p.produto_id
			</cfquery>
       		<cfreturn qr_result>		
	</cffunction> 

	<!--- 
	-- PROPSITO
	-- Retorna produes
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_producao" displayname="Retorna produo" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="controle_id" required="no" default="" />
		<cfargument name="placa" required="no" default="" />
		<cfargument name="data" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_fim" required="no" default="" />
		<cfargument name="quantidade" required="no" default="" />  
        <cfargument name="projeto_id" required="no" default="" />
        <cfargument name="servico_id" required="no" default="" />
        <cfargument name="produto_id" required="no" default="" />     
        <cfargument name="cod_unidade" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.controle_id, 
            	   p.operacao_id,
                   p.placa, 
                   p.data, 
                   p.quantidade, 
                   p.projeto_id, 
                   p.servico_id, 
                   p.produto_id, 
                   p.cod_unidade, 
                   o.nome, 
                   pt.descricao as nome_produto,
                   pr.nome as nome_projeto,
                   ts.descricao as nome_servico,
                   dedicado.to_operacao_dados(p.operacao_id).nome_completo as operacao
            from dedicado.v$operacao_producao p
            inner join dedicado.v$operacao o
                          on o.operacao_id = p.operacao_id
            inner join dedicado.v$produto_transportado pt
                          on pt.produto_id = p.produto_id
            inner join dedicado.v$projeto pr
                          on pr.projeto_id = p.projeto_id
            inner join dedicado.v$tipo_servico ts
                          on ts.servico_id = p.servico_id                          
           where 1=1		
			 <cfif Len(Trim(arguments.OPERACAO_ID))>
               and p.operacao_id = #arguments.OPERACAO_ID#
			 </cfif>
             <cfif Len(Trim(arguments.PLACA))>
               and upper(p.placa) like upper('%#arguments.PLACA#%')
			 </cfif>   
			 <cfif Len(Trim(arguments.DATA_INICIO)) and Len(Trim(arguments.DATA_FIM))>
			   and to_date(to_char(p.data,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.DATA_INICIO#','dd/mm/yyyy') and to_date('#arguments.DATA_FIM#','dd/mm/yyyy')
			 </cfif>
             
             order by p.operacao_id, p.data
        </cfquery>
		<cfreturn qr_result>
	</cffunction> 
    
    	<!--- 
	-- PROPSITO
	-- Retorna relatorio de produes
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_producao_relatorio" displayname="Retorna relatrio de produo" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
        <cfargument name="quantidade" required="no" default="" />
		<cfargument name="projeto_id" required="no" default="" />
        <cfargument name="servico_id" required="no" default="" />    
        <cfargument name="cod_unidade" required="no" default="" />
        <cfargument name="data" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.projeto_id,
            	   p.operacao_id,
			       p.servico_id,
			       p.cod_unidade,
			       sum(p.quantidade) quantidade,
			       pr.nome as nome_projeto,
			       ts.descricao as nome_servico,
                   dedicado.to_operacao_dados(p.operacao_id).nome_completo as operacao
			from dedicado.v$operacao_producao p
			inner join dedicado.v$projeto pr on pr.projeto_id = p.projeto_id
			inner join dedicado.v$tipo_servico ts on ts.servico_id = p.servico_id
			where 1 = 1
            <cfif Len(Trim(arguments.OPERACAO_ID))>
               and p.operacao_id = #arguments.OPERACAO_ID#
			</cfif>
            <cfif Len(Trim(arguments.PROJETO_ID))>
               and p.projeto_id = #arguments.PROJETO_ID#
			</cfif>
			 <cfif Len(Trim(arguments.DATA_INICIO)) and Len(Trim(arguments.DATA_FIM))>
			   and to_date(to_char(p.data,'dd/mm/yyyy'),'dd/mm/yyyy') between to_date('#arguments.DATA_INICIO#','dd/mm/yyyy') and to_date('#arguments.DATA_FIM#','dd/mm/yyyy')
			 </cfif>
			group by p.projeto_id,
          			 p.servico_id,
			         p.cod_unidade,
			         pr.nome,
                     p.operacao_id,
			         ts.descricao
			order by nome_servico
        </cfquery>
		<cfreturn qr_result>
	</cffunction> 
              
    <!---CONTROLE DE PRODUO DOS VEICULOS--->

   	<!--- 
	-- PROPSITO
	-- Retorna relatorio de produes por veculos
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_producao_relatorio_veiculos" displayname="Retorna relatrio de produo" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
        <cfargument name="data_inicial" required="no" default="" />
        <cfargument name="data_final" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select placa_controle
                   ,cod_veiculo
                   ,sum(viagens) as viagens
                   ,kss.to_tempo(numtodsinterval(sum(tempo_viagem),'DAY'),4).retorno as tempo_viagem
                   ,kss.to_tempo(numtodsinterval(sum(tempo_carga),'DAY'),4).retorno as tempo_carga
                   ,kss.to_tempo(numtodsinterval(sum(tempo_descarga),'DAY'),4).retorno as tempo_descarga
                   ,round(sum(peso_total)) as peso_total
                   ,sum(km_romaneio) as km_romaneio
                   ,sum(km_vazio) as km_vazio
                   ,sum(km_carregado) as km_carregado
                   ,sum(faturamento) as faturamento
              from (
                    select a.placa_controle
                           ,oper.pkg_veiculo.fnc_get_cod_veiculo(a.placa_controle) as cod_veiculo
                           ,count(*) as viagens
                           ,sum(tempo_viagem_num) as tempo_viagem
                           ,sum(tempo_carga_num) as tempo_carga
                           ,sum(tempo_descarga_num) as tempo_descarga
                           ,sum(peso_total)/1000 as peso_total
                           ,sum(km_f_carregado - km_i_vazio) as km_romaneio
                           ,sum(km_f_vazio - km_i_vazio) as km_vazio
                           ,sum(km_f_carregado) - sum(km_i_carregado) as km_carregado
                           ,round(sum(peso_total/1000 * decode(dedicado.pkg_operacao.fnc_valor_faixa_km(1,km_f_carregado-km_i_carregado,data_inicio),0,dedicado.pkg_operacao.fnc_valor_romaneio(NUM_ROMANEIO),dedicado.pkg_operacao.fnc_valor_faixa_km(1,km_f_carregado-km_i_carregado,data_inicio))),2) as faturamento
                      from (
                            select r.placa_controle, r.data_inicio, 
                                   r.data_termino,
                                   r.data_termino - r.data_inicio as tempo_viagem_num,
                                   r.data_termino_carga - 
                                   nvl(
                                       (select min(re.data)
                                          from oper.v$romaneio_evo re
                                         where re.num_romaneio = r.num_romaneio
                                           and re.num_evento in (270, 247, 259)
                                       ), r.data_inicio_carga
                                      ) as tempo_carga_num,
                                   r.data_termino_descarga - r.data_inicio_descarga as tempo_descarga_num,
                                   nvl(r.peso_total, 0) as peso_total,
                                   dedicado.pkg_operacao.fnc_ultimo_km(r.placa_controle, oper.to_evo_romaneio(221, r.num_romaneio).data) as km_i_vazio,
                                   (select min(re.km)
                                      from oper.v$romaneio_evo re
                                     where re.num_romaneio = r.num_romaneio
                                       and re.num_evento in (2, 234, 257)
                                   ) as km_f_vazio,
                                   (select min(re.km)
                                      from oper.v$romaneio_evo re
                                     where re.num_romaneio = r.num_romaneio
                                       and re.num_evento in (4, 249, 262)
                                   ) as km_f_carregado,
                                   (select min(re.km)
                                      from oper.v$romaneio_evo re
                                     where re.num_romaneio = r.num_romaneio
                                       and re.num_evento in (2, 234, 257)
                                   ) as km_i_carregado,
                                   r.num_romaneio
                              from oper.v$romaneio_dedicado r
                             where 1 = 1
                               and exists (select 1
                                                  from dedicado.v$operacao_veiculo ov
                                                 where ov.placa = r.placa_controle
                                                   and ov.operacao_id = #arguments.operacao_id#
                                                   and r.data_termino between ov.data_inicio and nvl(ov.data_termino, sysdate))
                               and trunc(data_termino) >= '#arguments.data_inicial#'
                               and (trunc(data_termino) <= '#arguments.data_final#' or data_termino is null) ) a
                    where placa_controle in (select v.placa from oper.v$veiculo v
                            left join oper.v$veiculo_tipo_carroceria vtc
                                   on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                            left join oper.v$veiculo_agrupamento va
                              on va.agrupamento_id = vtc.agrupamento_id     
                            where va.tracao = 1)
                            
                    group by placa_controle
        
                    union all
                    
                    select ov.placa as placa_controle, 
                           oper.pkg_veiculo.fnc_get_cod_veiculo(ov.placa) as frota,0,0,0,0,0,0,0,0,0
                      from dedicado.v$operacao_veiculo ov
                     where ov.operacao_id = #arguments.operacao_id#
                       and '#arguments.data_inicial#' <= nvl(ov.data_termino,sysdate)
                       and '#arguments.data_final#' >= ov.data_inicio
                    )
					where placa_controle in (select v.placa from oper.v$veiculo v
                           inner join oper.v$veiculo_tipo_carroceria vtc
                                   on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                           inner join oper.v$veiculo_agrupamento va
                              on va.agrupamento_id = vtc.agrupamento_id
                             and va.tracao = 1)                    
                    group by placa_controle
                           ,cod_veiculo
                           
		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
    
   	<!--- 
	-- PROPSITO
	-- Retorna relatorio de produes por motorista
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_producao_relatorio_motorista" displayname="Retorna relatrio de produo" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
        <cfargument name="data_inicial" required="no" default="" />
        <cfargument name="data_final" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ofu.operacao_id, ofu.cod_pessoa, p.cliente as funcionario,mrh.cod_registro,
                   nvl((select sum(peso_total) / count(distinct rd.num_romaneio) 
                                        from oper.v$romaneio_dedicado rd
                                        inner join oper.v$romaneio_hist_veiculo rhv
                                              on rd.num_romaneio = rhv.num_romaneio	
                                     where rhv.cod_pessoa = ofu.cod_pessoa
                                         and rhv.data_termino between ofu.data_inicio and nvl(ofu.data_termino,sysdate)
                                         and rhv.data_termino between '#arguments.data_inicial#' and '#arguments.data_final#'),0) as peso_total,
                   nvl((select count(*)
                            from oper.v$romaneio_dedicado rd
                                inner join oper.v$romaneio_hist_veiculo rhv
                                        on rd.num_romaneio = rhv.num_romaneio
                              where rhv.cod_pessoa = ofu.cod_pessoa
                               and rhv.data_termino between ofu.data_inicio and nvl(ofu.data_termino,sysdate)
                               and rhv.data_termino between '#arguments.data_inicial#' and '#arguments.data_final#'),0) as viagens_participou
              from dedicado.v$operacao_funcionario ofu
                inner join kss.v$pessoa p
                        on p.COD_PESSOA = ofu.cod_pessoa
                inner join oper.v$motorista_reg_historico mrh
                        on mrh.cod_pessoa = p.cod_pessoa
                       and mrh.data_fim is null  
             where ofu.operacao_id = #arguments.operacao_id#
               and (trunc(ofu.data_termino) between '#arguments.data_inicial#' and '#arguments.data_final#'
                    or ofu.data_termino is null)				
               order by mrh.cod_registro
		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
    

   	<!--- 
	-- PROPSITO
	-- Retorna relatorio de viagens do veculo no perodo
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_producao_viagens" displayname="Retorna relatrio de produo" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="no" default="" />
		<cfargument name="placa_controle" required="no" default="" />
		<cfargument name="placa_referencia" required="no" default="" />
        <cfargument name="data_inicial" required="no" default="" />
        <cfargument name="data_final" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select num_romaneio, carregamento, 
            	   to_char(data_inicio, 'dd/mm hh24:mi') as data_inicio,
                   to_char(data_termino, 'dd/mm hh24:mi') as data_termino,
            	   tempo_viagem, 
                   kss.to_tempo(numtodsinterval(sum(tempo_viagem_num) over(),'DAY'),4).retorno as tempo_total_viagem, 
                   data_inicio_carga, data_termino_carga,
                   tempo_carga, kss.to_tempo(numtodsinterval(sum(tempo_carga_num) over(),'DAY'),4).retorno as tempo_total_carga,
                   data_inicio_descarga, data_termino_descarga, 
                   tempo_descarga, kss.to_tempo(numtodsinterval(sum(tempo_descarga_num) over(),'DAY'),4).retorno as tempo_total_descarga,
                   placa_controle,
                   frota_cavalo, placa_referencia, frota_carreta, peso_total, nota_fiscal, num_ticket, 
                   a.evento_f_carregado.km - km_i_vazio as km_romaneio,
                   a.evento_f_vazio.km - km_i_vazio as km_vazio,
                   a.evento_f_carregado.km - km_i_carregado as km_carregado,
                   decode(dedicado.pkg_operacao.fnc_valor_faixa_km(1,a.evento_f_carregado.km - km_i_carregado, data_inicio),0,dedicado.pkg_operacao.fnc_valor_romaneio(NUM_ROMANEIO),dedicado.pkg_operacao.fnc_valor_faixa_km(1,a.evento_f_carregado.km - km_i_carregado, data_inicio)) as valor_faixa
              from (select r.num_romaneio,
                                         r.carregamento,
                                         r.data_inicio,
                                         r.data_termino,
                                         kss.to_tempo(numtodsinterval(r.data_termino - r.data_inicio,'DAY'),4).retorno as tempo_viagem,
                                         r.data_termino - r.data_inicio  as tempo_viagem_num,
                                         to_char(r.data_inicio_carga, 'dd/mm hh24:mi') as data_inicio_carga,
                                         to_char(r.data_termino_carga, 'dd/mm hh24:mi') as data_termino_carga,
                                         kss.to_tempo(numtodsinterval(r.data_termino_carga -
                                                                                                    r.data_inicio_carga,
                                                                                                    'DAY'),4) .retorno as tempo_carga,
                                         r.data_termino_carga - r.data_inicio_carga as tempo_carga_num,                           
                                         to_char(r.data_inicio_descarga, 'dd/mm hh24:mi') as data_inicio_descarga,
                                         to_char(r.data_termino_descarga, 'dd/mm hh24:mi') as data_termino_descarga,
                                         kss.to_tempo(numtodsinterval(r.data_termino_descarga -
                                                                                                    r.data_inicio_descarga,
                                                                                                    'DAY'),4) .retorno as tempo_descarga,
                                         r.data_termino_descarga - r.data_inicio_descarga as tempo_descarga_num,                           
                                         r.placa_controle,
                                         oper.fnc_get_cod_veiculo(r.placa_controle) as frota_cavalo,
                                         r.placa_referencia,
                                         oper.fnc_get_cod_veiculo(r.placa_referencia) as frota_carreta,
                                         nvl(r.peso_total,0) as peso_total,
                                         (select kss.fnc_concat_all(kss.to_concat_expr(valor, '-'))
                                                from oper.v$romaneio_evento re
                                             inner join oper.v$evento_operacao_dado eod on re.controle_evo_id =
                                                                                                                                         eod.controle_evo_id
                                                                                                                                 and eod.dado_id = 39
                                             where re.num_romaneio = r.num_romaneio) as nota_fiscal,
                                         (select kss.fnc_concat_all(kss.to_concat_expr(valor, '-'))
                                                from oper.v$romaneio_evento re
                                             inner join oper.v$evento_operacao_dado eod on re.controle_evo_id =
                                                                                                                                         eod.controle_evo_id
                                                                                                                                 and eod.dado_id = 37
                                             where re.num_romaneio = r.num_romaneio) as num_ticket
                                             ,dedicado.pkg_operacao.fnc_ultimo_km(r.placa_controle, oper.to_evo_romaneio(221, r.num_romaneio).data) as km_i_vazio
                                             ,oper.to_evo_romaneio(2,r.num_romaneio) as evento_f_vazio
                                             ,oper.to_evo_romaneio(208,r.num_romaneio).km as km_i_carregado
                                             ,oper.to_evo_romaneio(4,r.num_romaneio) as evento_f_carregado				 
                                from oper.v$romaneio_dedicado r
                             where 1 = 1
                          <cfif Len(Trim(arguments.placa_controle))>
                              and placa_controle = '#arguments.placa_controle#'
                              <cfif Len(Trim(arguments.OPERACAO_ID))>
                                  and exists (select 1
                                                from dedicado.v$operacao_veiculo ov
                                               where ov.placa = r.placa_controle
                                                 and ov.operacao_id = #arguments.OPERACAO_ID#
                                                 and r.data_termino between ov.data_inicio and nvl(ov.data_termino,sysdate))
                              </cfif>
                          </cfif>              
                          <cfif Len(Trim(arguments.placa_referencia))>
                              and placa_referencia = '#arguments.placa_referencia#'
                              <cfif Len(Trim(arguments.OPERACAO_ID))>
                                  and exists (select 1
                                                from dedicado.v$operacao_veiculo ov
                                               where ov.placa = r.placa_controle
                                                 and ov.operacao_id = #arguments.OPERACAO_ID#
                                                 and r.data_termino between ov.data_inicio and nvl(ov.data_termino,sysdate))
                              </cfif>
                          </cfif>              
                          <cfif Len(Trim(arguments.DATA_INICIAL))>
                              and trunc(data_termino) >= '#arguments.DATA_INICIAL#' 
                          </cfif>
                          <cfif Len(Trim(arguments.DATA_FINAL))>
                              and (trunc(data_termino) <= '#arguments.DATA_FINAL#' or data_termino is null)
                              
                          </cfif>
                          <cfif not Len(Trim(arguments.DATA_INICIAL)) and not Len(Trim(arguments.DATA_FINAL))>
                            and 1=0
                          </cfif>
                          ) a
						order by a.data_inicio asc
		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
    
   	<!--- 
	-- PROPSITO
	-- Retorna detalhes dos eventos do romaneio
	-- NOTAS EXPLICATIVAS
	--  
	-- 21/04/2008 - criado
	--->	
	<cffunction name="get_producao_detalhes_romaneio" displayname="Retorna relatrio de produo" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.descricao_resumida, re.controle_evo_id, 
            	   to_char(re.data,'dd/mm/yyyy hh24:mi') as data, 
                   re.num_evento, nvl(lag(re.km) over(order by re.data),km) as km_anterior,
                         re.km, re.local, oper.fnc_get_cod_veiculo(re.placa) as frota
              from oper.v$romaneio_evo re
            inner join oper.v$evento_operacao_setup e
                   on e.num_evento = re.num_evento
            where re.num_romaneio = #arguments.num_romaneio#
            order by to_date(data,'dd/mm/yyyy hh24:mi')
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as rotas de uma operao dedicada
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 30/12/2010 - ALTERADO
	--->
	<cffunction name="get_local_rota" displayname="Retorna as rotas entre locais cadastradas" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select lr.local_rota_id
                 , lr.rota_id
                 , lr.operacao_id
                 , r.abreviatura
                 , r.descricao_rota
                 , r.referencia_origem_id
                 , (select re.referencia
                      from rastreador.v$referencia re
                     where re.referencia_id = r.referencia_origem_id
                   ) as referencia_origem
                 , r.origem_municipio_id
                 , cep.fnc_cidade_completa(r.origem_municipio_id) as origem_municipio
                 , r.origem_latitude
                 , r.origem_longitude
                 , r.referencia_destino_id
                 , (select re.referencia
                      from rastreador.v$referencia re
                     where re.referencia_id = r.referencia_destino_id
                   ) as referencia_destino
                 , r.destino_municipio_id
                 , cep.fnc_cidade_completa(r.destino_municipio_id) as destino_municipio
                 , r.destino_latitude
                 , r.destino_longitude
                 , r.distancia_padrao
              from dedicado.v$local_rota lr
             inner join oper.v$rota r
                     on r.rota_id = lr.rota_id
             where lr.operacao_id = #arguments.operacao_id#
               and lr.data_cancelamento is null
             order by r.descricao_rota
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os tipos de pagamentos cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 15/04/2009
	--->
	<cffunction name="get_tipo_pagto" displayname="Retorna os tipos de pagamentos cadastrados" output="true" returntype="query" access="remote">
		<cfargument name="tipo_pagto_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tp.tipo_pagto_id,
                   tp.descricao
              from dedicado.v$tipo_pagto tp
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_pagto_id))>
			   and tp.tipo_pagto_id = #arguments.tipo_pagto_id#
            </cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(tp.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by tp.descricao
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna os tipos de despesas de romaneio cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 15/04/2009
	--->
	<cffunction name="get_tipo_despesa_romaneio" displayname="Retorna os tipos de despesas de romaneio cadastrados" output="true" returntype="query" access="remote">
		<cfargument name="tipo_despesa_romaneio_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select td.tipo_despesa_romaneio_id,
                   td.descricao
              from dedicado.v$tipo_despesa_romaneio td
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_despesa_romaneio_id))>
			   and td.tipo_despesa_romaneio_id = #arguments.tipo_despesa_romaneio_id#
            </cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(td.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by td.descricao
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    
    <!--- 
	-- PROPSITO
	-- Retorna os planejamentos de viagem
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 15/04/2009
	--->
	<cffunction name="get_viagem_planejamento" displayname="Retorna os planejamentos de viagem" output="true" returntype="query" access="remote">
		<cfargument name="planejamento_id" required="no" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfargument name="placa_controle" required="no" default="">
        <cfargument name="placa_referencia" required="no" default="">
        <cfargument name="data_previsao_carregamento" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vp.planejamento_id,
                   vp.operacao_id,
                   dedicado.to_operacao_dados(vp.operacao_id).nome_completo as operacao,
                   vp.placa_controle,
                   vp.placa_referencia,
                   vp.local_id_origem,
                   lo.descricao as local_origem,
                   vp.regiao_id_origem,
                   ro.nome as regiao_origem,
                   vp.local_id_destino,
                   ld.descricao as local_destino,
                   vp.regiao_id_destino,
                   rd.nome as regiao_destino,
                   to_char(vp.data_previsao_carregamento, 'dd/mm/yyyy') as data_previsao_carregamento,
                   vp.controle_evo_id,
                   vp.num_romaneio,
                   to_char(vp.data_cancelamento, 'dd/mm/yyyy') as data_cancelamento
              from dedicado.v$viagem_planejamento vp
              left join dedicado.v$local lo
                     on lo.local_id = vp.local_id_origem
              left join dedicado.v$regiao ro
                     on ro.regiao_id = vp.regiao_id_origem
              left join dedicado.v$local ld
                     on ld.local_id = vp.local_id_destino
              left join dedicado.v$regiao rd
                     on rd.regiao_id = vp.regiao_id_destino
             where 1 = 1
			<cfif Len(Trim(arguments.planejamento_id))>
               and vp.planejamento_id = #arguments.planejamento_id#
			</cfif>
			<cfif Len(Trim(arguments.operacao_id))>
               and vp.operacao_id = #arguments.operacao_id#
			</cfif>
			<cfif Len(Trim(arguments.placa_controle))>
               and upper(vp.placa_controle) like upper('#arguments.placa_controle#%')
			</cfif>
			<cfif Len(Trim(arguments.placa_referencia))>
               and upper(vp.placa_referencia) like upper('#arguments.placa_referencia#%')
			</cfif>
			<cfif Len(Trim(arguments.data_previsao_carregamento))>
               and trunc(vp.data_previsao_carregamento) = '#arguments.data_previsao_carregamento#'
			</cfif>
             order by vp.data_previsao_carregamento asc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os lanamentos com despesas de romaneio
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 12/05/2009
	--->
	<cffunction name="get_despesa_romaneio" displayname="Retorna os lanamentos com despesas de romaneio" output="true" returntype="query" access="remote">
		<cfargument name="despesa_romaneio_id" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="num_documento" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dr.despesa_romaneio_id,
            	   to_char(dr.data_lancamento, 'dd/mm/yyyy hh24:mi') as data_lancamento,
                   dr.placa,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(dr.placa) as cod_veiculo,
                   dr.num_romaneio,
                   dr.num_documento,
                   dr.tipo_despesa_romaneio_id,
                   tdr.descricao as tipo_despesa_romaneio,
                   dr.valor,
                   dr.complemento
              from dedicado.v$despesa_romaneio dr
              left join dedicado.v$tipo_despesa_romaneio tdr
                     on tdr.tipo_despesa_romaneio_id = dr.tipo_despesa_romaneio_id
             where 1 = 1
			<cfif Len(Trim(arguments.despesa_romaneio_id))>
               and dr.despesa_romaneio_id = #arguments.despesa_romaneio_id#
			</cfif>
			<cfif Len(Trim(arguments.placa))>
               and upper(dr.placa) = upper('#arguments.placa#')
			</cfif>
			<cfif Len(Trim(arguments.num_romaneio))>
               and dr.num_romaneio = #arguments.num_romaneio#
			</cfif>
			<cfif Len(Trim(arguments.num_documento))>
               and dr.num_documento = #arguments.num_documento#
			</cfif>
             order by dr.data_lancamento, dr.num_romaneio
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os lanamentos com despesas de manuteno
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 19/05/2009
	--->
	<cffunction name="get_despesa_manutencao" displayname="Retorna os lanamentos com despesas de manuteno" output="true" returntype="query" access="remote">
		<cfargument name="despesa_manutencao_id" required="no" default="">
        <cfargument name="num_documento" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="cod_oficina" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfargument name="tipo_despesa" required="no" default="">
        <cfargument name="tipo_manutencao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dm.despesa_manutencao_id,
                   dm.num_documento,
                   to_char(dm.data_lancto, 'dd/mm/yyyy') as data_lancto,
                   dm.cod_oficina,
                   p1.cnpj_cpf as cnpj_cpf_oficina,
                   p1.identificador as identificador_oficina,
                   p1.cliente as oficina,
                   dm.placa,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(dm.placa) as cod_veiculo,
                   dm.tipo_despesa,
                   case
                     when dm.tipo_despesa = 1 then
                      'Pea'
                     when dm.tipo_despesa = 2 then
                      'Mo-de-obra'
                   end as desc_tipo_despesa,
                   dm.tipo_manutencao,
                   case
                     when dm.tipo_manutencao = 1 then
                      'Corretiva'
                     when dm.tipo_manutencao = 2 then
                      'Preventiva'
                   end as desc_tipo_manutencao,
                   to_char(dm.data_entrada, 'dd/mm/yyyy') as data_entrada,
                   to_char(dm.data_saida, 'dd/mm/yyyy') as data_saida,
                   dm.cod_motorista,
                   (select max(fma.num_matricula)
                      from kss.v$funcionario_matr_atual fma
                     where fma.cod_pessoa  = dm.cod_motorista) as cod_registro_motorista,
                   p2.cliente as motorista,
                   dm.cod_responsavel,
                   (select max(fma.num_matricula)
                      from kss.v$funcionario_matr_atual fma
                     where fma.cod_pessoa  = dm.cod_responsavel) as num_matricula_responsavel,
                   p3.cliente as responsavel,
                   dm.valor,
                   dm.complemento
              from dedicado.v$despesa_manutencao dm
              left join kss.v$pessoa p1
                     on p1.cod_pessoa = dm.cod_oficina
              left join kss.v$pessoa p2
                     on p2.cod_pessoa = dm.cod_motorista
              left join kss.v$pessoa p3
                     on p3.cod_pessoa = dm.cod_responsavel
             where 1 = 1
			<cfif Len(Trim(arguments.despesa_manutencao_id))>
               and dm.despesa_manutencao_id = #arguments.despesa_manutencao_id#
			</cfif>
            <cfif Len(Trim(arguments.num_documento))>
				and dm.num_documento = #arguments.num_documento#
			</cfif>
            <cfif Len(Trim(arguments.data_inicio))>
				and trunc(dm.data_lancto) >= '#arguments.data_inicio#'
			</cfif>
            <cfif Len(Trim(arguments.data_fim))>
				and trunc(dm.data_lancto) <= '#arguments.data_fim#'
			</cfif>
            <cfif Len(Trim(arguments.cod_oficina))>
				and dm.cod_oficina in (#arguments.cod_oficina#)
			</cfif>
            <cfif Len(Trim(arguments.placa))>
				and upper(dm.placa) like upper('#arguments.placa#')
			</cfif>
            <cfif Len(Trim(arguments.tipo_despesa))>
				and dm.tipo_despesa = #arguments.tipo_despesa#
			</cfif>
            <cfif Len(Trim(arguments.tipo_manutencao))>
				and dm.tipo_manutencao = #arguments.tipo_manutencao#
			</cfif>
             order by dm.data_lancto, dm.despesa_manutencao_id
        </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna um comparativo entre Manuteno Corretiva e Preventiva
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 20/05/2009
	--->
	<cffunction name="get_comparativo_manutencao" displayname="Retorna um comparativo entre Manuteno Corretiva e Preventiva" output="true" returntype="query" access="remote">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dm.placa,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(dm.placa) as cod_veiculo,
                   sum(case when dm.tipo_manutencao = 1 then dm.valor else 0 end) as total_corretiva,
                   sum(case when dm.tipo_manutencao = 2 then dm.valor else 0 end) as total_preventiva,
                   sum(dm.valor) as total
              from dedicado.v$despesa_manutencao dm
             where 1 = 1
            <cfif Len(Trim(arguments.data_inicio))>
				and trunc(dm.data_lancto) >= '#arguments.data_inicio#'
			</cfif>
            <cfif Len(Trim(arguments.data_fim))>
				and trunc(dm.data_lancto) <= '#arguments.data_fim#'
			</cfif>
              group by dm.placa
        </cfquery>
		<cfreturn qr_result>
	</cffunction> 

	<!--- 
	-- PROPSITO
	-- Retorna os romaneios
	-- NOTAS EXPLICATIVAS
	-- RAFAEL_COSTA 01/06/2009
	--->
	<cffunction name="get_romaneio" displayname="Retorna os romaneios" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select r.num_romaneio,
               r.carregamento,
               r.destino,
               r.cliente,
               r.remetente,
               r.destinatario,
               r.data_inicio,
               r.data_destinado,
               r.data_termino,
               r.data_previsao_descarga,
               r.data_previsao_vazio,
               r.data_previsao_carregado,
               r.num_natureza,
               r.num_especie,
               r.cod_unidade,
               r.frete_em,
               r.peso_total,
               r.peso_cobrado,
               r.volume_total,
               r.m3_total,
               r.frete_liquido,
               r.despacho,
               r.frete_total,
               r.valor_entregue,
               r.km_vazio,
               r.km_carregado,
               r.valor_pedagio_vazio,
               r.valor_pedagio_carregado,
               r.valor_descarga,
               r.org_logradouro,
               r.org_complemento,
               r.org_bairro,
               r.org_cep,
               nvl(r.org_cod_uf,
                   (select (select cu.cod_uf
                              from cep.cep_ufs cu
                             where cu.sigla_uf = mo.uf_id)
                      from cep.municipio mo
                     where mo.municipio_id = r.org_municipio_id)) as org_cod_uf,
               r.org_cod_municipio,
               r.org_cod_distrito,
               r.org_cod_dv,
               r.org_municipio_id,
               r.dest_logradouro,
               r.dest_complemento,
               r.dest_bairro,
               r.dest_cep,
               nvl(r.dest_cod_uf,
                   (select (select cu.cod_uf
                              from cep.cep_ufs cu
                             where cu.sigla_uf = mu.uf_id)
                      from cep.municipio mu
                     where mu.municipio_id = r.dest_municipio_id)) as dest_cod_uf,
               r.dest_cod_municipio,
               r.dest_cod_distrito,
               r.dest_cod_dv,
               r.dest_municipio_id,
               r.situacao_id,
               r.data_inicio_carga,
               r.data_termino_carga,
               r.data_inicio_descarga,
               r.data_termino_descarga,
               r.placa_controle,
               r.placa_referencia,
               r.mensagem_motorista,
               r.cod_pessoa_atraso_vazio,
               r.mensagem_prev_carregado,
               r.cod_pessoa_atraso_carr,
               r.bloquear_previsao_carr,
               r.bloquear_previsao_vazio,
               r.observacao,
               r.user_insert,
               r.date_insert,
               r.user_update,
               r.date_update,
               r.muda_filial_responsavel,
               r.cod_pessoa_filial,
               r.cod_pessoa_responsavel,
               r.rowid,
               trunc(r.data_inicio) data_ini,
               to_date(to_char(r.data_inicio, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_ini,
               trunc(r.data_termino) data_tem,
               to_date(to_char(r.data_termino, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_term,
               trunc(r.data_previsao_descarga) data_prev_descarga,
               to_date(to_char(r.data_previsao_descarga, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_prev_descarga,
               trunc(r.data_previsao_vazio) data_prev_vazio,
               to_date(to_char(r.data_previsao_vazio, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_prev_vazio,
               trunc(r.data_previsao_carregado) data_prev_carregado,
               to_date(to_char(r.data_previsao_carregado, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_prev_carregado,
               trunc(r.data_inicio_carga) data_ini_carga,
               to_date(to_char(r.data_inicio_carga, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_ini_carga,
               trunc(r.data_termino_carga) data_term_carga,
               to_date(to_char(r.data_termino_carga, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_term_carga,
               trunc(r.data_inicio_descarga) data_ini_descarga,
               to_date(to_char(r.data_inicio_descarga, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_ini_descarga,
               trunc(r.data_termino_descarga) data_tem_descarga,
               to_date(to_char(r.data_termino_descarga, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_term_descarga,
               trunc(r.data_destinado) data_dest,
               to_date(to_char(r.data_destinado, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_dest,
               trunc(r.data_vazio_planejado) data_vaz_planej,
               to_date(to_char(r.data_vazio_planejado, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_vaz_planej,
               trunc(r.data_carregado_planejado) data_carr_planej,
               to_date(to_char(r.data_carregado_planejado, 'HH24:MI:SS'), 'HH24:MI:SS') as hora_carr_planej,
               oper.pkg_operacional.fnc_converte_peso(r.peso_total,'Kg',r.cod_unidade) peso_real,
               (select un.unidade_negocio
                  from kss.v$unidade_negocio un
                 where un.cod_pessoa = r.cod_pessoa_filial) filial_manifesto,
               case
                when r.muda_filial_responsavel = 1 then
                 nvl(rf.filial_responsavel,
                     (select un.unidade_negocio
                        from kss.v$unidade_negocio un
                       where un.cod_pessoa = r.cod_pessoa_responsavel))
                else
                 (select un.unidade_negocio
                    from kss.v$unidade_negocio un
                   where un.cod_pessoa = r.cod_pessoa_responsavel)
               end filial_responsavel
          from oper.v$romaneio_dedicado r
          left join oper.v$rank_frota rf on rf.num_romaneio = r.num_romaneio
         where 1=1
         <cfif Len(Trim(arguments.num_romaneio))>
         	and r.num_romaneio = #arguments.num_romaneio#
         </cfif>
         <cfif Len(Trim(arguments.placa))>
         	and r.placa_controle = upper(#arguments.placa#);
         </cfif>
         </cfquery>
		<cfreturn qr_result>
	</cffunction>

   <!--- 
	-- PROPSITO
	-- Retorna os eventos do romaneio
	-- NOTAS EXPLICATIVAS
	-- RAFAEL_COSTA 05/06/2009
	--->
	<cffunction name="get_romaneio_eventos" displayname="Retorna os Eventos do Romaneio" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select /*+ORDERED*/
               re.controle_evo_id,
               re.data,
               re.num_evento,
               re.km,
               re.local,
               v.cod_veiculo placa,
               eos.descricao
          from oper.v$romaneio_evo re
         inner join oper.v$evento_operacao_setup eos
                 on eos.num_evento = re.num_evento
         inner join oper.v$veiculo v
                 on v.placa = re.placa
                 where 1=1
                 <cfif Len(Trim(arguments.num_romaneio))>
                    and re.num_romaneio = #arguments.num_romaneio#
                 </cfif>
                 order by re.data
         </cfquery>
		<cfreturn qr_result>
	</cffunction>
       
    <!--- 
	-- PROPSITO
	-- Retorna os eventos do romaneio
	-- NOTAS EXPLICATIVAS
	-- RAFAEL_COSTA 05/06/2009
	--->
	<cffunction name="get_romaneio_historico" displayname="Retorna o Histrico de um Romaneio" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+FIRST_ROWS*/
            v.cod_veiculo as cavalo,
            vv.cod_veiculo as carreta,
            rhv.data_inicio,
            rhv.data_termino,
            rhv.km_inicio,
            rhv.km_fim,
            oper.pkg_global.fnc_get_cod_funcionario(rhv.cod_pessoa)||' - '||(select pf.nome
                                                                              from oper.v$pessoa_fisica pf
                                                                             where pf.cod_pessoa = rhv.cod_pessoa) as motorista 
      from oper.v$romaneio_hist_veiculo rhv
     inner join oper.v$veiculo v
            on v.placa = rhv.placa_controle
      left join oper.v$veiculo vv
            on vv.placa = rhv.placa_referencia
            where 1=1
            <cfif Len(Trim(arguments.num_romaneio))>
        and rhv.num_romaneio = #arguments.num_romaneio#
            </cfif>
   order by rhv.data_inicio 
         </cfquery>
		<cfreturn qr_result>
	</cffunction>

       
    <!--- 
	-- PROPSITO
	-- Retorna os eventos do romaneio
	-- NOTAS EXPLICATIVAS
	-- RAFAEL_COSTA 05/06/2009
	--->
	<cffunction name="get_romaneio_itens" displayname="Retorna o Itens de um Romaneio" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ri.item_id,
					ri.num_romaneio,
					ri.num_lote,
					ri.volume,
					ri.peso,
					ri.peso_cobrado,
					ri.m3,
					ri.valor_frete,
					ri.cod_remetente,
					ri.rem_municipio_id,
					ri.cod_destinatario,
					ri.dest_municipio_id
                 , (select m.uf_id
              from cep.municipio m
             where m.municipio_id = ri.dest_municipio_id) dest_uf, 
           ri.observacao, 
           ri.redespacho, 
           ri.valor_frete_liquido,
           ri.despacho,
           ri.rowid, 
           ri.num_romaneio || ri.num_lote || ri.item_id chave,
           oper.pkg_operacional.fnc_converte_peso(ri.peso, 'Kg', rr.cod_unidade) as peso_real, 
			0.00 as valor_unitario, 
			'' as complemento_coleta, 
			'' as complemento_entrega, 
			case
              when (select count(*)
                      from oper.v$conhecimento c
                     where c.num_romaneio = ri.num_romaneio
                       and c.item_id = ri.item_id
                       and c.situacao_id <> 1) > 0 then 'Sim'
              when (select count(*)
                      from oper.v$manifesto it
                      where it.roo_item_id = ri.item_id
                        and it.situacao_id <> 5) > 0 then 'Sim'
              when (select count(*)
                      from fiscal.v$intc_manifesto i
                     where i.num_romaneio = ri.num_romaneio
                       and i.item_id = ri.item_id) > 0 then 'Sim'
              when (select count(*)
                      from fiscal.v$nf_es_frete n
                     where n.num_romaneio = ri.num_romaneio
                       and n.item_id = ri.item_id) > 0 then 'Sim'
              when (select count(*) * l.internacional
                      from oper.v$romaneio_intc_conhecimento i
                     inner join fiscal.v$intc_conhecimento c
                        on c.conhecimento_id = i.conhecimento_id
                     where i.num_romaneio = ri.num_romaneio) > 0 then 'Sim'
           else 'No' end documento, 
		   decode(l.frete_proprio,0,'Sub-contratado','Prprio') as frete, 
		   decode(l.internacional,0,'No','Sim') as internacional,
           kss.pkg_pessoa.fnc_get_cliente(ri.cod_remetente) as remetente, 
           l.fracionado, 
		   (select ma.num_manifesto
              from oper.v$manifesto ma
             where ma.roo_item_id = ri.item_id
               and ma.num_lote = ri.num_lote
               and ma.situacao_id <> 5   -- desconsidera cancelado
               and rownum = 1
           ) as num_manifesto
      from oper.v$romaneio_item ri
     inner join oper.v$romaneio rr
        on rr.num_romaneio = ri.num_romaneio
     inner join oper.v$lote l
        on l.num_lote = ri.num_lote
         		 where 1 =1            
                 <cfif Len(Trim(arguments.num_romaneio))>
                    and ri.num_romaneio = #arguments.num_romaneio#
                 </cfif>
         </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
       
    <!--- 
	-- PROPSITO
	-- Retorna os eventos do romaneio
	-- NOTAS EXPLICATIVAS
	-- RAFAEL_COSTA 05/06/2009
	--->
	<cffunction name="get_romaneio_rotas" displayname="Retorna o Histrico de um Romaneio" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="no" default="">
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			   select a.*,
               level as sequencia
  from (select it.itinerario_id,
               it.num_romaneio,
               it.placa_referencia,
               it.origem_municipio_id,
               it.destino_municipio_id,
               it.rota_id,
               it.km_rota,
               it.data_previsao,
               it.data_chegada,
               it.vazio_carregado,
               it.itinerario_id_anterior,
               it.itinerario_id_posterior,
               it.ordem,
               r.abreviatura,
               r.descricao_rota,
               r.abreviatura || ' - ' || r.descricao_rota as rota,
               ita.num_romaneio as romaneio_anterior
          from oper.v$romaneio_itinerario it
          left join oper.v$rota r on r.rota_id = it.rota_id
          left join oper.v$romaneio_itinerario ita on ita.itinerario_id = it.itinerario_id_anterior
         where it.num_romaneio = #arguments.num_romaneio# ) a
 start with num_romaneio <> romaneio_anterior
         or romaneio_anterior is null
connect by prior itinerario_id = itinerario_id_anterior
            </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
          
    <!--- 
	-- PROPSITO
	-- Retorna os eventos do romaneio
	-- NOTAS EXPLICATIVAS
	-- RAFAEL_COSTA 05/06/2009
	--->
	<cffunction name="get_carreta_atual" displayname="Retorna a carreta engatada no caminho" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select rhv.placa_controle,
        	   rhv.placa_referencia,
               to_char(rhv.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
          from oper.v$romaneio_hist_veiculo rhv
         where rhv.num_romaneio = #arguments.num_romaneio#
           and rhv.data_inicio = (select max(rhv1.data_inicio)
                                       from oper.v$romaneio_hist_veiculo rhv1
                                      where rhv1.num_romaneio = #arguments.num_romaneio#)
        </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
 	<!--- 
	-- PROPSITO
	-- Retorna os eventos do romaneio
	-- NOTAS EXPLICATIVAS
	-- RAFAEL_COSTA 05/06/2009
	--->
	<cffunction name="get_posicao_atual" displayname="Retorna a posio atual do caminho" output="true" returntype="query" access="remote">
		<cfargument name="placa_referencia" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select t.itinerario_id,
        	   t.destino_municipio_id,
               cep.fnc_municipio_uf(t.destino_municipio_id, ' - ') as municipio
          from oper.v$romaneio_itinerario t
         where placa_referencia like '#arguments.placa_referencia#'
           and itinerario_id_posterior is null
      order by itinerario_id desc
        </cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Retorna os valores de frete cadastrados para as rotas
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 17/06/2009
	--->
	<cffunction name="get_local_rota_valor" displayname="Retorna os valores de frete cadastrados para as rotas" output="true" returntype="query" access="remote">
		<cfargument name="rota_valor_id" required="no" default="" />
        <cfargument name="operacao_id" required="no" default="" />
		<cfargument name="local_rota_id" required="no" default="" />
        <cfargument name="classificacao_comercial_id" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select lrv.rota_valor_id
                 , lrv.local_rota_id
                 , (select r.abreviatura
                      from oper.v$rota r
                     where r.rota_id = lr.rota_id
                   ) as abreviatura
                 , (select r.descricao_rota
                      from oper.v$rota r
                     where r.rota_id = lr.rota_id
                   ) as descricao_rota
                 , lrv.classificacao_comercial_id
                 , (select cc.descricao
                      from comercial.v$classificacao_comercial cc
                     where cc.classificacao_comercial_id = lrv.classificacao_comercial_id
                   ) as classificacao_comercial
                 , lrv.valor_frete
                 , lrv.valor_km
                 , lrv.valor_ton
                 , to_char(lrv.data_vigencia, 'dd/mm/yyyy') as data_vigencia
                 , lrv.usuario_cancelamento
                 , to_char(lrv.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') data_cancelamento
              from dedicado.v$local_rota_valor lrv
             inner join dedicado.v$local_rota lr
                     on lr.local_rota_id = lrv.local_rota_id
             where 1 = 1
			<cfif Len(Trim(arguments.rota_valor_id))>
			   and lrv.rota_valor_id = #arguments.rota_valor_id#
            </cfif>
            <cfif Len(Trim(arguments.operacao_id))>
			   and lr.operacao_id = #arguments.operacao_id#
            </cfif>
            <cfif Len(Trim(arguments.local_rota_id))>
			   and lrv.local_rota_id = #arguments.local_rota_id#
            </cfif>
            <cfif Len(Trim(arguments.classificacao_comercial_id))>
			   and lrv.classificacao_comercial_id = #arguments.classificacao_comercial_id#
            </cfif>
             order by descricao_rota, classificacao_comercial, lrv.data_vigencia
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
    <!--- 
	-- PROPSITO
	-- Retorna os tipos de pagamentos para prmios cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 29/06/2009
	--->
	<cffunction name="get_tipo_pagto_premio" displayname="Retorna os tipos de pagamentos para prmios cadastrados" output="true" returntype="query" access="remote">
		<cfargument name="tipo_pagto_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tp.tipo_pagto_id,
                   tp.descricao
              from dedicado.v$tipo_pagto_premio tp
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_pagto_id))>
			   and tp.tipo_pagto_id = #arguments.tipo_pagto_id#
            </cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(tp.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by tp.descricao
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os prmios cadastrados
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 29/06/2009
	--->
	<cffunction name="get_premio" displayname="Retorna os prmios cadastrados" output="true" returntype="query" access="remote">
		<cfargument name="premio_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.premio_id,
                   p.titulo,
                   p.ativo,
                   case when p.ativo = 1 then 'Sim' else 'No' end as desc_ativo,
                   p.tipo_pagto_id,
                   tp.descricao as tipo_pagto
              from dedicado.v$premio p
              left join dedicado.v$tipo_pagto_premio tp
                     on tp.tipo_pagto_id = p.tipo_pagto_id
             where 1 = 1
			<cfif Len(Trim(arguments.premio_id))>
			   and p.premio_id = #arguments.premio_id#
            </cfif>
			<cfif Len(Trim(arguments.titulo))>
			   and upper(p.titulo) like upper('#arguments.titulo#%')
            </cfif>
             order by p.titulo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as origens de reclamaes cadastradas
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 29/06/2009
	--->
	<cffunction name="get_origem_reclamacao" displayname="Retorna as origens de reclamaes cadastradas" output="true" returntype="query" access="remote">
		<cfargument name="origem_reclamacao_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.origem_reclamacao_id,
                   o.descricao
              from dedicado.v$origem_reclamacao o
             where 1 = 1
			<cfif Len(Trim(arguments.origem_reclamacao_id))>
			   and o.origem_reclamacao_id = #arguments.origem_reclamacao_id#
            </cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(o.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by o.descricao
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os reclamaes cadastradas
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 29/06/2009
	--->
	<cffunction name="get_reclamacao" displayname="Retorna os reclamaes cadastradas" output="true" returntype="query" access="remote">
		<cfargument name="reclamacao_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.reclamacao_id, 
                   to_char(r.data_reclamacao, 'dd/mm/yyyy') as data_reclamacao, 
                   r.cod_motorista,
                   p.cliente as motorista_nome,
                   p.cnpj_cpf as motorista_cpf,
                   r.origem_reclamacao_id, 
                   o.descricao as origem_reclamacao,
                   r.observacao
              from dedicado.v$reclamacao r 
              left join kss.v$pessoa p
                     on p.cod_pessoa = r.cod_motorista
              left join dedicado.v$origem_reclamacao o
                     on o.origem_reclamacao_id = r.origem_reclamacao_id
             where 1 = 1
			<cfif Len(Trim(arguments.reclamacao_id))>
			   and r.reclamacao_id = #arguments.reclamacao_id#
            </cfif>
			<cfif Len(Trim(arguments.data_inicio))>
			   and trunc(r.data_reclamacao) >= '#arguments.data_inicio#'
			</cfif>
            <cfif Len(Trim(arguments.data_fim))>
			   and trunc(r.data_reclamacao) <= '#arguments.data_fim#'
			</cfif>
             order by r.data_reclamacao desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
   
    <!--- 
	-- PROPSITO
	-- Retorna os valores de premiao
	-- NOTAS EXPLICATIVAS
	-- JONAS 02/07/2009
	--->
	<cffunction name="get_premio_valores" displayname="Retorna os valores de premiao" output="true" returntype="query" access="remote">
		<cfargument name="premio_valores_id" required="no" default="">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select pv.premio_valores_id,
                pv.valor_referencial,
                pv.nao_sinistro,
                pv.km_rodado,
                pv.punicao,
                pv.premio_pago,
                to_char(pv.vigencia,'dd/mm/yyyy') as vigencia
           from dedicado.v$premio_valores pv
          where 1 = 1
          <cfif Len(Trim(arguments.premio_valores_id))>
            and pv.premio_valores_id = #arguments.premio_valores_id#
          </cfif>
          order by pv.vigencia desc,pv.premio_valores_id asc
      </cfquery>
      <cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os reclamaes cadastradas
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 29/06/2009
	--->
	<cffunction name="get_sinistro" displayname="Retorna os reclamaes cadastradas" output="true" returntype="query" access="remote">
		<cfargument name="sinistro_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="placas" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.sinistro_id,
                   to_char(s.data_ocorrencia, 'dd/mm/yyyy') as data_ocorrencia,
                   s.placa,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(s.placa) as cod_veiculo,
                   s.cod_motorista,
                   p.cliente as motorista_nome,
                   p.cnpj_cpf as motorista_cpf,
                   p.identificador as motorista_identificador,
                   s.ocorrencia
              from dedicado.v$sinistro s
              left join kss.v$pessoa p
                     on p.cod_pessoa = s.cod_motorista
             where 1 = 1
			<cfif Len(Trim(arguments.sinistro_id))>
			   and s.sinistro_id = #arguments.sinistro_id#
            </cfif>
			<cfif Len(Trim(arguments.data_inicio))>
			   and trunc(s.data_ocorrencia) >= '#arguments.data_inicio#'
			</cfif>
            <cfif Len(Trim(arguments.data_fim))>
			   and trunc(s.data_ocorrencia) <= '#arguments.data_fim#'
			</cfif>
            <cfif Len(Trim(arguments.placa))>
			   and upper(s.placa) = upper('#arguments.placa#')
            </cfif>
             order by s.data_ocorrencia desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os valores de premiao por faixa de mdia de consumo
	-- NOTAS EXPLICATIVAS
	-- JONAS 02/07/2009
	--->
	<cffunction name="get_premio_faixa_consumo" displayname="Retorna os valores de premiao por faixa de mdia de consumo" output="true" returntype="query" access="remote">
		<cfargument name="faixa_id" required="no" default="">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select pfc.faixa_id
                ,pfc.operacao_id
                ,pfc.faixa_inicial
                ,pfc.faixa_final
                ,pfc.premio
            from dedicado.v$premio_faixa_consumo pfc
           where 1 = 1
          <cfif Len(Trim(arguments.faixa_id))>
            and pfc.faixa_id = #arguments.faixa_id#
          </cfif>         
      </cfquery>
      <cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna o consumo por motorista de acordo com a operao e o intervalo de tempo estipulado
	-- NOTAS EXPLICATIVAS
	-- LEANDRO 17/02/2010
	--->
	<cffunction name="get_consumo_motorista" displayname="Retorna os consumos por motorista" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select b.controle_id,
                   b.cod_veiculo,
                   b.placa,
                   b.data_hora,
                   b.quantidade,
                   (b.km - b.km_anterior) as km_rodado,
                   b.km_anterior,
                   b.km,
                   b.carregamento,
                   b.cod_motorista,
                   kss.pkg_pessoa.fnc_get_cliente(b.cod_motorista) as motorista,
                   round(decode((b.km_anterior - b.km), 0, 1, (b.km - b.km_anterior))/b.quantidade,2) as consumo
              from (select a.controle_id,
                           v.cod_veiculo,
                           v.placa,
                           a.data_hora,
                           a.quantidade,
                           a.km,
                           (select max(a2.km) keep(dense_rank last order by a2.data_hora)
                              from oper.v$abastecimento a2
                             where a2.placa = a.placa
                               and a2.data_hora < a.data_hora) as km_anterior,
                           (select max(r.carregamento) keep(dense_rank last order by data_inicio)
                              from oper.v$romaneio_todos r
                             where r.placa_controle = a.placa
                               and r.data_inicio < a.data_hora) as carregamento,
                           (select max(vm.cod_pessoa) keep (dense_rank last order by vm.data_inicio)
                              from oper.v$veiculo_motorista vm
                             where vm.placa = v.placa) as cod_motorista
                      from oper.v$abastecimento a
                     inner join oper.v$veiculo v 
                             on a.placa = v.placa
                     where 1 = 1
                       and a.data_hora between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                       and a.combustivel = 1
                       and exists (select 1
                                     from dedicado.v$operacao_veiculo ov
                                    where ov.placa = a.placa
                                      and ov.operacao_id = #arguments.operacao_id#
                                      and a.data_hora between ov.data_inicio and nvl(ov.data_termino, sysdate))
                   ) b
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
     <!--- 
	-- PROPSITO
	-- Retorna os faturamentos de acordo com a operao e o intervalo de tempo estipulado
	-- NOTAS EXPLICATIVAS
	-- LEANDRO 17/02/2010
	--->
	<cffunction name="get_faturamento" displayname="Retorna os faturamentos" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select num_romaneio, carregamento
               , (select p.cliente 
                         from kss.v$pessoa p
                         where p.cod_pessoa = a.cod_pessoa_motorista) as motorista
               , to_char(data_inicio, 'dd/mm hh24:mi') as data_inicio
               , to_char(data_termino, 'dd/mm hh24:mi') as data_termino
               , tempo_viagem
               , kss.to_tempo(numtodsinterval(sum(tempo_viagem_num) over(),'DAY'),4).retorno as tempo_total_viagem
               , data_inicio_carga, data_termino_carga
               , tempo_carga, kss.to_tempo(numtodsinterval(sum(tempo_carga_num) over(),'DAY'),4).retorno as tempo_total_carga
               , data_inicio_descarga, data_termino_descarga 
               , tempo_descarga, kss.to_tempo(numtodsinterval(sum(tempo_descarga_num) over(),'DAY'),4).retorno as tempo_total_descarga
               , placa_controle
               , frota_cavalo
               , placa_referencia
               , frota_carreta
               , peso_total
               , nota_fiscal
               , num_ticket
               , a.km_f_carregado - km_i_vazio as km_romaneio
               , a.km_f_vazio - km_i_vazio as km_vazio
               , a.km_f_carregado - km_i_carregado as km_carregado
               , decode(dedicado.pkg_operacao.fnc_valor_faixa_km(1,a.km_f_carregado - km_i_carregado, data_inicio),0,dedicado.pkg_operacao.fnc_valor_romaneio(num_romaneio),dedicado.pkg_operacao.fnc_valor_faixa_km(1,a.km_f_carregado - km_i_carregado, data_inicio)) as valor_faixa
            from (select r.num_romaneio
                       , r.carregamento
                       , r.data_inicio
                       , r.data_termino
                       , kss.to_tempo(numtodsinterval(r.data_termino - r.data_inicio,'DAY'),4).retorno as tempo_viagem
                       , r.data_termino - r.data_inicio  as tempo_viagem_num
                       , to_char(r.data_inicio_carga, 'dd/mm hh24:mi') as data_inicio_carga
                       , to_char(r.data_termino_carga, 'dd/mm hh24:mi') as data_termino_carga
                       , kss.to_tempo(numtodsinterval(r.data_termino_carga - r.data_inicio_carga, 'DAY'),4).retorno as tempo_carga
                       , r.data_termino_carga - r.data_inicio_carga as tempo_carga_num
                       , to_char(r.data_inicio_descarga, 'dd/mm hh24:mi') as data_inicio_descarga
                       , to_char(r.data_termino_descarga, 'dd/mm hh24:mi') as data_termino_descarga
                       , kss.to_tempo(numtodsinterval(r.data_termino_descarga -  r.data_inicio_descarga, 'DAY'),4).retorno as tempo_descarga
                       , r.data_termino_descarga - r.data_inicio_descarga as tempo_descarga_num
                       , r.placa_controle
                       , oper.fnc_get_cod_veiculo(r.placa_controle) as frota_cavalo
                       , r.placa_referencia
                       , oper.fnc_get_cod_veiculo(r.placa_referencia) as frota_carreta
                       , nvl(r.peso_total,0) as peso_total
                       , (select kss.fnc_concat_all(kss.to_concat_expr(valor, '-'))
                           from oper.v$romaneio_evento re
                           inner join oper.v$evento_operacao_dado eod
                                   on re.controle_evo_id = eod.controle_evo_id
                                  and eod.dado_id = 39
                          where re.num_romaneio = r.num_romaneio) as nota_fiscal
                       , (select kss.fnc_concat_all(kss.to_concat_expr(valor, '-'))
                            from oper.v$romaneio_evento re
                           inner join oper.v$evento_operacao_dado eod
                                   on re.controle_evo_id = eod.controle_evo_id
                                  and eod.dado_id = 37
                           where re.num_romaneio = r.num_romaneio) as num_ticket
                       , dedicado.pkg_operacao.fnc_ultimo_km(r.placa_controle, oper.to_evo_romaneio(221, r.num_romaneio).data) as km_i_vazio
                       , (select min(re.km)
                            from oper.v$romaneio_evo re
                           where re.num_romaneio = r.num_romaneio
                             and re.num_evento in (2, 234, 257)
                         ) as km_f_vazio
                       , (select min(re.km)
                            from oper.v$romaneio_evo re
                           where re.num_romaneio = r.num_romaneio
                             and re.num_evento in (2, 234, 257)
                         ) as km_i_carregado
                       , (select min(re.km)
                            from oper.v$romaneio_evo re
                           where re.num_romaneio = r.num_romaneio
                             and re.num_evento in (4, 249, 262)
                         ) as km_f_carregado                       
                       , (select max(rhv.cod_pessoa) keep (dense_rank last order by rhv.data_inicio)
                            from oper.v$romaneio_hist_veiculo rhv
                           where rhv.num_romaneio = r.num_romaneio) as cod_pessoa_motorista
                    from oper.v$romaneio_dedicado r
                   where exists (select 1
                                   from dedicado.v$operacao_veiculo ov
                                  where ov.placa = r.placa_controle
                                    and ov.operacao_id = #arguments.operacao_id#
                                    and r.data_termino between ov.data_inicio and nvl(ov.data_termino,sysdate))
                        and exists (select 1
                                      from dedicado.v$operacao_veiculo ov
                                     where ov.placa = r.placa_controle
                                       and ov.operacao_id = #arguments.operacao_id#
                                       and r.data_termino between ov.data_inicio and nvl(ov.data_termino,sysdate))
                    and r.data_termino >= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
                    and (r.data_termino <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') or data_termino is null)
                ) a
              order by a.data_inicio asc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as horas trabalhadas de acordo com o motorista, operao e o intervalo de tempo estipulado
	-- NOTAS EXPLICATIVAS
	-- LEANDRO 17/02/2010
	--->
	<cffunction name="get_horas_trabalhadas" displayname="Retorna as horas trabalhadas dos motoristas" output="true" returntype="query" access="remote">
		<cfargument name="operacao_id" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cliente as motorista
                 , vm.placa
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(vm.placa) as frota
                 , to_char(vm.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as entrada
                 , to_char(vm.data_fim, 'dd/mm/yyyy hh24:mi:ss') as saida
                 , kss.to_tempo(numtodsinterval(nvl(vm.data_fim, sysdate)-vm.data_inicio,'DAY')).retorno as tempo_total
                 , dedicado.pkg_relatorio.fnc_coluna_valor_data(4,10, 23, vm.placa,vm.data_inicio, nvl(vm.data_fim, sysdate)) as tempo_carga_descarga
                 , dedicado.pkg_relatorio.fnc_coluna_valor_data(4,11, 23, vm.placa,vm.data_inicio, nvl(vm.data_fim, sysdate)) as tempo_manutencao
                 , dedicado.pkg_relatorio.fnc_coluna_valor_data(4,12, 23, vm.placa,vm.data_inicio, nvl(vm.data_fim, sysdate)) as tempo_parado
              from oper.v$veiculo_motorista vm
             inner join kss.v$pessoa p
                     on p.cod_pessoa = vm.cod_pessoa
             where vm.data_inicio between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
               and exists (select 1
                             from dedicado.v$operacao_veiculo ov
                            where ov.placa = vm.placa
                              and ov.operacao_id = #arguments.operacao_id#
                              and vm.data_inicio between ov.data_inicio and nvl(ov.data_termino, sysdate)
                          )
               and exists (select 1
                             from dedicado.v$operacao_funcionario fu
                            where fu.cod_pessoa = vm.cod_pessoa
                              and fu.operacao_id = #arguments.operacao_id#
                              and vm.data_inicio between fu.data_inicio and nvl(fu.data_termino, sysdate)
                          )
			<cfif Len(Trim(arguments.cod_motorista))>
               and vm.cod_pessoa = #arguments.cod_motorista#
            </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Relao de Odmetros
    -- ANDERSON 18/02/2010 - CRIADO
    --->		
    <cffunction name="get_relacao_odometro" access="remote" returntype="query" output="true">
        <cfargument name="operacao_id" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="placa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select t.placa
                 , t.cod_veiculo
                 , t.km_inicial
                 , to_char(t.data_inicial, 'dd/mm/yyyy hh24:mi:ss') as data_inicial
                 , t.km_final
                 , to_char(t.data_final, 'dd/mm/yyyy hh24:mi:ss') as data_final
                 , t.km_final - t.km_inicial as km_rodado
              from (select v.placa
                         , v.cod_veiculo
                         , (select min(vk.km) keep(dense_rank last order by vk.data_hora desc)
                               from oper.v$veiculo_km vk
                              where vk.placa = v.placa
                                and vk.data_hora between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as km_inicial
                         , (select min(vk.data_hora) keep(dense_rank last order by vk.data_hora desc)
                              from oper.v$veiculo_km vk
                             where vk.placa = v.placa
                               and vk.data_hora between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as data_inicial
                         , (select max(vk.km) keep(dense_rank last order by vk.data_hora)
                              from oper.v$veiculo_km vk
                             where vk.placa = v.placa
                               and vk.data_hora between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as km_final
                         , (select max(vk.data_hora) keep(dense_rank last order by vk.data_hora)
                              from oper.v$veiculo_km vk
                             where vk.placa = v.placa
                               and vk.data_hora between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')) as data_final
                      from oper.v$veiculo v
                     inner join oper.v$veiculo_tipo_carroceria vtc
                             on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                     inner join oper.v$veiculo_agrupamento va
                             on va.agrupamento_id = vtc.agrupamento_id
                            and va.tracao = 1
                     where exists (select 1
                                     from dedicado.v$operacao_veiculo ov
                                    where ov.placa = v.placa
                                      and ov.operacao_id = #arguments.operacao_id#
                                      and to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') between ov.data_inicio and nvl(ov.data_termino, sysdate)
                                  )
					<cfif Len(Trim(arguments.placa))>
                       and v.placa = '#arguments.placa#'
                    </cfif>
                   ) t
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Relatrio de Ciclo de Viagem
    -- ANDERSON 18/02/2010 - CRIADO
    --->		
    <cffunction name="get_ciclo_viagem" access="remote" returntype="query" output="true">
        <cfargument name="operacao_id" required="yes">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio
                 , r.carregamento
                 , to_char(r.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio
                 , to_char(r.data_termino, 'dd/mm/yyyy hh24:mi:ss') as data_termino
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) as frota
                 , dedicado.pkg_relatorio.fnc_coluna_valor(1, 1, #arguments.operacao_id#, r.num_romaneio) as aguardando_carga
                 , dedicado.pkg_relatorio.fnc_coluna_valor(1, 2, #arguments.operacao_id#, r.num_romaneio) as carregando
                 , dedicado.pkg_relatorio.fnc_coluna_valor(1, 6, #arguments.operacao_id#, r.num_romaneio) as total_carga
                 , dedicado.pkg_relatorio.fnc_coluna_valor(1, 3, #arguments.operacao_id#, r.num_romaneio) as pesagem
                 , dedicado.pkg_relatorio.fnc_coluna_valor(1, 5, #arguments.operacao_id#, r.num_romaneio) as aguardando_descarga
                 , dedicado.pkg_relatorio.fnc_coluna_valor(1, 4, #arguments.operacao_id#, r.num_romaneio) as descarga
                 , dedicado.pkg_relatorio.fnc_coluna_valor(1, 7, #arguments.operacao_id#, r.num_romaneio) as ciclo_total
                 , dedicado.pkg_relatorio.fnc_coluna_valor(1, 8, #arguments.operacao_id#, r.num_romaneio) as km_total
                 , (select p.cliente 
                      from oper.v$romaneio_hist_veiculo rhv
                     inner join oper.v$romaneio_todos rt
                             on rt.num_romaneio = rhv.num_romaneio
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = rhv.cod_pessoa
                     where nvl(rhv.data_termino, sysdate) = (select max(nvl(rhv2.data_termino, sysdate))
                                                               from oper.v$romaneio_hist_veiculo rhv2
                                                              where rhv2.num_romaneio = rhv.num_romaneio)
                       and rhv.num_romaneio = r.num_romaneio) as motorista
              from oper.v$romaneio_dedicado r
             where exists (select 1 
                             from dedicado.v$operacao_veiculo ov
                            where ov.placa = r.placa_controle
                              and ov.operacao_id = #arguments.operacao_id#
                              and r.data_termino between ov.data_inicio and nvl(ov.data_termino, sysdate)
                          )
                  
               and exists (select 1 
                             from dedicado.v$operacao_veiculo ov
                            where ov.placa = r.placa_referencia
                              and ov.operacao_id = #arguments.operacao_id#
                              and r.data_termino between ov.data_inicio and nvl(ov.data_termino, sysdate)
                          )
               and data_termino >= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
               and (data_termino <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss') or data_termino is null)
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as ocorrncias de uma operao dedicada
    -- ANDERSON 25/11/2010 - CRIADO
    --->		
    <cffunction name="get_operacao_ocorrencia" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oo.operacao_ocorrencia_id
                 , oo.operacao_id
                 , oo.ocorrencia_id
                 , o.tipo_id
                 , kss.fnc_ref_code('DEDICADO', 'OCORRENCIA.TIPO_ID', o.tipo_id) as tipo
                 , o.usuario
                 , to_char(o.data, 'dd/mm/yyyy hh24:mi:ss') as data
                 , o.descricao
              from dedicado.v$operacao_ocorrencia oo
             inner join dedicado.v$ocorrencia o
                     on o.ocorrencia_id = oo.ocorrencia_id
             where oo.operacao_id = #arguments.operacao_id#
             order by o.data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as ocorrncias de um valor de frete por rota
    -- ANDERSON 25/11/2010 - CRIADO
    --->		
    <cffunction name="get_rota_valor_ocorrencia" access="remote" returntype="query" output="true">
    	<cfargument name="rota_valor_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rvo.rota_valor_ocorrencia_id
                 , rvo.rota_valor_id
                 , rvo.ocorrencia_id
                 , o.tipo_id
                 , kss.fnc_ref_code('DEDICADO', 'OCORRENCIA.TIPO_ID', o.tipo_id) as tipo
                 , o.usuario
                 , to_char(o.data, 'dd/mm/yyyy hh24:mi:ss') as data
                 , o.descricao
              from dedicado.v$rota_valor_ocorrencia rvo
             inner join dedicado.v$ocorrencia o
                     on o.ocorrencia_id = rvo.ocorrencia_id
             where rvo.rota_valor_id = #arguments.rota_valor_id#
             order by o.data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna um romaneio
    -- ANDERSON 30/11/2010 - CRIADO
    --->		
    <cffunction name="get_romaneio_simplificado" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio
                 , r.placa_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) as cod_veiculo_controle
                 , r.placa_referencia
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia) as cod_veiculo_referencia
                 , r.carregamento
                 , r.destino
                 , r.remetente
                 , r.destinatario
                 , r.peso_total
                 , to_char(r.data_destinado, 'dd/mm/yyyy hh24:mi:ss') as data_destinado
                 , to_char(r.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio
                 , to_char(r.data_termino, 'dd/mm/yyyy hh24:mi:ss') as data_termino
                 , to_char(r.data_inicio_carga, 'dd/mm/yyyy hh24:mi:ss') as data_inicio_carga
                 , to_char(r.data_termino_carga, 'dd/mm/yyyy hh24:mi:ss') as data_termino_carga
                 , to_char(r.data_inicio_descarga, 'dd/mm/yyyy hh24:mi:ss') as data_inicio_descarga
                 , to_char(r.data_termino_descarga, 'dd/mm/yyyy hh24:mi:ss') as data_termino_descarga
                 , r.situacao_id
                 , r.dedicado
                 , (select rod.romaneio_operacao_id
                      from oper.v$romaneio_operacao_dedicada rod
                     where rod.num_romaneio = r.num_romaneio
                   ) as romaneio_operacao_id
                 , (select rod.operacao_id
                      from oper.v$romaneio_operacao_dedicada rod
                     where rod.num_romaneio = r.num_romaneio
                   ) as operacao_id
                 , (select rod.local_rota_id
                      from oper.v$romaneio_operacao_dedicada rod
                     where rod.num_romaneio = r.num_romaneio
                   ) as local_rota_id
                 , (select o.cfa_pre_impressa
                      from oper.v$romaneio_operacao_dedicada rod
                     inner join dedicado.v$operacao o
                             on o.operacao_id = rod.operacao_id
                     where rod.num_romaneio = r.num_romaneio
                   ) as cfa_pre_impressa
              from oper.v$romaneio r
             where r.num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as viagens para o "Conferncia de Viagens"
    -- ANDERSON 30/11/2010 - CRIADO
    --->		
    <cffunction name="get_conferencia_viagem" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="yes" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfargument name="placa" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="cod_proprietario" required="no" default="" />
        <cfargument name="valores_zerados" required="no" default="" />
        <cfargument name="conferida" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.num_romaneio
                 , t.carregamento
                 , t.origem
                 , t.destino
                 , t.cliente
                 , t.remetente
                 , t.destinatario
                 , t.placa_controle
                 , t.cod_frota_tracao
                 , t.placa_referencia
                 , t.cod_frota_reboque
                 , t.data_inicio
                 , to_char(t.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
                 , t.data_inicio_carga
                 , t.data_termino_carga
                 , t.data_inicio_descarga
                 , t.data_termino_descarga
                 , t.mercadoria
                 , t.peso_total
                 , t.frete_total
                 , t.valor_entregue
                 , t.situacao_romaneio
                 , t.conferencia_viagem
                 , t.situacao_viagem
                 , t.cod_funcionario
                 , t.motorista
                 , t.total_icms
                 , t.tem_complemento
                 , t.redespacho
                 , t.frete_liquido
                 , t.nf
                 , t.tempo_carga
                 , t.tempo_descarga
                 , oper.pkg_global.fnc_tempo_formatado(t.tempo_carga) as tempo_carga_formatado
                 , oper.pkg_global.fnc_tempo_formatado(t.tempo_descarga) as tempo_descarga_formatado
                 , t.valor_despacho_ctrc
                 , t.grupo
                 , (select dedicado.to_operacao_dados(rod.operacao_id).nome_completo
                      from oper.v$romaneio_operacao_dedicada rod
                     where rod.num_romaneio = t.num_romaneio
                   ) as operacao_dedicada
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.user_update
                 , to_char(t.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from oper.v$conferencia_viagem t
             where 1 = 1
               and exists (select 1
                             from oper.v$romaneio_operacao_dedicada rod
                            where rod.num_romaneio = t.num_romaneio
                              and rod.operacao_id = #arguments.operacao_id#
                          )
			<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
               and nvl(t.data_termino, sysdate) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_inicio))>
               and nvl(t.data_termino, sysdate) >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_termino))>
               and nvl(t.data_termino, sysdate) <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.placa))>
               and (t.placa_controle = '#arguments.placa#' or t.placa_referencia = '#arguments.placa#')
            </cfif>
            <cfif Len(Trim(arguments.cod_motorista))>
               and t.cod_pessoa = #arguments.cod_motorista#
            </cfif>
            <cfif Len(Trim(arguments.cod_proprietario))>
               and t.cod_pessoa_proprietario = #arguments.cod_proprietario#
            </cfif>
            <cfif Len(Trim(arguments.valores_zerados))>
				<cfif arguments.valores_zerados eq 0>
                	and oper.pkg_romaneio.fnc_valor_receita_romaneio(t.num_romaneio) <> 0
                <cfelseif arguments.valores_zerados eq 1>
                    and oper.pkg_romaneio.fnc_valor_receita_romaneio(t.num_romaneio) = 0
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.conferida))>
				<cfif arguments.conferida eq 0>
					and t.situacao_id in (0, 1, 3)
                <cfelseif arguments.conferida eq 1>
                	and t.situacao_id = 2
                </cfif>
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os eventos de um romaneio
    -- ANDERSON 30/11/2010 - CRIADO
    --->		
    <cffunction name="get_romaneio_evo" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select re.controle_evo_id
                 , to_char(re.data, 'dd/mm/yyyy hh24:mi:ss') as data
                 , re.num_evento
                 , re.km
                 , re.local
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(re.placa) as cod_veiculo
                 , (select eos.descricao
                      from oper.v$evento_operacao_setup eos
                     where eos.num_evento = re.num_evento
                   ) as descricao_evento
              from oper.v$romaneio_evo re
             where re.num_romaneio = #arguments.num_romaneio#
             order by re.data
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os CTRCs de um romaneio
    -- ANDERSON 30/11/2010 - CRIADO
    --->		
    <cffunction name="get_romaneio_conhecimento" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , c.num_conhecimento
                 , (select kss.fnc_concat_all(kss.to_concat_expr(max(ri.num_lote), ', '))
                      from oper.v$romaneio_item ri
                     where ri.num_romaneio = c.num_romaneio
                     group by ri.num_lote
                   ) as lote
                 , (select u.unidade_negocio
                      from kss.v$unidade_negocio u
                     where u.cod_pessoa = c.cod_pessoa_filial
                   ) as unidade_negocio
                 , c.rem_razao_social
                 , c.rem_municipio
                 , c.dest_razao_social
                 , c.dest_municipio
                 , c.total_conhecimento
                 , c.volume
                 , c.peso_real
                 , c.peso
                 , (select kss.fnc_concat_all(kss.to_concat_expr(m.num_manifesto, ', '))
                      from oper.v$manifesto_conhecimento mc
                     inner join oper.v$manifesto m
                        on m.manifesto_id = mc.manifesto_id
                     where mc.conhecimento_id = c.conhecimento_id
                   ) as manifesto
              from fiscal.v$conhecimento c
             where c.num_romaneio = #arguments.num_romaneio#
             order by c.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as Cartas Frete de um romaneio
    -- ANDERSON 30/11/2010 - CRIADO
    --->		
    <cffunction name="get_romaneio_carta_frete" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , c.lancto_id
                 , c.num_formulario
                 , c.valor_frete_bruto
                 , kss.pkg_pessoa.fnc_get_cliente(c.proprietario_cod_pessoa) as proprietario
                 , (select u.unidade_negocio
                      from kss.v$unidade_negocio u
                     where u.cod_pessoa = c.cod_pessoa_filial
                   ) as unidade_negocio
              from oper.v$contrato_transp c
             where c.num_romaneio = #arguments.num_romaneio#
             union all
            select to_char(cf.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao
                 , cf.lancto_id
                 , cf.num_formulario
                 , cf.valor_frete_bruto
                 , kss.pkg_pessoa.fnc_get_cliente(cf.proprietario_cod_pessoa) as proprietario
                 , (select u.unidade_negocio
                      from kss.v$unidade_negocio u
                     where u.cod_pessoa = cf.cod_pessoa_filial
                   ) as unidade_negocio
              from oper.v$cfa cf
             where cf.num_romaneio = #arguments.num_romaneio#
               and cf.data_cancelamento is null
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados da impresso no formato A4
    -- ANDERSON 30/11/2010 - CRIADO
    --->		
    <cffunction name="get_cfa_dedicado_form" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.lancto_id
                 , t.lancto_id_pai
                 , t.num_formulario
                 , t.filial
                 , t.filial_cnpj
                 , t.emissao_data
                 , t.emissao_local_endereco
                 , t.emissao_local_municipio
                 , t.modalidade_transporte
                 , t.num_conhecimento
                 , t.num_romaneio
                 , t.cliente
                 , t.operacao
                 , t.cliente_cnpj_cpf
                 , t.cliente_municipio_uf
                 , t.origem
                 , t.destino
                 , t.num_nota_fiscal
                 , t.natureza_carga
                 , t.peso
                 , t.proprietario_nome
                 , t.proprietario_cnpj_cpf
                 , t.proprietario_endereco
                 , t.proprietario_municipio
                 , t.motorista_nome
                 , t.motorista_cpf
                 , t.placa
                 , t.valor_unitario
                 , t.valor_total_servico
                 , t.valor_carga_descarga
                 , t.valor_pedagio
                 , t.valor_servico_prestado
                 , t.valor_irrf
                 , t.valor_total_adto
                 , t.valor_icms_retido
                 , t.valor_liquido_servico
                 , t.valor_falta_avaria
                 , t.valor_inss_sest_senat
                 , t.valor_liquido_pagar
              from oper.v$cfa_dedicado_form t
             where t.lancto_id = #arguments.lancto_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os usurios vinculados  uma operao dedicada que podem fazer auditoria
    -- ANDERSON 29/12/2010 - CRIADO
    --->		
    <cffunction name="get_operacao_usuario_auditoria" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="yes" />
        <cfargument name="sessao_atual" required="no" default="0" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oua.operacao_usuario_auditoria_id
                 , oua.operacao_id
                 , oua.usuario
              from dedicado.v$operacao_usuario_auditoria oua
             where oua.operacao_id = #arguments.operacao_id#
			<cfif arguments.sessao_atual eq 1>
               and oua.usuario = user
            </cfif>
             order by oua.usuario
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as ocorrncias no lidas de uma operao dedicada
    -- ANDERSON 29/12/2010 - CRIADO
    --->		
    <cffunction name="get_auditoria_ocorrencias" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.ocorrencia_id
                 , t.tipo_id
                 , t.tipo
                 , t.descricao_rota
                 , t.classificacao_comercial
                 , t.usuario
                 , to_char(t.data, 'dd/mm/yyyy hh24:mi:ss') as data
                 , t.descricao
              from (
                    select o.ocorrencia_id
                         , o.tipo_id
                         , kss.fnc_ref_code('DEDICADO', 'OCORRENCIA.TIPO_ID', o.tipo_id) as tipo
                         , null as descricao_rota
                         , null as classificacao_comercial
                         , o.usuario
                         , o.data
                         , o.descricao
                      from dedicado.v$operacao_ocorrencia oo
                     inner join dedicado.v$ocorrencia o
                             on o.ocorrencia_id = oo.ocorrencia_id
                     where oo.operacao_id = #arguments.operacao_id#
                       and o.lida = 0
                                
                     union all
                                
                    select o.ocorrencia_id
                         , o.tipo_id
                         , kss.fnc_ref_code('DEDICADO', 'OCORRENCIA.TIPO_ID', o.tipo_id) as tipo
                         , (select r.descricao_rota
                              from dedicado.v$local_rota lr
                             inner join oper.v$rota r
                                     on r.rota_id = lr.rota_id
                             where lr.local_rota_id = lrv.local_rota_id
                           ) as descricao_rota
                         , (select cc.descricao
                              from comercial.v$classificacao_comercial cc
                             where cc.classificacao_comercial_id = lrv.classificacao_comercial_id
                           ) as classificacao_comercial
                         , o.usuario
                         , o.data
                         , o.descricao
                      from dedicado.v$rota_valor_ocorrencia rvo
                     inner join dedicado.v$local_rota_valor lrv
                             on lrv.rota_valor_id = rvo.rota_valor_id
                     inner join dedicado.v$ocorrencia o
                             on o.ocorrencia_id = rvo.ocorrencia_id
                     where exists (select 1
                                     from dedicado.v$local_rota lr
                                    where lr.local_rota_id = lrv.local_rota_id
                                      and lr.operacao_id = #arguments.operacao_id#
                                  )
                       and o.lida = 0
                   ) t
             order by t.data, t.tipo_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>