<cfcomponent displayname="Consultas da referentes a CTE" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Buscar dados da NFE
	-- RAFAEL 16/07/2010 17:37:17 - CRIADO
	--->
	<cffunction name='get_nfe_dados' displayname='Buscar dados da NFE' access='remote' returntype='Struct' output='true'>
		<cfargument name='NFE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_nfe_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR' dbvarname='P_NFE'  value='#arguments.NFE#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHAVE' variable='retorno.CHAVE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO' variable='retorno.NUMERO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE' variable='retorno.SERIE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO' variable='retorno.DATA_EMISSAO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CNPJ_EMITENTE' variable='retorno.CNPJ_EMITENTE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMITENTE' variable='retorno.EMITENTE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CNPJ_DESTINATARIO' variable='retorno.CNPJ_DESTINATARIO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESTINATARIO' variable='retorno.DESTINATARIO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR' variable='retorno.VALOR' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO' variable='retorno.MODELO' >
                    <!---<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO' variable='retorno.PESO' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ESPECIE' variable='retorno.ESPECIE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE_VOLUMES' variable='retorno.QUANTIDADE_VOLUMES' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE' variable='retorno.QUANTIDADE' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UNIDADE' variable='retorno.UNIDADE' >--->
				</cfstoredproc>
				<cfset retorno.erro = false>				
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_cte_lista" displayname="Busca Modelos para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="data_inicio" required="no" default="#DateFormat(now() - 7, 'DD/MM/YYYY')#">
        <cfargument name="data_termino" required="no" default="#DateFormat(now(), 'DD/MM/YYYY')#">
        <cfargument name="dacte_impresso" required="no" default="">
        <cfargument name="num_cte" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="serie" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select cte.conhecimento_id      
                 , cte.num_conhecimento
                 , cte.serie
                 , to_char(cte.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , cte.num_romaneio
                 , cte.rem_razao_social
                 , kss.pkg_string.fnc_formata_cnpj_cpf(cte.rem_cnpj_cpf) as rem_cnpj_cpf
                 , cte.dest_razao_social
                 , kss.pkg_string.fnc_formata_cnpj_cpf(cte.dest_cnpj_cpf) as dest_cnpj_cpf
                 , dc.documento_id
                 , ds.cod_status
                 , ds.descricao_status
                 , nvl(ds.situacao_id, 0) as situacao_id
                 , ds.emitido
                 , ds.permite_editar
                 , ds.permite_cancelar
                 , cte.user_insert
                 , nvl(cte.status_email_remetente,0) as status_email_remetente
                 , nvl(cte.status_email_destinatario,0) as status_email_destinatario
                 , nvl(cte.status_email_recebedor,0) as status_email_recebedor
                 , nvl(cte.status_email_expedidor,0) as status_email_expedidor
                 , nvl(cte.status_email_tomador,0) as status_email_tomador
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_remetente) as email_remetente
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_destinatario) as email_destinatario
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.entrega_cod_pessoa) as email_recebedor
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.coleta_cod_pessoa) as email_expedidor
                 , fiscal.pkg_cte_email.fnc_email_cte(cte.cod_consignatario) as email_tomador
                 , (select p.cliente
                      from kss.v$pessoa p
                      where p.cod_pessoa = cte.cod_pessoa_filial) as filial
                 , cte.coleta_municipio || ' - ' || cte.coleta_uf as coleta
                 , cte.entrega_municipio || ' - ' || cte.entrega_uf as entrega
                 , (select te.descricao
                      from sefaz.v$tipo_emissao te
                     where te.cod_docto = 'CTE'
                       and te.tipo_emissao_id =  ds.tipo_emissao_id) as tipo_emissao
                 , ds.tipo_emissao_id
                 , d.ambiente_id
                 , cte.liberado_impressao
				 , oper.pkg_veiculo.fnc_get_cod_veiculo(cte.placa_tracao) as cod_veiculo_tracao
                 , cte.modalidade
                 , cte.nome_motorista
              from fiscal.v$conhecimento cte
        inner join fiscal.v$documento_cte dc
                on dc.conhecimento_id = cte.conhecimento_id
        inner join fiscal.v$documento_status ds
                on ds.documento_id = dc.documento_id
        inner join sefaz.documento d
                on d.documento_id = ds.documento_id
             where 1 = 1
             <cfif (Len(Trim(arguments.situacao_id)) and (arguments.situacao_id neq '0,1,2,3,4,5'))>
             	and nvl(ds.situacao_id, 0) in(#arguments.situacao_id#)
             </cfif>
             <cfif Len(Trim(arguments.cod_pessoa_filial))>
             	and cte.cod_pessoa_filial = #arguments.cod_pessoa_filial#
             </cfif>
             <cfif Len(Trim(arguments.serie)) and Len(Trim(arguments.serie))>
                and cte.serie in (#ListQualify(arguments.serie,"'",",")#)
             </cfif>
             <cfif isDefined("arguments.conhecimento_tipo_id") and Len(Trim(arguments.conhecimento_tipo_id)) >
               and cte.conhecimento_tipo_id = #arguments.conhecimento_tipo_id#
           </cfif>
			 <cfif Len(Trim(arguments.num_cte))>
             	and cte.num_conhecimento = #arguments.num_cte#             					
             <cfelse>
				 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                    and trunc(cte.data_emissao) between trunc(to_date('#arguments.data_inicio#', 'dd/mm/yyyy hh24:mi:ss')) and trunc(to_date('#arguments.data_termino#', 'dd/mm/yyyy hh24:mi:ss'))
                 </cfif>
                 <cfif arguments.dacte_impresso eq 0>
                    and cte.impressao_dacte is null
                 <cfelseif arguments.dacte_impresso eq 1>
                    and cte.impressao_dacte is not null
                 </cfif>
           	 </cfif>
           order by lpad(cte.serie,3,'0') asc , cte.num_conhecimento desc
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os CTE's para complementar
	-- Rafael 01/10/2010 16:18 - CRIADO
	--->
	<cffunction name="get_cte_complementar" displayname="Busca os CTE's para complementar" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no">
		<cfargument name="cod_departamento" required="no">
		<cfargument name="cod_setor" required="no">
		<cfargument name="cod_centro_custo" required="no">
        <cfargument name="serie" required="yes">
		<cfargument name="pagador" required="yes">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" required="no">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="coleta_municipio_id" required="no">
        <cfargument name="entrega_municipio_id" required="no">
		<cfquery datasource="#session.dsn#" name="qr_conhecimentos" username="#session.usuario#" password="#session.senha#">
            select /*+ ORDERED USE_HASH(C IT) USE_HASH(IT LF)*/
                   c.num_romaneio
                 , c.conhecimento_id
                 , c.num_conhecimento
                 , case
                      when nvl(l.regra_fiscal_id, 1) = 1 then
                       c.total_conhecimento
                      when l.regra_fiscal_id in (2) then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 3 and c.pagador = 0 then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 3 and c.pagador = 1 then
                       c.total_conhecimento
                      when l.regra_fiscal_id = 7 and c.pagador = 0 then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 7 and c.pagador = 1 and
                           c.coleta_cod_uf = c.entrega_cod_uf then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 7 and c.pagador = 1 and
                           c.coleta_cod_uf <> c.entrega_cod_uf then
                       c.total_conhecimento
                      when l.regra_fiscal_id in (4, 13) and c.pagador = 0 then
                       c.total_conhecimento - ((c.valor_icms_substit + c.valor_icms) * 0.80)
                   -- Gerdal desconta 80% do ICMS
                      when l.regra_fiscal_id in (4, 13) and c.pagador = 1 then
                       c.total_conhecimento -- Gerdal se pagador destinatario no desconta ICMS
                      when l.regra_fiscal_id = 6 then
                       c.total_conhecimento + c.pedagio -- Coamo
                      when l.regra_fiscal_id = 8 and c.pagador = 0 then
                       c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                      when l.regra_fiscal_id = 8 and c.pagador = 1 then
                       c.total_conhecimento
                      else
                       c.total_conhecimento
                   end total_conhecimento
                 , oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso
                 , c.m3
                 , oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
                 , c.frete_unitario
                 , (select m.municipio || '/' || m.uf_id
                      from oper.v$municipio m
                     where m.municipio_id = c.coleta_municipio_id) as carregamento
                 , (select m.municipio || '/' || m.uf_id
                      from oper.v$municipio m
                     where m.municipio_id = c.entrega_municipio_id) as destino
                 , (select distinct count(rit2.cod_destinatario)
                      from oper.v$romaneio_item rit2
                     where rit2.num_romaneio = c.num_romaneio) as total_entregas                 
              from fiscal.v$cte c
              left join oper.v$romaneio r
                     on c.num_romaneio = r.num_romaneio
              left join oper.v$romaneio_item it
                     on c.num_romaneio = it.num_romaneio
                    and c.item_id = it.item_id
              left join oper.v$lote l
                     on it.num_lote = l.num_lote             
			 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			   and c.cod_departamento  = #arguments.cod_departamento#
			   and c.cod_setor         = #arguments.cod_setor#
			   and c.cod_centro_custo  = #arguments.cod_centro_custo#
			   and c.situacao_id <> 1
               and not exists (select 1 
                                 from oper.v$conhecimento_complemento cc
                                where c.conhecimento_id = cc.conhecimento_complemento_id
                                   or c.conhecimento_id = cc.conhecimento_id)
			<cfif isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio))>
            	and c.num_romaneio = '#arguments.num_romaneio#'
            <cfelse>
				<cfif isDefined("arguments.serie") and Len(Trim(arguments.serie))>
                   and c.serie = '#arguments.serie#'
                </cfif>
                <cfif isDefined("arguments.coleta_municipio_id") and Len(Trim(arguments.coleta_municipio_id))>
                   and c.coleta_municipio_id = #arguments.coleta_municipio_id#
                </cfif>
                <cfif isDefined("arguments.entrega_municipio_id") and Len(Trim(arguments.entrega_municipio_id))>
                   and c.entrega_municipio_id = #arguments.entrega_municipio_id#
                </cfif>
                   and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.pagador#
                <cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
                   and data_emissao between to_date('#arguments.data_inicial# 00:00:00','dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_final# 23:59:59','dd/mm/yyyy hh24:mi:ss')
                </cfif>
            </cfif>
			 order by c.num_conhecimento
		</cfquery>
		<cfreturn qr_conhecimentos>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados do CTE para Complementar
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_cte_complemento" access="remote" returntype="query" output="false">
		<cfargument name="conhecimento_id" required="yes" default="">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
               select c.num_conhecimento
                    , c.serie
                    , c.num_romaneio
                    , it.num_lote
                    , it.item_id
                    , to_char(c.data_emissao,'dd/mm/yyyy') as data_emissao
                    , oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
                    , c.rem_razao_social as remetente
                    , c.dest_razao_social as destinatario
                    , c.m3
                    , oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso
                    , oper.pkg_operacional.fnc_converte_peso(c.peso_cobrado, 'Kg', c.cod_unidade) as peso_cobrado
                    , c.volume
                    , c.frete_unitario
                    , 0 as valor_mercadoria
                    , c.frete_valor
                    , c.despacho
                    , c.ademe
                    , c.desconto
                    , c.coleta_entrega
                    , c.impostos
                    , case
                          when nvl(l.regra_fiscal_id, 1) = 1 then
                           c.total_conhecimento
                          when l.regra_fiscal_id in (2) then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 3 and c.pagador = 0 then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 3 and c.pagador = 1 then
                           c.total_conhecimento
                          when l.regra_fiscal_id = 7 and c.pagador = 0 then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 7 and c.pagador = 1 and
                               c.coleta_cod_uf = c.entrega_cod_uf then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 7 and c.pagador = 1 and
                               c.coleta_cod_uf <> c.entrega_cod_uf then
                           c.total_conhecimento
                          when l.regra_fiscal_id in (4, 13) and c.pagador = 0 then
                           c.total_conhecimento - ((c.valor_icms_substit + c.valor_icms) * 0.80)
                       -- Gerdal desconta 80% do ICMS
                          when l.regra_fiscal_id in (4, 13) and c.pagador = 1 then
                           c.total_conhecimento -- Gerdal se pagador destinatario no desconta ICMS
                          when l.regra_fiscal_id = 6 then
                           c.total_conhecimento + c.pedagio -- Coamo
                          when l.regra_fiscal_id = 8 and c.pagador = 0 then
                           c.total_conhecimento - (c.valor_icms_substit + c.valor_icms)
                          when l.regra_fiscal_id = 8 and c.pagador = 1 then
                           c.total_conhecimento
                          else
                           c.total_conhecimento
                       end total_conhecimento
                    , c.base_calculo_icms
                    , c.aliquota_icms
                    , c.valor_icms
                    , nvl(l.frete_em, 'PESO') as frete_em
                    , (select uf.sigla_uf
                         from cep.cep_ufs uf
                        where uf.cod_uf = c.entrega_cod_uf) as entrega_uf
                    , (select uf.sigla_uf
                         from cep.cep_ufs uf
                        where uf.cod_uf = c.coleta_cod_uf) as coleta_uf
                    , c.pagador
                    , c.cod_unidade
                    , c.num_produto
                    , c.num_natureza
                    , c.cod_remetente
                    , c.cod_destinatario
                    , c.st_icms_id
                 from fiscal.v$cte c
                inner join oper.v$romaneio r
                   on c.num_romaneio = r.num_romaneio
                inner join oper.v$romaneio_item it
                   on c.num_romaneio = it.num_romaneio
                  and c.item_id = it.item_id
                 left join oper.v$lote l
                   on it.num_lote = l.num_lote
                  and c.item_id = it.item_id
                where c.conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os pagadores com conhecimento em aberto para determinada agencia
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_pagador_cte" displayname="Busca os pagadores com conhecimento em aberto para determinada agencia" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
	    <cfargument name="cod_departamento" required="no">
	    <cfargument name="cod_setor" required="no">
		<cfargument name="cod_centro_custo" required="no"/>
		<cfargument name="serie" required="yes"/>
		<cfargument name="data_inicial" required="no"/>
		<cfargument name="data_final" required="no"/>
		<cfargument name="complemento" required="no"/>
		<cfargument name="ORGANOGRAMA" required="no" default=""/>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.ORGANOGRAMA,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.ORGANOGRAMA,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.ORGANOGRAMA,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.ORGANOGRAMA,4,'_')>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
        select x.pagador
             , p.razao_social
             , p.cnpj_cpf as codigo
             , oper.pkg_global.fnc_mascara_cnpj_cpf(p.cod_pessoa) as cnpj_cpf
             , pep.municipio
             , pep.uf
          from (select distinct decode(c.pagador, 0, c.cod_remetente, c.cod_destinatario) as pagador
                  from fiscal.v$cte c
                 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                   and c.cod_departamento  = #arguments.cod_departamento#
                   and c.cod_setor         = #arguments.cod_setor#
                   and c.cod_centro_custo  = #arguments.cod_centro_custo#
                   and c.situacao_id <> 1
			   <cfif arguments.serie neq 0>
				   and c.serie = '#arguments.serie#'
			   </cfif>
			   <cfif not isDefined("arguments.complemento")>
				   and not exists (select 'x' 
									 from oper.v$cte_emitido_receber cr
									where c.conhecimento_id = cr.conhecimento_id)
			   </cfif>
			   <cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
			  	  and data_emissao between to_date('#arguments.data_inicial# 00:00:00','dd/mm/yyyy hh24:mi:ss')and to_date('#arguments.data_final# 23:59:59','dd/mm/yyyy hh24:mi:ss')
			   </cfif>
               ) x 
      inner join kss.v$pessoa p
              on p.cod_pessoa = x.pagador
      inner join kss.v$pessoa_endereco_padrao pep
              on pep.cod_pessoa = p.cod_pessoa
        order by p.razao_social
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os locais de coleta e entrega
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_coleta_entrega" displayname="Busca os locais de coleta e entrega" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" />
		<cfargument name="cod_setor" 		 required="no" />
		<cfargument name="serie" 			 required="yes" />
		<cfargument name="clientes" 		 required="yes" />
		<cfargument name="coleta_entrega"    displayname="FLAG - 0 Coleta 1 Entrega" required="no" default="0">
		<cfargument name="data_inicial" 	 required="no" default="" />
		<cfargument name="data_final" 		 required="no" default=""/>
		<cfargument name="organograma" required="no" default="">		
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>		
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select distinct m.uf_id, m.municipio, m.municipio_id as municipio_id
			  from fiscal.v$cte c
			  <cfif arguments.coleta_entrega eq 0>
		     inner join oper.v$municipio m
                     on m.municipio_id = c.coleta_municipio_id
			  <cfelse>
			 inner join oper.v$municipio m
                     on m.municipio_id = c.entrega_municipio_id
			  </cfif>
				 where c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                   and c.cod_departamento  = #arguments.cod_departamento#
                   and c.cod_setor         = #arguments.cod_setor#
                   and c.cod_centro_custo  = #arguments.cod_centro_custo#
                   and c.situacao_id <> 1
			  <cfif isDefined("arguments.num_romaneio") and Len(Trim(arguments.num_romaneio))>
                   and c.num_romaneio = '#arguments.num_romaneio#'
              <cfelse>
				  <cfif arguments.serie neq 0>
                       and c.serie = '#arguments.serie#'
                  </cfif>
                  <cfif Len(Trim(arguments.DATA_INICIAL)) and Len(Trim(arguments.DATA_FINAL))>
                       and data_emissao between to_date('#arguments.data_inicial# 00:00:00','dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_final# 23:59:59','dd/mm/yyyy hh24:mi:ss')
                  </cfif>
                  <cfif Len(Trim(arguments.clientes))>
                       and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.clientes#
                  </cfif>                       
              </cfif>				
                and not exists (select 1 
                                  from oper.v$conhecimento_complemento cc
                                 where c.conhecimento_id = cc.conhecimento_complemento_id
                                    or c.conhecimento_id = cc.conhecimento_id)			    
			  order by m.uf_id, m.municipio
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca relaes de complemento em aberto
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_relacao_aberto" displayname="Busca relaes de complemento em aberto" access="remote" returntype="query" output="true">
        <cfargument name="relacao_id" required="no" default="" />
        <cfargument name="pagador" required="no" default="" />
        <cfargument name="todas" displayname="FLAG que indica a consulta por todas as relaes" required="no" />
		<cfquery datasource="#session.dsn#" name="qr_relacao_complemento" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS */
                   cc.relacao_id
                 , cc.conhecimento_id
                 , c.num_romaneio as num_romaneio
                 , decode(c.pagador, 0, c.cod_remetente, c.cod_destinatario) as pagador
                 , decode(c.pagador, 0, c.rem_razao_social, c.dest_razao_social) as razao_social
                 , decode(c.pagador, 0, oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente)
                 , oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario)) as cnpj_cpf
                 , c.num_conhecimento
                 , oper.pkg_operacional.fnc_converte_peso(c.peso, 'Kg', c.cod_unidade) as peso_lancado
                 , oper.pkg_operacional.fnc_converte_peso(c.peso + cc.peso,'Kg',c.cod_unidade) as peso_correto
                 , c.m3 as m3_lancado
                 , c.m3 + cc.m3 as m3_correto
                 , cc.volume
                 , cc.m3
                 , c.frete_unitario as unit_lancado
                 , cc.valor_unitario as unit_correto
                 , c.frete_valor as frete_lancado
                 , cc.valor_frete_liquido + c.frete_valor as frete_correto
                 , cc.valor_frete_liquido as diferenca
                 , cc.cod_unidade
                 , oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
                 , c.cod_pessoa_filial
                 , c.cod_setor
                 , decode(cc.situacao, 1, 'Fechada', 'Aberta') as situacao
              from fiscal.v$conhecimento_complemento cc
             inner join fiscal.v$cte_emitido c
                on cc.conhecimento_id = c.conhecimento_id             
             <cfif not isDefined("arguments.todas")>
                 inner join oper.v$kss_usuario_lotacao ul
                    on c.cod_pessoa_filial = ul.cod_pessoa
                   and ul.cod_aplicacao = 'EMISSAO_DOCUMENTO'
             </cfif>
             where 1=1
             <cfif not isDefined("arguments.todas")>
              and cc.situacao = 0
             </cfif> 
             <cfif Len(Trim(arguments.RELACAO_ID))>
               and cc.relacao_id = #arguments.RELACAO_ID#
             </cfif> 
             <cfif Len(Trim(arguments.pagador))>
               and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.pagador#
             </cfif>
            order by razao_social, cc.relacao_id , c.num_conhecimento         
		</cfquery> 
		<cfreturn qr_relacao_complemento>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados das relaes de complemento em aberto
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_relacao_dados" displayname="Busca os dados das relaes de complemento em aberto" access="remote" returntype="query" output="true">
		<cfargument name="relacao_id" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_relacao_complemento" username="#session.usuario#" password="#session.senha#">
            select c.rem_razao_social
                 , c.rem_uf
                 , c.rem_municipio
                 , c.dest_razao_social
                 , c.dest_municipio
                 , c.dest_uf
                 , c.cod_destinatario
                 , c.entrega_cod_uf
                 , c.entrega_cod_municipio
                 , c.entrega_cod_distrito
                 , c.entrega_cod_dv
                 , oper.fnc_monta_observacao_ctrc(c.num_romaneio) as observacao
              from fiscal.v$cte c
             where c.conhecimento_id = (select max(cc.conhecimento_id)
                                          from fiscal.v$conhecimento_complemento cc
                                         where cc.relacao_id = #arguments.RELACAO_ID#)
		</cfquery> 
		<cfreturn qr_relacao_complemento>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados das relaes de complemento em aberto
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 26/07/2010
	--->
	<cffunction name="get_nfe" displayname="Busca as NFE's Integradas" access="remote" returntype="query">
        <cfargument name="tipo_nfe" required="no" default="0" hint="0 - Todas / 1 - Transporte / 2 - Terceiro"/>
        <cfargument name="cpf_cnpj_destinatario" required="no" default=""/>
        <cfargument name="cpf_cnpj_emitente" required="no" default=""/>
        <cfargument name="documento_id" required="no" default=""/>
        <cfargument name="status_id" required="no" default="1"/>
		<cfquery datasource="#session.dsn#" name="qr_relacao_complemento" username="#session.usuario#" password="#session.senha#">
            select ed.documento_id
                 , ed.email_id
                 , ed.tipo_documento_id as tipo_documento
                 , ed.chave
                 , substr(ed.chave, 4) as chave_numerica
                 , ed.numero_documento
                 , ed.serie_documento
                 , ed.modelo_documento
                 , to_char(ed.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , ed.valor
                 , kss.pkg_string.fnc_formata_cnpj_cpf(ed.cpf_cnpj_emitente) as cpf_cnpj_emitente
                 , ed.razao_social_emitente
                 , kss.pkg_string.fnc_formata_cnpj_cpf(ed.cpf_cnpj_destinatario) as cpf_cnpj_destinatario
                 , ed.razao_social_destinatario
                 , ed.status_id
                 , kss.fnc_ref_code('SEFAZ', 'EMAIL_DOCUMENTO.STATUS_ID', ed.status_id) as status     
              from sefaz.v$email_documento ed
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_nfe))>
              <cfif arguments.tipo_nfe eq 1>
              and ed.cpf_cnpj_destinatario not in (select p.cnpj_cpf
                                                     from kss.v$unidade_negocio u
                                                    inner join kss.v$pessoa p
                                                       on p.cod_pessoa = u.cod_pessoa)
              <cfelseif arguments.tipo_nfe eq 2>
              and ed.cpf_cnpj_destinatario in (select p.cnpj_cpf
                                                 from kss.v$unidade_negocio u
                                                inner join kss.v$pessoa p
                                                   on p.cod_pessoa = u.cod_pessoa)
              </cfif>              
            </cfif>
            <cfif Len(Trim(arguments.cpf_cnpj_destinatario))>
              and ed.cpf_cnpj_destinatario = #arguments.cpf_cnpj_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.cpf_cnpj_emitente))>
              and ed.cpf_cnpj_emitente = #arguments.cpf_cnpj_emitente#
            </cfif>
            <cfif Len(Trim(arguments.documento_id))>
              and ed.documento_id in(#arguments.documento_id#)
            </cfif>
            <cfif Len(Trim(arguments.status_id))>
              and ed.status_id = #arguments.status_id#
            </cfif>            
            order by ed.data_emissao desc
		</cfquery> 
		<cfreturn qr_relacao_complemento>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados resumidos do CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 01/12/2010
	--->
	<cffunction name="get_cte_resumo" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select dc.documento_id
            	 , c.conhecimento_id
                 , c.num_conhecimento
                 , c.serie
                 , (select d.chave
                      from fiscal.v$dacte d
                     where d.documento_id = dc.documento_id) as chave_cte
                 , ds.cod_status
                 , ds.situacao_id
                 , ds.descricao_status
                 , ds.permite_editar
                 , ds.permite_inutilizar
                 , ds.emitido
				 , d.tipo_emissao_id
                 , c.liberado_impressao
              from fiscal.v$conhecimento c
             inner join fiscal.v$documento_cte dc
                on dc.conhecimento_id = c.conhecimento_id
             inner join sefaz.documento d
                on d.documento_id = dc.documento_id
             inner join fiscal.v$documento_status ds
               on ds.documento_id = dc.documento_id
             where c.conhecimento_id = #arguments.conhecimento_id#
		</cfquery> 
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca o Ambiente de Emisso de CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 01/12/2010
	--->
	<cffunction name="get_cte_ambiente" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select fiscal.pkg_sefaz_cte.fnc_ambiente(#arguments.cod_pessoa_filial#) as ambiente
  			  from dual
		</cfquery> 
		<cfreturn qr_result>
	</cffunction>
   	
    <!--- 
	-- PROPSITO 
	-- Busca se est Autorizado a emitir CTE
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 14/05/2011
	--->
	<cffunction name="get_emite_cte" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select fiscal.pkg_sefaz_cte.fnc_emite_docto_fiscal(#arguments.cod_pessoa_filial#) as emite_cte
  			  from dual
		</cfquery> 
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca documentos do pagador
	-- RAFAEL 01/12/2010
	--->
	
	<cffunction name="get_documentos_acerto_financeiro" access="remote" returntype="query" output="true">
		<cfargument name="cod_remetente" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfquery datasource="#session.dsn#" name="qr_documentos_pagador" username="#session.usuario#" password="#session.senha#">
			   select cf.cod_documento
                   , dc.documento
                   , cf.num_romaneio
                   , to_char(cf.data_emissao, 'dd/mm/yyyy') as data_emissao
                   , cf.volume
                   , oper.pkg_operacional.fnc_converte_peso(cf.peso, 'Kg', cf.cod_unidade) peso
                   , cf.valor_unitario
                   , cf.valor_frete_liquido
                   , cf.valor_frete_bruto
                   , cf.lancto_id
                   , d.cod_pessoa destinatario
                   , d.nome_fantasia nome_destinatario
                   , oper.pkg_global.fnc_mascara_cnpj_cpf(d.codigo) cnpj_cpf_destinatario
                   , ri.cod_remetente
                   , d.municipio
                from oper.v$carta_frete cf
               inner join oper.v$remetente_destinatario d
                  on d.cod_pessoa = cf.cod_destinatario
               inner join oper.v$documento_frete dc
                  on dc.documento_id = cf.tipo_docto
               inner join oper.v$romaneio_item ri
                  on ri.num_romaneio = cf.num_romaneio
                 and ri.item_id = cf.item_id
               inner join oper.v$romaneio r
                  on r.num_romaneio = cf.num_romaneio
                 and r.situacao_id = 2
            <cfif Len(Trim(arguments.cod_remetente))>
                 and ri.cod_remetente = #arguments.cod_remetente#
            </cfif>
               where cf.conhecimento_id is null
                 and cf.crt_receber_id is null                 
            <cfif len(trim(arguments.num_romaneio))>     
                 and cf.num_romaneio = #arguments.num_romaneio#
            </cfif>
            <cfif len(trim(arguments.data_inicial))>
                 and trunc(r.data_inicio) >= trunc(to_date('#arguments.data_inicial#', 'dd/mm/yyyy hh24:mi:ss'))
            </cfif>
            <cfif len(trim(arguments.data_final))>
                 and trunc(r.data_termino) <= trunc(to_date('#arguments.data_final#', 'dd/mm/yyyy hh24:mi:ss'))
            </cfif>
            order by cf.data_emissao
 		</cfquery>
		<cfreturn qr_documentos_pagador>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca a Mensagem de Alerta do CTE
	-- RAFAEL 01/12/2010
	--->	
	<cffunction name="get_mensagem_cte" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes">
        <cfquery datasource="#session.dsn#" name="qr_mensagem" username="#session.usuario#" password="#session.senha#">
			   select fiscal.pkg_sefaz_cte.fnc_consulta_contingencia('',#arguments.cod_pessoa_filial#) as mensagem
                 from dual            
 		</cfquery>
		<cfreturn qr_mensagem>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as filiais
	-- RAFAEL 14/03/2011
	--->		
	<cffunction name="get_filial" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="todos" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select un.cod_pessoa
                 , un.unidade_negocio nome
                 , fiscal.pkg_sefaz_cte.fnc_consulta_contingencia('',un.cod_pessoa) as mensagem_contingencia
              from kss.v$unidade_negocio un
             inner join kss.v$pessoa p
                on p.cod_pessoa = un.cod_pessoa
             inner join sefaz.v$emitente_ambiente ea
                on ea.cnpj_cpf = p.cnpj_cpf              
             where 1 = 1
             <cfif arguments.todos eq 0>
             	and ea.emite_docto_fiscal = 1
             </cfif>
             <cfif len(trim(arguments.operacao_id))>
			 		and un.cod_pessoa in (select o.cod_pessoa
                    						from logistica.v$operacao_filial_emissao ofe
                                           inner join kss.v$organograma o
                                           		   on o.cod_organograma = ofe.cod_organograma                                                   
                                           where ofe.operacao_id = #arguments.operacao_id#)
             </cfif>
             order by un.unidade_negocio
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>
