<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca bombas de combustivel da filial
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/01/2006
	--->
	<cffunction name="get_bombas" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select bomba_id, cod_pessoa, num_bomba, contador, situacao
			  from oper.v$bomba_combustivel
			 where cod_pessoa = #arguments.cod_pessoa#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Data limite para o lanamento das requisies antes do proximo inventrio
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/01/2006
	--->
	<cffunction name="get_data_limite_conferencia" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select max(ei.data_inventario + oper.pkg_global.fnc_get_parametro(6,'ABASTECIMENTO')) as data_limite
			  from oper.v$estoque_inventario ei, oper.v$estoque e
			 where ei.estoque_id = e.estoque_id
			   and e.cod_pessoa_filial = #arguments.cod_pessoa#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Retorna Estoque ID do diesel da filial
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/01/2006
	--->
	<cffunction name="get_estoque_id_diesel" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select e.estoque_id
  				  from oper.v$estoque e
  			inner join oper.v$produto_abastecimento pa
  					on pa.produto_id=e.produto_id
 				 where cod_pessoa_filial = #arguments.cod_pessoa#
   				   and pa.produto_oper_id in (2,4)
                   and e.ativo = 1
			</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	

	<!--- 
	-- PROPSITO 
	-- Busca ultimos lanamentos feitos na filial
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/01/2006
	--->
	<cffunction name="get_lancamentos" access="remote" returntype="query" output="true" displayname="Busca os lanamentos feitos na filial que o usurio est lotado.">
		<cfargument name="cod_pessoa" required="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select *
				  from (
				select /*+LEADING(PE) INDEX(PE INDX_ABST_11) USE_HASH(PE B) USE_HASH(PE E)*/
					   pe.*,
					   'Bomba ' || to_char(b.num_bomba, '000') as num_bomba,
					   b.contador
				  from (select p.controle_id,
									p.num_requisicao,
									p.num_saida,
									p.estoque_id,
									p.placa,
									p.km,
									to_char(p.data_hora, 'dd/mm/yyyy') as data,
									to_char(p.data_hora, 'hh24:mi') as hora,
									p.data_hora,
									p.quantidade,
									p.conferido,
									p.valor_unitario,
									upper(p.user_update) as usuario,
									p.bomba_id,
									p.date_update
							 from oper.v$abastecimento p
						 where p.tipo_entrada = 2
						   and p.data_confirmacao is not null) pe
						 inner join oper.v$bomba_combustivel b
								 on b.bomba_id = pe.bomba_id
						 inner join oper.v$estoque e
								 on e.estoque_id = pe.estoque_id
								and e.cod_pessoa_filial = #session.cod_pessoa#
						 inner join oper.v$produto_abastecimento pa
                    			 on pa.produto_id = e.produto_id
								 and pa.produto_oper_id in (2,4)
						order by pe.date_update desc)
				where rownum < 6
	</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca dados da requisio
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/01/2006
	--->
	<cffunction name="get_lancamento" access="remote" returntype="query" output="true" displayname="Busca os lanamentos feitos na filial que o usurio est lotado.">
		<cfargument name="num_requisicao" required="no" default=""/>
		<cfargument name="placa" required="no" default=""/>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			 select pe.controle_id, pe.num_requisicao, pe.num_saida, pe.estoque_id, pe.placa, pe.km, 
				 to_char(pe.data_hora,'dd/mm/yyyy') as data, to_char(pe.data_hora,'hh24:mi') as hora, 
				   pe.data_hora, pe.quantidade, 
				   pe.conferido, 'Bomba ' || to_char(b.num_bomba,'000') as num_bomba, pe.valor_unitario,
				   upper(pe.user_update) as usuario  
			  from oper.v$abastecimento pe
		     inner join oper.v$bomba_combustivel b
				     on pe.bomba_id = b.bomba_id
			  where 1=1
			  <cfif Len(Trim(arguments.placa))>
			  	and pe.placa = upper('#arguments.placa#')
			  </cfif>
			  <cfif Len(Trim(arguments.num_requisicao))>
			    and pe.num_requisicao = #arguments.num_requisicao#
			  </cfif>
			</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca movimentao no perodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/01/2006
	--->
	<cffunction name="get_saldo_estoque" access="remote" returntype="numeric" output="true" displayname="Busca saldo por perodo.">
		<cfargument name="data_inicio" required="no">
		<cfargument name="estoque_id"   required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			<cfif isDefined("arguments.data_inicio")>
				select oper.pkg_almoxarifado.fnc_calcula_saldo_estoque(#arguments.ESTOQUE_ID#, to_date('#arguments.data_inicio#','dd/mm/yyyy hh24:mi')-1/1440) as saldo 
 				  from dual
			<cfelse>
				select oper.pkg_almoxarifado.fnc_calcula_saldo_estoque(#arguments.ESTOQUE_ID#, sysdate) as saldo 
 				  from dual
			</cfif>	
   		</cfquery>
		<cfreturn qr_result.saldo>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca movimentao no perodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/01/2006
	--->
	<cffunction name="get_movimentacao_combustivel" displayname="Busca a movimentao da filial" access="remote" returntype="query" output="true">
		<cfargument name="estoque_id"  required="true">
		<cfargument name="data_inicio" required="true">
		<cfargument name="data_fim"    required="true">		
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select num_documento, placa_veiculo, historico, nvl(quantidade,0) as quantidade, to_char(data,'dd/mm/yyyy HH24:mi') as data, 
				   tipo,usuario, num_bomba 
			from  (SELECT 0 as lancto_id, 0 as num_documento, '----' as placa_veiculo, 
						  'Inventrio de '||e.data_inventario as historico, e.qtde_estoque as quantidade, 
						  e.data_inventario as data, 'Inventrio' as tipo, e.user_insert as usuario, 0 as num_bomba 
					 from oper.v$estoque_inventario e 
					where e.estoque_id = #arguments.estoque_id#
					  and e.data_inventario between to_date('#Arguments.data_inicio#','dd/mm/yyyy HH24:mi') and to_date('#Arguments.data_fim#','dd/mm/yyyy HH24:mi')+1-1/86400
					  
					union 
					
				   SELECT nfr.num_nota_fiscal as lancto_id, nfr.num_nota_fiscal as num_documento,                                       
           		    '----' as placa_veiculo, nfr.emit_razao_social as historico, nf_it.QTDE_VOLUME as quantidade,                                       
						      nfr.data_entrada as data, 'Entrada' as tipo, nfr.user_insert as usuario, 0 as num_bomba
 					   from oper.v$nf_terceiro nfr 
					  inner join oper.v$nf_terceiro_it nfr_it
					     on nfr.num_nota_id = nfr_it.num_nota_id
					    and trunc(nfr.data_entrada) between to_date('#Arguments.data_inicio#','dd/mm/yyyy') and to_date('#Arguments.data_fim#','dd/mm/yyyy')
            inner join oper.v$nf_item nf_it
                   on nf_it.num_nota_it_id = nfr_it.num_nota_it_id
				   and exists (select 'x'
				      			 from oper.v$produto_abastecimento pa
								where pa.produto_id = nf_it.produto_id
  								  and pa.produto_oper_id in (2,4))
  					inner join oper.v$pessoa_juridica_filial pjf
	  				   on pjf.cod_pessoa = nfr.cod_pessoa_filial
			  		inner join oper.v$estoque e
                    on e.cod_pessoa_filial = pjf.cod_pessoa
                   and e.estoque_id = #arguments.estoque_id#
  					inner join oper.v$estoque_inventario ei 
  	  				      on ei.estoque_id = e.estoque_id
			  		inner join oper.pessoa_juridica pj
				  	   on pj.cod_pessoa = nfr.COD_EMITENTE
  					  and pj.modalidade_id = 14
	  				  and nfr.data_entrada >= ei.data_inventario
												   
					union                                     
					
				  select pe.controle_id,  pe.num_requisicao as num_documento,                                        
                 pe.placa, 'KM - ' || pe.km as historico,                                       
                 round(es_it.quantidade,3) as quantidade, es.data_saida as data,                                         
                 'Sada' as tipo, pe.user_update as usuario, b.num_bomba
            from oper.v$estoque_saida es
           inner join oper.v$estoque_saida_it es_it
                   on es_it.num_saida = es.num_saida
           inner join oper.v$abastecimento pe
                   on pe.num_saida = es.num_saida
			      and pe.data_hora between to_date('#Arguments.data_inicio#','dd/mm/yyyy HH24:mi') and to_date('#Arguments.data_fim#','dd/mm/yyyy HH24:mi')+1-1/86400
           inner join oper.v$estoque e
                   on e.estoque_id = es_it.estoque_id
                  and e.estoque_id = #arguments.estoque_id#
           inner join oper.v$bomba_combustivel b
                   on b.bomba_id = pe.bomba_id         

			ORDER BY data, num_documento,tipo) 
			</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	
	<!--- 
	-- PROPSITO 
	-- Estoque e Produto
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/01/2006
	--->
	
	<cffunction name="get_estoque_produto" access="remote" returntype="query" output="true" >
		<cfargument name="cod_pessoa" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select e.estoque_id, e.produto_id
				  from oper.v$estoque e
			inner join oper.v$produto_abastecimento pa
				    on pa.produto_id = e.produto_id
				   and pa.produto_oper_id in (2,4,244)
				 where cod_pessoa_filial = #arguments.cod_pessoa#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os produtos
	-- NOTAS EXPLICATIVAS
	-- GUTO 25/06/2006
	--->
	
	<cffunction name="get_produto" access="remote" returntype="query" output="true" >
		<cfargument name="descricao" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			SELECT 
				p.produto_id,
				p.descricao
			FROM OPER.V$produto p
			where 1=1
			<cfif Len(Trim(arguments.descricao))>
				and upper(p.descricao) like upper('%arguments.descricao%')
			</cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
		
	<!--- 
	-- PROPSITO 
	-- Busca os Negociadores
	-- LOUIS  16/04/2006
	--->		
	<cffunction name="get_negociador" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select cod_gestao,
			   negociador_id,
			   negociador,
			   telefone,
			   email,
		 from negociador
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os numero do CTF da filial onde o usurio est lotado
	-- LOUIS  16/04/2006
	--->		
	<cffunction name="get_num_ctf_filial_usuario" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct p.cnpj_cpf, p.cod_pessoa, kss.pkg_pessoa.fnc_get_atributo(p.cod_pessoa,15) as num_ctf
              from oper.v$kss_usuario_lotacao ul
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = ul.cod_pessoa
 		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	


	<!--- 
	-- PROPSITO 
	-- Busca abastecimentos lanados manualmente na filial
	-- LOUIS  16/04/2006
	--->		
	<cffunction name="get_abastecimento_ctf_filial" access="remote" returntype="query" output="true">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="DATA" required="no" default=""/>
    	<cfargument name="CTF_ID" required="no" default=""/>
    	<cfargument name="ABERTO" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ws.ctf_id, ws.cod_posto, ws.ctf_cd_abastecimento, 
                   ws.ctf_cod_posto, ws.ctf_dc_placa, ws.ctf_nr_km_atual, ws.ctf_cd_status_abastecimento,
                   ws.ctf_nr_qtd_litros, to_char(ws.ctf_dt_evento,'dd/mm/yyyy hh24:mi') as ctf_dt_evento, ws.ctf_nr_cnpj,
                   ws.cancelado, to_char(ws.data_conferencia,'dd/mm/yyyy hh24:mi') as data_conferencia,
                   ws.mensagem
              from oper.v$ctf_webservice ws
             where ws.ctf_cd_combustivel = 'E'
               <cfif Len(Trim(arguments.ABERTO))>
               	 and ws.data_conferencia is null
               </cfif>
               <cfif Len(Trim(arguments.CTF_ID))>
               	 and ws.ctf_id = #arguments.CTF_ID#    
               </cfif>
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
               	 and ws.cod_posto = #arguments.COD_PESSOA_FILIAL#    
               </cfif>
               <cfif Len(Trim(arguments.DATA))>
               	 and trunc(ws.ctf_dt_evento) = '#arguments.DATA#'
               </cfif>
            </cfquery>
            <cfreturn qr_result>		
        </cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Retorna a quantidade de motorista na data e hora especificada.
	-- Usado para verificar se h motorista no lanamento da CTF contingncia
	-- WAGNERLV  28/12/2007
	--->		
	<cffunction name="get_quantidade_motorista_hora" access="remote" returntype="Struct" output="true">
    <cfargument name="PLACA" required="yes" default=""/>
    <cfargument name="DATA" required="yes" default=""/>
	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
   		 select t.qtde
              , t.cod_pessoa
             , (select case when count(1) > 0 then 1 else 0 end
                  from oper.v$veiculo_dados
                 where placa = '#arguments.PLACA#'
                   and tipo_id in (8, 9, 19)) as veiculo
          from (select count(cod_pessoa) as qtde
                     , max(cod_pessoa) as cod_pessoa
                  from oper.v$veiculo_motorista
                 where 1 = 1
                   and placa = '#arguments.PLACA#'
                   and to_date('#arguments.DATA#','dd/mm/yyyy hh24:mi') between data_inicio and nvl(data_fim, to_date('#arguments.DATA#','dd/mm/yyyy hh24:mi'))) t
    </cfquery>
    <cfif "#qr_result.qtde#" gt 0>
		<cfset retorno.erro = false>
        <cfset retorno.qtde = #qr_result.qtde#>
        <cfset retorno.mensagem = JSStringFormat('')>
    <cfelseif "#qr_result.veiculo#" eq 0>
    	<cfset retorno.erro = false> 
        <cfset retorno.qtde = #qr_result.qtde#>
        <cfset retorno.mensagem = JSStringFormat('No h motorista no veculo com a data e hora especificada!')>
    <cfelse>
    	<cfset retorno.erro = false>
        <cfset retorno.qtde = 0>
        <cfset retorno.mensagem = JSStringFormat('')>
	</cfif> 		
		<cfreturn retorno>		
	</cffunction>	   
    
    
    <!--- 
	-- PROPSITO 
	-- Retorna o tipo do veiculo
	-- WAGNERLV  28/12/2007
	--->		
	<cffunction name="get_tipo_veiculo" access="remote" returntype="query" output="true">
    <cfargument name="PLACA" required="yes" default=""/>
	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
   		select tipo.tipo_id tipo	  from oper.v$veiculo veiculo
              inner join oper.v$veiculo_modelo modelo on modelo.modelo_id = veiculo.modelo_id
              inner join oper.v$veiculo_marca marca on marca.marca_id = veiculo.marca_id
              inner join oper.v$veiculo_tipo tipo on tipo.tipo_id = modelo.tipo_id 
              where veiculo.placa='#arguments.PLACA#'
    </cfquery>    	
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna a placa do veculo de acordo com um parmetro, este sendo "cod_veiculo" ou "placa"
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/03/2009
	--->	
	<cffunction name="get_placa_veiculo" displayname="Retorna as filiais cadastradas" output="true" returntype="query" access="remote">
    	<cfargument name="parametro" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ORDERED*/v.placa, v.cod_veiculo as veiculo
			  from oper.v$veiculo v
			 inner join oper.v$veiculo_frota_geral vfg
				on v.placa = vfg.placa
			 inner join oper.v$veiculo_tipo_carroceria vtc
				on vtc.tipo_carroceria_id = v.tipo_carroceria_id
			 inner join oper.v$veiculo_agrupamento vt
				on vt.agrupamento_id = vtc.agrupamento_id
			   and vt.tracao = 1 
			 where v.situacao_id = 1
			<cfif Len(Trim(arguments.parametro))>
			   and v.placa = upper('#arguments.parametro#')
                or v.cod_veiculo = upper('#arguments.parametro#')
			</cfif>
			 order by v.placa
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os modelos de veculos cadastrados para a Relao de Abastecimentos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/03/2009
	--->	
	<cffunction name="get_modelos" displayname="Retorna os modelos de veculos cadastrados para a Relao de Abastecimentos" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vm.modelo_id, vm.modelo
			  from oper.v$veiculo_modelo vm
			 where exists(select 0
							from oper.v$veiculo v
						   inner join oper.v$veiculo_tipo_carroceria vtc
							  on vtc.tipo_carroceria_id = v.tipo_carroceria_id
						   inner join oper.v$veiculo_agrupamento va
							  on va.agrupamento_id = vtc.agrupamento_id
							 and va.tracao = 1          
						   where v.modelo_id = vm.modelo_id
							 and v.marca_id = vm.marca_id
							 and exists (select 0 
										   from oper.v$veiculo_tipo_carr_atrib tca
										  where tca.tipo_carroceria_id = vtc.tipo_carroceria_id
											and tca.atributo_id = 133)
							   )
						   order by vm.modelo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as classificaes de veculos cadastradas para a Relao de Abastecimentos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/03/2009
	--->	
	<cffunction name="get_classificacoes" displayname="Retorna as classificaes de veculos cadastradas para a Relao de Abastecimentos" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select va.descricao||' - '||tc.descricao as classificacao, tc.tipo_carroceria_id
			  from oper.v$veiculo_tipo_carroceria tc
			 inner join oper.v$veiculo_agrupamento va
				on va.agrupamento_id = tc.agrupamento_id
			 where exists (select 0 
							 from oper.v$veiculo_tipo_carr_atrib tca
							where tca.tipo_carroceria_id = tc.tipo_carroceria_id
							  and tca.atributo_id = 133)
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os proprietrios de veculos cadastrados para a Relao de Abastecimentos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/03/2009
	--->	
	<cffunction name="get_proprietarios_veiculos" displayname="Retorna os proprietrios de veculos cadastrados para a Relao de Abastecimentos" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cpf_cnpj, cod_pessoa, proprietario, tipo_proprietario
			  from oper.v$proprietario_agregado_frota
			 order by proprietario
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna as filiais cadastradas
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/03/2009
	--->	
	<cffunction name="get_filiais" displayname="Retorna as filiais cadastradas" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ORDERED*/distinct pj.nome_fantasia, pj.cod_pessoa
			  from oper.v$bomba_combustivel b
			 inner join kss.v$pessoa_juridica pj
			    on pj.cod_pessoa = b.cod_pessoa
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna uma Relao de Abastecimentos de acordo com os parmetros atribudos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/03/2009
	--->
	<cffunction name="get_relacao_abastecimentos" displayname="Retorna uma Relao de Abastecimentos de acordo com os parmetros atribudos" output="true" returntype="query" access="remote">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
        <cfargument name="placa" required="no" default="">
        <cfargument name="modelo_id" required="no" default="">
        <cfargument name="agrupamento_id" required="no" default="">
        <cfargument name="tipo_carroceria_id" required="no" default="">
        <cfargument name="controle_evo_id" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfargument name="abastecido" required="no" default="">
        <cfargument name="cod_pessoa_posto" required="no" default="">
        <cfargument name="filial" required="no" default="">
        <cfargument name="status_tanque" required="no" default="">
        <cfargument name="situacao_abastecimento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.controle_id, to_char(a.data_hora, 'dd/mm/yyyy hh24:mi') as data_hora, a.quantidade
     			 , nvl(ai.quantidade, 0) as qtde_indevida
     			 , vmo.modelo
     			 , v.cod_veiculo
     			 , a.placa
     			 , a.km
     			 , decode(a.encheu,0,'No',1,'Sim') as encheu_tanque
     			 , (select (select mrh.cod_registro
                              from oper.v$motorista_reg_historico mrh
                             where a.data_hora between mrh.data_inicio and nvl(mrh.data_fim, a.data_hora)
                               and mrh.cod_pessoa = vm.cod_pessoa
                               )||' - '||kss.pkg_pessoa.fnc_get_cliente(vm.cod_pessoa) as funcionario
                      from oper.v$veiculo_motorista vm
                     where case
                              when vm.placa is null then 1
                              else
                                 case 
                                    when a.data_hora between vm.data_inicio and nvl(vm.data_fim, sysdate +1/24) then 1
                                    else 0
                                 end
                           end = 1
                       and vm.placa = nvl(vjp.placa_controle, a.placa)
                   ) as funcionario
                 , a.controle_evo_id
                 , nvl2(a.cod_pessoa_posto,kss.pkg_pessoa.fnc_get_cliente(a.cod_pessoa_posto,1),'****  vista ****') as posto
                 , a.valor_unitario
                 , a.valor_total as valor_abastecimento
                 , (select pe.uf
                      from kss.v$pessoa_endereco pe
                     where pe.endereco_padrao = 1
                       and pe.cod_pessoa = a.cod_pessoa_posto) as uf
                 , (select vtr.valor_num_centro_custo
                      from oper.v$veiculo_atributo vtr
                     where vtr.placa = a.placa) as valor_num_centro_custo
                 , decode(a.tipo_entrada,6,'Sim','No') as esso_card
                 , vj.num_romaneio
                 , nvl(vj.volume_total,0) as volume_total
                 , nvl(vj.m3_total,0) as m3_total
                 , vj.peso_total/1000 as peso
                 , (select ran.destino
                      from oper.v$romaneio ran
                     inner join oper.v$romaneio_viagem_anterior rva
                        on ran.num_romaneio = rva.num_romaneio_anterior
                     where rva.num_romaneio = vj.num_romaneio
                       and rva.placa = vj.placa_controle)||' - '||vj.carregamento||' - '||vj.destino as desc_viagem
                 , decode(ai.controle_macro_id, null, 'Normal', 'Indevido') as indevido
                 , decode(a.encheu,1,oper.pkg_veiculo.fnc_media_abastecimento(a.placa,a.data_hora,a.km,a.quantidade).km,0) as km_ench
                 , decode(a.encheu,1,oper.pkg_veiculo.fnc_media_abastecimento(a.placa,a.data_hora,a.km,a.quantidade).quantidade,0) as quantidade_ench
                 , decode(a.encheu,1,oper.pkg_veiculo.fnc_media_abastecimento(a.placa,a.data_hora,a.km,a.quantidade).media,0) as media
                 , decode(a.data_confirmacao, null, 'No', 'Sim') as abast_nao_confirmado
                 , a.date_insert, a.date_update, a.user_insert, a.user_update
                 , (select kss.pkg_pessoa.fnc_get_cliente(vp.cod_pessoa)
                      from oper.v$veiculo_proprietario vp
                     where vp.placa = a.placa
                       and a.data_hora between vp.data_inicio and nvl(vp.data_fim, a.data_hora) and rownum = 1) as proprietario
                 , a.num_requisicao
                 , decode(a.tipo_entrada, 7, 'Sim', 'No') as ticket_car
                 , decode(a.autenticado,0,'No','Sim') as situacao
                 , a.autenticado
                 , a.nao_autenticado_motivo
                 , decode(a.combustivel,0,'Lubrificante','Diesel') as tipo_abastecimento
                 , a.combustivel
                 , a.cod_pessoa_posto
                 , v.tipo_carroceria_id
                 , vtc.descricao as classificacao
                 , va.descricao as agrupamento
                 , nvl(a.media_consumo_ideal,0) as media_consumo_ideal
                 , dedicado.to_operacao_dados(vo.operacao_id).nome_completo as operacao
                 , a.rowid
              from oper.v$abastecimento a
             inner join oper.v$veiculo v
                on v.placa = a.placa
             inner join oper.v$veiculo_modelo vmo
                on vmo.marca_id = v.marca_id
               and vmo.modelo_id = v.modelo_id
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vtc.tipo_carroceria_id = v.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
              left join oper.v$romaneio_hist_veiculo vjp
                on vjp.placa_controle = a.placa
               and a.data_hora between vjp.data_inicio and nvl(vjp.data_termino, sysdate+1/24)
              left join oper.v$romaneio vj
                on vj.num_romaneio = vjp.num_romaneio
              left join oper.v$posto_abast_indevido ai
                on ai.controle_macro_id = a.controle_id
			<cfif Len(Trim(arguments.operacao_id))>
             inner join dedicado.v$operacao_veiculo vo       
                on vo.placa = a.placa      
               and a.data_hora between vo.data_inicio and nvl(vo.data_termino, a.data_hora)
            <cfelse>
              left join dedicado.v$operacao_veiculo vo                                               
                on vo.placa = a.placa                                
               and a.data_hora between vo.data_inicio and nvl(vo.data_termino, a.data_hora)
			</cfif>
             where 1=1
               and a.combustivel = 1			
               and a.data_hora between to_date('#arguments.data_inicial# 00:00:00','dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfif Len(Trim(arguments.placa))>
			   and a.placa = '#arguments.placa#'
            </cfif>
            <cfif Len(Trim(arguments.modelo_id))>
			   and vmo.modelo_id = #arguments.modelo_id#
            </cfif>
            <cfif Len(Trim(arguments.agrupamento_id))>
			   and va.agrupamento_id = #arguments.agrupamento_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_carroceria_id))>
			   and v.tipo_carroceria_id = #tipo_carroceria_id#
            </cfif>
            <cfif Len(Trim(arguments.controle_evo_id))>
			   and a.controle_evo_id = #arguments.controle_evo_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa))>
			   and exists (select 0 from oper.v$veiculo_proprietario vp
                            where vp.placa = a.placa and a.data_hora between vp.data_inicio and nvl(vp.data_fim, a.data_hora)
                              and vp.cod_pessoa  = #arguments.cod_pessoa#
                              and rownum = 1)
            </cfif>
            <cfif Len(Trim(arguments.operacao_id))>
			   and vo.operacao_id = #arguments.operacao_id#
            </cfif>
            <cfif Len(Trim(arguments.abastecido))>
				<cfif arguments.abastecido eq 2>
                	and not exists (select 0
                   from kss.v$unidade_negocio un
                  where un.cod_pessoa = a.cod_pessoa_posto)
                <cfelseif arguments.abastecido eq 3>
                	and exists (select 0
                   from kss.v$unidade_negocio un
                  where un.cod_pessoa = a.cod_pessoa_posto)
                <cfelseif arguments.abastecido eq 4>
                	and a.cod_pessoa_posto = #arguments.cod_pessoa_posto#
                <cfelseif arguments.abastecido eq 5>
                	and a.cod_pessoa_posto = #arguments.filial#
				 </cfif>
            </cfif>
            <cfif Len(Trim(arguments.status_tanque))>
			   and a.encheu = #arguments.status_tanque#
            </cfif>
            <cfif Len(Trim(arguments.situacao_abastecimento))>
            	<cfif arguments.situacao_abastecimento eq 0>
                	and a.data_confirmacao is null
                <cfelseif arguments.situacao_abastecimento eq 1>
                	and a.data_confirmacao is not null
                </cfif>
            </cfif>
			 order by a.data_hora, v.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!--- 
	-- PROPSITO
	-- Retorna entradas no estoque
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/03/2009
	--->	
	<cffunction name="get_entradas" displayname="Retorna entradas no estoque" output="true" returntype="query" access="remote">
    	<cfargument name="estoque_id" required="yes"/>
    	<cfargument name="data_inicial" required="no" default=""/>
    	<cfargument name="data_termino" required="no" default=""/>        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ee.num_entrada, to_char(ee.data_entrada,'dd/mm/yyyy hh24:mi') as data_entrada, ee.utilizacao, ee.num_nota_remessa,
                   eit.estoque_id, eit.quantidade, eit.preco_unitario, eit.preco_total
              from oper.v$estoque_entrada ee
             inner join oper.v$estoque_entrada_it eit
                     on ee.num_entrada = eit.num_entrada
            where eit.estoque_id = #arguments.estoque_id#
            <cfif Len(Trim(arguments.DATA_INICIAL))>
            	and trunc(ee.data_entrada) >= '#arguments.DATA_INICIAL#'
            </cfif>
            <cfif Len(Trim(arguments.DATA_TERMINO))>
            	and trunc(ee.data_entrada) <= '#arguments.DATA_TERMINO#'
            </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>    
</cfcomponent>