<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de postos" extends="_transportes.funcoes.cfc_init">
	
	<cffunction name="get_operacao_repom" displayname="" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select operacao_id,
               operacao_codigo,
               operacao_descricao,
               calcula_frete_km
          from oper.v$repom_operacao
         </cfquery>
     <cfreturn qr_result>
   </cffunction>
            
	
	
	<!--- 
	-- PROPSITO 
	-- Busca Local de envio para os romaneios
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  10/01/2004
	--->		
	<cffunction name="get_local_envio_romaneio" displayname="Busca Local de envio para os romaneios" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes" hint="Lista de romaneios">
		<cfargument name="cod_pessoa" required="yes">
		<cfquery name="qr_doctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ fd.num_romaneio, ct.num_formulario, fd.documento, fd.responsavel, 
				   fd.num_docto as num_ctrc, fd.serie,  min(data_entrega) as data_entrega, min(data_recebimento) as data_recebimento, fd.lancto_id, 
				   fd.setor_faturamento, fd.endereco_faturamento, decode(ctp.saldo,0,'Adiantamento','Saldo') as tipo
			  from oper.v$fluxo_documento fd
			 inner join oper.v$contrato_transp ct
				on fd.num_romaneio = ct.num_romaneio
			 inner join oper.v$contrato_transp_pagar ctp
				on ct.lancto_id = ctp.lancto_id
			   and ctp.cod_pessoa_recebimento = #arguments.cod_pessoa#
				 where fd.situacao_id_lancto = 0
			   and fd.cod_etapa = 'M'  
			   and fd.documento_id not in (11,3)
			   and fd.num_romaneio in (#arguments.num_romaneio#)        
			   group by fd.num_romaneio, ct.num_formulario, fd.documento, fd.responsavel, 
				   fd.num_docto, fd.serie, fd.lancto_id, 
				   fd.setor_faturamento, fd.endereco_faturamento, decode(ctp.saldo,0,'Adiantamento','Saldo')
			   order by fd.endereco_faturamento, ct.num_formulario, fd.num_docto, decode(ctp.saldo,0,'Adiantamento','Saldo')
		</cfquery>		
		<cfreturn qr_doctos>							 
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados do contrato
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2004
	--->
	<cffunction name="get_contrato_transporte" displayname="Busca os dados do contrato" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" displayname="Identificador do lanamento" required="no" default="">
		<!--- Quando a consulta for pelo docto precisa informar o local de emisso --->
		<cfargument name="num_formulario" displayname="Nmero do contrato de transporte" required="no" default="">
		<cfargument name="placa" displayname="Placa do veculo" required="no" default="">
	
		<cfquery name="qr_contrato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ lancto_id, num_romaneio, num_formulario, serie_formulario, 
				   cod_pessoa_filial, cod_departamento, cod_setor, cod_centro_custo, 
                   to_char(data_emissao,'dd/mm/yyyy') as data_emissao, 
                   oper.pkg_operacional.fnc_converte_peso(peso,'Kg',cod_unidade) as peso, volume, 
				   m3, frete_em, cod_unidade, tolerancia_falta, valor_unitario, 
				   valor_frete_bruto, valor_frete_liquido, motorista_cod_pessoa, 
				   motorista, placa_controle, oper.fnc_get_cod_veiculo(placa_controle) as frota,
                   placa_referencia, proprietario_cod_pessoa, 
				   proprietario_endereco, proprietario_cod_uf, proprietario_cod_municipio, 
				   proprietario_cod_distrito, proprietario_cod_dv, impresso, 
				   situacao_adto_id, situacao_saldo_id, observacao, proprietario_nit,
				   especie
			  from oper.v$contrato_transporte
			 where data_emissao > to_date('01/07/2004 00:00','dd/mm/yyyy hh24:mi')
			<cfif Len(Trim(arguments.lancto_id))>
			   and lancto_id = #arguments.lancto_id# 
            </cfif>
            <cfif Len(Trim(arguments.num_formulario))>
			   and num_formulario = '#arguments.num_formulario#'
            </cfif>
            <cfif Len(Trim(arguments.placa))>
			   and (placa_controle = upper('#arguments.placa#') or placa_referencia = upper('#arguments.placa#') )
			</cfif>
		</cfquery>			
		<cfreturn qr_contrato>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados dos itens do contrato
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2004
	--->
	<cffunction name="get_contrato_transp_itens" displayname="Busca os dados dos itens do contrato" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" displayname="Identificador do lanamento" required="true">
		<cfargument name="item_id" displayname="Identificador do item" required="false">
		<cfquery name="qr_contrato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ci.lancto_id, ci.item_id, ci.valor, ci.desconto, ci.descricao,
					decode(ci.desconto,1,'Desconto','Acrscimo') as tipo, ct.situacao_saldo_id, ct.situacao_adto_id
			  from oper.v$contrato_transp ct
			 inner join oper.v$contrato_transp_item ci
				on ct.lancto_id = ci.lancto_id
			 where ct.lancto_id = #arguments.lancto_id#
			 <cfif isDefined("arguments.item_id")>
			   and ci.item_id = #arguments.item_id# 
			 </cfif>
		</cfquery>			
		<cfreturn qr_contrato>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Fluxo de doctos do contratos confirmados nos postos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2004
	--->
	<cffunction name="get_fluxo_doctos_enviados_posto" displayname="Busca Fluxo de doctos do contratos confirmados nos postos" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes">
		<cfquery name="qr_doctos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct /*+ FIRST_ROWS */ fd.lancto_id, fd.num_docto, fd.serie, fd.responsavel,fd.documento, 
				   fd.cod_pessoa_filial_fat, fd.setor_faturamento,
				   s.cep, s.endereco, s.complemento, s.numero, s.bairro,
				   ib.sigla_uf, ib.nome_municipio,
				   'CEP: ' || s.cep || ' - ' || s.ENDERECO || ', ' || s.numero || ' - ' ||  s.bairro ||', '|| ib.nome_municipio || '/'||ib.sigla_uf as endereco
			  from oper.v$fluxo_documento fd
			 inner join oper.v$setor s
				on s.cod_pessoa_filial = fd.cod_pessoa_filial_fat
		 and s.COD_SETOR = fd.cod_setor_fat
			 inner join cep.ibge_municipio ib
				on ib.cod_uf = oper.pkg_global.fnc_endereco_ibge(s.cep).cod_uf
			   and ib.cod_municipio = oper.pkg_global.fnc_endereco_ibge(s.cep).cod_municipio
			   and ib.cod_distrito = oper.pkg_global.fnc_endereco_ibge(s.cep).cod_distrito
			   and ib.cod_dv = oper.pkg_global.fnc_endereco_ibge(s.cep).cod_dv
			  where fd.num_romaneio = #arguments.num_romaneio#
				and fd.cod_etapa = 'M'
				and fd.documento_id <> 11
				and fd.situacao_id_lancto = 0
			order by fd.num_docto, s.cep
		</cfquery>		
	<cfreturn qr_doctos>							 
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca tipos de frete
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_tipo_frete" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select produto_id, descricao 
              from oper.v$produto t
	 		 where t.frete = 1
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca natureza dos produtos da empresa
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_natureza" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			<!--- Antigo
			select n.num_natureza, n.descricao, n.num_grau_risco, gr.descricao as grau_risco, 
				   r.rastreabilidade_id, r.descricao as rastreabilidade
			  from oper.v$natureza n
			 inner join oper.v$grau_risco gr
				on n.num_grau_risco = gr.num_grau
			 inner join oper.v$rastreabilidade r
				on gr.rastreabilidade_id = r.rastreabilidade_id
			 order by n.descricao	--->
			 select num_natureza, descricao
				from oper.v$natureza
				order by descricao
		</cfquery>
	<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca especie dos produtos
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_especie" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select num_especie, descricao, 
			       abreviatura, nvl(peso,0) as peso
			  from oper.v$especie
             order by descricao
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_equipamento" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select num_equipamento, equipamento 
			  from oper.v$equipamento
			 order by equipamento 
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca ambiente
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_ambiente" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select num_ambiente, ambiente || ' - ' || decode (trabalha_com_chuva,1,'Trabalha com chuva', 'No trabalha com chuva') as ambiente
			  from oper.v$ambiente	
			 order by ambiente
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca unidade de medida
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_unidade" displayname="Busca Unidade" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select  u.cod_unidade, u.unidade
			  from oper.v$unidade_medida u	
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca material
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_material" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select num_material, material
			  from oper.v$material
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca conta corrente do favorecido
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_ccorrente_favorecido" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select cc.cod_conta, cc.cod_conta ||'-'|| cc.descricao_conta as descricao_conta,
				   cc.aceita_deposito, cc.aceita_boleto	       
			  from oper.v$ccorrente_banco cc
			 where cc.ativo = 1
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca formas de pagamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_forma_pagto" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select forma_id, forma_descricao
			  from finan.v$faturamento_forma
			 order by forma_descricao
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca agrupamentos
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_agrupamento" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select agrupamento_id, agrupamento, num_dia
			  from finan.v$faturamento_periodo
		     order by agrupamento  	
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca documentos para faturamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_documentos_faturamento" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select df.documento_id, df.documento, df.motorista, df.faturista, df.embarcador,
			       (select count(*) 
			          from oper.v$lote_documento ld
			         where ld.documento_id = df.documento_id) as uso
			  from oper.v$documento_frete df
			 order by uso desc, df.documento
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca condies de faturamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_condicao_faturamento" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select fc.condicao_id, fc.condicao
			  from finan.v$faturamento_condicao fc
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca padro para participao nos lotes
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_gestao_participacao_lotes" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_global.FNC_GET_PARAMETRO(1, 'CONTRATO_TRANSP') as perc_comissao, 
				   oper.pkg_global.FNC_GET_PARAMETRO(2, 'CONTRATO_TRANSP') as perc_negociador, 
				   oper.pkg_global.FNC_GET_PARAMETRO(3, 'CONTRATO_TRANSP') as perc_embarcador, 
				   oper.pkg_global.FNC_GET_PARAMETRO(4, 'CONTRATO_TRANSP') as perc_emissor
			 from dual
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca series
	-- CRISTOFER  12/06/2006
	--->		
	<cffunction name="get_serie" displayname="Busca Sries" access="remote" returntype="query" output="false">
	    <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_pessoa" hint="Usado para algumas telas que usam o COD_PESSOA como o cdigo pessoa da filial" required="no" default=""/>
	    <cfargument name="cod_departamento" required="no">
	    <cfargument name="cod_setor" required="no">
	    <cfargument name="cod_centro_custo" required="no">
		<cfargument name="cod_modelo" required="no" default="">
	    <cfargument name="organograma" required="no" default="">		
		<cfargument name="todas" required="no">
		<cfif Len(Trim(arguments.cod_pessoa)) and not Len(Trim(arguments.cod_pessoa_filial))>
			<cfset arguments.cod_pessoa_filial = arguments.cod_pessoa>
		</cfif>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cfif not isDefined("arguments.todas")>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				 <cfif Len(Trim(arguments.cod_pessoa_filial))>
					select ags.serie 
					  from fiscal.v$modelo_serie ags
					 where ags.cod_pessoa       = #arguments.cod_pessoa_filial#
					   and ags.cod_departamento = #arguments.cod_departamento#
					   and ags.cod_setor        = #arguments.cod_setor#
					   and ags.ativo 			= 1 
					   <cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo ='#arguments.cod_modelo#'
					   </cfif>
					  order by ags.cod_pessoa, ags.cod_departamento, ags.cod_setor 
				 <cfelse>
					select distinct ags.serie 
					  from fiscal.v$modelo_serie ags
					 inner join oper.v$kss_usuario_lotacao ul
						on ags.cod_pessoa = ul.cod_pessoa
					   and ags.cod_departamento = ul.cod_departamento
					   and ags.cod_setor = ul.cod_setor
					  where ags.ativo 	 = 1
					  	<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo = '#arguments.cod_modelo#'
					   </cfif>
					  order by ags.serie 
				 </cfif>
			</cfquery>		
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				select distinct serie 
				from fiscal.v$modelo_serie
				where ativo 	 = 1
				<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					and cod_modelo = '#arguments.cod_modelo#'
				</cfif>
  			</cfquery>		
	    </cfif>
		<cfreturn qr_serie> 
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados do lote
	-- CRISTOFER  //2006
	--->		
	<cffunction name="get_lote" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select l.num_lote, l.data_inicio_retirada, l.data_prazo_retirada, l.data_contrato, l.num_natureza, 
  				   n.descricao as natureza, l.num_especie, e.descricao as especie, 
  				   oper.pkg_operacional.fnc_converte_peso(l.peso,'Kg',l.cod_unidade) as peso, l.volume, 
  				   l.m3, l.frete_em, l.cod_unidade, l.qtde_viagem, 
  				   l.frete_proprio, l.frete_valor_unitario, l.frete_valor, l.frete_por_conta, 
  				   l.num_produto, l.situacao_tributaria, l.aliquota_icms, l.reducao_base_calculo, 
  				   l.icms_incluso, l.destaca_base_calc_icms, 
  				   decode(l.fundamentacao_legal,'','',l.fundamentacao_legal || chr(10)) || 'Ace Seguros S/A. n AP-27.54.0001133.14' as fundamentacao_legal, 
  				   rem.razao_social as remetente, rem.inscricao_estadual as rem_inscr_estadual, rem.municipio as rem_municipio, 
  				   rem.uf as rem_uf, rem.codigo as cnpj_cpf_remetente, rem.cep as rem_cep, rem.situacao_id as rem_situacao,
  				   rem.endereco as rem_endereco, rem.bairro as rem_bairro,
  				   dest.codigo as cnpj_cpf_destinatario,
  					 dest.razao_social as destinatario, dest.inscricao_estadual as dest_inscr_estadual, dest.municipio as dest_municipio, 
  				   dest.uf as dest_uf, dest.cep as dest_cep, dest.situacao_id as dest_situacao,
  				   dest.endereco as dest_endereco, dest.bairro as dest_bairro,
					   decode(l.cod_pessoa_destinatario,null,0,1) as lote_com_destinatario,
					   l.cod_pessoa_remetente, l.cod_pessoa_destinatario, l.coleta_logradouro, 
					   l.coleta_complemento, l.coleta_bairro, l.coleta_cep, l.coleta_cod_uf, 
					   l.coleta_cod_municipio, l.coleta_cod_dv, l.coleta_cod_distrito, l.entrega_logradouro, 
					   l.entrega_complemento, l.entrega_cep, l.entrega_bairro, ent.sigla_uf as entrega_uf,
  				   ent.nome_municipio as entrega_municipio, l.entrega_cod_uf, 
 					   l.entrega_cod_municipio, l.entrega_cod_distrito, l.entrega_cod_dv, l.controle_peso, 
 					   l.controle_peso_veiculo, l.situacao_id, l.observacao, l.negociador_id,
 					   l.controle_viagem, l.observacao_emitente, l.pedagio_incluso,
 					   decode(l.frete_por_conta,0,rem.cod_atividade_fiscal,dest.cod_atividade_fiscal) as cod_atividade_fiscal,
  				   case l.situacao_id 
  					 when 1 then 'Disponvel'
  					 when 2 then 'Bloqueado'
  					 when 3 then 'Cancelado'
  					 when 4 then 'Encerrado'
  				   end situacao,             
  						   nvl(round((select sum(ri.peso)
  								  from oper.v$romaneio_item ri 
  								 where ri.num_lote = l.num_lote) * 100/decode(l.peso,0,1,l.peso),0),0) as peso_carregado,
  						   decode(ld.imprime_conhecimento,1,ld.observacao,'') as rodape,
  				   cl.nome_municipio as coleta_municipio, cl.sigla_uf as coleta_uf,
  				   l.cod_pessoa_filial, kss.pessoa_pkg.getCliente(l.cod_pessoa_filial,1) as filial,
  				   l.cod_departamento, l.cod_setor, l.cod_centro_custo, s.descricao as setor, n.descricao as natureza, e.descricao as especie, e.peso as tara_especie,
  				   p.descricao as produto
			  from oper.v$lote l
			 inner join oper.v$natureza n
				       on l.num_natureza = n.num_natureza
			 inner join oper.v$especie e 
				       on l.num_especie = e.num_especie
			 inner join oper.v$remetente_destinatario rem
				       on rem.cod_pessoa = l.cod_pessoa_remetente
			 inner join kss.v$setor s
				       on l.cod_setor = s.cod_setor
			 inner join oper.v$produto p
				       on l.num_produto = p.produto_id        
       left outer join oper.v$remetente_destinatario dest
			              on dest.cod_pessoa = l.cod_pessoa_destinatario
		   left outer join oper.v$lote_descarga ld
				            on l.num_lote = ld.num_lote		
			 left outer join cep.ibge_municipio cl
				            on l.coleta_cod_uf = cl.cod_uf
			             and l.coleta_cod_municipio = cl.cod_municipio
			             and l.coleta_cod_distrito = cl.cod_distrito
			             and l.coleta_cod_dv = cl.cod_dv
			 left outer join cep.ibge_municipio ent
				            on l.entrega_cod_uf = ent.cod_uf
			             and l.entrega_cod_municipio = ent.cod_municipio
			             and l.entrega_cod_distrito = ent.cod_distrito
			             and l.entrega_cod_dv = ent.cod_dv
			 where l.num_lote = #arguments.num_lote#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca lote por material
	-- Wagner  //2006
	--->
	
	<cffunction name="get_lote_material" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select lm.num_lote, lm.num_material, m.material, lm.carga, lm.descarga
			  from oper.v$lote_material lm
			 inner join oper.v$material m
				on lm.num_material = m.num_material
			 where lm.num_lote = #arguments.num_lote#
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca lote por carga
	-- Wagner //2006
	--->
	
	<cffunction name="get_lote_carga" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select lc.num_lote, lc.num_equipamento, e.equipamento, lc.num_ambiente, a.ambiente, lc.por_conta,
				   case lc.por_conta 
					 when 1 then 'Remetente'
					 when 2 then 'Transportador'
					 else 'Ambos'
				   end por_conta_de, lc.carregador, lc.contato_nome, lc.contato_cargo, 
				   lc.contato_telefone, lc.contato_email, lc.imprime_ordem_cargto, lc.observacao
			  from oper.v$lote_carga lc
			 inner join oper.v$equipamento e
				on lc.num_equipamento = e.num_equipamento
			 inner join oper.v$ambiente a
				on lc.num_ambiente = a.num_ambiente
			 where lc.num_lote = #arguments.num_lote#
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca lote por descarga
	-- Wagner //2006
	--->
	
	<cffunction name="get_lote_descarga" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select lc.num_lote, lc.num_equipamento, e.equipamento, lc.num_ambiente, a.ambiente, lc.por_conta,
				   case lc.por_conta 
					 when 1 then 'Remetente'
					 when 2 then 'Transportador'
					 else 'Ambos'
				   end por_conta_de, lc.descarregador, lc.contato_nome, lc.contato_cargo, 
				   lc.contato_telefone, lc.contato_mail, lc.imprime_conhecimento, lc.observacao
			  from oper.v$lote_descarga lc
			 inner join oper.v$equipamento e
				on lc.num_equipamento = e.num_equipamento
			 inner join oper.v$ambiente a
				on lc.num_ambiente = a.num_ambiente
			 where lc.num_lote = #arguments.num_lote#
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca lote por faturamento
	-- Wagner //2006
	--->
	
	<cffunction name="get_lote_faturamento" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select lf.num_lote, lf.cod_pessoa_filial, kss.pessoa_pkg.getcliente(lf.cod_pessoa_filial,1) as filial, 
				   lf.cod_setor, s.descricao as setor, 
				   lf.forma_id, ff.forma_descricao as forma_pagto, 
				   lf.agrupamento_id, fp.agrupamento, lf.condicao_id, fc.condicao,
				   lf.num_dias_vencto, lf.cod_conta_favorecido, cc.descricao_conta as ccorrente,
				   lf.contato_nome, lf.contato_telefone, lf.contato_email, 
				   lf.logradouro, lf.complemento, lf.bairro, lf.cep, lf.cod_uf, 
				   lf.cod_municipio, lf.cod_distrito, lf.cod_dv, lf.observacao, e.sigla_uf as uf, e.nome_municipio as municipio
			  from oper.v$lote_faturamento lf
			 inner join oper.v$ccorrente cc 
				on lf.cod_conta_favorecido = cc.cod_conta
			 inner join finan.v$faturamento_forma ff
				on lf.forma_id = ff.forma_id
			 inner join finan.v$faturamento_periodo fp
				on lf.agrupamento_id = fp.agrupamento_id
			 inner join finan.v$faturamento_condicao fc
				on lf.condicao_id = fc.condicao_id
			 inner join kss.v$setor s
				on lf.cod_setor = s.cod_setor
			  left outer join cep.ibge_municipio e
				on lf.cod_uf = e.cod_uf
			   and lf.cod_municipio = e.cod_municipio
			   and lf.cod_distrito = e.cod_distrito
			   and lf.cod_dv = e.cod_dv   
			 where lf.num_lote =  #arguments.num_lote#
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>			
	
	<!--- 
	-- PROPSITO 
	-- Busca lote por documentos
	-- Wagner //2006
	--->
	
	<cffunction name="get_lote_documentos" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select ld.num_lote, ld.documento_id, df.documento, ld.embarcador, ld.faturista, ld.motorista
			  from oper.v$lote_documento ld
			 inner join oper.v$documento_frete df
				on ld.documento_id = df.documento_id
			 where ld.num_lote =  #arguments.num_lote#
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>				
	
	<!--- 
	-- PROPSITO 
	-- Busca lote por contratante
	-- Wagner //2006
	--->
	
	<cffunction name="get_lote_contratante" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select lc.num_lote, lc.nome, lc.cargo, lc.telefone, lc.email, lc.observacao
			  from oper.v$lote_contratante lc
			 where lc.num_lote =  #arguments.num_lote#
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Agncia Compartilhamento
	-- Wagner //2006
	--->
	
	<cffunction name="get_lote_ag_compto" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_lote_ag_compto" username="#session.usuario#" password="#session.senha#">
			select l.num_lote, l.permite_destinar, s.descricao as setor,
				     kss.pessoa_pkg.getcliente(l.cod_pessoa_filial,1) as filial
			  from oper.v$lote_setor_compto l
			 inner join kss.v$setor s
				on l.cod_setor = s.cod_setor
		     where l.num_lote =  #arguments.num_lote#			 
  		</cfquery>
	<cfreturn qr_lote_ag_compto>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Agncia Emitir Doctos
	-- Wagner //2006
	--->	
	
	<cffunction name="get_lote_ag_docto" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_lote_ag_docto" username="#session.usuario#" password="#session.senha#">
			select l.num_lote, kss.pessoa_pkg.getcliente(l.cod_pessoa_filial,1) as filial, s.descricao as setor
			  from oper.v$lote_setor_docto l
			 inner join kss.v$setor s
			   on l.cod_setor = s.cod_setor
		     where l.num_lote =  #arguments.num_lote#			 
  		</cfquery>
	<cfreturn qr_lote_ag_docto>
	</cffunction>	
	
		
	<cffunction name="get_servico_contratado" displayname="Busca os dados para o servio contratado" access="remote" returntype="struct" output="true">
		<cfargument name="p_placa" required="yes">
		<cfargument name="p_data_emissao" required="yes">
		<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_operacional.prc_get_motorista_proprietario" username="#session.usuario#" password="#session.senha#">
			<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_placa" value="#arguments.p_placa#">
			<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_data_hora" value="#arguments.p_data_emissao#">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_proprietario" variable="retorno.cod_pessoa_proprietario">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_proprietario" variable="retorno.proprietario">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_cnpj_prop" variable="retorno.cnpj_prop">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_endereco" variable="retorno.endereco">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_cidade" variable="retorno.cidade">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_uf" variable="retorno.uf">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_cod_dv" variable="retorno.proprietario_cod_dv">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_cod_distrito" variable="retorno.proprietario_cod_distrito">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_cod_municipio" variable="retorno.proprietario_cod_municipio">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_cod_uf" variable="retorno.proprietario_cod_uf">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_cod_pessoa_motorista" variable="retorno.cod_pessoa_motorista">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_cpf_motorista" variable="retorno.cpf_motorista">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_nome_motorista" variable="retorno.nome_motorista">
			<cfprocparam type="out" cfsqltype="cf_sql_date" dbvarname="p_cnh_validade" variable="retorno.cnh_validade">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_cnh_numero" variable="retorno.cnh_numero">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_pis_pasep_nit" variable="retorno.pis_pasep_nit">
			<cfprocparam type="out" cfsqltype="cf_sql_integer" dbvarname="p_retorno" variable="retorno.retorno">
		</cfstoredproc>
		<cfreturn retorno>
	</cffunction>		
	<!--- 
	-- PROPSITO 
	-- Busca Conhecimentos sem Contrato de Transporte
	-- Wagner 19/06/2006
	--->
	<cffunction name="get_conhecimento_sem_ct" displayname="Busca os conhecimentos sem contrato" access="remote" returntype="query" output="true">
		<cfargument name="num_conhecimento" required="false">
		<cfargument name="serie" required="false">
		<cfargument name="num_romaneio" required="false">
		<cfquery name="qr_conhecimentos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ c.conhecimento_id, c.num_romaneio, c.data_emissao, c.placa, 
				   c.num_conhecimento, rd.nome_fantasia, rd.municipio, rd.codigo, 
           		   r.carregamento, r.destino, r.cliente, r.cod_unidade, r.frete_em, 
				   oper.pkg_operacional.fnc_converte_peso(c.peso,'Kg',c.cod_unidade) as peso,
				   rhv.placa_referencia, rhv.placa_controle, c.frete_unitario, rit.num_lote
			  from oper.v$conhecimento c
			 inner join oper.v$romaneio r
				on c.num_romaneio = r.num_romaneio
			 inner join oper.v$romaneio_item rit
			    on r.num_romaneio = rit.num_romaneio
			   and c.item_id = rit.item_id
			 inner join oper.v$romaneio_hist_veiculo rhv
			    on r.num_romaneio = rhv.num_romaneio
			   and rhv.data_inicio = (select min(rhv2.data_inicio) 
										from oper.v$romaneio_hist_veiculo rhv2
									   where rhv.num_romaneio = rhv2.num_romaneio)
			 inner join oper.v$remetente_destinatario rd
				on c.cod_destinatario = rd.cod_pessoa
			 where c.cod_pessoa_filial = #session.cod_pessoa#
			 <cfif isDefined("arguments.num_conhecimento") and isDefined("arguments.serie")>
			   and c.num_conhecimento = #arguments.num_conhecimento#
			   and c.serie = '#arguments.serie#' 
			 </cfif>
			 <cfif isDefined("arguments.num_romaneio")>
			   and c.num_romaneio = #arguments.num_romaneio# 
			 </cfif>
		</cfquery>			
		<cfreturn qr_conhecimentos>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca Conhecimentos sem Contrato de Transporte
	-- Wagner 19/06/2006
	--->
	<cffunction name="get_contrato_lote" displayname="Busca os dados do lote a que o contrato esta vinculado" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" displayname="Identificador do lanamento" required="true">
		<cfquery name="qr_lote" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ct.lancto_id, r.carregamento, r.destino, r.cliente, 
				   n.descricao as produto, r.peso_total
			  from oper.v$contrato_transp ct
			 inner join oper.v$romaneio r
				on ct.num_romaneio = r.num_romaneio
			 inner join oper.v$natureza n
				on r.num_natureza = n.num_natureza
			 where ct.lancto_id = #arguments.lancto_id#
		</cfquery>			
		<cfreturn qr_lote>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca Conhecimentos
	-- Wagner 19/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_conhecimentos" displayname="Busca os conhecimentos a que o contrato esta vinculado" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" required="false">
		<cfargument name="num_conhecimento" required="false">
		<cfargument name="serie" required="false">
		<cfargument name="num_romaneio" required="false">
		<cfargument name="cnpj_ordem_filial" required="false">
		<cfargument name="agencia_id" required="false">
		<cfquery name="qr_conhecimentos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.conhecimento_id, c.num_romaneio, c.data_emissao, c.placa, 
				   c.num_conhecimento, rd.nome_fantasia, rd.municipio, rd.codigo
			  from oper.v$contrato_transp ct
			 inner join oper.v$conhecimento c
				on ct.num_romaneio = c.num_romaneio
			 inner join oper.v$remetente_destinatario rd
				on c.cod_destinatario = rd.cod_pessoa
			 where 1=1
			 <cfif isDefined("arguments.lancto_id")>
			   and ct.lancto_id = #arguments.lancto_id#
			 </cfif>
			 <cfif isDefined("arguments.num_conhecimento") and isDefined("arguments.serie")>
			   and c.num_conhecimento = #arguments.num_conhecimento#
			   and c.serie = '#arguments.serie#'
			 </cfif>
			 <cfif isDefined("arguments.cod_pessoa_filial")>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			   and c.cod_departamento  = #arguments.cod_departamento#
			   and c.cod_setor 		   = #arguments.cod_setor#
			   and c.cod_centro_custo  = #arguments.cod_centro_custo#
			 </cfif>
			 <cfif isDefined("arguments.num_romaneio")>
			   and c.num_romaneio = #arguments.num_romaneio#
			 </cfif>
		</cfquery>			
		<cfreturn qr_conhecimentos>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Contrato de Transporte
	-- Wagner 19/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_dados_contrato_transporte" displayname="Busca os dados do contrato de transporte" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" required="no" default="">
		<cfargument name="num_formulario" required="no" default="">
		<cfquery name="qr_contrato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select distinct lancto_id, num_romaneio, 
        	   to_char(data_emissao,'dd/mm/yyyy') as data_emissao, filial, setor, 
			   remetente, origem, org_uf, destino, destinatario, 
			   frete_em, peso, tolerancia_falta, valor_frete_bruto, 
			   especie, volume, motorista_cod_pessoa, motorista, 
			   cnh_num_registro, placa_controle, oper.fnc_get_cod_veiculo(placa_controle) as frota,
               placa_referencia, 
			   proprietario_cod_pessoa, proprietario, proprietario_cnpj_cpf, 
			   proprietario_endereco, proprietario_nit, prop_municipio, prop_uf, 
			   observacao, notas_fiscais, ct.valor_frete_liquido,
         nvl((select sum(valor) 
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ct.lancto_id
             and cti.item_id = 1),0) as valor_pedagio,
         nvl((select sum(valor) 
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ct.lancto_id
             and cti.item_id = 21),0) as inss,
         nvl((select sum(valor) 
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ct.lancto_id
             and cti.item_id = 20),0) as irrf,
         nvl((select sum(valor) 
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ct.lancto_id
             and cti.item_id = 7),0) as adiantamento,
          (select nvl(sum(cti.valor), 0)
					  from oper.v$contrato_transp_item cti
			   where cti.lancto_id = ct.lancto_id
             and cti.desconto = 1) total_descontos,
		  ( ct.valor_frete_liquido  +
          (select nvl(sum(cti.valor), 0)
					  from oper.v$contrato_transp_item cti
			   where cti.lancto_id = ct.lancto_id
             and cti.desconto = 0) -
          (select nvl(sum(cti.valor), 0)
					  from oper.v$contrato_transp_item cti
			   where cti.lancto_id = ct.lancto_id
             and cti.desconto = 1)) as saldo_receber			 		  
		  from oper.v$contrato_transporte ct
		 where 1=1
         <cfif Len(Trim(arguments.lancto_id))>
          and ct.lancto_id = #arguments.lancto_id#
         </cfif>
         <cfif Len(Trim(arguments.NUM_FORMULARIO))>
           and ct.num_formulario = #arguments.NUM_FORMULARIO#
         </cfif>
	</cfquery>		
	<cfreturn qr_contrato>							 
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Seguro Vigente pelo tipo
	-- Wagner //2006
	--->
	
	<cffunction name="get_seguro_vigente" access="remote" returntype="query" output="true">
		<cfargument name="tipo_seguro" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_seguro_vigente" username="#session.usuario#" password="#session.senha#">
				select /*+FIRST_ROWS*/seg.numero_apolice, seg.id_seguradora,
						nvl(( select max(valor)
								from oper.v$seg_cont_endosso
							   where id_seguradora = seg.id_seguradora),seg.valor_cobertura) valor_cobertura,
						p.razao_social,ger.cnpj_basico||ger.cnpj_ordem||ger.cnpj_dv cnpj_gerenciadora
				  from oper.v$seg_contratado seg
			inner join oper.v$pessoa p
					on p.cod_pessoa = seg.cod_seguradora 
			 left join oper.v$pessoa_juridica ger
					on ger.cod_pessoa = seg.cod_gerenciadora         
				 where trunc(sysdate) between seg.data_inicio_vigencia and seg.data_fim_vigencia
				   and seg.tipo_seguro = #arguments.tipo_seguro#
				   and seg.data_cancelamento is null
   		</cfquery>
	<cfreturn qr_seguro_vigente>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Liberaes por Seguradora
	-- Wagner //2006
	--->
	
	<cffunction name="get_liberacao_seguro" access="remote" returntype="query" output="true">
		<cfargument name="id_seguradora" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_liberacao_seguradora" username="#session.usuario#" password="#session.senha#">
				select sc.valor_cobertura, l.num_liberacao, sc.ID_SEGURADORA
				  from oper.v$seg_contratado sc
		 	 left join oper.v$seg_cont_liberacao l
			 		on l.ID_SEGURADORA = sc.ID_SEGURADORA
				 where sc.id_seguradora = #arguments.id_seguradora#
				   and data_exclusao is null
			  order by l.num_liberacao
		</cfquery>
	<cfreturn qr_liberacao_seguradora>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Regras fiscais do Cliente
	-- Wagner //2006
	--->
	
	<cffunction name="get_lote_regra_fiscal" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select distinct lr.regra_fiscal_id, lr.descricao
		      from oper.v$lote_regra_fiscal lr
			where ativa = 1
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca Situao padro para gerar o lote
	-- Wagner 19/06/2006 17:38:31 - CRIADO
	--->
	
	<cffunction name="get_lote_situacao" displayname="Busca Situao padro para gerar o lote" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_situacao_tributaria" username="#session.usuario#" password="#session.senha#">
			select nvl(kss.pkg_global.fnc_obtem_parametro_str(11, 'OPERACIONAL', 17, 213),0) valor
  			  from dual
 		</cfquery>		
		<cfreturn qr_situacao_tributaria>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Regras fiscais do Cliente
	-- Wagner //2006
	--->
	
	<cffunction name="get_contrato_transporte_inss" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="lancto_id" required="no" default="">
		<cfargument name="PROPRIETARIO_COD_PESSOA" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select  distinct ct.lancto_id, ct.num_romaneio,
					ct.num_formulario,
					ct.placa_controle,
	       			ct.data_emissao,ct.valor_unitario, 
            		ct.valor_frete_bruto, ct.valor_frete_liquido, ct.proprietario_cod_pessoa, 
			      	p.nome as proprietario,
					oper.pkg_global.fnc_mascara_cnpj_cpf(ct.proprietario_cod_pessoa) as cpf,
            		p.cpf || p.cpf_dv as cpf_sem_mascara,
            		p.pis_pasep_nit as nit_pis, 
			      	cti.VALOR as valor_retido
			   from oper.v$contrato_transporte ct
		 inner join oper.v$contrato_transp_item cti
       			 on cti.LANCTO_ID = ct.lancto_id
       			and cti.ITEM_ID = 21 /*INSS*/
		 inner join kss.v$pessoa_fisica p
		 		 on p.cod_pessoa = ct.proprietario_cod_pessoa  
     		  where 1=1
			  <cfif Len(Trim(arguments.data_inicial))>	
				and trunc(ct.data_emissao) >= '#arguments.data_inicial#'
			  </cfif>
			  <cfif Len(Trim(arguments.data_final))>	
				and trunc(ct.data_emissao) <= '#arguments.data_final#'
			  </cfif>
       		  <cfif Len(Trim(arguments.lancto_id))>	
				and ct.lancto_id = #arguments.lancto_id#
			  </cfif>
			  <cfif Len(Trim(arguments.PROPRIETARIO_COD_PESSOA))>	
				and ct.PROPRIETARIO_COD_PESSOA = #arguments.PROPRIETARIO_COD_PESSOA#
			  </cfif>
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados do lote
	-- CRISTOFER  24/11/2006
	--->		
	<cffunction name="get_lote_dados" access="remote" returntype="query" output="true">	
		<cfargument name="num_lote" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select l.num_lote,
				   l.frete_em,
				   l.fracionado,
				   l.cod_pessoa_remetente,
				   l.cod_pessoa_filial
			  from oper.v$lote l
			 where 1=1
			   and l.num_lote in (#arguments.num_lote#)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
 
	<!--- 
	-- PROPSITO 
	-- Busca os dados do manifesto para 
	-- CRISTOFER  24/11/2006
	--->		
	<cffunction name="get_manifesto_ct" access="remote" returntype="query" output="true">
		<cfargument name="num_manifesto" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.manifesto_id,
				   m.num_manifesto,
				   sum(c.peso) peso,
				   oper.pkg_operacional.fnc_converte_peso(sum(c.peso),min(cod_unidade),'Ton') peso_ton,
				   sum(c.m3) m3,
				   sum(c.volume) volume,
				   min(cod_unidade) cod_unidade,
				   m.placa_tracao,
				   m.placa_reboque,
				   oper.pkg_veiculo.fnc_veiculo_proprietario(m.placa_tracao) as veiculo_proprietario, -- 1 - Frota, 2 - Agregado, 3 - Terceiro
				   case when exists (select 0
				                       from oper.v$contrato_transp ct
									  where ct.manifesto_id = m.manifesto_id
									    and ct.data_cancelamento is null) then 1
					    else 0
				   end vinculado_ct,
				   case when exists (select 0
				                       from oper.v$romaneio roo
	                                  inner join oper.v$contrato_transp ct
    	                                      on ct.num_romaneio = roo.num_romaneio
									  where roo.num_romaneio = c.num_romaneio
									    and ct.data_cancelamento is null) and m.roo_item_id is not null then 1
					    else 0
				   end vinculado_roo,
				   m.num_lote
			  from oper.v$manifesto m
			 inner join oper.v$manifesto_conhecimento mc
					 on mc.manifesto_id = m.manifesto_id
			 inner join fiscal.v$conhecimento c
					 on c.conhecimento_id = mc.conhecimento_id
			 where 1=1
			 <cfif len(trim(arguments.num_manifesto))>
			   and m.num_manifesto = #arguments.num_manifesto#
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial))>
	           and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 group by m.manifesto_id, 
					  m.num_manifesto,
					  m.placa_tracao,
					  m.placa_reboque,
					  m.num_lote,
					  c.num_romaneio,
                      m.roo_item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os conhecimentos do manifesto
	-- CRISTOFER  27/11/2006
	--->		
	<cffunction name="get_manifesto_conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mc.manifesto_id,
				   c.conhecimento_id,
				   c.num_conhecimento, to_char(c.data_emissao,'dd/mm/yyyy') as data_emissao
			  from oper.v$manifesto_conhecimento mc
			 inner join fiscal.v$conhecimento c
					 on c.conhecimento_id = mc.conhecimento_id
			 where 1=1
			 <cfif len(trim(arguments.manifesto_id))>
			   and mc.manifesto_id = #arguments.manifesto_id#
			 </cfif>
			 order by c.num_conhecimento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca autorizao de abastecimento para impresso
	-- WAGNER  27/12/2006
	--->		
	<cffunction name="get_autorizacao_abastecimento_print" access="remote" returntype="query" output="true">
		<cfargument name="autorizacao_id" required="no" default="" >
		<cfargument name="lancto_id" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				   select	aa.rg_motorista as identidade,
							aa.nome_motorista as motorista,
							p.identificador as posto_cnpj,
							p.razao_social as posto_nome,
							aa.valor_total as valor,
							aa.placa_controle as placa_tracao,
       						aa.placa_referencia as placa_carreta,
							finan.pkg_financeiro.fnc_extenso(aa.valor_total)as valor_extenso 
					 from oper.v$abastecimento_autorizacao aa
			   inner join kss.v$pessoa p 
					   on p.cod_pessoa = aa.cod_pessoa
					where 1=1
					<cfif Len(Trim(arguments.autorizacao_id))>
					  and aa.autorizacao_id = #arguments.autorizacao_id#
					</cfif>
					<cfif Len(Trim(arguments.lancto_id))>
					  and aa.lancto_id = #arguments.lancto_id#
					</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as cartas frete que teem RPA vinculado
	-- WAGNER  27/12/2006
	--->		
	<cffunction name="get_carta_frete_rpa" access="remote" returntype="query" output="true">
		<cfargument name="num_formulario" 	  		required="no"  default="">
		<cfargument name="DATA_EMISSAO" 	  		required="no" default="">
		<cfargument name="PROPRIETARIO_COD_PESSOA" 	required="yes" >
		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				    select 	ct.data_emissao,
             				ct.num_formulario,
             				ct.valor_frete_liquido,
             				ct.valor_frete_bruto,
             				ct.proprietario_cod_pessoa,
             				kss.pkg_global.fnc_busca_nome_pessoa(ct.proprietario_cod_pessoa) as proprietario_nome,
             				ct.num_rpa
        			  from oper.v$contrato_transp ct
  				inner join rh.rh_rpa rpa
          				on rpa.num_rpa = ct.num_rpa
					 where 1=1
				<cfif Len(Trim(arguments.num_formulario))>
					   and ct.num_formulario = #arguments.num_formulario#
				</cfif>
				<cfif Len(Trim(arguments.PROPRIETARIO_COD_PESSOA))>
					   and ct.PROPRIETARIO_COD_PESSOA = #arguments.PROPRIETARIO_COD_PESSOA#
				</cfif>
				<cfif Len(Trim(arguments.data_emissao))>
					   and ct.data_emissao like('#LSDateFormat(arguments.data_emissao,'dd/mm/yyyy')#%') 
				</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
			
	<!--- 
	-- PROPSITO 
	-- Busca os Negociadores
	-- LOUIS  16/0/2006
	--->		
	<cffunction name="get_negociador" access="remote" returntype="query" output="true">
	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select negociador_id,
			   negociador,
			   telefone,
			   email
		 from oper.v$negociador
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	


	<!--- 
	-- PROPSITO 
	-- Busca as cargas em aberto para cartas frete de coleta/entrega
	-- CRISTOFER  24/04/2007
	--->		
	<cffunction name="get_cargas_entrega" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.carga_id,
                   nvl2(con.num_conhecimento, con.num_conhecimento || '/' || con.serie, '') as num_conhecimento,
                   rem.cliente remetente,
                   cep.fnc_municipio_uf(c.coleta_municipio_id) origem,
                   dest.cliente destinatario,
                   cep.fnc_municipio_uf(c.entrega_municipio_id) destino,
                   ev.placa,
                   to_char(ev.data_agendamento,'dd/mm/yyyy hh24:mi:ss') data,
                   2 as operacao_id
              from oper.v$entrega e
             inner join oper.v$entrega_veiculo ev
                     on ev.entrega_id = e.entrega_id
             inner join oper.v$carga c
                     on c.carga_Id = e.carga_id
             inner join kss.v$pessoa rem
                     on rem.cod_pessoa = c.rem_cod_pessoa
             inner join kss.v$pessoa dest
                     on dest.cod_pessoa = c.dest_cod_pessoa
              left join oper.v$carga_ctrc cc
                     on cc.carga_id = c.carga_id
              left join fiscal.v$conhecimento con
                     on con.conhecimento_id = cc.conhecimento_id
             where 1=1
               and ev.data_cancelamento is null
               /* and data_entrega is not null */
            <cfif len(trim(arguments.placa))>
               and ev.placa = '#arguments.placa#'
            </cfif>
            <cfif len(trim(arguments.data_inicial))>
               and trunc(ev.data_agendamento) >= '#arguments.data_inicial#'
            </cfif>
            <cfif len(trim(arguments.data_final))>
               and trunc(ev.data_agendamento) <= '#arguments.data_final#'
            </cfif>
               and ev.data_agendamento >= to_date('01/07/2011','dd/mm/yyyy')
               and not exists (select 'x'
                                 from oper.v$contrato_transp_carga avc
                                where avc.carga_id = c.carga_id
                                  and avc.tipo_operacao = 2)
             order by ev.data_agendamento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca as coletas em aberto para a placa
	-- CRISTOFER  24/04/2007
	--->		
	<cffunction name="get_cargas_coleta" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.carga_id,
                   nvl2(con.num_conhecimento, con.num_conhecimento || '/' || con.serie, '') as num_conhecimento,
                   rem.cliente remetente,
                   cep.fnc_municipio_uf(c.coleta_municipio_id) origem,
                   dest.cliente destinatario,
                   cep.fnc_municipio_uf(c.entrega_municipio_id) destino,
                   cv.placa,
                   to_char(cl.data_pedido,'dd/mm/yyyy hh24:mi:ss')  data,
                   1 as operacao_id,
                   cl.num_coleta
              from oper.v$coleta cl
             inner join oper.v$coleta_veiculo cv
                     on cv.coleta_id = cl.coleta_id
             inner join oper.v$carga c
                     on c.carga_Id = cl.carga_id
             inner join kss.v$pessoa rem
                     on rem.cod_pessoa = c.rem_cod_pessoa
             inner join kss.v$pessoa dest
                     on dest.cod_pessoa = c.dest_cod_pessoa
              left join oper.v$carga_ctrc cc
                     on cc.carga_id = c.carga_id
              left join fiscal.v$conhecimento con
                     on con.conhecimento_id = cc.conhecimento_id
             where 1=1
               and cv.data_cancelamento is null
               /* and cv.data_confirmacao is not null */
            <cfif len(trim(arguments.placa))>
               and cv.placa = '#arguments.placa#'
            </cfif>
            <cfif len(trim(arguments.data_inicial))>
               and trunc(cl.data_pedido) >= '#arguments.data_inicial#'
            </cfif>
            <cfif len(trim(arguments.data_final))>
               and trunc(cl.data_pedido) <= '#arguments.data_final#'
            </cfif>
               and cl.data_pedido >= to_date('01/07/2011','dd/mm/yyyy')
               and not exists (select 'x'
                                 from oper.v$contrato_transp_carga avc
                                where avc.carga_id = c.carga_id
                                  and avc.tipo_operacao = 1)    
            order by cl.data_pedido
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os demais manifestos abertos de uma placa atravs de um manifesto
    -- ANDERSON 10/08/2009 - CRIADO
    --->		
    <cffunction name="get_manifestos_abertos_placa" access="remote" returntype="query" output="true">
        <cfargument name="num_manifesto" required="yes">
        <cfargument name="cod_pessoa_filial" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct m.manifesto_id,
                   m.num_manifesto,
                   m.cod_pessoa_filial,
                   (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = m.cod_pessoa_filial) as filial,
                   cep.fnc_municipio_uf(m.org_municipio_id) origem,
                   cep.fnc_municipio_uf(m.dest_municipio_id) destino,
                   to_char(m.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   to_char(m.data_termino, 'dd/mm/yyyy hh24:mi:ss') as data_termino,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(m.placa_tracao) frota_tracao,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(m.placa_reboque) frota_reboque,
                   m.situacao_id,
                   (select cg.rv_abbreviation
                      from oper.cg_ref_codes cg
                     where cg.rv_low_value = m.situacao_id
                       and cg.rv_domain = 'MANIFESTO.SITUACAO_ID') as situacao
              from oper.v$manifesto m
             inner join oper.v$manifesto_conhecimento mc
                     on mc.manifesto_id = m.manifesto_id
             inner join fiscal.v$conhecimento c
                     on c.conhecimento_id = mc.conhecimento_id
             where m.placa_tracao = (select m2.placa_tracao
                                       from oper.v$manifesto m2
                                      where m2.num_manifesto = #arguments.num_manifesto#)
               and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               and not exists (select 0
                                 from oper.v$contrato_transp ct
                                where ct.manifesto_id = m.manifesto_id
                                  and ct.data_cancelamento is null)
               and not exists (select 0
                                 from oper.v$romaneio r
                                inner join oper.v$contrato_transp ct
                                        on ct.num_romaneio = r.num_romaneio
                                where r.num_romaneio = c.num_romaneio
                                  and ct.data_cancelamento is null)
               and m.num_manifesto <> #arguments.num_manifesto#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca total receita romaneio
	--->
	<cffunction name="get_receita_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="NUM_ROMANEIO" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_contrato_transp.fnc_valor_contrato_receita(#arguments.NUM_ROMANEIO#) as valor_receita
		      from dual
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca usurios que possuem alada para liberao
	--->
	<cffunction name="get_alcada_liberacao_controle" access="remote" returntype="query" output="true">
		<cfargument name="OPERACAO" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct al.operacao, al.usuario, u.nome
              from oper.v$alcada_liberacao_controle al
             inner join kss.v$kss_usuarios u
                     on u.usuario = al.usuario 
            where al.valor_alcada > 0
            <cfif Len(Trim(arguments.OPERACAO)) >
              and al.operacao in (#ListQualify(arguments.operacao, "'", ",")#)
            </cfif>
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

    <!--- 
    -- PROPSITO 
    -- BUSCA LISTA DE CARTAS-FRETE QUE PRECISAM DE LIBERAO
    -- LEOPOLDOS 21/05/2010 - CRIADO
    --->		
    <cffunction name="get_cf_liberacao" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select ct.lancto_id
                     , (select p.cliente
                         from kss.v$pessoa p
                        where p.cod_pessoa = ct.cod_pessoa_filial) as Filial
                     , (select p.cliente
                          from kss.v$pessoa p
                         where p.cod_pessoa = ct.proprietario_cod_pessoa) as Proprietario
                     , (select p.cliente
                          from kss.v$pessoa p
                         where p.cod_pessoa = ct.motorista_cod_pessoa) as Motorista
                     , to_char(ct.data_emissao, 'dd/mm/yyyy') as data_emissao
                     , to_char(ct.data_liberacao, 'dd/mm/yyyy') as data_liberacao
                     , ct.valor_frete_bruto
                     , ct.valor_frete_liquido      
                     , ct.percentual_receita
                     , ro.frete_total
                     , ct.modalidade_veiculo
                     , case when ct.avulsa = 1 then 'Sim'
                       else 'No' end as avulsa
                     , ct.observacao
                     , co.total_conhecimento as total_conhecimento
                     , ro.frete_total as frete_total_romaneio
                     , ro.carregamento
                     , ro.destino
                     , ro.cliente
                from oper.v$contrato_transp ct
                left join fiscal.v$conhecimento co
                  on ct.conhecimento_id = co.conhecimento_id
                left join oper.v$romaneio ro
                  on ct.num_romaneio = ro.num_romaneio
               where 1=1 
                 and ct.data_liberacao is null
                 and ct.data_cancelamento is null
                 and ct.usuario_liberacao = user
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Verifica se usurio possui alada para liberao
	-- LEOPOLDOS 21/05/2010 - CRIADO
	--->
	<cffunction name="get_alcada_liberacao_controle_usuario" access="remote" returntype="query" output="true">
		<cfargument name="OPERACAO" required="no" default=""/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select distinct al.operacao, al.usuario, u.nome
              from oper.v$alcada_liberacao_controle al
             inner join kss.v$kss_usuarios u
                     on u.usuario = al.usuario 
            where al.valor_alcada > 0
              and al.usuario = user
            <cfif Len(Trim(arguments.OPERACAO)) >
              and al.operacao = '#arguments.OPERACAO#'
            </cfif>
		</cfquery>
	<cfreturn qr_result>
	</cffunction> 
    
    <!--- 
	-- PROPSITO 
	-- Busca CFI
	-- ERIC 30/07/2010
	--->		
	<cffunction name="get_pessoa_cfi" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pessoa_cfi_id
              from oper.v$pessoa_cfi p
             where p.cod_pessoa = '#arguments.cod_pessoa#'	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as cartas frete pendentes de aprovao
    -- ANDERSON 09/02/2010 - CRIADO
    --->		
    <cffunction name="get_contrato_transp_pendente_aprovacao" access="remote" returntype="query" output="true">
    	<cfargument name="pendente" required="no" default="" />
        <cfargument name="aprovada" required="no" default="" />
        <cfargument name="aprovada_data_inicial" required="no" default="" />
        <cfargument name="aprovada_data_final" required="no" default="" />
        <cfargument name="reprovada" required="no" default="" />
        <cfargument name="reprovada_data_inicial" required="no" default="" />
        <cfargument name="reprovada_data_final" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.lancto_id
                 , case
                      when t.num_formulario < 0 then ''
                      else to_char(t.num_formulario)
                   end as num_formulario
                 , decode(t.tipo_contrato, 0, 'TERCEIRO', 'AGREGADO') as tipo_contrato
                 , (select cg.rv_abbreviation
                      from oper.v$agreg_viagem av
                     inner join oper.cg_ref_codes cg
                        on cg.rv_domain = 'AGREG_VIAGEM.TIPO_SERVICO'
                       and cg.rv_low_value = av.tipo_servico
                     where av.lancto_id = t.lancto_id
                   ) as tipo_servico
                 , (select cg.rv_abbreviation
                      from oper.cg_ref_codes cg
             		 where cg.rv_domain = 'CONTRATO_TRANSP.TIPO_CARGA'
                       and cg.rv_low_value = t.tipo_carga
                   ) as tipo_carga
                 , t.num_romaneio
                 , (select r.carregamento
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as carregamento
                 , (select r.destino
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as destino
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = t.cod_pessoa_filial
                   ) as unidade_negocio
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = t.cod_departamento
                   ) as departamento
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = t.cod_setor
                   ) as setor
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = t.cod_centro_custo
                   ) as centro_custo
                 , t.cod_organograma_gerencial
                 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , t.peso
                 , t.cod_unidade
                 , t.volume
                 , t.m3
                 , t.frete_em
     			 , nvl(t.total_parcela, 1) as total_parcela
                 , t.valor_unitario
                 , t.valor_frete_bruto
                 , t.valor_frete_liquido
                 , oper.pkg_contrato_transporte.fnc_valor_frete_bruto_acum(t.lancto_id) as valor_frete_bruto_acum
                 , t.total_conhecimento
                 , t.ganho_bruto
                 , case
                      when t.total_conhecimento > 0 then
                         round((t.ganho_bruto / t.total_conhecimento) * 100, 2)
                      else 0
                   end as percentual_ganho_bruto
                 , oper.pkg_contrato_transporte.fnc_total_nf_es_frete(t.lancto_id) as total_nf_es_frete
                 , oper.pkg_contrato_transporte.fnc_total_crt(t.lancto_id) as total_crt
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_controle) as cod_veiculo_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_referencia) as cod_veiculo_referencia
                 , kss.pkg_pessoa.fnc_get_cliente(t.proprietario_cod_pessoa) as proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(t.motorista_cod_pessoa) as motorista
                 , t.rpa_id
                 , t.impresso
                 , decode(t.impresso, 1, 'Sim', 'No') as impresso_desc
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_cancelamento
                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , t.usuario_aprovacao
                 , to_char(t.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
                 , t.usuario_reprovacao
                 , to_char(t.data_reprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_reprovacao
                 , t.motivo_reprovacao
              from (
				<cfif Len(Trim(arguments.pendente)) and arguments.pendente eq 1>
                    select ct.lancto_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.tipo_carga
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.cod_organograma_gerencial
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
     					 , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , oper.pkg_contrato_transporte.fnc_total_conhecimento(ct.lancto_id) as total_conhecimento
                         , oper.pkg_contrato_transporte.fnc_ganho_bruto_conhecimento(ct.lancto_id) as ganho_bruto
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , ct.impresso
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                         , ct.usuario_aprovacao
                         , ct.data_aprovacao
                         , ct.usuario_reprovacao
                         , ct.data_reprovacao
                         , ct.motivo_reprovacao
                      from oper.v$contrato_transp_todos ct
                     where ct.num_formulario < 0
                       and ct.lancto_id_pai is null
                       and ct.data_cancelamento is null
                       and ct.data_aprovacao is null
                       and ct.data_reprovacao is null
                       and (exists (select 1
                                      from oper.v$contrato_transp_liberacao ctl
                                     where ctl.cod_pessoa_filial = ct.cod_pessoa_filial
                                       and ctl.usuario = user
                                   ) or
                            exists (select 1
                                      from oper.v$contrato_transp_liberacao ctl
                                     where ctl.cod_pessoa_filial is null
                                       and ctl.usuario = user
                                   )
                           )
				</cfif>
				<cfif (Len(Trim(arguments.pendente)) and arguments.pendente eq 1) and (Len(Trim(arguments.aprovada)) and arguments.aprovada eq 1)>
                     union all
				</cfif>
                <cfif Len(Trim(arguments.aprovada)) and arguments.aprovada eq 1>
                    select ct.lancto_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.tipo_carga
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.cod_organograma_gerencial
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
     					 , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , oper.pkg_contrato_transporte.fnc_total_conhecimento(ct.lancto_id) as total_conhecimento
                         , oper.pkg_contrato_transporte.fnc_ganho_bruto_conhecimento(ct.lancto_id) as ganho_bruto
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , ct.impresso
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                         , ct.usuario_aprovacao
                         , ct.data_aprovacao
                         , ct.usuario_reprovacao
                         , ct.data_reprovacao
                         , ct.motivo_reprovacao
                      from oper.v$contrato_transp_todos ct
                     where ct.lancto_id_pai is null
                       and (ct.usuario_aprovacao = user
                            or (ct.usuario_aprovacao is not null
                                and exists (select 1
                                              from oper.v$contrato_transp_liberacao ctl
                                             where ctl.cod_pessoa_filial is null
                                               and ctl.usuario = user
                                           )
                               )
                           )
					<cfif Len(Trim(arguments.aprovada_data_inicial)) and Len(Trim(arguments.aprovada_data_final))>
                       and ct.data_aprovacao between to_date('#arguments.aprovada_data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.aprovada_data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                    <cfelseif Len(Trim(arguments.aprovada_data_inicial))>
                       and ct.data_aprovacao >= to_date('#arguments.aprovada_data_inicial#', 'dd/mm/yyyy')
                    <cfelseif Len(Trim(arguments.aprovada_data_final))>
                       and ct.data_aprovacao <= to_date('#arguments.aprovada_data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
					</cfif>
				</cfif>
                <cfif ((Len(Trim(arguments.pendente)) and arguments.pendente eq 1) or (Len(Trim(arguments.aprovada)) and arguments.aprovada eq 1)) and (Len(Trim(arguments.reprovada)) and arguments.reprovada eq 1)>
                     union all
				</cfif>
                <cfif Len(Trim(arguments.reprovada)) and arguments.reprovada eq 1>
                    select ct.lancto_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.tipo_carga
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.cod_organograma_gerencial
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
     					 , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , oper.pkg_contrato_transporte.fnc_total_conhecimento(ct.lancto_id) as total_conhecimento
                         , oper.pkg_contrato_transporte.fnc_ganho_bruto_conhecimento(ct.lancto_id) as ganho_bruto
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , ct.impresso
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                         , ct.usuario_aprovacao
                         , ct.data_aprovacao
                         , ct.usuario_reprovacao
                         , ct.data_reprovacao
                         , ct.motivo_reprovacao
                      from oper.v$contrato_transp_todos ct
                     where ct.lancto_id_pai is null
                       and (ct.usuario_reprovacao = user
                            or (ct.usuario_reprovacao is not null
                                and exists (select 1
                                              from oper.v$contrato_transp_liberacao ctl
                                             where ctl.cod_pessoa_filial is null
                                               and ctl.usuario = user
                                           )
                               )
                           )
					<cfif Len(Trim(arguments.reprovada_data_inicial)) and Len(Trim(arguments.reprovada_data_final))>
                       and ct.data_reprovacao between to_date('#arguments.reprovada_data_inicial#', 'dd/mm/yyyy') and to_date('#arguments.reprovada_data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                    <cfelseif Len(Trim(arguments.reprovada_data_inicial))>
                       and ct.data_reprovacao >= to_date('#arguments.reprovada_data_inicial#', 'dd/mm/yyyy')
                    <cfelseif Len(Trim(arguments.reprovada_data_final))>
                       and ct.data_reprovacao <= to_date('#arguments.reprovada_data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
					</cfif>
				</cfif>
                   ) t
             order by t.data_emissao, t.lancto_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as cartas frete pendentes de aprovao
    -- ANDERSON 09/02/2010 - CRIADO
    --->		
    <cffunction name="get_contrato_transp_nao_impressa" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.lancto_id
                 , case
                      when t.num_formulario < 0 then ''
                      else to_char(t.num_formulario)
                   end as num_formulario
                 , decode(t.tipo_contrato, 0, 'TERCEIRO', 'AGREGADO') as tipo_contrato
                 , (select cg.rv_abbreviation
                      from oper.v$agreg_viagem av
                     inner join oper.cg_ref_codes cg
                             on cg.rv_domain = 'AGREG_VIAGEM.TIPO_SERVICO'
                            and cg.rv_low_value = av.tipo_servico
                     where av.lancto_id = t.lancto_id
                   ) as tipo_servico
                 , (select cg.rv_abbreviation
                      from oper.cg_ref_codes cg
                     where cg.rv_domain = 'CONTRATO_TRANSP.TIPO_CARGA'
                       and cg.rv_low_value = t.tipo_carga
                   ) as tipo_carga
                 , t.num_romaneio
                 , (select r.carregamento
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as carregamento
                 , (select r.destino
                      from oper.v$romaneio r
                     where r.num_romaneio = t.num_romaneio 
                   ) as destino
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = t.cod_pessoa_filial
                   ) as unidade_negocio
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = t.cod_departamento
                   ) as departamento
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = t.cod_setor
                   ) as setor
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = t.cod_centro_custo
                   ) as centro_custo
                 , t.cod_organograma_gerencial
                 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , t.peso
                 , t.cod_unidade
                 , t.volume
                 , t.m3
                 , t.frete_em
                 , t.lancto_id_pai
                 , nvl(t.parcela, 1) as parcela
                 , nvl(t.total_parcela, 1) as total_parcela
                 , t.valor_unitario
                 , t.valor_frete_bruto
                 , t.valor_frete_liquido
                 , oper.pkg_contrato_transporte.fnc_valor_frete_bruto_acum(t.lancto_id) as valor_frete_bruto_acum
                 , t.total_conhecimento
                 , t.ganho_bruto
                 , case
                      when t.total_conhecimento > 0 then
                         round((t.ganho_bruto / t.total_conhecimento) * 100, 2)
                      else 0
                   end as percentual_ganho_bruto
                 , oper.pkg_contrato_transporte.fnc_total_nf_es_frete(t.lancto_id) as total_nf_es_frete
                 , oper.pkg_contrato_transporte.fnc_total_crt(t.lancto_id) as total_crt
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_controle) as cod_veiculo_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa_referencia) as cod_veiculo_referencia
                 , kss.pkg_pessoa.fnc_get_cliente(t.proprietario_cod_pessoa) as proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(t.motorista_cod_pessoa) as motorista
                 , t.rpa_id
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_aprovacao
                 , to_char(t.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
                 , t.usuario_reprovacao
                 , to_char(t.data_reprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_reprovacao
                 , t.motivo_reprovacao
              from (
                    select ct.lancto_id
                         , ct.num_formulario
                         , ct.tipo_contrato
                         , ct.tipo_carga
                         , ct.num_romaneio
                         , ct.cod_pessoa_filial
                         , ct.cod_departamento
                         , ct.cod_setor
                         , ct.cod_centro_custo
                         , ct.cod_organograma_gerencial
                         , ct.data_emissao
                         , ct.peso
                         , ct.cod_unidade
                         , ct.volume
                         , ct.m3
                         , ct.frete_em
                         , ct.lancto_id_pai
                         , ct.parcela
                         , ct.total_parcela
                         , ct.valor_unitario
                         , ct.valor_frete_bruto
                         , ct.valor_frete_liquido
                         , oper.pkg_contrato_transporte.fnc_total_conhecimento(ct.lancto_id) as total_conhecimento
                         , oper.pkg_contrato_transporte.fnc_ganho_bruto_conhecimento(ct.lancto_id) as ganho_bruto
                         , ct.placa_controle
                         , ct.placa_referencia
                         , ct.proprietario_cod_pessoa
                         , ct.motorista_cod_pessoa
                         , ct.rpa_id
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_aprovacao
                         , ct.data_aprovacao
                         , ct.usuario_reprovacao
                         , ct.data_reprovacao
                         , ct.motivo_reprovacao
                      from oper.v$contrato_transp_todos ct
                     where ct.impresso = 0
                       and ct.data_cancelamento is null
                       and ct.cod_pessoa_filial = #session.cod_pessoa#
                       and ct.data_emissao >= to_date('10/05/2011', 'dd/mm/yyyy')
                   ) t
             order by t.data_emissao, t.lancto_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os conhecimentos (CTRCs) de uma carta frete
    -- ANDERSON 22/03/2010 - CRIADO
    --->		
    <cffunction name="get_conhecimentos_carta_frete" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
                 , c.num_conhecimento
                 , c.serie
                 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = c.cod_pessoa_filial
                   ) as unidade_negocio
                 , (select d.descricao
                      from kss.v$departamento d
                     where d.cod_departamento = c.cod_departamento
                   ) as departamento
                 , (select s.descricao
                      from kss.v$setor s
                     where s.cod_setor = c.cod_setor
                   ) as setor
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = c.cod_centro_custo
                   ) as centro_custo
                 , c.total_conhecimento
              from oper.v$contrato_transp_ctrc ctc
             inner join fiscal.v$conhecimento c
                     on c.conhecimento_id = ctc.conhecimento_id
             where ctc.lancto_id = #arguments.lancto_id#
             order by c.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de carga de uma carta frete de terceiro
    -- ANDERSON 25/03/2010 - CRIADO
    --->		
    <cffunction name="get_tipo_carga" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_low_value as tipo_carga
                 , cg.rv_abbreviation as descricao
              from oper.cg_ref_codes cg
             where cg.rv_domain = 'CONTRATO_TRANSP.TIPO_CARGA'
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os valores disponveis para uma carta frete
	-- ANDERSONC 24/06/2011 09:54:00 - CRIADO
	--->
	<cffunction name='valores_contrato' displayname='Retorna os valores disponveis para uma carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CRT_ID_DIARIA' required='yes'>
		<cfargument name='DIVISAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_contrato_transp.prc_valores_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CRT_ID_DIARIA'  value='#arguments.CRT_ID_DIARIA#'  null='#iif(len(trim(arguments.CRT_ID_DIARIA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DIVISAO_ID'  value='#arguments.DIVISAO_ID#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_RECEITA' variable='retorno.VALOR_RECEITA' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_CF_ACUMULADO' variable='retorno.VALOR_CF_ACUMULADO' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MAXIMO' variable='retorno.VALOR_MAXIMO' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os veculos de um romaneio
    -- ANDERSON 14/09/2011 - CRIADO
    --->		
    <cffunction name="get_veiculos_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rhv.placa_controle
                 , rhv.placa_referencia
                 , to_char(rhv.data_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_inicio
                 , (select max(c.cartao_numero) keep(dense_rank last order by ct.date_insert)
                      from repom.v$contrato ct
                     inner join repom.v$cartao c
                             on c.cartao_id = ct.cartao_id
                     where ct.cod_motorista = rhv.cod_pessoa
                       and ct.data_cancelamento is null
                   ) as cartao_numero_historico
              from oper.v$romaneio_hist_veiculo rhv
             where rhv.num_romaneio = #arguments.num_romaneio#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>