<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Lista os lancamentos contabeis 
	-- CRISTOFER  09/06/2006
	--->		
	<cffunction name="get_lancamentos_contabeis" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="num_documento" required="no" default="">
		<cfargument name="class_contab" required="no" default="">
		<cfargument name="ano_plano" required="no" default="">
		<cfargument name="cod_reduzido" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			Select /*+ First_rows */ It.Num_lancamento_it,
				   It.Cod_reduzido,
				   It.Ano_plano,
				   It.Num_lancamento,
				   L.Data_lancamento,
				   to_char(L.Num_documento) as num_documento,
				   Un.Cod_unidade_negocio,
				   Un.Unidade_negocio,
				   It.Cod_departamento,
				   (select Depto.Descricao Departamento from Kss.V$departamento Depto where It.Cod_departamento = Depto.Cod_departamento) Departamento,
				   It.Cod_setor,
				   (select St.Descricao Setor from Kss.V$setor St where It.Cod_setor = St.Cod_setor) Setor,
				   It.Cod_centro_custo,
				   (select Cc.Centro_custo Centro_custo from Kss.V$centro_custo Cc where It.Cod_centro_custo = Cc.Cod_centro_custo) Centro_custo,
				   It.Cod_pessoa,
				   It.Valor_debito,
				   It.Valor_credito,
				   It.Historico,
				   Pc.Descricao Conta,
				   It.user_insert, it.date_insert, it.user_update, it.date_update,
				   lpad(pc.grau1, length(mpc.GRAU1_MASK), '0')||decode(pc.grau2, null, null, '.'||lpad(pc.grau2, length(mpc.GRAU2_MASK), '0'))
						||decode(pc.grau3, null, null, '.'||lpad(pc.grau3, length(mpc.GRAU3_MASK), '0'))
						||decode(pc.grau4, null, null, '.'||lpad(pc.grau4, length(mpc.GRAU4_MASK), '0'))
						||decode(pc.grau5, null, null, '.'||lpad(pc.grau5, length(mpc.GRAU5_MASK), '0'))
						||decode(pc.grau6, null, null, '.'||lpad(pc.grau6, length(mpc.GRAU6_MASK), '0'))
						||decode(pc.grau7, null, null, '.'||lpad(pc.grau7, length(mpc.GRAU7_MASK), '0'))
						||decode(pc.grau8, null, null, '.'||lpad(pc.grau8, length(mpc.GRAU8_MASK), '0'))
						||decode(pc.grau9, null, null, '.'||lpad(pc.grau9, length(mpc.GRAU9_MASK), '0')) as class_contab
			  from Contab.V$contab_lancamento_it It,
				   Contab.V$contab_plano_de_contas Pc,
				   Contab.V$contab_modelo_plano_contas mpc,
				   Contab.V$contab_lancamento L,
				   Kss.V$unidade_negocio Un,
				   contab.v$orc_organograma_usuario ou
				   
			 where It.Num_lancamento = L.Num_lancamento
				   and It.Ano_plano = Pc.Ano_plano
				   and It.Cod_reduzido = Pc.Cod_reduzido
				   and Pc.Cod_modelo = mpc.cod_modelo
				   and It.Cod_pessoa = Un.Cod_pessoa
				   and it.cod_pessoa = ou.cod_pessoa
				   and it.cod_departamento = ou.cod_departamento
				   and it.cod_setor = ou.cod_setor
				   and it.cod_centro_custo = ou.cod_centro_custo
				 <cfif len(trim(arguments.class_contab))>
				   and lpad(pc.grau1, length(mpc.GRAU1_MASK), '0')||decode(pc.grau2, null, null, '.'||lpad(pc.grau2, length(mpc.GRAU2_MASK), '0'))
						||decode(pc.grau3, null, null, '.'||lpad(pc.grau3, length(mpc.GRAU3_MASK), '0'))
						||decode(pc.grau4, null, null, '.'||lpad(pc.grau4, length(mpc.GRAU4_MASK), '0'))
						||decode(pc.grau5, null, null, '.'||lpad(pc.grau5, length(mpc.GRAU5_MASK), '0'))
						||decode(pc.grau6, null, null, '.'||lpad(pc.grau6, length(mpc.GRAU6_MASK), '0'))
						||decode(pc.grau7, null, null, '.'||lpad(pc.grau7, length(mpc.GRAU7_MASK), '0'))
						||decode(pc.grau8, null, null, '.'||lpad(pc.grau8, length(mpc.GRAU8_MASK), '0'))
						||decode(pc.grau9, null, null, '.'||lpad(pc.grau9, length(mpc.GRAU9_MASK), '0')) like '#arguments.class_contab#%'
				 </cfif>
				 <cfif len(trim(arguments.cod_centro_custo))>
				   and It.Cod_centro_custo in (#arguments.cod_centro_custo#)
				 </cfif>
				 <cfif len(trim(arguments.ano_plano))>
				   and pc.ano_plano = '#arguments.ano_plano#'
				 </cfif>
				 <cfif len(trim(arguments.cod_reduzido))>
				   and pc.cod_reduzido in (#arguments.cod_reduzido#)
				 </cfif>
				 <cfif len(trim(arguments.data_inicial))>
			       and trunc(l.data_lancamento) >= '#arguments.data_inicial#'
				 </cfif>
				 <cfif len(trim(arguments.data_final))>
			       and trunc(l.data_lancamento) <= '#arguments.data_final#'
				 </cfif>
				 <cfif len(trim(arguments.num_documento))>
			       and l.num_documento = #arguments.num_documento#
				 </cfif>
			 order by l.num_lancamento, it.num_lancamento_it, l.data_lancamento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os planos de contas
	-- CRISTOFER  09/06/2006
	--->		
	<cffunction name="get_plano_de_contas" access="remote" returntype="query" output="true">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="apelido" required="no" default="">
		<cfargument name="ano_plano" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ano_plano,
				   cod_reduzido,
				   descricao,
				   grau1,
				   grau2,
				   grau3,
				   grau4,
				   grau5,
				   grau6,
				   grau7,
				   grau8,
				   grau9,
				   cod_modelo,
				   user_insert,
				   date_insert
				   orc_contrapartida,
				   cod_operacao,
				   orc_descricao,
				   cod_historico,
				   natureza,
				   apelido
			  from contab.v$contab_plano_de_contas
			 where 1=1
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 <cfif len(trim(arguments.apelido))>
			   and upper(apelido) in (#ListQualify(arguments.apelido, "'", ",")#)
			 </cfif>
			 <cfif len(trim(arguments.ano_plano))>
			   and ano_plano in (#arguments.ano_plano#)
			 </cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca os centros de custo
	-- CRISTOFER  09/06/2006
	--->		
	<cffunction name="get_centro_custo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.cod_centro_custo,
				   t.centro_custo,
				   t.date_insert,
				   t.user_insert,
				   t.date_update,
				   t.user_update 
			  from kss.v$centro_custo t	
			 where 1=1
			 order by centro_custo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>			
	
	<!--- 
	-- PROPSITO 
	-- Busca os lancamentos orcamentarios
	-- CRISTOFER  09/06/2006
	--->		
	<cffunction name="get_lancamentos_orcamentarios" access="remote" returntype="query" output="true">
		<cfargument name="class_contab" required="no" default="">
		<cfargument name="ano_plano" required="no" default="">
		<cfargument name="cod_reduzido" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="ano" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ol.ano_plano,
				   ol.cod_reduzido,
				   ol.cod_pessoa,
				   ol.cod_departamento,
				   ol.cod_setor,
				   ol.cod_centro_custo,
				   (select cc.centro_custo from kss.v$centro_custo cc where cc.cod_centro_custo = ou.cod_centro_custo) centro_custo,
				   pc.descricao as conta,
				   ol.val_01,
				   ol.qtd_01,
				   ol.mem_01,
				   ol.val_02,
				   ol.qtd_02,
				   ol.mem_02,
				   ol.val_03,
				   ol.qtd_03,
				   ol.mem_03,
				   ol.val_04,
				   ol.qtd_04,
				   ol.mem_04,
				   ol.val_05,
				   ol.qtd_05,
				   ol.mem_05,
				   ol.val_06,
				   ol.qtd_06,
				   ol.mem_06,
				   ol.val_07,
				   ol.qtd_07,
				   ol.mem_07,
				   ol.val_08,
				   ol.qtd_08,
				   ol.mem_08,
				   ol.val_09,
				   ol.qtd_09,
				   ol.mem_09,
				   ol.val_10,
				   ol.qtd_10,
				   ol.mem_10,
				   ol.val_11,
				   ol.qtd_11,
				   ol.mem_11,
				   ol.val_12,
				   ol.qtd_12,
				   ol.mem_12,
				   ol.cod_unidade_medida,
				   ol.user_insert,
				   ol.date_insert,
				   ol.user_update,
				   ol.date_update,
				   lpad(pc.grau1, length(mpc.GRAU1_MASK), '0')||decode(pc.grau2, null, null, '.'||lpad(pc.grau2, length(mpc.GRAU2_MASK), '0'))
									||decode(pc.grau3, null, null, '.'||lpad(pc.grau3, length(mpc.GRAU3_MASK), '0'))
									||decode(pc.grau4, null, null, '.'||lpad(pc.grau4, length(mpc.GRAU4_MASK), '0'))
									||decode(pc.grau5, null, null, '.'||lpad(pc.grau5, length(mpc.GRAU5_MASK), '0'))
									||decode(pc.grau6, null, null, '.'||lpad(pc.grau6, length(mpc.GRAU6_MASK), '0'))
									||decode(pc.grau7, null, null, '.'||lpad(pc.grau7, length(mpc.GRAU7_MASK), '0'))
									||decode(pc.grau8, null, null, '.'||lpad(pc.grau8, length(mpc.GRAU8_MASK), '0'))
									||decode(pc.grau9, null, null, '.'||lpad(pc.grau9, length(mpc.GRAU9_MASK), '0')) as class_contab
			  from contab.v$orc_lancamento ol
			 inner join contab.v$contab_plano_de_contas pc
					 on pc.ano_plano = ol.ano_plano
					and pc.cod_reduzido = ol.cod_reduzido
			 inner join contab.v$contab_modelo_plano_contas mpc
					 on mpc.cod_modelo = pc.cod_modelo    
			 inner join contab.v$orc_organograma_usuario ou
			         on ou.cod_pessoa = ol.cod_pessoa
					and ou.cod_departamento = ol.cod_departamento
					and ou.cod_setor = ol.cod_setor
					and ou.cod_centro_custo = ol.cod_centro_custo
			 where 1=1  
				<cfif len(trim(arguments.class_contab))>
				   and lpad(pc.grau1, length(mpc.GRAU1_MASK), '0')||decode(pc.grau2, null, null, '.'||lpad(pc.grau2, length(mpc.GRAU2_MASK), '0'))
						||decode(pc.grau3, null, null, '.'||lpad(pc.grau3, length(mpc.GRAU3_MASK), '0'))
						||decode(pc.grau4, null, null, '.'||lpad(pc.grau4, length(mpc.GRAU4_MASK), '0'))
						||decode(pc.grau5, null, null, '.'||lpad(pc.grau5, length(mpc.GRAU5_MASK), '0'))
						||decode(pc.grau6, null, null, '.'||lpad(pc.grau6, length(mpc.GRAU6_MASK), '0'))
						||decode(pc.grau7, null, null, '.'||lpad(pc.grau7, length(mpc.GRAU7_MASK), '0'))
						||decode(pc.grau8, null, null, '.'||lpad(pc.grau8, length(mpc.GRAU8_MASK), '0'))
						||decode(pc.grau9, null, null, '.'||lpad(pc.grau9, length(mpc.GRAU9_MASK), '0')) like '#arguments.class_contab#%'
				 </cfif>
				 <cfif len(trim(arguments.cod_centro_custo))>
				   and ol.Cod_centro_custo in (#arguments.cod_centro_custo#)
				 </cfif>
				 <cfif len(trim(arguments.ano_plano))>
				   and pc.ano_plano = '#arguments.ano_plano#'
				 </cfif>
				 <cfif len(trim(arguments.ano))>
				   and pc.ano_plano = '#arguments.ano#'
				 </cfif>
				 <cfif len(trim(arguments.cod_reduzido))>
				   and pc.cod_reduzido in (#arguments.cod_reduzido#)
				 </cfif>					  
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	 

	<!--- 
	-- PROPSITO 
	-- Busca os conhecimentos 
	-- CRISTOFER  04/10/2006
	--->		
	<cffunction name="get_rel_conf_fisco_contabil_viagem" access="remote" returntype="query" output="true">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="modalidade" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="tipo_venda" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.COD_CENTRO_CUSTO_GERENCIAL COD_CENTRO_CUSTO,
		           t.centro_custo_gerencial centro_custo,
				   t.modalidade,
				   case
					 when t.modalidade = 11 then 'Frota'
					 when t.modalidade = 23 then 'Agregado'
					 when t.modalidade = 21 then 'Carreteiro'
					 else ''
				   end modalidade_descricao,
				   c.placa as veiculo,
				   max(c.data_emissao) data_emissao,
				   min(c.data_emissao) data_emissao_min,
				   sum(t.ganho2) ganho2,
				   sum(c.km_rota + t.km_vazio) as km_total,
				   sum(c.total_conhecimento) total_frete,
				   sum(t.outros) outros,
				   sum(t.credito_pis_cofins) credito_pis_cofins,
				   sum(case
					 when modalidade = 11 then t.custo_fr + t.custo_ge
					 else 0
				   end) custo_frota,
				   sum(case
					 when modalidade = 21 then t.custo_fr + t.custo_ge
					 else 0
				   end) custo_carreteiro,
				   sum(case
					 when modalidade = 23 then t.ps_agregado /* t.custo_fr + t.custo_ge */
					 else 0
				   end) custo_agregado,
				   sum(t.seg_pedagio) seg_pedagio,
				   0 ganho3,
				   0 result_cia,
				   t.viagem,
				   count(*) as conhecimentos,
              	   sum(t.icms_fr + t.icms_ge) as icms,
				   t.tipo_venda,
				   case tipo_venda
				     when 1then 'Geral'
					 when 2 then 'Fracionado'
					 else ''
				   end tipo_venda_descricao,
			      nvl(sum(nvl(t.pis_fr,0) + nvl(t.pis_ge,0) + nvl(t.cofins_fr,0) + nvl(t.cofins_ge,0) + nvl(t.credito_pis_cofins,0)),0) as pis_cofins
			  from fiscal.v$conhecimento_outros_dados t
			 inner join fiscal.v$conhecimento c
					 on c.conhecimento_id = t.conhecimento_id
			 where 1=1
			   and c.situacao_id = 0
			 <cfif len(trim(arguments.modalidade))>
			   and t.modalidade in (#arguments.modalidade#)
			 </cfif>
			 <cfif len(trim(arguments.tipo_venda))>
			   and t.tipo_venda in (#arguments.tipo_venda#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.cod_centro_custo))>
			   and t.cod_centro_custo_gerencial in (#arguments.cod_centro_custo#)
			 </cfif>
			 group by t.cod_centro_custo_gerencial, t.viagem, t.modalidade, t.centro_custo_gerencial, c.placa, t.viagem, t.tipo_venda 
			 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os conhecimentos 
	-- CRISTOFER  04/10/2006
	--->		
	<cffunction name="get_rel_conf_fisco_contabil" access="remote" returntype="query" output="true">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="modalidade" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="tipo_venda" required="no" default="">
		<cfargument name="viagem" required="no" default="">
		<cfargument name="veiculo" required="no" default="">
		<cfargument name="data_emissao" required="no" default="">
		<cfargument name="data_emissao_min" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ first_rows */ 
					   c.num_conhecimento,
					   c.data_emissao,
				   rem.cliente as remetente,
				   dest.cliente as destinatario,
				   c.total_conhecimento total_frete,
				   t.icms_fr + t.icms_ge icms
				  from fiscal.v$conhecimento_outros_dados t
				 inner join fiscal.v$conhecimento c
						 on c.conhecimento_id = t.conhecimento_id
			  left join kss.v$pessoa rem
					  on rem.cod_pessoa = c.COD_REMETENTE
			  left join kss.v$pessoa dest
					  on dest.cod_pessoa = c.COD_DESTINATARIO
			 where 1=1
			   and c.situacao_id = 0
			 <cfif len(trim(arguments.viagem))>
			    <cfif arguments.viagem eq "-">
	            and replace(viagem,' ','') is null
				<cfelse>
	            and replace(viagem,' ','') = '#Replace(arguments.viagem,' ','','all')#'
				</cfif>
			 </cfif>
			 <cfif len(trim(arguments.modalidade))>
			   and t.modalidade in (#arguments.modalidade#)
			 </cfif>
			 <cfif len(trim(arguments.tipo_venda))>
			   and t.tipo_venda in (#arguments.tipo_venda#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and c.data_emissao >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and c.data_emissao <= '#arguments.data_final#'
			 </cfif>
			 <cfif len(trim(arguments.data_emissao))>
			   and trunc(c.data_emissao) <= '#arguments.data_emissao#'
			 </cfif>
			 <cfif len(trim(arguments.data_emissao_min))>
			   and trunc(c.data_emissao) >= '#arguments.data_emissao_min#'
			 </cfif>
			 <cfif len(trim(arguments.placa))>
			   and c.placa = '#arguments.placa#'
			 </cfif>
			 <cfif len(trim(arguments.cod_centro_custo))>
			   and t.cod_centro_custo_gerencial in (#arguments.cod_centro_custo#)
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca conta contabil
	-- CRISTOFER  09/06/2006
	--->		
	<cffunction name="get_cod_contabil" access="remote" returntype="query" output="true">
    	<cfargument name="apelido" required="no" default="">
    	<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select cod_reduzido, descricao
                 , contab.pkg_contab.classificacao(grau1,grau2,grau3,grau4,grau5,grau6,grau7,grau8,grau9,cod_modelo) as classificacao
                 , ano_plano, cod_modelo, apelido
              from contab.v$contab_plano_de_contas pc
             where 1=1
               <cfif Len(Trim(arguments.apelido))>
                 and upper(apelido) like upper('#arguments.apelido#')
               </cfif>
               <cfif Len(Trim(arguments.descricao))>
                 and upper(descricao) like upper('#arguments.descricao#%')
               </cfif>
               and pc.ano_plano = (select max(ano_plano) from contab.v$contab_plano_de_contas)
             order by upper(descricao)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	    
		 	
</cfcomponent>