<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos em CC
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  20/02/2006
	--->
	<cffunction name="get_lancamentos" displayname="Buscas os lanamentos feitos pelo usurio" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" 	required="no">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" 	required="no">
		<cfquery datasource="#session.dsn#" name="qr_lancamento" username="#session.usuario#" password="#session.senha#">
				select num_lancamento, descricao_documento, cod_funcionario, favorecido, 
					   num_documento, data_lancamento, historico, valor_lancamento, deb_cred, 
					   data_vencto, user_insert
				 from (SELECT /*+ RULE */ 
				 			  case 
							    when cc.user_insert in ('ADMINTRANSP','VALE','SENTINELA','OPER','RASTREADOR') then 'AUTO'
							    when cc.user_insert in ('FUNC_MOTORISTA') then 'MOTORISTA'								
								else cc.user_insert end user_insert,cc.num_lancamento, ccd.descricao_documento, 
							  mr.cod_registro as cod_funcionario, cc.favorecido,          
							  cc.num_documento, cc.data_lancamento, cc.historico,          
							  cc.valor_lancamento, decode(cc.cod_documento, 373, 'Pagamento',decode(cc.deb_cred,0,'Dbito','Crdito')) as deb_cred, cc.data_vencto
					     FROM oper.v$ccorrente c 
					    inner join oper.v$ccorrente_lancamento cc 
						        on cc.cod_conta = c.cod_conta
							   and c.modalidade_id = 9 
							   and c.ativo = 1
					    inner join oper.v$ccorrente_documento ccd 
								on cc.cod_documento = ccd.cod_documento    							    
							   and ccd.deb_cred = 0
					    inner join oper.v$motorista_reg_historico mr
							    on mr.cod_pessoa = c.cod_pessoa
							   and mr.data_fim is null        
					    where ccd.cod_documento not in (373)     
					    <cfif isDefined("arguments.cod_pessoa")>
					      and c.cod_pessoa = #arguments.cod_pessoa#
					    </cfif>
			   <cfif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
						order by cc.favorecido, data_lancamento) 
					where trunc(data_lancamento) between '#arguments.data_inicial#' and '#arguments.data_final#'
			   <cfelseif not  isDefined("arguments.cod_pessoa")>
			       and cc.user_insert = user
					order by num_lancamento desc) 
				where rownum < 6  
			   </cfif>
   		</cfquery>
		<cfreturn qr_lancamento>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos em CC
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  20/02/2006
	--->
	<cffunction name="get_lancamento_espefico" displayname="Buscas os lanamentos feitos pelo usurio" access="remote" returntype="query" output="true">
		<cfargument name="num_lancamento" 	required="no">
		<cfquery datasource="#session.dsn#" name="qr_lancamento" username="#session.usuario#" password="#session.senha#">
				select num_lancamento
                     , cod_conta
                     , cod_pessoa_un
                     , cod_documento
                     , num_documento
                     , data_lancamento
                     , data_vencto
                     , historico
                     , valor_lancamento
                     , deb_cred
                     , favorecido
                
                from finan.v$ccorrente_lancamento cl
               where 1=1
			   <cfif len(trim("arguments.num_lancamento")) >
					and num_lancamento = '#arguments.num_lancamento#'
			   </cfif>
   		</cfquery>
		<cfreturn qr_lancamento>
	</cffunction>
    
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os lanamentos em CC do perodo para o funcionrio passado.
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  20/02/2006
	--->
	<cffunction name="get_lancamentos_extrato" displayname="Busca todos os lanamentos em CC do perodo para o funcionrio passado." access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="yes" />
		<cfargument name="data_inicial" required="no" default="Now()" />		
		<cfargument name="data_final" required="no" default="Now()" />		
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select * 
			  from (
					SELECT t.cod_documento, decode(t.user_insert,'INTEGRACAO_VALE','VALE','FUNC_MOTORISTA','MOTORISTA','SENTINELA','AUTO','OPER','AUTO','RASTREADOR','AUTO',t.user_insert) as usuario,          
						   t.data_vencto, t.num_lancamento, t.num_documento,                              
						   t.data_lancamento, t.historico, decode(t.deb_cred, 1, 'C','D') as d_c,
						   decode(t.cod_documento,373,'Pagto',decode(t.deb_cred, 1, 'Crdito','Dbito')) as d_c_p,                            
						   round(t.valor_lancamento,1) as valor_lancamento, nvl(pl.placa,'------------') as placa,
						   rank() over (partition by cc.cod_pessoa order by cc.cod_conta desc) as rank
					  FROM oper.v$ccorrente_lancamento t, 
						   oper.v$pedagio_lancto pl, 
						   oper.v$ccorrente cc,
						   oper.v$motorista_reg_historico mrh   
					  WHERE cc.cod_pessoa = mrh.cod_pessoa
						and mrh.cod_registro = #arguments.cod_funcionario#
						and mrh.data_inicio = (select max(mrh2.data_inicio)
												 from oper.v$motorista_reg_historico mrh2
												where mrh2.cod_pessoa = mrh.cod_pessoa)
						and trunc(t.data_vencto) between to_date('#Arguments.data_inicial#','dd/mm/yyyy')  and to_date('#Arguments.data_final#','dd/mm/yyyy')       
						and pl.num_lancto_ccorrente (+) = t.num_lancamento     
						and cc.cod_conta = t.cod_conta
						and cc.modalidade_id = 9 )
				where rank = 1
			  ORDER BY data_vencto, num_lancamento
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca a posio do motorista no rank ou todo o rank
	-- CRISTOFER  20/02/2006
	--->	
	<cffunction name="get_notas" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_notas" username="#session.usuario#" password="#session.senha#" blockfactor="20">
			select mr.cod_funcionario, mr.nome_funcionario, 
				   mr.mes, mr.ano, mr.nota, mr.dias_trabalhados,
				   (count(*) over(partition by mr.nome_funcionario order by mr.nome_funcionario )) as total_notas
			  from oper.motorista_rank mr
			 inner join oper.v$motorista_reg_historico mrh
			         on mrh.cod_registro = mr.cod_funcionario 
					and mrh.data_fim is null
			 where to_date('01/'|| mes || '/' ||ano) >= trunc(sysdate-365)		
			 order by mr.cod_funcionario, mr.ano, mr.mes
   		</cfquery>
		<cfreturn qr_notas>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca a posio do motorista no rank ou todo o rank
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  20/02/2006
	--->
	<cffunction name="get_rank_motorista" displayname="Busca a posio do motorista no rank ou todo o rank" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no">		
		<cfargument name="cod_pessoa" required="no">		
		<cfargument name="posicoes" required="no">		
		<cfargument name="mes" required="no" >		
		<cfargument name="ano" required="no" >		
		<cfquery datasource="#session.dsn#" name="qr_lancamentos" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa, ano, mes, cod_funcionario, nome_funcionario, 
				   indice_produtividade, nota, saldo_valor_pago, dias_corridos, dias_trabalhados,
				   rownum as posicao
		     from (
					select cod_pessoa, ano, mes, cod_funcionario, nome_funcionario, 
						   indice_produtividade, nota, saldo_valor_pago, dias_corridos, dias_trabalhados						   
					  from oper.motorista_rank r
					 where 1 = 1
					 <cfif IsDefined("arguments.cod_funcionario") and Len(Trim(arguments.cod_funcionario))>
					   and cod_funcionario = #arguments.cod_funcionario#
					 </cfif>
					 <cfif IsDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa))>
					   and cod_pessoa = #arguments.cod_pessoa#
					 </cfif>
					 <cfif IsDefined("arguments.mes") and Len(Trim(arguments.mes)) and IsDefined("arguments.ano") and Len(Trim(arguments.ano))>
					   and mes = #arguments.mes#
					   and ano = #arguments.ano#
					 <cfelse>
					   and mes = (select max(r2.mes)
                          from oper.motorista_rank r2
                         where r2.ano = r.ano)
					   and ano = (select max(r2.ano)
                          from oper.motorista_rank r2)
					 </cfif>
				 order by nota desc, ano, mes)
			 <cfif IsDefined("arguments.posicoes") and Len(Trim(arguments.posicoes))>
			   where rownum <= #arguments.posicoes#
			 </cfif>
   		</cfquery>
		<cfreturn qr_lancamentos>
	</cffunction>			

	<!--- 
	-- PROPSITO 
	-- Busca o saldo anterior a data passada.
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  20/02/2006
	--->
	<cffunction name="get_saldo_anterior_extrato" displayname="Busca o saldo anterior a data passada." access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="yes" />
		<cfargument name="data_inicial" required="no" default="#DateFormat(Now(), 'dd/mm/yyyy')#" />		
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select saldo
			   from (
					SELECT round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta,<cfif arguments.data_inicial EQ 0>sysdate<cfelse>to_date('#arguments.data_inicial# 23:59:59','DD/MM/YYYY hh24:mi:ss')</cfif>),1) as saldo,  
						   rank() over (partition by cc.cod_pessoa order by cc.cod_conta desc) as rank
					  FROM oper.v$ccorrente cc,
						   oper.v$motorista_reg_historico mrh   
					 WHERE cc.cod_pessoa = mrh.cod_pessoa
					   and mrh.cod_registro = #arguments.cod_funcionario#
					   and mrh.data_inicio = (select max(mrh2.data_inicio)
												from oper.v$motorista_reg_historico mrh2
											   where mrh2.cod_pessoa = mrh.cod_pessoa)
					   and cc.modalidade_id = 9)
				where rank = 1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>			
	
	<!--- 
	-- PROPSITO 
	-- Busca todas as contas com o saldo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  20/02/2006
	--->
	<cffunction name="get_saldos" displayname="Busca todas as contas com o saldo" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_lancamentos" username="#session.usuario#" password="#session.senha#">
			select m.cod_funcionario, m.nome_funcionario, 
                   dense_rank() over(order by m.saldo_atual desc) posicao,
                   (saldo_atual/max(saldo_atual) over ())*10 as nota,
                              m.acumulado,
                              m.saldo_atual saldo,
                              m.saldo_total,
                              m.valor_premio_acumulado, 
                   sysdate - m.data_admissao as tempo_casa,
                   en.entreposto as nome_empresa,
                   en.cod_entreposto as cod_pessoa_empresa
                    from (select c.cod_pessoa, f.cod_funcionario, f.nome_funcionario, f.cod_entreposto, min(f.data_admissao) data_admissao, -- Data do primeiro registro
                                                       sum(case when cl.historico like '%Avaria Carga%' or (cl.cod_documento = 373 and cl.deb_cred = 1) then -- Tinha avaria e fechamento do saldo negativo
                                                                               case when cl.historico like '%Avaria Carga%'  then cl.valor_lancamento else -1*cl.valor_lancamento end
                                                                         else 0 end) as acumulado -- Saldo acumulado considerando as avarias e outros crdito para ZERAR a conta resultado por semestre
                                                       ,sum(case when cl.deb_cred = 1 then cl.valor_lancamento else -1*cl.valor_lancamento end) saldo_atual -- Saldo atual da C/C
                                                       ,sum(case when cl.deb_cred = 0 and cl.cod_documento = 373 then cl.valor_lancamento else 0 end) valor_premio_acumulado -- Valor j retirado pelo motorista como prmio
                                                       ,sum(case when cl.historico like '%Avaria Carga%' or (cl.cod_documento = 373 and cl.deb_cred = 1) then -- Tinha avaria e fechamento do saldo negativo
                                                                               case when cl.historico like '%Avaria Carga%'  then cl.valor_lancamento else -1*cl.valor_lancamento end
                                                                         else 0 end) +  sum(case when cl.deb_cred = 1 then cl.valor_lancamento else -1*cl.valor_lancamento end) saldo_total 
                                            from finan.v$ccorrente_lancamento cl
                                      inner join finan.v$ccorrente c
                                                             on c.cod_conta = cl.cod_conta
                                                             and c.modalidade_id = 9
                                                             and c.ativo = 1
                                      inner join oper.v$motorista_reg_historico rm
                                                             on rm.cod_pessoa = c.cod_pessoa
                                                             and cl.data_vencto between rm.data_inicio and nvl(rm.data_fim, cl.data_vencto)
                                                             and rm.data_fim is null
                                      inner join oper.v$rh_funcionario f
                                                             on f.cod_funcionario = rm.cod_registro        
                                                         and f.cod_cargo = 1
                                                         and f.data_demissao is null
                                      where exists (select 'x'
                                                                                     from oper.v$ccorrente_lancamento cc2
                                                                               where cc2.cod_conta = c.cod_conta
                                                                                     and cc2.data_lancamento > sysdate - 180) -- Teve lanamentos nos ltimos 180 dias
                                            and not exists (select 'x'
                                                                                                from rh.rh_rescisao_temp r
                                                                                                where r.cod_funcionario = f.cod_funcionario) -- No est em processo de resciso
                                      group by c.cod_pessoa, f.cod_funcionario, f.cod_entreposto, f.nome_funcionario) m
                       left join rh.entreposto en 
                               on en.cod_entreposto = m.cod_entreposto
                 order by cod_pessoa_empresa
		</cfquery>
		<cfreturn qr_lancamentos>
	</cffunction>				
    
    <!--- 
	-- PROPSITO 
	-- Busca as multas.
	-- NOTAS EXPLICATIVAS
	-- RAFAEL   03/03/2010
	--->
	<cffunction name="get_multas" displayname="Busca as multas" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" />
        <cfargument name="data_final" required="no" />
        <cfargument name="COD_PESSOA_FUNCIONARIO" required="no" />
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			    select cl.num_lancamento as lancto_id
                     , fhp.cod_funcionario
                     , (select rhf.nome_funcionario
                          from rh.v$rh_funcionario rhf
                         where rhf.cod_funcionario = fhp.cod_funcionario) as nome_funcionario
                     , to_char(fhp.data_historico, 'dd/mm/yyyy hh24:mi') as data_historico
                     , cl.historico
                     , cl.valor_lancamento
                     , (select count(p.parcelamento_id)
                          from rh.v$parcelamento p
                         where p.lancto_id = cl.num_lancamento ) as possui_parcelamento
                  from finan.v$ccorrente_lancamento cl
            inner join rh.rh_funcionario_hist_pessoal fhp
                    on fhp.lancto_id = cl.num_lancamento
                   and fhp.cod_tipo_historico = 36
                 where 1 = 1
				 <cfif Len(Trim(arguments.data_inicial))>
                   and fhp.data_historico >= to_date('#arguments.data_inicial# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
                 </cfif>
                 <cfif Len(Trim(arguments.data_final))>
                   and fhp.data_historico <= to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                 </cfif>
                 <cfif Len(Trim(arguments.COD_PESSOA_FUNCIONARIO))>
                   and fhp.cod_funcionario = #arguments.COD_PESSOA_FUNCIONARIO#
                 </cfif>
              order by cl.date_insert desc
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os parclemaentos de uma multa
	-- NOTAS EXPLICATIVAS
	-- RAFAEL   03/03/2010
	--->
	<cffunction name="get_multas_parcelamento" displayname="Busca os parcelamentos de uma multa" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" required="yes" />
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			    select p.valor as valor_parcelamento
                 , p.mes as mes_inicial
                 , p.evento_id
                 , (select rhe.descricao
                      from rh.rh_evento rhe
                     where rhe.cod_evento = p.evento_id) as evento_descricao
                 , pi.num_parcela
                 , pi.mes
                 , pi.ano
                 , pi.valor
                 , p.parcelamento_id
                 , p.lancto_id
                 , (select count(pi2.parcelamento_id)
                      from rh.v$parcelamento_it pi2
                     where pi2.parcelamento_id = p.parcelamento_id ) as num_parcelas
              from rh.v$parcelamento p
            inner join rh.v$parcelamento_it pi
            on pi.parcelamento_id = p.parcelamento_id
            
            where p.lancto_id = #arguments.lancto_id#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>