<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Busca a listagem de documentos
    -- //2009 - criado
    --->	
    <cffunction name="get_formulario_documento_lista" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fd.cod_documento,
                   fd.descricao,
                   fd.view_name,
                   f.formulario_id,
                   f.descricao as formulario,
                   f.width,
                   f.height,
                   f.ativo,
                   f.padrao,
                   fd.date_insert,
                   fd.user_insert,
                   fd.date_update,
                   fd.user_update,
                   fd.site
              from kss.v$formulario_documento fd
              left join kss.v$formulario f
                     on f.cod_documento = fd.cod_documento
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
  
    
    <!--- 
    -- PROPSITO
    -- Busca os formularios cadastrados
    -- 05/12/2008 - criado
    --->	
    <cffunction name="get_formulario_impressao" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_documento" required="no" default="">
    	<cfargument name="formulario_id" required="no" default="">
    	<cfargument name="padrao" required="no" default="">
        <cfargument name="cod_modelo" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="no_centro_custo" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	<cfif len(trim(arguments.cod_modelo))>
                select distinct t.formulario_id 
                  from fiscal.v$modelo_serie t 
                 where t.cod_modelo = '#arguments.cod_modelo#'
                   and t.cod_pessoa = #session.cod_pessoa#
                   and t.cod_departamento = #session.cod_departamento#
                   and t.cod_setor = #session.cod_setor#
             <cfif arguments.no_centro_custo neq 1>
                   and t.cod_centro_custo = #session.cod_centro_custo#
             </cfif>
            <cfelse> 
                select f.formulario_id
                  from kss.v$formulario f
                 inner join kss.v$formulario_documento fd
                         on fd.cod_documento = f.cod_documento
                 where 1=1
                 <cfif len(trim(arguments.cod_documento))>
                   and f.cod_documento = '#arguments.cod_documento#'
                 </cfif>
                 <cfif len(trim(arguments.formulario_id))>
                   and f.formulario_id = #arguments.formulario_id#
                 </cfif>
                 <cfif len(trim(arguments.padrao))>
                   and f.padrao = #arguments.padrao#
                 </cfif>
        	</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
	<!--- 
    -- PROPSITO
    -- Busca os formularios cadastrados
    -- 05/12/2008 - criado
    --->	
    <cffunction name="get_formulario" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_documento" required="no" default="">
    	<cfargument name="formulario_id" required="no" default="">
    	<cfargument name="padrao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.formulario_id,
                   f.formulario_id_pai,
                   f.cod_documento,
                   f.descricao,
                   fd.view_name,
                   f.cod_unidade,
                   f.width,
                   f.height,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',f.width)) as width_pixels,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',f.height)) as height_pixels,
                   f.ativo,
                   f.padrao,
                   f.font_size,
                   f.font_family,
                   f.java,
                   f.date_insert,
                   f.user_insert,
                   f.date_update,
                   f.user_update,
                   f.site
              from kss.v$formulario f
             inner join kss.v$formulario_documento fd
                     on fd.cod_documento = f.cod_documento
             where 1=1
             <cfif len(trim(arguments.cod_documento))>
               and f.cod_documento = '#arguments.cod_documento#'
             </cfif>
             <cfif len(trim(arguments.formulario_id))>
               and f.formulario_id = #arguments.formulario_id#
             </cfif>
             <cfif len(trim(arguments.padrao))>
               and f.padrao = #arguments.padrao#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca os campos de um modelo de formulario
    -- 05/12/2009 - criado
    --->	
    <cffunction name="get_formulario_campo" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="formulario_id" required="no" default="">
    	<cfargument name="documento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fc.formulario_campo_id,
                   fc.formulario_id,
                   fc.tipo_id,
                   fc.campo_id,
                   fdc.view_field,
                   fc.top,
                   fc.left, 
                   fc.height, 
                   fc.width, 
                   fc.align,
                   fc.valign,
                   fc.expressao,
                   fc.font_size,
                   fc.font_family,
                   f.cod_unidade,
                   <cfif len(trim(arguments.documento_id))>
                   case
                      when fc.tipo_id = 2 then kss.pkg_formulario.fnc_calcula_campo(fc.formulario_campo_id,'#arguments.documento_id#') 
                      else ''
                    end as valor,
                   </cfif>
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.top)) as top_pixels,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.left)) as left_pixels,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.width)) as width_pixels,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.height)) as height_pixels
              from kss.v$formulario_campo fc
             inner join kss.v$formulario f
                     on f.formulario_id = fc.formulario_id
              left join kss.v$formulario_documento_campo fdc
                     on fdc.campo_id = fc.campo_id
             where 1=1
             <cfif len(trim(arguments.formulario_id))>
               and fc.formulario_id = #arguments.formulario_id#
             </cfif>
             
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Busca os campos de um modelo de formulario
    -- 05/12/2009 - criado
    --->	
    <cffunction name="get_formulario_campo_xml" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="formulario_id" required="no" default="">
    	<cfargument name="documento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fc.formulario_campo_id,
                   fc.formulario_id,
                   fc.tipo_id,
                   fc.campo_id,
                   fdc.view_field,
                   fc.top as top,
                   fc.left as left, 
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'POINT',fc.top)) as top_points,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'POINT',fc.left)) as left_points,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'POINT',fc.width)) as width_points,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'POINT',fc.height)) as height_points,
                   fc.height, 
                   fc.width,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.width)) as width_pixels,
                   nvl(fc.font_size,f.font_size)  as font_size,
                   nvl(fc.font_family,f.font_family)  as font_family,
                   fc.align,
                   fc.valign,
                   fc.expressao,
                   f.cod_unidade,
                   <cfif len(trim(arguments.documento_id))>
                   case
                      when fc.tipo_id = 2 then kss.pkg_formulario.fnc_calcula_campo(fc.formulario_campo_id,'#arguments.documento_id#') 
                      else ''
                    end as valor,
                   </cfif>
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.top)) as top_pixels,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.left)) as left_pixels,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.width)) as width_pixels,
                   round(kss.pkg_formulario.fnc_converte_unidade(f.cod_unidade,'PIXEL',fc.height)) as height_pixels
              from kss.v$formulario_campo fc
             inner join kss.v$formulario f
                     on f.formulario_id = fc.formulario_id
              left join kss.v$formulario_documento_campo fdc
                     on fdc.campo_id = fc.campo_id
             where 1=1
             <cfif len(trim(arguments.formulario_id))>
               and fc.formulario_id = #arguments.formulario_id#
             </cfif>
             order by fc.top, fc.left
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
    
    <!--- 
    -- PROPSITO
    -- Busca os formularios cadastrados
    -- 05/12/2008 - criado
    --->	
    <cffunction name="get_formulario_sem_conv" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_documento" required="no" default="">
    	<cfargument name="formulario_id" required="no" default="">
    	<cfargument name="padrao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.formulario_id,
                   f.formulario_id_pai,
                   f.cod_documento,
                   f.descricao,
                   fd.view_name,
                   f.cod_unidade,
                   f.width,
                   f.height,
                   f.width as width_pixels,
                   f.height as height_pixels,
                   f.ativo,
                   f.padrao,
                   f.font_size,
                   f.font_family,
                   f.java,
                   f.date_insert,
                   f.user_insert,
                   f.date_update,
                   f.user_update,
                   f.site
              from kss.v$formulario f
             inner join kss.v$formulario_documento fd
                     on fd.cod_documento = f.cod_documento
             where 1=1
             <cfif len(trim(arguments.cod_documento))>
               and f.cod_documento = '#arguments.cod_documento#'
             </cfif>
             <cfif len(trim(arguments.formulario_id))>
               and f.formulario_id = #arguments.formulario_id#
             </cfif>
             <cfif len(trim(arguments.padrao))>
               and f.padrao = #arguments.padrao#
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Busca os campos de um modelo de formulario
    -- 05/12/2009 - criado
    --->	
    <cffunction name="get_formulario_campo_sem_conv" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="formulario_id" required="no" default="">
    	<cfargument name="documento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fc.formulario_campo_id,
                   fc.formulario_id,
                   fc.tipo_id,
                   fc.campo_id,
                   fdc.view_field,
                   fc.top,
                   fc.left, 
                   fc.height, 
                   fc.width, 
                   fc.align,
                   fc.valign,
                   fc.expressao,
                   fc.font_size,
                   fc.font_family,
                   f.cod_unidade,
                   <cfif len(trim(arguments.documento_id))>
                   case
                      when fc.tipo_id = 2 then kss.pkg_formulario.fnc_calcula_campo(fc.formulario_campo_id,'#arguments.documento_id#') 
                      else ''
                    end as valor,
                   </cfif>
                   fc.top    as top_pixels,
                   fc.left   as left_pixels,
                   fc.width  as width_pixels,
                   fc.height as height_pixels
              from kss.v$formulario_campo fc
             inner join kss.v$formulario f
                     on f.formulario_id = fc.formulario_id
              left join kss.v$formulario_documento_campo fdc
                     on fdc.campo_id = fc.campo_id
             where 1=1
             <cfif len(trim(arguments.formulario_id))>
               and fc.formulario_id = #arguments.formulario_id#
             </cfif>
             
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Busca os campos de um modelo de formulario
    -- 05/12/2009 - criado
    --->	
    <cffunction name="get_formulario_campo_xml_sem_conv" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="formulario_id" required="no" default="">
    	<cfargument name="documento_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fc.formulario_campo_id,
                   fc.formulario_id,
                   fc.tipo_id,
                   fc.campo_id,
                   fdc.view_field,
                   fc.top as top,
                   fc.left as left, 
                   fc.top as top_points,
                   fc.left as left_points,
                   fc.width as width_points,
                   fc.height as height_points,
                   fc.height, 
                   fc.width,
                   fc.width as width_pixels,
                   nvl(fc.font_size,f.font_size)  as font_size,
                   nvl(fc.font_family,f.font_family)  as font_family,
                   fc.align,
                   fc.valign,
                   fc.expressao,
                   f.cod_unidade,
                   <cfif len(trim(arguments.documento_id))>
                   case
                      when fc.tipo_id = 2 then kss.pkg_formulario.fnc_calcula_campo(fc.formulario_campo_id,'#arguments.documento_id#') 
                      else ''
                    end as valor,
                   </cfif>
                   fc.top    as top_pixels,
                   fc.left   as left_pixels,
                   fc.width  as width_pixels,
                   fc.height as height_pixels
              from kss.v$formulario_campo fc
             inner join kss.v$formulario f
                     on f.formulario_id = fc.formulario_id
              left join kss.v$formulario_documento_campo fdc
                     on fdc.campo_id = fc.campo_id
             where 1=1
             <cfif len(trim(arguments.formulario_id))>
               and fc.formulario_id = #arguments.formulario_id#
             </cfif>
             order by fc.top, fc.left
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
    
      

	<!--- 
    -- PROPSITO
    -- Busca os dados do documento
    -- 05/12/2009 - criado
    --->	
    <cffunction name="get_formulario_documento_dados" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="documento_id" required="no" default="">
    	<cfargument name="view_name" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.*
              from #arguments.view_name# t
             where 1=1
               and to_char(t.documento_id) = '#arguments.documento_id#'
           
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>