<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Busca as contas correntes 
    -- 22/12/2008 - criado
    --->	
    <cffunction name="get_ccorrente_banco" displayname="" output="true" returntype="query" access="remote">
    	<cfargument name="cod_pessoa" required="no" default="">
    	<cfargument name="cnpj_cpf" required="no" default="">
    	<cfargument name="cod_conta" required="no" default="">
        <cfargument name="tipo" required="no" default="">
		<cfargument name="valor" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.cod_conta, 
                   cc.descricao_conta, 
                   cc.cod_pessoa,
                   p.cnpj_cpf,
                   p.cliente,
                   cc.modalidade_id, 
                   cc.banco_id, 
                   b.banco_descricao,
                   cc.agencia_id, 
                   cc.conta_corrente, 
                   cc.conta_corrente_dv, 
                   cc.conta_corrente_ag_cc_dv, 
                   to_char(cc.data_abertura,'dd/mm/yyyy hh24:mi:ss') as data_abertura, 
                   cc.aceita_deposito, 
                   cc.aceita_boleto, 
                   cc.ativo, 
                   cc.cod_moeda,
                   m.descricao_moeda,
                   cc.cod_contabil,
                   ba.logradouro||nvl2(ba.numero,', '||ba.numero,'')||nvl2(ba.complemento,' '||ba.complemento,'')||' - '||kss.pkg_string.fnc_formata_cep(ba.cep)||' - '||ba.municipio||'-'||ba.uf agencia_endereco
              from finan.v$ccorrente_banco cc
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = cc.cod_pessoa
             inner join kss.banco_agencia ba
                     on ba.banco_id = cc.banco_id
                    and ba.agencia_id = cc.agencia_id
             left join kss.banco b
                     on b.banco_id = cc.banco_id
             left join finan.v$moeda_bacen m
                     on m.cod_moeda = cc.cod_moeda
             where  1=1 
             <cfif len(trim(arguments.cod_conta))>
               and cc.cod_conta = #arguments.cod_conta#
             </cfif>
             <cfif len(trim(arguments.cod_pessoa))>
               and cc.cod_pessoa = #arguments.cod_pessoa#
             </cfif>
             <cfif len(trim(arguments.cnpj_cpf))>
               and p.cnpj_cpf = '#arguments.cnpj_cpf#'
             </cfif>
             <cfif len(trim(arguments.valor))>
             	<cfif arguments.tipo eq 1>
                	and cc.cod_conta = #arguments.valor#
                <cfelseif arguments.tipo eq 2>
                	and p.cnpj_cpf = #arguments.valor#
                <cfelseif arguments.tipo eq 3>
                	and p.cliente like upper('%#arguments.valor#%')
                <cfelseif arguments.tipo eq 4>
                	and cc.descricao_conta like upper('%#arguments.valor#%')
                </cfif>
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Busca os lancamentos da conta corrente
    -- 22/12/2008 - criado
    --->	
    <cffunction name="get_ccorrente_lancamento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="cod_conta" required="no" default="">
    	<cfargument name="data_inicio" required="no" default="">
    	<cfargument name="data_fim" required="no" default="">
    	<cfargument name="data_inicio_emissao" required="no" default="">
    	<cfargument name="data_fim_emissao" required="no" default="">
    	<cfargument name="num_lancamento" required="no" default="">
    	<cfargument name="num_documento" required="no" default="">
    	<cfargument name="futuros" required="no" default="">
        <cfargument name="compensados" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cl.num_lancamento,
                   cl.cod_conta,
                   cc.descricao_conta,
                   cl.cod_pessoa_un,
                   cl.cod_documento,
                   cl.num_documento,
                   to_char(cl.data_lancamento, 'dd/mm/yyyy hh24:mi:ss') as data_lancamento,
                   to_char(cl.data_vencto, 'dd/mm/yyyy hh24:mi:ss') as data_vencto,
                   cl.historico,
                   ch.num_cheque,
                   cl.valor_lancamento,
                   cl.deb_cred,
                   cl.favorecido,
                   cl.user_insert
                  , (select kss.fnc_concat_all(kss.to_concat_expr(cp.num_docto||'\'||cp.parc_docto,'<br>'))
                          from finan.v$finan_contas_pagar_amort a
                    inner join finan.v$finan_contas_pagar cp
                            on cp.contas_pagar_id = a.contas_pagar_id
                         where a.num_lancto_cc_sacado = cl.num_lancamento) as pagtos_amortizados
              from finan.v$ccorrente_lancamento cl
             inner join finan.v$ccorrente_banco cc
                on cc.cod_conta = cl.cod_conta
              left join finan.v$cheque_ccorrente ch 
                on ch.num_lancto_ccorrente = cl.num_lancamento
             where 1 = 1
             <cfif len(trim(arguments.num_lancamento))>
               and cl.num_lancamento in (#arguments.num_lancamento#)
             </cfif>
             <cfif len(trim(arguments.num_documento))>
               and cl.num_documento in (#arguments.num_documento#)
             </cfif>
             
             <cfif len(trim(arguments.cod_conta))>
               and cl.cod_conta in (#arguments.cod_conta#)
             </cfif>
             <cfif len(trim(arguments.futuros))>
               and cl.data_vencto is null
             </cfif>
             <cfif len(trim(arguments.compensados))>
               and cl.data_vencto is not null
             </cfif>
             <cfif len(trim(arguments.data_inicio))>
               and cl.data_vencto >= '#arguments.data_inicio#'
             </cfif>
             <cfif len(trim(arguments.data_fim))>
               and cl.data_vencto <= '#arguments.data_fim#'
             </cfif>
             <cfif len(trim(arguments.data_inicio_emissao))>
               and cl.data_lancamento >= '#arguments.data_inicio_emissao#'
             </cfif>
             <cfif len(trim(arguments.data_fim_emissao))>
               and cl.data_lancamento <= '#arguments.data_fim_emissao#'
             </cfif>
              order by cl.data_lancamento, cl.data_vencto, cl.num_lancamento
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca saldo anterior
	-- GUTO 02/12/2008
	--->		
	<cffunction name="get_saldo_anterior" access="remote" returntype="query" output="true">
		<cfargument name="cod_conta" required="yes" >
		<cfargument name="data" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select finan.pkg_ccorrente.fnc_saldo_ccorrente_atual(#arguments.cod_conta#, '#arguments.data#') as saldo
			  from dual
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>     

	<!--- 
    -- PROPSITO
    -- Busca os documentos para os lanctos da ccorrente
    -- 22/12/2008 - criado
    --->	
    <cffunction name="get_ccorrente_documento" displayname="" output="true" returntype="query" access="public">
        <cfargument name="deb_cred" required="no" default="">
        <cfargument name="uso_exclusivo_cheque" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cd.cod_documento, 
                   cd.descricao_documento, 
                   cd.deb_cred, 
                   cd.febraban_g092_id, 
                   cd.modalidade_id, 
                   cd.observacao, 
                   cd.uso_exclusivo_deposito, 
                   cd.uso_exclusivo_cheque, 
                   cd.cod_contabil 
              from finan.v$ccorrente_documento cd
             where 1=1
             <cfif len(trim(arguments.deb_cred))>
               and cd.deb_cred in (#arguments.deb_cred#)
             </cfif>
             <cfif len(trim(arguments.uso_exclusivo_cheque))>
               and cd.uso_exclusivo_cheque in (#arguments.uso_exclusivo_cheque#)
             </cfif>
             order by cd.descricao_documento    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Busca as unidade de negocio
    -- 22/12/2008 - criado
    --->	
    <cffunction name="get_unidade_negocio" displayname="" output="true" returntype="query" access="public">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_unidade_negocio, 
                   unidade_negocio, 
                   cod_pessoa, 
                   site 
              from kss.v$unidade_negocio
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca saldo anterior
	-- RAFAEL 27/07/2009
	--->		
	<cffunction name="get_saldo_anterior_pagtos" access="remote" returntype="query" output="true">
		<cfargument name="cod_conta" required="yes" >
		<cfargument name="data" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nvl(sum(l.valor_lancamento * (l.deb_cred + sign(l.deb_cred-1))),0) as saldo
                   from finan.v$ccorrente_lancamento l
             where l.cod_conta = #arguments.cod_conta#
               and l.data_lancamento < '#arguments.data#'
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>     
    
</cfcomponent>