<cfcomponent displayname="Controle e manipulao de caixas INTERNACIONAIS" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO g
	-- Consulta Caixa da filial
	-- GUTO  28/06/2007
	--->		
	<cffunction name="get_caixa" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select c.descricao,
			   c.caixa_id,
			   c.num_caixa,
			   c.cod_contabil
		  from finan.v$finan_caixa c
		 where 1=1  
		   <cfif len(trim(arguments.cod_pessoa_filial))>
	   		and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
		   </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca os Centros de Custo
	-- LOUIS  28/05/2007
	--->		
	<cffunction name="get_centro_custo" access="remote" returntype="query" output="true">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cc.cod_centro_custo,
				   cc.centro_custo
			  from kss.v$centro_custo cc
			 where 1=1
			 <cfif len(trim(arguments.cod_centro_custo))>
			   and cc.cod_centro_custo = #arguments.cod_centro_custo#
			 </cfif>
			  <cfif len(trim(arguments.centro_custo))>
			   and upper(cc.centro_custo) like upper('%#arguments.centro_custo#%')
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Consulta Caixa Aberto
	-- LOUIS (SQL feita pelo JEK)  28/05/2007
	--->		
	<cffunction name="get_caixa_aberto" access="remote" returntype="query" output="true">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="controle_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.controle_id
                 , c.descricao
                 , c.caixa_id
                 , c.num_caixa
                 , c.cod_contabil
                 , c.cod_pessoa_filial
                 , p.razao_social
                 , p.cnpj_cpf
              from finan.v$finan_caixa_controle cc
             inner join finan.v$finan_caixa c
                     on c.caixa_id = cc.caixa_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = c.cod_pessoa_filial
             where 1=1
           <cfif len(trim(arguments.usuario))>
		      and upper(cc.usuario) = upper('#arguments.usuario#')
           </cfif>
		   <cfif len(trim(arguments.descricao))>
			  and upper(c.descricao) like upper('%#arguments.descricao#%')
		   </cfif>
		   <cfif len(trim(arguments.controle_id))>
		   	  and cc.controle_id = '#arguments.controle_id#'
		   </cfif>
               and cc.data_encerramento is null
               and exists (select 0 
                             from kss.v$kss_usuario_lotacao ul
                            where ul.cod_pessoa = c.cod_pessoa_filial
           <cfif len(trim(arguments.usuario))>
						     and ul.usuario = upper('#arguments.usuario#')
           </cfif>
			              )           
             union 
            select cc.controle_id
                 , c.descricao
                 , c.caixa_id
                 , c.num_caixa
                 , c.cod_contabil
                 , c.cod_pessoa_filial
                 , p.razao_social
                 , p.cnpj_cpf
              from finan.v$finan_caixa_controle cc
             inner join finan.v$finan_caixa c
                     on c.caixa_id = cc.caixa_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = c.cod_pessoa_filial
             where 1 = 1
               and cc.data_encerramento is null
               and c.controle_usuario = 0
             order by num_caixa
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os historicos para lancamento de caixa (BRASIL)
	-- LOUIS 28/05/2007
	--->		
	<cffunction name="get_historico_br" access="remote" returntype="query" output="true">
		<cfargument name="cod_historico" required="no" default="">
		<cfargument name="historico" required="no" default="">
		<cfargument name="cod_contabil" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select h.cod_historico, h.historico, h.cod_contabil, h.cod_centro_custo, cc.centro_custo 
			  from finan.v$finan_caixa_historico h
		      left join kss.v$centro_custo cc
                     on cc.cod_centro_custo = h.cod_centro_custo
		      where 1=1
			 <cfif len(trim(arguments.historico))>
		        and upper(h.historico) like upper('%#arguments.historico#%')
			 </cfif>
			  <cfif len(trim(arguments.cod_historico))>
			   and h.cod_historico = #arguments.cod_historico#
			 </cfif>
			  <cfif len(trim(arguments.cod_contabil))>
			   and  upper(h.cod_contabil) like upper('%#arguments.cod_contabil#%')
			 </cfif>
			  order by h.cod_historico
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os historicos para lancamento de caixa (ARGENTINA)
	-- LOUIS 28/05/2007
	--->		
	<cffunction name="get_historico" access="remote" returntype="query" output="true">
		<cfargument name="historico_arg" required="no" default="">
		<cfargument name="cod_historico_arg" required="no" default="">
		<cfargument name="cod_historico" required="no" default="">
		<cfargument name="cod_contabil" required="no" default="">
		<cfargument name="cod_contabil_arg" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select h.cod_historico_arg, h.historico_arg, h.cod_contabil_arg,
				   h.cod_historico, f.historico, f.cod_contabil, f.cod_centro_custo, cc.centro_custo 
			  from finan.v$finan_caixa_historico_arg h
			 inner join finan.v$finan_caixa_historico f
			         on f.cod_historico = h.cod_historico
		      left join kss.v$centro_custo cc
                     on cc.cod_centro_custo = f.cod_centro_custo
		      where 1=1
			 <cfif len(trim(arguments.historico_arg))>
		        and upper(h.historico_arg) like upper('%#arguments.historico_arg#%')
			 </cfif>
			 <cfif len(trim(arguments.cod_historico_arg))>
			   and h.cod_historico_arg = #arguments.cod_historico_arg#
			 </cfif>
			  <cfif len(trim(arguments.cod_historico))>
			   and h.cod_historico = #arguments.cod_historico#
			 </cfif>
			  <cfif len(trim(arguments.cod_contabil))>
			   and  upper(f.cod_contabil) like upper('%#arguments.cod_contabil#%')
			 </cfif>
			  <cfif len(trim(arguments.cod_contabil_arg))>
			   and  upper(h.cod_contabil_arg) like upper('#arguments.cod_contabil_arg#%')
			 </cfif>
			  order by h.cod_historico_arg
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca lanamentos no caixa
	-- GUTO 
	--->		
	<cffunction name="get_lancamentos" access="remote" returntype="query" output="true">
		<cfargument name="caixa_id" required="no" default="">
		<cfargument name="num_docto" required="no" default="">
		<cfargument name="lancamento_id" required="no" default="">
		<cfargument name="receita" required="no" default="">
        <cfargument name="data_lancamento_inicial" required="no" default="">
        <cfargument name="data_lancamento_final" required="no" default="">
        <cfargument name="editar" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cl.lancamento_id, cl.controle_id, cl.controle_id,
				   cl.complemento, cl.cod_centro_custo, nvl(cl.valor,0) as valor,
				   cl.receita, cl.data_lancamento, cl.num_docto,
				   cla.lancamento_id_vinculo, cla.pagamento_id, cla.cod_pessoa_fornecedor, cla.data_comprovante, cla.cod_comprovante, 
                   nvl(cla.precep_iva,0) as precep_iva, cla.cod_tipo_comprovante, cla.tipo_formulario, cla.jurisdicao_ib,
                   nvl(cla.precep_iva,0) as precep_iva, cla.jurisdicao_ib,
                   p.cliente as fornecedor, p.cnpj_cpf as cod_cadastro_contribuinte,
				   cla.docto_pagamento, cla.cod_historico_arg, cla.valor_neto, cla.valor_iva,
				   nvl(cla.valor_no_gravado,0) as valor_no_gravado, nvl(cla.valor_exentos,0) as valor_exentos, nvl(cla.valor_ret_ir,0) as valor_ret_ir,
				   nvl(cla.valor_total,0) valor_total, h.historico_arg, ca.descricao as caixa,
                   ca.num_caixa, cc.centro_custo,
                   cla.lancamento_id_vinculo, clv.complemento as complemento_vinculo,
                   clv.num_docto as num_docto_vinculo, f.cliente as filial,
                   c.usuario, 
                   case 
                     when '#arguments.data_lancamento_inicial#' > c.data_abertura then nvl(finan.pkg_cxa.fnc_caixa_saldo_data(c.caixa_id, '#arguments.data_lancamento_inicial#'),0) 
                   else nvl(c.saldo_abertura,0) end as saldo_abertura, c.saldo_encerramento, c.data_abertura, c.data_encerramento,
				   fpt.descricao || ' - Num.:' || fpa.cod_comprovante || ' - ' || fpa.complemento as pagamento_complemento,
                   h.cod_contabil_arg,
                   r.num_recibo
			  from finan.v$finan_caixa ca
             inner join kss.v$pessoa f
                     on f.cod_pessoa = ca.cod_pessoa_filial
             inner join finan.v$finan_caixa_controle c
                     on c.caixa_id = ca.caixa_id
			 inner join finan.v$finan_caixa_lancamento cl
			         on cl.controle_id = c.controle_id
             left join kss.v$centro_custo cc
                     on cc.cod_centro_custo = cl.cod_centro_custo
			 left join finan.v$finan_caixa_lancamento_arg cla
					 on cla.lancamento_id = cl.lancamento_id
		     left join finan.v$finan_caixa_historico_arg h
			         on cla.cod_historico_arg = h.cod_historico_arg
			 left join finan.v$finan_caixa_lancamento clv
			         on clv.lancamento_id = cla.lancamento_id_vinculo
             left join kss.v$pessoa p 
                    on p.cod_pessoa = cla.cod_pessoa_fornecedor
             left join finan.v$finan_caixa_pagto_arg fpa
                    on fpa.pagamento_id = cla.pagamento_id
             left join finan.v$finan_caixa_pagto_tipo fpt
                    on fpt.tipo_pagamento_id = fpa.tipo_pagamento_id
             left join fiscal.v$intc_recibo_pagto rp
             		on rp.lancamento_caixa_id = cl.lancamento_id
             left join fiscal.v$intc_recibo r
             		on r.recibo_id = rp.recibo_id
		     where 1=1
             <cfif Len(Trim(arguments.cod_pessoa_filial))>
			   and ca.cod_pessoa_filial = #arguments.cod_pessoa_filial#
             </cfif>
             <cfif Len(Trim(arguments.data_lancamento_inicial))>
			   and trunc(cl.data_lancamento) >= '#arguments.data_lancamento_inicial#'
             </cfif>
             <cfif Len(Trim(arguments.data_lancamento_final))>
			   and trunc(cl.data_lancamento) <= '#arguments.data_lancamento_final#'
             </cfif>
             <cfif Len(Trim(arguments.caixa_id))>
			   and c.caixa_id = #arguments.caixa_id#
             </cfif>
			 <cfif Len(Trim(arguments.receita))>
			   and cl.receita = #arguments.receita#
			 </cfif>
			 <cfif Len(Trim(arguments.num_docto))>
			   and cl.num_docto = '#arguments.num_docto#'
			 </cfif>
			 <cfif Len(Trim(arguments.lancamento_id))>
			   and cl.lancamento_id = #arguments.lancamento_id#
			 </cfif>
             <cfif Len(Trim(arguments.editar))>
               and ca.cod_pessoa_filial = #session.cod_pessoa#
             </cfif>
			 order by ca.caixa_id, c.controle_id, cl.lancamento_id 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca lista de lanamentos no caixat
	-- ERIC 
	--->		
	<cffunction name="get_lista_lancamentos" access="remote" returntype="query" output="true">
		<cfargument name="caixa_id" required="no" default="">
        <cfargument name="data_lancamento_inicial" required="no" default="">
        <cfargument name="data_lancamento_final" required="no" default="">  
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_pessoa_fornecedor" required="no" default="">
        <cfargument name="com_saldo" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.lancamento_id
                 , y.controle_id
                 , y.complemento
                 , y.valor
                 , y.receita
                 , to_char(y.data_lancamento, 'dd/mm/yyyy') as data_lancamento
                 , y.num_docto
                 , y.docto_pagamento
                 , y.valor_iva
                 , y.caixa
                 , y.caixa_id
                 , y.num_caixa
                 , y.cod_moeda
                 , y.usuario
                 , y.data_abertura
                 , y.data_encerramento  
                 , y.historico_arg 
                 , y.centro_custo
                 , y.filial
                 , y.fornecedor
                 , y.cod_contabil_arg
                 , y.data_cotacao_pesos
                 , y.data_cotacao_reais
                 , y.cotacao_do_dia_pesos
                 , y.cotacao_do_dia_reais
				<cfif arguments.com_saldo eq 1>
                 , case
                      when y.cod_moeda <> 705 then -- Pesos
                         round(y.saldo_abertura * y.taxa_venda_pesos, 2)
                      else
                         y.saldo_abertura
                   end as saldo_abertura_pesos
                 , case
                      when y.cod_moeda <> 790 then -- R$
                         round(y.saldo_abertura * y.taxa_venda_reais, 2)
                      else
                         y.saldo_abertura
                   end as saldo_abertura_reais
				</cfif>
                 , case
                      when y.cod_moeda <> 705 then -- Pesos
                         round(y.valor * y.taxa_venda_pesos, 2)
                      else
                         y.valor
                   end as valor_pesos
                 , case
                      when y.cod_moeda <> 790 then -- R$
                         round(y.valor * y.taxa_venda_reais, 2)
                      else
                         y.valor
                   end as valor_reais
              from (
                    select t.lancamento_id
                         , t.controle_id
                         , t.complemento
                         , t.valor
                         , t.receita
                         , t.data_lancamento
                         , t.num_docto
                         , t.docto_pagamento
                         , t.valor_iva
                         , t.caixa
                         , t.caixa_id
                         , t.num_caixa
                         , t.cod_moeda
                         , t.usuario
                         , t.data_abertura
                         , t.data_encerramento  
                         , t.historico_arg 
                         , t.centro_custo
                         , t.filial
                         , t.fornecedor
                         , t.cod_contabil_arg
						<cfif arguments.com_saldo eq 1>
                         , t.saldo_abertura
						</cfif>
                         , extractvalue(t.xml_cotacao_pesos, '/COTACAO/COTACAO[1]/DATA_COTACAO') as data_cotacao_pesos
                         , extractvalue(t.xml_cotacao_reais, '/COTACAO/COTACAO[1]/DATA_COTACAO') as data_cotacao_reais
                         , extractvalue(t.xml_cotacao_pesos, '/COTACAO/COTACAO[1]/COTACAO_DO_DIA') as cotacao_do_dia_pesos
                         , extractvalue(t.xml_cotacao_reais, '/COTACAO/COTACAO[1]/COTACAO_DO_DIA') as cotacao_do_dia_reais
                         , to_number(extractvalue(t.xml_cotacao_pesos, '/COTACAO/COTACAO[1]/TAXA_VENDA')) as taxa_venda_pesos
                         , to_number(extractvalue(t.xml_cotacao_reais, '/COTACAO/COTACAO[1]/TAXA_VENDA')) as taxa_venda_reais
                      from (
                            select cl.lancamento_id
                                 , cl.controle_id
                                 , cl.complemento
                                 , cl.valor
                                 , cl.receita
                                 , cl.data_lancamento
                                 , cl.num_docto
                                 , cla.docto_pagamento
                                 , cla.valor_iva
                                 , ca.descricao as caixa
                                 , ca.caixa_id
                                 , ca.num_caixa
                                 , ca.cod_moeda
                                 , c.usuario
                                 , c.data_abertura
                                 , c.data_encerramento                       
                                 , (select h.historico_arg
                                      from finan.v$finan_caixa_historico_arg h
                                     where h.cod_historico_arg = cla.cod_historico_arg
                                   ) as historico_arg                                    
                                 , (select cc.centro_custo
                                      from kss.v$centro_custo cc
                                     where cc.cod_centro_custo = cl.cod_centro_custo
                                   ) as centro_custo
                                 , (select p.cliente
                                      from kss.v$pessoa p
                                     where p.cod_pessoa = ca.cod_pessoa_filial
                                   ) as filial
                                 , (select p.cliente
                                      from kss.v$pessoa p
                                     where p.cod_pessoa = cla.cod_pessoa_fornecedor
                                   ) as fornecedor
                                 , (select h.cod_contabil_arg
                                      from finan.v$finan_caixa_historico_arg h
                                     where h.cod_historico_arg = cla.cod_historico_arg
                                   ) as cod_contabil_arg
								<cfif arguments.com_saldo eq 1>
                                 , case
                                      when to_date('#arguments.data_lancamento_inicial#', 'dd/mm/yyyy') > c.data_abertura then
                                         finan.pkg_cxa.fnc_caixa_saldo_data(c.caixa_id, to_date('#arguments.data_lancamento_inicial#', 'dd/mm/yyyy'))
                                      else
                                         c.saldo_abertura
                                   end as saldo_abertura  
								</cfif>                     
                                 , finan.pkg_cotacao.fnc_cotacao(ca.cod_moeda, 705, cl.data_lancamento - 1) as xml_cotacao_pesos
                                 , finan.pkg_cotacao.fnc_cotacao(ca.cod_moeda, 790, cl.data_lancamento - 1) as xml_cotacao_reais
                              from finan.v$finan_caixa ca
                             inner join finan.v$finan_caixa_controle c
                                     on c.caixa_id = ca.caixa_id
                             inner join finan.v$finan_caixa_lancamento cl
                                     on cl.controle_id = c.controle_id
                              left join finan.v$finan_caixa_lancamento_arg cla
                                     on cla.lancamento_id = cl.lancamento_id
                             where 1 = 1
                             <cfif Len(Trim(arguments.data_lancamento_inicial))>
                               and cl.data_lancamento >= to_date('#arguments.data_lancamento_inicial#', 'dd/mm/yyyy')
                             </cfif>
                             <cfif Len(Trim(arguments.data_lancamento_final))>
                               and cl.data_lancamento <= to_date('#arguments.data_lancamento_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                             </cfif>
                             <cfif Len(Trim(arguments.caixa_id))>
                               and c.caixa_id = #arguments.caixa_id#
                             </cfif>
                             <cfif Len(Trim(arguments.cod_pessoa_fornecedor))>
                               and cla.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                             </cfif>
							 <cfif Len(Trim(arguments.cod_pessoa_filial))>
                               and ca.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                             </cfif>
                           ) t
                   ) y
			 order by y.caixa_id, y.controle_id, y.lancamento_id		 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
 
	<!--- 
	-- PROPSITO 
	-- Busca os mics para os honorarios de fronteira
	-- CRISTOFER  06/06/2007
	--->		
	<cffunction name="get_rateio_honorarios_fronteira" access="remote" returntype="query" output="true">
		<cfargument name="fronteira_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="valor" required="no" default="">
		<cfargument name="valor_iva" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fnc_concat_all(to_concat_expr(centro_custo,'/')) as centro_custo,
                   manifesto_id, numero_manifesto, data_emissao,
                   fnc_concat_all(to_concat_expr(numero_crt,'/')) as numero_crt
              from (
                    select cc.centro_custo,
                           m.manifesto_id,
                           m.numero_cod_pais || '.' || m.numero_certificado || '.' || replace(replace(to_char(m.numero_sequencial, '000,000'), ',', '.'), ' ', '') as numero_manifesto,
                           fnc_concat_all(to_concat_expr(c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(replace(to_char(c.numero_sequencial, '000,000'), ',', '.'), ' ', ''),' / ')) as numero_crt,
                           m.data_emissao
                      from fiscal.v$intc_conhecimento c
                     inner join fiscal.v$intc_manifesto_crt mc
                         on mc.conhecimento_id = c.conhecimento_id
                     inner join fiscal.v$intc_manifesto m
                         on m.manifesto_id = mc.manifesto_id
                     inner join kss.v$organograma o 
                         on o.cod_organograma = c.cod_organograma
                     inner join kss.v$centro_custo cc
                         on cc.cod_centro_custo = o.cod_centro_custo
                     where 1=1               
                       and trunc(m.data_emissao) >= '01/04/2007'
                 <cfif len(trim(arguments.fronteira_id))>
                   and c.fronteira_id = #arguments.fronteira_id#
                   and not exists(select 'x'
                                    from fiscal.v$intc_manifesto_caixa imc
                                   where imc.manifesto_id = m.manifesto_id
                                     and imc.fronteira_id = #arguments.fronteira_id#)
                 </cfif>
                 <cfif len(trim(arguments.data_inicial))>
                   and trunc(m.data_emissao) >= '#arguments.data_inicial#'
                 </cfif>
                 <cfif len(trim(arguments.data_final))>
                   and trunc(m.data_emissao) <= '#arguments.data_final#'
                 </cfif>
                   group by m.manifesto_id,
                            m.numero_cod_pais || '.' || m.numero_certificado || '.' || replace(replace(to_char(m.numero_sequencial, '000,000'), ',', '.'), ' ', ''),
                            cc.centro_custo,m.data_emissao)
                   group by manifesto_id, numero_manifesto, data_emissao         
                   order by data_emissao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<cffunction name="get_rateio_honorarios_fronteira_rateio" access="remote" returntype="query" output="true">
		<cfargument name="manifesto_id" required="yes">
		<cfargument name="valor" required="yes">
		<cfargument name="valor_iva" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_centro_custo, 
                   centro_custo, 
                   count(*) as num_crts,
                   sum(crt) * avg(valor_crt) as total_servico,
                   sum(crt) * avg(valor_iva) as total_iva,
                   round((sum(num_crts) / sum( sum(num_crts) ) over())*100,2) as percentual,
                   count(distinct manifesto_id) as total_mics,
                   round(sum(num_crts),2) as num_mics,
                   fnc_concat_all(to_concat_expr(manifesto_id,',')) as lista_manifesto
            from (                     
                    select m.manifesto_id, o.cod_centro_custo, 1 as crt,
                           cc.centro_custo, 
                           1 / count(*) over(partition by m.manifesto_id order by m.manifesto_id) as num_crts,
                           #val(arguments.valor)# / count(*) over(partition by m.manifesto_id order by m.manifesto_id) as valor_crt,
                           #val(arguments.valor_iva)# / count(*) over(partition by m.manifesto_id order by m.manifesto_id) as valor_iva                          
                      from fiscal.v$intc_conhecimento c
                     inner join fiscal.v$intc_manifesto_crt mc
                         on mc.conhecimento_id = c.conhecimento_Id
                     inner join fiscal.v$intc_manifesto m
                         on m.manifesto_id = mc.manifesto_id
                     inner join kss.v$organograma o 
                         on o.cod_organograma = c.cod_organograma
                     inner join kss.v$centro_custo cc
                         on cc.cod_centro_custo = o.cod_centro_custo
                     where 1=1
                       and manifesto_id in (#arguments.manifesto_id#)
                   group by m.manifesto_id, c.conhecimento_id, o.cod_centro_custo,cc.centro_custo)
            group by cod_centro_custo,centro_custo   
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca os valores da cg_ref_codes
	-- CRISTOFER  11/06/2007
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
		<cfargument name="DOMINIO" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rv_domain dominio, 
				   rv_low_value id, 
				   rv_high_value, 
				   rv_abbreviation abreviacao, 
				   rv_meaning descricao
			  from fiscal.v$cg_ref_codes
			 where rv_domain = '#arguments.dominio#'
             order by rv_low_value
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os valores de um determinado atributo
	-- LOUIS  09/08/2007
	--->		
	<cffunction name="get_atributos" access="remote" returntype="query" output="true">
		<cfargument name="ATRIBUTO_ID" required="yes">
        <cfargument name="VALOR" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.item_id, t.atributo_id, t.valor
  			  from kss.v$atributo_item t
             where atributo_id = #arguments.atributo_id#
		    <cfif len(trim(arguments.VALOR))>
               and upper(t.valor) = upper('#arguments.VALOR#')
            </cfif>             
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os caixas
	-- LOUIS 22/06/2007
	--->		
	<cffunction name="get_caixas" access="remote" returntype="query" output="true">
		<cfargument name="caixa_id" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="controle_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select c.caixa_id
              , c.cod_pessoa_filial
              , c.finalidade_id
              , c.num_caixa
              , c.descricao
              , c.cod_moeda
              , c.tipo_id
              , c.cod_contabil
              , c.ativo
              , cc.controle_id
              , cc.usuario
              , cc.data_abertura
              , case
                   when cc.saldo_encerramento is null then
                      cc.saldo_abertura
                   else
                      cc.saldo_encerramento
                end as saldo
              , case
                   when cc.data_encerramento is null then
                      'Aberto'
                   else
                      'Fechado'
                end as situacao 
            from finan.v$finan_caixa c
           inner join finan.v$finan_caixa_controle cc
                   on cc.caixa_id = c.caixa_id
           where 1=1
		   <cfif len(trim(arguments.caixa_id))>
             and c.caixa_id = '#arguments.caixa_id#'
           </cfif>
           <cfif len(trim(arguments.controle_id))>
             and cc.controle_id = '#arguments.controle_id#'
           </cfif>  
             and (select l.cod_pessoa
                    from kss.usuario_lotacao ul
                   inner join kss.v$lotacao l
                           on ul.cod_lotacao = l.cod_lotacao and upper(ul.usuario) = upper('#arguments.usuario#')) = c.cod_pessoa_filial
             and nvl(finan.pkg_cxa.fnc_get_controle(c.caixa_id),0) = cc.controle_id
           order by c.descricao, cc.controle_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os abastecimentos lanados
	-- LOUIS 25/06/2007
	-- MODIFICADO POR Eric 03/11/2010
	--->		
	<cffunction name="get_abastecimento" access="remote" returntype="query" output="true">
		<cfargument name="controle_id"             required="no" default="">
        <cfargument name="lancamento_id"           required="no" default="">
        <cfargument name="docto_pagamento"         required="no" default="">
        <cfargument name="data_lancamento_inicial" required="no" default="">
        <cfargument name="data_lancamento_final"   required="no" default="">
        <cfargument name="rownum_limite"           required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.placa
                 , a.km
                 , a.quantidade
                 , a.produto_id
                 , (select p.descricao
                      from oper.v$produto p
                     where p.produto_id = a.produto_id) as produto
                 , a.cod_pessoa_motorista
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = a.cod_pessoa_motorista
                   ) as motorista
                 , a.controle_id
                 , a.valor_total
                 , a.lancto_caixa_intc_id
                 , l.user_insert as usuario
                 , l.cod_historico_arg
                 , (select h.historico_arg
                      from finan.v$finan_caixa_historico_arg h
                     where h.cod_historico_arg = l.cod_historico_arg
                   ) as historico_arg
                 , l.valor_neto
                 , l.valor_exentos
                 , l.valor_iva
                 , l.precep_iva
                 , l.valor_ret_ir
                 , l.valor_total as valor_total_lancamento
                 , l.valor_no_gravado
                 , l.cod_tipo_comprovante as tipo_comprovante
                 , l.tipo_formulario
                 , l.cod_comprovante
                 , l.docto_pagamento
                 , l.lancamento_id
                 , l.jurisdicao_ib
                 , lb.controle_id as controle_id_caixa
                 , (select cc.caixa_id
                      from finan.v$finan_caixa_controle cc
                     where cc.controle_id = lb.controle_id
                   ) as caixa_id
                 , lb.num_docto
                 , lb.cod_centro_custo
                 , (select cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = lb.cod_centro_custo
                   ) as centro_custo
                 , lb.complemento
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = a.cod_pessoa_posto
                   )  as cnpj_cpf
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = a.cod_pessoa_posto
                   ) as posto
                 , a.cod_pessoa_posto as cod_fornecedor
                 , to_char(lb.data_lancamento, 'dd/mm/yyyy hh24:mi') as data_lancamento
                 , to_char(l.data_comprovante, 'dd/mm/yyyy hh24:mi') as data_comprovante
                 , to_char(a.data_hora, 'dd/mm/yyyy hh24:mi') as data_abastecimento
              from (select a.placa
                         , a.km
                         , a.quantidade
                         , a.produto_id
                         , a.cod_pessoa_motorista
                         , a.data_hora
                         , a.lancto_caixa_intc_id
                         , a.controle_id
                         , a.user_insert
                         , a.valor_total
                         , a.cod_pessoa_posto
                      from oper.v$abastecimento a
                     order by a.data_hora desc) a
             inner join finan.v$finan_caixa_lancamento_arg l
                     on l.lancamento_id = a.lancto_caixa_intc_id
             inner join finan.v$finan_caixa_lancamento lb
                     on lb.lancamento_id = l.lancamento_id
             where 1 = 1
			 <cfif len(trim(arguments.controle_id))>
			 	and a.controle_id = #arguments.controle_id#
			 </cfif>
             <cfif len(trim(arguments.lancamento_id))>
			 	and l.lancamento_id = #arguments.lancamento_id#
			 </cfif>
			 <cfif len(trim(arguments.docto_pagamento))>
			 	and l.docto_pagamento = '#arguments.docto_pagamento#'
			 </cfif>      
			 <cfif Len(Trim(arguments.data_lancamento_inicial))>
                and lb.data_lancamento >= to_date('#arguments.data_lancamento_inicial#', 'dd/mm/yyyy')
             </cfif>
             <cfif Len(Trim(arguments.data_lancamento_final))>
                and lb.data_lancamento <= to_date('#arguments.data_lancamento_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
             </cfif>      
             <cfif arguments.rownum_limite eq 1>             
                and rownum <= 10
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Consulta lancamentos de recibos
	-- GUTO  20/09/2007
	--->		
	<cffunction name="get_recebimentos" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_recibo, r.cod_posto_venda, r.data_emissao, c.razao_social, rp.valor, rp.valor_moeda2,
                   fp.descricao, fp.cod_conta_contabil_arg, rp.cotacao_moeda2,
						       (select kss.fnc_concat_all(kss.to_concat_expr(c.numero_cod_pais || '.' || c.numero_certificado || '.' || c.numero_sequencial,' / '))
									    from fiscal.v$intc_fatura_item fi
								     inner join fiscal.v$intc_conhecimento c
										         on fi.conhecimento_id = c.conhecimento_id
									   inner join fiscal.v$intc_recibo_fatura rf
										         on rf.fatura_id = fi.fatura_id			 
									   where rf.recibo_id = r.recibo_id) as crts,
                     case
                         when rp.forma_pagto_id = 2 then (select pc.banco || ' Num.:' || pc.num_cheque
                                                             from fiscal.v$intc_recibo_pagto_cheque pc
                                                            where pc.pagto_id = rp.pagto_id)
                     else ''
					 end cheque       
              from fiscal.v$intc_recibo r
             inner join fiscal.v$intc_recibo_pagto rp
                     on rp.recibo_id = r.recibo_id
             inner join fiscal.v$intc_forma_pagto fp
                     on fp.forma_pagto_id = rp.forma_pagto_id         
             inner join fiscal.v$intc_clientes c
                     on c.cod_pessoa = r.cod_pessoa_cliente         
             where 1=1  
		   <cfif len(trim(arguments.data_inicial))>
	   		 and r.data_emissao >= '#arguments.data_inicial#'
		   </cfif>
		   <cfif len(trim(arguments.data_final))>
	   		 and r.data_emissao <= '#arguments.data_final#'
		   </cfif>
            order by r.data_emissao		 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Consulta faturas para IVA VENTAS
	-- GUTO  26/09/2007
	--->		
	<cffunction name="get_faturas_iva_ventas" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select case
                     when f.tipo_fatura = 1 then 'FC'
                     when f.tipo_fatura = 2 then 'ND'
                     when f.tipo_fatura = 3 then 'NC'
                   end tipo, 
                   
                   f.cod_tipo, 
				   case 
				       when trim(f.COD_TIPO) = 'E' then 
                         to_char(f.num_duplicata,'0000') || '-' || to_char(f.num_fatura,'00000000')
                   else 
                         '0001-' || to_char(f.num_fatura,'00000000') end num_fatura,                     
                   f.data_emissao, 
                   decode(f.cancelada,1,'',p.cnpj_cpf) as cnpj_cpf,
                   decode(f.cancelada,1,'CANCELADA',p.razao_social) as cliente,
                   nvl(f.valor_iva,0) as valor_iva,
                   nvl(f.cotacao_moeda2,0) as cotacao_moeda2,
                   nvl(f.valor_total,0) as valor_uss,
                   decode(f.cancelada,1,'',nvl(f.valor_moeda2,0)) as valor_pesos,
                   decode(f.cancelada,1,'',nvl(f.valor_moeda2,0)+nvl(f.valor_iva,0)) as valor_total,
                   f.user_insert, '2800000' as cod_conta_contabil                   
              from fiscal.v$intc_fatura f
             inner join kss.v$pessoa p
                     on p.cod_pessoa = f.cod_pessoa_cliente
             where 1=1 --p.tipo_pessoa = 2
               and trim(f.COD_TIPO) <> 'BR'
		   <cfif len(trim(arguments.data_inicial))>
	   		 and f.data_emissao >= '#arguments.data_inicial#'
		   </cfif>
		   <cfif len(trim(arguments.data_final))>
	   		 and f.data_emissao <= '#arguments.data_final#'
		   </cfif>
             order by f.data_emissao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Consulta faturas para IVA COMPRAS
	-- GUTO  26/09/2007
	--->		
	<cffunction name="get_faturas_iva_compras" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select distinct cla.tipo_formulario, cla.cod_tipo_comprovante, cla.cod_comprovante,
               nvl(cla.data_comprovante,cl.data_lancamento) as data_comprovante, p.cnpj_cpf as cuit, p.cliente, cla.valor_neto,
               cla.valor_iva, cla.valor_exentos, cla.valor_no_gravado, cla.valor_ret_ir,
                     cla.jurisdicao_ib, nvl(cla.precep_iva,0) as precep_iva, cla.valor_total,
                     fch.historico_arg,  fch.cod_contabil_arg,
                     to_char(cl.data_lancamento, 'dd/mm/yyyy hh24:mi') as data_lancamento, cl.lancamento_id
          from finan.v$finan_caixa ca
            inner join finan.v$finan_caixa_controle cc
                    on cc.caixa_id = cc.caixa_id
            inner join finan.v$finan_caixa_lancamento cl
                    on cl.controle_id = cc.controle_id
            inner join finan.v$finan_caixa_lancamento_arg cla
                    on cla.lancamento_id = cl.lancamento_id
            inner join finan.v$finan_caixa_historico_arg fch
                    on fch.cod_historico_arg = cla.cod_historico_arg				
           left join kss.v$pessoa p 
                    on p.cod_pessoa = cla.cod_pessoa_fornecedor
            where cla.cod_tipo_comprovante <> '--'
              and cl.receita = 0					
              and ca.cod_pessoa_filial = #session.cod_pessoa#
		   <cfif len(trim(arguments.data_inicial))>
	   		 and trunc(coalesce(cl.data_lancamento, cla.data_comprovante)) >= '#arguments.data_inicial#'
		   </cfif>
		   <cfif len(trim(arguments.data_final))>
	   		 and trunc(coalesce(cl.data_lancamento, cla.data_comprovante)) <= '#arguments.data_final#'
		   </cfif>
           order by data_lancamento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Consulta tipos de pagamento
	-- GUTO  28/06/2007
	--->		
	<cffunction name="get_caixa_pagamento_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo_pagamento_id, descricao
              from finan.v$finan_caixa_pagto_tipo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 

	<!--- 
	-- PROPSITO 
	-- Consulta pagamentos em caixa
	-- GUTO  17/11/2007
	--->		
	<cffunction name="get_caixa_pagamento_arg" access="remote" returntype="query" output="true">
    	<cfargument name="pagamento_id" required="no" default="">
        <cfargument name="cod_comprovante" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="caixa_id" required="no" default="">
        <cfargument name="data_lancamento" required="no" default="">
        <cfargument name="todos" required="no" default="0">        
		<cfquery result="return" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pagamento_id, cod_comprovante, tipo_pagamento_id, data_lancamento, data_comprovante,
                   controle_id, cod_historico_arg, complemento, valor_total, caixa, historico_arg, num_caixa,
                   tipo_pagamento, saldo
              from (select cp.pagamento_id, cp.cod_comprovante, cp.tipo_pagamento_id, 
                           cp.data_lancamento, cp.data_comprovante, cp.controle_id,  
                           cp.cod_historico_arg, cp.complemento, cp.valor_total,
                           fc.descricao as caixa, ch.historico_arg, fc.num_caixa,
                           cpt.descricao as tipo_pagamento, 
                           cp.valor_total - nvl((select sum(cla.valor_total) 
												   from finan.v$finan_caixa_lancamento_arg cla
									              where cla.pagamento_id = cp.pagamento_id),0) as saldo
                      from finan.v$finan_caixa_pagto_arg cp
                     inner join finan.v$finan_caixa_controle cc
                             on cc.controle_id = cp.controle_id
                     inner join finan.v$finan_caixa fc 
                             on fc.caixa_id = cc.caixa_id
                     inner join finan.v$finan_caixa_historico_arg ch
                             on ch.cod_historico_arg = cp.cod_historico_arg
                     inner join finan.v$finan_caixa_pagto_tipo cpt
                             on cpt.tipo_pagamento_id = cp.tipo_pagamento_id
                     where 1=1
                     <cfif Len(Trim(arguments.pagamento_id))>
                       and cp.pagamento_id = #arguments.pagamento_id#
                     </cfif>        
                     <cfif Len(Trim(arguments.caixa_id))>
                       and fc.caixa_id = #arguments.caixa_id#
                     </cfif>        
                     <cfif Len(Trim(arguments.data_lancamento))>
                       and trunc(cp.data_lancamento) = '#Left(arguments.data_lancamento,10)#'
                     </cfif>        
                     <cfif Len(Trim(arguments.cod_comprovante))>
                       and cp.cod_comprovante like '#arguments.cod_comprovante#%'
                     </cfif>        
                     <cfif Len(Trim(arguments.data_inicio))>
                       and trunc(cp.data_lancamento) >= '#arguments.data_inicio#'
                     </cfif>        
                     <cfif Len(Trim(arguments.data_fim))>
                       and trunc(cp.data_lancamento) <= '#arguments.data_fim#'
                     </cfif>
                   )    
                <cfif arguments.todos eq 0>
                	where saldo > 0
                </cfif> 
            order by data_lancamento  
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>            

	<!--- 
	-- PROPSITO 
	-- Consulta despesas pagas
	-- GUTO  17/11/2007
	--->		
	<cffunction name="get_caixa_pagamentos" access="remote" returntype="query" output="true">
   	  <cfargument name="cod_comprovante" required="no" default="">
        <cfargument name="caixa_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
		<cfquery result="return" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select 
                 fc.caixa_id,fc.descricao as caixa,
          		  fcp.pagamento_id, cpt.descricao as tipo_pagto,
                 fcp.cod_comprovante, fcp.data_lancamento, fcp.data_comprovante,
                 fcp.complemento, fcp.valor_total,
                 fcp.valor_total - nvl(sum(cla.valor_total) over(partition by cla.pagamento_id order by cla.pagamento_id),0) as saldo, 
                 ha.historico_arg, 
                 cl.complemento as complemento_despesa, 
                 cla.data_comprovante as data_despesa, cl.data_lancamento as data_lancto_despesa,
                 cla.valor_total as valor_despesa, cla.cod_comprovante as cod_comprovante_despesa, 
                 nvl(sum(cla.valor_total) over(partition by cla.pagamento_id order by cla.pagamento_id),0) as valor_usado
              from finan.v$finan_caixa_pagto_arg fcp
             <!---/* inicio - filtra por caixa */--->
             inner join finan.v$finan_caixa_controle fcc on fcc.controle_id = fcp.controle_id
             inner join finan.v$finan_caixa fc on fc.caixa_id = fcc.caixa_id
             <!---/* fim    - filtra por caixa */--->
             left join finan.v$finan_caixa_pagto_tipo cpt
                     on cpt.tipo_pagamento_id = fcp.tipo_pagamento_id
             left join finan.v$finan_caixa_lancamento_arg cla
                     on cla.pagamento_id = fcp.pagamento_id
             left join finan.v$finan_caixa_lancamento cl
                     on cl.lancamento_id = cla.lancamento_id
             left join finan.v$finan_caixa_historico_arg ha
                     on ha.cod_historico_arg = cla.cod_historico_arg
             where 1=1
             <cfif Len(Trim(arguments.cod_comprovante))>
               and fcp.cod_comprovante = #arguments.cod_comprovante#
				 </cfif>
				 <cfif Len(Trim(arguments.caixa_id))>
               and fc.caixa_id = #arguments.caixa_id#
             </cfif>            
             <cfif Len(Trim(arguments.data_inicio))>
               and trunc(fcp.data_lancamento) >= '#arguments.data_inicio#'
             </cfif>        
             <cfif Len(Trim(arguments.data_fim))>
               and trunc(fcp.data_lancamento) <= '#arguments.data_fim#'
             </cfif>
             
            order by fcp.pagamento_id, cla.data_comprovante
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>     

	<!--- 
	-- PROPSITO
	-- Contrato de Transporte
	-- GUTO 14/01/2009 - CRIADO
	--->
	
	<cffunction name="get_dados_contrato_transporte" displayname="Busca os dados do contrato de transporte" access="remote" returntype="query" output="true">
		<cfargument name="lancto_id" required="no" default="">
		<cfargument name="num_formulario" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_contrato" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select distinct lancto_id, num_romaneio, 
        	   to_char(data_emissao,'dd/mm/yyyy') as data_emissao, filial, setor, 
			   remetente, origem, org_uf, destino, destinatario, 
			   frete_em, peso, tolerancia_falta, valor_frete_bruto, 
			   especie, volume, motorista_cod_pessoa, motorista, 
			   cnh_num_registro, placa_controle, oper.fnc_get_cod_veiculo(placa_controle) as frota,
               placa_referencia, 
			   proprietario_cod_pessoa, proprietario, proprietario_cnpj_cpf, 
			   proprietario_endereco, proprietario_nit, prop_municipio, prop_uf, 
			   observacao, notas_fiscais, ct.valor_frete_liquido,
         nvl((select sum(valor) 
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ct.lancto_id
             and cti.item_id = 1),0) as valor_pedagio,
         nvl((select sum(valor) 
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ct.lancto_id
             and cti.item_id = 21),0) as inss,
         nvl((select sum(valor) 
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ct.lancto_id
             and cti.item_id = 20),0) as irrf,
         nvl((select sum(valor) 
            from oper.v$contrato_transp_item cti
           where cti.lancto_id = ct.lancto_id
             and cti.item_id = 7),0) as adiantamento,
          (select nvl(sum(cti.valor), 0)
					  from oper.v$contrato_transp_item cti
			   where cti.lancto_id = ct.lancto_id
             and cti.desconto = 1) total_descontos,
		  ( ct.valor_frete_liquido  +
          (select nvl(sum(cti.valor), 0)
					  from oper.v$contrato_transp_item cti
			   where cti.lancto_id = ct.lancto_id
             and cti.desconto = 0) -
          (select nvl(sum(cti.valor), 0)
					  from oper.v$contrato_transp_item cti
			   where cti.lancto_id = ct.lancto_id
             and cti.desconto = 1)) as saldo_receber			 		  
		  from oper.v$contrato_transporte ct
		 where ct.tipo_contrato = 1
         <cfif Len(Trim(arguments.lancto_id))>
          and ct.lancto_id = #arguments.lancto_id#
         </cfif>
         <cfif Len(Trim(arguments.NUM_FORMULARIO))>
           and ct.num_formulario = #arguments.NUM_FORMULARIO#
         </cfif>
         <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
           and ct.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
         </cfif>
         <cfif Len(Trim(arguments.num_romaneio))>
           and ct.num_romaneio = #Val(arguments.num_romaneio)#
         </cfif>
         <cfif Len(Trim(arguments.data_inicial))>
           and ct.data_emissao >= '#arguments.data_inicial#'
         </cfif>
         <cfif Len(Trim(arguments.data_final))>
           and ct.data_emissao <= '#arguments.data_final#'
         </cfif>
         <cfif Len(Trim(arguments.cod_veiculo))>
           and oper.fnc_get_cod_veiculo(ct.placa_controle) = '#arguments.cod_veiculo#'
         </cfif>         
         order by data_emissao
	</cfquery>		
	<cfreturn qr_contrato>							 
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca opagamentos vinculados a CFA
	-- GUTO  15/01/2008
	--->		
	<cffunction name="get_pagamentos_cfa" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="no" default=""/>        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.lancto_id, ct.num_romaneio, ctc.lancamento_id,
                   decode(ctc.tipo_pagto,0,'Parcial',1,'Final','Total') as tipo_pagto,
                   ctc.valor,
                   decode(ctc.tipo_id,1,'Saldo','Adiantamento') as tipo,
                   to_char(fc.data_lancamento,'dd/mm/yyyy hh24:mi') as data_lancamento, 
                   fc.valor as valor_pesos
              from oper.v$contrato_transp_caixa ctc
              inner join oper.v$contrato_transp_todos ct
                      on ct.lancto_id = ctc.lancto_id 
              inner join finan.v$finan_caixa_lancamento fc
                      on fc.lancamento_id = ctc.lancamento_id
              where 1=1
              <cfif Len(Trim(arguments.lancto_id))>
                and ctc.lancto_id = #arguments.lancto_id#
              </cfif>
              order by fc.data_lancamento
        </cfquery>
		<cfreturn qr_result>		
	</cffunction>      
    
	<!--- 
	-- PROPSITO 
	-- Busca cotaoes
	-- GUTO  28/06/2007
	--->		
	<cffunction name="get_cotacao_moedas" access="remote" returntype="query" output="true">
    	<cfargument name="moeda_origem" required="no" default=""/>
    	<cfargument name="moeda_conversao" required="no" default=""/>
    	<cfargument name="data" required="no" default=""/>        
    	<cfargument name="intervalo" required="no" default="0"/>        
        <cftry>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select a.cotacao.taxa_compra as taxa_compra, a.cotacao.taxa_venda as taxa_venda  
                  from (select finan.to_cotacao(#arguments.moeda_origem#,#arguments.moeda_conversao#,to_date('#arguments.data#','dd/mm/yyyy hh24:mi') + #arguments.intervalo#) as cotacao
                          from dual) a
            </cfquery>
         <cfcatch>
         	<cfscript>
			   qr_result = QueryNew('erro','VarChar');
			   temp = QueryAddRow(qr_result,1);
			   temp = QuerySetCell(qr_result,"erro",cfcatch.Detail,1);
			</cfscript>
         </cfcatch>
         </cftry>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os Centros de Custo referentes a uma unidade de negcio
	-- RAFAEL 17/11/2009
	--->		
	<cffunction name="get_centro_custo_un_negocio" access="remote" returntype="query" output="true">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfargument name="centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select cc.cod_centro_custo
                   , centro_custo
                   , un.cod_pessoa
                from kss.v$centro_custo cc
               inner join kss.v$organograma o
                  on cc.cod_centro_custo = o.cod_centro_custo
               inner join kss.v$unidade_negocio un
                  on un.cod_pessoa = o.cod_pessoa
            order by un.cod_pessoa, cc.cod_centro_custo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as transferncias entre caixas
    -- ANDERSON 14/06/2010 - CRIADO
    --->		
    <cffunction name="get_caixa_transferencia" access="remote" returntype="query" output="true">
    	<cfargument name="cod_transferencia" required="no" default="">
        <cfargument name="usuario" required="no" default="">
        <cfargument name="num_comprovante" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.cod_transferencia
                 , ct.controle_id_debito
                 , (select p.cnpj_cpf || ' - ' || p.razao_social
                      from finan.v$finan_caixa c
                     inner join kss.v$pessoa p
                        on p.cod_pessoa = c.cod_pessoa_filial
                     where c.caixa_id = cc.caixa_id
                   ) as unidade_negocio_origem
                 , (select c.num_caixa || ' - ' || c.descricao
                      from finan.v$finan_caixa c
                     where c.caixa_id = cc.caixa_id
                   ) as caixa_debito_descricao
                 , ct.lancamento_id_debito
                 , (select p.cod_pessoa
                      from finan.v$finan_caixa c
                     inner join kss.v$pessoa p
                        on p.cod_pessoa = c.cod_pessoa_filial
                     where c.caixa_id = ct.caixa_id_credito
                   ) as cod_pessoa_filial_destino
                 , ct.caixa_id_credito
                 , (select c.num_caixa || ' - ' || c.descricao
                      from finan.v$finan_caixa c
                     where c.caixa_id = ct.caixa_id_credito
                   ) as caixa_credito_descricao
                 , ct.lancamento_id_credito
                 , ct.num_comprovante
                 , ct.valor
                 , to_char(ct.data_transferencia, 'dd/mm/yyyy hh24:mi') as data_transferencia
                 , cld.cod_historico
                 , cld.complemento
                 , substr(cld.complemento, 1, instr(cld.complemento, '-') - 2) as historico
                 , substr(cld.complemento, instr(cld.complemento, '-') + 2, length(cld.complemento)) as complemento_parcial
                 , cld.cod_centro_custo as cod_centro_custo_debito
                 , clc.cod_centro_custo as cod_centro_custo_credito
                 , to_char(ct.data_confirmacao, 'dd/mm/yyyy hh24:mi') as data_confirmacao
              from finan.v$finan_caixa_transferencia ct
             inner join finan.v$finan_caixa_controle cc
                     on cc.controle_id = controle_id_debito
             inner join finan.v$finan_caixa_lancamento cld
                     on cld.lancamento_id = ct.lancamento_id_debito
             inner join finan.v$finan_caixa_lancamento clc
                     on clc.lancamento_id = ct.lancamento_id_credito
             where 1 = 1
			<cfif Len(Trim(arguments.cod_transferencia))>
               and ct.cod_transferencia = #arguments.cod_transferencia#
            </cfif>
            <cfif Len(Trim(arguments.usuario))>
               and upper(cc.usuario) = upper('#arguments.usuario#')
            </cfif>
            <cfif Len(Trim(arguments.num_comprovante))>
               and ct.num_comprovante = #arguments.num_comprovante#
            </cfif>
            <cfif Len(Trim(arguments.data_inicial))>
               and ct.data_transferencia >= to_date('#arguments.data_inicial#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_final))>
               and ct.data_transferencia <= to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
             order by ct.data_transferencia desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca Baixa de DTI
	-- ERIC 05/11/2010
	--->		
	<cffunction name="get_baixa_dti" access="remote" returntype="query" output="true">
        <cfargument name="controle_id"             required="no" default="">
        <cfargument name="lancamento_id"           required="no" default="">
        <cfargument name="docto_pagamento"         required="no" default="">
        <cfargument name="data_lancamento_inicial" required="no" default="">
        <cfargument name="data_lancamento_final"   required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select idc.controle_id as controle_lancto_id
                 , idc.despacho_id
                 , idc.lancamento_id
                 , d.cod_pessoa_filial
                 , d.num_despacho
                 , d.serie
                 , idc.tipo_id
                 , (select rc.rv_meaning
                      from fiscal.v$cg_ref_codes rc
                     where rc.rv_domain = 'INTC_DESPACHO_CAIXA.TIPO_ID'
                       and rc.rv_low_value = idc.tipo_id
                   ) as tipo
                 , lb.controle_id
                 , (select cc.caixa_id
                      from finan.v$finan_caixa_controle cc
                     where cc.controle_id = lb.controle_id
                   ) as caixa_id
                 , to_char(lb.data_lancamento, 'dd/mm/yyyy hh24:mi') as data_lancamento
                 , idc.tipo_pagto
                 , (select rc.rv_meaning
                      from fiscal.v$cg_ref_codes rc
                     where rc.rv_domain = 'INTC_DESPACHO_CAIXA.TIPO_PAGTO'
                       and rc.rv_low_value = idc.tipo_pagto
                   ) as tipo_pagto_desc
                 , idc.valor
                 , lb.valor as valor_pesos
                 , l.docto_pagamento
                 , l.cod_comprovante
                 , to_char(l.data_comprovante, 'dd/mm/yyyy') as data_comprovante
                 , l.cod_tipo_comprovante
                 , l.tipo_formulario
                 , l.cod_pessoa_fornecedor
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = l.cod_pessoa_fornecedor
                   ) as cnpj_fornecedor
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = l.cod_pessoa_fornecedor
                   ) as nome_fornecedor
                 , lb.complemento
                 , l.cod_historico_arg
                 , (select h.historico_arg
                      from finan.v$finan_caixa_historico_arg h
                     where h.cod_historico_arg = l.cod_historico_arg
                   ) as historico_arg
                 , l.valor_neto
                 , l.valor_exentos
                 , l.valor_iva
                 , l.valor_ret_ir
                 , l.jurisdicao_ib
                 , l.precep_iva
                 , l.valor_no_gravado
                 , l.valor_total
              from fiscal.v$intc_despacho_caixa idc
             inner join fiscal.v$intc_despacho d
                     on d.despacho_id = idc.despacho_id
             inner join finan.v$finan_caixa_lancamento_arg l
                     on l.lancamento_id = idc.lancamento_id
             inner join finan.v$finan_caixa_lancamento lb
                     on lb.lancamento_id = idc.lancamento_id
             where 1 = 1
			<cfif len(trim(arguments.controle_id))>
               and idc.controle_id = #arguments.controle_id#
			</cfif>
            <cfif len(trim(arguments.lancamento_id))>
               and idc.lancamento_id = #arguments.lancamento_id#
			</cfif>
			<cfif len(trim(arguments.docto_pagamento))>
               and l.docto_pagamento = '#arguments.docto_pagamento#'
			</cfif>
			<cfif Len(Trim(arguments.data_lancamento_inicial))>
               and lb.data_lancamento >= to_date('#arguments.data_lancamento_inicial#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_lancamento_final))>
               and lb.data_lancamento <= to_date('#arguments.data_lancamento_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
             order by lb.data_lancamento desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Baixa de CFA
	-- ERIC 05/11/2010
	--->		
	<cffunction name="get_baixa_contrato_transp" access="remote" returntype="query" output="true">
        <cfargument name="controle_id"             required="no" default="">
        <cfargument name="lancamento_id"           required="no" default="">
        <cfargument name="docto_pagamento"         required="no" default="">
        <cfargument name="data_lancamento_inicial" required="no" default="">
        <cfargument name="data_lancamento_final"   required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctc.controle_id as controle_lancto_id
                 , ctc.lancto_id
                 , ctc.lancamento_id
                 , ct.num_formulario
                 , ct.serie_formulario
                 , ctc.tipo_id
                 , lb.controle_id
                 , (select cc.caixa_id
                      from finan.v$finan_caixa_controle cc
                     where cc.controle_id = lb.controle_id
                   ) as caixa_id
                 , to_char(lb.data_lancamento, 'dd/mm/yyyy hh24:mi') as data_lancamento
                 , ctc.tipo_pagto
                 , (select rc.rv_meaning
                      from fiscal.v$cg_ref_codes rc
                     where rc.rv_domain = 'INTC_DESPACHO_CAIXA.TIPO_PAGTO'
                       and rc.rv_low_value = ctc.tipo_pagto
                   ) as tipo_pagto_desc
                 , ctc.valor
                 , lb.valor as valor_pesos
                 , l.docto_pagamento
                 , l.cod_comprovante
                 , to_char(l.data_comprovante, 'dd/mm/yyyy') as data_comprovante
                 , l.cod_tipo_comprovante
                 , l.tipo_formulario
                 , l.cod_pessoa_fornecedor
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = l.cod_pessoa_fornecedor
                   ) as cnpj_fornecedor
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = l.cod_pessoa_fornecedor
                   ) as nome_fornecedor
                 , lb.complemento
                 , l.cod_historico_arg
                 , (select h.historico_arg
                      from finan.v$finan_caixa_historico_arg h
                     where h.cod_historico_arg = l.cod_historico_arg
                   ) as historico_arg
                 , l.valor_neto
                 , l.valor_exentos
                 , l.valor_iva
                 , l.valor_ret_ir
                 , l.jurisdicao_ib
                 , l.precep_iva
                 , l.valor_no_gravado
                 , l.valor_total
              from oper.v$contrato_transp_caixa ctc
             inner join oper.v$contrato_transporte ct
                     on ct.lancto_id = ctc.lancto_id
                    and ct.tipo_contrato = 1
             inner join finan.v$finan_caixa_lancamento_arg l
                     on l.lancamento_id = ctc.lancamento_id
             inner join finan.v$finan_caixa_lancamento lb
                     on lb.lancamento_id = ctc.lancamento_id
             where 1 = 1
			<cfif len(trim(arguments.controle_id))>
               and ctc.controle_id = #arguments.controle_id#
			</cfif>
            <cfif len(trim(arguments.lancamento_id))>
               and ctc.lancamento_id = #arguments.lancamento_id#
			</cfif>
			<cfif len(trim(arguments.docto_pagamento))>
               and l.docto_pagamento = '#arguments.docto_pagamento#'
			</cfif>
			<cfif Len(Trim(arguments.data_lancamento_inicial))>
               and lb.data_lancamento >= to_date('#arguments.data_lancamento_inicial#', 'dd/mm/yyyy')
            </cfif>
            <cfif Len(Trim(arguments.data_lancamento_final))>
               and lb.data_lancamento <= to_date('#arguments.data_lancamento_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
             order by lb.data_lancamento desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>