<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de caixas" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca todos os caixas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  30/12/2005
	--->		
	<cffunction name="get_caixas" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" 	required="yes">
		<cfargument name="cod_departamento" 	required="no" default="">
		<cfargument name="cod_setor" 			required="no" default="">
		<cfargument name="cod_centro_custo" 	required="no" default="">
		<cfargument name="controle_id"		 	required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr" username="#session.usuario#" password="#session.senha#">
				SELECT cc.controle_id, cc.data_abertura, decode(cc.data_encerramento, null, 'Aberto', 'Encerrado') situacao,                 
						   cg.num_caixa, s.descricao setor, cg.cod_pessoa, cg.cod_departamento, cg.cod_setor, cg.cod_centro_custo,
				   cc.usuario, cg.finalidade_id,  tp.descricao as tipo, cf.descricao finalidade, s.descricao as setor, 
						   nvl(finan.pkg_caixa.fnc_caixa_saldo_data(cg.cod_pessoa, cg.cod_departamento, cg.cod_setor, cg.cod_centro_custo, cg.num_caixa, sysdate), 0) Saldo,
				   to_char(cg.num_caixa,'000') || ' - ' || tp.descricao ||' - '|| cc.usuario  as caixa          
				  from finan.v$caixa_gestao cg,          
						   finan.v$caixa_finalidade cf,         
						   finan.v$caixa_tipo tp, 
						   finan.v$caixa_controle cc,  
				   oper.v$setor s
				 where cg.cod_pessoa = #arguments.cod_pessoa_filial#
				 <cfif len(trim(arguments.cod_departamento))>
				   and cg.cod_departamento = #arguments.cod_departamento#
				 </cfif>
				 <cfif len(trim(arguments.cod_setor))>
				   and cg.cod_setor = #arguments.cod_setor#
				 </cfif>
				 <cfif len(trim(arguments.cod_centro_custo))>
				   and cg.cod_centro_custo = #arguments.cod_centro_custo#
				 </cfif>
				 <cfif len(trim(arguments.controle_id))>
				   and cc.controle_id = '#arguments.controle_id#'
				 </cfif>
				   and cg.finalidade_id = cf.finalidade_id     
				   and cg.tipo_id = tp.tipo_id 
				   and cg.ativo = 1 
				   and cg.cod_pessoa = s.cod_pessoa_filial
				   and cg.cod_setor = s.cod_setor
				   and cg.num_caixa  = cc.num_caixa      
				   and cg.cod_departamento = cc.cod_departamento
				   and cg.cod_setor = cc.cod_setor
				   and cg.cod_centro_custo = cc.cod_centro_custo
				   and cg.cod_pessoa  = cc.cod_pessoa
				   and cc.data_abertura = (select max(ctrl.data_abertura)  
															 FROM finan.v$caixa_controle ctrl  
															WHERE ctrl.num_caixa  = cc.num_caixa                                  
															and ctrl.cod_departamento = cc.cod_departamento
										  and ctrl.cod_setor = cc.cod_setor
										  and ctrl.cod_centro_custo = cc.cod_centro_custo
															  and ctrl.cod_pessoa  = cc.cod_pessoa)      
					 ORDER BY s.descricao, num_caixa, finalidade_id
		</cfquery>
		<cfreturn qr>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca todos os historicos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  30/12/2005
	--->
	<cffunction name="get_historico" displayname="Busca todos os histricos" access="remote" returntype="query" output="true">
    	<cfargument name="uso_internet" required="no" default="">
        <cfargument name="cod_historico" required="no" default="">
        <cfargument name="historico" required="no" default="">
        <cfargument name="filtro" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_historico" username="#session.usuario#" password="#session.senha#">
			select cod_historico, historico     
			  from finan.v$caixa_historico   
			 where 1=1
             and ativo = 1
             <cfif Len(Trim(arguments.uso_internet))>
             	and uso_internet = #arguments.uso_internet#
             </cfif>
             <cfif Len(Trim(arguments.cod_historico))>
             	and cod_historico = #arguments.cod_historico#
             </cfif>
             <cfif Len(Trim(arguments.historico)) >
             	and upper(historico) like upper('%#arguments.historico#%')
             </cfif>
             <cfif Len(Trim(arguments.filtro))>
				<cfif IsNumeric(arguments.filtro)>
	                and cod_historico = #arguments.filtro#
                <cfelse>
	             	and upper(historico) like upper('%#arguments.filtro#%')
				</cfif>
             </cfif>
             order by cod_historico
 		</cfquery>
		<cfreturn qr_historico>
	</cffunction>		
	<!--- 
	-- PROPSITO 
	-- Unidade Monetaria
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  30/12/2005
	--->
	<cffunction name="get_unidade" displayname="Unidade Monetria" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_unidade_monet" username="#session.usuario#" password="#session.senha#">
			select unidade_id, unidade_id as cod_unidade, descricao unidade    
			  from finan.v$caixa_unidade_monetaria   
			 order by cod_unidade 
		</cfquery>
		<cfreturn qr_unidade_monet>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Pega o saldo anterior
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  30/12/2005
	--->
	<cffunction name="get_caixa_saldo_anterior" access="remote" returntype="query" output="true">
		<cfargument name="num_caixa" displayname="Caixa" type="numeric" required="true">
		<cfargument name="cod_pessoa_filial" displayname="CNPJ ordem filial" type="string" required="true">
		<cfargument name="cod_departamento" displayname="CNPJ ordem filial" type="string" required="true">
		<cfargument name="cod_setor" displayname="CNPJ ordem filial" type="string" required="true">
		<cfargument name="cod_centro_custo" displayname="CNPJ ordem filial" type="string" required="true">
		<cfargument name="data" displayname="Perodo" type="date" required="true">
		<cfargument name="saldo_anterior" displayname="FLAG" required="false" default="0">
		<cfquery datasource="#session.dsn#" name="qr_saldo_anterior" username="#session.usuario#" password="#session.senha#">
			select finan.pkg_caixa.fnc_caixa_saldo_data(#arguments.cod_pessoa_filial#, #arguments.cod_departamento#,#arguments.cod_setor#, #arguments.cod_centro_custo#,#arguments.num_caixa#,to_date('#arguments.data#','dd/mm/yyyy')-1/1440) as saldo_anterior
			  from dual
		</cfquery>
		<cfreturn qr_saldo_anterior>
	</cffunction>
	<!--- 
	-- PROPSITO 
	-- Busca as movimentaes de caixa no periodo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  02/01/2006
	--->
	<cffunction name="get_movimentacao" displayname="Busca a movimentacao do controle passado" access="remote" returntype="query" output="true">
		<cfargument name="controle_id" 			required="no">
		<cfargument name="num_caixa" 			required="no">
		<cfargument name="cod_pessoa_filial" 	required="no">
		<cfargument name="cod_departamento" 	required="no">
		<cfargument name="cod_setor" 			required="no">
		<cfargument name="cod_centro_custo" 	required="no">
		<cfargument name="data_inicial" 		required="no">
		<cfargument name="data_final" 			required="no">
		<cfquery datasource="#session.dsn#" name="qr_movimentacao" username="#session.usuario#" password="#session.senha#">
			<cfif isDefined("arguments.controle_id") and len(trim(arguments.controle_id))>
				SELECT /*+ leading(c) */  cc.num_caixa, c.user_insert as apelido,                   
						 c.lancamento_id, c.data_lancamento, c.controle_id, c.num_docto,                   
						 c.cod_historico, ch.historico, c.complemento,                  
						 c.cod_pessoa, c.cod_departamento, c.cod_setor, c.cod_centro_custo,          
						 sum(decode(it.receita, 1, valor, 0)) receita,                  
						 sum(decode(it.receita, 0, valor, 0)) despesa, 0 SaldoAnterior    
				  FROM finan.v$caixa_item it, 
			   finan.v$caixa c, 
			   finan.v$caixa_controle cc,                    
						 finan.v$caixa_historico ch
				 WHERE cc.controle_id = #arguments.controle_id#
				   and c.controle_id = cc.controle_id          
				   and c.cod_historico = ch.cod_historico          
				   and c.lancamento_id = it.lancamento_id       
				 group by cc.num_caixa, c.user_insert,                    
						  c.lancamento_id, c.data_lancamento, c.controle_id, c.num_docto,                     
						  c.cod_historico, ch.historico, c.complemento,                    
						  c.cod_pessoa, c.cod_departamento, c.cod_setor, c.cod_centro_custo  
				 ORDER BY data_lancamento 
			<cfelse>
				SELECT /*+ leading(c) */ cc.num_caixa, cc.user_insert as apelido,                   
						   c.lancamento_id, c.data_lancamento, c.controle_id, c.num_docto,                   
						   c.cod_historico, ch.historico, c.complemento,                  
						   c.cod_pessoa, c.cod_departamento, c.cod_setor, c.cod_centro_custo,          
						   sum(decode(it.receita, 1, valor, 0)) receita,                  
						   sum(decode(it.receita, 0, valor, 0)) despesa, 0 SaldoAnterior    
					  FROM oper.v$caixa_item it, 
				 finan.v$caixa c, 
				 finan.v$caixa_controle cc,                    
							 finan.v$caixa_historico ch
					 WHERE c.controle_id = cc.controle_id          
					   and c.cod_historico = ch.cod_historico          
					   and c.lancamento_id = it.lancamento_id       
				   and cc.num_caixa = #arguments.num_caixa#
			 and cc.cod_pessoa = #arguments.cod_pessoa_filial#
			 and cc.cod_departamento = #arguments.cod_departamento#
			 and cc.cod_setor = #arguments.cod_setor#
			 and cc.cod_centro_custo = #arguments.cod_centro_custo#
				   and c.data_lancamento between to_date('#arguments.data_inicial#' || '00:00:00', 'DD/MM/YYYY HH24:MI:SS')
											 and to_date('#arguments.data_final#' || '23:59:59', 'DD/MM/YYYY HH24:MI:SS')			   
					 group by cc.num_caixa, cc.user_insert,                    
								  c.lancamento_id, c.data_lancamento, c.controle_id, c.num_docto,                     
								  c.cod_historico, ch.historico, c.complemento,                    
								  c.cod_pessoa, c.cod_departamento, c.cod_setor, c.cod_centro_custo  
					 ORDER BY c.controle_id, data_lancamento 
			</cfif>
		</cfquery>
		<cfreturn qr_movimentacao>
	</cffunction>	
	<!--- 
	-- PROPSITO 
	-- Busca todas solicitaes de crdito feitas pelo usurio
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  02/01/2006
	--->
	<cffunction name="get_solicitacoes" displayname="Busca todas solicitaes de crdito feitas pelo usurio" access="remote" returntype="query" output="true">
		<cfargument name="lancamento_id" displayname="No caso de solicitaes fechadas passar o n do lanamento" required="false">
		<cfquery datasource="#session.dsn#" name="qr_solicitacoes" username="#session.usuario#" password="#session.senha#">
			<cfif not isDefined("arguments.lancamento_id")>
				select cs.cod_solicitacao,
                       decode(cs.num_documento, '', 's/ nota', cs.num_documento) as num_documento,
                       cs.descricao,
                       cs.valor,
                       cs.data_lancamento,
                       cs.cod_historico,
                       ch.historico
                  from finan.v$caixa_solicitacao cs
                  left join finan.v$caixa_historico ch 
                         on ch.cod_historico = cs.cod_historico
                 where lancamento_id is null
                   and cs.user_insert = user
                 order by cs.cod_solicitacao desc
			<cfelse>
				select /*+ FIRST_ROWS */ distinct cs.cod_solicitacao, cs.num_caixa, DECODE(cs.num_documento,'','s/nota',cs.num_documento) as num_documento, 
					   cs.descricao, cs.valor, cs.data_lancamento,         
					   cs.user_insert, pj.nome_fantasia, s.descricao as setor, cf.descricao as finalidade,
					   c.controle_id
				  from finan.v$caixa_gestao cg
				 inner join finan.v$caixa_solicitacao cs 
						 on cs.num_caixa = cg.num_caixa
						and cs.cod_pessoa = cg.cod_pessoa
						and cs.cod_departamento = cg.cod_departamento
						and cs.cod_setor = cg.cod_setor
						and cs.cod_centro_custo = cg.cod_centro_custo
				 inner join oper.pessoa_juridica pj 
						 on pj.cod_pessoa = cg.cod_pessoa
				 inner join finan.v$caixa_finalidade cf
						 on cg.finalidade_id = cf.finalidade_id
				 inner join oper.v$setor s 
						 on s.cod_pessoa_filial = cs.cod_pessoa
						and s.cod_setor = cs.cod_setor
				  inner join oper.v$caixa c
					 on c.lancamento_id = cs.lancamento_id
				  where cs.lancamento_id = #arguments.lancamento_id#
               order by cs.cod_solicitacao
		</cfif>	
		</cfquery>
		<cfreturn qr_solicitacoes>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as despesas em aberto das filiais
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  04/01/2006
	--->
	<cffunction name="get_despesas_filiais" displayname="Busca as despesas em aberto das filiais" access="remote" returntype="query" output="true">
		<cfargument name="num_caixa" 			required="yes">
		<cfargument name="cod_pessoa_filial" 	required="yes">
		<cfargument name="cod_setor" 			required="yes">
		<cfquery datasource="#session.dsn#" name="qr_despesas" username="#session.usuario#" password="#session.senha#">
			select distinct cs.cod_solicitacao
                 , cs.num_caixa
                 , DECODE(cs.num_documento,999999,'s/nota',1,'s/nota',cs.num_documento) as num_documento
                 , cs.descricao
                 , cs.valor
                 , cs.data_lancamento
                 , cs.user_insert as usuario
                 , pj.nome_fantasia
                 , s.descricao as setor
                 , (select ch.historico
                     from finan.v$caixa_historico ch
                    where ch.cod_historico = cs.cod_historico
                   ) as historico
			  from finan.v$caixa_solicitacao cs 
			  inner join oper.pessoa_juridica pj 
				 on pj.cod_pessoa = cs.cod_pessoa
			  inner join oper.v$setor s
					  on s.cod_setor = cs.cod_setor
			  where lancamento_id is null  
				and cs.num_caixa = #Arguments.num_caixa#
				and cs.cod_setor = #Arguments.cod_setor#
				and cs.cod_pessoa = #Arguments.cod_pessoa_filial#
			  order by cs.cod_solicitacao desc
		</cfquery>
		<cfreturn qr_despesas>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os caixas abertos
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/01/2006
	--->
	<cffunction name="get_caixas_abertos" displayname="Busca todos os caixas abertos" access="remote" returntype="query" output="true">
		<cfargument name="finalidade_id" required="no" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */ cc.num_caixa, cc.controle_id, to_char(cc.num_caixa,'0000') || ' - ' || cf.descricao as caixa,
				   cf.finalidade_id, cc.cod_pessoa ,cg.cod_departamento, cg.cod_setor, cg.cod_centro_custo,
				   pj.cnpj_basico || pj.cnpj_ordem as cnpj_filial, 
				   case 
					 when kss.pkg_global.fnc_obtem_parametro_num(11,'OPERACIONAL',261) - round(sysdate - cc.data_abertura) < 0 then -1
					 when kss.pkg_global.fnc_obtem_parametro_num(11,'OPERACIONAL',261) - round(sysdate - cc.data_abertura) = 0 then 0
					 else kss.pkg_global.fnc_obtem_parametro_num(11,'OPERACIONAL',261) - round(sysdate - cc.data_abertura) end dias_aberto
			  from finan.v$caixa_controle cc 
			 inner join finan.v$caixa_gestao cg 
					 on cc.num_caixa = cg.num_caixa 
					and cc.cod_departamento = cg.cod_departamento
					and cc.cod_setor = cg.cod_setor
					and cc.cod_centro_custo = cg.cod_centro_custo
					and cc.cod_pessoa = cg.cod_pessoa 
			inner join finan.v$caixa_finalidade cf 
					on cg.finalidade_id = cf.finalidade_id   
			inner join oper.v$pessoa_juridica pj
					on cc.cod_pessoa = pj.cod_pessoa
			 where cc.usuario = user
			   and cc.data_encerramento is null
			 <cfif isDefined("arguments.finalidade_id")>
			   and cf.finalidade_id = #arguments.finalidade_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca todas as transferncias em aberto
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/01/2006
	--->
	<cffunction name="get_transferencias" displayname="Busca todas as transferncias em aberto" access="remote" returntype="query" output="true">
		<cfargument name="origem" default="1" required="no" displayname="Caso as consultas sejam por transferncia"/>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.origem EQ 1>
				select /*+ FIRST_ROWS */  t.cod_transferencia, (to_char(ct1.num_caixa,'000') || ' - ' || f1.descricao || ' - ' || ct1.usuario) as caixa_credito,         
					   (to_char(ct2.num_caixa,'000') || ' - ' || f2.descricao) as caixa_debito, t.valor,          
					   t.date_insert  as data_transferencia
				  from finan.v$caixa_transferencia t,         
					   (finan.v$caixa_controle ct1 inner join          
						finan.v$caixa_gestao cg1 on           
						ct1.num_caixa = cg1.num_caixa and          
						ct1.cod_pessoa = cg1.cod_pessoa and
						ct1.cod_departamento = cg1.cod_departamento and          
						ct1.cod_setor = cg1.cod_setor and
						ct1.cod_centro_custo = cg1.cod_centro_custo) inner join          
					   finan.v$caixa_finalidade f1 on          
					   cg1.finalidade_id = f1.finalidade_id,           (
					   finan.v$caixa_controle ct2 inner join          
					   finan.v$caixa_gestao cg2 on           
					   ct2.num_caixa = cg2.num_caixa and          
					   ct2.cod_pessoa = cg2.cod_pessoa and
					   ct2.cod_departamento = cg2.cod_departamento and          
					   ct2.cod_setor = cg2.cod_setor and
					   ct2.cod_centro_custo = cg2.cod_centro_custo) inner join          
					   finan.v$caixa_finalidade f2 on          
					   cg2.finalidade_id = f2.finalidade_id   
				 where t.controle_id_credito = ct1.controle_id      
				   and t.controle_id_debito = ct2.controle_id     
				   and t.lancamento_id_credito is null     
				   and t.lancamento_id_debito is null     
				   and t.user_insert = user
				<cfelse>
					SELECT /*+ FIRST_ROWS */  t.cod_transferencia, (to_char(ct1.num_caixa,'000') || ' - ' || f1.descricao) as caixa_credito,            
						   (to_char(ct2.num_caixa,'000') || ' - ' || f2.descricao|| ' - ' || ct2.usuario) as caixa_debito,            
						   t.valor, t.date_insert as data_aberto  
					  FROM finan.v$caixa_transferencia t,                     
						   (finan.v$caixa_controle ct1 
				inner join finan.v$caixa_gestao cg1 
						on ct1.num_caixa = cg1.num_caixa 
					   and ct1.cod_pessoa = cg1.cod_pessoa and 
						   ct1.cod_departamento = cg1.cod_departamento and
						   ct1.cod_setor = cg1.cod_setor and
						   ct1.cod_centro_custo = cg1.cod_centro_custo) inner join                      
						   finan.v$caixa_finalidade f1 on                      
						   cg1.finalidade_id = f1.finalidade_id,                       
						   (finan.v$caixa_controle ct2 inner join                      
							finan.v$caixa_gestao cg2 on                       
							ct2.num_caixa = cg2.num_caixa and                      
							ct2.cod_pessoa = cg2.cod_pessoa and
							ct2.cod_departamento = cg2.cod_departamento and
							ct2.cod_setor = cg2.cod_setor and
							ct2.cod_centro_custo = cg2.cod_centro_custo) inner join                      
							finan.v$caixa_finalidade f2 on                      
							cg2.finalidade_id = f2.finalidade_id  
					  WHERE t.controle_id_credito = ct1.controle_id             
						and t.controle_id_debito = ct2.controle_id             
						and t.lancamento_id_credito is null        
						and t.lancamento_id_debito is null        
						and ct1.usuario = user					
				</cfif>  	
     		</cfquery>
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca todos os controle relacionado ao usurio
	-- NOTAS EXPLICATIVAS
	-- GUTO 05/01/2006
	--->
	<cffunction name="get_controles_caixa" displayname="Busca todos os controle relacionado ao usurio" access="remote" returntype="query" output="true">
		<cfargument name="controle_id" required="no" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			<cfif not isDefined("arguments.controle_id")>
				select controle_id, num_caixa, data_abertura, saldo_abertura, data_encerramento,  
					   decode(saldo_encerramento,null,-1,saldo_encerramento) as saldo_encerramento
				  from finan.v$caixa_controle  
				 where usuario = user
				order by data_encerramento
			<cfelse>
				select controle_id, num_caixa, data_abertura, saldo_abertura, data_encerramento,  
					   decode(saldo_encerramento,null,-1,saldo_encerramento) as saldo_encerramento
				  from finan.v$caixa_controle  
				 where controle_id = #arguments.controle_id#
				order by data_encerramento
 			</cfif>				
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca a movimentacao do controle passado
	-- NOTAS EXPLICATIVAS
	-- GUTO 05/01/2006
	--->
	<cffunction name="get_controles_movimentacao" displayname="Busca a movimentacao do controle passado" access="remote" returntype="query" output="true">
		<cfargument name="controle_id" required="no" />
		<!--- Caso o usurio insira o controle o metodo retorna a movimentao do retorno, caso contrario do caixa todo. --->
		<cfargument name="num_caixa" required="no" />
		<cfargument name="cod_pessoa" required="no" />
		<cfargument name="cod_departamento" required="no" />
		<cfargument name="cod_setor" required="no" />
		<cfargument name="cod_centro_custo" required="no" />
		<cfargument name="data_inicial" required="no" />
		<cfargument name="data_final" required="no" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			<cfif isDefined("arguments.controle_id") and Len(Trim(arguments.controle_id))>
				SELECT cc.num_caixa, c.user_insert as apelido,                   
					     c.lancamento_id, c.data_lancamento, c.controle_id, c.num_docto,                   
					     c.cod_historico, ch.historico, c.complemento,                  
					     c.cod_pessoa, c.cod_departamento, c.cod_setor, c.cod_centro_custo,          
					     sum(decode(it.receita, 1, valor, 0)) receita,                  
					     sum(decode(it.receita, 0, valor, 0)) despesa, 
						 sum(cc.saldo_abertura) as SaldoAnterior    
				  FROM finan.v$caixa_item it, 
               finan.v$caixa c, 
               finan.v$caixa_controle cc,                    
					     finan.v$caixa_historico ch
				 WHERE cc.controle_id = #arguments.controle_id#
				   and c.controle_id = cc.controle_id          
				   and c.cod_historico = ch.cod_historico          
				   and c.lancamento_id = it.lancamento_id       
				 group by cc.num_caixa, c.user_insert,                    
						  c.lancamento_id, c.data_lancamento, c.controle_id, c.num_docto,                     
						  c.cod_historico, ch.historico, c.complemento,                    
						  c.cod_pessoa, c.cod_departamento, c.cod_setor, c.cod_centro_custo  
				 ORDER BY data_lancamento 
			<cfelse>
				SELECT cc.num_caixa, c.user_insert as apelido,                   
						   c.lancamento_id, c.data_lancamento, c.controle_id, c.num_docto,                   
						   c.cod_historico, ch.historico, c.complemento,                  
						   c.cod_pessoa, c.cod_departamento, c.cod_setor, c.cod_centro_custo,          
						   sum(decode(it.receita, 1, valor, 0)) receita,                  
						   sum(decode(it.receita, 0, valor, 0)) despesa, 0 SaldoAnterior    
					  FROM finan.v$caixa_item it, 
                 finan.v$caixa c, 
                 finan.v$caixa_controle cc,                    
						     oper.v$caixa_historico ch
					 WHERE c.controle_id = cc.controle_id          
					   and c.cod_historico = ch.cod_historico          
					   and c.lancamento_id = it.lancamento_id       
    			   and cc.num_caixa = #arguments.num_caixa#
             and cc.cod_pessoa = #arguments.cod_pessoa#
             and cc.cod_departamento = #arguments.cod_departamento#
             and cc.cod_setor = #arguments.cod_setor#
             and cc.cod_centro_custo = #arguments.cod_centro_custo#
    			   and c.data_lancamento between to_date('#arguments.data_inicial#' || '00:00:00', 'DD/MM/YYYY HH24:MI:SS')
											 and to_date('#arguments.data_final#' || '23:59:59', 'DD/MM/YYYY HH24:MI:SS')			   
					 group by cc.num_caixa, c.user_insert,                    
    							  c.lancamento_id, c.data_lancamento, c.controle_id, c.num_docto,                     
    							  c.cod_historico, ch.historico, c.complemento,                    
    							  c.cod_pessoa, c.cod_departamento, c.cod_setor, c.cod_centro_custo  
					 ORDER BY data_lancamento
			</cfif>
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Buca tipos de adto para funcionario
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/12/2007
	--->
	<cffunction name="get_tipo_adto_func" displayname="Buca tipos de adto para funcionario" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_unidade_monet" username="#session.usuario#" password="#session.senha#">
            select t.cod_tipo_adiantamento, t.descricao
              from rh.v$rh_tipo_adiantamento t
  		</cfquery>
		<cfreturn qr_unidade_monet>
	</cffunction>	
</cfcomponent>