<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init">
<!---
Lista os Bancos cadastrados
--->
<cffunction name="get_banco" access="remote" returntype="query" output="true">
	<cfquery name="qrbanco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select banco_id, 
				banco_descricao  
		   from kss.banco  
		  where permite_movimento = 1
	</cfquery>
<cfreturn qrbanco>
</cffunction>

<!---
Lista as Formas de pagamento possveis
Obs: Atualmente disponivel apenas na Del Pozo
--->
<cffunction name="get_forma_pagamento" access="remote" returntype="query" output="true">
	<cfquery name="qrformapagto" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select forma_id, 
			   forma_descricao  
		  from delpozo.faturamento_forma
	</cfquery>
<cfreturn qrformapagto>
</cffunction>

<!---
Lista as distribuidoras de combustivel
--->
<cffunction name="get_distribuidora" access="remote" returntype="query" output="true">
	<cfquery name="qrdistribuidora" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select distribuidora_id, 
			   descricao  
		  from oper.posto_distribuidora
	</cfquery>
<cfreturn qrdistribuidora>
</cffunction>

<!---
Lista os tipos de piso dos postos
--->
<cffunction name="get_posto_piso" access="remote" returntype="query" output="true">
	<cfquery name="qrpiso" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select piso_id, 
			   piso_descricao  
		  from oper.posto_piso
	</cfquery>
<cfreturn qrpiso>
</cffunction>	

<!---
Lista os produtos fornecidos por postos
--->
<cffunction name="get_produtos_postos" access="remote" returntype="query" output="true">
	<cfquery name="qr_produtos" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select t.descricao, 
			   t.produto_id, 
			   u.unidade, 
			   t.servico
		  from oper.v$posto_produto t, 
		  	   kss.unidade_medida u  
		 where t.ativo = 1           
		   and u.cod_unidade = t.cod_unidade
 		 order by t.produto_id
	</cfquery>	
<cfreturn qr_produtos>
</cffunction>	
</cfcomponent>