<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca as aplicaes registradas
	-- CRISTOFER  14/08/2006
	--->		
	<cffunction name="get_aplicacao_atualizacao" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="produto" required="no" default="">
		<cfargument name="ativo" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select aat.cod_projeto,
			       p.nome_projeto as projeto,
				   aat.cod_aplicacao,
				   a.nome_aplicacao as aplicacao,
				   liveupdate.pkg_sincronizador.fnc_get_aplicacao_versao(aat.cod_projeto, aat.cod_aplicacao) as versao_atual,
				   aat.produto,
				   aat.ativo,
				   aat.mensagem,
				   aat.site_produto,
				   aat.altera_senha,
				   aat.usuario,
				   aat.senha,
				   aat.date_insert,
				   aat.user_insert,
				   aat.date_update,
				   aat.user_update,
				   aat.site
			  from liveupdate.v$aplicacao_atualizacao aat
			 inner join kss.kss_aplicacao a
			         on aat.cod_aplicacao = a.cod_aplicacao
			 inner join kss.kss_projeto p
			         on aat.cod_projeto = p.cod_projeto
			 <cfif len(trim(arguments.usuario))>
			 inner join liveupdate.v$aplicacao_tecnico ate
			         on aat.cod_projeto = ate.cod_projeto
					and aat.cod_aplicacao = ate.cod_aplicacao
					and upper(ate.usuario) = upper('#arguments.usuario#')
			 </cfif>
			 where 1=1
			 <cfif len(trim(arguments.cod_projeto))>
			   and aat.cod_projeto in (#arguments.cod_projeto#)
			 </cfif>
			 <cfif len(trim(arguments.cod_aplicacao))>
			   and aat.cod_aplicacao in (#ListQualify(arguments.cod_aplicacao,"'",",")#)
			 </cfif>
			 <cfif len(trim(arguments.produto))>
			   and upper(aat.produto) like upper('%#arguments.produto#%')
			 </cfif>
			 <cfif len(trim(arguments.ativo))>
			   and aat.ativo = #arguments.ativo#
			 </cfif>
			 order by aat.cod_projeto, aat.cod_aplicacao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
	
	<!--- 
	-- PROPSITO 
	-- Busca as pastas da aplicacao
	-- CRISTOFER  14/08/2006
	--->		
	<cffunction name="get_aplicacao_diretorio" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="sincronizar" required="no" default="">
		<cfargument name="origem" required="no" default="0">
		<cfargument name="diretorio_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ad.cod_projeto,
				   ad.cod_aplicacao,
				   ad.diretorio_id,
				  <cfif arguments.origem eq 1>
				   replace(replace(liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(ad.diretorio_id),liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(so.diretorio_id_destino),liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(so.diretorio_id_origem)),'\','/') as origem,
				  </cfif>
				   replace(liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(ad.diretorio_id),'\','/') as caminho,
				   ad.sincronizar,
				   ad.date_insert,
				   ad.user_insert,
				   ad.date_update,
				   ad.user_update,
				   ad.site,
				   (select kss.fnc_concat_all(to_concat_expr(cod_tipo_arquivo,','))
					  from liveupdate.v$arquivo_diretorio_tipo_arq ta
					 where ta.diretorio_id = ad.diretorio_id) as extensoes_permitidas
			  from liveupdate.v$aplicacao_diretorio ad
				  <cfif arguments.origem eq 1>
			  	   , liveupdate.v$sincronizador_origem so
				  </cfif>
			 where 1=1
			 <cfif len(trim(arguments.sincronizar))>
			   and ad.sincronizar = #arguments.sincronizar#
			 </cfif>
			 <cfif len(trim(arguments.cod_projeto))>
			   and ad.cod_projeto in (#arguments.cod_projeto#)
			 </cfif>
			 <cfif len(trim(arguments.cod_aplicacao))>
			   and ad.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif len(trim(arguments.diretorio_id))>
			   and ad.diretorio_id = #arguments.diretorio_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>   
   	
	<!--- 
	-- PROPSITO 
	-- Busca as pastas de origem e destino dos sistemas
	-- CRISTOFER  14/08/2006
	--->		
	<cffunction name="get_sincronizador_origem" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select replace(liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(diretorio_id_origem),'\','/')||'/' origem,
				   replace(liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(diretorio_id_destino),'\','/')||'/' destino,
				   diretorio_id_origem,
				   diretorio_id_destino
			  from liveupdate.v$sincronizador_origem
			 where rownum = 1
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca o conteudo do diretorio
	-- CRISTOFER  14/08/2006
	--->		
	<cffunction name="get_diretorio_conteudo" access="remote" returntype="query" output="true">
		<cfargument name="caminho" required="yes">
		<cfargument name="diretorio_origem" required="yes">
		<cfargument name="recurse" required="no" default="no">
		<cfargument name="extensoes" required="no" default="">
		<cfset SetLocale('Portuguese (Brazilian)')>
		<cfdirectory name 		= "qrDiretorio"
					 directory 	= "#arguments.caminho#"
					 sort		= "datelastmodified desc, name asc"
					 recurse	= "#arguments.recurse#"	 />
		<cfset qr_result = QueryNew("nome,diretorio,arquivo_tipo,path,assinatura,data_arquivo,tamanho,tipo,diretorio_local,extensao,permitido")>
		<cfoutput query="qrDiretorio">
			<cfset QueryAddRow(qr_result)>
			<cfset QuerySetCell(qr_result, "nome", qrDiretorio.name)>
			<cfset QuerySetCell(qr_result, "diretorio", qrDiretorio.directory)>
			<cfset QuerySetCell(qr_result, "path", replace(qrDiretorio.directory, arguments.diretorio_origem, '', 'one')&"/"&qrDiretorio.name)>
			<cfset QuerySetCell(qr_result, "diretorio_local", replace(qrDiretorio.directory, arguments.diretorio_origem, '', 'one'))>
			<cfset QuerySetCell(qr_result, "data_arquivo",  lsdateFormat(Insert("20",qrDiretorio.datelastmodified,6),'dd/mm/yyyy')& ' ' & lstimeformat(qrDiretorio.datelastmodified,'HH:MM:SS'))>
			<cfset QuerySetCell(qr_result, "tamanho", qrDiretorio.size)>
			<cfset QuerySetCell(qr_result, "tipo", qrDiretorio.type)>
			<cfset QuerySetCell(qr_result, "extensao", uCase(ListLast(qrDiretorio.name,'.')))>
			<cfset QuerySetCell(qr_result, "permitido", iif(listFind(arguments.extensoes,ucase(ListLast(qrDiretorio.name,'.'))),de(1),de(0)))>
			<cfif qrDiretorio.type eq "File">
				<cfset QuerySetCell(qr_result, "assinatura", this.md5_file(file = qrDiretorio.directory&"/"&qrDiretorio.name))>
				<cfset QuerySetCell(qr_result, "arquivo_tipo", this.get_arquivo_tipo_desc(cod_tipo_arquivo = uCase(ListLast(qrDiretorio.name,'.'))))>
			<cfelse>
				<cfset QuerySetCell(qr_result, "arquivo_tipo", "Diretrio")>
			</cfif>
		</cfoutput>
		<cfreturn qr_result>		
	</cffunction>	
		
	<!--- 
	-- PROPSITO 
	-- Busca o tipo do arquivo
	-- CRISTOFER  15/08/2006
	--->		
	<cffunction name="get_arquivo_tipo_desc" access="remote" returntype="string" output="true">
		<cfargument name="cod_tipo_arquivo" required="no" default="">
		<cfscript>
			switch(ucase(arguments.cod_tipo_arquivo)) {
				case "RTX":
					return 'Relatrio';
					break;
				case 'SQL':
				case 'BAT':
				case 'QRX':
					return 'Script';
					break;
				default:
					return 'Arquivo';
					break;
			}
		</cfscript>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Captura o Hash MD5 do Arquivo
	-- CRISTOFER 04/11/2005 - criado
	--->
	<cffunction name="md5_file_old" displayname="Captura o Hash MD5 do Arquivo" returntype="string" output="true" access="remote">
		<cfargument name="file" required="yes">
		<cfhttp url="http://#cgi.http_host#/KMM/md5_file.php?file=#file#" method="get"></cfhttp>
		<cfreturn UCase(cfhttp.FileContent) />
	</cffunction>		
    
	<!--- 
	-- PROPSITO
	-- Captura o Hash MD5 do Arquivo
	-- CRISTOFER 04/11/2005 - criado
	--->
	<cffunction name="md5_file" displayname="Captura o Hash MD5 do Arquivo" returntype="string" output="true" access="remote">
		<cfargument name="file" required="yes">
        <cffile action="read" file="#file#" variable="xFile" />
		<cfscript>
			return ucase(hash(xFile,'MD5'));
		</cfscript>
    </cffunction>

	
	<!--- 
	-- PROPSITO 
	-- Busca o arquivo
	-- CRISTOFER  14/08/2006
	--->		
	<cffunction name="get_diretorio_arquivos" access="remote" returntype="query" output="true">
		<cfargument name="diretorio_id" required="yes">
		<cfargument name="diretorio_origem" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.nome_arquivo nome,
				   case 
				     when t.script = 1 then 'Script' 
					 when t.relatorio = 1 then 'Reltorio'
					 else 'Arquivo'
				   end arquivo_tipo,
				   replace(liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(a.diretorio_id),'\','/') as diretorio,
				   replace(replace(liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(a.diretorio_id),'\','/'),'#diretorio_origem#','')||'/'||a.nome_arquivo as path,
				   replace(replace(liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(a.diretorio_id),'\','/'),'#diretorio_origem#','') diretorio_local,
				   a.assinatura,
				   to_char(a.data_arquivo,'dd/mm/yyyy hh24:mi:ss') as data_arquivo,
				   a.tamanho,
				   upper(a.cod_tipo_arquivo) extensao,
				   1 as permitido,
				   'File' as tipo
			  from liveupdate.v$arquivo	a
			 inner join liveupdate.v$arquivo_tipo t
			         on a.cod_tipo_arquivo = t.cod_tipo_arquivo			 
			 where a.diretorio_id = #arguments.diretorio_id#
			 order by a.data_arquivo desc, upper(a.nome_arquivo)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca a comparao entre as duas querys
	-- CRISTOFER  14/08/2006
	--->		
	<cffunction name="get_diretorio_compare" access="remote" returntype="query" output="true">
		<cfargument name="origem" required="yes">
		<cfargument name="destino" required="yes">
		<cfargument name="diretorio_destino" required="yes">
		<cfset c_origem = 1>
		<cfset c_destino = 1>
		<cfset qr_result = QueryNew("nome,extensao,arquivo_tipo,diretorio_origem,diretorio_destino,assinatura_origem,assinatura_destino,data_arquivo,tamanho,tipo,operacao,diretorio_local")>
		<cfset v_list_origem = ValueList(arguments.origem.path)>
		<cfset v_list_destino = ValueList(arguments.destino.path)>
		<cfloop query="arguments.origem">
			<cfif arguments.origem.tipo eq 'File'>
				<cfif not listfind(v_list_destino,arguments.origem.path)>
					<!--- Insere o arquivo --->
					<cfset c_origem = arguments.origem.currentrow>
					<cfscript>
						QueryAddRow(qr_result);
						QuerySetCell(qr_result, "nome", arguments.origem["nome"][c_origem]);
						QuerySetCell(qr_result, "extensao", arguments.origem["extensao"][c_origem]);
						QuerySetCell(qr_result, "arquivo_tipo", arguments.origem["arquivo_tipo"][c_origem]);
						QuerySetCell(qr_result, "diretorio_origem", arguments.origem["diretorio"][c_origem]);
						QuerySetCell(qr_result, "diretorio_destino", arguments.diretorio_destino&arguments.origem["diretorio_local"][c_origem]);
						QuerySetCell(qr_result, "assinatura_origem", arguments.origem["assinatura"][c_origem]);
						QuerySetCell(qr_result, "assinatura_destino", "");
						QuerySetCell(qr_result, "data_arquivo", arguments.origem["data_arquivo"][c_origem]);
						QuerySetCell(qr_result, "tamanho", arguments.origem["tamanho"][c_origem]);
						QuerySetCell(qr_result, "tipo", "File");
						QuerySetCell(qr_result, "diretorio_local", arguments.origem["diretorio_local"][c_origem]);
						QuerySetCell(qr_result, "operacao", iif(arguments.origem["permitido"][c_origem] eq 1, de("inserir"), de("recusado")));
					</cfscript>
				<cfelse>
					<cfset c_origem = arguments.origem.currentrow>
					<cfset c_destino = listfind(v_list_destino,arguments.origem.path)>
					<cfif arguments.origem["assinatura"][c_origem] neq arguments.destino["assinatura"][c_destino]>
						<cfscript>
							QueryAddRow(qr_result);
							QuerySetCell(qr_result, "nome", arguments.origem["nome"][c_origem]);
							QuerySetCell(qr_result, "extensao", arguments.origem["extensao"][c_origem]);
							QuerySetCell(qr_result, "arquivo_tipo", arguments.origem["arquivo_tipo"][c_origem]);
							QuerySetCell(qr_result, "diretorio_origem", arguments.origem["diretorio"][c_origem]);
							QuerySetCell(qr_result, "diretorio_destino", arguments.destino["diretorio"][c_destino]);
							QuerySetCell(qr_result, "assinatura_origem", arguments.origem["assinatura"][c_origem]);
							QuerySetCell(qr_result, "assinatura_destino", arguments.origem["assinatura"][c_destino]);
							QuerySetCell(qr_result, "data_arquivo", arguments.origem["data_arquivo"][c_origem]);
							QuerySetCell(qr_result, "tamanho", arguments.origem["tamanho"][c_origem]);
							QuerySetCell(qr_result, "diretorio_local", arguments.destino["diretorio_local"][c_destino]);
							QuerySetCell(qr_result, "tipo", "File");
							QuerySetCell(qr_result, "operacao", iif(arguments.origem["permitido"][c_origem] eq 1, de("alterar"), de("recusado")));
						</cfscript>
					</cfif>
				</cfif>
			</cfif>
		</cfloop>
		<cfloop query="arguments.destino">
			<cfif arguments.destino.tipo eq 'File'>
				<cfif not listFind(v_list_origem, arguments.destino.path)>
					<cfset c_destino = arguments.destino.currentrow>
					<cfscript>
						QueryAddRow(qr_result);
						QuerySetCell(qr_result, "nome", arguments.destino["nome"][c_destino]);
						QuerySetCell(qr_result, "extensao", arguments.destino["extensao"][c_destino]);
						QuerySetCell(qr_result, "arquivo_tipo", arguments.destino["arquivo_tipo"][c_destino]);
						QuerySetCell(qr_result, "diretorio_origem", "");
						QuerySetCell(qr_result, "diretorio_destino", arguments.destino["diretorio"][c_destino]);
						QuerySetCell(qr_result, "assinatura_origem", "");
						QuerySetCell(qr_result, "assinatura_destino", arguments.destino["assinatura"][c_destino]);
						QuerySetCell(qr_result, "data_arquivo", arguments.destino["data_arquivo"][c_destino]);
						QuerySetCell(qr_result, "tamanho", arguments.destino["tamanho"][c_destino]);
						QuerySetCell(qr_result, "diretorio_local", arguments.destino["diretorio_local"][c_destino]);
						QuerySetCell(qr_result, "tipo", "File");
						QuerySetCell(qr_result, "operacao", "excluir");
					</cfscript>
				</cfif>
			</cfif>
		</cfloop>
		<cfreturn qr_result>		
	</cffunction>	
	

	<!--- 
	-- PROPSITO 
	-- Busca os arquivos a serem sincronizados
	-- CRISTOFER  14/08/2006
	--->		
	<cffunction name="get_aplicacao_sincronizar" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cfscript>
			conn = CreateObject("component","_transportes.consulta.cfc_atualizador");
			conn2 = CreateObject("component", "_transportes.funcoes.cfc_global");
			//Busca os diretorios da aplicacao
			qrDiretorios = conn.get_aplicacao_diretorio(argumentCollection = arguments,
												        sincronizar = 1,
												        origem = 1);
			//Busca os diretorios de origem e destino da sincronizao
			qrDestinos = conn.get_sincronizador_origem();
		</cfscript>		
		<cfloop query="qrDiretorios">
			<cfscript>
				//Busca o conteudo do diretorio na origem
				qrOrigem = conn.get_diretorio_conteudo(	caminho = qrDiretorios.origem, 
														diretorio_origem = qrDestinos.origem,
														extensoes = qrDiretorios.extensoes_permitidas);
				//Busca os arquivos cadastrados para o diretorio
				qrBancoDados = conn.get_diretorio_arquivos(	diretorio_id = qrDiretorios.diretorio_id, 
															diretorio_origem = qrDestinos.destino);
				if(qrDiretorios.currentrow neq 1) {
					qrBanco = conn2.queryConcat(	query1 = qrBanco, 
													query2 = qrBancoDados);
					qrServidor = conn2.queryConcat(	query1 = qrServidor,
													query2 = qrOrigem);
				} else {
					qrBanco = qrBancoDados;
					qrServidor = qrOrigem;
				}
			</cfscript>
		</cfloop>
		<cfscript>
			if(isdefined("qrServidor")) {
				//Compara o conteudo do diretorio com os arquivos do banco de dados
				qr_result = conn.get_diretorio_compare(origem = qrServidor, destino = qrBanco, diretorio_destino = qrDestinos.destino);
			} else {
				qr_result = QueryNew("nome,diretorio,arquivo_tipo,path,assinatura,data_arquivo,tamanho,tipo,diretorio_local,extensao,permitido");
			}
		</cfscript>
		<cfreturn qr_result>		
	</cffunction>
	

	<!--- 
	-- PROPSITO 
	-- Busca os historicos de sincronizao
	-- CRISTOFER  17/08/2006
	--->		
	<cffunction name="get_sincronizador_historico" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="aberto" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="historico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select sh.cod_projeto,
				   p.nome_projeto as projeto,
				   sh.cod_aplicacao,
				   a.nome_aplicacao as aplicacao,
				   sh.historico_id,
				   sh.usuario,
				   sh.data_inicio,
				   sh.data_fim,
				   sh.v_major,
				   sh.v_minor,
				   sh.v_release,
				   sh.v_build,
				   (select count('x')
				      from liveupdate.v$sincronizador_historico_log shl
					 where shl.cod_projeto = sh.cod_projeto
					   and shl.cod_aplicacao = sh.cod_aplicacao
					   and shl.historico_id = sh.historico_id
					   and shl.usuario = sh.usuario
					   and shl.sincronizado = 0) as erros
			  from liveupdate.v$sincronizador_historico sh
			 inner join kss.kss_projeto p
					 on p.cod_projeto = sh.cod_projeto
			 inner join kss.kss_aplicacao a
					 on a.cod_aplicacao = sh.cod_aplicacao
			 where 1=1
			 <cfif arguments.aberto eq 1>
			   and sh.data_fim is null	
			 </cfif>
			 <cfif len(trim(arguments.cod_aplicacao))>
			   and sh.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif len(trim(arguments.cod_projeto))>
			   and sh.cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(sh.usuario) = upper('#arguments.usuario#')
			 </cfif>
			 <cfif len(trim(arguments.historico_id))>
			   and sh.historico_id = #arguments.historico_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os logs de sincronizao
	-- CRISTOFER  17/08/2006
	--->		
	<cffunction name="get_sincronizador_historico_log" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="historico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_projeto,
				   cod_aplicacao,
				   historico_id,
				   usuario,
				   nome_arquivo,
				   case upper(substr(nome_arquivo, instr(nome_arquivo,'.',-1)+1, length(nome_arquivo)-instr(nome_arquivo,'.',-1)))
					 when 'BAT' then 'Script'
					 when 'SQL' then 'Script'
					 when 'RTX' then 'Relatorio'
					 when 'QRX' then 'Script'
					 else 'Arquivo'
				   end arquivo_tipo,
				   pasta_instalacao,
				   comentario,
				   dir_origem,
				   dir_destino,
				   ultima_modificacao,
				   tamanho,
				   sincronizado,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from liveupdate.v$sincronizador_historico_log sh
			 where 1=1
			 <cfif len(trim(arguments.cod_aplicacao))>
			   and sh.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif len(trim(arguments.cod_projeto))>
			   and sh.cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(sh.usuario) = upper('#arguments.usuario#')
			 </cfif>
			 <cfif len(trim(arguments.historico_id))>
			   and sh.historico_id = #arguments.historico_id#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>			 
	
	<!--- 
	-- PROPSITO 
	-- Busca emails sincronizao
	-- CRISTOFER  17/08/2006
	--->		
	<cffunction name="get_email_sincronizacao" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="historico_id" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */ u.nome, 
				   e.email_completo as email, 
				   max(case 
					  when ate.usuario is null then 0
					  else 1
				   end) as tecnico,
				   e.email_id
			  from liveupdate.v$sincronizador_historico_log sl
			 inner join liveupdate.v$sincronizador_historico sh
					 on sh.cod_projeto = sl.cod_projeto
					and sh.cod_aplicacao = sl.cod_aplicacao
					and sh.historico_id = sl.historico_id
					and sh.usuario = sl.usuario
			 inner join liveupdate.v$arquivo_diretorio ad
					 on liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(ad.diretorio_id) = sl.dir_destino
			 inner join liveupdate.v$aplicacao_diretorio aa
					 on aa.diretorio_id = ad.diretorio_id
			 inner join liveupdate.v$atualizacao_email ae
					 on ae.cod_projeto = sl.cod_projeto
					and ae.cod_aplicacao = sl.cod_aplicacao
			 inner join kss.v$email e
					 on ae.email_id = e.email_id
			  left join kss.kss_usuarios u
					 on u.email_id = e.email_id
			  left join liveupdate.v$aplicacao_tecnico ate
					 on ate.usuario = u.usuario
			 where 1=1
			 <cfif len(trim(arguments.cod_projeto))>
			   and sl.cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif len(trim(arguments.cod_aplicacao))>
			   and sl.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif len(trim(arguments.historico_id))>
			   and sl.historico_id = #arguments.historico_id#
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and sl.usuario = '#arguments.usuario#'
			 </cfif>
			 group by u.nome, 
					  e.email_completo,
					  e.email_id
			 order by 3 desc, 2, 1	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os diretorios do servidor
	-- CRISTOFER  18/08/2006
	--->		
	<cffunction name="get_arquivo_diretorio" access="remote" returntype="query" output="true">
		<cfargument name="diretorio_id" required="no" default="">
		<cfargument name="diretorio_pai" required="no" default="">
		<cfargument name="nome" required="no" default="">
		<cfargument name="raiz" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ad.diretorio_id,
				   ad.diretorio_pai,
				   nvl(ad.diretorio_pai,0) as diretorio_pai_nvl,
				   liveupdate.pkg_arquivo.fnc_get_diretorio_caminho(ad.diretorio_id) as caminho,
				   ad.nome,
				   ad.date_insert,
				   ad.user_insert,
				   ad.date_update,
				   ad.user_update,
				   ad.site,
                   ad.raiz_aplicacao,
                   ad.raiz_ftp
			  from liveupdate.v$arquivo_diretorio ad
			 where 1=1
			 <cfif len(trim(arguments.diretorio_id))>
			   and ad.diretorio_id in (#arguments.diretorio_id#)
			 </cfif>
			 <cfif lcase(arguments.diretorio_pai) eq "null">
			   and ad.diretorio_pai is null
			 <cfelseif len(trim(arguments.diretorio_pai))>
			   and ad.diretorio_pai in (#arguments.diretorio_pai#)
			 </cfif>
			 <cfif len(trim(arguments.nome))>
			   and upper(ad.nome) like upper('%#arguments.nome#%')
			 </cfif>
			 <cfif not len(trim(arguments.raiz))>
			 start with ad.diretorio_pai is null
			 <cfelse>
			 start with ad.diretorio_pai = #arguments.raiz#
			 </cfif>
			connect by prior ad.diretorio_id = ad.diretorio_pai	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os tipos de arquivo
	-- CRISTOFER  21/08/2006
	--->		
	<cffunction name="get_arquivo_tipo" access="remote" returntype="query" output="true">
		<cfargument name="cod_tipo_arquivo" required="no" default="">
		<cfargument name="script" required="no" default="">
		<cfargument name="relatorio" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_tipo_arquivo,
				   descricao,
				   script,
				   relatorio,
				   case 
				     when script = 1 then 'Script' 
					 when relatorio = 1 then 'Reltorio'
					 else 'Arquivo'
				   end arquivo_tipo,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from liveupdate.v$arquivo_tipo a
			 where 1=1
			 <cfif len(trim(arguments.cod_tipo_arquivo))>
			   and cod_tipo_arquivo in (#ListQualify(arguments.cod_tipo_arquivo, "'", ',')#)
			 </cfif>
			 <cfif len(trim(arguments.script))>
			   and script = #arguments.script#
			 </cfif>
			 <cfif len(trim(arguments.relatorio))>
			   and relatorio = #arguments.relatorio#
			 </cfif>
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 order by cod_tipo_arquivo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os tipos de arquivo permitidos no diretorio
	-- CRISTOFER  21/08/2006
	--->		
	<cffunction name="get_arquivo_diretorio_tipo_arq" access="remote" returntype="query" output="true">
		<cfargument name="diretorio_id" required="no" default="">
		<cfargument name="cod_tipo_arquivo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select diretorio_id,
				   cod_tipo_arquivo,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from liveupdate.v$arquivo_diretorio_tipo_arq	
			 where 1=1
			 <cfif len(trim(arguments.cod_tipo_arquivo))>
			   and cod_tipo_arquivo = '#arguments.cod_tipo_arquivo#'
			 </cfif>
			 <cfif len(trim(arguments.diretorio_id))>
			   and diretorio_id = #arguments.diretorio_id#
			 </cfif>
			 order by cod_tipo_arquivo, diretorio_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os projetos cadastrados
	-- CRISTOFER  30/08/2006
	--->		
	<cffunction name="get_projeto" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_projeto,
				   nome_projeto,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from kss.kss_projeto t
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca as aplicaes cadastradas
	-- CRISTOFER  30/08/2006
	--->		
	<cffunction name="get_aplicacao" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_aplicacao,
				   nome_aplicacao,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from kss.kss_aplicacao t
			 where 1=1
			 <cfif len(trim(arguments.cod_projeto))>
			   and cod_projeto = #arguments.cod_projeto#
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>			
	
	<!--- 
	-- PROPSITO 
	-- Busca todos os projetos e aplicacoes e produtos relacionados
	-- CRISTOFER  30/08/2006
	--->		
	<cffunction name="get_projeto_aplicacao" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.cod_projeto,
				   p.nome_projeto projeto,
				   a.cod_aplicacao,
				   a.nome_aplicacao aplicacao,
				   aa.produto
			  from kss.kss_projeto p
			 inner join kss.kss_aplicacao a
					 on a.cod_projeto = p.cod_projeto
			  left join liveupdate.v$aplicacao_atualizacao aa
					 on aa.cod_projeto = a.cod_projeto
					and aa.cod_aplicacao = a.cod_aplicacao
			 order by p.nome_projeto, a.nome_aplicacao	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os emails para atualizacao
	-- CRISTOFER  04/09/2006
	--->		
	<cffunction name="get_atualizacao_email" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="email" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ae.cod_projeto,
				   p.nome_projeto as projeto,
				   ae.cod_aplicacao,
				   a.nome_aplicacao as aplicacao,
				   ae.email_id,
				   e.email_completo email, 
				   ae.date_insert,
				   ae.user_insert,
				   ae.date_update,
				   ae.user_update,
				   ae.site
			  from liveupdate.v$atualizacao_email ae
			 inner join kss.v$email e
					 on e.email_id = ae.email_id
			 inner join kss.kss_projeto p 
					 on p.cod_projeto = ae.cod_projeto
			 inner join kss.kss_aplicacao a
					 on ae.cod_projeto = a.cod_projeto
					and ae.cod_aplicacao = a.cod_aplicacao
			 where 1=1
			 <cfif len(trim(arguments.cod_projeto))>
			   and ae.cod_projeto = #arguments.cod_projeto#
			 </cfif>	
			 <cfif len(trim(arguments.cod_aplicacao))>
			   and ae.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif len(trim(arguments.email))>
			   and upper(e.email_completo) like upper('%#arguments.email#%')
			 </cfif>
			 order by p.nome_projeto, a.nome_aplicacao, e.email_completo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os e-mails ainda nao enviados de atualizacao
	-- CRISTOFER  04/09/2006
	--->		
	<cffunction name="get_atualizacao_email_versao" access="remote" returntype="query" output="true">
		<cfargument name="enviado" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select aev.email_versao_id,
				   aev.cod_projeto||'-'||aev.cod_aplicacao||'-'||aev.v_major||'.'||aev.v_release||'.'||aev.v_build aplicacao_versao,
				   aev.cod_projeto,
				   aev.cod_aplicacao,
				   aev.v_major,
				   aev.v_minor,
				   aev.v_release,
				   aev.v_build ,
				   aev.email_id,
				   e.email_completo,
				   aev.enviado
			  from liveupdate.v$atualizacao_email_versao aev
			 inner join kss.v$email e
					 on e.email_id = aev.email_id
			 where 1=1
			 <cfif len(trim(arguments.enviado))>
			   and enviado = #arguments.enviado#
			 </cfif>
			 order by cod_projeto, cod_aplicacao, v_major, v_minor, v_release, v_build
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados da versao de atualizacao
	-- CRISTOFER  04/09/2006
	--->		
	<cffunction name="get_atualizacao_versao" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="yes">
		<cfargument name="cod_aplicacao" required="yes">
		<cfargument name="v_major" required="yes">
		<cfargument name="v_minor" required="yes">
		<cfargument name="v_release" required="yes">
		<cfargument name="v_build" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select av.cod_projeto,
				   av.cod_aplicacao,
				   av.descricao,
				   av.v_major,
				   av.v_minor,
				   av.v_release,
				   av.v_build,
				   av.v_major||'.'||av.v_minor||'.'||av.v_release||'.'||av.v_build versao,
				   aa.produto,
				   nvl(u.nome, av.user_insert) as liberado_por,
				   av.date_insert,
				   av.user_insert,
				   av.date_update,
				   av.user_update,
				   av.site
			  from liveupdate.v$atualizacao_versao av
			 inner join liveupdate.v$aplicacao_atualizacao aa
			         on aa.cod_projeto = av.cod_projeto
					and aa.cod_aplicacao = av.cod_aplicacao
			  left join kss.kss_usuarios u
			         on u.usuario = av.user_insert
			 where 1=1
			   and av.cod_projeto = #arguments.cod_projeto#
			   and av.cod_aplicacao = '#arguments.cod_aplicacao#'
			   and av.v_major = #arguments.v_major#
			   and av.v_minor = #arguments.v_minor#
			   and av.v_release = #arguments.v_release#
			   and av.v_build = #arguments.v_build#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>   

	<!--- 
	-- PROPSITO 
	-- Busca os usuarios do sistema
	-- CRISTOFER  04/09/2006
	--->		
	<cffunction name="get_usuarios" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select usuario,
				   nome
			  from kss.kss_usuarios t
			 where ativo = 1	
			 order by usuario
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os tecnicos da aplicacao
	-- CRISTOFER  04/09/2006
	--->		
	<cffunction name="get_aplicacao_tecnico" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_projeto,
				   cod_aplicacao,
				   usuario,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
			  from liveupdate.v$aplicacao_tecnico
			 where 1=1
			 <cfif len(trim(arguments.cod_projeto))>
			   and cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif len(trim(arguments.cod_aplicacao))>
			   and cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and usuario = '#arguments.usuario#'
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca um serial disponivel
	-- CRISTOFER  06/09/2006
	--->		
	<cffunction name="get_serial_disponivel" access="remote" returntype="string" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select liveupdate.pkg_sincronizador.fnc_serial_disponivel as num_serie
			  from dual
		</cfquery>
		<cfreturn qr_result.num_serie>
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as copias registradas
	-- CRISTOFER  06/09/2006
	--->		
	<cffunction name="get_copia" access="remote" returntype="query" output="true">
		<cfargument name="cod_projeto" required="no" default="">
		<cfargument name="cod_aplicacao" required="no" default="">
		<cfargument name="num_serie" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.num_serie,
				   c.cod_pessoa,
				   p.cliente,
				   c.cod_projeto,
				   c.cod_aplicacao,
				   aat.produto,
				   c.data_instalacao,
				   c.direito_uso,
				   c.atualizacao,
				   c.usuario,
				   c.senha,
				   c.usuario_administrador,
				   c.senha_administrador,
				   c.date_insert,
				   c.user_insert,
				   c.date_update,
				   c.user_update,
				   c.site
			  from liveupdate.v$copia c
			 inner join liveupdate.v$aplicacao_atualizacao aat
					 on aat.cod_projeto = c.cod_projeto
					and aat.cod_aplicacao = c.cod_aplicacao
			 inner join kss.v$pessoa p
					 on c.cod_pessoa = p.cod_pessoa	
			 where 1=1
			 <cfif len(trim(arguments.num_serie))>
			   and c.num_serie = '#arguments.num_serie#'
			 </cfif>
			 <cfif len(trim(arguments.cod_projeto))>
			   and c.cod_projeto = #arguments.cod_projeto#
			 </cfif>
			 <cfif len(trim(arguments.cod_aplicacao))>
			   and c.cod_aplicacao = '#arguments.cod_aplicacao#'
			 </cfif>
			 order by p.cliente, aat.produto
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>