<cfcomponent>	
	<!--- 
	-- PROPSITO 
	-- Busca os atendimentos
	-- CRISTOFER  31/05/2006
	--->		
	<cffunction name="get_atendimento" access="remote" returntype="query" output="true">
		<cfargument name="atendimento_id" required="no" default="">
		<cfargument name="situacao_id" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="cliente_id" required="no" default="">
		<cfargument name="aplicacao_id" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_termino" required="no" default="">
		<cfargument name="tecnico" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select atd.atendimento_id,
				   atd.cliente_id,
				   clt.nome as cliente,
				   atd.aplicacao_id,
				   apl.descricao as aplicacao,
				   atd.usuario,
				   atd.descricao,
				   substr('['||atd.atendimento_id || ']- ' || atd.descricao,0,50)||case when length(atd.descricao) > 50 then '...' else '' end as resumo,
				   atd.situacao_id,
				   atd.data_inicio,
				   atd.data_termino,
				   atd.tecnico_atendimento,
				   atd.date_insert,
				   atd.user_insert,
				   atd.date_update,
				   atd.user_update,
				   atd.site
			  from kmm.v$atendimento atd
			 inner join kmm.v$cliente clt
					 on clt.cliente_id = atd.cliente_id
			 inner join kmm.v$aplicacao apl
					 on apl.aplicacao_id = atd.aplicacao_id
			 where 1=1
			 <cfif len(trim(arguments.atendimento_id))>
			   and atd.atendimento_id in (#arguments.atendimento_id#)
			 </cfif>
			 <cfif len(trim(arguments.situacao_id))>
			   and atd.situacao_id in (#arguments.situacao_id#)
			 </cfif>
			 <cfif len(trim(arguments.cliente_id))>
			   and atd.cliente_id = #arguments.cliente_id#
			 </cfif>
			 <cfif len(trim(arguments.aplicacao_id))>
			   and atd.aplicacao_id = #arguments.aplicacao_id#
			 </cfif>
			 <cfif len(trim(arguments.data_inicio))>
			   and trunc(atd.data_inicio) >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
			 </cfif>
			 <cfif len(trim(arguments.data_termino))>
			   and trunc(atd.data_inicio) <= to_date('#arguments.data_termino#', 'dd/mm/yyyy')
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(atd.usuario) = upper('#arguments.usuario#')
			 </cfif>
			 <cfif arguments.tecnico eq 1 >
			   and ((upper(atd.tecnico_atendimento) = upper('#session.usuario#') and atd.situacao_id = 2) or (atd.situacao_id <> 2))
			 </cfif>
			 order by atd.situacao_id desc, atd.data_inicio
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca as mensagens do atendimento
	-- CRISTOFER  31/05/2006
	--->		
	<cffunction name="get_atendimento_mensagem" access="remote" returntype="query" output="true">
		<cfargument name="atendimento_id" required="no" default="">
		<cfargument name="ultima_mensagem_id" required="no" default="">
		<cfargument name="apos_refresh" required="no" default="0">
		<cfargument name="tipo_id" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select am.mensagem_id,
				   am.atendimento_id,
				   am.usuario,
				   am.data,
				   am.date_insert,
				   am.user_insert,
				   am.date_update,
				   am.user_update,
				   am.site,
				   am.mensagem,
				   am.tipo_id
			  from kmm.v$atendimento_mensagem am
			 where 1=1
			 <cfif len(trim(arguments.atendimento_id))>
			   and am.atendimento_id = #arguments.atendimento_id#
			 </cfif>
			 <cfif len(trim(arguments.ultima_mensagem_id))>
			   and am.mensagem_id > #arguments.ultima_mensagem_id#
			 </cfif>
			 <cfif arguments.apos_refresh eq 1>
			   and am.mensagem_id > (select nvl(max(mensagem_id),0)
			   					    from kmm.v$atendimento_status
								   where upper(usuario) = upper(user)
								     and atendimento_id = am.atendimento_id)
			 </cfif>
			 <cfif len(trim(arguments.tipo_id))>
			   and am.tipo_id in (#arguments.tipo_id#)
			 </cfif>
			 order by mensagem_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  

	<!--- 
	-- PROPSITO 
	-- Busca o status dos usuarios no atendimento
	-- CRISTOFER  02/06/2006
	--->		
	<cffunction name="get_atendimento_status" access="remote" returntype="query" output="true">
		<cfargument name="atendimento_id" required="no" default="">
		<cfargument name="digitando" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ast.atendimento_id,
				   ast.usuario,
				   case when digitando >= sysdate - (5/(24*60*60)) then 1 else 0 end as digitando
			  from kmm.v$atendimento_status ast
			 where 1=1
			 <cfif len(trim(arguments.atendimento_id))>
			   and atendimento_id = #arguments.atendimento_id#
			 </cfif>
			 <cfif len(trim(arguments.digitando))>
			   and case when digitando >= sysdate - (5/(24*60*60)) then 1 else 0 end = #arguments.digitando#
			 </cfif>
			   and upper(ast.usuario) <> upper(user)  	 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca todas as conversas que possuem mensagens nao lidas
	-- CRISTOFER  02/06/2006
	--->		
	<cffunction name="get_mensagens_nao_lidas" access="remote" returntype="query" output="true">
		<cfargument name="ignorar_atendimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct atd.atendimento_id
			  from kmm.v$atendimento atd
			 inner join kmm.v$atendimento_mensagem am
					 on atd.atendimento_id = am.atendimento_id
			 inner join kmm.v$atendimento_status ast
					 on ast.atendimento_id = am.atendimento_id
			 where ast.usuario = user --or atd.usuario = user
			 <cfif len(trim(arguments.ignorar_atendimento_id))>
			   and atd.atendimento_id not in (#arguments.ignorar_atendimento_id#)
			 </cfif>
			   and (am.mensagem_id > ast.mensagem_id or ast.mensagem_id is null)
			   and am.tipo_id = 1
			 order by atd.atendimento_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
</cfcomponent>