<cfcomponent displayname="Componentes de consulta para o controle de trafego" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Retorna filiais que movimentam estoque
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/03/2007 - criado
	--->	
	<cffunction name="get_filial_estoque" displayname="Retorna todos os tipos de dados" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select f.cod_pessoa, f.nome 
			  from oper.v$filial f
			 where exists (select 1
						     from almoxarifado.v$movimentacao m
						    where m.COD_PESSOA_FILIAL = f.cod_pessoa)
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os tipos de dados utilizados para os atributos do almoxarifado
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/06/2006 - criado
	--->	
	<cffunction name="get_tipo_dado" displayname="Retorna todos os tipos de dados" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select nome, codigo, descricao 
			  from almoxarifado.v$tipo_dado
			 order by nome
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os atributos cadastrados
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/06/2006 - criado
	--->	
	<cffunction name="get_atributo" displayname="Retorna os dados do atributo" access="remote" returntype="query" output="true">
		<cfargument name="atributo_id" required="no" default=""/>
		<cfargument name="descricao" required="no" default=""/>
		<cfargument name="entrada" required="no" default=""/>
		<cfargument name="saida" required="no" default=""/>
		<cfargument name="estoque" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select a.atributo_id, 
				   a.descricao, 
				   a.comentario, 
				   a.tipo_dado, 
				   a.ativo, 
				   a.estoque, 
				   a.entrada, 
				   a.saida,
				   case tipo_dado
					 when 'LISTA' then (select kss.fnc_concat_all(kss.to_concat_expr(ai.valor,','))
										  from almoxarifado.v$atributo_item ai
										 where ai.atributo_id = a.atributo_id)
					 when 'FLAG' then 'Sim,No'
					 else ''
				   end as itens
			  from almoxarifado.v$atributo a
  			 where 1=1
			 <cfif Len(Trim(arguments.atributo_id))>
			 	and a.atributo_id = #arguments.atributo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.descricao))>
			 	and upper(a.descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 <cfif Len(Trim(arguments.entrada))>
			 	and a.entrada = #arguments.entrada#
			 </cfif>
			 <cfif Len(Trim(arguments.saida))>
			 	and a.saida = #arguments.saida#
			 </cfif>
			 <cfif Len(Trim(arguments.estoque))>
			 	and a.estoque = #arguments.estoque#
			 </cfif>
			 order by a.descricao
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna todos os tipos de dados utilizados para os atributos do almoxarifado
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/06/2006 - criado
	--->	
	<cffunction name="get_atributo_item" displayname="Retorna os itens do atributo" access="remote" returntype="query" output="true">
		<cfargument name="atributo_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select atributo_id, item_id, valor
			  from almoxarifado.v$atributo_item
			 where 1=1
			 <cfif Len(Trim(arguments.atributo_id))>
			 	and atributo_id = #arguments.atributo_id#
			 </cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca as unidades de medida
	-- CRISTOFER  07/07/2006
	--->		
	<cffunction name="get_unidade_medida" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_unidade,
				   unidade,
				   permite_editar,
				   permite_excluir,
				   cod_grupo_umedida,
				   valor_em
			  from fiscal.v$unidade_medida	
			 where 1=1
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os materiais cadastrados
	-- CRISTOFER  07/07/2006
	--->		
	<cffunction name="get_material" access="remote" returntype="query" output="true">
		<cfargument  name="material_id" required="no" default="">
		<cfargument  name="inventario" required="no" default="">
		<cfargument  name="estoque" required="no" default="">
		<cfargument  name="material_pai" required="no" default="">
       	<cfargument  name="cod_material" required="no" default="">
        <cfargument  name="material_descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.material_id,
				   m.material_pai,
				   nvl(m.material_pai,0) as material_pai_nvl,
				   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id,' ') material_descricao,
				   m.cod_material,
				   m.titulo,
				   m.descricao,
				   m.compoe_descricao,
				   m.estoque,
                   m.ativo,
				   m.unidade_estoque,
				   um1.unidade as unid_estoque,
				   m.unidade_comercializacao,
				   um1.unidade as unid_comercializacao,				   
				   m.identificado, m.modelo_id, m.grupo_id
				   <cfif arguments.inventario eq 1>
				   ,(select max(data_lancamento)
				      from almoxarifado.v$movimentacao mov
					 where mov.material_id = m.material_id
					   and mov.operacao_tipo_id = 1) as ultimo_inventario
				   </cfif>
				   <cfif len(trim(arguments.estoque))>
				   ,almoxarifado.pkg_almoxarifado.fnc_estoque_material(m.material_id, #arguments.estoque#, sysdate) as quantidade_estoque
				   </cfif> 
                   <cfif not len(trim(arguments.material_id))>
                   ,connect_by_isleaf as folha
                   </cfif>
			  from almoxarifado.v$material m
			  left join fiscal.v$unidade_medida um1
			         on um1.cod_unidade = m.unidade_estoque
		      left join fiscal.v$unidade_medida um2
			         on um2.cod_unidade = m.unidade_comercializacao
			 where 1=1
			<cfif len(trim(arguments.material_id))>
			   and m.material_id = #arguments.material_id#
			<cfelse>
				<cfif len(trim(arguments.material_pai))>
                    <cfif lcase(arguments.material_pai) eq 'null'>
                   and m.material_pai is #arguments.material_pai#
                    <cfelse>
                   and m.material_pai = #arguments.material_pai#
                    </cfif>
                </cfif>		
                <cfif len(trim(arguments.material_descricao))>
                    and upper(material_descricao) like upper('%#arguments.material_descricao#%')
                 </cfif>	
                 <cfif len(trim(arguments.cod_material))>
                    and m.cod_material = #arguments.cod_material#
                 </cfif>
                 start with m.material_pai is null
                connect by prior m.material_id = m.material_pai
                order siblings by m.titulo 
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os atributos do material
	-- CRISTOFER  10/07/2006
	--->		
	<cffunction name="get_material_atributo" access="remote" returntype="query" output="true">
		<cfargument name="material_id" required="yes">
		<cfargument name="entrada" required="no" default="0"/>
		<cfargument name="saida" required="no" default="0"/>
		<cfargument name="estoque" required="no" default=""/>
		<cfargument name="transferencia_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ma.material_id,
				   ma.atributo_id,
				   a.descricao as atributo,
				   ma.obrigatorio,
				   ma.valor_padrao,
				   ma.user_insert,
				   ma.date_insert,
				   ma.user_update,
				   ma.date_update,
				   ma.site,
				   a.tipo_dado,
				   case tipo_dado
					 when 'LISTA' then (select kss.fnc_concat_all(kss.to_concat_expr(ai.valor,','))
										  from almoxarifado.v$atributo_item ai
										 where ai.atributo_id = a.atributo_id)
					 when 'FLAG' then 'Sim,No'
					 else ''
				   end as itens,
                   almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(#session.cod_pessoa#,ma.material_id,12) as ult_localizacao,
             	   almoxarifado.pkg_almoxarifado.fnc_proximo_cod_equipamento() as cod_equipamento,
			       almoxarifado.to_material_estoque(ma.material_id).valor_unitario valor_unitario
			    <cfif Len(Trim(arguments.transferencia_id))>		
				  , (select md.identificador
					   from almoxarifado.v$movimentacao_dados md
					  inner join almoxarifado.v$transferencia t
						 	  on t.lancamento_id_saida = md.lancamento_id
					  where t.transferencia_id = #arguments.transferencia_id#) as equipamento_transferido
				</cfif>	
					
			  from almoxarifado.v$material_atributo	ma
			 inner join almoxarifado.v$atributo a
			         on a.atributo_id = ma.atributo_id
			 where 1=1
			   and material_id = #arguments.material_id#
			<cfif arguments.entrada eq 1>
			   and a.entrada = #arguments.entrada#
			</cfif>
			<cfif arguments.saida eq 1>
			   and a.saida = #arguments.saida#
			</cfif>
			<cfif Len(Trim(arguments.estoque))>
			   and a.estoque = #arguments.estoque#
			</cfif>
			order by ma.obrigatorio desc, a.descricao 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca atributo vinculado ao material e a filial
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 09/01/2007 - criado
	--->	
	<cffunction name="get_material_atributo_filial" displayname="Busca atributo vinculado ao material e a filial" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="atributo_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select maf.cod_pessoa_filial, maf.material_id, maf.atributo_id, maf.valor,
				   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(maf.material_id,' ') material_descricao,
				   p.cliente as filial, a.descricao as atributo
			  from almoxarifado.v$material_atributo_filial maf
			 inner join kss.v$pessoa p 
			         on p.cod_pessoa = maf.cod_pessoa_filial
			 inner join almoxarifado.v$atributo a
			         on a.atributo_id = maf.atributo_id
			 where 1=1
			<cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
		       and cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
			</cfif>
			<cfif Len(Trim(arguments.MATERIAL_ID))>
		       and material_id = #arguments.MATERIAL_ID#
			</cfif>
			<cfif Len(Trim(arguments.ATRIBUTO_ID))>
		       and maf.atributo_id = #arguments.ATRIBUTO_ID#
			</cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca os materiais da requisio
	-- CRISTOFER  14/07/2006
	--->		
	<cffunction name="get_requisicao_material" access="remote" returntype="query" output="true">
		<cfargument name="requisicao_id" required="no" default="">
		<cfargument name="classe_id" required="no" default="">
		<cfargument name="cotacoes_usuario" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cr.requisicao_id,
				   cr.condicao_id,
				   cr.classe_id,
				   cs.descricao as classe,
				   cr.data_requisicao,
				   cr.valor_total,
				   cr.situacao,
				   cr.entrega_em,
				   cr.cod_pessoa_filial,
				   cm.material_id,
				   almoxarifado.pkg_almoxarifado.FNC_GET_MATERIAL_DESCRICAO(cm.material_id,'>') as material,
				   cm.quantidade,
				   cm.cod_unidade,
				   un.unidade,
				   cm.observacao,
				   m.estoque,
				   <cfif arguments.cotacoes_usuario eq 1>
				   (select count(*) 
					  from oper.v$compra_cotacao cc
					 where cc.requisicao_id = cm.requisicao_id
					   and cc.cod_pessoa_fornecedor = #session.cod_pessoa_usuario#) as cotacoes_usuario,
				   </cfif>
				   cr.user_insert,
				   cr.date_insert,
				   cr.user_update,
				   cr.date_update,
				   cr.site
			  from oper.v$compra_requisicao cr
			 inner join oper.v$compra_material_classe cs
			         on cs.classe_id = cr.classe_id
			  left join oper.v$compra_requisicao_material cm
					 on cm.requisicao_id = cr.requisicao_id
			  left join almoxarifado.v$material m
					 on m.material_id = cm.material_id
			  left join kss.v$unidade_medida un
					 on un.cod_unidade = cm.cod_unidade
			 where 1=1	
			<cfif len(trim(arguments.requisicao_id))>
			   and cr.requisicao_id in (#arguments.requisicao_id#)
			</cfif>
			<cfif len(trim(arguments.classe_id))>
			   and cr.classe_id in (#arguments.classe_id#)
			</cfif>
			 order by cr.classe_id, cr.requisicao_id, 10
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca as classes de materiais de um fornecedor
	-- CRISTOFER  14/07/2006
	--->		
	<cffunction name="get_fornecedor_classe" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="classe_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fc.cod_pessoa,
				   fc.classe_id,
				   cmc.descricao as classe,
				   fc.user_insert,
				   fc.date_insert,
				   fc.user_update,
				   fc.date_update,
				   fc.site
			  from oper.v$compra_fornecedor_classe fc
			 inner join oper.v$compra_material_classe cmc
			         on cmc.classe_id = fc.classe_id
			 where 1=1
			 <cfif len(trim(arguments.cod_pessoa))>
			   and fc.cod_pessoa in (#arguments.cod_pessoa#)
			 </cfif>
			 <cfif len(trim(arguments.classe_id))>
			   and fc.classe_id in (#arguments.classe_id#)
			 </cfif>
			 order by cmc.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  
	
	<!--- 
	-- PROPSITO 
	-- Busca uma lista de materiais e com sua estrutura anterior e todos os seus nos filhos
	-- CRISTOFER  14/07/2006
	--->		
	<cffunction name="get_material_requisicao_tree" access="remote" returntype="query" output="true">
		<cfargument name="requisicao_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.material_id,
				   m.material_pai,
				   m.cod_material,
				   m.titulo,
				   m.descricao,
				   m.compoe_descricao,
				   m.estoque,
				   m.unidade_estoque,
				   m.unidade_comercializacao,
				   m.identificado,
				   m.user_insert,
				   m.date_insert,
				   m.user_update,
				   m.date_update,
				   m.site,
				   nivel,
				   cotar,
				   material_requisicao,
				   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id, '>') as descricao_completa,
				   first_value(rm.quantidade) over (partition by grupo order by grupo) as quantidade,
				   first_value(rm.cod_unidade) over (partition by grupo order by grupo) as cod_unidade_requisicao
			  from (select mt.material_id,
						   mt.cotar,
						   mt.requisicao_id,
						   rownum as linha,
						   level as nivel,
						   count(rm.material_id) over(order by rownum) as grupo,
						   decode(rm.material_id, null, 0, 1) as material_requisicao
					  from (select material_id, material_pai, 0 as cotar, #arguments.requisicao_id# as requisicao_id
							  from almoxarifado.v$material
							 where material_id not in (select material_id
														 from oper.v$compra_requisicao_material
														where requisicao_id = #arguments.requisicao_id#)
							 start with material_id in (select material_id
														  from oper.v$compra_requisicao_material
														 where requisicao_id = #arguments.requisicao_id#)
							connect by prior material_pai = material_id
							union
							select material_id, material_pai, 1 as cotar, #arguments.requisicao_id# as requisicao_id
							  from almoxarifado.v$material
							 start with material_id in (select material_id
														  from oper.v$compra_requisicao_material
														 where requisicao_id = #arguments.requisicao_id#)
							connect by prior material_id = material_pai) mt
					  left join oper.v$compra_requisicao_material rm 
							 on rm.material_id = mt.material_id
							and rm.requisicao_id = mt.requisicao_id
					 start with mt.material_pai is null
					connect by prior mt.material_id = mt.material_pai) mt
			  inner join almoxarifado.v$material m
					  on mt.material_id = m.material_id
			   left join oper.v$compra_requisicao_material rm
					  on rm.material_id = m.material_id
					 and rm.requisicao_id = mt.requisicao_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as cotaes realizadas para a requisicao
	-- CRISTOFER  17/07/2006
	--->		
	<cffunction name="get_compra_cotacao" access="remote" returntype="query" output="true">
		<cfargument name="requisicao_id" required="yes">
		<cfargument name="cod_pessoa_fornecedor" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cotacao_id,
				   requisicao_id,
				   material_id,
				   cod_pessoa_fornecedor,
				   data_cotacao,
				   data_aprovacao,
				   data_cancelamento,
				   cod_unidade,
				   quantidade,
				   valor_unitario,
				   valor_total,
				   observacao,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from oper.v$compra_cotacao	
			 where 1=1
			   and requisicao_id in (#arguments.requisicao_id#)
			  <cfif len(trim(arguments.cod_pessoa_fornecedor))>
			   and cod_pessoa_fornecedor in (#arguments.cod_pessoa_fornecedor#)
			  </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os tipos de movimentacao
	-- CRISTOFER  31/07/2006
	--->		
	<cffunction name="get_operacao_tipo" access="remote" returntype="query" output="true">
		<cfargument name="operacao_tipo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select operacao_tipo_id,
				   descricao,
				   d_c,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from almoxarifado.v$operacao_tipo
			 where 1=1
			 <cfif len(trim(arguments.operacao_tipo_id))>
			   and operacao_tipo_id in (#arguments.operacao_tipo_id#)
			 </cfif>
			 order by descricao	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca as transferencias de material
	-- CRISTOFER  01/08/2006
	--->		
	<cffunction name="get_transferencia" access="remote" returntype="query" output="true">
		<cfargument name="transferencia_id" required="no" default="">
		<cfargument name="material_id" required="no" default="">
		<cfargument name="em_aberto" required="no" default="">
		<cfargument name="cod_pessoa_filial_saida" required="no" default="">
		<cfargument name="cod_pessoa_filial_destino" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.transferencia_id,
				   t.lancamento_id_saida,
				   m.quantidade,
				   m.material_id,
				   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id, ' ') as descricao,
				   m.cod_pessoa_filial,
				   ps.nome_fantasia as filial_saida,
				   t.data_saida,
				   t.lancamento_id_entrada,
				   t.data_entrada,
				   t.usuario_entrada,
				   t.usuario_cancelamento,
				   t.cod_pessoa_filial_destino,
				   pd.nome_fantasia as filial_destino,
				   t.user_insert,
				   t.date_insert,
				   t.user_update,
				   t.date_update,
				   t.site,
                   t.analise_id,
                   e.cod_equipamento
			  from almoxarifado.v$transferencia t
			 inner join almoxarifado.v$movimentacao m
					 on m.lancamento_id = t.lancamento_id_saida
			 inner join kss.v$pessoa_juridica ps
					 on ps.cod_pessoa = m.cod_pessoa_filial
			 inner join kss.v$pessoa_juridica pd
					 on pd.cod_pessoa = t.cod_pessoa_filial_destino
              left join almoxarifado.v$equipamento e
                      on e.equipamento_id = m.equipamento_id
			 where 1=1
			 <cfif len(trim(arguments.transferencia_id))>
			   and t.transferencia_id in (#arguments.transferencia_id#)
			 </cfif>
			 <cfif len(trim(arguments.material_id))>
			   and m.material_id in (#arguments.material_id#)
			 </cfif>
			 <cfif arguments.em_aberto eq 1>
			   and t.data_entrada is null
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial_saida))>
			   and m.cod_pessoa_filial in (#arguments.cod_pessoa_filial_saida#)
			 </cfif>
			 <cfif len(trim(arguments.USUARIO))>
			   and t.user_insert = '#Ucase(arguments.usuario)#'
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial_destino))>
			   and t.cod_pessoa_filial_destino in (#arguments.cod_pessoa_filial_destino#)
			 </cfif>
			 order by data_saida 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as transferencias em uma data
	-- CRISTOFER  01/08/2006
	--->		
	<cffunction name="get_transferencia_data" access="remote" returntype="query" output="true">
		<cfargument name="data" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.transferencia_id, mv.data_lancamento,
                   mv.quantidade, m.descricao_completa as material, m.unidade_estoque,
                   e.cod_equipamento, p.cliente as filial_destino, t.cod_pessoa_filial_destino,
                   decode(t.analise_id,null,0,1) as em_analise, t.analise_id
              from almoxarifado.v$movimentacao mv
             inner join almoxarifado.v$material m
                     on m.material_id = mv.material_id
             inner join almoxarifado.v$transferencia t
                     on mv.lancamento_id = t.lancamento_id_saida
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = t.cod_pessoa_filial_destino
             left join almoxarifado.v$equipamento e
                     on e.equipamento_id = mv.equipamento_id
             where mv.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
               and trunc(mv.data_lancamento) = '#arguments.DATA#'
                 and t.data_entrada is null
            order by cod_pessoa_filial_destino, data_lancamento desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca materiais
	-- GUTO  19/09/2006
	--->		
	<cffunction name="get_material_lista" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select material_id, almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(material_id, ' ') as material,
				   cod_genuino, cod_fabricante, cod_paralelo
			  from almoxarifado.v$material_dados m
			 where m.estoque = 1
			 start with m.material_pai is null
			connect by prior m.material_id = m.material_pai
			order siblings by m.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os equipamentos relacionados aos materiais
	-- ARLEN  21/11/2006
	--->		
	<cffunction name="get_equipamento_material" access="remote" returntype="query" output="true">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select eq.cod_equipamento, eq.equipamento_id,
				   eq.data_aquisicao,
				   eq.data_inativacao,
				   eq.situacao,
				   eq.ativo,
				   eq.em_manutencao,
				   eq.montado,
				   (select e.cod_equipamento
					  from manutencao.v$equipamento_material em
				inner join almoxarifado.v$equipamento e
						on e.equipamento_id = em.equipamento_id
					 where em.equipamento_id_identificado = eq.equipamento_id
					   and em.ordem_servico_id_desmontagem is null) as equip_montado
					  from almoxarifado.v$equipamento eq
					 inner join almoxarifado.v$material ma
							 on ma.material_id = eq.material_id
			 where 1=1
			 <cfif len(trim(arguments.material_id))>
			   and ma.material_id = #arguments.material_id#
			 </cfif>
			 order by eq.cod_equipamento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction> 
	
	<!--- 
	-- PROPSITO 
	-- Busca a raiz dos materiais
	-- ARLEN  22/11/2006
	--->		
	<cffunction name="get_raiz" access="remote" returntype="query" output="true">
		<cfargument  name="material_id" required="no" default="">
		<cfargument  name="material_pai" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select t.material_id,
			   t.material_pai,
			   nvl(t.material_pai, 0) as material_pai_nvl,
			   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(t.material_id, ' ') as material_descricao,
			   t.cod_material,
			   t.titulo,
			   t.descricao,
			   t.compoe_descricao,
			   t.estoque,
			   t.unidade_estoque,
			   t.identificado 
		from almoxarifado.v$material t
		where t.material_pai is null
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca os materiais cadastrados
	-- ARLEN  27/11/2006
	--->		
	<cffunction name="get_material_cadastro" access="remote" returntype="query" output="true">
		<cfargument  name="material_id" required="no" default="">
		<cfargument  name="inventario" required="no" default="">
		<cfargument  name="estoque" required="no" default="">
		<cfargument  name="material_pai" required="no" default="">
		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.material_id,
				   m.material_pai,
					m.material,
				   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id, ' ') as material_descricao,
				   nvl(m.material_pai,0) as material_pai_nvl,
				   m.cod_material,
				   m.titulo,
				   m.descricao,
				   m.compoe_descricao,
				   m.estoque,
				   m.unidade_estoque,
				   um1.unidade as unid_estoque,
				   m.unidade_comercializacao,
				   um1.unidade as unid_comercializacao,				   
				   m.identificado,
				   <cfif arguments.inventario eq 1>
				   (select max(data_lancamento)
				      from almoxarifado.v$movimentacao mov
					 where mov.material_id = m.material_id
					   and mov.operacao_tipo_id = 1) as ultimo_inventario,
				   </cfif>
				   <cfif len(trim(arguments.estoque))>
				   almoxarifado.pkg_almoxarifado.fnc_estoque_material(m.material_id, #arguments.estoque#, sysdate) as quantidade_estoque,
				   </cfif>
				   m.user_insert,
				   m.date_insert,
				   m.user_update,
				   m.date_update,
				   m.site
			  from almoxarifado.v$material_dados m
			  left join kss.v$unidade_medida um1
			         on um1.cod_unidade = m.unidade_estoque
		      left join kss.v$unidade_medida um2
			         on um2.cod_unidade = m.unidade_comercializacao
			 where 1=1
			 <cfif len(trim(arguments.material_pai))>
			   and m.material_pai in (#arguments.material_pai#)
			</cfif>
			<cfif len(trim(arguments.material_id))>
			   and m.material_id = #arguments.material_id#
			<cfelse>
			 start with m.material_pai is null
			connect by prior m.material_id = m.material_pai
			</cfif>
			order by  m.titulo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os componentes do material
	-- CRISTOFER  30/11/2006
	--->		
	<cffunction name="get_material_componente" access="remote" returntype="query" output="true">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.material_id,
				   m.material_id_componente,
				   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id_componente,' ') descricao_componente,
				   m.user_insert,
				   m.date_insert,
				   m.user_update,
				   m.date_update,
				   m.site
			  from almoxarifado.v$material_componente m
			 where 1=1
			 <cfif len(trim(arguments.material_id))>
			   and m.material_id = #arguments.material_id#
			 </cfif>
			 order by m.material_id_componente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	

	<!--- 
	-- PROPSITO 
	-- Busca o proximo identificador para o EQUIPAMENTO
	-- GUTO  15/12/2006
	--->		
	<cffunction name="get_proximo_num_equipamento" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select manutencao.pkg_ordem_servico.fnc_proximo_cod_equipamento() as cod_equipamento
			  from dual
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca saldo em estoque
	-- GUTO  18/12/2006
	--->		
	<cffunction name="get_saldo_estoque" access="remote" returntype="query" output="true">
		<cfargument name="material_id" required="yes">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="filiais" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.filiais eq 0>
				<cfif Len(Trim(arguments.cod_pessoa_filial))>
					select almoxarifado.pkg_almoxarifado.fnc_estoque_material(#arguments.material_id#,#arguments.cod_pessoa_filial#,'#arguments.data_inicio#') as saldo
				<cfelse>
					select almoxarifado.pkg_almoxarifado.fnc_estoque_material(#arguments.material_id#,'#arguments.data_inicio#') as saldo
				</cfif>
				  from dual
			<cfelse>
				select f.nome as filial, almoxarifado.pkg_almoxarifado.fnc_estoque_material(#arguments.MATERIAL_ID#,f.cod_pessoa, sysdate) as saldo
				  from oper.v$filial f			
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca movimentao do estoque
	-- GUTO  18/12/2006
	--->		
	<cffunction name="get_movimentacao" access="remote" returntype="query" output="true">
		<cfargument name="material_id" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="POR_DATA" required="no" default="">        
        <cfargument name="organizacional_id" required="no" default="">        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.lancamento_id, ot.descricao as operacao_tipo, 
					   decode(ot.d_c,0,'Sada','Entrada') as d_c,
					   ot.d_c as d_c_id,
					   md.material, m.material_id,
                       to_char(m.data_lancamento,'dd/mm/yyyy hh24:mi') as data_lancamento, m.observacao,
					   m.cod_pessoa_filial, p.cliente as filial,
					   nvl(m.quantidade, 0) as quantidade, nvl(m.valor_unitario, 0)as valor_unitario, nvl(m.valor_total, nvl(m.quantidade, 0) * nvl(m.valor_unitario, 0)) as valor_total,
					   md.unidade_estoque,
					   m.identificador, m.localizacao,
					   almoxarifado.pkg_almoxarifado.fnc_estoque_material(md.material_id,m.cod_pessoa_filial,m.data_lancamento - 1/1440) as saldo
					   ,almoxarifado.pkg_almoxarifado.fnc_estoque_material(md.material_id,m.cod_pessoa_filial,m.data_lancamento) as saldo_real
                       ,m.organizacional
			  from almoxarifado.v$movimentacao_dados m
			 inner join almoxarifado.v$material_dados md
						on md.material_id = m.material_id
			 inner join kss.v$pessoa p 
						on p.cod_pessoa = m.cod_pessoa_filial
			 inner join almoxarifado.v$operacao_tipo ot
						on ot.operacao_tipo_id = m.operacao_tipo_id
			 where 1=1
			<cfif Len(Trim(arguments.cod_equipamento))>
				and m.equipamento_id = manutencao.to_equipamento_dados('#arguments.cod_equipamento#').equipamento_id
			</cfif>
			<cfif Len(Trim(arguments.material_id))>
				and md.material_id = #arguments.material_id#			 
			</cfif>
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
				and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#			 
			</cfif>
             
			<cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
				and m.data_lancamento between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_inicio))>
                and m.data_lancamento >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_fim))>
			    and m.data_lancamento between <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
			</cfif>
             <cfif Len(Trim(arguments.organizacional_id))>
				and m.organizacional_id = #arguments.organizacional_id#			 
			</cfif>
            
            <cfif Len(Trim(arguments.POR_DATA))>
               order by m.data_lancamento
			<cfelse>
			   order by m.cod_pessoa_filial, md.material, m.data_lancamento
            </cfif>
  		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

   <!--- 
	-- PROPSITO 
	-- Busca movimentao do estoque
	-- wagnerlv  18/12/2006
	--->		
	<cffunction name="get_equipamento_sucata_detalhes" access="remote" returntype="query" output="true">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 
            mov.OPERACAO_TIPO_ID,
            e.equipamento_id,
                   e.lancamento_id,
                   e.cod_equipamento,
                   e.data_aquisicao,
                   e.data_inativacao,
                   e.ativo,
                   e.em_manutencao,
                   e.montado,
                   md.material,
                   el.cod_pessoa_filial,
                   f.cliente as filial,
                   el.data_entrada,
                   el.data_saida,
                   ep.cod_pessoa_proprietario,
                   prop.cliente as proprietario,
                   (select e2.cod_equipamento
                      from manutencao.v$equipamento_material em
                     inner join almoxarifado.v$equipamento e2 on e2.equipamento_id =
                                                                 em.equipamento_id
                     where em.equipamento_id_identificado = e.equipamento_id
                       and em.ordem_servico_id_desmontagem is null) as equipamento_montado,
                   case
                     when e.em_manutencao = 1 then
                      (select 'O.S.: ' || to_char(os.num_ordem_servico) || ' Local: ' ||
                              p.cliente
                         from manutencao.v$ordem_servico os
                        inner join kss.v$pessoa p on p.cod_pessoa =
                                                      os.cod_pessoa_oficina
                        where os.equipamento_id = e.equipamento_id
                          and os.data_fechamento is null)
                     else
                      ''
                   end local_manutencao	
              from almoxarifado.v$equipamento e
             inner join almoxarifado.v$material_dados md on md.material_id =
                                                            e.material_id
              left join almoxarifado.v$equip_proprietario_atual ep on ep.equipamento_id =
                                                                      e.equipamento_id
              left join kss.v$pessoa prop on prop.cod_pessoa =
                                              ep.cod_pessoa_proprietario
              left join almoxarifado.v$equipamento_localizacao el on el.equipamento_id =
                                                                     e.equipamento_id
              left join kss.v$pessoa f on f.cod_pessoa = el.cod_pessoa_filial
              left join almoxarifado.v$movimentacao_dados mov on mov.EQUIPAMENTO_ID = e.EQUIPAMENTO_ID
             where 1 = 1
                <cfif Len(Trim(arguments.cod_equipamento))>
                            and e.cod_equipamento = upper('#arguments.cod_equipamento#')
                </cfif>
               and el.LOCALIZACAO_ID = (select max(el2.LOCALIZACAO_ID)
                            		    from almoxarifado.v$equipamento_localizacao el2
                            			where el2.equipamento_id = el.equipamento_id)
   			   and mov.DATA_LANCAMENTO = (select max(mov2.DATA_LANCAMENTO) 
                              			  from almoxarifado.v$movimentacao mov2
                           			      where mov2.EQUIPAMENTO_ID = mov.EQUIPAMENTO_ID)
             order by el.data_entrada	
            </cfquery>
		<cfreturn qr_result>		
	</cffunction>	
 


	<!--- 
	-- PROPSITO 
	-- Busca posicao estoque
	-- GUTO  02/01/2007
	--->		
	<cffunction name="get_posicao_estoque" access="remote" returntype="query" output="true">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select md.material_id,  md.cod_material, md.cod_genuino, md.cod_fabricante, md.cod_paralelo, md.identificado, 
						 md.unidade_estoque, md.material, 
						 nvl(md.qtde_minima,0) as qtde_minima,
						 almoxarifado.pkg_almoxarifado.fnc_estoque_material(md.material_id, sysdate) as saldo
				  from almoxarifado.v$material_dados md
				 where md.estoque = 1
				<cfif Len(Trim(arguments.material_id))>
				   and md.material_id in(#arguments.material_id#)
				</cfif>
			  order by md.material
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca Materiais transferidos
	-- WAGNER  09/01/2007
	--->		
	<cffunction name="print_transferencia_materiais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_origem" required="yes">
		<cfargument name="cod_pessoa_destino" required="yes">
        <cfargument name="transferencias_aberto" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select mo.data_lancamento as data_saida,
                	   mo.identificador, 	
					   (select t.nome
          				  from oper.v$filial t
         				 where t.cod_pessoa =  mo.cod_pessoa_filial) as filial_origem,
       				   (select t.nome
          				  from oper.v$filial t
         				 where t.cod_pessoa =  tr.cod_pessoa_filial_destino) as filial_destino,
       				   mo.quantidade as quantidade,
					   mo.cod_pessoa_filial as origem,
					   tr.cod_pessoa_filial_destino as destino,
					   mo.quantidade as quantidade,
					   ma.unidade_estoque as unidade,
					   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(ma.material_id,' ') as material,
					   nvl(ma.cod_material,'---') as cod_material
				  from almoxarifado.v$movimentacao_dados mo 
			inner join almoxarifado.v$transferencia tr 
					on tr.lancamento_id_saida = mo.lancamento_id
			inner join almoxarifado.v$material ma
					on ma.material_id = mo.material_id
				 where 1=1
			<cfif len(Trim(arguments.cod_pessoa_origem))>
				   and mo.cod_pessoa_filial = #arguments.cod_pessoa_origem#
 			</cfif>
			<cfif len(Trim(arguments.cod_pessoa_destino))>
				   and tr.cod_pessoa_filial_destino = #arguments.cod_pessoa_destino#
			</cfif>
            <cfif len(Trim(arguments.transferencias_aberto))>
				   and tr.data_entrada is null
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca materiais com os atributos de estoque maximo e minimo	
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 02/02/2007 - criado
	--->	
	<cffunction name="get_material_estoque_min_max" displayname="Retorna todos os tipos de dados" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(md.material_id,' ') as material,
				   md.material_id,
				   almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(#arguments.cod_pessoa_filial#,material_id, 5) as estoque_minimo,
				   almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(#arguments.cod_pessoa_filial#,material_id, 27) as estoque_maximo
			  from almoxarifado.v$material md
			 where md.estoque = 1
			   and exists (select 'x'
							 from almoxarifado.v$material_atributo ma
							where ma.material_id = md.material_id
							  and ma.atributo_id = 5)
			order by material
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Query para relatorio de reposio de peas
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 03/02/2007 - criado
	--->	
	<cffunction name="get_material_reposicao" displayname="Query para relatorio de reposio de peas" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select m.material_id, m.cod_material
				   ,almoxarifado.fnc_get_material_descricao(m.material_id, ' ') as material
				   ,m.unidade_estoque, m.cod_genuino, m.cod_fabricante,
				   ,almoxarifado.to_material_movimentacao(m.material_id<cfif Len(Trim(arguments.cod_pessoa_filial))>,#arguments.cod_pessoa_filial#</cfif>).localizacao as ult_localizacao
				   ,round(almoxarifado.pkg_almoxarifado.fnc_estoque_material(m.material_id<cfif Len(Trim(arguments.cod_pessoa_filial))>,#arguments.cod_pessoa_filial#</cfif>, sysdate),2) as qtde_atual
				   ,round(almoxarifado.PKG_ALMOXARIFADO.FNC_GET_ATRIBUTO_MAT(<cfif Len(Trim(arguments.cod_pessoa_filial))>#arguments.cod_pessoa_filial#,</cfif>MATERIAL_ID, 5),2) AS QTDE_MINIMA
				   ,round(almoxarifado.PKG_ALMOXARIFADO.FNC_GET_ATRIBUTO_MAT(<cfif Len(Trim(arguments.cod_pessoa_filial))>#arguments.cod_pessoa_filial#,</cfif>MATERIAL_ID, 27),2) AS QTDE_MAXIMA
				   ,round(almoxarifado.to_material(m.material_id<cfif Len(Trim(arguments.cod_pessoa_filial))>,#arguments.cod_pessoa_filial#</cfif>).valor_unitario,2) as unit_medio
				   ,round(almoxarifado.to_material(m.material_id<cfif Len(Trim(arguments.cod_pessoa_filial))>,#arguments.cod_pessoa_filial#</cfif>).ultimo_valor,2) as unit_ult_compra
				   ,almoxarifado.to_material_movimentacao(m.material_id<cfif Len(Trim(arguments.cod_pessoa_filial))>,#arguments.cod_pessoa_filial#</cfif>).ultimo_fornecedor as ult_fornecedor
				   ,almoxarifado.to_material_movimentacao(m.material_id<cfif Len(Trim(arguments.cod_pessoa_filial))>,#arguments.cod_pessoa_filial#</cfif>).data_ultima_compra as data_ult_compra
			  from almoxarifado.v$material m
			 where estoque = 1	
			order by material 
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna lista de proprietarios
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 15/02/2007 - criado
	--->	
	<cffunction name="get_proprietarios" displayname="Retorna lista de proprietarios" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select distinct p.cod_pessoa, p.cliente as proprietario
			  from almoxarifado.v$equip_proprietario_atual epa
			 inner join kss.v$pessoa p 
				on p.cod_pessoa = epa.cod_pessoa_proprietario
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna detalhes do equipamento
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/02/2007 - criado
	--->	
	<cffunction name="get_equipamento_detalhes" access="remote" returntype="query" output="true">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select e.equipamento_id,
            	   e.lancamento_id,
                   e.cod_equipamento,
                   e.data_aquisicao,
				   e.data_inativacao,
                   e.ativo, 
                   e.em_manutencao,
                   case
                    when exists(select 'x'
                                   from manutencao.v$equipamento_material em2
                                  where em2.equipamento_id_identificado = e.EQUIPAMENTO_ID
                                    and em2.ORDEM_SERVICO_ID_DESMONTAGEM is null)
                     then 1
                    else 0
                   end montado,
				   md.material, 
                   el.cod_pessoa_filial, 
                   f.cliente as filial, 
				   el.data_entrada, el.data_saida,
           		   ep.cod_pessoa_proprietario, prop.cliente as proprietario, 
				   (select e2.cod_equipamento 
					  from manutencao.v$equipamento_material em
					 inner join almoxarifado.v$equipamento e2
							 on e2.equipamento_id = em.equipamento_id
					where em.equipamento_id_identificado = e.equipamento_id
					  and em.ordem_servico_id_desmontagem is null) as equipamento_montado,
				    case
					 when e.em_manutencao = 1 then
						  (select 'O.S.: ' || to_char(os.num_ordem_servico) || ' Local: ' || p.cliente
							 from manutencao.v$ordem_servico os
							inner join kss.v$pessoa p
									on p.cod_pessoa = os.cod_pessoa_oficina
							where os.equipamento_id = e.equipamento_id
							  and os.data_fechamento is null)
				    else '' end local_manutencao,
						case
								when exists (select 1
												from manutencao.v$equipamento_material em
											 where em.equipamento_id_identificado = e.equipamento_id
												 and em.ordem_servico_id_desmontagem is null) then
								 'Montado'
								when exists (select 1
												from manutencao.v$equipamento_analise ea
											 where ea.equipamento_id = e.equipamento_id
												 and ea.data_analise is null) then
								 'Em Analise'
								when exists (select 1
												from almoxarifado.v$movimentacao_dados m
											 inner join almoxarifado.v$transferencia t on t.lancamento_id_saida = m.lancamento_id
											 where m.equipamento_id = e.equipamento_id
												 and t.lancamento_id_entrada is null) then
								 'Em Transfrencia'
								when not exists (select 1
												from almoxarifado.v$movimentacao_dados m
											 where m.equipamento_id = e.equipamento_id) then
								 'Sem movimentao'
								when e.data_inativacao is not null then
								 'Sucateado'
								else
								 'Estoque'
							end as status						  
			  from almoxarifado.v$equipamento e
			 inner join almoxarifado.v$material_dados md
					 on md.material_id = e.material_id
			 left join almoxarifado.v$equip_proprietario_atual ep
               on ep.equipamento_id = e.equipamento_id
			 left join kss.v$pessoa prop
					 on prop.cod_pessoa = ep.cod_pessoa_proprietario
			 left join almoxarifado.v$equipamento_localizacao el
					 on el.equipamento_id = e.equipamento_id         
			 left join kss.v$pessoa f
					 on f.cod_pessoa = el.cod_pessoa_filial
			   where 1=1		 
			  <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
			  	and upper(e.cod_equipamento) = upper('#arguments.COD_EQUIPAMENTO#')
			  </cfif>
			  <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
			  	and e.equipamento_id = #arguments.EQUIPAMENTO_ID#
			  </cfif>
			  <cfif not Len(Trim(arguments.COD_EQUIPAMENTO)) and not Len(Trim(arguments.EQUIPAMENTO_ID))>
			  	and 1=0
			  </cfif>
			  order by el.data_entrada			  			  
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna lista de materiais em estoque
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/02/2007 - criado
	--->	
	<cffunction name="get_estoque_materiais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="data" required="no" default=""/>
		<cfargument name="valor_unitario_minimo" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select md.material_id, md.cod_material, md.material, md.cod_genuino, md.cod_fabricante,
				   almoxarifado.pkg_almoxarifado.fnc_estoque_material(md.material_id,f.cod_pessoa,<cfif Len(Trim(arguments.DATA))>to_date('#arguments.DATA# 23:59:59')<cfelse>sysdate</cfif>) as quantidade,
				   almoxarifado.to_material_estoque(md.material_id).valor_unitario as valor_unitario,
				   f.nome as filial, md.unidade_estoque,
				   nvl((select sum(m.quantidade)
					 from almoxarifado.v$movimentacao m
					inner join almoxarifado.v$operacao_tipo ot
							on ot.OPERACAO_TIPO_ID = m.OPERACAO_TIPO_ID
					where ot.d_c = 1
					  and m.cod_pessoa_filial = f.cod_pessoa
					  <cfif Len(Trim(arguments.DATA))>
					    and trunc(m.data_lancamento) <= to_date('#arguments.DATA# 23:59:59')
					  </cfif>
					  and m.material_id = md.material_id),0) as entradas,           
				   nvl((select sum(m.quantidade)
					 from almoxarifado.v$movimentacao m
					inner join almoxarifado.v$operacao_tipo ot
							on ot.OPERACAO_TIPO_ID = m.OPERACAO_TIPO_ID
					where ot.d_c = 0
					  and m.cod_pessoa_filial = f.cod_pessoa
					  <cfif Len(Trim(arguments.DATA))>
					    and trunc(m.data_lancamento) <= to_date('#arguments.DATA# 23:59:59')
					  </cfif>
					  and m.material_id = md.material_id),0) as saidas
			  from almoxarifado.v$material_dados md
			 natural join oper.v$filial f
			 where almoxarifado.pkg_almoxarifado.fnc_estoque_material(md.material_id,f.cod_pessoa,<cfif Len(Trim(arguments.DATA))>to_date('#arguments.DATA# 23:59:59')<cfelse>sysdate</cfif>) > 0
			   and f.cod_pessoa in (#arguments.cod_pessoa_filial#)
		   <cfif Len(Trim(arguments.MATERIAL_ID))>
			  and md.material_id in (#arguments.MATERIAL_ID#)
		   </cfif>
		   <cfif Len(Trim(arguments.VALOR_UNITARIO_MINIMO))>
			  and almoxarifado.to_material_estoque(md.material_id).valor_unitario >= #arguments.VALOR_UNITARIO_MINIMO#
		   </cfif>
			order by md.material
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna lista de materiais em estoque
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/02/2007 - criado
	--->	
	<cffunction name="get_material_entrada" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="operacao_tipo_id" required="no" default="1,2"/>
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select a.lancamento_id
                 , a.filial
                 , a.material_id
                 , a.material
                 , a.data_lancamento
                 , a.operacao
                 , a.valor_unitario
                 , avg(a.valor_unitario) over(partition by a.material_id) as valor_medio_material
                 , a.ultimo_fornecedor
                 , a.data_ultima_compra
                 , a.fornecedor
                 , a.quantidade
                 , a.unidade_estoque
                 , a.menor_valor as menor_valor
                 , a.maior_valor as maior_valor
                 , round((a.maior_valor / decode(a.menor_valor, 0, 1, a.menor_valor) - 1) * 100, 2) as variacao
              from (select m.lancamento_id
                         , f.nome as filial
                         , md.material_id
                         , md.material
                         , m.data_lancamento
                         , decode(m.operacao_tipo_id, 1, 'Inventrio', 2, 'Entrada') as operacao
                         , nvl(round(to_number(ma.valor, '99999999d0099999999999999', 'nls_numeric_characters=''.,'''), 3), 0) as valor_unitario
                         , almoxarifado.to_material_movimentacao(md.material_id) as movimentacao
                         , (select kss.pkg_pessoa.fnc_get_cliente(p.cod_pessoa_fornecedor, 1)
                              from compras.v$pedido_item pi
                             inner join compras.v$pedido p
                                     on p.pedido_id = pi.pedido_id
                             where pi.pedido_item_id = m.pedido_item_id
                               and rownum = 1
                           ) as fornecedor
                         , m.quantidade
                         , md.unidade_estoque
                         , (select max(kss.pkg_pessoa.fnc_get_cliente(p.cod_pessoa_fornecedor, 1)) keep(dense_rank last order by p.data_pedido)
                              from compras.v$cotacao c
                             inner join compras.v$pedido_item pi
                                     on pi.cotacao_id = c.cotacao_id
                             inner join compras.v$pedido p
                                     on p.pedido_id = pi.pedido_id
                             where c.material_id = md.material_id
                           ) as ultimo_fornecedor
                         , (select max(p.data_pedido)
                              from compras.v$cotacao c
                             inner join compras.v$pedido_item pi
                                     on pi.cotacao_id = c.cotacao_id
                             inner join compras.v$pedido p
                                     on p.pedido_id = pi.pedido_id
                             where c.material_id = md.material_id
                           ) as data_ultima_compra
                         , (select max(c.valor_unitario)
                              from compras.v$cotacao c
                             inner join compras.v$pedido_item pi
                                     on pi.cotacao_id = c.cotacao_id
                             inner join compras.v$pedido p
                                     on p.pedido_id = pi.pedido_id
                             where c.material_id = md.material_id
                               and p.data_pedido >= sysdate - 180
                           ) as maior_valor
                         , (select min(c.valor_unitario)
                              from compras.v$cotacao c
                             inner join compras.v$pedido_item pi
                                     on pi.cotacao_id = c.cotacao_id
                             inner join compras.v$pedido p
                                     on p.pedido_id = pi.pedido_id
                             where c.material_id = md.material_id
                               and p.data_pedido >= sysdate - 180
                           ) as menor_valor
                      from almoxarifado.v$material_dados md
                     inner join almoxarifado.v$movimentacao m
                             on m.material_id = md.material_id
                     inner join almoxarifado.v$movimentacao_atributo ma
                             on ma.lancamento_id = m.lancamento_id
                     inner join oper.v$filial f
                             on f.cod_pessoa = m.cod_pessoa_filial
                     where ma.atributo_id = 23
                       and ma.valor is not null
                       and m.material_id in
                           (select a.material_id
                              from table(almoxarifado.pkg_almoxarifado.fnc_material_filhos(#arguments.MATERIAL_ID#)) a
                           )
                       and m.operacao_tipo_id in (#arguments.operacao_tipo_id#)
                  	<cfif Len(Trim(arguments.DATA_INICIO))>
                       and trunc(m.data_lancamento) >= '#arguments.DATA_INICIO#'
                  	</cfif>
                  	<cfif Len(Trim(arguments.DATA_FIM))>
                       and trunc(m.data_lancamento) <= '#arguments.DATA_FIM#'
                  	</cfif>
                   ) a
             order by a.material_id, a.data_lancamento
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>


	<!--- 
	-- PROPSITO
	-- Retorna lista de materiais para reposio
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/02/2007 - criado
	--->	
	<cffunction name="get_material_reposicao_lista" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="reposicao" required="no" default=""/>
		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select material_id, material, unidade_estoque, 
            	   round(estoque_atual,2) as estoque_atual, 
                   round(estoque_minimo_projetado,2) as estoque_minimo_projetado, 
                   round(estoque_maximo_projetado,2) as estoque_maximo_projetado, 
                   round(valor_unitario,2) as valor_unitario, 
                   ult_fornecedor, 
                   localizacao, 
                   round(estoque_atual_total,2) as estoque_atual_total, 
                   round(qtde_maxima,2) as qtde_maxima, 
                   round(qtde_uso,2) as qtde_uso, 
                   cod_pessoa_filial, 
                   cod_genuino, 
                   cod_fabricante
              from almoxarifado.mv$material_reposicao
             where cod_pessoa_filial = #arguments.cod_pessoa_filial#              
           <cfif Len(Trim("arguments.REPOSICAO"))>
		   	    and qtde_uso > 0
			    and estoque_atual < estoque_minimo_projetado
		   </cfif>
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna lista de quantidade de materiais por filial
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 28/02/2007 - criado
	--->	
	<cffunction name="get_lista_material_reposicao" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="material_id" required="no" default=""/>
		
   	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select material_id, material, unidade_estoque, estoque_atual, estoque_minimo_projetado, 
                   estoque_maximo_projetado, valor_unitario, ult_fornecedor, localizacao, estoque_atual_total, 
                   qtde_maxima, qtde_uso, cod_pessoa_filial, p.cliente as filial
              from almoxarifado.mv$material_reposicao f
              inner join kss.v$pessoa p 
                      on p.cod_pessoa = f.cod_pessoa_filial
             where 1=1
             <cfif Len(Trim(arguments.cod_pessoa_filial))>
			   and cod_pessoa_filial = #arguments.cod_pessoa_filial#   
             </cfif>
             <cfif Len(Trim(arguments.material_id))>
		       and material_id = #arguments.material_id#
             </cfif>
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Retorna Compras do material
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 01/06/2007 - criado
	--->	
	<cffunction name="get_material_compra" displayname="Retorna todos os tipos de dados" access="remote" returntype="query" output="true">
    	<cfargument name="material_id" required="no" default="" />
    	<cfargument name="cod_pessoa_filial" required="no" default="" />
    	<cfargument name="data_inicio" required="no" default="" />
    	<cfargument name="data_fim" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select  material_id, 
            		almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(#arguments.material_id#,' ') as material,
            		material as material_compra,
            	    data_lancamento,  
            	    round(sysdate-data_lancamento) num_dias, 
                    nvl(round(valor_unitario,2),0) as valor_unitario,  
                    nvl(round(valor_medio,2),0) as valor_medio,
                     case 
                      when '#arguments.data_inicio#' > data_lancamento then rownum-1 else 0 end marca_inicial,
                     case 
                      when '#arguments.data_fim#' < data_lancamento then rownum-1 else 100 end marca_final
            from (
            select  md.material_id, md.material, 
            		m.data_lancamento, m.valor_unitario, 
                   (select nvl(round(avg(to_number(ma.valor,'99999999D0099999999999','nls_numeric_characters=''.,''')),3),0)
                    from almoxarifado.v$movimentacao mo
                   inner join almoxarifado.v$movimentacao_atributo ma
                           on mo.lancamento_id = ma.lancamento_id
                   where ma.atributo_id = 23
                     and ma.material_id in (select a.material_id
                                              from table(almoxarifado.pkg_almoxarifado.fnc_material_filhos(#arguments.MATERIAL_ID#)) a)
                     and mo.operacao_tipo_id = 2
                     and mo.data_lancamento < m.data_lancamento
                     and ma.valor is not null) as valor_medio
              from almoxarifado.v$movimentacao_dados m
             inner join almoxarifado.v$material_dados md
                     on md.material_id = m.material_id
             where m.material_id in (select a.material_id
                                      from table(almoxarifado.pkg_almoxarifado.fnc_material_filhos(#arguments.MATERIAL_ID#)) a)
               and m.data_lancamento between sysdate - 180 and sysdate
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
               	and m.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
               </cfif>
               and m.operacao_tipo_id = 2   
            order by m.data_lancamento   ) 
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>    

	<!--- PROPSITO
	-- Retorna Compras do material
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 02/06/2007 - criado
	--->	
	<cffunction name="get_compras" displayname="Retorna todas as compras do perodo" access="remote" returntype="query" output="true">
    	<cfargument name="material_id" required="no" default="" />
    	<cfargument name="data_inicio" required="no" default="" />
    	<cfargument name="data_fim" required="no" default="" />
    	<cfargument name="cod_pessoa_filial" required="no" default="" />
    	<cfargument name="diferenca_inicio" required="no" default="" />
    	<cfargument name="diferenca_fim" required="no" default="" />
    	<cfargument name="diferenca" required="no" default="1" />
    	<cfargument name="compras" required="no" default="" />
    	<cfargument name="tipo_grupo" required="no" default="1" />
        <!---        
             Consulta divividade em materiais AGRUPADOS ou INDIVIDUAIS
               TIPO_GRUPO = 1 (Para Compras INDIVIDUAIS)
               TIPO_GRUPO = 2 (Para materias AGRUPADOS)
        --->
		<cfif arguments.TIPO_GRUPO eq 1> 
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
                select material_id, material, to_number(quantidade) as quantidade, to_number(compras) as compras, 
                       data_lancamento, to_number(valor_medio_atual) as valor_medio_atual, to_number(ultimo_valor) as ultimo_valor, 
                       to_number(penultimo_valor) as penultimo_valor, to_number(diferenca) as diferenca, to_number(percentual) as percentual, 
                       to_number(ultimo_valor_antes_compra) as ultimo_valor_antes_compra
                  from (
                        select material_id, material, nvl(quantidade,0) as quantidade,  
                               (select count(count(*))
                                  from almoxarifado.v$movimentacao m
                                 where m.material_id = a.material_id
                                   and m.operacao_tipo_id = 2
                                   <cfif Len(Trim(arguments.DATA_INICIO))>
                                   and trunc(m.data_lancamento) >= '#arguments.DATA_INICIO#'
                                   </cfif>
                                   <cfif Len(Trim(arguments.DATA_FIM))>
                                   and trunc(m.data_lancamento) <= '#arguments.DATA_FIM#'
                                   </cfif>
								   <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
									and m.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
								   </cfif>
                                 group by m.num_nota_id) as compras, 
                               data_lancamento, 
                               almoxarifado.to_material_estoque(a.material_id).valor_unitario as  valor_medio_atual,
                               nvl(ultimo_valor,0) as ultimo_valor, nvl(penultimo_valor,0) as penultimo_valor, 
                               penultimo_valor-ultimo_valor as diferenca,
                               round(((penultimo_valor/decode(ultimo_valor,0,1,ultimo_valor))-1)*100,2) as percentual,
                               nvl((select m2.valor_unitario
                                  from almoxarifado.v$movimentacao_dados m2
                                 where m2.operacao_tipo_id = 2
                                   and m2.material_id = a.material_id
                                   and m2.lancamento_id = (select max(m3.lancamento_id)
                                                             from almoxarifado.v$movimentacao m3
                                                            where m3.operacao_tipo_id = 2
                                                              and m3.material_id = m2.material_id
                                                              and m3.data_lancamento < a.data_lancamento)),0) as ultimo_valor_antes_compra
                          from (
                        select md.material_id, md.material, 
                               sum(m.quantidade) over(partition by m.material_id order by m.material_id) as quantidade,
                               min(m.data_lancamento) over(partition by m.material_id order by m.material_id, m.data_lancamento rows between unbounded preceding and unbounded following) as data_lancamento,
                               m.valor_unitario as ultimo_valor,
                               lag(m.valor_unitario) over(partition by m.material_id order by m.material_id, m.data_lancamento)as penultimo_valor,
                               case 
                                 when m.lancamento_id = last_value(m.lancamento_id) over(partition by m.material_id order by m.material_id, m.data_lancamento rows between unbounded preceding and unbounded following) then 1
                               else 0 end ultimo
                          from almoxarifado.v$movimentacao_dados m
                         inner join almoxarifado.v$material_dados md
                                 on md.material_id = m.material_id
                         where m.operacao_tipo_id = 2
                           <cfif Len(Trim(arguments.MATERIAL_ID))>
                            and m.material_id in (#arguments.MATERIAL_ID#)
                           </cfif>
                           <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
                            and m.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
                           </cfif>
                           <cfif Len(Trim(arguments.DATA_INICIO))>
                            and trunc(m.data_lancamento) >= '#arguments.DATA_INICIO#'
                           </cfif>
                           <cfif Len(Trim(arguments.DATA_FIM))>
                            and trunc(m.data_lancamento) <= '#arguments.DATA_FIM#'
                           </cfif>
                        order by m.material_id, m.data_lancamento) a
                        where ultimo = 1    
                           <cfif Len(Trim(arguments.DIFERENCA_INICIO))>
                               and (round(((penultimo_valor/ultimo_valor)-1)*100,2)) * #arguments.DIFERENCA#  >= #arguments.DIFERENCA_INICIO#
                           </cfif>
                           <cfif Len(Trim(arguments.DIFERENCA_FIM))>
                               and (round(((penultimo_valor/ultimo_valor)-1)*100,2)) * #arguments.DIFERENCA# <= #arguments.DIFERENCA_FIM#
                           </cfif>
                        )
                where 1=1
                <cfif Len(Trim(arguments.COMPRAS))>
                  and compras >= #arguments.COMPRAS#
                </cfif>
                order by material 
            </cfquery>
        <cfelse>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
                select material_id, material, nvl(quantidade,0) as quantidade, data_lancamento, nvl(ultimo_valor,0) as ultimo_valor, nvl(penultimo_valor,0) as penultimo_valor,
                       maior_valor, menor_valor, diferenca, percentual, compras, ultimo_valor_antes_compra
                  from table(almoxarifado.pkg_almoxarifado.fnc_compras(cursor(select material_id 
                                                               from almoxarifado.v$material_atributo 
                                                              where 1=1
                                                              	<cfif Len(Trim(arguments.MATERIAL_ID))>
                                                                   and material_id in (#arguments.MATERIAL_ID#)
                                                                </cfif>
                                                                and atributo_id=5),'#arguments.DATA_INICIO#', '#arguments.DATA_FIM#'<cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>,#arguments.COD_PESSOA_FILIAL#</cfif>)) a
                where 1=1
			   <cfif Len(Trim(arguments.DIFERENCA_INICIO))>
                   and percentual * #arguments.DIFERENCA#  >= #arguments.DIFERENCA_INICIO#
               </cfif>
               <cfif Len(Trim(arguments.DIFERENCA_FIM))>
                   and percentual * #arguments.DIFERENCA# <= #arguments.DIFERENCA_FIM#
               </cfif>
               <cfif Len(Trim(arguments.COMPRAS))>
                   and compras >= #arguments.COMPRAS#
               </cfif>
               order by material
			</cfquery>          
        </cfif>
	   <cfreturn qr_result>	   
	</cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Retorna todos os laudos existentes
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS 16/08/2007 - criado
	--->	
	<cffunction name="get_laudos" displayname="Retorna todos os laudos existentes" access="remote" returntype="query" output="true">
    	<cfargument name="laudo_id" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
        	select sl.laudo_id,
                   sl.descricao,
                   sl.user_insert,
                   sl.date_insert,
                   sl.user_update,
                   sl.date_update,
                   sl.site
              from almoxarifado.v$sucateamento_laudo sl
              where 1=1
              <cfif len(trim(arguments.laudo_id))>
              	and sl.laudo_id = #arguments.laudo_id#
              </cfif>
              order by sl.descricao
        </cfquery>
	   <cfreturn qr_result>	   
	</cffunction> 
    
    <!--- 
	-- PROPSITO
	-- Retorna todos os laudos existentes para um determinado material
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS 17/08/2007 - criado
	--->	
	<cffunction name="get_laudos_material" displayname="Retorna todos os laudos existentes para um determinado material" access="remote" returntype="query" output="true">
    	<cfargument name="material_id" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
              select sl.descricao,
              		 slm.material_id,
                     slm.laudo_id,
                     slm.date_insert,
                     slm.user_update,
                     slm.user_update,
                     slm.date_update
                from almoxarifado.v$sucateamento_laudo_material slm
          inner join almoxarifado.v$sucateamento_laudo sl 
                  on sl.laudo_id = slm.laudo_id
               where 1=1
              <cfif len(trim(arguments.material_id))>
                 and slm.material_id = #arguments.material_id#
              </cfif>
        </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>    

    <!--- 
	-- PROPSITO
	-- Retorna localizao geogrfica do equipamento
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 03/09/2007 - criado
	--->	
	<cffunction name="get_equipamento_posicao" displayname="Retorna localizao geogrfica do equipamento" access="remote" returntype="query" output="true">
    	<cfargument name="cod_equipamento" required="yes">
    	<cfargument name="data" required="no" default="">
    	<cfquery name="qr_placas" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select t.column_value as placa
              from table(kss.pkg_string.fnc_split(oper.pkg_veiculo.fnc_get_composicao(oper.pkg_veiculo.fnc_get_placa('#arguments.cod_equipamento#')),'|')) t 
             where t.column_value is not null
        </cfquery>
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select t.landmark as localizacao, t.latitude, t.longitude
              from oper.v$posicao t
             where t.placa in (#ListQualify(ValueList(qr_placas.PLACA,','),"'",',')#)
               and t.data = (select max(p2.data)
                               from oper.v$posicao p2
                              where p2.placa in (#ListQualify(ValueList(qr_placas.PLACA,','),"'",',')#)
                                and p2.data <= '#arguments.DATA#')
        </cfquery>
	   <cfreturn qr_result>
	</cffunction>    

    <!--- 
	-- PROPSITO
	-- Retorna solicitaes de materiais
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 02/10/2007 - criado
	--->	
	<cffunction name="get_solicitacao_material" displayname="Retorna solicitaes de materiais" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="no" default="">
    	<cfargument name="pendentes" 		 required="no" default="">
    	<cfargument name="material_id" 		 required="no" default="">
    	<cfargument name="data_inicio" 		 required="no" default="">
    	<cfargument name="data_fim" 		 required="no" default="">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
              select sm.solicitacao_id, sm.material_id, m.descricao_completa as material,
                     sm.cod_pessoa_filial, sm.cod_pessoa_responsavel, 
                     to_char(sm.data_solicitacao,'dd/mm/yyyy hh24:mi') as data_solicitacao, 
                     to_char(sm.data_atendimento,'dd/mm/yyyy hh24:mi') as data_atendimento, 
                     sm.quantidade, sm.urgencia, sm.observacao, sm.lancamento_id_mov, 
                     sm.data_cancelamento, sm.motivo_cancelamento, 
                     case
                       when sm.status = 0 then 'Solicitada'
                       when sm.status = 1 then 'Atendida'
                       when sm.status = 2 then 'Cancelada'                       
                     end status, 
                     sm.user_insert, p.cliente as responsavel
              from almoxarifado.v$solicitacao_material sm
             inner join almoxarifado.v$material m
                     on m.MATERIAL_ID = sm.material_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = sm.cod_pessoa_responsavel
             <cfif Len(Trim(arguments.MATERIAL_ID))>
                 inner join table(almoxarifado.pkg_almoxarifado.fnc_material_antecessores(#arguments.MATERIAL_ID#)) a
                         on a.material_id = sm.material_id			
             </cfif> 
             where 1=1
           <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
               and sm.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
           </cfif>
           <cfif Len(Trim(arguments.DATA_INICIO))>
               and trunc(sm.data_solicitacao) >= '#arguments.DATA_INICIO#'
           </cfif>
           <cfif Len(Trim(arguments.DATA_FIM))>
               and trunc(sm.data_solicitacao) <= '#arguments.DATA_FIM#'
           </cfif>
           <cfif Len(Trim(arguments.PENDENTES))>
               and sm.data_atendimento is null
               and sm.data_cancelamento is null
           </cfif>
           order by sm.data_solicitacao desc 
        </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>    

    <!--- 
	-- PROPSITO
	-- Retorna movimentaes apos uma data
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 03/09/2007 - criado
	--->	
	<cffunction name="get_movimentacao_filhos" displayname="Retorna movimentaes apos uma data" access="remote" returntype="query" output="true">
    	<cfargument name="material_id" required="yes">
    	<cfargument name="cod_pessoa_filial" required="no" default="">
    	<cfargument name="data_lancamento" required="no" default="">
    	<cfargument name="filial" required="no" default="">
    	<cfargument name="entrada_saida" required="no" default="">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select md.lancamento_id, md.operacao_tipo_id,
                   ot.descricao as operacao, to_char(md.data_lancamento,'dd/mm/yyyy hh24:mi') as data_lancamento,
                   md.quantidade, md.observacao, ma.descricao_completa as material
              from almoxarifado.v$movimentacao_dados md
             inner join table(almoxarifado.pkg_almoxarifado.fnc_material_filhos(#arguments.material_id#)) m
                     on m.material_id = md.material_id
             inner join almoxarifado.v$operacao_tipo ot
                     on ot.operacao_tipo_id = md.operacao_tipo_id				 
             inner join almoxarifado.v$material ma
                     on ma.material_id = md.material_id
            where 1=1
              <cfif Len(Trim(arguments.cod_pessoa_filial))>
	              and md.cod_pessoa_filial = #arguments.cod_pessoa_filial#
              </cfif>
              <cfif Len(Trim(arguments.data_lancamento))>
	              and md.data_lancamento >= to_date('#arguments.data_lancamento#','dd/mm/yyyy hh24:mi')
              </cfif>
              <cfif Len(Trim(arguments.entrada_saida))>
    	          and ot.d_c = #arguments.entrada_saida#
              </cfif>
            order by md.data_lancamento	
        </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>        

    <!--- 
	-- PROPSITO
	-- Retorna Dados dos equipamentos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 22/05/2009 - Modificado
	--->	
	<cffunction name="get_equipamento_movimentacao" displayname="Retorna Dados dos equipamentos" access="remote" returntype="query" output="true">
    	<cfargument name="material_id" required="no" default="">
    	<cfargument name="status_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select t.equipamento_id,
                   t.material_id,
                   t.material,
                   t.cod_equipamento,
                   t.status_id,
                   t.status,
                   t.placa,
                   t.num_ordem_servico,
                   t.cod_pessoa_filial,
                   t.filial
              from (select equipamento_id,
                           material_id,
                           material,
                           cod_equipamento,
                           status_id,
                           status,
                           case
                             when status_id = 1 then
                              (select e2.cod_equipamento
                                 from manutencao.v$equipamento_material em
                                inner join almoxarifado.v$equipamento e2 on e2.equipamento_id =
                                                                            em.equipamento_id
                                where em.equipamento_id_identificado = a.equipamento_id
                                  and em.ordem_servico_id_desmontagem is null)
                             else
                              ''
                           end placa,
                           case
                             when status_id = 1 then
                              (select os.num_ordem_servico
                                 from manutencao.v$equipamento_material em
                                inner join manutencao.v$ordem_servico os on os.ordem_servico_id =
                                                                            em.ordem_servico_id_montagem
                                where em.equipamento_id_identificado = a.equipamento_id
                                  and em.ordem_servico_id_desmontagem is null)
                             else
                              null
                           end num_ordem_servico,
                           case
                             when status_id not in (1, 2) then
                              (select m2.cod_pessoa_filial
                                 from almoxarifado.v$movimentacao m2
                                where m2.equipamento_id = a.equipamento_id
                                  and rownum = 1
                                  and m2.data_lancamento =
                                      (select max(m3.data_lancamento)
                                         from almoxarifado.v$movimentacao m3
                                        where m2.equipamento_id = m3.equipamento_id))
                             when status_id = 2 then
                              (select m2.cod_pessoa_filial
                                 from manutencao.v$equipamento_analise m2
                                where m2.equipamento_id = a.equipamento_id
                                  and rownum = 1
                                  and m2.data_analise is null)
                             else
                              null
                           end cod_pessoa_filial,
                           case
                             when status_id not in (1, 2) then
                              (select p.cliente
                                 from almoxarifado.v$movimentacao m2
                                inner join kss.v$pessoa p on p.cod_pessoa =
                                                             m2.cod_pessoa_filial
                                where m2.equipamento_id = a.equipamento_id
                                  and rownum = 1
                                  and m2.data_lancamento =
                                      (select max(m3.data_lancamento)
                                         from almoxarifado.v$movimentacao m3
                                        where m2.equipamento_id = m3.equipamento_id))
                             when status_id = 2 then
                              (select p.cliente
                                 from manutencao.v$equipamento_analise m2
                                inner join kss.v$pessoa p on p.cod_pessoa =
                                                             m2.cod_pessoa_filial
                                where m2.equipamento_id = a.equipamento_id
                                  and rownum = 1
                                  and m2.data_analise is null)
                             else
                              ''
                           end filial
                      from (select /*+ ORDERED*/
                             e.equipamento_id,
                             m.descricao_completa as material,
                             m.material_id,
                             e.cod_equipamento,
                             case
                               when exists (select 1
                                       from manutencao.v$equipamento_analise ea
                                      where ea.equipamento_id = e.equipamento_id
                                        and ea.data_analise is null) then
                                2
                               when exists (select 1
                                       from almoxarifado.v$movimentacao m
                                      inner join almoxarifado.v$movimentacao_atributo ma on ma.lancamento_id =
                                                                                            m.lancamento_id
                                                                                        and ma.atributo_id = 7
                                      inner join almoxarifado.v$transferencia t on t.lancamento_id_saida =
                                                                                   m.lancamento_id
                                      where ma.valor = e.cod_equipamento
                                        and t.lancamento_id_entrada is null) then
                                3
                               when e.data_inativacao is not null then
                                4
                               when not exists
                                (select 1
                                       from almoxarifado.v$movimentacao m
                                      where m.equipamento_id = e.equipamento_id) then
                                5
                               when exists
                                (select 1
                                   from manutencao.v$equipamento_material em
                                  where em.equipamento_id_identificado =
                                        e.equipamento_id
                                    and em.ordem_servico_id_desmontagem is null) then
                                1
                               else
                                0
                             end as status_id,
                             case
                               when exists (select 1
                                       from manutencao.v$equipamento_analise ea
                                      where ea.equipamento_id = e.equipamento_id
                                        and ea.data_analise is null) then
                                'Em Analise'
                               when exists (select 1
                                       from almoxarifado.v$movimentacao m
                                      inner join almoxarifado.v$transferencia t on t.lancamento_id_saida =
                                                                                   m.lancamento_id
                                      where m.equipamento_id = e.equipamento_id
                                        and t.lancamento_id_entrada is null) then
                                'Em Transfrencia'
                               when not exists
                                (select 1
                                       from almoxarifado.v$movimentacao m
                                      where m.equipamento_id = e.equipamento_id) then
                                'Sem movimentao'
                               when exists
                                (select 1
                                       from manutencao.v$equipamento_material em
                                      where em.equipamento_id_identificado =
                                            e.equipamento_id
                                        and em.ordem_servico_id_desmontagem is null) then
                                'Montado'
                               when e.data_inativacao is not null then
                                'Sucateado'
                               else
                                'Estoque'
                             end as status
                              from almoxarifado.v$equipamento e
                             inner join almoxarifado.v$material m on m.material_id =
                                                                     e.material_id) a
                     where 1 = 1
					<cfif Len(Trim(arguments.status_id))>
                       and a.status_id in (#arguments.status_id#)
						<cfif not listfind(arguments.status_id,1)>
                			and a.status_id <> 1
                		</cfif>
            		</cfif>
            		<cfif Len(Trim(arguments.material_id))>
                       and a.material_id in (#arguments.material_id#)
            		</cfif>
             ) t
             where 1 = 1		
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
               and t.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
            </cfif>
        </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>        
    
    <!--- 
	-- PROPSITO 
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- wagnerlv 16/01/2008
	--->
	<cffunction name="get_equipamentos_sucata" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="sem_modelo" required="no" default="0">
        <cfargument name="equipamento" required="no" default="">
        <cfargument name="analisados" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select equipamento_id, cod_equipamento, md.material
                  from almoxarifado.v$equipamento e
                 inner join almoxarifado.v$material_dados md on md.material_id =
                                                                e.material_id
                  left join almoxarifado.v$equip_proprietario_atual ep on ep.equipamento_id =
                                                                          e.equipamento_id
                  left join oper.v$pessoa prop on prop.cod_pessoa =
                                                  ep.cod_pessoa_proprietario
                  left join almoxarifado.v$equipamento_localizacao el on el.equipamento_id =
                                                                         e.equipamento_id
                  left join oper.v$pessoa f on f.cod_pessoa = el.cod_pessoa_filial
                  left join almoxarifado.v$movimentacao_dados mov on mov.EQUIPAMENTO_ID =
                                                                     e.EQUIPAMENTO_ID
                 where 1=1
 			  <cfif Len(Trim(arguments.equipamento_id))>
				and m.equipamento_id = #arguments.equipamento_id#
			  </cfif>
 			  <cfif Len(Trim(arguments.cod_equipamento))>
				and m.cod_equipamento = '#arguments.cod_equipamento#'
			  </cfif>			 
              <cfif len(trim(arguments.equipamento))>
               and upper(md.material) like upper('%#arguments.equipamento#%')
              </cfif>   
              and el.LOCALIZACAO_ID =
               (select max(el2.LOCALIZACAO_ID)
                  from almoxarifado.v$equipamento_localizacao el2
                 where el2.equipamento_id = el.equipamento_id)
           and mov.DATA_LANCAMENTO =
               (select max(mov2.DATA_LANCAMENTO)
                  from almoxarifado.v$movimentacao mov2
                 where mov2.EQUIPAMENTO_ID = mov.EQUIPAMENTO_ID and mov.operacao_tipo_id = 7)           
 			  order by md.material, cod_equipamento 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- wagnerlv 16/01/2008
	--->
	<cffunction name="get_equipamentos_proprietario_atual" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_pessoa_proprietario, 
            	   to_char(data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio
              from almoxarifado.v$equip_proprietario_atual e
             where 1=1
 			  <cfif Len(Trim(arguments.equipamento_id))>
				and e.equipamento_id = #arguments.equipamento_id#
			  </cfif>
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO
	-- Busca oficinas cadastradas
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/04/2007 - criado
	--->	
	<cffunction name="get_oficinas" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="interna" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select o.cod_pessoa, o.cnpj_cpf, o.identificador, o.inscricao_estadual, 
				   o.razao_social, o.cliente 
			  from almoxarifado.v$oficinas o
			 where 1=1
			 <cfif Len(Trim(arguments.COD_PESSOA))>
			   and cod_pessoa = #arguments.COD_PESSOA#
			 </cfif>
			 <cfif Len(Trim(arguments.INTERNA))>
			   and interna= #arguments.INTERNA#
			 </cfif>
			 order by cliente
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as prioridades para as solicitaes de compras
    -- ANDERSON 16/09/2009 - CRIADO
    --->		
    <cffunction name="get_solicitacao_prioridade" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select sp.prioridade_id
                 , sp.descricao
                 , sp.numero_horas
              from compras.v$solicitacao_prioridade sp
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as reas para as solicitaes de compras
    -- ANDERSON 16/09/2009 - CRIADO
    --->		
    <cffunction name="get_area" access="remote" returntype="query" output="true">
	    <cfargument name="cod_pessoa_fornecedor" required="no" default="">
        <cfargument name="situacao" required="no" default="1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.area_id
                 , a.descricao
              from compras.v$area a
             where visivel = 1
               and situacao = #arguments.situacao#
			<cfif len(trim(arguments.cod_pessoa_fornecedor))>
               and (
                    exists (select 0
                              from compras.v$fornecedor_area fa
                             where fa.area_id = a.area_id
                               and fa.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                            )                
                    or not exists (select 0
                                     from compras.v$fornecedor_area fa
                                    where fa.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                                  ) 
                   )               
			</cfif>
             order by a.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as solicitaes de compras
    -- ANDERSON 16/09/2009 - CRIADO
    --->		
    <cffunction name="get_solicitacao_compra" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="num_controle" required="no" default="">
        <cfargument name="titulo" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.solicitacao_id
                 , s.num_controle
                 , s.titulo
                 , s.cod_organograma
                 , s.cod_pessoa_emissao
                 , oper.pkg_global.fnc_get_cod_funcionario(s.cod_pessoa_emissao) as cod_funcionario
                 , kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as nome_funcionario
                 , to_char(s.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , s.equipamento_id
                 , (select e.cod_equipamento
                      from almoxarifado.v$equipamento e
                     where e.equipamento_id = s.equipamento_id) as cod_equipamento
                 , s.equipamento_custo_id
                 , (select e.cod_equipamento
                      from almoxarifado.v$equipamento e
                     where e.equipamento_id = s.equipamento_custo_id) as cod_equipamento_custo
                 , (select ma.material
                      from almoxarifado.v$equipamento e
                 	 inner join almoxarifado.v$material_dados ma
                        on ma.material_id = e.material_id
                     where e.equipamento_id = s.equipamento_custo_id) as material_equipamento_custo
                 , (select ma.material
                      from almoxarifado.v$equipamento e
                     inner join almoxarifado.v$material_dados ma
                             on ma.material_id = e.material_id
                     where e.equipamento_id = s.equipamento_id) as equipamento
                 , s.observacao
                 , s.situacao_id
                 , (select cg.rv_abbreviation
                      from compras.v$cg_ref_codes cg
                     where cg.rv_low_value = s.situacao_id
                       and cg.rv_domain = 'SOLICITACAO SITUACAO') as situacao
                 , s.prioridade_id
                 , (select sp.descricao
                      from compras.v$solicitacao_prioridade sp
                     where sp.prioridade_id = s.prioridade_id) as prioridade
                 , s.area_id
                 , (select a.descricao
                      from compras.v$area a
                     where a.area_id = s.area_id) as area
                 , s.log_alteracao
                 , s.cod_pessoa_fornecedor
                 , (select p.cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = s.cod_pessoa_fornecedor) as cnpj_fornecedor
                 , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = s.cod_pessoa_fornecedor) as fornecedor
                 , (select o.cod_organizacional
                      from kss.v$organizacional o
                     where o.organizacional_id = s.organizacional_id) as cod_organizacional
                 ,(select o.organizacional_id
                     from kss.v$organizacional o
                    where o.organizacional_id = s.organizacional_id) as organizacional_id
              from compras.v$solicitacao s
             inner join kss.v$organograma o
                on o.cod_organograma = s.cod_organograma
             where 1 = 1
			<cfif Len(Trim(arguments.solicitacao_id))>
               and s.solicitacao_id = #arguments.solicitacao_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and o.cod_pessoa = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.num_controle))>
               and s.num_controle = #arguments.num_controle#
            </cfif>
            <cfif Len(Trim(arguments.titulo))>
               and upper(s.titulo) like upper('#arguments.titulo#%')
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(s.data_emissao) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(s.data_emissao) <= '#arguments.data_fim#'
            </cfif>
             order by s.num_controle asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca os materiais de um solicitao de compra
    -- ANDERSON 16/09/2009 - CRIADO
    --->		
    <cffunction name="get_solicitacao_compra_material" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sm.controle_id
                 , sm.solicitacao_id
                 , sm.tipo_compra_id
                 , sm.descricao
                 , sm.material_id
                 , sm.cod_unidade
                 , sm.quantidade
                 , sm.compra_liberada
                 , sm.valor_sugerido
                 , (select mp.produto_id
                      from almoxarifado.v$material_produto mp
                     where mp.material_id = sm.material_id) as produto_id
                 , (select m.descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id) as descricao_completa
                 , (select m.ativo
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id) as ativo  
              from compras.v$solicitacao_material sm
             where sm.solicitacao_id = #arguments.solicitacao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Busca as atividades de um solicitao de compra
    -- ANDERSON 16/09/2009 - CRIADO
    --->		
    <cffunction name="get_solicitacao_compra_atividade" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sa.controle_id
                 , sa.solicitacao_id
                 , sa.tipo_compra_id
                 , sa.descricao
                 , sa.atividade_id
                 , sa.quantidade
                 , sa.compra_liberada
                 , sa.valor_sugerido
                 , (select ap.produto_id
                      from manutencao.v$atividade_produto ap
                     where ap.atividade_id = sa.atividade_id) as produto_id
                 , (select a.titulo
                      from manutencao.v$atividade a
                     where a.atividade_id = sa.atividade_id) as atividade_descricao
              from compras.v$solicitacao_atividade sa
             where sa.solicitacao_id = #arguments.solicitacao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
	-- PROPSITO
	-- Lista NCM de produto
	-- NOTAS EXPLICATIVAS
	--  
	-- 15/12/2005 - criado
	--->	
	<cffunction name="get_produto_ncm" access="remote" returntype="query" output="true">
		<cfargument name="cod_ncm" required="no" default="" />
		<cfargument name="descricao_ncm" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select cod_ncm, descricao_ncm 
			  from fiscal.v$produto_ncm
		    where 1=1
              <cfif Len(Trim(arguments.cod_ncm))>
                and cod_ncm = '#arguments.cod_ncm#'
  			    and rownum = 1
              </cfif>
              <cfif Len(Trim(arguments.descricao_ncm))>
                and lower(descricao_ncm) like lower('%#arguments.descricao_ncm#%')
              </cfif>
              order by cod_ncm
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os pedidos de compra abertos de um fornecedor
    -- ANDERSON 16/11/2009 - CRIADO
    --->		
    <cffunction name="get_pedidos_abertos_fornecedor" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_fornecedor" required="yes">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="nf_fornecedor" required="no" default="0">
        <cfargument name="os_externa" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pedido_id
                 , p.num_pedido
                 , to_char(p.data_pedido, 'dd/mm/yyyy') as data_pedido
                 , (select cg.rv_abbreviation
                      from compras.v$cg_ref_codes cg
                     where cg.rv_domain = 'PEDIDO SITUACAO'
                       and cg.rv_low_value = p.situacao_id
                   ) as situacao
                 , p.valor_material
                 , p.valor_atividade
                 , p.valor_total_pedido
                 , pi.pedido_item_id
                 , ct.cotacao_id
                 , ct.atividade_id
                 , '-1' as atividade_posicao_id
                 , 'nica' as atividade_posicao
                 , ct.material_id
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(ct.material_id, 9) as material_cod_genuino
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(ct.material_id, 10) as material_cod_fabricante
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(ct.material_id, 11) as material_cod_paralelo
                 , m.identificado as material_identificado
                 , m.unidade_estoque as material_unidade_estoque
                 , '-1' as material_posicao_id
                 , 'nica' as material_posicao
                 , sp.num_controle as num_solicitacao_compra
                 , sp.solicitante
                 , sp.equipamento
                 , sp.situacao_id
                 , nvl(a.titulo, m.descricao_completa) as descricao_item
                 , nvl(
                       (select p.categoria_id
                          from manutencao.v$atividade_produto ap
                         inner join fiscal.v$produto p
                                 on p.produto_id = ap.produto_id
                         where ap.atividade_id = ct.atividade_id
                       ),
                       (select p.categoria_id
                          from almoxarifado.v$material_produto mp
                         inner join fiscal.v$produto p
                                 on p.produto_id = mp.produto_id
                         where mp.material_id = ct.material_id
                       )
                      ) as categoria_id
                 , ct.quantidade
                 , (ct.quantidade
                    - (select nvl(sum(nfpi.quantidade), 0)
                         from fiscal.v$nf_terceiro_pedido_item nfpi
                        where nfpi.pedido_item_id = pi.pedido_item_id
                      )
                   ) as quantidade_disponivel
                 , ct.valor_unitario
                 , ct.valor_negociado
			<cfif Len(Trim(arguments.ordem_servico_id))>
                 , (select count(*)
                      from manutencao.v$os_pedido osp
                     where osp.pedido_id = p.pedido_id
                       and osp.ordem_servico_id = #arguments.ordem_servico_id#
                   ) as pedido_utilizado_os
                 , nvl(
                       (select osp.valor_utilizado
                          from manutencao.v$os_pedido osp
                         where osp.pedido_id = p.pedido_id
                           and osp.ordem_servico_id = #arguments.ordem_servico_id#
                       ), 0
                      ) as pedido_valor_utilizado_os
                 , (select count(*)
                      from manutencao.v$os_pedido_item ospi
                     where ospi.pedido_item_id = pi.pedido_item_id
                       and ospi.ordem_servico_id = #arguments.ordem_servico_id#
                   ) as pedido_item_utilizado_os
            <cfelse>
                 , 0 as pedido_utilizado_os
                 , 0 as pedido_valor_utilizado_os
                 , 0 as pedido_item_utilizado_os
            </cfif>
              from compras.v$pedido p
             inner join compras.v$pedido_item pi
                     on pi.pedido_id = p.pedido_id
             inner join compras.v$cotacao ct
                     on ct.cotacao_id = pi.cotacao_id
             inner join compras.v$solicitacao_pedido sp
                     on sp.pedido_id = p.pedido_id
              left join manutencao.v$atividade a
                     on a.atividade_id = ct.atividade_id
              left join almoxarifado.v$material m
                     on m.material_id = ct.material_id
             where ct.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
            <cfif Len(Trim(arguments.equipamento_id))>
               and compras.pkg_compras.fnc_equipamento_pert_cotacao(ct.cotacao_id, #arguments.equipamento_id#) = 1
            </cfif>
			<cfif arguments.nf_fornecedor eq 1>
               and (select nvl(sum(nfpi.quantidade), 0)
                      from fiscal.v$nf_terceiro_pedido_item nfpi
                     where nfpi.pedido_item_id = pi.pedido_item_id
                   ) < ct.quantidade
			</cfif>
            <cfif arguments.os_externa eq 1>
               and pi.pedido_item_id not in (select ospi.pedido_item_id
                                   			   from manutencao.v$os_pedido_item ospi
											<cfif Len(Trim(arguments.ordem_servico_id))>
                                              where ospi.ordem_servico_id <> #arguments.ordem_servico_id#
                                            </cfif>

                                            )
			</cfif>
             order by p.num_pedido
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna os pedidos de compra em aberto que possuem quantidade de itens disponvel para executar uma movimentao de entrada
    -- GUSTAVOC 19/11/2010 - CRIADO
    --->		
    <cffunction name="get_pedidos_mov_entrada" access="remote" returntype="query" output="true">
        <cfargument name="num_pedido" required="yes">
        <cfargument name="localizacao" required="no">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
select p.pedido_id, rowid
                 , p.valor_material
                 , p.valor_atividade
                 , p.valor_total_pedido
                 , pi.pedido_item_id
                 , m.material_id
                 , nvl(a.titulo, m.descricao_completa) as descricao_item
                 , ct.quantidade
                 , (ct.quantidade
                    - (select nvl(sum(mvpi.quantidade), 0)
                         from almoxarifado.v$movimentacao mvpi
                        where mvpi.pedido_item_id = pi.pedido_item_id
                      )
                   ) as quantidade_disponivel
                 , to_number(ct.quantidade
                    - (select nvl(sum(mvpi.quantidade), 0)
                         from almoxarifado.v$movimentacao mvpi
                        where mvpi.pedido_item_id = pi.pedido_item_id
                      )) as quantidade_disp
                 , nullif(
                      least
                      (
                         (select nvl(min(s.situacao_id), 999)
                            from compras.v$pedido pe
                           inner join compras.v$pedido_item pit
                                   on pit.pedido_id = pe.pedido_id
                           inner join compras.v$cotacao c
                                   on c.cotacao_id = pit.cotacao_id
                           inner join compras.v$orcamento_atividade oa
                                   on oa.orcamento_atividade_id = c.orcamento_atividade_id
                           inner join compras.v$orcamento_atividade_solic oas
                                   on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                           inner join compras.v$solicitacao_atividade sa
                                   on sa.controle_id = oas.solicitacao_atividade_id
                           inner join compras.v$solicitacao s
                                   on s.solicitacao_id = sa.solicitacao_id
                           where pe.pedido_id = p.pedido_id
                         ),
                         (select nvl(min(s.situacao_id), 999)
                            from compras.v$pedido pe
                           inner join compras.v$pedido_item pit
                                   on pit.pedido_id = pe.pedido_id
                           inner join compras.v$cotacao c
                                   on c.cotacao_id = pit.cotacao_id
                           inner join compras.v$orcamento_material om
                                   on om.orcamento_material_id = c.orcamento_material_id
                           inner join compras.v$orcamento_material_solic oms
                                   on oms.orcamento_material_id = om.orcamento_material_id
                           inner join compras.v$solicitacao_material sm
                                   on sm.controle_id = oms.solicitacao_material_id
                           inner join compras.v$solicitacao s
                                   on s.solicitacao_id = sm.solicitacao_id
                           where pe.pedido_id = p.pedido_id
                         )
                      ), 999) as situacao_id
                   , p.rowid
                  , (select md.localizacao
                       from almoxarifado.v$movimentacao_dados md
                      where md.material_id = m.material_id
                        and md.lancamento_id = (select max(mo.lancamento_id)
                                                  from almoxarifado.v$movimentacao_dados mo
                                                 where mo.material_id = md.material_id
                                                   and mo.localizacao is not null
                                               )
                    ) as localizacao
              from compras.v$pedido p
              
             inner join compras.v$pedido_item pi
                     on pi.pedido_id = p.pedido_id
             inner join compras.v$cotacao ct
                     on ct.cotacao_id = pi.cotacao_id
              left join manutencao.v$atividade a
                     on a.atividade_id = ct.atividade_id
             inner join almoxarifado.v$material m
                     on m.material_id = ct.material_id
             where (p.num_pedido =  #arguments.num_pedido#
                    and 
                   (select nvl(sum(mvpi.quantidade), 0)
                      from almoxarifado.v$movimentacao mvpi
                     where mvpi.pedido_item_id = pi.pedido_item_id
                   ) < ct.quantidade
                   )
             order by p.num_pedido
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- consulta pedidos
    -- GUSTAVOC 19/11/2010 - CRIADO
    --->		
    <cffunction name="get_consulta_pedido" access="remote" returntype="query" output="true">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="razao_social" required="no" default="">
        <cfargument name="cpf_cnpj" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pe.pedido_id, pe.num_pedido, pe.data_pedido, pe.valor_total_pedido, 
                   (select c.rv_abbreviation
                      from compras.v$cg_ref_codes c
                     where c.rv_low_value = pe.situacao_id
                       and c.rv_domain = 'PEDIDO SITUACAO') as situacao,        
                   p.cnpj_cpf, p.razao_social        
              from compras.v$pedido pe
             inner join kss.v$pessoa p
                     on p.cod_pessoa = pe.cod_pessoa_fornecedor  
            
			<cfif Len(Trim(arguments.cpf_cnpj))>
             where p.cnpj_cpf like '#arguments.cpf_cnpj#%'
            </cfif>
            
            <cfif Len(Trim(arguments.num_pedido))>
             where to_char(pe.num_pedido) like '%#arguments.num_pedido#'
            </cfif>
            
            <cfif Len(Trim(arguments.razao_social))>
             where lower(p.razao_social) like lower('#arguments.razao_social#%')
            </cfif>
             
             order by pe.num_pedido
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
    <!--- 
    -- PROPSITO 
    -- gera parcelas de acordo com a forma de vencimento
    -- WAGNER 24/04/2012 - CRIADO
    --->		
    <cffunction name="get_simulacao_parcelas" access="remote" returntype="query" output="true">
        <cfargument name="DATA_PRIM_VENCTO" required="yes">
        <cfargument name="VALOR" required="yes">
        <cfargument name="QTDE_PARCELAS" required="yes" >
        <cfargument name="TIPO_VENCIMENTO" required="no" default="vencimento">
		<cfargument name="QTDE_DIAS_VENCTO" required="no" default="">
        <cftransaction action='begin'>
        	<cfif arguments.TIPO_VENCIMENTO eq 'vencimento' >
                <cfstoredproc procedure='compras.pkg_compras.prc_simular_parcelas_mes' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PRIM_VENCTO'  value='#arguments.DATA_PRIM_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PARCELAS'  value='#arguments.QTDE_PARCELAS#'  null='#iif(len(trim(arguments.QTDE_PARCELAS)), de('no'), de('yes'))#'>
                </cfstoredproc>
            <cfelse>
            	<cfstoredproc procedure='compras.pkg_compras.prc_simular_parcelas_dias' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PRIM_VENCTO'  value='#arguments.DATA_PRIM_VENCTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_DIAS_VENCTO'  value='#arguments.QTDE_DIAS_VENCTO#'  null='#iif(len(trim(arguments.QTDE_DIAS_VENCTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QTDE_PARCELAS'  value='#arguments.QTDE_PARCELAS#'  null='#iif(len(trim(arguments.QTDE_PARCELAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
				</cfstoredproc>
            </cfif>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Parcelas geradas com sucesso!')>
            
            <cfscript>
				qrParcelas = this.get_simulacao_parcelas_temp();
			</cfscript>
            
        </cftransaction>
        <cfreturn qrParcelas>
    </cffunction>
    
    
    <!--- 
    -- PROPSITO 
    -- consulta pedidos
    -- WAGNER 24/04/2012 - CRIADO
    --->		
    <cffunction name="get_simulacao_parcelas_temp" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select valor
                     , num_parcela
                     , dia_vencimento
                     , to_char(data_vencto,'dd/mm/yyyy') as data_vencto
                     , to_char(data_vencto,'dd') as dia_vencto
                  from compras.parcelamento_temp
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    
</cfcomponent>