<cfcomponent displayname="Consultas de Agregados" extends="_transportes.funcoes.cfc_init">
	<cfscript>
	/**
	 * @descritivo	: Recupera primeiro dia do ms
	 * @parametro	: mes  : string. ( Requerido ) 
					  ano  : string.   ( Requerido )
	 * @retorno		: data
	 * @autor       :Jefferson Petilo( jefferson@kmm.com.br ) 
	 * @verso		: 1, 09  de Julho de 2003
	 */					
	function primeiro_dia_mes( mes , ano )
	{
	  if ( ArrayLen( Arguments ) gt 1 ) 
		   ano = Arguments[ 2 ];
		   
	  return ( DateFormat(DateAdd('d', -DateFormat( ultimo_dia_mes( mes , ano ) , 'dd'), DateAdd('m', 1, CreateDate( ano , mes, 1 ) ) ), 'dd/mm/yyyy') );
	}
	/**
	 * @descritivo	: Recupera ultimo dia do ms
	 * @parametro	: mes  : string. ( Requerido )
					  ano  : string.   ( Requerido )
	 * @retorno		: data
	 * @autor       :Jefferson Petilo( jefferson@kmm.com.br ) 
	 * @verso		: 1, 09  de Julho de 2003
	 */					
	function ultimo_dia_mes( mes , ano ) 
	{
	  if ( ArrayLen( Arguments ) gt 1)
			ano = Arguments[ 2 ];
			
	  return ( DateFormat(DateAdd('d', -1, DateAdd('m', 1, CreateDate(ano, mes, 1 ) ) ),'dd/mm/yyyy') );
	}
	</cfscript>

	<!--- 
	-- PROPSITO 
	-- Retorna TRUE caso o pessoa passada por um usuario e FALSE caso contrrio
	-- NOTAS EXPLICATIVAS
	-- GUTO 13/01/2006
	--->		
	<cffunction name="isAgregado" access="remote" description="Retorna TRUE caso o pessoa passada por um usuario e FALSE caso contrrio" returntype="boolean" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.cod_pessoa
			  from oper.v$agregado a
			 where a.cod_pessoa = #arguments.COD_PESSOA#
		</cfquery>
		<cfif qr_result.RecordCount gt 0>
			<cfreturn true />
		<cfelse>
			<cfreturn false />
		</cfif>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Seleciona parmetros dos agregados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  28/12/2005
	--->		
	<cffunction name="getParametros" access="remote" description="Carrega todos os parmetros ativos." returntype="query" output="true">
		<cfquery name="qrParametros" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ap.id, ap.descricao, decode(ap.tipo_valor_id,3,decode(ap.valor,1,'Sim','No'),to_char(ap.valor,'999,990.00')) as valor, ap.ativo
			  from oper.v$agregado_gestao_padrao ap   
			 where ap.id <> 20
		   union
		   select ap.id, ap.descricao, decode(ap.valor,0,'Quinzenal','Semanal') as valor, ap.ativo
			 from oper.v$agregado_gestao_padrao ap   
			where id = 20
			order by 2	
		</cfquery>
		<cfreturn qrParametros />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Seleciona somente os agregados ativos e que possuam veculos ( caminhes )
	no so listados nessa consulta as carretas nem os veculos em manuteno
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_agregados" returntype="query" displayname="Consulta Agregados" access="remote"  output="true">
		<cfargument name="cod_pessoa" required="no" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.cod_pessoa, a.usuario, a.nome_fantasia, cc.cod_conta
			  from oper.v$agregado a
			 left join oper.v$ccorrente cc
			         on cc.cod_pessoa = a.cod_pessoa
					and cc.modalidade_id in (1,2,6)
					and cc.ativo = 1
			 where a.situacao_id = 1
			<cfif IsDefined('arguments.cod_pessoa') and IsNumeric( arguments.cod_pessoa )>
			   and a.cod_pessoa = #arguments.cod_pessoa#
			</cfif>
			   and exists( select 'x' -- seleciona somente os agregados que tem veculos ( trao )
							 from oper.v$veiculo_proprietario vp
							 inner join oper.v$veiculo v 
									 on vp.placa = v.placa
									and v.situacao_id = 1
									and vp.data_fim is null
							 inner join oper.v$veiculo_modelo vm
									 on vm.marca_id = v.marca_id
									and vm.modelo_id = v.modelo_id
							 inner join oper.v$veiculo_tracao  vt
									 on vt.tipo_id = vm.tipo_id 
							 where vp.cod_pessoa = a.cod_pessoa ) 
			 order by a.nome_fantasia	
		</cfquery>
	  <cfreturn qr_result />								
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Categorias de despesas 
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2007
	--->		
	<cffunction name="get_agregado_contabilizacao" returntype="query" displayname="Consulta Agregados" access="remote"  output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select categoria_id,titulo,historico,cred_tipo
			  from oper.v$agregado_contabilizacao t
			 where categoria_id in (225,226)
		</cfquery>
	  <cfreturn qr_result />								
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Seleciona somente veculos de trao 
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_veiculos" displayname="Seleciona veculos do agregado" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" />
		<cfargument name="data" required="no" />
        <cfargument name="data_proprietario" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select vp.placa
                 , vp.cod_pessoa
                 , a.nome_fantasia
                 , to_char(greatest(vp.DATA_INICIO<cfif len(trim(arguments.data_proprietario))>,'#arguments.data_proprietario#'</cfif>), 'dd/mm/yyyy') as agr_data_inicio
                 , to_char(least(nvl(vp.DATA_FIM, <cfif len(trim(arguments.data_proprietario))>last_day('#arguments.data_proprietario#')<cfelse>sysdate</cfif>) <cfif len(trim(arguments.data_proprietario))>, last_day('#arguments.data_proprietario#')</cfif>), 'dd/mm/yyyy') as agr_data_fim
			  from oper.v$agregado a
			  inner join oper.v$veiculo_proprietario vp
					  on vp.cod_pessoa = a.cod_pessoa 
                 <cfif len(trim(arguments.data_proprietario))>
                 	and trunc(vp.data_inicio, 'month') <= '#arguments.data_proprietario#'
                    and (vp.DATA_FIM is null
                         or (trunc(nvl(vp.data_fim, last_day('#arguments.data_proprietario#')+1)-1/86400) <= last_day('#arguments.data_proprietario#')
                             and vp.DATA_FIM > '#arguments.data_proprietario#'
                             and vp.DATA_FIM is not null)
                        )
                    
                 </cfif>
			  inner join oper.v$veiculo v 
					  on vp.placa = v.placa
			        <cfif not IsDefined('arguments.data')>
					   and v.situacao_id = 1
                    </cfif>
                    <cfif not len(trim(arguments.data_proprietario))>
					   and vp.data_fim is null
                    </cfif>
			  inner join oper.v$veiculo_modelo vm
					  on vm.marca_id = v.marca_id
					 and vm.modelo_id = v.modelo_id
			  inner join oper.v$veiculo_tracao  vt
					  on vt.tipo_id = vm.tipo_id 
			where a.situacao_id = 1
			<cfif IsDefined('arguments.cod_pessoa') and IsNumeric( arguments.cod_pessoa )>
			  and a.cod_pessoa = #val( arguments.cod_pessoa )#
			</cfif>
			<cfif IsDefined('arguments.data')>
			  and exists (select 'x'
				            from oper.v$romaneio_hist_veiculo rhv
				           where rhv.placa_controle = v.placa
			 			     and rhv.data_termino between '#arguments.data#' and last_day('#arguments.data#'))
			</cfif>
			order by a.nome_fantasia, vp.placa
		</cfquery>
		<cfreturn qr_result />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca saldo anterior da conta corrente
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_saldo_anterior" access="remote" description="Busca saldo anterior da conta corrente" returntype="query" output="true">
		<cfargument name="cod_conta" required="yes" />
		<cfargument name="data" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select 0 as cod_documento, 'Saldo Anterior' as historico, to_date('#arguments.DATA# 00:00','dd/mm/yyyy hh24:mi') as data_vencto, 
					 oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(#arguments.COD_CONTA#, to_date('#arguments.DATA# 00:00','dd/mm/yyyy hh24:mi')) as valor
				from dual
		</cfquery>
		<cfreturn qr_result />
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca lancamentos na conta corrente
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_lancamentos_conta_agregado" access="remote" description="Busca lancamentos na conta corrente" returntype="query" output="true">
		<cfargument name="cod_conta" required="yes"/>
		<cfargument name="data_inicio" required="yes" />
		<cfargument name="data_fim" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cl.num_documento, cl.historico, cl.data_vencto, cl.valor_lancamento, cl.deb_cred,
            	   (select os.ordem_servico_id
                      from manutencao.v$ordem_servico os
                     where os.num_lancamento = cl.num_lancamento) as ordem_servico_id
			  from oper.v$ccorrente_lancamento cl
			  where cl.cod_conta = #arguments.COD_CONTA#
				 and cl.data_vencto between to_date('#arguments.DATA_INICIO# 00:00','dd/mm/yyyy hh24:mi') and to_date('#arguments.DATA_FIM# 23:59','dd/mm/yyyy hh24:mi')
			 order by data_vencto
		</cfquery>
		<cfreturn qr_result />
	</cffunction>		

	<!--- 
	-- PROPSITO 
	-- Busca viagens do veculo no perodo
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_viagens" access="remote" description="Busca lancamentos na conta corrente" returntype="query" output="true">
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="cod_pessoa" required="no">
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED use_hash(VAT RHV)  */ vat.cod_pessoa
                  ,r.num_romaneio as viagem_id
                  , to_char(rhv.data_inicio,'dd/mm') as data_inicio
                  , to_char(rhv.data_termino,'dd/mm') as data_fim
                  , initcap(r.carregamento) as origem
                  , initcap(r.destino) destino
                  , initcap(substr(r.cliente,1,12)) as cliente
                  , max(oper.pkg_operacional.fnc_converte_peso(r.peso_total,'kg',r.cod_unidade)) as peso
                  , decode( nvl( r.frete_liquido , 0 ), 0 , 0, round( nvl( r.frete_liquido , 0 )  /  oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'kg',  r.cod_unidade),  2 )) as frete_valor_unitario
                  , nvl(oper.pkg_agregado.fnc_valor_total_frete(r.num_romaneio),0) as frete_total
                  , (((oper.pkg_agregado.fnc_valor_total_frete(r.num_romaneio) + nvl(oper.pkg_operacional.fnc_romaneio_dado(r.num_romaneio).total_icms,0)) - oper.pkg_operacional.fnc_valor_entregue(r.num_romaneio))) diferenca
                  , decode(r.situacao_id,2,'OK','?') situacao,substr(rhv.placa_controle,1,3)||'-'||substr(rhv.placa_controle,4) as placa_tracao
                  , rhv.placa_controle as placa
                  , decode(l.frete_proprio,1,1,0) as tipo_frete
                  , decode(decode(l.frete_proprio,1,1,0), 0, (oper.pkg_agregado.fnc_valor_total_frete(r.num_romaneio) * oper.pkg_agregado.fnc_consulta_percentual(2,<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, vat.cod_pessoa, 1))
                  , (oper.pkg_agregado.fnc_valor_total_frete(r.num_romaneio) * oper.pkg_agregado.fnc_consulta_percentual(1,<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, vat.cod_pessoa, 1))) frete_final
                  , min(r.situacao_id) as situacao_id
				from oper.v$veiculo_agregado_tracao vat
			 inner join oper.v$romaneio_hist_veiculo rhv
						 on rhv.placa_controle = vat.placa
						and nvl(rhv.data_termino,sysdate) = (select max(nvl(rhv2.data_termino,sysdate)) 
																				   from oper.v$romaneio_hist_veiculo rhv2
																					where rhv.num_romaneio = rhv2.num_romaneio)
						and rhv.placa_controle in( #Ucase(ListQualify( arguments.placa ,"'",",","char") ) # )
						and rhv.data_termino between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio# 00:00:00'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
			 inner join oper.v$romaneio r 
					 on r.num_romaneio = rhv.num_romaneio
			 inner join oper.v$romaneio_item it
					 on r.num_romaneio = it.num_romaneio
                     <cfif len(trim(arguments.cod_pessoa)) >
                     	and vat.cod_pessoa = #arguments.cod_pessoa#
                     </cfif>
					and it.redespacho = 0
			 inner join oper.v$lote l
					 on it.num_lote = l.num_lote
			 where exists (select 'x'
			 				 from oper.v$romaneio_evo re
						    where re.num_romaneio = rhv.num_romaneio
							 and re.num_evento =5)					 
			 group by r.num_romaneio, vat.cod_pessoa, rhv.data_inicio, rhv.data_termino, 
						 r.carregamento, r.destino, substr(r.cliente,1,12), decode( nvl( r.frete_liquido , 0 ), 0 , 0, round( nvl( r.frete_liquido , 0 )  /  oper.pkg_operacional.fnc_converte_peso(r.peso_total, 'kg',  r.cod_unidade),  2 )),
						 nvl(oper.pkg_agregado.fnc_valor_total_frete(r.num_romaneio),0), (((oper.pkg_agregado.fnc_valor_total_frete(r.num_romaneio) + nvl(oper.pkg_operacional.fnc_romaneio_dado(r.num_romaneio).total_icms,0)) - oper.pkg_operacional.fnc_valor_entregue(r.num_romaneio))), 
						 decode(r.situacao_id,2,'OK','?'),substr(rhv.placa_controle,1,3)||'-'||substr(rhv.placa_controle,4), rhv.placa_controle, 
						 decode(l.frete_proprio,1,1,0), decode(decode(l.frete_proprio,1,1,0), 0, (oper.pkg_agregado.fnc_valor_total_frete(r.num_romaneio) * oper.pkg_agregado.fnc_consulta_percentual(2,<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, vat.usuario)),
					   (oper.pkg_agregado.fnc_valor_total_frete(r.num_romaneio) * oper.pkg_agregado.fnc_consulta_percentual(1,<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, vat.usuario))) 				 
			 order by rhv.placa_controle, rhv.data_inicio
		</cfquery>
		<cfreturn qr_result />
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca abastecimentos do veculo no perodo
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->
		
	<cffunction name="get_abastecimentos" access="remote" description="Busca lancamentos na conta corrente" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		   select /*+ ORDERED */ distinct
 				p.placa,p.data_hora,vat.cod_pessoa,
 				substr(p.placa, 1, 3) || '-' || substr(p.placa, 4, length(p.placa)) as placa_tracao,
 				pj.nome_fantasia as posto,pj.municipio,pj.uf,
                nvl(p.valor_unitario, 0) * quantidade as valor,
 				<!---nvl(nvl(round(oper.pkg_agregado.fnc_calcula_preco_diesel(p.controle_id,vat.usuario),3) * p.quantidade,p.valor_total),nvl(p.valor_unitario, 0) * quantidade) as valor,--->
				<!---nvl(round(oper.pkg_agregado.fnc_calcula_preco_diesel(p.controle_id, vat.usuario),3) * p.quantidade,p.valor_total) as valor,--->
				replace(to_char(round(p.quantidade, 1)), ',', '.') as qtde,
                p.valor_unitario,
 				<!---nvl(round(oper.pkg_agregado.fnc_calcula_preco_diesel(p.controle_id,vat.usuario),3),p.valor_unitario) as valor_unitario,--->
				p.km
  			from oper.v$abastecimento p
 	  inner join oper.pessoa_juridica pj on pj.cod_pessoa = p.cod_pessoa_posto
 	  inner join oper.v$veiculo_agregado_tracao vat on vat.placa = p.placa
 		   where p.combustivel = 1
		   	 and pj.modalidade_id != 7
			 and (trunc(p.data_hora) between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio# 00:00:00'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
			 and vat.placa in(#ucase(ListQualify(arguments.placa,"'",",","char"))#))
			 and vat.cod_pessoa = #val( arguments.cod_pessoa )#
   		   order by 1, 2 
		</cfquery>
		<cfreturn qr_result />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca despesas pagas pelo motorista
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_despesas" access="remote" description="Busca despesas pagas pelo motorista" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		    
			select distinct
					va.cod_pessoa, p.placa, substr(p.placa, 1, 3) || '-' ||  substr(p.placa, 4, length(p.placa)) as placa_tracao,p.data_hora,  
				   pj.nome_fantasia as posto, pj.municipio, pp.descricao as produto, pj.uf, p.valor_total, round(p.quantidade,1) as quantidade,   
				   round(p.valor_unitario,3) as valor_unitario,  p.km 
			  from oper.pessoa_juridica pj
			  inner join oper.v$abastecimento p
				 	  on p.cod_pessoa_posto = pj.cod_pessoa
			  inner join oper.v$posto_produto pp 
				 	  on pp.produto_id = p.produto_id   
			  inner join oper.v$veiculo_agregado va
				   on va.placa = p.placa
		      inner join oper.v$produto_abastecimento pa
			  	   on p.produto_id = pa.produto_id          
			where pa.produto_oper_id    != 1  
			  and pj.modalidade_id != 7
			  and (p.data_hora  between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
			  and p.placa in (#ucase(ListQualify(arguments.placa,"'",",","char"))#))                  
			  and va.cod_pessoa  = #val( arguments.cod_pessoa )#
			order by p.placa, p.data_hora
		</cfquery>
		<cfreturn qr_result />
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca vales trocados pelo motorista no perodo, somente se o motorista no for da empresa.
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_vales_veiculo_motorista" access="remote" description="Busca vales trocados pelo motorista no perodo, somente se o motorista no for da empresa." returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="no" />
		<cfargument name="ano" required="no" />
		<cfargument name="data_inicio" required="no" />
		<cfargument name="data_fim" required="no" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

	    <cfif IsDefined("arguments.MES") and IsDefined("arguments.ANO") and Len(Trim(arguments.MES)) and Len(Trim(arguments.ANO))>
			<cfset v_data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
			<cfset v_data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />
		</cfif>

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ordered*/ 
	               v.placa, substr(v.placa, 1, 3) || '-' ||  substr(v.placa, 4, length(v.placa)) as placa_tracao, v.num_vale, v.data_troca, v.valor, 
             	   pj.cod_pessoa, decode(v.tipo_id,2,'Pessoal','Despesas') as tipo, pj.nome_fantasia, pf.nome
			 from oper.v$vale v 
            	  inner join kss.v$pessoa_fisica pf
              		 on pf.cod_pessoa = v.cod_pessoa_funcionario  
            	  inner join oper.v$pessoa_juridica pj 
               		 on pj.cod_pessoa = v.cod_pessoa_troca  
				  inner join oper.v$agregado_motorista am
				          on am.cod_pessoa_motorista = v.cod_pessoa_funcionario
				  inner join(select a.cod_pessoa, vp.placa                                
							   from oper.v$agregado a
								    inner join oper.v$veiculo_proprietario vp
									   on vp.cod_pessoa = a.cod_pessoa
									  and vp.DATA_FIM is null 
                         	  where a.situacao_id = 1 ) vpe
             		 on vpe.placa      = v.placa 
    	   where vpe.cod_pessoa = #val( arguments.cod_pessoa )#
		     <cfif IsDefined("arguments.MES") and IsDefined("arguments.ANO") and Len(Trim(arguments.MES)) and Len(Trim(arguments.ANO))>
				 and trunc(v.data_troca) between to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#v_data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#v_data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
			 </cfif>
		     <cfif IsDefined("arguments.DATA_INICIO") and IsDefined("arguments.DATA_FIM") and Len(Trim(arguments.DATA_INICIO)) and Len(Trim(arguments.DATA_FIM))>
				 and trunc(v.data_troca) between to_date('#arguments.DATA_INICIO# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.DATA_FIM# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
			 </cfif>
			 and v.placa in (#ucase(ListQualify(arguments.placa,"'",",","char"))#)
			 and not exists (select 'x' 
			  				   from oper.v$funcionario_dados fd
							  where fd.cod_pessoa = v.cod_pessoa_funcionario
							    and fd.empresa = 1)
			order by v.data_troca
		</cfquery>
		<cfreturn qr_result />
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca vales trocados pelo motorista no perodo, somente se o motorista no for da empresa.
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_vales_motorista" access="remote" description="Busca vales trocados pelo motorista no perodo, somente se o motorista no for da empresa." returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="data_inicio" required="yes" />
		<cfargument name="data_fim" required="yes" />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ordered*/ 
	               v.placa, substr(v.placa, 1, 3) || '-' ||  substr(v.placa, 4, length(v.placa)) as placa_tracao, v.num_vale, v.data_troca, v.valor, 
             	   pj.cod_pessoa, decode(v.tipo_id,2,'Pessoal','Despesas') as tipo, pj.nome_fantasia, pf.nome
			 from oper.v$vale v 
            	  inner join oper.v$pessoa_fisica pf
              		 on pf.cod_pessoa = v.cod_pessoa_funcionario  
            	  inner join oper.v$pessoa_juridica pj 
               		 on pj.cod_pessoa = v.cod_pessoa_troca  
				  inner join oper.v$agregado_motorista am
				          on am.cod_pessoa_motorista = v.cod_pessoa_funcionario
    	   where v.cod_pessoa_funcionario = #val( arguments.cod_pessoa )#
			 and trunc(v.data_troca) between to_date('#arguments.DATA_INICIO# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.DATA_FIM# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
			 and not exists (select 'x' 
			  				   from oper.v$funcionario_dados fd
							  where fd.cod_pessoa = v.cod_pessoa_funcionario
							    and fd.empresa = 1)
			order by v.data_troca
		</cfquery>
		<cfreturn qr_result />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca despesas pagas pela administradora
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_despesas_administradora" access="remote" description="Busca despesas pagas pela administradora." returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ordered*/
			       'Pedgio' as tipo, pl.placa, pp.descricao, pf.nome as nome_funcionario, pl.data, pl.valor_tarifa as valor,  pl.user_insert as usuario    
			  from oper.v$romaneio_hist_veiculo rhv
       		inner join oper.v$pedagio_lancto pl
				       on pl.placa = rhv.placa_controle
       		inner join oper.v$veiculo_agregado_tracao vat
               on vat.placa = pl.placa
		    inner join oper.v$pedagio_postos pp
			         on pl.posto_pedagio_id = pp.posto_pedagio_id     
       		inner join oper.v$pessoa_fisica pf
               on pf.cod_pessoa = pl.cod_pessoa
    	 where (nvl(rhv.data_termino,sysdate) between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss'))  
			   and pl.data between to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
  	     and not exists (select 'x'
				               from oper.v$agregado_motorista am
					            where am.cod_pessoa_motorista = pl.cod_pessoa
								  and am.cod_pessoa_agregado = vat.cod_pessoa )
   		   and vat.placa = upper('#arguments.placa#')                      
							  
	   union
	                  
		 select /*+ ordered */
			  		'Recibo' as tipo, vr.placa, vr.complemento as descricao, pf.nome as nome_funcionario, vr.data, vr.valor,  vr.user_insert as usuario    
			 from oper.v$romaneio_hist_veiculo rhv
			inner join oper.v$viagem_recibo vr
				    on  vr.placa = rhv.placa_controle
  		    inner join oper.v$veiculo_agregado_tracao vat
				    on vat.placa = vr.placa
		    inner join oper.v$pessoa_fisica pf
				    on pf.cod_pessoa = vr.cod_pessoa			
		  where (nvl(rhv.data_termino,sysdate) between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss'))  
		    and vr.data between to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
			 and not exists (select 'x'
								   from oper.v$agregado_motorista am
									where am.cod_pessoa_motorista = pf.cod_pessoa									
  								      and am.cod_pessoa_agregado = vat.cod_pessoa)
 		    and vat.placa = upper('#arguments.placa#')                      
  	      order by tipo, data   
		</cfquery>
		<cfreturn qr_result />
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca relao de peas gastas pelo veculo no perodo
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_pecas" access="remote" description="Busca relao de peas gastas pelo veculo no perodo" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">
        
		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mp.lancto_id, mp.data_movto, mp.os,  (select os.ordem_servico_id from manutencao.v$ordem_servico os
                                                          where os.num_ordem_servico = mp.os) as ordem_servico_id, mp.placa, substr(mp.placa, 1, 3) || '-' ||  substr(mp.placa, 4, length(mp.placa)) as placa_tracao,initcap(mp.descricao) as descricao,          
				   round(mp.quantidade,1) as quantidade, round(mp.preco_unitario,2) as valor_unitario,round(mp.preco_total,2) as valor_total,
               	   pve.cod_pessoa
			  from oper.manut_peca mp  
                   inner join (select vp.placa, vp.cod_pessoa
  	       			             from oper.v$agregado a 
        							  inner join oper.v$veiculo_proprietario vp
        							     on vp.cod_pessoa = a.cod_pessoa 
										and vp.DATA_FIM is null
        						where a.situacao_id = 1) pve
			 		  on pve.placa = mp.placa                
		    where (mp.data_movto between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
			  and pve.placa in (#ucase(ListQualify( arguments.placa ,"'",",","char"))#))
              and pve.cod_pessoa = #val( arguments.cod_pessoa )#       

			union

 			select om.CONTROLE_ID lancto_id, os.DATA_ABERTURA as data_movto, os.NUM_ORDEM_SERVICO os,os.ordem_servico_id, 
             e.cod_equipamento as placa, substr(e.cod_equipamento, 1, 3) || '-' ||  substr(e.cod_equipamento, 4, length(e.cod_equipamento)) as placa_tracao,
             almoxarifado.fnc_get_material_descricao(om.material_id, ' ')  || ' ' || os.observacao  as descricao,          
 				     round(om.quantidade,1) as quantidade, 
             case 
               when os.empresa = 0 then round(om.valor_unitario,2)
               when os.empresa = 1 and almoxarifado.to_material(om.material_id).valor_unitario = 0 then round(om.valor_unitario,2)
             else round(almoxarifado.to_material(om.material_id).valor_unitario,2) end valor_unitario,
             case 
               when os.empresa = 0 then round(om.valor_total,2)
               when os.empresa = 1 and almoxarifado.to_material(om.material_id).valor_unitario = 0 then round(om.valor_total,2)
             else round(om.quantidade * almoxarifado.to_material(om.material_id).valor_unitario ,2) end valor_total,
             pve.cod_pessoa
			  from manutencao.v$ordem_servico os
			 inner join manutencao.v$os_material om
						on om.ordem_servico_id = os.ordem_servico_id
			 inner join manutencao.v$equipamento e
						on e.equipamento_id = os.equipamento_id               
			 inner join (select vp.placa, vp.cod_pessoa
									from oper.v$agregado a 
							  inner join oper.v$veiculo_proprietario vp
										 on vp.cod_pessoa = a.cod_pessoa 
									  and vp.DATA_FIM is null
									where a.situacao_id = 1) pve
			  on pve.placa = e.cod_equipamento
			where (os.DATA_ABERTURA between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
              and os.num_lancamento is null /* nao est na conta corrente do agregado */
            
		  and pve.placa in (#ucase(ListQualify( arguments.placa ,"'",",","char"))#))
					  and pve.cod_pessoa = #val( arguments.cod_pessoa )#       	
		   union

 			select om.lancamento_id lancto_id, os.DATA_LANCAMENTO as data_movto, os.LANCAMENTO_ID os,(select os.ordem_servico_id from manutencao.v$ordem_servico os
                                                                                                       where os.num_ordem_servico = os.lancamento_id) as ordem_servico_id,
             e.cod_equipamento as placa, substr(e.cod_equipamento, 1, 3) || '-' ||  substr(e.cod_equipamento, 4, length(e.cod_equipamento)) as placa_tracao,
             almoxarifado.fnc_get_material_descricao(os.material_id, ' ')  || ' - ' || os.observacao  as descricao,          
 				     round(os.quantidade,1) as quantidade, round(almoxarifado.to_material(os.material_id).valor_unitario,2) as valor_unitario,
             round(os.quantidade * almoxarifado.to_material(os.material_id).valor_unitario ,2) as valor_total,
             pve.cod_pessoa
			  from almoxarifado.v$movimentacao os
			 inner join almoxarifado.v$movimentacao_equipamento om
						on om.lancamento_id = os.LANCAMENTO_ID
			 inner join manutencao.v$equipamento e
						on e.equipamento_id = om.equipamento_id               
			 inner join (select vp.placa, vp.cod_pessoa
									from oper.v$agregado a 
							  inner join oper.v$veiculo_proprietario vp
										 on vp.cod_pessoa = a.cod_pessoa 
									  and vp.DATA_FIM is null
									where a.situacao_id = 1) pve
			  on pve.placa = e.cod_equipamento
			where (os.DATA_LANCAMENTO between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
		  and pve.placa in (#ucase(ListQualify( arguments.placa ,"'",",","char"))#))
          and om.num_lancamento is null /* nao est na conta corrente do agregado */
					  and pve.cod_pessoa = #val( arguments.cod_pessoa )#       	
		   
			order by placa, data_movto
      </cfquery>
		<cfreturn qr_result />
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca servios gastos pelo veculo no perodo
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_servicos" access="remote" description="Busca servios gastos pelo veculo no perodo" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select pve.cod_pessoa
                	  ,ms.placa
                      ,substr(ms.placa, 1, 3) || '-' ||  substr(ms.placa, 4, length(ms.placa)) as placa_tracao
                      ,ms.servico_id
                      ,ms.os,
                      (select os.ORDEM_SERVICO_ID from manutencao.v$ordem_servico os
                        where os.NUM_ORDEM_SERVICO = ms.os) as ordem_servico_id
                      ,to_number('') as num_nota_id
                      ,to_char(ms.data_emissao,'dd/mm/yyyy') as data_emissao
                      ,initcap(ms.descricao) as descricao
                      ,ms.secao
                      ,ms.categoria_servico
                      ,initcap(ms.observacao) as observacao
                      ,to_char(ms.tempo) as tempo
                      ,round(ms.tempo*((oper.pkg_agregado.fnc_consulta_valor(decode(ms.categoria_servico,'A',16,'B',17,'C',18,'D',19),<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>
                      ,pve.cod_pessoa, 1))/60),2) as valor_total      
					  ,ms.mecanico1_id
             from  oper.manut_servico ms
				 inner join (select vp.placa, vp.cod_pessoa, a.usuario
							   from oper.v$agregado a 
							   inner join oper.v$veiculo_proprietario vp
									   on vp.cod_pessoa = a.cod_pessoa 
									  and vp.DATA_FIM is null
							   where a.situacao_id = 1) pve
						  on pve.placa = ms.placa                
			  where (ms.data_emissao between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
				and ms.placa in (#ucase(ListQualify( arguments.placa ,"'",",","char"))#))
				and pve.cod_pessoa = #val( arguments.cod_pessoa)#
	
           union
			  
  	    select pve.cod_pessoa, e.cod_equipamento as placa, substr(e.cod_equipamento, 1, 3) || '-' ||  substr(e.cod_equipamento, 4, length(e.cod_equipamento)) as placa_tracao,
               to_char(a.atividade_id) as servico_id, 
               os.num_ordem_servico as num_os, os.ordem_servico_id, os.num_nota_id, to_char(os.data_abertura,'dd/mm/yyyy') as data_emissao, 
               initcap(a.titulo) as descricao,          
				  '' as secao, to_char(a.nivel_id) as categoria_servico ,initcap(os.observacao) as observacao, manutencao.to_tempo_execucao(a.tempo_execucao,3).retorno as tempo,
				  case 
				    when os.empresa = 1 then round(((sysdate+om.tempo_execucao_ajustado-sysdate)*24)*((oper.pkg_agregado.fnc_consulta_valor(decode(a.nivel_id,1,16,2,17,3,18,4,19),<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, pve.cod_pessoa, 1))),2) 
					 else round(os.valor_servico / count(om.atividade_id) over(partition by os.ordem_servico_id order by os.ordem_servico_id),2) end valor_total,
				  null
          from manutencao.v$ordem_servico os
         inner join manutencao.v$os_atividade om
                 on om.ordem_servico_id = os.ordem_servico_id
         inner join manutencao.v$atividade a
                 on a.atividade_id = om.atividade_id
         inner join manutencao.v$equipamento e
                 on e.equipamento_id = os.equipamento_id
				 inner join (select vp.placa, vp.cod_pessoa, a.usuario
							   from oper.v$agregado a 
							   inner join oper.v$veiculo_proprietario vp
									   on vp.cod_pessoa = a.cod_pessoa 
									  and vp.DATA_FIM is null
							   where a.situacao_id = 1) pve
						  on pve.placa = e.cod_equipamento
			  where (os.data_abertura between  to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss')
				and pve.placa in (#ucase(ListQualify( arguments.placa ,"'",",","char"))#))
				and pve.cod_pessoa = #val( arguments.cod_pessoa)#
                and os.num_lancamento is null /* nao est na conta corrente do agregado */
		  order by placa, data_emissao, categoria_servico	
		</cfquery>
		<cfreturn qr_result />
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca valor do aluguel de carretas
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_aluguel" access="remote" description="Busca valor do aluguel de carretas" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select nvl( sum((r.frete_total*oper.pkg_agregado.fnc_consulta_valor(21,d.data_inicio,a.usuario)/100)), 0) as valor_aluguel 
                  from oper.v$agregado a
                 cross join (
                             select to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, 'dd/mm/yyyy') as data_inicio
                                  , to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss') as data_termino
                               from dual
                            ) d
                 inner join oper.v$veiculo_proprietario vpe
                         on vpe.cod_pessoa = a.cod_pessoa
                        and vpe.data_inicio < d.data_termino
                        and nvl(vpe.data_fim, d.data_inicio + 1) > d.data_inicio
                 inner join oper.v$romaneio_hist_veiculo rhv
                         on rhv.placa_controle = vpe.placa
                 inner join oper.v$romaneio r
                         on rhv.num_romaneio = r.num_romaneio
                 inner join oper.v$veiculo_proprietario vpr
                         on vpr.placa = rhv.placa_referencia
                        and vpr.data_inicio < nvl(rhv.data_termino, vpr.data_inicio + 1)
                        and nvl(vpr.data_fim, rhv.data_inicio + 1) > rhv.data_inicio
                 inner join kss.v$unidade_negocio un
                         on un.cod_pessoa = vpr.cod_pessoa
                 where a.cod_pessoa = #arguments.cod_pessoa# 
                   and vpe.placa = upper('#arguments.placa#') 
                   and rhv.data_termino between d.data_inicio and d.data_termino
                   and nvl(rhv.data_termino, sysdate) = (select max(nvl(rhv2.data_termino, sysdate))
                                                           from oper.v$romaneio_hist_veiculo rhv2
                                                          where rhv2.num_romaneio = rhv.num_romaneio
                                                        )
		</cfquery>
		<cfreturn qr_result />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca encargos do motorista locado para o agregado
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_encargos" access="remote" description="Busca encargos do motorista locado para o agregado" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ 
				   nvl( sum(((r.frete_liquido-(r.valor_pedagio_vazio + r.valor_pedagio_carregado + nvl(r.valor_descarga,0))) * oper.pkg_agregado.fnc_consulta_percentual(1,<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, a.cod_pessoa, 1) * vcv.comissao /100 * 0.67)  * (1-oper.pkg_agregado.fnc_consulta_percentual(38,<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, a.cod_pessoa, 1)) ), 0) as valor_total
			  from oper.v$romaneio r 
			  inner join oper.v$romaneio_hist_veiculo rhv 
					  on rhv.num_romaneio = r.num_romaneio 
		      inner join oper.v$motorista_reg_historico mrh
                on mrh.cod_pessoa = rhv.cod_pessoa
               and rhv.data_termino between mrh.data_inicio and nvl(mrh.data_fim,sysdate)
			  inner join oper.v$veiculo_proprietario vp 
					  on vp.placa = rhv.placa_controle 
					 and vp.DATA_FIM is null
			  inner join oper.v$veiculo_dados vd 
					  on vd.placa = vp.placa 
			   inner join oper.v$agregado a 
					  on a.cod_pessoa = vp.cod_pessoa          
			 inner join oper.v$veiculo_comissao_placa vcp
					 on vcp.placa = vd.placa
					and r.data_termino between vcp.data_inicio and nvl(vcp.data_termino,sysdate)
 			 inner join oper.v$veiculo_comissao_vigencia vcv
					on vcv.cod_comissao = vcp.cod_comissao
				   and r.data_termino between vcv.data_inicio and nvl(vcv.data_termino,sysdate)
			where (nvl(rhv.data_termino,sysdate) between to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss'))          
			  and vd.num_rastreador is not null 
			  and vp.placa = upper('#arguments.placa#') 
			  and a.cod_pessoa = #val( arguments.cod_pessoa )# 
			  and mrh.cod_registro in (select f.cod_funcionario
									   from oper.v$rh_funcionario f 
									   where f.cod_entreposto = 1
									     and f.data_demissao is null) 	  	
		</cfquery>
		<cfreturn qr_result />
	</cffunction>							

	<!--- 
	-- PROPSITO 
	-- Busca valor de motorista locados para o agregado
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_locacoes" access="remote" description="Busca valor de motorista locados para o agregado" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS */ 
				   nvl( sum((r.frete_liquido-(r.valor_pedagio_vazio+r.valor_pedagio_carregado + nvl(r.valor_descarga,0))) * oper.pkg_agregado.fnc_consulta_percentual(1,<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, a.cod_pessoa, 1) * vcv.comissao /100), 0) as valor_funcionario
			  from oper.v$romaneio r 
			  inner join oper.v$romaneio_hist_veiculo rhv 
					  on rhv.num_romaneio = r.num_romaneio 
		      inner join oper.v$motorista_reg_historico mrh
                on mrh.cod_pessoa = rhv.cod_pessoa
               and rhv.data_termino between mrh.data_inicio and nvl(mrh.data_fim,sysdate)
			  inner join oper.v$veiculo_proprietario vp 
					  on vp.placa = rhv.placa_controle 
					 and vp.DATA_FIM is null
			  inner join oper.v$veiculo_dados vd 
					  on vd.placa = vp.placa 
			   inner join oper.v$agregado a 
					  on a.cod_pessoa = vp.cod_pessoa          
			 inner join oper.v$veiculo_comissao_placa vcp
					 on vcp.placa = vd.placa
					and r.data_termino between vcp.data_inicio and nvl(vcp.data_termino,sysdate)
 			 inner join oper.v$veiculo_comissao_vigencia vcv
					on vcv.cod_comissao = vcp.cod_comissao
				   and r.data_termino between vcv.data_inicio and nvl(vcv.data_termino,sysdate)
			where (nvl(rhv.data_termino,sysdate) between to_date(<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio# 00:00:00'</cfif>, 'dd/mm/yyyy hh24:mi:ss') and to_date(<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim# 23:59:59'</cfif>, 'dd/mm/yyyy hh24:mi:ss'))          
			  and vd.num_rastreador is not null 
			  and vp.placa = upper('#arguments.placa#') 
			  and a.cod_pessoa = #val( arguments.cod_pessoa )# 
			  and mrh.cod_registro in (select f.cod_funcionario
									   from oper.v$rh_funcionario f 
									   where f.cod_entreposto = 1
									     and f.data_demissao is null) 		
		</cfquery>
		<cfreturn qr_result />
	</cffunction>	
	
	<!--- 
	-- PROPSITO 
	-- Busca valor do rastreamento dos veculos do agregado
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_rastreamento" access="remote" description="Busca valor do rastreamento dos veculos do agregado" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />
        <cfargument name="agr_data_inicio" required="no" default="">
        <cfargument name="agr_data_fim" required="no" default="">

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select max(decode(v.rastreador_id, null, 0, oper.pkg_agregado.fnc_consulta_valor(25,<cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif>, a.usuario)/100)) as valor_rastreamento
		      from oper.v$agregado a
			 inner join oper.v$veiculo_proprietario vp
			         on vp.cod_pessoa = a.cod_pessoa
					and vp.DATA_FIM is null
			 inner join oper.v$veiculo_historico_rastreador v
			         on v.placa = vp.placa 		
                    and nvl(v.data_final,<cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim#'</cfif>) between <cfif len(trim(arguments.agr_data_inicio))>'#arguments.agr_data_inicio#'<cfelse>'#data_inicio#'</cfif> and <cfif len(trim(arguments.agr_data_fim))>'#arguments.agr_data_fim# 23:59:59'<cfelse>'#data_fim#'</cfif>
			  where a.cod_pessoa  = #val( arguments.cod_pessoa )#
                and v.placa = '#arguments.placa#'
		</cfquery>
		<cfreturn qr_result />
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca dados do fechamento
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_fechamento" access="remote" description="Busca dados do fechamento" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes"/>
		<cfargument name="placa" required="yes"/>
		<cfargument name="mes" required="yes" />
		<cfargument name="ano" required="yes" />

		<cfset var data_inicio = this.primeiro_dia_mes(argumentCollection = arguments ) />
		<cfset var data_fim    = this.ultimo_dia_mes(argumentCollection = arguments ) />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select af.fechamento_id, af.fechamento_id as cod_fechamento, af.placa, 
			 	    af.mes, af.ano, af.num_lancamento_ccorrente, af.valor     
 	    	   from oper.v$agregado_fechamento af
		  	   where af.placa		  = upper('#arguments.placa#')
		   	     and af.mes 	      = '#arguments.mes#'
		    	 and af.ano 		  = '#arguments.ano#'	
		</cfquery>
		<cfreturn qr_result />
	</cffunction>				

	<!--- 
	-- PROPSITO 
	-- Busca ultimos lanamentos efetuados nas contas correntes dos usurios
	-- NOTAS EXPLICATIVAS
	-- GUTO  13/01/2006
	--->		
	<cffunction name="get_lancamentos_conta_corrente" access="remote" description="Busca ultimos lanamentos efetuados nas contas correntes dos usurios" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select l.num_lancamento, l.num_documento, l.cod_conta, 
			 	    l.data_lancamento, l.historico, l.valor_lancamento, 
					l.deb_cred, l.data_vencto, l.razao_social as agregado,
					l.favorecido, l.cod_documento, l.deb_cred_id
			  from ( select /*+ordered use_hash(a pjl)*/
                     cl.num_lancamento, cl.num_documento, cl.cod_conta, cl.data_lancamento,
                     cl.historico, cl.valor_lancamento, cl.favorecido, cl.cod_documento,
                     cl.deb_cred as deb_cred_id,
                     decode(cl.deb_cred, 0, 'Dbito', 1, 'Crdito') as deb_cred, cl.data_vencto,
                     a.razao_social
                from oper.v$agregado a
               inner join oper.v$ccorrente pjl 
                       on a.cod_pessoa = pjl.cod_pessoa
               inner join oper.v$ccorrente_lancamento cl
                       on cl.cod_conta = pjl.cod_conta
               where cl.user_insert = user
               order by cl.date_insert desc) l 
			 where rownum <=15 
		</cfquery>
		<cfreturn qr_result />
	</cffunction>				

   <!--- 
	-- PROPSITO 
	-- Lista do saldo das contas corrente dos agregados
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO  13/02/2006
	--->			
	<cffunction name="get_saldo_agregado" displayname="Listagem do saldo das contas corrente dos agregados" access="remote" returntype="query" output="true">
		<cfargument name="data" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select pj.cod_pessoa, pj.nome_fantasia || ' - ' || pj.razao_social as nome_fantasia, 
			 oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(pjc.cod_conta,to_date('#arguments.data#','dd/mm/yyyy'), 0) saldo 
			   from oper.v$ccorrente pjc 
			   inner join oper.v$pessoa_juridica pj 
					   on pj.cod_pessoa = pjc.cod_pessoa
			   inner join oper.v$agregado a
					   on a.cod_pessoa = pj.cod_pessoa
			 where a.situacao_id =1
			   and exists( select 'x'
							 from oper.v$veiculo_proprietario vp
							 inner join oper.v$veiculo v 
									 on vp.placa = v.placa
									and vp.data_fim is null
							 inner join oper.v$veiculo_modelo vm
									 on vm.marca_id = v.marca_id
									and vm.modelo_id = v.modelo_id
							 inner join oper.v$veiculo_tracao  vt
									 on vt.tipo_id = vm.tipo_id 
						where vp.cod_pessoa = a.cod_pessoa )
			order by pj.nome_fantasia			
	 </cfquery>
				
	<cfreturn qr_result />										
	</cffunction>
	
   <!--- 
	-- PROPSITO 
	-- Seleciona parmetros dos agregados
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO  13/02/2006
	--->			
	<cffunction name="get_parametros_agregados" displayname="Seleciona parmetros individuais e personalizados" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes" />		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 'Geral' as tipo, ap.id, ap.descricao, 
					decode(ap.tipo_valor_id,3,decode(ap.valor,1,'Sim','No'),2,ap.valor,to_char(ap.valor,'999,990.00')) as valor, ap.ativo,
					'Geral' as data_vigencia, 
					to_char(ap.valor) as valor_real
			  from oper.v$agregado_gestao_padrao ap   
			 where not exists (select 'x'                       
								from oper.v$agregado_gestao_individual ag
									 inner join oper.v$agregado a                      
									   on ag.cod_pessoa = a.cod_pessoa
							   where a.cod_pessoa = #arguments.cod_pessoa#
								 and ap.id = ag.id) 
			  and ap.ativo = 1 
			  and ap.id <> 20
		   union
		   select 'Geral' as tipo, ap.id, ap.descricao, 
				  decode(ap.valor,0,'Quinzenal','Semanal') as valor, ap.ativo,
				  'Geral' as data_vigencia, to_char(ap.valor) as valor_real
			 from oper.v$agregado_gestao_padrao ap   
			where not exists (select 'x'                       
								from oper.v$agregado_gestao_individual ag
									 inner join oper.v$agregado a                      
									   on ag.cod_pessoa = a.cod_pessoa
							   where a.cod_pessoa = #arguments.cod_pessoa#
								 and ap.id = ag.id) 
			  and ap.ativo = 1 
			  and id = 20
			union     
			  select 'Personalizado' as tipo, ap.id, ap.descricao, 
					 decode(ap.tipo_valor_id,3,decode(ag.percentual,1,'Sim','No'),2,ag.percentual,to_char((ap.valor*(100+ag.percentual))/100,'999,990.00')) as valor, ap.ativo,
					 to_char(ag.data_vigencia,'dd/mm/yyyy') as data_vigencia, 
					 decode(ap.tipo_valor_id,3,to_char(ag.percentual),2,to_char(ag.percentual),to_char((ap.valor*(100+ag.percentual))/100,'999,990.00') ) as valor_real
				from oper.v$agregado_gestao_padrao ap
					 inner join  oper.v$agregado_gestao_individual ag
					   on ap.id = ag.id
					 inner join oper.v$agregado a
					   on ag.cod_pessoa =  a.cod_pessoa
				where exists (select 'x'                       
								from oper.v$agregado_gestao_individual ag
									 inner join oper.v$agregado a                      
									   on ag.cod_pessoa = a.cod_pessoa
							   where a.cod_pessoa = #arguments.cod_pessoa#
								 and ap.id = ag.id) 
			  and a.cod_pessoa = #arguments.cod_pessoa#
			  and ap.id <> 20
			  and ap.ativo = 1
			union     
			  select 'Personalizado' as tipo, ap.id, ap.descricao, decode(ag.percentual,0,'Quinzenal','Semanal') as valor, ap.ativo, 
					 to_char(ag.data_vigencia,'dd/mm/yyyy') as data_vigencia, 
					 to_char(ag.percentual) as valor_real
				from oper.v$agregado_gestao_padrao ap
					 inner join  oper.v$agregado_gestao_individual ag
					   on ap.id = ag.id
					 inner join oper.v$agregado a
					   on ag.cod_pessoa =  a.cod_pessoa
				where exists (select 'x'                       
								from oper.v$agregado_gestao_individual ag
									 inner join oper.v$agregado a                      
									   on ag.cod_pessoa = a.cod_pessoa
							   where a.cod_pessoa = #arguments.cod_pessoa#
								 and ap.id = ag.id) 
			  and a.cod_pessoa = #arguments.cod_pessoa#
			  and ap.id = 20
			  and ap.ativo = 1
			order by 2	

		</cfquery>
				
		<cfreturn qr_result />								
		
	</cffunction>	


	<!--- 
	-- PROPSITO 
	-- Busca as cargas em aberto para cartas frete de coleta/entrega
	-- CRISTOFER  24/04/2007
	--->		
	<cffunction name="get_cargas_entrega" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.carga_id,
                   con.num_conhecimento||'/'||con.serie num_conhecimento,
                   rem.cliente remetente,
                   cep.fnc_municipio_uf(c.coleta_municipio_id) origem,
                   dest.cliente destinatario,
                   cep.fnc_municipio_uf(c.entrega_municipio_id) destino,
                   ev.placa,
                   to_char(ev.data_agendamento,'dd/mm/yyyy hh24:mi:ss') data,
                   2 as operacao_id
              from oper.v$entrega e
             inner join oper.v$entrega_veiculo ev
                     on ev.entrega_id = e.entrega_id
             inner join oper.v$carga c
                     on c.carga_Id = e.carga_id
             inner join kss.v$pessoa rem
                     on rem.cod_pessoa = c.rem_cod_pessoa
             inner join kss.v$pessoa dest
                     on dest.cod_pessoa = c.dest_cod_pessoa
              left join oper.v$carga_ctrc cc
                     on cc.carga_id = c.carga_id
              left join fiscal.v$conhecimento con
                     on con.conhecimento_id = cc.conhecimento_id
             where 1=1
               /* and data_entrega is not null */
            <cfif len(trim(arguments.placa))>
               and oper.pkg_veiculo.fnc_get_placa(ev.placa) = '#arguments.placa#'
            </cfif>
            <cfif len(trim(arguments.data_inicial))>
               and trunc(ev.data_agendamento) >= '#arguments.data_inicial#'
            </cfif>
            <cfif len(trim(arguments.data_final))>
               and trunc(ev.data_agendamento) <= '#arguments.data_final#'
            </cfif>
               and ev.data_agendamento > to_date('01/03/2008','dd/mm/yyyy')
               and not exists (select 'x'
                                 from oper.v$agreg_viagem_carga avc
                                where avc.carga_id = c.carga_id
                                  and avc.operacao_Id = 2)
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca as coletas em aberto para a placa
	-- CRISTOFER  24/04/2007
	--->		
	<cffunction name="get_cargas_coleta" access="remote" returntype="query" output="true">
    	<cfargument name="placa" required="no" default="">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.carga_id,
                   con.num_conhecimento||'/'||con.serie num_conhecimento,
                   rem.cliente remetente,
                   cep.fnc_municipio_uf(c.coleta_municipio_id) origem,
                   dest.cliente destinatario,
                   cep.fnc_municipio_uf(c.entrega_municipio_id) destino,
                   cv.placa,
                   to_char(cl.data_pedido,'dd/mm/yyyy hh24:mi:ss')  data,
                   1 as operacao_Id
              from oper.v$coleta cl
             inner join oper.v$coleta_veiculo cv
                     on cv.coleta_id = cl.coleta_id
             inner join oper.v$carga c
                     on c.carga_Id = cl.carga_id
             inner join kss.v$pessoa rem
                     on rem.cod_pessoa = c.rem_cod_pessoa
             inner join kss.v$pessoa dest
                     on dest.cod_pessoa = c.dest_cod_pessoa
              left join oper.v$carga_ctrc cc
                     on cc.carga_id = c.carga_id
              left join fiscal.v$conhecimento con
                     on con.conhecimento_id = cc.conhecimento_id
             where 1=1
               /* and cv.data_confirmacao is not null */
            <cfif len(trim(arguments.placa))>
               and oper.pkg_veiculo.fnc_get_placa(cv.placa) = '#arguments.placa#'
            </cfif>
            <cfif len(trim(arguments.data_inicial))>
               and trunc(cl.data_pedido) >= '#arguments.data_inicial#'
            </cfif>
            <cfif len(trim(arguments.data_final))>
               and trunc(cl.data_pedido) <= '#arguments.data_final#'
            </cfif>
               and cl.data_pedido > to_date('01/03/2008','dd/mm/yyyy')
               and not exists (select 'x'
                                 from oper.v$agreg_viagem_carga avc
                                where avc.carga_id = c.carga_id
                                  and avc.operacao_id = 1)  
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca as cartas frete de agregados
	-- CRISTOFER  26/04/2007
	--->		
	<cffunction name="get_agreg_viagem" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicial" required="no" default="">
    	<cfargument name="data_final" required="no" default="">
    	<cfargument name="placa" required="no" default="">
        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.viagem_id,
                   to_char(v.data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio,
                   v.placa_controle,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(v.placa_controle) cod_veiculo,
                   v.num_romaneio,
                   c.lancto_id,
                   v.municipio_id_origem,
                   v.municipio_id_destino,
                   cep.fnc_municipio_uf(v.municipio_id_origem) origem,
                   cep.fnc_municipio_uf(v.municipio_id_destino) destino,
                   v.tipo_servico,
                   oper.fnc_ref_code('AGREG_VIAGEM.TIPO_SERVICO',v.tipo_servico) tipo_servico_desc,
                   v.valor_servico,
                   c.num_formulario,
                   v.user_insert,
                   v.usuario_cancelamento,
                   to_char(v.data_cancelamento,'dd/mm/yyyy hh24:mi:ss') data_cancelamento,
                   nvl((select min(impresso)
                   		  from oper.v$cfa c1
                         where coalesce(c1.lancto_id_pai,c1.lancto_id) = c.lancto_id),1) impresso,
                   c.parcela,
                   c.total_parcela
              from oper.v$agreg_viagem v
              left join oper.v$cfa c
                     on c.lancto_id = v.lancto_id
             where 1=1
             <cfif len(trim(arguments.data_inicial))>
               and trunc(v.data_inicio) >= '#arguments.data_inicial#'
             </cfif>
             <cfif len(trim(arguments.data_final))>
               and trunc(v.data_inicio) <= '#arguments.data_final#'
             </cfif>
             <cfif len(trim(arguments.placa))>
               and (upper(v.placa_controle) like upper('%#arguments.placa#%') or upper(oper.fnc_get_cod_veiculo(v.placa_controle)) like upper('%#arguments.placa#%'))
             </cfif>
             order by data_inicio, num_formulario
             
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
	<!--- 
	-- PROPSITO 
	-- Busca os dados para a impressao da CFA
	-- CRISTOFER  28/04/2008
	--->		
	<cffunction name="get_cfa_print" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctf.cf_terceiro, 
                   ctf.cf_agregado, 
                   ctf.lancto_id, 
                   ctf.num_formulario, 
                   ctf.serie_formulario,
                   ctf.num_romaneio, 
                   ctf.previsao_chegada_dia, 
                   ctf.num_manifesto_ctrc_first, 
                   ctf.remetente, 
                   ctf.destinatario, 
                   ctf.origem, 
                   ctf.destino, 
                   ctf.proprietario_veiculo, 
                   ctf.proprietario_cnpj_cpf, 
                   ctf.placa_frota, 
                   ctf.proprietario_nit, 
                   ctf.proprietario_rg, 
                   ctf.motorista, 
                   ctf.cod_pessoa_filial, 
                   ctf.filial, 
                   ctf.cnpj_filial, 
                   ctf.data_emissao, 
                   ctf.descarga_por_conta, 
                   ctf.valor_total_servico, 
                   ctf.valor_carga_descarga, 
                   ctf.valor_pedagio, 
                   ctf.valor_servico_prestado, 
                   ctf.valor_adiantamento, 
                   ctf.valor_adiantamento_pedagio, 
                   ctf.valor_adto_carga_descarga, 
                   ctf.valor_total_adto, 
                   ctf.valor_irrf, 
                   ctf.valor_inss, 
                   ctf.valor_sest_senat, 
                   ctf.valor_consulta_cadastro, 
                   ctf.valor_transf_acerto, 
                   ctf.saldo_pagar, 
                   ctf.valor_falta_avaria, 
                   ctf.saldo_liquido_pagar, 
                   ctf.valor_novo_saldo_pagar, 
                   ctf.observacao, 
                   ctf.observacao2, 
                   ctf.observacao_final, 
                   ctf.cfi,
                   ctf.tipo_contrato,
                   ctf.impresso,
                   to_char(ctf.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') data_cancelamento,
                   to_char(ctf.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
              from oper.v$contrato_transp_form ctf
             where 1=1
             <cfif len(trim(arguments.lancto_id))>
               and ctf.lancto_id = #arguments.lancto_id#
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna tipos de custo
    -- LEOPOLDOS 25/08/2010 - CRIADO
    --->		
    <cffunction name="get_tipos_custo" access="remote" returntype="query" output="true">
    	<cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.custo_tipo_id
            	 , a.descricao
              from oper.v$agreg_custo_tipo a
             where 1=1
             <cfif Len(Trim(arguments.descricao))>
               and upper(a.descricao) like upper('%#arguments.descricao#%')
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna Frotas do agregado
    -- LEOPOLDOS 99/99/2010 - CRIADO
    --->		
    <cffunction name="get_frota_agregado" access="remote" returntype="query" output="true">
    	<cfargument name="nome" required="no" default="">
        <cfargument name="frota" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select vp.placa
	             , oper.pkg_veiculo.fnc_get_cod_veiculo(vp.placa) as frota
                 , vp.cod_pessoa
                 , a.nome_fantasia
              from oper.v$agregado a
             inner join oper.v$veiculo_proprietario vp
                      on vp.cod_pessoa = a.cod_pessoa 
             inner join oper.v$veiculo v 
                      on vp.placa = v.placa
             where 1 = 1
               <cfif Len(Trim(arguments.nome))>
               and upper(a.nome_fantasia) like upper('%#arguments.nome#%')
               </cfif>
               <cfif Len(Trim(arguments.frota))>
               and vp.placa = oper.pkg_veiculo.fnc_get_placa(upper('#arguments.frota#'))
               </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna Custos por agregado
    -- LEOPOLDOS 26/08/2010 - CRIADO
    --->		
    <cffunction name="get_custo_agregado" access="remote" returntype="query" output="true">
    	<cfargument name="frota" required="no" default="">
    	<cfargument name="custo_tipo_id" required="no" default="">
    	<cfargument name="data_inicio" required="no" default="">
    	<cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.custo_pessoa_id
                 , p.frota
                 , p.custo_tipo_id
                 , (select t.descricao
 			          from oper.v$agreg_custo_tipo t
         			 where t.custo_tipo_id = p.custo_tipo_id) as tipo_custo
                 , p.valor
                 , to_char(p.data_vigencia, 'dd/MM/yyyy') as data_vigencia
              from oper.v$agreg_custo_pessoa p
             where 1 = 1 
               <cfif Len(Trim(arguments.frota))>
               and p.frota = oper.pkg_veiculo.fnc_get_cod_veiculo('#arguments.frota#')
               </cfif>
               <cfif Len(Trim(arguments.custo_tipo_id))>
               and p.custo_tipo_id = #arguments.custo_tipo_id#
               </cfif>
               <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
               and p.data_vigencia between '#arguments.data_inicio#' and '#arguments.data_fim#'
               </cfif>
               <cfif Len(Trim(arguments.data_inicio)) and (Len(Trim(arguments.data_fim)) eq 0)>
               and p.data_vigencia >= '#arguments.data_inicio# 00:00:00'
               </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna Faturamento Agregado
    -- LEOPOLDOS 26/08/2010 - CRIADO
    --->		
    <cffunction name="get_relatorio_faturamento_agregado" access="remote" returntype="query" output="true">
    	<cfargument name="frota" required="yes">
    	<cfargument name="data_inicio" required="yes">
    	<cfargument name="data_fim" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.num_formulario as carta_frete
                 , ct.serie_formulario
                 , decode(ct.avulsa,0,ct.num_romaneio, null) as romaneio
                 , to_char(ct.data_emissao, 'dd/MM/yyyy') as data
                 , r.carregamento as origem
                 , r.destino
                 , ct.valor_frete_liquido as valor_frete
                 , ct.proprietario_cod_pessoa
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = proprietario_cod_pessoa) as proprietario
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(ct.placa_controle) as frota
                 , ct.placa_controle as placa
                 , '#arguments.DATA_INICIO#'||' a '||'#arguments.DATA_FIM#' as periodo
              from oper.v$contrato_transp ct
              left join oper.v$romaneio r
                on r.num_romaneio = ct.num_romaneio
             where ct.data_cancelamento is null
               and ct.placa_controle = oper.pkg_veiculo.fnc_get_placa('#arguments.FROTA#')
               and ct.data_emissao between '#arguments.DATA_INICIO# 00:00:00' and '#arguments.DATA_FIM# 23:59:59'
             order by ct.placa_controle, ct.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    <!--- 
    -- PROPSITO 
    -- Retorna Custo agregado
    -- LEOPOLDOS 99/99/2010 - CRIADO
    --->		
    <cffunction name="get_relatorio_custo_agregado" access="remote" returntype="query" output="true">
    	<cfargument name="frota" required="yes">
    	<cfargument name="data_inicio" required="yes">
    	<cfargument name="data_fim" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.tipo_custo
                 , x.valor as valor_km
                 , nvl((x.km_fim - km_inicio),0) km_rodado
                 , nvl((x.km_final - x.km_inicial),0) km_rodado_total
                 , nvl(x.valor * (x.km_fim - km_inicio),0) as valor
                 , x.frota    
              from (select act.descricao as tipo_custo
                         , acp.valor
                         , acp.frota
                         , (select min(vk.km) keep(dense_rank first order by vk.data_hora)
                              from oper.v$veiculo_km vk
                             where vk.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.FROTA#')
                               and vk.data_hora between case 
                                                           when acp.data_vigencia < to_date('#arguments.DATA_INICIO# 00:00:00') then
                                                              to_date('#arguments.DATA_INICIO# 00:00:00')
                                                           else
                                                              acp.data_vigencia
                                                        end and (select decode(max(ac.data_vigencia), acp.data_vigencia, '#arguments.DATA_FIM# 23:59:59', max(ac.data_vigencia))
                                                                                 from oper.v$agreg_custo_pessoa ac
                                                                                where ac.custo_tipo_id = act.custo_tipo_id
                                                                                  and ac.frota = acp.frota
                                                                                  and ac.data_vigencia <= '#arguments.DATA_FIM# 23:59:59')) km_inicio    
                         , (select max(vk.km) keep(dense_rank last order by vk.data_hora)
                              from oper.v$veiculo_km vk
                             where vk.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.FROTA#')
                               and vk.data_hora between case 
                                                           when acp.data_vigencia < to_date('#arguments.DATA_INICIO# 00:00:00') then
                                                              to_date('#arguments.DATA_INICIO# 00:00:00')
                                                           else
                                                              acp.data_vigencia
                                                        end and (select decode(max(ac.data_vigencia), acp.data_vigencia, '#arguments.DATA_FIM# 23:59:59', max(ac.data_vigencia))
                                                                                 from oper.v$agreg_custo_pessoa ac
                                                                                where ac.custo_tipo_id = act.custo_tipo_id
                                                                                  and ac.frota = acp.frota
                                                                                  and ac.data_vigencia <= '#arguments.DATA_FIM# 23:59:59')) km_fim       
                         , (select min(vk.km) keep(dense_rank first order by vk.data_hora)
                              from oper.v$veiculo_km vk
                             where vk.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.FROTA#')
                               and vk.data_hora between '#arguments.DATA_INICIO# 00:00:00' and '#arguments.DATA_FIM# 23:59:59') as km_inicial  
                         , (select max(vk.km) keep(dense_rank last order by vk.data_hora)
                              from oper.v$veiculo_km vk
                             where vk.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.FROTA#')
                               and vk.data_hora between '#arguments.DATA_INICIO# 00:00:00' and '#arguments.DATA_FIM# 23:59:59') as km_final         
                      from oper.v$agreg_custo_tipo act
                     inner join oper.v$agreg_custo_pessoa acp
                        on acp.custo_tipo_id = act.custo_tipo_id    
                     where acp.frota = oper.pkg_veiculo.fnc_get_cod_veiculo(oper.pkg_veiculo.fnc_get_placa('#arguments.FROTA#'))
                       and acp.data_vigencia <= (select max(ac.data_vigencia)
                                                   from oper.v$agreg_custo_pessoa ac
                                                  where ac.custo_tipo_id = act.custo_tipo_id
                                                    and ac.frota = acp.frota
                                                    and ac.data_vigencia <= '#arguments.DATA_FIM# 23:59:59')
            ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
   <!--- 
    -- PROPSITO 
    -- Retorna solicitao de pagamento/recebimento de agregado
    -- Eric 06/11/2010 - CRIADO
    --->		
    <cffunction name="get_solicitacao_agregado" access="remote" returntype="query" output="true">
	    <cfargument name="solicitacao_id"  required="no" default="">
        <cfargument name="descricao"       required="no" default="">
    	<cfargument name="frota"           required="no" default="">
    	<cfargument name="data_vencimento" required="no" default="">
    	<cfargument name="data_lancamento" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select als.solicitacao_id
                 , als.placa_controle
                 , als.cod_pessoa_agregado
                 , kss.pkg_pessoa.fnc_get_cliente(als.cod_pessoa_agregado) as agregado
                 , (select v.cod_veiculo
                      from oper.v$veiculo v
                     where v.placa = als.placa_controle) as cod_veiculo
                 , als.deb_cred
                 , decode(als.deb_cred, 1, 'Crdito', 'Dbito') as deb_cred_desc
                 , als.config_id
                 , als.cod_organograma_gerencial
                 , als.valor
                 , als.num_parcela
                 , als.total_parcela
                 , als.valor_parcelamento
                 , als.descricao
                 , to_char(als.data_lancamento, 'dd/mm/yyyy') as data_lancamento
                 , to_char(als.data_vencimento, 'dd/mm/yyyy') as data_vencimento
                 , als.observacao
                 , als.lancamento_id
                 , als.rpa_id
                 , to_char(als.data_cancelamento, 'dd/mm/yyyy hh24:mi') as data_cancelamento
                 , upper(als.usuario_cancelamento) as usuario_cancelamento
                 , als.motivo_cancelamento
                 , to_char(als.data_aprovacao, 'dd/mm/yyyy hh24:mi') as data_aprovacao
                 , upper(als.usuario_aprovacao) as usuario_aprovacao
                 , upper(als.user_insert) as user_insert
                 , to_char(als.date_insert, 'dd/mm/yyyy hh24:mi') as date_insert
                 , upper(als.user_update) as user_update
                 , als.date_update
              from oper.v$agreg_lancamento_solicit als
             where 1 = 1
			<cfif Len(Trim(arguments.solicitacao_id))>
               and upper(als.solicitacao_id) like upper('#arguments.solicitacao_id#%')
            </cfif>             
			<cfif Len(Trim(arguments.descricao))>
               and upper(als.descricao) like upper('#arguments.descricao#%')
            </cfif>  
			<cfif Len(Trim(arguments.frota))>
			   and als.placa_controle in (select v.placa
                                            from oper.v$veiculo v
                                           where upper(v.cod_veiculo) like upper('#arguments.frota#%'))
            </cfif>
            <cfif Len(Trim(arguments.data_vencimento))>
               and als.data_vencimento = '#arguments.data_vencimento#'
            </cfif>
            <cfif Len(Trim(arguments.data_lancamento))>
               and als.data_lancamento = '#arguments.data_lancamento#'
            </cfif>            
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
   <!--- 
    -- PROPSITO 
    -- Retorna classificao contbil para agregado
    -- Eric 08/11/2010 - CRIADO
    --->		
    <cffunction name="get_class_contabil_agregado" access="remote" returntype="query" output="true">
	    <cfargument name="deb_cred"  required="yes">
        <cfargument name="config_id" required="no" default="">
        <cfargument name="ativo"     required="no" default="">
        <cfargument name="descricao" required="no" default="">        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.config_id
                 , a.ativo
                 , case
                      when a.ativo = 0 then
                         a.descricao||' (INATIVO)'
                      else
                         a.descricao
                   end as descricao
                 , case
                      when a.deb_cred = 1 then
                         'Crdito'
                      else
                         'Dbito'
                   end as deb_cred
                 , a.cod_organograma_gerencial
                 , (select lpad(cc.cod_centro_custo,4,'0') ||' - '|| cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = o.cod_centro_custo
                   ) as desc_centro_custo
              from oper.v$agreg_contab_config a
             inner join kss.v$organograma o
                     on o.cod_organograma = a.cod_organograma_gerencial
             where a.deb_cred = #arguments.deb_cred#
			<cfif Len(Trim(arguments.config_id))>
               and upper(a.config_id) like upper('#arguments.config_id#')
            </cfif>
			<cfif Len(Trim(arguments.ativo))>
               and a.ativo = #arguments.ativo#
            </cfif>                        
			<cfif Len(Trim(arguments.descricao))>
               and upper(a.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by a.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>  
    
   <!--- 
    -- PROPSITO 
    -- Retorna a contabilidade do agregado
    -- Eric 09/11/2010 - CRIADO
    --->		
    <cffunction name="get_contabilidade_agregado" access="remote" returntype="query" output="true">
	    <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ac.contabilizacao_id
                 , (select lpad(ac.cod_centro_custo,4,'0') ||' - '|| cc.centro_custo
                      from kss.v$centro_custo cc
                     where cc.cod_centro_custo = ac.cod_centro_custo
                   ) as centro_custo
                 , ac.historico
                 , ac.valor_debito
                 , ac.valor_credito
              from oper.v$agreg_contabilizacao ac
             inner join oper.v$agreg_contabilizacao_solicit acs
                     on acs.agrupamento_id = ac.agrupamento_id
             where acs.solicitacao_id = #arguments.solicitacao_id#
             order by ac.num_lancamento_contabil
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
</cfcomponent>