<cfcomponent  	displayname="KM&M File Manager"
				extends="_transportes.funcoes.cfc_init">

<cffunction name="getTelefoneTipo" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select telefone_tipo_id,
				   descricao,
				   abreviacao
			  from contatos.v$telefone_tipo
		</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="getMsgTipo" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select tipo_msg_id,
				   descricao,
				   abreviacao
			  from contatos.v$tipo_msg
		</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="getUfs" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select sigla_uf
			  from contatos.v$uf
		</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="getContato" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfargument name="contato_id" required="no" default="">
		<cfargument name="nome" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="municipio" required="no" default="">
		<cfargument name="fone" required="no" default="">
		<cfargument name="INICIAL" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select c.contato_id,
				   c.nome,
				   c.sobrenome,
				   c.apelido,
				   c.particular,
				   c.cargo,
				   c.empresa,
				   nvl(upper(substr(c.empresa, 1, 1)), upper(substr(c.nome, 1, 1))) as inicial,
				   c.url,
				   t.telefone,
				   t.ramal,
				   e.EMAIL,
				   m.USUARIO as msg_instantanea,
				   mt.descricao as tipo_msg,
				   en.endereco,
		           cep.fnc_cidade_completa(en.MUNICIPIO_ID) as municipio,
				   case when f.contato_id is null then 0 else 1 end as possui_foto
			  from contatos.v$contato c
			  left join contatos.v$contato_telefone t
					 on c.CONTATO_ID = t.contato_id
					and t.principal = 1
			  left join contatos.v$contato_foto f
					 on c.contato_id = f.contato_id			   
				left join contatos.v$contato_email e
				   on c.CONTATO_ID = e.contato_id
				  and e.principal = 1
				left join contatos.v$contato_endereco en
				   on c.contato_id = en.contato_id
				  and en.principal = 1
				left join contatos.v$contato_msg_instantanea m
				   on m.contato_id = c.contato_id
				  and m.principal = 1
				left join contatos.v$tipo_msg mt
				   on mt.tipo_msg_id = m.TIPO
			  where 1=1
			<cfif len(trim(arguments.inicial))>
				and nvl(upper(substr(c.empresa, 1, 1)), upper(substr(c.nome, 1, 1))) = '#arguments.inicial#'
			</cfif>
			<cfif len(trim(arguments.contato_id))>
				and c.contato_id = #arguments.contato_id#
			</cfif>
				and ((c.particular = 1 and c.user_insert = user) or (c.particular = 0))
			<cfif len(trim(arguments.empresa))>
				and (1 = 1
				<cfloop list="#arguments.empresa#" index="v_item" delimiters=" ">
					and ( upper(c.empresa) like upper('%#v_item#%') or (c.empresa is null and c.sobrenome is null and upper(c.nome) like upper('%#v_item#%')))
				</cfloop>
				)
			</cfif>
			<cfif len(trim(arguments.fone))>
            and t.contato_id in (select contato_id 
                                 from contatos.v$contato_telefone 
                                 where replace(telefone,'-','') like replace('%#arguments.fone#%','-',''))
			</cfif>
			<cfif len(trim(arguments.municipio))>
				and upper(cep.fnc_cidade_completa(en.MUNICIPIO_ID)) like upper('%#arguments.municipio#%')
			</cfif>
			<cfif len(trim(arguments.nome))>
				and (1 = 1
				<cfloop list="#arguments.nome#" index="v_item" delimiters=" ">
					and upper(c.nome||' '||c.sobrenome) like upper('%#v_item#%')
				</cfloop>
				)
			</cfif>
			ORDER BY  nvl(upper(substr(c.empresa, 1, 1)), upper(substr(c.nome, 1, 1))), c.empresa, c.nome, c.sobrenome
			
		</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="get_inicial" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfargument name="contato_id" required="no" default="">
		<cfargument name="nome" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="municipio" required="no" default="">
		<cfargument name="fone" required="no" default="">
		<cfargument name="INICIAL" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select nvl(upper(substr(c.empresa, 1, 1)), upper(substr(c.nome, 1, 1))) as inicial
			  from contatos.v$contato c
           left join contatos.v$contato_endereco en
				      on c.contato_id = en.contato_id
				     and en.principal = 1
			  where 1=1
			<cfif len(trim(arguments.inicial))>
				and nvl(upper(substr(c.empresa, 1, 1)), upper(substr(c.nome, 1, 1))) = '#arguments.inicial#'
			</cfif>
			<cfif len(trim(arguments.empresa))>
				and (1 = 1
				<cfloop list="#arguments.empresa#" index="v_item" delimiters=" ">
					and ( upper(c.empresa) like upper('%#v_item#%') or (c.empresa is null and c.sobrenome is null and upper(c.nome) like upper('%#v_item#%')))
				</cfloop>
				)
			</cfif>
			<cfif len(trim(arguments.fone))>
            and c.contato_id in (select contato_id 
                                 from contatos.v$contato_telefone 
                                 where replace(telefone,'-','') like replace('%#arguments.fone#%','-',''))
			</cfif>
			<cfif len(trim(arguments.municipio))>
				and upper(cep.fnc_cidade_completa(en.MUNICIPIO_ID)) like upper('%#arguments.municipio#%')
			</cfif>
			<cfif len(trim(arguments.nome))>
				and (1 = 1
				<cfloop list="#arguments.nome#" index="v_item" delimiters=" ">
					and upper(c.nome||' '||c.sobrenome) like upper('%#v_item#%')
				</cfloop>
				)
			</cfif>
         GROUP BY nvl(upper(substr(c.empresa, 1, 1)), upper(substr(c.nome, 1, 1)))
			ORDER BY nvl(upper(substr(c.empresa, 1, 1)), upper(substr(c.nome, 1, 1)))
		</cfquery>  
	<cfreturn qr />
</cffunction>


<cffunction name="getContatoFoto" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfargument name="contato_id" required="yes">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select foto
			  from contatos.v$contato_foto
			 where contato_id = #arguments.contato_id#				
		</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="getContatoTelefone" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfargument name="contato_id" required="yes">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select contato_id,
				   telefone_id,
				   telefone_tipo,
				   telefone,
				   ramal,
				   observacao,
				   principal,
		           t.descricao as tipo_telefone
			  from contatos.v$contato_telefone c
        inner join contatos.v$telefone_tipo t 
                on c.TELEFONE_TIPO = t.telefone_tipo_id
			 where contato_id = #arguments.contato_id#
		</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="getContatoEmail" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfargument name="contato_id" required="yes">
		<cfargument name="email_id" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select contato_id,
				   email_id,
				   email,
				   principal
			  from contatos.v$contato_email
			 where contato_id = #arguments.contato_id#
			  <cfif len(trim(arguments.email_id))>
			  	and email_id = #arguments.email_id#
			  </cfif>
		</cfquery>  
	<cfreturn qr />
</cffunction>

<cffunction name="getContatoMsg" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfargument name="contato_id" required="yes">
		<cfargument name="msg_instantanea_id" required="no" default="">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select m.msg_instantanea_id,
				   m.contato_id,
				   m.tipo,
				   m.usuario,
				   m.principal,
				   t.descricao as tipo_msg
			  from contatos.v$contato_msg_instantanea m
			 inner join contatos.v$tipo_msg t
					 on t.tipo_msg_id = m.TIPO
			 where contato_id = #arguments.contato_id#
			  <cfif len(trim(arguments.msg_instantanea_id))>
			  	and msg_instantanea_id = #arguments.msg_instantanea_id#
			  </cfif>
		</cfquery>  
	<cfreturn qr />
</cffunction>


<cffunction name="getMunicipio" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfargument name="uf" required="yes">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select municipio_id, 
					   municipio, 
					   latitude, 
					   longitude, 
					   pais, 
					   uf_id, 
					   altitude
				  from contatos.v$municipio
			  <cfif len(trim(arguments.uf))>
			  	where uf_id = '#arguments.uf#'
			  <cfelse>
			    where 1=0
			  </cfif>
			  order by municipio
		</cfquery>  
	<cfreturn qr />
</cffunction>


	<cffunction name="getEndereco" access="remote" returntype="query" output="false">
		<cfargument name="cep" displayname="CEP para ser consultado" type="numeric" required="true">
			<cfset arguments.cep = replace(arguments.cep, "-", "", 'ALL')>
			<cfquery name="qr_endereco" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				SELECT log.cep8_log as cep,            
					   initcap(tit.abrev_tipo || '.' || '  ' || log.nome_log) as logradouro,            
					   initcap(decode(loc.tipo_local, 'D', 'Dist. ' || initcap(loc.nome_local),  
					   decode(loc.tipo_local,'P', 'Pov. ' || initcap(loc.nome_local) , initcap(bai.extenso_bai)))) as bairro,            
					   initcap(bai2.extenso_bai) as bairro2,            
					   initcap(loc.nome_local) as local,            
					   uf.sigla_uf as uf, loc.cod_uf, loc.cod_municipio, loc.cod_distrito, loc.cod_dv    
					   , loc.municipio_id
--					   , mun.municipio_id
				  from cep.cep_log log,  cep.cep_tit tit, cep.cep_bai bai, 
					   cep.cep_bai bai2, cep.cep_loc loc, cep.cep_ufs uf
--					   , cep.municipio mun
				 where log.cep8_log = #arguments.cep#
				   and log.chave_local = loc.chave_local     
				   and log.chvbai1_log = bai.chave_bai     
				   and log.chave_local = bai.chave_local     
				   and log.chvbai2_log = bai2.chave_bai (+)      
				   and log.chave_local = bai2.chave_local (+)     
				   and loc.sigla_uf = uf.sigla_uf     
				   and log.chave_tipo = tit.chave_tipo 
--				   and mun.municipio_id = loc.cod_municipio
				   
				   union          
				   
				select decode(loc.sit_local,'0', loc.cep8_local, log.cep8_log)  as cep,             
					   decode(loc.sit_local,'0', 'No codificado - Preencha com seu logradouro',  log.nome_log )  as logradouro,             
					   decode(loc.tipo_local, 'D', 'DIST. ' || loc.nome_local,  decode(loc.tipo_local,'P', 'POV. ' || loc.nome_local , 
					   bai.extenso_bai)) as bairro,             
					   initcap(bai2.extenso_bai),             
					   initcap(decode(loc2.nome_local, null, loc.nome_local, loc2.nome_local)) as local,             
					   uf.sigla_uf as uf, loc.cod_uf, loc.cod_municipio, loc.cod_distrito, loc.cod_dv     
					   , loc.municipio_id
--					   , mun.municipio_id
				  from cep.cep_loc loc, cep.cep_ufs uf, cep.cep_loc 
					   loc2, cep.cep_log log, cep.cep_bai bai, cep.cep_bai bai2
--					   , cep.municipio mun
				 where loc.cep8_local = #arguments.cep#
				   and loc.sigla_uf = uf.sigla_uf       
				   and loc.subor_local =  loc2.chave_local (+)       
				   and loc.chave_local =  log.chave_local (+)       
				   and log.chvbai1_log  =  bai.chave_bai (+)         
				   and log.chave_local = bai.chave_local (+)       
				   and log.chvbai2_log  =  bai2.chave_bai (+)         
				   and log.chave_local = bai2.chave_local (+)         
--				   and mun.municipio_id = loc.cod_municipio
				   
				 union    
				 
				select esp.cep8_esp as cep,            
					   initcap(esp.nome_esp || esp.comple_esp) as logradouro,            
					   initcap(bai.extenso_bai) as bairro,            
					   initcap(loc.nome_local) as local,            
					   initcap(bai.extenso_bai) as bairro,            
					   esp.uf_esp as uf, loc.cod_uf, loc.cod_municipio, loc.cod_distrito, loc.cod_dv  
					   , loc.municipio_id
--					   , mun.municipio_id
				  FROM cep.cep_loc loc, cep.cep_esp esp, cep.cep_bai bai
--				  , cep.municipio mun
				 WHERE esp.cep8_esp = #arguments.cep#
				   and esp.chave_local = loc.chave_local     
				   and esp.chave_bai = bai.chave_bai     
				   and esp.chave_local = bai.chave_local
--				   and mun.municipio_id = loc.cod_municipio
				   
				union    
				
				select agp.cep8_agp as cep,            
					   initcap(agp.nome_agp) as logradouro,            
					   initcap(bai.extenso_bai) as bairro,            
					   initcap(loc.nome_local) as local,            
					   initcap(bai.extenso_bai) as bairro,            
					   agp.uf_agp as uf, loc.cod_uf, loc.cod_municipio, loc.cod_distrito, loc.cod_dv  
					   , loc.municipio_id
--					   , mun.municipio_id
				  FROM cep.cep_loc loc, cep.cep_agp agp, cep.cep_bai bai
--				  , cep.municipio mun
				 WHERE agp.cep8_agp = #arguments.cep#
				   and agp.chave_local = loc.chave_local     
				   and agp.chave_bai = bai.chave_bai     
				   and agp.chave_local = bai.chave_local   			
--				   and mun.municipio_id = loc.cod_municipio
			</cfquery>
		<cfreturn qr_endereco>		
	</cffunction>

<cffunction name="getTipoEndereco" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select endereco_tipo_id, abreviacao, descricao
			  from contatos.v$endereco_tipo		
		</cfquery>  
	<cfreturn qr />
</cffunction>


<cffunction name="getEnderecoContato" displayname="Tarefas" access="remote" returntype="Query" output="true">	  
   <!--- 
   	-- PROPSITO
	-- Seleciona as tarefas em um determinado periodo
	-- NOTAS EXPLICATIVAS
	--  
	-- CRISTOFER 15/08/2005 - criado
	--->			
		<cfargument name="contato_id" required="yes">
		<cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" blockfactor="100">
				select e.contato_id,
					   e.endereco_id,
					   e.endereco,
					   e.endereco_tipo,       
					   te.descricao as tipo_endereco,
					   e.cep,
					   e.municipio_id,
					   mun.municipio,
					   mun.uf_id as uf,
					   e.correspondencia,
					   e.user_insert,
					   e.date_insert,
					   e.user_update,
					   e.date_update,
					   e.site,
					   e.principal
				  from contatos.v$contato_endereco e
				  left join cep.municipio mun
						 on e.municipio_id = mun.municipio_id
				 inner join contatos.v$endereco_tipo te
						 on te.endereco_tipo_id = e.ENDERECO_TIPO
			 where e.contato_id = #arguments.contato_id#
 		</cfquery>  
	<cfreturn qr />
</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os tipos de evento
	-- CRISTOFER  17/04/2006
	--->		
	<cffunction name="get_evento_tipo" access="remote" returntype="query" output="true">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="tipo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tipo_id,
				   descricao
			  from contatos.v$evento_tipo
			 where 1=1
			 <cfif len(trim(arguments.descricao))>
			   and upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			 <cfif len(trim(arguments.tipo_id))>
			   and tipo_id in (#arguments.tipo_id#)
			 </cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os eventos 
	-- CRISTOFER  17/04/2006
	--->		
	<cffunction name="get_evento" access="remote" returntype="query" output="true">
		<cfargument name="evento_id" required="no" default="">
		<cfargument name="tipo_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="data" required="no" default="">
		<cfargument name="mes" required="no" default="">
		<cfargument name="ano" required="no" default="">
		<cfargument name="passados" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.evento_id,
				   e.tipo_id,
				   e.titulo,
				   e.local,
				   e.detalhes,
				   e.data_hora,
				   to_number(to_char(e.data_hora, 'dd')) as dia
			  from contatos.v$evento e
			 inner join contatos.v$evento_tipo et
			         on et.tipo_id = e.tipo_id
			 where 1=1
			 <cfif len(trim(arguments.titulo))>
			   and upper(e.titulo) like upper('%#arguments.titulo#%')
			 </cfif>
			 <cfif len(trim(arguments.evento_id))>
			   and e.evento_id in (#arguments.evento_id#)
			 </cfif>
			 <cfif len(trim(arguments.tipo_id))> 
			   and e.tipo_id in (#arguments.tipo_id#)
			 </cfif>
			 <cfif arguments.passados neq 1>
			   and trunc(e.data_hora) >= trunc(sysdate)
			 </cfif>
			 <cfif len(trim(arguments.mes))>
			   and to_number(to_char(e.data_hora, 'mm')) = #arguments.mes#
			 </cfif>			 
			 <cfif len(trim(arguments.ano))>
			   and to_number(to_char(e.data_hora, 'yyyy')) = #arguments.ano#
			 </cfif>
			 
			 <cfif len(trim(arguments.data))>
			   and trunc(e.data_hora) = to_date('#arguments.data#', 'dd/mm/yyyy')
			 </cfif>
			 order by data_hora
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>  	
	
	<!--- 
	-- PROPSITO 
	-- Busca os feriados
	-- CRISTOFER  17/04/2006
	--->		
	<cffunction name="get_feriados" access="remote" returntype="query" output="true">
		<cfargument name="mes" required="no" default="">
		<cfargument name="ano" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select feriado_id, 
				   data,
				   descricao,
				   to_number(to_char(data, 'dd')) as dia
			  from kss.feriado_febraban t
			 where cod_municipio is null
			   and sigla_uf is null
			 <cfif len(trim(arguments.mes))>
			   and to_number(to_char(data, 'mm')) = #arguments.mes#
			 </cfif>
			 <cfif len(trim(arguments.ano))>
			   and to_number(to_char(data, 'yyyy')) = #arguments.ano#
			 </cfif>
			 order by data	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>