<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPÓSITO 
	-- Busca funcionario
	-- GUTO 28/05/2007
	--->		
	<cffunction name="get_funcionario_matricula" access="remote" returntype="query" output="true">
		<cfargument name="num_matricula" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="cnpj_cpf" required="no" default="">
        <cfargument name="liberacao_alcada" required="no" default="0"><!--- GUSTAVOC 20090 4/3 - Controle de usuários para liberação de ADV (WEB)  --->
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select f.num_matricula
                  , p.cliente as nome
                  , f.cod_pessoa
                  , p.cnpj_cpf
              <cfif arguments.liberacao_alcada eq "1">
                  , alc.valor_alcada
              </cfif>
               from kss.v$funcionario_matr_atual f
              inner join kss.v$pessoa p
                      on p.cod_pessoa = f.cod_pessoa 
              <cfif arguments.liberacao_alcada eq "1">
                 inner join kss.v$kss_usuarios u
                         on u.cod_pessoa = p.cod_pessoa
                 inner join oper.v$alcada_liberacao_controle alc
                         on alc.usuario = u.usuario
              </cfif>
              
              where 1=1
              <cfif Len(Trim(arguments.cnpj_cpf))>
                and p.cnpj_cpf = '#arguments.cnpj_cpf#'
              </cfif>
              <cfif Len(Trim(arguments.cod_pessoa))>
                and f.cod_pessoa = #arguments.cod_pessoa#
              </cfif>
              <cfif Len(Trim(arguments.num_matricula))>
                and f.num_matricula = '#arguments.num_matricula#'
              </cfif>
              
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	<!--- 
	-- PROPÓSITO 
	-- Busca plano de contas 
	-- GUTO 28/05/2007
	--->		
	<cffunction name="get_conta_contabil" access="remote" returntype="query" output="true">
		<cfargument name="apelido" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
     select descricao, apelido
       from contab.v$contab_plano_de_contas c
      where apelido is not null
        and c.ano_plano = to_char(sysdate,'yyyy')
			 <cfif len(trim(arguments.apelido))>
		        and upper(apelido) like '%#UCase(arguments.apelido)#%'
			 </cfif>
			  <cfif len(trim(arguments.descricao))>
			   and  upper(descricao) like upper('%#arguments.descricao#%')
			 </cfif>
			  order by descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
 
	<!--- 
	-- PROPÓSITO 
	-- Busca as ADV-Viagem
	-- kathlyn  18/01/2008
	--->
    <cffunction name="get_adv" access="remote" returntype="query" output="true">
       <cfargument name="ADV_ID" required="no" default="">
       <cfargument name="DATA_INICIO" required="no" default="">
       <cfargument name="DATA_FINAL" required="no" default="">
       <cfargument name="NUM_ROMANEIO" required="no" default="">
       <cfargument name="COD_PESSOA" required="no" default="">
       <cfargument name="TODOS" required="no" default="0"/>
       <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.adv_id,
               t.adv_tipo,
               t.cod_pessoa_gerente,
               to_char(t.data_emissao,'dd/mm/yyyy hh24:mi') as data_emissao,
               t.valor,
               cc.nome,
               p.cliente,
                  p.cnpj_cpf,
               cc.identificador,
               (select f.num_matricula 
                  from kss.v$funcionario_matr_atual f 
                 where f.cod_pessoa = t.cod_pessoa_gerente) as cod_registro_gerente ,
               cc.cod_registro,
               cc.cod_pessoa,
               t.num_romaneio,
               to_char(t.data_impressao,'dd/mm/yyyy hh24:mi') as data_impressao,
               to_char(t.data_cancelamento,'dd/mm/yyyy hh24:mi') as data_cancelamento,
               t.contas_pagar_id,
               t.motivo_cancel,
               nvl2(t.data_cancelamento, 'Sim', 'N&atilde;o') as cancelado,
               t.user_insert,
               case
                 when t.data_impressao is null then
                  0
                 else
                  1
               end permite_imprimir,
               case
                 when t.data_emissao + 1 / 24 > sysdate and t.data_cancelamento is null then
                  1
                 else
                  0
               end permite_cancelar,
               case
                 when t.data_cancelamento is null then
                  0
                 else
                  1
               end cancel,
               case t.adv_tipo 
                    when 0 then 'Autorizo descontar em folha de pagamento o valor abaixo, referente a Adiantamento de Viagem (ADV), solicitado por mim e utilizado para fins pessoais'
                    else t.observacao 
                 end as observacao 
            from oper.v$adv t
            inner join (select cc.cod_pessoa,
                            cc.cod_conta,
                            kss.pkg_pessoa.fnc_get_cliente(cc.cod_pessoa, 1) as nome,
                            kss.pkg_pessoa.fnc_get_identificador(cc.cod_pessoa) as identificador,
                            (select max(mrh.cod_registro) keep(dense_rank last order by mrh.data_inicio)
                               from oper.v$motorista_reg_historico mrh
                              where mrh.cod_pessoa = cc.cod_pessoa) as cod_registro
                       from finan.v$ccorrente cc
                      where cc.modalidade_id between 12 and 14) cc on cc.cod_conta =
                                                                      t.cod_conta
            left join kss.v$pessoa p on p.cod_pessoa = t.cod_pessoa_gerente
            where t.adv_tipo = 1
            <cfif arguments.TODOS eq 0>
            and t.user_insert like upper(user)
            </cfif>
            <cfif len(trim(arguments.DATA_INICIO)) and len(trim(arguments.DATA_FINAL))>
             and trunc(t.data_emissao) between to_date('#arguments.DATA_INICIO#', 'dd/mm/yyyy') and to_date('#arguments.DATA_FINAL#', 'dd/mm/yyyy') 
             and rownum <=100
            </cfif> 
            <cfif len(trim(arguments.ADV_ID))>
            and t.adv_id = '#arguments.Adv_id#'
            </cfif>       
            <cfif Len(Trim(arguments.NUM_ROMANEIO))>
            and t.num_romaneio = #arguments.NUM_ROMANEIO#
            </cfif>
            <cfif Len(Trim(arguments.COD_PESSOA))>
            and cc.cod_pessoa = #arguments.COD_PESSOA#
            </cfif>
            order by t.adv_id
        </cfquery>                   
      <cfreturn qr_result>
    </cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca as C/C do motorista
	-- kathlyn  18/01/2008
	--->
    <cffunction name="get_cc_adv_romaneio" access="remote" returntype="query" output="true">
      <cfargument name="ADV_ID" required="no">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select t.adv_id,
                           t.adv_tipo,
                           t.valor,
                           to_char(t.data_emissao,'dd/mm/yyyy hh24:mi') as data_emissao,
                           nome,
                           m.centro_custo,
                           identificador,
                           t.num_romaneio,
                           t.cod_centro_custo,
                           t.data_cancelamento, 
                           to_char(t.data_encerramento,'dd/mm/yyyy hh24:mi') as  data_encerramento, 
                           t.user_encerramento,
                           nvl((select min(c.cod_centro_custo)
                                 from fiscal.v$conhecimento c
                                where c.num_romaneio = t.num_romaneio),
                               (select min(o.cod_centro_custo)
                                  from fiscal.v$intc_conhecimento i
                                 inner join oper.v$romaneio_intc_conhecimento ri 
                                         on ri.conhecimento_id = i.conhecimento_id
                                 inner join kss.v$organograma o 
                                         on o.cod_organograma = i.cod_organograma
                                 where ri.num_romaneio = t.num_romaneio)) as cod_centro_custo
                      from oper.v$adv t
                     inner join (select cc.cod_pessoa,
                                        cc.cod_conta,
                                        kss.pkg_pessoa.fnc_get_cliente(cc.cod_pessoa, 1) as nome,
                                        kss.pkg_pessoa.fnc_get_identificador(cc.cod_pessoa) as identificador,
                                        (select max(mrh.cod_registro) keep(dense_rank last order by mrh.data_inicio)
                                           from oper.v$motorista_reg_historico mrh
                                          where mrh.cod_pessoa = cc.cod_pessoa) as cod_registro
                                   from finan.v$ccorrente cc
                                  where cc.modalidade_id between 12 and 14) cc on cc.cod_conta =
                                                                                  t.cod_conta
                     inner join kss.v$centro_custo m 
                             on m.cod_centro_custo = t.cod_centro_custo
                     where t.adv_tipo = 1
                     <cfif len(trim(arguments.ADV_ID))>
                     and t.adv_id = '#arguments.Adv_id#'
                     </cfif> 
                     order by t.adv_id
             </cfquery>
      <cfreturn qr_result>
    </cffunction>
	<!--- 
    -- PROPÓSITO
    -- Verificar se já existe uma ADV.
    -- kathlyn 21/01/2008 17:21:26 - CRIADO
    --->
    <cffunction name="verifica_romaneio_web" displayname="Verificar se já existe uma ADV" access="remote" returntype="struct" output="true">
      <cfargument name="num_romaneio" required="yes">
      <cftry>
        <cftransaction action='begin'>
          <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_adv.prc_verifica_romaneio_web" username="#session.usuario#" password="#session.senha#">
            <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_num_romaneio" value="#arguments.num_romaneio#">
          </cfstoredproc>
          <cfset retorno.erro = false>
          <cfset retorno.mensagem = JSStringFormat('')>
        </cftransaction>
        <cfcatch>
          <cftransaction action='rollback'/><cfset retorno.erro = true>
          <cfset retorno.mensagem = cfcatch.Detail>
        </cfcatch>
      </cftry>
      <cfreturn retorno />
    </cffunction>
	<!--- 
    -- PROPÓSITO
    -- Busca motoristas ligados a viagem.
    -- kathlyn 21/01/2008 17:21:26 - CRIADO
    --->
    <cffunction name="get_motorista_romaneio" access="remote" returntype="query" output="true">
      <cfargument name="num_romaneio" required="no">
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select p.cod_pessoa
                          ,p.cliente as nome
                       ,oper.pkg_global.fnc_get_cod_funcionario(p.cod_pessoa) as cod_funcionario
                            from oper.v$romaneio_hist_veiculo rh
                                inner join kss.v$pessoa p 
                                        on p.cod_pessoa = rh.cod_pessoa
                            where rh.NUM_ROMANEIO = '#arguments.num_romaneio#'
            </cfquery>
      <cfreturn qr_result>
    </cffunction>
<!--- 
-- PROPÓSITO
-- Verificar se já existe uma ADV impressa.
-- kathlyn 21/01/2008 17:21:26 - CRIADO
--->
<cffunction name="verifica_impressao" displayname="Verificar se já existe uma ADV impressa" access="remote" returntype="struct" output="true">
  <cfargument name="adv_id" required="yes">
  <cftry>
    <cftransaction action='begin'>
      <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_adv.prc_imprimir_adv" username="#session.usuario#" password="#session.senha#">
        <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_adv_id" value="#arguments.adv_id#">
      </cfstoredproc>
      <cfset retorno.erro = false>
      <cfset retorno.mensagem = JSStringFormat('')>
    </cftransaction>
    <cfcatch>
      <cftransaction action='rollback'/><cfset retorno.erro = true>
      <cfset retorno.mensagem = cfcatch.Detail>
    </cfcatch>
  </cftry>
  <cfreturn retorno />
</cffunction>
<!--- 
-- PROPÓSITO
-- Busca classe e código contábil.
-- kathlyn 21/01/2008 17:21:26 - CRIADO
--->
<cffunction name="get_classe_cod_contabil" access="remote" returntype="query" output="true">
  <cfargument name="num_romaneio" required="no">
  <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.classe_id,
            	      a.descricao,
                   a.cod_contabil, c.descricao as historico_contab
  			from oper.v$adv_classe a
     inner join contab.v$contab_plano_de_contas c 
             on c.apelido = a.cod_contabil
             and c.ano_plano = to_char(sysdate,'yyyy')
     where a.classe_id <> 0
		</cfquery>
  <cfreturn qr_result>
</cffunction>
<!--- 
-- PROPÓSITO
-- Busca dados da lista de despesas.
-- kathlyn 21/01/2008 17:21:26 - CRIADO
--->
<cffunction name="get_dados_lista" access="remote" returntype="query" output="true">
  <cfargument name="ADV_ID" required="no">
  <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select  d.despesa_id,
                       d.classe_id,
                       d.valor,
                       d.complemento,
                       d.cod_contabil,
                       d.cod_centro_custo,
                       d.cod_emitente,
                       d.num_docto,
                       p.cliente,
                       c.descricao,
                       emit_cnpj_cpf, pc.descricao as historico_contab
                  from oper.v$adv_despesa d
                 inner join kss.v$pessoa p 
                         on p.cod_pessoa = d.cod_emitente
                 inner join oper.v$adv_classe c 
                         on c.classe_id = d.classe_id
                 inner join contab.v$contab_plano_de_contas pc 
                         on pc.apelido = c.cod_contabil
                         and pc.ano_plano = to_char(sysdate,'yyyy')        
                where adv_id = '#arguments.ADV_ID#'
		</cfquery>
  <cfreturn qr_result>
</cffunction>

<!--- 
-- PROPÓSITO
-- Imprime ADV.
-- kathlyn 21/01/2008 17:21:26 - CRIADO
--->
<cffunction name="print_adv" access="remote" returntype="query" output="true">
  <cfargument name="P_ADV_ID" required="yes">
  <cfargument name="cod_pessoa" required="no" default="">  
  <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select a.adv_id
                    	 , cc.nome
                         , cc.cod_registro
                         , case a.adv_tipo
                              when 0 then 'Pessoal'
                              when 1 then 'Viagem'
                              when 2 then 'Administrativa'
                           end as tipo_adv
                         , a.num_romaneio
                         , replace(trim(r.carregamento||'   '||r.destino),'   ',' -> ') as descricao_romaneio
                         ,  (select v.cod_veiculo
          					from oper.v$veiculo v
         					where v.placa = r.placa_controle) as frota
                         , trunc(a.data_emissao) as data_emissao
                         , a.valor
                         , finan.pkg_financeiro.fnc_extenso(a.valor) as valor_extenso
                         , lpad(extract(day from a.data_emissao),2,'0') as dia
                         , lpad(extract(month from a.data_emissao),2,'0') as mes
                         , extract(year from a.data_emissao) as ano
                         , (select f.num_matricula 
                              from kss.v$funcionario_matr_atual f 
                             where f.cod_pessoa = a.cod_pessoa_gerente) as cod_registro_gerente 
                         , kss.pkg_pessoa.fnc_get_cliente(a.cod_pessoa_gerente) as gerente
                         , (select (select f.num_matricula from kss.v$funcionario_matr_atual f where f.cod_pessoa = us.cod_pessoa) 
                              from kss.kss_usuarios us 
                             where us.usuario = user) as cod_registro_usuario 
                         , (select kss.pkg_pessoa.fnc_get_cliente(us.cod_pessoa) from kss.kss_usuarios us where us.usuario = user) as nome_usuario
                         , (select kss.pkg_pessoa.fnc_get_cliente(p.cod_pessoa)||chr(13)||chr(10)
                                 ||p.logradouro||' - '||nvl2(p.numero,'nº '||p.numero,'s/n')||', '||p.bairro||chr(13)||chr(10)
                                 ||p.municipio||' - '||p.uf
                              from kss.v$pessoa_endereco_padrao p
                             where p.cod_pessoa = <cfif Len(Trim(arguments.cod_pessoa))>#arguments.cod_pessoa#<cfelse>a.cod_pessoa_filial</cfif>) as dados_filial
                         , nvl2(a.adv_id_origem,'X',null) as xis
                         , nvl2(a.adv_id_origem,'Ajuste de saldo '||case a.adv_tipo when 0 then 'devedor' else 'credor' end||' ref. ADV nº'||a.adv_id_origem,null) as mensagem_acerto
                         , case a.adv_tipo 
                                when 0 then 'Autorizo descontar em folha de pagamento o valor abaixo, referente a Adiantamento de Viagem (ADV), solicitado por mim e utilizado para fins pessoais'
                                else a.observacao 
                             end as observacao                          
                      from oper.v$adv a
                     inner join (select cc.cod_pessoa, cc.cod_conta
                                      , kss.pkg_pessoa.fnc_get_cliente(cc.cod_pessoa,1) as nome
                                      , kss.pkg_pessoa.fnc_get_identificador(cc.cod_pessoa) as identificador
                                      , (select max(mrh.cod_registro) keep (dense_rank last order by mrh.data_inicio)
                                           from oper.v$motorista_reg_historico mrh
                                          where mrh.cod_pessoa = cc.cod_pessoa) as cod_registro
                                   from finan.v$ccorrente cc
                                  where cc.modalidade_id between 12 and 14
                                ) cc
                        on cc.cod_conta = a.cod_conta
                      left join oper.v$romaneio r
                        on r.num_romaneio = a.num_romaneio
                     where a.adv_id = '#arguments.P_ADV_ID#'
		</cfquery>
  <cfreturn qr_result>
</cffunction>

	<!--- 
    -- PROPÓSITO
    -- Seleciona Romaneios.
    -- kathlyn 21/01/2008 17:21:26 - CRIADO
    --->
    <cffunction name="get_romaneios" access="remote" returntype="query" output="true">
      <cfargument name="NUM_ROMANEIO" required="no" default="">
      <cfargument name="COD_VEICULO" required="no" default="">
      <cfargument name="DATA_INICIO" required="no" default="">
      <cfargument name="DATA_FINAL" required="no" default="">
       <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                   with x as
                      (select r.num_romaneio, r.data_inicio, r.data_termino, r.remetente, r.destinatario,
                              r.carregamento, r.destino
                         from oper.v$romaneio_aberto r
                         where r.data_inicio >= sysdate - 60
                         <cfif len(trim(arguments.DATA_INICIO)) and len(trim(arguments.DATA_FINAL))>
                             and trunc(r.data_inicio) between to_date('#arguments.DATA_INICIO#', 'dd/mm/yyyy') and to_date('#arguments.DATA_FINAL#', 'dd/mm/yyyy') 
                             and rownum <=100
                         </cfif>
                        <cfif len(trim(arguments.NUM_ROMANEIO))>
                           and r.num_romaneio like '%#arguments.NUM_ROMANEIO#%'
                           </cfif>
                        <cfif len(trim(arguments.COD_VEICULO))>
                           and r.placa_controle = oper.pkg_veiculo.fnc_get_placa('#arguments.COD_VEICULO#')
                        </cfif>
                      ) 
                    select num_romaneio, data_inicio, data_termino, remetente, destinatario, carregamento, destino,
                           rtrim(kss.fnc_concat_all(kss.to_concat_expr(placa_tracao, ', ')),', ') as placa_tracao,
                           rtrim(kss.fnc_concat_all(kss.to_concat_expr(placa_carreta, ', ')),', ') as placa_carreta
                      from (
                             select distinct x.num_romaneio, x.data_inicio, x.data_termino, x.remetente, x.destinatario,
                                    '' as placa_tracao, v.placa_referencia as placa_carreta,
                                    x.carregamento, x.destino
                                from x
                               inner join oper.v$romaneio_hist_veiculo v
                                       on v.num_romaneio = x.num_romaneio
                    
                              union all
                    
                             select distinct x.num_romaneio, x.data_inicio, x.data_termino, x.remetente, x.destinatario,
                                    v.placa_controle as placa_tracao, '' as placa_carreta,
                                    x.carregamento, x.destino
                                from x
                               inner join oper.v$romaneio_hist_veiculo v
                                       on v.num_romaneio = x.num_romaneio
                           )
                     group by num_romaneio, data_inicio, data_termino, remetente, destinatario,
                                                      carregamento, destino
                     order by num_romaneio
                      
           </cfquery>
      <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPÓSITO
	-- Retorna as tipos de despesas cadastradas (RAP)
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 14/05/2009
	--->
	<cffunction name="get_tipo_despesa_rap" displayname="Retorna as despesas cadastradas (RAP)" output="true" returntype="query" access="remote">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rdt.despesa_tipo_id,
                   rdt.descricao
              from oper.v$rap_despesa_tipo rdt
             where 1 = 1
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPÓSITO
	-- Retorna as despesas cadastradas (RAP)
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 14/05/2009
	--->
	<cffunction name="get_despesa_rap" displayname="Retorna as despesas cadastradas (RAP)" output="true" returntype="query" access="remote">
		<cfargument name="despesa_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="despesa_tipo_id" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.despesa_id,
                   to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao,
                   t.despesa_tipo_id,
                   rdt.descricao as tipo,
                   t.municipio_id,
                   m.municipio,
                   m.uf_id as uf,
                   t.adv_id,
                   t.num_romaneio,
                   t.cod_pessoa_filial,
                   un.cod_unidade_negocio||' - '||un.unidade_negocio as filial,
                   t.remetente,       
                   t.rem_municipio_id,
                   t.remetente||' / '||mr.municipio||' - '||mr.uf_id as rem_descricao,
                   t.destinatario,
                   t.dest_municipio_id,
                   t.destinatario||' / '||md.municipio||' - '||md.uf_id as dest_descricao,
                   t.valor_servico,
                   t.placa,
                   vm.marca||' / '||vmo.modelo as marca_modelo,
                   t.cod_motorista,
                   mot.cnpj_cpf as mot_cnpj_cpf,
                   mot.razao_social as mot_razao_social,
                   t.cod_proprietario,
                   prop.cnpj_cpf||' - '||prop.razao_social as proprietario,
                   prop.tipo_pessoa,
                   t.cod_beneficiario,
                   t.ben_cnpj_cpf,
                   t.ben_razao_social,
                   t.ben_nit,
                   to_char(t.ben_data_nascimento, 'dd/mm/yyyy') as ben_data_nascimento,
                   t.ben_cart_ident_num,
                   t.ben_cart_ident_orgao,
                   t.data_cancelamento,
                   nvl2(t.data_cancelamento, 'Cancelado', decode(t.situacao, 0, 'Emitido', 1, 'Quitado')) as situacao,
                   t.num_nota_id,
                   nf.num_nota_fiscal,
                   nf.calc_valor_total_nota,
                   nf.emit_razao_social as emitente
              from oper.v$rap_despesa t
             inner join cep.municipio m
                     on m.municipio_id = t.municipio_id
             inner join oper.v$romaneio r
                     on r.num_romaneio = t.num_romaneio
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = t.cod_pessoa_filial
             inner join cep.municipio mr
                     on mr.municipio_id = t.rem_municipio_id                       
             inner join cep.municipio md
                     on md.municipio_id = t.dest_municipio_id
             inner join oper.v$veiculo v
                     on v.placa = t.placa
             inner join oper.v$veiculo_marca vm
                     on vm.marca_id = v.marca_id
             inner join oper.v$veiculo_modelo vmo
                     on vmo.marca_id = v.marca_id
                    and vmo.modelo_id = v.modelo_id         
             inner join kss.v$pessoa mot
                     on mot.cod_pessoa = t.cod_motorista
             inner join kss.v$pessoa prop
                     on prop.cod_pessoa = t.cod_proprietario
              left join oper.v$rap_despesa_tipo rdt
                     on rdt.despesa_tipo_id = t.despesa_tipo_id 
              left join kss.v$pessoa ben
                     on ben.cod_pessoa = t.cod_beneficiario        
              left join fiscal.v$nf_terceiro nf
                     on nf.num_nota_id = t.num_nota_id
             where 1 = 1
			<cfif Len(Trim(arguments.despesa_id))>
               and t.despesa_id = #arguments.despesa_id#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(t.data_emissao) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(t.data_emissao) <= '#arguments.data_fim#'
            </cfif>
            <cfif Len(Trim(arguments.despesa_tipo_id))>
               and t.despesa_tipo_id = #arguments.despesa_tipo_id#
            </cfif>
            <cfif Len(Trim(arguments.num_romaneio))>
               and t.num_romaneio = #arguments.num_romaneio#
            </cfif>
             order by t.data_emissao, t.despesa_id
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO
	-- Retorna o romaneio cadastrado para um ADV
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 14/05/2009
	--->
	<cffunction name="get_adv_romaneio" displayname="Retorna o romaneio cadastrado para um ADV" output="true" returntype="query" access="remote">
		<cfargument name="adv_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.adv_id
                 , t.num_romaneio
              from oper.v$adv t
             where t.adv_tipo = 1
               and t.data_cancelamento is null
               and t.data_encerramento is null
               and t.adv_id = #arguments.adv_id#
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO
	-- Retorna os dados de um romaneio cadastrado para um ADV
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 14/05/2009
	--->
	<cffunction name="get_dados_adv_romaneio" displayname="Retorna os dados de um romaneio cadastrado para um ADV" output="true" returntype="query" access="remote">
		<cfargument name="num_romaneio" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio,
                   r.cod_pessoa_filial,
                   un.cod_unidade_negocio ||' - '|| un.unidade_negocio as filial,
                   r.remetente,
                   r.destinatario,
                   r.org_municipio_id as rem_municipio_id,
                   r.dest_municipio_id as dest_municipio_id,
                   r.remetente ||' / '|| m1.municipio ||' - '|| m1.uf_id as rem_descricao, 
                   r.destinatario ||' / '|| m2.municipio ||' - '|| m2.uf_id as dest_descricao,
                   r.placa_controle as placa,
                   vm.marca||' / '||vmo.modelo as marca_modelo,
                   (select p.cpf||p.cpf_dv
                      from oper.v$romaneio_hist_veiculo v
                     inner join kss.v$pessoa_fisica p
                             on p.cod_pessoa = v.cod_pessoa
                     where v.num_romaneio = r.num_romaneio 
                       and rownum = 1) as cpf_motorista,
                   (select vp.cod_pessoa
                      from oper.v$veiculo_proprietario vp
                     where vp.placa = r.placa_controle 
                       and nvl(vp.data_fim,sysdate) = (select max(nvl(data_fim,sysdate)) 
                                                         from oper.v$veiculo_proprietario t 
                                                        where t.placa = vp.placa)) as cod_proprietario,
                   (select p.cnpj_cpf||' - '||p.razao_social
                      from oper.v$veiculo_proprietario vp
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = vp.cod_pessoa
                     where vp.placa = r.placa_controle 
                       and nvl(vp.data_fim,sysdate) = (select max(nvl(data_fim,sysdate)) 
                                                         from oper.v$veiculo_proprietario t 
                                                        where t.placa = vp.placa)) as proprietario,
                   (select p.tipo_pessoa
                      from oper.v$veiculo_proprietario vp
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = vp.cod_pessoa
                     where vp.placa = r.placa_controle 
                       and nvl(vp.data_fim,sysdate) = (select max(nvl(data_fim,sysdate)) 
                                                         from oper.v$veiculo_proprietario t 
                                                        where t.placa = vp.placa)) as tipo_pessoa
              from oper.v$romaneio r
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = r.cod_pessoa_filial
             inner join oper.v$veiculo v
                     on v.placa = r.placa_controle         
              left join oper.v$veiculo_marca vm
                     on vm.marca_id = v.marca_id
              left join oper.v$veiculo_modelo vmo
                     on vmo.marca_id = v.marca_id
                    and vmo.modelo_id = v.modelo_id
              left join cep.municipio m1
                     on m1.municipio_id = r.org_municipio_id
              left join cep.municipio m2
                     on m2.municipio_id = r.dest_municipio_id
             where r.num_romaneio = #arguments.num_romaneio#
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO
	-- Retorna os dados de uma determinada NF Terceiro
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 14/05/2009
	--->
	<cffunction name="get_nf_terceiro" displayname="Retorna os dados de uma determinada NF Terceiro" output="true" returntype="query" access="remote">
		<cfargument name="num_nota_id" required="no" default="">
        <cfargument name="num_nota_fiscal" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.num_nota_id,
                   t.num_nota_fiscal,
                   t.calc_valor_total_nota,
                   p.razao_social as emitente
              from fiscal.v$nf_terceiro t
             inner join kss.v$pessoa p
                on p.cod_pessoa = t.cod_emitente
             where 1 = 1
            <cfif Len(Trim(arguments.num_nota_id))>
               and t.num_nota_id = #arguments.num_nota_id#
            </cfif>
			<cfif Len(Trim(arguments.num_nota_fiscal))>
               and t.num_nota_fiscal like '#arguments.num_nota_fiscal#%'
            </cfif>
               and rownum <= 10
             order by t.num_nota_fiscal asc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO
	-- Retorna os dados de uma despesa (RAP) para a impressão
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 14/05/2009
	--->
	<cffunction name="get_despesa_rap_print" displayname="Retorna os dados de uma despesa (RAP) para a impressão" output="true" returntype="query" access="remote">
		<cfargument name="despesa_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select x.despesa_id
                  , x.tipo
                  , x.data_emissao
                  , x.localidade
                  , x.num_romaneio
                  , x.num_conhecimento
                  , x.filial
                  , x.cpf_cnpj_empresa
                  , x.cliente
                  , x.rem_descricao
                  , x.dest_descricao
                  , x.valor_servico_extenso
                  , x.valor_servico
                  , x.descricao_servico
                  , x.placa
                  , x.marca_modelo
                  , x.motorista
                  , x.proprietario
                  , x.ben_cnpj_cpf
                  , x.ben_razao_social
                  , x.ben_nit
                  , x.ben_data_nascimento
                  , x.ben_cart_ident_num
                  , x.ben_cart_ident_num
                  , x.ben_cart_ident_orgao
                  , x.desconto_irrf
                  , x.desconto_inss
                  , x.desconto_sest
                  , x.desconto_senat
                  , x.total_descontos
                  , (x.valor_servico -(x.desconto_irrf + x.desconto_inss + x.desconto_sest + x.desconto_senat)) as valor_liquido
               from(
                     select t.despesa_id
                          , dt.descricao as tipo
                          , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                          , m.municipio ||' - '|| m.uf_id as localidade
                          , t.num_romaneio 
                          , (select kss.fnc_concat_all(distinct kss.to_concat_expr(c.num_conhecimento, ', '))
                               from fiscal.v$conhecimento c
                              where c.num_romaneio = t.num_romaneio
                            ) as num_conhecimento
                          , un.cod_unidade_negocio||' - '||un.unidade_negocio as filial
                          , (select p.identificador
                               from kss.v$pessoa p
                              where p.cod_pessoa = un.cod_pessoa
                            ) as cpf_cnpj_empresa
                          , kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa_filial) as cliente
                          , t.remetente||' / '||mr.municipio||' - '||mr.uf_id as rem_descricao
                          , t.destinatario||' / '||md.municipio||' - '||md.uf_id as dest_descricao
                          , '(' || kss.pkg_string.fnc_extenso(t.valor_servico) || ')' as valor_servico_extenso
                          , rpa.descricao_servico
                          , t.valor_servico
                          , t.placa
                          , vm.marca||' / '||vmo.modelo as marca_modelo
                          , mot.razao_social as motorista
                          , prop.razao_social as proprietario
                          , t.ben_cnpj_cpf
                          , t.ben_razao_social
                          , t.ben_nit
                          , t.ben_data_nascimento
                          , t.ben_cart_ident_num
                          , t.ben_cart_ident_orgao
                          , nvl((select rpai.valor
                                   from folha.v$recibo_rpa_it rpai
                                  inner join folha.v$evento_ci ec
                                     on rpai.evento_id = ec.evento_id
                                  where rpai.rpa_id = rpa.rpa_id
                                    and ec.evento_id = 3),0) as desconto_irrf
                          , nvl((select rpai.valor
                                   from folha.v$recibo_rpa_it rpai
                                  inner join folha.v$evento_ci ec
                                     on rpai.evento_id = ec.evento_id
                                  where rpai.rpa_id = rpa.rpa_id
                                    and ec.evento_id = 2),0) as desconto_inss
                          , nvl((select rpai.valor
                                   from folha.v$recibo_rpa_it rpai
                                  inner join folha.v$evento_ci ec
                                     on rpai.evento_id = ec.evento_id
                                  where rpai.rpa_id = rpa.rpa_id
                                    and ec.evento_id = 4),0) as desconto_sest
                          , nvl((select rpai.valor
                                   from folha.v$recibo_rpa_it rpai
                                  inner join folha.v$evento_ci ec
                                     on rpai.evento_id = ec.evento_id
                                  where rpai.rpa_id = rpa.rpa_id
                                    and ec.evento_id = 5),0) as desconto_senat
                          , rpa.total_descontos as total_descontos
                  		  , rpa.valor_liquido as valor_liquido                       
                       from oper.v$rap_despesa t
                      inner join oper.v$rap_despesa_tipo dt
                              on dt.despesa_tipo_id = t.despesa_tipo_id
                      inner join cep.municipio m
                              on m.municipio_id = t.municipio_id
                      inner join oper.v$romaneio r
                              on r.num_romaneio = t.num_romaneio
                      inner join kss.v$unidade_negocio un
                              on un.cod_pessoa = t.cod_pessoa_filial
                      inner join cep.municipio mr
                              on mr.municipio_id = t.rem_municipio_id                       
                      inner join cep.municipio md
                              on md.municipio_id = t.dest_municipio_id
                      inner join oper.v$veiculo v
                              on v.placa = t.placa
                      inner join oper.v$veiculo_marca vm
                              on vm.marca_id = v.marca_id
                      inner join oper.v$veiculo_modelo vmo
                              on vmo.marca_id = v.marca_id
                             and vmo.modelo_id = v.modelo_id         
                      inner join kss.v$pessoa mot
                              on mot.cod_pessoa = t.cod_motorista
                      inner join kss.v$pessoa prop
                              on prop.cod_pessoa = t.cod_proprietario
                       left join kss.v$pessoa ben
                              on ben.cod_pessoa = t.cod_beneficiario   
                       left join folha.v$recibo_rpa rpa
                              on rpa.rpa_id = t.num_rpa        
                      where t.despesa_id = #arguments.despesa_id#
               )x
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
</cfcomponent>