<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna as solicitaes de compras de acordo com o filtro selecionado
    -- ANDERSON 04/12/2009 - CRIADO
    --->		
    <cffunction name="get_solicitacoes_compras" access="remote" returntype="query" output="true">
    	<cfargument name="num_controle" required="no" default="">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="cod_pessoa_fornecedor" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select s.solicitacao_id, s.num_controle, s.titulo, o.cod_pessoa as cod_pessoa_filial,
            	   to_char(s.data_emissao,'dd/mm/yyyy hh24:mi') as data_emissao, 
                   to_char(s.data_emissao + sp.numero_horas/24,'dd/mm/yyyy hh24:mi') as data_previsao,
                   case
                      -- ainda no tem cotao
                      when s.situacao_id < 4 then
                         case
                            when s.data_emissao + sp.numero_horas/24 > sysdate then 'Dentro do Prazo'
                            else 'Atrasada'
                         end
                      -- rejeitada   
                      when s.situacao_id = 7 then ''  
                      -- cotado     
                      else  
                         case
                            when s.data_emissao + sp.numero_horas/24 > nvl(compras.pkg_compras.fnc_max_data_cotacao(s.solicitacao_id), sysdate) then 'Dentro do Prazo'
                            else 'Atrasada'
                         end
                   end status_previsao
                   ,oper.pkg_global.fnc_get_cod_funcionario(s.cod_pessoa_emissao) as cod_funcionario
                   ,kss.pkg_pessoa.fnc_get_cliente(s.cod_pessoa_emissao) as nome_funcionario,
                   s.situacao_id, sp.descricao as prioridade, 
                   s.situacao_id ||' - '||sit.rv_abbreviation as desc_situacao,
                   sit.rv_abbreviation as situacao, 
                   a.descricao as area,
                   (select count(*)
                      from compras.v$solicitacao_material sm
                     where sm.solicitacao_id = s.solicitacao_id) +
                   (select count(*)
                      from compras.v$solicitacao_atividade sm
                     where sm.solicitacao_id = s.solicitacao_id) as qtde_itens,
                   (select count(*)
                      from compras.v$solicitacao_material sm
                     inner join compras.v$orcamento_material_solic oms
                             on oms.solicitacao_material_id = sm.controle_id                 
                     inner join compras.v$cotacao co
                             on co.orcamento_material_id = oms.orcamento_material_id
                     where sm.solicitacao_id = s.solicitacao_id) + 
                   (select count(*)
                      from compras.v$solicitacao_atividade sa
                     inner join compras.v$orcamento_atividade_solic oms
                             on oms.solicitacao_atividade_id = sa.controle_id                 
                     inner join compras.v$cotacao co
                             on co.orcamento_atividade_id = oms.orcamento_atividade_id
                     where sa.solicitacao_id = s.solicitacao_id) as qtde_itens_cotados,
                   s.user_insert, 
                   to_char(s.date_insert,'dd/mm/yyyy hh24:mi') as date_insert,                    
                   s.user_update, 
                   to_char(s.date_update,'dd/mm/yyyy hh24:mi') as date_update,
                   (select us.nome
                      from kss.v$usuarios us
                     where us.usuario = s.user_insert) as proprietario_insert,
                   (select us.nome
                      from kss.v$usuarios us
                     where us.usuario = s.user_update) as proprietario_update,
                   (select un.unidade_negocio
                     from kss.v$unidade_negocio un
                    where un.cod_unidade_negocio = org.cod_unidade_negocio) as unidade_negocio,
                   (select dp.descricao
                      from kss.v$departamento dp
                     where dp.cod_departamento = org.cod_departamento) as departamento,
                   (select s.descricao
                      from kss.v$setor s 
                     where s.cod_setor = org.cod_setor) as setor,
                   (select cc.centro_custo
                      from kss.v$centro_custo cc 
                     where cc.cod_centro_custo = org.cod_centro_custo) as centro_custo,
                    compras.pkg_compras.fnc_get_pedido_solicitacao(s.solicitacao_id) as num_pedido,
                   p.identificador as cnpj_fornecedor,
                   p.razao_social as fornecedor,
                   nvl((select sum(valor_negociado) 
                          from (select distinct oas.orcamento_atividade_id, ct.valor_negociado, sa.solicitacao_id
                                  from compras.v$solicitacao_atividade sa
                                  inner join compras.v$orcamento_atividade_solic oas
                                            on oas.solicitacao_atividade_id = sa.controle_id
                                  inner join compras.v$cotacao ct
                                            on ct.orcamento_atividade_id = oas.orcamento_atividade_id
                                          and ct.aprovada = 1  
                               ) a 
                          where a.solicitacao_id = s.solicitacao_id),0) +                
                    nvl((select sum(valor_negociado) 
                           from (select distinct oas.orcamento_material_id, ct.valor_negociado, sa.solicitacao_id
                                   from compras.v$solicitacao_material sa
                                   inner join compras.v$orcamento_material_solic oas
                                             on oas.solicitacao_material_id = sa.controle_id
                                   inner join compras.v$cotacao ct
                                             on ct.orcamento_material_id = oas.orcamento_material_id
                                           and ct.aprovada = 1 ) a
                                   where a.solicitacao_id = s.solicitacao_id),0)  as valor_solicitacao,
                     compras.pkg_compras.fnc_solicitacao_valor_minimo(s.solicitacao_id) as valor_minimo,
                    e.cod_equipamento, e.cod_equipamento as equipamento,
                    e.placa,
                    compras.pkg_compras.fnc_get_usuario_ocorrencia(s.solicitacao_id
                                                                 , kss.pkg_global.fnc_parametro_num(11,'OPERACIONAL',33,419)) as usuario_aprovacao,
                    kss.to_tempo((sysdate - s.date_insert) *24*60).retorno as tempo_tramite,
                    (sysdate - s.date_insert) *24*60 tempo_tramite_minutos,
                    (select count(*)
                       from compras.v$solicitacao_ocorrencia so
                      where so.solicitacao_id = s.solicitacao_id) as qtde_ocorrencias ,
                    (select o.cod_organizacional || ' - ' || o.descricao
                        from kss.v$organizacional o
                       where o.organizacional_id = s.organizacional_id) as organizacional
              from compras.v$solicitacao s
             inner join compras.v$solicitacao_prioridade sp
                     on sp.prioridade_id = s.prioridade_id 
             inner join compras.v$area a
                     on a.area_id = s.area_id
             inner join kss.v$organograma o
                     on o.cod_organograma = s.cod_organograma 
             inner join compras.v$cg_ref_codes sit
                     on sit.rv_domain = 'SOLICITACAO SITUACAO'
                    and sit.rv_low_value = s.situacao_id    
             inner join kss.v$organograma org
                     on org.cod_organograma = s.cod_organograma  
             left join almoxarifado.v$equipamento e 
                     on e.equipamento_id = s.equipamento_id                          
              left join kss.v$pessoa p
                     on p.cod_pessoa = s.cod_pessoa_fornecedor       
             where 1 = 1
            <cfif Len(Trim(arguments.num_controle))>
               and s.num_controle = #arguments.num_controle#
            <cfelseif Len(Trim(arguments.num_pedido))>
               and s.solicitacao_id in (select s2.solicitacao_id
                                          from compras.v$pedido p
                                    inner join compras.v$pedido_item pi
                                            on pi.pedido_id = p.pedido_id
                                    inner join compras.v$cotacao c
                                            on c.cotacao_id = pi.cotacao_id
                                    inner join compras.v$orcamento_atividade oa
                                            on oa.orcamento_atividade_id = c.orcamento_atividade_id
                                    inner join compras.v$orcamento_atividade_solic oas
                                            on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                                    inner join compras.v$solicitacao_atividade sa
                                            on sa.controle_id = oas.solicitacao_atividade_id
                                    inner join compras.v$solicitacao s2
                                            on s2.solicitacao_id = sa.solicitacao_id
                                         where p.num_pedido = #arguments.num_pedido#
                                    union
                                        select s2.solicitacao_id
                                          from compras.v$pedido p
                                    inner join compras.v$pedido_item pi
                                            on pi.pedido_id = p.pedido_id
                                    inner join compras.v$cotacao c
                                            on c.cotacao_id = pi.cotacao_id
                                    inner join compras.v$orcamento_material om
                                            on om.orcamento_material_id = c.orcamento_material_id
                                    inner join compras.v$orcamento_material_solic oms
                                            on oms.orcamento_material_id = om.orcamento_material_id
                                    inner join compras.v$solicitacao_material sm
                                            on sm.controle_id = oms.solicitacao_material_id
                                    inner join compras.v$solicitacao s2
                                            on s2.solicitacao_id = sm.solicitacao_id
                                    where p.num_pedido = #arguments.num_pedido#)
            <cfelse>
				<cfif Len(Trim(arguments.data_inicio))>
					and s.data_emissao >= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
                <cfif Len(Trim(arguments.data_fim))>
					and s.data_emissao <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
                <cfif Len(Trim(arguments.equipamento_id))>
					and s.equipamento_id = #arguments.equipamento_id#
                </cfif>
                <cfif Len(Trim(arguments.cod_pessoa_fornecedor))>
					and s.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                </cfif>
                <cfif Len(Trim(arguments.area_id))>
					and s.area_id = #arguments.area_id#
                </cfif>
                <cfif Len(Trim(arguments.cod_pessoa_filial))>
					and o.cod_pessoa = #arguments.cod_pessoa_filial#
                </cfif>
                <cfif Len(Trim(arguments.cod_centro_custo))>
					and o.cod_centro_custo = #arguments.cod_centro_custo#
                </cfif>
                <cfif Len(Trim(arguments.situacao_id))>
					and s.situacao_id in (#arguments.situacao_id#)
                </cfif>
			</cfif>
            order by s.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as ocorrncias de uma solicitao de compra
    -- ANDERSON 17/12/2009 - CRIADO
    --->		
    <cffunction name="get_solicitacao_ocorrencias" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select ot.titulo
                      from compras.v$ocorrencia_tipo ot
                     where ot.ocorrencia_id = o.tipo_id) as tipo
                 , o.comentario
              from compras.v$solicitacao_ocorrencia so
             inner join compras.v$ocorrencia o
                     on o.ocorrencia_id = so.ocorrencia_id
             where so.solicitacao_id = #arguments.solicitacao_id#
             order by o.date_insert
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os itens de uma solicitao de compra
    -- ANDERSON 04/12/2009 - CRIADO
    --->		
    <cffunction name="get_solicitacao_itens" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select m.descricao_completa
                      from almoxarifado.v$material m
                     where m.material_id = sm.material_id) as descricao_item
                 , sm.descricao
                 , sm.cod_unidade
                 , sm.quantidade
                 , sm.compra_liberada
                 , sm.valor_sugerido
                 , sm.quantidade * nvl(sm.valor_sugerido, 0) as valor_total
              from compras.v$solicitacao_material sm
             where sm.solicitacao_id = #arguments.solicitacao_id#
             
             union all
             
            select (select a.titulo
                      from manutencao.v$atividade a
                     where a.atividade_id = sa.atividade_id) as descricao_item
                 , sa.descricao
                 , 'UN' as cod_unidade
                 , sa.quantidade
                 , sa.compra_liberada
                 , sa.valor_sugerido
                 , sa.quantidade * nvl(sa.valor_sugerido, 0) as valor_total
              from compras.v$solicitacao_atividade sa
             where sa.solicitacao_id = #arguments.solicitacao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os itens cotados de uma solicitao de compra
    -- ANDERSON 04/12/2009 - CRIADO
    --->		
    <cffunction name="get_solicitacao_itens_cotados" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select 'Material' as tipo
                 , ct.num_cotacao
                 , ct.cotacao_id
                 , sm.descricao
                 , sm.cod_unidade
                 , sm.quantidade
                 , ct.valor_negociado / sm.quantidade as valor_unitario
                 , ct.valor_negociado
                 , ct.aprovada
                 , kss.pkg_pessoa.fnc_get_identificador(ct.cod_pessoa_fornecedor) as cnpj_cpf_fornecedor
                 , (select p.razao_social
                     from kss.v$pessoa p
                    where p.cod_pessoa = ct.cod_pessoa_fornecedor) as fornecedor
                 , (select ff.forma_descricao
                     from kss.v$faturamento_forma ff
                    where ff.forma_id = ct.forma_pagto_id) as forma_pagamento
                 , (select pe.descricao
                      from compras.v$prazo_entrega pe
                     where pe.prazo_entrega_id = ct.prazo_entrega_id) as prazo_entrega
              from compras.v$solicitacao_material sm
             inner join compras.v$orcamento_material_solic oms
                     on oms.solicitacao_material_id = sm.controle_id
             inner join compras.v$cotacao ct
                     on ct.orcamento_material_id = oms.orcamento_material_id
             where sm.solicitacao_id = #arguments.solicitacao_id#
             
             union all
             
            select 'Servio' as tipo
            	 , ct.num_cotacao
                 , ct.cotacao_id
                 , sa.descricao
                 , 'UN' as cod_unidade
                 , sa.quantidade
                 , ct.valor_negociado / sa.quantidade as valor_unitario
                 , ct.valor_negociado
                 , ct.aprovada
                 , kss.pkg_pessoa.fnc_get_identificador(ct.cod_pessoa_fornecedor) as cnpj_cpf_fornecedor
                 , (select p.razao_social
                     from kss.v$pessoa p
                    where p.cod_pessoa = ct.cod_pessoa_fornecedor) as fornecedor
                 , (select ff.forma_descricao
                     from kss.v$faturamento_forma ff
                    where ff.forma_id = ct.forma_pagto_id) as forma_pagamento
                 , (select pe.descricao
                      from compras.v$prazo_entrega pe
                     where pe.prazo_entrega_id = ct.prazo_entrega_id) as prazo_entrega
              from compras.v$solicitacao_atividade sa
             inner join compras.v$orcamento_atividade_solic oas
                     on oas.solicitacao_atividade_id = sa.controle_id
             inner join compras.v$cotacao ct
                     on ct.orcamento_atividade_id = oas.orcamento_atividade_id
             where sa.solicitacao_id = #arguments.solicitacao_id#
             
             order by cnpj_cpf_fornecedor, tipo, descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna se um fornecedor possui tabela de preo fixo
    -- ANDERSON 28/01/2010 - CRIADO
    --->		
    <cffunction name="get_fornecedor_tabela_preco_fixo" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_fornecedor" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select sign(count(*)) as possui_tabela
              from compras.v$tabela_preco_fixo tpf
             where tpf.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO 
    -- Retorna a tabela de preo fixo de um fornecedor
    -- ANDERSON 09/06/2010 - CRIADO
    --->		
    <cffunction name="get_tabela_preco_fixo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_fornecedor" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tpf.tabela_id
                 , tpf.cod_tabela
                 , tpf.cod_pessoa_fornecedor
                 , tpf.titulo
                 , to_char(tpf.data_vigencia, 'dd/mm/yyyy') as data_vigencia
                 , tpf.observacao
                 , tpf.aprovada
                 , to_char(tpf.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
                 , tpf.ativa
                 , to_char(tpf.data_inativacao, 'dd/mm/yyyy hh24:mi:ss') as data_inativacao
              from compras.v$tabela_preco_fixo tpf
             where tpf.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
               and tpf.aprovada = 1
               and tpf.ativa = 1
               and tpf.data_vigencia = (select max(tpf2.data_vigencia)
                                          from compras.v$tabela_preco_fixo tpf2
                                         where tpf2.cod_pessoa_fornecedor = tpf.cod_pessoa_fornecedor
                                           and tpf2.aprovada = 1
                                           and tpf2.ativa = 1
                                           and tpf2.data_vigencia <= sysdate
                                        )
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Verifica se uma lista de materiais pertence a uma tabela
    -- ANDERSON 11/06/2010 - CRIADO
    --->		
    <cffunction name="get_verificacao_tabela_materiais" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
        <cfargument name="material_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.column_value as material_id
                 , x.valor
              from table(kss.pkg_string.fnc_split('#arguments.material_id#', ';')) t
              left join (select tpm.material_id
                              , tpm.valor
                           from compras.v$tabela_preco_material tpm
                          where tpm.tabela_id = #arguments.tabela_id#
                            and tpm.data_vigencia = (select max(tpm2.data_vigencia)
                                                       from compras.v$tabela_preco_material tpm2
                                                      where tpm2.material_id = tpm.material_id
                                                        and tpm2.tabela_id = tpm.tabela_id
                                                        and tpm2.data_vigencia <= sysdate
                                                    )
                        ) x
                     on x.material_id = t.column_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Verifica se uma lista de atividades pertence a uma tabela
    -- ANDERSON 11/06/2010 - CRIADO
    --->		
    <cffunction name="get_verificacao_tabela_atividades" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
        <cfargument name="atividade_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.column_value as atividade_id
                 , x.valor
              from table(kss.pkg_string.fnc_split('#arguments.atividade_id#', ';')) t
              left join (select tpa.atividade_id
                              , tpa.valor
                           from compras.v$tabela_preco_atividade tpa
                          where tpa.tabela_id = #arguments.tabela_id#
                            and tpa.data_vigencia = (select max(tpa2.data_vigencia)
                                                       from compras.v$tabela_preco_atividade tpa2
                                                      where tpa2.atividade_id = tpa.atividade_id
                                                        and tpa2.tabela_id = tpa.tabela_id
                                                        and tpa2.data_vigencia <= sysdate
                                                    )
                        ) x
                     on x.atividade_id = t.column_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna dados do pedigo
    -- GUTO 02/02/2010 - CRIADO
    --->		
    <cffunction name="get_pedido" access="remote" returntype="query" output="true">
        <cfargument name="pedido_id" required="no" default="">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="ver_pedido" required="no" default="1">
        <cfif arguments.ver_pedido eq 1>
            <cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#"> 
                insert into kss.pessoa_usuario_acesso_cur 
                    (cod_pessoa, usuario) 
                values
                    (1,user)
            </cfquery>        
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pedido_id
                 , p.num_pedido
                 , pe.identificador as cnpj
                 , pe.inscricao_estadual
                 , pe.razao_social
                 , pe.cliente as fornecedor
                 , pep.logradouro
                 , pep.numero
                 , pep.bairro
                 , pep.municipio
                 , pep.uf
                 , pep.cep
                 , ptp.telefone
                 , to_char(p.data_pedido, 'dd/mm/yyyy') as data_pedido
                 , to_char(nvl(p.data_vencimento, p.data_pedido + 35), 'dd/mm/yyyy') as data_vencto
                 , to_char(p.valor_total_pedido, 'FM999G999G990D00', 'nls_numeric_characters='',.''') as valor_total_pedido
                 , autenticacao
                 , to_char(p.data_entrega, 'dd/mm/yyyy') as data_entrega
                 , p.local_entrega
                 , p.observacoes
                 , compras.pkg_compras.fnc_get_equipamento_pedido(p.pedido_id) as equipamentos
                 , (select t.cod_pessoa
                      from (select pi.pedido_id
                                 , o.cod_pessoa
                              from compras.v$pedido_item pi
                             inner join compras.v$cotacao c
                                     on c.cotacao_id = pi.cotacao_id
                             inner join compras.v$orcamento_atividade oa
                                     on oa.orcamento_atividade_id = c.orcamento_atividade_id
                             inner join compras.v$orcamento_atividade_solic oas
                                     on oas.orcamento_atividade_id = oa.orcamento_atividade_id
                             inner join compras.v$solicitacao_atividade sa
                                     on sa.controle_id = oas.solicitacao_atividade_id
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sa.solicitacao_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                            
                             union all
                            
                            select pi.pedido_id
                                 , o.cod_pessoa
                              from compras.v$pedido_item pi
                             inner join compras.v$cotacao c
                                     on c.cotacao_id = pi.cotacao_id
                             inner join compras.v$orcamento_material om
                                     on om.orcamento_material_id = c.orcamento_material_id
                             inner join compras.v$orcamento_material_solic oms
                                     on oms.orcamento_material_id = om.orcamento_material_id
                             inner join compras.v$solicitacao_material sm
                                     on sm.controle_id = oms.solicitacao_material_id
                             inner join compras.v$solicitacao s
                                     on s.solicitacao_id = sm.solicitacao_id  
                             inner join kss.v$organograma o
                                     on o.cod_organograma = s.cod_organograma
                           ) t
                     where t.pedido_id = p.pedido_id
                       and rownum = 1
                   ) as cod_pessoa_emissao            
              from compras.v$pedido p
             inner join kss.v$pessoa pe
                     on pe.cod_pessoa = p.cod_pessoa_fornecedor
             inner join compras.v$solicitacao_pedido sp
                     on sp.pedido_id = p.pedido_id
              left join kss.v$pessoa_endereco_padrao pep
                     on pep.cod_pessoa = pe.cod_pessoa
              left join kss.v$pessoa_telefone_padrao ptp 
                     on ptp.cod_pessoa = pe.cod_pessoa
             where p.num_pedido = #arguments.num_pedido#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    

    <!--- 
    -- PROPSITO 
    -- Retorna dados do pedigo
    -- GUTO 02/02/2010 - CRIADO
    --->		
    <cffunction name="get_pedido_material" access="remote" returntype="query" output="true">
        <cfargument name="pedido_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select coalesce(m.cod_paralelo,m.cod_fabricante,m.cod_genuino)  as codigo
                   ,m.descricao_completa, c.quantidade, 
                   to_char(round(c.valor_negociado/c.quantidade,4),'FM999G999G990D0000','nls_numeric_characters='',.''') as valor_unitario,
                   to_char(c.valor_negociado,'FM999G999G990D00','nls_numeric_characters='',.''') as valor_negociado,
                   to_char(sum(c.valor_negociado) over(),'FM999G999G990D00','nls_numeric_characters='',.''') as valor_total
              from compras.v$pedido_item pi
              inner join compras.v$cotacao c
                      on c.cotacao_id = pi.cotacao_id
              inner join almoxarifado.v$material_dados m
                      on m.material_id = c.material_id
            where pi.pedido_id = #arguments.pedido_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>      

    <!--- 
    -- PROPSITO 
    -- Retorna dados do pedigo
    -- GUTO 02/02/2010 - CRIADO
    --->		
    <cffunction name="get_pedido_atividade" access="remote" returntype="query" output="true">
        <cfargument name="pedido_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.titulo, c.quantidade, 
                   to_char(round(c.valor_negociado/c.quantidade,4),'FM999G999G990D0000','nls_numeric_characters='',.''') as valor_unitario,
                   to_char(c.valor_negociado,'FM999G999G990D00','nls_numeric_characters='',.''') as valor_negociado,
                   to_char(sum(c.valor_negociado) over(),'FM999G999G990D00','nls_numeric_characters='',.''') as valor_total
              from compras.v$pedido_item pi
              inner join compras.v$cotacao c
                      on c.cotacao_id = pi.cotacao_id
              inner join manutencao.v$atividade a
                      on a.atividade_id = c.atividade_id
            where pi.pedido_id = #arguments.pedido_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
     <!--- 
    -- PROPSITO 
    -- Retorna os pedidos de acordo com o filtro selecionado
    -- ANDERSON 08/02/2010 - CRIADO
    --->		
    <cffunction name="get_pedidos" access="remote" returntype="query" output="true">
        <cfargument name="num_pedido" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pedido_id
                 , compras.pkg_compras.fnc_get_pedido_placa(p.pedido_id) as placa
                 , p.num_pedido
                 , to_char(p.data_pedido, 'dd/mm/yyyy') as data_pedido
                 , to_char(nvl(p.data_vencimento, p.data_pedido + 35), 'dd/mm/yyyy') as data_vencimento
                 , p.valor_material
                 , p.valor_atividade
                 , p.valor_total_pedido
                 , kss.fnc_ref_code('COMPRAS', 'PEDIDO SITUACAO', p.situacao_id, 0) as situacao
                 , (select ff.forma_descricao
                      from kss.v$faturamento_forma ff
                     where ff.forma_id = p.forma_pagto_id) as forma_pagamento
                 , (select pe.descricao
                      from compras.v$prazo_entrega pe
                     where pe.prazo_entrega_id = p.prazo_entrega_id) as prazo_entrega
                 , to_char(p.data_entrega, 'dd/mm/yyyy') as data_entrega
                 , p.local_entrega
                 , p.observacoes
                 , fiscal.pkg_nf_terceiro.fnc_nota_fiscal_pedido(p.pedido_id) as num_nota_fiscal
                 , p.autenticacao
              from compras.v$pedido p
             where p.cod_pessoa_fornecedor = (select u.cod_pessoa
                                                from kss.v$usuarios u
                                               where u.usuario = user)
			<cfif Len(Trim(arguments.num_pedido))>
               and p.num_pedido = #arguments.num_pedido#
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and p.data_pedido >= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and p.data_pedido <= to_date('#arguments.data_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
             order by p.num_pedido asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna os tipos de compra
    -- ANDERSON 13/02/2010 - CRIADO
    --->		
    <cffunction name="get_tipo_compra" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select tp.tipo_compra_id
                 , tp.descricao
              from compras.v$tipo_compra tp
             order by tp.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Retorna resumo de valor por rea
    -- GUTO 19/03/2010 - CRIADO
    --->		
    <cffunction name="get_resumo_areas" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="agrupar_filiais" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.area_id, area <cfif arguments.agrupar_filiais eq 0>,p.cod_pessoa as cod_pessoa_filial, p.cliente as filial<cfelse>,'' as cod_pessoa_filial, 'Todas as Filiais' as filial</cfif>
                   ,sum(valor_nf_lancada) as valor_nf_lancada
                   ,sum(valor_nf_nao_lancada) as valor_nf_nao_lancada
                   ,sum(valor_aprovada) as valor_aprovada
              from (
            select a.area_id, a.descricao as area<cfif arguments.agrupar_filiais eq 0>,y.cod_organograma</cfif>
                   ,case
                     when ar.column_value = 'NF Lanada' then nvl(y.valor, 0) 
                   else 0 end valor_nf_lancada
                   ,case
                     when ar.column_value = 'NF no Lanada' then nvl(y.valor, 0) 
                   else 0 end valor_nf_nao_lancada
                   ,case
                     when ar.column_value = 'Aprovadas' then nvl(y.valor, 0) 
                   else 0 end valor_aprovada
            from compras.v$area a 
            natural join table(kss.pkg_string.fnc_split('NF Lanada,NF no Lanada,Aprovadas',',')) ar
              left  join (select 'NF Lanada' as tipo, x.area_id, round(sum(x.valor_total),2) as valor
              					 <cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>
                      from (select s.area_id
                              ,compras.pkg_compras.fnc_get_pedido_nf_solicitacao(s.solicitacao_id) as pedido_nf
                              <cfif arguments.agrupar_filiais eq 0>,s.cod_organograma</cfif>
                              , nvl((select sum(valor) 
                                   from (select sum(sm.quantidade * c.valor_unitario) as valor, sm.solicitacao_id
                                           from compras.v$solicitacao_material sm
                                           inner join compras.v$orcamento_material_solic oms
                                                   on oms.solicitacao_material_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_material_id = oms.orcamento_material_id
                                           inner join compras.v$pedido_item pi
                                                   on pi.cotacao_id = c.cotacao_id
                                          group by sm.solicitacao_id
                                          union all
                                          select sum(sm.quantidade * c.valor_unitario)as valor, sm.solicitacao_id
                                            from compras.v$solicitacao_atividade sm
                                           inner join compras.v$orcamento_atividade_solic oms
                                                   on oms.solicitacao_atividade_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_atividade_id = oms.orcamento_atividade_id
                                           inner join compras.v$pedido_item pi
                                                   on pi.cotacao_id = c.cotacao_id
                                          group by sm.solicitacao_id)
                                          where solicitacao_id = s.solicitacao_id),0) as valor_total
                      from compras.v$solicitacao s
                      inner join kss.v$organograma o 
                              on o.cod_organograma = s.cod_organograma
                      where 1 = 1
                        <cfif Len(Trim(arguments.AREA_ID))>
                           and s.area_id in (#arguments.AREA_ID#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
                           and o.cod_pessoa in (#arguments.COD_PESSOA_FILIAL#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                           and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_INICIAL))>
                           and trunc(s.data_emissao) >= '#arguments.DATA_INICIAL#'
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_FINAL))>
                           and trunc(s.data_emissao) <= '#arguments.DATA_FINAL#'
                        </cfif>
                        ) x
                      where x.pedido_nf is not null
                    group by x.area_id<cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>
            
                    union all
            
                    select 'NF no Lanada' as tipo, x.area_id, round(sum(x.valor_total),2) as valor 
                    	   <cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>
                      from (select s.area_id 
                              ,compras.pkg_compras.fnc_get_pedido_nf_solicitacao(s.solicitacao_id) as pedido_nf
                              <cfif arguments.agrupar_filiais eq 0>,s.cod_organograma</cfif>
                              , nvl((select sum(valor) 
                                   from (select sum(sm.quantidade * c.valor_unitario) as valor, sm.solicitacao_id
                                           from compras.v$solicitacao_material sm
                                           inner join compras.v$orcamento_material_solic oms
                                                   on oms.solicitacao_material_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_material_id = oms.orcamento_material_id
                                           inner join compras.v$pedido_item pi
                                                   on pi.cotacao_id = c.cotacao_id
                                          group by sm.solicitacao_id
                                          union all
                                          select sum(sm.quantidade * c.valor_unitario)as valor, sm.solicitacao_id
                                            from compras.v$solicitacao_atividade sm
                                           inner join compras.v$orcamento_atividade_solic oms
                                                   on oms.solicitacao_atividade_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_atividade_id = oms.orcamento_atividade_id
                                           inner join compras.v$pedido_item pi
                                                   on pi.cotacao_id = c.cotacao_id
                                          group by sm.solicitacao_id)
                                          where solicitacao_id = s.solicitacao_id),0) as valor_total
                      from compras.v$solicitacao s
                      inner join kss.v$organograma o 
                              on o.cod_organograma = s.cod_organograma
                      where 1 = 1
                        <cfif Len(Trim(arguments.AREA_ID))>
                           and s.area_id in (#arguments.AREA_ID#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
                           and o.cod_pessoa in (#arguments.COD_PESSOA_FILIAL#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                           and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_INICIAL))>
                           and trunc(s.data_emissao) >= '#arguments.DATA_INICIAL#'
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_FINAL))>
                           and trunc(s.data_emissao) <= '#arguments.DATA_FINAL#'
                        </cfif>
                        and s.situacao_id in (10,6)) x
                      where x.pedido_nf is null
                    group by x.area_id<cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>
            
                    union all
            
                    select 'Aprovadas' as tipo, x.area_id, round(sum(x.valor_total),2) as valor 
                    	   <cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>
                      from (select s.area_id 
                              ,compras.pkg_compras.fnc_get_pedido_nf_solicitacao(s.solicitacao_id) as pedido_nf
                              <cfif arguments.agrupar_filiais eq 0>,s.cod_organograma</cfif>
                              , nvl((select sum(valor) 
                                   from (select sum(sm.quantidade * c.valor_unitario) as valor, sm.solicitacao_id
                                           from compras.v$solicitacao_material sm
                                           inner join compras.v$orcamento_material_solic oms
                                                   on oms.solicitacao_material_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_material_id = oms.orcamento_material_id
                                                  and c.aprovada = 1
                                          group by sm.solicitacao_id
                                          union all
                                          select sum(sm.quantidade * c.valor_unitario)as valor, sm.solicitacao_id
                                            from compras.v$solicitacao_atividade sm
                                           inner join compras.v$orcamento_atividade_solic oms
                                                   on oms.solicitacao_atividade_id = sm.controle_id
                                           inner join compras.v$cotacao c
                                                   on c.orcamento_atividade_id = oms.orcamento_atividade_id
                                                  and c.aprovada = 1 
                                          group by sm.solicitacao_id)
                                          where solicitacao_id = s.solicitacao_id),0) as valor_total
                      from compras.v$solicitacao s
                      inner join kss.v$organograma o 
                              on o.cod_organograma = s.cod_organograma
                      where 1 = 1
                        <cfif Len(Trim(arguments.AREA_ID))>
                           and s.area_id in (#arguments.AREA_ID#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
                           and o.cod_pessoa in (#arguments.COD_PESSOA_FILIAL#)
                        </cfif>
                        <cfif Len(Trim(arguments.COD_CENTRO_CUSTO))>
                           and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_INICIAL))>
                           and trunc(s.data_emissao) >= '#arguments.DATA_INICIAL#'
                        </cfif>
                        <cfif Len(Trim(arguments.DATA_FINAL))>
                           and trunc(s.data_emissao) <= '#arguments.DATA_FINAL#'
                        </cfif>
                        and s.situacao_id in (5)) x
                    group by x.area_id<cfif arguments.agrupar_filiais eq 0>,x.cod_organograma</cfif>) y         
               on y.area_id = a.area_id
              and y.tipo = ar.column_value
            order by a.descricao) t
              <cfif arguments.agrupar_filiais eq 0>
              inner join kss.v$organograma o
                      on o.cod_organograma = t.cod_organograma
              inner join kss.v$pessoa p
                      on p.cod_pessoa = o.cod_pessoa
              </cfif>
			<cfif Len(Trim(arguments.AREA_ID))>
               where t.area_id in (#arguments.AREA_ID#)
            </cfif>
            group by t.area_id, area<cfif arguments.agrupar_filiais eq 0>,p.cliente, p.cod_pessoa</cfif>
            order by filial, cod_pessoa_filial,area           
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
    
    <!--- 
    -- PROPSITO 
    -- Retorna resumo de valor por rea
    -- GUTO 19/03/2010 - CRIADO
    --->		
    <cffunction name="get_detalhamento_area" access="remote" returntype="query" output="true">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="area_id" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="situacao_id" required="no" default="">
        <cfargument name="com_nota" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select *
              from ( 
            select s.solicitacao_id
                 , s.num_controle
                 , s.titulo
                 , to_char(s.data_emissao,'dd/mm/yyyy hh24:mi') as data_emissao
                 , s.cod_organograma     
                 , (select un.unidade_negocio
                      from kss.v$unidade_negocio un
                     where o.cod_unidade_negocio = un.cod_unidade_negocio) as unidade_negocio
                 , (select pf.nome
                      from kss.v$pessoa_fisica pf
                     where pf.cod_pessoa = s.cod_pessoa_emissao) as nome_funcionario
                 , e.cod_equipamento as equipamento
                 , e.placa as placa
                 , sit.rv_abbreviation as situacao
                 , sp.descricao as prioridade
                 , a.descricao as area           
                 , p.identificador as cnpj_fornecedor
                 , p.razao_social as fornecedor
                 , s.user_insert
                 , to_char(s.date_insert,'dd/mm/yyyy hh24:mi') as date_insert
                 , s.user_update
                 , s.date_update
                 , nvl((select sum(sm.quantidade * c.valor_unitario)
                           from compras.v$solicitacao_material sm
                           inner join compras.v$orcamento_material_solic oms
                                   on oms.solicitacao_material_id = sm.controle_id
                           inner join compras.v$cotacao c
                                   on c.orcamento_material_id = oms.orcamento_material_id
                           inner join compras.v$pedido_item pi
                                   on pi.cotacao_id = c.cotacao_id
                          where sm.solicitacao_id = s.solicitacao_id),0) as valor_material
                      , nvl((select sum(sm.quantidade * c.valor_unitario)
                           from compras.v$solicitacao_atividade sm
                           inner join compras.v$orcamento_atividade_solic oms
                                   on oms.solicitacao_atividade_id = sm.controle_id
                           inner join compras.v$cotacao c
                                   on c.orcamento_atividade_id = oms.orcamento_atividade_id
                           inner join compras.v$pedido_item pi
                                   on pi.cotacao_id = c.cotacao_id
                          where sm.solicitacao_id = s.solicitacao_id),0) as valor_atividade
                      , nvl((select sum(valor) 
                           from (select sum(sm.quantidade * c.valor_unitario) as valor, sm.solicitacao_id
                                   from compras.v$solicitacao_material sm
                                   inner join compras.v$orcamento_material_solic oms
                                           on oms.solicitacao_material_id = sm.controle_id
                                   inner join compras.v$cotacao c
                                           on c.orcamento_material_id = oms.orcamento_material_id
                                   inner join compras.v$pedido_item pi
                                           on pi.cotacao_id = c.cotacao_id
                                  group by sm.solicitacao_id
                                  union all
                                  select sum(sm.quantidade * c.valor_unitario)as valor, sm.solicitacao_id
                                    from compras.v$solicitacao_atividade sm
                                   inner join compras.v$orcamento_atividade_solic oms
                                           on oms.solicitacao_atividade_id = sm.controle_id
                                   inner join compras.v$cotacao c
                                           on c.orcamento_atividade_id = oms.orcamento_atividade_id
                                   inner join compras.v$pedido_item pi
                                           on pi.cotacao_id = c.cotacao_id
                                  group by sm.solicitacao_id)
                                  where solicitacao_id = s.solicitacao_id),0) as valor_total
                 ,compras.pkg_compras.fnc_get_pedido_solicitacao(s.solicitacao_id) as pedidos
                 ,to_char(compras.pkg_compras.fnc_get_pedido_data(s.solicitacao_id),'dd/mm/yyyy') as pedido_data
                 ,compras.pkg_compras.fnc_get_pedido_nf_solicitacao(s.solicitacao_id) as pedido_nf
                 ,to_char(compras.pkg_compras.fnc_get_pedido_data_nf(s.solicitacao_id),'dd/mm/yyyy') as pedido_nf_data     
                 ,nvl((select sum(valor) 
                         from (select sum(sm.quantidade * nvl(sm.valor_sugerido,0)) as valor, sm.solicitacao_id
                                 from compras.v$solicitacao_material sm
                                 group by sm.solicitacao_id
                               union all
                               select sum(sm.quantidade * nvl(sm.valor_sugerido,0))as valor, sm.solicitacao_id
                               from compras.v$solicitacao_atividade sm
                               group by sm.solicitacao_id)
                         where solicitacao_id = s.solicitacao_id),0) as valor_total_solicitacao
                 ,to_char(compras.pkg_compras.fnc_get_pedido_data_nf(s.solicitacao_id,1),'dd/mm/yyyy') as pedido_nf_emissao_data
                 ,compras.pkg_compras.fnc_get_solitacao_ped_forn(s.solicitacao_id) as pedido_fornecedor
                 ,(select cc.centro_custo
                     from kss.v$centro_custo cc
                    where o.cod_centro_custo = cc.cod_centro_custo) as centro_custo
                
              from compras.v$solicitacao s
             inner join kss.v$organograma o 
                     on o.cod_organograma = s.cod_organograma
             inner join compras.v$cg_ref_codes sit        
                     on sit.rv_low_value = s.situacao_id
                    and sit.rv_domain = 'SOLICITACAO SITUACAO'
             inner join compras.v$solicitacao_prioridade sp
                     on sp.prioridade_id = s.prioridade_id  
              left join kss.v$pessoa p
                     on p.cod_pessoa = s.cod_pessoa_fornecedor
              left join almoxarifado.v$equipamento e
                     on e.equipamento_id = s.equipamento_id
              left join compras.v$area a
                     on a.area_id = s.area_id 
              where 1 = 1
                <cfif Len(Trim(arguments.AREA_ID))>
	                and s.area_id in (#arguments.AREA_ID#)
                </cfif>
                <cfif Len(Trim(arguments.COD_PESSOA))>
                	and o.cod_pessoa in (#arguments.COD_PESSOA#)
                </cfif>
                <cfif Len(Trim(arguments.DATA_INICIAL))>
                   and s.data_emissao >= '#arguments.DATA_INICIAL#'
                </cfif>
                <cfif Len(Trim(arguments.DATA_FINAL))>
                   and s.data_emissao <= to_date('#arguments.DATA_FINAL# 23:59:59','dd/mm/yyyy hh24:mi:ss')
                </cfif>
                <cfif Len(Trim(arguments.SITUACAO_ID))>
                   and s.situacao_id in (#arguments.SITUACAO_ID#)
                </cfif>)
                where 1=1
                <cfif Len(Trim(arguments.COM_NOTA)) and arguments.COM_NOTA eq 1>
                   and pedido_nf is not null
                <cfelseif Len(Trim(arguments.COM_NOTA)) and arguments.COM_NOTA eq 0>
                   and pedido_nf is null
                </cfif>
                order by data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>    
                
    <!--- 
    -- PROPSITO 
    -- Consulta as informaes de ltimas compras de um determinado material
    -- GUSTAVOC - CRIADO 23/11/2010
    --->		
    <cffunction name="get_informacoes_compra_material" access="remote" returntype="query" output="true">
    	<cfargument name="MATERIAL_ID" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.material_id
                 , kss.pkg_pessoa.fnc_get_identificador(p.cod_pessoa_fornecedor) as cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(p.cod_pessoa_fornecedor) as fornecedor
                 , p.data_pedido
                 , ct.valor_unitario
                 , nvl(almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(ct.material_id, '102'), '-') as target
                 , m.cod_genuino
                 , m.cod_fabricante
                 , m.cod_paralelo
              from compras.v$pedido p
             inner join compras.v$pedido_item pi
                on pi.pedido_id = p.pedido_id
             inner join compras.v$cotacao ct
                on ct.cotacao_id = pi.cotacao_id
             inner join almoxarifado.v$material_dados m
                on m.material_id = ct.material_id
             where ct.material_id = <cfif Len(Trim(arguments.MATERIAL_ID))>#arguments.MATERIAL_ID#<cfelse>-999999</cfif>
             order by p.data_pedido desc;
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Consulta parcelamento pedido
    -- LINCOLNS - CRIADO 29/03/2011
    --->		
    <cffunction name="get_parcelamento_pedido" access="remote" returntype="query" output="true">
    	<cfargument name="pedido_id" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pp.valor
                 , pp.num_parcela
                 , to_char(pp.data_vencimento, 'dd/mm/yyyy') as data_vencimento
                 , p.tipo_parcelamento
                 , p.dia_vencimento
             from compras.v$parcelamento_pedido pp
            inner join compras.v$pedido p
		       on p.pedido_id = pp.pedido_id
            where 1 = 1
            <cfif Len(Trim(arguments.pedido_id))>
              and pp.pedido_id = #arguments.pedido_id#
            </cfif>
            order by pp.data_vencimento  
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
    <!--- 
    -- PROPSITO 
    -- Consulta parcelamento pedido
    -- LINCOLNS - CRIADO 29/03/2011
    --->		
    <cffunction name="get_dados_parcelamento" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select pt.valor
                , pt.num_parcela
                , to_char(pt.data_vencto, 'dd/mm/yyyy') as data_vencto
             from compras.parcelamento_temp pt
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    
    <!--- 
    -- PROPSITO 
    -- Consulta parcelamento pedido
    -- LINCOLNS - CRIADO 29/03/2011
    --->		
    <cffunction name="get_equipamento_ultima_tracao" access="remote" returntype="query" output="true">
    	<cfargument name="equipamento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.equipamento_id_tracao
                 , e.cod_equipamento
                 , ma.material as material_equipamento_custo
              from (select compras.pkg_compras.fnc_get_equipamento_ult_tracao(#arguments.equipamento_id#) as equipamento_id_tracao
                      from dual) t
             inner join almoxarifado.v$equipamento e
                on e.equipamento_id = t.equipamento_id_tracao
             inner join almoxarifado.v$material_dados ma
                on ma.material_id = e.material_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

</cfcomponent>