
/* 
Funo: Carrega Imagem
Inserida: 19/01/2006 16:41
Ultima alterao: 19/01/2006 16:41
Propsito: Carrega uma imagem selecionada em um input:file em um img.
Obs: inserida em onChange do input:file
*/
		
function f_carrega_imagem(v_file_input, v_image_preview) {
	if(v_file_input.value != "") {
		v_image_preview.style.display = '';
		v_image_preview.src = v_file_input.value;
	} else {
		v_image_preview.style.display = 'none';
	}
}

/* 
Funo: Controla Campos
Inserida: 19/01/2006 16:03
Ultima alterao: 19/01/2006 16:03
Propsito: f_controla_campos(num_forms) : Cria show messagem para os campos, inclusive pode gerar tabindex
	* variveis *
	  - num_forms : numero de formularios da tela
	  - cria_tab_index : parmetro deve ser passado caso o desenvolvedor desejar a criao automtica do tanindex dos forms
	* chamada *
    windown.onload = function() { f_controla_campos(1); }
*/
		
function f_controla_campos(num_forms) {
    var v_controla_tab_index = false;
	var args = f_controla_campos.arguments;

    if (args.length > 1) 
	   var v_controla_tab_index = true;
	   
	for (var j = 0; j<num_forms; j++) {  
	    var formulario = eval(document.forms[j]);
		for (var i = 0; i<formulario.length; i++) {		
			// Limpar todos os TABINDEX
			if (v_controla_tab_index) 
				formulario.elements[i].tabIndex = 0;		
			if (formulario.elements[i].onfocus) {
				formulario.elements[i].v_funcao_focus = formulario.elements[i].onfocus;
				formulario.elements[i].onfocus = function() { 
																v_funcao = String(this.v_funcao_focus).replace('function anonymous()','');
																v_funcao = String(v_funcao).replace('}','');
																v_funcao = String(v_funcao).replace('{','');																
																v_funcao = Trim(v_funcao);
																eval(v_funcao);											
																if (f_verifica_tipo(this)) {
																	event.srcElement.style.backgroundColor='#FFFFDD'; 
																	event.srcElement.style.color = '#000000';
																}
																if (event.srcElement.hint) 
																   show_popup(event.srcElement,event,event.srcElement.hint);
															}
			}
			else 
				formulario.elements[i].onfocus = function() { 
												              if (f_verifica_tipo(this)) { 
															     event.srcElement.style.backgroundColor='#FFFFDD'; 
 																 event.srcElement.style.color = '#000000';
															  }
															  if (event.srcElement.hint) 
																show_popup(event.srcElement,event,event.srcElement.hint);
															}

			if (v_controla_tab_index) 
				formulario.elements[i].tabIndex = i+1;   
				
			if (f_verifica_tipo(formulario.elements[i])) {
					
				formulario.elements[i].onhelp = function() { show_popup(event.srcElement,event,event.srcElement.hint); }
				
				if (formulario.elements[i].onblur) {
					formulario.elements[i].v_funcao = formulario.elements[i].onblur;
					formulario.elements[i].onblur = function() { 
																v_funcao = String(this.v_funcao).replace('function anonymous()','');
																v_funcao = String(v_funcao).replace('}','');
																v_funcao = String(v_funcao).replace('{','');																
																v_funcao = Trim(v_funcao);
																eval(v_funcao);																
					                                            event.srcElement.style.backgroundColor='';
																event.srcElement.style.color = '';
																window.status = '';
																}
				}
				else
					formulario.elements[i].onblur = function() {  
																 event.srcElement.style.backgroundColor='';
															     event.srcElement.style.color = '';
																 window.status = '';
															   }															   
			}
		}	
	}
	window.status = ''; 
}

/* 
Funo: Cria Boto
Inserida: 19/01/2006 16:34
Ultima alterao: 19/01/2006 16:34
Propsito: Cria objeto BUTTON em uma barra do site
variveis:
 - p_nome -> Nome do boto, palavra unica e sem espaos ou caracteres especiais
 - p_label  -> Label do boto
 - p_click   -> Evento de click
 - p_barra  -> Funo completa para inserir o boto na barra (parent.document.getElementById('barra_botoes_top').appendChild(obj))
*/
		
function f_cria_botao (p_nome, p_label, p_click, p_barra) {
	// Cria o objeto BOTAO
	var obj = parent.document.createElement('button');
	// Marca como temporario para o RESETA BOTOES elimin-lo na proxima pagina
	obj.temp = 1;
	// Identifica novo boto
	obj.id = 'btn_' + p_nome;
	obj.name = 'btn_' + p_nome;
	obj.className = 'botao_cab';
	// Gera o conteudo visual do objeto
	obj.innerHTML = '<img src="_imagens/botoes/16x16/' + p_nome + '.gif" id="img_'+p_nome+'" width="16" height="16" align="absmiddle"> ' + p_label;
	// Gera evento do click no objeto
	obj.onclick = function() {  eval(p_click); } 

	// Adiciona o boto a barra determinada
               obj.temp = 1;
	p_barra.appendChild(obj);
}

/* 
Funo: Cria Option Select
Inserida: 19/01/2006 16:47
Ultima alterao: 19/01/2006 16:47
Propsito: Insere um option em um select
*/
		
function f_cria_option(p_value, p_text, p_select) {
	var v_opt = document.createElement('option');
	v_opt.value = p_value;
	v_opt.text = p_text;
	p_select.add(v_opt);
}

/* 
Funo: Currency
Inserida: 19/01/2006 16:46
Ultima alterao: 19/01/2006 16:46
Propsito: Converte um valor numerico para formatao monetaria
Ex: 1 = 1,00
*/
		
function toCurrency(v_valor) {
	var result = Math.round(v_valor)+',';
	var dec = (((Math.round(v_valor*100) % 100)<10)?'0':'')+(Math.round(v_valor*100) % 100);
	return result+dec;
}

/* 
Funo: Desabilita Todos os Campos
Inserida: 19/01/2006 15:56
Ultima alterao: 19/01/2006 15:56
Propsito: Desabilita todos os campos do formulrio
*/
		
function f_desabilita_todos_campos( ) {
  for( var i = 0; i < document.forms[0].length; i++ ) {
	if(!document.forms[ 0 ].elements[ i ].sempre_ativo || document.forms[ 0 ].elements[ i ].sempre_ativo != 1) {
		document.forms[ 0 ].elements[ i ].disabled = true;
	}
  } 
}

/* 
Funo: Desabilitar Boto
Inserida: 19/01/2006 15:51
Ultima alterao: 19/01/2006 15:51
Propsito: Desabilita um botao
*/
		
function f_desabilitar_botao( p_botao ) {
	try {
		v_img   		 = document.getElementById('img_'+ p_botao);
		v_botao          = document.getElementById('btn_'+p_botao);
		v_img.src   	 = '/_imagens/botoes/16x16/' + p_botao + '_disable.gif'; 
		v_botao.onclick	 = '';
		v_botao.disabled = true;
	} catch(e) {
		with(parent) {
			v_img   	     = document.getElementById('img_'+ p_botao);
			v_botao 	     = document.getElementById('btn_'+p_botao);
		    v_img.src   	 = '/_imagens/botoes/16x16/' + p_botao + '_disable.gif'; 
			v_botao.onclick	 = '';
			v_botao.disabled = true;
		}
	}
}

/* 
Funo: Erro Imagem
Inserida: 19/01/2006 16:42
Ultima alterao: 19/01/2006 16:42
Propsito: Trata um erro de carregamento da imagem em um img. 
display => Exibe mensagem de erro quando no for possvel carregar
Evento: onError
*/
		
function f_erro_imagem(v_image_preview, display) {
	v_image_preview.style.display = 'none';
	if(display) {
		alert('Nao foi possivel carregar esta imagem!');
	}
}

/* 
Funo: Formata Nmero Decimal
Inserida: 19/01/2006 15:52
Ultima alterao: 19/01/2006 15:52
Propsito: Filtra a entrada de dados para apenas numeros, com "," ou "."
Ex: onKeyPress="return f_formata_numero_decimal(this)"
*/
		
function f_formata_numero_decimal(objeto) {
  var k = -1;
  if (window.event && window.event.keyCode) k = window.event.keyCode;
  if(k == 44 && objeto.value.indexOf('.') == -1) objeto.value += '.';
  return (k > -1 ? ((k > 47 && k < 58) || (k == 8 || (k == 46 && objeto.value.indexOf('.') == -1 ))) : true);
}

/* 
Funo: Habilita Todos os campos
Inserida: 19/01/2006 15:58
Ultima alterao: 19/01/2006 15:58
Propsito: Habilita Todos os campos do formulrio
*/
		
function f_habilita_todos_campos( ) {
  var v_focus = true;
  for( var i = 0; i < document.forms[ 0 ].length; i++ ) {	
	
	if (!document.forms[ 0 ].elements[ i ].ativo || document.forms[ 0 ].elements[ i ].ativo != 0)
		document.forms[ 0 ].elements[ i ].disabled = false;
	
	if ( ( ( document.forms[ 0 ].elements[ i ].type == 'select-multiple' ) || ( document.forms[ 0 ].elements[ i ].type == 'select-one' ) || ( document.forms[ 0 ].elements[ i ].type == 'text' ) ) && v_focus && !document.forms[ 0 ].elements[ i ].disabled) {
		try {
			document.forms[ 0 ].elements[ i ].focus();
			v_focus = false;
		} catch(e) {}
	}
  }	
}

/* 
Funo: Habilitar Boto
Inserida: 19/01/2006 15:50
Ultima alterao: 19/01/2006 15:51
Propsito: Funo: Habilita boto
Propsito: Habilita o boto
*/
		
function f_habilitar_botao( p_botao, p_evo_click) {
	try {
		v_img = eval("document.getElementById('img_"+ p_botao + "')");
		v_botao = eval("document.getElementById('btn_"+p_botao+"')");
		v_img.src   		= '/_imagens/botoes/16x16/' + p_botao + '.gif'; 
		v_botao.onclick	    = function() { eval(p_evo_click);              };	
		v_botao.disabled = false;
	} catch(e) {
		with(parent) {
                                        try{
			v_img = document.getElementById('img_'+ p_botao );
			v_botao = document.getElementById('btn_'+p_botao);
			v_img.src   		= '/_imagens/botoes/16x16/' + p_botao + '.gif'; 
			v_botao.onclick	    = function() { eval(p_evo_click);              };	
			v_botao.disabled = false; 
                                         }catch(e) {}
		}
	}
}

/* 
Funo: Hide Hint
Inserida: 19/01/2006 15:55
Ultima alterao: 19/01/2006 15:55
Propsito: Oculta um Hint da funo show_popup
*/
		
function showhide(fld){
	var campo = document.createElement("tr") ;; 
	campo = eval(fld);
	if(campo.style.display == 'none'){
		campo.style.display ='';
	}else{
		campo.style.display ='none';
	}
                return false;
}

/* 
Funo: Image to Check
Inserida: 19/01/2006 16:36
Ultima alterao: 19/01/2006 16:36
Propsito: Transforma um img e um input type="hidden" em um checkbox, alternando as imagens conforme clicado.

*/
		
function f_img_check(obj, img_check, img_uncheck, v_field) {
	if(obj.src.indexOf(img_check) != -1) {
		v_field.value = 0;
		obj.src = img_uncheck;
	} else {
		v_field.value = 1;
		obj.src = img_check;
	}
}

/* 
Funo: Inicializa Abas
Inserida: 19/01/2006 16:29
Ultima alterao: 19/01/2006 16:29
Propsito: Inicializa uma tabela para conter abas
*/
		
function initAbas(v_id, v_aba_inicial) {
	var tbl = document.getElementById(v_id);
	var abas = tbl.rows[0].cells
	var nro_abas = abas.length;
	var corpos = new Array();
	for(var i=0;i<tbl.rows.length;i++) {
		if(i!=0) {
			corpos[corpos.length] = tbl.rows[i];
		}
	}
	var nro_corpos = corpos.length;
	if (nro_abas < nro_corpos) {
//		alert("O numero de abas  menor que o numero de corpos!");
	}
	for(var i=0;i<abas.length;i++) {
		if (i < nro_corpos) {
			if(v_aba_inicial == i) {
				abas[i].className = 'td_aba_up';
			} else {
				abas[i].className = 'td_aba_down';
			}
			abas[i].onclick = function() {
				mudaAba(corpos, abas, this);
			}
		} else {
			abas[i].className = 'td_aba_none';
		}
	}
	for(var i=0;i<corpos.length;i++) {
		if(v_aba_inicial == i) {
			corpos[i].style.display = '';
		} else {
			corpos[i].style.display = 'none';
		}
	}		
}

/* 
Funo: Limita Imagem
Inserida: 19/01/2006 16:44
Ultima alterao: 19/01/2006 16:44
Propsito: Limita as dimenses de uma imagem em um img, sem alterar a proporo
*/
		
function f_limita_imagem(v_image, v_width, v_height) {
	larga = ((v_image.width/v_image.height) > (v_width/v_height));
	if(v_image.height > v_height || v_image.width > v_width) {
		if (larga) {
			v_image.width = v_width;
		} else {
			v_image.height = v_height;
		}
	}
}

/* 
Funo: Limpa PLACA
Inserida: 19/01/2006 15:48
Ultima alterao: 19/01/2006 15:48
Propsito: Parmetros
- fld = campo PLACA a ser formatado
Chamada
- Deve ser colocada no evento onBlur
*/
		
function f_placa(fld) {
	fld.value = (fld.value.replace('-','')).toUpperCase();	
}

/* 
Funo: Limpa Select
Inserida: 19/01/2006 16:48
Ultima alterao: 19/01/2006 16:48
Propsito: Exclui todos os options do select
*/
		
function f_limpa_select(obj) {
	while (obj.options.length > 0)
		obj.options[0] = null;
}

/* 
Funo: Limpar Campos
Inserida: 19/01/2006 15:59
Ultima alterao: 19/01/2006 15:59
Propsito: Limpa todos os campos
*/
		
function f_limpar_campos() {
	  for( var i = 0; i < document.forms[ 0 ].length; i++ ) {	
		if (!document.forms[ 0 ].elements[ i ].fixo) {
			switch (document.forms[ 0 ].elements[ i ].type) {
				case 'text'     : document.forms[ 0 ].elements[ i ].value = '';
				   break;
				case 'textarea' : document.forms[ 0 ].elements[ i ].value = '';
				   break;
				case 'checkbox' : document.forms[ 0 ].elements[ i ].checked = false;
				   break;
				case 'radio'    : document.forms[ 0 ].elements[ i ].checked = false;
				   break;
				case 'select-one' : document.forms[ 0 ].elements[ i ].value = '';
				   break;
				case 'select-multiple' : document.forms[ 0 ].elements[ i ].value = '';
				   break;
				case 'hidden' : document.forms[ 0 ].elements[ i ].value = '';
				   break;
			}
		}
	  }	
	 //document.forms[ 0 ].reset();
}

/* 
Funo: Marca Checks
Inserida: 19/01/2006 16:28
Ultima alterao: 19/01/2006 16:28
Propsito: Marca todos os itens de um check group
*/
		
function f_marca_todos( p_check_name ) {
  for (var i = 0;i<document.forms[0].elements.length; i++) {		
    if ( (document.forms[0].elements[i].type == 'checkbox') && (p_check_name == document.forms[0].elements[i].name) )
       document.forms[0].elements[i].checked = true;	
  }
}

/* 
Funo: Maskara de Formatao
Inserida: 19/01/2006 15:56
Ultima alterao: 19/01/2006 15:56
Propsito: Formata um campo de acordo com uma maskara pr-determinada.
0 indica caracteres somente numericos
X indica caracteres alfa numericos
Ex: 
Formatao de datas
onKeyPress="return f_formata(this, '00/00/0000')
*/
		
function f_formata(obj, mask) {
	var k = -1;
	if (window.event && window.event.keyCode ) k = window.event.keyCode;
	if(mask.substring(obj.value.length, obj.value.length+1) == '0') {
		ret = (k > -1 ? ((k > 47 && k < 58)) : true);
	} else if (mask.substring(obj.value.length, obj.value.length+1) == 'X') {
		ret = true;
	} else {
		if (mask.substring(obj.value.length, obj.value.length+1) != k) {
			ret = true;
		} else {
			ret = false;
		}
		obj.value = obj.value+mask.substring(obj.value.length, obj.value.length+1 );
		if(mask.substring(obj.value.length, obj.value.length+1) == '0') {
			ret = (k > -1 ? ((k > 47 && k < 58)) : true);
		} else if (mask.substring(obj.value.length, obj.value.length+1) == 'X') { 
			ret = true;
		}  
	}
	return ((!(obj.value.length>(mask.length-1)))&&ret);
}

/* 
Funo: Mostra Erro
Inserida: 19/01/2006 16:31
Ultima alterao: 19/01/2006 16:31
Propsito: f_erro(p_mensagem, p_campo, form) : Mostra mensagem de erro e posiciona o cursor no campo que disparou o erro
	* variveis *
	  - p_mensagem : mensagem que deve ser mostrada
	  - p_campo : campo que disparou o erro
	  - form : formulario
*/
		
function f_erro(p_mensagem, p_campo, form) {
     try {
	alert(p_mensagem);
	if (form.MENSAGEM) 
        form.MENSAGEM.value = p_mensagem;
	if (p_campo.type == 'select-one') 
		p_campo.focus();
	if (p_campo.type == 'text') 
		p_campo.select();
     } catch(e) {}
	return false;
}

/* 
Funo: Muda Aba
Inserida: 19/01/2006 16:30
Ultima alterao: 19/01/2006 16:30
Propsito: Muda a aba atual selecionada
*/
		
function mudaAba(v_tbody, v_tr, obj) {
	tb = v_tbody;
	tr = v_tr;
	var sel = -1;
	for(var i=0;i<tr.length;i++) {
		if (i < tb.length) {
			if (tr[i] == obj) {
				sel = i;
				tr[i].className = 'td_aba_up';
			} else {
				tr[i].className = 'td_aba_down';
			}
		}
	}
	for(var i=0;i<tb.length;i++) {
		if (i == sel) {
			tb[i].style.display = '';
		} else {
			tb[i].style.display = 'none';
		}
	}			
}

/* 
Funo: New Window
Inserida: 19/01/2006 16:32
Ultima alterao: 19/01/2006 16:32
Propsito: Exibe uma nova janela, sem as barras de ferramentas
*/
		
function NewWindow(mypage, myname, w, h, scroll) {
	var winl = (screen.width - w) / 2;
	var wint = (screen.height - h) / 2;
	winprops = 'height='+h+',width='+w+',top='+wint+',left='+winl+',scrollbars='+scroll+',resizable,status'
	win = window.open(mypage, myname, winprops)
	if (parseInt(navigator.appVersion) >= 4) { win.window.focus(); }
}

/* 
Funo: Prototype Dtos
Inserida: 19/01/2006 16:58
Ultima alterao: 19/01/2006 16:58
Propsito: ???
*/
		
Date.prototype.Dtos = function(){
		var dd = this.getDate();
		var mm = this.getMonth() + 1;
		var yy = this.getFullYear();
		
		return( [ yy , ( mm < 10 ? '0' : '' ) + mm , ( dd < 10 ? '0' : '' ) + dd ].join( '' ) );
	}

/* 
Funo: Prototype hasEmptyElements
Inserida: 19/01/2006 16:58
Ultima alterao: 19/01/2006 16:58
Propsito: Verifica se um array possui elementos em branco, nulos ou indefinidos
*/
		
Array.prototype.hasEmptyElements = function(){
		for ( var i = 0 ; i < this.length ; i++ )
			if ( ( this[ i ] == '' ) || ( this[ i ] == null ) || ( this[ i ] == undefined ) )
				return( true );
		return( false );
	}

/* 
Funo: Prototype isCNPJ
Inserida: 19/01/2006 16:50
Ultima alterao: 20/01/2006 08:44
Propsito: Verifica se o valor da string  um CNPJ vlido
*/
		
String.prototype.isCNPJ = function() {
	return testacnpj(this);
}

/* 
Funo: Prototype isCPF
Inserida: 19/01/2006 16:52
Ultima alterao: 20/01/2006 08:43
Propsito: Verifica se o valor da String  um CPF
*/
		
String.prototype.isCPF = function(){
    return testacpf(this);
}

/* 
Funo: Prototype isDataHora
Inserida: 19/01/2006 16:54
Ultima alterao: 19/01/2006 16:54
Propsito: Verifica se o valor da String  uma data/Hora no formata dd/mm/yyyy HH:MM vlida.
*/
		
String.prototype.isDataHora = function(){
		var pt = this.split( '/' );
		var dt = new Date();
		var dd = Number( pt[ 0 ] );
		var mm = Number( pt[ 1 ] );
		var yy = Number(this.substr(6,4));
		var hh = this.substr(11,2);
		var mi = this.substr(14,2);

		// Data sem HORA
		if ( this.length < 15 ) return false ;
		
		// Caso seja preenchida com segundos
		if (this.length > 15) 
			var ss = this.substr(17,2); 
		else 
			var ss = '00';

		if ( !( ( hh >= 00 ) && ( hh < 24 ) && ( mi >= 00 ) && ( mi < 60 ) && ( ss >= 00 ) && ( ss < 60 ) ) )
		   return( false );
			
		if ( pt.length < 3 ) return( false );
		
		if ((mm == 1 || mm == 3 || mm == 5 || mm == 7 || mm == 8 || mm == 10 || mm == 12) && (dd <= 0 || dd > 31)) return false;
			
		if ((mm == 4 || mm == 6 || mm == 9 || mm == 11 ) && (dd <= 0 || dd > 30)) return false;

		if ((mm == 2 ) && (dd <= 0 || (yy%4 == 0 && dd > 29 ) || (yy%4 != 0 && dd > 28 ))) return false;

		if (yy < 1900 || yy > 2100) return false;
		return true;
//		dt.setFullYear( yy , mm - 1 , dd );

//		return( [ yy , ( mm < 10 ? '0' : '' ) + mm , ( dd < 10 ? '0' : '' ) + dd ].join( '' ) == dt.Dtos() );
	}

/* 
Funo: Prototype isDate
Inserida: 19/01/2006 16:55
Ultima alterao: 19/01/2006 16:55
Propsito: Verifica se o valor da string  uma data valida
*/
		
String.prototype.isDate = function(){
		var pt = this.split( '/' );
		var dt = new Date();
		var dd = Number( pt[ 0 ] );
		var mm = Number( pt[ 1 ] );
		var yy = Number( pt[ 2 ] );
		
		if ( pt.length != 3 ) return( false );

		dt.setFullYear( yy , mm - 1 , dd );
		
		if (mm <= 12 && dd <= 31 && yy > 1900 && yy < 2050) 
		   return( true );
	}

/* 
Funo: Prototype isMail
Inserida: 19/01/2006 16:51
Ultima alterao: 19/01/2006 16:51
Propsito: Verifica se o valor da String  um e-mail
*/
		
String.prototype.isMail = function(){
		var test
		var pt1    = this.split( '@' );
		var valid = '.-_@';
		
		if ( ( pt1.length != 2 ) || ( pt1[ 0 ].length == 0 ) || ( pt1[ 1 ].length == 0 ) ) return( false );
		else {
			for ( var i = 0 ; i < valid.length - 1 ; i++ ){
				if ( pt1[ 0 ].split( valid.charAt( i ) ).hasEmptyElements() ) return( false );
				if ( pt1[ 1 ].split( valid.charAt( i ) ).hasEmptyElements() ) return( false );
			}			
		}
		
		for ( var i = 0 ; i < this.length ; i++ ){
			var v_char = this.toUpperCase().charCodeAt( i );
			if ( valid.indexOf( String.fromCharCode( v_char ) ) == -1 )
				if ( !( ( ( v_char >= 65 ) && ( v_char <= 90 ) ) || ( ( v_char >= 48 ) && ( v_char <= 57 ) ) ) ) return( false );
		}	
		
		return( true );
	}

/* 
Funo: Prototype isNumber
Inserida: 19/01/2006 16:56
Ultima alterao: 19/01/2006 16:56
Propsito: Verifica se o valor da string  um numero
*/
		
String.prototype.isNumber = function(){
		return( !isNaN( this.split( '.' ).join( '' ).split( ',' ).join( '' ).split( '-' ).join( '' ) ) );
	}

/* 
Funo: Prototype isPlaca
Inserida: 19/01/2006 16:56
Ultima alterao: 19/01/2006 16:56
Propsito: Verifica se o valor de uma string  uma placa valida no formato 'XXX0000'
*/
		
String.prototype.isPlaca = function(){
		if ( this.length != 7) return( false );
		v_num = this.substr(3,4);
		if ( !isNaN( v_num ) ) return( false );
		return( true );
	}

/* 
Funo: Show Hint
Inserida: 19/01/2006 15:54
Ultima alterao: 19/01/2006 15:54
Propsito: Mostra um hint, s funciona em IE.
*/
		
function show_popup(current,e,comentario) {
	var oPopup = window.createPopup();
	var oPopupBody = oPopup.document.body;
	oPopupBody.style.backgroundColor = "lightyellow";
	oPopupBody.style.border = "solid black 1px";    
	oPopupBody.style.fontFamily = "Verdana, Geneva, Arial, Helvetica, sans-serif";
	oPopupBody.style.fontSize = "10px";
	oPopupBody.scroll = "yes";
	
	var altura = 1;
	var largura = 320;
	var deslocamento = (parseInt(current.offsetHeight)+5);
	
	if (comentario.length > 45)
	  altura = Math.ceil(comentario.length/45);
	else
	  largura = Math.ceil(comentario.length * 8);
	 
	oPopupBody.innerHTML = comentario; 
	
	if ((current.type == 'select-one') || (current.type == 'select-multiple')) {
	   if (altura == 1)
		   deslocamento = -1*(parseInt(current.offsetHeight)+5);
	   else
		   deslocamento = -1*(parseInt(current.offsetHeight)+(10*altura));
	}
	
	oPopup.show(0, deslocamento, largura, 15*altura, current);
}

/* 
Funo: Show Modal
Inserida: 19/01/2006 16:44
Ultima alterao: 19/01/2006 16:44
Propsito: Abre uma nova janela de forma Modal
*/
		
function showModal( p_pagina, p_target, p_resize, p_scroll, p_status, p_width, p_height )
{
 var path     = p_pagina.split('/');
 var pagina   = path[ path.length -1 ].split('?');
	 resize	  = ( p_resize != null || p_resize != 0 ) ? p_resize : false;
	 scrol 	  = ( p_scroll != null || p_scroll != 0 ) ? p_scroll : false;
	 status   = ( p_status != null || p_status != 0 ) ? p_status : '';
	 width	  = ( p_width  != null || p_width  != 0 ) ? p_width  : 0;
	 height	  = ( p_height != null || p_height != 0 ) ? p_height : 0; 
	 esquerda = ( screen.width  ) ? ( screen.width  - parseInt( width )  ) / 2 : 0;
	 topo	  = ( screen.height ) ? ( screen.height - parseInt( height ) ) / 2 : 0; 
	 win 	  = window.open( p_pagina, p_target ,'height='+ height +', width='+ width +', left='+ esquerda + ', top=' + topo + ', toolbar=0, location=0,directories=0,status='+ status +',menuBar=0,scrollBars='+ scrol +',resizable=' + resize + '');

	 win.focus(); 
}

/* 
Funo: Testa CNPJ
Inserida: 19/01/2006 16:37
Ultima alterao: 19/01/2006 16:37
Propsito: Testa a validade de um nro de cnpj
*/
		
function testacnpj(cnpj)
{
  while (cnpj.indexOf('.') > 0)
  {
    cnpj= cnpj.replace('.', '');
  }
  while (cnpj.indexOf('-') > 0)
  {
    cnpj = cnpj.replace('-', '');
  }
  while (cnpj.indexOf('/') > 0)
  {
    cpnj = cnpj.replace('/', '');
  }
  res = false;
  digito = 0;
  if(cnpj.length == 14)
  {
    cnpjdv = cnpj.substring(12, 14);
        digito = 0;
        controle = "";
        for(i=0;i<2;i++)
        {
          soma = 0;
          for(j=0;j<12;j++)
          {
            soma += (cnpj.substring(j, j+1)*1)*((11+i-j)%8+2);
          }
          if(i == 1)
          {
            soma += digito * 2;
          }
          digito = 11 - soma%11;
          if (digito > 9)
          {
            digito = 0;
          }
          controle = controle+""+digito;
    }
        if(controle == cnpjdv)
        {
          res = true;
        }
  }
  return res;
}

/* 
Funo: Testa CNPJ/CPF
Inserida: 19/01/2006 16:39
Ultima alterao: 19/01/2006 16:39
Propsito: Testa a validade de um CNPJ ou CPF, de acordo com o tamanho do nro passado
*/
		
function testacpfcnpj(cpfcnpj)
{
  if(cpfcnpj.length == 14)
  {
    return testacnpj(cpfcnpj);
  }
  else
  {
    return testacpf(cpfcnpj);
  }
}

/* 
Funo: Testa CPF
Inserida: 19/01/2006 16:38
Ultima alterao: 19/01/2006 16:38
Propsito: Testa a validade de um nro de CPF
*/
		
function testacpf(cpf)
{
  while (cpf.indexOf('.') > 0)
  {
    cpf = cpf.replace('.', '');
  }
  while (cpf.indexOf('-') > 0)
  {
    cpf = cpf.replace('-', '');
  }
  while (cpf.indexOf('/') > 0)
  {
    cpf = cpf.replace('/', '');
  }
  if(cpf == '00000000000')
  {
    return true;
  }
  digito1 = 0;
  digito2 = 0;
  if(cpf.length == 11)
  {
    for(i=0;i<9;i++)
        {
          digito1 += (cpf.substring(i, i+1)*1)*(10-i);
        }
        if ((digito1%11==1)||(digito1%11==0))
        {
          digito1 = 0;
        }
        else
        {
          digito1 = 11-(digito1%11);
        }
        for (i=0;i<10;i++)
        {
          digito2 += (cpf.substring(i, i+1)*1)*(11-i);
        }
        if ((digito2%11==1)||(digito2%11==0))
        {
          digito2 = 0;
        }
        else
        {
          digito2 = 11 - (digito2%11);
        }
        return ((digito1+""+digito2)==cpf.substring(9, 11));
  }
  else
  {
    return false;
  }
}

/* 
Funo: Valor do Campo
Inserida: 19/01/2006 16:47
Ultima alterao: 19/01/2006 16:47
Propsito: Busca o valor de um campo em um formulrio
*/
		
function f_valor_campo(p_campo, p_form) {
	var value = '';
	var j = 0;
	for(var i=0;i<p_form.elements.length;i++) {
		if(p_form.elements[i].name == p_campo && !p_form.elements[i].disabled) {
			switch(p_form.elements[i].type) {
				case 'radio':
					if (p_form.elements[i].checked) {
						return p_form.elements[i].value;
					}
					break;
				case 'checkbox':
					if (p_form.elements[i].checked) {
						if (j != 0) {
							value += ',';
						}
						value += p_form.elements[i].value;
					}
					break;
				default:
					if (j != 0) {
						value += ',';
					}
					value += p_form.elements[i].value;
					break;				
			}
		}
	}
}

/* 
Funo: Verifica Form
Inserida: 19/01/2006 16:33
Ultima alterao: 19/01/2006 16:33
Propsito: f_verifica_form(formulario) : Verifica os dados do formulario, o que pode ser feito apenas em uma secao do form
	* variveis *
	  - formulario : nome do formulario
	  - secao : Opcional, indica que a verificao deve ser feita apenas em uma parte do form
*/
		
function f_verifica_form(formulario) {
	var args=f_verifica_form.arguments;
	// Verifica apenas umas secao do formulario
	var secao = false;
	if (args.length == 2) secao = true;	
	for (var i = 0; i<formulario.length; i++) {
 	    
 	    if (secao) {
		    if (args[1] == formulario.elements[i].secao) 
				if ((formulario.elements[i].obrigatorio == 1) && (!formulario.elements[i].value) && (!formulario.elements[i].disable)) {
					mensagem = 'O campo '+formulario.elements[i].display+' '+String.fromCharCode(233)+' requerido.';
					return f_erro(mensagem,formulario.elements[i], formulario);
				}
		}
		else {
			if ((formulario.elements[i].obrigatorio == 1) && (!formulario.elements[i].value) && (!formulario.elements[i].secao)&& (!formulario.elements[i].disable)) {
				mensagem = 'O campo '+formulario.elements[i].display+' '+String.fromCharCode(233)+' requerido.';
				return f_erro(mensagem,formulario.elements[i], formulario);
			}
	        }
		
 	    if (secao) {
		    if (args[1] == formulario.elements[i].secao) {
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'numerico') && (!formulario.elements[i].value.isNumber()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser num'+String.fromCharCode(233)+'rico.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'data') && (!formulario.elements[i].value.substr(0,10).isDate()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma data v'+String.fromCharCode(225)+'lida.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'data_hora') && (!formulario.elements[i].value.isDataHora()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma data e hora v'+String.fromCharCode(225)+'lida, no formato (dia/m'+String.fromCharCode(234)+'s/ano hora:minuto).';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'cpf') && (!formulario.elements[i].value.isCPF()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um n v'+String.fromCharCode(225)+'lido de CPF.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'email') && (!formulario.elements[i].value.isMail()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um e-mail.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'cnpj') && (!formulario.elements[i].value.isCNPJ()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um CNPJ v'+String.fromCharCode(225)+'lido.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }	
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'placa') && (!formulario.elements[i].value.isPlaca()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma placa v'+String.fromCharCode(225)+'lida..';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }	
			   }
			}
		else {
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'numerico') && (!formulario.elements[i].value.isNumber()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser num'+String.fromCharCode(233)+'rico.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'data') && (!formulario.elements[i].value.substr(0,10).isDate()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma data v'+String.fromCharCode(225)+'lida.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'data_hora') && (!formulario.elements[i].value.isDataHora()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma data e hora v'+String.fromCharCode(225)+'lida, no formato (dia/m'+String.fromCharCode(234)+'s/ano hora:minuto).';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'cpf') && (!formulario.elements[i].value.isCPF()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um n v'+String.fromCharCode(225)+'lido de CPF.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'email') && (!formulario.elements[i].value.isMail()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um e-mail.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'cnpj') && (!formulario.elements[i].value.isCNPJ()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um CNPJ v'+String.fromCharCode(225)+'lido.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }						
	     }
	}
	return true;
}

/* 
Funo: Verifica Separador Numerico
Inserida: 19/01/2006 15:49
Ultima alterao: 19/01/2006 15:49
Propsito: f_verifica_separador(fld) : Verifica o separador de um campo numrico, se o usuario digitar ',' substitui por '.'
	* variveis *
	  - fld : Objeto
	* chamada *
    f_verifica_separador(this);
*/
		
function f_verifica_separador(fld)
{
	if ((fld.value).indexOf(',') != -1) {
	  fld.value = fld.value.substr(0,fld.value.length - 1);
	  fld.value = fld.value + '.';
    }
	if(isNaN(fld.value)) {
	  alert("Digite somente nmeros neste campo.");
	  fld.value = fld.value.substr(0,fld.value.length - 1);
    }
}

/* 
Funo: Verifica Tipo do Campo
Inserida: 19/01/2006 15:53
Ultima alterao: 19/01/2006 15:53
Propsito: Retorno TRUE se o campo  controlado pela funo CONTROLA CAMPOS
*/
		
function f_verifica_tipo( p_campo )
{
	switch( p_campo.type ) 
	{
				case 'text' : 
				case 'select-one' : 
				case 'select-multiple' : 
				case 'textarea' : 
				case 'password' : 
					
					return ( true );
				
			   default :	
					return ( false );
	}

}

