var campos 	  			= document.cookie;
var hoje 	  			= new Date();
var expirar   			= new Date( hoje.getTime() + 28 * 24 * 60 * 60 * 1000 ); 
var horas    			= hoje.getHours();
var minutos  			= hoje.getMinutes();
var segundos 			= hoje.getSeconds();
var dia      			= hoje.getDate();
var mes      			= hoje.getMonth();
var ano      			= hoje.getFullYear();

// Browser Lib
 
/**
 * @descritivo	: Detecta Navegador 
 * @parametro	: sem parmetros
 * @retorno		: Data
 * @autor       : Desconhecido
 * @verso		: 1, 11  de Junho de 2004
 */					
function xbDetectBrowser()
{
 var platform;
 var oldOnError 	   	  = window.onerror;
 var element    	   	  = null;
	 window.onerror 	  = null;
	 window.saveNavigator = window.navigator;// work around bug in xpcdom Mozilla 0.9.1
	 navigator.OS    	  = '';
	 navigator.version  	 = parseFloat( navigator.appVersion );
	 navigator.org    	  = '';
	 navigator.family  	  = '';
	  
	 if( typeof( window.navigator.platform ) != 'undefined')
	 {
	   platform = window.navigator.platform.toLowerCase();
	   
	   if( platform.indexOf('win') != -1 )
		   navigator.OS = 'win';
	   else if( platform.indexOf('mac') != -1 )
		   navigator.OS = 'mac';
	   else if( platform.indexOf('unix') != -1 || platform.indexOf('linux') != -1 || platform.indexOf('sun') != -1 )
		   navigator.OS = 'nix';
	 }
	
	  var i  = 0;
	  var ua = window.navigator.userAgent.toLowerCase();
	  
	  if( ua.indexOf('opera') != -1 )
	  {
		
		i 				   = ua.indexOf('opera');
		navigator.family   = 'opera';
		navigator.org      = 'opera';
		navigator.version  = parseFloat('0' + ua.substr( i + 6 ), 10);
		
	  } else if( ( i = ua.indexOf('msie') ) != -1 ) {
		
		navigator.org      = 'microsoft';
		navigator.version  = parseFloat('0' + ua.substr( i + 5 ), 10);
		navigator.family   = ( navigator.version < 4  )? 'ie3':'ie4';
	  } else if( ua.indexOf('gecko') != -1 ) {
		  
		navigator.family   = 'gecko';
		var rvStart        = ua.indexOf('rv:');
		var rvEnd   	   = ua.indexOf(')', rvStart);
		var rv      	   = ua.substring(rvStart + 3, rvEnd );
		var rvParts 	   = rv.split('.');
		var rvValue 	   = 0;
		var exp     	   = 1;
	
		for( var i = 0; i < rvParts.length; i++ )
		{
		  var val  = parseInt( rvParts[ i ] );
		  rvValue += val / exp;
		  exp 	  *= 100;
		}
		navigator.version   = rvValue;
	
		if( ua.indexOf('netscape') != -1 )
		  navigator.org = 'netscape';
		else if(ua.indexOf('compuserve') != -1)
		  navigator.org = 'compuserve';
		else
		  navigator.org = 'mozilla';
		  
	  } else if( ( ua.indexOf('mozilla') !=-1) && (ua.indexOf('spoofer')==-1) && (ua.indexOf('compatible') == -1) && (ua.indexOf('opera')==-1)&& (ua.indexOf('webtv')==-1) && (ua.indexOf('hotjava')==-1)) {
		
		var is_major = parseFloat(navigator.appVersion);
			if( is_major < 4 )
			  navigator.version = is_major;
			else
			{
			  i = ua.lastIndexOf('/')
			  navigator.version = parseFloat('0' + ua.substr( i + 1 ), 10);
			}
			  navigator.org    = 'netscape';
			  navigator.family = 'nn' + parseInt( navigator.appVersion );
			  
	 } else if((i = ua.indexOf('aol')) != -1 )  {
		// aol
			  navigator.family   	   = 'aol';
			  navigator.org      	   = 'aol';
			  navigator.version  	   = parseFloat('0' + ua.substr( i + 4 ), 10);
			  
	  } else if( ( i = ua.indexOf('hotjava') ) != -1 )  {
		// hotjava
			  navigator.family  	   = 'hotjava';
			  navigator.org    		   = 'sun';
			  navigator.version  	   = parseFloat(navigator.appVersion);
	  }
	   window.onerror = oldOnError;
}
	// Detecta navegador
	xbDetectBrowser();	
/*
=============================================================================================	
=============================================================================================	
================================ DESENVOLVIDO PELA KMM ======================================	
=============================================================================================	
=============================================================================================	

==================================================================
currencyFormat(fld, milSep, decSep, e) : converte para valor numrico com separadores decimais
	* variveis *
	 - fld - Nome do campo
	 - milSep - Separador do MILHAR
	 - decSep - Separador do DECIMAL
	 - e - evento 
	* chamada *
    onKeyPress="return(currencyFormat(this,',','.',event))"
==================================================================
*/
function currencyFormat(fld, milSep, decSep, e) {
	var sep = 0; 
	var key = '';
	var i = j = 0;
	var len = len2 = 0;  
	var strCheck = '0123456789';
	var aux = aux2 = ''; 
	var whichCode = (window.Event) ? e.which : e.keyCode;
	
	if (whichCode == 13) return true;  // Enter
		key = String.fromCharCode(whichCode);  // Get key value from key code

	if (strCheck.indexOf(key) == -1) return false;  // Not a valid key
		len = fld.value.length;
	
	for(i = 0; i < len; i++)
		if ((fld.value.charAt(i) != '0') && (fld.value.charAt(i) != decSep)) break;
			aux = '';
	for(; i < len; i++)
		if (strCheck.indexOf(fld.value.charAt(i))!=-1) aux += fld.value.charAt(i);
			aux += key;

	len = aux.length;
	
	if (len == 0) fld.value = '';
	if (len == 1) fld.value = '0'+ decSep + '0' + aux;
	if (len == 2) fld.value = '0'+ decSep + aux;
	if (len > 2) {
		aux2 = '';
		for (j = 0, i = len - 3; i >= 0; i--) {
			if (j == 3) {
				aux2 += milSep;
				j = 0;
			}
			aux2 += aux.charAt(i);
			j++;
		}
		fld.value = '';
		len2 = aux2.length;
		for (i = len2 - 1; i >= 0; i--)
			fld.value += aux2.charAt(i);
		fld.value += decSep + aux.substr(len - 2, len);
	}
	return false;
}

/*
==================================================================
data.dataAdd( intervalo, num_dias ) : Adiciona perodo a uma data
	* variveis *
	  - data        = new Date() ;
	  - intervalo 	= 'D';
	  - num_dias	= 15;
	* chamada *
    temp = ( data.dataAdd( intervalo, num_dias ) );
==================================================================
*/

Date.prototype.dataAdd = function ( p_intervalo, p_num_dias ) { return DateAdd( this, p_intervalo, p_num_dias ); } 
			
function DateAdd( p_data_inicial, p_intervalo , p_num_dias )
{
	var stDatams = Date.parse( p_data_inicial );

	switch ( p_intervalo.toUpperCase() )
	{
		case 'D': p_num_dias *=   24; 	// dias para horas
		case 'H': p_num_dias *=   60; 	// horas para minutos
		case 'M': p_num_dias *=   60;   // minutos para segundos
		case 'S': p_num_dias *= 1000;  break; // segundos para milisegundos
	}
	return ( new Date( stDatams + p_num_dias ) );

}


/*
==================================================================
f_formata_data_hora(fld) : Adiciona marcara a campo data/hora
	* variveis *
	  - fld : Objeto;
	* chamada *
    onKeyUp="f_formata_data_hora(this)";
==================================================================
*/
function f_formata_data_hora(fld) {
 key = window.event.keyCode;
 if (key!=8 && key!=37 && key!=39 && key!=9 && key!=16){
    if ((fld.value).length == 2 || (fld.value).length == 5) {
       fld.value += '/';
      }
    if ((fld.value).length == 10) {
       fld.value += ' ';
      }
    if ((fld.value).length == 13) {
       fld.value += ':';
      }
    if ((fld.value).indexOf('//') != -1) {
       fld.value = fld.substring(0,(fld.value).length -1);
      }
    return; 
  }
}

/*
==================================================================
f_formata_data(fld) : Adiciona marcara a campo data
	* variveis *
	  - fld : Objeto;
	* chamada *
    onKeyUp="f_formata_data(this)";
==================================================================
*/
function f_formata_data(fld) {
 key = window.event.keyCode;
 if (key!=8 && key!=37 && key!=39 && key!=9 && key!=16){
    if ((fld.value).length == 2 || (fld.value).length == 5) {
       fld.value += '/';
      }
    if ((fld.value).indexOf('//') != -1) {
       fld.value = fld.substring(0,(fld.value).length -1);
      }
    return; 
  }
}

/*
==================================================================
f_formata_hora(fld) : Adiciona marcara a campo hora
	* variveis *
	  - fld : Objeto;
	* chamada *
    onKeyUp="f_formata_hora(this)";
==================================================================
*/
function f_formata_hora(fld) {
 key = window.event.keyCode;
 if (key!=8 && key!=37 && key!=39 && key!=9 && key!=16){
    if ((fld.value).length == 2) {
       fld.value += ':';
      }
    if ((fld.value).indexOf('::') != -1) {
       fld.value = fld.substring(0,(fld.value).length -1);
      }
    return; 
  }
}

/*
==================================================================
f_arredondamento(valor) : Arredonda valores para duas casas decimais
	* variveis *
	  - valor : Valor que deve ser arredondado;
	* chamada *
    f_arredondamento('100,999999');
==================================================================
*/
function f_arredondamento(valor) {

  var valor_calc = valor.toString(); // Transforma o valor para String
  if (valor_calc.indexOf('.') != -1) { //verifica se o numero tem casas decimais pelo '.'
     decimais = valor_calc.substr(valor_calc.indexOf(".")+1,2); // armazena as duas casas decimais
	
	digito = valor_calc.substr(valor_calc.indexOf(".") + 3,1); // armazena o terceiro digito decimal do numero
	
	if (digito > 5) { // verifica se o terceiro digito  maior que 5 para arredondar o proximo
    	decimal = decimais+digito; //todo o conteudo da decimal a ser arredondada  concatenado numa mesma varvel, apenas para facilitar
		if (decimais == 99) { //caso o numero seja por ex: 4.9999999 o arredondamento  feito direto para o prximo inteiro neste caso 5
	   	    valor = parseInt(valor) + 1; 
			decimais = '.00';
			return(valor+decimais);
	     }
	if (decimal.substr(0,1) == 0) decimal = decimal.substr(1,2);
   		decimais = parseInt(decimal) + (10-parseInt(digito)); //o valor das decimais de sada  arredondade usando a formula (valor + (10-digito)) que vai dar o interiro da para este valor
	if (decimais.toString().length < 3) decimais = '0' + decimais;
   }
 }
 else decimais = '00'; // caso no hajam casas decimais no numero apenas lhe  acrescido 00

 decimais = '.'+decimais.toString().substr(0,2); // o valor das decimais est com 3 casas, pega-se a duas primeiras e inclui-se o ponto antes
 valor = parseInt(valor) + decimais.toString(); // concatena-se o valor de entrada inteiro mais as decimais
 
 if (!(valor.toString().substr(valor_calc.indexOf(".") + 2,1))) valor = valor+'0';
 
 return(valor); //retorno do valor arredondado
}


/*
==================================================================
f_verifica_separador(fld) : Verifica o separador de um campo numrico, se o usuario digitar ',' substitui por '.'
	* variveis *
	  - fld : Objeto
	* chamada *
    f_verifica_separador(this);
==================================================================
*/
function f_verifica_separador(fld)
{
	if ((fld.value).indexOf(',') != -1) {
	  fld.value = fld.value.substr(0,fld.value.length - 1);
	  fld.value = fld.value + '.';
    }
	if(isNaN(fld.value)) {
	  alert("Digite somente nmeros neste campo.");
	  fld.value = fld.value.substr(0,fld.value.length - 1);
    }
}

/*
==================================================================
f_confere_data(data_verificar,data_base,mensagem,controle) : Verifica uma data em relao a uma data limite
	* variveis *
	  - data_verificar : data que vai ser verificada
	  - data_base : data limite
	  - mensagem : mensagem caso a data esteja superior a data limite
	  - controle : variavel de retorno
	* chamada *
    f_confere_data(data_1, data_limite, 'Teste', v_controle);
==================================================================
*/function f_confere_data(data_verificar,data_base,mensagem,controle) {
 if (data_verificar) {
   ano = data_base.substr(0,4);
   mes = data_base.substr(5,2);
   dia = data_base.substr(8,2);

   dia_verifica = data_verificar.substr(0,2);
   mes_verifica = data_verificar.substr(3,2);
   ano_verifica = data_verificar.substr(6,4);
   if (!((parseInt(dia_verifica) > parseInt(dia)) && ((parseInt(mes_verifica) >= parseInt(mes))) || (parseInt(mes_verifica) > parseInt(mes)) || (parseInt(ano_verifica) > parseInt(ano)))) {
     alert(mensagem);
	 controle = -1;
    }	 
	else controle = 1
  }	 
   return(controle); 
}

/*
==================================================================
f_controla_campos(num_forms) : Cria show messagem para os campos, inclusive pode gerar tabindex
	* variveis *
	  - num_forms : numero de formularios da tela
	  - cria_tab_index : parmetro deve ser passado caso o desenvolvedor desejar a criao automtica do tanindex dos forms
	* chamada *
    windown.onload = function() { f_controla_campos(1); }
==================================================================
*/
function f_controla_campos(num_forms) {
    var v_controla_tab_index = false;
	var args = f_controla_campos.arguments;

    if (args.length > 1) 
	   var v_controla_tab_index = true;
	   
	for (var j = 0; j<num_forms; j++) {  
	    var formulario = eval(document.forms[j]);
		for (var i = 0; i<formulario.length; i++) {		
			// Limpar todos os TABINDEX
			if (v_controla_tab_index) 
				formulario.elements[i].tabIndex = 0;		
			if (formulario.elements[i].onfocus) {
				formulario.elements[i].v_funcao_focus = formulario.elements[i].onfocus;
				formulario.elements[i].onfocus = function() { 
																v_funcao = String(this.v_funcao_focus).replace('function anonymous()','');
																v_funcao = String(v_funcao).replace('}','');
																v_funcao = String(v_funcao).replace('{','');																
																v_funcao = Trim(v_funcao);
																eval(v_funcao);											
																if (f_verifica_tipo(this)) {
																	event.srcElement.style.backgroundColor='#FFFFDD'; 
																	event.srcElement.style.color = '#000000';
																}
																if (event.srcElement.hint) 
																   show_popup(event.srcElement,event,event.srcElement.hint);
															}
			}
			else 
				formulario.elements[i].onfocus = function() { 
												              if (f_verifica_tipo(this)) { 
															     event.srcElement.style.backgroundColor='#FFFFDD'; 
 																 event.srcElement.style.color = '#000000';
															  }
															  if (event.srcElement.hint) 
																show_popup(event.srcElement,event,event.srcElement.hint);
															}

			if (v_controla_tab_index) 
				formulario.elements[i].tabIndex = i+1;   
				
			if (f_verifica_tipo(formulario.elements[i])) {
					
				formulario.elements[i].onhelp = function() { show_popup(event.srcElement,event,event.srcElement.hint); }
				
				if (formulario.elements[i].onblur) {
					formulario.elements[i].v_funcao = formulario.elements[i].onblur;
					formulario.elements[i].onblur = function() { 
																v_funcao = String(this.v_funcao).replace('function anonymous()','');
																v_funcao = String(v_funcao).replace('}','');
																v_funcao = String(v_funcao).replace('{','');																
																v_funcao = Trim(v_funcao);
																eval(v_funcao);																
					                                            event.srcElement.style.backgroundColor='';
																event.srcElement.style.color = '';
																window.status = '';
																}
				}
				else
					formulario.elements[i].onblur = function() {  
																 event.srcElement.style.backgroundColor='';
															     event.srcElement.style.color = '';
																 window.status = '';
															   }															   
			}
		}	
	}
	window.status = ''; 
}

/*
==================================================================
f_verifica_form(formulario) : Verifica os dados do formulario, o que pode ser feito apenas em uma secao do form
	* variveis *
	  - formulario : nome do formulario
	  - secao : Opcional, indica que a verificao deve ser feita apenas em uma parte do form
==================================================================
*/

function f_verifica_form(formulario) {
	var args=f_verifica_form.arguments;
	// Verifica apenas umas secao do formulario
	var secao = false;
	if (args.length == 2) secao = true;	
	for (var i = 0; i<formulario.length; i++) {
 	    
 	    if (secao) {
		    if (args[1] == formulario.elements[i].secao) 
				if ((formulario.elements[i].obrigatorio == 1) && (!formulario.elements[i].value)) {
					mensagem = 'O campo '+formulario.elements[i].display+' '+String.fromCharCode(233)+' requerido.';
					return f_erro(mensagem,formulario.elements[i], formulario);
				}
		}
		else {
			if ((formulario.elements[i].obrigatorio == 1) && (!formulario.elements[i].value)) {
				mensagem = 'O campo '+formulario.elements[i].display+' '+String.fromCharCode(233)+' requerido.';
				return f_erro(mensagem,formulario.elements[i], formulario);
			}
	        }
		
 	    if (secao) {
		    if (args[1] == formulario.elements[i].secao) {
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'numerico') && (!formulario.elements[i].value.isNumber()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser num'+String.fromCharCode(233)+'rico.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'data') && (!formulario.elements[i].value.substr(0,10).isDate()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma data v'+String.fromCharCode(225)+'lida.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'data_hora') && (!formulario.elements[i].value.isDataHora()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma data e hora v'+String.fromCharCode(225)+'lida, no formato (dia/m'+String.fromCharCode(234)+'s/ano hora:minuto).';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'cpf') && (!formulario.elements[i].value.isCPF()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um n v'+String.fromCharCode(225)+'lido de CPF.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'email') && (!formulario.elements[i].value.isMail()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um e-mail.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }			
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'cnpj') && (!formulario.elements[i].value.isCNPJ()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um CNPJ v'+String.fromCharCode(225)+'lido.';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }	
				if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'placa') && (!formulario.elements[i].value.isPlaca()))
				   {
					mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma placa v'+String.fromCharCode(225)+'lida..';
					return f_erro(mensagem,formulario.elements[i], formulario)
				   }	
			   }
			}
		else {
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'numerico') && (!formulario.elements[i].value.isNumber()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser num'+String.fromCharCode(233)+'rico.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'data') && (!formulario.elements[i].value.substr(0,10).isDate()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma data v'+String.fromCharCode(225)+'lida.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (formulario.elements[i].tipo == 'data_hora') && (!formulario.elements[i].value.isDataHora()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser uma data e hora v'+String.fromCharCode(225)+'lida, no formato (dia/m'+String.fromCharCode(234)+'s/ano hora:minuto).';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'cpf') && (!formulario.elements[i].value.isCPF()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um n v'+String.fromCharCode(225)+'lido de CPF.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'email') && (!formulario.elements[i].value.isMail()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um e-mail.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }			
			if ((formulario.elements[i].value) && (!formulario.elements[i].secao) && (formulario.elements[i].tipo == 'cnpj') && (!formulario.elements[i].value.isCNPJ()))
			   {
				mensagem = 'O valor do campo '+formulario.elements[i].display+' deve ser um CNPJ v'+String.fromCharCode(225)+'lido.';
				return f_erro(mensagem,formulario.elements[i], formulario)
			   }						
	     }
	}
	return true;
}

/*
==================================================================
f_erro(p_mensagem, p_campo, form) : Mostra mensagem de erro e posiciona o cursor no campo que disparou o erro
	* variveis *
	  - p_mensagem : mensagem que deve ser mostrada
	  - p_campo : campo que disparou o erro
	  - form : formulario
==================================================================
*/

function f_erro(p_mensagem, p_campo, form) {
	alert(p_mensagem);
	if (form.MENSAGEM) 
        form.MENSAGEM.value = p_mensagem;
	if (p_campo.type == 'select-one') 
		p_campo.focus();
	if (p_campo.type == 'text') 
		p_campo.select();
	return false;
}

//Alterar IMAGEM para recolher/expandir
// fld campo da imagem que deve ser trocado
// fld_exp objeto que deve expandir/recolher
// img_exp caminho da imagem expandir
// img_rec caminho da imagem recolher
function f_exp_rec_img(fld,fld_exp, img_exp, img_rec){
	var campo_tr = document.createElement("tr") ;; 
	campo_tr = eval(fld_exp);
	var campo_img = document.createElement("img") ;; 
	campo_img = eval(fld);
	if(campo_tr.style.display == 'none'){
		campo_tr.style.display ='';
		campo_img.src = img_rec;
	}else{
		campo_tr.style.display ='none';
		campo_img.src = img_exp;
	}
return false;
}

/*
=============================================================
Formata PLACA 
14/01/2004
=============================================================
Parmetros
	- fld = campo PLACA a ser formatado
Chamada
	- Deve ser colocada no evento onKeyUp
*/
function f_formata_placa(fld) {
  key = window.event.keyCode;
  if (key!=8 && key!=37 && key!=39 && key!=9 && key!=16){
     fld.value = (fld.value).toUpperCase();
     if ((fld.value).length == 3) {
        fld.value += '-';
       }
     if ((fld.value).indexOf('--') != -1) {
        fld.value = fld.value.substring(0,(fld.value).length -1);
       }
	} 		
}

/*
=============================================================
Limpa PLACA 
14/01/2004
=============================================================
Parmetros
	- fld = campo PLACA a ser formatado
Chamada
	- Deve ser colocada no evento onBlur
*/
function f_converte_placa(fld) {
	fld.value = fld.value.replace('-','');	
}

/*
=============================================================
Compara Datas
10/05/2004
=============================================================
Parmetros
	- p_data1 : Campo data 1
	- p_data2 : Campo data 2
Chamada
	- Deve ser colocada no evento onBlur
Retorno
    - -1 se a data 1 for maior que a data 2
    - 1 se a data 2 for maior que a data 1
    - 0 se as datas forem iguais
	- -2 Data 1 invlida
	- -3 Data 2 invlida
*/
function f_compara_data(p_data1, p_data2)
{
	if (!p_data1.isDataHora() && !p_data1.isDate()) 
		return -2;

	if (!p_data2.isDataHora() && !p_data2.isDate()) 
		return -3;
    
	var v_data1 = new Date(p_data1.substr(6,4),p_data1.substr(3,2)-1,p_data1.substr(0,2),p_data1.substr(11,2),p_data1.substr(14,2),00);
	var v_data2 = new Date(p_data2.substr(6,4),p_data2.substr(3,2)-1,p_data2.substr(0,2),p_data2.substr(11,2),p_data2.substr(14,2),00);;	
	
	if (v_data1 > v_data2) 
		return -1;
    else if (v_data1 < v_data2)
	         return 1;
	     else
	         return 0;
}

/*
=============================================================
Mostra TR
22/03/2004
	- Verifica se o valor digitado  numrico
=============================================================
Parmetros
	- fld = Identificador do tr que ser mostrado
	- td = Imagem que chama o evento
Chamada
	- Deve ser colocada no evento onKeyUp da imagem expandir/recolher
*/

function expandir_recolher(fld, td){
	var campo_tr = document.createElement("tr") ;; 
	campo_tr = eval(fld);
	var campo_td = document.createElement("td") ;; 
	campo_td = eval(td);
	if(campo_tr.style.display == 'none'){
		campo_tr.style.display ='';
		campo_td.className = 'ajd-img-recolher';
	}else{
		campo_tr.style.display ='none';
		campo_td.className = 'ajd-img-expandir';
	}
return false;
}

/** 
* @descritivo  : Desabilita teclas nocivas ao wizard 
* @parametro   : sem parmetros 
* @retorno     : void 
* @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
* @verso      : 1, 31 de Maro  de  2004 
*/                                   

function f_seguranca() 
{ 
		document.onkeydown = function(){ 
										//alert( window.event.keyCode );
	
										if ( window.event.ctrlKey ) // caso seja pressionada a tecla control
	
										 { 
												  switch( window.event.keyCode )
	
												  {       
	
														   case  65 :   // caso A ( select all )
	
														   case  69 :   // caso E ( search )
	
														   case  70 :   // caso F ( find )
	
														   case  72 :   // caso H ( history )
	
														   case  73 :   // caso I ( favorites )
	
														   case  78 :   // caso N ( new window )
	
														   case  79 :   // caso O ( open )
	
														   case  80 :   // caso P ( print )
	
														   case  82 :   // caso R ( refresh )
	
														   case  87 :   // caso W ( close ) 
	
																 
	
																 window.event.keyCode = 999;
	
																 
	
														 break;    
	
												 }
	
												
	
										  }     else if ( window.event.altKey )  // caso seja pressionada a tecla alt 
	
																 {
	
																		  switch( window.event.keyCode )
	
																		  {       
	
																				   case  115 : window.event.keyCode = 999; break;    // alt + f4 
	
																		  }
	
										  } else 
	
											{ 
														  switch( window.event.keyCode ) // caso sejam pressionadas isoladamente algumas teclas
	
														  {       

																   case  8   : 
																   
																   if ((window.event.srcElement.type == 'text') || (window.event.srcElement.type == 'password')  || (window.event.srcElement.type == 'select-multiple')  || (window.event.srcElement.type == 'select-one') || (window.event.srcElement.type == 'textarea'))
																   	break;
																   // backspace
																   
																   case 27: 
																   			if( window.opener ) window.close();
																	break;		
	
																   case  112 : // f1
	
																   case  114 : // f3
	
																   case  116 : // f5
	
																   case  122 : // f11
	
																		   window.event.keyCode = 999; 
	
																  break;    
	
														  }
	
												}
	
												if  ( window.event.keyCode == 999 ) return ( false );
	
								}       
						/*		document.oncontextmenu = function(){ return false } 
								
										if( document.layers ) 
										   { 
													window.captureEvents( Event.MOUSEDOWN ); 
									
													window.onmousedown = function(e){ 
																						if( e.target == document ) return ( false );
																					}
						
											} 
								else { 
										document.onmousedown = function(){return false} 
									 }  
						*/			 
} 

// Para limpar e voltar o valor pado para o campo
// fld = campo
// valor_padrao = valor padro para o campo.
// ex.:  onFocus="f_limpa_campo(this, '-- Todos --')" onBlur="f_volta_campo(this, '-- Todos --')"
function f_limpa_campo(fld, valor_padrao) {
	if (fld.value == valor_padrao) 
		fld.value = '';
}
function f_volta_campo(fld, valor_padrao) {
	if (!fld.value) 
		fld.value = valor_padrao;
}

function f_preenche_gauge(p_barra,p_tabela_preenchimento, p_div_valor, p_valor) {
	if (p_valor > 0) {
		if (p_div_valor) 
			p_div_valor.innerHTML = p_valor+'%';
		p_valor = (p_valor*100)/p_barra.width;
		p_tabela_preenchimento.width = p_valor+'%';
	}
}	
function swapBG(el, BG1, BG2) {
el.style.background = (el.style.background == BG1) ? BG2 : BG1;
}


/*
=============================================================================================	
=============================================================================================	
=============================== DESENVOLVIDO POR TERCEIROS ==================================	
=============================================================================================	
=============================================================================================	

// Cookie Lib

/**
 * @descritivo	: captura Cookie
 * @parametro	: nome : string. ( Requerido )
 * @retorno		: cookie
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 2 de Dezembro de 2003 
 */					
function getCookie( nome )
{ 
  var index  = campos.indexOf( nome + '=');
	  if(index == -1 ) 
	  	  return ( null );
	
	  index  = campos.indexOf( '=', index ) + 1;
  var sfinal = campos.indexOf(';', index );  
	  if( sfinal == -1 ) 
	  	  sfinal = campos.length;
		
  return unescape( campos.substring( index, sfinal ) );
}	

/**
 * @descritivo	: Gravar Cookies
 * @parametro	: nome  : string. ( Requerido )
 * @retorno		: cookie
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 2 de Dezembro de 2003 
 */					
function setCookie( nome, valor )
{ 
  if( valor != null )
    document.cookie = nome + '=' + escape( valor ) + '; expires=' + expirar.toGMTString();
				 
  campos = document.cookie; 
}
/**
 * @descritivo	: Deleta Cookies
 * @parametro	: nome    : string. ( Requerido )
				  caminho : string. ( Requerido )
				  dominio : string. ( Requerido )
 * @retorno		: cookie
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 05 de Outubro de 2004
 */					
function deleteCookie(nome ) 
{
  if ( getCookie( nome ) ) 
  {
    document.cookie = nome + '=' + '; expires=Thu, 01-Jan-70 00:00:01 GMT';
  }
}

/*
==================================================================
LTrim(string) : Returns a copy of a string without leading spaces.
==================================================================
*/
function LTrim(str)
/*
   PURPOSE: Remove leading blanks from our string.
   IN: str - the string we want to LTrim
*/
{
   var whitespace = new String(" \t\n\r");

   var s = new String(str);

   if (whitespace.indexOf(s.charAt(0)) != -1) {
      // We have a string with leading blank(s)...

      var j=0, i = s.length;

      // Iterate from the far left of string until we
      // don't have any more whitespace...
      while (j < i && whitespace.indexOf(s.charAt(j)) != -1)
         j++;

      // Get the substring from the first non-whitespace
      // character to the end of the string...
      s = s.substring(j, i);
   }
   return s;
}

/*
==================================================================
RTrim(string) : Returns a copy of a string without trailing spaces.
==================================================================
*/
function RTrim(str)
/*
   PURPOSE: Remove trailing blanks from our string.
   IN: str - the string we want to RTrim

*/
{
   // We don't want to trip JUST spaces, but also tabs,
   // line feeds, etc.  Add anything else you want to
   // "trim" here in Whitespace
   var whitespace = new String(" \t\n\r");

   var s = new String(str);

   if (whitespace.indexOf(s.charAt(s.length-1)) != -1) {
      // We have a string with trailing blank(s)...

      var i = s.length - 1;       // Get length of string

      // Iterate from the far right of string until we
      // don't have any more whitespace...
      while (i >= 0 && whitespace.indexOf(s.charAt(i)) != -1)
         i--;


      // Get the substring from the front of the string to
      // where the last non-whitespace character is...
      s = s.substring(0, i+1);
   }

   return s;
}

/*
=============================================================
Trim(string) : Returns a copy of a string without leading or trailing spaces
=============================================================
*/
function Trim(str)
/*
   PURPOSE: Remove trailing and leading blanks from our string.
   IN: str - the string we want to Trim

   RETVAL: A Trimmed string!
*/
{
   return RTrim(LTrim(str));
}

// Form Methods Vr. 0.1
	// (c) 2003, Joo Batista Neto
	// joaoneto@mugb.com.br
	
	Date.prototype.Dtos = function(){
		var dd = this.getDate();
		var mm = this.getMonth() + 1;
		var yy = this.getFullYear();
		
		return( [ yy , ( mm < 10 ? '0' : '' ) + mm , ( dd < 10 ? '0' : '' ) + dd ].join( '' ) );
	}
	
	Array.prototype.hasEmptyElements = function(){
		for ( var i = 0 ; i < this.length ; i++ )
			if ( ( this[ i ] == '' ) || ( this[ i ] == null ) || ( this[ i ] == undefined ) )
				return( true );
		return( false );
	}
	
	String.prototype.isNumber = function(){
		return( !isNaN( this.split( '.' ).join( '' ).split( ',' ).join( '' ).split( '-' ).join( '' ) ) );
	}

	String.prototype.isPlaca = function(){
		if ( this.length != 7) return( false );
		v_num = this.substr(3,4);
		if ( !isNaN( v_num ) ) return( false );
		return( true );
	}

	String.prototype.isDate = function(){
		var pt = this.split( '/' );
		var dt = new Date();
		var dd = Number( pt[ 0 ] );
		var mm = Number( pt[ 1 ] );
		var yy = Number( pt[ 2 ] );
		
		if ( pt.length != 3 ) return( false );

		dt.setFullYear( yy , mm - 1 , dd );
		
		if (mm <= 12 && dd <= 31 && yy > 1900 && yy < 2050) 
		   return( true );
	}

	String.prototype.isDataHora = function(){
		var pt = this.split( '/' );
		var dt = new Date();
		var dd = Number( pt[ 0 ] );
		var mm = Number( pt[ 1 ] );
		var yy = this.substr(6,4);
		var hh = this.substr(11,2);
		var mi = this.substr(14,2);

		// Data sem HORA
		if ( this.length < 15 ) return( false );
		
		// Caso seja preenchida com segundos
		if (this.length > 15) 
			var ss = this.substr(17,2); 
		else 
			var ss = '00';

		if ( !( ( hh >= 00 ) && ( hh < 24 ) && ( mi >= 00 ) && ( mi < 60 ) && ( ss >= 00 ) && ( ss < 60 ) ) )
		   return( false );
			
		if ( pt.length != 3 ) return( false );
		
		dt.setFullYear( yy , mm - 1 , dd );

		return( [ yy , ( mm < 10 ? '0' : '' ) + mm , ( dd < 10 ? '0' : '' ) + dd ].join( '' ) == dt.Dtos() );
	}
	
	String.prototype.isCPF = function(){
		this.testar = function( soma , pos ){
			var resto = 11 - ( soma % 11 );
			if ( ( resto == 10 ) || ( resto == 11 ) ) resto = 0;
			return( resto == this.charCodeAt( pos ) - 48 );
		}

		for ( var i = 0 ; i < 10 ; i++ ) if ( this.split( i ).join( '' ).length == 0 ) return( false );
		for ( var i = 0 , soma1 = 0 ; i < 9 ; i++ ) soma1 += ( this.charCodeAt( i ) - 48 ) * ( 10 - i );
		for ( var i = 0 , soma2 = 0 ; i < 9 ; i++ ) soma2 += ( this.charCodeAt( i ) - 48 ) * ( 11 - i );

		if ( !this.testar( soma1 , 9 ) ) return( false );
		if ( !this.testar( soma2 , 10 ) ) return( false );

		return( true );
	}

	String.prototype.isMail = function(){
		var test
		var pt1    = this.split( '@' );
		var valid = '.-_@';
		
		if ( ( pt1.length != 2 ) || ( pt1[ 0 ].length == 0 ) || ( pt1[ 1 ].length == 0 ) ) return( false );
		else {
			for ( var i = 0 ; i < valid.length - 1 ; i++ ){
				if ( pt1[ 0 ].split( valid.charAt( i ) ).hasEmptyElements() ) return( false );
				if ( pt1[ 1 ].split( valid.charAt( i ) ).hasEmptyElements() ) return( false );
			}			
		}
		
		for ( var i = 0 ; i < this.length ; i++ ){
			var v_char = this.toUpperCase().charCodeAt( i );
			if ( valid.indexOf( String.fromCharCode( v_char ) ) == -1 )
				if ( !( ( ( v_char >= 65 ) && ( v_char <= 90 ) ) || ( ( v_char >= 48 ) && ( v_char <= 57 ) ) ) ) return( false );
		}	
		
		return( true );
	}
	
	String.prototype.isCNPJ = function() {			
				var verificar = this;
				if (verificar.length > 14) 
					return false;
					
				var digito = verificar.toString()
				// DIGITO 1
				var soma1 = 0
				soma1 = soma1 + 5 * digito.charAt(0)
				soma1 = soma1 + 4 * digito.charAt(1)
				soma1 = soma1 + 3 * digito.charAt(2)
				soma1 = soma1 + 2 * digito.charAt(3)
				soma1 = soma1 + 9 * digito.charAt(4)
				soma1 = soma1 + 8 * digito.charAt(5)
				soma1 = soma1 + 7 * digito.charAt(6)
				soma1 = soma1 + 6 * digito.charAt(7)
				soma1 = soma1 + 5 * digito.charAt(8)
				soma1 = soma1 + 4 * digito.charAt(9)
				soma1 = soma1 + 3 * digito.charAt(10)
				soma1 = soma1 + 2 * digito.charAt(11)
				var divisao1    = soma1 / 11
				var multiplica1 = parseInt(divisao1,10) * 11
				var resto1      = soma1 - multiplica1
				if (resto1 <= 1) {
					var digi1 = 0
				} else {
					var digi1 = 11 - resto1
				}
				// DIGITO 2
				var soma2 = 0
				soma2 = soma2 + 6 * digito.charAt(0)
				soma2 = soma2 + 5 * digito.charAt(1)
				soma2 = soma2 + 4 * digito.charAt(2)
				soma2 = soma2 + 3 * digito.charAt(3)
				soma2 = soma2 + 2 * digito.charAt(4)
				soma2 = soma2 + 9 * digito.charAt(5)
				soma2 = soma2 + 8 * digito.charAt(6)
				soma2 = soma2 + 7 * digito.charAt(7)
				soma2 = soma2 + 6 * digito.charAt(8)
				soma2 = soma2 + 5 * digito.charAt(9)
				soma2 = soma2 + 4 * digito.charAt(10)
				soma2 = soma2 + 3 * digito.charAt(11)
				soma2 = soma2 + 2 * digi1       
				var divisao2    = soma2 / 11
				var multiplica2 = parseInt(divisao2,10) * 11
				var resto2      = soma2 - multiplica2
				if ( resto2 <= 1 ){
					var digi2 = 0
				} else {
					var digi2 = 11 - resto2
				}
				if ( digito.charAt( 12 ) == digi1.toString() & digito.charAt( 13 ) == digi2.toString() ){
					return( true )
				} else {
					return(false)
				}
			}	
			


  function getAbsolutePos(el) {
  	var r = { x: el.offsetLeft, y: el.offsetTop };
  	if (el.offsetParent) {
  		var tmp = getAbsolutePos(el.offsetParent);
  		r.x += tmp.x;
  		r.y += tmp.y;
  	}
  	return r;
  };


 function showtip(current,e,comentario)

	{

	 if (document.layers) // Netscape 4.0+

		{

		 theString="<DIV CLASS='ttip'>"+comentario+"</DIV>";

		 document.tooltip.document.write(theString);

		 document.tooltip.document.close();

		 document.tooltip.left=e.pageX+14;
		 document.tooltip.top=e.pageY+2;

		 document.tooltip.visibility="show";

		}

	 else

	   {

		if(document.getElementById) // Netscape 6.0+ and Internet Explorer 5.0+

		  {
		   elm=document.getElementById("tooltip");

		   elml=current;

		   elm.innerHTML=comentario;

		   elm.style.height=elml.style.height; 

		   var pos = getAbsolutePos(current);
		   
		   var elmHeight = current.offsetHeight;
		   
		   elm.style.top= parseInt(pos.y) + parseInt(elmHeight) +5;

		   elm.style.left= pos.x+2;

		   elm.style.visibility = "visible";

		  }

	   }

	}

function hidetip(){

if (document.layers) // Netscape 4.0+

{

document.tooltip.visibility="hidden";

}

else

{

if(document.getElementById) // Netscape 6.0+ and Internet Explorer 5.0+

 {

  elm.style.visibility="hidden";
 }

} 

}

// Abre um show MODAL
function showjanela(v_url, v_largura, v_altura)
{
	var msAttributes ="status:no;help:no;border:thin;statusbar:yes;scroll:auto;dialogWidth:"+ v_largura +"px;dialogHeight:"+ v_altura +"px";
	showModalDialog(v_url,window,msAttributes);
}


function show_popup(current,e,comentario) {
	var oPopup = window.createPopup();
	var oPopupBody = oPopup.document.body;
	oPopupBody.style.backgroundColor = "lightyellow";
	oPopupBody.style.border = "solid black 1px";    
	oPopupBody.style.fontFamily = "Verdana, Geneva, Arial, Helvetica, sans-serif";
	oPopupBody.style.fontSize = "10px";
	oPopupBody.scroll = "yes";
	
	var altura = 1;
	var largura = 320;
	var deslocamento = (parseInt(current.offsetHeight)+5);
	
	if (comentario.length > 45)
	  altura = Math.ceil(comentario.length/45);
	else
	  largura = Math.ceil(comentario.length * 8);
	 
	oPopupBody.innerHTML = comentario; 
	
	if ((current.type == 'select-one') || (current.type == 'select-multiple')) {
	   if (altura == 1)
		   deslocamento = -1*(parseInt(current.offsetHeight)+5);
	   else
		   deslocamento = -1*(parseInt(current.offsetHeight)+(10*altura));
	}
	
	oPopup.show(0, deslocamento, largura, 15*altura, current);
}

function f_verifica_tipo( p_campo )
{
	switch( p_campo.type ) 
	{
				case 'text' : 
				case 'select-one' : 
				case 'select-multiple' : 
				case 'textarea' : 
				case 'password' : 
					
					return ( true );
				
			   default :	
					return ( false );
	}

}

function showhide(fld){
	var campo = document.createElement("tr") ;; 
	campo = eval(fld);
	if(campo.style.display == 'none'){
		campo.style.display ='';
	}else{
		campo.style.display ='none';
	}
return false;
}

function hide(fld){
	var campo = document.createElement("tr") ;; 
	campo = eval(fld);
	campo.style.display ='none';
return false;
}

function show(fld){
	var campo = document.createElement("tr") ;; 
	campo = eval(fld);
	campo.style.display ='';
return false;
}

// NewWindow('../../cadastro/conhecimento/natureza.cfm?EMISSAO=1','Natureza','500','300','no');return false"
function NewWindow(mypage, myname, w, h, scroll) {
	var winl = (screen.width - w) / 2;
	var wint = (screen.height - h) / 2;
	winprops = 'height='+h+',width='+w+',top='+wint+',left='+winl+',scrollbars='+scroll+',resizable,status'
	win = window.open(mypage, myname, winprops)
	if (parseInt(navigator.appVersion) >= 4) { win.window.focus(); }
}

/**
 * @descritivo	: Mostrar Dialogo
 * @parametro	: p_pagina 		  : string 		( obrigatrio ) 
				  p_target	  	  : string 		( obrigatrio ) 
				  p_resize		  : booleano	( opcional )
				  p_wizard		  : booelano	( opcional )
				  p_scrol		  : booelano	( opcional )
				  p_status		  : booelano	( opcional )
				  p_width		  : numrico	( opcional )
				  p_heigth		  : numrico	( opcional )
 * @retorno		: void
 * @autor       : Jefferson Petilo ( jefferson@kmm.com.br ) 
 * @verso		: 1, 05 de Maio de  2004
 * @sintaxe1 	: showModal('pagina1.cfm', '_top|_self|_blank|_parent') 
 * @sintaxe2 	: showModal('pagina2.cfm', 'target_customizado', 1, 1, 0, 580, 420 )
 */					
function showModal( p_pagina, p_target, p_resize, p_scroll, p_status, p_width, p_height )
{
 var path     = p_pagina.split('/');
 var pagina   = path[ path.length -1 ].split('?');
	 resize	  = ( p_resize != null || p_resize != 0 ) ? p_resize : false;
	 scrol 	  = ( p_scroll != null || p_scroll != 0 ) ? p_scroll : false;
	 status   = ( p_status != null || p_status != 0 ) ? p_status : '';
	 width	  = ( p_width  != null || p_width  != 0 ) ? p_width  : 0;
	 height	  = ( p_height != null || p_height != 0 ) ? p_height : 0; 
	 esquerda = ( screen.width  ) ? ( screen.width  - parseInt( width )  ) / 2 : 0;
	 topo	  = ( screen.height ) ? ( screen.height - parseInt( height ) ) / 2 : 0; 
	 win 	  = window.open( p_pagina, p_target ,'height='+ height +', width='+ width +', left='+ esquerda + ', top=' + topo + ', toolbar=0, location=0,directories=0,status='+ status +',menuBar=0,scrollBars='+ scrol +',resizable=' + resize + '');

	 win.focus(); 
}


/*
=============================================================
Limpa PLACA 
14/01/2004
	- Verifica se o valor digitado  numrico
=============================================================
Parmetros
	- fld = campo a ser verificado
Chamada
	- Deve ser colocada no evento onKeyUp
*/

function f_verifica_numero(fld)
{
if ((isNaN(fld.value)) || ((fld.value).indexOf(',') != -1) || ((fld.value).indexOf('.') != -1)) {
  alert("Digite somente nmeros neste campo.");
  fld.value = fld.value.substr(0,fld.value.length - 1);
}
}

/**
 * @descritivo	: Seleciona todos elementos do Select Box
 * @parametro	: p_select    : array. ( Requerido )
 * @retorno		: Data
 * @autor       : Jefferson Petilo( jefferson@kmm.com.br ) 
 * @verso		: 1, 06  de Junho de 2004
 */					
function f_seleciona_todos( p_select )
{
 for(var i = 0; i < p_select.options.length;i++ )
     if( p_select.options[ i ].value.length > 0 )
	     p_select.options[ i ].selected = true;
     else 
	     p_select.options[ i ] = null;
}

/**
 * @descritivo	: Marca todos os itens de um check group
 * @parametro	: p_campo    : array. ( Requerido )
 * @retorno		: Data
 * @autor       : Guto
 * @verso		: 21/11/2005
 */					
function f_marca_todos( p_check_name )
{
	for (var i = 0; i<document.forms[0].elements.length; i++) {		
	   if ( (document.forms[0].elements[i].type == 'checkbox') && (p_check_name == document.forms[0].elements[i].name) )
	     document.forms[0].elements[i].checked = true;	
	}
}
/*
function initAbas(v_id, v_aba_inicial) {
	var tbl = document.getElementById(v_id);
	var abas = tbl.rows[0].cells
	var nro_abas = abas.length;
	var corpos = new Array();
	for(var i=0;i<tbl.rows.length;i++) {
		if(i!=0) {
			corpos[corpos.length] = tbl.rows[i];
		}
	}
	var nro_corpos = corpos.length;
	if (nro_abas < nro_corpos) {
//		alert("O numero de abas  menor que o numero de corpos!");
	}
	for(var i=0;i<abas.length;i++) {
		if (i < nro_corpos) {
			if(v_aba_inicial == i) {
				abas[i].className = 'td_aba_up';
			} else {
				abas[i].className = 'td_aba_down';
			}
			abas[i].onclick = function() {
				mudaAba(corpos, abas, this);
			}
		} else {
			abas[i].className = 'td_aba_none';
		}
	}
	for(var i=0;i<corpos.length;i++) {
		if(v_aba_inicial == i) {
			corpos[i].style.display = '';
		} else {
			corpos[i].style.display = 'none';
		}
	}		
} 

function mudaAba(v_tbody, v_tr, obj) {
	tb = v_tbody;
	tr = v_tr;
	var sel = -1;
	for(var i=0;i<tr.length;i++) {
		if (i < tb.length) {
			if (tr[i] == obj) {
				sel = i;
				tr[i].className = 'td_aba_up';
			} else {
				tr[i].className = 'td_aba_down';
			}
		}
	}
	for(var i=0;i<tb.length;i++) {
		if (i == sel) {
			tb[i].style.display = '';
		} else {
			tb[i].style.display = 'none';
		}
	}			
}*/