       var MAX_DUMP_DEPTH = 10;

       function dumpObj(obj, name, indent, depth) {
              if (depth > MAX_DUMP_DEPTH) {
                     return indent + name + ": <Maximum Depth Reached>\n";
              }
              if (typeof obj == "object") {
                     var child = null;
                     var output = indent + name + "\n";
                     indent += "\t";
                     for (var item in obj)
                     {
                           try {
                                  child = obj[item];
                           } catch (e) {
                                  child = "<Unable to Evaluate>";
                           }
                           if (typeof child == "object") {
                                  output += dumpObj(child, item, indent, depth + 1);
                           } else {
                                  output += indent + item + ": " + child + "\n";
                           }
                     }
                     return output;
              } else {
                     return obj;
              }
       }

// Copyright 2005 Robert Blackburn
// 
// To use place <script type="text/javascript" src="javascripts/jsdump.js"></script> 
// where you would like to place the JSDump output. 
//
// Developed by: Robert Blackburn
// Contact: skorpiun@gmail.com
//
// MODIFICATION HISTORY
//		11/25/05 Robert Blackburn	Creation (v1.0)

function jsdump_listPropertyNames(objectName)
{
	try {
		object = eval(objectName);
		
		debugForm = document.debugForm2;
		debugField = debugForm.debugSelect;
		debugForm.debugDOM.value = objectName;
		debugForm.debugValue.value = object;
		
		var names = "";
		var index = 0;
		debugField.options.length = index;
		elementArray = new Array();
		for(var i in object) 
			elementArray.push(i);
		elementArray.sort();
	
		for(var index in elementArray) {
		
			var element = elementArray[index]
				
			try {
				if( typeof(object[element]) != 'unknown') {
				//if( !isNull(object[element]) ) {
					subObject = object[element];
					var subObjectType = typeof subObject;
					var subObjectValue = subObject;
				} else {
					var subObjectType = "!unknown";
					var subObjectValue = "xxxxxxx";
				}
			} catch(identifier) {
				if( identifier.toString().indexOf("0x80004001 (NS_ERROR_NOT_IMPLEMENTED)") > 0 ) {
					// This is some odd Firefox v1 error thrown when an object type is unknown.
					// We just want to ignore those errors for now. Later versions we might 
					// handle this differently.
				} else {
					alert("JSDump encountered an error.\n\n"+identifier);
					_JSDumpLastError = identifier;
				}
				
			} 
	
			debugField.options.length = index;
			
			if(isNaN(element)) {
				newOpion = new Option(element+" (" + subObjectType + ")", objectName + "." + element);
			} else {
				newOpion = new Option(element+" (" + subObjectType + ")", objectName + "[" + element + "]");
			}
			
			debugField.options[index] = newOpion;
			
			if(subObjectType == 'object') {
				debugField[index].className='jsdump_object';
			} else {
				debugField[index].className='jsdump_prop';	
			}
			
			++index;
		}
	} catch(identifier) {
		alert("JSDump encountered an error.\n\n"+identifier);
		_JSDumpLastError = identifier;
	} 
}

function jsdump_fGotoParent(objectName) {

	try {
		objectDOMArray = objectName.split(".");
	
		if(--objectDOMArray.length > 0) {
			jsdump_listPropertyNames(objectDOMArray.join("."));
		}
	} catch(identifier) {
		alert("JSDump encountered an error.\n\n"+identifier);
		_JSDumpLastError = identifier;
	} 



}

function jsdump() {	
	document.write("<style>");
	document.write("   .jsdump_object { color: blue; font: bold; }");
	document.write("   .jsdump_prop { color: green; }");
	document.write("   #JSDumpForm { font-family: monospace; font-size: 10pt; width: 100%; background-color: #cccccc; border: 2px solid #999999; color: #999999}");
	document.write("   #JSDumpForm div { text-align: center; padding: 0.5em; }");
	document.write("   #JSDumpForm h3 { font-size: 12pt; border: none; text-align: center; text-transform: none; color: black; }");
	document.write("   #JSDumpForm label { font-family: monospace; font-size: 8pt; font-weight: bold; display: block; text-align: left; }");
	document.write("   #JSDumpForm .field { font-family: monospace; font-size: 8pt; width: 95%; text-align: left; }");
	document.write("   #JSDumpForm a { font-size: 8pt; font-decoration: none; color: #999999; display: block; text-align: right;}");
	document.write("</style>");
	
	document.write("<form action=\"##\" name=\"debugForm2\" id=\"JSDumpForm\">");
	document.write("<h3>JSDump v.1</h3>");
	document.write("<div><label for=\"debugDOM\">Object DOM</label><input type=\"text\" name=\"debugDOM\" id=\"debugDOM\" class=\"field\" value=\"\" size=\"50\" /></div>");
	document.write("<div><label for=\"debugValue\">Object Value</label><input disabled type=\"text\" name=\"debugValue\" id=\"debugValue\" class=\"field\" value=\"\" size=\"50\" /></div>");
	document.write("<div><label for=\"debugSelect\">Object Properties</label><select name=\"debugSelect\" id=\"debugSelect\" class=\"field\" size=\"8\" onchange=\"jsdump_listPropertyNames(this.options[this.selectedIndex].value);\"><option></option></select></div>");
	document.write("<div><input type=\"submit\" name=\"reset\" value=\"Refresh\" onClick=\"jsdump_listPropertyNames(document.debugForm2.debugDOM.value); return false;\" /> <input type=\"submit\" name=\"reset\" value=\"Parent Object\" onClick=\"jsdump_fGotoParent(document.debugForm2.debugDOM.value); return false;\" /></div>");
	document.write("<a href=\"http://www.rbdev.net\" target=\"_blank\">Copyright &copy;2005 Robert Blackburn</a>");
	document.write("</form>");
	
	jsdump_listPropertyNames('window');
}

jsdump();






