// JavaScript Document
function initCalendario(v_id,config) {
	v_div = document.getElementById(v_id);
	return new Calendario(v_div,config);
}

function Calendario(obj,config) {
	this.div = obj;
	this.dayHeight = 25;
	this.dayWidth = 482;
	this.marginTop = 40;
	this.marginLeft = 92;
	this.config = config;
	this.top = f_posicao_objeto(this.div,false);
	this.left = f_posicao_objeto(this.div,true);
	this.days = [];
	this.selectedInterval = null;
	
	this.getNumber = function(value) {
		var v_hour 		= Number(String(value).split(':')[0]);
		var v_minute	= Number(String(value).split(':')[1]);
		var v_second	= (String(value).split(':').length > 2)?Number(String(value).split(':')[2]):0;
		return Number(new Date(2006,10,10,v_hour,v_minute,v_second));
	}
	this.testTime = function (value) {
		v_hora = value.split(':');
		if(v_hora.length > 3 || v_hora.length < 2 || Number(v_hora[0]) != Math.round(Number(v_hora[0])) || Number(v_hora[1]) != Math.round(Number(v_hora[1])) || (v_hora.length > 2 && Number(v_hora[2]) != Math.round(Number(v_hora[2]))) ) {
			alert('Formato invlido para a hora! '+value);
			return false;
		}
		if(Number(v_hora[0]) < 0 || Number(v_hora[0]) > 23 || Number(v_hora[1]) < 0 || Number(v_hora[1]) > 59) {
			alert('Valor invalido para a hora! '+value);
			return false;
		}				
		return true;
	}


	this.WeekDay = function(parent,v_weekday) {
		this.parent = parent;
		this.weekday = v_weekday;
		this.intervals = [];
		this.div = document.createElement("DIV");
		
		this.parent.div.appendChild(this.div);
		with(this.div) {
			style.position = 'absolute';
			style.top = this.parent.top+this.parent.marginTop+(this.weekday*this.parent.dayHeight);// f_posicao_objeto(this.div,false)+41;
			this.top = this.parent.top+this.parent.marginTop+(this.weekday*this.parent.dayHeight);
			style.left = this.parent.left+this.parent.marginLeft;//f_posicao_objeto(this.div,true)+92;
			this.left = this.parent.left+this.parent.marginLeft;//f_posicao_objeto(this.div,true)+92;
			style.width = this.parent.dayWidth;
			style.height = this.parent.dayHeight;
//			style.border = '1px solid #FFFF00';
		}
		this.addInterval = function (v_id,initial, final) {
			if(this.detectFusion(initial,final) != null) {
				if(this.parent.config.autofusion) {
					obj = this.detectFusion(initial,final);
					obj.setInitial((obj.getNumber(obj.initial) < obj.getNumber(initial))?obj.initial:initial);
					obj.setFinal((obj.getNumber(obj.final) > obj.getNumber(final))?obj.final:final);
				} else {
					alert('O horario indicado sobrepoe um horario existente!');
				}
			} else {
				this.intervals.push(v_obj = new this.Interval(this,v_id,initial,final));
			}
			return v_obj;
		}
		this.getNumber = function(value) {
			var v_hour 		= Number(String(value).split(':')[0]);
			var v_minute	= Number(String(value).split(':')[1]);
			var v_second	= (String(value).split(':').length > 2)?Number(String(value).split(':')[2]):0;
			return Number(new Date(2006,10,10,v_hour,v_minute,v_second));
		}
		this.testTime = function (value) {
			v_hora = value.split(':');
			if(v_hora.length > 3 || v_hora.length < 2 || Number(v_hora[0]) != Math.round(Number(v_hora[0])) || Number(v_hora[1]) != Math.round(Number(v_hora[1])) || (v_hora.length > 2 && Number(v_hora[2]) != Math.round(Number(v_hora[2]))) ) {
				alert('Formato invlido para a hora! '+value);
				return false;
			}
			if(Number(v_hora[0]) < 0 || Number(v_hora[0]) > 23 || Number(v_hora[1]) < 0 || Number(v_hora[1]) > 59) {
				alert('Valor invalido para a hora! '+value);
				return false;
			}				
			return true;
		}
		this.Interval = function(parent, v_id, initial, final) {
			this.parent = parent;
			this.id = v_id;
			this.initial = initial;
			this.final = final;
			this.selected = false;
			this.getNumber = function(value) {
				var v_hour 		= Number(String(value).split(':')[0]);
				var v_minute	= Number(String(value).split(':')[1]);
				var v_second	= (String(value).split(':').length > 2)?Number(String(value).split(':')[2]):0;
				return Number(new Date(2006,10,10,v_hour,v_minute,v_second));
			}
			this.min = this.getNumber('00:00:00');
			this.max = this.getNumber('23:59:59');
			this.div = document.createElement('div');
			this.parent.div.appendChild(this.div);
			this.div.objInterval = this;
			with(this.div) {
				className = 'calendario_intervalo_cinza';
				onmouseover = function() {
					if(!this.objInterval.selected) {
						this.className = 'calendario_intervalo_over';
						this.style.cursor = 'pointer';
					}
				}
				onmouseout = function() {
					if(!this.objInterval.selected) {
						this.className = 'calendario_intervalo_cinza';
						this.style.cursor = '';
					}
				}
				style.position = 'absolute';
				style.height = 12;
				style.top = 7;
				onclick = function() {
					if(this.objInterval.parent.parent.config.intervalonclick)
						this.objInterval.parent.parent.config.intervalonclick(this.objInterval);
					this.objInterval.select();
				}
//				style.backgroundColor = '#000000';
			}
			this.testTime = function (value) {
				v_hora = value.split(':');
				if(v_hora.length > 3 || v_hora.length < 2 || Number(v_hora[0]) != Math.round(Number(v_hora[0])) || Number(v_hora[1]) != Math.round(Number(v_hora[1])) || (v_hora.length > 2 && Number(v_hora[2]) != Math.round(Number(v_hora[2]))) ) {
					alert('Formato invlido para a hora! '+value);
					return false;
				}
				if(Number(v_hora[0]) < 0 || Number(v_hora[0]) > 23 || Number(v_hora[1]) < 0 || Number(v_hora[1]) > 59) {
					alert('Valor invalido para a hora! '+value);
					return false;
				}				
				return true;
			}
			
			this.setInitial = function (value) {
				if(!this.testTime(value))
					return false;
				this.initial = value;
				this.div.style.left = Math.round(this.parent.parent.dayWidth*(this.getNumber(value)-this.min)/(this.max-this.min));
				return true;
			}
			this.setInitial(this.initial);
			this.setFinal = function (value) {
				if(!this.testTime(value))
					return false;
				this.final = value;
				if(this.getNumber(this.initial) > this.getNumber(value)) {
					alert('O horario de termino  menor que o horario de inicio!');
					return;
				}
				this.div.style.width = Math.round(this.parent.parent.dayWidth*(this.getNumber(value)-this.getNumber(this.initial))/(this.max-this.min));
				return true;
			}
			this.setFinal(this.final);
			this.select = function() {
				if(this.parent.parent.selectedInterval != null)
					this.parent.parent.selectedInterval.unSelect();
				this.div.className = 'calendario_intervalo';
				this.selected = true;
				this.parent.parent.selectedInterval = this;
				if(this.parent.parent.config.intervalonselect)
					this.parent.parent.config.intervalonselect(this);
			}
			this.unSelect = function() {
				this.div.className = 'calendario_intervalo_cinza';
				this.selected = false;
				this.parent.parent.selectedInterval = null;
				if(this.parent.parent.config.intervalonunselect)
					this.parent.parent.config.intervalonunselect(this);
			}
			this.destroy = function() {
				this.unSelect();
				this.div.removeNode(true);
				for(var i=0;i<this.parent.intervals.length;i++) {
					if(this.parent.intervals[i] == this) {
						this.parent.intervals.splice(i,1);
					}
				}
			}
		}
		this.detectFusion = function(initial, final) {
			for(var i=0;i<this.intervals.length;i++) {
				if( (this.intervals[i].getNumber(this.intervals[i].initial) <= this.intervals[i].getNumber(initial) &&
					this.intervals[i].getNumber(this.intervals[i].final) >= this.intervals[i].getNumber(initial)) ||
					(this.intervals[i].getNumber(this.intervals[i].initial) <= this.intervals[i].getNumber(final) &&
					this.intervals[i].getNumber(this.intervals[i].final) >= this.intervals[i].getNumber(final))) {
					return this.intervals[i];
				}
			}
			return null;			
		}
	}
	for(var i=0;i<=6;i++) {
		this.days.push(new this.WeekDay(this,i));
	}
	this.unSelect = function() {
		if(this.selectedInterval != null)
			this.selectedInterval.unSelect();
	}
	this.deleteInterval = function() {
		if(this.selectedInterval != null)
			this.selectedInterval.destroy();
	}
	this.clean = function() {
		for(var i=0;i<this.days.length;i++) {
			for(var j=0;j<this.days[i].intervals.length;j++) {
				this.days[i].intervals[j].destroy();
			}
		}
	}
	this.fullCalendar = function() {
		this.clean();
		for(var i=0;i<this.days.length;i++) {
			this.days[i].addInterval('','00:00','23:59:59');
		}
	}
	this.dataset = null;
	this.setDataSet = function (name,form) {
		this.dataset = new DataSet(name,form,'HORARIO_ID,HORARIO_INICIAL,HORARIO_FINAL,HORARIO_DIA_SEMANA',{});
		
	}
	this.refreshDataset = function () {
		if(this.dataset == null) {
			alert(' necessrio definir o dataset com a funcao setDataSet!');
		}
		this.dataset.clear();
		for(var i=0;i<this.days.length;i++) {
			for(var j=0;j<this.days[i].intervals.length;j++) {
				this.dataset.addRow(String(this.days[i].intervals[j].id+','+this.days[i].intervals[j].initial+','+this.days[i].intervals[j].final+','+this.days[i].weekday).split(','));
			}
		}
	}
}