/**
 * Script de Criao de arvores de elementos
 */
function Tree(id, config) {
	if(!window.vTreeObjs)
		window.vTreeObjs = [];
	window.vTreeObjs[id] = this;
	this.undoPilha = [];
	try {
		if(!DragObj) {};
	} catch(e) {
		alert(' necessrio a insero do script de controle de movimentos para a utilizao da arvore!');
		return;
	}	
	this.id = id;
	this.masterDiv = document.createElement('div');
	if(config) {
		this.config = config;
	} 
	if(!this.config)
		this.config = { };
	if(!config || !config.imgPath) {
		this.config.imgPath = '/_scripts/dragdrop/	tree/';
	}
	this.moveObj = new DragObj({ 	
		type: 'position',
		moveOpacity: 60,
		minDistance: 1000,
		onChangePosition: function (obj, insAntes) {
			if (obj.treeNode.isChildren(insAntes.parentNode.treeNode)) {
				obj.treeNode.setParent(obj.treeNode.movedFrom, obj.treeNode.movedPosition);
				return;
			}
			if (insAntes.treeNode) {
				var pos = obj.treeNode.getPosition();
				var posaf = insAntes.treeNode.getPosition();
				if(posaf > pos) {
					obj.treeNode.setParent(insAntes.parentNode.treeNode, posaf-1);
				} else {
					obj.treeNode.setParent(insAntes.parentNode.treeNode, posaf);
				}
			} else 
				obj.treeNode.setParent(insAntes.parentNode.treeNode);
			obj.treeNode.parent.open(true);
			
		},
		onDragStart: function(obj) {
			obj.treeNode.movedFrom = obj.treeNode.parent;
			obj.treeNode.movedPosition = obj.treeNode.getPosition();
		},
		onEndOverObj: function(obj, overObj) {
			obj.treeNode.setParent(overObj.treeNode,null);
		},
		onDragEnd: function (obj) {
			if(obj.treeNode.movedPosition != obj.treeNode.getPosition() || obj.treeNode.movedFrom != obj.treeNode.parent) {
				if(obj.treeNode.tree.config.onChangePosition)
					obj.treeNode.tree.config.onChangePosition(obj.treeNode, obj.treeNode.movedFrom, obj.treeNode.parent);
				obj.treeNode.tree.undoPilha.push('window.vTreeObjs["'+obj.treeNode.tree.id+'"].getNode("'+obj.treeNode.id+'").setParent('+(obj.treeNode.movedFrom?'"window.vTreeObjs["'+obj.treeNode.tree.id+'"].getNode("'+obj.treeNode.movedFrom.id+'")':'null')+', '+obj.treeNode.movedPosition+',true)');
			}
			obj.treeNode.movedFrom = null;
			obj.treeNode.movedTo = null;
			obj.treeNode.movedPosition = null;
		}});
	this.icon = {
		root			: this.config.imgPath+'base.gif',
		folder			: this.config.imgPath+'folder.gif',
		folderOpen		: this.config.imgPath+'folderopen.gif',
		node			: this.config.imgPath+'page.gif',
		empty			: this.config.imgPath+'empty.gif',
		line			: this.config.imgPath+'line.gif',
		join			: this.config.imgPath+'join.gif',
		joinBottom		: this.config.imgPath+'joinbottom.gif',
		plus			: this.config.imgPath+'plus.gif',
		plusBottom		: this.config.imgPath+'plusbottom.gif',
		minus			: this.config.imgPath+'minus.gif',
		minusBottom		: this.config.imgPath+'minusbottom.gif',
		nlPlus			: this.config.imgPath+'nolines_plus.gif',
		nlMinus			: this.config.imgPath+'nolines_minus.gif'
	};
	this.nodes = [];
	this.nodeIds = [];
	this.roots = []; //Todas os nos definidos como raiz da arvore
	this.selectedNode = null;
	this.openAll = function() {
		for(var i=0;i<this.nodes.length;i++) {
			this.nodes[i].open(true);
		}
	}
	this.closeAll = function() {
		for(var i=0;i<this.nodes.length;i++) {
			if(this.nodes[i].parent)
				this.nodes[i].open(false);
		}
	}
	/**
	 * Insere uma arvore na posio atual do documento
	 */
	this.print = function() {
		document.write('<div id="tree_'+this.id+'"></div>');
		(v_div = document.getElementById('tree_'+this.id)).appendChild(this.getObject());
	}
	this.rePrint = function() {
		(v_div = document.getElementById('tree_'+this.id)).appendChild(this.getObject());
	}
	/**
	 * Retorna o objeto de construo da arvore
	 */
	this.getObject = function() {
//		if(this.masterDiv)
//			this.masterDiv.removeNode(true);
		this.masterDiv = document.createElement('div');
		for(var i=0;i<this.roots.length;i++) {
			this.masterDiv.appendChild(this.roots[i].getObject());
		}
		return this.masterDiv;
	}
	/**
	 * Retorna o no da arvore pelo seu id
	 */
	this.getNode = function (id) {
		return this.nodeIds[id];
	}
	this.undo = function(number) {
		if(!number) 
			number = 1;
		for(var i=1;i<=number;i++) {
			if(this.undoPilha.length == 0)
				return i-1;
			eval((txt = this.undoPilha.pop()));
		}
	}
	/**
	 * Declaracao das propriedades e metodos dos nos
	 */
	this.Node = function(id,parent,text,tree,config,data) {
		this.id = id;
		this.parent = null;
		this.tree = tree;
		this.text = text;
		this.title = '';
		this.lastSibling = true;
		this.haveChildren = false;
		this.icon = document.createElement('img');
		this.divText = document.createElement('span');
		this.div = document.createElement('div');
//		this.div.style.width = '0px';
		this.divChildrens = document.createElement('span');
		this.divChild = document.createElement('div');
		this.divContext = document.createElement('button');
		this.indent = document.createElement("img");
		this.childs = [];
		this.config = config;
		this.icons = {};
		if(!data)
			this.data = {};
		else
			this.data = data;
		if(!this.config)
			if(this.tree.config.defaultNodeConfig)
				this.config = this.tree.config.defaultNodeConfig;
			else
				this.config = {};
		if(!this.config.alwaysHaveChildren)
			this.config.alwaysHaveChildren = false;
		this.opened = true;
		this.movedFrom = null;
		this.movedTo   = null;
		this.movedPosition = null;
		this.alwaysHaveChildren = false;
		this.setLastSibling = function (value) {
			if(this.lastSibling != value) {
				this.lastSibling = value;
				if(this.parent) {
					if(!this.lastSibling)
						this.divChild.style.background = 'url('+this.tree.icon.line+') repeat-y';
					else
						this.divChild.style.background = '';
				} else {
					this.divChild.style.paddingLeft = '0px';
					this.divChild.style.background = '';
				}
				this.getIndent();
			}
		}
		this.setHaveChildren = function(value) {
			if(this.config.alwaysHaveChildren) 
				value = true;
			if(this.haveChildren != value) {
				if (value) {
					this.open(this.opened, true);
				}
				this.haveChildren = value;
				this.getIcon();
				this.getIndent();
			}
		}
		this.addChild = function (node,position) {
			node.setLastSibling(false);
			if(this.childs.length > 0)
				this.childs[this.childs.length-1].setLastSibling(false);
			(position == null)?this.childs.push(node):this.childs.splice(position,0,node);
			for(var i=0;i<this.childs.length;i++)
				this.childs[i].setLastSibling(false);
			this.childs[this.childs.length-1].setLastSibling(true);
			this.setHaveChildren(true);
		}
		this.removeChild = function (node) {
			for(var i=0;i<this.childs.length;i++) {
				if(this.childs[i] == node) {
					this.childs.splice(i,1);
					i--;
				}
				if(i == this.childs.length-1)
					if(this.childs[i] && this.childs[i].setLastSibling)
						this.childs[i].setLastSibling(true);
			}
			this.setHaveChildren((this.childs.length > 0));
		}
		this.removeChilds = function() {
			for(var i=this.childs.length-1;i>=0;i--) {
				this.childs[i].destroy(true, true);
			}
		}
		this.destroy = function(recursive, force) {
			if(!force)
				force = false;
			if(this.config.beforeDestroy)
				if(!this.config.beforeDestroy(this,recursive,force))
					return;
			if(!this.parent) {
				alert('Ns da raiz da arvore no podem ser removidos!');
				return;
			}
			if(!recursive) {
				if(this.parent) {
					var pos = this.getPosition();
					for(var i=this.childs.length-1;i>= 0;i--) {
						this.childs[i].setParent(this.parent, pos, true);
					}
				}
			} else {
				for(var i=this.childs.length-1;i>=0;i--) {
					this.childs[i].destroy(recursive, true);
				}
			}
			
			this.div.removeNode(true);
			this.parent.removeChild(this);
			if(this.config.afterDestroy)
				this.config.afterDestroy(this);
		}

		/**
		 * Retorna o nivel da hierarquia em que se encontra o no
		 */
		this.getLevel = function() {
			return this.parent?this.parent.getLevel()+1:1;
		}
		this.open = function(value, force) {
			if(!force)
				force = false;
			if(!this.haveChildren) {
				this.opened = value;
				this.divChild.style.display = '';
			} 
			if(((this.haveChildren && this.opened != value) || force)  && this.parent) {
				this.divChild.style.display = value?'':'none';
				if(value)
					if(this.config.onOpen) 
						this.config.onOpen(this);
				else
					if(this.config.onClose)
						this.config.onClose(this);
				this.opened = value;
				this.getIcon();
				this.getIndent();
			}
		}
		this.openTo = function() {
			this.open(true);
			if(this.parent != null) {
				this.parent.openTo();
			}
		}
		/**
		 * Retorna o HTML para a contruo da estrutura de identacao
		 */
		this.getIndent = function() {
			if (this.parent) {
				this.indent.treeNode = this;
				if (this.haveChildren) {
					this.indent.src = this.lastSibling ? (this.opened?(this.icons.minusBottom?this.icons.minusBottom:this.tree.icon.minusBottom) :(this.icons.plusBottom?this.icons.plusBottom:this.tree.icon.plusBottom)) : (this.opened?(this.icons.minus?this.icons.minus:this.tree.icon.minus):(this.icons.plus?this.icons.plus:this.tree.icon.plus));
					this.indent.align = 'absmiddle';
					this.indent.alt = 'Expandir';
					this.indent.onclick = function() {
						this.treeNode.open(!this.treeNode.opened);
					}
				} else {
					this.indent.src = ( (this.lastSibling) ? (this.icons.joinBottom?this.icons.joinBottom:this.tree.icon.joinBottom) : (this.icons.join?this.icons.join:this.tree.icon.join) );
					this.indent.alt = '';
					this.indent.style.textAlign = 'left';
				}
				this.indent.style.display = '';
			} else {
				this.indent.style.display = 'none'; 
			}
			return this.indent;
		}
		this.setIconSrc = function(value) {
			this.icon.src = value;
		}
		this.getIcon = function() {
			this.icon.height = '16';
			this.icon.width = '16';
			this.icon.align = 'absmiddle';
			this.setIconSrc(this.haveChildren ? (this.opened?(this.icons.folderOpen?this.icons.folderOpen:this.tree.icon.folderOpen):(this.icons.folder?this.icons.folder:this.tree.icon.folder)) : (this.icons.node?this.icons.node:this.tree.icon.node));
			return this.icon;
		}
		this.setText = function(value) {
			this.text = value;
			this.getText();
		}
		this.getText = function() {
			this.divText.innerHTML = this.text;
			this.divText.className = 'node';
			return this.divText;
		}
		this.getContext = function() {
			this.divContext.appendChild(this.getIcon());
			this.divContext.appendChild(this.getText());
			this.divContext.className = 'button_node'; 
			if (navigator.appName != "Microsoft Internet Explorer") this.divContext.type = 'button';
			with(this.divContext) {
				this.divContext.treeNode = this;
				onclick = function() {
					this.treeNode.click();
				}
				onmouseover = function() {
					this.treeNode.mouseover();
				}
				onmouseout = function() {
					this.treeNode.mouseout();
				}
				oncontextmenu = function() {
					return this.treeNode.contextMenu();
				}
				ondblclick = function() {
					this.treeNode.dblClick();
				}
			}
			
			return this.divContext;
		}
		this.click = function() {
			this.select(true);
			if(this.config.onclick)
				this.config.onclick(this);
		}
		this.dblClick = function() {
			if(this.config.ondblclick)
				this.config.ondblclick(this);
		}
		this.mouseover = function() {
			if(this.config.onmouseover)
				this.config.onmouseover(this);
		}
		this.mouseout = function() {
			if(this.config.onmouseout)
				this.config.onmouseout(this);
		}
		this.contextMenu = function() {
			if(this.config.oncontextmenu)
				return this.config.oncontextmenu(this);
			else
				return true;
		}
		this.mouseout = function() {
			if(this.config.onmouseout)
				this.config.onmouseout(this);
		}
		this.select = function(value) {
			if(this.tree.selectedNode && this.tree.selectedNode != this)
				this.tree.selectedNode.select(false);
			this.divText.className = value?'nodeSelect':'node';
			this.tree.selectedNode = this;
			if(this.config.onSelect)
				this.config.onSelect(this);
		}
		this.getObject = function() {
			this.div.innerHTML = '';
			this.div.style.whiteSpace = 'nowrap';
			this.div.treeNode = this;
			this.div.appendChild(this.getIndent());
			this.div.appendChild(this.getContext());
			this.div.appendChild(this.divChild);
			this.divChild.appendChild(this.divChildrens);
			this.divChildrens.treeNode = this;
			for(var j=0;j<this.childs.length;j++) {
				this.divChildrens.appendChild(this.childs[j].getObject());
			}
			this.tree.moveObj.addPosition(this.divChildrens);
			return this.div;
		}
		this.getPosition = function() {
			if(this.parent) {
				for(var i=0;i<this.parent.childs.length;i++) {
					if(this.parent.childs[i] == this) {
						return i;
					}
				}
			}
		}
		this.toString = function (ident) {
			str = this.id;
			return str;
		}
		this.setParentMoving = function(parent,position) {
			this.setParent(parent,position);
			if (this.getPosition() == this.parent.childs.length-1) {
				this.parent.divChildrens.insertBefore(this.div, this.parent.divChildrens.childNodes[this.parent.divChildrens.childNodes.length-1]);
			} else {
				this.parent.divChildrens.insertBefore(this.div, this.parent.childs[this.getPosition()+1].div);
			}
		}
		this.setParent = function(parent, position, setEvent) {
			if(parent == this)
				return;
			var oldParent = this.parent;
			var oldPosition = this.getPosition();
			if(this.parent) {
				this.parent.removeChild(this);
			}
			if(parent) {
				parent.addChild(this,position);
			}				
			this.parent = parent;
			this.refresh();
			if(this.parent) {
				this.divChild.style.paddingLeft = '18px';
				if(this.div.parentNode != this.parent.divChildrens) {
					if (this.getPosition() == this.parent.childs.length-1) {
						this.parent.divChildrens.insertBefore(this.div, this.parent.divChildrens.childNodes[this.parent.divChildrens.childNodes.length-1]);
					} else {
						this.parent.divChildrens.insertBefore(this.div, this.parent.childs[this.getPosition()+1].div);
					}
				}
			}
			else
				this.divChild.style.paddingLeft = '0px';
			if(setEvent)
				if(this.tree.config.onChangePosition)
					this.tree.config.onChangePosition(this, oldParent, this.parent);
		};
		this.isChildren = function(node) {
			for(var i=0;i<this.childs.length;i++) {
				if(this.childs[i] == node || this.childs[i].isChildren(node))
					return true;
			}
			return false;
		}
		this.refresh = function() {
			if(this.lastSibling) {
				this.divChild.style.background = '';
			} else {
				this.divChild.style.background = 'url('+this.tree.icon.line+') repeat-y';
			}	
			this.getIndent();		
		}
		this.setTitle = function(value) {
			this.div.title = value;
			this.title = value;
		}
		this.setParent(parent);
		this.open(false);
		this.moved = false;
	}
	/**
	 * Insere um novo no na arvore
	 */
	this.addNode = function(id,pid,text,config,data) {
		this.nodes.push((this.nodeIds[id] = new this.Node(id,this.getNode(pid),text,this,config,data)));
		if(!this.getNode(pid)) {
			if(this.roots.length > 0)
				this.roots[this.roots.length-1].setLastSibling(false);
			this.roots.push(this.nodeIds[id]);
			
		}
		this.moveObj.addObj(this.nodeIds[id].getObject(), this.nodeIds[id].getIcon());
		if(this.config.onAddNode)
			this.config.onAddNode(this.nodeIds[id]);
		return this.nodeIds[id];
	}
	this.printStruct = function() {
		alert(this.roots);
	}
}