// JavaScript Document

function PopupMenu (id,config) {
	this.id = id;
	this.config = config;
	this.items = [];
	this.itemIds = [];
	this.opening = false;
	this.baseWindow = top;
	this.contentDiv = document.createElement("div");
	this.contentDiv.style.zIndex = 50000001;
	this.shieldDiv = document.createElement("div");
	this.shieldDiv.style.zIndex = 50000000;
	this.contentTable = document.createElement("table");
	this.contentTBody = document.createElement("tbody");
	this.scrollElement = null;
	this.positionOffset = { left:0,top:0 };
	if(!document.vPopupArray)
		document.vPopupArray = []
	document.vPopupArray.push(this);
	this.shieldFrame = document.createElement('iframe');
	with(this.shieldDiv) {
		appendChild(this.shieldFrame);
		style.position = 'absolute';
		style.display = 'none';
	}
	with(this.shieldFrame) {
		width = '100%';
		height = '100%';
	}
	with(this.contentTable) {
		width = '100%';
		className = 'popup_borda';
		appendChild(this.contentTBody);
		cellPadding = 2;
		cellSpacing = 0;
	}
	this.contentTable.popupObj = this;
	this.contentTable.onclick = function () {
		this.popupObj.hide();
	}
	with(this.contentDiv) {
		style.position = 'absolute';
		className = 'borda';
		style.display = 'none';
		style.backgroundColor = '#f9f9f9';
		if(document.all)
			style.width = 200;
		appendChild(this.contentTable);
	}
	this.show = function (left,top,leftclick) {
		this.opening = true;
		if(document.vPopupOpened != null)
			document.vPopupOpened.hide();
		document.body.appendChild(this.contentDiv);
		document.body.appendChild(this.shieldDiv);
		document.onclick = function() {
			if(document.vPopupOpened && !document.vPopupOpened.opening) {
				document.vPopupOpened.hide();
			}
			if(document.vPopupOpened && document.vPopupOpened.opening)
				document.vPopupOpened.opening = false;
		}
		this.baseWindow.document.onclick = document.onclick;
		v_get_scroll_element_old = v_get_scroll_element;
		v_get_scroll_element = this.scrollElement;
		
		f_get_scroll();
		v_get_scroll_element = v_get_scroll_element_old;
		with(this.contentDiv) {
			v_top = Number(top) + Number(scrOfY);
			style.display = '';
			// Verifica se o Popupmenu no excede o limite inferior
			if(v_top + Number(offsetHeight) > Number(scrOfY) + Number(scrOfHeight)) {
				// Move o Popup para tocar o limite inferior da pagina
				v_top = v_top - Math.abs((v_top + Number(offsetHeight)) - (Number(scrOfY) + Number(scrOfHeight)));
			}
			if(v_top < scrOfY) {
				v_top = scrOfY;
			}
			style.top = v_top + this.positionOffset.top;

			v_left = Number(left) + Number(scrOfX);
			// Verifica se o Popupmenu no excede o limite inferior
			if(v_left + Number(offsetWidth) > Number(scrOfX) + Number(scrOfWidth)) {
				// Move o Popup para tocar o limite inferior da pagina
				v_left = v_left - Math.abs((v_left + Number(offsetWidth)) - (Number(scrOfX) + Number(scrOfWidth)));
			}
			if(v_left < scrOfX) {
				v_left = scrOfX;
			}
			style.left = v_left + this.positionOffset.left;
			style.width = offsetWidth;
		}
		with(this.shieldDiv) {
			style.top = this.contentDiv.style.top;
			style.left = this.contentDiv.style.left;
			this.shieldDiv.style.width = this.contentDiv.offsetWidth;
			this.shieldDiv.style.height = this.contentDiv.offsetHeight;
			this.shieldDiv.style.overflow = 'hidden';
			style.display = ''; 
		}
		document.vPopupOpened = this;
		if(!leftclick) {
			this.opening = false;
		}
	}
	this.hide = function () {
		this.contentDiv.style.display = 'none';
		this.shieldDiv.style.display = 'none';
		if(document.vPopupOpened == this)
			document.vPopupOpened = null;
	}
	this.MenuItem = function(popupMenu,name,separador,label,icon,onclick) {
		this.parent = popupMenu;
		this.parent.items.push(this);
		this.parent.itemIds[name] = this;
		this.contentTr = document.createElement('tr');
		this.parent.contentTBody.appendChild(this.contentTr);
		this.separador = separador;
		if(separador) {
			this.contentSeparator = document.createElement("td");
			with(this.contentSeparator) {
				colSpan = 2;
				height = 2;
				className = 'separador_h';
			}
			this.contentTr.appendChild(this.contentSeparator);
		} else {
			this.iconTd = document.createElement("td");
			this.contentTr.appendChild(this.iconTd);
			this.contentTr.style.cursor = 'pointer';
			this.contentTr.onmouseover = function() {
				this.className = 'linha_1';
			}
			this.contentTr.onmouseout = function() {
				this.className = '';
			}
			this.image = document.createElement("img");
			this.image.width = 16;
			this.image.height = 16;
			this.image.align = 'absmiddle';
			with(this.iconTd) {
				className = 'popup_degrade';
				appendChild(this.image);
				width = '1%';
			}
			this.labelTd = document.createElement("td");
			this.labelTd.className = 'texto';
			this.contentTr.appendChild(this.labelTd);
			this.setIcon = function(icon) {
				this.image.src = icon;
				this.image.style.display = (icon.length == 0)?'none':'';
			}
			this.setLabel = function(label) {
				this.labelTd.innerHTML = '<nobr>'+label+'</nobr>';
			}
			this.setLabel(label);
			this.setIcon(icon);
			this.setOnClick = function(value) {
				this.contentTr.onclick = value;
			}
			this.setOnClick(onclick);
		}
		this.setVisible = function (value) {
			this.contentTr.style.display = value?'':'none';
		}
	}
	this.addItem = function (name,label,icon,onclick) {
		return new this.MenuItem(this,name,false,label,icon,onclick);
	}
	this.addSeparator = function(name) {
		return new this.MenuItem(this,name,true);
	}
	this.contextMenu = function(event,wnd) {
		if(!wnd)
			wnd = window;
		if(!event) {
			v_left = wnd.event.clientX;
			v_top = wnd.event.clientY;
		} else {
			v_left = event.clientX;
			v_top = event.clientY;
		}
		this.show(v_left,v_top);
		if(wnd && wnd.event)
			wnd.event.cancelBubble = true;
		else
			event.cancelBubble = true;
		return false;
	}
	this.showMenu = function(event) {
		if(!event) {
			v_left = window.event.clientX;
			v_top = window.event.clientY;
		} else {
			v_left = event.clientX;
			v_top = event.clientY;
		}
		this.show(v_left,v_top,true);
		return false;
	}
}


