// JavaScript Document
function InfoGrama(name,div,config) {
	this.name = name;
	this.div = div;
	this.div.infoObj = this;
	this.config = config;
	this.faixas = [];
	this.getWidth = function () {
		return this.div.offsetWidth;
	}
	this.getHeight = function () {
		return this.div.offsetHeight;
	}
	this.getScroll = function() {
		if( typeof( window.pageYOffset ) == 'number' ) {
			this.scrOfY = window.pageYOffset;
			this.scrOfX = window.pageXOffset;
		} else if( document.body && ( document.body.scrollLeft || document.body.scrollTop ) ) {
			this.scrOfY = document.body.scrollTop;
			this.scrOfX = document.body.scrollLeft;
		} else if( document.documentElement && ( document.documentElement.scrollLeft || document.documentElement.scrollTop || document.documentElement.scrollTop == 0) ) {
			this.scrOfY = document.documentElement.scrollTop;
			this.scrOfX = document.documentElement.scrollLeft;
		}
	}

	this.div.onmouseover = function () {
		if (this.infoObj.config.onmouseover)
			this.infoObj.config.onmouseover();
	}
	this.div.onmousemove = function (ev) {
		if(window.event)
			ev = window.event;
		this.infoObj.getScroll(ev);
		if (this.infoObj.config.onmousemove) {
			v_posobjx = this.infoObj.posicaoObjeto(this.infoObj.div, true);
			v_posobjy = this.infoObj.posicaoObjeto(this.infoObj.div, false);
			this.infoObj.config.onmousemove(this.infoObj,{	
				x: ev.clientX + this.infoObj.scrOfX,
				y: ev.clientY + this.infoObj.scrOfY,
				left: ev.clientX - v_posobjx + this.infoObj.scrOfX,
				top: ev.clientY - v_posobjy + this.infoObj.scrOfY,
				leftPerc: this.infoObj.getPercX(ev.clientX - v_posobjx + this.infoObj.scrOfX),
				topPerc: this.infoObj.getPercY(ev.clientY - v_posobjy + this.infoObj.scrOfY)
			});
		}
	}
	this.div.oncontextmenu = function (ev) {
		if(window.event)
			ev = window.event;
		this.infoObj.getScroll(ev);
		if (this.infoObj.config.oncontextmenu) {
			v_posobjx = this.infoObj.posicaoObjeto(this.infoObj.div, true);
			v_posobjy = this.infoObj.posicaoObjeto(this.infoObj.div, false);
			return this.infoObj.config.oncontextmenu(event,this.infoObj,{	
				x: ev.clientX + this.infoObj.scrOfX,
				y: ev.clientY + this.infoObj.scrOfY,
				left: ev.clientX - v_posobjx + this.infoObj.scrOfX,
				top: ev.clientY - v_posobjy + this.infoObj.scrOfY,
				leftPerc: this.infoObj.getPercX(ev.clientX - v_posobjx + this.infoObj.scrOfX),
				topPerc: this.infoObj.getPercY(ev.clientY - v_posobjy + this.infoObj.scrOfY)
			});
		}
	}
	this.getPercX = function (left) {
		return left / this.getWidth();
	}
	this.getPercY = function (top) {
		return top / this.getHeight();
	}
	this.div.onmouseout = function () {
		if (this.infoObj.config.onmouseout)
			this.infoObj.config.onmouseout();
	}
	this.getScroll = function() {
		if( typeof( window.pageYOffset ) == 'number' ) {
			this.scrOfY = window.pageYOffset;
			this.scrOfX = window.pageXOffset;
		} else if( document.body && ( document.body.scrollLeft || document.body.scrollTop ) ) {
			this.scrOfY = document.body.scrollTop;
			this.scrOfX = document.body.scrollLeft;
		} else if( document.documentElement && ( document.documentElement.scrollLeft || document.documentElement.scrollTop || document.documentElement.scrollTop == 0) ) {
			this.scrOfY = document.documentElement.scrollTop;
			this.scrOfX = document.documentElement.scrollLeft;
		}
	}
	this.posicaoObjeto = function (p_obj,p_left){
		var total=0;
		while(p_obj!=null){
			total+=p_obj["offset"+(p_left?"Left":"Top")];
			p_obj=p_obj.offsetParent;
		}
		return total;
	}
	this.setInitialDate = function (value) {
		this.initialDate = value;
	}
	this.setFinalDate = function (value) {
		this.finalDate = value;
	}
	this.getDate = function(leftPerc) {
		return new Date(Number(this.initialDate)+((Number(this.finalDate)-Number(this.initialDate))*leftPerc));
	}
	this.getPercPosition = function(perc) {
		return Math.round(this.getWidth()*perc);
	}
	this.getDatePosition = function(date) {
		return this.getPercPosition((Number(date)-Number(this.initialDate))/(Number(this.finalDate)-Number(this.initialDate)));
	}
	this.Faixa = function (parent,id) {
		this.parent = parent;
		this.id 	= id;
		this.div = document.createElement('div');
		this.div.faixaObj = this;
		this.icons = [];
		this.left = 0;
		this.color = '';
		this.opacity = '';
		this.setZIndex = function(index) {
			this.div.style.zIndex = index;
		}
		this.setVisible = function (value) {
			this.div.style.display = value?'':'none';
		}
		this.div.onmouseover = function () {
			if(this.faixaObj.onmouseover)
				this.faixaObj.onmouseover(this.faixaObj);
		}
		this.div.onmouseout = function () {
			if(this.faixaObj.onmouseout)
				this.faixaObj.onmouseout(this.faixaObj);
		}
		this.setWidth = function(value) {
			this.div.style.width = value;
		}
		this.getWidth = function() {
			return Number(this.div.style.width.replace('px',''));
		}
		this.setOpacity = function (value) {
			this.opacity = value;
			this.div.style.opacity 		= value/100;
			this.div.style.filter		= "alpha(opacity="+value+")";
		}
		with(this.div) {
			style.display = '';
			style.position = 'absolute';
			style.left = this.parent.posicaoObjeto(this.parent.div, true);
			style.top  = this.parent.posicaoObjeto(this.parent.div, false);
			style.height = this.parent.getHeight();
			style.width = 0;
			style.backgroundColor = '#000000';
		}
		this.setOpacity(50);
		this.setWidth = function(value) {
			if(this.getLeft() + value > this.parent.getWidth()) {
				alert('No  possvel inserir a faixa fora do infograma!');
				return;
			}
			this.div.style.width = value;
		}
		this.setLeft = function(value) {
			if(value > this.parent.getWidth() || value < 0) {
				alert('No  possvel inserir a faixa fora do infograma!');
				return;
			}
			this.div.style.left = this.parent.posicaoObjeto(this.parent.div, true)+value;
			this.left = Number(String(this.div.style.left).replace('px',''));
		}
		this.getLeft = function() {
			return Number(String(this.div.style.left).replace('px',''));
		}
		this.setColor = function (value) {
			this.color = value;
			this.div.style.backgroundColor = value;
		}
		this.destaca = function() {
			this.div.style.backgroundColor = '#FFFF00';
			this.div.style.opacity 		= 1;
			this.div.style.filter		= "alpha(opacity=100)";
			for(var i=0;i<this.parent.faixas.length;i++) {
				this.parent.faixas[i].setZIndex(10);
			}
		}
		this.undestaca = function() {
			this.div.style.backgroundColor = this.color;
			this.setOpacity(this.opacity);
		}
		this.setTitle = function(value) {
			this.div.title = value;
		}
		this.parent.div.appendChild(this.div);
		this.getIconHeight = function() {
			v_soma = 0;
			for(var i=0;i<this.icons.length;i++) {
				v_soma += this.icons[i].getHeight();
			}
			return v_soma;
		}
		this.getTop = function() {
			return Number(this.div.style.top.replace('px',''));
		}		
		this.focus = function () {
			this.div.focus();
		}
		
		this.addIcon = function (src,title,data) {
			v_icon = new this.Icon(this,src,title);
			this.icons.push(v_icon);
			return v_icon;
		}
		this.Icon = function (faixa, src, title, data) {
			this.data = data;
			this.parent = faixa;
			this.div = document.createElement('div');
			this.parent.parent.div.appendChild(this.div);
			this.image = document.createElement('img');
			this.div.appendChild(this.image);
			
			this.div.iconObj = this;
			this.div.onmouseover = function() {
				this.style.zIndex = 100000;
				this.style.backgroundColor = '#FFFFFF';
				this.style.border = '1px solid #CCCCCC';
				this.iconObj.parent.destaca();
				this.iconObj.parent.setZIndex(1000);
				this.padding = '1px 1px 1px 1px'
				if(this.iconObj.onmouseover)
					return this.iconObj.onmouseover(this.iconObj);
			}
			this.div.onmouseout = function() {
				this.style.zIndex = 1001;
				this.style.backgroundColor = '';
				this.iconObj.parent.undestaca();
				this.style.border = '';
				this.style.padding = '';
				this.iconObj.parent.setZIndex(900);
				if(this.iconObj.onmouseout)
					return this.iconObj.onmouseout(this.iconObj);
			}
			this.div.oncontextmenu = function() {
				if(this.iconObj.oncontextmenu)
					return this.iconObj.oncontextmenu(this.iconObj);
			}
			this.div.onclick = function() {
				if(this.iconObj.onclick)
					return this.iconObj.onclick(this.iconObj);
			}
			this.setSrc = function (value) {
				this.src = value;
				this.image.style.zIndex = 1001;
				this.image.src = value;
				this.image.alt = this.parent.div.title;
			}
			this.getHeight = function() {
				return this.image.height;
			}
			this.getWidth = function() {
				return this.image.width;
			}
			this.getTop = function() {
				return Number(String(this.div.style.top).replace('px',''));
			}
			this.setSrc(src);
			this.reposiciona = function () {
				with(this.div) {
					style.position = 'absolute';
					style.zIndex = 1001;
					style.left = Number(this.parent.div.style.left.replace('px',''))-((this.image.width/2)-(this.parent.getWidth()/2));
					if(Number(String(style.left).replace('px','')) < 0) {
						style.left = '0px';
					}
					v_anteriores = 0;
					for(var j=0;j<this.parent.parent.faixas.length;j++) {
						if(Math.abs(this.parent.parent.faixas[j].getLeft() - this.parent.getLeft()) <= (this.getWidth()/2) ) {
							for(var i=0;i<this.parent.parent.faixas[j].icons.length;i++) {
								if (this.parent.icons[i] == this)
									break;
								v_anteriores = this.parent.parent.faixas[j].icons[i].getTop()+this.parent.parent.faixas[j].icons[i].getHeight();
							}
						}
					}
					style.top = this.parent.getTop() + v_anteriores;
				}
			}
			this.reposiciona();
			
			this.setTitle = function (value) {
				this.title = value;
				this.div.title = value;
			}
			this.setTitle(title);
			this.destroy = function () {
				this.div.removeNode(true);
				
			}
		}
		this.destroy = function () {
			for(j=0;j<this.icons.length;j++) {
				this.icons[j].destroy();
			}
			this.div.removeNode(true);
		}
	}
	this.addFaixa = function (id) {
		v_obj = new this.Faixa(this,id);
		this.faixas.push(v_obj);
		return v_obj;
	}
	
	this.cleanFaixas = function () {
		for(i=0;i<this.faixas.length;i++) {
			this.faixas[i].destroy();
		}
		this.faixas = [];
	}
	
	this.getLarguraDia = function() {
		return this.getDatePosition(new Date(Number(Number(this.initialDate)+(1000*60*60*24))))-info.getDatePosition(this.initialDate);
	}
	
	this.truncDate = function(date) {
		date.setHours(0);
		date.setMinutes(0);
		date.setSeconds(0);
		return date;
	}
	this.addDessecacaoPeriod = function(data) {
		var v_dias_dessec = ((Number(this.initialDate) - Number(data)) / (1000 * 60 * 60 * 24));
		var v_dias_info = ((Number(this.finalDate) - Number(this.initialDate)) / (1000 * 60 * 60 * 24));
		var v_padding_add = Number(this.getWidth()) * (v_dias_dessec/v_dias_info);
		this.div.style.width = Math.round(Number(String(this.getWidth()).replace('px','')) + (v_padding_add));
		this.div.style.paddingLeft = Math.round(v_padding_add);
		this.setInitialDate(data);
	}
}