// JavaScript Document
if (GBrowserIsCompatible()) {
	// A TextualZoomControl is a GControl that displays textual "Zoom In"
	// and "Zoom Out" buttons (as opposed to the iconic buttons used in
	// Google Maps).
	function SmallMapTypeControl() {
	}
	SmallMapTypeControl.prototype = new GControl();
	
	// Creates a one DIV for each of the buttons and places them in a container
	// DIV which is returned as our control element. We add the control to
	// to the map container and return the element for the map class to
	// position properly.
	SmallMapTypeControl.prototype.initialize = function(map) {
		var container = document.createElement("div");
		
		var btnMapa = document.createElement("span");
		this.setButtonStyle_(btnMapa);
		container.appendChild(btnMapa);
		btnMapa.appendChild(document.createTextNode("M"));
		GEvent.addDomListener(btnMapa, "click", function() {
			map.setCenter(map.getCenter(),map.getZoom(),G_NORMAL_MAP);
		});
		
		var btnSatelite = document.createElement("span");
		this.setButtonStyle_(btnSatelite);
		container.appendChild(btnSatelite);
		btnSatelite.appendChild(document.createTextNode("S"));
		GEvent.addDomListener(btnSatelite, "click", function() {
			map.setCenter(map.getCenter(),map.getZoom(),G_SATELLITE_MAP);
		});
		
		var btnHibrido = document.createElement("span");
		this.setButtonStyle_(btnHibrido);
		container.appendChild(btnHibrido);
		btnHibrido.appendChild(document.createTextNode("H"));
		GEvent.addDomListener(btnHibrido, "click", function() {
			map.setCenter(map.getCenter(),map.getZoom(),G_HYBRID_MAP);
		});
		
		var btnPhisical = document.createElement("span");
		btnPhisical.title = 'Mapa Fisico';
		this.setButtonStyle_(btnPhisical);
		container.appendChild(btnPhisical);
		btnPhisical.appendChild(document.createTextNode("F"));
		GEvent.addDomListener(btnPhisical, "click", function() {
			map.setCenter(map.getCenter(),map.getZoom(),G_PHYSICAL_MAP);
		});
		
		var btnDestacar = document.createElement("span");
		this.setButtonStyle_(btnDestacar);
		container.appendChild(btnDestacar);
		btnDestacar.appendChild(document.createTextNode("D"));
		GEvent.addDomListener(btnDestacar, "click", function() {
			var cont = map.getContainer();
			var oldCenter = map.getCenter();
			if(!cont.mapDetached) {
				cont.mapDetached = true;
				cont.oldTop = cont.style.top;
				cont.oldLeft = cont.style.left;
				cont.oldWidth = cont.style.width;
				cont.oldHeight = cont.style.height;
				cont.oldPosition = cont.style.position;
				cont.oldCenter = map.getCenter();
				cont.oldParent = cont.parentNode;
				cont.oldBodyOverflow = document.body.style.overflow;
				document.body.style.overflow = 'hidden';
				document.body.appendChild(cont);
				cont.style.position = 'absolute';
				cont.style.top = '0px';
				cont.style.left = '0px';
				cont.style.width = document.body.offsetWidth;
				cont.style.height = document.body.offsetHeight;
				cont.style.zIndex = 80000;
				document.detachedMap = map;
				document.oldonresizedetachedMap = window.onresize;
				window.onresize = function() {
					var cont = document.detachedMap.getContainer();
					cont.style.width = document.body.offsetWidth;
					cont.style.height = document.body.offsetHeight;
					document.detachedMap.checkResize();
					if(document.oldonresizedetachedMap)
						document.oldonresizedetachedMap();
				}
			} else {
				cont.mapDetached = false;
				cont.oldParent.appendChild(cont);
				document.body.style.overflow = cont.oldBodyOverflow;
				cont.style.top = cont.oldTop;
				cont.style.left = cont.oldLeft;
				cont.style.width = cont.oldWidth;
				cont.style.height = cont.oldHeight;
				cont.style.position = cont.oldPosition;
				if(document.oldonresizedetachedMap)
					window.onresize = document.oldonresizedetachedMap;
				else
					window.onresize = function () {};
			}
			map.checkResize();
			map.setCenter(oldCenter);
		});
		map.getContainer().appendChild(container);
		return container;
	}
	
	// By default, the control will appear in the top left corner of the
	// map with 7 pixels of padding.
	SmallMapTypeControl.prototype.getDefaultPosition = function() {
	  return new GControlPosition(G_ANCHOR_TOP_RIGHT, new GSize(0, 0));
	}
	
	// Sets the proper CSS for the given button element.
	SmallMapTypeControl.prototype.setButtonStyle_ = function(button) {
	  button.style.color = "#000000";
	  button.style.backgroundColor = "white";
	  button.style.font = "small Arial";
	  button.style.fontSize = "12";
	  button.style.border = "1px solid black";
	  button.style.padding = "2px";
	  button.style.marginBottom = "0px";
	  button.style.textAlign = "center";
	  button.style.width = "20px";
	  button.style.cursor = "pointer";
	}
}