// JavaScript Document
function DataSet(name,form,fieldlist, config) {
	this.name = name;
	if(config)
		this.config = config;
	else
		this.config = {};	
	this.fieldlist = fieldlist.split(',');
	this.fields = [];
	this.fieldByName = [];
	this.form = form;
	this.addField = function (name, type, def) {
		if(this.fieldByName[name] != null && this.fieldByName[name] != 'undefined') {
//			alert('Campo j existente no Dataset!');
			return;
		}
		this.fields.push((field = new this.Field(name, type, def, this)));
		this.fieldByName[name] = field;
		this.fieldlist.push(name);
	}
	this.Field = function (name, type, def, dataset) {
		this.name = name;
		this.type = type;
		this.dataset = dataset;
		this.def = def;
		this.values = [];
		this.valueFields = [];
		this.addRow = function(value) {
			this.values.push(value?value:this.def);
			this.valueFields.push(document.createElement('input'));
			with(this.valueFields[this.valueFields.length-1]) {
				type = 'hidden';
				name = this.name+'_'+this.dataset.name+'_'+(this.valueFields.length-1);
			}
			this.valueFields[this.valueFields.length-1].value = (value != null)?value:def;
			this.dataset.form.appendChild(this.valueFields[this.valueFields.length-1]);
		}
		this.deleteRow = function (row) {
			this.values.splice(row,1);
			this.valueFields[row].removeNode(true);
			this.valueFields.splice(row,1);
		}
		this.setValue = function (value, row) {
			this.values[row] = value;
			this.valueFields[row].value = value;
		}
	}
	this.addRow = function(fieldValues) {
		for(var i=0;i<this.fields.length;i++) {
			this.fields[i].addRow(fieldValues?fieldValues[i]:null);
		}
		if(this.config.onAddRow)
			this.config.onAddRow(this,this.fields[0].values.length-1);
	}
	this.deleteRow = function(row) {
		for(var i=0;i<this.fields.length;i++) {
			this.fields[i].deleteRow(row);
		}
	}
	this.clear = function() {
		for(var i=0;i<this.fields.length;i++) {
			for(var j=this.fields[i].values.length-1;j>=0;j--)
				this.fields[i].deleteRow(j);
		}
	}
	for(var i=0;i<this.fieldlist.length;i++) {
		this.addField(this.fieldlist[i],'String','');
	}
	
}