var v_seta=null;
/*
Retorna o div para a movimentao
*/

var v_processando=null;
var v_div=null;
function f_div() {
	try{
		if(!v_div){
			v_div=document.createElement("DIV");
			v_div.style.display="none";
			v_div.style.position="absolute";
			v_div.style.cursor="move";
			v_div.style.paddingTop="3px";
			document.body.appendChild(v_div);
		}
		return v_div;
	}catch(e){}
}
f_div();
/*
Retorna o div de processando
*/
function f_processando() {
	try{
		if(!v_processando){
			v_processando=document.createElement("DIV");
			v_processando.style.display="none";
			v_processando.style.position="absolute";
			v_processando.className = 'processando';
			v_processando.align = 'center';
			v_processando.style.verticalAlignment = 'middle';
			v_processando.innerHTML = '<br><div style="height: 15px"></div>Aguarde, processando...';
			document.body.appendChild(v_processando);
		}
		return v_processando;
	}catch(e){}
}
f_processando();
/** 
 * Retorna o div de indicacao da posicao de colocao da coluna 
 */
function f_seta() {
	try{
		if(!v_seta){
			v_seta=document.createElement("DIV");
			v_seta.style.display="";
			v_seta.style.position="absolute";
			v_seta.style.paddingBottom="0px";
			v_seta.style.top = -20;
			v_seta.style.left = -20;
			v_seta.innerHTML = '<img src="/_imagens/botoes/16x16/acima.gif">';
			document.body.appendChild(v_seta);
		}
		return v_seta;
	}catch(e){}
}
f_seta();	

/**
 * Classe de controle do script de movimentao
 */
var v_obj = null;
function objControleDrag() {
	this.obj  = null;
	this.tbl = null;
	this.summaries= [];
	/**
	 * Retorna o numero de celulas de uma tabela considerando colspans
	 */
	this.getTableCellLength = function(tbl) {
		var cellLength = 0;
		var t = (tbl.tHead.rows[1])?1:0;
		for(var i=0;i<tbl.tHead.rows[t].cells.length;i++) {
			if(tbl.tHead.rows[t].cells[i].style.display != 'none')
				cellLength += tbl.tHead.rows[t].cells[i].colSpan;
		}
		return cellLength;
	}
	/**
	 * Inicializa uma tabela com o script de movimentacao e agrupamento
	 */
	this.initTable = function(tbl) {
		this.tbl = tbl;
		this.tbl.dragDropTableObj = this;
		tbl.fieldTds = new Array();
		tbl.headerTr = tbl.tHead.rows[0];
		/**
		 * Inicializa todas as colunas do THead da tabela
		 */
		for(var i=0;i<tbl.tHead.rows[0].cells.length;i++) {
			tbl.tHead.rows[0].cells[i].indexCol = i;
			if(tbl.tHead.rows[0].cells[i].getAttribute('type') != 'nao_ordenar') {
				tbl.tHead.rows[0].cells[i].style.paddingRight = '14px';
				tbl.tHead.rows[0].style.cursor = 'pointer';
			}
			this.init(tbl.tHead.rows[0].cells[i], tbl);
		}
		
		for(var i=0;i<tbl.tBodies[0].rows.length;i++) {
			tbl.tBodies[0].rows[i].indexDrag = i;
		}
		//insere a linha de agrupamento
		this.addGroupColumn(tbl);
		/**
		 * Inicializa os divs de seta e processando
		 */
		f_seta();
		f_processando();		
	}
	/**
	 * Cria a linha de agrupamentos da tabela 
	 */
	this.addGroupColumn = function(tbl) {
		var _tr = document.createElement("TR");
			_tr.style.height = '40px';
			_tr.oncontextmenu = function(event) {
				if(tbl.oncontextGroupTr) {
					try {
						return tbl.oncontextGroupTr(event);
					} catch(e) {
						return false;
					}
				}
				return true;
			}
			var _td = document.createElement("TD");
			_td.className = 'grupos';
				_td.colSpan = this.getTableCellLength(this.tbl);
				_td.verticalAlign = 'middle';
				var _tbl1 = document.createElement("table");
					_tbl1.border = '0';
					_tbl1.cellSpacing = '10px';
					var _tb1 = document.createElement("tbody");
						var _tr1 = document.createElement("tr");
							var _td1 = document.createElement("td");
								_td1.style.display = '';
								_td1.innerHTML = '';
								_td1.style.width = 0;
								_td1.style.visibility = 'hidden';
							_tr1.appendChild(_td1);
						_tb1.appendChild(_tr1);
					_tbl1.appendChild(_tb1);
				_td.appendChild(_tbl1);
			_tr.appendChild(_td);
		tbl.tHead.insertBefore(_tr, tbl.tHead.rows[0]);
		tbl.groupTr = _tr1;
		this.init(_td1, tbl);
	}
	/**
	 * Inicializa a Coluna para a movimentao
	 */
	this.init = function(a, tbl){ 
		//inclui o objeto na lista de objetos moveis da tabela
		tbl.fieldTds[tbl.fieldTds.length] = a;
		//cria a referencia entre o objeto e a tabela
		a.tblRef = tbl;
		//chama o start da movimentacao no clique do mouse
		if(a.getAttribute('type') != 'nao_ordenar')
			a.onmousedown=al.start;
		if(isNaN(parseInt(f_div().style.left)))
			f_div().style.left = "0px";
		if(isNaN(parseInt(f_div().style.top)))
			f_div().style.top  = "0px";
		//Cria as funes para tratamento das etapas de movimentao
		a.onDragStart = function(af,ag){
			clearInterval(ap);
			var ai=this;
			ai.origNextSibling=ai.nextSibling;
			//torna o div de movimentacao igual ao objeto a ser movimentado
			var ak = f_div();
			ak.style.left  	 		= f_posicao_objeto(ai,true);
			ak.style.top	 		= f_posicao_objeto(ai,false);
			ak.style.height	 		= ai.offsetHeight;
			ak.style.width	 		= ai.offsetWidth;
			ak.style.display 		= "block";
			ak.style.opacity 		= 0.8;
			ak.style.filter	 		= "alpha(opacity=80)";
			ak.innerHTML	 		= ai.innerHTML;
			if (ai.className == '') {
				ak.className	 	= ai.parentNode.className;
			} else {
				ak.className	 	= ai.className;
			}
			ak.align 		 		= ai.align;
/*			ak.style.paddingTop   	= 3;
			ak.style.paddingLeft   	= 3;
			ak.style.paddingRight  	= 10;
			ak.style.paddingBottom 	= 3;
*/			ak.style.verticalAlign 	= ai.style.verticalAlign;
			ak.style.verticalAlign 	= 'middle';
			ak.style.display ='none';
			//marca o objeto como no movimentado ainda
			this.dragged	 = false;
		};
		a.onDrag=function(left,top){
			//calcula o objeto mais proximo dentro do limite minimo
			al.f_calcula_mais_proximo(this,left,top);
			f_div().style.display = 'block';
			//marca objeto como movido
			this.dragged=true;
		};
		a.onDragEnd=function(af,ag){
			//oculta a seta de indicao do objeto mais proximo
			f_seta().style.display = 'none';
			if(a.inserirAntes!=null) {
				//caso exista um objeto marcado para ser inserido antes executa
				//e reseta o parametro
				al.f_alterar_ordem(a);
				a.inserirAntes = null;
			}
			if(this.dragged){
				//caso o objeto tenha sido movimentado efetua o retorno animado
				ap = al.f_retorno_div(this,150,15);
			} else {
				al.f_sort_column(this.tblRef, this.cellIndex, (this.className != 'arrowDown'), this.getAttribute('type'));
				this.className = ((this.className == 'arrowDown')?'arrowUp':'arrowDown');
				if(this.tblRef.lastOrder != this && this.tblRef.lastOrder != null)
					this.tblRef.lastOrder.className = '';
				this.tblRef.lastOrder = this;
				//oculta o div de movimentacao
				f_div().style.display = 'none';
//				this.parentNode.onclick();
				if(this.href){
					if(this.target){
						window.open(this.href,this.target);
					} else {
						document.location=this.href;
					}
				}
			}
			this.target=null;
			this.href=null;
			if(this.nextSibling!=this.origNextSibling){
//				alert('aI()');
			}
		}
	};
	/**
	 * Inicio da movimentao do objeto
	 */
	this.start = function(a){
		//retorna o evento da janela
		a = al.fixE(a);
		if(a.button == 2)
			return false;
		var aa = al.obj = this;
		var ab = parseInt(f_div().style.top);
		var ac = parseInt(f_div().style.left);
		//aparentemente nao utilizada
		aa.onDragStart(ac,ab,a.clientX,a.clientY);
		//grava as ultimas posies on o objeto se encontrava
		aa.lastMouseX = a.clientX;
		aa.lastMouseY = a.clientY;
		//seta as funes de tratamento de movimentao e termino
		document.onmousemove = al.drag;
		document.onmouseup   = al.end;
		return false;
	};
	/**
	 * Calcula o movimento efetuado pelo mouse para a movmentacao do objeto
	 */
	this.drag = function(a){
		//retorna o evento da janela
		a = al.fixE(a);
		var aa = al.obj;
		var af,ag;
		af = parseInt(f_div().style.left) + a.clientX - aa.lastMouseX;
		ag = parseInt(f_div().style.top) + a.clientY - aa.lastMouseY;
		f_div().style.left = af + "px";
		f_div().style.top  = ag + "px";
		aa.lastMouseX = a.clientX;
		aa.lastMouseY = a.clientY;
		aa.onDrag(af,ag,a.clientX,a.clientY);
		return false;
	};
	/**
	 * Finaliza a movimentacao do objeto
	 */
	this.end = function(){
		//retira as funes de controle de movimentacao
		document.onmousemove = null;
		document.onmouseup   = null;
		//chama a finalizao da movimentacao
		al.obj.onDragEnd(parseInt(f_div().style.left),parseInt(f_div().style.top));
		al.obj=null;
	};
	/**
	 * Captura o evento da janela
	 */
	this.fixE = function(a){
		if(typeof a=="undefined")
			a=window.event;
		if(typeof a.layerX=="undefined")
			a.layerX=a.offsetX;
		if(typeof a.layerY=="undefined")
			a.layerY=a.offsetY;
		return a;
	};
	/** 
	 * Efetua o retorno do div de movimentacao para a posicao original 
	 */
	this.f_retorno_div = function (a,aa,ab){
		var ac=parseInt(f_div().style.left);
		var ad=parseInt(f_div().style.top);
		var ae=(ac-f_posicao_objeto(a,true))/ab;
		var af=(ad-f_posicao_objeto(a,false))/ab;
		return setInterval( function(){
			if(ab<1){
				clearInterval(ap);
				f_div().style.display = 'none';
				return
			}
			ab--;
			ac-=ae;
			ad-=af;
			f_div().style.left=parseInt(ac)+"px";
			f_div().style.top=parseInt(ad)+"px";
		},aa/ab)
	}	
	/**
	 * Calcula qual dos objetos encontra-se mais proximo do div de movimentacao 
	 */
	this.f_calcula_mais_proximo = function(obj,p_left,p_top){
		var ac=null;
		var ad=60;
		var objs = obj.tblRef.fieldTds;
		for(var i=0;i<objs.length;i++) {
			var ag=objs[i];
			if(ag==obj)
				continue;
			var ai=Math.sqrt(Math.pow(p_left-f_posicao_objeto(ag,true),2)+Math.pow(p_top-f_posicao_objeto(ag,false),2));
			if(isNaN(ai))
				continue;
			if(ai<ad){
				ad=ai;
				ac=ag
			}
		}
		if(ac!=null&&obj.nextSibling!=ac) {
			f_seta().style.top = f_posicao_objeto(ac,false)+ac.offsetHeight-4;
			f_seta().style.left = (f_posicao_objeto(ac,true)>0)?(f_posicao_objeto(ac,true)-8):-8;
			f_seta().style.display = '';
			obj.inserirAntes = ac;
		} else {
			f_seta().style.display = 'none';	
			obj.inserirAntes = null;
		}
	}
	/**
	 * Altera a ordem e posicao das colunas 
	 */
	this.f_alterar_ordem = function (obj, atual, antes) {
		var v_tbl = obj.tblRef;
		if(atual != null) {
//			for(var i=0;i<v_tbl.tBodies[0].rows.length;i++) {
//				v_tbl.tBodies[0].rows[i].cells[antes].parentNode.insertBefore(v_tbl.tBodies[0].rows[i].cells[atual], v_tbl.tBodies[0].rows[i].cells[antes]);
//			}
			v_obj = null;
			f_processando().style.display = 'none';
		} else {
			f_processando().style.display = '';
			f_processando().style.left = f_posicao_objeto(obj, true);
			f_processando().style.top = f_posicao_objeto(obj, false)+obj.offsetHeight;
			if(obj.tblRef.groupTr == obj.inserirAntes.parentNode) {
				//
				if(obj.oldClass != 'agrupamento') 
					obj.oldClass = obj.className;
				obj.className = 'agrupamento';
				this.f_posiciona_coluna(obj,obj.inserirAntes,true);
				obj.inserirAntes.parentNode.insertBefore(obj,obj.inserirAntes);
				this.f_agrupa(obj.tblRef);
			} else {
				var v_old_class = obj.className;
				if(obj.className == 'agrupamento') {
					obj.className = '';
				}
				this.f_posiciona_coluna(obj,obj.inserirAntes,false);
				obj.inserirAntes.parentNode.insertBefore(obj,obj.inserirAntes);
				v_obj = obj;
				if(v_old_class == 'agrupamento')
					this.f_agrupa(obj.tblRef);
			}
			v_obj = null;
			f_processando().style.display = 'none';
		}
	}
	
	this.f_agrupar_coluna = function(v_coluna) {
		var v_grupos = this.tbl.tHead.rows[0].cells[0].childNodes[0].tBodies[0].rows[0];
		v_coluna.inserirAntes = v_grupos.cells[v_grupos.cells.length-1];
		this.f_alterar_ordem(v_coluna,null,null);
	}
	
	/**
	 * Gera os agrupamentos 
	 */
	this.f_agrupa = function (p_tbl) {
		window.status = 'Desagrupando...';
		this.f_limpa_agrupamentos(p_tbl);
		this.f_sort_groups(p_tbl);
		window.status = 'Montando grupos...';
		//insere os agrupamentos na ordem que estao inseridos
		for(var i=0;i<p_tbl.groupTr.cells.length-1;i++) {
			window.status = 'Agrupando coluna "'+this.getInnerText(p_tbl.groupTr.cells[i])+'"';
			this.f_agrupa_coluna(p_tbl.groupTr.cells[i], i);
		}
		window.status = 'Agrupamento concludo...';
	}
	/**
	 * Limpa todos os agrupamentos de colunas da tabela
	 */
	this.f_limpa_agrupamentos = function (p_tbl) {
		for(var i=p_tbl.tBodies[0].rows.length-1;i>=0;i--) {
			if(p_tbl.tBodies[0].rows[i].agrupamento == 1) {
				p_tbl.tBodies[0].deleteRow(i);
			}
		}
	}
	/**
	 * Gera o agrupamento de uma coluna especifica
	 */
	this.f_agrupa_coluna = function (p_col, p_nivel) {
		//Inserir ordenao para o agrupamento
		var v_colspan = this.getTableCellLength(p_col.tblRef);
		var v_linhas = p_col.tblRef.tBodies[0].rows;
		var last_group = null;
		var v_count_tr_grupo = 0;
		var v_trs_grupo = [];
		var v_idx = this.f_get_indice(p_col);
		for(var i=0;i<=v_linhas.length;i++) {
			if((i == v_linhas.length) || 
			   (last_group != null && v_linhas[i].agrupamento != 1 && last_group != v_linhas[i].cells[v_idx].innerHTML) ||
			   (v_linhas[i].rodape == 1 && v_linhas[i].nivel != p_nivel)) {
				if(i != v_linhas.length || p_nivel == 0 ) {
					_tr = document.createElement("tr");
					_tr.agrupamento = 1;
					_tr.rodape = 1;
					_tr.nivel = p_nivel;
					if(i == v_linhas.length) 
						p_col.tblRef.tBodies[0].appendChild(_tr );
					else
						v_linhas[i].parentNode.insertBefore(_tr, v_linhas[i]);
					for(var j=0;j<v_colspan;j++) {
						_td = document.createElement("td");
						_td.style.height = '3px';
						_td.style.textAlign = 'right';
						_td.innerHTML = '';
						_td.className = 'titulo_5';
						_td.style.fontSize = '10px';
						_tr.appendChild(_td);
						for(var l=0;l<this.summaries.length;l++) {
							if(this.tbl.tHead.rows[1].cells[j] == this.summaries[l].header) {
								this.summaries[l].v_function(this.summaries[l].header.getAttribute('type'), v_count_tr_grupo,v_trs_grupo,j,_tr);
								break;
							}
						}
					}
					i++;
					v_count_tr_grupo = 0;
					v_trs_grupo = [];
				}
			}

			if(i < v_linhas.length) {
				v_count_tr_grupo++;
				v_trs_grupo.push(v_linhas[i]);
				if(v_linhas[i].agrupamento != 1 && v_linhas[i].cells.length != 1) {
					if(last_group != v_linhas[i].cells[v_idx].innerHTML) {
						last_group = v_linhas[i].cells[v_idx].innerHTML;
						_tr = document.createElement("tr");
						_td = document.createElement("td");
						_td.style.height = '10px'
						_tr.agrupamento = 1;
						_tr.nivel = p_nivel;
						_td.colSpan = v_colspan;
						var v_html = '';
						for(var k=0;k<p_nivel;k++) {
							v_html += '&nbsp;&nbsp;&nbsp;';
						}
						v_html += '<button class="botao-16x16" onclick=" al.f_hide_group(this.parentNode.parentNode, (this.childNodes[0].src.indexOf(\'ocultar\') != -1), this.childNodes[0])"><img src="/_imagens/botoes/16x16/ocultar.gif" width="16" height="16" align="absmiddle" /></button>'+((document.all)?p_col.innerText:p_col.textContent)+': '+v_linhas[i].cells[v_idx].innerHTML;
						_td.innerHTML = v_html;
						_td.className = 'titulo_3';
						_tr.appendChild(_td);
						v_linhas[i].parentNode.insertBefore(_tr, v_linhas[i]);
						i++;
					}
				} else {
					last_group = null;
					v_count_tr_grupo = 0;
					v_trs_grupo = [];
				}
			}
		}
	}
	/**
	 * Oculta as linha de um grupo
	 */
	this.f_hide_group = function (p_row, p_hide, p_btn) {
		if(p_btn != null) {
			p_btn.src = '/_imagens/botoes/16x16/'+((p_hide)?'mostrar':'ocultar')+'.gif';
		}
		var v_count = 0;
		var v_do = false;
		var show_nivel = -1;
		for(var i=0;i<p_row.parentNode.rows.length;i++) {
			if(v_do) {
				v_count++;
				if(v_count == 1 && p_row.parentNode.rows[i].agrupamento == 1) {
					show_nivel = p_row.parentNode.rows[i].nivel;
				}
				if(p_row.parentNode.rows[i].agrupamento == 1 && p_row.parentNode.rows[i].nivel == p_row.nivel) {
					break;
				}
				if(show_nivel == -1 && p_row.parentNode.rows[i].agrupamento != 1) {
					p_row.parentNode.rows[i].style.display = (p_hide)?'none':'';
				} else if ((p_row.parentNode.rows[i].agrupamento == 1 && p_row.parentNode.rows[i].nivel == show_nivel) || p_hide) {
					p_row.parentNode.rows[i].style.display = (p_hide)?'none':'';
					if(p_row.parentNode.rows[i].agrupamento == 1) {
						try {
							p_row.parentNode.rows[i].cells[0].childNodes[1].childNodes[0].src = '/_imagens/botoes/16x16/mostrar.gif';
						} catch(e) {
							//nenhum efeito conhecido
						}
					}
				}
			} else {
				if(p_row.parentNode.rows[i] == p_row) {
					v_do = true;
				}
			}
		}
		return v_count;
	}
	/**
	 * Altera a posicao das colunas para ocultar ou reposicionar abaixo de seu header
	 * p_col = coluna a ser movida
	 * p_colAntes = coluna seguinte a qual a coluna deve ser inserida
	 */			
	this.f_posiciona_coluna = function (p_col, p_colAntes, p_ocultar) {
		var v_linhas = p_col.tblRef.tBodies[0].rows;
		//captura os indices reais das colunas
		var v_idx = this.f_get_indice(p_col);
		if(p_ocultar) {
			for(var i=0;i<v_linhas.length;i++) {
				if(v_linhas[i].rodape == 1 || v_linhas[i].agrupamento != 1) {
					v_linhas[i].cells[v_idx].style.display = 'none';
					v_linhas[i].cells[v_idx].indexCol = p_col.indexCol;
					v_linhas[i].insertBefore(v_linhas[i].cells[v_idx],null);
				}
			}
		} else {
			var v_idxAntes = this.f_get_indice(p_colAntes);
			for(var i=0;i<v_linhas.length;i++) {
				if(v_linhas[i].rodape == 1 || v_linhas[i].agrupamento != 1 ) {
					if(v_linhas[i].cells[v_idx]) {
						v_linhas[i].cells[v_idx].style.display = '';
						v_linhas[i].cells[v_idx].indexCol = p_col.indexCol;
						v_linhas[i].insertBefore(v_linhas[i].cells[v_idx], v_linhas[i].cells[v_idxAntes]);
					}
				}
			}
		}
	}
	/**
	 * Busca o indice real da coluna a ser movimentada
	 */
	this.f_get_indice = function (p_col) {
		if(p_col.tblRef.headerTr == p_col.parentNode) {
			var v_colunas = p_col.tblRef.headerTr.cells;
		} else {
			for (var i=0;i<p_col.tblRef.tBodies[0].rows.length;i++) {
				if (p_col.tblRef.tBodies[0].rows[i].agrupamento != 1) {
					var v_colunas = p_col.tblRef.tBodies[0].rows[i].cells;
					break;
				}
			}
		}
		for(var i=0;i<v_colunas.length;i++) {
			if(v_colunas[i].indexCol == p_col.indexCol) {
				return i;
			}
		}
		return -1;
	}		
	/**
	 * Busca o texto interno de uma coluna da tabela
	 */
	this.getInnerText = function (p_col) {
/*
	var dom = (document.getElementsByTagName) ? true : false;
	var ie5 = (document.getElementsByTagName && document.all) ? true : false;
*/	
		if (document.getElementsByTagName && document.all) {
			if(p_col.innerText.toLowerCase().replace(/ /g,'') == '&nbsp;')
				return '';
			else
				return p_col.innerText;
		} else {
			if(p_col.textContent.toLowerCase().replace(/ /g,'') == '&nbsp;')
				return '';
			else
				return p_col.textContent;
		}
		var str = "";
		var cs = p_col.childNodes;
		var l = cs.length;
		for (var i = 0; i < l; i++) {
			switch (cs[i].nodeType) {
				case 1: //ELEMENT_NODE
					str += getInnerText(cs[i]);
					break;
				case 3:	//TEXT_NODE
					str += cs[i].nodeValue;
					break;
			}
		}
		return str;
	}
	/**
	 * Converte uma string para numerico tratando caracteres desconsiderados
	 */
	this.toNumber = function (s){
		s = s.replace('R$', '');
		if (s.indexOf(',') != -1 && s.indexOf('.') != -1) {
			s = s.replace('.', '');
		}
		s = s.replace(',','.');
		if(s.replace(/ /g,'').replace(/[^:0-9,-\.]/g, "") == '-')
			s = String(-99999998);
		if(s.replace(/ /g,'').replace(/[^:0-9,-\.]/g, "") == '')
			s = String(-99999999);
		if (s.indexOf(':') == -1) 
			return Number(s.replace(/[^:0-9,-\.]/g, ""));
		else 
			return Number(parseInt(s.slice(0,s.indexOf(':'))) + parseInt(s.substr(s.indexOf(':')))) ;	
	}	
	/**
	 * Ajusta o valor de KM para a ordenao
	 */
	this.KM = function(s) {
		valor = s.split('(M)');
		valor[0] = valor[0].replace('.','');
		if (isNaN(Number(valor[0]))) {
			valor[0] = -30000;
		}
		return Number(valor[0]);
	}	
	/**
	 * Ajusta uma data para a ordenacao
	 */
	this.parseDate = function (s) { 
		if(s == "")
			return Number.MIN_VALUE;
		
		var v_date = String(s).getDateTime();
		if(s == "" || v_date == null) {
			return Number.MIN_VALUE;
		} else {
			if(isNaN(Number(v_date))) {
				return Number.MIN_VALUE;
			} else {
			    return Number(v_date);
			}
		}
	}

	this.parseDateNullsLast = function (s) { 
		if(s == "")
			return Number.MAX_VALUE;
		
		var v_date = String(s).getDateTime();
		if(s == "" || v_date == null) {
			return Number.MAX_VALUE;
		} else {
			if(isNaN(Number(v_date))) {
				return Number.MAX_VALUE;
			} else {
			    return Number(v_date);
			}
		}
	}

	/**
	 * Ajusta uma hora para ordenacao
	 */	
	this.Hora = function (s) {	
		v_dias = 0;
		v_horas = 0;
		if (s.indexOf('/') != -1) {
		   v_dias = s.substr(0,2)*86400;
		   v_horas = s.substr(s.indexOf('/')+1,2)*3600
		}
		else {
		   v_dias = 0;
		   v_horas = s.substr(0,s.indexOf(':'))*3600	
		}
		if (s.length < 3) 
		   valor = -1;
		else   
		   valor =  v_dias + v_horas + s.substr(s.indexOf(':')+2)*60;
		return Number(valor);
	}
	
	this.Tempo = function (s) {	
		s = s.replace(' Hs ',':').replace(' Min','');
		parts = s.split(':');
		v_dias = 0;
		v_horas = Number(parts[0])*3600	
		v_minutos = Number(parts[1])*60;
		return Number(v_horas+v_minutos);
	}
	

	/** 
	 * Ajusta uma String para a ordenacao
	 */
	this.CaseInsensitiveString = function(s) {
		return String(s).toUpperCase();
	}
	/** 
	 * Ajusta uma String para a ordenacao
	 */
	this.imagem = function(s) {
		return String(s).toUpperCase();
	}
	/**
	 * Determina que uma coluna no sera ordenada
	 */
	this.nao_ordenar = function (s) {
		return 1;
	}
	/**
	 * Retorna os valores para a ordenao das colunas
	 */
	this.f_sort_function = function (nCol, bDescending, sType) {
		var c = nCol;
		var d = bDescending;
		var fTypeCast = String;
		sType = sType.toUpperCase();
		if (sType == "NUMBER")
			fTypeCast = this.toNumber;
		else if (sType == "KM")
			fTypeCast = this.KM;
		else if (sType == "DATE")
			fTypeCast = this.parseDate;
		else if (sType == "DATE NULLS LAST")
			fTypeCast = this.parseDateNullsLast;
		else if (sType == "CASEINSENSITIVESTRING")
			fTypeCast = this.CaseInsensitiveString;
		else if (sType == "HORA") 
			fTypeCast = this.Hora;
		else if (sType == "TEMPO") 
			fTypeCast = this.Tempo;
		else if (sType == "IMAGEM") 
			fTypeCast = this.imagem;
		else if (sType == "NAO_ORDENAR") 
			fTypeCast = this.nao_ordenar;
		else 
			fTypeCast = this.nao_ordenar;
		getInner = this.getInnerText;
		return function (n1, n2) {
			if(n1.agrupamento == 1) 
				return null;
			if(n2.agrupamento == 1) 
				return null;
			if (fTypeCast(getInner(n1.cells[c])) < fTypeCast(getInner(n2.cells[c])))
				return d ? -1 : +1;
			if (fTypeCast(getInner(n1.cells[c])) > fTypeCast(getInner(n2.cells[c])))
				return d ? +1 : -1;
			return 0;
		};
	}	
	/**
	 * Retorna os valores para a ordenao das colunas com uma lista de colunas
	 * Obs: Desmontar agrupamentos antes de utilizar
	 */
	this.f_sort_function_mult = function (nCol, bDescending, sType) {
		var c = nCol;
		var d = bDescending;
		var e = sType;
		var fTypeCast = String;
		toNumber = this.toNumber;
		KM = this.KM;
		parseDate = this.parseDate;
		CaseInsensitiveString = this.CaseInsensitiveString;
		Hora = this.Hora;
		nao_ordenar = this.nao_ordenar;
		getInner = this.getInnerText;
		return function (n1, n2) {
			if(n1.agrupamento == 1 || n2.agrupamento == 1) 
				return 0;
			for(var i=0;i<c.length;i++) {
				sType[i] = String(sType[i]).toUpperCase();
				if (sType[i] == "NUMBER")	
					fTypeCast = this.toNumber;
				else if (sType[i] == "KM")
					fTypeCast = this.KM;
				else if (sType[i] == "DATE")
					fTypeCast = this.parseDate;
				else if (sType[i] == "CASEINSENSITIVESTRING")
					fTypeCast = this.CaseInsensitiveString;
				else if (sType[i] == "HORA") 
					fTypeCast = this.Hora;
				else if (sType[i] == "TEMPO") 
					fTypeCast = this.Tempo;
				else if (sType[i] == "NAO_ORDENAR") 
					fTypeCast = this.nao_ordenar;
				else 
					fTypeCast = this.nao_ordenar;
				if (fTypeCast(getInner(n1.cells[c[i]])) < fTypeCast(getInner(n2.cells[c[i]])))
					return d[i] ? -1 : +1;
				if (fTypeCast(getInner(n1.cells[c[i]])) > fTypeCast(getInner(n2.cells[c[i]])))
					return d[i] ? +1 : -1;
			}
			return 0;
		};
	}	
	/**
	 * Efetua a ordenao dos grupos
	 */
	this.f_sort_groups = function (p_tbl) {
		var groupIndexes = new Array();
		var groupTypes = new Array();
		var groupDescs = new Array();
		var v_rows = new Array();
		window.status = "Limpando agrupamentos...";
		this.f_limpa_agrupamentos(p_tbl);
		for(var i=0;i<p_tbl.groupTr.cells.length-1;i++) {
			groupIndexes[groupIndexes.length] = this.f_get_indice(p_tbl.groupTr.cells[i]);
			groupTypes[groupTypes.length] = p_tbl.groupTr.cells[i].getAttribute('type');
			groupDescs[groupDescs.length] = true;
		}
		var tBody = p_tbl.tBodies[0];
		window.status = "Classificando grupos...";
		var start = new Date;
		for (var i = 0; i < tBody.rows.length; i++) {
			if(tBody.rows[i].agrupamento != 1) {
				v_rows[v_rows.length] = tBody.rows[i];
			}
		}
		v_rows.sort(this.f_sort_function_mult(groupIndexes,groupDescs,groupTypes));
		
		window.status = "Classificao de dados concluida";
		for (var i = 0; i < v_rows.length; i++) {
			tBody.appendChild(v_rows[i]);
			window.status = "Atualizando linha  " + (i + 1) + " de " + tBody.rows.length +
							" (Tempo Estimado: " + (new Date - start) + "ms)";
		}
	}
	/**
	 * Ordena os dados de determinada coluna
	 */
	this.f_sort_column = function (tableNode, nCol, bDesc, sType) {
		var tBody = tableNode.tBodies[0];
		var trs = tBody.rows;
		var trl= trs.length;
		var a = new Array();
		var final = new Array();

		window.status = "Classificando...";
		var start = new Date;
		for (var i = 0; i < trl; i++) {
			if(trs[i].agrupamento == 1) {
				if(a.length > 0) {
					a.sort(this.f_sort_function(nCol,bDesc,sType));
					for(var j=0;j<a.length;j++) {
						final[final.length] = a[j];
					}
				}
				a = null;
				a = new Array();
				final[final.length] = trs[i];
			} else {
				a[a.length] = trs[i];
			}
		}
		a.sort(this.f_sort_function(nCol,bDesc,sType));
		for(var j=0;j<a.length;j++) {
			final[final.length] = a[j];
		}
		window.status = "Classificao de dados concluida";
		
		for (var i = 0; i < final.length; i++) {
			if(final[i])
				tBody.appendChild(final[i]);
			window.status = "Atualizando linha  " + (i + 1) + " de " + trl +
							" (Tempo Estimado: " + (new Date - start) + "ms)";
		}
		
		// check for onsort
		if (typeof tableNode.onsort == "string")
			tableNode.onsort = new Function("", tableNode.onsort);
		if (typeof tableNode.onsort == "function")
			tableNode.onsort();
	}	
	
	this.agruparColuna = function(index) {
		this.tbl.tHead.rows[1].cells[index].inserirAntes = this.tbl.groupTr.cells[this.tbl.groupTr.cells.length-1];
		this.f_alterar_ordem(this.tbl.tHead.rows[1].cells[index]);
	}
	
	this.addSummary = function(colHeader, v_function) {
		this.summaries.push({
					header: colHeader,
					v_function: v_function
				});
	}
}
/**
 * Instancia o objeto de controle de movimentacao 
 */
var al = new objControleDrag();
var ap = 0;
/**
 * Retorna a posicao atual do objeto 
 */
function f_posicao_objeto(p_obj,p_left){
	var total=0;
	while(p_obj!=null){
		total+=p_obj["offset"+(p_left?"Left":"Top")];
		p_obj=p_obj.offsetParent;
	}
	return total;
}

		

/** 
 * Inicializa uma table com tHead e TBody para o script 
 */
function initDragTable(v_id) {
	al = new objControleDrag();
	al.initTable(document.getElementById(v_id));
}

/** 
 * Retorna o scroll efetuado na tela 
 */
function getScrollY() {
	if( typeof( window.pageYOffset ) == 'number' ) {
		scrOfY = window.pageYOffset;
		scrOfX = window.pageXOffset;
	} else if( document.body && ( document.body.scrollLeft || document.body.scrollTop ) ) {
		scrOfY = document.body.scrollTop;
		scrOfX = document.body.scrollLeft;
	} else if( document.documentElement && ( document.documentElement.scrollLeft || document.documentElement.scrollTop || document.documentElement.scrollTop == 0) ) {
		scrOfY = document.documentElement.scrollTop;
		scrOfX = document.documentElement.scrollLeft;
	}
}

function f_sum_grid_summary(type,count,trs,index,tr) {
	switch(String(type).toLowerCase().trim()) {
		case 'tempo':
			v_tempo = 0;
			for(var i=0;i<trs.length;i++) {
				v_tempo_cell = String(getInnerText(trs[i].cells[index])).replace(' Hs ',':').replace(' Min','');
				v_parts = v_tempo_cell.split(':');
				v_tempo += Number(v_parts[0])*60 + Number(v_parts[1]);
			}
			v_minutos = v_tempo%60;
			v_horas = (v_tempo-v_minutos)/60;
			tr.cells[index].innerHTML = v_horas+' Hs '+v_minutos+' Min';
			tr.cells[index].style.border = '1px solid #000000';
			break;
		case 'number':
			if(trs.length == 0) {
				// Adaptado para no aparecer o rodape sem grupo. Verificar porque o rodape esta sendo criado.
				tr.style.display = 'none';
				return;
			}
			v_soma = 0;
			for(var i=0;i<trs.length;i++) {
				v_soma += Number(String(getInnerText(trs[i].cells[index])).replace('.','').replace(',','.'));
			}
			tr.cells[index].innerHTML = Math.round(v_soma);
			tr.cells[index].style.border = '1px solid #000000';
			break;
		case 'number_format_2':
			if(trs.length == 0) {
				// Adaptado para no aparecer o rodape sem grupo. Verificar porque o rodape esta sendo criado.
				tr.style.display = 'none';
				return;
			}
			v_soma = 0;
			for(var i=0;i<trs.length;i++) {
				v_soma += Number(String(getInnerText(trs[i].cells[index])).replace(',','.'));
			}
			
			tr.cells[index].innerHTML = number_format(v_soma,2,',','.');
			tr.cells[index].style.border = '1px solid #000000';
			break;
	}
}

function f_max_grid_summary(type,count,trs,index,tr) {
	switch(String(type).toLowerCase().trim()) {
		case 'tempo':
			v_tempo = 0;
			for(var i=0;i<trs.length;i++) {
				v_tempo_cell = String(getInnerText(trs[i].cells[index])).replace(' Hs ',':').replace(' Min','');
				v_parts = v_tempo_cell.split(':');
				if(v_tempo < Number(v_parts[0])*60 + Number(v_parts[1]))
					v_tempo = Number(v_parts[0])*60 + Number(v_parts[1]);
			}
			v_minutos = v_tempo%60;
			v_horas = (v_tempo-v_minutos)/60;
			tr.cells[index].innerHTML = v_horas+' Hs '+v_minutos+' Min';
			tr.cells[index].style.border = '1px solid #000000';
			break;
	}
}

function f_min_grid_summary(type,count,trs,index,tr) {
	switch(String(type).toLowerCase().trim()) {
		case 'tempo':
			v_tempo = 0;
			for(var i=0;i<trs.length;i++) {
				v_tempo_cell = String(getInnerText(trs[i].cells[index])).replace(' Hs ',':').replace(' Min','');
				v_parts = v_tempo_cell.split(':');
				if(v_tempo < Number(v_parts[0])*60 + Number(v_parts[1]))
					v_tempo = Number(v_parts[0])*60 + Number(v_parts[1]);
			}
			v_minutos = v_tempo%60;
			v_horas = (v_tempo-v_minutos)/60;
			tr.cells[index].innerHTML = v_horas+' Hs '+v_minutos+' Min';
			tr.cells[index].style.border = '1px solid #000000';
			break;
	}
}

function f_count_grid_summary(type,count,trs,index,tr) {
	tr.cells[index].innerHTML = count;
	tr.cells[index].style.border = '1px solid #000000';
}

function f_avg_grid_summary(type,count,trs,index,tr) {
	switch(String(type).toLowerCase().trim()) {
		case 'tempo':
			v_tempo = 0;
			for(var i=0;i<trs.length;i++) {
				v_tempo_cell = String(getInnerText(trs[i].cells[index])).replace(' Hs ',':').replace(' Min','');
				v_parts = v_tempo_cell.split(':');
				if(v_tempo < Number(v_parts[0])*60 + Number(v_parts[1]))
					v_tempo = Number(v_parts[0])*60 + Number(v_parts[1]);
			}
			v_tempo = v_tempo/count;
			v_minutos = v_tempo%60;
			v_horas = (v_tempo-v_minutos)/60;
			tr.cells[index].innerHTML = v_horas+' Hs '+lpad(Math.floor(v_minutos),2,'0')+' Min';
			tr.cells[index].style.border = '1px solid #000000';
			break;
	}
}

try{

	v_temp = document.createElement("div");
	v_temp.innerHTML = '<img src="/_imagens/botoes/16x16/ocultar.gif" width="16" height="16" align="absmiddle" />';
	v_temp.style.display = '';
	v_temp.style.position = 'absolute';
	v_temp.style.top = -1000;
	document.body.appendChild(v_temp);

}catch(e){}

function number_format( number, decimals, dec_point, thousands_sep ) { 
    var n = number, prec = decimals;
    n = !isFinite(+n) ? 0 : +n;
    prec = !isFinite(+prec) ? 0 : Math.abs(prec);
    var sep = (typeof thousands_sep == "undefined") ? ',' : thousands_sep;
    var dec = (typeof dec_point == "undefined") ? '.' : dec_point;
 
    var s = (prec > 0) ? n.toFixed(prec) : Math.round(n).toFixed(prec); //fix for IE parseFloat(0.55).toFixed(0) = 0;
 
    var abs = Math.abs(n).toFixed(prec);
    var _, i;
 
    if (abs >= 1000) {
        _ = abs.split(/\D/);
        i = _[0].length % 3 || 3;
 
        _[0] = s.slice(0,i + (n < 0)) +
              _[0].slice(i).replace(/(\d{3})/g, sep+'$1');
 
        s = _.join(dec);
    } else {
        s = s.replace('.', dec);
    }
 
    return s;
}