// OBJETOS KM&M
var a_objetos = new Array();
var a_linhas  = new Array();

// Cria o objeto para Drag
var moveObj = new DragObj({ 	
	type: 'preview',
	moveOpacity: 60,
	minDistance: 1000,
	onDragStart: function (obj) { },
	onDrag: function (obj) { },
	onDragEnd: function (obj) {
		obj.objeto.x = Number(obj.style.left.replace('px',''));
		obj.objeto.y = Number(obj.style.top.replace('px','')); 
		for (i=0;i<a_linhas.length;i++) {
			if ( (a_linhas[i].obj1 == obj.objeto) || (a_linhas[i].obj2 == obj.objeto) ) {
				a_linhas[i].recria();
			}
		}		
	},
	onEndOverObj: function(obj1, obj2) {
		a_linhas.push(new conexao(canvas, a_objetos[obj1.objeto.objeto_id], a_objetos[obj2.objeto.objeto_id]));
		f_grava_conexao(v_diagrama_id, obj1.objeto, obj2.objeto)
		moveObj.config.type = 'preview';
		document.getElementById('tr_mensagem').innerText = 'Modo cria'+String.fromCharCode(231)+String.fromCharCode(227)+'o/edi'+String.fromCharCode(231)+String.fromCharCode(227)+'o'; 
	}
});	
// Cria o objeto para Drag
var connObj = new DragObj({ 	
	type: 'preview',
	moveOpacity: 60,
	minDistance: 1000,
	onDragStart: function (obj) { },
	onDrag: function (obj) { },
	onDragEnd: function (obj) {	}
});	

function f_grava_conexao(p_diagrama_id, p_obj1, p_obj2) {
	// Atualiza objeto no banco de dados
	p_url = '/_transportes/manipulacao/cfc_diagrama.cfc?method=ins_objeto_vinculo';
	p_arguments = 'DIAGRAMA_ID=' +p_diagrama_id +
	              '&OBJETO_ID_1=' +p_obj1.objeto_id +
				  '&OBJETO_ID_2=' +p_obj2.objeto_id;
	f_query_wddx(p_url, p_arguments, f_result);	
}

function f_grava_objeto(p_objeto) {
	// Atualiza objeto no banco de dados
	p_url = '/_transportes/manipulacao/cfc_diagrama.cfc?method=alt_objeto';
	p_arguments = 'OBJETO_ID='    +p_objeto.obj.objeto_id+
				  '&DIAGRAMA_ID=' +p_objeto.obj.diagrama_id+
				  '&X=' 		  +p_objeto.obj.x+
				  '&Y=' 		  +p_objeto.obj.y+
				  '&FORMA_ID='    +p_objeto.obj.forma_id+
				  '&LARGURA='     +p_objeto.obj.largura+
				  '&ALTURA='      +p_objeto.obj.altura;
	f_query_wddx(p_url, p_arguments, f_result);	
}

function f_result(retorno) {
	if (retorno.struct)
	  if (retorno.struct.erro == 'true') {
		if (retorno.struct.mensagem.detail)
		    alert(retorno.struct.mensagem.detail);
		else if (retorno.struct.mensagem)
		    alert(retorno.struct.mensagem);
	}
}

function ajusta_conexao(p_obj) {
	for (i=0;i<a_linhas.length;i++) {
		if ( (a_linhas[i].obj1 == p_obj.obj) || (a_linhas[i].obj2 == p_obj.obj) ) {
			a_linhas[i].recria();
		}
	}	
}
			
// Objeto de conexoes
function conexao(p_canvas, p_obj1, p_obj2) {
	this.obj1 = p_obj1.obj;
	this.obj2 = p_obj2.obj;	

	this.cria = function() {
		// Ajusta coordenadas
		this.x1 = this.obj1.x + this.obj1.largura/2;
		this.y1 = this.obj1.y + this.obj1.altura/2;
		this.x2 = this.obj2.x + this.obj2.largura/2;
		this.y2 = this.obj2.y + this.obj2.altura/2;
			
		this.v_linha = document.createElement("div");
		this.v_linha.id = 'conn'+ this.obj1.objeto_id + this.obj2.objeto_id;
		connObj.addObj(this.v_linha);
		document.body.appendChild(this.v_linha);			
		with(this.v_linha.style) {
			position = 'absolute';
			top = 0;
			left = 0;
			width = 0;
			left = 0;
		}
		
		if(Math.abs(this.x1 - this.x2) < Math.abs(this.y1 - this.y2)) {
			for(y = Math.min(this.y1, this.y2) - 1, x = Math.max(this.y1, this.y2); ++y <= x;
				p_canvas.pixel((y * (this.x1 - this.x2) - this.x1 * this.y2 + this.y1 * this.x2) / (this.y1 - this.y2), y,null,this.v_linha) );
		}
		else {
			for(x = Math.min(this.x1, this.x2) - 1, y = Math.max(this.x1, this.x2); ++x <= y;
				p_canvas.pixel(x, (x * (this.y1 - this.y2) - this.y1 * this.x2 + this.x1 * this.y2) / (this.x1 - this.x2),null,this.v_linha ) );
		}	
	}	
	
	this.destroi = function() {
		// Remove a conexao
		this.v_linha.removeNode(true);	
	}
	this.recria = function() {
		
		this.destroi();
		this.cria();
	}
	
	this.toString = function() {
		return this.obj1.objeto_id + ' -> ' + this.obj2.objeto_id + '\n';
	}
	
	this.cria();
}

/* Object OBJ
   canvas : object canvas
   tipo   : 'retangulo'
   p_objeto_id : identificador do objeto (BD)
   p_x : coordenada X
   p_y : coordenada Y
   p_altura : altura em pixel do objeto
   p_largura : largura em pixel
   p_conteudo : conteudo HTML do objeto
*/   
  
function objeto(config) {
	this.obj = config;	
	this.cria = function() {
		switch ( this.obj.tipo ) {
		   case 'retangulo' :
				// Desenha o retangulo
				v_div = document.createElement("div");
				v_div.id        = this.obj.objeto_id;
				v_div.className = this.obj.tipo;
				with(v_div.style) {
					 width  = this.obj.largura;
					 height = this.obj.altura;		
					 top    = this.obj.y;
					 left   = this.obj.x;
				}
				v_div.innerHTML = this.obj.conteudo;
				v_div.objeto = this.obj;
				document.body.appendChild(v_div);			
				// Inicializa Drag do objeto
				moveObj.addObj(v_div);	
				// Retorna o objeto 
				this.div = v_div;
		   default: 
				return false; 	
		}
	}
	
	this.destroi = function() {
		// Remove a conexao
		this.div.removeNode(true);	
	}
	
	this.recria = function() {
		this.destroi();
		this.cria();
	}

	this.setAltura = function(p_altura) {
		this.div.height = p_altura;	
		this.obj.altura = p_altura;	
	}
	this.setLargura = function(p_largura) {
		this.div.width = p_largura;	
		this.obj.largura = p_largura;	
	}
	
	this.setConteudoHTML = function(p_conteudo) {
		this.div.innerHTML = p_conteudo;	
	}
	this.setConteudo = function(p_obj) {
		this.div.innerHTML = '';
		this.div.appendChild(p_obj);
	}
	this.toString = function() {
		return this.obj.objeto_id + '\n';
	}
	this.cria();
}

var a_pontos = new Array();
Canvas = function(){ //v1.0
	var o = this;
	(o.penPos = {x: 0, y: 0}, 
	 o.pixelSize = 1, 
	 o.pen = {style: "solid", size: 1, color: "#000"}, 
	 o.brush = {style: "solid", color: "#000"}
	);
};

with({p: Canvas.prototype}){
	p.pixel = function(x, y, color, linha) {
		var o = this, 
		pix = document.createElement("div"); 
		s = linha.appendChild(pix).style;
		return (s.position = "absolute", 
				s.width = (o.pen.size * o.pixelSize) + "px",
			    s.height = (o.pen.size * o.pixelSize) + "px", 
				s.fontSize = "1px",
			    s.left = (x * o.pixelSize) + "px", 
				s.top = (y * o.pixelSize) + "px",
			    s.backgroundColor = color || o.pen.color, o);
	};
	
	p.line = function(x1, y1, x2, y2){
		v_painel = document.createElement("div");
		document.body.appendChild(v_painel);
		a_pontos.push(v_painel);
		with(v_painel.style) {
			position = 'absolute';
			top = 0;
			left = 0;
			width = 0;
			left = 0;
		}	
		if(Math.abs(x1 - x2) < Math.abs(y1 - y2))
			for(y = Math.min(y1, y2) - 1, x = Math.max(y1, y2); ++y <= x;
				this.pixel((y * (x1 - x2) - x1 * y2 + y1 * x2) / (y1 - y2), y,null,v_painel) );
		else
			for(x = Math.min(x1, x2) - 1, y = Math.max(x1, x2); ++x <= y;
				this.pixel(x, (x * (y1 - y2) - y1 * x2 + x1 * y2) / (x1 - x2) ),null,v_painel );
		return this;
	};
	
	p.arc = function(x, y, raio, startAngle, degrees) {
		for(degrees += startAngle; degrees --> startAngle;
			this.pixel(Math.cos(degrees * Math.PI / 180) * raio + x,
				Math.sin(degrees * Math.PI / 180) * raio + y)); return this;
	};
	p.rectangle = function(x, y, width, height, rotation){
		return this.moveTo(x, y).lineBy(0, height).lineBy(width, 0).lineBy(0, -height).lineBy(-width, 0);
	};
	
	p.moveTo = function(x, y){var o = this; return (o.penPos.x = x, o.penPos.y = y, o);};
	p.moveBy = function(x, y){var o = this; return o.moveTo(o.penPos.x + x, o.penPos.y + y);};
	p.lineTo = function(x, y){var o = this; return o.line(o.penPos.x, o.penPos.y, x, y).moveTo(x, y);};
	p.lineBy = function(x, y){var o = this; return o.lineTo(o.penPos.x + x, o.penPos.y + y);};
}
