<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The (x, y) data for the first line
dataX0 = Array(20, 90, 40, 30, 12);
dataY0 = Array(10, 40, 75, 54, 20);

// The (x, y) data for the second line
dataX1 = Array(10, 40, 75, 54, 60);
dataY1 = Array(50, 90, 40, 30, 10);

// Create a XYChart object of size 450 x 450 pixels
c = cd.XYChart(450, 450);

// Set the plotarea at (55, 65) and of size 350 x 300 pixels, with white background
// and a light grey border (0xc0c0c0). Turn on both horizontal and vertical grid
// lines with light grey color (0xc0c0c0)
c.setPlotArea(55, 65, 350, 300, "0xffffff", -1, "0xc0c0c0", "0xc0c0c0", -1);

// Add a legend box at (50, 30) (top of the chart) with horizontal layout. Use 12 pts
// Times Bold Italic font. Set the background and border color to Transparent.
c.addLegend(50, 30, False, "Times New Roman Bold Italic", 12).setBackground(
    cd.Transparent);

// Add a title to the chart using 18 pts Times Bold Itatic font
c.addTitle("Reaction Path", "Times New Roman Bold Italic", 18);

// Add a title to the y axis using 12 pts Arial Bold Italic font
c.yAxis().setTitle("Temperature (Celcius)", "Arial Bold Italic", 12);

// Set the y axis line width to 3 pixels
c.yAxis().setWidth(3);

// Add a title to the x axis using 12 pts Arial Bold Italic font
c.xAxis().setTitle("Pressure (Pa)", "Arial Bold Italic", 12);

// Set the x axis line width to 3 pixels
c.xAxis().setWidth(3);

// Add a red (0xff3333) line layer using dataX0 and dataY0
layer1 = c.addLineLayer(dataY0, "0xff3333", "Compound AAA");
layer1.setXData(dataX0);

// Set the line width to 3 pixels
layer1.setLineWidth(3);

// Use 9 pixel square symbols for the data points
layer1.getDataSet(0).setDataSymbol(cd.SquareSymbol, 9);

// Add custom text labels to the first and last point on the scatter plot using Arial
// Bold font
layer1.addCustomDataLabel(0, 0, "Start", "Arial Bold");
layer1.addCustomDataLabel(0, 4, "End", "Arial Bold");

// Add a green (0x33ff33) line layer using dataX1 and dataY1
layer2 = c.addLineLayer(dataY1, "0x33ff33", "Compound BBB");
layer2.setXData(dataX1);

// Set the line width to 3 pixels
layer2.setLineWidth(3);

// Use 11 pixel diamond symbols for the data points
layer2.getDataSet(0).setDataSymbol(cd.DiamondSymbol, 11);

// Add custom text labels to the first and last point on the scatter plot using Arial
// Bold font
layer2.addCustomDataLabel(0, 0, "Start", "Arial Bold");
layer2.addCustomDataLabel(0, 4, "End", "Arial Bold");

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='[{dataSetName}] Pressure = {x} Pa, Temperature = {value} C'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Arbitrary XY Line Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
