<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Function to create the demo charts
function createChart(img)
{
    // Declare local variables
    var value = 0;
    var m = 0;

    // The value to display on the meter
    value = 6.5;

    // Create an AugularMeter object of size 200 x 100 pixels with rounded corners
    m = cd.AngularMeter(200, 100);

    // Set search path to current directory for loading icon images
    m.setSearchPath(GetPageContext());
    m.setRoundedFrame();

    // Set meter background according to a parameter
    if (img EQ "0") {
        // Use gold background color
        m.setBackground(cd.goldColor(), "0x000000", -2);
    } else if (img EQ "1") {
        // Use silver background color
        m.setBackground(cd.silverColor(), "0x000000", -2);
    } else if (img EQ "2") {
        // Use metallic blue (9898E0) background color
        m.setBackground(cd.metalColor("0x9898e0"), "0x000000", -2);
    } else if (img EQ "3") {
        // Use a wood pattern as background color
        m.setBackground(m.patternColor2("wood.png"), "0x000000", -2);
    } else if (img EQ "4") {
        // Use a marble pattern as background color
        m.setBackground(m.patternColor2("marble.png"), "0x000000", -2);
    } else {
        // Use a solid light purple (EEBBEE) background color
        m.setBackground("0xeebbee", "0x000000", -2);
    }

    // Set the meter center at (100, 235), with radius 210 pixels, and span from -24
    // to +24 degress
    m.setMeter(100, 235, 210, -24, 24);

    // Meter scale is 0 - 100, with a tick every 1 unit
    m.setScale(0, 10, 1);

    // Set 0 - 6 as green (99ff99) zone, 6 - 8 as yellow (ffff00) zone, and 8 - 10 as
    // red (ff3333) zone
    m.addZone(0, 6, "0x99ff99", "0x808080");
    m.addZone(6, 8, "0xffff00", "0x808080");
    m.addZone(8, 10, "0xff3333", "0x808080");

    // Add a title at the bottom of the meter using 10 pts Arial Bold font
    m.addTitle2(cd.Bottom, "OUTPUT POWER LEVEL<*br*>", "Arial Bold", 10);

    // Add a semi-transparent black (80000000) pointer at the specified value
    m.addPointer(value, "0x80000000");

    // Output the chart
    return m.makeSession(GetPageContext(), "chart" & img);
}

chart0URL = createChart(0);
chart1URL = createChart(1);
chart2URL = createChart(2);
chart3URL = createChart(3);
chart4URL = createChart(4);
chart5URL = createChart(5);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Wide Angular Meters
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart0URL#" />
<img src="getchart.cfm?#chart1URL#" />
<img src="getchart.cfm?#chart2URL#" />
<img src="getchart.cfm?#chart3URL#" />
<img src="getchart.cfm?#chart4URL#" />
<img src="getchart.cfm?#chart5URL#" />
</cfoutput>
</body>
</html>
