<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the pyramid chart
data = Array(156, 123, 211, 179);

// The labels for the pyramid chart
labels = Array("Corporate Tax", "Working Capital", "Re-investment", "Dividend");

// The colors for the pyramid layers
colors = Array("0x66aaee", "0xeebb22", "0xcccccc", "0xcc88ff");

// Create a PyramidChart object of size 500 x 400 pixels
c = cd.PyramidChart(500, 400);

// Set the pyramid center at (200, 180), and width x height to 150 x 300 pixels
c.setPyramidSize(200, 180, 150, 300);

// Set the elevation to 15 degrees
c.setViewAngle(15);

// Set the pyramid data and labels
c.setData(data, labels);

// Set the layer colors to the given colors
c.setColors2(cd.DataColor, colors);

// Leave 1% gaps between layers
c.setLayerGap(0.01);

// Add labels at the center of the pyramid layers using Arial Bold font. The labels
// will show the percentage of the layers.
c.setCenterLabel("{percent}%", "Arial Bold");

// Add labels at the right side of the pyramid layers using Arial Bold font. The
// labels will have two lines showing the layer name and value.
c.setRightLabel("{label}<*br*>US$ {value}M", "Arial Bold");

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "", "title='{label}: US$ {value}M ({percent}%)'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    3D Pyramid Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
