<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The XYZ points for the bubble chart
dataX0 = Array(170, 300, 1000, 1700);
dataY0 = Array(16, 69, 16, 75);
dataZ0 = Array(52, 105, 88, 140);

dataX1 = Array(500, 1000, 1300);
dataY1 = Array(40, 58, 85);
dataZ1 = Array(140, 202, 84);

// Create a XYChart object of size 540 x 480 pixels
c = cd.XYChart(540, 480);

// Set the plotarea at (70, 65) and of size 400 x 350 pixels. Turn on both horizontal
// and vertical grid lines with light grey color (0xc0c0c0)
c.setPlotArea(70, 65, 400, 350, -1, -1, cd.Transparent, "0xc0c0c0", -1);

// Add a legend box at (70, 30) (top of the chart) with horizontal layout. Use 12 pts
// Times Bold Italic font. Set the background and border color to Transparent.
c.addLegend(70, 30, False, "Times New Roman Bold Italic", 12).setBackground(
    cd.Transparent);

// Add a title to the chart using 18 pts Times Bold Itatic font.
c.addTitle("Product Comparison Chart", "Times New Roman Bold Italic", 18);

// Add titles to the axes using 12 pts Arial Bold Italic font
c.yAxis().setTitle("Capacity (tons)", "Arial Bold Italic", 12);
c.xAxis().setTitle("Range (miles)", "Arial Bold Italic", 12);

// Set the axes line width to 3 pixels
c.xAxis().setWidth(3);
c.yAxis().setWidth(3);

// Add (dataX0, dataY0) as a scatter layer with red (ff3333) glass spheres, where the
// sphere size is modulated by dataZ0. This creates a bubble effect.
c.addScatterLayer(dataX0, dataY0, "Technology AAA", cd.GlassSphere2Shape, 15,
    "0xff3333").setSymbolScale(dataZ0);

// Add (dataX1, dataY1) as a scatter layer with blue (0000ff) glass spheres, where
// the sphere size is modulated by dataZ1. This creates a bubble effect.
c.addScatterLayer(dataX1, dataY1, "Technology BBB", cd.GlassSphere2Shape, 15,
    "0x0000ff").setSymbolScale(dataZ1);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='[{dataSetName}] Range = {x} miles, Capacity = {value} tons, Length = " &
    "{z} meters'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    3D Bubble Chart (2)
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
