<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the pie chart
data = Array(18, 45, 28);

// The labels for the pie chart
labels = Array("Marble", "Wood", "Granite");

// The icons for the sectors
texture = Array("marble3.png", "wood.png", "rock.png");

// Create a PieChart object of size 400 x 330 pixels, with a metallic green (88EE88)
// background, black border and 1 pixel 3D border effect
c = cd.PieChart(400, 330, cd.metalColor("0x88ee88"), "0x000000", 1);

// Set search path to current directory for loading icon images
c.setSearchPath(GetPageContext());

// Set donut center at (200, 160), and outer/inner radii as 120/60 pixels
c.setDonutSize(200, 160, 120, 60);

// Add a title box using 15 pts Times Bold Italic font and metallic deep green
// (008000) background color
c.addTitle("Material Composition", "Times New Roman Bold Italic", 15).setBackground(
    cd.metalColor("0x008000"));

// Set the pie data and the pie labels
c.setData(data, labels);

// Set the colors of the sectors to the 3 texture patterns
c.setColor(cd.DataColor + 0, c.patternColor2(texture[1]));
c.setColor(cd.DataColor + 1, c.patternColor2(texture[2]));
c.setColor(cd.DataColor + 2, c.patternColor2(texture[3]));

// Draw the pie in 3D with a 3D depth of 30 pixels
c.set3D(30);

// Use 12 pts Arial Bold Italic as the sector label font
c.setLabelStyle("Arial Bold Italic", 12);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "", "title='{label}: {value}kg ({percent}%)'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Texture Donut Chart
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
