<cfscript>

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// Function to create the demo charts
function createChart(img)
{
    // Declare local variables
    var dataX = 0;
    var dataY = 0;
    var dataZ = 0;
    var yIndex = 0;
    var y = 0;
    var xIndex = 0;
    var x = 0;
    var c = 0;

    // The x and y coordinates of the grid
    dataX = Array(-10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10);
    dataY = Array(-10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10);

    // The values at the grid points. In this example, we will compute the values
    // using the formula z = x * sin(y) + y * sin(x).
    dataZ = ArrayNew(1);
    for (yIndex = 0; yIndex LT ArrayLen(dataY); yIndex = yIndex + 1) {
        y = dataY[yIndex + 1];
        for (xIndex = 0; xIndex LT ArrayLen(dataX); xIndex = xIndex + 1) {
            x = dataX[xIndex + 1];
            dataZ[yIndex * ArrayLen(dataX) + xIndex + 1] = x * Sin(y) + y * Sin(x);
        }
    }

    // Create a SurfaceChart object of size 380 x 400 pixels, with white (ffffff)
    // background and grey (888888) border.
    c = cd.SurfaceChart(380, 400, "0xffffff", "0x888888");

    // Demonstrate various shading methods
    if (img EQ "0") {
        c.addTitle("11 x 11 Data Points<*br*>Smooth Shading");
    } else if (img EQ "1") {
        c.addTitle("11 x 11 Points - Spline Fitted to 50 x 50<*br*>Smooth Shading");
        c.setInterpolation(50, 50);
    } else if (img EQ "2") {
        c.addTitle("11 x 11 Data Points<*br*>Rectangular Shading");
        c.setShadingMode(cd.RectangularShading);
    } else {
        c.addTitle("11 x 11 Data Points<*br*>Triangular Shading");
        c.setShadingMode(cd.TriangularShading);
    }

    // Set the center of the plot region at (175, 200), and set width x depth x
    // height to 200 x 200 x 160 pixels
    c.setPlotRegion(175, 200, 200, 200, 160);

    // Set the plot region wall thichness to 5 pixels
    c.setWallThickness(5);

    // Set the elevation and rotation angles to 45 and 60 degrees
    c.setViewAngle(45, 60);

    // Set the perspective level to 35
    c.setPerspective(35);

    // Set the data to use to plot the chart
    c.setData(dataX, dataY, dataZ);

    // Set contour lines to semi-transparent black (c0000000)
    c.setContourColor("0xc0000000");

    // Output the chart
    return c.makeSession(GetPageContext(), "chart" & img, cd.JPG);
}

chart0URL = createChart(0);
chart1URL = createChart(1);
chart2URL = createChart(2);
chart3URL = createChart(3);

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<div style="font-size:18pt; font-family:verdana; font-weight:bold">
    Surface Shading
</div>
<hr style="border:solid 1px #000080" />
<cfoutput>
<div style="font-size:9pt; font-family:verdana; margin-bottom:1.5em">
    <a href='viewsource.cfm?file=#CGI.SCRIPT_NAME#'>View Source Code</a>
</div>
<img src="getchart.cfm?#chart0URL#" />
<img src="getchart.cfm?#chart1URL#" />
<img src="getchart.cfm?#chart2URL#" />
<img src="getchart.cfm?#chart3URL#" />
</cfoutput>
</body>
</html>
